/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/video/transcoder/v1/resources.proto

package com.google.cloud.video.transcoder.v1;

/**
 *
 *
 * <pre>
 * Video stream resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.video.transcoder.v1.VideoStream}
 */
public final class VideoStream extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.VideoStream)
    VideoStreamOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VideoStream.newBuilder() to construct.
  private VideoStream(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VideoStream() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VideoStream();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_VideoStream_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_VideoStream_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.video.transcoder.v1.VideoStream.class,
            com.google.cloud.video.transcoder.v1.VideoStream.Builder.class);
  }

  public interface H264CodecSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The width of the video in pixels. Must be an even integer.
     * When not specified, the width is adjusted to match the specified height
     * and input aspect ratio. If both are omitted, the input width is used.
     * </pre>
     *
     * <code>int32 width_pixels = 1;</code>
     *
     * @return The widthPixels.
     */
    int getWidthPixels();

    /**
     *
     *
     * <pre>
     * The height of the video in pixels. Must be an even integer.
     * When not specified, the height is adjusted to match the specified width
     * and input aspect ratio. If both are omitted, the input height is used.
     * </pre>
     *
     * <code>int32 height_pixels = 2;</code>
     *
     * @return The heightPixels.
     */
    int getHeightPixels();

    /**
     *
     *
     * <pre>
     * Required. The target video frame rate in frames per second (FPS). Must be less than
     * or equal to 120. Will default to the input frame rate if larger than the
     * input frame rate. The API will generate an output FPS that is divisible
     * by the input FPS, and smaller or equal to the target FPS. See
     * [Calculating frame
     * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
     * more information.
     * </pre>
     *
     * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The frameRate.
     */
    double getFrameRate();

    /**
     *
     *
     * <pre>
     * Required. The video bitrate in bits per second. The minimum value is 1,000.
     * The maximum value is 800,000,000.
     * </pre>
     *
     * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bitrateBps.
     */
    int getBitrateBps();

    /**
     *
     *
     * <pre>
     * Pixel format to use. The default is `yuv420p`.
     * Supported pixel formats:
     * - `yuv420p` pixel format
     * - `yuv422p` pixel format
     * - `yuv444p` pixel format
     * - `yuv420p10` 10-bit HDR pixel format
     * - `yuv422p10` 10-bit HDR pixel format
     * - `yuv444p10` 10-bit HDR pixel format
     * - `yuv420p12` 12-bit HDR pixel format
     * - `yuv422p12` 12-bit HDR pixel format
     * - `yuv444p12` 12-bit HDR pixel format
     * </pre>
     *
     * <code>string pixel_format = 5;</code>
     *
     * @return The pixelFormat.
     */
    java.lang.String getPixelFormat();
    /**
     *
     *
     * <pre>
     * Pixel format to use. The default is `yuv420p`.
     * Supported pixel formats:
     * - `yuv420p` pixel format
     * - `yuv422p` pixel format
     * - `yuv444p` pixel format
     * - `yuv420p10` 10-bit HDR pixel format
     * - `yuv422p10` 10-bit HDR pixel format
     * - `yuv444p10` 10-bit HDR pixel format
     * - `yuv420p12` 12-bit HDR pixel format
     * - `yuv422p12` 12-bit HDR pixel format
     * - `yuv444p12` 12-bit HDR pixel format
     * </pre>
     *
     * <code>string pixel_format = 5;</code>
     *
     * @return The bytes for pixelFormat.
     */
    com.google.protobuf.ByteString getPixelFormatBytes();

    /**
     *
     *
     * <pre>
     * Specify the `rate_control_mode`. The default is `vbr`.
     * Supported rate control modes:
     * - `vbr` - variable bitrate
     * - `crf` - constant rate factor
     * </pre>
     *
     * <code>string rate_control_mode = 6;</code>
     *
     * @return The rateControlMode.
     */
    java.lang.String getRateControlMode();
    /**
     *
     *
     * <pre>
     * Specify the `rate_control_mode`. The default is `vbr`.
     * Supported rate control modes:
     * - `vbr` - variable bitrate
     * - `crf` - constant rate factor
     * </pre>
     *
     * <code>string rate_control_mode = 6;</code>
     *
     * @return The bytes for rateControlMode.
     */
    com.google.protobuf.ByteString getRateControlModeBytes();

    /**
     *
     *
     * <pre>
     * Target CRF level. Must be between 10 and 36, where 10 is the highest
     * quality and 36 is the most efficient compression. The default is 21.
     * </pre>
     *
     * <code>int32 crf_level = 7;</code>
     *
     * @return The crfLevel.
     */
    int getCrfLevel();

    /**
     *
     *
     * <pre>
     * Specifies whether an open Group of Pictures (GOP) structure should be
     * allowed or not. The default is `false`.
     * </pre>
     *
     * <code>bool allow_open_gop = 8;</code>
     *
     * @return The allowOpenGop.
     */
    boolean getAllowOpenGop();

    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified frame count. Must be greater
     * than zero.
     * </pre>
     *
     * <code>int32 gop_frame_count = 9;</code>
     *
     * @return Whether the gopFrameCount field is set.
     */
    boolean hasGopFrameCount();
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified frame count. Must be greater
     * than zero.
     * </pre>
     *
     * <code>int32 gop_frame_count = 9;</code>
     *
     * @return The gopFrameCount.
     */
    int getGopFrameCount();

    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 10;</code>
     *
     * @return Whether the gopDuration field is set.
     */
    boolean hasGopDuration();
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 10;</code>
     *
     * @return The gopDuration.
     */
    com.google.protobuf.Duration getGopDuration();
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 10;</code>
     */
    com.google.protobuf.DurationOrBuilder getGopDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Use two-pass encoding strategy to achieve better video quality.
     * `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
     * </pre>
     *
     * <code>bool enable_two_pass = 11;</code>
     *
     * @return The enableTwoPass.
     */
    boolean getEnableTwoPass();

    /**
     *
     *
     * <pre>
     * Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
     * greater than zero. The default is equal to `VideoStream.bitrate_bps`.
     * </pre>
     *
     * <code>int32 vbv_size_bits = 12;</code>
     *
     * @return The vbvSizeBits.
     */
    int getVbvSizeBits();

    /**
     *
     *
     * <pre>
     * Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
     * Must be greater than zero. The default is equal to 90% of
     * `VideoStream.vbv_size_bits`.
     * </pre>
     *
     * <code>int32 vbv_fullness_bits = 13;</code>
     *
     * @return The vbvFullnessBits.
     */
    int getVbvFullnessBits();

    /**
     *
     *
     * <pre>
     * The entropy coder to use. The default is `cabac`.
     * Supported entropy coders:
     * - `cavlc`
     * - `cabac`
     * </pre>
     *
     * <code>string entropy_coder = 14;</code>
     *
     * @return The entropyCoder.
     */
    java.lang.String getEntropyCoder();
    /**
     *
     *
     * <pre>
     * The entropy coder to use. The default is `cabac`.
     * Supported entropy coders:
     * - `cavlc`
     * - `cabac`
     * </pre>
     *
     * <code>string entropy_coder = 14;</code>
     *
     * @return The bytes for entropyCoder.
     */
    com.google.protobuf.ByteString getEntropyCoderBytes();

    /**
     *
     *
     * <pre>
     * Allow B-pyramid for reference frame selection. This may not be supported
     * on all decoders. The default is `false`.
     * </pre>
     *
     * <code>bool b_pyramid = 15;</code>
     *
     * @return The bPyramid.
     */
    boolean getBPyramid();

    /**
     *
     *
     * <pre>
     * The number of consecutive B-frames. Must be greater than or equal to
     * zero. Must be less than `VideoStream.gop_frame_count` if set. The default
     * is 0.
     * </pre>
     *
     * <code>int32 b_frame_count = 16;</code>
     *
     * @return The bFrameCount.
     */
    int getBFrameCount();

    /**
     *
     *
     * <pre>
     * Specify the intensity of the adaptive quantizer (AQ). Must be between 0
     * and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
     * higher value equals a lower bitrate but smoother image. The default is 0.
     * </pre>
     *
     * <code>double aq_strength = 17;</code>
     *
     * @return The aqStrength.
     */
    double getAqStrength();

    /**
     *
     *
     * <pre>
     * Enforces the specified codec profile. The following profiles are
     * supported:
     * *   `baseline`
     * *   `main`
     * *   `high` (default)
     * The available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H264CodecSettings`
     * message.
     * </pre>
     *
     * <code>string profile = 18;</code>
     *
     * @return The profile.
     */
    java.lang.String getProfile();
    /**
     *
     *
     * <pre>
     * Enforces the specified codec profile. The following profiles are
     * supported:
     * *   `baseline`
     * *   `main`
     * *   `high` (default)
     * The available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H264CodecSettings`
     * message.
     * </pre>
     *
     * <code>string profile = 18;</code>
     *
     * @return The bytes for profile.
     */
    com.google.protobuf.ByteString getProfileBytes();

    /**
     *
     *
     * <pre>
     * Enforces the specified codec tune. The available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H264CodecSettings`
     * message.
     * </pre>
     *
     * <code>string tune = 19;</code>
     *
     * @return The tune.
     */
    java.lang.String getTune();
    /**
     *
     *
     * <pre>
     * Enforces the specified codec tune. The available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H264CodecSettings`
     * message.
     * </pre>
     *
     * <code>string tune = 19;</code>
     *
     * @return The bytes for tune.
     */
    com.google.protobuf.ByteString getTuneBytes();

    /**
     *
     *
     * <pre>
     * Enforces the specified codec preset. The default is `veryfast`. The
     * available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H264CodecSettings`
     * message.
     * </pre>
     *
     * <code>string preset = 20;</code>
     *
     * @return The preset.
     */
    java.lang.String getPreset();
    /**
     *
     *
     * <pre>
     * Enforces the specified codec preset. The default is `veryfast`. The
     * available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H264CodecSettings`
     * message.
     * </pre>
     *
     * <code>string preset = 20;</code>
     *
     * @return The bytes for preset.
     */
    com.google.protobuf.ByteString getPresetBytes();

    public com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.GopModeCase
        getGopModeCase();
  }
  /**
   *
   *
   * <pre>
   * H264 codec settings.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings}
   */
  public static final class H264CodecSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings)
      H264CodecSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use H264CodecSettings.newBuilder() to construct.
    private H264CodecSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private H264CodecSettings() {
      pixelFormat_ = "";
      rateControlMode_ = "";
      entropyCoder_ = "";
      profile_ = "";
      tune_ = "";
      preset_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new H264CodecSettings();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_VideoStream_H264CodecSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_VideoStream_H264CodecSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.class,
              com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.Builder.class);
    }

    private int gopModeCase_ = 0;
    private java.lang.Object gopMode_;

    public enum GopModeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GOP_FRAME_COUNT(9),
      GOP_DURATION(10),
      GOPMODE_NOT_SET(0);
      private final int value;

      private GopModeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static GopModeCase valueOf(int value) {
        return forNumber(value);
      }

      public static GopModeCase forNumber(int value) {
        switch (value) {
          case 9:
            return GOP_FRAME_COUNT;
          case 10:
            return GOP_DURATION;
          case 0:
            return GOPMODE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public GopModeCase getGopModeCase() {
      return GopModeCase.forNumber(gopModeCase_);
    }

    public static final int WIDTH_PIXELS_FIELD_NUMBER = 1;
    private int widthPixels_;
    /**
     *
     *
     * <pre>
     * The width of the video in pixels. Must be an even integer.
     * When not specified, the width is adjusted to match the specified height
     * and input aspect ratio. If both are omitted, the input width is used.
     * </pre>
     *
     * <code>int32 width_pixels = 1;</code>
     *
     * @return The widthPixels.
     */
    @java.lang.Override
    public int getWidthPixels() {
      return widthPixels_;
    }

    public static final int HEIGHT_PIXELS_FIELD_NUMBER = 2;
    private int heightPixels_;
    /**
     *
     *
     * <pre>
     * The height of the video in pixels. Must be an even integer.
     * When not specified, the height is adjusted to match the specified width
     * and input aspect ratio. If both are omitted, the input height is used.
     * </pre>
     *
     * <code>int32 height_pixels = 2;</code>
     *
     * @return The heightPixels.
     */
    @java.lang.Override
    public int getHeightPixels() {
      return heightPixels_;
    }

    public static final int FRAME_RATE_FIELD_NUMBER = 3;
    private double frameRate_;
    /**
     *
     *
     * <pre>
     * Required. The target video frame rate in frames per second (FPS). Must be less than
     * or equal to 120. Will default to the input frame rate if larger than the
     * input frame rate. The API will generate an output FPS that is divisible
     * by the input FPS, and smaller or equal to the target FPS. See
     * [Calculating frame
     * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
     * more information.
     * </pre>
     *
     * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The frameRate.
     */
    @java.lang.Override
    public double getFrameRate() {
      return frameRate_;
    }

    public static final int BITRATE_BPS_FIELD_NUMBER = 4;
    private int bitrateBps_;
    /**
     *
     *
     * <pre>
     * Required. The video bitrate in bits per second. The minimum value is 1,000.
     * The maximum value is 800,000,000.
     * </pre>
     *
     * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bitrateBps.
     */
    @java.lang.Override
    public int getBitrateBps() {
      return bitrateBps_;
    }

    public static final int PIXEL_FORMAT_FIELD_NUMBER = 5;
    private volatile java.lang.Object pixelFormat_;
    /**
     *
     *
     * <pre>
     * Pixel format to use. The default is `yuv420p`.
     * Supported pixel formats:
     * - `yuv420p` pixel format
     * - `yuv422p` pixel format
     * - `yuv444p` pixel format
     * - `yuv420p10` 10-bit HDR pixel format
     * - `yuv422p10` 10-bit HDR pixel format
     * - `yuv444p10` 10-bit HDR pixel format
     * - `yuv420p12` 12-bit HDR pixel format
     * - `yuv422p12` 12-bit HDR pixel format
     * - `yuv444p12` 12-bit HDR pixel format
     * </pre>
     *
     * <code>string pixel_format = 5;</code>
     *
     * @return The pixelFormat.
     */
    @java.lang.Override
    public java.lang.String getPixelFormat() {
      java.lang.Object ref = pixelFormat_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pixelFormat_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Pixel format to use. The default is `yuv420p`.
     * Supported pixel formats:
     * - `yuv420p` pixel format
     * - `yuv422p` pixel format
     * - `yuv444p` pixel format
     * - `yuv420p10` 10-bit HDR pixel format
     * - `yuv422p10` 10-bit HDR pixel format
     * - `yuv444p10` 10-bit HDR pixel format
     * - `yuv420p12` 12-bit HDR pixel format
     * - `yuv422p12` 12-bit HDR pixel format
     * - `yuv444p12` 12-bit HDR pixel format
     * </pre>
     *
     * <code>string pixel_format = 5;</code>
     *
     * @return The bytes for pixelFormat.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPixelFormatBytes() {
      java.lang.Object ref = pixelFormat_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pixelFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RATE_CONTROL_MODE_FIELD_NUMBER = 6;
    private volatile java.lang.Object rateControlMode_;
    /**
     *
     *
     * <pre>
     * Specify the `rate_control_mode`. The default is `vbr`.
     * Supported rate control modes:
     * - `vbr` - variable bitrate
     * - `crf` - constant rate factor
     * </pre>
     *
     * <code>string rate_control_mode = 6;</code>
     *
     * @return The rateControlMode.
     */
    @java.lang.Override
    public java.lang.String getRateControlMode() {
      java.lang.Object ref = rateControlMode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rateControlMode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specify the `rate_control_mode`. The default is `vbr`.
     * Supported rate control modes:
     * - `vbr` - variable bitrate
     * - `crf` - constant rate factor
     * </pre>
     *
     * <code>string rate_control_mode = 6;</code>
     *
     * @return The bytes for rateControlMode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRateControlModeBytes() {
      java.lang.Object ref = rateControlMode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rateControlMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CRF_LEVEL_FIELD_NUMBER = 7;
    private int crfLevel_;
    /**
     *
     *
     * <pre>
     * Target CRF level. Must be between 10 and 36, where 10 is the highest
     * quality and 36 is the most efficient compression. The default is 21.
     * </pre>
     *
     * <code>int32 crf_level = 7;</code>
     *
     * @return The crfLevel.
     */
    @java.lang.Override
    public int getCrfLevel() {
      return crfLevel_;
    }

    public static final int ALLOW_OPEN_GOP_FIELD_NUMBER = 8;
    private boolean allowOpenGop_;
    /**
     *
     *
     * <pre>
     * Specifies whether an open Group of Pictures (GOP) structure should be
     * allowed or not. The default is `false`.
     * </pre>
     *
     * <code>bool allow_open_gop = 8;</code>
     *
     * @return The allowOpenGop.
     */
    @java.lang.Override
    public boolean getAllowOpenGop() {
      return allowOpenGop_;
    }

    public static final int GOP_FRAME_COUNT_FIELD_NUMBER = 9;
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified frame count. Must be greater
     * than zero.
     * </pre>
     *
     * <code>int32 gop_frame_count = 9;</code>
     *
     * @return Whether the gopFrameCount field is set.
     */
    @java.lang.Override
    public boolean hasGopFrameCount() {
      return gopModeCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified frame count. Must be greater
     * than zero.
     * </pre>
     *
     * <code>int32 gop_frame_count = 9;</code>
     *
     * @return The gopFrameCount.
     */
    @java.lang.Override
    public int getGopFrameCount() {
      if (gopModeCase_ == 9) {
        return (java.lang.Integer) gopMode_;
      }
      return 0;
    }

    public static final int GOP_DURATION_FIELD_NUMBER = 10;
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 10;</code>
     *
     * @return Whether the gopDuration field is set.
     */
    @java.lang.Override
    public boolean hasGopDuration() {
      return gopModeCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 10;</code>
     *
     * @return The gopDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getGopDuration() {
      if (gopModeCase_ == 10) {
        return (com.google.protobuf.Duration) gopMode_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 10;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getGopDurationOrBuilder() {
      if (gopModeCase_ == 10) {
        return (com.google.protobuf.Duration) gopMode_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }

    public static final int ENABLE_TWO_PASS_FIELD_NUMBER = 11;
    private boolean enableTwoPass_;
    /**
     *
     *
     * <pre>
     * Use two-pass encoding strategy to achieve better video quality.
     * `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
     * </pre>
     *
     * <code>bool enable_two_pass = 11;</code>
     *
     * @return The enableTwoPass.
     */
    @java.lang.Override
    public boolean getEnableTwoPass() {
      return enableTwoPass_;
    }

    public static final int VBV_SIZE_BITS_FIELD_NUMBER = 12;
    private int vbvSizeBits_;
    /**
     *
     *
     * <pre>
     * Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
     * greater than zero. The default is equal to `VideoStream.bitrate_bps`.
     * </pre>
     *
     * <code>int32 vbv_size_bits = 12;</code>
     *
     * @return The vbvSizeBits.
     */
    @java.lang.Override
    public int getVbvSizeBits() {
      return vbvSizeBits_;
    }

    public static final int VBV_FULLNESS_BITS_FIELD_NUMBER = 13;
    private int vbvFullnessBits_;
    /**
     *
     *
     * <pre>
     * Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
     * Must be greater than zero. The default is equal to 90% of
     * `VideoStream.vbv_size_bits`.
     * </pre>
     *
     * <code>int32 vbv_fullness_bits = 13;</code>
     *
     * @return The vbvFullnessBits.
     */
    @java.lang.Override
    public int getVbvFullnessBits() {
      return vbvFullnessBits_;
    }

    public static final int ENTROPY_CODER_FIELD_NUMBER = 14;
    private volatile java.lang.Object entropyCoder_;
    /**
     *
     *
     * <pre>
     * The entropy coder to use. The default is `cabac`.
     * Supported entropy coders:
     * - `cavlc`
     * - `cabac`
     * </pre>
     *
     * <code>string entropy_coder = 14;</code>
     *
     * @return The entropyCoder.
     */
    @java.lang.Override
    public java.lang.String getEntropyCoder() {
      java.lang.Object ref = entropyCoder_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        entropyCoder_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The entropy coder to use. The default is `cabac`.
     * Supported entropy coders:
     * - `cavlc`
     * - `cabac`
     * </pre>
     *
     * <code>string entropy_coder = 14;</code>
     *
     * @return The bytes for entropyCoder.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEntropyCoderBytes() {
      java.lang.Object ref = entropyCoder_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        entropyCoder_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int B_PYRAMID_FIELD_NUMBER = 15;
    private boolean bPyramid_;
    /**
     *
     *
     * <pre>
     * Allow B-pyramid for reference frame selection. This may not be supported
     * on all decoders. The default is `false`.
     * </pre>
     *
     * <code>bool b_pyramid = 15;</code>
     *
     * @return The bPyramid.
     */
    @java.lang.Override
    public boolean getBPyramid() {
      return bPyramid_;
    }

    public static final int B_FRAME_COUNT_FIELD_NUMBER = 16;
    private int bFrameCount_;
    /**
     *
     *
     * <pre>
     * The number of consecutive B-frames. Must be greater than or equal to
     * zero. Must be less than `VideoStream.gop_frame_count` if set. The default
     * is 0.
     * </pre>
     *
     * <code>int32 b_frame_count = 16;</code>
     *
     * @return The bFrameCount.
     */
    @java.lang.Override
    public int getBFrameCount() {
      return bFrameCount_;
    }

    public static final int AQ_STRENGTH_FIELD_NUMBER = 17;
    private double aqStrength_;
    /**
     *
     *
     * <pre>
     * Specify the intensity of the adaptive quantizer (AQ). Must be between 0
     * and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
     * higher value equals a lower bitrate but smoother image. The default is 0.
     * </pre>
     *
     * <code>double aq_strength = 17;</code>
     *
     * @return The aqStrength.
     */
    @java.lang.Override
    public double getAqStrength() {
      return aqStrength_;
    }

    public static final int PROFILE_FIELD_NUMBER = 18;
    private volatile java.lang.Object profile_;
    /**
     *
     *
     * <pre>
     * Enforces the specified codec profile. The following profiles are
     * supported:
     * *   `baseline`
     * *   `main`
     * *   `high` (default)
     * The available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H264CodecSettings`
     * message.
     * </pre>
     *
     * <code>string profile = 18;</code>
     *
     * @return The profile.
     */
    @java.lang.Override
    public java.lang.String getProfile() {
      java.lang.Object ref = profile_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        profile_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Enforces the specified codec profile. The following profiles are
     * supported:
     * *   `baseline`
     * *   `main`
     * *   `high` (default)
     * The available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H264CodecSettings`
     * message.
     * </pre>
     *
     * <code>string profile = 18;</code>
     *
     * @return The bytes for profile.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProfileBytes() {
      java.lang.Object ref = profile_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        profile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TUNE_FIELD_NUMBER = 19;
    private volatile java.lang.Object tune_;
    /**
     *
     *
     * <pre>
     * Enforces the specified codec tune. The available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H264CodecSettings`
     * message.
     * </pre>
     *
     * <code>string tune = 19;</code>
     *
     * @return The tune.
     */
    @java.lang.Override
    public java.lang.String getTune() {
      java.lang.Object ref = tune_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tune_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Enforces the specified codec tune. The available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H264CodecSettings`
     * message.
     * </pre>
     *
     * <code>string tune = 19;</code>
     *
     * @return The bytes for tune.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTuneBytes() {
      java.lang.Object ref = tune_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tune_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PRESET_FIELD_NUMBER = 20;
    private volatile java.lang.Object preset_;
    /**
     *
     *
     * <pre>
     * Enforces the specified codec preset. The default is `veryfast`. The
     * available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H264CodecSettings`
     * message.
     * </pre>
     *
     * <code>string preset = 20;</code>
     *
     * @return The preset.
     */
    @java.lang.Override
    public java.lang.String getPreset() {
      java.lang.Object ref = preset_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        preset_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Enforces the specified codec preset. The default is `veryfast`. The
     * available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H264CodecSettings`
     * message.
     * </pre>
     *
     * <code>string preset = 20;</code>
     *
     * @return The bytes for preset.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPresetBytes() {
      java.lang.Object ref = preset_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        preset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (widthPixels_ != 0) {
        output.writeInt32(1, widthPixels_);
      }
      if (heightPixels_ != 0) {
        output.writeInt32(2, heightPixels_);
      }
      if (java.lang.Double.doubleToRawLongBits(frameRate_) != 0) {
        output.writeDouble(3, frameRate_);
      }
      if (bitrateBps_ != 0) {
        output.writeInt32(4, bitrateBps_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pixelFormat_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, pixelFormat_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rateControlMode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, rateControlMode_);
      }
      if (crfLevel_ != 0) {
        output.writeInt32(7, crfLevel_);
      }
      if (allowOpenGop_ != false) {
        output.writeBool(8, allowOpenGop_);
      }
      if (gopModeCase_ == 9) {
        output.writeInt32(9, (int) ((java.lang.Integer) gopMode_));
      }
      if (gopModeCase_ == 10) {
        output.writeMessage(10, (com.google.protobuf.Duration) gopMode_);
      }
      if (enableTwoPass_ != false) {
        output.writeBool(11, enableTwoPass_);
      }
      if (vbvSizeBits_ != 0) {
        output.writeInt32(12, vbvSizeBits_);
      }
      if (vbvFullnessBits_ != 0) {
        output.writeInt32(13, vbvFullnessBits_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entropyCoder_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 14, entropyCoder_);
      }
      if (bPyramid_ != false) {
        output.writeBool(15, bPyramid_);
      }
      if (bFrameCount_ != 0) {
        output.writeInt32(16, bFrameCount_);
      }
      if (java.lang.Double.doubleToRawLongBits(aqStrength_) != 0) {
        output.writeDouble(17, aqStrength_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(profile_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 18, profile_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tune_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 19, tune_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preset_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 20, preset_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (widthPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, widthPixels_);
      }
      if (heightPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, heightPixels_);
      }
      if (java.lang.Double.doubleToRawLongBits(frameRate_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, frameRate_);
      }
      if (bitrateBps_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, bitrateBps_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pixelFormat_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, pixelFormat_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rateControlMode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, rateControlMode_);
      }
      if (crfLevel_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, crfLevel_);
      }
      if (allowOpenGop_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, allowOpenGop_);
      }
      if (gopModeCase_ == 9) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                9, (int) ((java.lang.Integer) gopMode_));
      }
      if (gopModeCase_ == 10) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                10, (com.google.protobuf.Duration) gopMode_);
      }
      if (enableTwoPass_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, enableTwoPass_);
      }
      if (vbvSizeBits_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(12, vbvSizeBits_);
      }
      if (vbvFullnessBits_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(13, vbvFullnessBits_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entropyCoder_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, entropyCoder_);
      }
      if (bPyramid_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, bPyramid_);
      }
      if (bFrameCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(16, bFrameCount_);
      }
      if (java.lang.Double.doubleToRawLongBits(aqStrength_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(17, aqStrength_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(profile_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, profile_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tune_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, tune_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preset_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, preset_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings other =
          (com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings) obj;

      if (getWidthPixels() != other.getWidthPixels()) return false;
      if (getHeightPixels() != other.getHeightPixels()) return false;
      if (java.lang.Double.doubleToLongBits(getFrameRate())
          != java.lang.Double.doubleToLongBits(other.getFrameRate())) return false;
      if (getBitrateBps() != other.getBitrateBps()) return false;
      if (!getPixelFormat().equals(other.getPixelFormat())) return false;
      if (!getRateControlMode().equals(other.getRateControlMode())) return false;
      if (getCrfLevel() != other.getCrfLevel()) return false;
      if (getAllowOpenGop() != other.getAllowOpenGop()) return false;
      if (getEnableTwoPass() != other.getEnableTwoPass()) return false;
      if (getVbvSizeBits() != other.getVbvSizeBits()) return false;
      if (getVbvFullnessBits() != other.getVbvFullnessBits()) return false;
      if (!getEntropyCoder().equals(other.getEntropyCoder())) return false;
      if (getBPyramid() != other.getBPyramid()) return false;
      if (getBFrameCount() != other.getBFrameCount()) return false;
      if (java.lang.Double.doubleToLongBits(getAqStrength())
          != java.lang.Double.doubleToLongBits(other.getAqStrength())) return false;
      if (!getProfile().equals(other.getProfile())) return false;
      if (!getTune().equals(other.getTune())) return false;
      if (!getPreset().equals(other.getPreset())) return false;
      if (!getGopModeCase().equals(other.getGopModeCase())) return false;
      switch (gopModeCase_) {
        case 9:
          if (getGopFrameCount() != other.getGopFrameCount()) return false;
          break;
        case 10:
          if (!getGopDuration().equals(other.getGopDuration())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + WIDTH_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getWidthPixels();
      hash = (37 * hash) + HEIGHT_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getHeightPixels();
      hash = (37 * hash) + FRAME_RATE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getFrameRate()));
      hash = (37 * hash) + BITRATE_BPS_FIELD_NUMBER;
      hash = (53 * hash) + getBitrateBps();
      hash = (37 * hash) + PIXEL_FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + getPixelFormat().hashCode();
      hash = (37 * hash) + RATE_CONTROL_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getRateControlMode().hashCode();
      hash = (37 * hash) + CRF_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getCrfLevel();
      hash = (37 * hash) + ALLOW_OPEN_GOP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowOpenGop());
      hash = (37 * hash) + ENABLE_TWO_PASS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableTwoPass());
      hash = (37 * hash) + VBV_SIZE_BITS_FIELD_NUMBER;
      hash = (53 * hash) + getVbvSizeBits();
      hash = (37 * hash) + VBV_FULLNESS_BITS_FIELD_NUMBER;
      hash = (53 * hash) + getVbvFullnessBits();
      hash = (37 * hash) + ENTROPY_CODER_FIELD_NUMBER;
      hash = (53 * hash) + getEntropyCoder().hashCode();
      hash = (37 * hash) + B_PYRAMID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBPyramid());
      hash = (37 * hash) + B_FRAME_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getBFrameCount();
      hash = (37 * hash) + AQ_STRENGTH_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getAqStrength()));
      hash = (37 * hash) + PROFILE_FIELD_NUMBER;
      hash = (53 * hash) + getProfile().hashCode();
      hash = (37 * hash) + TUNE_FIELD_NUMBER;
      hash = (53 * hash) + getTune().hashCode();
      hash = (37 * hash) + PRESET_FIELD_NUMBER;
      hash = (53 * hash) + getPreset().hashCode();
      switch (gopModeCase_) {
        case 9:
          hash = (37 * hash) + GOP_FRAME_COUNT_FIELD_NUMBER;
          hash = (53 * hash) + getGopFrameCount();
          break;
        case 10:
          hash = (37 * hash) + GOP_DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getGopDuration().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * H264 codec settings.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings)
        com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_VideoStream_H264CodecSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_VideoStream_H264CodecSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.class,
                com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.Builder.class);
      }

      // Construct using
      // com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        widthPixels_ = 0;

        heightPixels_ = 0;

        frameRate_ = 0D;

        bitrateBps_ = 0;

        pixelFormat_ = "";

        rateControlMode_ = "";

        crfLevel_ = 0;

        allowOpenGop_ = false;

        if (gopDurationBuilder_ != null) {
          gopDurationBuilder_.clear();
        }
        enableTwoPass_ = false;

        vbvSizeBits_ = 0;

        vbvFullnessBits_ = 0;

        entropyCoder_ = "";

        bPyramid_ = false;

        bFrameCount_ = 0;

        aqStrength_ = 0D;

        profile_ = "";

        tune_ = "";

        preset_ = "";

        gopModeCase_ = 0;
        gopMode_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_VideoStream_H264CodecSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings build() {
        com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings buildPartial() {
        com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings result =
            new com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings(this);
        result.widthPixels_ = widthPixels_;
        result.heightPixels_ = heightPixels_;
        result.frameRate_ = frameRate_;
        result.bitrateBps_ = bitrateBps_;
        result.pixelFormat_ = pixelFormat_;
        result.rateControlMode_ = rateControlMode_;
        result.crfLevel_ = crfLevel_;
        result.allowOpenGop_ = allowOpenGop_;
        if (gopModeCase_ == 9) {
          result.gopMode_ = gopMode_;
        }
        if (gopModeCase_ == 10) {
          if (gopDurationBuilder_ == null) {
            result.gopMode_ = gopMode_;
          } else {
            result.gopMode_ = gopDurationBuilder_.build();
          }
        }
        result.enableTwoPass_ = enableTwoPass_;
        result.vbvSizeBits_ = vbvSizeBits_;
        result.vbvFullnessBits_ = vbvFullnessBits_;
        result.entropyCoder_ = entropyCoder_;
        result.bPyramid_ = bPyramid_;
        result.bFrameCount_ = bFrameCount_;
        result.aqStrength_ = aqStrength_;
        result.profile_ = profile_;
        result.tune_ = tune_;
        result.preset_ = preset_;
        result.gopModeCase_ = gopModeCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings) {
          return mergeFrom(
              (com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings other) {
        if (other
            == com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
                .getDefaultInstance()) return this;
        if (other.getWidthPixels() != 0) {
          setWidthPixels(other.getWidthPixels());
        }
        if (other.getHeightPixels() != 0) {
          setHeightPixels(other.getHeightPixels());
        }
        if (other.getFrameRate() != 0D) {
          setFrameRate(other.getFrameRate());
        }
        if (other.getBitrateBps() != 0) {
          setBitrateBps(other.getBitrateBps());
        }
        if (!other.getPixelFormat().isEmpty()) {
          pixelFormat_ = other.pixelFormat_;
          onChanged();
        }
        if (!other.getRateControlMode().isEmpty()) {
          rateControlMode_ = other.rateControlMode_;
          onChanged();
        }
        if (other.getCrfLevel() != 0) {
          setCrfLevel(other.getCrfLevel());
        }
        if (other.getAllowOpenGop() != false) {
          setAllowOpenGop(other.getAllowOpenGop());
        }
        if (other.getEnableTwoPass() != false) {
          setEnableTwoPass(other.getEnableTwoPass());
        }
        if (other.getVbvSizeBits() != 0) {
          setVbvSizeBits(other.getVbvSizeBits());
        }
        if (other.getVbvFullnessBits() != 0) {
          setVbvFullnessBits(other.getVbvFullnessBits());
        }
        if (!other.getEntropyCoder().isEmpty()) {
          entropyCoder_ = other.entropyCoder_;
          onChanged();
        }
        if (other.getBPyramid() != false) {
          setBPyramid(other.getBPyramid());
        }
        if (other.getBFrameCount() != 0) {
          setBFrameCount(other.getBFrameCount());
        }
        if (other.getAqStrength() != 0D) {
          setAqStrength(other.getAqStrength());
        }
        if (!other.getProfile().isEmpty()) {
          profile_ = other.profile_;
          onChanged();
        }
        if (!other.getTune().isEmpty()) {
          tune_ = other.tune_;
          onChanged();
        }
        if (!other.getPreset().isEmpty()) {
          preset_ = other.preset_;
          onChanged();
        }
        switch (other.getGopModeCase()) {
          case GOP_FRAME_COUNT:
            {
              setGopFrameCount(other.getGopFrameCount());
              break;
            }
          case GOP_DURATION:
            {
              mergeGopDuration(other.getGopDuration());
              break;
            }
          case GOPMODE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  widthPixels_ = input.readInt32();

                  break;
                } // case 8
              case 16:
                {
                  heightPixels_ = input.readInt32();

                  break;
                } // case 16
              case 25:
                {
                  frameRate_ = input.readDouble();

                  break;
                } // case 25
              case 32:
                {
                  bitrateBps_ = input.readInt32();

                  break;
                } // case 32
              case 42:
                {
                  pixelFormat_ = input.readStringRequireUtf8();

                  break;
                } // case 42
              case 50:
                {
                  rateControlMode_ = input.readStringRequireUtf8();

                  break;
                } // case 50
              case 56:
                {
                  crfLevel_ = input.readInt32();

                  break;
                } // case 56
              case 64:
                {
                  allowOpenGop_ = input.readBool();

                  break;
                } // case 64
              case 72:
                {
                  gopMode_ = input.readInt32();
                  gopModeCase_ = 9;
                  break;
                } // case 72
              case 82:
                {
                  input.readMessage(getGopDurationFieldBuilder().getBuilder(), extensionRegistry);
                  gopModeCase_ = 10;
                  break;
                } // case 82
              case 88:
                {
                  enableTwoPass_ = input.readBool();

                  break;
                } // case 88
              case 96:
                {
                  vbvSizeBits_ = input.readInt32();

                  break;
                } // case 96
              case 104:
                {
                  vbvFullnessBits_ = input.readInt32();

                  break;
                } // case 104
              case 114:
                {
                  entropyCoder_ = input.readStringRequireUtf8();

                  break;
                } // case 114
              case 120:
                {
                  bPyramid_ = input.readBool();

                  break;
                } // case 120
              case 128:
                {
                  bFrameCount_ = input.readInt32();

                  break;
                } // case 128
              case 137:
                {
                  aqStrength_ = input.readDouble();

                  break;
                } // case 137
              case 146:
                {
                  profile_ = input.readStringRequireUtf8();

                  break;
                } // case 146
              case 154:
                {
                  tune_ = input.readStringRequireUtf8();

                  break;
                } // case 154
              case 162:
                {
                  preset_ = input.readStringRequireUtf8();

                  break;
                } // case 162
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int gopModeCase_ = 0;
      private java.lang.Object gopMode_;

      public GopModeCase getGopModeCase() {
        return GopModeCase.forNumber(gopModeCase_);
      }

      public Builder clearGopMode() {
        gopModeCase_ = 0;
        gopMode_ = null;
        onChanged();
        return this;
      }

      private int widthPixels_;
      /**
       *
       *
       * <pre>
       * The width of the video in pixels. Must be an even integer.
       * When not specified, the width is adjusted to match the specified height
       * and input aspect ratio. If both are omitted, the input width is used.
       * </pre>
       *
       * <code>int32 width_pixels = 1;</code>
       *
       * @return The widthPixels.
       */
      @java.lang.Override
      public int getWidthPixels() {
        return widthPixels_;
      }
      /**
       *
       *
       * <pre>
       * The width of the video in pixels. Must be an even integer.
       * When not specified, the width is adjusted to match the specified height
       * and input aspect ratio. If both are omitted, the input width is used.
       * </pre>
       *
       * <code>int32 width_pixels = 1;</code>
       *
       * @param value The widthPixels to set.
       * @return This builder for chaining.
       */
      public Builder setWidthPixels(int value) {

        widthPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The width of the video in pixels. Must be an even integer.
       * When not specified, the width is adjusted to match the specified height
       * and input aspect ratio. If both are omitted, the input width is used.
       * </pre>
       *
       * <code>int32 width_pixels = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWidthPixels() {

        widthPixels_ = 0;
        onChanged();
        return this;
      }

      private int heightPixels_;
      /**
       *
       *
       * <pre>
       * The height of the video in pixels. Must be an even integer.
       * When not specified, the height is adjusted to match the specified width
       * and input aspect ratio. If both are omitted, the input height is used.
       * </pre>
       *
       * <code>int32 height_pixels = 2;</code>
       *
       * @return The heightPixels.
       */
      @java.lang.Override
      public int getHeightPixels() {
        return heightPixels_;
      }
      /**
       *
       *
       * <pre>
       * The height of the video in pixels. Must be an even integer.
       * When not specified, the height is adjusted to match the specified width
       * and input aspect ratio. If both are omitted, the input height is used.
       * </pre>
       *
       * <code>int32 height_pixels = 2;</code>
       *
       * @param value The heightPixels to set.
       * @return This builder for chaining.
       */
      public Builder setHeightPixels(int value) {

        heightPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The height of the video in pixels. Must be an even integer.
       * When not specified, the height is adjusted to match the specified width
       * and input aspect ratio. If both are omitted, the input height is used.
       * </pre>
       *
       * <code>int32 height_pixels = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHeightPixels() {

        heightPixels_ = 0;
        onChanged();
        return this;
      }

      private double frameRate_;
      /**
       *
       *
       * <pre>
       * Required. The target video frame rate in frames per second (FPS). Must be less than
       * or equal to 120. Will default to the input frame rate if larger than the
       * input frame rate. The API will generate an output FPS that is divisible
       * by the input FPS, and smaller or equal to the target FPS. See
       * [Calculating frame
       * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
       * more information.
       * </pre>
       *
       * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The frameRate.
       */
      @java.lang.Override
      public double getFrameRate() {
        return frameRate_;
      }
      /**
       *
       *
       * <pre>
       * Required. The target video frame rate in frames per second (FPS). Must be less than
       * or equal to 120. Will default to the input frame rate if larger than the
       * input frame rate. The API will generate an output FPS that is divisible
       * by the input FPS, and smaller or equal to the target FPS. See
       * [Calculating frame
       * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
       * more information.
       * </pre>
       *
       * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The frameRate to set.
       * @return This builder for chaining.
       */
      public Builder setFrameRate(double value) {

        frameRate_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The target video frame rate in frames per second (FPS). Must be less than
       * or equal to 120. Will default to the input frame rate if larger than the
       * input frame rate. The API will generate an output FPS that is divisible
       * by the input FPS, and smaller or equal to the target FPS. See
       * [Calculating frame
       * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
       * more information.
       * </pre>
       *
       * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFrameRate() {

        frameRate_ = 0D;
        onChanged();
        return this;
      }

      private int bitrateBps_;
      /**
       *
       *
       * <pre>
       * Required. The video bitrate in bits per second. The minimum value is 1,000.
       * The maximum value is 800,000,000.
       * </pre>
       *
       * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bitrateBps.
       */
      @java.lang.Override
      public int getBitrateBps() {
        return bitrateBps_;
      }
      /**
       *
       *
       * <pre>
       * Required. The video bitrate in bits per second. The minimum value is 1,000.
       * The maximum value is 800,000,000.
       * </pre>
       *
       * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bitrateBps to set.
       * @return This builder for chaining.
       */
      public Builder setBitrateBps(int value) {

        bitrateBps_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The video bitrate in bits per second. The minimum value is 1,000.
       * The maximum value is 800,000,000.
       * </pre>
       *
       * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBitrateBps() {

        bitrateBps_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object pixelFormat_ = "";
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @return The pixelFormat.
       */
      public java.lang.String getPixelFormat() {
        java.lang.Object ref = pixelFormat_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pixelFormat_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @return The bytes for pixelFormat.
       */
      public com.google.protobuf.ByteString getPixelFormatBytes() {
        java.lang.Object ref = pixelFormat_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pixelFormat_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @param value The pixelFormat to set.
       * @return This builder for chaining.
       */
      public Builder setPixelFormat(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        pixelFormat_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPixelFormat() {

        pixelFormat_ = getDefaultInstance().getPixelFormat();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @param value The bytes for pixelFormat to set.
       * @return This builder for chaining.
       */
      public Builder setPixelFormatBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        pixelFormat_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object rateControlMode_ = "";
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * - `crf` - constant rate factor
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @return The rateControlMode.
       */
      public java.lang.String getRateControlMode() {
        java.lang.Object ref = rateControlMode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          rateControlMode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * - `crf` - constant rate factor
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @return The bytes for rateControlMode.
       */
      public com.google.protobuf.ByteString getRateControlModeBytes() {
        java.lang.Object ref = rateControlMode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          rateControlMode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * - `crf` - constant rate factor
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @param value The rateControlMode to set.
       * @return This builder for chaining.
       */
      public Builder setRateControlMode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        rateControlMode_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * - `crf` - constant rate factor
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRateControlMode() {

        rateControlMode_ = getDefaultInstance().getRateControlMode();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * - `crf` - constant rate factor
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @param value The bytes for rateControlMode to set.
       * @return This builder for chaining.
       */
      public Builder setRateControlModeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        rateControlMode_ = value;
        onChanged();
        return this;
      }

      private int crfLevel_;
      /**
       *
       *
       * <pre>
       * Target CRF level. Must be between 10 and 36, where 10 is the highest
       * quality and 36 is the most efficient compression. The default is 21.
       * </pre>
       *
       * <code>int32 crf_level = 7;</code>
       *
       * @return The crfLevel.
       */
      @java.lang.Override
      public int getCrfLevel() {
        return crfLevel_;
      }
      /**
       *
       *
       * <pre>
       * Target CRF level. Must be between 10 and 36, where 10 is the highest
       * quality and 36 is the most efficient compression. The default is 21.
       * </pre>
       *
       * <code>int32 crf_level = 7;</code>
       *
       * @param value The crfLevel to set.
       * @return This builder for chaining.
       */
      public Builder setCrfLevel(int value) {

        crfLevel_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Target CRF level. Must be between 10 and 36, where 10 is the highest
       * quality and 36 is the most efficient compression. The default is 21.
       * </pre>
       *
       * <code>int32 crf_level = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCrfLevel() {

        crfLevel_ = 0;
        onChanged();
        return this;
      }

      private boolean allowOpenGop_;
      /**
       *
       *
       * <pre>
       * Specifies whether an open Group of Pictures (GOP) structure should be
       * allowed or not. The default is `false`.
       * </pre>
       *
       * <code>bool allow_open_gop = 8;</code>
       *
       * @return The allowOpenGop.
       */
      @java.lang.Override
      public boolean getAllowOpenGop() {
        return allowOpenGop_;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether an open Group of Pictures (GOP) structure should be
       * allowed or not. The default is `false`.
       * </pre>
       *
       * <code>bool allow_open_gop = 8;</code>
       *
       * @param value The allowOpenGop to set.
       * @return This builder for chaining.
       */
      public Builder setAllowOpenGop(boolean value) {

        allowOpenGop_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether an open Group of Pictures (GOP) structure should be
       * allowed or not. The default is `false`.
       * </pre>
       *
       * <code>bool allow_open_gop = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowOpenGop() {

        allowOpenGop_ = false;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified frame count. Must be greater
       * than zero.
       * </pre>
       *
       * <code>int32 gop_frame_count = 9;</code>
       *
       * @return Whether the gopFrameCount field is set.
       */
      public boolean hasGopFrameCount() {
        return gopModeCase_ == 9;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified frame count. Must be greater
       * than zero.
       * </pre>
       *
       * <code>int32 gop_frame_count = 9;</code>
       *
       * @return The gopFrameCount.
       */
      public int getGopFrameCount() {
        if (gopModeCase_ == 9) {
          return (java.lang.Integer) gopMode_;
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified frame count. Must be greater
       * than zero.
       * </pre>
       *
       * <code>int32 gop_frame_count = 9;</code>
       *
       * @param value The gopFrameCount to set.
       * @return This builder for chaining.
       */
      public Builder setGopFrameCount(int value) {
        gopModeCase_ = 9;
        gopMode_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified frame count. Must be greater
       * than zero.
       * </pre>
       *
       * <code>int32 gop_frame_count = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGopFrameCount() {
        if (gopModeCase_ == 9) {
          gopModeCase_ = 0;
          gopMode_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          gopDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       *
       * @return Whether the gopDuration field is set.
       */
      @java.lang.Override
      public boolean hasGopDuration() {
        return gopModeCase_ == 10;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       *
       * @return The gopDuration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getGopDuration() {
        if (gopDurationBuilder_ == null) {
          if (gopModeCase_ == 10) {
            return (com.google.protobuf.Duration) gopMode_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        } else {
          if (gopModeCase_ == 10) {
            return gopDurationBuilder_.getMessage();
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      public Builder setGopDuration(com.google.protobuf.Duration value) {
        if (gopDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          gopMode_ = value;
          onChanged();
        } else {
          gopDurationBuilder_.setMessage(value);
        }
        gopModeCase_ = 10;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      public Builder setGopDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (gopDurationBuilder_ == null) {
          gopMode_ = builderForValue.build();
          onChanged();
        } else {
          gopDurationBuilder_.setMessage(builderForValue.build());
        }
        gopModeCase_ = 10;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      public Builder mergeGopDuration(com.google.protobuf.Duration value) {
        if (gopDurationBuilder_ == null) {
          if (gopModeCase_ == 10 && gopMode_ != com.google.protobuf.Duration.getDefaultInstance()) {
            gopMode_ =
                com.google.protobuf.Duration.newBuilder((com.google.protobuf.Duration) gopMode_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            gopMode_ = value;
          }
          onChanged();
        } else {
          if (gopModeCase_ == 10) {
            gopDurationBuilder_.mergeFrom(value);
          } else {
            gopDurationBuilder_.setMessage(value);
          }
        }
        gopModeCase_ = 10;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      public Builder clearGopDuration() {
        if (gopDurationBuilder_ == null) {
          if (gopModeCase_ == 10) {
            gopModeCase_ = 0;
            gopMode_ = null;
            onChanged();
          }
        } else {
          if (gopModeCase_ == 10) {
            gopModeCase_ = 0;
            gopMode_ = null;
          }
          gopDurationBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      public com.google.protobuf.Duration.Builder getGopDurationBuilder() {
        return getGopDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getGopDurationOrBuilder() {
        if ((gopModeCase_ == 10) && (gopDurationBuilder_ != null)) {
          return gopDurationBuilder_.getMessageOrBuilder();
        } else {
          if (gopModeCase_ == 10) {
            return (com.google.protobuf.Duration) gopMode_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getGopDurationFieldBuilder() {
        if (gopDurationBuilder_ == null) {
          if (!(gopModeCase_ == 10)) {
            gopMode_ = com.google.protobuf.Duration.getDefaultInstance();
          }
          gopDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  (com.google.protobuf.Duration) gopMode_, getParentForChildren(), isClean());
          gopMode_ = null;
        }
        gopModeCase_ = 10;
        onChanged();
        ;
        return gopDurationBuilder_;
      }

      private boolean enableTwoPass_;
      /**
       *
       *
       * <pre>
       * Use two-pass encoding strategy to achieve better video quality.
       * `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
       * </pre>
       *
       * <code>bool enable_two_pass = 11;</code>
       *
       * @return The enableTwoPass.
       */
      @java.lang.Override
      public boolean getEnableTwoPass() {
        return enableTwoPass_;
      }
      /**
       *
       *
       * <pre>
       * Use two-pass encoding strategy to achieve better video quality.
       * `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
       * </pre>
       *
       * <code>bool enable_two_pass = 11;</code>
       *
       * @param value The enableTwoPass to set.
       * @return This builder for chaining.
       */
      public Builder setEnableTwoPass(boolean value) {

        enableTwoPass_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use two-pass encoding strategy to achieve better video quality.
       * `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
       * </pre>
       *
       * <code>bool enable_two_pass = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableTwoPass() {

        enableTwoPass_ = false;
        onChanged();
        return this;
      }

      private int vbvSizeBits_;
      /**
       *
       *
       * <pre>
       * Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
       * greater than zero. The default is equal to `VideoStream.bitrate_bps`.
       * </pre>
       *
       * <code>int32 vbv_size_bits = 12;</code>
       *
       * @return The vbvSizeBits.
       */
      @java.lang.Override
      public int getVbvSizeBits() {
        return vbvSizeBits_;
      }
      /**
       *
       *
       * <pre>
       * Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
       * greater than zero. The default is equal to `VideoStream.bitrate_bps`.
       * </pre>
       *
       * <code>int32 vbv_size_bits = 12;</code>
       *
       * @param value The vbvSizeBits to set.
       * @return This builder for chaining.
       */
      public Builder setVbvSizeBits(int value) {

        vbvSizeBits_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
       * greater than zero. The default is equal to `VideoStream.bitrate_bps`.
       * </pre>
       *
       * <code>int32 vbv_size_bits = 12;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVbvSizeBits() {

        vbvSizeBits_ = 0;
        onChanged();
        return this;
      }

      private int vbvFullnessBits_;
      /**
       *
       *
       * <pre>
       * Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
       * Must be greater than zero. The default is equal to 90% of
       * `VideoStream.vbv_size_bits`.
       * </pre>
       *
       * <code>int32 vbv_fullness_bits = 13;</code>
       *
       * @return The vbvFullnessBits.
       */
      @java.lang.Override
      public int getVbvFullnessBits() {
        return vbvFullnessBits_;
      }
      /**
       *
       *
       * <pre>
       * Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
       * Must be greater than zero. The default is equal to 90% of
       * `VideoStream.vbv_size_bits`.
       * </pre>
       *
       * <code>int32 vbv_fullness_bits = 13;</code>
       *
       * @param value The vbvFullnessBits to set.
       * @return This builder for chaining.
       */
      public Builder setVbvFullnessBits(int value) {

        vbvFullnessBits_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
       * Must be greater than zero. The default is equal to 90% of
       * `VideoStream.vbv_size_bits`.
       * </pre>
       *
       * <code>int32 vbv_fullness_bits = 13;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVbvFullnessBits() {

        vbvFullnessBits_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object entropyCoder_ = "";
      /**
       *
       *
       * <pre>
       * The entropy coder to use. The default is `cabac`.
       * Supported entropy coders:
       * - `cavlc`
       * - `cabac`
       * </pre>
       *
       * <code>string entropy_coder = 14;</code>
       *
       * @return The entropyCoder.
       */
      public java.lang.String getEntropyCoder() {
        java.lang.Object ref = entropyCoder_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          entropyCoder_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The entropy coder to use. The default is `cabac`.
       * Supported entropy coders:
       * - `cavlc`
       * - `cabac`
       * </pre>
       *
       * <code>string entropy_coder = 14;</code>
       *
       * @return The bytes for entropyCoder.
       */
      public com.google.protobuf.ByteString getEntropyCoderBytes() {
        java.lang.Object ref = entropyCoder_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          entropyCoder_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The entropy coder to use. The default is `cabac`.
       * Supported entropy coders:
       * - `cavlc`
       * - `cabac`
       * </pre>
       *
       * <code>string entropy_coder = 14;</code>
       *
       * @param value The entropyCoder to set.
       * @return This builder for chaining.
       */
      public Builder setEntropyCoder(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        entropyCoder_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The entropy coder to use. The default is `cabac`.
       * Supported entropy coders:
       * - `cavlc`
       * - `cabac`
       * </pre>
       *
       * <code>string entropy_coder = 14;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEntropyCoder() {

        entropyCoder_ = getDefaultInstance().getEntropyCoder();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The entropy coder to use. The default is `cabac`.
       * Supported entropy coders:
       * - `cavlc`
       * - `cabac`
       * </pre>
       *
       * <code>string entropy_coder = 14;</code>
       *
       * @param value The bytes for entropyCoder to set.
       * @return This builder for chaining.
       */
      public Builder setEntropyCoderBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        entropyCoder_ = value;
        onChanged();
        return this;
      }

      private boolean bPyramid_;
      /**
       *
       *
       * <pre>
       * Allow B-pyramid for reference frame selection. This may not be supported
       * on all decoders. The default is `false`.
       * </pre>
       *
       * <code>bool b_pyramid = 15;</code>
       *
       * @return The bPyramid.
       */
      @java.lang.Override
      public boolean getBPyramid() {
        return bPyramid_;
      }
      /**
       *
       *
       * <pre>
       * Allow B-pyramid for reference frame selection. This may not be supported
       * on all decoders. The default is `false`.
       * </pre>
       *
       * <code>bool b_pyramid = 15;</code>
       *
       * @param value The bPyramid to set.
       * @return This builder for chaining.
       */
      public Builder setBPyramid(boolean value) {

        bPyramid_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Allow B-pyramid for reference frame selection. This may not be supported
       * on all decoders. The default is `false`.
       * </pre>
       *
       * <code>bool b_pyramid = 15;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBPyramid() {

        bPyramid_ = false;
        onChanged();
        return this;
      }

      private int bFrameCount_;
      /**
       *
       *
       * <pre>
       * The number of consecutive B-frames. Must be greater than or equal to
       * zero. Must be less than `VideoStream.gop_frame_count` if set. The default
       * is 0.
       * </pre>
       *
       * <code>int32 b_frame_count = 16;</code>
       *
       * @return The bFrameCount.
       */
      @java.lang.Override
      public int getBFrameCount() {
        return bFrameCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of consecutive B-frames. Must be greater than or equal to
       * zero. Must be less than `VideoStream.gop_frame_count` if set. The default
       * is 0.
       * </pre>
       *
       * <code>int32 b_frame_count = 16;</code>
       *
       * @param value The bFrameCount to set.
       * @return This builder for chaining.
       */
      public Builder setBFrameCount(int value) {

        bFrameCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of consecutive B-frames. Must be greater than or equal to
       * zero. Must be less than `VideoStream.gop_frame_count` if set. The default
       * is 0.
       * </pre>
       *
       * <code>int32 b_frame_count = 16;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBFrameCount() {

        bFrameCount_ = 0;
        onChanged();
        return this;
      }

      private double aqStrength_;
      /**
       *
       *
       * <pre>
       * Specify the intensity of the adaptive quantizer (AQ). Must be between 0
       * and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
       * higher value equals a lower bitrate but smoother image. The default is 0.
       * </pre>
       *
       * <code>double aq_strength = 17;</code>
       *
       * @return The aqStrength.
       */
      @java.lang.Override
      public double getAqStrength() {
        return aqStrength_;
      }
      /**
       *
       *
       * <pre>
       * Specify the intensity of the adaptive quantizer (AQ). Must be between 0
       * and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
       * higher value equals a lower bitrate but smoother image. The default is 0.
       * </pre>
       *
       * <code>double aq_strength = 17;</code>
       *
       * @param value The aqStrength to set.
       * @return This builder for chaining.
       */
      public Builder setAqStrength(double value) {

        aqStrength_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify the intensity of the adaptive quantizer (AQ). Must be between 0
       * and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
       * higher value equals a lower bitrate but smoother image. The default is 0.
       * </pre>
       *
       * <code>double aq_strength = 17;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAqStrength() {

        aqStrength_ = 0D;
        onChanged();
        return this;
      }

      private java.lang.Object profile_ = "";
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   `baseline`
       * *   `main`
       * *   `high` (default)
       * The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 18;</code>
       *
       * @return The profile.
       */
      public java.lang.String getProfile() {
        java.lang.Object ref = profile_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          profile_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   `baseline`
       * *   `main`
       * *   `high` (default)
       * The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 18;</code>
       *
       * @return The bytes for profile.
       */
      public com.google.protobuf.ByteString getProfileBytes() {
        java.lang.Object ref = profile_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          profile_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   `baseline`
       * *   `main`
       * *   `high` (default)
       * The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 18;</code>
       *
       * @param value The profile to set.
       * @return This builder for chaining.
       */
      public Builder setProfile(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        profile_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   `baseline`
       * *   `main`
       * *   `high` (default)
       * The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 18;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProfile() {

        profile_ = getDefaultInstance().getProfile();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   `baseline`
       * *   `main`
       * *   `high` (default)
       * The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 18;</code>
       *
       * @param value The bytes for profile to set.
       * @return This builder for chaining.
       */
      public Builder setProfileBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        profile_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object tune_ = "";
      /**
       *
       *
       * <pre>
       * Enforces the specified codec tune. The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string tune = 19;</code>
       *
       * @return The tune.
       */
      public java.lang.String getTune() {
        java.lang.Object ref = tune_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tune_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec tune. The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string tune = 19;</code>
       *
       * @return The bytes for tune.
       */
      public com.google.protobuf.ByteString getTuneBytes() {
        java.lang.Object ref = tune_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tune_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec tune. The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string tune = 19;</code>
       *
       * @param value The tune to set.
       * @return This builder for chaining.
       */
      public Builder setTune(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        tune_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec tune. The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string tune = 19;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTune() {

        tune_ = getDefaultInstance().getTune();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec tune. The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Tune).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string tune = 19;</code>
       *
       * @param value The bytes for tune to set.
       * @return This builder for chaining.
       */
      public Builder setTuneBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        tune_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object preset_ = "";
      /**
       *
       *
       * <pre>
       * Enforces the specified codec preset. The default is `veryfast`. The
       * available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string preset = 20;</code>
       *
       * @return The preset.
       */
      public java.lang.String getPreset() {
        java.lang.Object ref = preset_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          preset_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec preset. The default is `veryfast`. The
       * available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string preset = 20;</code>
       *
       * @return The bytes for preset.
       */
      public com.google.protobuf.ByteString getPresetBytes() {
        java.lang.Object ref = preset_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          preset_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec preset. The default is `veryfast`. The
       * available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string preset = 20;</code>
       *
       * @param value The preset to set.
       * @return This builder for chaining.
       */
      public Builder setPreset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        preset_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec preset. The default is `veryfast`. The
       * available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string preset = 20;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPreset() {

        preset_ = getDefaultInstance().getPreset();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec preset. The default is `veryfast`. The
       * available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.264#Preset).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H264CodecSettings`
       * message.
       * </pre>
       *
       * <code>string preset = 20;</code>
       *
       * @param value The bytes for preset to set.
       * @return This builder for chaining.
       */
      public Builder setPresetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        preset_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings)
    private static final com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings();
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<H264CodecSettings> PARSER =
        new com.google.protobuf.AbstractParser<H264CodecSettings>() {
          @java.lang.Override
          public H264CodecSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<H264CodecSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<H264CodecSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface H265CodecSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The width of the video in pixels. Must be an even integer.
     * When not specified, the width is adjusted to match the specified height
     * and input aspect ratio. If both are omitted, the input width is used.
     * </pre>
     *
     * <code>int32 width_pixels = 1;</code>
     *
     * @return The widthPixels.
     */
    int getWidthPixels();

    /**
     *
     *
     * <pre>
     * The height of the video in pixels. Must be an even integer.
     * When not specified, the height is adjusted to match the specified width
     * and input aspect ratio. If both are omitted, the input height is used.
     * </pre>
     *
     * <code>int32 height_pixels = 2;</code>
     *
     * @return The heightPixels.
     */
    int getHeightPixels();

    /**
     *
     *
     * <pre>
     * Required. The target video frame rate in frames per second (FPS). Must be less than
     * or equal to 120. Will default to the input frame rate if larger than the
     * input frame rate. The API will generate an output FPS that is divisible
     * by the input FPS, and smaller or equal to the target FPS. See
     * [Calculating frame
     * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
     * more information.
     * </pre>
     *
     * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The frameRate.
     */
    double getFrameRate();

    /**
     *
     *
     * <pre>
     * Required. The video bitrate in bits per second. The minimum value is 1,000.
     * The maximum value is 800,000,000.
     * </pre>
     *
     * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bitrateBps.
     */
    int getBitrateBps();

    /**
     *
     *
     * <pre>
     * Pixel format to use. The default is `yuv420p`.
     * Supported pixel formats:
     * - `yuv420p` pixel format
     * - `yuv422p` pixel format
     * - `yuv444p` pixel format
     * - `yuv420p10` 10-bit HDR pixel format
     * - `yuv422p10` 10-bit HDR pixel format
     * - `yuv444p10` 10-bit HDR pixel format
     * - `yuv420p12` 12-bit HDR pixel format
     * - `yuv422p12` 12-bit HDR pixel format
     * - `yuv444p12` 12-bit HDR pixel format
     * </pre>
     *
     * <code>string pixel_format = 5;</code>
     *
     * @return The pixelFormat.
     */
    java.lang.String getPixelFormat();
    /**
     *
     *
     * <pre>
     * Pixel format to use. The default is `yuv420p`.
     * Supported pixel formats:
     * - `yuv420p` pixel format
     * - `yuv422p` pixel format
     * - `yuv444p` pixel format
     * - `yuv420p10` 10-bit HDR pixel format
     * - `yuv422p10` 10-bit HDR pixel format
     * - `yuv444p10` 10-bit HDR pixel format
     * - `yuv420p12` 12-bit HDR pixel format
     * - `yuv422p12` 12-bit HDR pixel format
     * - `yuv444p12` 12-bit HDR pixel format
     * </pre>
     *
     * <code>string pixel_format = 5;</code>
     *
     * @return The bytes for pixelFormat.
     */
    com.google.protobuf.ByteString getPixelFormatBytes();

    /**
     *
     *
     * <pre>
     * Specify the `rate_control_mode`. The default is `vbr`.
     * Supported rate control modes:
     * - `vbr` - variable bitrate
     * - `crf` - constant rate factor
     * </pre>
     *
     * <code>string rate_control_mode = 6;</code>
     *
     * @return The rateControlMode.
     */
    java.lang.String getRateControlMode();
    /**
     *
     *
     * <pre>
     * Specify the `rate_control_mode`. The default is `vbr`.
     * Supported rate control modes:
     * - `vbr` - variable bitrate
     * - `crf` - constant rate factor
     * </pre>
     *
     * <code>string rate_control_mode = 6;</code>
     *
     * @return The bytes for rateControlMode.
     */
    com.google.protobuf.ByteString getRateControlModeBytes();

    /**
     *
     *
     * <pre>
     * Target CRF level. Must be between 10 and 36, where 10 is the highest
     * quality and 36 is the most efficient compression. The default is 21.
     * </pre>
     *
     * <code>int32 crf_level = 7;</code>
     *
     * @return The crfLevel.
     */
    int getCrfLevel();

    /**
     *
     *
     * <pre>
     * Specifies whether an open Group of Pictures (GOP) structure should be
     * allowed or not. The default is `false`.
     * </pre>
     *
     * <code>bool allow_open_gop = 8;</code>
     *
     * @return The allowOpenGop.
     */
    boolean getAllowOpenGop();

    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified frame count. Must be greater
     * than zero.
     * </pre>
     *
     * <code>int32 gop_frame_count = 9;</code>
     *
     * @return Whether the gopFrameCount field is set.
     */
    boolean hasGopFrameCount();
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified frame count. Must be greater
     * than zero.
     * </pre>
     *
     * <code>int32 gop_frame_count = 9;</code>
     *
     * @return The gopFrameCount.
     */
    int getGopFrameCount();

    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 10;</code>
     *
     * @return Whether the gopDuration field is set.
     */
    boolean hasGopDuration();
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 10;</code>
     *
     * @return The gopDuration.
     */
    com.google.protobuf.Duration getGopDuration();
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 10;</code>
     */
    com.google.protobuf.DurationOrBuilder getGopDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Use two-pass encoding strategy to achieve better video quality.
     * `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
     * </pre>
     *
     * <code>bool enable_two_pass = 11;</code>
     *
     * @return The enableTwoPass.
     */
    boolean getEnableTwoPass();

    /**
     *
     *
     * <pre>
     * Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
     * greater than zero. The default is equal to `VideoStream.bitrate_bps`.
     * </pre>
     *
     * <code>int32 vbv_size_bits = 12;</code>
     *
     * @return The vbvSizeBits.
     */
    int getVbvSizeBits();

    /**
     *
     *
     * <pre>
     * Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
     * Must be greater than zero. The default is equal to 90% of
     * `VideoStream.vbv_size_bits`.
     * </pre>
     *
     * <code>int32 vbv_fullness_bits = 13;</code>
     *
     * @return The vbvFullnessBits.
     */
    int getVbvFullnessBits();

    /**
     *
     *
     * <pre>
     * Allow B-pyramid for reference frame selection. This may not be supported
     * on all decoders. The default is `false`.
     * </pre>
     *
     * <code>bool b_pyramid = 14;</code>
     *
     * @return The bPyramid.
     */
    boolean getBPyramid();

    /**
     *
     *
     * <pre>
     * The number of consecutive B-frames. Must be greater than or equal to
     * zero. Must be less than `VideoStream.gop_frame_count` if set. The default
     * is 0.
     * </pre>
     *
     * <code>int32 b_frame_count = 15;</code>
     *
     * @return The bFrameCount.
     */
    int getBFrameCount();

    /**
     *
     *
     * <pre>
     * Specify the intensity of the adaptive quantizer (AQ). Must be between 0
     * and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
     * higher value equals a lower bitrate but smoother image. The default is 0.
     * </pre>
     *
     * <code>double aq_strength = 16;</code>
     *
     * @return The aqStrength.
     */
    double getAqStrength();

    /**
     *
     *
     * <pre>
     * Enforces the specified codec profile. The following profiles are
     * supported:
     * *   8-bit profiles
     *     *   `main` (default)
     *     *   `main-intra`
     *     *   `mainstillpicture`
     * *   10-bit profiles
     *     *   `main10` (default)
     *     *   `main10-intra`
     *     *   `main422-10`
     *     *   `main422-10-intra`
     *     *   `main444-10`
     *     *   `main444-10-intra`
     * *   12-bit profiles
     *     *   `main12` (default)
     *     *   `main12-intra`
     *     *   `main422-12`
     *     *   `main422-12-intra`
     *     *   `main444-12`
     *     *   `main444-12-intra`
     * The available options are
     * [FFmpeg-compatible](https://x265.readthedocs.io/).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H265CodecSettings`
     * message.
     * </pre>
     *
     * <code>string profile = 17;</code>
     *
     * @return The profile.
     */
    java.lang.String getProfile();
    /**
     *
     *
     * <pre>
     * Enforces the specified codec profile. The following profiles are
     * supported:
     * *   8-bit profiles
     *     *   `main` (default)
     *     *   `main-intra`
     *     *   `mainstillpicture`
     * *   10-bit profiles
     *     *   `main10` (default)
     *     *   `main10-intra`
     *     *   `main422-10`
     *     *   `main422-10-intra`
     *     *   `main444-10`
     *     *   `main444-10-intra`
     * *   12-bit profiles
     *     *   `main12` (default)
     *     *   `main12-intra`
     *     *   `main422-12`
     *     *   `main422-12-intra`
     *     *   `main444-12`
     *     *   `main444-12-intra`
     * The available options are
     * [FFmpeg-compatible](https://x265.readthedocs.io/).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H265CodecSettings`
     * message.
     * </pre>
     *
     * <code>string profile = 17;</code>
     *
     * @return The bytes for profile.
     */
    com.google.protobuf.ByteString getProfileBytes();

    /**
     *
     *
     * <pre>
     * Enforces the specified codec tune. The available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H265CodecSettings`
     * message.
     * </pre>
     *
     * <code>string tune = 18;</code>
     *
     * @return The tune.
     */
    java.lang.String getTune();
    /**
     *
     *
     * <pre>
     * Enforces the specified codec tune. The available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H265CodecSettings`
     * message.
     * </pre>
     *
     * <code>string tune = 18;</code>
     *
     * @return The bytes for tune.
     */
    com.google.protobuf.ByteString getTuneBytes();

    /**
     *
     *
     * <pre>
     * Enforces the specified codec preset. The default is `veryfast`. The
     * available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H265CodecSettings`
     * message.
     * </pre>
     *
     * <code>string preset = 19;</code>
     *
     * @return The preset.
     */
    java.lang.String getPreset();
    /**
     *
     *
     * <pre>
     * Enforces the specified codec preset. The default is `veryfast`. The
     * available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H265CodecSettings`
     * message.
     * </pre>
     *
     * <code>string preset = 19;</code>
     *
     * @return The bytes for preset.
     */
    com.google.protobuf.ByteString getPresetBytes();

    public com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.GopModeCase
        getGopModeCase();
  }
  /**
   *
   *
   * <pre>
   * H265 codec settings.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings}
   */
  public static final class H265CodecSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings)
      H265CodecSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use H265CodecSettings.newBuilder() to construct.
    private H265CodecSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private H265CodecSettings() {
      pixelFormat_ = "";
      rateControlMode_ = "";
      profile_ = "";
      tune_ = "";
      preset_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new H265CodecSettings();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_VideoStream_H265CodecSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_VideoStream_H265CodecSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.class,
              com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.Builder.class);
    }

    private int gopModeCase_ = 0;
    private java.lang.Object gopMode_;

    public enum GopModeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GOP_FRAME_COUNT(9),
      GOP_DURATION(10),
      GOPMODE_NOT_SET(0);
      private final int value;

      private GopModeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static GopModeCase valueOf(int value) {
        return forNumber(value);
      }

      public static GopModeCase forNumber(int value) {
        switch (value) {
          case 9:
            return GOP_FRAME_COUNT;
          case 10:
            return GOP_DURATION;
          case 0:
            return GOPMODE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public GopModeCase getGopModeCase() {
      return GopModeCase.forNumber(gopModeCase_);
    }

    public static final int WIDTH_PIXELS_FIELD_NUMBER = 1;
    private int widthPixels_;
    /**
     *
     *
     * <pre>
     * The width of the video in pixels. Must be an even integer.
     * When not specified, the width is adjusted to match the specified height
     * and input aspect ratio. If both are omitted, the input width is used.
     * </pre>
     *
     * <code>int32 width_pixels = 1;</code>
     *
     * @return The widthPixels.
     */
    @java.lang.Override
    public int getWidthPixels() {
      return widthPixels_;
    }

    public static final int HEIGHT_PIXELS_FIELD_NUMBER = 2;
    private int heightPixels_;
    /**
     *
     *
     * <pre>
     * The height of the video in pixels. Must be an even integer.
     * When not specified, the height is adjusted to match the specified width
     * and input aspect ratio. If both are omitted, the input height is used.
     * </pre>
     *
     * <code>int32 height_pixels = 2;</code>
     *
     * @return The heightPixels.
     */
    @java.lang.Override
    public int getHeightPixels() {
      return heightPixels_;
    }

    public static final int FRAME_RATE_FIELD_NUMBER = 3;
    private double frameRate_;
    /**
     *
     *
     * <pre>
     * Required. The target video frame rate in frames per second (FPS). Must be less than
     * or equal to 120. Will default to the input frame rate if larger than the
     * input frame rate. The API will generate an output FPS that is divisible
     * by the input FPS, and smaller or equal to the target FPS. See
     * [Calculating frame
     * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
     * more information.
     * </pre>
     *
     * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The frameRate.
     */
    @java.lang.Override
    public double getFrameRate() {
      return frameRate_;
    }

    public static final int BITRATE_BPS_FIELD_NUMBER = 4;
    private int bitrateBps_;
    /**
     *
     *
     * <pre>
     * Required. The video bitrate in bits per second. The minimum value is 1,000.
     * The maximum value is 800,000,000.
     * </pre>
     *
     * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bitrateBps.
     */
    @java.lang.Override
    public int getBitrateBps() {
      return bitrateBps_;
    }

    public static final int PIXEL_FORMAT_FIELD_NUMBER = 5;
    private volatile java.lang.Object pixelFormat_;
    /**
     *
     *
     * <pre>
     * Pixel format to use. The default is `yuv420p`.
     * Supported pixel formats:
     * - `yuv420p` pixel format
     * - `yuv422p` pixel format
     * - `yuv444p` pixel format
     * - `yuv420p10` 10-bit HDR pixel format
     * - `yuv422p10` 10-bit HDR pixel format
     * - `yuv444p10` 10-bit HDR pixel format
     * - `yuv420p12` 12-bit HDR pixel format
     * - `yuv422p12` 12-bit HDR pixel format
     * - `yuv444p12` 12-bit HDR pixel format
     * </pre>
     *
     * <code>string pixel_format = 5;</code>
     *
     * @return The pixelFormat.
     */
    @java.lang.Override
    public java.lang.String getPixelFormat() {
      java.lang.Object ref = pixelFormat_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pixelFormat_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Pixel format to use. The default is `yuv420p`.
     * Supported pixel formats:
     * - `yuv420p` pixel format
     * - `yuv422p` pixel format
     * - `yuv444p` pixel format
     * - `yuv420p10` 10-bit HDR pixel format
     * - `yuv422p10` 10-bit HDR pixel format
     * - `yuv444p10` 10-bit HDR pixel format
     * - `yuv420p12` 12-bit HDR pixel format
     * - `yuv422p12` 12-bit HDR pixel format
     * - `yuv444p12` 12-bit HDR pixel format
     * </pre>
     *
     * <code>string pixel_format = 5;</code>
     *
     * @return The bytes for pixelFormat.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPixelFormatBytes() {
      java.lang.Object ref = pixelFormat_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pixelFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RATE_CONTROL_MODE_FIELD_NUMBER = 6;
    private volatile java.lang.Object rateControlMode_;
    /**
     *
     *
     * <pre>
     * Specify the `rate_control_mode`. The default is `vbr`.
     * Supported rate control modes:
     * - `vbr` - variable bitrate
     * - `crf` - constant rate factor
     * </pre>
     *
     * <code>string rate_control_mode = 6;</code>
     *
     * @return The rateControlMode.
     */
    @java.lang.Override
    public java.lang.String getRateControlMode() {
      java.lang.Object ref = rateControlMode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rateControlMode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specify the `rate_control_mode`. The default is `vbr`.
     * Supported rate control modes:
     * - `vbr` - variable bitrate
     * - `crf` - constant rate factor
     * </pre>
     *
     * <code>string rate_control_mode = 6;</code>
     *
     * @return The bytes for rateControlMode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRateControlModeBytes() {
      java.lang.Object ref = rateControlMode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rateControlMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CRF_LEVEL_FIELD_NUMBER = 7;
    private int crfLevel_;
    /**
     *
     *
     * <pre>
     * Target CRF level. Must be between 10 and 36, where 10 is the highest
     * quality and 36 is the most efficient compression. The default is 21.
     * </pre>
     *
     * <code>int32 crf_level = 7;</code>
     *
     * @return The crfLevel.
     */
    @java.lang.Override
    public int getCrfLevel() {
      return crfLevel_;
    }

    public static final int ALLOW_OPEN_GOP_FIELD_NUMBER = 8;
    private boolean allowOpenGop_;
    /**
     *
     *
     * <pre>
     * Specifies whether an open Group of Pictures (GOP) structure should be
     * allowed or not. The default is `false`.
     * </pre>
     *
     * <code>bool allow_open_gop = 8;</code>
     *
     * @return The allowOpenGop.
     */
    @java.lang.Override
    public boolean getAllowOpenGop() {
      return allowOpenGop_;
    }

    public static final int GOP_FRAME_COUNT_FIELD_NUMBER = 9;
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified frame count. Must be greater
     * than zero.
     * </pre>
     *
     * <code>int32 gop_frame_count = 9;</code>
     *
     * @return Whether the gopFrameCount field is set.
     */
    @java.lang.Override
    public boolean hasGopFrameCount() {
      return gopModeCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified frame count. Must be greater
     * than zero.
     * </pre>
     *
     * <code>int32 gop_frame_count = 9;</code>
     *
     * @return The gopFrameCount.
     */
    @java.lang.Override
    public int getGopFrameCount() {
      if (gopModeCase_ == 9) {
        return (java.lang.Integer) gopMode_;
      }
      return 0;
    }

    public static final int GOP_DURATION_FIELD_NUMBER = 10;
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 10;</code>
     *
     * @return Whether the gopDuration field is set.
     */
    @java.lang.Override
    public boolean hasGopDuration() {
      return gopModeCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 10;</code>
     *
     * @return The gopDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getGopDuration() {
      if (gopModeCase_ == 10) {
        return (com.google.protobuf.Duration) gopMode_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 10;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getGopDurationOrBuilder() {
      if (gopModeCase_ == 10) {
        return (com.google.protobuf.Duration) gopMode_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }

    public static final int ENABLE_TWO_PASS_FIELD_NUMBER = 11;
    private boolean enableTwoPass_;
    /**
     *
     *
     * <pre>
     * Use two-pass encoding strategy to achieve better video quality.
     * `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
     * </pre>
     *
     * <code>bool enable_two_pass = 11;</code>
     *
     * @return The enableTwoPass.
     */
    @java.lang.Override
    public boolean getEnableTwoPass() {
      return enableTwoPass_;
    }

    public static final int VBV_SIZE_BITS_FIELD_NUMBER = 12;
    private int vbvSizeBits_;
    /**
     *
     *
     * <pre>
     * Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
     * greater than zero. The default is equal to `VideoStream.bitrate_bps`.
     * </pre>
     *
     * <code>int32 vbv_size_bits = 12;</code>
     *
     * @return The vbvSizeBits.
     */
    @java.lang.Override
    public int getVbvSizeBits() {
      return vbvSizeBits_;
    }

    public static final int VBV_FULLNESS_BITS_FIELD_NUMBER = 13;
    private int vbvFullnessBits_;
    /**
     *
     *
     * <pre>
     * Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
     * Must be greater than zero. The default is equal to 90% of
     * `VideoStream.vbv_size_bits`.
     * </pre>
     *
     * <code>int32 vbv_fullness_bits = 13;</code>
     *
     * @return The vbvFullnessBits.
     */
    @java.lang.Override
    public int getVbvFullnessBits() {
      return vbvFullnessBits_;
    }

    public static final int B_PYRAMID_FIELD_NUMBER = 14;
    private boolean bPyramid_;
    /**
     *
     *
     * <pre>
     * Allow B-pyramid for reference frame selection. This may not be supported
     * on all decoders. The default is `false`.
     * </pre>
     *
     * <code>bool b_pyramid = 14;</code>
     *
     * @return The bPyramid.
     */
    @java.lang.Override
    public boolean getBPyramid() {
      return bPyramid_;
    }

    public static final int B_FRAME_COUNT_FIELD_NUMBER = 15;
    private int bFrameCount_;
    /**
     *
     *
     * <pre>
     * The number of consecutive B-frames. Must be greater than or equal to
     * zero. Must be less than `VideoStream.gop_frame_count` if set. The default
     * is 0.
     * </pre>
     *
     * <code>int32 b_frame_count = 15;</code>
     *
     * @return The bFrameCount.
     */
    @java.lang.Override
    public int getBFrameCount() {
      return bFrameCount_;
    }

    public static final int AQ_STRENGTH_FIELD_NUMBER = 16;
    private double aqStrength_;
    /**
     *
     *
     * <pre>
     * Specify the intensity of the adaptive quantizer (AQ). Must be between 0
     * and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
     * higher value equals a lower bitrate but smoother image. The default is 0.
     * </pre>
     *
     * <code>double aq_strength = 16;</code>
     *
     * @return The aqStrength.
     */
    @java.lang.Override
    public double getAqStrength() {
      return aqStrength_;
    }

    public static final int PROFILE_FIELD_NUMBER = 17;
    private volatile java.lang.Object profile_;
    /**
     *
     *
     * <pre>
     * Enforces the specified codec profile. The following profiles are
     * supported:
     * *   8-bit profiles
     *     *   `main` (default)
     *     *   `main-intra`
     *     *   `mainstillpicture`
     * *   10-bit profiles
     *     *   `main10` (default)
     *     *   `main10-intra`
     *     *   `main422-10`
     *     *   `main422-10-intra`
     *     *   `main444-10`
     *     *   `main444-10-intra`
     * *   12-bit profiles
     *     *   `main12` (default)
     *     *   `main12-intra`
     *     *   `main422-12`
     *     *   `main422-12-intra`
     *     *   `main444-12`
     *     *   `main444-12-intra`
     * The available options are
     * [FFmpeg-compatible](https://x265.readthedocs.io/).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H265CodecSettings`
     * message.
     * </pre>
     *
     * <code>string profile = 17;</code>
     *
     * @return The profile.
     */
    @java.lang.Override
    public java.lang.String getProfile() {
      java.lang.Object ref = profile_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        profile_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Enforces the specified codec profile. The following profiles are
     * supported:
     * *   8-bit profiles
     *     *   `main` (default)
     *     *   `main-intra`
     *     *   `mainstillpicture`
     * *   10-bit profiles
     *     *   `main10` (default)
     *     *   `main10-intra`
     *     *   `main422-10`
     *     *   `main422-10-intra`
     *     *   `main444-10`
     *     *   `main444-10-intra`
     * *   12-bit profiles
     *     *   `main12` (default)
     *     *   `main12-intra`
     *     *   `main422-12`
     *     *   `main422-12-intra`
     *     *   `main444-12`
     *     *   `main444-12-intra`
     * The available options are
     * [FFmpeg-compatible](https://x265.readthedocs.io/).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H265CodecSettings`
     * message.
     * </pre>
     *
     * <code>string profile = 17;</code>
     *
     * @return The bytes for profile.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProfileBytes() {
      java.lang.Object ref = profile_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        profile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TUNE_FIELD_NUMBER = 18;
    private volatile java.lang.Object tune_;
    /**
     *
     *
     * <pre>
     * Enforces the specified codec tune. The available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H265CodecSettings`
     * message.
     * </pre>
     *
     * <code>string tune = 18;</code>
     *
     * @return The tune.
     */
    @java.lang.Override
    public java.lang.String getTune() {
      java.lang.Object ref = tune_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tune_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Enforces the specified codec tune. The available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H265CodecSettings`
     * message.
     * </pre>
     *
     * <code>string tune = 18;</code>
     *
     * @return The bytes for tune.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTuneBytes() {
      java.lang.Object ref = tune_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tune_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PRESET_FIELD_NUMBER = 19;
    private volatile java.lang.Object preset_;
    /**
     *
     *
     * <pre>
     * Enforces the specified codec preset. The default is `veryfast`. The
     * available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H265CodecSettings`
     * message.
     * </pre>
     *
     * <code>string preset = 19;</code>
     *
     * @return The preset.
     */
    @java.lang.Override
    public java.lang.String getPreset() {
      java.lang.Object ref = preset_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        preset_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Enforces the specified codec preset. The default is `veryfast`. The
     * available options are
     * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `H265CodecSettings`
     * message.
     * </pre>
     *
     * <code>string preset = 19;</code>
     *
     * @return The bytes for preset.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPresetBytes() {
      java.lang.Object ref = preset_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        preset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (widthPixels_ != 0) {
        output.writeInt32(1, widthPixels_);
      }
      if (heightPixels_ != 0) {
        output.writeInt32(2, heightPixels_);
      }
      if (java.lang.Double.doubleToRawLongBits(frameRate_) != 0) {
        output.writeDouble(3, frameRate_);
      }
      if (bitrateBps_ != 0) {
        output.writeInt32(4, bitrateBps_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pixelFormat_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, pixelFormat_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rateControlMode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, rateControlMode_);
      }
      if (crfLevel_ != 0) {
        output.writeInt32(7, crfLevel_);
      }
      if (allowOpenGop_ != false) {
        output.writeBool(8, allowOpenGop_);
      }
      if (gopModeCase_ == 9) {
        output.writeInt32(9, (int) ((java.lang.Integer) gopMode_));
      }
      if (gopModeCase_ == 10) {
        output.writeMessage(10, (com.google.protobuf.Duration) gopMode_);
      }
      if (enableTwoPass_ != false) {
        output.writeBool(11, enableTwoPass_);
      }
      if (vbvSizeBits_ != 0) {
        output.writeInt32(12, vbvSizeBits_);
      }
      if (vbvFullnessBits_ != 0) {
        output.writeInt32(13, vbvFullnessBits_);
      }
      if (bPyramid_ != false) {
        output.writeBool(14, bPyramid_);
      }
      if (bFrameCount_ != 0) {
        output.writeInt32(15, bFrameCount_);
      }
      if (java.lang.Double.doubleToRawLongBits(aqStrength_) != 0) {
        output.writeDouble(16, aqStrength_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(profile_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 17, profile_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tune_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 18, tune_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preset_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 19, preset_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (widthPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, widthPixels_);
      }
      if (heightPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, heightPixels_);
      }
      if (java.lang.Double.doubleToRawLongBits(frameRate_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, frameRate_);
      }
      if (bitrateBps_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, bitrateBps_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pixelFormat_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, pixelFormat_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rateControlMode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, rateControlMode_);
      }
      if (crfLevel_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, crfLevel_);
      }
      if (allowOpenGop_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, allowOpenGop_);
      }
      if (gopModeCase_ == 9) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                9, (int) ((java.lang.Integer) gopMode_));
      }
      if (gopModeCase_ == 10) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                10, (com.google.protobuf.Duration) gopMode_);
      }
      if (enableTwoPass_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(11, enableTwoPass_);
      }
      if (vbvSizeBits_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(12, vbvSizeBits_);
      }
      if (vbvFullnessBits_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(13, vbvFullnessBits_);
      }
      if (bPyramid_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, bPyramid_);
      }
      if (bFrameCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(15, bFrameCount_);
      }
      if (java.lang.Double.doubleToRawLongBits(aqStrength_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(16, aqStrength_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(profile_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, profile_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tune_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, tune_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preset_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, preset_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings other =
          (com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings) obj;

      if (getWidthPixels() != other.getWidthPixels()) return false;
      if (getHeightPixels() != other.getHeightPixels()) return false;
      if (java.lang.Double.doubleToLongBits(getFrameRate())
          != java.lang.Double.doubleToLongBits(other.getFrameRate())) return false;
      if (getBitrateBps() != other.getBitrateBps()) return false;
      if (!getPixelFormat().equals(other.getPixelFormat())) return false;
      if (!getRateControlMode().equals(other.getRateControlMode())) return false;
      if (getCrfLevel() != other.getCrfLevel()) return false;
      if (getAllowOpenGop() != other.getAllowOpenGop()) return false;
      if (getEnableTwoPass() != other.getEnableTwoPass()) return false;
      if (getVbvSizeBits() != other.getVbvSizeBits()) return false;
      if (getVbvFullnessBits() != other.getVbvFullnessBits()) return false;
      if (getBPyramid() != other.getBPyramid()) return false;
      if (getBFrameCount() != other.getBFrameCount()) return false;
      if (java.lang.Double.doubleToLongBits(getAqStrength())
          != java.lang.Double.doubleToLongBits(other.getAqStrength())) return false;
      if (!getProfile().equals(other.getProfile())) return false;
      if (!getTune().equals(other.getTune())) return false;
      if (!getPreset().equals(other.getPreset())) return false;
      if (!getGopModeCase().equals(other.getGopModeCase())) return false;
      switch (gopModeCase_) {
        case 9:
          if (getGopFrameCount() != other.getGopFrameCount()) return false;
          break;
        case 10:
          if (!getGopDuration().equals(other.getGopDuration())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + WIDTH_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getWidthPixels();
      hash = (37 * hash) + HEIGHT_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getHeightPixels();
      hash = (37 * hash) + FRAME_RATE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getFrameRate()));
      hash = (37 * hash) + BITRATE_BPS_FIELD_NUMBER;
      hash = (53 * hash) + getBitrateBps();
      hash = (37 * hash) + PIXEL_FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + getPixelFormat().hashCode();
      hash = (37 * hash) + RATE_CONTROL_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getRateControlMode().hashCode();
      hash = (37 * hash) + CRF_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getCrfLevel();
      hash = (37 * hash) + ALLOW_OPEN_GOP_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowOpenGop());
      hash = (37 * hash) + ENABLE_TWO_PASS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableTwoPass());
      hash = (37 * hash) + VBV_SIZE_BITS_FIELD_NUMBER;
      hash = (53 * hash) + getVbvSizeBits();
      hash = (37 * hash) + VBV_FULLNESS_BITS_FIELD_NUMBER;
      hash = (53 * hash) + getVbvFullnessBits();
      hash = (37 * hash) + B_PYRAMID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBPyramid());
      hash = (37 * hash) + B_FRAME_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getBFrameCount();
      hash = (37 * hash) + AQ_STRENGTH_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getAqStrength()));
      hash = (37 * hash) + PROFILE_FIELD_NUMBER;
      hash = (53 * hash) + getProfile().hashCode();
      hash = (37 * hash) + TUNE_FIELD_NUMBER;
      hash = (53 * hash) + getTune().hashCode();
      hash = (37 * hash) + PRESET_FIELD_NUMBER;
      hash = (53 * hash) + getPreset().hashCode();
      switch (gopModeCase_) {
        case 9:
          hash = (37 * hash) + GOP_FRAME_COUNT_FIELD_NUMBER;
          hash = (53 * hash) + getGopFrameCount();
          break;
        case 10:
          hash = (37 * hash) + GOP_DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getGopDuration().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * H265 codec settings.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings)
        com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_VideoStream_H265CodecSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_VideoStream_H265CodecSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.class,
                com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.Builder.class);
      }

      // Construct using
      // com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        widthPixels_ = 0;

        heightPixels_ = 0;

        frameRate_ = 0D;

        bitrateBps_ = 0;

        pixelFormat_ = "";

        rateControlMode_ = "";

        crfLevel_ = 0;

        allowOpenGop_ = false;

        if (gopDurationBuilder_ != null) {
          gopDurationBuilder_.clear();
        }
        enableTwoPass_ = false;

        vbvSizeBits_ = 0;

        vbvFullnessBits_ = 0;

        bPyramid_ = false;

        bFrameCount_ = 0;

        aqStrength_ = 0D;

        profile_ = "";

        tune_ = "";

        preset_ = "";

        gopModeCase_ = 0;
        gopMode_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_VideoStream_H265CodecSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings build() {
        com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings buildPartial() {
        com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings result =
            new com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings(this);
        result.widthPixels_ = widthPixels_;
        result.heightPixels_ = heightPixels_;
        result.frameRate_ = frameRate_;
        result.bitrateBps_ = bitrateBps_;
        result.pixelFormat_ = pixelFormat_;
        result.rateControlMode_ = rateControlMode_;
        result.crfLevel_ = crfLevel_;
        result.allowOpenGop_ = allowOpenGop_;
        if (gopModeCase_ == 9) {
          result.gopMode_ = gopMode_;
        }
        if (gopModeCase_ == 10) {
          if (gopDurationBuilder_ == null) {
            result.gopMode_ = gopMode_;
          } else {
            result.gopMode_ = gopDurationBuilder_.build();
          }
        }
        result.enableTwoPass_ = enableTwoPass_;
        result.vbvSizeBits_ = vbvSizeBits_;
        result.vbvFullnessBits_ = vbvFullnessBits_;
        result.bPyramid_ = bPyramid_;
        result.bFrameCount_ = bFrameCount_;
        result.aqStrength_ = aqStrength_;
        result.profile_ = profile_;
        result.tune_ = tune_;
        result.preset_ = preset_;
        result.gopModeCase_ = gopModeCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings) {
          return mergeFrom(
              (com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings other) {
        if (other
            == com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
                .getDefaultInstance()) return this;
        if (other.getWidthPixels() != 0) {
          setWidthPixels(other.getWidthPixels());
        }
        if (other.getHeightPixels() != 0) {
          setHeightPixels(other.getHeightPixels());
        }
        if (other.getFrameRate() != 0D) {
          setFrameRate(other.getFrameRate());
        }
        if (other.getBitrateBps() != 0) {
          setBitrateBps(other.getBitrateBps());
        }
        if (!other.getPixelFormat().isEmpty()) {
          pixelFormat_ = other.pixelFormat_;
          onChanged();
        }
        if (!other.getRateControlMode().isEmpty()) {
          rateControlMode_ = other.rateControlMode_;
          onChanged();
        }
        if (other.getCrfLevel() != 0) {
          setCrfLevel(other.getCrfLevel());
        }
        if (other.getAllowOpenGop() != false) {
          setAllowOpenGop(other.getAllowOpenGop());
        }
        if (other.getEnableTwoPass() != false) {
          setEnableTwoPass(other.getEnableTwoPass());
        }
        if (other.getVbvSizeBits() != 0) {
          setVbvSizeBits(other.getVbvSizeBits());
        }
        if (other.getVbvFullnessBits() != 0) {
          setVbvFullnessBits(other.getVbvFullnessBits());
        }
        if (other.getBPyramid() != false) {
          setBPyramid(other.getBPyramid());
        }
        if (other.getBFrameCount() != 0) {
          setBFrameCount(other.getBFrameCount());
        }
        if (other.getAqStrength() != 0D) {
          setAqStrength(other.getAqStrength());
        }
        if (!other.getProfile().isEmpty()) {
          profile_ = other.profile_;
          onChanged();
        }
        if (!other.getTune().isEmpty()) {
          tune_ = other.tune_;
          onChanged();
        }
        if (!other.getPreset().isEmpty()) {
          preset_ = other.preset_;
          onChanged();
        }
        switch (other.getGopModeCase()) {
          case GOP_FRAME_COUNT:
            {
              setGopFrameCount(other.getGopFrameCount());
              break;
            }
          case GOP_DURATION:
            {
              mergeGopDuration(other.getGopDuration());
              break;
            }
          case GOPMODE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  widthPixels_ = input.readInt32();

                  break;
                } // case 8
              case 16:
                {
                  heightPixels_ = input.readInt32();

                  break;
                } // case 16
              case 25:
                {
                  frameRate_ = input.readDouble();

                  break;
                } // case 25
              case 32:
                {
                  bitrateBps_ = input.readInt32();

                  break;
                } // case 32
              case 42:
                {
                  pixelFormat_ = input.readStringRequireUtf8();

                  break;
                } // case 42
              case 50:
                {
                  rateControlMode_ = input.readStringRequireUtf8();

                  break;
                } // case 50
              case 56:
                {
                  crfLevel_ = input.readInt32();

                  break;
                } // case 56
              case 64:
                {
                  allowOpenGop_ = input.readBool();

                  break;
                } // case 64
              case 72:
                {
                  gopMode_ = input.readInt32();
                  gopModeCase_ = 9;
                  break;
                } // case 72
              case 82:
                {
                  input.readMessage(getGopDurationFieldBuilder().getBuilder(), extensionRegistry);
                  gopModeCase_ = 10;
                  break;
                } // case 82
              case 88:
                {
                  enableTwoPass_ = input.readBool();

                  break;
                } // case 88
              case 96:
                {
                  vbvSizeBits_ = input.readInt32();

                  break;
                } // case 96
              case 104:
                {
                  vbvFullnessBits_ = input.readInt32();

                  break;
                } // case 104
              case 112:
                {
                  bPyramid_ = input.readBool();

                  break;
                } // case 112
              case 120:
                {
                  bFrameCount_ = input.readInt32();

                  break;
                } // case 120
              case 129:
                {
                  aqStrength_ = input.readDouble();

                  break;
                } // case 129
              case 138:
                {
                  profile_ = input.readStringRequireUtf8();

                  break;
                } // case 138
              case 146:
                {
                  tune_ = input.readStringRequireUtf8();

                  break;
                } // case 146
              case 154:
                {
                  preset_ = input.readStringRequireUtf8();

                  break;
                } // case 154
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int gopModeCase_ = 0;
      private java.lang.Object gopMode_;

      public GopModeCase getGopModeCase() {
        return GopModeCase.forNumber(gopModeCase_);
      }

      public Builder clearGopMode() {
        gopModeCase_ = 0;
        gopMode_ = null;
        onChanged();
        return this;
      }

      private int widthPixels_;
      /**
       *
       *
       * <pre>
       * The width of the video in pixels. Must be an even integer.
       * When not specified, the width is adjusted to match the specified height
       * and input aspect ratio. If both are omitted, the input width is used.
       * </pre>
       *
       * <code>int32 width_pixels = 1;</code>
       *
       * @return The widthPixels.
       */
      @java.lang.Override
      public int getWidthPixels() {
        return widthPixels_;
      }
      /**
       *
       *
       * <pre>
       * The width of the video in pixels. Must be an even integer.
       * When not specified, the width is adjusted to match the specified height
       * and input aspect ratio. If both are omitted, the input width is used.
       * </pre>
       *
       * <code>int32 width_pixels = 1;</code>
       *
       * @param value The widthPixels to set.
       * @return This builder for chaining.
       */
      public Builder setWidthPixels(int value) {

        widthPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The width of the video in pixels. Must be an even integer.
       * When not specified, the width is adjusted to match the specified height
       * and input aspect ratio. If both are omitted, the input width is used.
       * </pre>
       *
       * <code>int32 width_pixels = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWidthPixels() {

        widthPixels_ = 0;
        onChanged();
        return this;
      }

      private int heightPixels_;
      /**
       *
       *
       * <pre>
       * The height of the video in pixels. Must be an even integer.
       * When not specified, the height is adjusted to match the specified width
       * and input aspect ratio. If both are omitted, the input height is used.
       * </pre>
       *
       * <code>int32 height_pixels = 2;</code>
       *
       * @return The heightPixels.
       */
      @java.lang.Override
      public int getHeightPixels() {
        return heightPixels_;
      }
      /**
       *
       *
       * <pre>
       * The height of the video in pixels. Must be an even integer.
       * When not specified, the height is adjusted to match the specified width
       * and input aspect ratio. If both are omitted, the input height is used.
       * </pre>
       *
       * <code>int32 height_pixels = 2;</code>
       *
       * @param value The heightPixels to set.
       * @return This builder for chaining.
       */
      public Builder setHeightPixels(int value) {

        heightPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The height of the video in pixels. Must be an even integer.
       * When not specified, the height is adjusted to match the specified width
       * and input aspect ratio. If both are omitted, the input height is used.
       * </pre>
       *
       * <code>int32 height_pixels = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHeightPixels() {

        heightPixels_ = 0;
        onChanged();
        return this;
      }

      private double frameRate_;
      /**
       *
       *
       * <pre>
       * Required. The target video frame rate in frames per second (FPS). Must be less than
       * or equal to 120. Will default to the input frame rate if larger than the
       * input frame rate. The API will generate an output FPS that is divisible
       * by the input FPS, and smaller or equal to the target FPS. See
       * [Calculating frame
       * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
       * more information.
       * </pre>
       *
       * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The frameRate.
       */
      @java.lang.Override
      public double getFrameRate() {
        return frameRate_;
      }
      /**
       *
       *
       * <pre>
       * Required. The target video frame rate in frames per second (FPS). Must be less than
       * or equal to 120. Will default to the input frame rate if larger than the
       * input frame rate. The API will generate an output FPS that is divisible
       * by the input FPS, and smaller or equal to the target FPS. See
       * [Calculating frame
       * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
       * more information.
       * </pre>
       *
       * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The frameRate to set.
       * @return This builder for chaining.
       */
      public Builder setFrameRate(double value) {

        frameRate_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The target video frame rate in frames per second (FPS). Must be less than
       * or equal to 120. Will default to the input frame rate if larger than the
       * input frame rate. The API will generate an output FPS that is divisible
       * by the input FPS, and smaller or equal to the target FPS. See
       * [Calculating frame
       * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
       * more information.
       * </pre>
       *
       * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFrameRate() {

        frameRate_ = 0D;
        onChanged();
        return this;
      }

      private int bitrateBps_;
      /**
       *
       *
       * <pre>
       * Required. The video bitrate in bits per second. The minimum value is 1,000.
       * The maximum value is 800,000,000.
       * </pre>
       *
       * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bitrateBps.
       */
      @java.lang.Override
      public int getBitrateBps() {
        return bitrateBps_;
      }
      /**
       *
       *
       * <pre>
       * Required. The video bitrate in bits per second. The minimum value is 1,000.
       * The maximum value is 800,000,000.
       * </pre>
       *
       * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bitrateBps to set.
       * @return This builder for chaining.
       */
      public Builder setBitrateBps(int value) {

        bitrateBps_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The video bitrate in bits per second. The minimum value is 1,000.
       * The maximum value is 800,000,000.
       * </pre>
       *
       * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBitrateBps() {

        bitrateBps_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object pixelFormat_ = "";
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @return The pixelFormat.
       */
      public java.lang.String getPixelFormat() {
        java.lang.Object ref = pixelFormat_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pixelFormat_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @return The bytes for pixelFormat.
       */
      public com.google.protobuf.ByteString getPixelFormatBytes() {
        java.lang.Object ref = pixelFormat_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pixelFormat_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @param value The pixelFormat to set.
       * @return This builder for chaining.
       */
      public Builder setPixelFormat(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        pixelFormat_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPixelFormat() {

        pixelFormat_ = getDefaultInstance().getPixelFormat();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @param value The bytes for pixelFormat to set.
       * @return This builder for chaining.
       */
      public Builder setPixelFormatBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        pixelFormat_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object rateControlMode_ = "";
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * - `crf` - constant rate factor
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @return The rateControlMode.
       */
      public java.lang.String getRateControlMode() {
        java.lang.Object ref = rateControlMode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          rateControlMode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * - `crf` - constant rate factor
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @return The bytes for rateControlMode.
       */
      public com.google.protobuf.ByteString getRateControlModeBytes() {
        java.lang.Object ref = rateControlMode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          rateControlMode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * - `crf` - constant rate factor
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @param value The rateControlMode to set.
       * @return This builder for chaining.
       */
      public Builder setRateControlMode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        rateControlMode_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * - `crf` - constant rate factor
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRateControlMode() {

        rateControlMode_ = getDefaultInstance().getRateControlMode();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * - `crf` - constant rate factor
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @param value The bytes for rateControlMode to set.
       * @return This builder for chaining.
       */
      public Builder setRateControlModeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        rateControlMode_ = value;
        onChanged();
        return this;
      }

      private int crfLevel_;
      /**
       *
       *
       * <pre>
       * Target CRF level. Must be between 10 and 36, where 10 is the highest
       * quality and 36 is the most efficient compression. The default is 21.
       * </pre>
       *
       * <code>int32 crf_level = 7;</code>
       *
       * @return The crfLevel.
       */
      @java.lang.Override
      public int getCrfLevel() {
        return crfLevel_;
      }
      /**
       *
       *
       * <pre>
       * Target CRF level. Must be between 10 and 36, where 10 is the highest
       * quality and 36 is the most efficient compression. The default is 21.
       * </pre>
       *
       * <code>int32 crf_level = 7;</code>
       *
       * @param value The crfLevel to set.
       * @return This builder for chaining.
       */
      public Builder setCrfLevel(int value) {

        crfLevel_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Target CRF level. Must be between 10 and 36, where 10 is the highest
       * quality and 36 is the most efficient compression. The default is 21.
       * </pre>
       *
       * <code>int32 crf_level = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCrfLevel() {

        crfLevel_ = 0;
        onChanged();
        return this;
      }

      private boolean allowOpenGop_;
      /**
       *
       *
       * <pre>
       * Specifies whether an open Group of Pictures (GOP) structure should be
       * allowed or not. The default is `false`.
       * </pre>
       *
       * <code>bool allow_open_gop = 8;</code>
       *
       * @return The allowOpenGop.
       */
      @java.lang.Override
      public boolean getAllowOpenGop() {
        return allowOpenGop_;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether an open Group of Pictures (GOP) structure should be
       * allowed or not. The default is `false`.
       * </pre>
       *
       * <code>bool allow_open_gop = 8;</code>
       *
       * @param value The allowOpenGop to set.
       * @return This builder for chaining.
       */
      public Builder setAllowOpenGop(boolean value) {

        allowOpenGop_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether an open Group of Pictures (GOP) structure should be
       * allowed or not. The default is `false`.
       * </pre>
       *
       * <code>bool allow_open_gop = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowOpenGop() {

        allowOpenGop_ = false;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified frame count. Must be greater
       * than zero.
       * </pre>
       *
       * <code>int32 gop_frame_count = 9;</code>
       *
       * @return Whether the gopFrameCount field is set.
       */
      public boolean hasGopFrameCount() {
        return gopModeCase_ == 9;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified frame count. Must be greater
       * than zero.
       * </pre>
       *
       * <code>int32 gop_frame_count = 9;</code>
       *
       * @return The gopFrameCount.
       */
      public int getGopFrameCount() {
        if (gopModeCase_ == 9) {
          return (java.lang.Integer) gopMode_;
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified frame count. Must be greater
       * than zero.
       * </pre>
       *
       * <code>int32 gop_frame_count = 9;</code>
       *
       * @param value The gopFrameCount to set.
       * @return This builder for chaining.
       */
      public Builder setGopFrameCount(int value) {
        gopModeCase_ = 9;
        gopMode_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified frame count. Must be greater
       * than zero.
       * </pre>
       *
       * <code>int32 gop_frame_count = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGopFrameCount() {
        if (gopModeCase_ == 9) {
          gopModeCase_ = 0;
          gopMode_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          gopDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       *
       * @return Whether the gopDuration field is set.
       */
      @java.lang.Override
      public boolean hasGopDuration() {
        return gopModeCase_ == 10;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       *
       * @return The gopDuration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getGopDuration() {
        if (gopDurationBuilder_ == null) {
          if (gopModeCase_ == 10) {
            return (com.google.protobuf.Duration) gopMode_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        } else {
          if (gopModeCase_ == 10) {
            return gopDurationBuilder_.getMessage();
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      public Builder setGopDuration(com.google.protobuf.Duration value) {
        if (gopDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          gopMode_ = value;
          onChanged();
        } else {
          gopDurationBuilder_.setMessage(value);
        }
        gopModeCase_ = 10;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      public Builder setGopDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (gopDurationBuilder_ == null) {
          gopMode_ = builderForValue.build();
          onChanged();
        } else {
          gopDurationBuilder_.setMessage(builderForValue.build());
        }
        gopModeCase_ = 10;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      public Builder mergeGopDuration(com.google.protobuf.Duration value) {
        if (gopDurationBuilder_ == null) {
          if (gopModeCase_ == 10 && gopMode_ != com.google.protobuf.Duration.getDefaultInstance()) {
            gopMode_ =
                com.google.protobuf.Duration.newBuilder((com.google.protobuf.Duration) gopMode_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            gopMode_ = value;
          }
          onChanged();
        } else {
          if (gopModeCase_ == 10) {
            gopDurationBuilder_.mergeFrom(value);
          } else {
            gopDurationBuilder_.setMessage(value);
          }
        }
        gopModeCase_ = 10;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      public Builder clearGopDuration() {
        if (gopDurationBuilder_ == null) {
          if (gopModeCase_ == 10) {
            gopModeCase_ = 0;
            gopMode_ = null;
            onChanged();
          }
        } else {
          if (gopModeCase_ == 10) {
            gopModeCase_ = 0;
            gopMode_ = null;
          }
          gopDurationBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      public com.google.protobuf.Duration.Builder getGopDurationBuilder() {
        return getGopDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getGopDurationOrBuilder() {
        if ((gopModeCase_ == 10) && (gopDurationBuilder_ != null)) {
          return gopDurationBuilder_.getMessageOrBuilder();
        } else {
          if (gopModeCase_ == 10) {
            return (com.google.protobuf.Duration) gopMode_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getGopDurationFieldBuilder() {
        if (gopDurationBuilder_ == null) {
          if (!(gopModeCase_ == 10)) {
            gopMode_ = com.google.protobuf.Duration.getDefaultInstance();
          }
          gopDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  (com.google.protobuf.Duration) gopMode_, getParentForChildren(), isClean());
          gopMode_ = null;
        }
        gopModeCase_ = 10;
        onChanged();
        ;
        return gopDurationBuilder_;
      }

      private boolean enableTwoPass_;
      /**
       *
       *
       * <pre>
       * Use two-pass encoding strategy to achieve better video quality.
       * `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
       * </pre>
       *
       * <code>bool enable_two_pass = 11;</code>
       *
       * @return The enableTwoPass.
       */
      @java.lang.Override
      public boolean getEnableTwoPass() {
        return enableTwoPass_;
      }
      /**
       *
       *
       * <pre>
       * Use two-pass encoding strategy to achieve better video quality.
       * `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
       * </pre>
       *
       * <code>bool enable_two_pass = 11;</code>
       *
       * @param value The enableTwoPass to set.
       * @return This builder for chaining.
       */
      public Builder setEnableTwoPass(boolean value) {

        enableTwoPass_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use two-pass encoding strategy to achieve better video quality.
       * `VideoStream.rate_control_mode` must be `vbr`. The default is `false`.
       * </pre>
       *
       * <code>bool enable_two_pass = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableTwoPass() {

        enableTwoPass_ = false;
        onChanged();
        return this;
      }

      private int vbvSizeBits_;
      /**
       *
       *
       * <pre>
       * Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
       * greater than zero. The default is equal to `VideoStream.bitrate_bps`.
       * </pre>
       *
       * <code>int32 vbv_size_bits = 12;</code>
       *
       * @return The vbvSizeBits.
       */
      @java.lang.Override
      public int getVbvSizeBits() {
        return vbvSizeBits_;
      }
      /**
       *
       *
       * <pre>
       * Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
       * greater than zero. The default is equal to `VideoStream.bitrate_bps`.
       * </pre>
       *
       * <code>int32 vbv_size_bits = 12;</code>
       *
       * @param value The vbvSizeBits to set.
       * @return This builder for chaining.
       */
      public Builder setVbvSizeBits(int value) {

        vbvSizeBits_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Size of the Video Buffering Verifier (VBV) buffer in bits. Must be
       * greater than zero. The default is equal to `VideoStream.bitrate_bps`.
       * </pre>
       *
       * <code>int32 vbv_size_bits = 12;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVbvSizeBits() {

        vbvSizeBits_ = 0;
        onChanged();
        return this;
      }

      private int vbvFullnessBits_;
      /**
       *
       *
       * <pre>
       * Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
       * Must be greater than zero. The default is equal to 90% of
       * `VideoStream.vbv_size_bits`.
       * </pre>
       *
       * <code>int32 vbv_fullness_bits = 13;</code>
       *
       * @return The vbvFullnessBits.
       */
      @java.lang.Override
      public int getVbvFullnessBits() {
        return vbvFullnessBits_;
      }
      /**
       *
       *
       * <pre>
       * Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
       * Must be greater than zero. The default is equal to 90% of
       * `VideoStream.vbv_size_bits`.
       * </pre>
       *
       * <code>int32 vbv_fullness_bits = 13;</code>
       *
       * @param value The vbvFullnessBits to set.
       * @return This builder for chaining.
       */
      public Builder setVbvFullnessBits(int value) {

        vbvFullnessBits_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Initial fullness of the Video Buffering Verifier (VBV) buffer in bits.
       * Must be greater than zero. The default is equal to 90% of
       * `VideoStream.vbv_size_bits`.
       * </pre>
       *
       * <code>int32 vbv_fullness_bits = 13;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVbvFullnessBits() {

        vbvFullnessBits_ = 0;
        onChanged();
        return this;
      }

      private boolean bPyramid_;
      /**
       *
       *
       * <pre>
       * Allow B-pyramid for reference frame selection. This may not be supported
       * on all decoders. The default is `false`.
       * </pre>
       *
       * <code>bool b_pyramid = 14;</code>
       *
       * @return The bPyramid.
       */
      @java.lang.Override
      public boolean getBPyramid() {
        return bPyramid_;
      }
      /**
       *
       *
       * <pre>
       * Allow B-pyramid for reference frame selection. This may not be supported
       * on all decoders. The default is `false`.
       * </pre>
       *
       * <code>bool b_pyramid = 14;</code>
       *
       * @param value The bPyramid to set.
       * @return This builder for chaining.
       */
      public Builder setBPyramid(boolean value) {

        bPyramid_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Allow B-pyramid for reference frame selection. This may not be supported
       * on all decoders. The default is `false`.
       * </pre>
       *
       * <code>bool b_pyramid = 14;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBPyramid() {

        bPyramid_ = false;
        onChanged();
        return this;
      }

      private int bFrameCount_;
      /**
       *
       *
       * <pre>
       * The number of consecutive B-frames. Must be greater than or equal to
       * zero. Must be less than `VideoStream.gop_frame_count` if set. The default
       * is 0.
       * </pre>
       *
       * <code>int32 b_frame_count = 15;</code>
       *
       * @return The bFrameCount.
       */
      @java.lang.Override
      public int getBFrameCount() {
        return bFrameCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of consecutive B-frames. Must be greater than or equal to
       * zero. Must be less than `VideoStream.gop_frame_count` if set. The default
       * is 0.
       * </pre>
       *
       * <code>int32 b_frame_count = 15;</code>
       *
       * @param value The bFrameCount to set.
       * @return This builder for chaining.
       */
      public Builder setBFrameCount(int value) {

        bFrameCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of consecutive B-frames. Must be greater than or equal to
       * zero. Must be less than `VideoStream.gop_frame_count` if set. The default
       * is 0.
       * </pre>
       *
       * <code>int32 b_frame_count = 15;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBFrameCount() {

        bFrameCount_ = 0;
        onChanged();
        return this;
      }

      private double aqStrength_;
      /**
       *
       *
       * <pre>
       * Specify the intensity of the adaptive quantizer (AQ). Must be between 0
       * and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
       * higher value equals a lower bitrate but smoother image. The default is 0.
       * </pre>
       *
       * <code>double aq_strength = 16;</code>
       *
       * @return The aqStrength.
       */
      @java.lang.Override
      public double getAqStrength() {
        return aqStrength_;
      }
      /**
       *
       *
       * <pre>
       * Specify the intensity of the adaptive quantizer (AQ). Must be between 0
       * and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
       * higher value equals a lower bitrate but smoother image. The default is 0.
       * </pre>
       *
       * <code>double aq_strength = 16;</code>
       *
       * @param value The aqStrength to set.
       * @return This builder for chaining.
       */
      public Builder setAqStrength(double value) {

        aqStrength_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify the intensity of the adaptive quantizer (AQ). Must be between 0
       * and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A
       * higher value equals a lower bitrate but smoother image. The default is 0.
       * </pre>
       *
       * <code>double aq_strength = 16;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAqStrength() {

        aqStrength_ = 0D;
        onChanged();
        return this;
      }

      private java.lang.Object profile_ = "";
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   8-bit profiles
       *     *   `main` (default)
       *     *   `main-intra`
       *     *   `mainstillpicture`
       * *   10-bit profiles
       *     *   `main10` (default)
       *     *   `main10-intra`
       *     *   `main422-10`
       *     *   `main422-10-intra`
       *     *   `main444-10`
       *     *   `main444-10-intra`
       * *   12-bit profiles
       *     *   `main12` (default)
       *     *   `main12-intra`
       *     *   `main422-12`
       *     *   `main422-12-intra`
       *     *   `main444-12`
       *     *   `main444-12-intra`
       * The available options are
       * [FFmpeg-compatible](https://x265.readthedocs.io/).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 17;</code>
       *
       * @return The profile.
       */
      public java.lang.String getProfile() {
        java.lang.Object ref = profile_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          profile_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   8-bit profiles
       *     *   `main` (default)
       *     *   `main-intra`
       *     *   `mainstillpicture`
       * *   10-bit profiles
       *     *   `main10` (default)
       *     *   `main10-intra`
       *     *   `main422-10`
       *     *   `main422-10-intra`
       *     *   `main444-10`
       *     *   `main444-10-intra`
       * *   12-bit profiles
       *     *   `main12` (default)
       *     *   `main12-intra`
       *     *   `main422-12`
       *     *   `main422-12-intra`
       *     *   `main444-12`
       *     *   `main444-12-intra`
       * The available options are
       * [FFmpeg-compatible](https://x265.readthedocs.io/).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 17;</code>
       *
       * @return The bytes for profile.
       */
      public com.google.protobuf.ByteString getProfileBytes() {
        java.lang.Object ref = profile_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          profile_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   8-bit profiles
       *     *   `main` (default)
       *     *   `main-intra`
       *     *   `mainstillpicture`
       * *   10-bit profiles
       *     *   `main10` (default)
       *     *   `main10-intra`
       *     *   `main422-10`
       *     *   `main422-10-intra`
       *     *   `main444-10`
       *     *   `main444-10-intra`
       * *   12-bit profiles
       *     *   `main12` (default)
       *     *   `main12-intra`
       *     *   `main422-12`
       *     *   `main422-12-intra`
       *     *   `main444-12`
       *     *   `main444-12-intra`
       * The available options are
       * [FFmpeg-compatible](https://x265.readthedocs.io/).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 17;</code>
       *
       * @param value The profile to set.
       * @return This builder for chaining.
       */
      public Builder setProfile(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        profile_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   8-bit profiles
       *     *   `main` (default)
       *     *   `main-intra`
       *     *   `mainstillpicture`
       * *   10-bit profiles
       *     *   `main10` (default)
       *     *   `main10-intra`
       *     *   `main422-10`
       *     *   `main422-10-intra`
       *     *   `main444-10`
       *     *   `main444-10-intra`
       * *   12-bit profiles
       *     *   `main12` (default)
       *     *   `main12-intra`
       *     *   `main422-12`
       *     *   `main422-12-intra`
       *     *   `main444-12`
       *     *   `main444-12-intra`
       * The available options are
       * [FFmpeg-compatible](https://x265.readthedocs.io/).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 17;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProfile() {

        profile_ = getDefaultInstance().getProfile();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   8-bit profiles
       *     *   `main` (default)
       *     *   `main-intra`
       *     *   `mainstillpicture`
       * *   10-bit profiles
       *     *   `main10` (default)
       *     *   `main10-intra`
       *     *   `main422-10`
       *     *   `main422-10-intra`
       *     *   `main444-10`
       *     *   `main444-10-intra`
       * *   12-bit profiles
       *     *   `main12` (default)
       *     *   `main12-intra`
       *     *   `main422-12`
       *     *   `main422-12-intra`
       *     *   `main444-12`
       *     *   `main444-12-intra`
       * The available options are
       * [FFmpeg-compatible](https://x265.readthedocs.io/).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 17;</code>
       *
       * @param value The bytes for profile to set.
       * @return This builder for chaining.
       */
      public Builder setProfileBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        profile_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object tune_ = "";
      /**
       *
       *
       * <pre>
       * Enforces the specified codec tune. The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string tune = 18;</code>
       *
       * @return The tune.
       */
      public java.lang.String getTune() {
        java.lang.Object ref = tune_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tune_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec tune. The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string tune = 18;</code>
       *
       * @return The bytes for tune.
       */
      public com.google.protobuf.ByteString getTuneBytes() {
        java.lang.Object ref = tune_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tune_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec tune. The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string tune = 18;</code>
       *
       * @param value The tune to set.
       * @return This builder for chaining.
       */
      public Builder setTune(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        tune_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec tune. The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string tune = 18;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTune() {

        tune_ = getDefaultInstance().getTune();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec tune. The available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string tune = 18;</code>
       *
       * @param value The bytes for tune to set.
       * @return This builder for chaining.
       */
      public Builder setTuneBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        tune_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object preset_ = "";
      /**
       *
       *
       * <pre>
       * Enforces the specified codec preset. The default is `veryfast`. The
       * available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string preset = 19;</code>
       *
       * @return The preset.
       */
      public java.lang.String getPreset() {
        java.lang.Object ref = preset_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          preset_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec preset. The default is `veryfast`. The
       * available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string preset = 19;</code>
       *
       * @return The bytes for preset.
       */
      public com.google.protobuf.ByteString getPresetBytes() {
        java.lang.Object ref = preset_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          preset_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec preset. The default is `veryfast`. The
       * available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string preset = 19;</code>
       *
       * @param value The preset to set.
       * @return This builder for chaining.
       */
      public Builder setPreset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        preset_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec preset. The default is `veryfast`. The
       * available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string preset = 19;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPreset() {

        preset_ = getDefaultInstance().getPreset();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec preset. The default is `veryfast`. The
       * available options are
       * [FFmpeg-compatible](https://trac.ffmpeg.org/wiki/Encode/H.265).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `H265CodecSettings`
       * message.
       * </pre>
       *
       * <code>string preset = 19;</code>
       *
       * @param value The bytes for preset to set.
       * @return This builder for chaining.
       */
      public Builder setPresetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        preset_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings)
    private static final com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings();
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<H265CodecSettings> PARSER =
        new com.google.protobuf.AbstractParser<H265CodecSettings>() {
          @java.lang.Override
          public H265CodecSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<H265CodecSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<H265CodecSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface Vp9CodecSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The width of the video in pixels. Must be an even integer.
     * When not specified, the width is adjusted to match the specified height
     * and input aspect ratio. If both are omitted, the input width is used.
     * </pre>
     *
     * <code>int32 width_pixels = 1;</code>
     *
     * @return The widthPixels.
     */
    int getWidthPixels();

    /**
     *
     *
     * <pre>
     * The height of the video in pixels. Must be an even integer.
     * When not specified, the height is adjusted to match the specified width
     * and input aspect ratio. If both are omitted, the input height is used.
     * </pre>
     *
     * <code>int32 height_pixels = 2;</code>
     *
     * @return The heightPixels.
     */
    int getHeightPixels();

    /**
     *
     *
     * <pre>
     * Required. The target video frame rate in frames per second (FPS). Must be less than
     * or equal to 120. Will default to the input frame rate if larger than the
     * input frame rate. The API will generate an output FPS that is divisible
     * by the input FPS, and smaller or equal to the target FPS. See
     * [Calculating frame
     * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
     * more information.
     * </pre>
     *
     * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The frameRate.
     */
    double getFrameRate();

    /**
     *
     *
     * <pre>
     * Required. The video bitrate in bits per second. The minimum value is 1,000.
     * The maximum value is 480,000,000.
     * </pre>
     *
     * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bitrateBps.
     */
    int getBitrateBps();

    /**
     *
     *
     * <pre>
     * Pixel format to use. The default is `yuv420p`.
     * Supported pixel formats:
     * - `yuv420p` pixel format
     * - `yuv422p` pixel format
     * - `yuv444p` pixel format
     * - `yuv420p10` 10-bit HDR pixel format
     * - `yuv422p10` 10-bit HDR pixel format
     * - `yuv444p10` 10-bit HDR pixel format
     * - `yuv420p12` 12-bit HDR pixel format
     * - `yuv422p12` 12-bit HDR pixel format
     * - `yuv444p12` 12-bit HDR pixel format
     * </pre>
     *
     * <code>string pixel_format = 5;</code>
     *
     * @return The pixelFormat.
     */
    java.lang.String getPixelFormat();
    /**
     *
     *
     * <pre>
     * Pixel format to use. The default is `yuv420p`.
     * Supported pixel formats:
     * - `yuv420p` pixel format
     * - `yuv422p` pixel format
     * - `yuv444p` pixel format
     * - `yuv420p10` 10-bit HDR pixel format
     * - `yuv422p10` 10-bit HDR pixel format
     * - `yuv444p10` 10-bit HDR pixel format
     * - `yuv420p12` 12-bit HDR pixel format
     * - `yuv422p12` 12-bit HDR pixel format
     * - `yuv444p12` 12-bit HDR pixel format
     * </pre>
     *
     * <code>string pixel_format = 5;</code>
     *
     * @return The bytes for pixelFormat.
     */
    com.google.protobuf.ByteString getPixelFormatBytes();

    /**
     *
     *
     * <pre>
     * Specify the `rate_control_mode`. The default is `vbr`.
     * Supported rate control modes:
     * - `vbr` - variable bitrate
     * </pre>
     *
     * <code>string rate_control_mode = 6;</code>
     *
     * @return The rateControlMode.
     */
    java.lang.String getRateControlMode();
    /**
     *
     *
     * <pre>
     * Specify the `rate_control_mode`. The default is `vbr`.
     * Supported rate control modes:
     * - `vbr` - variable bitrate
     * </pre>
     *
     * <code>string rate_control_mode = 6;</code>
     *
     * @return The bytes for rateControlMode.
     */
    com.google.protobuf.ByteString getRateControlModeBytes();

    /**
     *
     *
     * <pre>
     * Target CRF level. Must be between 10 and 36, where 10 is the highest
     * quality and 36 is the most efficient compression. The default is 21.
     * **Note:** This field is not supported.
     * </pre>
     *
     * <code>int32 crf_level = 7;</code>
     *
     * @return The crfLevel.
     */
    int getCrfLevel();

    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified frame count. Must be greater
     * than zero.
     * </pre>
     *
     * <code>int32 gop_frame_count = 8;</code>
     *
     * @return Whether the gopFrameCount field is set.
     */
    boolean hasGopFrameCount();
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified frame count. Must be greater
     * than zero.
     * </pre>
     *
     * <code>int32 gop_frame_count = 8;</code>
     *
     * @return The gopFrameCount.
     */
    int getGopFrameCount();

    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 9;</code>
     *
     * @return Whether the gopDuration field is set.
     */
    boolean hasGopDuration();
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 9;</code>
     *
     * @return The gopDuration.
     */
    com.google.protobuf.Duration getGopDuration();
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 9;</code>
     */
    com.google.protobuf.DurationOrBuilder getGopDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * Enforces the specified codec profile. The following profiles are
     * supported:
     * *   `profile0` (default)
     * *   `profile1`
     * *   `profile2`
     * *   `profile3`
     * The available options are
     * [WebM-compatible](https://www.webmproject.org/vp9/profiles/).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `Vp9CodecSettings`
     * message.
     * </pre>
     *
     * <code>string profile = 10;</code>
     *
     * @return The profile.
     */
    java.lang.String getProfile();
    /**
     *
     *
     * <pre>
     * Enforces the specified codec profile. The following profiles are
     * supported:
     * *   `profile0` (default)
     * *   `profile1`
     * *   `profile2`
     * *   `profile3`
     * The available options are
     * [WebM-compatible](https://www.webmproject.org/vp9/profiles/).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `Vp9CodecSettings`
     * message.
     * </pre>
     *
     * <code>string profile = 10;</code>
     *
     * @return The bytes for profile.
     */
    com.google.protobuf.ByteString getProfileBytes();

    public com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.GopModeCase
        getGopModeCase();
  }
  /**
   *
   *
   * <pre>
   * VP9 codec settings.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings}
   */
  public static final class Vp9CodecSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings)
      Vp9CodecSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Vp9CodecSettings.newBuilder() to construct.
    private Vp9CodecSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Vp9CodecSettings() {
      pixelFormat_ = "";
      rateControlMode_ = "";
      profile_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Vp9CodecSettings();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_VideoStream_Vp9CodecSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_VideoStream_Vp9CodecSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.class,
              com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.Builder.class);
    }

    private int gopModeCase_ = 0;
    private java.lang.Object gopMode_;

    public enum GopModeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GOP_FRAME_COUNT(8),
      GOP_DURATION(9),
      GOPMODE_NOT_SET(0);
      private final int value;

      private GopModeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static GopModeCase valueOf(int value) {
        return forNumber(value);
      }

      public static GopModeCase forNumber(int value) {
        switch (value) {
          case 8:
            return GOP_FRAME_COUNT;
          case 9:
            return GOP_DURATION;
          case 0:
            return GOPMODE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public GopModeCase getGopModeCase() {
      return GopModeCase.forNumber(gopModeCase_);
    }

    public static final int WIDTH_PIXELS_FIELD_NUMBER = 1;
    private int widthPixels_;
    /**
     *
     *
     * <pre>
     * The width of the video in pixels. Must be an even integer.
     * When not specified, the width is adjusted to match the specified height
     * and input aspect ratio. If both are omitted, the input width is used.
     * </pre>
     *
     * <code>int32 width_pixels = 1;</code>
     *
     * @return The widthPixels.
     */
    @java.lang.Override
    public int getWidthPixels() {
      return widthPixels_;
    }

    public static final int HEIGHT_PIXELS_FIELD_NUMBER = 2;
    private int heightPixels_;
    /**
     *
     *
     * <pre>
     * The height of the video in pixels. Must be an even integer.
     * When not specified, the height is adjusted to match the specified width
     * and input aspect ratio. If both are omitted, the input height is used.
     * </pre>
     *
     * <code>int32 height_pixels = 2;</code>
     *
     * @return The heightPixels.
     */
    @java.lang.Override
    public int getHeightPixels() {
      return heightPixels_;
    }

    public static final int FRAME_RATE_FIELD_NUMBER = 3;
    private double frameRate_;
    /**
     *
     *
     * <pre>
     * Required. The target video frame rate in frames per second (FPS). Must be less than
     * or equal to 120. Will default to the input frame rate if larger than the
     * input frame rate. The API will generate an output FPS that is divisible
     * by the input FPS, and smaller or equal to the target FPS. See
     * [Calculating frame
     * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
     * more information.
     * </pre>
     *
     * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The frameRate.
     */
    @java.lang.Override
    public double getFrameRate() {
      return frameRate_;
    }

    public static final int BITRATE_BPS_FIELD_NUMBER = 4;
    private int bitrateBps_;
    /**
     *
     *
     * <pre>
     * Required. The video bitrate in bits per second. The minimum value is 1,000.
     * The maximum value is 480,000,000.
     * </pre>
     *
     * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bitrateBps.
     */
    @java.lang.Override
    public int getBitrateBps() {
      return bitrateBps_;
    }

    public static final int PIXEL_FORMAT_FIELD_NUMBER = 5;
    private volatile java.lang.Object pixelFormat_;
    /**
     *
     *
     * <pre>
     * Pixel format to use. The default is `yuv420p`.
     * Supported pixel formats:
     * - `yuv420p` pixel format
     * - `yuv422p` pixel format
     * - `yuv444p` pixel format
     * - `yuv420p10` 10-bit HDR pixel format
     * - `yuv422p10` 10-bit HDR pixel format
     * - `yuv444p10` 10-bit HDR pixel format
     * - `yuv420p12` 12-bit HDR pixel format
     * - `yuv422p12` 12-bit HDR pixel format
     * - `yuv444p12` 12-bit HDR pixel format
     * </pre>
     *
     * <code>string pixel_format = 5;</code>
     *
     * @return The pixelFormat.
     */
    @java.lang.Override
    public java.lang.String getPixelFormat() {
      java.lang.Object ref = pixelFormat_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pixelFormat_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Pixel format to use. The default is `yuv420p`.
     * Supported pixel formats:
     * - `yuv420p` pixel format
     * - `yuv422p` pixel format
     * - `yuv444p` pixel format
     * - `yuv420p10` 10-bit HDR pixel format
     * - `yuv422p10` 10-bit HDR pixel format
     * - `yuv444p10` 10-bit HDR pixel format
     * - `yuv420p12` 12-bit HDR pixel format
     * - `yuv422p12` 12-bit HDR pixel format
     * - `yuv444p12` 12-bit HDR pixel format
     * </pre>
     *
     * <code>string pixel_format = 5;</code>
     *
     * @return The bytes for pixelFormat.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPixelFormatBytes() {
      java.lang.Object ref = pixelFormat_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pixelFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RATE_CONTROL_MODE_FIELD_NUMBER = 6;
    private volatile java.lang.Object rateControlMode_;
    /**
     *
     *
     * <pre>
     * Specify the `rate_control_mode`. The default is `vbr`.
     * Supported rate control modes:
     * - `vbr` - variable bitrate
     * </pre>
     *
     * <code>string rate_control_mode = 6;</code>
     *
     * @return The rateControlMode.
     */
    @java.lang.Override
    public java.lang.String getRateControlMode() {
      java.lang.Object ref = rateControlMode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rateControlMode_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specify the `rate_control_mode`. The default is `vbr`.
     * Supported rate control modes:
     * - `vbr` - variable bitrate
     * </pre>
     *
     * <code>string rate_control_mode = 6;</code>
     *
     * @return The bytes for rateControlMode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRateControlModeBytes() {
      java.lang.Object ref = rateControlMode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rateControlMode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CRF_LEVEL_FIELD_NUMBER = 7;
    private int crfLevel_;
    /**
     *
     *
     * <pre>
     * Target CRF level. Must be between 10 and 36, where 10 is the highest
     * quality and 36 is the most efficient compression. The default is 21.
     * **Note:** This field is not supported.
     * </pre>
     *
     * <code>int32 crf_level = 7;</code>
     *
     * @return The crfLevel.
     */
    @java.lang.Override
    public int getCrfLevel() {
      return crfLevel_;
    }

    public static final int GOP_FRAME_COUNT_FIELD_NUMBER = 8;
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified frame count. Must be greater
     * than zero.
     * </pre>
     *
     * <code>int32 gop_frame_count = 8;</code>
     *
     * @return Whether the gopFrameCount field is set.
     */
    @java.lang.Override
    public boolean hasGopFrameCount() {
      return gopModeCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified frame count. Must be greater
     * than zero.
     * </pre>
     *
     * <code>int32 gop_frame_count = 8;</code>
     *
     * @return The gopFrameCount.
     */
    @java.lang.Override
    public int getGopFrameCount() {
      if (gopModeCase_ == 8) {
        return (java.lang.Integer) gopMode_;
      }
      return 0;
    }

    public static final int GOP_DURATION_FIELD_NUMBER = 9;
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 9;</code>
     *
     * @return Whether the gopDuration field is set.
     */
    @java.lang.Override
    public boolean hasGopDuration() {
      return gopModeCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 9;</code>
     *
     * @return The gopDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getGopDuration() {
      if (gopModeCase_ == 9) {
        return (com.google.protobuf.Duration) gopMode_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Select the GOP size based on the specified duration. The default is
     * `3s`. Note that `gopDuration` must be less than or equal to
     * [`segmentDuration`](#SegmentSettings), and
     * [`segmentDuration`](#SegmentSettings) must be divisible by
     * `gopDuration`.
     * </pre>
     *
     * <code>.google.protobuf.Duration gop_duration = 9;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getGopDurationOrBuilder() {
      if (gopModeCase_ == 9) {
        return (com.google.protobuf.Duration) gopMode_;
      }
      return com.google.protobuf.Duration.getDefaultInstance();
    }

    public static final int PROFILE_FIELD_NUMBER = 10;
    private volatile java.lang.Object profile_;
    /**
     *
     *
     * <pre>
     * Enforces the specified codec profile. The following profiles are
     * supported:
     * *   `profile0` (default)
     * *   `profile1`
     * *   `profile2`
     * *   `profile3`
     * The available options are
     * [WebM-compatible](https://www.webmproject.org/vp9/profiles/).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `Vp9CodecSettings`
     * message.
     * </pre>
     *
     * <code>string profile = 10;</code>
     *
     * @return The profile.
     */
    @java.lang.Override
    public java.lang.String getProfile() {
      java.lang.Object ref = profile_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        profile_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Enforces the specified codec profile. The following profiles are
     * supported:
     * *   `profile0` (default)
     * *   `profile1`
     * *   `profile2`
     * *   `profile3`
     * The available options are
     * [WebM-compatible](https://www.webmproject.org/vp9/profiles/).
     * Note that certain values for this field may cause the
     * transcoder to override other fields you set in the `Vp9CodecSettings`
     * message.
     * </pre>
     *
     * <code>string profile = 10;</code>
     *
     * @return The bytes for profile.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProfileBytes() {
      java.lang.Object ref = profile_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        profile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (widthPixels_ != 0) {
        output.writeInt32(1, widthPixels_);
      }
      if (heightPixels_ != 0) {
        output.writeInt32(2, heightPixels_);
      }
      if (java.lang.Double.doubleToRawLongBits(frameRate_) != 0) {
        output.writeDouble(3, frameRate_);
      }
      if (bitrateBps_ != 0) {
        output.writeInt32(4, bitrateBps_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pixelFormat_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, pixelFormat_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rateControlMode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, rateControlMode_);
      }
      if (crfLevel_ != 0) {
        output.writeInt32(7, crfLevel_);
      }
      if (gopModeCase_ == 8) {
        output.writeInt32(8, (int) ((java.lang.Integer) gopMode_));
      }
      if (gopModeCase_ == 9) {
        output.writeMessage(9, (com.google.protobuf.Duration) gopMode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(profile_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 10, profile_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (widthPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, widthPixels_);
      }
      if (heightPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, heightPixels_);
      }
      if (java.lang.Double.doubleToRawLongBits(frameRate_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, frameRate_);
      }
      if (bitrateBps_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, bitrateBps_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pixelFormat_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, pixelFormat_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rateControlMode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, rateControlMode_);
      }
      if (crfLevel_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, crfLevel_);
      }
      if (gopModeCase_ == 8) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                8, (int) ((java.lang.Integer) gopMode_));
      }
      if (gopModeCase_ == 9) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                9, (com.google.protobuf.Duration) gopMode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(profile_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, profile_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings other =
          (com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings) obj;

      if (getWidthPixels() != other.getWidthPixels()) return false;
      if (getHeightPixels() != other.getHeightPixels()) return false;
      if (java.lang.Double.doubleToLongBits(getFrameRate())
          != java.lang.Double.doubleToLongBits(other.getFrameRate())) return false;
      if (getBitrateBps() != other.getBitrateBps()) return false;
      if (!getPixelFormat().equals(other.getPixelFormat())) return false;
      if (!getRateControlMode().equals(other.getRateControlMode())) return false;
      if (getCrfLevel() != other.getCrfLevel()) return false;
      if (!getProfile().equals(other.getProfile())) return false;
      if (!getGopModeCase().equals(other.getGopModeCase())) return false;
      switch (gopModeCase_) {
        case 8:
          if (getGopFrameCount() != other.getGopFrameCount()) return false;
          break;
        case 9:
          if (!getGopDuration().equals(other.getGopDuration())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + WIDTH_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getWidthPixels();
      hash = (37 * hash) + HEIGHT_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getHeightPixels();
      hash = (37 * hash) + FRAME_RATE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getFrameRate()));
      hash = (37 * hash) + BITRATE_BPS_FIELD_NUMBER;
      hash = (53 * hash) + getBitrateBps();
      hash = (37 * hash) + PIXEL_FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + getPixelFormat().hashCode();
      hash = (37 * hash) + RATE_CONTROL_MODE_FIELD_NUMBER;
      hash = (53 * hash) + getRateControlMode().hashCode();
      hash = (37 * hash) + CRF_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + getCrfLevel();
      hash = (37 * hash) + PROFILE_FIELD_NUMBER;
      hash = (53 * hash) + getProfile().hashCode();
      switch (gopModeCase_) {
        case 8:
          hash = (37 * hash) + GOP_FRAME_COUNT_FIELD_NUMBER;
          hash = (53 * hash) + getGopFrameCount();
          break;
        case 9:
          hash = (37 * hash) + GOP_DURATION_FIELD_NUMBER;
          hash = (53 * hash) + getGopDuration().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * VP9 codec settings.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings)
        com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_VideoStream_Vp9CodecSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_VideoStream_Vp9CodecSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.class,
                com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.Builder.class);
      }

      // Construct using
      // com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        widthPixels_ = 0;

        heightPixels_ = 0;

        frameRate_ = 0D;

        bitrateBps_ = 0;

        pixelFormat_ = "";

        rateControlMode_ = "";

        crfLevel_ = 0;

        if (gopDurationBuilder_ != null) {
          gopDurationBuilder_.clear();
        }
        profile_ = "";

        gopModeCase_ = 0;
        gopMode_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_VideoStream_Vp9CodecSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings build() {
        com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings buildPartial() {
        com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings result =
            new com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings(this);
        result.widthPixels_ = widthPixels_;
        result.heightPixels_ = heightPixels_;
        result.frameRate_ = frameRate_;
        result.bitrateBps_ = bitrateBps_;
        result.pixelFormat_ = pixelFormat_;
        result.rateControlMode_ = rateControlMode_;
        result.crfLevel_ = crfLevel_;
        if (gopModeCase_ == 8) {
          result.gopMode_ = gopMode_;
        }
        if (gopModeCase_ == 9) {
          if (gopDurationBuilder_ == null) {
            result.gopMode_ = gopMode_;
          } else {
            result.gopMode_ = gopDurationBuilder_.build();
          }
        }
        result.profile_ = profile_;
        result.gopModeCase_ = gopModeCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings) {
          return mergeFrom(
              (com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings other) {
        if (other
            == com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
                .getDefaultInstance()) return this;
        if (other.getWidthPixels() != 0) {
          setWidthPixels(other.getWidthPixels());
        }
        if (other.getHeightPixels() != 0) {
          setHeightPixels(other.getHeightPixels());
        }
        if (other.getFrameRate() != 0D) {
          setFrameRate(other.getFrameRate());
        }
        if (other.getBitrateBps() != 0) {
          setBitrateBps(other.getBitrateBps());
        }
        if (!other.getPixelFormat().isEmpty()) {
          pixelFormat_ = other.pixelFormat_;
          onChanged();
        }
        if (!other.getRateControlMode().isEmpty()) {
          rateControlMode_ = other.rateControlMode_;
          onChanged();
        }
        if (other.getCrfLevel() != 0) {
          setCrfLevel(other.getCrfLevel());
        }
        if (!other.getProfile().isEmpty()) {
          profile_ = other.profile_;
          onChanged();
        }
        switch (other.getGopModeCase()) {
          case GOP_FRAME_COUNT:
            {
              setGopFrameCount(other.getGopFrameCount());
              break;
            }
          case GOP_DURATION:
            {
              mergeGopDuration(other.getGopDuration());
              break;
            }
          case GOPMODE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  widthPixels_ = input.readInt32();

                  break;
                } // case 8
              case 16:
                {
                  heightPixels_ = input.readInt32();

                  break;
                } // case 16
              case 25:
                {
                  frameRate_ = input.readDouble();

                  break;
                } // case 25
              case 32:
                {
                  bitrateBps_ = input.readInt32();

                  break;
                } // case 32
              case 42:
                {
                  pixelFormat_ = input.readStringRequireUtf8();

                  break;
                } // case 42
              case 50:
                {
                  rateControlMode_ = input.readStringRequireUtf8();

                  break;
                } // case 50
              case 56:
                {
                  crfLevel_ = input.readInt32();

                  break;
                } // case 56
              case 64:
                {
                  gopMode_ = input.readInt32();
                  gopModeCase_ = 8;
                  break;
                } // case 64
              case 74:
                {
                  input.readMessage(getGopDurationFieldBuilder().getBuilder(), extensionRegistry);
                  gopModeCase_ = 9;
                  break;
                } // case 74
              case 82:
                {
                  profile_ = input.readStringRequireUtf8();

                  break;
                } // case 82
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int gopModeCase_ = 0;
      private java.lang.Object gopMode_;

      public GopModeCase getGopModeCase() {
        return GopModeCase.forNumber(gopModeCase_);
      }

      public Builder clearGopMode() {
        gopModeCase_ = 0;
        gopMode_ = null;
        onChanged();
        return this;
      }

      private int widthPixels_;
      /**
       *
       *
       * <pre>
       * The width of the video in pixels. Must be an even integer.
       * When not specified, the width is adjusted to match the specified height
       * and input aspect ratio. If both are omitted, the input width is used.
       * </pre>
       *
       * <code>int32 width_pixels = 1;</code>
       *
       * @return The widthPixels.
       */
      @java.lang.Override
      public int getWidthPixels() {
        return widthPixels_;
      }
      /**
       *
       *
       * <pre>
       * The width of the video in pixels. Must be an even integer.
       * When not specified, the width is adjusted to match the specified height
       * and input aspect ratio. If both are omitted, the input width is used.
       * </pre>
       *
       * <code>int32 width_pixels = 1;</code>
       *
       * @param value The widthPixels to set.
       * @return This builder for chaining.
       */
      public Builder setWidthPixels(int value) {

        widthPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The width of the video in pixels. Must be an even integer.
       * When not specified, the width is adjusted to match the specified height
       * and input aspect ratio. If both are omitted, the input width is used.
       * </pre>
       *
       * <code>int32 width_pixels = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWidthPixels() {

        widthPixels_ = 0;
        onChanged();
        return this;
      }

      private int heightPixels_;
      /**
       *
       *
       * <pre>
       * The height of the video in pixels. Must be an even integer.
       * When not specified, the height is adjusted to match the specified width
       * and input aspect ratio. If both are omitted, the input height is used.
       * </pre>
       *
       * <code>int32 height_pixels = 2;</code>
       *
       * @return The heightPixels.
       */
      @java.lang.Override
      public int getHeightPixels() {
        return heightPixels_;
      }
      /**
       *
       *
       * <pre>
       * The height of the video in pixels. Must be an even integer.
       * When not specified, the height is adjusted to match the specified width
       * and input aspect ratio. If both are omitted, the input height is used.
       * </pre>
       *
       * <code>int32 height_pixels = 2;</code>
       *
       * @param value The heightPixels to set.
       * @return This builder for chaining.
       */
      public Builder setHeightPixels(int value) {

        heightPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The height of the video in pixels. Must be an even integer.
       * When not specified, the height is adjusted to match the specified width
       * and input aspect ratio. If both are omitted, the input height is used.
       * </pre>
       *
       * <code>int32 height_pixels = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHeightPixels() {

        heightPixels_ = 0;
        onChanged();
        return this;
      }

      private double frameRate_;
      /**
       *
       *
       * <pre>
       * Required. The target video frame rate in frames per second (FPS). Must be less than
       * or equal to 120. Will default to the input frame rate if larger than the
       * input frame rate. The API will generate an output FPS that is divisible
       * by the input FPS, and smaller or equal to the target FPS. See
       * [Calculating frame
       * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
       * more information.
       * </pre>
       *
       * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The frameRate.
       */
      @java.lang.Override
      public double getFrameRate() {
        return frameRate_;
      }
      /**
       *
       *
       * <pre>
       * Required. The target video frame rate in frames per second (FPS). Must be less than
       * or equal to 120. Will default to the input frame rate if larger than the
       * input frame rate. The API will generate an output FPS that is divisible
       * by the input FPS, and smaller or equal to the target FPS. See
       * [Calculating frame
       * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
       * more information.
       * </pre>
       *
       * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The frameRate to set.
       * @return This builder for chaining.
       */
      public Builder setFrameRate(double value) {

        frameRate_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The target video frame rate in frames per second (FPS). Must be less than
       * or equal to 120. Will default to the input frame rate if larger than the
       * input frame rate. The API will generate an output FPS that is divisible
       * by the input FPS, and smaller or equal to the target FPS. See
       * [Calculating frame
       * rate](https://cloud.google.com/transcoder/docs/concepts/frame-rate) for
       * more information.
       * </pre>
       *
       * <code>double frame_rate = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFrameRate() {

        frameRate_ = 0D;
        onChanged();
        return this;
      }

      private int bitrateBps_;
      /**
       *
       *
       * <pre>
       * Required. The video bitrate in bits per second. The minimum value is 1,000.
       * The maximum value is 480,000,000.
       * </pre>
       *
       * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bitrateBps.
       */
      @java.lang.Override
      public int getBitrateBps() {
        return bitrateBps_;
      }
      /**
       *
       *
       * <pre>
       * Required. The video bitrate in bits per second. The minimum value is 1,000.
       * The maximum value is 480,000,000.
       * </pre>
       *
       * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bitrateBps to set.
       * @return This builder for chaining.
       */
      public Builder setBitrateBps(int value) {

        bitrateBps_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The video bitrate in bits per second. The minimum value is 1,000.
       * The maximum value is 480,000,000.
       * </pre>
       *
       * <code>int32 bitrate_bps = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBitrateBps() {

        bitrateBps_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object pixelFormat_ = "";
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @return The pixelFormat.
       */
      public java.lang.String getPixelFormat() {
        java.lang.Object ref = pixelFormat_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pixelFormat_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @return The bytes for pixelFormat.
       */
      public com.google.protobuf.ByteString getPixelFormatBytes() {
        java.lang.Object ref = pixelFormat_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pixelFormat_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @param value The pixelFormat to set.
       * @return This builder for chaining.
       */
      public Builder setPixelFormat(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        pixelFormat_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPixelFormat() {

        pixelFormat_ = getDefaultInstance().getPixelFormat();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Pixel format to use. The default is `yuv420p`.
       * Supported pixel formats:
       * - `yuv420p` pixel format
       * - `yuv422p` pixel format
       * - `yuv444p` pixel format
       * - `yuv420p10` 10-bit HDR pixel format
       * - `yuv422p10` 10-bit HDR pixel format
       * - `yuv444p10` 10-bit HDR pixel format
       * - `yuv420p12` 12-bit HDR pixel format
       * - `yuv422p12` 12-bit HDR pixel format
       * - `yuv444p12` 12-bit HDR pixel format
       * </pre>
       *
       * <code>string pixel_format = 5;</code>
       *
       * @param value The bytes for pixelFormat to set.
       * @return This builder for chaining.
       */
      public Builder setPixelFormatBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        pixelFormat_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object rateControlMode_ = "";
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @return The rateControlMode.
       */
      public java.lang.String getRateControlMode() {
        java.lang.Object ref = rateControlMode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          rateControlMode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @return The bytes for rateControlMode.
       */
      public com.google.protobuf.ByteString getRateControlModeBytes() {
        java.lang.Object ref = rateControlMode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          rateControlMode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @param value The rateControlMode to set.
       * @return This builder for chaining.
       */
      public Builder setRateControlMode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        rateControlMode_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRateControlMode() {

        rateControlMode_ = getDefaultInstance().getRateControlMode();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify the `rate_control_mode`. The default is `vbr`.
       * Supported rate control modes:
       * - `vbr` - variable bitrate
       * </pre>
       *
       * <code>string rate_control_mode = 6;</code>
       *
       * @param value The bytes for rateControlMode to set.
       * @return This builder for chaining.
       */
      public Builder setRateControlModeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        rateControlMode_ = value;
        onChanged();
        return this;
      }

      private int crfLevel_;
      /**
       *
       *
       * <pre>
       * Target CRF level. Must be between 10 and 36, where 10 is the highest
       * quality and 36 is the most efficient compression. The default is 21.
       * **Note:** This field is not supported.
       * </pre>
       *
       * <code>int32 crf_level = 7;</code>
       *
       * @return The crfLevel.
       */
      @java.lang.Override
      public int getCrfLevel() {
        return crfLevel_;
      }
      /**
       *
       *
       * <pre>
       * Target CRF level. Must be between 10 and 36, where 10 is the highest
       * quality and 36 is the most efficient compression. The default is 21.
       * **Note:** This field is not supported.
       * </pre>
       *
       * <code>int32 crf_level = 7;</code>
       *
       * @param value The crfLevel to set.
       * @return This builder for chaining.
       */
      public Builder setCrfLevel(int value) {

        crfLevel_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Target CRF level. Must be between 10 and 36, where 10 is the highest
       * quality and 36 is the most efficient compression. The default is 21.
       * **Note:** This field is not supported.
       * </pre>
       *
       * <code>int32 crf_level = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCrfLevel() {

        crfLevel_ = 0;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified frame count. Must be greater
       * than zero.
       * </pre>
       *
       * <code>int32 gop_frame_count = 8;</code>
       *
       * @return Whether the gopFrameCount field is set.
       */
      public boolean hasGopFrameCount() {
        return gopModeCase_ == 8;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified frame count. Must be greater
       * than zero.
       * </pre>
       *
       * <code>int32 gop_frame_count = 8;</code>
       *
       * @return The gopFrameCount.
       */
      public int getGopFrameCount() {
        if (gopModeCase_ == 8) {
          return (java.lang.Integer) gopMode_;
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified frame count. Must be greater
       * than zero.
       * </pre>
       *
       * <code>int32 gop_frame_count = 8;</code>
       *
       * @param value The gopFrameCount to set.
       * @return This builder for chaining.
       */
      public Builder setGopFrameCount(int value) {
        gopModeCase_ = 8;
        gopMode_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified frame count. Must be greater
       * than zero.
       * </pre>
       *
       * <code>int32 gop_frame_count = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGopFrameCount() {
        if (gopModeCase_ == 8) {
          gopModeCase_ = 0;
          gopMode_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          gopDurationBuilder_;
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 9;</code>
       *
       * @return Whether the gopDuration field is set.
       */
      @java.lang.Override
      public boolean hasGopDuration() {
        return gopModeCase_ == 9;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 9;</code>
       *
       * @return The gopDuration.
       */
      @java.lang.Override
      public com.google.protobuf.Duration getGopDuration() {
        if (gopDurationBuilder_ == null) {
          if (gopModeCase_ == 9) {
            return (com.google.protobuf.Duration) gopMode_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        } else {
          if (gopModeCase_ == 9) {
            return gopDurationBuilder_.getMessage();
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 9;</code>
       */
      public Builder setGopDuration(com.google.protobuf.Duration value) {
        if (gopDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          gopMode_ = value;
          onChanged();
        } else {
          gopDurationBuilder_.setMessage(value);
        }
        gopModeCase_ = 9;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 9;</code>
       */
      public Builder setGopDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (gopDurationBuilder_ == null) {
          gopMode_ = builderForValue.build();
          onChanged();
        } else {
          gopDurationBuilder_.setMessage(builderForValue.build());
        }
        gopModeCase_ = 9;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 9;</code>
       */
      public Builder mergeGopDuration(com.google.protobuf.Duration value) {
        if (gopDurationBuilder_ == null) {
          if (gopModeCase_ == 9 && gopMode_ != com.google.protobuf.Duration.getDefaultInstance()) {
            gopMode_ =
                com.google.protobuf.Duration.newBuilder((com.google.protobuf.Duration) gopMode_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            gopMode_ = value;
          }
          onChanged();
        } else {
          if (gopModeCase_ == 9) {
            gopDurationBuilder_.mergeFrom(value);
          } else {
            gopDurationBuilder_.setMessage(value);
          }
        }
        gopModeCase_ = 9;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 9;</code>
       */
      public Builder clearGopDuration() {
        if (gopDurationBuilder_ == null) {
          if (gopModeCase_ == 9) {
            gopModeCase_ = 0;
            gopMode_ = null;
            onChanged();
          }
        } else {
          if (gopModeCase_ == 9) {
            gopModeCase_ = 0;
            gopMode_ = null;
          }
          gopDurationBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 9;</code>
       */
      public com.google.protobuf.Duration.Builder getGopDurationBuilder() {
        return getGopDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 9;</code>
       */
      @java.lang.Override
      public com.google.protobuf.DurationOrBuilder getGopDurationOrBuilder() {
        if ((gopModeCase_ == 9) && (gopDurationBuilder_ != null)) {
          return gopDurationBuilder_.getMessageOrBuilder();
        } else {
          if (gopModeCase_ == 9) {
            return (com.google.protobuf.Duration) gopMode_;
          }
          return com.google.protobuf.Duration.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Select the GOP size based on the specified duration. The default is
       * `3s`. Note that `gopDuration` must be less than or equal to
       * [`segmentDuration`](#SegmentSettings), and
       * [`segmentDuration`](#SegmentSettings) must be divisible by
       * `gopDuration`.
       * </pre>
       *
       * <code>.google.protobuf.Duration gop_duration = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getGopDurationFieldBuilder() {
        if (gopDurationBuilder_ == null) {
          if (!(gopModeCase_ == 9)) {
            gopMode_ = com.google.protobuf.Duration.getDefaultInstance();
          }
          gopDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  (com.google.protobuf.Duration) gopMode_, getParentForChildren(), isClean());
          gopMode_ = null;
        }
        gopModeCase_ = 9;
        onChanged();
        ;
        return gopDurationBuilder_;
      }

      private java.lang.Object profile_ = "";
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   `profile0` (default)
       * *   `profile1`
       * *   `profile2`
       * *   `profile3`
       * The available options are
       * [WebM-compatible](https://www.webmproject.org/vp9/profiles/).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `Vp9CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 10;</code>
       *
       * @return The profile.
       */
      public java.lang.String getProfile() {
        java.lang.Object ref = profile_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          profile_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   `profile0` (default)
       * *   `profile1`
       * *   `profile2`
       * *   `profile3`
       * The available options are
       * [WebM-compatible](https://www.webmproject.org/vp9/profiles/).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `Vp9CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 10;</code>
       *
       * @return The bytes for profile.
       */
      public com.google.protobuf.ByteString getProfileBytes() {
        java.lang.Object ref = profile_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          profile_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   `profile0` (default)
       * *   `profile1`
       * *   `profile2`
       * *   `profile3`
       * The available options are
       * [WebM-compatible](https://www.webmproject.org/vp9/profiles/).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `Vp9CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 10;</code>
       *
       * @param value The profile to set.
       * @return This builder for chaining.
       */
      public Builder setProfile(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        profile_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   `profile0` (default)
       * *   `profile1`
       * *   `profile2`
       * *   `profile3`
       * The available options are
       * [WebM-compatible](https://www.webmproject.org/vp9/profiles/).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `Vp9CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProfile() {

        profile_ = getDefaultInstance().getProfile();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enforces the specified codec profile. The following profiles are
       * supported:
       * *   `profile0` (default)
       * *   `profile1`
       * *   `profile2`
       * *   `profile3`
       * The available options are
       * [WebM-compatible](https://www.webmproject.org/vp9/profiles/).
       * Note that certain values for this field may cause the
       * transcoder to override other fields you set in the `Vp9CodecSettings`
       * message.
       * </pre>
       *
       * <code>string profile = 10;</code>
       *
       * @param value The bytes for profile to set.
       * @return This builder for chaining.
       */
      public Builder setProfileBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        profile_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings)
    private static final com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings();
    }

    public static com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Vp9CodecSettings> PARSER =
        new com.google.protobuf.AbstractParser<Vp9CodecSettings>() {
          @java.lang.Override
          public Vp9CodecSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Vp9CodecSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Vp9CodecSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int codecSettingsCase_ = 0;
  private java.lang.Object codecSettings_;

  public enum CodecSettingsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    H264(1),
    H265(2),
    VP9(3),
    CODECSETTINGS_NOT_SET(0);
    private final int value;

    private CodecSettingsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CodecSettingsCase valueOf(int value) {
      return forNumber(value);
    }

    public static CodecSettingsCase forNumber(int value) {
      switch (value) {
        case 1:
          return H264;
        case 2:
          return H265;
        case 3:
          return VP9;
        case 0:
          return CODECSETTINGS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public CodecSettingsCase getCodecSettingsCase() {
    return CodecSettingsCase.forNumber(codecSettingsCase_);
  }

  public static final int H264_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * H264 codec settings.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings h264 = 1;</code>
   *
   * @return Whether the h264 field is set.
   */
  @java.lang.Override
  public boolean hasH264() {
    return codecSettingsCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * H264 codec settings.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings h264 = 1;</code>
   *
   * @return The h264.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings getH264() {
    if (codecSettingsCase_ == 1) {
      return (com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings) codecSettings_;
    }
    return com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * H264 codec settings.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings h264 = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettingsOrBuilder
      getH264OrBuilder() {
    if (codecSettingsCase_ == 1) {
      return (com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings) codecSettings_;
    }
    return com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.getDefaultInstance();
  }

  public static final int H265_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * H265 codec settings.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings h265 = 2;</code>
   *
   * @return Whether the h265 field is set.
   */
  @java.lang.Override
  public boolean hasH265() {
    return codecSettingsCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * H265 codec settings.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings h265 = 2;</code>
   *
   * @return The h265.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings getH265() {
    if (codecSettingsCase_ == 2) {
      return (com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings) codecSettings_;
    }
    return com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * H265 codec settings.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings h265 = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettingsOrBuilder
      getH265OrBuilder() {
    if (codecSettingsCase_ == 2) {
      return (com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings) codecSettings_;
    }
    return com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.getDefaultInstance();
  }

  public static final int VP9_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * VP9 codec settings.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings vp9 = 3;</code>
   *
   * @return Whether the vp9 field is set.
   */
  @java.lang.Override
  public boolean hasVp9() {
    return codecSettingsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * VP9 codec settings.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings vp9 = 3;</code>
   *
   * @return The vp9.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings getVp9() {
    if (codecSettingsCase_ == 3) {
      return (com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings) codecSettings_;
    }
    return com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * VP9 codec settings.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings vp9 = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettingsOrBuilder
      getVp9OrBuilder() {
    if (codecSettingsCase_ == 3) {
      return (com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings) codecSettings_;
    }
    return com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (codecSettingsCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings) codecSettings_);
    }
    if (codecSettingsCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings) codecSettings_);
    }
    if (codecSettingsCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings) codecSettings_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (codecSettingsCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings) codecSettings_);
    }
    if (codecSettingsCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings) codecSettings_);
    }
    if (codecSettingsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings) codecSettings_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.video.transcoder.v1.VideoStream)) {
      return super.equals(obj);
    }
    com.google.cloud.video.transcoder.v1.VideoStream other =
        (com.google.cloud.video.transcoder.v1.VideoStream) obj;

    if (!getCodecSettingsCase().equals(other.getCodecSettingsCase())) return false;
    switch (codecSettingsCase_) {
      case 1:
        if (!getH264().equals(other.getH264())) return false;
        break;
      case 2:
        if (!getH265().equals(other.getH265())) return false;
        break;
      case 3:
        if (!getVp9().equals(other.getVp9())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (codecSettingsCase_) {
      case 1:
        hash = (37 * hash) + H264_FIELD_NUMBER;
        hash = (53 * hash) + getH264().hashCode();
        break;
      case 2:
        hash = (37 * hash) + H265_FIELD_NUMBER;
        hash = (53 * hash) + getH265().hashCode();
        break;
      case 3:
        hash = (37 * hash) + VP9_FIELD_NUMBER;
        hash = (53 * hash) + getVp9().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.video.transcoder.v1.VideoStream prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Video stream resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.VideoStream}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.VideoStream)
      com.google.cloud.video.transcoder.v1.VideoStreamOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_VideoStream_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_VideoStream_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.VideoStream.class,
              com.google.cloud.video.transcoder.v1.VideoStream.Builder.class);
    }

    // Construct using com.google.cloud.video.transcoder.v1.VideoStream.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (h264Builder_ != null) {
        h264Builder_.clear();
      }
      if (h265Builder_ != null) {
        h265Builder_.clear();
      }
      if (vp9Builder_ != null) {
        vp9Builder_.clear();
      }
      codecSettingsCase_ = 0;
      codecSettings_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_VideoStream_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream getDefaultInstanceForType() {
      return com.google.cloud.video.transcoder.v1.VideoStream.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream build() {
      com.google.cloud.video.transcoder.v1.VideoStream result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream buildPartial() {
      com.google.cloud.video.transcoder.v1.VideoStream result =
          new com.google.cloud.video.transcoder.v1.VideoStream(this);
      if (codecSettingsCase_ == 1) {
        if (h264Builder_ == null) {
          result.codecSettings_ = codecSettings_;
        } else {
          result.codecSettings_ = h264Builder_.build();
        }
      }
      if (codecSettingsCase_ == 2) {
        if (h265Builder_ == null) {
          result.codecSettings_ = codecSettings_;
        } else {
          result.codecSettings_ = h265Builder_.build();
        }
      }
      if (codecSettingsCase_ == 3) {
        if (vp9Builder_ == null) {
          result.codecSettings_ = codecSettings_;
        } else {
          result.codecSettings_ = vp9Builder_.build();
        }
      }
      result.codecSettingsCase_ = codecSettingsCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.video.transcoder.v1.VideoStream) {
        return mergeFrom((com.google.cloud.video.transcoder.v1.VideoStream) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.video.transcoder.v1.VideoStream other) {
      if (other == com.google.cloud.video.transcoder.v1.VideoStream.getDefaultInstance())
        return this;
      switch (other.getCodecSettingsCase()) {
        case H264:
          {
            mergeH264(other.getH264());
            break;
          }
        case H265:
          {
            mergeH265(other.getH265());
            break;
          }
        case VP9:
          {
            mergeVp9(other.getVp9());
            break;
          }
        case CODECSETTINGS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getH264FieldBuilder().getBuilder(), extensionRegistry);
                codecSettingsCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getH265FieldBuilder().getBuilder(), extensionRegistry);
                codecSettingsCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getVp9FieldBuilder().getBuilder(), extensionRegistry);
                codecSettingsCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int codecSettingsCase_ = 0;
    private java.lang.Object codecSettings_;

    public CodecSettingsCase getCodecSettingsCase() {
      return CodecSettingsCase.forNumber(codecSettingsCase_);
    }

    public Builder clearCodecSettings() {
      codecSettingsCase_ = 0;
      codecSettings_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings,
            com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.Builder,
            com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettingsOrBuilder>
        h264Builder_;
    /**
     *
     *
     * <pre>
     * H264 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings h264 = 1;</code>
     *
     * @return Whether the h264 field is set.
     */
    @java.lang.Override
    public boolean hasH264() {
      return codecSettingsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * H264 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings h264 = 1;</code>
     *
     * @return The h264.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings getH264() {
      if (h264Builder_ == null) {
        if (codecSettingsCase_ == 1) {
          return (com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings)
              codecSettings_;
        }
        return com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
            .getDefaultInstance();
      } else {
        if (codecSettingsCase_ == 1) {
          return h264Builder_.getMessage();
        }
        return com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * H264 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings h264 = 1;</code>
     */
    public Builder setH264(
        com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings value) {
      if (h264Builder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        codecSettings_ = value;
        onChanged();
      } else {
        h264Builder_.setMessage(value);
      }
      codecSettingsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * H264 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings h264 = 1;</code>
     */
    public Builder setH264(
        com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.Builder
            builderForValue) {
      if (h264Builder_ == null) {
        codecSettings_ = builderForValue.build();
        onChanged();
      } else {
        h264Builder_.setMessage(builderForValue.build());
      }
      codecSettingsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * H264 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings h264 = 1;</code>
     */
    public Builder mergeH264(
        com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings value) {
      if (h264Builder_ == null) {
        if (codecSettingsCase_ == 1
            && codecSettings_
                != com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
                    .getDefaultInstance()) {
          codecSettings_ =
              com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.newBuilder(
                      (com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings)
                          codecSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          codecSettings_ = value;
        }
        onChanged();
      } else {
        if (codecSettingsCase_ == 1) {
          h264Builder_.mergeFrom(value);
        } else {
          h264Builder_.setMessage(value);
        }
      }
      codecSettingsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * H264 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings h264 = 1;</code>
     */
    public Builder clearH264() {
      if (h264Builder_ == null) {
        if (codecSettingsCase_ == 1) {
          codecSettingsCase_ = 0;
          codecSettings_ = null;
          onChanged();
        }
      } else {
        if (codecSettingsCase_ == 1) {
          codecSettingsCase_ = 0;
          codecSettings_ = null;
        }
        h264Builder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * H264 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings h264 = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.Builder
        getH264Builder() {
      return getH264FieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * H264 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings h264 = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettingsOrBuilder
        getH264OrBuilder() {
      if ((codecSettingsCase_ == 1) && (h264Builder_ != null)) {
        return h264Builder_.getMessageOrBuilder();
      } else {
        if (codecSettingsCase_ == 1) {
          return (com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings)
              codecSettings_;
        }
        return com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * H264 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings h264 = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings,
            com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.Builder,
            com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettingsOrBuilder>
        getH264FieldBuilder() {
      if (h264Builder_ == null) {
        if (!(codecSettingsCase_ == 1)) {
          codecSettings_ =
              com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings
                  .getDefaultInstance();
        }
        h264Builder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings,
                com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings.Builder,
                com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettingsOrBuilder>(
                (com.google.cloud.video.transcoder.v1.VideoStream.H264CodecSettings) codecSettings_,
                getParentForChildren(),
                isClean());
        codecSettings_ = null;
      }
      codecSettingsCase_ = 1;
      onChanged();
      ;
      return h264Builder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings,
            com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.Builder,
            com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettingsOrBuilder>
        h265Builder_;
    /**
     *
     *
     * <pre>
     * H265 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings h265 = 2;</code>
     *
     * @return Whether the h265 field is set.
     */
    @java.lang.Override
    public boolean hasH265() {
      return codecSettingsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * H265 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings h265 = 2;</code>
     *
     * @return The h265.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings getH265() {
      if (h265Builder_ == null) {
        if (codecSettingsCase_ == 2) {
          return (com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings)
              codecSettings_;
        }
        return com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
            .getDefaultInstance();
      } else {
        if (codecSettingsCase_ == 2) {
          return h265Builder_.getMessage();
        }
        return com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * H265 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings h265 = 2;</code>
     */
    public Builder setH265(
        com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings value) {
      if (h265Builder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        codecSettings_ = value;
        onChanged();
      } else {
        h265Builder_.setMessage(value);
      }
      codecSettingsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * H265 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings h265 = 2;</code>
     */
    public Builder setH265(
        com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.Builder
            builderForValue) {
      if (h265Builder_ == null) {
        codecSettings_ = builderForValue.build();
        onChanged();
      } else {
        h265Builder_.setMessage(builderForValue.build());
      }
      codecSettingsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * H265 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings h265 = 2;</code>
     */
    public Builder mergeH265(
        com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings value) {
      if (h265Builder_ == null) {
        if (codecSettingsCase_ == 2
            && codecSettings_
                != com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
                    .getDefaultInstance()) {
          codecSettings_ =
              com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.newBuilder(
                      (com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings)
                          codecSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          codecSettings_ = value;
        }
        onChanged();
      } else {
        if (codecSettingsCase_ == 2) {
          h265Builder_.mergeFrom(value);
        } else {
          h265Builder_.setMessage(value);
        }
      }
      codecSettingsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * H265 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings h265 = 2;</code>
     */
    public Builder clearH265() {
      if (h265Builder_ == null) {
        if (codecSettingsCase_ == 2) {
          codecSettingsCase_ = 0;
          codecSettings_ = null;
          onChanged();
        }
      } else {
        if (codecSettingsCase_ == 2) {
          codecSettingsCase_ = 0;
          codecSettings_ = null;
        }
        h265Builder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * H265 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings h265 = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.Builder
        getH265Builder() {
      return getH265FieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * H265 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings h265 = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettingsOrBuilder
        getH265OrBuilder() {
      if ((codecSettingsCase_ == 2) && (h265Builder_ != null)) {
        return h265Builder_.getMessageOrBuilder();
      } else {
        if (codecSettingsCase_ == 2) {
          return (com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings)
              codecSettings_;
        }
        return com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * H265 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings h265 = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings,
            com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.Builder,
            com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettingsOrBuilder>
        getH265FieldBuilder() {
      if (h265Builder_ == null) {
        if (!(codecSettingsCase_ == 2)) {
          codecSettings_ =
              com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings
                  .getDefaultInstance();
        }
        h265Builder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings,
                com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings.Builder,
                com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettingsOrBuilder>(
                (com.google.cloud.video.transcoder.v1.VideoStream.H265CodecSettings) codecSettings_,
                getParentForChildren(),
                isClean());
        codecSettings_ = null;
      }
      codecSettingsCase_ = 2;
      onChanged();
      ;
      return h265Builder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings,
            com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.Builder,
            com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettingsOrBuilder>
        vp9Builder_;
    /**
     *
     *
     * <pre>
     * VP9 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings vp9 = 3;</code>
     *
     * @return Whether the vp9 field is set.
     */
    @java.lang.Override
    public boolean hasVp9() {
      return codecSettingsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * VP9 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings vp9 = 3;</code>
     *
     * @return The vp9.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings getVp9() {
      if (vp9Builder_ == null) {
        if (codecSettingsCase_ == 3) {
          return (com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings) codecSettings_;
        }
        return com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
            .getDefaultInstance();
      } else {
        if (codecSettingsCase_ == 3) {
          return vp9Builder_.getMessage();
        }
        return com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * VP9 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings vp9 = 3;</code>
     */
    public Builder setVp9(com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings value) {
      if (vp9Builder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        codecSettings_ = value;
        onChanged();
      } else {
        vp9Builder_.setMessage(value);
      }
      codecSettingsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * VP9 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings vp9 = 3;</code>
     */
    public Builder setVp9(
        com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.Builder builderForValue) {
      if (vp9Builder_ == null) {
        codecSettings_ = builderForValue.build();
        onChanged();
      } else {
        vp9Builder_.setMessage(builderForValue.build());
      }
      codecSettingsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * VP9 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings vp9 = 3;</code>
     */
    public Builder mergeVp9(
        com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings value) {
      if (vp9Builder_ == null) {
        if (codecSettingsCase_ == 3
            && codecSettings_
                != com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
                    .getDefaultInstance()) {
          codecSettings_ =
              com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.newBuilder(
                      (com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings)
                          codecSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          codecSettings_ = value;
        }
        onChanged();
      } else {
        if (codecSettingsCase_ == 3) {
          vp9Builder_.mergeFrom(value);
        } else {
          vp9Builder_.setMessage(value);
        }
      }
      codecSettingsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * VP9 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings vp9 = 3;</code>
     */
    public Builder clearVp9() {
      if (vp9Builder_ == null) {
        if (codecSettingsCase_ == 3) {
          codecSettingsCase_ = 0;
          codecSettings_ = null;
          onChanged();
        }
      } else {
        if (codecSettingsCase_ == 3) {
          codecSettingsCase_ = 0;
          codecSettings_ = null;
        }
        vp9Builder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * VP9 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings vp9 = 3;</code>
     */
    public com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.Builder
        getVp9Builder() {
      return getVp9FieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * VP9 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings vp9 = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettingsOrBuilder
        getVp9OrBuilder() {
      if ((codecSettingsCase_ == 3) && (vp9Builder_ != null)) {
        return vp9Builder_.getMessageOrBuilder();
      } else {
        if (codecSettingsCase_ == 3) {
          return (com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings) codecSettings_;
        }
        return com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * VP9 codec settings.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings vp9 = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings,
            com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.Builder,
            com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettingsOrBuilder>
        getVp9FieldBuilder() {
      if (vp9Builder_ == null) {
        if (!(codecSettingsCase_ == 3)) {
          codecSettings_ =
              com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings
                  .getDefaultInstance();
        }
        vp9Builder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings,
                com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings.Builder,
                com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettingsOrBuilder>(
                (com.google.cloud.video.transcoder.v1.VideoStream.Vp9CodecSettings) codecSettings_,
                getParentForChildren(),
                isClean());
        codecSettings_ = null;
      }
      codecSettingsCase_ = 3;
      onChanged();
      ;
      return vp9Builder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.VideoStream)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.VideoStream)
  private static final com.google.cloud.video.transcoder.v1.VideoStream DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.VideoStream();
  }

  public static com.google.cloud.video.transcoder.v1.VideoStream getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VideoStream> PARSER =
      new com.google.protobuf.AbstractParser<VideoStream>() {
        @java.lang.Override
        public VideoStream parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VideoStream> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VideoStream> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.VideoStream getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
