/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/video/transcoder/v1/resources.proto

package com.google.cloud.video.transcoder.v1;

/**
 *
 *
 * <pre>
 * Encoding of a text stream. For example, closed captions or subtitles.
 * </pre>
 *
 * Protobuf type {@code google.cloud.video.transcoder.v1.TextStream}
 */
public final class TextStream extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.TextStream)
    TextStreamOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TextStream.newBuilder() to construct.
  private TextStream(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TextStream() {
    codec_ = "";
    mapping_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TextStream();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_TextStream_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_TextStream_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.video.transcoder.v1.TextStream.class,
            com.google.cloud.video.transcoder.v1.TextStream.Builder.class);
  }

  public interface TextMappingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.TextStream.TextMapping)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The `EditAtom.key` that references atom with text inputs in the
     * `Job.edit_list`.
     * </pre>
     *
     * <code>string atom_key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The atomKey.
     */
    java.lang.String getAtomKey();
    /**
     *
     *
     * <pre>
     * Required. The `EditAtom.key` that references atom with text inputs in the
     * `Job.edit_list`.
     * </pre>
     *
     * <code>string atom_key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for atomKey.
     */
    com.google.protobuf.ByteString getAtomKeyBytes();

    /**
     *
     *
     * <pre>
     * Required. The `Input.key` that identifies the input file.
     * </pre>
     *
     * <code>string input_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The inputKey.
     */
    java.lang.String getInputKey();
    /**
     *
     *
     * <pre>
     * Required. The `Input.key` that identifies the input file.
     * </pre>
     *
     * <code>string input_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for inputKey.
     */
    com.google.protobuf.ByteString getInputKeyBytes();

    /**
     *
     *
     * <pre>
     * Required. The zero-based index of the track in the input file.
     * </pre>
     *
     * <code>int32 input_track = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The inputTrack.
     */
    int getInputTrack();
  }
  /**
   *
   *
   * <pre>
   * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.TextStream.TextMapping}
   */
  public static final class TextMapping extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.TextStream.TextMapping)
      TextMappingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TextMapping.newBuilder() to construct.
    private TextMapping(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TextMapping() {
      atomKey_ = "";
      inputKey_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TextMapping();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_TextStream_TextMapping_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_TextStream_TextMapping_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.TextStream.TextMapping.class,
              com.google.cloud.video.transcoder.v1.TextStream.TextMapping.Builder.class);
    }

    public static final int ATOM_KEY_FIELD_NUMBER = 1;
    private volatile java.lang.Object atomKey_;
    /**
     *
     *
     * <pre>
     * Required. The `EditAtom.key` that references atom with text inputs in the
     * `Job.edit_list`.
     * </pre>
     *
     * <code>string atom_key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The atomKey.
     */
    @java.lang.Override
    public java.lang.String getAtomKey() {
      java.lang.Object ref = atomKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        atomKey_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `EditAtom.key` that references atom with text inputs in the
     * `Job.edit_list`.
     * </pre>
     *
     * <code>string atom_key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for atomKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAtomKeyBytes() {
      java.lang.Object ref = atomKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        atomKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INPUT_KEY_FIELD_NUMBER = 2;
    private volatile java.lang.Object inputKey_;
    /**
     *
     *
     * <pre>
     * Required. The `Input.key` that identifies the input file.
     * </pre>
     *
     * <code>string input_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The inputKey.
     */
    @java.lang.Override
    public java.lang.String getInputKey() {
      java.lang.Object ref = inputKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputKey_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `Input.key` that identifies the input file.
     * </pre>
     *
     * <code>string input_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for inputKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInputKeyBytes() {
      java.lang.Object ref = inputKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INPUT_TRACK_FIELD_NUMBER = 3;
    private int inputTrack_;
    /**
     *
     *
     * <pre>
     * Required. The zero-based index of the track in the input file.
     * </pre>
     *
     * <code>int32 input_track = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The inputTrack.
     */
    @java.lang.Override
    public int getInputTrack() {
      return inputTrack_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(atomKey_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, atomKey_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputKey_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, inputKey_);
      }
      if (inputTrack_ != 0) {
        output.writeInt32(3, inputTrack_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(atomKey_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, atomKey_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputKey_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, inputKey_);
      }
      if (inputTrack_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, inputTrack_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.TextStream.TextMapping)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.TextStream.TextMapping other =
          (com.google.cloud.video.transcoder.v1.TextStream.TextMapping) obj;

      if (!getAtomKey().equals(other.getAtomKey())) return false;
      if (!getInputKey().equals(other.getInputKey())) return false;
      if (getInputTrack() != other.getInputTrack()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ATOM_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getAtomKey().hashCode();
      hash = (37 * hash) + INPUT_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getInputKey().hashCode();
      hash = (37 * hash) + INPUT_TRACK_FIELD_NUMBER;
      hash = (53 * hash) + getInputTrack();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.TextStream.TextMapping prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.TextStream.TextMapping}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.TextStream.TextMapping)
        com.google.cloud.video.transcoder.v1.TextStream.TextMappingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_TextStream_TextMapping_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_TextStream_TextMapping_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.TextStream.TextMapping.class,
                com.google.cloud.video.transcoder.v1.TextStream.TextMapping.Builder.class);
      }

      // Construct using com.google.cloud.video.transcoder.v1.TextStream.TextMapping.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        atomKey_ = "";

        inputKey_ = "";

        inputTrack_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_TextStream_TextMapping_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.TextStream.TextMapping
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.TextStream.TextMapping.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.TextStream.TextMapping build() {
        com.google.cloud.video.transcoder.v1.TextStream.TextMapping result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.TextStream.TextMapping buildPartial() {
        com.google.cloud.video.transcoder.v1.TextStream.TextMapping result =
            new com.google.cloud.video.transcoder.v1.TextStream.TextMapping(this);
        result.atomKey_ = atomKey_;
        result.inputKey_ = inputKey_;
        result.inputTrack_ = inputTrack_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.TextStream.TextMapping) {
          return mergeFrom((com.google.cloud.video.transcoder.v1.TextStream.TextMapping) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.video.transcoder.v1.TextStream.TextMapping other) {
        if (other
            == com.google.cloud.video.transcoder.v1.TextStream.TextMapping.getDefaultInstance())
          return this;
        if (!other.getAtomKey().isEmpty()) {
          atomKey_ = other.atomKey_;
          onChanged();
        }
        if (!other.getInputKey().isEmpty()) {
          inputKey_ = other.inputKey_;
          onChanged();
        }
        if (other.getInputTrack() != 0) {
          setInputTrack(other.getInputTrack());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  atomKey_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  inputKey_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 24:
                {
                  inputTrack_ = input.readInt32();

                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object atomKey_ = "";
      /**
       *
       *
       * <pre>
       * Required. The `EditAtom.key` that references atom with text inputs in the
       * `Job.edit_list`.
       * </pre>
       *
       * <code>string atom_key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The atomKey.
       */
      public java.lang.String getAtomKey() {
        java.lang.Object ref = atomKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          atomKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The `EditAtom.key` that references atom with text inputs in the
       * `Job.edit_list`.
       * </pre>
       *
       * <code>string atom_key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for atomKey.
       */
      public com.google.protobuf.ByteString getAtomKeyBytes() {
        java.lang.Object ref = atomKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          atomKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The `EditAtom.key` that references atom with text inputs in the
       * `Job.edit_list`.
       * </pre>
       *
       * <code>string atom_key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The atomKey to set.
       * @return This builder for chaining.
       */
      public Builder setAtomKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        atomKey_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The `EditAtom.key` that references atom with text inputs in the
       * `Job.edit_list`.
       * </pre>
       *
       * <code>string atom_key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAtomKey() {

        atomKey_ = getDefaultInstance().getAtomKey();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The `EditAtom.key` that references atom with text inputs in the
       * `Job.edit_list`.
       * </pre>
       *
       * <code>string atom_key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for atomKey to set.
       * @return This builder for chaining.
       */
      public Builder setAtomKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        atomKey_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object inputKey_ = "";
      /**
       *
       *
       * <pre>
       * Required. The `Input.key` that identifies the input file.
       * </pre>
       *
       * <code>string input_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The inputKey.
       */
      public java.lang.String getInputKey() {
        java.lang.Object ref = inputKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          inputKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The `Input.key` that identifies the input file.
       * </pre>
       *
       * <code>string input_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for inputKey.
       */
      public com.google.protobuf.ByteString getInputKeyBytes() {
        java.lang.Object ref = inputKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          inputKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The `Input.key` that identifies the input file.
       * </pre>
       *
       * <code>string input_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The inputKey to set.
       * @return This builder for chaining.
       */
      public Builder setInputKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        inputKey_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The `Input.key` that identifies the input file.
       * </pre>
       *
       * <code>string input_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInputKey() {

        inputKey_ = getDefaultInstance().getInputKey();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The `Input.key` that identifies the input file.
       * </pre>
       *
       * <code>string input_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for inputKey to set.
       * @return This builder for chaining.
       */
      public Builder setInputKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        inputKey_ = value;
        onChanged();
        return this;
      }

      private int inputTrack_;
      /**
       *
       *
       * <pre>
       * Required. The zero-based index of the track in the input file.
       * </pre>
       *
       * <code>int32 input_track = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The inputTrack.
       */
      @java.lang.Override
      public int getInputTrack() {
        return inputTrack_;
      }
      /**
       *
       *
       * <pre>
       * Required. The zero-based index of the track in the input file.
       * </pre>
       *
       * <code>int32 input_track = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The inputTrack to set.
       * @return This builder for chaining.
       */
      public Builder setInputTrack(int value) {

        inputTrack_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The zero-based index of the track in the input file.
       * </pre>
       *
       * <code>int32 input_track = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInputTrack() {

        inputTrack_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.TextStream.TextMapping)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.TextStream.TextMapping)
    private static final com.google.cloud.video.transcoder.v1.TextStream.TextMapping
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.TextStream.TextMapping();
    }

    public static com.google.cloud.video.transcoder.v1.TextStream.TextMapping getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TextMapping> PARSER =
        new com.google.protobuf.AbstractParser<TextMapping>() {
          @java.lang.Override
          public TextMapping parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TextMapping> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TextMapping> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.TextStream.TextMapping getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CODEC_FIELD_NUMBER = 1;
  private volatile java.lang.Object codec_;
  /**
   *
   *
   * <pre>
   * The codec for this text stream. The default is `webvtt`.
   * Supported text codecs:
   * - `srt`
   * - `ttml`
   * - `cea608`
   * - `cea708`
   * - `webvtt`
   * </pre>
   *
   * <code>string codec = 1;</code>
   *
   * @return The codec.
   */
  @java.lang.Override
  public java.lang.String getCodec() {
    java.lang.Object ref = codec_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      codec_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The codec for this text stream. The default is `webvtt`.
   * Supported text codecs:
   * - `srt`
   * - `ttml`
   * - `cea608`
   * - `cea708`
   * - `webvtt`
   * </pre>
   *
   * <code>string codec = 1;</code>
   *
   * @return The bytes for codec.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCodecBytes() {
    java.lang.Object ref = codec_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      codec_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAPPING_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.video.transcoder.v1.TextStream.TextMapping> mapping_;
  /**
   *
   *
   * <pre>
   * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.video.transcoder.v1.TextStream.TextMapping>
      getMappingList() {
    return mapping_;
  }
  /**
   *
   *
   * <pre>
   * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.video.transcoder.v1.TextStream.TextMappingOrBuilder>
      getMappingOrBuilderList() {
    return mapping_;
  }
  /**
   *
   *
   * <pre>
   * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
   */
  @java.lang.Override
  public int getMappingCount() {
    return mapping_.size();
  }
  /**
   *
   *
   * <pre>
   * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.TextStream.TextMapping getMapping(int index) {
    return mapping_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.TextStream.TextMappingOrBuilder getMappingOrBuilder(
      int index) {
    return mapping_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(codec_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, codec_);
    }
    for (int i = 0; i < mapping_.size(); i++) {
      output.writeMessage(3, mapping_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(codec_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, codec_);
    }
    for (int i = 0; i < mapping_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, mapping_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.video.transcoder.v1.TextStream)) {
      return super.equals(obj);
    }
    com.google.cloud.video.transcoder.v1.TextStream other =
        (com.google.cloud.video.transcoder.v1.TextStream) obj;

    if (!getCodec().equals(other.getCodec())) return false;
    if (!getMappingList().equals(other.getMappingList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CODEC_FIELD_NUMBER;
    hash = (53 * hash) + getCodec().hashCode();
    if (getMappingCount() > 0) {
      hash = (37 * hash) + MAPPING_FIELD_NUMBER;
      hash = (53 * hash) + getMappingList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.video.transcoder.v1.TextStream parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.TextStream parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.TextStream parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.TextStream parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.TextStream parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.TextStream parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.TextStream parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.TextStream parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.TextStream parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.TextStream parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.TextStream parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.TextStream parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.video.transcoder.v1.TextStream prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Encoding of a text stream. For example, closed captions or subtitles.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.TextStream}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.TextStream)
      com.google.cloud.video.transcoder.v1.TextStreamOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_TextStream_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_TextStream_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.TextStream.class,
              com.google.cloud.video.transcoder.v1.TextStream.Builder.class);
    }

    // Construct using com.google.cloud.video.transcoder.v1.TextStream.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      codec_ = "";

      if (mappingBuilder_ == null) {
        mapping_ = java.util.Collections.emptyList();
      } else {
        mapping_ = null;
        mappingBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_TextStream_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.TextStream getDefaultInstanceForType() {
      return com.google.cloud.video.transcoder.v1.TextStream.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.TextStream build() {
      com.google.cloud.video.transcoder.v1.TextStream result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.TextStream buildPartial() {
      com.google.cloud.video.transcoder.v1.TextStream result =
          new com.google.cloud.video.transcoder.v1.TextStream(this);
      int from_bitField0_ = bitField0_;
      result.codec_ = codec_;
      if (mappingBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          mapping_ = java.util.Collections.unmodifiableList(mapping_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.mapping_ = mapping_;
      } else {
        result.mapping_ = mappingBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.video.transcoder.v1.TextStream) {
        return mergeFrom((com.google.cloud.video.transcoder.v1.TextStream) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.video.transcoder.v1.TextStream other) {
      if (other == com.google.cloud.video.transcoder.v1.TextStream.getDefaultInstance())
        return this;
      if (!other.getCodec().isEmpty()) {
        codec_ = other.codec_;
        onChanged();
      }
      if (mappingBuilder_ == null) {
        if (!other.mapping_.isEmpty()) {
          if (mapping_.isEmpty()) {
            mapping_ = other.mapping_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureMappingIsMutable();
            mapping_.addAll(other.mapping_);
          }
          onChanged();
        }
      } else {
        if (!other.mapping_.isEmpty()) {
          if (mappingBuilder_.isEmpty()) {
            mappingBuilder_.dispose();
            mappingBuilder_ = null;
            mapping_ = other.mapping_;
            bitField0_ = (bitField0_ & ~0x00000001);
            mappingBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMappingFieldBuilder()
                    : null;
          } else {
            mappingBuilder_.addAllMessages(other.mapping_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                codec_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 26:
              {
                com.google.cloud.video.transcoder.v1.TextStream.TextMapping m =
                    input.readMessage(
                        com.google.cloud.video.transcoder.v1.TextStream.TextMapping.parser(),
                        extensionRegistry);
                if (mappingBuilder_ == null) {
                  ensureMappingIsMutable();
                  mapping_.add(m);
                } else {
                  mappingBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object codec_ = "";
    /**
     *
     *
     * <pre>
     * The codec for this text stream. The default is `webvtt`.
     * Supported text codecs:
     * - `srt`
     * - `ttml`
     * - `cea608`
     * - `cea708`
     * - `webvtt`
     * </pre>
     *
     * <code>string codec = 1;</code>
     *
     * @return The codec.
     */
    public java.lang.String getCodec() {
      java.lang.Object ref = codec_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        codec_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The codec for this text stream. The default is `webvtt`.
     * Supported text codecs:
     * - `srt`
     * - `ttml`
     * - `cea608`
     * - `cea708`
     * - `webvtt`
     * </pre>
     *
     * <code>string codec = 1;</code>
     *
     * @return The bytes for codec.
     */
    public com.google.protobuf.ByteString getCodecBytes() {
      java.lang.Object ref = codec_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        codec_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The codec for this text stream. The default is `webvtt`.
     * Supported text codecs:
     * - `srt`
     * - `ttml`
     * - `cea608`
     * - `cea708`
     * - `webvtt`
     * </pre>
     *
     * <code>string codec = 1;</code>
     *
     * @param value The codec to set.
     * @return This builder for chaining.
     */
    public Builder setCodec(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      codec_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The codec for this text stream. The default is `webvtt`.
     * Supported text codecs:
     * - `srt`
     * - `ttml`
     * - `cea608`
     * - `cea708`
     * - `webvtt`
     * </pre>
     *
     * <code>string codec = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCodec() {

      codec_ = getDefaultInstance().getCodec();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The codec for this text stream. The default is `webvtt`.
     * Supported text codecs:
     * - `srt`
     * - `ttml`
     * - `cea608`
     * - `cea708`
     * - `webvtt`
     * </pre>
     *
     * <code>string codec = 1;</code>
     *
     * @param value The bytes for codec to set.
     * @return This builder for chaining.
     */
    public Builder setCodecBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      codec_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.video.transcoder.v1.TextStream.TextMapping> mapping_ =
        java.util.Collections.emptyList();

    private void ensureMappingIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        mapping_ =
            new java.util.ArrayList<com.google.cloud.video.transcoder.v1.TextStream.TextMapping>(
                mapping_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.TextStream.TextMapping,
            com.google.cloud.video.transcoder.v1.TextStream.TextMapping.Builder,
            com.google.cloud.video.transcoder.v1.TextStream.TextMappingOrBuilder>
        mappingBuilder_;

    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.TextStream.TextMapping>
        getMappingList() {
      if (mappingBuilder_ == null) {
        return java.util.Collections.unmodifiableList(mapping_);
      } else {
        return mappingBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public int getMappingCount() {
      if (mappingBuilder_ == null) {
        return mapping_.size();
      } else {
        return mappingBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public com.google.cloud.video.transcoder.v1.TextStream.TextMapping getMapping(int index) {
      if (mappingBuilder_ == null) {
        return mapping_.get(index);
      } else {
        return mappingBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public Builder setMapping(
        int index, com.google.cloud.video.transcoder.v1.TextStream.TextMapping value) {
      if (mappingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMappingIsMutable();
        mapping_.set(index, value);
        onChanged();
      } else {
        mappingBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public Builder setMapping(
        int index,
        com.google.cloud.video.transcoder.v1.TextStream.TextMapping.Builder builderForValue) {
      if (mappingBuilder_ == null) {
        ensureMappingIsMutable();
        mapping_.set(index, builderForValue.build());
        onChanged();
      } else {
        mappingBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public Builder addMapping(com.google.cloud.video.transcoder.v1.TextStream.TextMapping value) {
      if (mappingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMappingIsMutable();
        mapping_.add(value);
        onChanged();
      } else {
        mappingBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public Builder addMapping(
        int index, com.google.cloud.video.transcoder.v1.TextStream.TextMapping value) {
      if (mappingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMappingIsMutable();
        mapping_.add(index, value);
        onChanged();
      } else {
        mappingBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public Builder addMapping(
        com.google.cloud.video.transcoder.v1.TextStream.TextMapping.Builder builderForValue) {
      if (mappingBuilder_ == null) {
        ensureMappingIsMutable();
        mapping_.add(builderForValue.build());
        onChanged();
      } else {
        mappingBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public Builder addMapping(
        int index,
        com.google.cloud.video.transcoder.v1.TextStream.TextMapping.Builder builderForValue) {
      if (mappingBuilder_ == null) {
        ensureMappingIsMutable();
        mapping_.add(index, builderForValue.build());
        onChanged();
      } else {
        mappingBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public Builder addAllMapping(
        java.lang.Iterable<? extends com.google.cloud.video.transcoder.v1.TextStream.TextMapping>
            values) {
      if (mappingBuilder_ == null) {
        ensureMappingIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mapping_);
        onChanged();
      } else {
        mappingBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public Builder clearMapping() {
      if (mappingBuilder_ == null) {
        mapping_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        mappingBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public Builder removeMapping(int index) {
      if (mappingBuilder_ == null) {
        ensureMappingIsMutable();
        mapping_.remove(index);
        onChanged();
      } else {
        mappingBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public com.google.cloud.video.transcoder.v1.TextStream.TextMapping.Builder getMappingBuilder(
        int index) {
      return getMappingFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public com.google.cloud.video.transcoder.v1.TextStream.TextMappingOrBuilder getMappingOrBuilder(
        int index) {
      if (mappingBuilder_ == null) {
        return mapping_.get(index);
      } else {
        return mappingBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.video.transcoder.v1.TextStream.TextMappingOrBuilder>
        getMappingOrBuilderList() {
      if (mappingBuilder_ != null) {
        return mappingBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(mapping_);
      }
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public com.google.cloud.video.transcoder.v1.TextStream.TextMapping.Builder addMappingBuilder() {
      return getMappingFieldBuilder()
          .addBuilder(
              com.google.cloud.video.transcoder.v1.TextStream.TextMapping.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public com.google.cloud.video.transcoder.v1.TextStream.TextMapping.Builder addMappingBuilder(
        int index) {
      return getMappingFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.video.transcoder.v1.TextStream.TextMapping.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.TextStream.TextMapping mapping = 3;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.TextStream.TextMapping.Builder>
        getMappingBuilderList() {
      return getMappingFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.TextStream.TextMapping,
            com.google.cloud.video.transcoder.v1.TextStream.TextMapping.Builder,
            com.google.cloud.video.transcoder.v1.TextStream.TextMappingOrBuilder>
        getMappingFieldBuilder() {
      if (mappingBuilder_ == null) {
        mappingBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.TextStream.TextMapping,
                com.google.cloud.video.transcoder.v1.TextStream.TextMapping.Builder,
                com.google.cloud.video.transcoder.v1.TextStream.TextMappingOrBuilder>(
                mapping_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        mapping_ = null;
      }
      return mappingBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.TextStream)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.TextStream)
  private static final com.google.cloud.video.transcoder.v1.TextStream DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.TextStream();
  }

  public static com.google.cloud.video.transcoder.v1.TextStream getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TextStream> PARSER =
      new com.google.protobuf.AbstractParser<TextStream>() {
        @java.lang.Override
        public TextStream parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TextStream> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TextStream> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.TextStream getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
