/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/video/transcoder/v1/resources.proto

package com.google.cloud.video.transcoder.v1;

/**
 *
 *
 * <pre>
 * Sprite sheet configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.video.transcoder.v1.SpriteSheet}
 */
public final class SpriteSheet extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.SpriteSheet)
    SpriteSheetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SpriteSheet.newBuilder() to construct.
  private SpriteSheet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpriteSheet() {
    format_ = "";
    filePrefix_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpriteSheet();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_SpriteSheet_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_SpriteSheet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.video.transcoder.v1.SpriteSheet.class,
            com.google.cloud.video.transcoder.v1.SpriteSheet.Builder.class);
  }

  private int extractionStrategyCase_ = 0;
  private java.lang.Object extractionStrategy_;

  public enum ExtractionStrategyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TOTAL_COUNT(9),
    INTERVAL(10),
    EXTRACTIONSTRATEGY_NOT_SET(0);
    private final int value;

    private ExtractionStrategyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExtractionStrategyCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExtractionStrategyCase forNumber(int value) {
      switch (value) {
        case 9:
          return TOTAL_COUNT;
        case 10:
          return INTERVAL;
        case 0:
          return EXTRACTIONSTRATEGY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExtractionStrategyCase getExtractionStrategyCase() {
    return ExtractionStrategyCase.forNumber(extractionStrategyCase_);
  }

  public static final int FORMAT_FIELD_NUMBER = 1;
  private volatile java.lang.Object format_;
  /**
   *
   *
   * <pre>
   * Format type. The default is `jpeg`.
   * Supported formats:
   * - `jpeg`
   * </pre>
   *
   * <code>string format = 1;</code>
   *
   * @return The format.
   */
  @java.lang.Override
  public java.lang.String getFormat() {
    java.lang.Object ref = format_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      format_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Format type. The default is `jpeg`.
   * Supported formats:
   * - `jpeg`
   * </pre>
   *
   * <code>string format = 1;</code>
   *
   * @return The bytes for format.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFormatBytes() {
    java.lang.Object ref = format_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      format_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILE_PREFIX_FIELD_NUMBER = 2;
  private volatile java.lang.Object filePrefix_;
  /**
   *
   *
   * <pre>
   * Required. File name prefix for the generated sprite sheets.
   * Each sprite sheet has an incremental 10-digit zero-padded suffix starting
   * from 0 before the extension, such as `sprite_sheet0000000123.jpeg`.
   * </pre>
   *
   * <code>string file_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The filePrefix.
   */
  @java.lang.Override
  public java.lang.String getFilePrefix() {
    java.lang.Object ref = filePrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filePrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. File name prefix for the generated sprite sheets.
   * Each sprite sheet has an incremental 10-digit zero-padded suffix starting
   * from 0 before the extension, such as `sprite_sheet0000000123.jpeg`.
   * </pre>
   *
   * <code>string file_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for filePrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilePrefixBytes() {
    java.lang.Object ref = filePrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filePrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPRITE_WIDTH_PIXELS_FIELD_NUMBER = 3;
  private int spriteWidthPixels_;
  /**
   *
   *
   * <pre>
   * Required. The width of sprite in pixels. Must be an even integer. To preserve the
   * source aspect ratio, set the [SpriteSheet.sprite_width_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_width_pixels] field or
   * the [SpriteSheet.sprite_height_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_height_pixels] field, but not both (the API will
   * automatically calculate the missing field).
   * </pre>
   *
   * <code>int32 sprite_width_pixels = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The spriteWidthPixels.
   */
  @java.lang.Override
  public int getSpriteWidthPixels() {
    return spriteWidthPixels_;
  }

  public static final int SPRITE_HEIGHT_PIXELS_FIELD_NUMBER = 4;
  private int spriteHeightPixels_;
  /**
   *
   *
   * <pre>
   * Required. The height of sprite in pixels. Must be an even integer. To preserve the
   * source aspect ratio, set the [SpriteSheet.sprite_height_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_height_pixels] field or
   * the [SpriteSheet.sprite_width_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_width_pixels] field, but not both (the API will
   * automatically calculate the missing field).
   * </pre>
   *
   * <code>int32 sprite_height_pixels = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The spriteHeightPixels.
   */
  @java.lang.Override
  public int getSpriteHeightPixels() {
    return spriteHeightPixels_;
  }

  public static final int COLUMN_COUNT_FIELD_NUMBER = 5;
  private int columnCount_;
  /**
   *
   *
   * <pre>
   * The maximum number of sprites per row in a sprite sheet. The default is 0,
   * which indicates no maximum limit.
   * </pre>
   *
   * <code>int32 column_count = 5;</code>
   *
   * @return The columnCount.
   */
  @java.lang.Override
  public int getColumnCount() {
    return columnCount_;
  }

  public static final int ROW_COUNT_FIELD_NUMBER = 6;
  private int rowCount_;
  /**
   *
   *
   * <pre>
   * The maximum number of rows per sprite sheet. When the sprite sheet is full,
   * a new sprite sheet is created. The default is 0, which indicates no maximum
   * limit.
   * </pre>
   *
   * <code>int32 row_count = 6;</code>
   *
   * @return The rowCount.
   */
  @java.lang.Override
  public int getRowCount() {
    return rowCount_;
  }

  public static final int START_TIME_OFFSET_FIELD_NUMBER = 7;
  private com.google.protobuf.Duration startTimeOffset_;
  /**
   *
   *
   * <pre>
   * Start time in seconds, relative to the output file timeline. Determines the
   * first sprite to pick. The default is `0s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration start_time_offset = 7;</code>
   *
   * @return Whether the startTimeOffset field is set.
   */
  @java.lang.Override
  public boolean hasStartTimeOffset() {
    return startTimeOffset_ != null;
  }
  /**
   *
   *
   * <pre>
   * Start time in seconds, relative to the output file timeline. Determines the
   * first sprite to pick. The default is `0s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration start_time_offset = 7;</code>
   *
   * @return The startTimeOffset.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getStartTimeOffset() {
    return startTimeOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : startTimeOffset_;
  }
  /**
   *
   *
   * <pre>
   * Start time in seconds, relative to the output file timeline. Determines the
   * first sprite to pick. The default is `0s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration start_time_offset = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getStartTimeOffsetOrBuilder() {
    return getStartTimeOffset();
  }

  public static final int END_TIME_OFFSET_FIELD_NUMBER = 8;
  private com.google.protobuf.Duration endTimeOffset_;
  /**
   *
   *
   * <pre>
   * End time in seconds, relative to the output file timeline. When
   * `end_time_offset` is not specified, the sprites are generated until the end
   * of the output file.
   * </pre>
   *
   * <code>.google.protobuf.Duration end_time_offset = 8;</code>
   *
   * @return Whether the endTimeOffset field is set.
   */
  @java.lang.Override
  public boolean hasEndTimeOffset() {
    return endTimeOffset_ != null;
  }
  /**
   *
   *
   * <pre>
   * End time in seconds, relative to the output file timeline. When
   * `end_time_offset` is not specified, the sprites are generated until the end
   * of the output file.
   * </pre>
   *
   * <code>.google.protobuf.Duration end_time_offset = 8;</code>
   *
   * @return The endTimeOffset.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getEndTimeOffset() {
    return endTimeOffset_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : endTimeOffset_;
  }
  /**
   *
   *
   * <pre>
   * End time in seconds, relative to the output file timeline. When
   * `end_time_offset` is not specified, the sprites are generated until the end
   * of the output file.
   * </pre>
   *
   * <code>.google.protobuf.Duration end_time_offset = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getEndTimeOffsetOrBuilder() {
    return getEndTimeOffset();
  }

  public static final int TOTAL_COUNT_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Total number of sprites. Create the specified number of sprites
   * distributed evenly across the timeline of the output media. The default
   * is 100.
   * </pre>
   *
   * <code>int32 total_count = 9;</code>
   *
   * @return Whether the totalCount field is set.
   */
  @java.lang.Override
  public boolean hasTotalCount() {
    return extractionStrategyCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Total number of sprites. Create the specified number of sprites
   * distributed evenly across the timeline of the output media. The default
   * is 100.
   * </pre>
   *
   * <code>int32 total_count = 9;</code>
   *
   * @return The totalCount.
   */
  @java.lang.Override
  public int getTotalCount() {
    if (extractionStrategyCase_ == 9) {
      return (java.lang.Integer) extractionStrategy_;
    }
    return 0;
  }

  public static final int INTERVAL_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Starting from `0s`, create sprites at regular intervals. Specify the
   * interval value in seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration interval = 10;</code>
   *
   * @return Whether the interval field is set.
   */
  @java.lang.Override
  public boolean hasInterval() {
    return extractionStrategyCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Starting from `0s`, create sprites at regular intervals. Specify the
   * interval value in seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration interval = 10;</code>
   *
   * @return The interval.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getInterval() {
    if (extractionStrategyCase_ == 10) {
      return (com.google.protobuf.Duration) extractionStrategy_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Starting from `0s`, create sprites at regular intervals. Specify the
   * interval value in seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration interval = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getIntervalOrBuilder() {
    if (extractionStrategyCase_ == 10) {
      return (com.google.protobuf.Duration) extractionStrategy_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  public static final int QUALITY_FIELD_NUMBER = 11;
  private int quality_;
  /**
   *
   *
   * <pre>
   * The quality of the generated sprite sheet. Enter a value between 1
   * and 100, where 1 is the lowest quality and 100 is the highest quality.
   * The default is 100. A high quality value corresponds to a low image data
   * compression ratio.
   * </pre>
   *
   * <code>int32 quality = 11;</code>
   *
   * @return The quality.
   */
  @java.lang.Override
  public int getQuality() {
    return quality_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(format_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, format_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filePrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filePrefix_);
    }
    if (spriteWidthPixels_ != 0) {
      output.writeInt32(3, spriteWidthPixels_);
    }
    if (spriteHeightPixels_ != 0) {
      output.writeInt32(4, spriteHeightPixels_);
    }
    if (columnCount_ != 0) {
      output.writeInt32(5, columnCount_);
    }
    if (rowCount_ != 0) {
      output.writeInt32(6, rowCount_);
    }
    if (startTimeOffset_ != null) {
      output.writeMessage(7, getStartTimeOffset());
    }
    if (endTimeOffset_ != null) {
      output.writeMessage(8, getEndTimeOffset());
    }
    if (extractionStrategyCase_ == 9) {
      output.writeInt32(9, (int) ((java.lang.Integer) extractionStrategy_));
    }
    if (extractionStrategyCase_ == 10) {
      output.writeMessage(10, (com.google.protobuf.Duration) extractionStrategy_);
    }
    if (quality_ != 0) {
      output.writeInt32(11, quality_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(format_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, format_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filePrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filePrefix_);
    }
    if (spriteWidthPixels_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, spriteWidthPixels_);
    }
    if (spriteHeightPixels_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, spriteHeightPixels_);
    }
    if (columnCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, columnCount_);
    }
    if (rowCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, rowCount_);
    }
    if (startTimeOffset_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getStartTimeOffset());
    }
    if (endTimeOffset_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEndTimeOffset());
    }
    if (extractionStrategyCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              9, (int) ((java.lang.Integer) extractionStrategy_));
    }
    if (extractionStrategyCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.protobuf.Duration) extractionStrategy_);
    }
    if (quality_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(11, quality_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.video.transcoder.v1.SpriteSheet)) {
      return super.equals(obj);
    }
    com.google.cloud.video.transcoder.v1.SpriteSheet other =
        (com.google.cloud.video.transcoder.v1.SpriteSheet) obj;

    if (!getFormat().equals(other.getFormat())) return false;
    if (!getFilePrefix().equals(other.getFilePrefix())) return false;
    if (getSpriteWidthPixels() != other.getSpriteWidthPixels()) return false;
    if (getSpriteHeightPixels() != other.getSpriteHeightPixels()) return false;
    if (getColumnCount() != other.getColumnCount()) return false;
    if (getRowCount() != other.getRowCount()) return false;
    if (hasStartTimeOffset() != other.hasStartTimeOffset()) return false;
    if (hasStartTimeOffset()) {
      if (!getStartTimeOffset().equals(other.getStartTimeOffset())) return false;
    }
    if (hasEndTimeOffset() != other.hasEndTimeOffset()) return false;
    if (hasEndTimeOffset()) {
      if (!getEndTimeOffset().equals(other.getEndTimeOffset())) return false;
    }
    if (getQuality() != other.getQuality()) return false;
    if (!getExtractionStrategyCase().equals(other.getExtractionStrategyCase())) return false;
    switch (extractionStrategyCase_) {
      case 9:
        if (getTotalCount() != other.getTotalCount()) return false;
        break;
      case 10:
        if (!getInterval().equals(other.getInterval())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + getFormat().hashCode();
    hash = (37 * hash) + FILE_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getFilePrefix().hashCode();
    hash = (37 * hash) + SPRITE_WIDTH_PIXELS_FIELD_NUMBER;
    hash = (53 * hash) + getSpriteWidthPixels();
    hash = (37 * hash) + SPRITE_HEIGHT_PIXELS_FIELD_NUMBER;
    hash = (53 * hash) + getSpriteHeightPixels();
    hash = (37 * hash) + COLUMN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getColumnCount();
    hash = (37 * hash) + ROW_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getRowCount();
    if (hasStartTimeOffset()) {
      hash = (37 * hash) + START_TIME_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getStartTimeOffset().hashCode();
    }
    if (hasEndTimeOffset()) {
      hash = (37 * hash) + END_TIME_OFFSET_FIELD_NUMBER;
      hash = (53 * hash) + getEndTimeOffset().hashCode();
    }
    hash = (37 * hash) + QUALITY_FIELD_NUMBER;
    hash = (53 * hash) + getQuality();
    switch (extractionStrategyCase_) {
      case 9:
        hash = (37 * hash) + TOTAL_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getTotalCount();
        break;
      case 10:
        hash = (37 * hash) + INTERVAL_FIELD_NUMBER;
        hash = (53 * hash) + getInterval().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.video.transcoder.v1.SpriteSheet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Sprite sheet configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.SpriteSheet}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.SpriteSheet)
      com.google.cloud.video.transcoder.v1.SpriteSheetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_SpriteSheet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_SpriteSheet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.SpriteSheet.class,
              com.google.cloud.video.transcoder.v1.SpriteSheet.Builder.class);
    }

    // Construct using com.google.cloud.video.transcoder.v1.SpriteSheet.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      format_ = "";

      filePrefix_ = "";

      spriteWidthPixels_ = 0;

      spriteHeightPixels_ = 0;

      columnCount_ = 0;

      rowCount_ = 0;

      if (startTimeOffsetBuilder_ == null) {
        startTimeOffset_ = null;
      } else {
        startTimeOffset_ = null;
        startTimeOffsetBuilder_ = null;
      }
      if (endTimeOffsetBuilder_ == null) {
        endTimeOffset_ = null;
      } else {
        endTimeOffset_ = null;
        endTimeOffsetBuilder_ = null;
      }
      if (intervalBuilder_ != null) {
        intervalBuilder_.clear();
      }
      quality_ = 0;

      extractionStrategyCase_ = 0;
      extractionStrategy_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_SpriteSheet_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.SpriteSheet getDefaultInstanceForType() {
      return com.google.cloud.video.transcoder.v1.SpriteSheet.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.SpriteSheet build() {
      com.google.cloud.video.transcoder.v1.SpriteSheet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.SpriteSheet buildPartial() {
      com.google.cloud.video.transcoder.v1.SpriteSheet result =
          new com.google.cloud.video.transcoder.v1.SpriteSheet(this);
      result.format_ = format_;
      result.filePrefix_ = filePrefix_;
      result.spriteWidthPixels_ = spriteWidthPixels_;
      result.spriteHeightPixels_ = spriteHeightPixels_;
      result.columnCount_ = columnCount_;
      result.rowCount_ = rowCount_;
      if (startTimeOffsetBuilder_ == null) {
        result.startTimeOffset_ = startTimeOffset_;
      } else {
        result.startTimeOffset_ = startTimeOffsetBuilder_.build();
      }
      if (endTimeOffsetBuilder_ == null) {
        result.endTimeOffset_ = endTimeOffset_;
      } else {
        result.endTimeOffset_ = endTimeOffsetBuilder_.build();
      }
      if (extractionStrategyCase_ == 9) {
        result.extractionStrategy_ = extractionStrategy_;
      }
      if (extractionStrategyCase_ == 10) {
        if (intervalBuilder_ == null) {
          result.extractionStrategy_ = extractionStrategy_;
        } else {
          result.extractionStrategy_ = intervalBuilder_.build();
        }
      }
      result.quality_ = quality_;
      result.extractionStrategyCase_ = extractionStrategyCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.video.transcoder.v1.SpriteSheet) {
        return mergeFrom((com.google.cloud.video.transcoder.v1.SpriteSheet) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.video.transcoder.v1.SpriteSheet other) {
      if (other == com.google.cloud.video.transcoder.v1.SpriteSheet.getDefaultInstance())
        return this;
      if (!other.getFormat().isEmpty()) {
        format_ = other.format_;
        onChanged();
      }
      if (!other.getFilePrefix().isEmpty()) {
        filePrefix_ = other.filePrefix_;
        onChanged();
      }
      if (other.getSpriteWidthPixels() != 0) {
        setSpriteWidthPixels(other.getSpriteWidthPixels());
      }
      if (other.getSpriteHeightPixels() != 0) {
        setSpriteHeightPixels(other.getSpriteHeightPixels());
      }
      if (other.getColumnCount() != 0) {
        setColumnCount(other.getColumnCount());
      }
      if (other.getRowCount() != 0) {
        setRowCount(other.getRowCount());
      }
      if (other.hasStartTimeOffset()) {
        mergeStartTimeOffset(other.getStartTimeOffset());
      }
      if (other.hasEndTimeOffset()) {
        mergeEndTimeOffset(other.getEndTimeOffset());
      }
      if (other.getQuality() != 0) {
        setQuality(other.getQuality());
      }
      switch (other.getExtractionStrategyCase()) {
        case TOTAL_COUNT:
          {
            setTotalCount(other.getTotalCount());
            break;
          }
        case INTERVAL:
          {
            mergeInterval(other.getInterval());
            break;
          }
        case EXTRACTIONSTRATEGY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                format_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                filePrefix_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 24:
              {
                spriteWidthPixels_ = input.readInt32();

                break;
              } // case 24
            case 32:
              {
                spriteHeightPixels_ = input.readInt32();

                break;
              } // case 32
            case 40:
              {
                columnCount_ = input.readInt32();

                break;
              } // case 40
            case 48:
              {
                rowCount_ = input.readInt32();

                break;
              } // case 48
            case 58:
              {
                input.readMessage(getStartTimeOffsetFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEndTimeOffsetFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 72:
              {
                extractionStrategy_ = input.readInt32();
                extractionStrategyCase_ = 9;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(getIntervalFieldBuilder().getBuilder(), extensionRegistry);
                extractionStrategyCase_ = 10;
                break;
              } // case 82
            case 88:
              {
                quality_ = input.readInt32();

                break;
              } // case 88
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int extractionStrategyCase_ = 0;
    private java.lang.Object extractionStrategy_;

    public ExtractionStrategyCase getExtractionStrategyCase() {
      return ExtractionStrategyCase.forNumber(extractionStrategyCase_);
    }

    public Builder clearExtractionStrategy() {
      extractionStrategyCase_ = 0;
      extractionStrategy_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object format_ = "";
    /**
     *
     *
     * <pre>
     * Format type. The default is `jpeg`.
     * Supported formats:
     * - `jpeg`
     * </pre>
     *
     * <code>string format = 1;</code>
     *
     * @return The format.
     */
    public java.lang.String getFormat() {
      java.lang.Object ref = format_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        format_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Format type. The default is `jpeg`.
     * Supported formats:
     * - `jpeg`
     * </pre>
     *
     * <code>string format = 1;</code>
     *
     * @return The bytes for format.
     */
    public com.google.protobuf.ByteString getFormatBytes() {
      java.lang.Object ref = format_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        format_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Format type. The default is `jpeg`.
     * Supported formats:
     * - `jpeg`
     * </pre>
     *
     * <code>string format = 1;</code>
     *
     * @param value The format to set.
     * @return This builder for chaining.
     */
    public Builder setFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      format_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Format type. The default is `jpeg`.
     * Supported formats:
     * - `jpeg`
     * </pre>
     *
     * <code>string format = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFormat() {

      format_ = getDefaultInstance().getFormat();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Format type. The default is `jpeg`.
     * Supported formats:
     * - `jpeg`
     * </pre>
     *
     * <code>string format = 1;</code>
     *
     * @param value The bytes for format to set.
     * @return This builder for chaining.
     */
    public Builder setFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      format_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object filePrefix_ = "";
    /**
     *
     *
     * <pre>
     * Required. File name prefix for the generated sprite sheets.
     * Each sprite sheet has an incremental 10-digit zero-padded suffix starting
     * from 0 before the extension, such as `sprite_sheet0000000123.jpeg`.
     * </pre>
     *
     * <code>string file_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filePrefix.
     */
    public java.lang.String getFilePrefix() {
      java.lang.Object ref = filePrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filePrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. File name prefix for the generated sprite sheets.
     * Each sprite sheet has an incremental 10-digit zero-padded suffix starting
     * from 0 before the extension, such as `sprite_sheet0000000123.jpeg`.
     * </pre>
     *
     * <code>string file_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filePrefix.
     */
    public com.google.protobuf.ByteString getFilePrefixBytes() {
      java.lang.Object ref = filePrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filePrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. File name prefix for the generated sprite sheets.
     * Each sprite sheet has an incremental 10-digit zero-padded suffix starting
     * from 0 before the extension, such as `sprite_sheet0000000123.jpeg`.
     * </pre>
     *
     * <code>string file_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The filePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setFilePrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      filePrefix_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. File name prefix for the generated sprite sheets.
     * Each sprite sheet has an incremental 10-digit zero-padded suffix starting
     * from 0 before the extension, such as `sprite_sheet0000000123.jpeg`.
     * </pre>
     *
     * <code>string file_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilePrefix() {

      filePrefix_ = getDefaultInstance().getFilePrefix();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. File name prefix for the generated sprite sheets.
     * Each sprite sheet has an incremental 10-digit zero-padded suffix starting
     * from 0 before the extension, such as `sprite_sheet0000000123.jpeg`.
     * </pre>
     *
     * <code>string file_prefix = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for filePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setFilePrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      filePrefix_ = value;
      onChanged();
      return this;
    }

    private int spriteWidthPixels_;
    /**
     *
     *
     * <pre>
     * Required. The width of sprite in pixels. Must be an even integer. To preserve the
     * source aspect ratio, set the [SpriteSheet.sprite_width_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_width_pixels] field or
     * the [SpriteSheet.sprite_height_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_height_pixels] field, but not both (the API will
     * automatically calculate the missing field).
     * </pre>
     *
     * <code>int32 sprite_width_pixels = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The spriteWidthPixels.
     */
    @java.lang.Override
    public int getSpriteWidthPixels() {
      return spriteWidthPixels_;
    }
    /**
     *
     *
     * <pre>
     * Required. The width of sprite in pixels. Must be an even integer. To preserve the
     * source aspect ratio, set the [SpriteSheet.sprite_width_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_width_pixels] field or
     * the [SpriteSheet.sprite_height_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_height_pixels] field, but not both (the API will
     * automatically calculate the missing field).
     * </pre>
     *
     * <code>int32 sprite_width_pixels = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The spriteWidthPixels to set.
     * @return This builder for chaining.
     */
    public Builder setSpriteWidthPixels(int value) {

      spriteWidthPixels_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The width of sprite in pixels. Must be an even integer. To preserve the
     * source aspect ratio, set the [SpriteSheet.sprite_width_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_width_pixels] field or
     * the [SpriteSheet.sprite_height_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_height_pixels] field, but not both (the API will
     * automatically calculate the missing field).
     * </pre>
     *
     * <code>int32 sprite_width_pixels = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpriteWidthPixels() {

      spriteWidthPixels_ = 0;
      onChanged();
      return this;
    }

    private int spriteHeightPixels_;
    /**
     *
     *
     * <pre>
     * Required. The height of sprite in pixels. Must be an even integer. To preserve the
     * source aspect ratio, set the [SpriteSheet.sprite_height_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_height_pixels] field or
     * the [SpriteSheet.sprite_width_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_width_pixels] field, but not both (the API will
     * automatically calculate the missing field).
     * </pre>
     *
     * <code>int32 sprite_height_pixels = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The spriteHeightPixels.
     */
    @java.lang.Override
    public int getSpriteHeightPixels() {
      return spriteHeightPixels_;
    }
    /**
     *
     *
     * <pre>
     * Required. The height of sprite in pixels. Must be an even integer. To preserve the
     * source aspect ratio, set the [SpriteSheet.sprite_height_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_height_pixels] field or
     * the [SpriteSheet.sprite_width_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_width_pixels] field, but not both (the API will
     * automatically calculate the missing field).
     * </pre>
     *
     * <code>int32 sprite_height_pixels = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The spriteHeightPixels to set.
     * @return This builder for chaining.
     */
    public Builder setSpriteHeightPixels(int value) {

      spriteHeightPixels_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The height of sprite in pixels. Must be an even integer. To preserve the
     * source aspect ratio, set the [SpriteSheet.sprite_height_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_height_pixels] field or
     * the [SpriteSheet.sprite_width_pixels][google.cloud.video.transcoder.v1.SpriteSheet.sprite_width_pixels] field, but not both (the API will
     * automatically calculate the missing field).
     * </pre>
     *
     * <code>int32 sprite_height_pixels = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpriteHeightPixels() {

      spriteHeightPixels_ = 0;
      onChanged();
      return this;
    }

    private int columnCount_;
    /**
     *
     *
     * <pre>
     * The maximum number of sprites per row in a sprite sheet. The default is 0,
     * which indicates no maximum limit.
     * </pre>
     *
     * <code>int32 column_count = 5;</code>
     *
     * @return The columnCount.
     */
    @java.lang.Override
    public int getColumnCount() {
      return columnCount_;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of sprites per row in a sprite sheet. The default is 0,
     * which indicates no maximum limit.
     * </pre>
     *
     * <code>int32 column_count = 5;</code>
     *
     * @param value The columnCount to set.
     * @return This builder for chaining.
     */
    public Builder setColumnCount(int value) {

      columnCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of sprites per row in a sprite sheet. The default is 0,
     * which indicates no maximum limit.
     * </pre>
     *
     * <code>int32 column_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColumnCount() {

      columnCount_ = 0;
      onChanged();
      return this;
    }

    private int rowCount_;
    /**
     *
     *
     * <pre>
     * The maximum number of rows per sprite sheet. When the sprite sheet is full,
     * a new sprite sheet is created. The default is 0, which indicates no maximum
     * limit.
     * </pre>
     *
     * <code>int32 row_count = 6;</code>
     *
     * @return The rowCount.
     */
    @java.lang.Override
    public int getRowCount() {
      return rowCount_;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of rows per sprite sheet. When the sprite sheet is full,
     * a new sprite sheet is created. The default is 0, which indicates no maximum
     * limit.
     * </pre>
     *
     * <code>int32 row_count = 6;</code>
     *
     * @param value The rowCount to set.
     * @return This builder for chaining.
     */
    public Builder setRowCount(int value) {

      rowCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of rows per sprite sheet. When the sprite sheet is full,
     * a new sprite sheet is created. The default is 0, which indicates no maximum
     * limit.
     * </pre>
     *
     * <code>int32 row_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowCount() {

      rowCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration startTimeOffset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        startTimeOffsetBuilder_;
    /**
     *
     *
     * <pre>
     * Start time in seconds, relative to the output file timeline. Determines the
     * first sprite to pick. The default is `0s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 7;</code>
     *
     * @return Whether the startTimeOffset field is set.
     */
    public boolean hasStartTimeOffset() {
      return startTimeOffsetBuilder_ != null || startTimeOffset_ != null;
    }
    /**
     *
     *
     * <pre>
     * Start time in seconds, relative to the output file timeline. Determines the
     * first sprite to pick. The default is `0s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 7;</code>
     *
     * @return The startTimeOffset.
     */
    public com.google.protobuf.Duration getStartTimeOffset() {
      if (startTimeOffsetBuilder_ == null) {
        return startTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : startTimeOffset_;
      } else {
        return startTimeOffsetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Start time in seconds, relative to the output file timeline. Determines the
     * first sprite to pick. The default is `0s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 7;</code>
     */
    public Builder setStartTimeOffset(com.google.protobuf.Duration value) {
      if (startTimeOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTimeOffset_ = value;
        onChanged();
      } else {
        startTimeOffsetBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time in seconds, relative to the output file timeline. Determines the
     * first sprite to pick. The default is `0s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 7;</code>
     */
    public Builder setStartTimeOffset(com.google.protobuf.Duration.Builder builderForValue) {
      if (startTimeOffsetBuilder_ == null) {
        startTimeOffset_ = builderForValue.build();
        onChanged();
      } else {
        startTimeOffsetBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time in seconds, relative to the output file timeline. Determines the
     * first sprite to pick. The default is `0s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 7;</code>
     */
    public Builder mergeStartTimeOffset(com.google.protobuf.Duration value) {
      if (startTimeOffsetBuilder_ == null) {
        if (startTimeOffset_ != null) {
          startTimeOffset_ =
              com.google.protobuf.Duration.newBuilder(startTimeOffset_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          startTimeOffset_ = value;
        }
        onChanged();
      } else {
        startTimeOffsetBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time in seconds, relative to the output file timeline. Determines the
     * first sprite to pick. The default is `0s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 7;</code>
     */
    public Builder clearStartTimeOffset() {
      if (startTimeOffsetBuilder_ == null) {
        startTimeOffset_ = null;
        onChanged();
      } else {
        startTimeOffset_ = null;
        startTimeOffsetBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time in seconds, relative to the output file timeline. Determines the
     * first sprite to pick. The default is `0s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 7;</code>
     */
    public com.google.protobuf.Duration.Builder getStartTimeOffsetBuilder() {

      onChanged();
      return getStartTimeOffsetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Start time in seconds, relative to the output file timeline. Determines the
     * first sprite to pick. The default is `0s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 7;</code>
     */
    public com.google.protobuf.DurationOrBuilder getStartTimeOffsetOrBuilder() {
      if (startTimeOffsetBuilder_ != null) {
        return startTimeOffsetBuilder_.getMessageOrBuilder();
      } else {
        return startTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : startTimeOffset_;
      }
    }
    /**
     *
     *
     * <pre>
     * Start time in seconds, relative to the output file timeline. Determines the
     * first sprite to pick. The default is `0s`.
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getStartTimeOffsetFieldBuilder() {
      if (startTimeOffsetBuilder_ == null) {
        startTimeOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getStartTimeOffset(), getParentForChildren(), isClean());
        startTimeOffset_ = null;
      }
      return startTimeOffsetBuilder_;
    }

    private com.google.protobuf.Duration endTimeOffset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        endTimeOffsetBuilder_;
    /**
     *
     *
     * <pre>
     * End time in seconds, relative to the output file timeline. When
     * `end_time_offset` is not specified, the sprites are generated until the end
     * of the output file.
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 8;</code>
     *
     * @return Whether the endTimeOffset field is set.
     */
    public boolean hasEndTimeOffset() {
      return endTimeOffsetBuilder_ != null || endTimeOffset_ != null;
    }
    /**
     *
     *
     * <pre>
     * End time in seconds, relative to the output file timeline. When
     * `end_time_offset` is not specified, the sprites are generated until the end
     * of the output file.
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 8;</code>
     *
     * @return The endTimeOffset.
     */
    public com.google.protobuf.Duration getEndTimeOffset() {
      if (endTimeOffsetBuilder_ == null) {
        return endTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : endTimeOffset_;
      } else {
        return endTimeOffsetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * End time in seconds, relative to the output file timeline. When
     * `end_time_offset` is not specified, the sprites are generated until the end
     * of the output file.
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 8;</code>
     */
    public Builder setEndTimeOffset(com.google.protobuf.Duration value) {
      if (endTimeOffsetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTimeOffset_ = value;
        onChanged();
      } else {
        endTimeOffsetBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End time in seconds, relative to the output file timeline. When
     * `end_time_offset` is not specified, the sprites are generated until the end
     * of the output file.
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 8;</code>
     */
    public Builder setEndTimeOffset(com.google.protobuf.Duration.Builder builderForValue) {
      if (endTimeOffsetBuilder_ == null) {
        endTimeOffset_ = builderForValue.build();
        onChanged();
      } else {
        endTimeOffsetBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End time in seconds, relative to the output file timeline. When
     * `end_time_offset` is not specified, the sprites are generated until the end
     * of the output file.
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 8;</code>
     */
    public Builder mergeEndTimeOffset(com.google.protobuf.Duration value) {
      if (endTimeOffsetBuilder_ == null) {
        if (endTimeOffset_ != null) {
          endTimeOffset_ =
              com.google.protobuf.Duration.newBuilder(endTimeOffset_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          endTimeOffset_ = value;
        }
        onChanged();
      } else {
        endTimeOffsetBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End time in seconds, relative to the output file timeline. When
     * `end_time_offset` is not specified, the sprites are generated until the end
     * of the output file.
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 8;</code>
     */
    public Builder clearEndTimeOffset() {
      if (endTimeOffsetBuilder_ == null) {
        endTimeOffset_ = null;
        onChanged();
      } else {
        endTimeOffset_ = null;
        endTimeOffsetBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End time in seconds, relative to the output file timeline. When
     * `end_time_offset` is not specified, the sprites are generated until the end
     * of the output file.
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 8;</code>
     */
    public com.google.protobuf.Duration.Builder getEndTimeOffsetBuilder() {

      onChanged();
      return getEndTimeOffsetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * End time in seconds, relative to the output file timeline. When
     * `end_time_offset` is not specified, the sprites are generated until the end
     * of the output file.
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 8;</code>
     */
    public com.google.protobuf.DurationOrBuilder getEndTimeOffsetOrBuilder() {
      if (endTimeOffsetBuilder_ != null) {
        return endTimeOffsetBuilder_.getMessageOrBuilder();
      } else {
        return endTimeOffset_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : endTimeOffset_;
      }
    }
    /**
     *
     *
     * <pre>
     * End time in seconds, relative to the output file timeline. When
     * `end_time_offset` is not specified, the sprites are generated until the end
     * of the output file.
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getEndTimeOffsetFieldBuilder() {
      if (endTimeOffsetBuilder_ == null) {
        endTimeOffsetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getEndTimeOffset(), getParentForChildren(), isClean());
        endTimeOffset_ = null;
      }
      return endTimeOffsetBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Total number of sprites. Create the specified number of sprites
     * distributed evenly across the timeline of the output media. The default
     * is 100.
     * </pre>
     *
     * <code>int32 total_count = 9;</code>
     *
     * @return Whether the totalCount field is set.
     */
    public boolean hasTotalCount() {
      return extractionStrategyCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Total number of sprites. Create the specified number of sprites
     * distributed evenly across the timeline of the output media. The default
     * is 100.
     * </pre>
     *
     * <code>int32 total_count = 9;</code>
     *
     * @return The totalCount.
     */
    public int getTotalCount() {
      if (extractionStrategyCase_ == 9) {
        return (java.lang.Integer) extractionStrategy_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Total number of sprites. Create the specified number of sprites
     * distributed evenly across the timeline of the output media. The default
     * is 100.
     * </pre>
     *
     * <code>int32 total_count = 9;</code>
     *
     * @param value The totalCount to set.
     * @return This builder for chaining.
     */
    public Builder setTotalCount(int value) {
      extractionStrategyCase_ = 9;
      extractionStrategy_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of sprites. Create the specified number of sprites
     * distributed evenly across the timeline of the output media. The default
     * is 100.
     * </pre>
     *
     * <code>int32 total_count = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalCount() {
      if (extractionStrategyCase_ == 9) {
        extractionStrategyCase_ = 0;
        extractionStrategy_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        intervalBuilder_;
    /**
     *
     *
     * <pre>
     * Starting from `0s`, create sprites at regular intervals. Specify the
     * interval value in seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval = 10;</code>
     *
     * @return Whether the interval field is set.
     */
    @java.lang.Override
    public boolean hasInterval() {
      return extractionStrategyCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Starting from `0s`, create sprites at regular intervals. Specify the
     * interval value in seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval = 10;</code>
     *
     * @return The interval.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getInterval() {
      if (intervalBuilder_ == null) {
        if (extractionStrategyCase_ == 10) {
          return (com.google.protobuf.Duration) extractionStrategy_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      } else {
        if (extractionStrategyCase_ == 10) {
          return intervalBuilder_.getMessage();
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Starting from `0s`, create sprites at regular intervals. Specify the
     * interval value in seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval = 10;</code>
     */
    public Builder setInterval(com.google.protobuf.Duration value) {
      if (intervalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        extractionStrategy_ = value;
        onChanged();
      } else {
        intervalBuilder_.setMessage(value);
      }
      extractionStrategyCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starting from `0s`, create sprites at regular intervals. Specify the
     * interval value in seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval = 10;</code>
     */
    public Builder setInterval(com.google.protobuf.Duration.Builder builderForValue) {
      if (intervalBuilder_ == null) {
        extractionStrategy_ = builderForValue.build();
        onChanged();
      } else {
        intervalBuilder_.setMessage(builderForValue.build());
      }
      extractionStrategyCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starting from `0s`, create sprites at regular intervals. Specify the
     * interval value in seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval = 10;</code>
     */
    public Builder mergeInterval(com.google.protobuf.Duration value) {
      if (intervalBuilder_ == null) {
        if (extractionStrategyCase_ == 10
            && extractionStrategy_ != com.google.protobuf.Duration.getDefaultInstance()) {
          extractionStrategy_ =
              com.google.protobuf.Duration.newBuilder(
                      (com.google.protobuf.Duration) extractionStrategy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          extractionStrategy_ = value;
        }
        onChanged();
      } else {
        if (extractionStrategyCase_ == 10) {
          intervalBuilder_.mergeFrom(value);
        } else {
          intervalBuilder_.setMessage(value);
        }
      }
      extractionStrategyCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starting from `0s`, create sprites at regular intervals. Specify the
     * interval value in seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval = 10;</code>
     */
    public Builder clearInterval() {
      if (intervalBuilder_ == null) {
        if (extractionStrategyCase_ == 10) {
          extractionStrategyCase_ = 0;
          extractionStrategy_ = null;
          onChanged();
        }
      } else {
        if (extractionStrategyCase_ == 10) {
          extractionStrategyCase_ = 0;
          extractionStrategy_ = null;
        }
        intervalBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Starting from `0s`, create sprites at regular intervals. Specify the
     * interval value in seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval = 10;</code>
     */
    public com.google.protobuf.Duration.Builder getIntervalBuilder() {
      return getIntervalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Starting from `0s`, create sprites at regular intervals. Specify the
     * interval value in seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval = 10;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getIntervalOrBuilder() {
      if ((extractionStrategyCase_ == 10) && (intervalBuilder_ != null)) {
        return intervalBuilder_.getMessageOrBuilder();
      } else {
        if (extractionStrategyCase_ == 10) {
          return (com.google.protobuf.Duration) extractionStrategy_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Starting from `0s`, create sprites at regular intervals. Specify the
     * interval value in seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getIntervalFieldBuilder() {
      if (intervalBuilder_ == null) {
        if (!(extractionStrategyCase_ == 10)) {
          extractionStrategy_ = com.google.protobuf.Duration.getDefaultInstance();
        }
        intervalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                (com.google.protobuf.Duration) extractionStrategy_,
                getParentForChildren(),
                isClean());
        extractionStrategy_ = null;
      }
      extractionStrategyCase_ = 10;
      onChanged();
      ;
      return intervalBuilder_;
    }

    private int quality_;
    /**
     *
     *
     * <pre>
     * The quality of the generated sprite sheet. Enter a value between 1
     * and 100, where 1 is the lowest quality and 100 is the highest quality.
     * The default is 100. A high quality value corresponds to a low image data
     * compression ratio.
     * </pre>
     *
     * <code>int32 quality = 11;</code>
     *
     * @return The quality.
     */
    @java.lang.Override
    public int getQuality() {
      return quality_;
    }
    /**
     *
     *
     * <pre>
     * The quality of the generated sprite sheet. Enter a value between 1
     * and 100, where 1 is the lowest quality and 100 is the highest quality.
     * The default is 100. A high quality value corresponds to a low image data
     * compression ratio.
     * </pre>
     *
     * <code>int32 quality = 11;</code>
     *
     * @param value The quality to set.
     * @return This builder for chaining.
     */
    public Builder setQuality(int value) {

      quality_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The quality of the generated sprite sheet. Enter a value between 1
     * and 100, where 1 is the lowest quality and 100 is the highest quality.
     * The default is 100. A high quality value corresponds to a low image data
     * compression ratio.
     * </pre>
     *
     * <code>int32 quality = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuality() {

      quality_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.SpriteSheet)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.SpriteSheet)
  private static final com.google.cloud.video.transcoder.v1.SpriteSheet DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.SpriteSheet();
  }

  public static com.google.cloud.video.transcoder.v1.SpriteSheet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpriteSheet> PARSER =
      new com.google.protobuf.AbstractParser<SpriteSheet>() {
        @java.lang.Override
        public SpriteSheet parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SpriteSheet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpriteSheet> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.SpriteSheet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
