/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/video/transcoder/v1/resources.proto

package com.google.cloud.video.transcoder.v1;

/**
 *
 *
 * <pre>
 * Preprocessing configurations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig}
 */
public final class PreprocessingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.PreprocessingConfig)
    PreprocessingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PreprocessingConfig.newBuilder() to construct.
  private PreprocessingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PreprocessingConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PreprocessingConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.class,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Builder.class);
  }

  public interface ColorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.PreprocessingConfig.Color)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Control color saturation of the video. Enter a value between -1 and 1,
     * where -1 is fully desaturated and 1 is maximum saturation. 0 is no
     * change. The default is 0.
     * </pre>
     *
     * <code>double saturation = 1;</code>
     *
     * @return The saturation.
     */
    double getSaturation();

    /**
     *
     *
     * <pre>
     * Control black and white contrast of the video. Enter a value between -1
     * and 1, where -1 is minimum contrast and 1 is maximum contrast. 0 is no
     * change. The default is 0.
     * </pre>
     *
     * <code>double contrast = 2;</code>
     *
     * @return The contrast.
     */
    double getContrast();

    /**
     *
     *
     * <pre>
     * Control brightness of the video. Enter a value between -1 and 1, where -1
     * is minimum brightness and 1 is maximum brightness. 0 is no change. The
     * default is 0.
     * </pre>
     *
     * <code>double brightness = 3;</code>
     *
     * @return The brightness.
     */
    double getBrightness();
  }
  /**
   *
   *
   * <pre>
   * Color preprocessing configuration.
   * **Note:** This configuration is not supported.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig.Color}
   */
  public static final class Color extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.PreprocessingConfig.Color)
      ColorOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Color.newBuilder() to construct.
    private Color(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Color() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Color();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Color_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Color_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.class,
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.Builder.class);
    }

    public static final int SATURATION_FIELD_NUMBER = 1;
    private double saturation_;
    /**
     *
     *
     * <pre>
     * Control color saturation of the video. Enter a value between -1 and 1,
     * where -1 is fully desaturated and 1 is maximum saturation. 0 is no
     * change. The default is 0.
     * </pre>
     *
     * <code>double saturation = 1;</code>
     *
     * @return The saturation.
     */
    @java.lang.Override
    public double getSaturation() {
      return saturation_;
    }

    public static final int CONTRAST_FIELD_NUMBER = 2;
    private double contrast_;
    /**
     *
     *
     * <pre>
     * Control black and white contrast of the video. Enter a value between -1
     * and 1, where -1 is minimum contrast and 1 is maximum contrast. 0 is no
     * change. The default is 0.
     * </pre>
     *
     * <code>double contrast = 2;</code>
     *
     * @return The contrast.
     */
    @java.lang.Override
    public double getContrast() {
      return contrast_;
    }

    public static final int BRIGHTNESS_FIELD_NUMBER = 3;
    private double brightness_;
    /**
     *
     *
     * <pre>
     * Control brightness of the video. Enter a value between -1 and 1, where -1
     * is minimum brightness and 1 is maximum brightness. 0 is no change. The
     * default is 0.
     * </pre>
     *
     * <code>double brightness = 3;</code>
     *
     * @return The brightness.
     */
    @java.lang.Override
    public double getBrightness() {
      return brightness_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(saturation_) != 0) {
        output.writeDouble(1, saturation_);
      }
      if (java.lang.Double.doubleToRawLongBits(contrast_) != 0) {
        output.writeDouble(2, contrast_);
      }
      if (java.lang.Double.doubleToRawLongBits(brightness_) != 0) {
        output.writeDouble(3, brightness_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(saturation_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, saturation_);
      }
      if (java.lang.Double.doubleToRawLongBits(contrast_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, contrast_);
      }
      if (java.lang.Double.doubleToRawLongBits(brightness_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, brightness_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color other =
          (com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color) obj;

      if (java.lang.Double.doubleToLongBits(getSaturation())
          != java.lang.Double.doubleToLongBits(other.getSaturation())) return false;
      if (java.lang.Double.doubleToLongBits(getContrast())
          != java.lang.Double.doubleToLongBits(other.getContrast())) return false;
      if (java.lang.Double.doubleToLongBits(getBrightness())
          != java.lang.Double.doubleToLongBits(other.getBrightness())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SATURATION_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getSaturation()));
      hash = (37 * hash) + CONTRAST_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getContrast()));
      hash = (37 * hash) + BRIGHTNESS_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getBrightness()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Color preprocessing configuration.
     * **Note:** This configuration is not supported.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig.Color}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.PreprocessingConfig.Color)
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.ColorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Color_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Color_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.class,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.Builder.class);
      }

      // Construct using com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        saturation_ = 0D;

        contrast_ = 0D;

        brightness_ = 0D;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Color_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color build() {
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color buildPartial() {
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color result =
            new com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color(this);
        result.saturation_ = saturation_;
        result.contrast_ = contrast_;
        result.brightness_ = brightness_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color) {
          return mergeFrom((com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color other) {
        if (other
            == com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.getDefaultInstance())
          return this;
        if (other.getSaturation() != 0D) {
          setSaturation(other.getSaturation());
        }
        if (other.getContrast() != 0D) {
          setContrast(other.getContrast());
        }
        if (other.getBrightness() != 0D) {
          setBrightness(other.getBrightness());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  saturation_ = input.readDouble();

                  break;
                } // case 9
              case 17:
                {
                  contrast_ = input.readDouble();

                  break;
                } // case 17
              case 25:
                {
                  brightness_ = input.readDouble();

                  break;
                } // case 25
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private double saturation_;
      /**
       *
       *
       * <pre>
       * Control color saturation of the video. Enter a value between -1 and 1,
       * where -1 is fully desaturated and 1 is maximum saturation. 0 is no
       * change. The default is 0.
       * </pre>
       *
       * <code>double saturation = 1;</code>
       *
       * @return The saturation.
       */
      @java.lang.Override
      public double getSaturation() {
        return saturation_;
      }
      /**
       *
       *
       * <pre>
       * Control color saturation of the video. Enter a value between -1 and 1,
       * where -1 is fully desaturated and 1 is maximum saturation. 0 is no
       * change. The default is 0.
       * </pre>
       *
       * <code>double saturation = 1;</code>
       *
       * @param value The saturation to set.
       * @return This builder for chaining.
       */
      public Builder setSaturation(double value) {

        saturation_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Control color saturation of the video. Enter a value between -1 and 1,
       * where -1 is fully desaturated and 1 is maximum saturation. 0 is no
       * change. The default is 0.
       * </pre>
       *
       * <code>double saturation = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSaturation() {

        saturation_ = 0D;
        onChanged();
        return this;
      }

      private double contrast_;
      /**
       *
       *
       * <pre>
       * Control black and white contrast of the video. Enter a value between -1
       * and 1, where -1 is minimum contrast and 1 is maximum contrast. 0 is no
       * change. The default is 0.
       * </pre>
       *
       * <code>double contrast = 2;</code>
       *
       * @return The contrast.
       */
      @java.lang.Override
      public double getContrast() {
        return contrast_;
      }
      /**
       *
       *
       * <pre>
       * Control black and white contrast of the video. Enter a value between -1
       * and 1, where -1 is minimum contrast and 1 is maximum contrast. 0 is no
       * change. The default is 0.
       * </pre>
       *
       * <code>double contrast = 2;</code>
       *
       * @param value The contrast to set.
       * @return This builder for chaining.
       */
      public Builder setContrast(double value) {

        contrast_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Control black and white contrast of the video. Enter a value between -1
       * and 1, where -1 is minimum contrast and 1 is maximum contrast. 0 is no
       * change. The default is 0.
       * </pre>
       *
       * <code>double contrast = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContrast() {

        contrast_ = 0D;
        onChanged();
        return this;
      }

      private double brightness_;
      /**
       *
       *
       * <pre>
       * Control brightness of the video. Enter a value between -1 and 1, where -1
       * is minimum brightness and 1 is maximum brightness. 0 is no change. The
       * default is 0.
       * </pre>
       *
       * <code>double brightness = 3;</code>
       *
       * @return The brightness.
       */
      @java.lang.Override
      public double getBrightness() {
        return brightness_;
      }
      /**
       *
       *
       * <pre>
       * Control brightness of the video. Enter a value between -1 and 1, where -1
       * is minimum brightness and 1 is maximum brightness. 0 is no change. The
       * default is 0.
       * </pre>
       *
       * <code>double brightness = 3;</code>
       *
       * @param value The brightness to set.
       * @return This builder for chaining.
       */
      public Builder setBrightness(double value) {

        brightness_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Control brightness of the video. Enter a value between -1 and 1, where -1
       * is minimum brightness and 1 is maximum brightness. 0 is no change. The
       * default is 0.
       * </pre>
       *
       * <code>double brightness = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBrightness() {

        brightness_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.PreprocessingConfig.Color)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.PreprocessingConfig.Color)
    private static final com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color();
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Color> PARSER =
        new com.google.protobuf.AbstractParser<Color>() {
          @java.lang.Override
          public Color parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Color> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Color> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DenoiseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Set strength of the denoise. Enter a value between 0 and 1. The higher
     * the value, the smoother the image. 0 is no denoising. The default is 0.
     * </pre>
     *
     * <code>double strength = 1;</code>
     *
     * @return The strength.
     */
    double getStrength();

    /**
     *
     *
     * <pre>
     * Set the denoiser mode. The default is `standard`.
     * Supported denoiser modes:
     * - `standard`
     * - `grain`
     * </pre>
     *
     * <code>string tune = 2;</code>
     *
     * @return The tune.
     */
    java.lang.String getTune();
    /**
     *
     *
     * <pre>
     * Set the denoiser mode. The default is `standard`.
     * Supported denoiser modes:
     * - `standard`
     * - `grain`
     * </pre>
     *
     * <code>string tune = 2;</code>
     *
     * @return The bytes for tune.
     */
    com.google.protobuf.ByteString getTuneBytes();
  }
  /**
   *
   *
   * <pre>
   * Denoise preprocessing configuration.
   * **Note:** This configuration is not supported.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise}
   */
  public static final class Denoise extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise)
      DenoiseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Denoise.newBuilder() to construct.
    private Denoise(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Denoise() {
      tune_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Denoise();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Denoise_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Denoise_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.class,
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.Builder.class);
    }

    public static final int STRENGTH_FIELD_NUMBER = 1;
    private double strength_;
    /**
     *
     *
     * <pre>
     * Set strength of the denoise. Enter a value between 0 and 1. The higher
     * the value, the smoother the image. 0 is no denoising. The default is 0.
     * </pre>
     *
     * <code>double strength = 1;</code>
     *
     * @return The strength.
     */
    @java.lang.Override
    public double getStrength() {
      return strength_;
    }

    public static final int TUNE_FIELD_NUMBER = 2;
    private volatile java.lang.Object tune_;
    /**
     *
     *
     * <pre>
     * Set the denoiser mode. The default is `standard`.
     * Supported denoiser modes:
     * - `standard`
     * - `grain`
     * </pre>
     *
     * <code>string tune = 2;</code>
     *
     * @return The tune.
     */
    @java.lang.Override
    public java.lang.String getTune() {
      java.lang.Object ref = tune_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tune_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Set the denoiser mode. The default is `standard`.
     * Supported denoiser modes:
     * - `standard`
     * - `grain`
     * </pre>
     *
     * <code>string tune = 2;</code>
     *
     * @return The bytes for tune.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTuneBytes() {
      java.lang.Object ref = tune_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tune_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(strength_) != 0) {
        output.writeDouble(1, strength_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tune_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, tune_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(strength_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, strength_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tune_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, tune_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise other =
          (com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise) obj;

      if (java.lang.Double.doubleToLongBits(getStrength())
          != java.lang.Double.doubleToLongBits(other.getStrength())) return false;
      if (!getTune().equals(other.getTune())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STRENGTH_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getStrength()));
      hash = (37 * hash) + TUNE_FIELD_NUMBER;
      hash = (53 * hash) + getTune().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Denoise preprocessing configuration.
     * **Note:** This configuration is not supported.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise)
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.DenoiseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Denoise_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Denoise_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.class,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.Builder.class);
      }

      // Construct using
      // com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        strength_ = 0D;

        tune_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Denoise_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise build() {
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise buildPartial() {
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise result =
            new com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise(this);
        result.strength_ = strength_;
        result.tune_ = tune_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise) {
          return mergeFrom(
              (com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise other) {
        if (other
            == com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise
                .getDefaultInstance()) return this;
        if (other.getStrength() != 0D) {
          setStrength(other.getStrength());
        }
        if (!other.getTune().isEmpty()) {
          tune_ = other.tune_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  strength_ = input.readDouble();

                  break;
                } // case 9
              case 18:
                {
                  tune_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private double strength_;
      /**
       *
       *
       * <pre>
       * Set strength of the denoise. Enter a value between 0 and 1. The higher
       * the value, the smoother the image. 0 is no denoising. The default is 0.
       * </pre>
       *
       * <code>double strength = 1;</code>
       *
       * @return The strength.
       */
      @java.lang.Override
      public double getStrength() {
        return strength_;
      }
      /**
       *
       *
       * <pre>
       * Set strength of the denoise. Enter a value between 0 and 1. The higher
       * the value, the smoother the image. 0 is no denoising. The default is 0.
       * </pre>
       *
       * <code>double strength = 1;</code>
       *
       * @param value The strength to set.
       * @return This builder for chaining.
       */
      public Builder setStrength(double value) {

        strength_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set strength of the denoise. Enter a value between 0 and 1. The higher
       * the value, the smoother the image. 0 is no denoising. The default is 0.
       * </pre>
       *
       * <code>double strength = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStrength() {

        strength_ = 0D;
        onChanged();
        return this;
      }

      private java.lang.Object tune_ = "";
      /**
       *
       *
       * <pre>
       * Set the denoiser mode. The default is `standard`.
       * Supported denoiser modes:
       * - `standard`
       * - `grain`
       * </pre>
       *
       * <code>string tune = 2;</code>
       *
       * @return The tune.
       */
      public java.lang.String getTune() {
        java.lang.Object ref = tune_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tune_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Set the denoiser mode. The default is `standard`.
       * Supported denoiser modes:
       * - `standard`
       * - `grain`
       * </pre>
       *
       * <code>string tune = 2;</code>
       *
       * @return The bytes for tune.
       */
      public com.google.protobuf.ByteString getTuneBytes() {
        java.lang.Object ref = tune_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tune_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Set the denoiser mode. The default is `standard`.
       * Supported denoiser modes:
       * - `standard`
       * - `grain`
       * </pre>
       *
       * <code>string tune = 2;</code>
       *
       * @param value The tune to set.
       * @return This builder for chaining.
       */
      public Builder setTune(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        tune_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set the denoiser mode. The default is `standard`.
       * Supported denoiser modes:
       * - `standard`
       * - `grain`
       * </pre>
       *
       * <code>string tune = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTune() {

        tune_ = getDefaultInstance().getTune();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set the denoiser mode. The default is `standard`.
       * Supported denoiser modes:
       * - `standard`
       * - `grain`
       * </pre>
       *
       * <code>string tune = 2;</code>
       *
       * @param value The bytes for tune to set.
       * @return This builder for chaining.
       */
      public Builder setTuneBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        tune_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise)
    private static final com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise();
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Denoise> PARSER =
        new com.google.protobuf.AbstractParser<Denoise>() {
          @java.lang.Override
          public Denoise parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Denoise> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Denoise> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeblockOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Set strength of the deblocker. Enter a value between 0 and 1. The higher
     * the value, the stronger the block removal. 0 is no deblocking. The
     * default is 0.
     * </pre>
     *
     * <code>double strength = 1;</code>
     *
     * @return The strength.
     */
    double getStrength();

    /**
     *
     *
     * <pre>
     * Enable deblocker. The default is `false`.
     * </pre>
     *
     * <code>bool enabled = 2;</code>
     *
     * @return The enabled.
     */
    boolean getEnabled();
  }
  /**
   *
   *
   * <pre>
   * Deblock preprocessing configuration.
   * **Note:** This configuration is not supported.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock}
   */
  public static final class Deblock extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock)
      DeblockOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Deblock.newBuilder() to construct.
    private Deblock(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Deblock() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Deblock();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Deblock_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Deblock_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.class,
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.Builder.class);
    }

    public static final int STRENGTH_FIELD_NUMBER = 1;
    private double strength_;
    /**
     *
     *
     * <pre>
     * Set strength of the deblocker. Enter a value between 0 and 1. The higher
     * the value, the stronger the block removal. 0 is no deblocking. The
     * default is 0.
     * </pre>
     *
     * <code>double strength = 1;</code>
     *
     * @return The strength.
     */
    @java.lang.Override
    public double getStrength() {
      return strength_;
    }

    public static final int ENABLED_FIELD_NUMBER = 2;
    private boolean enabled_;
    /**
     *
     *
     * <pre>
     * Enable deblocker. The default is `false`.
     * </pre>
     *
     * <code>bool enabled = 2;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(strength_) != 0) {
        output.writeDouble(1, strength_);
      }
      if (enabled_ != false) {
        output.writeBool(2, enabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(strength_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, strength_);
      }
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, enabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock other =
          (com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock) obj;

      if (java.lang.Double.doubleToLongBits(getStrength())
          != java.lang.Double.doubleToLongBits(other.getStrength())) return false;
      if (getEnabled() != other.getEnabled()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STRENGTH_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getStrength()));
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Deblock preprocessing configuration.
     * **Note:** This configuration is not supported.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock)
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.DeblockOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Deblock_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Deblock_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.class,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.Builder.class);
      }

      // Construct using
      // com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        strength_ = 0D;

        enabled_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Deblock_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock build() {
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock buildPartial() {
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock result =
            new com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock(this);
        result.strength_ = strength_;
        result.enabled_ = enabled_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock) {
          return mergeFrom(
              (com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock other) {
        if (other
            == com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock
                .getDefaultInstance()) return this;
        if (other.getStrength() != 0D) {
          setStrength(other.getStrength());
        }
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  strength_ = input.readDouble();

                  break;
                } // case 9
              case 16:
                {
                  enabled_ = input.readBool();

                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private double strength_;
      /**
       *
       *
       * <pre>
       * Set strength of the deblocker. Enter a value between 0 and 1. The higher
       * the value, the stronger the block removal. 0 is no deblocking. The
       * default is 0.
       * </pre>
       *
       * <code>double strength = 1;</code>
       *
       * @return The strength.
       */
      @java.lang.Override
      public double getStrength() {
        return strength_;
      }
      /**
       *
       *
       * <pre>
       * Set strength of the deblocker. Enter a value between 0 and 1. The higher
       * the value, the stronger the block removal. 0 is no deblocking. The
       * default is 0.
       * </pre>
       *
       * <code>double strength = 1;</code>
       *
       * @param value The strength to set.
       * @return This builder for chaining.
       */
      public Builder setStrength(double value) {

        strength_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Set strength of the deblocker. Enter a value between 0 and 1. The higher
       * the value, the stronger the block removal. 0 is no deblocking. The
       * default is 0.
       * </pre>
       *
       * <code>double strength = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStrength() {

        strength_ = 0D;
        onChanged();
        return this;
      }

      private boolean enabled_;
      /**
       *
       *
       * <pre>
       * Enable deblocker. The default is `false`.
       * </pre>
       *
       * <code>bool enabled = 2;</code>
       *
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       *
       *
       * <pre>
       * Enable deblocker. The default is `false`.
       * </pre>
       *
       * <code>bool enabled = 2;</code>
       *
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {

        enabled_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enable deblocker. The default is `false`.
       * </pre>
       *
       * <code>bool enabled = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {

        enabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock)
    private static final com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock();
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Deblock> PARSER =
        new com.google.protobuf.AbstractParser<Deblock>() {
          @java.lang.Override
          public Deblock parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Deblock> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Deblock> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AudioOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.PreprocessingConfig.Audio)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specify audio loudness normalization in loudness units relative to full
     * scale (LUFS). Enter a value between -24 and 0 (the default), where:
     * *   -24 is the Advanced Television Systems Committee (ATSC A/85) standard
     * *   -23 is the EU R128 broadcast standard
     * *   -19 is the prior standard for online mono audio
     * *   -18 is the ReplayGain standard
     * *   -16 is the prior standard for stereo audio
     * *   -14 is the new online audio standard recommended by Spotify, as well
     *     as Amazon Echo
     * *   0 disables normalization
     * </pre>
     *
     * <code>double lufs = 1;</code>
     *
     * @return The lufs.
     */
    double getLufs();

    /**
     *
     *
     * <pre>
     * Enable boosting high frequency components. The default is `false`.
     * **Note:** This field is not supported.
     * </pre>
     *
     * <code>bool high_boost = 2;</code>
     *
     * @return The highBoost.
     */
    boolean getHighBoost();

    /**
     *
     *
     * <pre>
     * Enable boosting low frequency components. The default is `false`.
     * **Note:** This field is not supported.
     * </pre>
     *
     * <code>bool low_boost = 3;</code>
     *
     * @return The lowBoost.
     */
    boolean getLowBoost();
  }
  /**
   *
   *
   * <pre>
   * Audio preprocessing configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig.Audio}
   */
  public static final class Audio extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.PreprocessingConfig.Audio)
      AudioOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Audio.newBuilder() to construct.
    private Audio(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Audio() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Audio();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Audio_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Audio_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.class,
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.Builder.class);
    }

    public static final int LUFS_FIELD_NUMBER = 1;
    private double lufs_;
    /**
     *
     *
     * <pre>
     * Specify audio loudness normalization in loudness units relative to full
     * scale (LUFS). Enter a value between -24 and 0 (the default), where:
     * *   -24 is the Advanced Television Systems Committee (ATSC A/85) standard
     * *   -23 is the EU R128 broadcast standard
     * *   -19 is the prior standard for online mono audio
     * *   -18 is the ReplayGain standard
     * *   -16 is the prior standard for stereo audio
     * *   -14 is the new online audio standard recommended by Spotify, as well
     *     as Amazon Echo
     * *   0 disables normalization
     * </pre>
     *
     * <code>double lufs = 1;</code>
     *
     * @return The lufs.
     */
    @java.lang.Override
    public double getLufs() {
      return lufs_;
    }

    public static final int HIGH_BOOST_FIELD_NUMBER = 2;
    private boolean highBoost_;
    /**
     *
     *
     * <pre>
     * Enable boosting high frequency components. The default is `false`.
     * **Note:** This field is not supported.
     * </pre>
     *
     * <code>bool high_boost = 2;</code>
     *
     * @return The highBoost.
     */
    @java.lang.Override
    public boolean getHighBoost() {
      return highBoost_;
    }

    public static final int LOW_BOOST_FIELD_NUMBER = 3;
    private boolean lowBoost_;
    /**
     *
     *
     * <pre>
     * Enable boosting low frequency components. The default is `false`.
     * **Note:** This field is not supported.
     * </pre>
     *
     * <code>bool low_boost = 3;</code>
     *
     * @return The lowBoost.
     */
    @java.lang.Override
    public boolean getLowBoost() {
      return lowBoost_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(lufs_) != 0) {
        output.writeDouble(1, lufs_);
      }
      if (highBoost_ != false) {
        output.writeBool(2, highBoost_);
      }
      if (lowBoost_ != false) {
        output.writeBool(3, lowBoost_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(lufs_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, lufs_);
      }
      if (highBoost_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, highBoost_);
      }
      if (lowBoost_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, lowBoost_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio other =
          (com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio) obj;

      if (java.lang.Double.doubleToLongBits(getLufs())
          != java.lang.Double.doubleToLongBits(other.getLufs())) return false;
      if (getHighBoost() != other.getHighBoost()) return false;
      if (getLowBoost() != other.getLowBoost()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LUFS_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getLufs()));
      hash = (37 * hash) + HIGH_BOOST_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHighBoost());
      hash = (37 * hash) + LOW_BOOST_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getLowBoost());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Audio preprocessing configuration.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig.Audio}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.PreprocessingConfig.Audio)
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.AudioOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Audio_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Audio_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.class,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.Builder.class);
      }

      // Construct using com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        lufs_ = 0D;

        highBoost_ = false;

        lowBoost_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Audio_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio build() {
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio buildPartial() {
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio result =
            new com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio(this);
        result.lufs_ = lufs_;
        result.highBoost_ = highBoost_;
        result.lowBoost_ = lowBoost_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio) {
          return mergeFrom((com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio other) {
        if (other
            == com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.getDefaultInstance())
          return this;
        if (other.getLufs() != 0D) {
          setLufs(other.getLufs());
        }
        if (other.getHighBoost() != false) {
          setHighBoost(other.getHighBoost());
        }
        if (other.getLowBoost() != false) {
          setLowBoost(other.getLowBoost());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  lufs_ = input.readDouble();

                  break;
                } // case 9
              case 16:
                {
                  highBoost_ = input.readBool();

                  break;
                } // case 16
              case 24:
                {
                  lowBoost_ = input.readBool();

                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private double lufs_;
      /**
       *
       *
       * <pre>
       * Specify audio loudness normalization in loudness units relative to full
       * scale (LUFS). Enter a value between -24 and 0 (the default), where:
       * *   -24 is the Advanced Television Systems Committee (ATSC A/85) standard
       * *   -23 is the EU R128 broadcast standard
       * *   -19 is the prior standard for online mono audio
       * *   -18 is the ReplayGain standard
       * *   -16 is the prior standard for stereo audio
       * *   -14 is the new online audio standard recommended by Spotify, as well
       *     as Amazon Echo
       * *   0 disables normalization
       * </pre>
       *
       * <code>double lufs = 1;</code>
       *
       * @return The lufs.
       */
      @java.lang.Override
      public double getLufs() {
        return lufs_;
      }
      /**
       *
       *
       * <pre>
       * Specify audio loudness normalization in loudness units relative to full
       * scale (LUFS). Enter a value between -24 and 0 (the default), where:
       * *   -24 is the Advanced Television Systems Committee (ATSC A/85) standard
       * *   -23 is the EU R128 broadcast standard
       * *   -19 is the prior standard for online mono audio
       * *   -18 is the ReplayGain standard
       * *   -16 is the prior standard for stereo audio
       * *   -14 is the new online audio standard recommended by Spotify, as well
       *     as Amazon Echo
       * *   0 disables normalization
       * </pre>
       *
       * <code>double lufs = 1;</code>
       *
       * @param value The lufs to set.
       * @return This builder for chaining.
       */
      public Builder setLufs(double value) {

        lufs_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specify audio loudness normalization in loudness units relative to full
       * scale (LUFS). Enter a value between -24 and 0 (the default), where:
       * *   -24 is the Advanced Television Systems Committee (ATSC A/85) standard
       * *   -23 is the EU R128 broadcast standard
       * *   -19 is the prior standard for online mono audio
       * *   -18 is the ReplayGain standard
       * *   -16 is the prior standard for stereo audio
       * *   -14 is the new online audio standard recommended by Spotify, as well
       *     as Amazon Echo
       * *   0 disables normalization
       * </pre>
       *
       * <code>double lufs = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLufs() {

        lufs_ = 0D;
        onChanged();
        return this;
      }

      private boolean highBoost_;
      /**
       *
       *
       * <pre>
       * Enable boosting high frequency components. The default is `false`.
       * **Note:** This field is not supported.
       * </pre>
       *
       * <code>bool high_boost = 2;</code>
       *
       * @return The highBoost.
       */
      @java.lang.Override
      public boolean getHighBoost() {
        return highBoost_;
      }
      /**
       *
       *
       * <pre>
       * Enable boosting high frequency components. The default is `false`.
       * **Note:** This field is not supported.
       * </pre>
       *
       * <code>bool high_boost = 2;</code>
       *
       * @param value The highBoost to set.
       * @return This builder for chaining.
       */
      public Builder setHighBoost(boolean value) {

        highBoost_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enable boosting high frequency components. The default is `false`.
       * **Note:** This field is not supported.
       * </pre>
       *
       * <code>bool high_boost = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHighBoost() {

        highBoost_ = false;
        onChanged();
        return this;
      }

      private boolean lowBoost_;
      /**
       *
       *
       * <pre>
       * Enable boosting low frequency components. The default is `false`.
       * **Note:** This field is not supported.
       * </pre>
       *
       * <code>bool low_boost = 3;</code>
       *
       * @return The lowBoost.
       */
      @java.lang.Override
      public boolean getLowBoost() {
        return lowBoost_;
      }
      /**
       *
       *
       * <pre>
       * Enable boosting low frequency components. The default is `false`.
       * **Note:** This field is not supported.
       * </pre>
       *
       * <code>bool low_boost = 3;</code>
       *
       * @param value The lowBoost to set.
       * @return This builder for chaining.
       */
      public Builder setLowBoost(boolean value) {

        lowBoost_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enable boosting low frequency components. The default is `false`.
       * **Note:** This field is not supported.
       * </pre>
       *
       * <code>bool low_boost = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLowBoost() {

        lowBoost_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.PreprocessingConfig.Audio)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.PreprocessingConfig.Audio)
    private static final com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio();
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Audio> PARSER =
        new com.google.protobuf.AbstractParser<Audio>() {
          @java.lang.Override
          public Audio parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Audio> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Audio> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CropOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.PreprocessingConfig.Crop)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The number of pixels to crop from the top. The default is 0.
     * </pre>
     *
     * <code>int32 top_pixels = 1;</code>
     *
     * @return The topPixels.
     */
    int getTopPixels();

    /**
     *
     *
     * <pre>
     * The number of pixels to crop from the bottom. The default is 0.
     * </pre>
     *
     * <code>int32 bottom_pixels = 2;</code>
     *
     * @return The bottomPixels.
     */
    int getBottomPixels();

    /**
     *
     *
     * <pre>
     * The number of pixels to crop from the left. The default is 0.
     * </pre>
     *
     * <code>int32 left_pixels = 3;</code>
     *
     * @return The leftPixels.
     */
    int getLeftPixels();

    /**
     *
     *
     * <pre>
     * The number of pixels to crop from the right. The default is 0.
     * </pre>
     *
     * <code>int32 right_pixels = 4;</code>
     *
     * @return The rightPixels.
     */
    int getRightPixels();
  }
  /**
   *
   *
   * <pre>
   * Video cropping configuration for the input video. The cropped input video
   * is scaled to match the output resolution.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig.Crop}
   */
  public static final class Crop extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.PreprocessingConfig.Crop)
      CropOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Crop.newBuilder() to construct.
    private Crop(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Crop() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Crop();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Crop_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Crop_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.class,
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.Builder.class);
    }

    public static final int TOP_PIXELS_FIELD_NUMBER = 1;
    private int topPixels_;
    /**
     *
     *
     * <pre>
     * The number of pixels to crop from the top. The default is 0.
     * </pre>
     *
     * <code>int32 top_pixels = 1;</code>
     *
     * @return The topPixels.
     */
    @java.lang.Override
    public int getTopPixels() {
      return topPixels_;
    }

    public static final int BOTTOM_PIXELS_FIELD_NUMBER = 2;
    private int bottomPixels_;
    /**
     *
     *
     * <pre>
     * The number of pixels to crop from the bottom. The default is 0.
     * </pre>
     *
     * <code>int32 bottom_pixels = 2;</code>
     *
     * @return The bottomPixels.
     */
    @java.lang.Override
    public int getBottomPixels() {
      return bottomPixels_;
    }

    public static final int LEFT_PIXELS_FIELD_NUMBER = 3;
    private int leftPixels_;
    /**
     *
     *
     * <pre>
     * The number of pixels to crop from the left. The default is 0.
     * </pre>
     *
     * <code>int32 left_pixels = 3;</code>
     *
     * @return The leftPixels.
     */
    @java.lang.Override
    public int getLeftPixels() {
      return leftPixels_;
    }

    public static final int RIGHT_PIXELS_FIELD_NUMBER = 4;
    private int rightPixels_;
    /**
     *
     *
     * <pre>
     * The number of pixels to crop from the right. The default is 0.
     * </pre>
     *
     * <code>int32 right_pixels = 4;</code>
     *
     * @return The rightPixels.
     */
    @java.lang.Override
    public int getRightPixels() {
      return rightPixels_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (topPixels_ != 0) {
        output.writeInt32(1, topPixels_);
      }
      if (bottomPixels_ != 0) {
        output.writeInt32(2, bottomPixels_);
      }
      if (leftPixels_ != 0) {
        output.writeInt32(3, leftPixels_);
      }
      if (rightPixels_ != 0) {
        output.writeInt32(4, rightPixels_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (topPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, topPixels_);
      }
      if (bottomPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, bottomPixels_);
      }
      if (leftPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, leftPixels_);
      }
      if (rightPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, rightPixels_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop other =
          (com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop) obj;

      if (getTopPixels() != other.getTopPixels()) return false;
      if (getBottomPixels() != other.getBottomPixels()) return false;
      if (getLeftPixels() != other.getLeftPixels()) return false;
      if (getRightPixels() != other.getRightPixels()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TOP_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getTopPixels();
      hash = (37 * hash) + BOTTOM_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getBottomPixels();
      hash = (37 * hash) + LEFT_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getLeftPixels();
      hash = (37 * hash) + RIGHT_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getRightPixels();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Video cropping configuration for the input video. The cropped input video
     * is scaled to match the output resolution.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig.Crop}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.PreprocessingConfig.Crop)
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.CropOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Crop_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Crop_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.class,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.Builder.class);
      }

      // Construct using com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        topPixels_ = 0;

        bottomPixels_ = 0;

        leftPixels_ = 0;

        rightPixels_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Crop_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop build() {
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop buildPartial() {
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop result =
            new com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop(this);
        result.topPixels_ = topPixels_;
        result.bottomPixels_ = bottomPixels_;
        result.leftPixels_ = leftPixels_;
        result.rightPixels_ = rightPixels_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop) {
          return mergeFrom((com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop other) {
        if (other
            == com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.getDefaultInstance())
          return this;
        if (other.getTopPixels() != 0) {
          setTopPixels(other.getTopPixels());
        }
        if (other.getBottomPixels() != 0) {
          setBottomPixels(other.getBottomPixels());
        }
        if (other.getLeftPixels() != 0) {
          setLeftPixels(other.getLeftPixels());
        }
        if (other.getRightPixels() != 0) {
          setRightPixels(other.getRightPixels());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  topPixels_ = input.readInt32();

                  break;
                } // case 8
              case 16:
                {
                  bottomPixels_ = input.readInt32();

                  break;
                } // case 16
              case 24:
                {
                  leftPixels_ = input.readInt32();

                  break;
                } // case 24
              case 32:
                {
                  rightPixels_ = input.readInt32();

                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int topPixels_;
      /**
       *
       *
       * <pre>
       * The number of pixels to crop from the top. The default is 0.
       * </pre>
       *
       * <code>int32 top_pixels = 1;</code>
       *
       * @return The topPixels.
       */
      @java.lang.Override
      public int getTopPixels() {
        return topPixels_;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to crop from the top. The default is 0.
       * </pre>
       *
       * <code>int32 top_pixels = 1;</code>
       *
       * @param value The topPixels to set.
       * @return This builder for chaining.
       */
      public Builder setTopPixels(int value) {

        topPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to crop from the top. The default is 0.
       * </pre>
       *
       * <code>int32 top_pixels = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopPixels() {

        topPixels_ = 0;
        onChanged();
        return this;
      }

      private int bottomPixels_;
      /**
       *
       *
       * <pre>
       * The number of pixels to crop from the bottom. The default is 0.
       * </pre>
       *
       * <code>int32 bottom_pixels = 2;</code>
       *
       * @return The bottomPixels.
       */
      @java.lang.Override
      public int getBottomPixels() {
        return bottomPixels_;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to crop from the bottom. The default is 0.
       * </pre>
       *
       * <code>int32 bottom_pixels = 2;</code>
       *
       * @param value The bottomPixels to set.
       * @return This builder for chaining.
       */
      public Builder setBottomPixels(int value) {

        bottomPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to crop from the bottom. The default is 0.
       * </pre>
       *
       * <code>int32 bottom_pixels = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBottomPixels() {

        bottomPixels_ = 0;
        onChanged();
        return this;
      }

      private int leftPixels_;
      /**
       *
       *
       * <pre>
       * The number of pixels to crop from the left. The default is 0.
       * </pre>
       *
       * <code>int32 left_pixels = 3;</code>
       *
       * @return The leftPixels.
       */
      @java.lang.Override
      public int getLeftPixels() {
        return leftPixels_;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to crop from the left. The default is 0.
       * </pre>
       *
       * <code>int32 left_pixels = 3;</code>
       *
       * @param value The leftPixels to set.
       * @return This builder for chaining.
       */
      public Builder setLeftPixels(int value) {

        leftPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to crop from the left. The default is 0.
       * </pre>
       *
       * <code>int32 left_pixels = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLeftPixels() {

        leftPixels_ = 0;
        onChanged();
        return this;
      }

      private int rightPixels_;
      /**
       *
       *
       * <pre>
       * The number of pixels to crop from the right. The default is 0.
       * </pre>
       *
       * <code>int32 right_pixels = 4;</code>
       *
       * @return The rightPixels.
       */
      @java.lang.Override
      public int getRightPixels() {
        return rightPixels_;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to crop from the right. The default is 0.
       * </pre>
       *
       * <code>int32 right_pixels = 4;</code>
       *
       * @param value The rightPixels to set.
       * @return This builder for chaining.
       */
      public Builder setRightPixels(int value) {

        rightPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to crop from the right. The default is 0.
       * </pre>
       *
       * <code>int32 right_pixels = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRightPixels() {

        rightPixels_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.PreprocessingConfig.Crop)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.PreprocessingConfig.Crop)
    private static final com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop();
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Crop> PARSER =
        new com.google.protobuf.AbstractParser<Crop>() {
          @java.lang.Override
          public Crop parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Crop> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Crop> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PadOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.PreprocessingConfig.Pad)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The number of pixels to add to the top. The default is 0.
     * </pre>
     *
     * <code>int32 top_pixels = 1;</code>
     *
     * @return The topPixels.
     */
    int getTopPixels();

    /**
     *
     *
     * <pre>
     * The number of pixels to add to the bottom. The default is 0.
     * </pre>
     *
     * <code>int32 bottom_pixels = 2;</code>
     *
     * @return The bottomPixels.
     */
    int getBottomPixels();

    /**
     *
     *
     * <pre>
     * The number of pixels to add to the left. The default is 0.
     * </pre>
     *
     * <code>int32 left_pixels = 3;</code>
     *
     * @return The leftPixels.
     */
    int getLeftPixels();

    /**
     *
     *
     * <pre>
     * The number of pixels to add to the right. The default is 0.
     * </pre>
     *
     * <code>int32 right_pixels = 4;</code>
     *
     * @return The rightPixels.
     */
    int getRightPixels();
  }
  /**
   *
   *
   * <pre>
   * Pad filter configuration for the input video. The padded input video
   * is scaled after padding with black to match the output resolution.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig.Pad}
   */
  public static final class Pad extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.PreprocessingConfig.Pad)
      PadOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Pad.newBuilder() to construct.
    private Pad(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Pad() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Pad();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Pad_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Pad_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.class,
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.Builder.class);
    }

    public static final int TOP_PIXELS_FIELD_NUMBER = 1;
    private int topPixels_;
    /**
     *
     *
     * <pre>
     * The number of pixels to add to the top. The default is 0.
     * </pre>
     *
     * <code>int32 top_pixels = 1;</code>
     *
     * @return The topPixels.
     */
    @java.lang.Override
    public int getTopPixels() {
      return topPixels_;
    }

    public static final int BOTTOM_PIXELS_FIELD_NUMBER = 2;
    private int bottomPixels_;
    /**
     *
     *
     * <pre>
     * The number of pixels to add to the bottom. The default is 0.
     * </pre>
     *
     * <code>int32 bottom_pixels = 2;</code>
     *
     * @return The bottomPixels.
     */
    @java.lang.Override
    public int getBottomPixels() {
      return bottomPixels_;
    }

    public static final int LEFT_PIXELS_FIELD_NUMBER = 3;
    private int leftPixels_;
    /**
     *
     *
     * <pre>
     * The number of pixels to add to the left. The default is 0.
     * </pre>
     *
     * <code>int32 left_pixels = 3;</code>
     *
     * @return The leftPixels.
     */
    @java.lang.Override
    public int getLeftPixels() {
      return leftPixels_;
    }

    public static final int RIGHT_PIXELS_FIELD_NUMBER = 4;
    private int rightPixels_;
    /**
     *
     *
     * <pre>
     * The number of pixels to add to the right. The default is 0.
     * </pre>
     *
     * <code>int32 right_pixels = 4;</code>
     *
     * @return The rightPixels.
     */
    @java.lang.Override
    public int getRightPixels() {
      return rightPixels_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (topPixels_ != 0) {
        output.writeInt32(1, topPixels_);
      }
      if (bottomPixels_ != 0) {
        output.writeInt32(2, bottomPixels_);
      }
      if (leftPixels_ != 0) {
        output.writeInt32(3, leftPixels_);
      }
      if (rightPixels_ != 0) {
        output.writeInt32(4, rightPixels_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (topPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, topPixels_);
      }
      if (bottomPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, bottomPixels_);
      }
      if (leftPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, leftPixels_);
      }
      if (rightPixels_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, rightPixels_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad other =
          (com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad) obj;

      if (getTopPixels() != other.getTopPixels()) return false;
      if (getBottomPixels() != other.getBottomPixels()) return false;
      if (getLeftPixels() != other.getLeftPixels()) return false;
      if (getRightPixels() != other.getRightPixels()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TOP_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getTopPixels();
      hash = (37 * hash) + BOTTOM_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getBottomPixels();
      hash = (37 * hash) + LEFT_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getLeftPixels();
      hash = (37 * hash) + RIGHT_PIXELS_FIELD_NUMBER;
      hash = (53 * hash) + getRightPixels();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Pad filter configuration for the input video. The padded input video
     * is scaled after padding with black to match the output resolution.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig.Pad}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.PreprocessingConfig.Pad)
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.PadOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Pad_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Pad_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.class,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.Builder.class);
      }

      // Construct using com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        topPixels_ = 0;

        bottomPixels_ = 0;

        leftPixels_ = 0;

        rightPixels_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_Pad_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad build() {
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad buildPartial() {
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad result =
            new com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad(this);
        result.topPixels_ = topPixels_;
        result.bottomPixels_ = bottomPixels_;
        result.leftPixels_ = leftPixels_;
        result.rightPixels_ = rightPixels_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad) {
          return mergeFrom((com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad other) {
        if (other
            == com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.getDefaultInstance())
          return this;
        if (other.getTopPixels() != 0) {
          setTopPixels(other.getTopPixels());
        }
        if (other.getBottomPixels() != 0) {
          setBottomPixels(other.getBottomPixels());
        }
        if (other.getLeftPixels() != 0) {
          setLeftPixels(other.getLeftPixels());
        }
        if (other.getRightPixels() != 0) {
          setRightPixels(other.getRightPixels());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  topPixels_ = input.readInt32();

                  break;
                } // case 8
              case 16:
                {
                  bottomPixels_ = input.readInt32();

                  break;
                } // case 16
              case 24:
                {
                  leftPixels_ = input.readInt32();

                  break;
                } // case 24
              case 32:
                {
                  rightPixels_ = input.readInt32();

                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int topPixels_;
      /**
       *
       *
       * <pre>
       * The number of pixels to add to the top. The default is 0.
       * </pre>
       *
       * <code>int32 top_pixels = 1;</code>
       *
       * @return The topPixels.
       */
      @java.lang.Override
      public int getTopPixels() {
        return topPixels_;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to add to the top. The default is 0.
       * </pre>
       *
       * <code>int32 top_pixels = 1;</code>
       *
       * @param value The topPixels to set.
       * @return This builder for chaining.
       */
      public Builder setTopPixels(int value) {

        topPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to add to the top. The default is 0.
       * </pre>
       *
       * <code>int32 top_pixels = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopPixels() {

        topPixels_ = 0;
        onChanged();
        return this;
      }

      private int bottomPixels_;
      /**
       *
       *
       * <pre>
       * The number of pixels to add to the bottom. The default is 0.
       * </pre>
       *
       * <code>int32 bottom_pixels = 2;</code>
       *
       * @return The bottomPixels.
       */
      @java.lang.Override
      public int getBottomPixels() {
        return bottomPixels_;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to add to the bottom. The default is 0.
       * </pre>
       *
       * <code>int32 bottom_pixels = 2;</code>
       *
       * @param value The bottomPixels to set.
       * @return This builder for chaining.
       */
      public Builder setBottomPixels(int value) {

        bottomPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to add to the bottom. The default is 0.
       * </pre>
       *
       * <code>int32 bottom_pixels = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBottomPixels() {

        bottomPixels_ = 0;
        onChanged();
        return this;
      }

      private int leftPixels_;
      /**
       *
       *
       * <pre>
       * The number of pixels to add to the left. The default is 0.
       * </pre>
       *
       * <code>int32 left_pixels = 3;</code>
       *
       * @return The leftPixels.
       */
      @java.lang.Override
      public int getLeftPixels() {
        return leftPixels_;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to add to the left. The default is 0.
       * </pre>
       *
       * <code>int32 left_pixels = 3;</code>
       *
       * @param value The leftPixels to set.
       * @return This builder for chaining.
       */
      public Builder setLeftPixels(int value) {

        leftPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to add to the left. The default is 0.
       * </pre>
       *
       * <code>int32 left_pixels = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLeftPixels() {

        leftPixels_ = 0;
        onChanged();
        return this;
      }

      private int rightPixels_;
      /**
       *
       *
       * <pre>
       * The number of pixels to add to the right. The default is 0.
       * </pre>
       *
       * <code>int32 right_pixels = 4;</code>
       *
       * @return The rightPixels.
       */
      @java.lang.Override
      public int getRightPixels() {
        return rightPixels_;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to add to the right. The default is 0.
       * </pre>
       *
       * <code>int32 right_pixels = 4;</code>
       *
       * @param value The rightPixels to set.
       * @return This builder for chaining.
       */
      public Builder setRightPixels(int value) {

        rightPixels_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of pixels to add to the right. The default is 0.
       * </pre>
       *
       * <code>int32 right_pixels = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRightPixels() {

        rightPixels_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.PreprocessingConfig.Pad)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.PreprocessingConfig.Pad)
    private static final com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad();
    }

    public static com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Pad> PARSER =
        new com.google.protobuf.AbstractParser<Pad>() {
          @java.lang.Override
          public Pad parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Pad> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Pad> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int COLOR_FIELD_NUMBER = 1;
  private com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color_;
  /**
   *
   *
   * <pre>
   * Color preprocessing configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color = 1;</code>
   *
   * @return Whether the color field is set.
   */
  @java.lang.Override
  public boolean hasColor() {
    return color_ != null;
  }
  /**
   *
   *
   * <pre>
   * Color preprocessing configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color = 1;</code>
   *
   * @return The color.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color getColor() {
    return color_ == null
        ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.getDefaultInstance()
        : color_;
  }
  /**
   *
   *
   * <pre>
   * Color preprocessing configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig.ColorOrBuilder
      getColorOrBuilder() {
    return getColor();
  }

  public static final int DENOISE_FIELD_NUMBER = 2;
  private com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise_;
  /**
   *
   *
   * <pre>
   * Denoise preprocessing configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise = 2;</code>
   *
   * @return Whether the denoise field is set.
   */
  @java.lang.Override
  public boolean hasDenoise() {
    return denoise_ != null;
  }
  /**
   *
   *
   * <pre>
   * Denoise preprocessing configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise = 2;</code>
   *
   * @return The denoise.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise getDenoise() {
    return denoise_ == null
        ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.getDefaultInstance()
        : denoise_;
  }
  /**
   *
   *
   * <pre>
   * Denoise preprocessing configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig.DenoiseOrBuilder
      getDenoiseOrBuilder() {
    return getDenoise();
  }

  public static final int DEBLOCK_FIELD_NUMBER = 3;
  private com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock_;
  /**
   *
   *
   * <pre>
   * Deblock preprocessing configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock = 3;</code>
   *
   * @return Whether the deblock field is set.
   */
  @java.lang.Override
  public boolean hasDeblock() {
    return deblock_ != null;
  }
  /**
   *
   *
   * <pre>
   * Deblock preprocessing configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock = 3;</code>
   *
   * @return The deblock.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock getDeblock() {
    return deblock_ == null
        ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.getDefaultInstance()
        : deblock_;
  }
  /**
   *
   *
   * <pre>
   * Deblock preprocessing configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig.DeblockOrBuilder
      getDeblockOrBuilder() {
    return getDeblock();
  }

  public static final int AUDIO_FIELD_NUMBER = 4;
  private com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio_;
  /**
   *
   *
   * <pre>
   * Audio preprocessing configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio = 4;</code>
   *
   * @return Whether the audio field is set.
   */
  @java.lang.Override
  public boolean hasAudio() {
    return audio_ != null;
  }
  /**
   *
   *
   * <pre>
   * Audio preprocessing configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio = 4;</code>
   *
   * @return The audio.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio getAudio() {
    return audio_ == null
        ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.getDefaultInstance()
        : audio_;
  }
  /**
   *
   *
   * <pre>
   * Audio preprocessing configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig.AudioOrBuilder
      getAudioOrBuilder() {
    return getAudio();
  }

  public static final int CROP_FIELD_NUMBER = 5;
  private com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop_;
  /**
   *
   *
   * <pre>
   * Specify the video cropping configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop = 5;</code>
   *
   * @return Whether the crop field is set.
   */
  @java.lang.Override
  public boolean hasCrop() {
    return crop_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specify the video cropping configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop = 5;</code>
   *
   * @return The crop.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop getCrop() {
    return crop_ == null
        ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.getDefaultInstance()
        : crop_;
  }
  /**
   *
   *
   * <pre>
   * Specify the video cropping configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig.CropOrBuilder getCropOrBuilder() {
    return getCrop();
  }

  public static final int PAD_FIELD_NUMBER = 6;
  private com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad_;
  /**
   *
   *
   * <pre>
   * Specify the video pad filter configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad = 6;</code>
   *
   * @return Whether the pad field is set.
   */
  @java.lang.Override
  public boolean hasPad() {
    return pad_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specify the video pad filter configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad = 6;</code>
   *
   * @return The pad.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad getPad() {
    return pad_ == null
        ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.getDefaultInstance()
        : pad_;
  }
  /**
   *
   *
   * <pre>
   * Specify the video pad filter configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig.PadOrBuilder getPadOrBuilder() {
    return getPad();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (color_ != null) {
      output.writeMessage(1, getColor());
    }
    if (denoise_ != null) {
      output.writeMessage(2, getDenoise());
    }
    if (deblock_ != null) {
      output.writeMessage(3, getDeblock());
    }
    if (audio_ != null) {
      output.writeMessage(4, getAudio());
    }
    if (crop_ != null) {
      output.writeMessage(5, getCrop());
    }
    if (pad_ != null) {
      output.writeMessage(6, getPad());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (color_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getColor());
    }
    if (denoise_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDenoise());
    }
    if (deblock_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDeblock());
    }
    if (audio_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAudio());
    }
    if (crop_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCrop());
    }
    if (pad_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getPad());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.video.transcoder.v1.PreprocessingConfig other =
        (com.google.cloud.video.transcoder.v1.PreprocessingConfig) obj;

    if (hasColor() != other.hasColor()) return false;
    if (hasColor()) {
      if (!getColor().equals(other.getColor())) return false;
    }
    if (hasDenoise() != other.hasDenoise()) return false;
    if (hasDenoise()) {
      if (!getDenoise().equals(other.getDenoise())) return false;
    }
    if (hasDeblock() != other.hasDeblock()) return false;
    if (hasDeblock()) {
      if (!getDeblock().equals(other.getDeblock())) return false;
    }
    if (hasAudio() != other.hasAudio()) return false;
    if (hasAudio()) {
      if (!getAudio().equals(other.getAudio())) return false;
    }
    if (hasCrop() != other.hasCrop()) return false;
    if (hasCrop()) {
      if (!getCrop().equals(other.getCrop())) return false;
    }
    if (hasPad() != other.hasPad()) return false;
    if (hasPad()) {
      if (!getPad().equals(other.getPad())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasColor()) {
      hash = (37 * hash) + COLOR_FIELD_NUMBER;
      hash = (53 * hash) + getColor().hashCode();
    }
    if (hasDenoise()) {
      hash = (37 * hash) + DENOISE_FIELD_NUMBER;
      hash = (53 * hash) + getDenoise().hashCode();
    }
    if (hasDeblock()) {
      hash = (37 * hash) + DEBLOCK_FIELD_NUMBER;
      hash = (53 * hash) + getDeblock().hashCode();
    }
    if (hasAudio()) {
      hash = (37 * hash) + AUDIO_FIELD_NUMBER;
      hash = (53 * hash) + getAudio().hashCode();
    }
    if (hasCrop()) {
      hash = (37 * hash) + CROP_FIELD_NUMBER;
      hash = (53 * hash) + getCrop().hashCode();
    }
    if (hasPad()) {
      hash = (37 * hash) + PAD_FIELD_NUMBER;
      hash = (53 * hash) + getPad().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.video.transcoder.v1.PreprocessingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Preprocessing configurations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.PreprocessingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.PreprocessingConfig)
      com.google.cloud.video.transcoder.v1.PreprocessingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.class,
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Builder.class);
    }

    // Construct using com.google.cloud.video.transcoder.v1.PreprocessingConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (colorBuilder_ == null) {
        color_ = null;
      } else {
        color_ = null;
        colorBuilder_ = null;
      }
      if (denoiseBuilder_ == null) {
        denoise_ = null;
      } else {
        denoise_ = null;
        denoiseBuilder_ = null;
      }
      if (deblockBuilder_ == null) {
        deblock_ = null;
      } else {
        deblock_ = null;
        deblockBuilder_ = null;
      }
      if (audioBuilder_ == null) {
        audio_ = null;
      } else {
        audio_ = null;
        audioBuilder_ = null;
      }
      if (cropBuilder_ == null) {
        crop_ = null;
      } else {
        crop_ = null;
        cropBuilder_ = null;
      }
      if (padBuilder_ == null) {
        pad_ = null;
      } else {
        pad_ = null;
        padBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_PreprocessingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig getDefaultInstanceForType() {
      return com.google.cloud.video.transcoder.v1.PreprocessingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig build() {
      com.google.cloud.video.transcoder.v1.PreprocessingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig buildPartial() {
      com.google.cloud.video.transcoder.v1.PreprocessingConfig result =
          new com.google.cloud.video.transcoder.v1.PreprocessingConfig(this);
      if (colorBuilder_ == null) {
        result.color_ = color_;
      } else {
        result.color_ = colorBuilder_.build();
      }
      if (denoiseBuilder_ == null) {
        result.denoise_ = denoise_;
      } else {
        result.denoise_ = denoiseBuilder_.build();
      }
      if (deblockBuilder_ == null) {
        result.deblock_ = deblock_;
      } else {
        result.deblock_ = deblockBuilder_.build();
      }
      if (audioBuilder_ == null) {
        result.audio_ = audio_;
      } else {
        result.audio_ = audioBuilder_.build();
      }
      if (cropBuilder_ == null) {
        result.crop_ = crop_;
      } else {
        result.crop_ = cropBuilder_.build();
      }
      if (padBuilder_ == null) {
        result.pad_ = pad_;
      } else {
        result.pad_ = padBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.video.transcoder.v1.PreprocessingConfig) {
        return mergeFrom((com.google.cloud.video.transcoder.v1.PreprocessingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.video.transcoder.v1.PreprocessingConfig other) {
      if (other == com.google.cloud.video.transcoder.v1.PreprocessingConfig.getDefaultInstance())
        return this;
      if (other.hasColor()) {
        mergeColor(other.getColor());
      }
      if (other.hasDenoise()) {
        mergeDenoise(other.getDenoise());
      }
      if (other.hasDeblock()) {
        mergeDeblock(other.getDeblock());
      }
      if (other.hasAudio()) {
        mergeAudio(other.getAudio());
      }
      if (other.hasCrop()) {
        mergeCrop(other.getCrop());
      }
      if (other.hasPad()) {
        mergePad(other.getPad());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getColorFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDenoiseFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDeblockFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getAudioFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCropFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                input.readMessage(getPadFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.Builder,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.ColorOrBuilder>
        colorBuilder_;
    /**
     *
     *
     * <pre>
     * Color preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color = 1;</code>
     *
     * @return Whether the color field is set.
     */
    public boolean hasColor() {
      return colorBuilder_ != null || color_ != null;
    }
    /**
     *
     *
     * <pre>
     * Color preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color = 1;</code>
     *
     * @return The color.
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color getColor() {
      if (colorBuilder_ == null) {
        return color_ == null
            ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.getDefaultInstance()
            : color_;
      } else {
        return colorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Color preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color = 1;</code>
     */
    public Builder setColor(com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color value) {
      if (colorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        color_ = value;
        onChanged();
      } else {
        colorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Color preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color = 1;</code>
     */
    public Builder setColor(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.Builder builderForValue) {
      if (colorBuilder_ == null) {
        color_ = builderForValue.build();
        onChanged();
      } else {
        colorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Color preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color = 1;</code>
     */
    public Builder mergeColor(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color value) {
      if (colorBuilder_ == null) {
        if (color_ != null) {
          color_ =
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.newBuilder(color_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          color_ = value;
        }
        onChanged();
      } else {
        colorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Color preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color = 1;</code>
     */
    public Builder clearColor() {
      if (colorBuilder_ == null) {
        color_ = null;
        onChanged();
      } else {
        color_ = null;
        colorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Color preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.Builder
        getColorBuilder() {

      onChanged();
      return getColorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Color preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.ColorOrBuilder
        getColorOrBuilder() {
      if (colorBuilder_ != null) {
        return colorBuilder_.getMessageOrBuilder();
      } else {
        return color_ == null
            ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.getDefaultInstance()
            : color_;
      }
    }
    /**
     *
     *
     * <pre>
     * Color preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Color color = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.Builder,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.ColorOrBuilder>
        getColorFieldBuilder() {
      if (colorBuilder_ == null) {
        colorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Color.Builder,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.ColorOrBuilder>(
                getColor(), getParentForChildren(), isClean());
        color_ = null;
      }
      return colorBuilder_;
    }

    private com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.Builder,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.DenoiseOrBuilder>
        denoiseBuilder_;
    /**
     *
     *
     * <pre>
     * Denoise preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise = 2;</code>
     *
     * @return Whether the denoise field is set.
     */
    public boolean hasDenoise() {
      return denoiseBuilder_ != null || denoise_ != null;
    }
    /**
     *
     *
     * <pre>
     * Denoise preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise = 2;</code>
     *
     * @return The denoise.
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise getDenoise() {
      if (denoiseBuilder_ == null) {
        return denoise_ == null
            ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.getDefaultInstance()
            : denoise_;
      } else {
        return denoiseBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Denoise preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise = 2;</code>
     */
    public Builder setDenoise(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise value) {
      if (denoiseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        denoise_ = value;
        onChanged();
      } else {
        denoiseBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Denoise preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise = 2;</code>
     */
    public Builder setDenoise(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.Builder builderForValue) {
      if (denoiseBuilder_ == null) {
        denoise_ = builderForValue.build();
        onChanged();
      } else {
        denoiseBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Denoise preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise = 2;</code>
     */
    public Builder mergeDenoise(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise value) {
      if (denoiseBuilder_ == null) {
        if (denoise_ != null) {
          denoise_ =
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.newBuilder(denoise_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          denoise_ = value;
        }
        onChanged();
      } else {
        denoiseBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Denoise preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise = 2;</code>
     */
    public Builder clearDenoise() {
      if (denoiseBuilder_ == null) {
        denoise_ = null;
        onChanged();
      } else {
        denoise_ = null;
        denoiseBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Denoise preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.Builder
        getDenoiseBuilder() {

      onChanged();
      return getDenoiseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Denoise preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.DenoiseOrBuilder
        getDenoiseOrBuilder() {
      if (denoiseBuilder_ != null) {
        return denoiseBuilder_.getMessageOrBuilder();
      } else {
        return denoise_ == null
            ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.getDefaultInstance()
            : denoise_;
      }
    }
    /**
     *
     *
     * <pre>
     * Denoise preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise denoise = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.Builder,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.DenoiseOrBuilder>
        getDenoiseFieldBuilder() {
      if (denoiseBuilder_ == null) {
        denoiseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Denoise.Builder,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.DenoiseOrBuilder>(
                getDenoise(), getParentForChildren(), isClean());
        denoise_ = null;
      }
      return denoiseBuilder_;
    }

    private com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.Builder,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.DeblockOrBuilder>
        deblockBuilder_;
    /**
     *
     *
     * <pre>
     * Deblock preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock = 3;</code>
     *
     * @return Whether the deblock field is set.
     */
    public boolean hasDeblock() {
      return deblockBuilder_ != null || deblock_ != null;
    }
    /**
     *
     *
     * <pre>
     * Deblock preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock = 3;</code>
     *
     * @return The deblock.
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock getDeblock() {
      if (deblockBuilder_ == null) {
        return deblock_ == null
            ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.getDefaultInstance()
            : deblock_;
      } else {
        return deblockBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Deblock preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock = 3;</code>
     */
    public Builder setDeblock(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock value) {
      if (deblockBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deblock_ = value;
        onChanged();
      } else {
        deblockBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Deblock preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock = 3;</code>
     */
    public Builder setDeblock(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.Builder builderForValue) {
      if (deblockBuilder_ == null) {
        deblock_ = builderForValue.build();
        onChanged();
      } else {
        deblockBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Deblock preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock = 3;</code>
     */
    public Builder mergeDeblock(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock value) {
      if (deblockBuilder_ == null) {
        if (deblock_ != null) {
          deblock_ =
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.newBuilder(deblock_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deblock_ = value;
        }
        onChanged();
      } else {
        deblockBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Deblock preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock = 3;</code>
     */
    public Builder clearDeblock() {
      if (deblockBuilder_ == null) {
        deblock_ = null;
        onChanged();
      } else {
        deblock_ = null;
        deblockBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Deblock preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock = 3;</code>
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.Builder
        getDeblockBuilder() {

      onChanged();
      return getDeblockFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deblock preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock = 3;</code>
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.DeblockOrBuilder
        getDeblockOrBuilder() {
      if (deblockBuilder_ != null) {
        return deblockBuilder_.getMessageOrBuilder();
      } else {
        return deblock_ == null
            ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.getDefaultInstance()
            : deblock_;
      }
    }
    /**
     *
     *
     * <pre>
     * Deblock preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock deblock = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.Builder,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.DeblockOrBuilder>
        getDeblockFieldBuilder() {
      if (deblockBuilder_ == null) {
        deblockBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Deblock.Builder,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.DeblockOrBuilder>(
                getDeblock(), getParentForChildren(), isClean());
        deblock_ = null;
      }
      return deblockBuilder_;
    }

    private com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.Builder,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.AudioOrBuilder>
        audioBuilder_;
    /**
     *
     *
     * <pre>
     * Audio preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio = 4;</code>
     *
     * @return Whether the audio field is set.
     */
    public boolean hasAudio() {
      return audioBuilder_ != null || audio_ != null;
    }
    /**
     *
     *
     * <pre>
     * Audio preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio = 4;</code>
     *
     * @return The audio.
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio getAudio() {
      if (audioBuilder_ == null) {
        return audio_ == null
            ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.getDefaultInstance()
            : audio_;
      } else {
        return audioBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Audio preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio = 4;</code>
     */
    public Builder setAudio(com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio value) {
      if (audioBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        audio_ = value;
        onChanged();
      } else {
        audioBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Audio preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio = 4;</code>
     */
    public Builder setAudio(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.Builder builderForValue) {
      if (audioBuilder_ == null) {
        audio_ = builderForValue.build();
        onChanged();
      } else {
        audioBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Audio preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio = 4;</code>
     */
    public Builder mergeAudio(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio value) {
      if (audioBuilder_ == null) {
        if (audio_ != null) {
          audio_ =
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.newBuilder(audio_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          audio_ = value;
        }
        onChanged();
      } else {
        audioBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Audio preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio = 4;</code>
     */
    public Builder clearAudio() {
      if (audioBuilder_ == null) {
        audio_ = null;
        onChanged();
      } else {
        audio_ = null;
        audioBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Audio preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio = 4;</code>
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.Builder
        getAudioBuilder() {

      onChanged();
      return getAudioFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Audio preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio = 4;</code>
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.AudioOrBuilder
        getAudioOrBuilder() {
      if (audioBuilder_ != null) {
        return audioBuilder_.getMessageOrBuilder();
      } else {
        return audio_ == null
            ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.getDefaultInstance()
            : audio_;
      }
    }
    /**
     *
     *
     * <pre>
     * Audio preprocessing configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio audio = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.Builder,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.AudioOrBuilder>
        getAudioFieldBuilder() {
      if (audioBuilder_ == null) {
        audioBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Audio.Builder,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.AudioOrBuilder>(
                getAudio(), getParentForChildren(), isClean());
        audio_ = null;
      }
      return audioBuilder_;
    }

    private com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.Builder,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.CropOrBuilder>
        cropBuilder_;
    /**
     *
     *
     * <pre>
     * Specify the video cropping configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop = 5;</code>
     *
     * @return Whether the crop field is set.
     */
    public boolean hasCrop() {
      return cropBuilder_ != null || crop_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specify the video cropping configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop = 5;</code>
     *
     * @return The crop.
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop getCrop() {
      if (cropBuilder_ == null) {
        return crop_ == null
            ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.getDefaultInstance()
            : crop_;
      } else {
        return cropBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specify the video cropping configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop = 5;</code>
     */
    public Builder setCrop(com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop value) {
      if (cropBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        crop_ = value;
        onChanged();
      } else {
        cropBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the video cropping configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop = 5;</code>
     */
    public Builder setCrop(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.Builder builderForValue) {
      if (cropBuilder_ == null) {
        crop_ = builderForValue.build();
        onChanged();
      } else {
        cropBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the video cropping configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop = 5;</code>
     */
    public Builder mergeCrop(com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop value) {
      if (cropBuilder_ == null) {
        if (crop_ != null) {
          crop_ =
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.newBuilder(crop_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          crop_ = value;
        }
        onChanged();
      } else {
        cropBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the video cropping configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop = 5;</code>
     */
    public Builder clearCrop() {
      if (cropBuilder_ == null) {
        crop_ = null;
        onChanged();
      } else {
        crop_ = null;
        cropBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the video cropping configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop = 5;</code>
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.Builder getCropBuilder() {

      onChanged();
      return getCropFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specify the video cropping configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop = 5;</code>
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.CropOrBuilder
        getCropOrBuilder() {
      if (cropBuilder_ != null) {
        return cropBuilder_.getMessageOrBuilder();
      } else {
        return crop_ == null
            ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.getDefaultInstance()
            : crop_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specify the video cropping configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop crop = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.Builder,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.CropOrBuilder>
        getCropFieldBuilder() {
      if (cropBuilder_ == null) {
        cropBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Crop.Builder,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.CropOrBuilder>(
                getCrop(), getParentForChildren(), isClean());
        crop_ = null;
      }
      return cropBuilder_;
    }

    private com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.Builder,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.PadOrBuilder>
        padBuilder_;
    /**
     *
     *
     * <pre>
     * Specify the video pad filter configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad = 6;</code>
     *
     * @return Whether the pad field is set.
     */
    public boolean hasPad() {
      return padBuilder_ != null || pad_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specify the video pad filter configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad = 6;</code>
     *
     * @return The pad.
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad getPad() {
      if (padBuilder_ == null) {
        return pad_ == null
            ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.getDefaultInstance()
            : pad_;
      } else {
        return padBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specify the video pad filter configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad = 6;</code>
     */
    public Builder setPad(com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad value) {
      if (padBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pad_ = value;
        onChanged();
      } else {
        padBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the video pad filter configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad = 6;</code>
     */
    public Builder setPad(
        com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.Builder builderForValue) {
      if (padBuilder_ == null) {
        pad_ = builderForValue.build();
        onChanged();
      } else {
        padBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the video pad filter configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad = 6;</code>
     */
    public Builder mergePad(com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad value) {
      if (padBuilder_ == null) {
        if (pad_ != null) {
          pad_ =
              com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.newBuilder(pad_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pad_ = value;
        }
        onChanged();
      } else {
        padBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the video pad filter configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad = 6;</code>
     */
    public Builder clearPad() {
      if (padBuilder_ == null) {
        pad_ = null;
        onChanged();
      } else {
        pad_ = null;
        padBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify the video pad filter configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad = 6;</code>
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.Builder getPadBuilder() {

      onChanged();
      return getPadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specify the video pad filter configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad = 6;</code>
     */
    public com.google.cloud.video.transcoder.v1.PreprocessingConfig.PadOrBuilder getPadOrBuilder() {
      if (padBuilder_ != null) {
        return padBuilder_.getMessageOrBuilder();
      } else {
        return pad_ == null
            ? com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.getDefaultInstance()
            : pad_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specify the video pad filter configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad pad = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.Builder,
            com.google.cloud.video.transcoder.v1.PreprocessingConfig.PadOrBuilder>
        getPadFieldBuilder() {
      if (padBuilder_ == null) {
        padBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.Pad.Builder,
                com.google.cloud.video.transcoder.v1.PreprocessingConfig.PadOrBuilder>(
                getPad(), getParentForChildren(), isClean());
        pad_ = null;
      }
      return padBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.PreprocessingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.PreprocessingConfig)
  private static final com.google.cloud.video.transcoder.v1.PreprocessingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.PreprocessingConfig();
  }

  public static com.google.cloud.video.transcoder.v1.PreprocessingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PreprocessingConfig> PARSER =
      new com.google.protobuf.AbstractParser<PreprocessingConfig>() {
        @java.lang.Override
        public PreprocessingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PreprocessingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PreprocessingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PreprocessingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
