/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/video/transcoder/v1/resources.proto

package com.google.cloud.video.transcoder.v1;

/**
 *
 *
 * <pre>
 * Overlay configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay}
 */
public final class Overlay extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.Overlay)
    OverlayOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Overlay.newBuilder() to construct.
  private Overlay(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Overlay() {
    animations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Overlay();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_Overlay_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_Overlay_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.video.transcoder.v1.Overlay.class,
            com.google.cloud.video.transcoder.v1.Overlay.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Fade type for the overlay: `FADE_IN` or `FADE_OUT`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.video.transcoder.v1.Overlay.FadeType}
   */
  public enum FadeType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The fade type is not specified.
     * </pre>
     *
     * <code>FADE_TYPE_UNSPECIFIED = 0;</code>
     */
    FADE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Fade the overlay object into view.
     * </pre>
     *
     * <code>FADE_IN = 1;</code>
     */
    FADE_IN(1),
    /**
     *
     *
     * <pre>
     * Fade the overlay object out of view.
     * </pre>
     *
     * <code>FADE_OUT = 2;</code>
     */
    FADE_OUT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The fade type is not specified.
     * </pre>
     *
     * <code>FADE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int FADE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Fade the overlay object into view.
     * </pre>
     *
     * <code>FADE_IN = 1;</code>
     */
    public static final int FADE_IN_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Fade the overlay object out of view.
     * </pre>
     *
     * <code>FADE_OUT = 2;</code>
     */
    public static final int FADE_OUT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FadeType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FadeType forNumber(int value) {
      switch (value) {
        case 0:
          return FADE_TYPE_UNSPECIFIED;
        case 1:
          return FADE_IN;
        case 2:
          return FADE_OUT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FadeType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FadeType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<FadeType>() {
          public FadeType findValueByNumber(int number) {
            return FadeType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.Overlay.getDescriptor().getEnumTypes().get(0);
    }

    private static final FadeType[] VALUES = values();

    public static FadeType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FadeType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.video.transcoder.v1.Overlay.FadeType)
  }

  public interface NormalizedCoordinateOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Normalized x coordinate.
     * </pre>
     *
     * <code>double x = 1;</code>
     *
     * @return The x.
     */
    double getX();

    /**
     *
     *
     * <pre>
     * Normalized y coordinate.
     * </pre>
     *
     * <code>double y = 2;</code>
     *
     * @return The y.
     */
    double getY();
  }
  /**
   *
   *
   * <pre>
   * 2D normalized coordinates. Default: `{0.0, 0.0}`
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate}
   */
  public static final class NormalizedCoordinate extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate)
      NormalizedCoordinateOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NormalizedCoordinate.newBuilder() to construct.
    private NormalizedCoordinate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NormalizedCoordinate() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NormalizedCoordinate();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_NormalizedCoordinate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_NormalizedCoordinate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.class,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder.class);
    }

    public static final int X_FIELD_NUMBER = 1;
    private double x_;
    /**
     *
     *
     * <pre>
     * Normalized x coordinate.
     * </pre>
     *
     * <code>double x = 1;</code>
     *
     * @return The x.
     */
    @java.lang.Override
    public double getX() {
      return x_;
    }

    public static final int Y_FIELD_NUMBER = 2;
    private double y_;
    /**
     *
     *
     * <pre>
     * Normalized y coordinate.
     * </pre>
     *
     * <code>double y = 2;</code>
     *
     * @return The y.
     */
    @java.lang.Override
    public double getY() {
      return y_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(x_) != 0) {
        output.writeDouble(1, x_);
      }
      if (java.lang.Double.doubleToRawLongBits(y_) != 0) {
        output.writeDouble(2, y_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(x_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, x_);
      }
      if (java.lang.Double.doubleToRawLongBits(y_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, y_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate other =
          (com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate) obj;

      if (java.lang.Double.doubleToLongBits(getX())
          != java.lang.Double.doubleToLongBits(other.getX())) return false;
      if (java.lang.Double.doubleToLongBits(getY())
          != java.lang.Double.doubleToLongBits(other.getY())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + X_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getX()));
      hash = (37 * hash) + Y_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getY()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * 2D normalized coordinates. Default: `{0.0, 0.0}`
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate)
        com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_NormalizedCoordinate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_NormalizedCoordinate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.class,
                com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder.class);
      }

      // Construct using
      // com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        x_ = 0D;

        y_ = 0D;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_NormalizedCoordinate_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate build() {
        com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate buildPartial() {
        com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate result =
            new com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate(this);
        result.x_ = x_;
        result.y_ = y_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate) {
          return mergeFrom(
              (com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate other) {
        if (other
            == com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
                .getDefaultInstance()) return this;
        if (other.getX() != 0D) {
          setX(other.getX());
        }
        if (other.getY() != 0D) {
          setY(other.getY());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  x_ = input.readDouble();

                  break;
                } // case 9
              case 17:
                {
                  y_ = input.readDouble();

                  break;
                } // case 17
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private double x_;
      /**
       *
       *
       * <pre>
       * Normalized x coordinate.
       * </pre>
       *
       * <code>double x = 1;</code>
       *
       * @return The x.
       */
      @java.lang.Override
      public double getX() {
        return x_;
      }
      /**
       *
       *
       * <pre>
       * Normalized x coordinate.
       * </pre>
       *
       * <code>double x = 1;</code>
       *
       * @param value The x to set.
       * @return This builder for chaining.
       */
      public Builder setX(double value) {

        x_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized x coordinate.
       * </pre>
       *
       * <code>double x = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearX() {

        x_ = 0D;
        onChanged();
        return this;
      }

      private double y_;
      /**
       *
       *
       * <pre>
       * Normalized y coordinate.
       * </pre>
       *
       * <code>double y = 2;</code>
       *
       * @return The y.
       */
      @java.lang.Override
      public double getY() {
        return y_;
      }
      /**
       *
       *
       * <pre>
       * Normalized y coordinate.
       * </pre>
       *
       * <code>double y = 2;</code>
       *
       * @param value The y to set.
       * @return This builder for chaining.
       */
      public Builder setY(double value) {

        y_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized y coordinate.
       * </pre>
       *
       * <code>double y = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearY() {

        y_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate)
    private static final com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate();
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NormalizedCoordinate> PARSER =
        new com.google.protobuf.AbstractParser<NormalizedCoordinate>() {
          @java.lang.Override
          public NormalizedCoordinate parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NormalizedCoordinate> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NormalizedCoordinate> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ImageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.Overlay.Image)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. URI of the JPEG image in Cloud Storage. For example,
     * `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * Required. URI of the JPEG image in Cloud Storage. For example,
     * `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * Normalized image resolution, based on output video resolution. Valid
     * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
     * either `x` or `y` to `0.0`. To use the original image resolution, set
     * both `x` and `y` to `0.0`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
     *
     * @return Whether the resolution field is set.
     */
    boolean hasResolution();
    /**
     *
     *
     * <pre>
     * Normalized image resolution, based on output video resolution. Valid
     * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
     * either `x` or `y` to `0.0`. To use the original image resolution, set
     * both `x` and `y` to `0.0`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
     *
     * @return The resolution.
     */
    com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate getResolution();
    /**
     *
     *
     * <pre>
     * Normalized image resolution, based on output video resolution. Valid
     * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
     * either `x` or `y` to `0.0`. To use the original image resolution, set
     * both `x` and `y` to `0.0`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
     */
    com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder
        getResolutionOrBuilder();

    /**
     *
     *
     * <pre>
     * Target image opacity. Valid values are from  `1.0` (solid, default) to
     * `0.0` (transparent), exclusive. Set this to a value greater than `0.0`.
     * </pre>
     *
     * <code>double alpha = 3;</code>
     *
     * @return The alpha.
     */
    double getAlpha();
  }
  /**
   *
   *
   * <pre>
   * Overlaid jpeg image.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay.Image}
   */
  public static final class Image extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.Overlay.Image)
      ImageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Image.newBuilder() to construct.
    private Image(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Image() {
      uri_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Image();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_Image_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_Image_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.Overlay.Image.class,
              com.google.cloud.video.transcoder.v1.Overlay.Image.Builder.class);
    }

    public static final int URI_FIELD_NUMBER = 1;
    private volatile java.lang.Object uri_;
    /**
     *
     *
     * <pre>
     * Required. URI of the JPEG image in Cloud Storage. For example,
     * `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. URI of the JPEG image in Cloud Storage. For example,
     * `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RESOLUTION_FIELD_NUMBER = 2;
    private com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution_;
    /**
     *
     *
     * <pre>
     * Normalized image resolution, based on output video resolution. Valid
     * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
     * either `x` or `y` to `0.0`. To use the original image resolution, set
     * both `x` and `y` to `0.0`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
     *
     * @return Whether the resolution field is set.
     */
    @java.lang.Override
    public boolean hasResolution() {
      return resolution_ != null;
    }
    /**
     *
     *
     * <pre>
     * Normalized image resolution, based on output video resolution. Valid
     * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
     * either `x` or `y` to `0.0`. To use the original image resolution, set
     * both `x` and `y` to `0.0`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
     *
     * @return The resolution.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate getResolution() {
      return resolution_ == null
          ? com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.getDefaultInstance()
          : resolution_;
    }
    /**
     *
     *
     * <pre>
     * Normalized image resolution, based on output video resolution. Valid
     * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
     * either `x` or `y` to `0.0`. To use the original image resolution, set
     * both `x` and `y` to `0.0`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder
        getResolutionOrBuilder() {
      return getResolution();
    }

    public static final int ALPHA_FIELD_NUMBER = 3;
    private double alpha_;
    /**
     *
     *
     * <pre>
     * Target image opacity. Valid values are from  `1.0` (solid, default) to
     * `0.0` (transparent), exclusive. Set this to a value greater than `0.0`.
     * </pre>
     *
     * <code>double alpha = 3;</code>
     *
     * @return The alpha.
     */
    @java.lang.Override
    public double getAlpha() {
      return alpha_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
      }
      if (resolution_ != null) {
        output.writeMessage(2, getResolution());
      }
      if (java.lang.Double.doubleToRawLongBits(alpha_) != 0) {
        output.writeDouble(3, alpha_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
      }
      if (resolution_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getResolution());
      }
      if (java.lang.Double.doubleToRawLongBits(alpha_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, alpha_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.Overlay.Image)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.Overlay.Image other =
          (com.google.cloud.video.transcoder.v1.Overlay.Image) obj;

      if (!getUri().equals(other.getUri())) return false;
      if (hasResolution() != other.hasResolution()) return false;
      if (hasResolution()) {
        if (!getResolution().equals(other.getResolution())) return false;
      }
      if (java.lang.Double.doubleToLongBits(getAlpha())
          != java.lang.Double.doubleToLongBits(other.getAlpha())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      if (hasResolution()) {
        hash = (37 * hash) + RESOLUTION_FIELD_NUMBER;
        hash = (53 * hash) + getResolution().hashCode();
      }
      hash = (37 * hash) + ALPHA_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getAlpha()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.video.transcoder.v1.Overlay.Image prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Overlaid jpeg image.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay.Image}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.Overlay.Image)
        com.google.cloud.video.transcoder.v1.Overlay.ImageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_Image_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_Image_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.Overlay.Image.class,
                com.google.cloud.video.transcoder.v1.Overlay.Image.Builder.class);
      }

      // Construct using com.google.cloud.video.transcoder.v1.Overlay.Image.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        uri_ = "";

        if (resolutionBuilder_ == null) {
          resolution_ = null;
        } else {
          resolution_ = null;
          resolutionBuilder_ = null;
        }
        alpha_ = 0D;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_Image_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.Image getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.Overlay.Image.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.Image build() {
        com.google.cloud.video.transcoder.v1.Overlay.Image result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.Image buildPartial() {
        com.google.cloud.video.transcoder.v1.Overlay.Image result =
            new com.google.cloud.video.transcoder.v1.Overlay.Image(this);
        result.uri_ = uri_;
        if (resolutionBuilder_ == null) {
          result.resolution_ = resolution_;
        } else {
          result.resolution_ = resolutionBuilder_.build();
        }
        result.alpha_ = alpha_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.Overlay.Image) {
          return mergeFrom((com.google.cloud.video.transcoder.v1.Overlay.Image) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.video.transcoder.v1.Overlay.Image other) {
        if (other == com.google.cloud.video.transcoder.v1.Overlay.Image.getDefaultInstance())
          return this;
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          onChanged();
        }
        if (other.hasResolution()) {
          mergeResolution(other.getResolution());
        }
        if (other.getAlpha() != 0D) {
          setAlpha(other.getAlpha());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  uri_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getResolutionFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              case 25:
                {
                  alpha_ = input.readDouble();

                  break;
                } // case 25
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * Required. URI of the JPEG image in Cloud Storage. For example,
       * `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. URI of the JPEG image in Cloud Storage. For example,
       * `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. URI of the JPEG image in Cloud Storage. For example,
       * `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        uri_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. URI of the JPEG image in Cloud Storage. For example,
       * `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {

        uri_ = getDefaultInstance().getUri();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. URI of the JPEG image in Cloud Storage. For example,
       * `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        uri_ = value;
        onChanged();
        return this;
      }

      private com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder>
          resolutionBuilder_;
      /**
       *
       *
       * <pre>
       * Normalized image resolution, based on output video resolution. Valid
       * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
       * either `x` or `y` to `0.0`. To use the original image resolution, set
       * both `x` and `y` to `0.0`.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
       *
       * @return Whether the resolution field is set.
       */
      public boolean hasResolution() {
        return resolutionBuilder_ != null || resolution_ != null;
      }
      /**
       *
       *
       * <pre>
       * Normalized image resolution, based on output video resolution. Valid
       * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
       * either `x` or `y` to `0.0`. To use the original image resolution, set
       * both `x` and `y` to `0.0`.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
       *
       * @return The resolution.
       */
      public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate getResolution() {
        if (resolutionBuilder_ == null) {
          return resolution_ == null
              ? com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
                  .getDefaultInstance()
              : resolution_;
        } else {
          return resolutionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Normalized image resolution, based on output video resolution. Valid
       * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
       * either `x` or `y` to `0.0`. To use the original image resolution, set
       * both `x` and `y` to `0.0`.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
       */
      public Builder setResolution(
          com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate value) {
        if (resolutionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          resolution_ = value;
          onChanged();
        } else {
          resolutionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized image resolution, based on output video resolution. Valid
       * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
       * either `x` or `y` to `0.0`. To use the original image resolution, set
       * both `x` and `y` to `0.0`.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
       */
      public Builder setResolution(
          com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder
              builderForValue) {
        if (resolutionBuilder_ == null) {
          resolution_ = builderForValue.build();
          onChanged();
        } else {
          resolutionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized image resolution, based on output video resolution. Valid
       * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
       * either `x` or `y` to `0.0`. To use the original image resolution, set
       * both `x` and `y` to `0.0`.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
       */
      public Builder mergeResolution(
          com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate value) {
        if (resolutionBuilder_ == null) {
          if (resolution_ != null) {
            resolution_ =
                com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.newBuilder(
                        resolution_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            resolution_ = value;
          }
          onChanged();
        } else {
          resolutionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized image resolution, based on output video resolution. Valid
       * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
       * either `x` or `y` to `0.0`. To use the original image resolution, set
       * both `x` and `y` to `0.0`.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
       */
      public Builder clearResolution() {
        if (resolutionBuilder_ == null) {
          resolution_ = null;
          onChanged();
        } else {
          resolution_ = null;
          resolutionBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized image resolution, based on output video resolution. Valid
       * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
       * either `x` or `y` to `0.0`. To use the original image resolution, set
       * both `x` and `y` to `0.0`.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
       */
      public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder
          getResolutionBuilder() {

        onChanged();
        return getResolutionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Normalized image resolution, based on output video resolution. Valid
       * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
       * either `x` or `y` to `0.0`. To use the original image resolution, set
       * both `x` and `y` to `0.0`.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
       */
      public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder
          getResolutionOrBuilder() {
        if (resolutionBuilder_ != null) {
          return resolutionBuilder_.getMessageOrBuilder();
        } else {
          return resolution_ == null
              ? com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
                  .getDefaultInstance()
              : resolution_;
        }
      }
      /**
       *
       *
       * <pre>
       * Normalized image resolution, based on output video resolution. Valid
       * values: `0.0`–`1.0`. To respect the original image aspect ratio, set
       * either `x` or `y` to `0.0`. To use the original image resolution, set
       * both `x` and `y` to `0.0`.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate resolution = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder>
          getResolutionFieldBuilder() {
        if (resolutionBuilder_ == null) {
          resolutionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate,
                  com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder,
                  com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder>(
                  getResolution(), getParentForChildren(), isClean());
          resolution_ = null;
        }
        return resolutionBuilder_;
      }

      private double alpha_;
      /**
       *
       *
       * <pre>
       * Target image opacity. Valid values are from  `1.0` (solid, default) to
       * `0.0` (transparent), exclusive. Set this to a value greater than `0.0`.
       * </pre>
       *
       * <code>double alpha = 3;</code>
       *
       * @return The alpha.
       */
      @java.lang.Override
      public double getAlpha() {
        return alpha_;
      }
      /**
       *
       *
       * <pre>
       * Target image opacity. Valid values are from  `1.0` (solid, default) to
       * `0.0` (transparent), exclusive. Set this to a value greater than `0.0`.
       * </pre>
       *
       * <code>double alpha = 3;</code>
       *
       * @param value The alpha to set.
       * @return This builder for chaining.
       */
      public Builder setAlpha(double value) {

        alpha_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Target image opacity. Valid values are from  `1.0` (solid, default) to
       * `0.0` (transparent), exclusive. Set this to a value greater than `0.0`.
       * </pre>
       *
       * <code>double alpha = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAlpha() {

        alpha_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.Overlay.Image)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.Overlay.Image)
    private static final com.google.cloud.video.transcoder.v1.Overlay.Image DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.Overlay.Image();
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Image getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Image> PARSER =
        new com.google.protobuf.AbstractParser<Image>() {
          @java.lang.Override
          public Image parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Image> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Image> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.Image getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AnimationStaticOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.Overlay.AnimationStatic)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Normalized coordinates based on output video resolution. Valid
     * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
     * object. For example, use the x and y coordinates {0,0} to position the
     * top-left corner of the overlay animation in the top-left corner of the
     * output video.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
     *
     * @return Whether the xy field is set.
     */
    boolean hasXy();
    /**
     *
     *
     * <pre>
     * Normalized coordinates based on output video resolution. Valid
     * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
     * object. For example, use the x and y coordinates {0,0} to position the
     * top-left corner of the overlay animation in the top-left corner of the
     * output video.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
     *
     * @return The xy.
     */
    com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate getXy();
    /**
     *
     *
     * <pre>
     * Normalized coordinates based on output video resolution. Valid
     * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
     * object. For example, use the x and y coordinates {0,0} to position the
     * top-left corner of the overlay animation in the top-left corner of the
     * output video.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
     */
    com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder getXyOrBuilder();

    /**
     *
     *
     * <pre>
     * The time to start displaying the overlay object, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 2;</code>
     *
     * @return Whether the startTimeOffset field is set.
     */
    boolean hasStartTimeOffset();
    /**
     *
     *
     * <pre>
     * The time to start displaying the overlay object, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 2;</code>
     *
     * @return The startTimeOffset.
     */
    com.google.protobuf.Duration getStartTimeOffset();
    /**
     *
     *
     * <pre>
     * The time to start displaying the overlay object, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 2;</code>
     */
    com.google.protobuf.DurationOrBuilder getStartTimeOffsetOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Display static overlay object.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay.AnimationStatic}
   */
  public static final class AnimationStatic extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.Overlay.AnimationStatic)
      AnimationStaticOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnimationStatic.newBuilder() to construct.
    private AnimationStatic(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnimationStatic() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnimationStatic();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationStatic_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationStatic_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.class,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.Builder.class);
    }

    public static final int XY_FIELD_NUMBER = 1;
    private com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy_;
    /**
     *
     *
     * <pre>
     * Normalized coordinates based on output video resolution. Valid
     * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
     * object. For example, use the x and y coordinates {0,0} to position the
     * top-left corner of the overlay animation in the top-left corner of the
     * output video.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
     *
     * @return Whether the xy field is set.
     */
    @java.lang.Override
    public boolean hasXy() {
      return xy_ != null;
    }
    /**
     *
     *
     * <pre>
     * Normalized coordinates based on output video resolution. Valid
     * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
     * object. For example, use the x and y coordinates {0,0} to position the
     * top-left corner of the overlay animation in the top-left corner of the
     * output video.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
     *
     * @return The xy.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate getXy() {
      return xy_ == null
          ? com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.getDefaultInstance()
          : xy_;
    }
    /**
     *
     *
     * <pre>
     * Normalized coordinates based on output video resolution. Valid
     * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
     * object. For example, use the x and y coordinates {0,0} to position the
     * top-left corner of the overlay animation in the top-left corner of the
     * output video.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder
        getXyOrBuilder() {
      return getXy();
    }

    public static final int START_TIME_OFFSET_FIELD_NUMBER = 2;
    private com.google.protobuf.Duration startTimeOffset_;
    /**
     *
     *
     * <pre>
     * The time to start displaying the overlay object, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 2;</code>
     *
     * @return Whether the startTimeOffset field is set.
     */
    @java.lang.Override
    public boolean hasStartTimeOffset() {
      return startTimeOffset_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time to start displaying the overlay object, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 2;</code>
     *
     * @return The startTimeOffset.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getStartTimeOffset() {
      return startTimeOffset_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : startTimeOffset_;
    }
    /**
     *
     *
     * <pre>
     * The time to start displaying the overlay object, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getStartTimeOffsetOrBuilder() {
      return getStartTimeOffset();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (xy_ != null) {
        output.writeMessage(1, getXy());
      }
      if (startTimeOffset_ != null) {
        output.writeMessage(2, getStartTimeOffset());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (xy_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getXy());
      }
      if (startTimeOffset_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStartTimeOffset());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic other =
          (com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic) obj;

      if (hasXy() != other.hasXy()) return false;
      if (hasXy()) {
        if (!getXy().equals(other.getXy())) return false;
      }
      if (hasStartTimeOffset() != other.hasStartTimeOffset()) return false;
      if (hasStartTimeOffset()) {
        if (!getStartTimeOffset().equals(other.getStartTimeOffset())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasXy()) {
        hash = (37 * hash) + XY_FIELD_NUMBER;
        hash = (53 * hash) + getXy().hashCode();
      }
      if (hasStartTimeOffset()) {
        hash = (37 * hash) + START_TIME_OFFSET_FIELD_NUMBER;
        hash = (53 * hash) + getStartTimeOffset().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Display static overlay object.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay.AnimationStatic}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.Overlay.AnimationStatic)
        com.google.cloud.video.transcoder.v1.Overlay.AnimationStaticOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationStatic_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationStatic_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.class,
                com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.Builder.class);
      }

      // Construct using com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (xyBuilder_ == null) {
          xy_ = null;
        } else {
          xy_ = null;
          xyBuilder_ = null;
        }
        if (startTimeOffsetBuilder_ == null) {
          startTimeOffset_ = null;
        } else {
          startTimeOffset_ = null;
          startTimeOffsetBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationStatic_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic build() {
        com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic buildPartial() {
        com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic result =
            new com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic(this);
        if (xyBuilder_ == null) {
          result.xy_ = xy_;
        } else {
          result.xy_ = xyBuilder_.build();
        }
        if (startTimeOffsetBuilder_ == null) {
          result.startTimeOffset_ = startTimeOffset_;
        } else {
          result.startTimeOffset_ = startTimeOffsetBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic) {
          return mergeFrom((com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic other) {
        if (other
            == com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.getDefaultInstance())
          return this;
        if (other.hasXy()) {
          mergeXy(other.getXy());
        }
        if (other.hasStartTimeOffset()) {
          mergeStartTimeOffset(other.getStartTimeOffset());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getXyFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getStartTimeOffsetFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder>
          xyBuilder_;
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
       *
       * @return Whether the xy field is set.
       */
      public boolean hasXy() {
        return xyBuilder_ != null || xy_ != null;
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
       *
       * @return The xy.
       */
      public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate getXy() {
        if (xyBuilder_ == null) {
          return xy_ == null
              ? com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
                  .getDefaultInstance()
              : xy_;
        } else {
          return xyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
       */
      public Builder setXy(
          com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate value) {
        if (xyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          xy_ = value;
          onChanged();
        } else {
          xyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
       */
      public Builder setXy(
          com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder
              builderForValue) {
        if (xyBuilder_ == null) {
          xy_ = builderForValue.build();
          onChanged();
        } else {
          xyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
       */
      public Builder mergeXy(
          com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate value) {
        if (xyBuilder_ == null) {
          if (xy_ != null) {
            xy_ =
                com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.newBuilder(xy_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            xy_ = value;
          }
          onChanged();
        } else {
          xyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
       */
      public Builder clearXy() {
        if (xyBuilder_ == null) {
          xy_ = null;
          onChanged();
        } else {
          xy_ = null;
          xyBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
       */
      public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder
          getXyBuilder() {

        onChanged();
        return getXyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
       */
      public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder
          getXyOrBuilder() {
        if (xyBuilder_ != null) {
          return xyBuilder_.getMessageOrBuilder();
        } else {
          return xy_ == null
              ? com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
                  .getDefaultInstance()
              : xy_;
        }
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder>
          getXyFieldBuilder() {
        if (xyBuilder_ == null) {
          xyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate,
                  com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder,
                  com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder>(
                  getXy(), getParentForChildren(), isClean());
          xy_ = null;
        }
        return xyBuilder_;
      }

      private com.google.protobuf.Duration startTimeOffset_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          startTimeOffsetBuilder_;
      /**
       *
       *
       * <pre>
       * The time to start displaying the overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 2;</code>
       *
       * @return Whether the startTimeOffset field is set.
       */
      public boolean hasStartTimeOffset() {
        return startTimeOffsetBuilder_ != null || startTimeOffset_ != null;
      }
      /**
       *
       *
       * <pre>
       * The time to start displaying the overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 2;</code>
       *
       * @return The startTimeOffset.
       */
      public com.google.protobuf.Duration getStartTimeOffset() {
        if (startTimeOffsetBuilder_ == null) {
          return startTimeOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : startTimeOffset_;
        } else {
          return startTimeOffsetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time to start displaying the overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 2;</code>
       */
      public Builder setStartTimeOffset(com.google.protobuf.Duration value) {
        if (startTimeOffsetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTimeOffset_ = value;
          onChanged();
        } else {
          startTimeOffsetBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to start displaying the overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 2;</code>
       */
      public Builder setStartTimeOffset(com.google.protobuf.Duration.Builder builderForValue) {
        if (startTimeOffsetBuilder_ == null) {
          startTimeOffset_ = builderForValue.build();
          onChanged();
        } else {
          startTimeOffsetBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to start displaying the overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 2;</code>
       */
      public Builder mergeStartTimeOffset(com.google.protobuf.Duration value) {
        if (startTimeOffsetBuilder_ == null) {
          if (startTimeOffset_ != null) {
            startTimeOffset_ =
                com.google.protobuf.Duration.newBuilder(startTimeOffset_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            startTimeOffset_ = value;
          }
          onChanged();
        } else {
          startTimeOffsetBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to start displaying the overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 2;</code>
       */
      public Builder clearStartTimeOffset() {
        if (startTimeOffsetBuilder_ == null) {
          startTimeOffset_ = null;
          onChanged();
        } else {
          startTimeOffset_ = null;
          startTimeOffsetBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to start displaying the overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 2;</code>
       */
      public com.google.protobuf.Duration.Builder getStartTimeOffsetBuilder() {

        onChanged();
        return getStartTimeOffsetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time to start displaying the overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 2;</code>
       */
      public com.google.protobuf.DurationOrBuilder getStartTimeOffsetOrBuilder() {
        if (startTimeOffsetBuilder_ != null) {
          return startTimeOffsetBuilder_.getMessageOrBuilder();
        } else {
          return startTimeOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : startTimeOffset_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time to start displaying the overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getStartTimeOffsetFieldBuilder() {
        if (startTimeOffsetBuilder_ == null) {
          startTimeOffsetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getStartTimeOffset(), getParentForChildren(), isClean());
          startTimeOffset_ = null;
        }
        return startTimeOffsetBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.Overlay.AnimationStatic)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.Overlay.AnimationStatic)
    private static final com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic();
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnimationStatic> PARSER =
        new com.google.protobuf.AbstractParser<AnimationStatic>() {
          @java.lang.Override
          public AnimationStatic parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnimationStatic> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnimationStatic> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AnimationFadeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.Overlay.AnimationFade)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Overlay.FadeType fade_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for fadeType.
     */
    int getFadeTypeValue();
    /**
     *
     *
     * <pre>
     * Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Overlay.FadeType fade_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The fadeType.
     */
    com.google.cloud.video.transcoder.v1.Overlay.FadeType getFadeType();

    /**
     *
     *
     * <pre>
     * Normalized coordinates based on output video resolution. Valid
     * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
     * object. For example, use the x and y coordinates {0,0} to position the
     * top-left corner of the overlay animation in the top-left corner of the
     * output video.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
     *
     * @return Whether the xy field is set.
     */
    boolean hasXy();
    /**
     *
     *
     * <pre>
     * Normalized coordinates based on output video resolution. Valid
     * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
     * object. For example, use the x and y coordinates {0,0} to position the
     * top-left corner of the overlay animation in the top-left corner of the
     * output video.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
     *
     * @return The xy.
     */
    com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate getXy();
    /**
     *
     *
     * <pre>
     * Normalized coordinates based on output video resolution. Valid
     * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
     * object. For example, use the x and y coordinates {0,0} to position the
     * top-left corner of the overlay animation in the top-left corner of the
     * output video.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
     */
    com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder getXyOrBuilder();

    /**
     *
     *
     * <pre>
     * The time to start the fade animation, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 3;</code>
     *
     * @return Whether the startTimeOffset field is set.
     */
    boolean hasStartTimeOffset();
    /**
     *
     *
     * <pre>
     * The time to start the fade animation, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 3;</code>
     *
     * @return The startTimeOffset.
     */
    com.google.protobuf.Duration getStartTimeOffset();
    /**
     *
     *
     * <pre>
     * The time to start the fade animation, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 3;</code>
     */
    com.google.protobuf.DurationOrBuilder getStartTimeOffsetOrBuilder();

    /**
     *
     *
     * <pre>
     * The time to end the fade animation, in seconds. Default:
     * `start_time_offset` + 1s
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 4;</code>
     *
     * @return Whether the endTimeOffset field is set.
     */
    boolean hasEndTimeOffset();
    /**
     *
     *
     * <pre>
     * The time to end the fade animation, in seconds. Default:
     * `start_time_offset` + 1s
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 4;</code>
     *
     * @return The endTimeOffset.
     */
    com.google.protobuf.Duration getEndTimeOffset();
    /**
     *
     *
     * <pre>
     * The time to end the fade animation, in seconds. Default:
     * `start_time_offset` + 1s
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 4;</code>
     */
    com.google.protobuf.DurationOrBuilder getEndTimeOffsetOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Display overlay object with fade animation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay.AnimationFade}
   */
  public static final class AnimationFade extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.Overlay.AnimationFade)
      AnimationFadeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnimationFade.newBuilder() to construct.
    private AnimationFade(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnimationFade() {
      fadeType_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnimationFade();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationFade_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationFade_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.class,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.Builder.class);
    }

    public static final int FADE_TYPE_FIELD_NUMBER = 1;
    private int fadeType_;
    /**
     *
     *
     * <pre>
     * Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Overlay.FadeType fade_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for fadeType.
     */
    @java.lang.Override
    public int getFadeTypeValue() {
      return fadeType_;
    }
    /**
     *
     *
     * <pre>
     * Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Overlay.FadeType fade_type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The fadeType.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.FadeType getFadeType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.video.transcoder.v1.Overlay.FadeType result =
          com.google.cloud.video.transcoder.v1.Overlay.FadeType.valueOf(fadeType_);
      return result == null
          ? com.google.cloud.video.transcoder.v1.Overlay.FadeType.UNRECOGNIZED
          : result;
    }

    public static final int XY_FIELD_NUMBER = 2;
    private com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy_;
    /**
     *
     *
     * <pre>
     * Normalized coordinates based on output video resolution. Valid
     * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
     * object. For example, use the x and y coordinates {0,0} to position the
     * top-left corner of the overlay animation in the top-left corner of the
     * output video.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
     *
     * @return Whether the xy field is set.
     */
    @java.lang.Override
    public boolean hasXy() {
      return xy_ != null;
    }
    /**
     *
     *
     * <pre>
     * Normalized coordinates based on output video resolution. Valid
     * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
     * object. For example, use the x and y coordinates {0,0} to position the
     * top-left corner of the overlay animation in the top-left corner of the
     * output video.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
     *
     * @return The xy.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate getXy() {
      return xy_ == null
          ? com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.getDefaultInstance()
          : xy_;
    }
    /**
     *
     *
     * <pre>
     * Normalized coordinates based on output video resolution. Valid
     * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
     * object. For example, use the x and y coordinates {0,0} to position the
     * top-left corner of the overlay animation in the top-left corner of the
     * output video.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder
        getXyOrBuilder() {
      return getXy();
    }

    public static final int START_TIME_OFFSET_FIELD_NUMBER = 3;
    private com.google.protobuf.Duration startTimeOffset_;
    /**
     *
     *
     * <pre>
     * The time to start the fade animation, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 3;</code>
     *
     * @return Whether the startTimeOffset field is set.
     */
    @java.lang.Override
    public boolean hasStartTimeOffset() {
      return startTimeOffset_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time to start the fade animation, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 3;</code>
     *
     * @return The startTimeOffset.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getStartTimeOffset() {
      return startTimeOffset_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : startTimeOffset_;
    }
    /**
     *
     *
     * <pre>
     * The time to start the fade animation, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getStartTimeOffsetOrBuilder() {
      return getStartTimeOffset();
    }

    public static final int END_TIME_OFFSET_FIELD_NUMBER = 4;
    private com.google.protobuf.Duration endTimeOffset_;
    /**
     *
     *
     * <pre>
     * The time to end the fade animation, in seconds. Default:
     * `start_time_offset` + 1s
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 4;</code>
     *
     * @return Whether the endTimeOffset field is set.
     */
    @java.lang.Override
    public boolean hasEndTimeOffset() {
      return endTimeOffset_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time to end the fade animation, in seconds. Default:
     * `start_time_offset` + 1s
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 4;</code>
     *
     * @return The endTimeOffset.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getEndTimeOffset() {
      return endTimeOffset_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : endTimeOffset_;
    }
    /**
     *
     *
     * <pre>
     * The time to end the fade animation, in seconds. Default:
     * `start_time_offset` + 1s
     * </pre>
     *
     * <code>.google.protobuf.Duration end_time_offset = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getEndTimeOffsetOrBuilder() {
      return getEndTimeOffset();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (fadeType_
          != com.google.cloud.video.transcoder.v1.Overlay.FadeType.FADE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, fadeType_);
      }
      if (xy_ != null) {
        output.writeMessage(2, getXy());
      }
      if (startTimeOffset_ != null) {
        output.writeMessage(3, getStartTimeOffset());
      }
      if (endTimeOffset_ != null) {
        output.writeMessage(4, getEndTimeOffset());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (fadeType_
          != com.google.cloud.video.transcoder.v1.Overlay.FadeType.FADE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, fadeType_);
      }
      if (xy_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getXy());
      }
      if (startTimeOffset_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStartTimeOffset());
      }
      if (endTimeOffset_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEndTimeOffset());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.Overlay.AnimationFade)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.Overlay.AnimationFade other =
          (com.google.cloud.video.transcoder.v1.Overlay.AnimationFade) obj;

      if (fadeType_ != other.fadeType_) return false;
      if (hasXy() != other.hasXy()) return false;
      if (hasXy()) {
        if (!getXy().equals(other.getXy())) return false;
      }
      if (hasStartTimeOffset() != other.hasStartTimeOffset()) return false;
      if (hasStartTimeOffset()) {
        if (!getStartTimeOffset().equals(other.getStartTimeOffset())) return false;
      }
      if (hasEndTimeOffset() != other.hasEndTimeOffset()) return false;
      if (hasEndTimeOffset()) {
        if (!getEndTimeOffset().equals(other.getEndTimeOffset())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FADE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + fadeType_;
      if (hasXy()) {
        hash = (37 * hash) + XY_FIELD_NUMBER;
        hash = (53 * hash) + getXy().hashCode();
      }
      if (hasStartTimeOffset()) {
        hash = (37 * hash) + START_TIME_OFFSET_FIELD_NUMBER;
        hash = (53 * hash) + getStartTimeOffset().hashCode();
      }
      if (hasEndTimeOffset()) {
        hash = (37 * hash) + END_TIME_OFFSET_FIELD_NUMBER;
        hash = (53 * hash) + getEndTimeOffset().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.Overlay.AnimationFade prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Display overlay object with fade animation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay.AnimationFade}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.Overlay.AnimationFade)
        com.google.cloud.video.transcoder.v1.Overlay.AnimationFadeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationFade_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationFade_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.class,
                com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.Builder.class);
      }

      // Construct using com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        fadeType_ = 0;

        if (xyBuilder_ == null) {
          xy_ = null;
        } else {
          xy_ = null;
          xyBuilder_ = null;
        }
        if (startTimeOffsetBuilder_ == null) {
          startTimeOffset_ = null;
        } else {
          startTimeOffset_ = null;
          startTimeOffsetBuilder_ = null;
        }
        if (endTimeOffsetBuilder_ == null) {
          endTimeOffset_ = null;
        } else {
          endTimeOffset_ = null;
          endTimeOffsetBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationFade_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationFade
          getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationFade build() {
        com.google.cloud.video.transcoder.v1.Overlay.AnimationFade result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationFade buildPartial() {
        com.google.cloud.video.transcoder.v1.Overlay.AnimationFade result =
            new com.google.cloud.video.transcoder.v1.Overlay.AnimationFade(this);
        result.fadeType_ = fadeType_;
        if (xyBuilder_ == null) {
          result.xy_ = xy_;
        } else {
          result.xy_ = xyBuilder_.build();
        }
        if (startTimeOffsetBuilder_ == null) {
          result.startTimeOffset_ = startTimeOffset_;
        } else {
          result.startTimeOffset_ = startTimeOffsetBuilder_.build();
        }
        if (endTimeOffsetBuilder_ == null) {
          result.endTimeOffset_ = endTimeOffset_;
        } else {
          result.endTimeOffset_ = endTimeOffsetBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.Overlay.AnimationFade) {
          return mergeFrom((com.google.cloud.video.transcoder.v1.Overlay.AnimationFade) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.video.transcoder.v1.Overlay.AnimationFade other) {
        if (other
            == com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.getDefaultInstance())
          return this;
        if (other.fadeType_ != 0) {
          setFadeTypeValue(other.getFadeTypeValue());
        }
        if (other.hasXy()) {
          mergeXy(other.getXy());
        }
        if (other.hasStartTimeOffset()) {
          mergeStartTimeOffset(other.getStartTimeOffset());
        }
        if (other.hasEndTimeOffset()) {
          mergeEndTimeOffset(other.getEndTimeOffset());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  fadeType_ = input.readEnum();

                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getXyFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getStartTimeOffsetFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getEndTimeOffsetFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int fadeType_ = 0;
      /**
       *
       *
       * <pre>
       * Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
       * </pre>
       *
       * <code>
       * .google.cloud.video.transcoder.v1.Overlay.FadeType fade_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for fadeType.
       */
      @java.lang.Override
      public int getFadeTypeValue() {
        return fadeType_;
      }
      /**
       *
       *
       * <pre>
       * Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
       * </pre>
       *
       * <code>
       * .google.cloud.video.transcoder.v1.Overlay.FadeType fade_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for fadeType to set.
       * @return This builder for chaining.
       */
      public Builder setFadeTypeValue(int value) {

        fadeType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
       * </pre>
       *
       * <code>
       * .google.cloud.video.transcoder.v1.Overlay.FadeType fade_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The fadeType.
       */
      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.FadeType getFadeType() {
        @SuppressWarnings("deprecation")
        com.google.cloud.video.transcoder.v1.Overlay.FadeType result =
            com.google.cloud.video.transcoder.v1.Overlay.FadeType.valueOf(fadeType_);
        return result == null
            ? com.google.cloud.video.transcoder.v1.Overlay.FadeType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
       * </pre>
       *
       * <code>
       * .google.cloud.video.transcoder.v1.Overlay.FadeType fade_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The fadeType to set.
       * @return This builder for chaining.
       */
      public Builder setFadeType(com.google.cloud.video.transcoder.v1.Overlay.FadeType value) {
        if (value == null) {
          throw new NullPointerException();
        }

        fadeType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
       * </pre>
       *
       * <code>
       * .google.cloud.video.transcoder.v1.Overlay.FadeType fade_type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFadeType() {

        fadeType_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder>
          xyBuilder_;
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
       *
       * @return Whether the xy field is set.
       */
      public boolean hasXy() {
        return xyBuilder_ != null || xy_ != null;
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
       *
       * @return The xy.
       */
      public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate getXy() {
        if (xyBuilder_ == null) {
          return xy_ == null
              ? com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
                  .getDefaultInstance()
              : xy_;
        } else {
          return xyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
       */
      public Builder setXy(
          com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate value) {
        if (xyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          xy_ = value;
          onChanged();
        } else {
          xyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
       */
      public Builder setXy(
          com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder
              builderForValue) {
        if (xyBuilder_ == null) {
          xy_ = builderForValue.build();
          onChanged();
        } else {
          xyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
       */
      public Builder mergeXy(
          com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate value) {
        if (xyBuilder_ == null) {
          if (xy_ != null) {
            xy_ =
                com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.newBuilder(xy_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            xy_ = value;
          }
          onChanged();
        } else {
          xyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
       */
      public Builder clearXy() {
        if (xyBuilder_ == null) {
          xy_ = null;
          onChanged();
        } else {
          xy_ = null;
          xyBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
       */
      public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder
          getXyBuilder() {

        onChanged();
        return getXyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
       */
      public com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder
          getXyOrBuilder() {
        if (xyBuilder_ != null) {
          return xyBuilder_.getMessageOrBuilder();
        } else {
          return xy_ == null
              ? com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate
                  .getDefaultInstance()
              : xy_;
        }
      }
      /**
       *
       *
       * <pre>
       * Normalized coordinates based on output video resolution. Valid
       * values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay
       * object. For example, use the x and y coordinates {0,0} to position the
       * top-left corner of the overlay animation in the top-left corner of the
       * output video.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate xy = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder,
              com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder>
          getXyFieldBuilder() {
        if (xyBuilder_ == null) {
          xyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate,
                  com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinate.Builder,
                  com.google.cloud.video.transcoder.v1.Overlay.NormalizedCoordinateOrBuilder>(
                  getXy(), getParentForChildren(), isClean());
          xy_ = null;
        }
        return xyBuilder_;
      }

      private com.google.protobuf.Duration startTimeOffset_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          startTimeOffsetBuilder_;
      /**
       *
       *
       * <pre>
       * The time to start the fade animation, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 3;</code>
       *
       * @return Whether the startTimeOffset field is set.
       */
      public boolean hasStartTimeOffset() {
        return startTimeOffsetBuilder_ != null || startTimeOffset_ != null;
      }
      /**
       *
       *
       * <pre>
       * The time to start the fade animation, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 3;</code>
       *
       * @return The startTimeOffset.
       */
      public com.google.protobuf.Duration getStartTimeOffset() {
        if (startTimeOffsetBuilder_ == null) {
          return startTimeOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : startTimeOffset_;
        } else {
          return startTimeOffsetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time to start the fade animation, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 3;</code>
       */
      public Builder setStartTimeOffset(com.google.protobuf.Duration value) {
        if (startTimeOffsetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTimeOffset_ = value;
          onChanged();
        } else {
          startTimeOffsetBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to start the fade animation, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 3;</code>
       */
      public Builder setStartTimeOffset(com.google.protobuf.Duration.Builder builderForValue) {
        if (startTimeOffsetBuilder_ == null) {
          startTimeOffset_ = builderForValue.build();
          onChanged();
        } else {
          startTimeOffsetBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to start the fade animation, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 3;</code>
       */
      public Builder mergeStartTimeOffset(com.google.protobuf.Duration value) {
        if (startTimeOffsetBuilder_ == null) {
          if (startTimeOffset_ != null) {
            startTimeOffset_ =
                com.google.protobuf.Duration.newBuilder(startTimeOffset_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            startTimeOffset_ = value;
          }
          onChanged();
        } else {
          startTimeOffsetBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to start the fade animation, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 3;</code>
       */
      public Builder clearStartTimeOffset() {
        if (startTimeOffsetBuilder_ == null) {
          startTimeOffset_ = null;
          onChanged();
        } else {
          startTimeOffset_ = null;
          startTimeOffsetBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to start the fade animation, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 3;</code>
       */
      public com.google.protobuf.Duration.Builder getStartTimeOffsetBuilder() {

        onChanged();
        return getStartTimeOffsetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time to start the fade animation, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 3;</code>
       */
      public com.google.protobuf.DurationOrBuilder getStartTimeOffsetOrBuilder() {
        if (startTimeOffsetBuilder_ != null) {
          return startTimeOffsetBuilder_.getMessageOrBuilder();
        } else {
          return startTimeOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : startTimeOffset_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time to start the fade animation, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getStartTimeOffsetFieldBuilder() {
        if (startTimeOffsetBuilder_ == null) {
          startTimeOffsetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getStartTimeOffset(), getParentForChildren(), isClean());
          startTimeOffset_ = null;
        }
        return startTimeOffsetBuilder_;
      }

      private com.google.protobuf.Duration endTimeOffset_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          endTimeOffsetBuilder_;
      /**
       *
       *
       * <pre>
       * The time to end the fade animation, in seconds. Default:
       * `start_time_offset` + 1s
       * </pre>
       *
       * <code>.google.protobuf.Duration end_time_offset = 4;</code>
       *
       * @return Whether the endTimeOffset field is set.
       */
      public boolean hasEndTimeOffset() {
        return endTimeOffsetBuilder_ != null || endTimeOffset_ != null;
      }
      /**
       *
       *
       * <pre>
       * The time to end the fade animation, in seconds. Default:
       * `start_time_offset` + 1s
       * </pre>
       *
       * <code>.google.protobuf.Duration end_time_offset = 4;</code>
       *
       * @return The endTimeOffset.
       */
      public com.google.protobuf.Duration getEndTimeOffset() {
        if (endTimeOffsetBuilder_ == null) {
          return endTimeOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : endTimeOffset_;
        } else {
          return endTimeOffsetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time to end the fade animation, in seconds. Default:
       * `start_time_offset` + 1s
       * </pre>
       *
       * <code>.google.protobuf.Duration end_time_offset = 4;</code>
       */
      public Builder setEndTimeOffset(com.google.protobuf.Duration value) {
        if (endTimeOffsetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endTimeOffset_ = value;
          onChanged();
        } else {
          endTimeOffsetBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to end the fade animation, in seconds. Default:
       * `start_time_offset` + 1s
       * </pre>
       *
       * <code>.google.protobuf.Duration end_time_offset = 4;</code>
       */
      public Builder setEndTimeOffset(com.google.protobuf.Duration.Builder builderForValue) {
        if (endTimeOffsetBuilder_ == null) {
          endTimeOffset_ = builderForValue.build();
          onChanged();
        } else {
          endTimeOffsetBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to end the fade animation, in seconds. Default:
       * `start_time_offset` + 1s
       * </pre>
       *
       * <code>.google.protobuf.Duration end_time_offset = 4;</code>
       */
      public Builder mergeEndTimeOffset(com.google.protobuf.Duration value) {
        if (endTimeOffsetBuilder_ == null) {
          if (endTimeOffset_ != null) {
            endTimeOffset_ =
                com.google.protobuf.Duration.newBuilder(endTimeOffset_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            endTimeOffset_ = value;
          }
          onChanged();
        } else {
          endTimeOffsetBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to end the fade animation, in seconds. Default:
       * `start_time_offset` + 1s
       * </pre>
       *
       * <code>.google.protobuf.Duration end_time_offset = 4;</code>
       */
      public Builder clearEndTimeOffset() {
        if (endTimeOffsetBuilder_ == null) {
          endTimeOffset_ = null;
          onChanged();
        } else {
          endTimeOffset_ = null;
          endTimeOffsetBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to end the fade animation, in seconds. Default:
       * `start_time_offset` + 1s
       * </pre>
       *
       * <code>.google.protobuf.Duration end_time_offset = 4;</code>
       */
      public com.google.protobuf.Duration.Builder getEndTimeOffsetBuilder() {

        onChanged();
        return getEndTimeOffsetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time to end the fade animation, in seconds. Default:
       * `start_time_offset` + 1s
       * </pre>
       *
       * <code>.google.protobuf.Duration end_time_offset = 4;</code>
       */
      public com.google.protobuf.DurationOrBuilder getEndTimeOffsetOrBuilder() {
        if (endTimeOffsetBuilder_ != null) {
          return endTimeOffsetBuilder_.getMessageOrBuilder();
        } else {
          return endTimeOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : endTimeOffset_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time to end the fade animation, in seconds. Default:
       * `start_time_offset` + 1s
       * </pre>
       *
       * <code>.google.protobuf.Duration end_time_offset = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getEndTimeOffsetFieldBuilder() {
        if (endTimeOffsetBuilder_ == null) {
          endTimeOffsetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getEndTimeOffset(), getParentForChildren(), isClean());
          endTimeOffset_ = null;
        }
        return endTimeOffsetBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.Overlay.AnimationFade)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.Overlay.AnimationFade)
    private static final com.google.cloud.video.transcoder.v1.Overlay.AnimationFade
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.Overlay.AnimationFade();
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationFade getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnimationFade> PARSER =
        new com.google.protobuf.AbstractParser<AnimationFade>() {
          @java.lang.Override
          public AnimationFade parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnimationFade> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnimationFade> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.AnimationFade getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AnimationEndOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.Overlay.AnimationEnd)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The time to end overlay object, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 1;</code>
     *
     * @return Whether the startTimeOffset field is set.
     */
    boolean hasStartTimeOffset();
    /**
     *
     *
     * <pre>
     * The time to end overlay object, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 1;</code>
     *
     * @return The startTimeOffset.
     */
    com.google.protobuf.Duration getStartTimeOffset();
    /**
     *
     *
     * <pre>
     * The time to end overlay object, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 1;</code>
     */
    com.google.protobuf.DurationOrBuilder getStartTimeOffsetOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * End previous overlay animation from the video. Without AnimationEnd, the
   * overlay object will keep the state of previous animation until the end of
   * the video.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay.AnimationEnd}
   */
  public static final class AnimationEnd extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.Overlay.AnimationEnd)
      AnimationEndOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnimationEnd.newBuilder() to construct.
    private AnimationEnd(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnimationEnd() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnimationEnd();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationEnd_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationEnd_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.class,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.Builder.class);
    }

    public static final int START_TIME_OFFSET_FIELD_NUMBER = 1;
    private com.google.protobuf.Duration startTimeOffset_;
    /**
     *
     *
     * <pre>
     * The time to end overlay object, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 1;</code>
     *
     * @return Whether the startTimeOffset field is set.
     */
    @java.lang.Override
    public boolean hasStartTimeOffset() {
      return startTimeOffset_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time to end overlay object, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 1;</code>
     *
     * @return The startTimeOffset.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getStartTimeOffset() {
      return startTimeOffset_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : startTimeOffset_;
    }
    /**
     *
     *
     * <pre>
     * The time to end overlay object, in seconds. Default: 0
     * </pre>
     *
     * <code>.google.protobuf.Duration start_time_offset = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getStartTimeOffsetOrBuilder() {
      return getStartTimeOffset();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (startTimeOffset_ != null) {
        output.writeMessage(1, getStartTimeOffset());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (startTimeOffset_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTimeOffset());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd other =
          (com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd) obj;

      if (hasStartTimeOffset() != other.hasStartTimeOffset()) return false;
      if (hasStartTimeOffset()) {
        if (!getStartTimeOffset().equals(other.getStartTimeOffset())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStartTimeOffset()) {
        hash = (37 * hash) + START_TIME_OFFSET_FIELD_NUMBER;
        hash = (53 * hash) + getStartTimeOffset().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * End previous overlay animation from the video. Without AnimationEnd, the
     * overlay object will keep the state of previous animation until the end of
     * the video.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay.AnimationEnd}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.Overlay.AnimationEnd)
        com.google.cloud.video.transcoder.v1.Overlay.AnimationEndOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationEnd_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationEnd_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.class,
                com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.Builder.class);
      }

      // Construct using com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (startTimeOffsetBuilder_ == null) {
          startTimeOffset_ = null;
        } else {
          startTimeOffset_ = null;
          startTimeOffsetBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_AnimationEnd_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd build() {
        com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd buildPartial() {
        com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd result =
            new com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd(this);
        if (startTimeOffsetBuilder_ == null) {
          result.startTimeOffset_ = startTimeOffset_;
        } else {
          result.startTimeOffset_ = startTimeOffsetBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd) {
          return mergeFrom((com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd other) {
        if (other == com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.getDefaultInstance())
          return this;
        if (other.hasStartTimeOffset()) {
          mergeStartTimeOffset(other.getStartTimeOffset());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getStartTimeOffsetFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.protobuf.Duration startTimeOffset_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          startTimeOffsetBuilder_;
      /**
       *
       *
       * <pre>
       * The time to end overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 1;</code>
       *
       * @return Whether the startTimeOffset field is set.
       */
      public boolean hasStartTimeOffset() {
        return startTimeOffsetBuilder_ != null || startTimeOffset_ != null;
      }
      /**
       *
       *
       * <pre>
       * The time to end overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 1;</code>
       *
       * @return The startTimeOffset.
       */
      public com.google.protobuf.Duration getStartTimeOffset() {
        if (startTimeOffsetBuilder_ == null) {
          return startTimeOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : startTimeOffset_;
        } else {
          return startTimeOffsetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time to end overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 1;</code>
       */
      public Builder setStartTimeOffset(com.google.protobuf.Duration value) {
        if (startTimeOffsetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTimeOffset_ = value;
          onChanged();
        } else {
          startTimeOffsetBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to end overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 1;</code>
       */
      public Builder setStartTimeOffset(com.google.protobuf.Duration.Builder builderForValue) {
        if (startTimeOffsetBuilder_ == null) {
          startTimeOffset_ = builderForValue.build();
          onChanged();
        } else {
          startTimeOffsetBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to end overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 1;</code>
       */
      public Builder mergeStartTimeOffset(com.google.protobuf.Duration value) {
        if (startTimeOffsetBuilder_ == null) {
          if (startTimeOffset_ != null) {
            startTimeOffset_ =
                com.google.protobuf.Duration.newBuilder(startTimeOffset_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            startTimeOffset_ = value;
          }
          onChanged();
        } else {
          startTimeOffsetBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to end overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 1;</code>
       */
      public Builder clearStartTimeOffset() {
        if (startTimeOffsetBuilder_ == null) {
          startTimeOffset_ = null;
          onChanged();
        } else {
          startTimeOffset_ = null;
          startTimeOffsetBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The time to end overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 1;</code>
       */
      public com.google.protobuf.Duration.Builder getStartTimeOffsetBuilder() {

        onChanged();
        return getStartTimeOffsetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time to end overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 1;</code>
       */
      public com.google.protobuf.DurationOrBuilder getStartTimeOffsetOrBuilder() {
        if (startTimeOffsetBuilder_ != null) {
          return startTimeOffsetBuilder_.getMessageOrBuilder();
        } else {
          return startTimeOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : startTimeOffset_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time to end overlay object, in seconds. Default: 0
       * </pre>
       *
       * <code>.google.protobuf.Duration start_time_offset = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getStartTimeOffsetFieldBuilder() {
        if (startTimeOffsetBuilder_ == null) {
          startTimeOffsetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getStartTimeOffset(), getParentForChildren(), isClean());
          startTimeOffset_ = null;
        }
        return startTimeOffsetBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.Overlay.AnimationEnd)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.Overlay.AnimationEnd)
    private static final com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd();
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnimationEnd> PARSER =
        new com.google.protobuf.AbstractParser<AnimationEnd>() {
          @java.lang.Override
          public AnimationEnd parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnimationEnd> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnimationEnd> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AnimationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.video.transcoder.v1.Overlay.Animation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Display static overlay object.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;</code>
     *
     * @return Whether the animationStatic field is set.
     */
    boolean hasAnimationStatic();
    /**
     *
     *
     * <pre>
     * Display static overlay object.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;</code>
     *
     * @return The animationStatic.
     */
    com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic getAnimationStatic();
    /**
     *
     *
     * <pre>
     * Display static overlay object.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;</code>
     */
    com.google.cloud.video.transcoder.v1.Overlay.AnimationStaticOrBuilder
        getAnimationStaticOrBuilder();

    /**
     *
     *
     * <pre>
     * Display overlay object with fade animation.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
     *
     * @return Whether the animationFade field is set.
     */
    boolean hasAnimationFade();
    /**
     *
     *
     * <pre>
     * Display overlay object with fade animation.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
     *
     * @return The animationFade.
     */
    com.google.cloud.video.transcoder.v1.Overlay.AnimationFade getAnimationFade();
    /**
     *
     *
     * <pre>
     * Display overlay object with fade animation.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
     */
    com.google.cloud.video.transcoder.v1.Overlay.AnimationFadeOrBuilder getAnimationFadeOrBuilder();

    /**
     *
     *
     * <pre>
     * End previous animation.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
     *
     * @return Whether the animationEnd field is set.
     */
    boolean hasAnimationEnd();
    /**
     *
     *
     * <pre>
     * End previous animation.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
     *
     * @return The animationEnd.
     */
    com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd getAnimationEnd();
    /**
     *
     *
     * <pre>
     * End previous animation.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
     */
    com.google.cloud.video.transcoder.v1.Overlay.AnimationEndOrBuilder getAnimationEndOrBuilder();

    public com.google.cloud.video.transcoder.v1.Overlay.Animation.AnimationTypeCase
        getAnimationTypeCase();
  }
  /**
   *
   *
   * <pre>
   * Animation types.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay.Animation}
   */
  public static final class Animation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.Overlay.Animation)
      AnimationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Animation.newBuilder() to construct.
    private Animation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Animation() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Animation();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_Animation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_Animation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.Overlay.Animation.class,
              com.google.cloud.video.transcoder.v1.Overlay.Animation.Builder.class);
    }

    private int animationTypeCase_ = 0;
    private java.lang.Object animationType_;

    public enum AnimationTypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ANIMATION_STATIC(1),
      ANIMATION_FADE(2),
      ANIMATION_END(3),
      ANIMATIONTYPE_NOT_SET(0);
      private final int value;

      private AnimationTypeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AnimationTypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static AnimationTypeCase forNumber(int value) {
        switch (value) {
          case 1:
            return ANIMATION_STATIC;
          case 2:
            return ANIMATION_FADE;
          case 3:
            return ANIMATION_END;
          case 0:
            return ANIMATIONTYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public AnimationTypeCase getAnimationTypeCase() {
      return AnimationTypeCase.forNumber(animationTypeCase_);
    }

    public static final int ANIMATION_STATIC_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Display static overlay object.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;</code>
     *
     * @return Whether the animationStatic field is set.
     */
    @java.lang.Override
    public boolean hasAnimationStatic() {
      return animationTypeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Display static overlay object.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;</code>
     *
     * @return The animationStatic.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic getAnimationStatic() {
      if (animationTypeCase_ == 1) {
        return (com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic) animationType_;
      }
      return com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Display static overlay object.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.AnimationStaticOrBuilder
        getAnimationStaticOrBuilder() {
      if (animationTypeCase_ == 1) {
        return (com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic) animationType_;
      }
      return com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.getDefaultInstance();
    }

    public static final int ANIMATION_FADE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Display overlay object with fade animation.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
     *
     * @return Whether the animationFade field is set.
     */
    @java.lang.Override
    public boolean hasAnimationFade() {
      return animationTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Display overlay object with fade animation.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
     *
     * @return The animationFade.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.AnimationFade getAnimationFade() {
      if (animationTypeCase_ == 2) {
        return (com.google.cloud.video.transcoder.v1.Overlay.AnimationFade) animationType_;
      }
      return com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Display overlay object with fade animation.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.AnimationFadeOrBuilder
        getAnimationFadeOrBuilder() {
      if (animationTypeCase_ == 2) {
        return (com.google.cloud.video.transcoder.v1.Overlay.AnimationFade) animationType_;
      }
      return com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.getDefaultInstance();
    }

    public static final int ANIMATION_END_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * End previous animation.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
     *
     * @return Whether the animationEnd field is set.
     */
    @java.lang.Override
    public boolean hasAnimationEnd() {
      return animationTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * End previous animation.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
     *
     * @return The animationEnd.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd getAnimationEnd() {
      if (animationTypeCase_ == 3) {
        return (com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd) animationType_;
      }
      return com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * End previous animation.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.AnimationEndOrBuilder
        getAnimationEndOrBuilder() {
      if (animationTypeCase_ == 3) {
        return (com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd) animationType_;
      }
      return com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (animationTypeCase_ == 1) {
        output.writeMessage(
            1, (com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic) animationType_);
      }
      if (animationTypeCase_ == 2) {
        output.writeMessage(
            2, (com.google.cloud.video.transcoder.v1.Overlay.AnimationFade) animationType_);
      }
      if (animationTypeCase_ == 3) {
        output.writeMessage(
            3, (com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd) animationType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (animationTypeCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic) animationType_);
      }
      if (animationTypeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.video.transcoder.v1.Overlay.AnimationFade) animationType_);
      }
      if (animationTypeCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd) animationType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.video.transcoder.v1.Overlay.Animation)) {
        return super.equals(obj);
      }
      com.google.cloud.video.transcoder.v1.Overlay.Animation other =
          (com.google.cloud.video.transcoder.v1.Overlay.Animation) obj;

      if (!getAnimationTypeCase().equals(other.getAnimationTypeCase())) return false;
      switch (animationTypeCase_) {
        case 1:
          if (!getAnimationStatic().equals(other.getAnimationStatic())) return false;
          break;
        case 2:
          if (!getAnimationFade().equals(other.getAnimationFade())) return false;
          break;
        case 3:
          if (!getAnimationEnd().equals(other.getAnimationEnd())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (animationTypeCase_) {
        case 1:
          hash = (37 * hash) + ANIMATION_STATIC_FIELD_NUMBER;
          hash = (53 * hash) + getAnimationStatic().hashCode();
          break;
        case 2:
          hash = (37 * hash) + ANIMATION_FADE_FIELD_NUMBER;
          hash = (53 * hash) + getAnimationFade().hashCode();
          break;
        case 3:
          hash = (37 * hash) + ANIMATION_END_FIELD_NUMBER;
          hash = (53 * hash) + getAnimationEnd().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.video.transcoder.v1.Overlay.Animation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Animation types.
     * </pre>
     *
     * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay.Animation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.Overlay.Animation)
        com.google.cloud.video.transcoder.v1.Overlay.AnimationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_Animation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_Animation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.video.transcoder.v1.Overlay.Animation.class,
                com.google.cloud.video.transcoder.v1.Overlay.Animation.Builder.class);
      }

      // Construct using com.google.cloud.video.transcoder.v1.Overlay.Animation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (animationStaticBuilder_ != null) {
          animationStaticBuilder_.clear();
        }
        if (animationFadeBuilder_ != null) {
          animationFadeBuilder_.clear();
        }
        if (animationEndBuilder_ != null) {
          animationEndBuilder_.clear();
        }
        animationTypeCase_ = 0;
        animationType_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.video.transcoder.v1.ResourcesProto
            .internal_static_google_cloud_video_transcoder_v1_Overlay_Animation_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.Animation getDefaultInstanceForType() {
        return com.google.cloud.video.transcoder.v1.Overlay.Animation.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.Animation build() {
        com.google.cloud.video.transcoder.v1.Overlay.Animation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.Animation buildPartial() {
        com.google.cloud.video.transcoder.v1.Overlay.Animation result =
            new com.google.cloud.video.transcoder.v1.Overlay.Animation(this);
        if (animationTypeCase_ == 1) {
          if (animationStaticBuilder_ == null) {
            result.animationType_ = animationType_;
          } else {
            result.animationType_ = animationStaticBuilder_.build();
          }
        }
        if (animationTypeCase_ == 2) {
          if (animationFadeBuilder_ == null) {
            result.animationType_ = animationType_;
          } else {
            result.animationType_ = animationFadeBuilder_.build();
          }
        }
        if (animationTypeCase_ == 3) {
          if (animationEndBuilder_ == null) {
            result.animationType_ = animationType_;
          } else {
            result.animationType_ = animationEndBuilder_.build();
          }
        }
        result.animationTypeCase_ = animationTypeCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.video.transcoder.v1.Overlay.Animation) {
          return mergeFrom((com.google.cloud.video.transcoder.v1.Overlay.Animation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.video.transcoder.v1.Overlay.Animation other) {
        if (other == com.google.cloud.video.transcoder.v1.Overlay.Animation.getDefaultInstance())
          return this;
        switch (other.getAnimationTypeCase()) {
          case ANIMATION_STATIC:
            {
              mergeAnimationStatic(other.getAnimationStatic());
              break;
            }
          case ANIMATION_FADE:
            {
              mergeAnimationFade(other.getAnimationFade());
              break;
            }
          case ANIMATION_END:
            {
              mergeAnimationEnd(other.getAnimationEnd());
              break;
            }
          case ANIMATIONTYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getAnimationStaticFieldBuilder().getBuilder(), extensionRegistry);
                  animationTypeCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getAnimationFadeFieldBuilder().getBuilder(), extensionRegistry);
                  animationTypeCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getAnimationEndFieldBuilder().getBuilder(), extensionRegistry);
                  animationTypeCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int animationTypeCase_ = 0;
      private java.lang.Object animationType_;

      public AnimationTypeCase getAnimationTypeCase() {
        return AnimationTypeCase.forNumber(animationTypeCase_);
      }

      public Builder clearAnimationType() {
        animationTypeCase_ = 0;
        animationType_ = null;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.Builder,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationStaticOrBuilder>
          animationStaticBuilder_;
      /**
       *
       *
       * <pre>
       * Display static overlay object.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;
       * </code>
       *
       * @return Whether the animationStatic field is set.
       */
      @java.lang.Override
      public boolean hasAnimationStatic() {
        return animationTypeCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Display static overlay object.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;
       * </code>
       *
       * @return The animationStatic.
       */
      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic getAnimationStatic() {
        if (animationStaticBuilder_ == null) {
          if (animationTypeCase_ == 1) {
            return (com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic) animationType_;
          }
          return com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.getDefaultInstance();
        } else {
          if (animationTypeCase_ == 1) {
            return animationStaticBuilder_.getMessage();
          }
          return com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Display static overlay object.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;
       * </code>
       */
      public Builder setAnimationStatic(
          com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic value) {
        if (animationStaticBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          animationType_ = value;
          onChanged();
        } else {
          animationStaticBuilder_.setMessage(value);
        }
        animationTypeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display static overlay object.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;
       * </code>
       */
      public Builder setAnimationStatic(
          com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.Builder builderForValue) {
        if (animationStaticBuilder_ == null) {
          animationType_ = builderForValue.build();
          onChanged();
        } else {
          animationStaticBuilder_.setMessage(builderForValue.build());
        }
        animationTypeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display static overlay object.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;
       * </code>
       */
      public Builder mergeAnimationStatic(
          com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic value) {
        if (animationStaticBuilder_ == null) {
          if (animationTypeCase_ == 1
              && animationType_
                  != com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic
                      .getDefaultInstance()) {
            animationType_ =
                com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.newBuilder(
                        (com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic)
                            animationType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            animationType_ = value;
          }
          onChanged();
        } else {
          if (animationTypeCase_ == 1) {
            animationStaticBuilder_.mergeFrom(value);
          } else {
            animationStaticBuilder_.setMessage(value);
          }
        }
        animationTypeCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display static overlay object.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;
       * </code>
       */
      public Builder clearAnimationStatic() {
        if (animationStaticBuilder_ == null) {
          if (animationTypeCase_ == 1) {
            animationTypeCase_ = 0;
            animationType_ = null;
            onChanged();
          }
        } else {
          if (animationTypeCase_ == 1) {
            animationTypeCase_ = 0;
            animationType_ = null;
          }
          animationStaticBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display static overlay object.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;
       * </code>
       */
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.Builder
          getAnimationStaticBuilder() {
        return getAnimationStaticFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Display static overlay object.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationStaticOrBuilder
          getAnimationStaticOrBuilder() {
        if ((animationTypeCase_ == 1) && (animationStaticBuilder_ != null)) {
          return animationStaticBuilder_.getMessageOrBuilder();
        } else {
          if (animationTypeCase_ == 1) {
            return (com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic) animationType_;
          }
          return com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Display static overlay object.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationStatic animation_static = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.Builder,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationStaticOrBuilder>
          getAnimationStaticFieldBuilder() {
        if (animationStaticBuilder_ == null) {
          if (!(animationTypeCase_ == 1)) {
            animationType_ =
                com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.getDefaultInstance();
          }
          animationStaticBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic,
                  com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic.Builder,
                  com.google.cloud.video.transcoder.v1.Overlay.AnimationStaticOrBuilder>(
                  (com.google.cloud.video.transcoder.v1.Overlay.AnimationStatic) animationType_,
                  getParentForChildren(),
                  isClean());
          animationType_ = null;
        }
        animationTypeCase_ = 1;
        onChanged();
        ;
        return animationStaticBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.video.transcoder.v1.Overlay.AnimationFade,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.Builder,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationFadeOrBuilder>
          animationFadeBuilder_;
      /**
       *
       *
       * <pre>
       * Display overlay object with fade animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
       *
       * @return Whether the animationFade field is set.
       */
      @java.lang.Override
      public boolean hasAnimationFade() {
        return animationTypeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Display overlay object with fade animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
       *
       * @return The animationFade.
       */
      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationFade getAnimationFade() {
        if (animationFadeBuilder_ == null) {
          if (animationTypeCase_ == 2) {
            return (com.google.cloud.video.transcoder.v1.Overlay.AnimationFade) animationType_;
          }
          return com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.getDefaultInstance();
        } else {
          if (animationTypeCase_ == 2) {
            return animationFadeBuilder_.getMessage();
          }
          return com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Display overlay object with fade animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
       */
      public Builder setAnimationFade(
          com.google.cloud.video.transcoder.v1.Overlay.AnimationFade value) {
        if (animationFadeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          animationType_ = value;
          onChanged();
        } else {
          animationFadeBuilder_.setMessage(value);
        }
        animationTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display overlay object with fade animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
       */
      public Builder setAnimationFade(
          com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.Builder builderForValue) {
        if (animationFadeBuilder_ == null) {
          animationType_ = builderForValue.build();
          onChanged();
        } else {
          animationFadeBuilder_.setMessage(builderForValue.build());
        }
        animationTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display overlay object with fade animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
       */
      public Builder mergeAnimationFade(
          com.google.cloud.video.transcoder.v1.Overlay.AnimationFade value) {
        if (animationFadeBuilder_ == null) {
          if (animationTypeCase_ == 2
              && animationType_
                  != com.google.cloud.video.transcoder.v1.Overlay.AnimationFade
                      .getDefaultInstance()) {
            animationType_ =
                com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.newBuilder(
                        (com.google.cloud.video.transcoder.v1.Overlay.AnimationFade) animationType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            animationType_ = value;
          }
          onChanged();
        } else {
          if (animationTypeCase_ == 2) {
            animationFadeBuilder_.mergeFrom(value);
          } else {
            animationFadeBuilder_.setMessage(value);
          }
        }
        animationTypeCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display overlay object with fade animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
       */
      public Builder clearAnimationFade() {
        if (animationFadeBuilder_ == null) {
          if (animationTypeCase_ == 2) {
            animationTypeCase_ = 0;
            animationType_ = null;
            onChanged();
          }
        } else {
          if (animationTypeCase_ == 2) {
            animationTypeCase_ = 0;
            animationType_ = null;
          }
          animationFadeBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display overlay object with fade animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
       */
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.Builder
          getAnimationFadeBuilder() {
        return getAnimationFadeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Display overlay object with fade animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationFadeOrBuilder
          getAnimationFadeOrBuilder() {
        if ((animationTypeCase_ == 2) && (animationFadeBuilder_ != null)) {
          return animationFadeBuilder_.getMessageOrBuilder();
        } else {
          if (animationTypeCase_ == 2) {
            return (com.google.cloud.video.transcoder.v1.Overlay.AnimationFade) animationType_;
          }
          return com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Display overlay object with fade animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationFade animation_fade = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.video.transcoder.v1.Overlay.AnimationFade,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.Builder,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationFadeOrBuilder>
          getAnimationFadeFieldBuilder() {
        if (animationFadeBuilder_ == null) {
          if (!(animationTypeCase_ == 2)) {
            animationType_ =
                com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.getDefaultInstance();
          }
          animationFadeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.video.transcoder.v1.Overlay.AnimationFade,
                  com.google.cloud.video.transcoder.v1.Overlay.AnimationFade.Builder,
                  com.google.cloud.video.transcoder.v1.Overlay.AnimationFadeOrBuilder>(
                  (com.google.cloud.video.transcoder.v1.Overlay.AnimationFade) animationType_,
                  getParentForChildren(),
                  isClean());
          animationType_ = null;
        }
        animationTypeCase_ = 2;
        onChanged();
        ;
        return animationFadeBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.Builder,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationEndOrBuilder>
          animationEndBuilder_;
      /**
       *
       *
       * <pre>
       * End previous animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
       *
       * @return Whether the animationEnd field is set.
       */
      @java.lang.Override
      public boolean hasAnimationEnd() {
        return animationTypeCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * End previous animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
       *
       * @return The animationEnd.
       */
      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd getAnimationEnd() {
        if (animationEndBuilder_ == null) {
          if (animationTypeCase_ == 3) {
            return (com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd) animationType_;
          }
          return com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.getDefaultInstance();
        } else {
          if (animationTypeCase_ == 3) {
            return animationEndBuilder_.getMessage();
          }
          return com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * End previous animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
       */
      public Builder setAnimationEnd(
          com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd value) {
        if (animationEndBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          animationType_ = value;
          onChanged();
        } else {
          animationEndBuilder_.setMessage(value);
        }
        animationTypeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * End previous animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
       */
      public Builder setAnimationEnd(
          com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.Builder builderForValue) {
        if (animationEndBuilder_ == null) {
          animationType_ = builderForValue.build();
          onChanged();
        } else {
          animationEndBuilder_.setMessage(builderForValue.build());
        }
        animationTypeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * End previous animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
       */
      public Builder mergeAnimationEnd(
          com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd value) {
        if (animationEndBuilder_ == null) {
          if (animationTypeCase_ == 3
              && animationType_
                  != com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd
                      .getDefaultInstance()) {
            animationType_ =
                com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.newBuilder(
                        (com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd) animationType_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            animationType_ = value;
          }
          onChanged();
        } else {
          if (animationTypeCase_ == 3) {
            animationEndBuilder_.mergeFrom(value);
          } else {
            animationEndBuilder_.setMessage(value);
          }
        }
        animationTypeCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * End previous animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
       */
      public Builder clearAnimationEnd() {
        if (animationEndBuilder_ == null) {
          if (animationTypeCase_ == 3) {
            animationTypeCase_ = 0;
            animationType_ = null;
            onChanged();
          }
        } else {
          if (animationTypeCase_ == 3) {
            animationTypeCase_ = 0;
            animationType_ = null;
          }
          animationEndBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * End previous animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
       */
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.Builder
          getAnimationEndBuilder() {
        return getAnimationEndFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * End previous animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.video.transcoder.v1.Overlay.AnimationEndOrBuilder
          getAnimationEndOrBuilder() {
        if ((animationTypeCase_ == 3) && (animationEndBuilder_ != null)) {
          return animationEndBuilder_.getMessageOrBuilder();
        } else {
          if (animationTypeCase_ == 3) {
            return (com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd) animationType_;
          }
          return com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * End previous animation.
       * </pre>
       *
       * <code>.google.cloud.video.transcoder.v1.Overlay.AnimationEnd animation_end = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.Builder,
              com.google.cloud.video.transcoder.v1.Overlay.AnimationEndOrBuilder>
          getAnimationEndFieldBuilder() {
        if (animationEndBuilder_ == null) {
          if (!(animationTypeCase_ == 3)) {
            animationType_ =
                com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.getDefaultInstance();
          }
          animationEndBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd,
                  com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd.Builder,
                  com.google.cloud.video.transcoder.v1.Overlay.AnimationEndOrBuilder>(
                  (com.google.cloud.video.transcoder.v1.Overlay.AnimationEnd) animationType_,
                  getParentForChildren(),
                  isClean());
          animationType_ = null;
        }
        animationTypeCase_ = 3;
        onChanged();
        ;
        return animationEndBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.Overlay.Animation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.Overlay.Animation)
    private static final com.google.cloud.video.transcoder.v1.Overlay.Animation DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.Overlay.Animation();
    }

    public static com.google.cloud.video.transcoder.v1.Overlay.Animation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Animation> PARSER =
        new com.google.protobuf.AbstractParser<Animation>() {
          @java.lang.Override
          public Animation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Animation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Animation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay.Animation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int IMAGE_FIELD_NUMBER = 1;
  private com.google.cloud.video.transcoder.v1.Overlay.Image image_;
  /**
   *
   *
   * <pre>
   * Image overlay.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.Overlay.Image image = 1;</code>
   *
   * @return Whether the image field is set.
   */
  @java.lang.Override
  public boolean hasImage() {
    return image_ != null;
  }
  /**
   *
   *
   * <pre>
   * Image overlay.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.Overlay.Image image = 1;</code>
   *
   * @return The image.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Overlay.Image getImage() {
    return image_ == null
        ? com.google.cloud.video.transcoder.v1.Overlay.Image.getDefaultInstance()
        : image_;
  }
  /**
   *
   *
   * <pre>
   * Image overlay.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.Overlay.Image image = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Overlay.ImageOrBuilder getImageOrBuilder() {
    return getImage();
  }

  public static final int ANIMATIONS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.video.transcoder.v1.Overlay.Animation> animations_;
  /**
   *
   *
   * <pre>
   * List of Animations. The list should be chronological, without any time
   * overlap.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.video.transcoder.v1.Overlay.Animation>
      getAnimationsList() {
    return animations_;
  }
  /**
   *
   *
   * <pre>
   * List of Animations. The list should be chronological, without any time
   * overlap.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.video.transcoder.v1.Overlay.AnimationOrBuilder>
      getAnimationsOrBuilderList() {
    return animations_;
  }
  /**
   *
   *
   * <pre>
   * List of Animations. The list should be chronological, without any time
   * overlap.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
   */
  @java.lang.Override
  public int getAnimationsCount() {
    return animations_.size();
  }
  /**
   *
   *
   * <pre>
   * List of Animations. The list should be chronological, without any time
   * overlap.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Overlay.Animation getAnimations(int index) {
    return animations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of Animations. The list should be chronological, without any time
   * overlap.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Overlay.AnimationOrBuilder getAnimationsOrBuilder(
      int index) {
    return animations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (image_ != null) {
      output.writeMessage(1, getImage());
    }
    for (int i = 0; i < animations_.size(); i++) {
      output.writeMessage(2, animations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (image_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getImage());
    }
    for (int i = 0; i < animations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, animations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.video.transcoder.v1.Overlay)) {
      return super.equals(obj);
    }
    com.google.cloud.video.transcoder.v1.Overlay other =
        (com.google.cloud.video.transcoder.v1.Overlay) obj;

    if (hasImage() != other.hasImage()) return false;
    if (hasImage()) {
      if (!getImage().equals(other.getImage())) return false;
    }
    if (!getAnimationsList().equals(other.getAnimationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasImage()) {
      hash = (37 * hash) + IMAGE_FIELD_NUMBER;
      hash = (53 * hash) + getImage().hashCode();
    }
    if (getAnimationsCount() > 0) {
      hash = (37 * hash) + ANIMATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAnimationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.video.transcoder.v1.Overlay parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.Overlay parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Overlay parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.Overlay parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Overlay parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.Overlay parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Overlay parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.Overlay parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Overlay parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.Overlay parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Overlay parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.Overlay parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.video.transcoder.v1.Overlay prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Overlay configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.Overlay}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.Overlay)
      com.google.cloud.video.transcoder.v1.OverlayOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.Overlay.class,
              com.google.cloud.video.transcoder.v1.Overlay.Builder.class);
    }

    // Construct using com.google.cloud.video.transcoder.v1.Overlay.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (imageBuilder_ == null) {
        image_ = null;
      } else {
        image_ = null;
        imageBuilder_ = null;
      }
      if (animationsBuilder_ == null) {
        animations_ = java.util.Collections.emptyList();
      } else {
        animations_ = null;
        animationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Overlay_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay getDefaultInstanceForType() {
      return com.google.cloud.video.transcoder.v1.Overlay.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay build() {
      com.google.cloud.video.transcoder.v1.Overlay result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Overlay buildPartial() {
      com.google.cloud.video.transcoder.v1.Overlay result =
          new com.google.cloud.video.transcoder.v1.Overlay(this);
      int from_bitField0_ = bitField0_;
      if (imageBuilder_ == null) {
        result.image_ = image_;
      } else {
        result.image_ = imageBuilder_.build();
      }
      if (animationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          animations_ = java.util.Collections.unmodifiableList(animations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.animations_ = animations_;
      } else {
        result.animations_ = animationsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.video.transcoder.v1.Overlay) {
        return mergeFrom((com.google.cloud.video.transcoder.v1.Overlay) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.video.transcoder.v1.Overlay other) {
      if (other == com.google.cloud.video.transcoder.v1.Overlay.getDefaultInstance()) return this;
      if (other.hasImage()) {
        mergeImage(other.getImage());
      }
      if (animationsBuilder_ == null) {
        if (!other.animations_.isEmpty()) {
          if (animations_.isEmpty()) {
            animations_ = other.animations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAnimationsIsMutable();
            animations_.addAll(other.animations_);
          }
          onChanged();
        }
      } else {
        if (!other.animations_.isEmpty()) {
          if (animationsBuilder_.isEmpty()) {
            animationsBuilder_.dispose();
            animationsBuilder_ = null;
            animations_ = other.animations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            animationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAnimationsFieldBuilder()
                    : null;
          } else {
            animationsBuilder_.addAllMessages(other.animations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getImageFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                com.google.cloud.video.transcoder.v1.Overlay.Animation m =
                    input.readMessage(
                        com.google.cloud.video.transcoder.v1.Overlay.Animation.parser(),
                        extensionRegistry);
                if (animationsBuilder_ == null) {
                  ensureAnimationsIsMutable();
                  animations_.add(m);
                } else {
                  animationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.video.transcoder.v1.Overlay.Image image_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.Overlay.Image,
            com.google.cloud.video.transcoder.v1.Overlay.Image.Builder,
            com.google.cloud.video.transcoder.v1.Overlay.ImageOrBuilder>
        imageBuilder_;
    /**
     *
     *
     * <pre>
     * Image overlay.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.Image image = 1;</code>
     *
     * @return Whether the image field is set.
     */
    public boolean hasImage() {
      return imageBuilder_ != null || image_ != null;
    }
    /**
     *
     *
     * <pre>
     * Image overlay.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.Image image = 1;</code>
     *
     * @return The image.
     */
    public com.google.cloud.video.transcoder.v1.Overlay.Image getImage() {
      if (imageBuilder_ == null) {
        return image_ == null
            ? com.google.cloud.video.transcoder.v1.Overlay.Image.getDefaultInstance()
            : image_;
      } else {
        return imageBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Image overlay.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.Image image = 1;</code>
     */
    public Builder setImage(com.google.cloud.video.transcoder.v1.Overlay.Image value) {
      if (imageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        image_ = value;
        onChanged();
      } else {
        imageBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Image overlay.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.Image image = 1;</code>
     */
    public Builder setImage(
        com.google.cloud.video.transcoder.v1.Overlay.Image.Builder builderForValue) {
      if (imageBuilder_ == null) {
        image_ = builderForValue.build();
        onChanged();
      } else {
        imageBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Image overlay.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.Image image = 1;</code>
     */
    public Builder mergeImage(com.google.cloud.video.transcoder.v1.Overlay.Image value) {
      if (imageBuilder_ == null) {
        if (image_ != null) {
          image_ =
              com.google.cloud.video.transcoder.v1.Overlay.Image.newBuilder(image_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          image_ = value;
        }
        onChanged();
      } else {
        imageBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Image overlay.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.Image image = 1;</code>
     */
    public Builder clearImage() {
      if (imageBuilder_ == null) {
        image_ = null;
        onChanged();
      } else {
        image_ = null;
        imageBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Image overlay.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.Image image = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.Overlay.Image.Builder getImageBuilder() {

      onChanged();
      return getImageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Image overlay.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.Image image = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.Overlay.ImageOrBuilder getImageOrBuilder() {
      if (imageBuilder_ != null) {
        return imageBuilder_.getMessageOrBuilder();
      } else {
        return image_ == null
            ? com.google.cloud.video.transcoder.v1.Overlay.Image.getDefaultInstance()
            : image_;
      }
    }
    /**
     *
     *
     * <pre>
     * Image overlay.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Overlay.Image image = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.Overlay.Image,
            com.google.cloud.video.transcoder.v1.Overlay.Image.Builder,
            com.google.cloud.video.transcoder.v1.Overlay.ImageOrBuilder>
        getImageFieldBuilder() {
      if (imageBuilder_ == null) {
        imageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.Overlay.Image,
                com.google.cloud.video.transcoder.v1.Overlay.Image.Builder,
                com.google.cloud.video.transcoder.v1.Overlay.ImageOrBuilder>(
                getImage(), getParentForChildren(), isClean());
        image_ = null;
      }
      return imageBuilder_;
    }

    private java.util.List<com.google.cloud.video.transcoder.v1.Overlay.Animation> animations_ =
        java.util.Collections.emptyList();

    private void ensureAnimationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        animations_ =
            new java.util.ArrayList<com.google.cloud.video.transcoder.v1.Overlay.Animation>(
                animations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.Overlay.Animation,
            com.google.cloud.video.transcoder.v1.Overlay.Animation.Builder,
            com.google.cloud.video.transcoder.v1.Overlay.AnimationOrBuilder>
        animationsBuilder_;

    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.Overlay.Animation>
        getAnimationsList() {
      if (animationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(animations_);
      } else {
        return animationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public int getAnimationsCount() {
      if (animationsBuilder_ == null) {
        return animations_.size();
      } else {
        return animationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.Overlay.Animation getAnimations(int index) {
      if (animationsBuilder_ == null) {
        return animations_.get(index);
      } else {
        return animationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public Builder setAnimations(
        int index, com.google.cloud.video.transcoder.v1.Overlay.Animation value) {
      if (animationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnimationsIsMutable();
        animations_.set(index, value);
        onChanged();
      } else {
        animationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public Builder setAnimations(
        int index, com.google.cloud.video.transcoder.v1.Overlay.Animation.Builder builderForValue) {
      if (animationsBuilder_ == null) {
        ensureAnimationsIsMutable();
        animations_.set(index, builderForValue.build());
        onChanged();
      } else {
        animationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public Builder addAnimations(com.google.cloud.video.transcoder.v1.Overlay.Animation value) {
      if (animationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnimationsIsMutable();
        animations_.add(value);
        onChanged();
      } else {
        animationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public Builder addAnimations(
        int index, com.google.cloud.video.transcoder.v1.Overlay.Animation value) {
      if (animationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnimationsIsMutable();
        animations_.add(index, value);
        onChanged();
      } else {
        animationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public Builder addAnimations(
        com.google.cloud.video.transcoder.v1.Overlay.Animation.Builder builderForValue) {
      if (animationsBuilder_ == null) {
        ensureAnimationsIsMutable();
        animations_.add(builderForValue.build());
        onChanged();
      } else {
        animationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public Builder addAnimations(
        int index, com.google.cloud.video.transcoder.v1.Overlay.Animation.Builder builderForValue) {
      if (animationsBuilder_ == null) {
        ensureAnimationsIsMutable();
        animations_.add(index, builderForValue.build());
        onChanged();
      } else {
        animationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public Builder addAllAnimations(
        java.lang.Iterable<? extends com.google.cloud.video.transcoder.v1.Overlay.Animation>
            values) {
      if (animationsBuilder_ == null) {
        ensureAnimationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, animations_);
        onChanged();
      } else {
        animationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public Builder clearAnimations() {
      if (animationsBuilder_ == null) {
        animations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        animationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public Builder removeAnimations(int index) {
      if (animationsBuilder_ == null) {
        ensureAnimationsIsMutable();
        animations_.remove(index);
        onChanged();
      } else {
        animationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.Overlay.Animation.Builder getAnimationsBuilder(
        int index) {
      return getAnimationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.Overlay.AnimationOrBuilder getAnimationsOrBuilder(
        int index) {
      if (animationsBuilder_ == null) {
        return animations_.get(index);
      } else {
        return animationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.video.transcoder.v1.Overlay.AnimationOrBuilder>
        getAnimationsOrBuilderList() {
      if (animationsBuilder_ != null) {
        return animationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(animations_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.Overlay.Animation.Builder addAnimationsBuilder() {
      return getAnimationsFieldBuilder()
          .addBuilder(com.google.cloud.video.transcoder.v1.Overlay.Animation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.Overlay.Animation.Builder addAnimationsBuilder(
        int index) {
      return getAnimationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.video.transcoder.v1.Overlay.Animation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of Animations. The list should be chronological, without any time
     * overlap.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay.Animation animations = 2;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.Overlay.Animation.Builder>
        getAnimationsBuilderList() {
      return getAnimationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.Overlay.Animation,
            com.google.cloud.video.transcoder.v1.Overlay.Animation.Builder,
            com.google.cloud.video.transcoder.v1.Overlay.AnimationOrBuilder>
        getAnimationsFieldBuilder() {
      if (animationsBuilder_ == null) {
        animationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.Overlay.Animation,
                com.google.cloud.video.transcoder.v1.Overlay.Animation.Builder,
                com.google.cloud.video.transcoder.v1.Overlay.AnimationOrBuilder>(
                animations_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        animations_ = null;
      }
      return animationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.Overlay)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.Overlay)
  private static final com.google.cloud.video.transcoder.v1.Overlay DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.Overlay();
  }

  public static com.google.cloud.video.transcoder.v1.Overlay getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Overlay> PARSER =
      new com.google.protobuf.AbstractParser<Overlay>() {
        @java.lang.Override
        public Overlay parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Overlay> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Overlay> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Overlay getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
