/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/video/transcoder/v1/resources.proto

package com.google.cloud.video.transcoder.v1;

/**
 *
 *
 * <pre>
 * Multiplexing settings for output stream.
 * </pre>
 *
 * Protobuf type {@code google.cloud.video.transcoder.v1.MuxStream}
 */
public final class MuxStream extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.MuxStream)
    MuxStreamOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MuxStream.newBuilder() to construct.
  private MuxStream(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MuxStream() {
    key_ = "";
    fileName_ = "";
    container_ = "";
    elementaryStreams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MuxStream();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_MuxStream_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_MuxStream_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.video.transcoder.v1.MuxStream.class,
            com.google.cloud.video.transcoder.v1.MuxStream.Builder.class);
  }

  public static final int KEY_FIELD_NUMBER = 1;
  private volatile java.lang.Object key_;
  /**
   *
   *
   * <pre>
   * A unique key for this multiplexed stream. HLS media manifests will be
   * named `MuxStream.key` with the `.m3u8` extension suffix.
   * </pre>
   *
   * <code>string key = 1;</code>
   *
   * @return The key.
   */
  @java.lang.Override
  public java.lang.String getKey() {
    java.lang.Object ref = key_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      key_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique key for this multiplexed stream. HLS media manifests will be
   * named `MuxStream.key` with the `.m3u8` extension suffix.
   * </pre>
   *
   * <code>string key = 1;</code>
   *
   * @return The bytes for key.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyBytes() {
    java.lang.Object ref = key_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      key_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILE_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object fileName_;
  /**
   *
   *
   * <pre>
   * The name of the generated file. The default is `MuxStream.key` with the
   * extension suffix corresponding to the `MuxStream.container`.
   * Individual segments also have an incremental 10-digit zero-padded suffix
   * starting from 0 before the extension, such as `mux_stream0000000123.ts`.
   * </pre>
   *
   * <code>string file_name = 2;</code>
   *
   * @return The fileName.
   */
  @java.lang.Override
  public java.lang.String getFileName() {
    java.lang.Object ref = fileName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fileName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the generated file. The default is `MuxStream.key` with the
   * extension suffix corresponding to the `MuxStream.container`.
   * Individual segments also have an incremental 10-digit zero-padded suffix
   * starting from 0 before the extension, such as `mux_stream0000000123.ts`.
   * </pre>
   *
   * <code>string file_name = 2;</code>
   *
   * @return The bytes for fileName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFileNameBytes() {
    java.lang.Object ref = fileName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fileName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTAINER_FIELD_NUMBER = 3;
  private volatile java.lang.Object container_;
  /**
   *
   *
   * <pre>
   * The container format. The default is `mp4`
   * Supported container formats:
   * - `ts`
   * - `fmp4`- the corresponding file extension is `.m4s`
   * - `mp4`
   * - `vtt`
   * See also:
   * [Supported input and output
   * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats)
   * </pre>
   *
   * <code>string container = 3;</code>
   *
   * @return The container.
   */
  @java.lang.Override
  public java.lang.String getContainer() {
    java.lang.Object ref = container_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      container_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The container format. The default is `mp4`
   * Supported container formats:
   * - `ts`
   * - `fmp4`- the corresponding file extension is `.m4s`
   * - `mp4`
   * - `vtt`
   * See also:
   * [Supported input and output
   * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats)
   * </pre>
   *
   * <code>string container = 3;</code>
   *
   * @return The bytes for container.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContainerBytes() {
    java.lang.Object ref = container_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      container_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ELEMENTARY_STREAMS_FIELD_NUMBER = 4;
  private com.google.protobuf.LazyStringList elementaryStreams_;
  /**
   *
   *
   * <pre>
   * List of `ElementaryStream.key`s multiplexed in this stream.
   * </pre>
   *
   * <code>repeated string elementary_streams = 4;</code>
   *
   * @return A list containing the elementaryStreams.
   */
  public com.google.protobuf.ProtocolStringList getElementaryStreamsList() {
    return elementaryStreams_;
  }
  /**
   *
   *
   * <pre>
   * List of `ElementaryStream.key`s multiplexed in this stream.
   * </pre>
   *
   * <code>repeated string elementary_streams = 4;</code>
   *
   * @return The count of elementaryStreams.
   */
  public int getElementaryStreamsCount() {
    return elementaryStreams_.size();
  }
  /**
   *
   *
   * <pre>
   * List of `ElementaryStream.key`s multiplexed in this stream.
   * </pre>
   *
   * <code>repeated string elementary_streams = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The elementaryStreams at the given index.
   */
  public java.lang.String getElementaryStreams(int index) {
    return elementaryStreams_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of `ElementaryStream.key`s multiplexed in this stream.
   * </pre>
   *
   * <code>repeated string elementary_streams = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the elementaryStreams at the given index.
   */
  public com.google.protobuf.ByteString getElementaryStreamsBytes(int index) {
    return elementaryStreams_.getByteString(index);
  }

  public static final int SEGMENT_SETTINGS_FIELD_NUMBER = 5;
  private com.google.cloud.video.transcoder.v1.SegmentSettings segmentSettings_;
  /**
   *
   *
   * <pre>
   * Segment settings for `ts`, `fmp4` and `vtt`.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.SegmentSettings segment_settings = 5;</code>
   *
   * @return Whether the segmentSettings field is set.
   */
  @java.lang.Override
  public boolean hasSegmentSettings() {
    return segmentSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Segment settings for `ts`, `fmp4` and `vtt`.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.SegmentSettings segment_settings = 5;</code>
   *
   * @return The segmentSettings.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.SegmentSettings getSegmentSettings() {
    return segmentSettings_ == null
        ? com.google.cloud.video.transcoder.v1.SegmentSettings.getDefaultInstance()
        : segmentSettings_;
  }
  /**
   *
   *
   * <pre>
   * Segment settings for `ts`, `fmp4` and `vtt`.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.SegmentSettings segment_settings = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.SegmentSettingsOrBuilder
      getSegmentSettingsOrBuilder() {
    return getSegmentSettings();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fileName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fileName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(container_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, container_);
    }
    for (int i = 0; i < elementaryStreams_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, elementaryStreams_.getRaw(i));
    }
    if (segmentSettings_ != null) {
      output.writeMessage(5, getSegmentSettings());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fileName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fileName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(container_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, container_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < elementaryStreams_.size(); i++) {
        dataSize += computeStringSizeNoTag(elementaryStreams_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getElementaryStreamsList().size();
    }
    if (segmentSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSegmentSettings());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.video.transcoder.v1.MuxStream)) {
      return super.equals(obj);
    }
    com.google.cloud.video.transcoder.v1.MuxStream other =
        (com.google.cloud.video.transcoder.v1.MuxStream) obj;

    if (!getKey().equals(other.getKey())) return false;
    if (!getFileName().equals(other.getFileName())) return false;
    if (!getContainer().equals(other.getContainer())) return false;
    if (!getElementaryStreamsList().equals(other.getElementaryStreamsList())) return false;
    if (hasSegmentSettings() != other.hasSegmentSettings()) return false;
    if (hasSegmentSettings()) {
      if (!getSegmentSettings().equals(other.getSegmentSettings())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKey().hashCode();
    hash = (37 * hash) + FILE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFileName().hashCode();
    hash = (37 * hash) + CONTAINER_FIELD_NUMBER;
    hash = (53 * hash) + getContainer().hashCode();
    if (getElementaryStreamsCount() > 0) {
      hash = (37 * hash) + ELEMENTARY_STREAMS_FIELD_NUMBER;
      hash = (53 * hash) + getElementaryStreamsList().hashCode();
    }
    if (hasSegmentSettings()) {
      hash = (37 * hash) + SEGMENT_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getSegmentSettings().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.video.transcoder.v1.MuxStream prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Multiplexing settings for output stream.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.MuxStream}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.MuxStream)
      com.google.cloud.video.transcoder.v1.MuxStreamOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_MuxStream_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_MuxStream_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.MuxStream.class,
              com.google.cloud.video.transcoder.v1.MuxStream.Builder.class);
    }

    // Construct using com.google.cloud.video.transcoder.v1.MuxStream.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      key_ = "";

      fileName_ = "";

      container_ = "";

      elementaryStreams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (segmentSettingsBuilder_ == null) {
        segmentSettings_ = null;
      } else {
        segmentSettings_ = null;
        segmentSettingsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_MuxStream_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.MuxStream getDefaultInstanceForType() {
      return com.google.cloud.video.transcoder.v1.MuxStream.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.MuxStream build() {
      com.google.cloud.video.transcoder.v1.MuxStream result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.MuxStream buildPartial() {
      com.google.cloud.video.transcoder.v1.MuxStream result =
          new com.google.cloud.video.transcoder.v1.MuxStream(this);
      int from_bitField0_ = bitField0_;
      result.key_ = key_;
      result.fileName_ = fileName_;
      result.container_ = container_;
      if (((bitField0_ & 0x00000001) != 0)) {
        elementaryStreams_ = elementaryStreams_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.elementaryStreams_ = elementaryStreams_;
      if (segmentSettingsBuilder_ == null) {
        result.segmentSettings_ = segmentSettings_;
      } else {
        result.segmentSettings_ = segmentSettingsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.video.transcoder.v1.MuxStream) {
        return mergeFrom((com.google.cloud.video.transcoder.v1.MuxStream) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.video.transcoder.v1.MuxStream other) {
      if (other == com.google.cloud.video.transcoder.v1.MuxStream.getDefaultInstance()) return this;
      if (!other.getKey().isEmpty()) {
        key_ = other.key_;
        onChanged();
      }
      if (!other.getFileName().isEmpty()) {
        fileName_ = other.fileName_;
        onChanged();
      }
      if (!other.getContainer().isEmpty()) {
        container_ = other.container_;
        onChanged();
      }
      if (!other.elementaryStreams_.isEmpty()) {
        if (elementaryStreams_.isEmpty()) {
          elementaryStreams_ = other.elementaryStreams_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureElementaryStreamsIsMutable();
          elementaryStreams_.addAll(other.elementaryStreams_);
        }
        onChanged();
      }
      if (other.hasSegmentSettings()) {
        mergeSegmentSettings(other.getSegmentSettings());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                key_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                fileName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                container_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureElementaryStreamsIsMutable();
                elementaryStreams_.add(s);
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getSegmentSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * A unique key for this multiplexed stream. HLS media manifests will be
     * named `MuxStream.key` with the `.m3u8` extension suffix.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique key for this multiplexed stream. HLS media manifests will be
     * named `MuxStream.key` with the `.m3u8` extension suffix.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique key for this multiplexed stream. HLS media manifests will be
     * named `MuxStream.key` with the `.m3u8` extension suffix.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @param value The key to set.
     * @return This builder for chaining.
     */
    public Builder setKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      key_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique key for this multiplexed stream. HLS media manifests will be
     * named `MuxStream.key` with the `.m3u8` extension suffix.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKey() {

      key_ = getDefaultInstance().getKey();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique key for this multiplexed stream. HLS media manifests will be
     * named `MuxStream.key` with the `.m3u8` extension suffix.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @param value The bytes for key to set.
     * @return This builder for chaining.
     */
    public Builder setKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      key_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object fileName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the generated file. The default is `MuxStream.key` with the
     * extension suffix corresponding to the `MuxStream.container`.
     * Individual segments also have an incremental 10-digit zero-padded suffix
     * starting from 0 before the extension, such as `mux_stream0000000123.ts`.
     * </pre>
     *
     * <code>string file_name = 2;</code>
     *
     * @return The fileName.
     */
    public java.lang.String getFileName() {
      java.lang.Object ref = fileName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fileName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the generated file. The default is `MuxStream.key` with the
     * extension suffix corresponding to the `MuxStream.container`.
     * Individual segments also have an incremental 10-digit zero-padded suffix
     * starting from 0 before the extension, such as `mux_stream0000000123.ts`.
     * </pre>
     *
     * <code>string file_name = 2;</code>
     *
     * @return The bytes for fileName.
     */
    public com.google.protobuf.ByteString getFileNameBytes() {
      java.lang.Object ref = fileName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fileName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the generated file. The default is `MuxStream.key` with the
     * extension suffix corresponding to the `MuxStream.container`.
     * Individual segments also have an incremental 10-digit zero-padded suffix
     * starting from 0 before the extension, such as `mux_stream0000000123.ts`.
     * </pre>
     *
     * <code>string file_name = 2;</code>
     *
     * @param value The fileName to set.
     * @return This builder for chaining.
     */
    public Builder setFileName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      fileName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the generated file. The default is `MuxStream.key` with the
     * extension suffix corresponding to the `MuxStream.container`.
     * Individual segments also have an incremental 10-digit zero-padded suffix
     * starting from 0 before the extension, such as `mux_stream0000000123.ts`.
     * </pre>
     *
     * <code>string file_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFileName() {

      fileName_ = getDefaultInstance().getFileName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the generated file. The default is `MuxStream.key` with the
     * extension suffix corresponding to the `MuxStream.container`.
     * Individual segments also have an incremental 10-digit zero-padded suffix
     * starting from 0 before the extension, such as `mux_stream0000000123.ts`.
     * </pre>
     *
     * <code>string file_name = 2;</code>
     *
     * @param value The bytes for fileName to set.
     * @return This builder for chaining.
     */
    public Builder setFileNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      fileName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object container_ = "";
    /**
     *
     *
     * <pre>
     * The container format. The default is `mp4`
     * Supported container formats:
     * - `ts`
     * - `fmp4`- the corresponding file extension is `.m4s`
     * - `mp4`
     * - `vtt`
     * See also:
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats)
     * </pre>
     *
     * <code>string container = 3;</code>
     *
     * @return The container.
     */
    public java.lang.String getContainer() {
      java.lang.Object ref = container_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        container_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The container format. The default is `mp4`
     * Supported container formats:
     * - `ts`
     * - `fmp4`- the corresponding file extension is `.m4s`
     * - `mp4`
     * - `vtt`
     * See also:
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats)
     * </pre>
     *
     * <code>string container = 3;</code>
     *
     * @return The bytes for container.
     */
    public com.google.protobuf.ByteString getContainerBytes() {
      java.lang.Object ref = container_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        container_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The container format. The default is `mp4`
     * Supported container formats:
     * - `ts`
     * - `fmp4`- the corresponding file extension is `.m4s`
     * - `mp4`
     * - `vtt`
     * See also:
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats)
     * </pre>
     *
     * <code>string container = 3;</code>
     *
     * @param value The container to set.
     * @return This builder for chaining.
     */
    public Builder setContainer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      container_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The container format. The default is `mp4`
     * Supported container formats:
     * - `ts`
     * - `fmp4`- the corresponding file extension is `.m4s`
     * - `mp4`
     * - `vtt`
     * See also:
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats)
     * </pre>
     *
     * <code>string container = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContainer() {

      container_ = getDefaultInstance().getContainer();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The container format. The default is `mp4`
     * Supported container formats:
     * - `ts`
     * - `fmp4`- the corresponding file extension is `.m4s`
     * - `mp4`
     * - `vtt`
     * See also:
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats)
     * </pre>
     *
     * <code>string container = 3;</code>
     *
     * @param value The bytes for container to set.
     * @return This builder for chaining.
     */
    public Builder setContainerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      container_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList elementaryStreams_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureElementaryStreamsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        elementaryStreams_ = new com.google.protobuf.LazyStringArrayList(elementaryStreams_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * List of `ElementaryStream.key`s multiplexed in this stream.
     * </pre>
     *
     * <code>repeated string elementary_streams = 4;</code>
     *
     * @return A list containing the elementaryStreams.
     */
    public com.google.protobuf.ProtocolStringList getElementaryStreamsList() {
      return elementaryStreams_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * List of `ElementaryStream.key`s multiplexed in this stream.
     * </pre>
     *
     * <code>repeated string elementary_streams = 4;</code>
     *
     * @return The count of elementaryStreams.
     */
    public int getElementaryStreamsCount() {
      return elementaryStreams_.size();
    }
    /**
     *
     *
     * <pre>
     * List of `ElementaryStream.key`s multiplexed in this stream.
     * </pre>
     *
     * <code>repeated string elementary_streams = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The elementaryStreams at the given index.
     */
    public java.lang.String getElementaryStreams(int index) {
      return elementaryStreams_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of `ElementaryStream.key`s multiplexed in this stream.
     * </pre>
     *
     * <code>repeated string elementary_streams = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the elementaryStreams at the given index.
     */
    public com.google.protobuf.ByteString getElementaryStreamsBytes(int index) {
      return elementaryStreams_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of `ElementaryStream.key`s multiplexed in this stream.
     * </pre>
     *
     * <code>repeated string elementary_streams = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The elementaryStreams to set.
     * @return This builder for chaining.
     */
    public Builder setElementaryStreams(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureElementaryStreamsIsMutable();
      elementaryStreams_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `ElementaryStream.key`s multiplexed in this stream.
     * </pre>
     *
     * <code>repeated string elementary_streams = 4;</code>
     *
     * @param value The elementaryStreams to add.
     * @return This builder for chaining.
     */
    public Builder addElementaryStreams(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureElementaryStreamsIsMutable();
      elementaryStreams_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `ElementaryStream.key`s multiplexed in this stream.
     * </pre>
     *
     * <code>repeated string elementary_streams = 4;</code>
     *
     * @param values The elementaryStreams to add.
     * @return This builder for chaining.
     */
    public Builder addAllElementaryStreams(java.lang.Iterable<java.lang.String> values) {
      ensureElementaryStreamsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, elementaryStreams_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `ElementaryStream.key`s multiplexed in this stream.
     * </pre>
     *
     * <code>repeated string elementary_streams = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearElementaryStreams() {
      elementaryStreams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `ElementaryStream.key`s multiplexed in this stream.
     * </pre>
     *
     * <code>repeated string elementary_streams = 4;</code>
     *
     * @param value The bytes of the elementaryStreams to add.
     * @return This builder for chaining.
     */
    public Builder addElementaryStreamsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureElementaryStreamsIsMutable();
      elementaryStreams_.add(value);
      onChanged();
      return this;
    }

    private com.google.cloud.video.transcoder.v1.SegmentSettings segmentSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.SegmentSettings,
            com.google.cloud.video.transcoder.v1.SegmentSettings.Builder,
            com.google.cloud.video.transcoder.v1.SegmentSettingsOrBuilder>
        segmentSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Segment settings for `ts`, `fmp4` and `vtt`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.SegmentSettings segment_settings = 5;</code>
     *
     * @return Whether the segmentSettings field is set.
     */
    public boolean hasSegmentSettings() {
      return segmentSettingsBuilder_ != null || segmentSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Segment settings for `ts`, `fmp4` and `vtt`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.SegmentSettings segment_settings = 5;</code>
     *
     * @return The segmentSettings.
     */
    public com.google.cloud.video.transcoder.v1.SegmentSettings getSegmentSettings() {
      if (segmentSettingsBuilder_ == null) {
        return segmentSettings_ == null
            ? com.google.cloud.video.transcoder.v1.SegmentSettings.getDefaultInstance()
            : segmentSettings_;
      } else {
        return segmentSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Segment settings for `ts`, `fmp4` and `vtt`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.SegmentSettings segment_settings = 5;</code>
     */
    public Builder setSegmentSettings(com.google.cloud.video.transcoder.v1.SegmentSettings value) {
      if (segmentSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        segmentSettings_ = value;
        onChanged();
      } else {
        segmentSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Segment settings for `ts`, `fmp4` and `vtt`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.SegmentSettings segment_settings = 5;</code>
     */
    public Builder setSegmentSettings(
        com.google.cloud.video.transcoder.v1.SegmentSettings.Builder builderForValue) {
      if (segmentSettingsBuilder_ == null) {
        segmentSettings_ = builderForValue.build();
        onChanged();
      } else {
        segmentSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Segment settings for `ts`, `fmp4` and `vtt`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.SegmentSettings segment_settings = 5;</code>
     */
    public Builder mergeSegmentSettings(
        com.google.cloud.video.transcoder.v1.SegmentSettings value) {
      if (segmentSettingsBuilder_ == null) {
        if (segmentSettings_ != null) {
          segmentSettings_ =
              com.google.cloud.video.transcoder.v1.SegmentSettings.newBuilder(segmentSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          segmentSettings_ = value;
        }
        onChanged();
      } else {
        segmentSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Segment settings for `ts`, `fmp4` and `vtt`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.SegmentSettings segment_settings = 5;</code>
     */
    public Builder clearSegmentSettings() {
      if (segmentSettingsBuilder_ == null) {
        segmentSettings_ = null;
        onChanged();
      } else {
        segmentSettings_ = null;
        segmentSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Segment settings for `ts`, `fmp4` and `vtt`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.SegmentSettings segment_settings = 5;</code>
     */
    public com.google.cloud.video.transcoder.v1.SegmentSettings.Builder
        getSegmentSettingsBuilder() {

      onChanged();
      return getSegmentSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Segment settings for `ts`, `fmp4` and `vtt`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.SegmentSettings segment_settings = 5;</code>
     */
    public com.google.cloud.video.transcoder.v1.SegmentSettingsOrBuilder
        getSegmentSettingsOrBuilder() {
      if (segmentSettingsBuilder_ != null) {
        return segmentSettingsBuilder_.getMessageOrBuilder();
      } else {
        return segmentSettings_ == null
            ? com.google.cloud.video.transcoder.v1.SegmentSettings.getDefaultInstance()
            : segmentSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Segment settings for `ts`, `fmp4` and `vtt`.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.SegmentSettings segment_settings = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.SegmentSettings,
            com.google.cloud.video.transcoder.v1.SegmentSettings.Builder,
            com.google.cloud.video.transcoder.v1.SegmentSettingsOrBuilder>
        getSegmentSettingsFieldBuilder() {
      if (segmentSettingsBuilder_ == null) {
        segmentSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.SegmentSettings,
                com.google.cloud.video.transcoder.v1.SegmentSettings.Builder,
                com.google.cloud.video.transcoder.v1.SegmentSettingsOrBuilder>(
                getSegmentSettings(), getParentForChildren(), isClean());
        segmentSettings_ = null;
      }
      return segmentSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.MuxStream)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.MuxStream)
  private static final com.google.cloud.video.transcoder.v1.MuxStream DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.MuxStream();
  }

  public static com.google.cloud.video.transcoder.v1.MuxStream getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MuxStream> PARSER =
      new com.google.protobuf.AbstractParser<MuxStream>() {
        @java.lang.Override
        public MuxStream parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MuxStream> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MuxStream> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.MuxStream getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
