/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/video/transcoder/v1/resources.proto

package com.google.cloud.video.transcoder.v1;

/**
 *
 *
 * <pre>
 * Manifest configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.video.transcoder.v1.Manifest}
 */
public final class Manifest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.Manifest)
    ManifestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Manifest.newBuilder() to construct.
  private Manifest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Manifest() {
    fileName_ = "";
    type_ = 0;
    muxStreams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Manifest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_Manifest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_Manifest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.video.transcoder.v1.Manifest.class,
            com.google.cloud.video.transcoder.v1.Manifest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The manifest type can be either `HLS` or `DASH`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.video.transcoder.v1.Manifest.ManifestType}
   */
  public enum ManifestType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The manifest type is not specified.
     * </pre>
     *
     * <code>MANIFEST_TYPE_UNSPECIFIED = 0;</code>
     */
    MANIFEST_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Create `HLS` manifest. The corresponding file extension is `.m3u8`.
     * </pre>
     *
     * <code>HLS = 1;</code>
     */
    HLS(1),
    /**
     *
     *
     * <pre>
     * Create `DASH` manifest. The corresponding file extension is `.mpd`.
     * </pre>
     *
     * <code>DASH = 2;</code>
     */
    DASH(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The manifest type is not specified.
     * </pre>
     *
     * <code>MANIFEST_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int MANIFEST_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Create `HLS` manifest. The corresponding file extension is `.m3u8`.
     * </pre>
     *
     * <code>HLS = 1;</code>
     */
    public static final int HLS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Create `DASH` manifest. The corresponding file extension is `.mpd`.
     * </pre>
     *
     * <code>DASH = 2;</code>
     */
    public static final int DASH_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ManifestType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ManifestType forNumber(int value) {
      switch (value) {
        case 0:
          return MANIFEST_TYPE_UNSPECIFIED;
        case 1:
          return HLS;
        case 2:
          return DASH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ManifestType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ManifestType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ManifestType>() {
          public ManifestType findValueByNumber(int number) {
            return ManifestType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.Manifest.getDescriptor().getEnumTypes().get(0);
    }

    private static final ManifestType[] VALUES = values();

    public static ManifestType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ManifestType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.video.transcoder.v1.Manifest.ManifestType)
  }

  public static final int FILE_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object fileName_;
  /**
   *
   *
   * <pre>
   * The name of the generated file. The default is `manifest` with the
   * extension suffix corresponding to the `Manifest.type`.
   * </pre>
   *
   * <code>string file_name = 1;</code>
   *
   * @return The fileName.
   */
  @java.lang.Override
  public java.lang.String getFileName() {
    java.lang.Object ref = fileName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fileName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the generated file. The default is `manifest` with the
   * extension suffix corresponding to the `Manifest.type`.
   * </pre>
   *
   * <code>string file_name = 1;</code>
   *
   * @return The bytes for fileName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFileNameBytes() {
    java.lang.Object ref = fileName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fileName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_;
  /**
   *
   *
   * <pre>
   * Required. Type of the manifest, can be `HLS` or `DASH`.
   * </pre>
   *
   * <code>
   * .google.cloud.video.transcoder.v1.Manifest.ManifestType type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Required. Type of the manifest, can be `HLS` or `DASH`.
   * </pre>
   *
   * <code>
   * .google.cloud.video.transcoder.v1.Manifest.ManifestType type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Manifest.ManifestType getType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.video.transcoder.v1.Manifest.ManifestType result =
        com.google.cloud.video.transcoder.v1.Manifest.ManifestType.valueOf(type_);
    return result == null
        ? com.google.cloud.video.transcoder.v1.Manifest.ManifestType.UNRECOGNIZED
        : result;
  }

  public static final int MUX_STREAMS_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList muxStreams_;
  /**
   *
   *
   * <pre>
   * Required. List of user given `MuxStream.key`s that should appear in this manifest.
   * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
   * and `.m3u8` extension is generated for each element of the
   * `Manifest.mux_streams`.
   * </pre>
   *
   * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the muxStreams.
   */
  public com.google.protobuf.ProtocolStringList getMuxStreamsList() {
    return muxStreams_;
  }
  /**
   *
   *
   * <pre>
   * Required. List of user given `MuxStream.key`s that should appear in this manifest.
   * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
   * and `.m3u8` extension is generated for each element of the
   * `Manifest.mux_streams`.
   * </pre>
   *
   * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of muxStreams.
   */
  public int getMuxStreamsCount() {
    return muxStreams_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. List of user given `MuxStream.key`s that should appear in this manifest.
   * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
   * and `.m3u8` extension is generated for each element of the
   * `Manifest.mux_streams`.
   * </pre>
   *
   * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The muxStreams at the given index.
   */
  public java.lang.String getMuxStreams(int index) {
    return muxStreams_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. List of user given `MuxStream.key`s that should appear in this manifest.
   * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
   * and `.m3u8` extension is generated for each element of the
   * `Manifest.mux_streams`.
   * </pre>
   *
   * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the muxStreams at the given index.
   */
  public com.google.protobuf.ByteString getMuxStreamsBytes(int index) {
    return muxStreams_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fileName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fileName_);
    }
    if (type_
        != com.google.cloud.video.transcoder.v1.Manifest.ManifestType.MANIFEST_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, type_);
    }
    for (int i = 0; i < muxStreams_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, muxStreams_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fileName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fileName_);
    }
    if (type_
        != com.google.cloud.video.transcoder.v1.Manifest.ManifestType.MANIFEST_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < muxStreams_.size(); i++) {
        dataSize += computeStringSizeNoTag(muxStreams_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getMuxStreamsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.video.transcoder.v1.Manifest)) {
      return super.equals(obj);
    }
    com.google.cloud.video.transcoder.v1.Manifest other =
        (com.google.cloud.video.transcoder.v1.Manifest) obj;

    if (!getFileName().equals(other.getFileName())) return false;
    if (type_ != other.type_) return false;
    if (!getMuxStreamsList().equals(other.getMuxStreamsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FILE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFileName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (getMuxStreamsCount() > 0) {
      hash = (37 * hash) + MUX_STREAMS_FIELD_NUMBER;
      hash = (53 * hash) + getMuxStreamsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.video.transcoder.v1.Manifest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.Manifest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Manifest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.Manifest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Manifest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.Manifest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Manifest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.Manifest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Manifest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.Manifest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Manifest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.Manifest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.video.transcoder.v1.Manifest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Manifest configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.Manifest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.Manifest)
      com.google.cloud.video.transcoder.v1.ManifestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Manifest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Manifest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.Manifest.class,
              com.google.cloud.video.transcoder.v1.Manifest.Builder.class);
    }

    // Construct using com.google.cloud.video.transcoder.v1.Manifest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      fileName_ = "";

      type_ = 0;

      muxStreams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Manifest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Manifest getDefaultInstanceForType() {
      return com.google.cloud.video.transcoder.v1.Manifest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Manifest build() {
      com.google.cloud.video.transcoder.v1.Manifest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Manifest buildPartial() {
      com.google.cloud.video.transcoder.v1.Manifest result =
          new com.google.cloud.video.transcoder.v1.Manifest(this);
      int from_bitField0_ = bitField0_;
      result.fileName_ = fileName_;
      result.type_ = type_;
      if (((bitField0_ & 0x00000001) != 0)) {
        muxStreams_ = muxStreams_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.muxStreams_ = muxStreams_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.video.transcoder.v1.Manifest) {
        return mergeFrom((com.google.cloud.video.transcoder.v1.Manifest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.video.transcoder.v1.Manifest other) {
      if (other == com.google.cloud.video.transcoder.v1.Manifest.getDefaultInstance()) return this;
      if (!other.getFileName().isEmpty()) {
        fileName_ = other.fileName_;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.muxStreams_.isEmpty()) {
        if (muxStreams_.isEmpty()) {
          muxStreams_ = other.muxStreams_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureMuxStreamsIsMutable();
          muxStreams_.addAll(other.muxStreams_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                fileName_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();

                break;
              } // case 16
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMuxStreamsIsMutable();
                muxStreams_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object fileName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the generated file. The default is `manifest` with the
     * extension suffix corresponding to the `Manifest.type`.
     * </pre>
     *
     * <code>string file_name = 1;</code>
     *
     * @return The fileName.
     */
    public java.lang.String getFileName() {
      java.lang.Object ref = fileName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fileName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the generated file. The default is `manifest` with the
     * extension suffix corresponding to the `Manifest.type`.
     * </pre>
     *
     * <code>string file_name = 1;</code>
     *
     * @return The bytes for fileName.
     */
    public com.google.protobuf.ByteString getFileNameBytes() {
      java.lang.Object ref = fileName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fileName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the generated file. The default is `manifest` with the
     * extension suffix corresponding to the `Manifest.type`.
     * </pre>
     *
     * <code>string file_name = 1;</code>
     *
     * @param value The fileName to set.
     * @return This builder for chaining.
     */
    public Builder setFileName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      fileName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the generated file. The default is `manifest` with the
     * extension suffix corresponding to the `Manifest.type`.
     * </pre>
     *
     * <code>string file_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFileName() {

      fileName_ = getDefaultInstance().getFileName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the generated file. The default is `manifest` with the
     * extension suffix corresponding to the `Manifest.type`.
     * </pre>
     *
     * <code>string file_name = 1;</code>
     *
     * @param value The bytes for fileName to set.
     * @return This builder for chaining.
     */
    public Builder setFileNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      fileName_ = value;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Type of the manifest, can be `HLS` or `DASH`.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Manifest.ManifestType type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Required. Type of the manifest, can be `HLS` or `DASH`.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Manifest.ManifestType type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {

      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Type of the manifest, can be `HLS` or `DASH`.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Manifest.ManifestType type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Manifest.ManifestType getType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.video.transcoder.v1.Manifest.ManifestType result =
          com.google.cloud.video.transcoder.v1.Manifest.ManifestType.valueOf(type_);
      return result == null
          ? com.google.cloud.video.transcoder.v1.Manifest.ManifestType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Type of the manifest, can be `HLS` or `DASH`.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Manifest.ManifestType type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.video.transcoder.v1.Manifest.ManifestType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Type of the manifest, can be `HLS` or `DASH`.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Manifest.ManifestType type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {

      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList muxStreams_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureMuxStreamsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        muxStreams_ = new com.google.protobuf.LazyStringArrayList(muxStreams_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of user given `MuxStream.key`s that should appear in this manifest.
     * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
     * and `.m3u8` extension is generated for each element of the
     * `Manifest.mux_streams`.
     * </pre>
     *
     * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the muxStreams.
     */
    public com.google.protobuf.ProtocolStringList getMuxStreamsList() {
      return muxStreams_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Required. List of user given `MuxStream.key`s that should appear in this manifest.
     * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
     * and `.m3u8` extension is generated for each element of the
     * `Manifest.mux_streams`.
     * </pre>
     *
     * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of muxStreams.
     */
    public int getMuxStreamsCount() {
      return muxStreams_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. List of user given `MuxStream.key`s that should appear in this manifest.
     * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
     * and `.m3u8` extension is generated for each element of the
     * `Manifest.mux_streams`.
     * </pre>
     *
     * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The muxStreams at the given index.
     */
    public java.lang.String getMuxStreams(int index) {
      return muxStreams_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. List of user given `MuxStream.key`s that should appear in this manifest.
     * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
     * and `.m3u8` extension is generated for each element of the
     * `Manifest.mux_streams`.
     * </pre>
     *
     * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the muxStreams at the given index.
     */
    public com.google.protobuf.ByteString getMuxStreamsBytes(int index) {
      return muxStreams_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. List of user given `MuxStream.key`s that should appear in this manifest.
     * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
     * and `.m3u8` extension is generated for each element of the
     * `Manifest.mux_streams`.
     * </pre>
     *
     * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The muxStreams to set.
     * @return This builder for chaining.
     */
    public Builder setMuxStreams(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMuxStreamsIsMutable();
      muxStreams_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of user given `MuxStream.key`s that should appear in this manifest.
     * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
     * and `.m3u8` extension is generated for each element of the
     * `Manifest.mux_streams`.
     * </pre>
     *
     * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The muxStreams to add.
     * @return This builder for chaining.
     */
    public Builder addMuxStreams(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMuxStreamsIsMutable();
      muxStreams_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of user given `MuxStream.key`s that should appear in this manifest.
     * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
     * and `.m3u8` extension is generated for each element of the
     * `Manifest.mux_streams`.
     * </pre>
     *
     * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The muxStreams to add.
     * @return This builder for chaining.
     */
    public Builder addAllMuxStreams(java.lang.Iterable<java.lang.String> values) {
      ensureMuxStreamsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, muxStreams_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of user given `MuxStream.key`s that should appear in this manifest.
     * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
     * and `.m3u8` extension is generated for each element of the
     * `Manifest.mux_streams`.
     * </pre>
     *
     * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMuxStreams() {
      muxStreams_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of user given `MuxStream.key`s that should appear in this manifest.
     * When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key`
     * and `.m3u8` extension is generated for each element of the
     * `Manifest.mux_streams`.
     * </pre>
     *
     * <code>repeated string mux_streams = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the muxStreams to add.
     * @return This builder for chaining.
     */
    public Builder addMuxStreamsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMuxStreamsIsMutable();
      muxStreams_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.Manifest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.Manifest)
  private static final com.google.cloud.video.transcoder.v1.Manifest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.Manifest();
  }

  public static com.google.cloud.video.transcoder.v1.Manifest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Manifest> PARSER =
      new com.google.protobuf.AbstractParser<Manifest>() {
        @java.lang.Override
        public Manifest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Manifest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Manifest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Manifest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
