/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/video/transcoder/v1/services.proto

package com.google.cloud.video.transcoder.v1;

/**
 *
 *
 * <pre>
 * Response message for `TranscoderService.ListJobTemplates`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.video.transcoder.v1.ListJobTemplatesResponse}
 */
public final class ListJobTemplatesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.ListJobTemplatesResponse)
    ListJobTemplatesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListJobTemplatesResponse.newBuilder() to construct.
  private ListJobTemplatesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListJobTemplatesResponse() {
    jobTemplates_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
    unreachable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListJobTemplatesResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.video.transcoder.v1.ServicesProto
        .internal_static_google_cloud_video_transcoder_v1_ListJobTemplatesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.video.transcoder.v1.ServicesProto
        .internal_static_google_cloud_video_transcoder_v1_ListJobTemplatesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse.class,
            com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse.Builder.class);
  }

  public static final int JOB_TEMPLATES_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.video.transcoder.v1.JobTemplate> jobTemplates_;
  /**
   *
   *
   * <pre>
   * List of job templates in the specified region.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.video.transcoder.v1.JobTemplate> getJobTemplatesList() {
    return jobTemplates_;
  }
  /**
   *
   *
   * <pre>
   * List of job templates in the specified region.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.video.transcoder.v1.JobTemplateOrBuilder>
      getJobTemplatesOrBuilderList() {
    return jobTemplates_;
  }
  /**
   *
   *
   * <pre>
   * List of job templates in the specified region.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
   */
  @java.lang.Override
  public int getJobTemplatesCount() {
    return jobTemplates_.size();
  }
  /**
   *
   *
   * <pre>
   * List of job templates in the specified region.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.JobTemplate getJobTemplates(int index) {
    return jobTemplates_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of job templates in the specified region.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.JobTemplateOrBuilder getJobTemplatesOrBuilder(
      int index) {
    return jobTemplates_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;
  private volatile java.lang.Object nextPageToken_;
  /**
   *
   *
   * <pre>
   * The pagination token.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The pagination token.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNREACHABLE_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList unreachable_;
  /**
   *
   *
   * <pre>
   * List of regions that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @return A list containing the unreachable.
   */
  public com.google.protobuf.ProtocolStringList getUnreachableList() {
    return unreachable_;
  }
  /**
   *
   *
   * <pre>
   * List of regions that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @return The count of unreachable.
   */
  public int getUnreachableCount() {
    return unreachable_.size();
  }
  /**
   *
   *
   * <pre>
   * List of regions that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The unreachable at the given index.
   */
  public java.lang.String getUnreachable(int index) {
    return unreachable_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of regions that could not be reached.
   * </pre>
   *
   * <code>repeated string unreachable = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the unreachable at the given index.
   */
  public com.google.protobuf.ByteString getUnreachableBytes(int index) {
    return unreachable_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < jobTemplates_.size(); i++) {
      output.writeMessage(1, jobTemplates_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    for (int i = 0; i < unreachable_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, unreachable_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < jobTemplates_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, jobTemplates_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < unreachable_.size(); i++) {
        dataSize += computeStringSizeNoTag(unreachable_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getUnreachableList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse other =
        (com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse) obj;

    if (!getJobTemplatesList().equals(other.getJobTemplatesList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnreachableList().equals(other.getUnreachableList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getJobTemplatesCount() > 0) {
      hash = (37 * hash) + JOB_TEMPLATES_FIELD_NUMBER;
      hash = (53 * hash) + getJobTemplatesList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (getUnreachableCount() > 0) {
      hash = (37 * hash) + UNREACHABLE_FIELD_NUMBER;
      hash = (53 * hash) + getUnreachableList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for `TranscoderService.ListJobTemplates`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.ListJobTemplatesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.ListJobTemplatesResponse)
      com.google.cloud.video.transcoder.v1.ListJobTemplatesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ServicesProto
          .internal_static_google_cloud_video_transcoder_v1_ListJobTemplatesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ServicesProto
          .internal_static_google_cloud_video_transcoder_v1_ListJobTemplatesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse.class,
              com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse.Builder.class);
    }

    // Construct using com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (jobTemplatesBuilder_ == null) {
        jobTemplates_ = java.util.Collections.emptyList();
      } else {
        jobTemplates_ = null;
        jobTemplatesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";

      unreachable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.video.transcoder.v1.ServicesProto
          .internal_static_google_cloud_video_transcoder_v1_ListJobTemplatesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse
        getDefaultInstanceForType() {
      return com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse build() {
      com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse buildPartial() {
      com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse result =
          new com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse(this);
      int from_bitField0_ = bitField0_;
      if (jobTemplatesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          jobTemplates_ = java.util.Collections.unmodifiableList(jobTemplates_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.jobTemplates_ = jobTemplates_;
      } else {
        result.jobTemplates_ = jobTemplatesBuilder_.build();
      }
      result.nextPageToken_ = nextPageToken_;
      if (((bitField0_ & 0x00000002) != 0)) {
        unreachable_ = unreachable_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.unreachable_ = unreachable_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse) {
        return mergeFrom((com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse other) {
      if (other
          == com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse.getDefaultInstance())
        return this;
      if (jobTemplatesBuilder_ == null) {
        if (!other.jobTemplates_.isEmpty()) {
          if (jobTemplates_.isEmpty()) {
            jobTemplates_ = other.jobTemplates_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureJobTemplatesIsMutable();
            jobTemplates_.addAll(other.jobTemplates_);
          }
          onChanged();
        }
      } else {
        if (!other.jobTemplates_.isEmpty()) {
          if (jobTemplatesBuilder_.isEmpty()) {
            jobTemplatesBuilder_.dispose();
            jobTemplatesBuilder_ = null;
            jobTemplates_ = other.jobTemplates_;
            bitField0_ = (bitField0_ & ~0x00000001);
            jobTemplatesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getJobTemplatesFieldBuilder()
                    : null;
          } else {
            jobTemplatesBuilder_.addAllMessages(other.jobTemplates_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        onChanged();
      }
      if (!other.unreachable_.isEmpty()) {
        if (unreachable_.isEmpty()) {
          unreachable_ = other.unreachable_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureUnreachableIsMutable();
          unreachable_.addAll(other.unreachable_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.video.transcoder.v1.JobTemplate m =
                    input.readMessage(
                        com.google.cloud.video.transcoder.v1.JobTemplate.parser(),
                        extensionRegistry);
                if (jobTemplatesBuilder_ == null) {
                  ensureJobTemplatesIsMutable();
                  jobTemplates_.add(m);
                } else {
                  jobTemplatesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureUnreachableIsMutable();
                unreachable_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.video.transcoder.v1.JobTemplate> jobTemplates_ =
        java.util.Collections.emptyList();

    private void ensureJobTemplatesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        jobTemplates_ =
            new java.util.ArrayList<com.google.cloud.video.transcoder.v1.JobTemplate>(
                jobTemplates_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.JobTemplate,
            com.google.cloud.video.transcoder.v1.JobTemplate.Builder,
            com.google.cloud.video.transcoder.v1.JobTemplateOrBuilder>
        jobTemplatesBuilder_;

    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.JobTemplate> getJobTemplatesList() {
      if (jobTemplatesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(jobTemplates_);
      } else {
        return jobTemplatesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public int getJobTemplatesCount() {
      if (jobTemplatesBuilder_ == null) {
        return jobTemplates_.size();
      } else {
        return jobTemplatesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.JobTemplate getJobTemplates(int index) {
      if (jobTemplatesBuilder_ == null) {
        return jobTemplates_.get(index);
      } else {
        return jobTemplatesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public Builder setJobTemplates(
        int index, com.google.cloud.video.transcoder.v1.JobTemplate value) {
      if (jobTemplatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJobTemplatesIsMutable();
        jobTemplates_.set(index, value);
        onChanged();
      } else {
        jobTemplatesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public Builder setJobTemplates(
        int index, com.google.cloud.video.transcoder.v1.JobTemplate.Builder builderForValue) {
      if (jobTemplatesBuilder_ == null) {
        ensureJobTemplatesIsMutable();
        jobTemplates_.set(index, builderForValue.build());
        onChanged();
      } else {
        jobTemplatesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public Builder addJobTemplates(com.google.cloud.video.transcoder.v1.JobTemplate value) {
      if (jobTemplatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJobTemplatesIsMutable();
        jobTemplates_.add(value);
        onChanged();
      } else {
        jobTemplatesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public Builder addJobTemplates(
        int index, com.google.cloud.video.transcoder.v1.JobTemplate value) {
      if (jobTemplatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJobTemplatesIsMutable();
        jobTemplates_.add(index, value);
        onChanged();
      } else {
        jobTemplatesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public Builder addJobTemplates(
        com.google.cloud.video.transcoder.v1.JobTemplate.Builder builderForValue) {
      if (jobTemplatesBuilder_ == null) {
        ensureJobTemplatesIsMutable();
        jobTemplates_.add(builderForValue.build());
        onChanged();
      } else {
        jobTemplatesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public Builder addJobTemplates(
        int index, com.google.cloud.video.transcoder.v1.JobTemplate.Builder builderForValue) {
      if (jobTemplatesBuilder_ == null) {
        ensureJobTemplatesIsMutable();
        jobTemplates_.add(index, builderForValue.build());
        onChanged();
      } else {
        jobTemplatesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public Builder addAllJobTemplates(
        java.lang.Iterable<? extends com.google.cloud.video.transcoder.v1.JobTemplate> values) {
      if (jobTemplatesBuilder_ == null) {
        ensureJobTemplatesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, jobTemplates_);
        onChanged();
      } else {
        jobTemplatesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public Builder clearJobTemplates() {
      if (jobTemplatesBuilder_ == null) {
        jobTemplates_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        jobTemplatesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public Builder removeJobTemplates(int index) {
      if (jobTemplatesBuilder_ == null) {
        ensureJobTemplatesIsMutable();
        jobTemplates_.remove(index);
        onChanged();
      } else {
        jobTemplatesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.JobTemplate.Builder getJobTemplatesBuilder(
        int index) {
      return getJobTemplatesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.JobTemplateOrBuilder getJobTemplatesOrBuilder(
        int index) {
      if (jobTemplatesBuilder_ == null) {
        return jobTemplates_.get(index);
      } else {
        return jobTemplatesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.video.transcoder.v1.JobTemplateOrBuilder>
        getJobTemplatesOrBuilderList() {
      if (jobTemplatesBuilder_ != null) {
        return jobTemplatesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(jobTemplates_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.JobTemplate.Builder addJobTemplatesBuilder() {
      return getJobTemplatesFieldBuilder()
          .addBuilder(com.google.cloud.video.transcoder.v1.JobTemplate.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.JobTemplate.Builder addJobTemplatesBuilder(
        int index) {
      return getJobTemplatesFieldBuilder()
          .addBuilder(index, com.google.cloud.video.transcoder.v1.JobTemplate.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of job templates in the specified region.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.JobTemplate job_templates = 1;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.JobTemplate.Builder>
        getJobTemplatesBuilderList() {
      return getJobTemplatesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.JobTemplate,
            com.google.cloud.video.transcoder.v1.JobTemplate.Builder,
            com.google.cloud.video.transcoder.v1.JobTemplateOrBuilder>
        getJobTemplatesFieldBuilder() {
      if (jobTemplatesBuilder_ == null) {
        jobTemplatesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.JobTemplate,
                com.google.cloud.video.transcoder.v1.JobTemplate.Builder,
                com.google.cloud.video.transcoder.v1.JobTemplateOrBuilder>(
                jobTemplates_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        jobTemplates_ = null;
      }
      return jobTemplatesBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * The pagination token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The pagination token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The pagination token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      nextPageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The pagination token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {

      nextPageToken_ = getDefaultInstance().getNextPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The pagination token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      nextPageToken_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList unreachable_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureUnreachableIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        unreachable_ = new com.google.protobuf.LazyStringArrayList(unreachable_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * List of regions that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return A list containing the unreachable.
     */
    public com.google.protobuf.ProtocolStringList getUnreachableList() {
      return unreachable_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * List of regions that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return The count of unreachable.
     */
    public int getUnreachableCount() {
      return unreachable_.size();
    }
    /**
     *
     *
     * <pre>
     * List of regions that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The unreachable at the given index.
     */
    public java.lang.String getUnreachable(int index) {
      return unreachable_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of regions that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the unreachable at the given index.
     */
    public com.google.protobuf.ByteString getUnreachableBytes(int index) {
      return unreachable_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of regions that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The unreachable to set.
     * @return This builder for chaining.
     */
    public Builder setUnreachable(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of regions that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param value The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of regions that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param values The unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addAllUnreachable(java.lang.Iterable<java.lang.String> values) {
      ensureUnreachableIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, unreachable_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of regions that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnreachable() {
      unreachable_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of regions that could not be reached.
     * </pre>
     *
     * <code>repeated string unreachable = 3;</code>
     *
     * @param value The bytes of the unreachable to add.
     * @return This builder for chaining.
     */
    public Builder addUnreachableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureUnreachableIsMutable();
      unreachable_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.ListJobTemplatesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.ListJobTemplatesResponse)
  private static final com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse();
  }

  public static com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListJobTemplatesResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListJobTemplatesResponse>() {
        @java.lang.Override
        public ListJobTemplatesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListJobTemplatesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListJobTemplatesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
