/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/video/transcoder/v1/resources.proto

package com.google.cloud.video.transcoder.v1;

/**
 *
 *
 * <pre>
 * Job configuration
 * </pre>
 *
 * Protobuf type {@code google.cloud.video.transcoder.v1.JobConfig}
 */
public final class JobConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.JobConfig)
    JobConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use JobConfig.newBuilder() to construct.
  private JobConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private JobConfig() {
    inputs_ = java.util.Collections.emptyList();
    editList_ = java.util.Collections.emptyList();
    elementaryStreams_ = java.util.Collections.emptyList();
    muxStreams_ = java.util.Collections.emptyList();
    manifests_ = java.util.Collections.emptyList();
    adBreaks_ = java.util.Collections.emptyList();
    spriteSheets_ = java.util.Collections.emptyList();
    overlays_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new JobConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_JobConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_JobConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.video.transcoder.v1.JobConfig.class,
            com.google.cloud.video.transcoder.v1.JobConfig.Builder.class);
  }

  public static final int INPUTS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.video.transcoder.v1.Input> inputs_;
  /**
   *
   *
   * <pre>
   * List of input assets stored in Cloud Storage.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.video.transcoder.v1.Input> getInputsList() {
    return inputs_;
  }
  /**
   *
   *
   * <pre>
   * List of input assets stored in Cloud Storage.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.video.transcoder.v1.InputOrBuilder>
      getInputsOrBuilderList() {
    return inputs_;
  }
  /**
   *
   *
   * <pre>
   * List of input assets stored in Cloud Storage.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
   */
  @java.lang.Override
  public int getInputsCount() {
    return inputs_.size();
  }
  /**
   *
   *
   * <pre>
   * List of input assets stored in Cloud Storage.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Input getInputs(int index) {
    return inputs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of input assets stored in Cloud Storage.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.InputOrBuilder getInputsOrBuilder(int index) {
    return inputs_.get(index);
  }

  public static final int EDIT_LIST_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.video.transcoder.v1.EditAtom> editList_;
  /**
   *
   *
   * <pre>
   * List of `Edit atom`s. Defines the ultimate timeline of the resulting
   * file or manifest.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.video.transcoder.v1.EditAtom> getEditListList() {
    return editList_;
  }
  /**
   *
   *
   * <pre>
   * List of `Edit atom`s. Defines the ultimate timeline of the resulting
   * file or manifest.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.video.transcoder.v1.EditAtomOrBuilder>
      getEditListOrBuilderList() {
    return editList_;
  }
  /**
   *
   *
   * <pre>
   * List of `Edit atom`s. Defines the ultimate timeline of the resulting
   * file or manifest.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
   */
  @java.lang.Override
  public int getEditListCount() {
    return editList_.size();
  }
  /**
   *
   *
   * <pre>
   * List of `Edit atom`s. Defines the ultimate timeline of the resulting
   * file or manifest.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.EditAtom getEditList(int index) {
    return editList_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of `Edit atom`s. Defines the ultimate timeline of the resulting
   * file or manifest.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.EditAtomOrBuilder getEditListOrBuilder(int index) {
    return editList_.get(index);
  }

  public static final int ELEMENTARY_STREAMS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.video.transcoder.v1.ElementaryStream> elementaryStreams_;
  /**
   *
   *
   * <pre>
   * List of elementary streams.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.video.transcoder.v1.ElementaryStream>
      getElementaryStreamsList() {
    return elementaryStreams_;
  }
  /**
   *
   *
   * <pre>
   * List of elementary streams.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.video.transcoder.v1.ElementaryStreamOrBuilder>
      getElementaryStreamsOrBuilderList() {
    return elementaryStreams_;
  }
  /**
   *
   *
   * <pre>
   * List of elementary streams.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
   * </code>
   */
  @java.lang.Override
  public int getElementaryStreamsCount() {
    return elementaryStreams_.size();
  }
  /**
   *
   *
   * <pre>
   * List of elementary streams.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.ElementaryStream getElementaryStreams(int index) {
    return elementaryStreams_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of elementary streams.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.ElementaryStreamOrBuilder
      getElementaryStreamsOrBuilder(int index) {
    return elementaryStreams_.get(index);
  }

  public static final int MUX_STREAMS_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.video.transcoder.v1.MuxStream> muxStreams_;
  /**
   *
   *
   * <pre>
   * List of multiplexing settings for output streams.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.video.transcoder.v1.MuxStream> getMuxStreamsList() {
    return muxStreams_;
  }
  /**
   *
   *
   * <pre>
   * List of multiplexing settings for output streams.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.video.transcoder.v1.MuxStreamOrBuilder>
      getMuxStreamsOrBuilderList() {
    return muxStreams_;
  }
  /**
   *
   *
   * <pre>
   * List of multiplexing settings for output streams.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
   */
  @java.lang.Override
  public int getMuxStreamsCount() {
    return muxStreams_.size();
  }
  /**
   *
   *
   * <pre>
   * List of multiplexing settings for output streams.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.MuxStream getMuxStreams(int index) {
    return muxStreams_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of multiplexing settings for output streams.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.MuxStreamOrBuilder getMuxStreamsOrBuilder(int index) {
    return muxStreams_.get(index);
  }

  public static final int MANIFESTS_FIELD_NUMBER = 5;
  private java.util.List<com.google.cloud.video.transcoder.v1.Manifest> manifests_;
  /**
   *
   *
   * <pre>
   * List of output manifests.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.video.transcoder.v1.Manifest> getManifestsList() {
    return manifests_;
  }
  /**
   *
   *
   * <pre>
   * List of output manifests.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.video.transcoder.v1.ManifestOrBuilder>
      getManifestsOrBuilderList() {
    return manifests_;
  }
  /**
   *
   *
   * <pre>
   * List of output manifests.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
   */
  @java.lang.Override
  public int getManifestsCount() {
    return manifests_.size();
  }
  /**
   *
   *
   * <pre>
   * List of output manifests.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Manifest getManifests(int index) {
    return manifests_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of output manifests.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.ManifestOrBuilder getManifestsOrBuilder(int index) {
    return manifests_.get(index);
  }

  public static final int OUTPUT_FIELD_NUMBER = 6;
  private com.google.cloud.video.transcoder.v1.Output output_;
  /**
   *
   *
   * <pre>
   * Output configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.Output output = 6;</code>
   *
   * @return Whether the output field is set.
   */
  @java.lang.Override
  public boolean hasOutput() {
    return output_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.Output output = 6;</code>
   *
   * @return The output.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Output getOutput() {
    return output_ == null
        ? com.google.cloud.video.transcoder.v1.Output.getDefaultInstance()
        : output_;
  }
  /**
   *
   *
   * <pre>
   * Output configuration.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.Output output = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.OutputOrBuilder getOutputOrBuilder() {
    return getOutput();
  }

  public static final int AD_BREAKS_FIELD_NUMBER = 7;
  private java.util.List<com.google.cloud.video.transcoder.v1.AdBreak> adBreaks_;
  /**
   *
   *
   * <pre>
   * List of ad breaks. Specifies where to insert ad break tags in the output
   * manifests.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.video.transcoder.v1.AdBreak> getAdBreaksList() {
    return adBreaks_;
  }
  /**
   *
   *
   * <pre>
   * List of ad breaks. Specifies where to insert ad break tags in the output
   * manifests.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.video.transcoder.v1.AdBreakOrBuilder>
      getAdBreaksOrBuilderList() {
    return adBreaks_;
  }
  /**
   *
   *
   * <pre>
   * List of ad breaks. Specifies where to insert ad break tags in the output
   * manifests.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
   */
  @java.lang.Override
  public int getAdBreaksCount() {
    return adBreaks_.size();
  }
  /**
   *
   *
   * <pre>
   * List of ad breaks. Specifies where to insert ad break tags in the output
   * manifests.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.AdBreak getAdBreaks(int index) {
    return adBreaks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of ad breaks. Specifies where to insert ad break tags in the output
   * manifests.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.AdBreakOrBuilder getAdBreaksOrBuilder(int index) {
    return adBreaks_.get(index);
  }

  public static final int PUBSUB_DESTINATION_FIELD_NUMBER = 8;
  private com.google.cloud.video.transcoder.v1.PubsubDestination pubsubDestination_;
  /**
   *
   *
   * <pre>
   * Destination on Pub/Sub.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PubsubDestination pubsub_destination = 8;</code>
   *
   * @return Whether the pubsubDestination field is set.
   */
  @java.lang.Override
  public boolean hasPubsubDestination() {
    return pubsubDestination_ != null;
  }
  /**
   *
   *
   * <pre>
   * Destination on Pub/Sub.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PubsubDestination pubsub_destination = 8;</code>
   *
   * @return The pubsubDestination.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PubsubDestination getPubsubDestination() {
    return pubsubDestination_ == null
        ? com.google.cloud.video.transcoder.v1.PubsubDestination.getDefaultInstance()
        : pubsubDestination_;
  }
  /**
   *
   *
   * <pre>
   * Destination on Pub/Sub.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.PubsubDestination pubsub_destination = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.PubsubDestinationOrBuilder
      getPubsubDestinationOrBuilder() {
    return getPubsubDestination();
  }

  public static final int SPRITE_SHEETS_FIELD_NUMBER = 9;
  private java.util.List<com.google.cloud.video.transcoder.v1.SpriteSheet> spriteSheets_;
  /**
   *
   *
   * <pre>
   * List of output sprite sheets.
   * Spritesheets require at least one VideoStream in the Jobconfig.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.video.transcoder.v1.SpriteSheet> getSpriteSheetsList() {
    return spriteSheets_;
  }
  /**
   *
   *
   * <pre>
   * List of output sprite sheets.
   * Spritesheets require at least one VideoStream in the Jobconfig.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.video.transcoder.v1.SpriteSheetOrBuilder>
      getSpriteSheetsOrBuilderList() {
    return spriteSheets_;
  }
  /**
   *
   *
   * <pre>
   * List of output sprite sheets.
   * Spritesheets require at least one VideoStream in the Jobconfig.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
   */
  @java.lang.Override
  public int getSpriteSheetsCount() {
    return spriteSheets_.size();
  }
  /**
   *
   *
   * <pre>
   * List of output sprite sheets.
   * Spritesheets require at least one VideoStream in the Jobconfig.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.SpriteSheet getSpriteSheets(int index) {
    return spriteSheets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of output sprite sheets.
   * Spritesheets require at least one VideoStream in the Jobconfig.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.SpriteSheetOrBuilder getSpriteSheetsOrBuilder(
      int index) {
    return spriteSheets_.get(index);
  }

  public static final int OVERLAYS_FIELD_NUMBER = 10;
  private java.util.List<com.google.cloud.video.transcoder.v1.Overlay> overlays_;
  /**
   *
   *
   * <pre>
   * List of overlays on the output video, in descending Z-order.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.video.transcoder.v1.Overlay> getOverlaysList() {
    return overlays_;
  }
  /**
   *
   *
   * <pre>
   * List of overlays on the output video, in descending Z-order.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.video.transcoder.v1.OverlayOrBuilder>
      getOverlaysOrBuilderList() {
    return overlays_;
  }
  /**
   *
   *
   * <pre>
   * List of overlays on the output video, in descending Z-order.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
   */
  @java.lang.Override
  public int getOverlaysCount() {
    return overlays_.size();
  }
  /**
   *
   *
   * <pre>
   * List of overlays on the output video, in descending Z-order.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Overlay getOverlays(int index) {
    return overlays_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of overlays on the output video, in descending Z-order.
   * </pre>
   *
   * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.OverlayOrBuilder getOverlaysOrBuilder(int index) {
    return overlays_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < inputs_.size(); i++) {
      output.writeMessage(1, inputs_.get(i));
    }
    for (int i = 0; i < editList_.size(); i++) {
      output.writeMessage(2, editList_.get(i));
    }
    for (int i = 0; i < elementaryStreams_.size(); i++) {
      output.writeMessage(3, elementaryStreams_.get(i));
    }
    for (int i = 0; i < muxStreams_.size(); i++) {
      output.writeMessage(4, muxStreams_.get(i));
    }
    for (int i = 0; i < manifests_.size(); i++) {
      output.writeMessage(5, manifests_.get(i));
    }
    if (output_ != null) {
      output.writeMessage(6, getOutput());
    }
    for (int i = 0; i < adBreaks_.size(); i++) {
      output.writeMessage(7, adBreaks_.get(i));
    }
    if (pubsubDestination_ != null) {
      output.writeMessage(8, getPubsubDestination());
    }
    for (int i = 0; i < spriteSheets_.size(); i++) {
      output.writeMessage(9, spriteSheets_.get(i));
    }
    for (int i = 0; i < overlays_.size(); i++) {
      output.writeMessage(10, overlays_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < inputs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, inputs_.get(i));
    }
    for (int i = 0; i < editList_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, editList_.get(i));
    }
    for (int i = 0; i < elementaryStreams_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, elementaryStreams_.get(i));
    }
    for (int i = 0; i < muxStreams_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, muxStreams_.get(i));
    }
    for (int i = 0; i < manifests_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, manifests_.get(i));
    }
    if (output_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOutput());
    }
    for (int i = 0; i < adBreaks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, adBreaks_.get(i));
    }
    if (pubsubDestination_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getPubsubDestination());
    }
    for (int i = 0; i < spriteSheets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, spriteSheets_.get(i));
    }
    for (int i = 0; i < overlays_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, overlays_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.video.transcoder.v1.JobConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.video.transcoder.v1.JobConfig other =
        (com.google.cloud.video.transcoder.v1.JobConfig) obj;

    if (!getInputsList().equals(other.getInputsList())) return false;
    if (!getEditListList().equals(other.getEditListList())) return false;
    if (!getElementaryStreamsList().equals(other.getElementaryStreamsList())) return false;
    if (!getMuxStreamsList().equals(other.getMuxStreamsList())) return false;
    if (!getManifestsList().equals(other.getManifestsList())) return false;
    if (hasOutput() != other.hasOutput()) return false;
    if (hasOutput()) {
      if (!getOutput().equals(other.getOutput())) return false;
    }
    if (!getAdBreaksList().equals(other.getAdBreaksList())) return false;
    if (hasPubsubDestination() != other.hasPubsubDestination()) return false;
    if (hasPubsubDestination()) {
      if (!getPubsubDestination().equals(other.getPubsubDestination())) return false;
    }
    if (!getSpriteSheetsList().equals(other.getSpriteSheetsList())) return false;
    if (!getOverlaysList().equals(other.getOverlaysList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getInputsCount() > 0) {
      hash = (37 * hash) + INPUTS_FIELD_NUMBER;
      hash = (53 * hash) + getInputsList().hashCode();
    }
    if (getEditListCount() > 0) {
      hash = (37 * hash) + EDIT_LIST_FIELD_NUMBER;
      hash = (53 * hash) + getEditListList().hashCode();
    }
    if (getElementaryStreamsCount() > 0) {
      hash = (37 * hash) + ELEMENTARY_STREAMS_FIELD_NUMBER;
      hash = (53 * hash) + getElementaryStreamsList().hashCode();
    }
    if (getMuxStreamsCount() > 0) {
      hash = (37 * hash) + MUX_STREAMS_FIELD_NUMBER;
      hash = (53 * hash) + getMuxStreamsList().hashCode();
    }
    if (getManifestsCount() > 0) {
      hash = (37 * hash) + MANIFESTS_FIELD_NUMBER;
      hash = (53 * hash) + getManifestsList().hashCode();
    }
    if (hasOutput()) {
      hash = (37 * hash) + OUTPUT_FIELD_NUMBER;
      hash = (53 * hash) + getOutput().hashCode();
    }
    if (getAdBreaksCount() > 0) {
      hash = (37 * hash) + AD_BREAKS_FIELD_NUMBER;
      hash = (53 * hash) + getAdBreaksList().hashCode();
    }
    if (hasPubsubDestination()) {
      hash = (37 * hash) + PUBSUB_DESTINATION_FIELD_NUMBER;
      hash = (53 * hash) + getPubsubDestination().hashCode();
    }
    if (getSpriteSheetsCount() > 0) {
      hash = (37 * hash) + SPRITE_SHEETS_FIELD_NUMBER;
      hash = (53 * hash) + getSpriteSheetsList().hashCode();
    }
    if (getOverlaysCount() > 0) {
      hash = (37 * hash) + OVERLAYS_FIELD_NUMBER;
      hash = (53 * hash) + getOverlaysList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.video.transcoder.v1.JobConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Job configuration
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.JobConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.JobConfig)
      com.google.cloud.video.transcoder.v1.JobConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_JobConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_JobConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.JobConfig.class,
              com.google.cloud.video.transcoder.v1.JobConfig.Builder.class);
    }

    // Construct using com.google.cloud.video.transcoder.v1.JobConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (inputsBuilder_ == null) {
        inputs_ = java.util.Collections.emptyList();
      } else {
        inputs_ = null;
        inputsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (editListBuilder_ == null) {
        editList_ = java.util.Collections.emptyList();
      } else {
        editList_ = null;
        editListBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (elementaryStreamsBuilder_ == null) {
        elementaryStreams_ = java.util.Collections.emptyList();
      } else {
        elementaryStreams_ = null;
        elementaryStreamsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (muxStreamsBuilder_ == null) {
        muxStreams_ = java.util.Collections.emptyList();
      } else {
        muxStreams_ = null;
        muxStreamsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (manifestsBuilder_ == null) {
        manifests_ = java.util.Collections.emptyList();
      } else {
        manifests_ = null;
        manifestsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (outputBuilder_ == null) {
        output_ = null;
      } else {
        output_ = null;
        outputBuilder_ = null;
      }
      if (adBreaksBuilder_ == null) {
        adBreaks_ = java.util.Collections.emptyList();
      } else {
        adBreaks_ = null;
        adBreaksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (pubsubDestinationBuilder_ == null) {
        pubsubDestination_ = null;
      } else {
        pubsubDestination_ = null;
        pubsubDestinationBuilder_ = null;
      }
      if (spriteSheetsBuilder_ == null) {
        spriteSheets_ = java.util.Collections.emptyList();
      } else {
        spriteSheets_ = null;
        spriteSheetsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (overlaysBuilder_ == null) {
        overlays_ = java.util.Collections.emptyList();
      } else {
        overlays_ = null;
        overlaysBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_JobConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.JobConfig getDefaultInstanceForType() {
      return com.google.cloud.video.transcoder.v1.JobConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.JobConfig build() {
      com.google.cloud.video.transcoder.v1.JobConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.JobConfig buildPartial() {
      com.google.cloud.video.transcoder.v1.JobConfig result =
          new com.google.cloud.video.transcoder.v1.JobConfig(this);
      int from_bitField0_ = bitField0_;
      if (inputsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          inputs_ = java.util.Collections.unmodifiableList(inputs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.inputs_ = inputs_;
      } else {
        result.inputs_ = inputsBuilder_.build();
      }
      if (editListBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          editList_ = java.util.Collections.unmodifiableList(editList_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.editList_ = editList_;
      } else {
        result.editList_ = editListBuilder_.build();
      }
      if (elementaryStreamsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          elementaryStreams_ = java.util.Collections.unmodifiableList(elementaryStreams_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.elementaryStreams_ = elementaryStreams_;
      } else {
        result.elementaryStreams_ = elementaryStreamsBuilder_.build();
      }
      if (muxStreamsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          muxStreams_ = java.util.Collections.unmodifiableList(muxStreams_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.muxStreams_ = muxStreams_;
      } else {
        result.muxStreams_ = muxStreamsBuilder_.build();
      }
      if (manifestsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          manifests_ = java.util.Collections.unmodifiableList(manifests_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.manifests_ = manifests_;
      } else {
        result.manifests_ = manifestsBuilder_.build();
      }
      if (outputBuilder_ == null) {
        result.output_ = output_;
      } else {
        result.output_ = outputBuilder_.build();
      }
      if (adBreaksBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          adBreaks_ = java.util.Collections.unmodifiableList(adBreaks_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.adBreaks_ = adBreaks_;
      } else {
        result.adBreaks_ = adBreaksBuilder_.build();
      }
      if (pubsubDestinationBuilder_ == null) {
        result.pubsubDestination_ = pubsubDestination_;
      } else {
        result.pubsubDestination_ = pubsubDestinationBuilder_.build();
      }
      if (spriteSheetsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          spriteSheets_ = java.util.Collections.unmodifiableList(spriteSheets_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.spriteSheets_ = spriteSheets_;
      } else {
        result.spriteSheets_ = spriteSheetsBuilder_.build();
      }
      if (overlaysBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          overlays_ = java.util.Collections.unmodifiableList(overlays_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.overlays_ = overlays_;
      } else {
        result.overlays_ = overlaysBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.video.transcoder.v1.JobConfig) {
        return mergeFrom((com.google.cloud.video.transcoder.v1.JobConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.video.transcoder.v1.JobConfig other) {
      if (other == com.google.cloud.video.transcoder.v1.JobConfig.getDefaultInstance()) return this;
      if (inputsBuilder_ == null) {
        if (!other.inputs_.isEmpty()) {
          if (inputs_.isEmpty()) {
            inputs_ = other.inputs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureInputsIsMutable();
            inputs_.addAll(other.inputs_);
          }
          onChanged();
        }
      } else {
        if (!other.inputs_.isEmpty()) {
          if (inputsBuilder_.isEmpty()) {
            inputsBuilder_.dispose();
            inputsBuilder_ = null;
            inputs_ = other.inputs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            inputsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInputsFieldBuilder()
                    : null;
          } else {
            inputsBuilder_.addAllMessages(other.inputs_);
          }
        }
      }
      if (editListBuilder_ == null) {
        if (!other.editList_.isEmpty()) {
          if (editList_.isEmpty()) {
            editList_ = other.editList_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureEditListIsMutable();
            editList_.addAll(other.editList_);
          }
          onChanged();
        }
      } else {
        if (!other.editList_.isEmpty()) {
          if (editListBuilder_.isEmpty()) {
            editListBuilder_.dispose();
            editListBuilder_ = null;
            editList_ = other.editList_;
            bitField0_ = (bitField0_ & ~0x00000002);
            editListBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEditListFieldBuilder()
                    : null;
          } else {
            editListBuilder_.addAllMessages(other.editList_);
          }
        }
      }
      if (elementaryStreamsBuilder_ == null) {
        if (!other.elementaryStreams_.isEmpty()) {
          if (elementaryStreams_.isEmpty()) {
            elementaryStreams_ = other.elementaryStreams_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureElementaryStreamsIsMutable();
            elementaryStreams_.addAll(other.elementaryStreams_);
          }
          onChanged();
        }
      } else {
        if (!other.elementaryStreams_.isEmpty()) {
          if (elementaryStreamsBuilder_.isEmpty()) {
            elementaryStreamsBuilder_.dispose();
            elementaryStreamsBuilder_ = null;
            elementaryStreams_ = other.elementaryStreams_;
            bitField0_ = (bitField0_ & ~0x00000004);
            elementaryStreamsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getElementaryStreamsFieldBuilder()
                    : null;
          } else {
            elementaryStreamsBuilder_.addAllMessages(other.elementaryStreams_);
          }
        }
      }
      if (muxStreamsBuilder_ == null) {
        if (!other.muxStreams_.isEmpty()) {
          if (muxStreams_.isEmpty()) {
            muxStreams_ = other.muxStreams_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureMuxStreamsIsMutable();
            muxStreams_.addAll(other.muxStreams_);
          }
          onChanged();
        }
      } else {
        if (!other.muxStreams_.isEmpty()) {
          if (muxStreamsBuilder_.isEmpty()) {
            muxStreamsBuilder_.dispose();
            muxStreamsBuilder_ = null;
            muxStreams_ = other.muxStreams_;
            bitField0_ = (bitField0_ & ~0x00000008);
            muxStreamsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMuxStreamsFieldBuilder()
                    : null;
          } else {
            muxStreamsBuilder_.addAllMessages(other.muxStreams_);
          }
        }
      }
      if (manifestsBuilder_ == null) {
        if (!other.manifests_.isEmpty()) {
          if (manifests_.isEmpty()) {
            manifests_ = other.manifests_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureManifestsIsMutable();
            manifests_.addAll(other.manifests_);
          }
          onChanged();
        }
      } else {
        if (!other.manifests_.isEmpty()) {
          if (manifestsBuilder_.isEmpty()) {
            manifestsBuilder_.dispose();
            manifestsBuilder_ = null;
            manifests_ = other.manifests_;
            bitField0_ = (bitField0_ & ~0x00000010);
            manifestsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getManifestsFieldBuilder()
                    : null;
          } else {
            manifestsBuilder_.addAllMessages(other.manifests_);
          }
        }
      }
      if (other.hasOutput()) {
        mergeOutput(other.getOutput());
      }
      if (adBreaksBuilder_ == null) {
        if (!other.adBreaks_.isEmpty()) {
          if (adBreaks_.isEmpty()) {
            adBreaks_ = other.adBreaks_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureAdBreaksIsMutable();
            adBreaks_.addAll(other.adBreaks_);
          }
          onChanged();
        }
      } else {
        if (!other.adBreaks_.isEmpty()) {
          if (adBreaksBuilder_.isEmpty()) {
            adBreaksBuilder_.dispose();
            adBreaksBuilder_ = null;
            adBreaks_ = other.adBreaks_;
            bitField0_ = (bitField0_ & ~0x00000020);
            adBreaksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAdBreaksFieldBuilder()
                    : null;
          } else {
            adBreaksBuilder_.addAllMessages(other.adBreaks_);
          }
        }
      }
      if (other.hasPubsubDestination()) {
        mergePubsubDestination(other.getPubsubDestination());
      }
      if (spriteSheetsBuilder_ == null) {
        if (!other.spriteSheets_.isEmpty()) {
          if (spriteSheets_.isEmpty()) {
            spriteSheets_ = other.spriteSheets_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureSpriteSheetsIsMutable();
            spriteSheets_.addAll(other.spriteSheets_);
          }
          onChanged();
        }
      } else {
        if (!other.spriteSheets_.isEmpty()) {
          if (spriteSheetsBuilder_.isEmpty()) {
            spriteSheetsBuilder_.dispose();
            spriteSheetsBuilder_ = null;
            spriteSheets_ = other.spriteSheets_;
            bitField0_ = (bitField0_ & ~0x00000040);
            spriteSheetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSpriteSheetsFieldBuilder()
                    : null;
          } else {
            spriteSheetsBuilder_.addAllMessages(other.spriteSheets_);
          }
        }
      }
      if (overlaysBuilder_ == null) {
        if (!other.overlays_.isEmpty()) {
          if (overlays_.isEmpty()) {
            overlays_ = other.overlays_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureOverlaysIsMutable();
            overlays_.addAll(other.overlays_);
          }
          onChanged();
        }
      } else {
        if (!other.overlays_.isEmpty()) {
          if (overlaysBuilder_.isEmpty()) {
            overlaysBuilder_.dispose();
            overlaysBuilder_ = null;
            overlays_ = other.overlays_;
            bitField0_ = (bitField0_ & ~0x00000080);
            overlaysBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOverlaysFieldBuilder()
                    : null;
          } else {
            overlaysBuilder_.addAllMessages(other.overlays_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.video.transcoder.v1.Input m =
                    input.readMessage(
                        com.google.cloud.video.transcoder.v1.Input.parser(), extensionRegistry);
                if (inputsBuilder_ == null) {
                  ensureInputsIsMutable();
                  inputs_.add(m);
                } else {
                  inputsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.video.transcoder.v1.EditAtom m =
                    input.readMessage(
                        com.google.cloud.video.transcoder.v1.EditAtom.parser(), extensionRegistry);
                if (editListBuilder_ == null) {
                  ensureEditListIsMutable();
                  editList_.add(m);
                } else {
                  editListBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.video.transcoder.v1.ElementaryStream m =
                    input.readMessage(
                        com.google.cloud.video.transcoder.v1.ElementaryStream.parser(),
                        extensionRegistry);
                if (elementaryStreamsBuilder_ == null) {
                  ensureElementaryStreamsIsMutable();
                  elementaryStreams_.add(m);
                } else {
                  elementaryStreamsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.video.transcoder.v1.MuxStream m =
                    input.readMessage(
                        com.google.cloud.video.transcoder.v1.MuxStream.parser(), extensionRegistry);
                if (muxStreamsBuilder_ == null) {
                  ensureMuxStreamsIsMutable();
                  muxStreams_.add(m);
                } else {
                  muxStreamsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.video.transcoder.v1.Manifest m =
                    input.readMessage(
                        com.google.cloud.video.transcoder.v1.Manifest.parser(), extensionRegistry);
                if (manifestsBuilder_ == null) {
                  ensureManifestsIsMutable();
                  manifests_.add(m);
                } else {
                  manifestsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getOutputFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 58:
              {
                com.google.cloud.video.transcoder.v1.AdBreak m =
                    input.readMessage(
                        com.google.cloud.video.transcoder.v1.AdBreak.parser(), extensionRegistry);
                if (adBreaksBuilder_ == null) {
                  ensureAdBreaksIsMutable();
                  adBreaks_.add(m);
                } else {
                  adBreaksBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getPubsubDestinationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            case 74:
              {
                com.google.cloud.video.transcoder.v1.SpriteSheet m =
                    input.readMessage(
                        com.google.cloud.video.transcoder.v1.SpriteSheet.parser(),
                        extensionRegistry);
                if (spriteSheetsBuilder_ == null) {
                  ensureSpriteSheetsIsMutable();
                  spriteSheets_.add(m);
                } else {
                  spriteSheetsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.video.transcoder.v1.Overlay m =
                    input.readMessage(
                        com.google.cloud.video.transcoder.v1.Overlay.parser(), extensionRegistry);
                if (overlaysBuilder_ == null) {
                  ensureOverlaysIsMutable();
                  overlays_.add(m);
                } else {
                  overlaysBuilder_.addMessage(m);
                }
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.video.transcoder.v1.Input> inputs_ =
        java.util.Collections.emptyList();

    private void ensureInputsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        inputs_ = new java.util.ArrayList<com.google.cloud.video.transcoder.v1.Input>(inputs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.Input,
            com.google.cloud.video.transcoder.v1.Input.Builder,
            com.google.cloud.video.transcoder.v1.InputOrBuilder>
        inputsBuilder_;

    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.Input> getInputsList() {
      if (inputsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(inputs_);
      } else {
        return inputsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public int getInputsCount() {
      if (inputsBuilder_ == null) {
        return inputs_.size();
      } else {
        return inputsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.Input getInputs(int index) {
      if (inputsBuilder_ == null) {
        return inputs_.get(index);
      } else {
        return inputsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public Builder setInputs(int index, com.google.cloud.video.transcoder.v1.Input value) {
      if (inputsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputsIsMutable();
        inputs_.set(index, value);
        onChanged();
      } else {
        inputsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public Builder setInputs(
        int index, com.google.cloud.video.transcoder.v1.Input.Builder builderForValue) {
      if (inputsBuilder_ == null) {
        ensureInputsIsMutable();
        inputs_.set(index, builderForValue.build());
        onChanged();
      } else {
        inputsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public Builder addInputs(com.google.cloud.video.transcoder.v1.Input value) {
      if (inputsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputsIsMutable();
        inputs_.add(value);
        onChanged();
      } else {
        inputsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public Builder addInputs(int index, com.google.cloud.video.transcoder.v1.Input value) {
      if (inputsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputsIsMutable();
        inputs_.add(index, value);
        onChanged();
      } else {
        inputsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public Builder addInputs(com.google.cloud.video.transcoder.v1.Input.Builder builderForValue) {
      if (inputsBuilder_ == null) {
        ensureInputsIsMutable();
        inputs_.add(builderForValue.build());
        onChanged();
      } else {
        inputsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public Builder addInputs(
        int index, com.google.cloud.video.transcoder.v1.Input.Builder builderForValue) {
      if (inputsBuilder_ == null) {
        ensureInputsIsMutable();
        inputs_.add(index, builderForValue.build());
        onChanged();
      } else {
        inputsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public Builder addAllInputs(
        java.lang.Iterable<? extends com.google.cloud.video.transcoder.v1.Input> values) {
      if (inputsBuilder_ == null) {
        ensureInputsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inputs_);
        onChanged();
      } else {
        inputsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public Builder clearInputs() {
      if (inputsBuilder_ == null) {
        inputs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        inputsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public Builder removeInputs(int index) {
      if (inputsBuilder_ == null) {
        ensureInputsIsMutable();
        inputs_.remove(index);
        onChanged();
      } else {
        inputsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.Input.Builder getInputsBuilder(int index) {
      return getInputsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.InputOrBuilder getInputsOrBuilder(int index) {
      if (inputsBuilder_ == null) {
        return inputs_.get(index);
      } else {
        return inputsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.video.transcoder.v1.InputOrBuilder>
        getInputsOrBuilderList() {
      if (inputsBuilder_ != null) {
        return inputsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(inputs_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.Input.Builder addInputsBuilder() {
      return getInputsFieldBuilder()
          .addBuilder(com.google.cloud.video.transcoder.v1.Input.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.Input.Builder addInputsBuilder(int index) {
      return getInputsFieldBuilder()
          .addBuilder(index, com.google.cloud.video.transcoder.v1.Input.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of input assets stored in Cloud Storage.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Input inputs = 1;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.Input.Builder>
        getInputsBuilderList() {
      return getInputsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.Input,
            com.google.cloud.video.transcoder.v1.Input.Builder,
            com.google.cloud.video.transcoder.v1.InputOrBuilder>
        getInputsFieldBuilder() {
      if (inputsBuilder_ == null) {
        inputsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.Input,
                com.google.cloud.video.transcoder.v1.Input.Builder,
                com.google.cloud.video.transcoder.v1.InputOrBuilder>(
                inputs_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        inputs_ = null;
      }
      return inputsBuilder_;
    }

    private java.util.List<com.google.cloud.video.transcoder.v1.EditAtom> editList_ =
        java.util.Collections.emptyList();

    private void ensureEditListIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        editList_ =
            new java.util.ArrayList<com.google.cloud.video.transcoder.v1.EditAtom>(editList_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.EditAtom,
            com.google.cloud.video.transcoder.v1.EditAtom.Builder,
            com.google.cloud.video.transcoder.v1.EditAtomOrBuilder>
        editListBuilder_;

    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.EditAtom> getEditListList() {
      if (editListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(editList_);
      } else {
        return editListBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public int getEditListCount() {
      if (editListBuilder_ == null) {
        return editList_.size();
      } else {
        return editListBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.EditAtom getEditList(int index) {
      if (editListBuilder_ == null) {
        return editList_.get(index);
      } else {
        return editListBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public Builder setEditList(int index, com.google.cloud.video.transcoder.v1.EditAtom value) {
      if (editListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEditListIsMutable();
        editList_.set(index, value);
        onChanged();
      } else {
        editListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public Builder setEditList(
        int index, com.google.cloud.video.transcoder.v1.EditAtom.Builder builderForValue) {
      if (editListBuilder_ == null) {
        ensureEditListIsMutable();
        editList_.set(index, builderForValue.build());
        onChanged();
      } else {
        editListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public Builder addEditList(com.google.cloud.video.transcoder.v1.EditAtom value) {
      if (editListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEditListIsMutable();
        editList_.add(value);
        onChanged();
      } else {
        editListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public Builder addEditList(int index, com.google.cloud.video.transcoder.v1.EditAtom value) {
      if (editListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEditListIsMutable();
        editList_.add(index, value);
        onChanged();
      } else {
        editListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public Builder addEditList(
        com.google.cloud.video.transcoder.v1.EditAtom.Builder builderForValue) {
      if (editListBuilder_ == null) {
        ensureEditListIsMutable();
        editList_.add(builderForValue.build());
        onChanged();
      } else {
        editListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public Builder addEditList(
        int index, com.google.cloud.video.transcoder.v1.EditAtom.Builder builderForValue) {
      if (editListBuilder_ == null) {
        ensureEditListIsMutable();
        editList_.add(index, builderForValue.build());
        onChanged();
      } else {
        editListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public Builder addAllEditList(
        java.lang.Iterable<? extends com.google.cloud.video.transcoder.v1.EditAtom> values) {
      if (editListBuilder_ == null) {
        ensureEditListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, editList_);
        onChanged();
      } else {
        editListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public Builder clearEditList() {
      if (editListBuilder_ == null) {
        editList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        editListBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public Builder removeEditList(int index) {
      if (editListBuilder_ == null) {
        ensureEditListIsMutable();
        editList_.remove(index);
        onChanged();
      } else {
        editListBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.EditAtom.Builder getEditListBuilder(int index) {
      return getEditListFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.EditAtomOrBuilder getEditListOrBuilder(int index) {
      if (editListBuilder_ == null) {
        return editList_.get(index);
      } else {
        return editListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.video.transcoder.v1.EditAtomOrBuilder>
        getEditListOrBuilderList() {
      if (editListBuilder_ != null) {
        return editListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(editList_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.EditAtom.Builder addEditListBuilder() {
      return getEditListFieldBuilder()
          .addBuilder(com.google.cloud.video.transcoder.v1.EditAtom.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.EditAtom.Builder addEditListBuilder(int index) {
      return getEditListFieldBuilder()
          .addBuilder(index, com.google.cloud.video.transcoder.v1.EditAtom.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of `Edit atom`s. Defines the ultimate timeline of the resulting
     * file or manifest.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.EditAtom edit_list = 2;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.EditAtom.Builder>
        getEditListBuilderList() {
      return getEditListFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.EditAtom,
            com.google.cloud.video.transcoder.v1.EditAtom.Builder,
            com.google.cloud.video.transcoder.v1.EditAtomOrBuilder>
        getEditListFieldBuilder() {
      if (editListBuilder_ == null) {
        editListBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.EditAtom,
                com.google.cloud.video.transcoder.v1.EditAtom.Builder,
                com.google.cloud.video.transcoder.v1.EditAtomOrBuilder>(
                editList_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        editList_ = null;
      }
      return editListBuilder_;
    }

    private java.util.List<com.google.cloud.video.transcoder.v1.ElementaryStream>
        elementaryStreams_ = java.util.Collections.emptyList();

    private void ensureElementaryStreamsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        elementaryStreams_ =
            new java.util.ArrayList<com.google.cloud.video.transcoder.v1.ElementaryStream>(
                elementaryStreams_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.ElementaryStream,
            com.google.cloud.video.transcoder.v1.ElementaryStream.Builder,
            com.google.cloud.video.transcoder.v1.ElementaryStreamOrBuilder>
        elementaryStreamsBuilder_;

    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.ElementaryStream>
        getElementaryStreamsList() {
      if (elementaryStreamsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(elementaryStreams_);
      } else {
        return elementaryStreamsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public int getElementaryStreamsCount() {
      if (elementaryStreamsBuilder_ == null) {
        return elementaryStreams_.size();
      } else {
        return elementaryStreamsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public com.google.cloud.video.transcoder.v1.ElementaryStream getElementaryStreams(int index) {
      if (elementaryStreamsBuilder_ == null) {
        return elementaryStreams_.get(index);
      } else {
        return elementaryStreamsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public Builder setElementaryStreams(
        int index, com.google.cloud.video.transcoder.v1.ElementaryStream value) {
      if (elementaryStreamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureElementaryStreamsIsMutable();
        elementaryStreams_.set(index, value);
        onChanged();
      } else {
        elementaryStreamsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public Builder setElementaryStreams(
        int index, com.google.cloud.video.transcoder.v1.ElementaryStream.Builder builderForValue) {
      if (elementaryStreamsBuilder_ == null) {
        ensureElementaryStreamsIsMutable();
        elementaryStreams_.set(index, builderForValue.build());
        onChanged();
      } else {
        elementaryStreamsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public Builder addElementaryStreams(
        com.google.cloud.video.transcoder.v1.ElementaryStream value) {
      if (elementaryStreamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureElementaryStreamsIsMutable();
        elementaryStreams_.add(value);
        onChanged();
      } else {
        elementaryStreamsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public Builder addElementaryStreams(
        int index, com.google.cloud.video.transcoder.v1.ElementaryStream value) {
      if (elementaryStreamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureElementaryStreamsIsMutable();
        elementaryStreams_.add(index, value);
        onChanged();
      } else {
        elementaryStreamsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public Builder addElementaryStreams(
        com.google.cloud.video.transcoder.v1.ElementaryStream.Builder builderForValue) {
      if (elementaryStreamsBuilder_ == null) {
        ensureElementaryStreamsIsMutable();
        elementaryStreams_.add(builderForValue.build());
        onChanged();
      } else {
        elementaryStreamsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public Builder addElementaryStreams(
        int index, com.google.cloud.video.transcoder.v1.ElementaryStream.Builder builderForValue) {
      if (elementaryStreamsBuilder_ == null) {
        ensureElementaryStreamsIsMutable();
        elementaryStreams_.add(index, builderForValue.build());
        onChanged();
      } else {
        elementaryStreamsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public Builder addAllElementaryStreams(
        java.lang.Iterable<? extends com.google.cloud.video.transcoder.v1.ElementaryStream>
            values) {
      if (elementaryStreamsBuilder_ == null) {
        ensureElementaryStreamsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, elementaryStreams_);
        onChanged();
      } else {
        elementaryStreamsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public Builder clearElementaryStreams() {
      if (elementaryStreamsBuilder_ == null) {
        elementaryStreams_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        elementaryStreamsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public Builder removeElementaryStreams(int index) {
      if (elementaryStreamsBuilder_ == null) {
        ensureElementaryStreamsIsMutable();
        elementaryStreams_.remove(index);
        onChanged();
      } else {
        elementaryStreamsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public com.google.cloud.video.transcoder.v1.ElementaryStream.Builder
        getElementaryStreamsBuilder(int index) {
      return getElementaryStreamsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public com.google.cloud.video.transcoder.v1.ElementaryStreamOrBuilder
        getElementaryStreamsOrBuilder(int index) {
      if (elementaryStreamsBuilder_ == null) {
        return elementaryStreams_.get(index);
      } else {
        return elementaryStreamsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.video.transcoder.v1.ElementaryStreamOrBuilder>
        getElementaryStreamsOrBuilderList() {
      if (elementaryStreamsBuilder_ != null) {
        return elementaryStreamsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(elementaryStreams_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public com.google.cloud.video.transcoder.v1.ElementaryStream.Builder
        addElementaryStreamsBuilder() {
      return getElementaryStreamsFieldBuilder()
          .addBuilder(com.google.cloud.video.transcoder.v1.ElementaryStream.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public com.google.cloud.video.transcoder.v1.ElementaryStream.Builder
        addElementaryStreamsBuilder(int index) {
      return getElementaryStreamsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.video.transcoder.v1.ElementaryStream.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of elementary streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.ElementaryStream elementary_streams = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.ElementaryStream.Builder>
        getElementaryStreamsBuilderList() {
      return getElementaryStreamsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.ElementaryStream,
            com.google.cloud.video.transcoder.v1.ElementaryStream.Builder,
            com.google.cloud.video.transcoder.v1.ElementaryStreamOrBuilder>
        getElementaryStreamsFieldBuilder() {
      if (elementaryStreamsBuilder_ == null) {
        elementaryStreamsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.ElementaryStream,
                com.google.cloud.video.transcoder.v1.ElementaryStream.Builder,
                com.google.cloud.video.transcoder.v1.ElementaryStreamOrBuilder>(
                elementaryStreams_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        elementaryStreams_ = null;
      }
      return elementaryStreamsBuilder_;
    }

    private java.util.List<com.google.cloud.video.transcoder.v1.MuxStream> muxStreams_ =
        java.util.Collections.emptyList();

    private void ensureMuxStreamsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        muxStreams_ =
            new java.util.ArrayList<com.google.cloud.video.transcoder.v1.MuxStream>(muxStreams_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.MuxStream,
            com.google.cloud.video.transcoder.v1.MuxStream.Builder,
            com.google.cloud.video.transcoder.v1.MuxStreamOrBuilder>
        muxStreamsBuilder_;

    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.MuxStream> getMuxStreamsList() {
      if (muxStreamsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(muxStreams_);
      } else {
        return muxStreamsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public int getMuxStreamsCount() {
      if (muxStreamsBuilder_ == null) {
        return muxStreams_.size();
      } else {
        return muxStreamsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public com.google.cloud.video.transcoder.v1.MuxStream getMuxStreams(int index) {
      if (muxStreamsBuilder_ == null) {
        return muxStreams_.get(index);
      } else {
        return muxStreamsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public Builder setMuxStreams(int index, com.google.cloud.video.transcoder.v1.MuxStream value) {
      if (muxStreamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMuxStreamsIsMutable();
        muxStreams_.set(index, value);
        onChanged();
      } else {
        muxStreamsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public Builder setMuxStreams(
        int index, com.google.cloud.video.transcoder.v1.MuxStream.Builder builderForValue) {
      if (muxStreamsBuilder_ == null) {
        ensureMuxStreamsIsMutable();
        muxStreams_.set(index, builderForValue.build());
        onChanged();
      } else {
        muxStreamsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public Builder addMuxStreams(com.google.cloud.video.transcoder.v1.MuxStream value) {
      if (muxStreamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMuxStreamsIsMutable();
        muxStreams_.add(value);
        onChanged();
      } else {
        muxStreamsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public Builder addMuxStreams(int index, com.google.cloud.video.transcoder.v1.MuxStream value) {
      if (muxStreamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMuxStreamsIsMutable();
        muxStreams_.add(index, value);
        onChanged();
      } else {
        muxStreamsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public Builder addMuxStreams(
        com.google.cloud.video.transcoder.v1.MuxStream.Builder builderForValue) {
      if (muxStreamsBuilder_ == null) {
        ensureMuxStreamsIsMutable();
        muxStreams_.add(builderForValue.build());
        onChanged();
      } else {
        muxStreamsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public Builder addMuxStreams(
        int index, com.google.cloud.video.transcoder.v1.MuxStream.Builder builderForValue) {
      if (muxStreamsBuilder_ == null) {
        ensureMuxStreamsIsMutable();
        muxStreams_.add(index, builderForValue.build());
        onChanged();
      } else {
        muxStreamsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public Builder addAllMuxStreams(
        java.lang.Iterable<? extends com.google.cloud.video.transcoder.v1.MuxStream> values) {
      if (muxStreamsBuilder_ == null) {
        ensureMuxStreamsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, muxStreams_);
        onChanged();
      } else {
        muxStreamsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public Builder clearMuxStreams() {
      if (muxStreamsBuilder_ == null) {
        muxStreams_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        muxStreamsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public Builder removeMuxStreams(int index) {
      if (muxStreamsBuilder_ == null) {
        ensureMuxStreamsIsMutable();
        muxStreams_.remove(index);
        onChanged();
      } else {
        muxStreamsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public com.google.cloud.video.transcoder.v1.MuxStream.Builder getMuxStreamsBuilder(int index) {
      return getMuxStreamsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public com.google.cloud.video.transcoder.v1.MuxStreamOrBuilder getMuxStreamsOrBuilder(
        int index) {
      if (muxStreamsBuilder_ == null) {
        return muxStreams_.get(index);
      } else {
        return muxStreamsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.video.transcoder.v1.MuxStreamOrBuilder>
        getMuxStreamsOrBuilderList() {
      if (muxStreamsBuilder_ != null) {
        return muxStreamsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(muxStreams_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public com.google.cloud.video.transcoder.v1.MuxStream.Builder addMuxStreamsBuilder() {
      return getMuxStreamsFieldBuilder()
          .addBuilder(com.google.cloud.video.transcoder.v1.MuxStream.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public com.google.cloud.video.transcoder.v1.MuxStream.Builder addMuxStreamsBuilder(int index) {
      return getMuxStreamsFieldBuilder()
          .addBuilder(index, com.google.cloud.video.transcoder.v1.MuxStream.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of multiplexing settings for output streams.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.MuxStream mux_streams = 4;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.MuxStream.Builder>
        getMuxStreamsBuilderList() {
      return getMuxStreamsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.MuxStream,
            com.google.cloud.video.transcoder.v1.MuxStream.Builder,
            com.google.cloud.video.transcoder.v1.MuxStreamOrBuilder>
        getMuxStreamsFieldBuilder() {
      if (muxStreamsBuilder_ == null) {
        muxStreamsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.MuxStream,
                com.google.cloud.video.transcoder.v1.MuxStream.Builder,
                com.google.cloud.video.transcoder.v1.MuxStreamOrBuilder>(
                muxStreams_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        muxStreams_ = null;
      }
      return muxStreamsBuilder_;
    }

    private java.util.List<com.google.cloud.video.transcoder.v1.Manifest> manifests_ =
        java.util.Collections.emptyList();

    private void ensureManifestsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        manifests_ =
            new java.util.ArrayList<com.google.cloud.video.transcoder.v1.Manifest>(manifests_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.Manifest,
            com.google.cloud.video.transcoder.v1.Manifest.Builder,
            com.google.cloud.video.transcoder.v1.ManifestOrBuilder>
        manifestsBuilder_;

    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.Manifest> getManifestsList() {
      if (manifestsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(manifests_);
      } else {
        return manifestsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public int getManifestsCount() {
      if (manifestsBuilder_ == null) {
        return manifests_.size();
      } else {
        return manifestsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public com.google.cloud.video.transcoder.v1.Manifest getManifests(int index) {
      if (manifestsBuilder_ == null) {
        return manifests_.get(index);
      } else {
        return manifestsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public Builder setManifests(int index, com.google.cloud.video.transcoder.v1.Manifest value) {
      if (manifestsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureManifestsIsMutable();
        manifests_.set(index, value);
        onChanged();
      } else {
        manifestsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public Builder setManifests(
        int index, com.google.cloud.video.transcoder.v1.Manifest.Builder builderForValue) {
      if (manifestsBuilder_ == null) {
        ensureManifestsIsMutable();
        manifests_.set(index, builderForValue.build());
        onChanged();
      } else {
        manifestsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public Builder addManifests(com.google.cloud.video.transcoder.v1.Manifest value) {
      if (manifestsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureManifestsIsMutable();
        manifests_.add(value);
        onChanged();
      } else {
        manifestsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public Builder addManifests(int index, com.google.cloud.video.transcoder.v1.Manifest value) {
      if (manifestsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureManifestsIsMutable();
        manifests_.add(index, value);
        onChanged();
      } else {
        manifestsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public Builder addManifests(
        com.google.cloud.video.transcoder.v1.Manifest.Builder builderForValue) {
      if (manifestsBuilder_ == null) {
        ensureManifestsIsMutable();
        manifests_.add(builderForValue.build());
        onChanged();
      } else {
        manifestsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public Builder addManifests(
        int index, com.google.cloud.video.transcoder.v1.Manifest.Builder builderForValue) {
      if (manifestsBuilder_ == null) {
        ensureManifestsIsMutable();
        manifests_.add(index, builderForValue.build());
        onChanged();
      } else {
        manifestsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public Builder addAllManifests(
        java.lang.Iterable<? extends com.google.cloud.video.transcoder.v1.Manifest> values) {
      if (manifestsBuilder_ == null) {
        ensureManifestsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, manifests_);
        onChanged();
      } else {
        manifestsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public Builder clearManifests() {
      if (manifestsBuilder_ == null) {
        manifests_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        manifestsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public Builder removeManifests(int index) {
      if (manifestsBuilder_ == null) {
        ensureManifestsIsMutable();
        manifests_.remove(index);
        onChanged();
      } else {
        manifestsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public com.google.cloud.video.transcoder.v1.Manifest.Builder getManifestsBuilder(int index) {
      return getManifestsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public com.google.cloud.video.transcoder.v1.ManifestOrBuilder getManifestsOrBuilder(int index) {
      if (manifestsBuilder_ == null) {
        return manifests_.get(index);
      } else {
        return manifestsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.video.transcoder.v1.ManifestOrBuilder>
        getManifestsOrBuilderList() {
      if (manifestsBuilder_ != null) {
        return manifestsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(manifests_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public com.google.cloud.video.transcoder.v1.Manifest.Builder addManifestsBuilder() {
      return getManifestsFieldBuilder()
          .addBuilder(com.google.cloud.video.transcoder.v1.Manifest.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public com.google.cloud.video.transcoder.v1.Manifest.Builder addManifestsBuilder(int index) {
      return getManifestsFieldBuilder()
          .addBuilder(index, com.google.cloud.video.transcoder.v1.Manifest.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of output manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Manifest manifests = 5;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.Manifest.Builder>
        getManifestsBuilderList() {
      return getManifestsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.Manifest,
            com.google.cloud.video.transcoder.v1.Manifest.Builder,
            com.google.cloud.video.transcoder.v1.ManifestOrBuilder>
        getManifestsFieldBuilder() {
      if (manifestsBuilder_ == null) {
        manifestsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.Manifest,
                com.google.cloud.video.transcoder.v1.Manifest.Builder,
                com.google.cloud.video.transcoder.v1.ManifestOrBuilder>(
                manifests_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        manifests_ = null;
      }
      return manifestsBuilder_;
    }

    private com.google.cloud.video.transcoder.v1.Output output_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.Output,
            com.google.cloud.video.transcoder.v1.Output.Builder,
            com.google.cloud.video.transcoder.v1.OutputOrBuilder>
        outputBuilder_;
    /**
     *
     *
     * <pre>
     * Output configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Output output = 6;</code>
     *
     * @return Whether the output field is set.
     */
    public boolean hasOutput() {
      return outputBuilder_ != null || output_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Output output = 6;</code>
     *
     * @return The output.
     */
    public com.google.cloud.video.transcoder.v1.Output getOutput() {
      if (outputBuilder_ == null) {
        return output_ == null
            ? com.google.cloud.video.transcoder.v1.Output.getDefaultInstance()
            : output_;
      } else {
        return outputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Output output = 6;</code>
     */
    public Builder setOutput(com.google.cloud.video.transcoder.v1.Output value) {
      if (outputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        output_ = value;
        onChanged();
      } else {
        outputBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Output output = 6;</code>
     */
    public Builder setOutput(com.google.cloud.video.transcoder.v1.Output.Builder builderForValue) {
      if (outputBuilder_ == null) {
        output_ = builderForValue.build();
        onChanged();
      } else {
        outputBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Output output = 6;</code>
     */
    public Builder mergeOutput(com.google.cloud.video.transcoder.v1.Output value) {
      if (outputBuilder_ == null) {
        if (output_ != null) {
          output_ =
              com.google.cloud.video.transcoder.v1.Output.newBuilder(output_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          output_ = value;
        }
        onChanged();
      } else {
        outputBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Output output = 6;</code>
     */
    public Builder clearOutput() {
      if (outputBuilder_ == null) {
        output_ = null;
        onChanged();
      } else {
        output_ = null;
        outputBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Output output = 6;</code>
     */
    public com.google.cloud.video.transcoder.v1.Output.Builder getOutputBuilder() {

      onChanged();
      return getOutputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Output output = 6;</code>
     */
    public com.google.cloud.video.transcoder.v1.OutputOrBuilder getOutputOrBuilder() {
      if (outputBuilder_ != null) {
        return outputBuilder_.getMessageOrBuilder();
      } else {
        return output_ == null
            ? com.google.cloud.video.transcoder.v1.Output.getDefaultInstance()
            : output_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output configuration.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.Output output = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.Output,
            com.google.cloud.video.transcoder.v1.Output.Builder,
            com.google.cloud.video.transcoder.v1.OutputOrBuilder>
        getOutputFieldBuilder() {
      if (outputBuilder_ == null) {
        outputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.Output,
                com.google.cloud.video.transcoder.v1.Output.Builder,
                com.google.cloud.video.transcoder.v1.OutputOrBuilder>(
                getOutput(), getParentForChildren(), isClean());
        output_ = null;
      }
      return outputBuilder_;
    }

    private java.util.List<com.google.cloud.video.transcoder.v1.AdBreak> adBreaks_ =
        java.util.Collections.emptyList();

    private void ensureAdBreaksIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        adBreaks_ =
            new java.util.ArrayList<com.google.cloud.video.transcoder.v1.AdBreak>(adBreaks_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.AdBreak,
            com.google.cloud.video.transcoder.v1.AdBreak.Builder,
            com.google.cloud.video.transcoder.v1.AdBreakOrBuilder>
        adBreaksBuilder_;

    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.AdBreak> getAdBreaksList() {
      if (adBreaksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(adBreaks_);
      } else {
        return adBreaksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public int getAdBreaksCount() {
      if (adBreaksBuilder_ == null) {
        return adBreaks_.size();
      } else {
        return adBreaksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public com.google.cloud.video.transcoder.v1.AdBreak getAdBreaks(int index) {
      if (adBreaksBuilder_ == null) {
        return adBreaks_.get(index);
      } else {
        return adBreaksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public Builder setAdBreaks(int index, com.google.cloud.video.transcoder.v1.AdBreak value) {
      if (adBreaksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdBreaksIsMutable();
        adBreaks_.set(index, value);
        onChanged();
      } else {
        adBreaksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public Builder setAdBreaks(
        int index, com.google.cloud.video.transcoder.v1.AdBreak.Builder builderForValue) {
      if (adBreaksBuilder_ == null) {
        ensureAdBreaksIsMutable();
        adBreaks_.set(index, builderForValue.build());
        onChanged();
      } else {
        adBreaksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public Builder addAdBreaks(com.google.cloud.video.transcoder.v1.AdBreak value) {
      if (adBreaksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdBreaksIsMutable();
        adBreaks_.add(value);
        onChanged();
      } else {
        adBreaksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public Builder addAdBreaks(int index, com.google.cloud.video.transcoder.v1.AdBreak value) {
      if (adBreaksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdBreaksIsMutable();
        adBreaks_.add(index, value);
        onChanged();
      } else {
        adBreaksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public Builder addAdBreaks(
        com.google.cloud.video.transcoder.v1.AdBreak.Builder builderForValue) {
      if (adBreaksBuilder_ == null) {
        ensureAdBreaksIsMutable();
        adBreaks_.add(builderForValue.build());
        onChanged();
      } else {
        adBreaksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public Builder addAdBreaks(
        int index, com.google.cloud.video.transcoder.v1.AdBreak.Builder builderForValue) {
      if (adBreaksBuilder_ == null) {
        ensureAdBreaksIsMutable();
        adBreaks_.add(index, builderForValue.build());
        onChanged();
      } else {
        adBreaksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public Builder addAllAdBreaks(
        java.lang.Iterable<? extends com.google.cloud.video.transcoder.v1.AdBreak> values) {
      if (adBreaksBuilder_ == null) {
        ensureAdBreaksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, adBreaks_);
        onChanged();
      } else {
        adBreaksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public Builder clearAdBreaks() {
      if (adBreaksBuilder_ == null) {
        adBreaks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        adBreaksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public Builder removeAdBreaks(int index) {
      if (adBreaksBuilder_ == null) {
        ensureAdBreaksIsMutable();
        adBreaks_.remove(index);
        onChanged();
      } else {
        adBreaksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public com.google.cloud.video.transcoder.v1.AdBreak.Builder getAdBreaksBuilder(int index) {
      return getAdBreaksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public com.google.cloud.video.transcoder.v1.AdBreakOrBuilder getAdBreaksOrBuilder(int index) {
      if (adBreaksBuilder_ == null) {
        return adBreaks_.get(index);
      } else {
        return adBreaksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public java.util.List<? extends com.google.cloud.video.transcoder.v1.AdBreakOrBuilder>
        getAdBreaksOrBuilderList() {
      if (adBreaksBuilder_ != null) {
        return adBreaksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(adBreaks_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public com.google.cloud.video.transcoder.v1.AdBreak.Builder addAdBreaksBuilder() {
      return getAdBreaksFieldBuilder()
          .addBuilder(com.google.cloud.video.transcoder.v1.AdBreak.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public com.google.cloud.video.transcoder.v1.AdBreak.Builder addAdBreaksBuilder(int index) {
      return getAdBreaksFieldBuilder()
          .addBuilder(index, com.google.cloud.video.transcoder.v1.AdBreak.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of ad breaks. Specifies where to insert ad break tags in the output
     * manifests.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.AdBreak ad_breaks = 7;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.AdBreak.Builder>
        getAdBreaksBuilderList() {
      return getAdBreaksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.AdBreak,
            com.google.cloud.video.transcoder.v1.AdBreak.Builder,
            com.google.cloud.video.transcoder.v1.AdBreakOrBuilder>
        getAdBreaksFieldBuilder() {
      if (adBreaksBuilder_ == null) {
        adBreaksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.AdBreak,
                com.google.cloud.video.transcoder.v1.AdBreak.Builder,
                com.google.cloud.video.transcoder.v1.AdBreakOrBuilder>(
                adBreaks_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        adBreaks_ = null;
      }
      return adBreaksBuilder_;
    }

    private com.google.cloud.video.transcoder.v1.PubsubDestination pubsubDestination_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PubsubDestination,
            com.google.cloud.video.transcoder.v1.PubsubDestination.Builder,
            com.google.cloud.video.transcoder.v1.PubsubDestinationOrBuilder>
        pubsubDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * Destination on Pub/Sub.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PubsubDestination pubsub_destination = 8;</code>
     *
     * @return Whether the pubsubDestination field is set.
     */
    public boolean hasPubsubDestination() {
      return pubsubDestinationBuilder_ != null || pubsubDestination_ != null;
    }
    /**
     *
     *
     * <pre>
     * Destination on Pub/Sub.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PubsubDestination pubsub_destination = 8;</code>
     *
     * @return The pubsubDestination.
     */
    public com.google.cloud.video.transcoder.v1.PubsubDestination getPubsubDestination() {
      if (pubsubDestinationBuilder_ == null) {
        return pubsubDestination_ == null
            ? com.google.cloud.video.transcoder.v1.PubsubDestination.getDefaultInstance()
            : pubsubDestination_;
      } else {
        return pubsubDestinationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Destination on Pub/Sub.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PubsubDestination pubsub_destination = 8;</code>
     */
    public Builder setPubsubDestination(
        com.google.cloud.video.transcoder.v1.PubsubDestination value) {
      if (pubsubDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pubsubDestination_ = value;
        onChanged();
      } else {
        pubsubDestinationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination on Pub/Sub.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PubsubDestination pubsub_destination = 8;</code>
     */
    public Builder setPubsubDestination(
        com.google.cloud.video.transcoder.v1.PubsubDestination.Builder builderForValue) {
      if (pubsubDestinationBuilder_ == null) {
        pubsubDestination_ = builderForValue.build();
        onChanged();
      } else {
        pubsubDestinationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination on Pub/Sub.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PubsubDestination pubsub_destination = 8;</code>
     */
    public Builder mergePubsubDestination(
        com.google.cloud.video.transcoder.v1.PubsubDestination value) {
      if (pubsubDestinationBuilder_ == null) {
        if (pubsubDestination_ != null) {
          pubsubDestination_ =
              com.google.cloud.video.transcoder.v1.PubsubDestination.newBuilder(pubsubDestination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pubsubDestination_ = value;
        }
        onChanged();
      } else {
        pubsubDestinationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination on Pub/Sub.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PubsubDestination pubsub_destination = 8;</code>
     */
    public Builder clearPubsubDestination() {
      if (pubsubDestinationBuilder_ == null) {
        pubsubDestination_ = null;
        onChanged();
      } else {
        pubsubDestination_ = null;
        pubsubDestinationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination on Pub/Sub.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PubsubDestination pubsub_destination = 8;</code>
     */
    public com.google.cloud.video.transcoder.v1.PubsubDestination.Builder
        getPubsubDestinationBuilder() {

      onChanged();
      return getPubsubDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Destination on Pub/Sub.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PubsubDestination pubsub_destination = 8;</code>
     */
    public com.google.cloud.video.transcoder.v1.PubsubDestinationOrBuilder
        getPubsubDestinationOrBuilder() {
      if (pubsubDestinationBuilder_ != null) {
        return pubsubDestinationBuilder_.getMessageOrBuilder();
      } else {
        return pubsubDestination_ == null
            ? com.google.cloud.video.transcoder.v1.PubsubDestination.getDefaultInstance()
            : pubsubDestination_;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination on Pub/Sub.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.PubsubDestination pubsub_destination = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.PubsubDestination,
            com.google.cloud.video.transcoder.v1.PubsubDestination.Builder,
            com.google.cloud.video.transcoder.v1.PubsubDestinationOrBuilder>
        getPubsubDestinationFieldBuilder() {
      if (pubsubDestinationBuilder_ == null) {
        pubsubDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.PubsubDestination,
                com.google.cloud.video.transcoder.v1.PubsubDestination.Builder,
                com.google.cloud.video.transcoder.v1.PubsubDestinationOrBuilder>(
                getPubsubDestination(), getParentForChildren(), isClean());
        pubsubDestination_ = null;
      }
      return pubsubDestinationBuilder_;
    }

    private java.util.List<com.google.cloud.video.transcoder.v1.SpriteSheet> spriteSheets_ =
        java.util.Collections.emptyList();

    private void ensureSpriteSheetsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        spriteSheets_ =
            new java.util.ArrayList<com.google.cloud.video.transcoder.v1.SpriteSheet>(
                spriteSheets_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.SpriteSheet,
            com.google.cloud.video.transcoder.v1.SpriteSheet.Builder,
            com.google.cloud.video.transcoder.v1.SpriteSheetOrBuilder>
        spriteSheetsBuilder_;

    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.SpriteSheet> getSpriteSheetsList() {
      if (spriteSheetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(spriteSheets_);
      } else {
        return spriteSheetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public int getSpriteSheetsCount() {
      if (spriteSheetsBuilder_ == null) {
        return spriteSheets_.size();
      } else {
        return spriteSheetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public com.google.cloud.video.transcoder.v1.SpriteSheet getSpriteSheets(int index) {
      if (spriteSheetsBuilder_ == null) {
        return spriteSheets_.get(index);
      } else {
        return spriteSheetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public Builder setSpriteSheets(
        int index, com.google.cloud.video.transcoder.v1.SpriteSheet value) {
      if (spriteSheetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpriteSheetsIsMutable();
        spriteSheets_.set(index, value);
        onChanged();
      } else {
        spriteSheetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public Builder setSpriteSheets(
        int index, com.google.cloud.video.transcoder.v1.SpriteSheet.Builder builderForValue) {
      if (spriteSheetsBuilder_ == null) {
        ensureSpriteSheetsIsMutable();
        spriteSheets_.set(index, builderForValue.build());
        onChanged();
      } else {
        spriteSheetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public Builder addSpriteSheets(com.google.cloud.video.transcoder.v1.SpriteSheet value) {
      if (spriteSheetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpriteSheetsIsMutable();
        spriteSheets_.add(value);
        onChanged();
      } else {
        spriteSheetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public Builder addSpriteSheets(
        int index, com.google.cloud.video.transcoder.v1.SpriteSheet value) {
      if (spriteSheetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpriteSheetsIsMutable();
        spriteSheets_.add(index, value);
        onChanged();
      } else {
        spriteSheetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public Builder addSpriteSheets(
        com.google.cloud.video.transcoder.v1.SpriteSheet.Builder builderForValue) {
      if (spriteSheetsBuilder_ == null) {
        ensureSpriteSheetsIsMutable();
        spriteSheets_.add(builderForValue.build());
        onChanged();
      } else {
        spriteSheetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public Builder addSpriteSheets(
        int index, com.google.cloud.video.transcoder.v1.SpriteSheet.Builder builderForValue) {
      if (spriteSheetsBuilder_ == null) {
        ensureSpriteSheetsIsMutable();
        spriteSheets_.add(index, builderForValue.build());
        onChanged();
      } else {
        spriteSheetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public Builder addAllSpriteSheets(
        java.lang.Iterable<? extends com.google.cloud.video.transcoder.v1.SpriteSheet> values) {
      if (spriteSheetsBuilder_ == null) {
        ensureSpriteSheetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, spriteSheets_);
        onChanged();
      } else {
        spriteSheetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public Builder clearSpriteSheets() {
      if (spriteSheetsBuilder_ == null) {
        spriteSheets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        spriteSheetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public Builder removeSpriteSheets(int index) {
      if (spriteSheetsBuilder_ == null) {
        ensureSpriteSheetsIsMutable();
        spriteSheets_.remove(index);
        onChanged();
      } else {
        spriteSheetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public com.google.cloud.video.transcoder.v1.SpriteSheet.Builder getSpriteSheetsBuilder(
        int index) {
      return getSpriteSheetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public com.google.cloud.video.transcoder.v1.SpriteSheetOrBuilder getSpriteSheetsOrBuilder(
        int index) {
      if (spriteSheetsBuilder_ == null) {
        return spriteSheets_.get(index);
      } else {
        return spriteSheetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.video.transcoder.v1.SpriteSheetOrBuilder>
        getSpriteSheetsOrBuilderList() {
      if (spriteSheetsBuilder_ != null) {
        return spriteSheetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(spriteSheets_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public com.google.cloud.video.transcoder.v1.SpriteSheet.Builder addSpriteSheetsBuilder() {
      return getSpriteSheetsFieldBuilder()
          .addBuilder(com.google.cloud.video.transcoder.v1.SpriteSheet.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public com.google.cloud.video.transcoder.v1.SpriteSheet.Builder addSpriteSheetsBuilder(
        int index) {
      return getSpriteSheetsFieldBuilder()
          .addBuilder(index, com.google.cloud.video.transcoder.v1.SpriteSheet.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of output sprite sheets.
     * Spritesheets require at least one VideoStream in the Jobconfig.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.SpriteSheet sprite_sheets = 9;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.SpriteSheet.Builder>
        getSpriteSheetsBuilderList() {
      return getSpriteSheetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.SpriteSheet,
            com.google.cloud.video.transcoder.v1.SpriteSheet.Builder,
            com.google.cloud.video.transcoder.v1.SpriteSheetOrBuilder>
        getSpriteSheetsFieldBuilder() {
      if (spriteSheetsBuilder_ == null) {
        spriteSheetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.SpriteSheet,
                com.google.cloud.video.transcoder.v1.SpriteSheet.Builder,
                com.google.cloud.video.transcoder.v1.SpriteSheetOrBuilder>(
                spriteSheets_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
        spriteSheets_ = null;
      }
      return spriteSheetsBuilder_;
    }

    private java.util.List<com.google.cloud.video.transcoder.v1.Overlay> overlays_ =
        java.util.Collections.emptyList();

    private void ensureOverlaysIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        overlays_ =
            new java.util.ArrayList<com.google.cloud.video.transcoder.v1.Overlay>(overlays_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.Overlay,
            com.google.cloud.video.transcoder.v1.Overlay.Builder,
            com.google.cloud.video.transcoder.v1.OverlayOrBuilder>
        overlaysBuilder_;

    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.Overlay> getOverlaysList() {
      if (overlaysBuilder_ == null) {
        return java.util.Collections.unmodifiableList(overlays_);
      } else {
        return overlaysBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public int getOverlaysCount() {
      if (overlaysBuilder_ == null) {
        return overlays_.size();
      } else {
        return overlaysBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public com.google.cloud.video.transcoder.v1.Overlay getOverlays(int index) {
      if (overlaysBuilder_ == null) {
        return overlays_.get(index);
      } else {
        return overlaysBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public Builder setOverlays(int index, com.google.cloud.video.transcoder.v1.Overlay value) {
      if (overlaysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOverlaysIsMutable();
        overlays_.set(index, value);
        onChanged();
      } else {
        overlaysBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public Builder setOverlays(
        int index, com.google.cloud.video.transcoder.v1.Overlay.Builder builderForValue) {
      if (overlaysBuilder_ == null) {
        ensureOverlaysIsMutable();
        overlays_.set(index, builderForValue.build());
        onChanged();
      } else {
        overlaysBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public Builder addOverlays(com.google.cloud.video.transcoder.v1.Overlay value) {
      if (overlaysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOverlaysIsMutable();
        overlays_.add(value);
        onChanged();
      } else {
        overlaysBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public Builder addOverlays(int index, com.google.cloud.video.transcoder.v1.Overlay value) {
      if (overlaysBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOverlaysIsMutable();
        overlays_.add(index, value);
        onChanged();
      } else {
        overlaysBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public Builder addOverlays(
        com.google.cloud.video.transcoder.v1.Overlay.Builder builderForValue) {
      if (overlaysBuilder_ == null) {
        ensureOverlaysIsMutable();
        overlays_.add(builderForValue.build());
        onChanged();
      } else {
        overlaysBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public Builder addOverlays(
        int index, com.google.cloud.video.transcoder.v1.Overlay.Builder builderForValue) {
      if (overlaysBuilder_ == null) {
        ensureOverlaysIsMutable();
        overlays_.add(index, builderForValue.build());
        onChanged();
      } else {
        overlaysBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public Builder addAllOverlays(
        java.lang.Iterable<? extends com.google.cloud.video.transcoder.v1.Overlay> values) {
      if (overlaysBuilder_ == null) {
        ensureOverlaysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, overlays_);
        onChanged();
      } else {
        overlaysBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public Builder clearOverlays() {
      if (overlaysBuilder_ == null) {
        overlays_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        overlaysBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public Builder removeOverlays(int index) {
      if (overlaysBuilder_ == null) {
        ensureOverlaysIsMutable();
        overlays_.remove(index);
        onChanged();
      } else {
        overlaysBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public com.google.cloud.video.transcoder.v1.Overlay.Builder getOverlaysBuilder(int index) {
      return getOverlaysFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public com.google.cloud.video.transcoder.v1.OverlayOrBuilder getOverlaysOrBuilder(int index) {
      if (overlaysBuilder_ == null) {
        return overlays_.get(index);
      } else {
        return overlaysBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public java.util.List<? extends com.google.cloud.video.transcoder.v1.OverlayOrBuilder>
        getOverlaysOrBuilderList() {
      if (overlaysBuilder_ != null) {
        return overlaysBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(overlays_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public com.google.cloud.video.transcoder.v1.Overlay.Builder addOverlaysBuilder() {
      return getOverlaysFieldBuilder()
          .addBuilder(com.google.cloud.video.transcoder.v1.Overlay.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public com.google.cloud.video.transcoder.v1.Overlay.Builder addOverlaysBuilder(int index) {
      return getOverlaysFieldBuilder()
          .addBuilder(index, com.google.cloud.video.transcoder.v1.Overlay.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of overlays on the output video, in descending Z-order.
     * </pre>
     *
     * <code>repeated .google.cloud.video.transcoder.v1.Overlay overlays = 10;</code>
     */
    public java.util.List<com.google.cloud.video.transcoder.v1.Overlay.Builder>
        getOverlaysBuilderList() {
      return getOverlaysFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.Overlay,
            com.google.cloud.video.transcoder.v1.Overlay.Builder,
            com.google.cloud.video.transcoder.v1.OverlayOrBuilder>
        getOverlaysFieldBuilder() {
      if (overlaysBuilder_ == null) {
        overlaysBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.Overlay,
                com.google.cloud.video.transcoder.v1.Overlay.Builder,
                com.google.cloud.video.transcoder.v1.OverlayOrBuilder>(
                overlays_, ((bitField0_ & 0x00000080) != 0), getParentForChildren(), isClean());
        overlays_ = null;
      }
      return overlaysBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.JobConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.JobConfig)
  private static final com.google.cloud.video.transcoder.v1.JobConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.JobConfig();
  }

  public static com.google.cloud.video.transcoder.v1.JobConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JobConfig> PARSER =
      new com.google.protobuf.AbstractParser<JobConfig>() {
        @java.lang.Override
        public JobConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<JobConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JobConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.JobConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
