/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/video/transcoder/v1/resources.proto

package com.google.cloud.video.transcoder.v1;

/**
 *
 *
 * <pre>
 * Transcoding job resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.video.transcoder.v1.Job}
 */
public final class Job extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.Job)
    JobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Job.newBuilder() to construct.
  private Job(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Job() {
    name_ = "";
    inputUri_ = "";
    outputUri_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Job();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_Job_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 16:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_Job_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.video.transcoder.v1.Job.class,
            com.google.cloud.video.transcoder.v1.Job.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The current state of the job.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.video.transcoder.v1.Job.ProcessingState}
   */
  public enum ProcessingState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The processing state is not specified.
     * </pre>
     *
     * <code>PROCESSING_STATE_UNSPECIFIED = 0;</code>
     */
    PROCESSING_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The job is enqueued and will be picked up for processing soon.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The job is being processed.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The job has been completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    SUCCEEDED(3),
    /**
     *
     *
     * <pre>
     * The job has failed. For additional information, see `failure_reason` and
     * `failure_details`
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The processing state is not specified.
     * </pre>
     *
     * <code>PROCESSING_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int PROCESSING_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The job is enqueued and will be picked up for processing soon.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The job is being processed.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The job has been completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    public static final int SUCCEEDED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The job has failed. For additional information, see `failure_reason` and
     * `failure_details`
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProcessingState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ProcessingState forNumber(int value) {
      switch (value) {
        case 0:
          return PROCESSING_STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return RUNNING;
        case 3:
          return SUCCEEDED;
        case 4:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ProcessingState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ProcessingState>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ProcessingState>() {
              public ProcessingState findValueByNumber(int number) {
                return ProcessingState.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.Job.getDescriptor().getEnumTypes().get(0);
    }

    private static final ProcessingState[] VALUES = values();

    public static ProcessingState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ProcessingState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.video.transcoder.v1.Job.ProcessingState)
  }

  private int jobConfigCase_ = 0;
  private java.lang.Object jobConfig_;

  public enum JobConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEMPLATE_ID(4),
    CONFIG(5),
    JOBCONFIG_NOT_SET(0);
    private final int value;

    private JobConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static JobConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static JobConfigCase forNumber(int value) {
      switch (value) {
        case 4:
          return TEMPLATE_ID;
        case 5:
          return CONFIG;
        case 0:
          return JOBCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public JobConfigCase getJobConfigCase() {
    return JobConfigCase.forNumber(jobConfigCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the job.
   * Format: `projects/{project_number}/locations/{location}/jobs/{job}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the job.
   * Format: `projects/{project_number}/locations/{location}/jobs/{job}`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_URI_FIELD_NUMBER = 2;
  private volatile java.lang.Object inputUri_;
  /**
   *
   *
   * <pre>
   * Input only. Specify the `input_uri` to populate empty `uri` fields in each element of
   * `Job.config.inputs` or `JobTemplate.config.inputs` when using template.
   * URI of the media. Input files must be at least 5 seconds in duration and
   * stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`). See
   * [Supported input and output
   * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
   * </pre>
   *
   * <code>string input_uri = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The inputUri.
   */
  @java.lang.Override
  public java.lang.String getInputUri() {
    java.lang.Object ref = inputUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inputUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input only. Specify the `input_uri` to populate empty `uri` fields in each element of
   * `Job.config.inputs` or `JobTemplate.config.inputs` when using template.
   * URI of the media. Input files must be at least 5 seconds in duration and
   * stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`). See
   * [Supported input and output
   * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
   * </pre>
   *
   * <code>string input_uri = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for inputUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInputUriBytes() {
    java.lang.Object ref = inputUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inputUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OUTPUT_URI_FIELD_NUMBER = 3;
  private volatile java.lang.Object outputUri_;
  /**
   *
   *
   * <pre>
   * Input only. Specify the `output_uri` to populate an empty `Job.config.output.uri` or
   * `JobTemplate.config.output.uri` when using template.
   * URI for the output file(s). For example, `gs://my-bucket/outputs/`. See
   * [Supported input and output
   * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
   * </pre>
   *
   * <code>string output_uri = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The outputUri.
   */
  @java.lang.Override
  public java.lang.String getOutputUri() {
    java.lang.Object ref = outputUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input only. Specify the `output_uri` to populate an empty `Job.config.output.uri` or
   * `JobTemplate.config.output.uri` when using template.
   * URI for the output file(s). For example, `gs://my-bucket/outputs/`. See
   * [Supported input and output
   * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
   * </pre>
   *
   * <code>string output_uri = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for outputUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputUriBytes() {
    java.lang.Object ref = outputUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEMPLATE_ID_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Input only. Specify the `template_id` to use for populating `Job.config`. The default
   * is `preset/web-hd`.
   * Preset Transcoder templates:
   * - `preset/{preset_id}`
   * - User defined JobTemplate:
   *   `{job_template_id}`
   * </pre>
   *
   * <code>string template_id = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return Whether the templateId field is set.
   */
  public boolean hasTemplateId() {
    return jobConfigCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Input only. Specify the `template_id` to use for populating `Job.config`. The default
   * is `preset/web-hd`.
   * Preset Transcoder templates:
   * - `preset/{preset_id}`
   * - User defined JobTemplate:
   *   `{job_template_id}`
   * </pre>
   *
   * <code>string template_id = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The templateId.
   */
  public java.lang.String getTemplateId() {
    java.lang.Object ref = "";
    if (jobConfigCase_ == 4) {
      ref = jobConfig_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (jobConfigCase_ == 4) {
        jobConfig_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input only. Specify the `template_id` to use for populating `Job.config`. The default
   * is `preset/web-hd`.
   * Preset Transcoder templates:
   * - `preset/{preset_id}`
   * - User defined JobTemplate:
   *   `{job_template_id}`
   * </pre>
   *
   * <code>string template_id = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for templateId.
   */
  public com.google.protobuf.ByteString getTemplateIdBytes() {
    java.lang.Object ref = "";
    if (jobConfigCase_ == 4) {
      ref = jobConfig_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (jobConfigCase_ == 4) {
        jobConfig_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The configuration for this job.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.JobConfig config = 5;</code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return jobConfigCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The configuration for this job.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.JobConfig config = 5;</code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.JobConfig getConfig() {
    if (jobConfigCase_ == 5) {
      return (com.google.cloud.video.transcoder.v1.JobConfig) jobConfig_;
    }
    return com.google.cloud.video.transcoder.v1.JobConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The configuration for this job.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.JobConfig config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.JobConfigOrBuilder getConfigOrBuilder() {
    if (jobConfigCase_ == 5) {
      return (com.google.cloud.video.transcoder.v1.JobConfig) jobConfig_;
    }
    return com.google.cloud.video.transcoder.v1.JobConfig.getDefaultInstance();
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.video.transcoder.v1.Job.ProcessingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the job.
   * </pre>
   *
   * <code>
   * .google.cloud.video.transcoder.v1.Job.ProcessingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Job.ProcessingState getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.video.transcoder.v1.Job.ProcessingState result =
        com.google.cloud.video.transcoder.v1.Job.ProcessingState.valueOf(state_);
    return result == null
        ? com.google.cloud.video.transcoder.v1.Job.ProcessingState.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int START_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the transcoding started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the transcoding started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the transcoding started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 14;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the transcoding finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the transcoding finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the transcoding finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int TTL_AFTER_COMPLETION_DAYS_FIELD_NUMBER = 15;
  private int ttlAfterCompletionDays_;
  /**
   *
   *
   * <pre>
   * Job time to live value in days, which will be effective after job
   * completion. Job should be deleted automatically after the given TTL. Enter
   * a value between 1 and 90. The default is 30.
   * </pre>
   *
   * <code>int32 ttl_after_completion_days = 15;</code>
   *
   * @return The ttlAfterCompletionDays.
   */
  @java.lang.Override
  public int getTtlAfterCompletionDays() {
    return ttlAfterCompletionDays_;
  }

  public static final int LABELS_FIELD_NUMBER = 16;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.video.transcoder.v1.ResourcesProto
                .internal_static_google_cloud_video_transcoder_v1_Job_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels associated with this job. You can use these to organize and
   * group your jobs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 16;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels associated with this job. You can use these to organize and
   * group your jobs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 16;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels associated with this job. You can use these to organize and
   * group your jobs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 16;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels associated with this job. You can use these to organize and
   * group your jobs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 16;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ERROR_FIELD_NUMBER = 17;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. An error object that describes the reason for the failure.
   * This property is always present when `state` is `FAILED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. An error object that describes the reason for the failure.
   * This property is always present when `state` is `FAILED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. An error object that describes the reason for the failure.
   * This property is always present when `state` is `FAILED`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return getError();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, inputUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, outputUri_);
    }
    if (jobConfigCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, jobConfig_);
    }
    if (jobConfigCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.video.transcoder.v1.JobConfig) jobConfig_);
    }
    if (state_
        != com.google.cloud.video.transcoder.v1.Job.ProcessingState.PROCESSING_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, state_);
    }
    if (createTime_ != null) {
      output.writeMessage(12, getCreateTime());
    }
    if (startTime_ != null) {
      output.writeMessage(13, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(14, getEndTime());
    }
    if (ttlAfterCompletionDays_ != 0) {
      output.writeInt32(15, ttlAfterCompletionDays_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 16);
    if (error_ != null) {
      output.writeMessage(17, getError());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, inputUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, outputUri_);
    }
    if (jobConfigCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, jobConfig_);
    }
    if (jobConfigCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.video.transcoder.v1.JobConfig) jobConfig_);
    }
    if (state_
        != com.google.cloud.video.transcoder.v1.Job.ProcessingState.PROCESSING_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getCreateTime());
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getEndTime());
    }
    if (ttlAfterCompletionDays_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(15, ttlAfterCompletionDays_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, labels__);
    }
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getError());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.video.transcoder.v1.Job)) {
      return super.equals(obj);
    }
    com.google.cloud.video.transcoder.v1.Job other = (com.google.cloud.video.transcoder.v1.Job) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getInputUri().equals(other.getInputUri())) return false;
    if (!getOutputUri().equals(other.getOutputUri())) return false;
    if (state_ != other.state_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (getTtlAfterCompletionDays() != other.getTtlAfterCompletionDays()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getJobConfigCase().equals(other.getJobConfigCase())) return false;
    switch (jobConfigCase_) {
      case 4:
        if (!getTemplateId().equals(other.getTemplateId())) return false;
        break;
      case 5:
        if (!getConfig().equals(other.getConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + INPUT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getInputUri().hashCode();
    hash = (37 * hash) + OUTPUT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getOutputUri().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + TTL_AFTER_COMPLETION_DAYS_FIELD_NUMBER;
    hash = (53 * hash) + getTtlAfterCompletionDays();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    switch (jobConfigCase_) {
      case 4:
        hash = (37 * hash) + TEMPLATE_ID_FIELD_NUMBER;
        hash = (53 * hash) + getTemplateId().hashCode();
        break;
      case 5:
        hash = (37 * hash) + CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.video.transcoder.v1.Job parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.Job parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Job parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.Job parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Job parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.Job parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Job parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.Job parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Job parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.Job parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.Job parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.Job parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.video.transcoder.v1.Job prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Transcoding job resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.Job}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.Job)
      com.google.cloud.video.transcoder.v1.JobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Job_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 16:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 16:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Job_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.Job.class,
              com.google.cloud.video.transcoder.v1.Job.Builder.class);
    }

    // Construct using com.google.cloud.video.transcoder.v1.Job.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      inputUri_ = "";

      outputUri_ = "";

      if (configBuilder_ != null) {
        configBuilder_.clear();
      }
      state_ = 0;

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      ttlAfterCompletionDays_ = 0;

      internalGetMutableLabels().clear();
      if (errorBuilder_ == null) {
        error_ = null;
      } else {
        error_ = null;
        errorBuilder_ = null;
      }
      jobConfigCase_ = 0;
      jobConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_Job_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Job getDefaultInstanceForType() {
      return com.google.cloud.video.transcoder.v1.Job.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Job build() {
      com.google.cloud.video.transcoder.v1.Job result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Job buildPartial() {
      com.google.cloud.video.transcoder.v1.Job result =
          new com.google.cloud.video.transcoder.v1.Job(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.inputUri_ = inputUri_;
      result.outputUri_ = outputUri_;
      if (jobConfigCase_ == 4) {
        result.jobConfig_ = jobConfig_;
      }
      if (jobConfigCase_ == 5) {
        if (configBuilder_ == null) {
          result.jobConfig_ = jobConfig_;
        } else {
          result.jobConfig_ = configBuilder_.build();
        }
      }
      result.state_ = state_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      result.ttlAfterCompletionDays_ = ttlAfterCompletionDays_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (errorBuilder_ == null) {
        result.error_ = error_;
      } else {
        result.error_ = errorBuilder_.build();
      }
      result.jobConfigCase_ = jobConfigCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.video.transcoder.v1.Job) {
        return mergeFrom((com.google.cloud.video.transcoder.v1.Job) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.video.transcoder.v1.Job other) {
      if (other == com.google.cloud.video.transcoder.v1.Job.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getInputUri().isEmpty()) {
        inputUri_ = other.inputUri_;
        onChanged();
      }
      if (!other.getOutputUri().isEmpty()) {
        outputUri_ = other.outputUri_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.getTtlAfterCompletionDays() != 0) {
        setTtlAfterCompletionDays(other.getTtlAfterCompletionDays());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.hasError()) {
        mergeError(other.getError());
      }
      switch (other.getJobConfigCase()) {
        case TEMPLATE_ID:
          {
            jobConfigCase_ = 4;
            jobConfig_ = other.jobConfig_;
            onChanged();
            break;
          }
        case CONFIG:
          {
            mergeConfig(other.getConfig());
            break;
          }
        case JOBCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                inputUri_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                outputUri_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                jobConfigCase_ = 4;
                jobConfig_ = s;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                jobConfigCase_ = 5;
                break;
              } // case 42
            case 64:
              {
                state_ = input.readEnum();

                break;
              } // case 64
            case 98:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 98
            case 106:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 106
            case 114:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 114
            case 120:
              {
                ttlAfterCompletionDays_ = input.readInt32();

                break;
              } // case 120
            case 130:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int jobConfigCase_ = 0;
    private java.lang.Object jobConfig_;

    public JobConfigCase getJobConfigCase() {
      return JobConfigCase.forNumber(jobConfigCase_);
    }

    public Builder clearJobConfig() {
      jobConfigCase_ = 0;
      jobConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the job.
     * Format: `projects/{project_number}/locations/{location}/jobs/{job}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the job.
     * Format: `projects/{project_number}/locations/{location}/jobs/{job}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the job.
     * Format: `projects/{project_number}/locations/{location}/jobs/{job}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the job.
     * Format: `projects/{project_number}/locations/{location}/jobs/{job}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the job.
     * Format: `projects/{project_number}/locations/{location}/jobs/{job}`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object inputUri_ = "";
    /**
     *
     *
     * <pre>
     * Input only. Specify the `input_uri` to populate empty `uri` fields in each element of
     * `Job.config.inputs` or `JobTemplate.config.inputs` when using template.
     * URI of the media. Input files must be at least 5 seconds in duration and
     * stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`). See
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
     * </pre>
     *
     * <code>string input_uri = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The inputUri.
     */
    public java.lang.String getInputUri() {
      java.lang.Object ref = inputUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `input_uri` to populate empty `uri` fields in each element of
     * `Job.config.inputs` or `JobTemplate.config.inputs` when using template.
     * URI of the media. Input files must be at least 5 seconds in duration and
     * stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`). See
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
     * </pre>
     *
     * <code>string input_uri = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for inputUri.
     */
    public com.google.protobuf.ByteString getInputUriBytes() {
      java.lang.Object ref = inputUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `input_uri` to populate empty `uri` fields in each element of
     * `Job.config.inputs` or `JobTemplate.config.inputs` when using template.
     * URI of the media. Input files must be at least 5 seconds in duration and
     * stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`). See
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
     * </pre>
     *
     * <code>string input_uri = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The inputUri to set.
     * @return This builder for chaining.
     */
    public Builder setInputUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      inputUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `input_uri` to populate empty `uri` fields in each element of
     * `Job.config.inputs` or `JobTemplate.config.inputs` when using template.
     * URI of the media. Input files must be at least 5 seconds in duration and
     * stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`). See
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
     * </pre>
     *
     * <code>string input_uri = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputUri() {

      inputUri_ = getDefaultInstance().getInputUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `input_uri` to populate empty `uri` fields in each element of
     * `Job.config.inputs` or `JobTemplate.config.inputs` when using template.
     * URI of the media. Input files must be at least 5 seconds in duration and
     * stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`). See
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
     * </pre>
     *
     * <code>string input_uri = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for inputUri to set.
     * @return This builder for chaining.
     */
    public Builder setInputUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      inputUri_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object outputUri_ = "";
    /**
     *
     *
     * <pre>
     * Input only. Specify the `output_uri` to populate an empty `Job.config.output.uri` or
     * `JobTemplate.config.output.uri` when using template.
     * URI for the output file(s). For example, `gs://my-bucket/outputs/`. See
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
     * </pre>
     *
     * <code>string output_uri = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The outputUri.
     */
    public java.lang.String getOutputUri() {
      java.lang.Object ref = outputUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `output_uri` to populate an empty `Job.config.output.uri` or
     * `JobTemplate.config.output.uri` when using template.
     * URI for the output file(s). For example, `gs://my-bucket/outputs/`. See
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
     * </pre>
     *
     * <code>string output_uri = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for outputUri.
     */
    public com.google.protobuf.ByteString getOutputUriBytes() {
      java.lang.Object ref = outputUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `output_uri` to populate an empty `Job.config.output.uri` or
     * `JobTemplate.config.output.uri` when using template.
     * URI for the output file(s). For example, `gs://my-bucket/outputs/`. See
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
     * </pre>
     *
     * <code>string output_uri = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The outputUri to set.
     * @return This builder for chaining.
     */
    public Builder setOutputUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      outputUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `output_uri` to populate an empty `Job.config.output.uri` or
     * `JobTemplate.config.output.uri` when using template.
     * URI for the output file(s). For example, `gs://my-bucket/outputs/`. See
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
     * </pre>
     *
     * <code>string output_uri = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputUri() {

      outputUri_ = getDefaultInstance().getOutputUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `output_uri` to populate an empty `Job.config.output.uri` or
     * `JobTemplate.config.output.uri` when using template.
     * URI for the output file(s). For example, `gs://my-bucket/outputs/`. See
     * [Supported input and output
     * formats](https://cloud.google.com/transcoder/docs/concepts/supported-input-and-output-formats).
     * </pre>
     *
     * <code>string output_uri = 3 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for outputUri to set.
     * @return This builder for chaining.
     */
    public Builder setOutputUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      outputUri_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Input only. Specify the `template_id` to use for populating `Job.config`. The default
     * is `preset/web-hd`.
     * Preset Transcoder templates:
     * - `preset/{preset_id}`
     * - User defined JobTemplate:
     *   `{job_template_id}`
     * </pre>
     *
     * <code>string template_id = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return Whether the templateId field is set.
     */
    @java.lang.Override
    public boolean hasTemplateId() {
      return jobConfigCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `template_id` to use for populating `Job.config`. The default
     * is `preset/web-hd`.
     * Preset Transcoder templates:
     * - `preset/{preset_id}`
     * - User defined JobTemplate:
     *   `{job_template_id}`
     * </pre>
     *
     * <code>string template_id = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The templateId.
     */
    @java.lang.Override
    public java.lang.String getTemplateId() {
      java.lang.Object ref = "";
      if (jobConfigCase_ == 4) {
        ref = jobConfig_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (jobConfigCase_ == 4) {
          jobConfig_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `template_id` to use for populating `Job.config`. The default
     * is `preset/web-hd`.
     * Preset Transcoder templates:
     * - `preset/{preset_id}`
     * - User defined JobTemplate:
     *   `{job_template_id}`
     * </pre>
     *
     * <code>string template_id = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for templateId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTemplateIdBytes() {
      java.lang.Object ref = "";
      if (jobConfigCase_ == 4) {
        ref = jobConfig_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (jobConfigCase_ == 4) {
          jobConfig_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `template_id` to use for populating `Job.config`. The default
     * is `preset/web-hd`.
     * Preset Transcoder templates:
     * - `preset/{preset_id}`
     * - User defined JobTemplate:
     *   `{job_template_id}`
     * </pre>
     *
     * <code>string template_id = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The templateId to set.
     * @return This builder for chaining.
     */
    public Builder setTemplateId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      jobConfigCase_ = 4;
      jobConfig_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `template_id` to use for populating `Job.config`. The default
     * is `preset/web-hd`.
     * Preset Transcoder templates:
     * - `preset/{preset_id}`
     * - User defined JobTemplate:
     *   `{job_template_id}`
     * </pre>
     *
     * <code>string template_id = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTemplateId() {
      if (jobConfigCase_ == 4) {
        jobConfigCase_ = 0;
        jobConfig_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. Specify the `template_id` to use for populating `Job.config`. The default
     * is `preset/web-hd`.
     * Preset Transcoder templates:
     * - `preset/{preset_id}`
     * - User defined JobTemplate:
     *   `{job_template_id}`
     * </pre>
     *
     * <code>string template_id = 4 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for templateId to set.
     * @return This builder for chaining.
     */
    public Builder setTemplateIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      jobConfigCase_ = 4;
      jobConfig_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.JobConfig,
            com.google.cloud.video.transcoder.v1.JobConfig.Builder,
            com.google.cloud.video.transcoder.v1.JobConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration for this job.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.JobConfig config = 5;</code>
     *
     * @return Whether the config field is set.
     */
    @java.lang.Override
    public boolean hasConfig() {
      return jobConfigCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The configuration for this job.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.JobConfig config = 5;</code>
     *
     * @return The config.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.JobConfig getConfig() {
      if (configBuilder_ == null) {
        if (jobConfigCase_ == 5) {
          return (com.google.cloud.video.transcoder.v1.JobConfig) jobConfig_;
        }
        return com.google.cloud.video.transcoder.v1.JobConfig.getDefaultInstance();
      } else {
        if (jobConfigCase_ == 5) {
          return configBuilder_.getMessage();
        }
        return com.google.cloud.video.transcoder.v1.JobConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for this job.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.JobConfig config = 5;</code>
     */
    public Builder setConfig(com.google.cloud.video.transcoder.v1.JobConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobConfig_ = value;
        onChanged();
      } else {
        configBuilder_.setMessage(value);
      }
      jobConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for this job.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.JobConfig config = 5;</code>
     */
    public Builder setConfig(
        com.google.cloud.video.transcoder.v1.JobConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        jobConfig_ = builderForValue.build();
        onChanged();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      jobConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for this job.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.JobConfig config = 5;</code>
     */
    public Builder mergeConfig(com.google.cloud.video.transcoder.v1.JobConfig value) {
      if (configBuilder_ == null) {
        if (jobConfigCase_ == 5
            && jobConfig_ != com.google.cloud.video.transcoder.v1.JobConfig.getDefaultInstance()) {
          jobConfig_ =
              com.google.cloud.video.transcoder.v1.JobConfig.newBuilder(
                      (com.google.cloud.video.transcoder.v1.JobConfig) jobConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobConfig_ = value;
        }
        onChanged();
      } else {
        if (jobConfigCase_ == 5) {
          configBuilder_.mergeFrom(value);
        } else {
          configBuilder_.setMessage(value);
        }
      }
      jobConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for this job.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.JobConfig config = 5;</code>
     */
    public Builder clearConfig() {
      if (configBuilder_ == null) {
        if (jobConfigCase_ == 5) {
          jobConfigCase_ = 0;
          jobConfig_ = null;
          onChanged();
        }
      } else {
        if (jobConfigCase_ == 5) {
          jobConfigCase_ = 0;
          jobConfig_ = null;
        }
        configBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for this job.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.JobConfig config = 5;</code>
     */
    public com.google.cloud.video.transcoder.v1.JobConfig.Builder getConfigBuilder() {
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration for this job.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.JobConfig config = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.JobConfigOrBuilder getConfigOrBuilder() {
      if ((jobConfigCase_ == 5) && (configBuilder_ != null)) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        if (jobConfigCase_ == 5) {
          return (com.google.cloud.video.transcoder.v1.JobConfig) jobConfig_;
        }
        return com.google.cloud.video.transcoder.v1.JobConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for this job.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.JobConfig config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.JobConfig,
            com.google.cloud.video.transcoder.v1.JobConfig.Builder,
            com.google.cloud.video.transcoder.v1.JobConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        if (!(jobConfigCase_ == 5)) {
          jobConfig_ = com.google.cloud.video.transcoder.v1.JobConfig.getDefaultInstance();
        }
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.JobConfig,
                com.google.cloud.video.transcoder.v1.JobConfig.Builder,
                com.google.cloud.video.transcoder.v1.JobConfigOrBuilder>(
                (com.google.cloud.video.transcoder.v1.JobConfig) jobConfig_,
                getParentForChildren(),
                isClean());
        jobConfig_ = null;
      }
      jobConfigCase_ = 5;
      onChanged();
      ;
      return configBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Job.ProcessingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Job.ProcessingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Job.ProcessingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.Job.ProcessingState getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.video.transcoder.v1.Job.ProcessingState result =
          com.google.cloud.video.transcoder.v1.Job.ProcessingState.valueOf(state_);
      return result == null
          ? com.google.cloud.video.transcoder.v1.Job.ProcessingState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Job.ProcessingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.video.transcoder.v1.Job.ProcessingState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the job.
     * </pre>
     *
     * <code>
     * .google.cloud.video.transcoder.v1.Job.ProcessingState state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the job was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding started.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp start_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the transcoding finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private int ttlAfterCompletionDays_;
    /**
     *
     *
     * <pre>
     * Job time to live value in days, which will be effective after job
     * completion. Job should be deleted automatically after the given TTL. Enter
     * a value between 1 and 90. The default is 30.
     * </pre>
     *
     * <code>int32 ttl_after_completion_days = 15;</code>
     *
     * @return The ttlAfterCompletionDays.
     */
    @java.lang.Override
    public int getTtlAfterCompletionDays() {
      return ttlAfterCompletionDays_;
    }
    /**
     *
     *
     * <pre>
     * Job time to live value in days, which will be effective after job
     * completion. Job should be deleted automatically after the given TTL. Enter
     * a value between 1 and 90. The default is 30.
     * </pre>
     *
     * <code>int32 ttl_after_completion_days = 15;</code>
     *
     * @param value The ttlAfterCompletionDays to set.
     * @return This builder for chaining.
     */
    public Builder setTtlAfterCompletionDays(int value) {

      ttlAfterCompletionDays_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Job time to live value in days, which will be effective after job
     * completion. Job should be deleted automatically after the given TTL. Enter
     * a value between 1 and 90. The default is 30.
     * </pre>
     *
     * <code>int32 ttl_after_completion_days = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTtlAfterCompletionDays() {

      ttlAfterCompletionDays_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this job. You can use these to organize and
     * group your jobs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this job. You can use these to organize and
     * group your jobs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this job. You can use these to organize and
     * group your jobs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this job. You can use these to organize and
     * group your jobs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this job. You can use these to organize and
     * group your jobs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this job. You can use these to organize and
     * group your jobs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this job. You can use these to organize and
     * group your jobs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 16;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return errorBuilder_ != null || error_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (error_ != null) {
          error_ = com.google.rpc.Status.newBuilder(error_).mergeFrom(value).buildPartial();
        } else {
          error_ = value;
        }
        onChanged();
      } else {
        errorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        error_ = null;
        onChanged();
      } else {
        error_ = null;
        errorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {

      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. An error object that describes the reason for the failure.
     * This property is always present when `state` is `FAILED`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.Job)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.Job)
  private static final com.google.cloud.video.transcoder.v1.Job DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.Job();
  }

  public static com.google.cloud.video.transcoder.v1.Job getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Job> PARSER =
      new com.google.protobuf.AbstractParser<Job>() {
        @java.lang.Override
        public Job parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Job> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Job> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.Job getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
