/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/video/transcoder/v1/resources.proto

package com.google.cloud.video.transcoder.v1;

/**
 *
 *
 * <pre>
 * Encoding of an input file such as an audio, video, or text track.
 * Elementary streams must be packaged before
 * mapping and sharing between different output formats.
 * </pre>
 *
 * Protobuf type {@code google.cloud.video.transcoder.v1.ElementaryStream}
 */
public final class ElementaryStream extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.video.transcoder.v1.ElementaryStream)
    ElementaryStreamOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ElementaryStream.newBuilder() to construct.
  private ElementaryStream(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ElementaryStream() {
    key_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ElementaryStream();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_ElementaryStream_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.video.transcoder.v1.ResourcesProto
        .internal_static_google_cloud_video_transcoder_v1_ElementaryStream_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.video.transcoder.v1.ElementaryStream.class,
            com.google.cloud.video.transcoder.v1.ElementaryStream.Builder.class);
  }

  private int elementaryStreamCase_ = 0;
  private java.lang.Object elementaryStream_;

  public enum ElementaryStreamCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VIDEO_STREAM(1),
    AUDIO_STREAM(2),
    TEXT_STREAM(3),
    ELEMENTARYSTREAM_NOT_SET(0);
    private final int value;

    private ElementaryStreamCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ElementaryStreamCase valueOf(int value) {
      return forNumber(value);
    }

    public static ElementaryStreamCase forNumber(int value) {
      switch (value) {
        case 1:
          return VIDEO_STREAM;
        case 2:
          return AUDIO_STREAM;
        case 3:
          return TEXT_STREAM;
        case 0:
          return ELEMENTARYSTREAM_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ElementaryStreamCase getElementaryStreamCase() {
    return ElementaryStreamCase.forNumber(elementaryStreamCase_);
  }

  public static final int KEY_FIELD_NUMBER = 4;
  private volatile java.lang.Object key_;
  /**
   *
   *
   * <pre>
   * A unique key for this elementary stream.
   * </pre>
   *
   * <code>string key = 4;</code>
   *
   * @return The key.
   */
  @java.lang.Override
  public java.lang.String getKey() {
    java.lang.Object ref = key_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      key_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique key for this elementary stream.
   * </pre>
   *
   * <code>string key = 4;</code>
   *
   * @return The bytes for key.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyBytes() {
    java.lang.Object ref = key_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      key_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VIDEO_STREAM_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Encoding of a video stream.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.VideoStream video_stream = 1;</code>
   *
   * @return Whether the videoStream field is set.
   */
  @java.lang.Override
  public boolean hasVideoStream() {
    return elementaryStreamCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Encoding of a video stream.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.VideoStream video_stream = 1;</code>
   *
   * @return The videoStream.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.VideoStream getVideoStream() {
    if (elementaryStreamCase_ == 1) {
      return (com.google.cloud.video.transcoder.v1.VideoStream) elementaryStream_;
    }
    return com.google.cloud.video.transcoder.v1.VideoStream.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Encoding of a video stream.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.VideoStream video_stream = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.VideoStreamOrBuilder getVideoStreamOrBuilder() {
    if (elementaryStreamCase_ == 1) {
      return (com.google.cloud.video.transcoder.v1.VideoStream) elementaryStream_;
    }
    return com.google.cloud.video.transcoder.v1.VideoStream.getDefaultInstance();
  }

  public static final int AUDIO_STREAM_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Encoding of an audio stream.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.AudioStream audio_stream = 2;</code>
   *
   * @return Whether the audioStream field is set.
   */
  @java.lang.Override
  public boolean hasAudioStream() {
    return elementaryStreamCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Encoding of an audio stream.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.AudioStream audio_stream = 2;</code>
   *
   * @return The audioStream.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.AudioStream getAudioStream() {
    if (elementaryStreamCase_ == 2) {
      return (com.google.cloud.video.transcoder.v1.AudioStream) elementaryStream_;
    }
    return com.google.cloud.video.transcoder.v1.AudioStream.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Encoding of an audio stream.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.AudioStream audio_stream = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.AudioStreamOrBuilder getAudioStreamOrBuilder() {
    if (elementaryStreamCase_ == 2) {
      return (com.google.cloud.video.transcoder.v1.AudioStream) elementaryStream_;
    }
    return com.google.cloud.video.transcoder.v1.AudioStream.getDefaultInstance();
  }

  public static final int TEXT_STREAM_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Encoding of a text stream. For example, closed captions or subtitles.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.TextStream text_stream = 3;</code>
   *
   * @return Whether the textStream field is set.
   */
  @java.lang.Override
  public boolean hasTextStream() {
    return elementaryStreamCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Encoding of a text stream. For example, closed captions or subtitles.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.TextStream text_stream = 3;</code>
   *
   * @return The textStream.
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.TextStream getTextStream() {
    if (elementaryStreamCase_ == 3) {
      return (com.google.cloud.video.transcoder.v1.TextStream) elementaryStream_;
    }
    return com.google.cloud.video.transcoder.v1.TextStream.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Encoding of a text stream. For example, closed captions or subtitles.
   * </pre>
   *
   * <code>.google.cloud.video.transcoder.v1.TextStream text_stream = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.TextStreamOrBuilder getTextStreamOrBuilder() {
    if (elementaryStreamCase_ == 3) {
      return (com.google.cloud.video.transcoder.v1.TextStream) elementaryStream_;
    }
    return com.google.cloud.video.transcoder.v1.TextStream.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (elementaryStreamCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.video.transcoder.v1.VideoStream) elementaryStream_);
    }
    if (elementaryStreamCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.video.transcoder.v1.AudioStream) elementaryStream_);
    }
    if (elementaryStreamCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.video.transcoder.v1.TextStream) elementaryStream_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, key_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (elementaryStreamCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.video.transcoder.v1.VideoStream) elementaryStream_);
    }
    if (elementaryStreamCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.video.transcoder.v1.AudioStream) elementaryStream_);
    }
    if (elementaryStreamCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.video.transcoder.v1.TextStream) elementaryStream_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, key_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.video.transcoder.v1.ElementaryStream)) {
      return super.equals(obj);
    }
    com.google.cloud.video.transcoder.v1.ElementaryStream other =
        (com.google.cloud.video.transcoder.v1.ElementaryStream) obj;

    if (!getKey().equals(other.getKey())) return false;
    if (!getElementaryStreamCase().equals(other.getElementaryStreamCase())) return false;
    switch (elementaryStreamCase_) {
      case 1:
        if (!getVideoStream().equals(other.getVideoStream())) return false;
        break;
      case 2:
        if (!getAudioStream().equals(other.getAudioStream())) return false;
        break;
      case 3:
        if (!getTextStream().equals(other.getTextStream())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKey().hashCode();
    switch (elementaryStreamCase_) {
      case 1:
        hash = (37 * hash) + VIDEO_STREAM_FIELD_NUMBER;
        hash = (53 * hash) + getVideoStream().hashCode();
        break;
      case 2:
        hash = (37 * hash) + AUDIO_STREAM_FIELD_NUMBER;
        hash = (53 * hash) + getAudioStream().hashCode();
        break;
      case 3:
        hash = (37 * hash) + TEXT_STREAM_FIELD_NUMBER;
        hash = (53 * hash) + getTextStream().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.video.transcoder.v1.ElementaryStream prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Encoding of an input file such as an audio, video, or text track.
   * Elementary streams must be packaged before
   * mapping and sharing between different output formats.
   * </pre>
   *
   * Protobuf type {@code google.cloud.video.transcoder.v1.ElementaryStream}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.video.transcoder.v1.ElementaryStream)
      com.google.cloud.video.transcoder.v1.ElementaryStreamOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_ElementaryStream_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_ElementaryStream_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.video.transcoder.v1.ElementaryStream.class,
              com.google.cloud.video.transcoder.v1.ElementaryStream.Builder.class);
    }

    // Construct using com.google.cloud.video.transcoder.v1.ElementaryStream.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      key_ = "";

      if (videoStreamBuilder_ != null) {
        videoStreamBuilder_.clear();
      }
      if (audioStreamBuilder_ != null) {
        audioStreamBuilder_.clear();
      }
      if (textStreamBuilder_ != null) {
        textStreamBuilder_.clear();
      }
      elementaryStreamCase_ = 0;
      elementaryStream_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.video.transcoder.v1.ResourcesProto
          .internal_static_google_cloud_video_transcoder_v1_ElementaryStream_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.ElementaryStream getDefaultInstanceForType() {
      return com.google.cloud.video.transcoder.v1.ElementaryStream.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.ElementaryStream build() {
      com.google.cloud.video.transcoder.v1.ElementaryStream result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.ElementaryStream buildPartial() {
      com.google.cloud.video.transcoder.v1.ElementaryStream result =
          new com.google.cloud.video.transcoder.v1.ElementaryStream(this);
      result.key_ = key_;
      if (elementaryStreamCase_ == 1) {
        if (videoStreamBuilder_ == null) {
          result.elementaryStream_ = elementaryStream_;
        } else {
          result.elementaryStream_ = videoStreamBuilder_.build();
        }
      }
      if (elementaryStreamCase_ == 2) {
        if (audioStreamBuilder_ == null) {
          result.elementaryStream_ = elementaryStream_;
        } else {
          result.elementaryStream_ = audioStreamBuilder_.build();
        }
      }
      if (elementaryStreamCase_ == 3) {
        if (textStreamBuilder_ == null) {
          result.elementaryStream_ = elementaryStream_;
        } else {
          result.elementaryStream_ = textStreamBuilder_.build();
        }
      }
      result.elementaryStreamCase_ = elementaryStreamCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.video.transcoder.v1.ElementaryStream) {
        return mergeFrom((com.google.cloud.video.transcoder.v1.ElementaryStream) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.video.transcoder.v1.ElementaryStream other) {
      if (other == com.google.cloud.video.transcoder.v1.ElementaryStream.getDefaultInstance())
        return this;
      if (!other.getKey().isEmpty()) {
        key_ = other.key_;
        onChanged();
      }
      switch (other.getElementaryStreamCase()) {
        case VIDEO_STREAM:
          {
            mergeVideoStream(other.getVideoStream());
            break;
          }
        case AUDIO_STREAM:
          {
            mergeAudioStream(other.getAudioStream());
            break;
          }
        case TEXT_STREAM:
          {
            mergeTextStream(other.getTextStream());
            break;
          }
        case ELEMENTARYSTREAM_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getVideoStreamFieldBuilder().getBuilder(), extensionRegistry);
                elementaryStreamCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getAudioStreamFieldBuilder().getBuilder(), extensionRegistry);
                elementaryStreamCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getTextStreamFieldBuilder().getBuilder(), extensionRegistry);
                elementaryStreamCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                key_ = input.readStringRequireUtf8();

                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int elementaryStreamCase_ = 0;
    private java.lang.Object elementaryStream_;

    public ElementaryStreamCase getElementaryStreamCase() {
      return ElementaryStreamCase.forNumber(elementaryStreamCase_);
    }

    public Builder clearElementaryStream() {
      elementaryStreamCase_ = 0;
      elementaryStream_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * A unique key for this elementary stream.
     * </pre>
     *
     * <code>string key = 4;</code>
     *
     * @return The key.
     */
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique key for this elementary stream.
     * </pre>
     *
     * <code>string key = 4;</code>
     *
     * @return The bytes for key.
     */
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique key for this elementary stream.
     * </pre>
     *
     * <code>string key = 4;</code>
     *
     * @param value The key to set.
     * @return This builder for chaining.
     */
    public Builder setKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      key_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique key for this elementary stream.
     * </pre>
     *
     * <code>string key = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKey() {

      key_ = getDefaultInstance().getKey();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique key for this elementary stream.
     * </pre>
     *
     * <code>string key = 4;</code>
     *
     * @param value The bytes for key to set.
     * @return This builder for chaining.
     */
    public Builder setKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      key_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.VideoStream,
            com.google.cloud.video.transcoder.v1.VideoStream.Builder,
            com.google.cloud.video.transcoder.v1.VideoStreamOrBuilder>
        videoStreamBuilder_;
    /**
     *
     *
     * <pre>
     * Encoding of a video stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream video_stream = 1;</code>
     *
     * @return Whether the videoStream field is set.
     */
    @java.lang.Override
    public boolean hasVideoStream() {
      return elementaryStreamCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Encoding of a video stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream video_stream = 1;</code>
     *
     * @return The videoStream.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStream getVideoStream() {
      if (videoStreamBuilder_ == null) {
        if (elementaryStreamCase_ == 1) {
          return (com.google.cloud.video.transcoder.v1.VideoStream) elementaryStream_;
        }
        return com.google.cloud.video.transcoder.v1.VideoStream.getDefaultInstance();
      } else {
        if (elementaryStreamCase_ == 1) {
          return videoStreamBuilder_.getMessage();
        }
        return com.google.cloud.video.transcoder.v1.VideoStream.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Encoding of a video stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream video_stream = 1;</code>
     */
    public Builder setVideoStream(com.google.cloud.video.transcoder.v1.VideoStream value) {
      if (videoStreamBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        elementaryStream_ = value;
        onChanged();
      } else {
        videoStreamBuilder_.setMessage(value);
      }
      elementaryStreamCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of a video stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream video_stream = 1;</code>
     */
    public Builder setVideoStream(
        com.google.cloud.video.transcoder.v1.VideoStream.Builder builderForValue) {
      if (videoStreamBuilder_ == null) {
        elementaryStream_ = builderForValue.build();
        onChanged();
      } else {
        videoStreamBuilder_.setMessage(builderForValue.build());
      }
      elementaryStreamCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of a video stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream video_stream = 1;</code>
     */
    public Builder mergeVideoStream(com.google.cloud.video.transcoder.v1.VideoStream value) {
      if (videoStreamBuilder_ == null) {
        if (elementaryStreamCase_ == 1
            && elementaryStream_
                != com.google.cloud.video.transcoder.v1.VideoStream.getDefaultInstance()) {
          elementaryStream_ =
              com.google.cloud.video.transcoder.v1.VideoStream.newBuilder(
                      (com.google.cloud.video.transcoder.v1.VideoStream) elementaryStream_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          elementaryStream_ = value;
        }
        onChanged();
      } else {
        if (elementaryStreamCase_ == 1) {
          videoStreamBuilder_.mergeFrom(value);
        } else {
          videoStreamBuilder_.setMessage(value);
        }
      }
      elementaryStreamCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of a video stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream video_stream = 1;</code>
     */
    public Builder clearVideoStream() {
      if (videoStreamBuilder_ == null) {
        if (elementaryStreamCase_ == 1) {
          elementaryStreamCase_ = 0;
          elementaryStream_ = null;
          onChanged();
        }
      } else {
        if (elementaryStreamCase_ == 1) {
          elementaryStreamCase_ = 0;
          elementaryStream_ = null;
        }
        videoStreamBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of a video stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream video_stream = 1;</code>
     */
    public com.google.cloud.video.transcoder.v1.VideoStream.Builder getVideoStreamBuilder() {
      return getVideoStreamFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Encoding of a video stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream video_stream = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.VideoStreamOrBuilder getVideoStreamOrBuilder() {
      if ((elementaryStreamCase_ == 1) && (videoStreamBuilder_ != null)) {
        return videoStreamBuilder_.getMessageOrBuilder();
      } else {
        if (elementaryStreamCase_ == 1) {
          return (com.google.cloud.video.transcoder.v1.VideoStream) elementaryStream_;
        }
        return com.google.cloud.video.transcoder.v1.VideoStream.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Encoding of a video stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.VideoStream video_stream = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.VideoStream,
            com.google.cloud.video.transcoder.v1.VideoStream.Builder,
            com.google.cloud.video.transcoder.v1.VideoStreamOrBuilder>
        getVideoStreamFieldBuilder() {
      if (videoStreamBuilder_ == null) {
        if (!(elementaryStreamCase_ == 1)) {
          elementaryStream_ = com.google.cloud.video.transcoder.v1.VideoStream.getDefaultInstance();
        }
        videoStreamBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.VideoStream,
                com.google.cloud.video.transcoder.v1.VideoStream.Builder,
                com.google.cloud.video.transcoder.v1.VideoStreamOrBuilder>(
                (com.google.cloud.video.transcoder.v1.VideoStream) elementaryStream_,
                getParentForChildren(),
                isClean());
        elementaryStream_ = null;
      }
      elementaryStreamCase_ = 1;
      onChanged();
      ;
      return videoStreamBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.AudioStream,
            com.google.cloud.video.transcoder.v1.AudioStream.Builder,
            com.google.cloud.video.transcoder.v1.AudioStreamOrBuilder>
        audioStreamBuilder_;
    /**
     *
     *
     * <pre>
     * Encoding of an audio stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.AudioStream audio_stream = 2;</code>
     *
     * @return Whether the audioStream field is set.
     */
    @java.lang.Override
    public boolean hasAudioStream() {
      return elementaryStreamCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Encoding of an audio stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.AudioStream audio_stream = 2;</code>
     *
     * @return The audioStream.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.AudioStream getAudioStream() {
      if (audioStreamBuilder_ == null) {
        if (elementaryStreamCase_ == 2) {
          return (com.google.cloud.video.transcoder.v1.AudioStream) elementaryStream_;
        }
        return com.google.cloud.video.transcoder.v1.AudioStream.getDefaultInstance();
      } else {
        if (elementaryStreamCase_ == 2) {
          return audioStreamBuilder_.getMessage();
        }
        return com.google.cloud.video.transcoder.v1.AudioStream.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Encoding of an audio stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.AudioStream audio_stream = 2;</code>
     */
    public Builder setAudioStream(com.google.cloud.video.transcoder.v1.AudioStream value) {
      if (audioStreamBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        elementaryStream_ = value;
        onChanged();
      } else {
        audioStreamBuilder_.setMessage(value);
      }
      elementaryStreamCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of an audio stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.AudioStream audio_stream = 2;</code>
     */
    public Builder setAudioStream(
        com.google.cloud.video.transcoder.v1.AudioStream.Builder builderForValue) {
      if (audioStreamBuilder_ == null) {
        elementaryStream_ = builderForValue.build();
        onChanged();
      } else {
        audioStreamBuilder_.setMessage(builderForValue.build());
      }
      elementaryStreamCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of an audio stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.AudioStream audio_stream = 2;</code>
     */
    public Builder mergeAudioStream(com.google.cloud.video.transcoder.v1.AudioStream value) {
      if (audioStreamBuilder_ == null) {
        if (elementaryStreamCase_ == 2
            && elementaryStream_
                != com.google.cloud.video.transcoder.v1.AudioStream.getDefaultInstance()) {
          elementaryStream_ =
              com.google.cloud.video.transcoder.v1.AudioStream.newBuilder(
                      (com.google.cloud.video.transcoder.v1.AudioStream) elementaryStream_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          elementaryStream_ = value;
        }
        onChanged();
      } else {
        if (elementaryStreamCase_ == 2) {
          audioStreamBuilder_.mergeFrom(value);
        } else {
          audioStreamBuilder_.setMessage(value);
        }
      }
      elementaryStreamCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of an audio stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.AudioStream audio_stream = 2;</code>
     */
    public Builder clearAudioStream() {
      if (audioStreamBuilder_ == null) {
        if (elementaryStreamCase_ == 2) {
          elementaryStreamCase_ = 0;
          elementaryStream_ = null;
          onChanged();
        }
      } else {
        if (elementaryStreamCase_ == 2) {
          elementaryStreamCase_ = 0;
          elementaryStream_ = null;
        }
        audioStreamBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of an audio stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.AudioStream audio_stream = 2;</code>
     */
    public com.google.cloud.video.transcoder.v1.AudioStream.Builder getAudioStreamBuilder() {
      return getAudioStreamFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Encoding of an audio stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.AudioStream audio_stream = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.AudioStreamOrBuilder getAudioStreamOrBuilder() {
      if ((elementaryStreamCase_ == 2) && (audioStreamBuilder_ != null)) {
        return audioStreamBuilder_.getMessageOrBuilder();
      } else {
        if (elementaryStreamCase_ == 2) {
          return (com.google.cloud.video.transcoder.v1.AudioStream) elementaryStream_;
        }
        return com.google.cloud.video.transcoder.v1.AudioStream.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Encoding of an audio stream.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.AudioStream audio_stream = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.AudioStream,
            com.google.cloud.video.transcoder.v1.AudioStream.Builder,
            com.google.cloud.video.transcoder.v1.AudioStreamOrBuilder>
        getAudioStreamFieldBuilder() {
      if (audioStreamBuilder_ == null) {
        if (!(elementaryStreamCase_ == 2)) {
          elementaryStream_ = com.google.cloud.video.transcoder.v1.AudioStream.getDefaultInstance();
        }
        audioStreamBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.AudioStream,
                com.google.cloud.video.transcoder.v1.AudioStream.Builder,
                com.google.cloud.video.transcoder.v1.AudioStreamOrBuilder>(
                (com.google.cloud.video.transcoder.v1.AudioStream) elementaryStream_,
                getParentForChildren(),
                isClean());
        elementaryStream_ = null;
      }
      elementaryStreamCase_ = 2;
      onChanged();
      ;
      return audioStreamBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.TextStream,
            com.google.cloud.video.transcoder.v1.TextStream.Builder,
            com.google.cloud.video.transcoder.v1.TextStreamOrBuilder>
        textStreamBuilder_;
    /**
     *
     *
     * <pre>
     * Encoding of a text stream. For example, closed captions or subtitles.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.TextStream text_stream = 3;</code>
     *
     * @return Whether the textStream field is set.
     */
    @java.lang.Override
    public boolean hasTextStream() {
      return elementaryStreamCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Encoding of a text stream. For example, closed captions or subtitles.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.TextStream text_stream = 3;</code>
     *
     * @return The textStream.
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.TextStream getTextStream() {
      if (textStreamBuilder_ == null) {
        if (elementaryStreamCase_ == 3) {
          return (com.google.cloud.video.transcoder.v1.TextStream) elementaryStream_;
        }
        return com.google.cloud.video.transcoder.v1.TextStream.getDefaultInstance();
      } else {
        if (elementaryStreamCase_ == 3) {
          return textStreamBuilder_.getMessage();
        }
        return com.google.cloud.video.transcoder.v1.TextStream.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Encoding of a text stream. For example, closed captions or subtitles.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.TextStream text_stream = 3;</code>
     */
    public Builder setTextStream(com.google.cloud.video.transcoder.v1.TextStream value) {
      if (textStreamBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        elementaryStream_ = value;
        onChanged();
      } else {
        textStreamBuilder_.setMessage(value);
      }
      elementaryStreamCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of a text stream. For example, closed captions or subtitles.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.TextStream text_stream = 3;</code>
     */
    public Builder setTextStream(
        com.google.cloud.video.transcoder.v1.TextStream.Builder builderForValue) {
      if (textStreamBuilder_ == null) {
        elementaryStream_ = builderForValue.build();
        onChanged();
      } else {
        textStreamBuilder_.setMessage(builderForValue.build());
      }
      elementaryStreamCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of a text stream. For example, closed captions or subtitles.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.TextStream text_stream = 3;</code>
     */
    public Builder mergeTextStream(com.google.cloud.video.transcoder.v1.TextStream value) {
      if (textStreamBuilder_ == null) {
        if (elementaryStreamCase_ == 3
            && elementaryStream_
                != com.google.cloud.video.transcoder.v1.TextStream.getDefaultInstance()) {
          elementaryStream_ =
              com.google.cloud.video.transcoder.v1.TextStream.newBuilder(
                      (com.google.cloud.video.transcoder.v1.TextStream) elementaryStream_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          elementaryStream_ = value;
        }
        onChanged();
      } else {
        if (elementaryStreamCase_ == 3) {
          textStreamBuilder_.mergeFrom(value);
        } else {
          textStreamBuilder_.setMessage(value);
        }
      }
      elementaryStreamCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of a text stream. For example, closed captions or subtitles.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.TextStream text_stream = 3;</code>
     */
    public Builder clearTextStream() {
      if (textStreamBuilder_ == null) {
        if (elementaryStreamCase_ == 3) {
          elementaryStreamCase_ = 0;
          elementaryStream_ = null;
          onChanged();
        }
      } else {
        if (elementaryStreamCase_ == 3) {
          elementaryStreamCase_ = 0;
          elementaryStream_ = null;
        }
        textStreamBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Encoding of a text stream. For example, closed captions or subtitles.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.TextStream text_stream = 3;</code>
     */
    public com.google.cloud.video.transcoder.v1.TextStream.Builder getTextStreamBuilder() {
      return getTextStreamFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Encoding of a text stream. For example, closed captions or subtitles.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.TextStream text_stream = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.video.transcoder.v1.TextStreamOrBuilder getTextStreamOrBuilder() {
      if ((elementaryStreamCase_ == 3) && (textStreamBuilder_ != null)) {
        return textStreamBuilder_.getMessageOrBuilder();
      } else {
        if (elementaryStreamCase_ == 3) {
          return (com.google.cloud.video.transcoder.v1.TextStream) elementaryStream_;
        }
        return com.google.cloud.video.transcoder.v1.TextStream.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Encoding of a text stream. For example, closed captions or subtitles.
     * </pre>
     *
     * <code>.google.cloud.video.transcoder.v1.TextStream text_stream = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.video.transcoder.v1.TextStream,
            com.google.cloud.video.transcoder.v1.TextStream.Builder,
            com.google.cloud.video.transcoder.v1.TextStreamOrBuilder>
        getTextStreamFieldBuilder() {
      if (textStreamBuilder_ == null) {
        if (!(elementaryStreamCase_ == 3)) {
          elementaryStream_ = com.google.cloud.video.transcoder.v1.TextStream.getDefaultInstance();
        }
        textStreamBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.video.transcoder.v1.TextStream,
                com.google.cloud.video.transcoder.v1.TextStream.Builder,
                com.google.cloud.video.transcoder.v1.TextStreamOrBuilder>(
                (com.google.cloud.video.transcoder.v1.TextStream) elementaryStream_,
                getParentForChildren(),
                isClean());
        elementaryStream_ = null;
      }
      elementaryStreamCase_ = 3;
      onChanged();
      ;
      return textStreamBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.video.transcoder.v1.ElementaryStream)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.video.transcoder.v1.ElementaryStream)
  private static final com.google.cloud.video.transcoder.v1.ElementaryStream DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.video.transcoder.v1.ElementaryStream();
  }

  public static com.google.cloud.video.transcoder.v1.ElementaryStream getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ElementaryStream> PARSER =
      new com.google.protobuf.AbstractParser<ElementaryStream>() {
        @java.lang.Override
        public ElementaryStream parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ElementaryStream> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ElementaryStream> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.video.transcoder.v1.ElementaryStream getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
