/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storagetransfer/v1/transfer_types.proto

package com.google.storagetransfer.v1.proto;

public final class TransferTypes {
  private TransferTypes() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface GoogleServiceAccountOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.GoogleServiceAccount)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Email address of the service account.
     * </pre>
     *
     * <code>string account_email = 1;</code>
     *
     * @return The accountEmail.
     */
    java.lang.String getAccountEmail();
    /**
     *
     *
     * <pre>
     * Email address of the service account.
     * </pre>
     *
     * <code>string account_email = 1;</code>
     *
     * @return The bytes for accountEmail.
     */
    com.google.protobuf.ByteString getAccountEmailBytes();

    /**
     *
     *
     * <pre>
     * Unique identifier for the service account.
     * </pre>
     *
     * <code>string subject_id = 2;</code>
     *
     * @return The subjectId.
     */
    java.lang.String getSubjectId();
    /**
     *
     *
     * <pre>
     * Unique identifier for the service account.
     * </pre>
     *
     * <code>string subject_id = 2;</code>
     *
     * @return The bytes for subjectId.
     */
    com.google.protobuf.ByteString getSubjectIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Google service account
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.GoogleServiceAccount}
   */
  public static final class GoogleServiceAccount extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.GoogleServiceAccount)
      GoogleServiceAccountOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GoogleServiceAccount.newBuilder() to construct.
    private GoogleServiceAccount(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GoogleServiceAccount() {
      accountEmail_ = "";
      subjectId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GoogleServiceAccount();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_GoogleServiceAccount_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_GoogleServiceAccount_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount.class,
              com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount.Builder.class);
    }

    public static final int ACCOUNT_EMAIL_FIELD_NUMBER = 1;
    private volatile java.lang.Object accountEmail_;
    /**
     *
     *
     * <pre>
     * Email address of the service account.
     * </pre>
     *
     * <code>string account_email = 1;</code>
     *
     * @return The accountEmail.
     */
    @java.lang.Override
    public java.lang.String getAccountEmail() {
      java.lang.Object ref = accountEmail_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        accountEmail_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Email address of the service account.
     * </pre>
     *
     * <code>string account_email = 1;</code>
     *
     * @return The bytes for accountEmail.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAccountEmailBytes() {
      java.lang.Object ref = accountEmail_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        accountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUBJECT_ID_FIELD_NUMBER = 2;
    private volatile java.lang.Object subjectId_;
    /**
     *
     *
     * <pre>
     * Unique identifier for the service account.
     * </pre>
     *
     * <code>string subject_id = 2;</code>
     *
     * @return The subjectId.
     */
    @java.lang.Override
    public java.lang.String getSubjectId() {
      java.lang.Object ref = subjectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subjectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Unique identifier for the service account.
     * </pre>
     *
     * <code>string subject_id = 2;</code>
     *
     * @return The bytes for subjectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSubjectIdBytes() {
      java.lang.Object ref = subjectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subjectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(accountEmail_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, accountEmail_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subjectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, subjectId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(accountEmail_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, accountEmail_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(subjectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, subjectId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount other =
          (com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount) obj;

      if (!getAccountEmail().equals(other.getAccountEmail())) return false;
      if (!getSubjectId().equals(other.getSubjectId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACCOUNT_EMAIL_FIELD_NUMBER;
      hash = (53 * hash) + getAccountEmail().hashCode();
      hash = (37 * hash) + SUBJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSubjectId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Google service account
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.GoogleServiceAccount}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.GoogleServiceAccount)
        com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccountOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_GoogleServiceAccount_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_GoogleServiceAccount_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount.class,
                com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        accountEmail_ = "";

        subjectId_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_GoogleServiceAccount_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount build() {
        com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount result =
            new com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount(this);
        result.accountEmail_ = accountEmail_;
        result.subjectId_ = subjectId_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount
                .getDefaultInstance()) return this;
        if (!other.getAccountEmail().isEmpty()) {
          accountEmail_ = other.accountEmail_;
          onChanged();
        }
        if (!other.getSubjectId().isEmpty()) {
          subjectId_ = other.subjectId_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  accountEmail_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  subjectId_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object accountEmail_ = "";
      /**
       *
       *
       * <pre>
       * Email address of the service account.
       * </pre>
       *
       * <code>string account_email = 1;</code>
       *
       * @return The accountEmail.
       */
      public java.lang.String getAccountEmail() {
        java.lang.Object ref = accountEmail_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          accountEmail_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Email address of the service account.
       * </pre>
       *
       * <code>string account_email = 1;</code>
       *
       * @return The bytes for accountEmail.
       */
      public com.google.protobuf.ByteString getAccountEmailBytes() {
        java.lang.Object ref = accountEmail_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          accountEmail_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Email address of the service account.
       * </pre>
       *
       * <code>string account_email = 1;</code>
       *
       * @param value The accountEmail to set.
       * @return This builder for chaining.
       */
      public Builder setAccountEmail(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        accountEmail_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Email address of the service account.
       * </pre>
       *
       * <code>string account_email = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAccountEmail() {

        accountEmail_ = getDefaultInstance().getAccountEmail();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Email address of the service account.
       * </pre>
       *
       * <code>string account_email = 1;</code>
       *
       * @param value The bytes for accountEmail to set.
       * @return This builder for chaining.
       */
      public Builder setAccountEmailBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        accountEmail_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object subjectId_ = "";
      /**
       *
       *
       * <pre>
       * Unique identifier for the service account.
       * </pre>
       *
       * <code>string subject_id = 2;</code>
       *
       * @return The subjectId.
       */
      public java.lang.String getSubjectId() {
        java.lang.Object ref = subjectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subjectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Unique identifier for the service account.
       * </pre>
       *
       * <code>string subject_id = 2;</code>
       *
       * @return The bytes for subjectId.
       */
      public com.google.protobuf.ByteString getSubjectIdBytes() {
        java.lang.Object ref = subjectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          subjectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Unique identifier for the service account.
       * </pre>
       *
       * <code>string subject_id = 2;</code>
       *
       * @param value The subjectId to set.
       * @return This builder for chaining.
       */
      public Builder setSubjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        subjectId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Unique identifier for the service account.
       * </pre>
       *
       * <code>string subject_id = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSubjectId() {

        subjectId_ = getDefaultInstance().getSubjectId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Unique identifier for the service account.
       * </pre>
       *
       * <code>string subject_id = 2;</code>
       *
       * @param value The bytes for subjectId to set.
       * @return This builder for chaining.
       */
      public Builder setSubjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        subjectId_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.GoogleServiceAccount)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.GoogleServiceAccount)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GoogleServiceAccount> PARSER =
        new com.google.protobuf.AbstractParser<GoogleServiceAccount>() {
          @java.lang.Override
          public GoogleServiceAccount parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GoogleServiceAccount> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GoogleServiceAccount> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.GoogleServiceAccount
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AwsAccessKeyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.AwsAccessKey)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. AWS access key ID.
     * </pre>
     *
     * <code>string access_key_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The accessKeyId.
     */
    java.lang.String getAccessKeyId();
    /**
     *
     *
     * <pre>
     * Required. AWS access key ID.
     * </pre>
     *
     * <code>string access_key_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for accessKeyId.
     */
    com.google.protobuf.ByteString getAccessKeyIdBytes();

    /**
     *
     *
     * <pre>
     * Required. AWS secret access key. This field is not returned in RPC
     * responses.
     * </pre>
     *
     * <code>string secret_access_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The secretAccessKey.
     */
    java.lang.String getSecretAccessKey();
    /**
     *
     *
     * <pre>
     * Required. AWS secret access key. This field is not returned in RPC
     * responses.
     * </pre>
     *
     * <code>string secret_access_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for secretAccessKey.
     */
    com.google.protobuf.ByteString getSecretAccessKeyBytes();
  }
  /**
   *
   *
   * <pre>
   * AWS access key (see
   * [AWS Security
   * Credentials](https://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html)).
   * For information on our data retention policy for user credentials, see
   * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.AwsAccessKey}
   */
  public static final class AwsAccessKey extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.AwsAccessKey)
      AwsAccessKeyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AwsAccessKey.newBuilder() to construct.
    private AwsAccessKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AwsAccessKey() {
      accessKeyId_ = "";
      secretAccessKey_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AwsAccessKey();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_AwsAccessKey_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_AwsAccessKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.class,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.Builder.class);
    }

    public static final int ACCESS_KEY_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object accessKeyId_;
    /**
     *
     *
     * <pre>
     * Required. AWS access key ID.
     * </pre>
     *
     * <code>string access_key_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The accessKeyId.
     */
    @java.lang.Override
    public java.lang.String getAccessKeyId() {
      java.lang.Object ref = accessKeyId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        accessKeyId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. AWS access key ID.
     * </pre>
     *
     * <code>string access_key_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for accessKeyId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAccessKeyIdBytes() {
      java.lang.Object ref = accessKeyId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        accessKeyId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SECRET_ACCESS_KEY_FIELD_NUMBER = 2;
    private volatile java.lang.Object secretAccessKey_;
    /**
     *
     *
     * <pre>
     * Required. AWS secret access key. This field is not returned in RPC
     * responses.
     * </pre>
     *
     * <code>string secret_access_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The secretAccessKey.
     */
    @java.lang.Override
    public java.lang.String getSecretAccessKey() {
      java.lang.Object ref = secretAccessKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        secretAccessKey_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. AWS secret access key. This field is not returned in RPC
     * responses.
     * </pre>
     *
     * <code>string secret_access_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for secretAccessKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSecretAccessKeyBytes() {
      java.lang.Object ref = secretAccessKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        secretAccessKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(accessKeyId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, accessKeyId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secretAccessKey_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, secretAccessKey_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(accessKeyId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, accessKeyId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(secretAccessKey_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, secretAccessKey_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey other =
          (com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey) obj;

      if (!getAccessKeyId().equals(other.getAccessKeyId())) return false;
      if (!getSecretAccessKey().equals(other.getSecretAccessKey())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACCESS_KEY_ID_FIELD_NUMBER;
      hash = (53 * hash) + getAccessKeyId().hashCode();
      hash = (37 * hash) + SECRET_ACCESS_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getSecretAccessKey().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * AWS access key (see
     * [AWS Security
     * Credentials](https://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html)).
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.AwsAccessKey}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.AwsAccessKey)
        com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKeyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AwsAccessKey_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AwsAccessKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.class,
                com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.Builder.class);
      }

      // Construct using com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        accessKeyId_ = "";

        secretAccessKey_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AwsAccessKey_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey build() {
        com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey result =
            new com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey(this);
        result.accessKeyId_ = accessKeyId_;
        result.secretAccessKey_ = secretAccessKey_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey) {
          return mergeFrom((com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.getDefaultInstance())
          return this;
        if (!other.getAccessKeyId().isEmpty()) {
          accessKeyId_ = other.accessKeyId_;
          onChanged();
        }
        if (!other.getSecretAccessKey().isEmpty()) {
          secretAccessKey_ = other.secretAccessKey_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  accessKeyId_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  secretAccessKey_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object accessKeyId_ = "";
      /**
       *
       *
       * <pre>
       * Required. AWS access key ID.
       * </pre>
       *
       * <code>string access_key_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The accessKeyId.
       */
      public java.lang.String getAccessKeyId() {
        java.lang.Object ref = accessKeyId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          accessKeyId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. AWS access key ID.
       * </pre>
       *
       * <code>string access_key_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for accessKeyId.
       */
      public com.google.protobuf.ByteString getAccessKeyIdBytes() {
        java.lang.Object ref = accessKeyId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          accessKeyId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. AWS access key ID.
       * </pre>
       *
       * <code>string access_key_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The accessKeyId to set.
       * @return This builder for chaining.
       */
      public Builder setAccessKeyId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        accessKeyId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. AWS access key ID.
       * </pre>
       *
       * <code>string access_key_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAccessKeyId() {

        accessKeyId_ = getDefaultInstance().getAccessKeyId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. AWS access key ID.
       * </pre>
       *
       * <code>string access_key_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for accessKeyId to set.
       * @return This builder for chaining.
       */
      public Builder setAccessKeyIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        accessKeyId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object secretAccessKey_ = "";
      /**
       *
       *
       * <pre>
       * Required. AWS secret access key. This field is not returned in RPC
       * responses.
       * </pre>
       *
       * <code>string secret_access_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The secretAccessKey.
       */
      public java.lang.String getSecretAccessKey() {
        java.lang.Object ref = secretAccessKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          secretAccessKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. AWS secret access key. This field is not returned in RPC
       * responses.
       * </pre>
       *
       * <code>string secret_access_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for secretAccessKey.
       */
      public com.google.protobuf.ByteString getSecretAccessKeyBytes() {
        java.lang.Object ref = secretAccessKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          secretAccessKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. AWS secret access key. This field is not returned in RPC
       * responses.
       * </pre>
       *
       * <code>string secret_access_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The secretAccessKey to set.
       * @return This builder for chaining.
       */
      public Builder setSecretAccessKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        secretAccessKey_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. AWS secret access key. This field is not returned in RPC
       * responses.
       * </pre>
       *
       * <code>string secret_access_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSecretAccessKey() {

        secretAccessKey_ = getDefaultInstance().getSecretAccessKey();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. AWS secret access key. This field is not returned in RPC
       * responses.
       * </pre>
       *
       * <code>string secret_access_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for secretAccessKey to set.
       * @return This builder for chaining.
       */
      public Builder setSecretAccessKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        secretAccessKey_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.AwsAccessKey)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.AwsAccessKey)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AwsAccessKey> PARSER =
        new com.google.protobuf.AbstractParser<AwsAccessKey>() {
          @java.lang.Override
          public AwsAccessKey parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AwsAccessKey> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AwsAccessKey> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AzureCredentialsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.AzureCredentials)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Azure shared access signature (SAS).
     * For more information about SAS, see
     * [Grant limited access to Azure Storage resources using shared access
     * signatures
     * (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
     * </pre>
     *
     * <code>string sas_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sasToken.
     */
    java.lang.String getSasToken();
    /**
     *
     *
     * <pre>
     * Required. Azure shared access signature (SAS).
     * For more information about SAS, see
     * [Grant limited access to Azure Storage resources using shared access
     * signatures
     * (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
     * </pre>
     *
     * <code>string sas_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sasToken.
     */
    com.google.protobuf.ByteString getSasTokenBytes();
  }
  /**
   *
   *
   * <pre>
   * Azure credentials
   * For information on our data retention policy for user credentials, see
   * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.AzureCredentials}
   */
  public static final class AzureCredentials extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.AzureCredentials)
      AzureCredentialsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AzureCredentials.newBuilder() to construct.
    private AzureCredentials(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AzureCredentials() {
      sasToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AzureCredentials();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_AzureCredentials_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_AzureCredentials_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials.class,
              com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials.Builder.class);
    }

    public static final int SAS_TOKEN_FIELD_NUMBER = 2;
    private volatile java.lang.Object sasToken_;
    /**
     *
     *
     * <pre>
     * Required. Azure shared access signature (SAS).
     * For more information about SAS, see
     * [Grant limited access to Azure Storage resources using shared access
     * signatures
     * (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
     * </pre>
     *
     * <code>string sas_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sasToken.
     */
    @java.lang.Override
    public java.lang.String getSasToken() {
      java.lang.Object ref = sasToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sasToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Azure shared access signature (SAS).
     * For more information about SAS, see
     * [Grant limited access to Azure Storage resources using shared access
     * signatures
     * (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
     * </pre>
     *
     * <code>string sas_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sasToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSasTokenBytes() {
      java.lang.Object ref = sasToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sasToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sasToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sasToken_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sasToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sasToken_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials other =
          (com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials) obj;

      if (!getSasToken().equals(other.getSasToken())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SAS_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getSasToken().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Azure credentials
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.AzureCredentials}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.AzureCredentials)
        com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentialsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AzureCredentials_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AzureCredentials_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials.class,
                com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials.Builder.class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        sasToken_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AzureCredentials_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials build() {
        com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials result =
            new com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials(this);
        result.sasToken_ = sasToken_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials
                .getDefaultInstance()) return this;
        if (!other.getSasToken().isEmpty()) {
          sasToken_ = other.sasToken_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  sasToken_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object sasToken_ = "";
      /**
       *
       *
       * <pre>
       * Required. Azure shared access signature (SAS).
       * For more information about SAS, see
       * [Grant limited access to Azure Storage resources using shared access
       * signatures
       * (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
       * </pre>
       *
       * <code>string sas_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The sasToken.
       */
      public java.lang.String getSasToken() {
        java.lang.Object ref = sasToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sasToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Azure shared access signature (SAS).
       * For more information about SAS, see
       * [Grant limited access to Azure Storage resources using shared access
       * signatures
       * (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
       * </pre>
       *
       * <code>string sas_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for sasToken.
       */
      public com.google.protobuf.ByteString getSasTokenBytes() {
        java.lang.Object ref = sasToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sasToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Azure shared access signature (SAS).
       * For more information about SAS, see
       * [Grant limited access to Azure Storage resources using shared access
       * signatures
       * (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
       * </pre>
       *
       * <code>string sas_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The sasToken to set.
       * @return This builder for chaining.
       */
      public Builder setSasToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        sasToken_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Azure shared access signature (SAS).
       * For more information about SAS, see
       * [Grant limited access to Azure Storage resources using shared access
       * signatures
       * (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
       * </pre>
       *
       * <code>string sas_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSasToken() {

        sasToken_ = getDefaultInstance().getSasToken();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Azure shared access signature (SAS).
       * For more information about SAS, see
       * [Grant limited access to Azure Storage resources using shared access
       * signatures
       * (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
       * </pre>
       *
       * <code>string sas_token = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for sasToken to set.
       * @return This builder for chaining.
       */
      public Builder setSasTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        sasToken_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.AzureCredentials)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.AzureCredentials)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AzureCredentials> PARSER =
        new com.google.protobuf.AbstractParser<AzureCredentials>() {
          @java.lang.Override
          public AzureCredentials parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AzureCredentials> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AzureCredentials> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ObjectConditionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.ObjectConditions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Ensures that objects are not transferred until a specific minimum time
     * has elapsed after the "last modification time". When a
     * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
     * transferred only if the elapsed time between the
     * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
     * and the "last modification time" of the object is equal to or
     * greater than the value of min_time_elapsed_since_last_modification`.
     * Objects that do not have a "last modification time" are also transferred.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
     *
     * @return Whether the minTimeElapsedSinceLastModification field is set.
     */
    boolean hasMinTimeElapsedSinceLastModification();
    /**
     *
     *
     * <pre>
     * Ensures that objects are not transferred until a specific minimum time
     * has elapsed after the "last modification time". When a
     * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
     * transferred only if the elapsed time between the
     * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
     * and the "last modification time" of the object is equal to or
     * greater than the value of min_time_elapsed_since_last_modification`.
     * Objects that do not have a "last modification time" are also transferred.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
     *
     * @return The minTimeElapsedSinceLastModification.
     */
    com.google.protobuf.Duration getMinTimeElapsedSinceLastModification();
    /**
     *
     *
     * <pre>
     * Ensures that objects are not transferred until a specific minimum time
     * has elapsed after the "last modification time". When a
     * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
     * transferred only if the elapsed time between the
     * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
     * and the "last modification time" of the object is equal to or
     * greater than the value of min_time_elapsed_since_last_modification`.
     * Objects that do not have a "last modification time" are also transferred.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
     */
    com.google.protobuf.DurationOrBuilder getMinTimeElapsedSinceLastModificationOrBuilder();

    /**
     *
     *
     * <pre>
     * Ensures that objects are not transferred if a specific maximum time
     * has elapsed since the "last modification time".
     * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
     * "last modification time" are transferred only if the elapsed time
     * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
     * `TransferOperation`and the "last modification time" of the object
     *  is less than the value of max_time_elapsed_since_last_modification`.
     * Objects that do not have a "last modification time" are also transferred.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
     *
     * @return Whether the maxTimeElapsedSinceLastModification field is set.
     */
    boolean hasMaxTimeElapsedSinceLastModification();
    /**
     *
     *
     * <pre>
     * Ensures that objects are not transferred if a specific maximum time
     * has elapsed since the "last modification time".
     * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
     * "last modification time" are transferred only if the elapsed time
     * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
     * `TransferOperation`and the "last modification time" of the object
     *  is less than the value of max_time_elapsed_since_last_modification`.
     * Objects that do not have a "last modification time" are also transferred.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
     *
     * @return The maxTimeElapsedSinceLastModification.
     */
    com.google.protobuf.Duration getMaxTimeElapsedSinceLastModification();
    /**
     *
     *
     * <pre>
     * Ensures that objects are not transferred if a specific maximum time
     * has elapsed since the "last modification time".
     * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
     * "last modification time" are transferred only if the elapsed time
     * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
     * `TransferOperation`and the "last modification time" of the object
     *  is less than the value of max_time_elapsed_since_last_modification`.
     * Objects that do not have a "last modification time" are also transferred.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
     */
    com.google.protobuf.DurationOrBuilder getMaxTimeElapsedSinceLastModificationOrBuilder();

    /**
     *
     *
     * <pre>
     * If you specify `include_prefixes`, Storage Transfer Service uses the items
     * in the `include_prefixes` array to determine which objects to include in a
     * transfer. Objects must start with one of the matching `include_prefixes`
     * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
     * objects must not start with any of the `exclude_prefixes` specified for
     * inclusion in the transfer.
     * The following are requirements of `include_prefixes`:
     *   * Each include-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each include-prefix must omit the leading slash. For example, to
     *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the include-prefix as `logs/y=2015/requests.gz`.
     *   * None of the include-prefix values can be empty, if specified.
     *   * Each include-prefix must include a distinct portion of the object
     *     namespace. No include-prefix may be a prefix of another
     *     include-prefix.
     * The max size of `include_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string include_prefixes = 3;</code>
     *
     * @return A list containing the includePrefixes.
     */
    java.util.List<java.lang.String> getIncludePrefixesList();
    /**
     *
     *
     * <pre>
     * If you specify `include_prefixes`, Storage Transfer Service uses the items
     * in the `include_prefixes` array to determine which objects to include in a
     * transfer. Objects must start with one of the matching `include_prefixes`
     * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
     * objects must not start with any of the `exclude_prefixes` specified for
     * inclusion in the transfer.
     * The following are requirements of `include_prefixes`:
     *   * Each include-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each include-prefix must omit the leading slash. For example, to
     *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the include-prefix as `logs/y=2015/requests.gz`.
     *   * None of the include-prefix values can be empty, if specified.
     *   * Each include-prefix must include a distinct portion of the object
     *     namespace. No include-prefix may be a prefix of another
     *     include-prefix.
     * The max size of `include_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string include_prefixes = 3;</code>
     *
     * @return The count of includePrefixes.
     */
    int getIncludePrefixesCount();
    /**
     *
     *
     * <pre>
     * If you specify `include_prefixes`, Storage Transfer Service uses the items
     * in the `include_prefixes` array to determine which objects to include in a
     * transfer. Objects must start with one of the matching `include_prefixes`
     * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
     * objects must not start with any of the `exclude_prefixes` specified for
     * inclusion in the transfer.
     * The following are requirements of `include_prefixes`:
     *   * Each include-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each include-prefix must omit the leading slash. For example, to
     *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the include-prefix as `logs/y=2015/requests.gz`.
     *   * None of the include-prefix values can be empty, if specified.
     *   * Each include-prefix must include a distinct portion of the object
     *     namespace. No include-prefix may be a prefix of another
     *     include-prefix.
     * The max size of `include_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string include_prefixes = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The includePrefixes at the given index.
     */
    java.lang.String getIncludePrefixes(int index);
    /**
     *
     *
     * <pre>
     * If you specify `include_prefixes`, Storage Transfer Service uses the items
     * in the `include_prefixes` array to determine which objects to include in a
     * transfer. Objects must start with one of the matching `include_prefixes`
     * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
     * objects must not start with any of the `exclude_prefixes` specified for
     * inclusion in the transfer.
     * The following are requirements of `include_prefixes`:
     *   * Each include-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each include-prefix must omit the leading slash. For example, to
     *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the include-prefix as `logs/y=2015/requests.gz`.
     *   * None of the include-prefix values can be empty, if specified.
     *   * Each include-prefix must include a distinct portion of the object
     *     namespace. No include-prefix may be a prefix of another
     *     include-prefix.
     * The max size of `include_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string include_prefixes = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includePrefixes at the given index.
     */
    com.google.protobuf.ByteString getIncludePrefixesBytes(int index);

    /**
     *
     *
     * <pre>
     * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
     * in the `exclude_prefixes` array to determine which objects to exclude from
     * a transfer. Objects must not start with one of the matching
     * `exclude_prefixes` for inclusion in a transfer.
     * The following are requirements of `exclude_prefixes`:
     *   * Each exclude-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each exclude-prefix must omit the leading slash. For example, to
     *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
     *   * None of the exclude-prefix values can be empty, if specified.
     *   * Each exclude-prefix must exclude a distinct portion of the object
     *     namespace. No exclude-prefix may be a prefix of another
     *     exclude-prefix.
     *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
     *   start with the value of a path explicitly included by `include_prefixes`.
     * The max size of `exclude_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string exclude_prefixes = 4;</code>
     *
     * @return A list containing the excludePrefixes.
     */
    java.util.List<java.lang.String> getExcludePrefixesList();
    /**
     *
     *
     * <pre>
     * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
     * in the `exclude_prefixes` array to determine which objects to exclude from
     * a transfer. Objects must not start with one of the matching
     * `exclude_prefixes` for inclusion in a transfer.
     * The following are requirements of `exclude_prefixes`:
     *   * Each exclude-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each exclude-prefix must omit the leading slash. For example, to
     *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
     *   * None of the exclude-prefix values can be empty, if specified.
     *   * Each exclude-prefix must exclude a distinct portion of the object
     *     namespace. No exclude-prefix may be a prefix of another
     *     exclude-prefix.
     *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
     *   start with the value of a path explicitly included by `include_prefixes`.
     * The max size of `exclude_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string exclude_prefixes = 4;</code>
     *
     * @return The count of excludePrefixes.
     */
    int getExcludePrefixesCount();
    /**
     *
     *
     * <pre>
     * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
     * in the `exclude_prefixes` array to determine which objects to exclude from
     * a transfer. Objects must not start with one of the matching
     * `exclude_prefixes` for inclusion in a transfer.
     * The following are requirements of `exclude_prefixes`:
     *   * Each exclude-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each exclude-prefix must omit the leading slash. For example, to
     *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
     *   * None of the exclude-prefix values can be empty, if specified.
     *   * Each exclude-prefix must exclude a distinct portion of the object
     *     namespace. No exclude-prefix may be a prefix of another
     *     exclude-prefix.
     *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
     *   start with the value of a path explicitly included by `include_prefixes`.
     * The max size of `exclude_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string exclude_prefixes = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The excludePrefixes at the given index.
     */
    java.lang.String getExcludePrefixes(int index);
    /**
     *
     *
     * <pre>
     * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
     * in the `exclude_prefixes` array to determine which objects to exclude from
     * a transfer. Objects must not start with one of the matching
     * `exclude_prefixes` for inclusion in a transfer.
     * The following are requirements of `exclude_prefixes`:
     *   * Each exclude-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each exclude-prefix must omit the leading slash. For example, to
     *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
     *   * None of the exclude-prefix values can be empty, if specified.
     *   * Each exclude-prefix must exclude a distinct portion of the object
     *     namespace. No exclude-prefix may be a prefix of another
     *     exclude-prefix.
     *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
     *   start with the value of a path explicitly included by `include_prefixes`.
     * The max size of `exclude_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string exclude_prefixes = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludePrefixes at the given index.
     */
    com.google.protobuf.ByteString getExcludePrefixesBytes(int index);

    /**
     *
     *
     * <pre>
     * If specified, only objects with a "last modification time" on or after
     * this timestamp and objects that don't have a "last modification time" are
     * transferred.
     * The `last_modified_since` and `last_modified_before` fields can be used
     * together for chunked data processing. For example, consider a script that
     * processes each day's worth of data at a time. For that you'd set each
     * of the fields as follows:
     * *  `last_modified_since` to the start of the day
     * *  `last_modified_before` to the end of the day
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
     *
     * @return Whether the lastModifiedSince field is set.
     */
    boolean hasLastModifiedSince();
    /**
     *
     *
     * <pre>
     * If specified, only objects with a "last modification time" on or after
     * this timestamp and objects that don't have a "last modification time" are
     * transferred.
     * The `last_modified_since` and `last_modified_before` fields can be used
     * together for chunked data processing. For example, consider a script that
     * processes each day's worth of data at a time. For that you'd set each
     * of the fields as follows:
     * *  `last_modified_since` to the start of the day
     * *  `last_modified_before` to the end of the day
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
     *
     * @return The lastModifiedSince.
     */
    com.google.protobuf.Timestamp getLastModifiedSince();
    /**
     *
     *
     * <pre>
     * If specified, only objects with a "last modification time" on or after
     * this timestamp and objects that don't have a "last modification time" are
     * transferred.
     * The `last_modified_since` and `last_modified_before` fields can be used
     * together for chunked data processing. For example, consider a script that
     * processes each day's worth of data at a time. For that you'd set each
     * of the fields as follows:
     * *  `last_modified_since` to the start of the day
     * *  `last_modified_before` to the end of the day
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
     */
    com.google.protobuf.TimestampOrBuilder getLastModifiedSinceOrBuilder();

    /**
     *
     *
     * <pre>
     * If specified, only objects with a "last modification time" before this
     * timestamp and objects that don't have a "last modification time" are
     * transferred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
     *
     * @return Whether the lastModifiedBefore field is set.
     */
    boolean hasLastModifiedBefore();
    /**
     *
     *
     * <pre>
     * If specified, only objects with a "last modification time" before this
     * timestamp and objects that don't have a "last modification time" are
     * transferred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
     *
     * @return The lastModifiedBefore.
     */
    com.google.protobuf.Timestamp getLastModifiedBefore();
    /**
     *
     *
     * <pre>
     * If specified, only objects with a "last modification time" before this
     * timestamp and objects that don't have a "last modification time" are
     * transferred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
     */
    com.google.protobuf.TimestampOrBuilder getLastModifiedBeforeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Conditions that determine which objects are transferred. Applies only
   * to Cloud Data Sources such as S3, Azure, and Cloud Storage.
   * The "last modification time" refers to the time of the
   * last change to the object's content or metadata — specifically, this is
   * the `updated` property of Cloud Storage objects, the `LastModified` field
   * of S3 objects, and the `Last-Modified` header of Azure blobs.
   * Transfers with a [PosixFilesystem][google.storagetransfer.v1.PosixFilesystem] source or destination don't support
   * `ObjectConditions`.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.ObjectConditions}
   */
  public static final class ObjectConditions extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.ObjectConditions)
      ObjectConditionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ObjectConditions.newBuilder() to construct.
    private ObjectConditions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ObjectConditions() {
      includePrefixes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      excludePrefixes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ObjectConditions();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_ObjectConditions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_ObjectConditions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions.class,
              com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions.Builder.class);
    }

    public static final int MIN_TIME_ELAPSED_SINCE_LAST_MODIFICATION_FIELD_NUMBER = 1;
    private com.google.protobuf.Duration minTimeElapsedSinceLastModification_;
    /**
     *
     *
     * <pre>
     * Ensures that objects are not transferred until a specific minimum time
     * has elapsed after the "last modification time". When a
     * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
     * transferred only if the elapsed time between the
     * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
     * and the "last modification time" of the object is equal to or
     * greater than the value of min_time_elapsed_since_last_modification`.
     * Objects that do not have a "last modification time" are also transferred.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
     *
     * @return Whether the minTimeElapsedSinceLastModification field is set.
     */
    @java.lang.Override
    public boolean hasMinTimeElapsedSinceLastModification() {
      return minTimeElapsedSinceLastModification_ != null;
    }
    /**
     *
     *
     * <pre>
     * Ensures that objects are not transferred until a specific minimum time
     * has elapsed after the "last modification time". When a
     * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
     * transferred only if the elapsed time between the
     * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
     * and the "last modification time" of the object is equal to or
     * greater than the value of min_time_elapsed_since_last_modification`.
     * Objects that do not have a "last modification time" are also transferred.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
     *
     * @return The minTimeElapsedSinceLastModification.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMinTimeElapsedSinceLastModification() {
      return minTimeElapsedSinceLastModification_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : minTimeElapsedSinceLastModification_;
    }
    /**
     *
     *
     * <pre>
     * Ensures that objects are not transferred until a specific minimum time
     * has elapsed after the "last modification time". When a
     * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
     * transferred only if the elapsed time between the
     * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
     * and the "last modification time" of the object is equal to or
     * greater than the value of min_time_elapsed_since_last_modification`.
     * Objects that do not have a "last modification time" are also transferred.
     * </pre>
     *
     * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMinTimeElapsedSinceLastModificationOrBuilder() {
      return getMinTimeElapsedSinceLastModification();
    }

    public static final int MAX_TIME_ELAPSED_SINCE_LAST_MODIFICATION_FIELD_NUMBER = 2;
    private com.google.protobuf.Duration maxTimeElapsedSinceLastModification_;
    /**
     *
     *
     * <pre>
     * Ensures that objects are not transferred if a specific maximum time
     * has elapsed since the "last modification time".
     * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
     * "last modification time" are transferred only if the elapsed time
     * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
     * `TransferOperation`and the "last modification time" of the object
     *  is less than the value of max_time_elapsed_since_last_modification`.
     * Objects that do not have a "last modification time" are also transferred.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
     *
     * @return Whether the maxTimeElapsedSinceLastModification field is set.
     */
    @java.lang.Override
    public boolean hasMaxTimeElapsedSinceLastModification() {
      return maxTimeElapsedSinceLastModification_ != null;
    }
    /**
     *
     *
     * <pre>
     * Ensures that objects are not transferred if a specific maximum time
     * has elapsed since the "last modification time".
     * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
     * "last modification time" are transferred only if the elapsed time
     * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
     * `TransferOperation`and the "last modification time" of the object
     *  is less than the value of max_time_elapsed_since_last_modification`.
     * Objects that do not have a "last modification time" are also transferred.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
     *
     * @return The maxTimeElapsedSinceLastModification.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMaxTimeElapsedSinceLastModification() {
      return maxTimeElapsedSinceLastModification_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : maxTimeElapsedSinceLastModification_;
    }
    /**
     *
     *
     * <pre>
     * Ensures that objects are not transferred if a specific maximum time
     * has elapsed since the "last modification time".
     * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
     * "last modification time" are transferred only if the elapsed time
     * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
     * `TransferOperation`and the "last modification time" of the object
     *  is less than the value of max_time_elapsed_since_last_modification`.
     * Objects that do not have a "last modification time" are also transferred.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMaxTimeElapsedSinceLastModificationOrBuilder() {
      return getMaxTimeElapsedSinceLastModification();
    }

    public static final int INCLUDE_PREFIXES_FIELD_NUMBER = 3;
    private com.google.protobuf.LazyStringList includePrefixes_;
    /**
     *
     *
     * <pre>
     * If you specify `include_prefixes`, Storage Transfer Service uses the items
     * in the `include_prefixes` array to determine which objects to include in a
     * transfer. Objects must start with one of the matching `include_prefixes`
     * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
     * objects must not start with any of the `exclude_prefixes` specified for
     * inclusion in the transfer.
     * The following are requirements of `include_prefixes`:
     *   * Each include-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each include-prefix must omit the leading slash. For example, to
     *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the include-prefix as `logs/y=2015/requests.gz`.
     *   * None of the include-prefix values can be empty, if specified.
     *   * Each include-prefix must include a distinct portion of the object
     *     namespace. No include-prefix may be a prefix of another
     *     include-prefix.
     * The max size of `include_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string include_prefixes = 3;</code>
     *
     * @return A list containing the includePrefixes.
     */
    public com.google.protobuf.ProtocolStringList getIncludePrefixesList() {
      return includePrefixes_;
    }
    /**
     *
     *
     * <pre>
     * If you specify `include_prefixes`, Storage Transfer Service uses the items
     * in the `include_prefixes` array to determine which objects to include in a
     * transfer. Objects must start with one of the matching `include_prefixes`
     * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
     * objects must not start with any of the `exclude_prefixes` specified for
     * inclusion in the transfer.
     * The following are requirements of `include_prefixes`:
     *   * Each include-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each include-prefix must omit the leading slash. For example, to
     *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the include-prefix as `logs/y=2015/requests.gz`.
     *   * None of the include-prefix values can be empty, if specified.
     *   * Each include-prefix must include a distinct portion of the object
     *     namespace. No include-prefix may be a prefix of another
     *     include-prefix.
     * The max size of `include_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string include_prefixes = 3;</code>
     *
     * @return The count of includePrefixes.
     */
    public int getIncludePrefixesCount() {
      return includePrefixes_.size();
    }
    /**
     *
     *
     * <pre>
     * If you specify `include_prefixes`, Storage Transfer Service uses the items
     * in the `include_prefixes` array to determine which objects to include in a
     * transfer. Objects must start with one of the matching `include_prefixes`
     * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
     * objects must not start with any of the `exclude_prefixes` specified for
     * inclusion in the transfer.
     * The following are requirements of `include_prefixes`:
     *   * Each include-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each include-prefix must omit the leading slash. For example, to
     *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the include-prefix as `logs/y=2015/requests.gz`.
     *   * None of the include-prefix values can be empty, if specified.
     *   * Each include-prefix must include a distinct portion of the object
     *     namespace. No include-prefix may be a prefix of another
     *     include-prefix.
     * The max size of `include_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string include_prefixes = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The includePrefixes at the given index.
     */
    public java.lang.String getIncludePrefixes(int index) {
      return includePrefixes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * If you specify `include_prefixes`, Storage Transfer Service uses the items
     * in the `include_prefixes` array to determine which objects to include in a
     * transfer. Objects must start with one of the matching `include_prefixes`
     * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
     * objects must not start with any of the `exclude_prefixes` specified for
     * inclusion in the transfer.
     * The following are requirements of `include_prefixes`:
     *   * Each include-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each include-prefix must omit the leading slash. For example, to
     *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the include-prefix as `logs/y=2015/requests.gz`.
     *   * None of the include-prefix values can be empty, if specified.
     *   * Each include-prefix must include a distinct portion of the object
     *     namespace. No include-prefix may be a prefix of another
     *     include-prefix.
     * The max size of `include_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string include_prefixes = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includePrefixes at the given index.
     */
    public com.google.protobuf.ByteString getIncludePrefixesBytes(int index) {
      return includePrefixes_.getByteString(index);
    }

    public static final int EXCLUDE_PREFIXES_FIELD_NUMBER = 4;
    private com.google.protobuf.LazyStringList excludePrefixes_;
    /**
     *
     *
     * <pre>
     * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
     * in the `exclude_prefixes` array to determine which objects to exclude from
     * a transfer. Objects must not start with one of the matching
     * `exclude_prefixes` for inclusion in a transfer.
     * The following are requirements of `exclude_prefixes`:
     *   * Each exclude-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each exclude-prefix must omit the leading slash. For example, to
     *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
     *   * None of the exclude-prefix values can be empty, if specified.
     *   * Each exclude-prefix must exclude a distinct portion of the object
     *     namespace. No exclude-prefix may be a prefix of another
     *     exclude-prefix.
     *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
     *   start with the value of a path explicitly included by `include_prefixes`.
     * The max size of `exclude_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string exclude_prefixes = 4;</code>
     *
     * @return A list containing the excludePrefixes.
     */
    public com.google.protobuf.ProtocolStringList getExcludePrefixesList() {
      return excludePrefixes_;
    }
    /**
     *
     *
     * <pre>
     * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
     * in the `exclude_prefixes` array to determine which objects to exclude from
     * a transfer. Objects must not start with one of the matching
     * `exclude_prefixes` for inclusion in a transfer.
     * The following are requirements of `exclude_prefixes`:
     *   * Each exclude-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each exclude-prefix must omit the leading slash. For example, to
     *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
     *   * None of the exclude-prefix values can be empty, if specified.
     *   * Each exclude-prefix must exclude a distinct portion of the object
     *     namespace. No exclude-prefix may be a prefix of another
     *     exclude-prefix.
     *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
     *   start with the value of a path explicitly included by `include_prefixes`.
     * The max size of `exclude_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string exclude_prefixes = 4;</code>
     *
     * @return The count of excludePrefixes.
     */
    public int getExcludePrefixesCount() {
      return excludePrefixes_.size();
    }
    /**
     *
     *
     * <pre>
     * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
     * in the `exclude_prefixes` array to determine which objects to exclude from
     * a transfer. Objects must not start with one of the matching
     * `exclude_prefixes` for inclusion in a transfer.
     * The following are requirements of `exclude_prefixes`:
     *   * Each exclude-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each exclude-prefix must omit the leading slash. For example, to
     *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
     *   * None of the exclude-prefix values can be empty, if specified.
     *   * Each exclude-prefix must exclude a distinct portion of the object
     *     namespace. No exclude-prefix may be a prefix of another
     *     exclude-prefix.
     *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
     *   start with the value of a path explicitly included by `include_prefixes`.
     * The max size of `exclude_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string exclude_prefixes = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The excludePrefixes at the given index.
     */
    public java.lang.String getExcludePrefixes(int index) {
      return excludePrefixes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
     * in the `exclude_prefixes` array to determine which objects to exclude from
     * a transfer. Objects must not start with one of the matching
     * `exclude_prefixes` for inclusion in a transfer.
     * The following are requirements of `exclude_prefixes`:
     *   * Each exclude-prefix can contain any sequence of Unicode characters, to
     *     a max length of 1024 bytes when UTF8-encoded, and must not contain
     *     Carriage Return or Line Feed characters.  Wildcard matching and regular
     *     expression matching are not supported.
     *   * Each exclude-prefix must omit the leading slash. For example, to
     *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
     *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
     *   * None of the exclude-prefix values can be empty, if specified.
     *   * Each exclude-prefix must exclude a distinct portion of the object
     *     namespace. No exclude-prefix may be a prefix of another
     *     exclude-prefix.
     *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
     *   start with the value of a path explicitly included by `include_prefixes`.
     * The max size of `exclude_prefixes` is 1000.
     * For more information, see [Filtering objects from
     * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
     * </pre>
     *
     * <code>repeated string exclude_prefixes = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludePrefixes at the given index.
     */
    public com.google.protobuf.ByteString getExcludePrefixesBytes(int index) {
      return excludePrefixes_.getByteString(index);
    }

    public static final int LAST_MODIFIED_SINCE_FIELD_NUMBER = 5;
    private com.google.protobuf.Timestamp lastModifiedSince_;
    /**
     *
     *
     * <pre>
     * If specified, only objects with a "last modification time" on or after
     * this timestamp and objects that don't have a "last modification time" are
     * transferred.
     * The `last_modified_since` and `last_modified_before` fields can be used
     * together for chunked data processing. For example, consider a script that
     * processes each day's worth of data at a time. For that you'd set each
     * of the fields as follows:
     * *  `last_modified_since` to the start of the day
     * *  `last_modified_before` to the end of the day
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
     *
     * @return Whether the lastModifiedSince field is set.
     */
    @java.lang.Override
    public boolean hasLastModifiedSince() {
      return lastModifiedSince_ != null;
    }
    /**
     *
     *
     * <pre>
     * If specified, only objects with a "last modification time" on or after
     * this timestamp and objects that don't have a "last modification time" are
     * transferred.
     * The `last_modified_since` and `last_modified_before` fields can be used
     * together for chunked data processing. For example, consider a script that
     * processes each day's worth of data at a time. For that you'd set each
     * of the fields as follows:
     * *  `last_modified_since` to the start of the day
     * *  `last_modified_before` to the end of the day
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
     *
     * @return The lastModifiedSince.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getLastModifiedSince() {
      return lastModifiedSince_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastModifiedSince_;
    }
    /**
     *
     *
     * <pre>
     * If specified, only objects with a "last modification time" on or after
     * this timestamp and objects that don't have a "last modification time" are
     * transferred.
     * The `last_modified_since` and `last_modified_before` fields can be used
     * together for chunked data processing. For example, consider a script that
     * processes each day's worth of data at a time. For that you'd set each
     * of the fields as follows:
     * *  `last_modified_since` to the start of the day
     * *  `last_modified_before` to the end of the day
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getLastModifiedSinceOrBuilder() {
      return getLastModifiedSince();
    }

    public static final int LAST_MODIFIED_BEFORE_FIELD_NUMBER = 6;
    private com.google.protobuf.Timestamp lastModifiedBefore_;
    /**
     *
     *
     * <pre>
     * If specified, only objects with a "last modification time" before this
     * timestamp and objects that don't have a "last modification time" are
     * transferred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
     *
     * @return Whether the lastModifiedBefore field is set.
     */
    @java.lang.Override
    public boolean hasLastModifiedBefore() {
      return lastModifiedBefore_ != null;
    }
    /**
     *
     *
     * <pre>
     * If specified, only objects with a "last modification time" before this
     * timestamp and objects that don't have a "last modification time" are
     * transferred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
     *
     * @return The lastModifiedBefore.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getLastModifiedBefore() {
      return lastModifiedBefore_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : lastModifiedBefore_;
    }
    /**
     *
     *
     * <pre>
     * If specified, only objects with a "last modification time" before this
     * timestamp and objects that don't have a "last modification time" are
     * transferred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getLastModifiedBeforeOrBuilder() {
      return getLastModifiedBefore();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (minTimeElapsedSinceLastModification_ != null) {
        output.writeMessage(1, getMinTimeElapsedSinceLastModification());
      }
      if (maxTimeElapsedSinceLastModification_ != null) {
        output.writeMessage(2, getMaxTimeElapsedSinceLastModification());
      }
      for (int i = 0; i < includePrefixes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, includePrefixes_.getRaw(i));
      }
      for (int i = 0; i < excludePrefixes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, excludePrefixes_.getRaw(i));
      }
      if (lastModifiedSince_ != null) {
        output.writeMessage(5, getLastModifiedSince());
      }
      if (lastModifiedBefore_ != null) {
        output.writeMessage(6, getLastModifiedBefore());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (minTimeElapsedSinceLastModification_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, getMinTimeElapsedSinceLastModification());
      }
      if (maxTimeElapsedSinceLastModification_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, getMaxTimeElapsedSinceLastModification());
      }
      {
        int dataSize = 0;
        for (int i = 0; i < includePrefixes_.size(); i++) {
          dataSize += computeStringSizeNoTag(includePrefixes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getIncludePrefixesList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < excludePrefixes_.size(); i++) {
          dataSize += computeStringSizeNoTag(excludePrefixes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExcludePrefixesList().size();
      }
      if (lastModifiedSince_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getLastModifiedSince());
      }
      if (lastModifiedBefore_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(6, getLastModifiedBefore());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions other =
          (com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions) obj;

      if (hasMinTimeElapsedSinceLastModification()
          != other.hasMinTimeElapsedSinceLastModification()) return false;
      if (hasMinTimeElapsedSinceLastModification()) {
        if (!getMinTimeElapsedSinceLastModification()
            .equals(other.getMinTimeElapsedSinceLastModification())) return false;
      }
      if (hasMaxTimeElapsedSinceLastModification()
          != other.hasMaxTimeElapsedSinceLastModification()) return false;
      if (hasMaxTimeElapsedSinceLastModification()) {
        if (!getMaxTimeElapsedSinceLastModification()
            .equals(other.getMaxTimeElapsedSinceLastModification())) return false;
      }
      if (!getIncludePrefixesList().equals(other.getIncludePrefixesList())) return false;
      if (!getExcludePrefixesList().equals(other.getExcludePrefixesList())) return false;
      if (hasLastModifiedSince() != other.hasLastModifiedSince()) return false;
      if (hasLastModifiedSince()) {
        if (!getLastModifiedSince().equals(other.getLastModifiedSince())) return false;
      }
      if (hasLastModifiedBefore() != other.hasLastModifiedBefore()) return false;
      if (hasLastModifiedBefore()) {
        if (!getLastModifiedBefore().equals(other.getLastModifiedBefore())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMinTimeElapsedSinceLastModification()) {
        hash = (37 * hash) + MIN_TIME_ELAPSED_SINCE_LAST_MODIFICATION_FIELD_NUMBER;
        hash = (53 * hash) + getMinTimeElapsedSinceLastModification().hashCode();
      }
      if (hasMaxTimeElapsedSinceLastModification()) {
        hash = (37 * hash) + MAX_TIME_ELAPSED_SINCE_LAST_MODIFICATION_FIELD_NUMBER;
        hash = (53 * hash) + getMaxTimeElapsedSinceLastModification().hashCode();
      }
      if (getIncludePrefixesCount() > 0) {
        hash = (37 * hash) + INCLUDE_PREFIXES_FIELD_NUMBER;
        hash = (53 * hash) + getIncludePrefixesList().hashCode();
      }
      if (getExcludePrefixesCount() > 0) {
        hash = (37 * hash) + EXCLUDE_PREFIXES_FIELD_NUMBER;
        hash = (53 * hash) + getExcludePrefixesList().hashCode();
      }
      if (hasLastModifiedSince()) {
        hash = (37 * hash) + LAST_MODIFIED_SINCE_FIELD_NUMBER;
        hash = (53 * hash) + getLastModifiedSince().hashCode();
      }
      if (hasLastModifiedBefore()) {
        hash = (37 * hash) + LAST_MODIFIED_BEFORE_FIELD_NUMBER;
        hash = (53 * hash) + getLastModifiedBefore().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Conditions that determine which objects are transferred. Applies only
     * to Cloud Data Sources such as S3, Azure, and Cloud Storage.
     * The "last modification time" refers to the time of the
     * last change to the object's content or metadata — specifically, this is
     * the `updated` property of Cloud Storage objects, the `LastModified` field
     * of S3 objects, and the `Last-Modified` header of Azure blobs.
     * Transfers with a [PosixFilesystem][google.storagetransfer.v1.PosixFilesystem] source or destination don't support
     * `ObjectConditions`.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.ObjectConditions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.ObjectConditions)
        com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_ObjectConditions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_ObjectConditions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions.class,
                com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions.Builder.class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (minTimeElapsedSinceLastModificationBuilder_ == null) {
          minTimeElapsedSinceLastModification_ = null;
        } else {
          minTimeElapsedSinceLastModification_ = null;
          minTimeElapsedSinceLastModificationBuilder_ = null;
        }
        if (maxTimeElapsedSinceLastModificationBuilder_ == null) {
          maxTimeElapsedSinceLastModification_ = null;
        } else {
          maxTimeElapsedSinceLastModification_ = null;
          maxTimeElapsedSinceLastModificationBuilder_ = null;
        }
        includePrefixes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        excludePrefixes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (lastModifiedSinceBuilder_ == null) {
          lastModifiedSince_ = null;
        } else {
          lastModifiedSince_ = null;
          lastModifiedSinceBuilder_ = null;
        }
        if (lastModifiedBeforeBuilder_ == null) {
          lastModifiedBefore_ = null;
        } else {
          lastModifiedBefore_ = null;
          lastModifiedBeforeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_ObjectConditions_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions build() {
        com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions result =
            new com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions(this);
        int from_bitField0_ = bitField0_;
        if (minTimeElapsedSinceLastModificationBuilder_ == null) {
          result.minTimeElapsedSinceLastModification_ = minTimeElapsedSinceLastModification_;
        } else {
          result.minTimeElapsedSinceLastModification_ =
              minTimeElapsedSinceLastModificationBuilder_.build();
        }
        if (maxTimeElapsedSinceLastModificationBuilder_ == null) {
          result.maxTimeElapsedSinceLastModification_ = maxTimeElapsedSinceLastModification_;
        } else {
          result.maxTimeElapsedSinceLastModification_ =
              maxTimeElapsedSinceLastModificationBuilder_.build();
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          includePrefixes_ = includePrefixes_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.includePrefixes_ = includePrefixes_;
        if (((bitField0_ & 0x00000002) != 0)) {
          excludePrefixes_ = excludePrefixes_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.excludePrefixes_ = excludePrefixes_;
        if (lastModifiedSinceBuilder_ == null) {
          result.lastModifiedSince_ = lastModifiedSince_;
        } else {
          result.lastModifiedSince_ = lastModifiedSinceBuilder_.build();
        }
        if (lastModifiedBeforeBuilder_ == null) {
          result.lastModifiedBefore_ = lastModifiedBefore_;
        } else {
          result.lastModifiedBefore_ = lastModifiedBeforeBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions
                .getDefaultInstance()) return this;
        if (other.hasMinTimeElapsedSinceLastModification()) {
          mergeMinTimeElapsedSinceLastModification(other.getMinTimeElapsedSinceLastModification());
        }
        if (other.hasMaxTimeElapsedSinceLastModification()) {
          mergeMaxTimeElapsedSinceLastModification(other.getMaxTimeElapsedSinceLastModification());
        }
        if (!other.includePrefixes_.isEmpty()) {
          if (includePrefixes_.isEmpty()) {
            includePrefixes_ = other.includePrefixes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureIncludePrefixesIsMutable();
            includePrefixes_.addAll(other.includePrefixes_);
          }
          onChanged();
        }
        if (!other.excludePrefixes_.isEmpty()) {
          if (excludePrefixes_.isEmpty()) {
            excludePrefixes_ = other.excludePrefixes_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureExcludePrefixesIsMutable();
            excludePrefixes_.addAll(other.excludePrefixes_);
          }
          onChanged();
        }
        if (other.hasLastModifiedSince()) {
          mergeLastModifiedSince(other.getLastModifiedSince());
        }
        if (other.hasLastModifiedBefore()) {
          mergeLastModifiedBefore(other.getLastModifiedBefore());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getMinTimeElapsedSinceLastModificationFieldBuilder().getBuilder(),
                      extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getMaxTimeElapsedSinceLastModificationFieldBuilder().getBuilder(),
                      extensionRegistry);

                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureIncludePrefixesIsMutable();
                  includePrefixes_.add(s);
                  break;
                } // case 26
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureExcludePrefixesIsMutable();
                  excludePrefixes_.add(s);
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getLastModifiedSinceFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getLastModifiedBeforeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Duration minTimeElapsedSinceLastModification_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          minTimeElapsedSinceLastModificationBuilder_;
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred until a specific minimum time
       * has elapsed after the "last modification time". When a
       * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
       * transferred only if the elapsed time between the
       * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
       * and the "last modification time" of the object is equal to or
       * greater than the value of min_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
       *
       * @return Whether the minTimeElapsedSinceLastModification field is set.
       */
      public boolean hasMinTimeElapsedSinceLastModification() {
        return minTimeElapsedSinceLastModificationBuilder_ != null
            || minTimeElapsedSinceLastModification_ != null;
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred until a specific minimum time
       * has elapsed after the "last modification time". When a
       * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
       * transferred only if the elapsed time between the
       * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
       * and the "last modification time" of the object is equal to or
       * greater than the value of min_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
       *
       * @return The minTimeElapsedSinceLastModification.
       */
      public com.google.protobuf.Duration getMinTimeElapsedSinceLastModification() {
        if (minTimeElapsedSinceLastModificationBuilder_ == null) {
          return minTimeElapsedSinceLastModification_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : minTimeElapsedSinceLastModification_;
        } else {
          return minTimeElapsedSinceLastModificationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred until a specific minimum time
       * has elapsed after the "last modification time". When a
       * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
       * transferred only if the elapsed time between the
       * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
       * and the "last modification time" of the object is equal to or
       * greater than the value of min_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
       */
      public Builder setMinTimeElapsedSinceLastModification(com.google.protobuf.Duration value) {
        if (minTimeElapsedSinceLastModificationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          minTimeElapsedSinceLastModification_ = value;
          onChanged();
        } else {
          minTimeElapsedSinceLastModificationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred until a specific minimum time
       * has elapsed after the "last modification time". When a
       * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
       * transferred only if the elapsed time between the
       * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
       * and the "last modification time" of the object is equal to or
       * greater than the value of min_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
       */
      public Builder setMinTimeElapsedSinceLastModification(
          com.google.protobuf.Duration.Builder builderForValue) {
        if (minTimeElapsedSinceLastModificationBuilder_ == null) {
          minTimeElapsedSinceLastModification_ = builderForValue.build();
          onChanged();
        } else {
          minTimeElapsedSinceLastModificationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred until a specific minimum time
       * has elapsed after the "last modification time". When a
       * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
       * transferred only if the elapsed time between the
       * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
       * and the "last modification time" of the object is equal to or
       * greater than the value of min_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
       */
      public Builder mergeMinTimeElapsedSinceLastModification(com.google.protobuf.Duration value) {
        if (minTimeElapsedSinceLastModificationBuilder_ == null) {
          if (minTimeElapsedSinceLastModification_ != null) {
            minTimeElapsedSinceLastModification_ =
                com.google.protobuf.Duration.newBuilder(minTimeElapsedSinceLastModification_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            minTimeElapsedSinceLastModification_ = value;
          }
          onChanged();
        } else {
          minTimeElapsedSinceLastModificationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred until a specific minimum time
       * has elapsed after the "last modification time". When a
       * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
       * transferred only if the elapsed time between the
       * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
       * and the "last modification time" of the object is equal to or
       * greater than the value of min_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
       */
      public Builder clearMinTimeElapsedSinceLastModification() {
        if (minTimeElapsedSinceLastModificationBuilder_ == null) {
          minTimeElapsedSinceLastModification_ = null;
          onChanged();
        } else {
          minTimeElapsedSinceLastModification_ = null;
          minTimeElapsedSinceLastModificationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred until a specific minimum time
       * has elapsed after the "last modification time". When a
       * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
       * transferred only if the elapsed time between the
       * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
       * and the "last modification time" of the object is equal to or
       * greater than the value of min_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
       */
      public com.google.protobuf.Duration.Builder getMinTimeElapsedSinceLastModificationBuilder() {

        onChanged();
        return getMinTimeElapsedSinceLastModificationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred until a specific minimum time
       * has elapsed after the "last modification time". When a
       * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
       * transferred only if the elapsed time between the
       * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
       * and the "last modification time" of the object is equal to or
       * greater than the value of min_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
       */
      public com.google.protobuf.DurationOrBuilder
          getMinTimeElapsedSinceLastModificationOrBuilder() {
        if (minTimeElapsedSinceLastModificationBuilder_ != null) {
          return minTimeElapsedSinceLastModificationBuilder_.getMessageOrBuilder();
        } else {
          return minTimeElapsedSinceLastModification_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : minTimeElapsedSinceLastModification_;
        }
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred until a specific minimum time
       * has elapsed after the "last modification time". When a
       * [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a "last modification time" are
       * transferred only if the elapsed time between the
       * [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the `TransferOperation`
       * and the "last modification time" of the object is equal to or
       * greater than the value of min_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration min_time_elapsed_since_last_modification = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMinTimeElapsedSinceLastModificationFieldBuilder() {
        if (minTimeElapsedSinceLastModificationBuilder_ == null) {
          minTimeElapsedSinceLastModificationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getMinTimeElapsedSinceLastModification(), getParentForChildren(), isClean());
          minTimeElapsedSinceLastModification_ = null;
        }
        return minTimeElapsedSinceLastModificationBuilder_;
      }

      private com.google.protobuf.Duration maxTimeElapsedSinceLastModification_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          maxTimeElapsedSinceLastModificationBuilder_;
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred if a specific maximum time
       * has elapsed since the "last modification time".
       * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
       * "last modification time" are transferred only if the elapsed time
       * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
       * `TransferOperation`and the "last modification time" of the object
       *  is less than the value of max_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
       *
       * @return Whether the maxTimeElapsedSinceLastModification field is set.
       */
      public boolean hasMaxTimeElapsedSinceLastModification() {
        return maxTimeElapsedSinceLastModificationBuilder_ != null
            || maxTimeElapsedSinceLastModification_ != null;
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred if a specific maximum time
       * has elapsed since the "last modification time".
       * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
       * "last modification time" are transferred only if the elapsed time
       * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
       * `TransferOperation`and the "last modification time" of the object
       *  is less than the value of max_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
       *
       * @return The maxTimeElapsedSinceLastModification.
       */
      public com.google.protobuf.Duration getMaxTimeElapsedSinceLastModification() {
        if (maxTimeElapsedSinceLastModificationBuilder_ == null) {
          return maxTimeElapsedSinceLastModification_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : maxTimeElapsedSinceLastModification_;
        } else {
          return maxTimeElapsedSinceLastModificationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred if a specific maximum time
       * has elapsed since the "last modification time".
       * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
       * "last modification time" are transferred only if the elapsed time
       * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
       * `TransferOperation`and the "last modification time" of the object
       *  is less than the value of max_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
       */
      public Builder setMaxTimeElapsedSinceLastModification(com.google.protobuf.Duration value) {
        if (maxTimeElapsedSinceLastModificationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maxTimeElapsedSinceLastModification_ = value;
          onChanged();
        } else {
          maxTimeElapsedSinceLastModificationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred if a specific maximum time
       * has elapsed since the "last modification time".
       * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
       * "last modification time" are transferred only if the elapsed time
       * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
       * `TransferOperation`and the "last modification time" of the object
       *  is less than the value of max_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
       */
      public Builder setMaxTimeElapsedSinceLastModification(
          com.google.protobuf.Duration.Builder builderForValue) {
        if (maxTimeElapsedSinceLastModificationBuilder_ == null) {
          maxTimeElapsedSinceLastModification_ = builderForValue.build();
          onChanged();
        } else {
          maxTimeElapsedSinceLastModificationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred if a specific maximum time
       * has elapsed since the "last modification time".
       * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
       * "last modification time" are transferred only if the elapsed time
       * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
       * `TransferOperation`and the "last modification time" of the object
       *  is less than the value of max_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
       */
      public Builder mergeMaxTimeElapsedSinceLastModification(com.google.protobuf.Duration value) {
        if (maxTimeElapsedSinceLastModificationBuilder_ == null) {
          if (maxTimeElapsedSinceLastModification_ != null) {
            maxTimeElapsedSinceLastModification_ =
                com.google.protobuf.Duration.newBuilder(maxTimeElapsedSinceLastModification_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            maxTimeElapsedSinceLastModification_ = value;
          }
          onChanged();
        } else {
          maxTimeElapsedSinceLastModificationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred if a specific maximum time
       * has elapsed since the "last modification time".
       * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
       * "last modification time" are transferred only if the elapsed time
       * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
       * `TransferOperation`and the "last modification time" of the object
       *  is less than the value of max_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
       */
      public Builder clearMaxTimeElapsedSinceLastModification() {
        if (maxTimeElapsedSinceLastModificationBuilder_ == null) {
          maxTimeElapsedSinceLastModification_ = null;
          onChanged();
        } else {
          maxTimeElapsedSinceLastModification_ = null;
          maxTimeElapsedSinceLastModificationBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred if a specific maximum time
       * has elapsed since the "last modification time".
       * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
       * "last modification time" are transferred only if the elapsed time
       * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
       * `TransferOperation`and the "last modification time" of the object
       *  is less than the value of max_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
       */
      public com.google.protobuf.Duration.Builder getMaxTimeElapsedSinceLastModificationBuilder() {

        onChanged();
        return getMaxTimeElapsedSinceLastModificationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred if a specific maximum time
       * has elapsed since the "last modification time".
       * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
       * "last modification time" are transferred only if the elapsed time
       * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
       * `TransferOperation`and the "last modification time" of the object
       *  is less than the value of max_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
       */
      public com.google.protobuf.DurationOrBuilder
          getMaxTimeElapsedSinceLastModificationOrBuilder() {
        if (maxTimeElapsedSinceLastModificationBuilder_ != null) {
          return maxTimeElapsedSinceLastModificationBuilder_.getMessageOrBuilder();
        } else {
          return maxTimeElapsedSinceLastModification_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : maxTimeElapsedSinceLastModification_;
        }
      }
      /**
       *
       *
       * <pre>
       * Ensures that objects are not transferred if a specific maximum time
       * has elapsed since the "last modification time".
       * When a [TransferOperation][google.storagetransfer.v1.TransferOperation] begins, objects with a
       * "last modification time" are transferred only if the elapsed time
       * between the [start_time][google.storagetransfer.v1.TransferOperation.start_time] of the
       * `TransferOperation`and the "last modification time" of the object
       *  is less than the value of max_time_elapsed_since_last_modification`.
       * Objects that do not have a "last modification time" are also transferred.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_time_elapsed_since_last_modification = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMaxTimeElapsedSinceLastModificationFieldBuilder() {
        if (maxTimeElapsedSinceLastModificationBuilder_ == null) {
          maxTimeElapsedSinceLastModificationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getMaxTimeElapsedSinceLastModification(), getParentForChildren(), isClean());
          maxTimeElapsedSinceLastModification_ = null;
        }
        return maxTimeElapsedSinceLastModificationBuilder_;
      }

      private com.google.protobuf.LazyStringList includePrefixes_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureIncludePrefixesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          includePrefixes_ = new com.google.protobuf.LazyStringArrayList(includePrefixes_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * If you specify `include_prefixes`, Storage Transfer Service uses the items
       * in the `include_prefixes` array to determine which objects to include in a
       * transfer. Objects must start with one of the matching `include_prefixes`
       * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
       * objects must not start with any of the `exclude_prefixes` specified for
       * inclusion in the transfer.
       * The following are requirements of `include_prefixes`:
       *   * Each include-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each include-prefix must omit the leading slash. For example, to
       *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the include-prefix as `logs/y=2015/requests.gz`.
       *   * None of the include-prefix values can be empty, if specified.
       *   * Each include-prefix must include a distinct portion of the object
       *     namespace. No include-prefix may be a prefix of another
       *     include-prefix.
       * The max size of `include_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string include_prefixes = 3;</code>
       *
       * @return A list containing the includePrefixes.
       */
      public com.google.protobuf.ProtocolStringList getIncludePrefixesList() {
        return includePrefixes_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * If you specify `include_prefixes`, Storage Transfer Service uses the items
       * in the `include_prefixes` array to determine which objects to include in a
       * transfer. Objects must start with one of the matching `include_prefixes`
       * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
       * objects must not start with any of the `exclude_prefixes` specified for
       * inclusion in the transfer.
       * The following are requirements of `include_prefixes`:
       *   * Each include-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each include-prefix must omit the leading slash. For example, to
       *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the include-prefix as `logs/y=2015/requests.gz`.
       *   * None of the include-prefix values can be empty, if specified.
       *   * Each include-prefix must include a distinct portion of the object
       *     namespace. No include-prefix may be a prefix of another
       *     include-prefix.
       * The max size of `include_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string include_prefixes = 3;</code>
       *
       * @return The count of includePrefixes.
       */
      public int getIncludePrefixesCount() {
        return includePrefixes_.size();
      }
      /**
       *
       *
       * <pre>
       * If you specify `include_prefixes`, Storage Transfer Service uses the items
       * in the `include_prefixes` array to determine which objects to include in a
       * transfer. Objects must start with one of the matching `include_prefixes`
       * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
       * objects must not start with any of the `exclude_prefixes` specified for
       * inclusion in the transfer.
       * The following are requirements of `include_prefixes`:
       *   * Each include-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each include-prefix must omit the leading slash. For example, to
       *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the include-prefix as `logs/y=2015/requests.gz`.
       *   * None of the include-prefix values can be empty, if specified.
       *   * Each include-prefix must include a distinct portion of the object
       *     namespace. No include-prefix may be a prefix of another
       *     include-prefix.
       * The max size of `include_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string include_prefixes = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The includePrefixes at the given index.
       */
      public java.lang.String getIncludePrefixes(int index) {
        return includePrefixes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * If you specify `include_prefixes`, Storage Transfer Service uses the items
       * in the `include_prefixes` array to determine which objects to include in a
       * transfer. Objects must start with one of the matching `include_prefixes`
       * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
       * objects must not start with any of the `exclude_prefixes` specified for
       * inclusion in the transfer.
       * The following are requirements of `include_prefixes`:
       *   * Each include-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each include-prefix must omit the leading slash. For example, to
       *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the include-prefix as `logs/y=2015/requests.gz`.
       *   * None of the include-prefix values can be empty, if specified.
       *   * Each include-prefix must include a distinct portion of the object
       *     namespace. No include-prefix may be a prefix of another
       *     include-prefix.
       * The max size of `include_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string include_prefixes = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the includePrefixes at the given index.
       */
      public com.google.protobuf.ByteString getIncludePrefixesBytes(int index) {
        return includePrefixes_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * If you specify `include_prefixes`, Storage Transfer Service uses the items
       * in the `include_prefixes` array to determine which objects to include in a
       * transfer. Objects must start with one of the matching `include_prefixes`
       * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
       * objects must not start with any of the `exclude_prefixes` specified for
       * inclusion in the transfer.
       * The following are requirements of `include_prefixes`:
       *   * Each include-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each include-prefix must omit the leading slash. For example, to
       *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the include-prefix as `logs/y=2015/requests.gz`.
       *   * None of the include-prefix values can be empty, if specified.
       *   * Each include-prefix must include a distinct portion of the object
       *     namespace. No include-prefix may be a prefix of another
       *     include-prefix.
       * The max size of `include_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string include_prefixes = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The includePrefixes to set.
       * @return This builder for chaining.
       */
      public Builder setIncludePrefixes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludePrefixesIsMutable();
        includePrefixes_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If you specify `include_prefixes`, Storage Transfer Service uses the items
       * in the `include_prefixes` array to determine which objects to include in a
       * transfer. Objects must start with one of the matching `include_prefixes`
       * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
       * objects must not start with any of the `exclude_prefixes` specified for
       * inclusion in the transfer.
       * The following are requirements of `include_prefixes`:
       *   * Each include-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each include-prefix must omit the leading slash. For example, to
       *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the include-prefix as `logs/y=2015/requests.gz`.
       *   * None of the include-prefix values can be empty, if specified.
       *   * Each include-prefix must include a distinct portion of the object
       *     namespace. No include-prefix may be a prefix of another
       *     include-prefix.
       * The max size of `include_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string include_prefixes = 3;</code>
       *
       * @param value The includePrefixes to add.
       * @return This builder for chaining.
       */
      public Builder addIncludePrefixes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludePrefixesIsMutable();
        includePrefixes_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If you specify `include_prefixes`, Storage Transfer Service uses the items
       * in the `include_prefixes` array to determine which objects to include in a
       * transfer. Objects must start with one of the matching `include_prefixes`
       * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
       * objects must not start with any of the `exclude_prefixes` specified for
       * inclusion in the transfer.
       * The following are requirements of `include_prefixes`:
       *   * Each include-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each include-prefix must omit the leading slash. For example, to
       *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the include-prefix as `logs/y=2015/requests.gz`.
       *   * None of the include-prefix values can be empty, if specified.
       *   * Each include-prefix must include a distinct portion of the object
       *     namespace. No include-prefix may be a prefix of another
       *     include-prefix.
       * The max size of `include_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string include_prefixes = 3;</code>
       *
       * @param values The includePrefixes to add.
       * @return This builder for chaining.
       */
      public Builder addAllIncludePrefixes(java.lang.Iterable<java.lang.String> values) {
        ensureIncludePrefixesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includePrefixes_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If you specify `include_prefixes`, Storage Transfer Service uses the items
       * in the `include_prefixes` array to determine which objects to include in a
       * transfer. Objects must start with one of the matching `include_prefixes`
       * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
       * objects must not start with any of the `exclude_prefixes` specified for
       * inclusion in the transfer.
       * The following are requirements of `include_prefixes`:
       *   * Each include-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each include-prefix must omit the leading slash. For example, to
       *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the include-prefix as `logs/y=2015/requests.gz`.
       *   * None of the include-prefix values can be empty, if specified.
       *   * Each include-prefix must include a distinct portion of the object
       *     namespace. No include-prefix may be a prefix of another
       *     include-prefix.
       * The max size of `include_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string include_prefixes = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIncludePrefixes() {
        includePrefixes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If you specify `include_prefixes`, Storage Transfer Service uses the items
       * in the `include_prefixes` array to determine which objects to include in a
       * transfer. Objects must start with one of the matching `include_prefixes`
       * for inclusion in the transfer. If [exclude_prefixes][google.storagetransfer.v1.ObjectConditions.exclude_prefixes] is specified,
       * objects must not start with any of the `exclude_prefixes` specified for
       * inclusion in the transfer.
       * The following are requirements of `include_prefixes`:
       *   * Each include-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each include-prefix must omit the leading slash. For example, to
       *     include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the include-prefix as `logs/y=2015/requests.gz`.
       *   * None of the include-prefix values can be empty, if specified.
       *   * Each include-prefix must include a distinct portion of the object
       *     namespace. No include-prefix may be a prefix of another
       *     include-prefix.
       * The max size of `include_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string include_prefixes = 3;</code>
       *
       * @param value The bytes of the includePrefixes to add.
       * @return This builder for chaining.
       */
      public Builder addIncludePrefixesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureIncludePrefixesIsMutable();
        includePrefixes_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList excludePrefixes_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureExcludePrefixesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          excludePrefixes_ = new com.google.protobuf.LazyStringArrayList(excludePrefixes_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
       * in the `exclude_prefixes` array to determine which objects to exclude from
       * a transfer. Objects must not start with one of the matching
       * `exclude_prefixes` for inclusion in a transfer.
       * The following are requirements of `exclude_prefixes`:
       *   * Each exclude-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each exclude-prefix must omit the leading slash. For example, to
       *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
       *   * None of the exclude-prefix values can be empty, if specified.
       *   * Each exclude-prefix must exclude a distinct portion of the object
       *     namespace. No exclude-prefix may be a prefix of another
       *     exclude-prefix.
       *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
       *   start with the value of a path explicitly included by `include_prefixes`.
       * The max size of `exclude_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string exclude_prefixes = 4;</code>
       *
       * @return A list containing the excludePrefixes.
       */
      public com.google.protobuf.ProtocolStringList getExcludePrefixesList() {
        return excludePrefixes_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
       * in the `exclude_prefixes` array to determine which objects to exclude from
       * a transfer. Objects must not start with one of the matching
       * `exclude_prefixes` for inclusion in a transfer.
       * The following are requirements of `exclude_prefixes`:
       *   * Each exclude-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each exclude-prefix must omit the leading slash. For example, to
       *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
       *   * None of the exclude-prefix values can be empty, if specified.
       *   * Each exclude-prefix must exclude a distinct portion of the object
       *     namespace. No exclude-prefix may be a prefix of another
       *     exclude-prefix.
       *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
       *   start with the value of a path explicitly included by `include_prefixes`.
       * The max size of `exclude_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string exclude_prefixes = 4;</code>
       *
       * @return The count of excludePrefixes.
       */
      public int getExcludePrefixesCount() {
        return excludePrefixes_.size();
      }
      /**
       *
       *
       * <pre>
       * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
       * in the `exclude_prefixes` array to determine which objects to exclude from
       * a transfer. Objects must not start with one of the matching
       * `exclude_prefixes` for inclusion in a transfer.
       * The following are requirements of `exclude_prefixes`:
       *   * Each exclude-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each exclude-prefix must omit the leading slash. For example, to
       *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
       *   * None of the exclude-prefix values can be empty, if specified.
       *   * Each exclude-prefix must exclude a distinct portion of the object
       *     namespace. No exclude-prefix may be a prefix of another
       *     exclude-prefix.
       *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
       *   start with the value of a path explicitly included by `include_prefixes`.
       * The max size of `exclude_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string exclude_prefixes = 4;</code>
       *
       * @param index The index of the element to return.
       * @return The excludePrefixes at the given index.
       */
      public java.lang.String getExcludePrefixes(int index) {
        return excludePrefixes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
       * in the `exclude_prefixes` array to determine which objects to exclude from
       * a transfer. Objects must not start with one of the matching
       * `exclude_prefixes` for inclusion in a transfer.
       * The following are requirements of `exclude_prefixes`:
       *   * Each exclude-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each exclude-prefix must omit the leading slash. For example, to
       *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
       *   * None of the exclude-prefix values can be empty, if specified.
       *   * Each exclude-prefix must exclude a distinct portion of the object
       *     namespace. No exclude-prefix may be a prefix of another
       *     exclude-prefix.
       *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
       *   start with the value of a path explicitly included by `include_prefixes`.
       * The max size of `exclude_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string exclude_prefixes = 4;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the excludePrefixes at the given index.
       */
      public com.google.protobuf.ByteString getExcludePrefixesBytes(int index) {
        return excludePrefixes_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
       * in the `exclude_prefixes` array to determine which objects to exclude from
       * a transfer. Objects must not start with one of the matching
       * `exclude_prefixes` for inclusion in a transfer.
       * The following are requirements of `exclude_prefixes`:
       *   * Each exclude-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each exclude-prefix must omit the leading slash. For example, to
       *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
       *   * None of the exclude-prefix values can be empty, if specified.
       *   * Each exclude-prefix must exclude a distinct portion of the object
       *     namespace. No exclude-prefix may be a prefix of another
       *     exclude-prefix.
       *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
       *   start with the value of a path explicitly included by `include_prefixes`.
       * The max size of `exclude_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string exclude_prefixes = 4;</code>
       *
       * @param index The index to set the value at.
       * @param value The excludePrefixes to set.
       * @return This builder for chaining.
       */
      public Builder setExcludePrefixes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludePrefixesIsMutable();
        excludePrefixes_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
       * in the `exclude_prefixes` array to determine which objects to exclude from
       * a transfer. Objects must not start with one of the matching
       * `exclude_prefixes` for inclusion in a transfer.
       * The following are requirements of `exclude_prefixes`:
       *   * Each exclude-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each exclude-prefix must omit the leading slash. For example, to
       *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
       *   * None of the exclude-prefix values can be empty, if specified.
       *   * Each exclude-prefix must exclude a distinct portion of the object
       *     namespace. No exclude-prefix may be a prefix of another
       *     exclude-prefix.
       *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
       *   start with the value of a path explicitly included by `include_prefixes`.
       * The max size of `exclude_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string exclude_prefixes = 4;</code>
       *
       * @param value The excludePrefixes to add.
       * @return This builder for chaining.
       */
      public Builder addExcludePrefixes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExcludePrefixesIsMutable();
        excludePrefixes_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
       * in the `exclude_prefixes` array to determine which objects to exclude from
       * a transfer. Objects must not start with one of the matching
       * `exclude_prefixes` for inclusion in a transfer.
       * The following are requirements of `exclude_prefixes`:
       *   * Each exclude-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each exclude-prefix must omit the leading slash. For example, to
       *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
       *   * None of the exclude-prefix values can be empty, if specified.
       *   * Each exclude-prefix must exclude a distinct portion of the object
       *     namespace. No exclude-prefix may be a prefix of another
       *     exclude-prefix.
       *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
       *   start with the value of a path explicitly included by `include_prefixes`.
       * The max size of `exclude_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string exclude_prefixes = 4;</code>
       *
       * @param values The excludePrefixes to add.
       * @return This builder for chaining.
       */
      public Builder addAllExcludePrefixes(java.lang.Iterable<java.lang.String> values) {
        ensureExcludePrefixesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludePrefixes_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
       * in the `exclude_prefixes` array to determine which objects to exclude from
       * a transfer. Objects must not start with one of the matching
       * `exclude_prefixes` for inclusion in a transfer.
       * The following are requirements of `exclude_prefixes`:
       *   * Each exclude-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each exclude-prefix must omit the leading slash. For example, to
       *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
       *   * None of the exclude-prefix values can be empty, if specified.
       *   * Each exclude-prefix must exclude a distinct portion of the object
       *     namespace. No exclude-prefix may be a prefix of another
       *     exclude-prefix.
       *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
       *   start with the value of a path explicitly included by `include_prefixes`.
       * The max size of `exclude_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string exclude_prefixes = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearExcludePrefixes() {
        excludePrefixes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If you specify `exclude_prefixes`, Storage Transfer Service uses the items
       * in the `exclude_prefixes` array to determine which objects to exclude from
       * a transfer. Objects must not start with one of the matching
       * `exclude_prefixes` for inclusion in a transfer.
       * The following are requirements of `exclude_prefixes`:
       *   * Each exclude-prefix can contain any sequence of Unicode characters, to
       *     a max length of 1024 bytes when UTF8-encoded, and must not contain
       *     Carriage Return or Line Feed characters.  Wildcard matching and regular
       *     expression matching are not supported.
       *   * Each exclude-prefix must omit the leading slash. For example, to
       *     exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`,
       *     specify the exclude-prefix as `logs/y=2015/requests.gz`.
       *   * None of the exclude-prefix values can be empty, if specified.
       *   * Each exclude-prefix must exclude a distinct portion of the object
       *     namespace. No exclude-prefix may be a prefix of another
       *     exclude-prefix.
       *   * If [include_prefixes][google.storagetransfer.v1.ObjectConditions.include_prefixes] is specified, then each exclude-prefix must
       *   start with the value of a path explicitly included by `include_prefixes`.
       * The max size of `exclude_prefixes` is 1000.
       * For more information, see [Filtering objects from
       * transfers](/storage-transfer/docs/filtering-objects-from-transfers).
       * </pre>
       *
       * <code>repeated string exclude_prefixes = 4;</code>
       *
       * @param value The bytes of the excludePrefixes to add.
       * @return This builder for chaining.
       */
      public Builder addExcludePrefixesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureExcludePrefixesIsMutable();
        excludePrefixes_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp lastModifiedSince_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          lastModifiedSinceBuilder_;
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" on or after
       * this timestamp and objects that don't have a "last modification time" are
       * transferred.
       * The `last_modified_since` and `last_modified_before` fields can be used
       * together for chunked data processing. For example, consider a script that
       * processes each day's worth of data at a time. For that you'd set each
       * of the fields as follows:
       * *  `last_modified_since` to the start of the day
       * *  `last_modified_before` to the end of the day
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
       *
       * @return Whether the lastModifiedSince field is set.
       */
      public boolean hasLastModifiedSince() {
        return lastModifiedSinceBuilder_ != null || lastModifiedSince_ != null;
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" on or after
       * this timestamp and objects that don't have a "last modification time" are
       * transferred.
       * The `last_modified_since` and `last_modified_before` fields can be used
       * together for chunked data processing. For example, consider a script that
       * processes each day's worth of data at a time. For that you'd set each
       * of the fields as follows:
       * *  `last_modified_since` to the start of the day
       * *  `last_modified_before` to the end of the day
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
       *
       * @return The lastModifiedSince.
       */
      public com.google.protobuf.Timestamp getLastModifiedSince() {
        if (lastModifiedSinceBuilder_ == null) {
          return lastModifiedSince_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastModifiedSince_;
        } else {
          return lastModifiedSinceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" on or after
       * this timestamp and objects that don't have a "last modification time" are
       * transferred.
       * The `last_modified_since` and `last_modified_before` fields can be used
       * together for chunked data processing. For example, consider a script that
       * processes each day's worth of data at a time. For that you'd set each
       * of the fields as follows:
       * *  `last_modified_since` to the start of the day
       * *  `last_modified_before` to the end of the day
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
       */
      public Builder setLastModifiedSince(com.google.protobuf.Timestamp value) {
        if (lastModifiedSinceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastModifiedSince_ = value;
          onChanged();
        } else {
          lastModifiedSinceBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" on or after
       * this timestamp and objects that don't have a "last modification time" are
       * transferred.
       * The `last_modified_since` and `last_modified_before` fields can be used
       * together for chunked data processing. For example, consider a script that
       * processes each day's worth of data at a time. For that you'd set each
       * of the fields as follows:
       * *  `last_modified_since` to the start of the day
       * *  `last_modified_before` to the end of the day
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
       */
      public Builder setLastModifiedSince(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (lastModifiedSinceBuilder_ == null) {
          lastModifiedSince_ = builderForValue.build();
          onChanged();
        } else {
          lastModifiedSinceBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" on or after
       * this timestamp and objects that don't have a "last modification time" are
       * transferred.
       * The `last_modified_since` and `last_modified_before` fields can be used
       * together for chunked data processing. For example, consider a script that
       * processes each day's worth of data at a time. For that you'd set each
       * of the fields as follows:
       * *  `last_modified_since` to the start of the day
       * *  `last_modified_before` to the end of the day
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
       */
      public Builder mergeLastModifiedSince(com.google.protobuf.Timestamp value) {
        if (lastModifiedSinceBuilder_ == null) {
          if (lastModifiedSince_ != null) {
            lastModifiedSince_ =
                com.google.protobuf.Timestamp.newBuilder(lastModifiedSince_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            lastModifiedSince_ = value;
          }
          onChanged();
        } else {
          lastModifiedSinceBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" on or after
       * this timestamp and objects that don't have a "last modification time" are
       * transferred.
       * The `last_modified_since` and `last_modified_before` fields can be used
       * together for chunked data processing. For example, consider a script that
       * processes each day's worth of data at a time. For that you'd set each
       * of the fields as follows:
       * *  `last_modified_since` to the start of the day
       * *  `last_modified_before` to the end of the day
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
       */
      public Builder clearLastModifiedSince() {
        if (lastModifiedSinceBuilder_ == null) {
          lastModifiedSince_ = null;
          onChanged();
        } else {
          lastModifiedSince_ = null;
          lastModifiedSinceBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" on or after
       * this timestamp and objects that don't have a "last modification time" are
       * transferred.
       * The `last_modified_since` and `last_modified_before` fields can be used
       * together for chunked data processing. For example, consider a script that
       * processes each day's worth of data at a time. For that you'd set each
       * of the fields as follows:
       * *  `last_modified_since` to the start of the day
       * *  `last_modified_before` to the end of the day
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
       */
      public com.google.protobuf.Timestamp.Builder getLastModifiedSinceBuilder() {

        onChanged();
        return getLastModifiedSinceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" on or after
       * this timestamp and objects that don't have a "last modification time" are
       * transferred.
       * The `last_modified_since` and `last_modified_before` fields can be used
       * together for chunked data processing. For example, consider a script that
       * processes each day's worth of data at a time. For that you'd set each
       * of the fields as follows:
       * *  `last_modified_since` to the start of the day
       * *  `last_modified_before` to the end of the day
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getLastModifiedSinceOrBuilder() {
        if (lastModifiedSinceBuilder_ != null) {
          return lastModifiedSinceBuilder_.getMessageOrBuilder();
        } else {
          return lastModifiedSince_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastModifiedSince_;
        }
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" on or after
       * this timestamp and objects that don't have a "last modification time" are
       * transferred.
       * The `last_modified_since` and `last_modified_before` fields can be used
       * together for chunked data processing. For example, consider a script that
       * processes each day's worth of data at a time. For that you'd set each
       * of the fields as follows:
       * *  `last_modified_since` to the start of the day
       * *  `last_modified_before` to the end of the day
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_since = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getLastModifiedSinceFieldBuilder() {
        if (lastModifiedSinceBuilder_ == null) {
          lastModifiedSinceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getLastModifiedSince(), getParentForChildren(), isClean());
          lastModifiedSince_ = null;
        }
        return lastModifiedSinceBuilder_;
      }

      private com.google.protobuf.Timestamp lastModifiedBefore_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          lastModifiedBeforeBuilder_;
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" before this
       * timestamp and objects that don't have a "last modification time" are
       * transferred.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
       *
       * @return Whether the lastModifiedBefore field is set.
       */
      public boolean hasLastModifiedBefore() {
        return lastModifiedBeforeBuilder_ != null || lastModifiedBefore_ != null;
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" before this
       * timestamp and objects that don't have a "last modification time" are
       * transferred.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
       *
       * @return The lastModifiedBefore.
       */
      public com.google.protobuf.Timestamp getLastModifiedBefore() {
        if (lastModifiedBeforeBuilder_ == null) {
          return lastModifiedBefore_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastModifiedBefore_;
        } else {
          return lastModifiedBeforeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" before this
       * timestamp and objects that don't have a "last modification time" are
       * transferred.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
       */
      public Builder setLastModifiedBefore(com.google.protobuf.Timestamp value) {
        if (lastModifiedBeforeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastModifiedBefore_ = value;
          onChanged();
        } else {
          lastModifiedBeforeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" before this
       * timestamp and objects that don't have a "last modification time" are
       * transferred.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
       */
      public Builder setLastModifiedBefore(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (lastModifiedBeforeBuilder_ == null) {
          lastModifiedBefore_ = builderForValue.build();
          onChanged();
        } else {
          lastModifiedBeforeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" before this
       * timestamp and objects that don't have a "last modification time" are
       * transferred.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
       */
      public Builder mergeLastModifiedBefore(com.google.protobuf.Timestamp value) {
        if (lastModifiedBeforeBuilder_ == null) {
          if (lastModifiedBefore_ != null) {
            lastModifiedBefore_ =
                com.google.protobuf.Timestamp.newBuilder(lastModifiedBefore_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            lastModifiedBefore_ = value;
          }
          onChanged();
        } else {
          lastModifiedBeforeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" before this
       * timestamp and objects that don't have a "last modification time" are
       * transferred.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
       */
      public Builder clearLastModifiedBefore() {
        if (lastModifiedBeforeBuilder_ == null) {
          lastModifiedBefore_ = null;
          onChanged();
        } else {
          lastModifiedBefore_ = null;
          lastModifiedBeforeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" before this
       * timestamp and objects that don't have a "last modification time" are
       * transferred.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
       */
      public com.google.protobuf.Timestamp.Builder getLastModifiedBeforeBuilder() {

        onChanged();
        return getLastModifiedBeforeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" before this
       * timestamp and objects that don't have a "last modification time" are
       * transferred.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getLastModifiedBeforeOrBuilder() {
        if (lastModifiedBeforeBuilder_ != null) {
          return lastModifiedBeforeBuilder_.getMessageOrBuilder();
        } else {
          return lastModifiedBefore_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : lastModifiedBefore_;
        }
      }
      /**
       *
       *
       * <pre>
       * If specified, only objects with a "last modification time" before this
       * timestamp and objects that don't have a "last modification time" are
       * transferred.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp last_modified_before = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getLastModifiedBeforeFieldBuilder() {
        if (lastModifiedBeforeBuilder_ == null) {
          lastModifiedBeforeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getLastModifiedBefore(), getParentForChildren(), isClean());
          lastModifiedBefore_ = null;
        }
        return lastModifiedBeforeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.ObjectConditions)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.ObjectConditions)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ObjectConditions> PARSER =
        new com.google.protobuf.AbstractParser<ObjectConditions>() {
          @java.lang.Override
          public ObjectConditions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ObjectConditions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ObjectConditions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GcsDataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.GcsData)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Cloud Storage bucket name. Must meet
     * [Bucket Name Requirements](/storage/docs/naming#requirements).
     * </pre>
     *
     * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucketName.
     */
    java.lang.String getBucketName();
    /**
     *
     *
     * <pre>
     * Required. Cloud Storage bucket name. Must meet
     * [Bucket Name Requirements](/storage/docs/naming#requirements).
     * </pre>
     *
     * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucketName.
     */
    com.google.protobuf.ByteString getBucketNameBytes();

    /**
     *
     *
     * <pre>
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * The root path value must meet
     * [Object Name Requirements](/storage/docs/naming#objectnames).
     * </pre>
     *
     * <code>string path = 3;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();
    /**
     *
     *
     * <pre>
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * The root path value must meet
     * [Object Name Requirements](/storage/docs/naming#objectnames).
     * </pre>
     *
     * <code>string path = 3;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();
  }
  /**
   *
   *
   * <pre>
   * In a GcsData resource, an object's name is the Cloud Storage object's
   * name and its "last modification time" refers to the object's `updated`
   * property of Cloud Storage objects, which changes when the content or the
   * metadata of the object is updated.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.GcsData}
   */
  public static final class GcsData extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.GcsData)
      GcsDataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GcsData.newBuilder() to construct.
    private GcsData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GcsData() {
      bucketName_ = "";
      path_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GcsData();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_GcsData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_GcsData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData.class,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder.class);
    }

    public static final int BUCKET_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object bucketName_;
    /**
     *
     *
     * <pre>
     * Required. Cloud Storage bucket name. Must meet
     * [Bucket Name Requirements](/storage/docs/naming#requirements).
     * </pre>
     *
     * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucketName.
     */
    @java.lang.Override
    public java.lang.String getBucketName() {
      java.lang.Object ref = bucketName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucketName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Cloud Storage bucket name. Must meet
     * [Bucket Name Requirements](/storage/docs/naming#requirements).
     * </pre>
     *
     * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucketName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBucketNameBytes() {
      java.lang.Object ref = bucketName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucketName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 3;
    private volatile java.lang.Object path_;
    /**
     *
     *
     * <pre>
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * The root path value must meet
     * [Object Name Requirements](/storage/docs/naming#objectnames).
     * </pre>
     *
     * <code>string path = 3;</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * The root path value must meet
     * [Object Name Requirements](/storage/docs/naming#objectnames).
     * </pre>
     *
     * <code>string path = 3;</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucketName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, path_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, bucketName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, path_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.GcsData)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.GcsData other =
          (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) obj;

      if (!getBucketName().equals(other.getBucketName())) return false;
      if (!getPath().equals(other.getPath())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BUCKET_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getBucketName().hashCode();
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.GcsData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * In a GcsData resource, an object's name is the Cloud Storage object's
     * name and its "last modification time" refers to the object's `updated`
     * property of Cloud Storage objects, which changes when the content or the
     * metadata of the object is updated.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.GcsData}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.GcsData)
        com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_GcsData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_GcsData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.GcsData.class,
                com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder.class);
      }

      // Construct using com.google.storagetransfer.v1.proto.TransferTypes.GcsData.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bucketName_ = "";

        path_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_GcsData_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.GcsData getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.GcsData build() {
        com.google.storagetransfer.v1.proto.TransferTypes.GcsData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.GcsData buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.GcsData result =
            new com.google.storagetransfer.v1.proto.TransferTypes.GcsData(this);
        result.bucketName_ = bucketName_;
        result.path_ = path_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storagetransfer.v1.proto.TransferTypes.GcsData) {
          return mergeFrom((com.google.storagetransfer.v1.proto.TransferTypes.GcsData) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storagetransfer.v1.proto.TransferTypes.GcsData other) {
        if (other == com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance())
          return this;
        if (!other.getBucketName().isEmpty()) {
          bucketName_ = other.bucketName_;
          onChanged();
        }
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  bucketName_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 26:
                {
                  path_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object bucketName_ = "";
      /**
       *
       *
       * <pre>
       * Required. Cloud Storage bucket name. Must meet
       * [Bucket Name Requirements](/storage/docs/naming#requirements).
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bucketName.
       */
      public java.lang.String getBucketName() {
        java.lang.Object ref = bucketName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bucketName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Cloud Storage bucket name. Must meet
       * [Bucket Name Requirements](/storage/docs/naming#requirements).
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for bucketName.
       */
      public com.google.protobuf.ByteString getBucketNameBytes() {
        java.lang.Object ref = bucketName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bucketName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Cloud Storage bucket name. Must meet
       * [Bucket Name Requirements](/storage/docs/naming#requirements).
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bucketName to set.
       * @return This builder for chaining.
       */
      public Builder setBucketName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        bucketName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Cloud Storage bucket name. Must meet
       * [Bucket Name Requirements](/storage/docs/naming#requirements).
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBucketName() {

        bucketName_ = getDefaultInstance().getBucketName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Cloud Storage bucket name. Must meet
       * [Bucket Name Requirements](/storage/docs/naming#requirements).
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for bucketName to set.
       * @return This builder for chaining.
       */
      public Builder setBucketNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        bucketName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * The root path value must meet
       * [Object Name Requirements](/storage/docs/naming#objectnames).
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * The root path value must meet
       * [Object Name Requirements](/storage/docs/naming#objectnames).
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * The root path value must meet
       * [Object Name Requirements](/storage/docs/naming#objectnames).
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        path_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * The root path value must meet
       * [Object Name Requirements](/storage/docs/naming#objectnames).
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {

        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * The root path value must meet
       * [Object Name Requirements](/storage/docs/naming#objectnames).
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        path_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.GcsData)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.GcsData)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.GcsData DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storagetransfer.v1.proto.TransferTypes.GcsData();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.GcsData getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GcsData> PARSER =
        new com.google.protobuf.AbstractParser<GcsData>() {
          @java.lang.Override
          public GcsData parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GcsData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GcsData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.GcsData getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AwsS3DataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.AwsS3Data)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. S3 Bucket name (see
     * [Creating a
     * bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
     * </pre>
     *
     * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucketName.
     */
    java.lang.String getBucketName();
    /**
     *
     *
     * <pre>
     * Required. S3 Bucket name (see
     * [Creating a
     * bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
     * </pre>
     *
     * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucketName.
     */
    com.google.protobuf.ByteString getBucketNameBytes();

    /**
     *
     *
     * <pre>
     * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
     * Permissions on the bucket must be granted to the access ID of the AWS
     * access key.
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the awsAccessKey field is set.
     */
    boolean hasAwsAccessKey();
    /**
     *
     *
     * <pre>
     * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
     * Permissions on the bucket must be granted to the access ID of the AWS
     * access key.
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The awsAccessKey.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey getAwsAccessKey();
    /**
     *
     *
     * <pre>
     * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
     * Permissions on the bucket must be granted to the access ID of the AWS
     * access key.
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKeyOrBuilder
        getAwsAccessKeyOrBuilder();

    /**
     *
     *
     * <pre>
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * </pre>
     *
     * <code>string path = 3;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();
    /**
     *
     *
     * <pre>
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * </pre>
     *
     * <code>string path = 3;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * The Amazon Resource Name (ARN) of the role to support temporary
     * credentials via `AssumeRoleWithWebIdentity`. For more information about
     * ARNs, see [IAM
     * ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
     * When a role ARN is provided, Transfer Service fetches temporary
     * credentials for the session using a `AssumeRoleWithWebIdentity` call for
     * the provided role using the [GoogleServiceAccount][google.storagetransfer.v1.GoogleServiceAccount] for this project.
     * </pre>
     *
     * <code>string role_arn = 4;</code>
     *
     * @return The roleArn.
     */
    java.lang.String getRoleArn();
    /**
     *
     *
     * <pre>
     * The Amazon Resource Name (ARN) of the role to support temporary
     * credentials via `AssumeRoleWithWebIdentity`. For more information about
     * ARNs, see [IAM
     * ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
     * When a role ARN is provided, Transfer Service fetches temporary
     * credentials for the session using a `AssumeRoleWithWebIdentity` call for
     * the provided role using the [GoogleServiceAccount][google.storagetransfer.v1.GoogleServiceAccount] for this project.
     * </pre>
     *
     * <code>string role_arn = 4;</code>
     *
     * @return The bytes for roleArn.
     */
    com.google.protobuf.ByteString getRoleArnBytes();
  }
  /**
   *
   *
   * <pre>
   * An AwsS3Data resource can be a data source, but not a data sink.
   * In an AwsS3Data resource, an object's name is the S3 object's key name.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.AwsS3Data}
   */
  public static final class AwsS3Data extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.AwsS3Data)
      AwsS3DataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AwsS3Data.newBuilder() to construct.
    private AwsS3Data(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AwsS3Data() {
      bucketName_ = "";
      path_ = "";
      roleArn_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AwsS3Data();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_AwsS3Data_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_AwsS3Data_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.class,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.Builder.class);
    }

    public static final int BUCKET_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object bucketName_;
    /**
     *
     *
     * <pre>
     * Required. S3 Bucket name (see
     * [Creating a
     * bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
     * </pre>
     *
     * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucketName.
     */
    @java.lang.Override
    public java.lang.String getBucketName() {
      java.lang.Object ref = bucketName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucketName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. S3 Bucket name (see
     * [Creating a
     * bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
     * </pre>
     *
     * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucketName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBucketNameBytes() {
      java.lang.Object ref = bucketName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucketName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AWS_ACCESS_KEY_FIELD_NUMBER = 2;
    private com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey awsAccessKey_;
    /**
     *
     *
     * <pre>
     * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
     * Permissions on the bucket must be granted to the access ID of the AWS
     * access key.
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the awsAccessKey field is set.
     */
    @java.lang.Override
    public boolean hasAwsAccessKey() {
      return awsAccessKey_ != null;
    }
    /**
     *
     *
     * <pre>
     * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
     * Permissions on the bucket must be granted to the access ID of the AWS
     * access key.
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The awsAccessKey.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey getAwsAccessKey() {
      return awsAccessKey_ == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.getDefaultInstance()
          : awsAccessKey_;
    }
    /**
     *
     *
     * <pre>
     * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
     * Permissions on the bucket must be granted to the access ID of the AWS
     * access key.
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKeyOrBuilder
        getAwsAccessKeyOrBuilder() {
      return getAwsAccessKey();
    }

    public static final int PATH_FIELD_NUMBER = 3;
    private volatile java.lang.Object path_;
    /**
     *
     *
     * <pre>
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * </pre>
     *
     * <code>string path = 3;</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * </pre>
     *
     * <code>string path = 3;</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ROLE_ARN_FIELD_NUMBER = 4;
    private volatile java.lang.Object roleArn_;
    /**
     *
     *
     * <pre>
     * The Amazon Resource Name (ARN) of the role to support temporary
     * credentials via `AssumeRoleWithWebIdentity`. For more information about
     * ARNs, see [IAM
     * ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
     * When a role ARN is provided, Transfer Service fetches temporary
     * credentials for the session using a `AssumeRoleWithWebIdentity` call for
     * the provided role using the [GoogleServiceAccount][google.storagetransfer.v1.GoogleServiceAccount] for this project.
     * </pre>
     *
     * <code>string role_arn = 4;</code>
     *
     * @return The roleArn.
     */
    @java.lang.Override
    public java.lang.String getRoleArn() {
      java.lang.Object ref = roleArn_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        roleArn_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The Amazon Resource Name (ARN) of the role to support temporary
     * credentials via `AssumeRoleWithWebIdentity`. For more information about
     * ARNs, see [IAM
     * ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
     * When a role ARN is provided, Transfer Service fetches temporary
     * credentials for the session using a `AssumeRoleWithWebIdentity` call for
     * the provided role using the [GoogleServiceAccount][google.storagetransfer.v1.GoogleServiceAccount] for this project.
     * </pre>
     *
     * <code>string role_arn = 4;</code>
     *
     * @return The bytes for roleArn.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRoleArnBytes() {
      java.lang.Object ref = roleArn_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        roleArn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucketName_);
      }
      if (awsAccessKey_ != null) {
        output.writeMessage(2, getAwsAccessKey());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, path_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(roleArn_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, roleArn_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, bucketName_);
      }
      if (awsAccessKey_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAwsAccessKey());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, path_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(roleArn_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, roleArn_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data other =
          (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data) obj;

      if (!getBucketName().equals(other.getBucketName())) return false;
      if (hasAwsAccessKey() != other.hasAwsAccessKey()) return false;
      if (hasAwsAccessKey()) {
        if (!getAwsAccessKey().equals(other.getAwsAccessKey())) return false;
      }
      if (!getPath().equals(other.getPath())) return false;
      if (!getRoleArn().equals(other.getRoleArn())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BUCKET_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getBucketName().hashCode();
      if (hasAwsAccessKey()) {
        hash = (37 * hash) + AWS_ACCESS_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getAwsAccessKey().hashCode();
      }
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (37 * hash) + ROLE_ARN_FIELD_NUMBER;
      hash = (53 * hash) + getRoleArn().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An AwsS3Data resource can be a data source, but not a data sink.
     * In an AwsS3Data resource, an object's name is the S3 object's key name.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.AwsS3Data}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.AwsS3Data)
        com.google.storagetransfer.v1.proto.TransferTypes.AwsS3DataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AwsS3Data_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AwsS3Data_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.class,
                com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.Builder.class);
      }

      // Construct using com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bucketName_ = "";

        if (awsAccessKeyBuilder_ == null) {
          awsAccessKey_ = null;
        } else {
          awsAccessKey_ = null;
          awsAccessKeyBuilder_ = null;
        }
        path_ = "";

        roleArn_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AwsS3Data_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data build() {
        com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data result =
            new com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data(this);
        result.bucketName_ = bucketName_;
        if (awsAccessKeyBuilder_ == null) {
          result.awsAccessKey_ = awsAccessKey_;
        } else {
          result.awsAccessKey_ = awsAccessKeyBuilder_.build();
        }
        result.path_ = path_;
        result.roleArn_ = roleArn_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data) {
          return mergeFrom((com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.getDefaultInstance())
          return this;
        if (!other.getBucketName().isEmpty()) {
          bucketName_ = other.bucketName_;
          onChanged();
        }
        if (other.hasAwsAccessKey()) {
          mergeAwsAccessKey(other.getAwsAccessKey());
        }
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          onChanged();
        }
        if (!other.getRoleArn().isEmpty()) {
          roleArn_ = other.roleArn_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  bucketName_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getAwsAccessKeyFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              case 26:
                {
                  path_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              case 34:
                {
                  roleArn_ = input.readStringRequireUtf8();

                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object bucketName_ = "";
      /**
       *
       *
       * <pre>
       * Required. S3 Bucket name (see
       * [Creating a
       * bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bucketName.
       */
      public java.lang.String getBucketName() {
        java.lang.Object ref = bucketName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bucketName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. S3 Bucket name (see
       * [Creating a
       * bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for bucketName.
       */
      public com.google.protobuf.ByteString getBucketNameBytes() {
        java.lang.Object ref = bucketName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bucketName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. S3 Bucket name (see
       * [Creating a
       * bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bucketName to set.
       * @return This builder for chaining.
       */
      public Builder setBucketName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        bucketName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. S3 Bucket name (see
       * [Creating a
       * bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBucketName() {

        bucketName_ = getDefaultInstance().getBucketName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. S3 Bucket name (see
       * [Creating a
       * bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for bucketName to set.
       * @return This builder for chaining.
       */
      public Builder setBucketNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        bucketName_ = value;
        onChanged();
        return this;
      }

      private com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey awsAccessKey_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKeyOrBuilder>
          awsAccessKeyBuilder_;
      /**
       *
       *
       * <pre>
       * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
       * Permissions on the bucket must be granted to the access ID of the AWS
       * access key.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return Whether the awsAccessKey field is set.
       */
      public boolean hasAwsAccessKey() {
        return awsAccessKeyBuilder_ != null || awsAccessKey_ != null;
      }
      /**
       *
       *
       * <pre>
       * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
       * Permissions on the bucket must be granted to the access ID of the AWS
       * access key.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The awsAccessKey.
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey getAwsAccessKey() {
        if (awsAccessKeyBuilder_ == null) {
          return awsAccessKey_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.getDefaultInstance()
              : awsAccessKey_;
        } else {
          return awsAccessKeyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
       * Permissions on the bucket must be granted to the access ID of the AWS
       * access key.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder setAwsAccessKey(
          com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey value) {
        if (awsAccessKeyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          awsAccessKey_ = value;
          onChanged();
        } else {
          awsAccessKeyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
       * Permissions on the bucket must be granted to the access ID of the AWS
       * access key.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder setAwsAccessKey(
          com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.Builder builderForValue) {
        if (awsAccessKeyBuilder_ == null) {
          awsAccessKey_ = builderForValue.build();
          onChanged();
        } else {
          awsAccessKeyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
       * Permissions on the bucket must be granted to the access ID of the AWS
       * access key.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder mergeAwsAccessKey(
          com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey value) {
        if (awsAccessKeyBuilder_ == null) {
          if (awsAccessKey_ != null) {
            awsAccessKey_ =
                com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.newBuilder(
                        awsAccessKey_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            awsAccessKey_ = value;
          }
          onChanged();
        } else {
          awsAccessKeyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
       * Permissions on the bucket must be granted to the access ID of the AWS
       * access key.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder clearAwsAccessKey() {
        if (awsAccessKeyBuilder_ == null) {
          awsAccessKey_ = null;
          onChanged();
        } else {
          awsAccessKey_ = null;
          awsAccessKeyBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
       * Permissions on the bucket must be granted to the access ID of the AWS
       * access key.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.Builder
          getAwsAccessKeyBuilder() {

        onChanged();
        return getAwsAccessKeyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
       * Permissions on the bucket must be granted to the access ID of the AWS
       * access key.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKeyOrBuilder
          getAwsAccessKeyOrBuilder() {
        if (awsAccessKeyBuilder_ != null) {
          return awsAccessKeyBuilder_.getMessageOrBuilder();
        } else {
          return awsAccessKey_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.getDefaultInstance()
              : awsAccessKey_;
        }
      }
      /**
       *
       *
       * <pre>
       * Input only. AWS access key used to sign the API requests to the AWS S3 bucket.
       * Permissions on the bucket must be granted to the access ID of the AWS
       * access key.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AwsAccessKey aws_access_key = 2 [(.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKeyOrBuilder>
          getAwsAccessKeyFieldBuilder() {
        if (awsAccessKeyBuilder_ == null) {
          awsAccessKeyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey,
                  com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKey.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.AwsAccessKeyOrBuilder>(
                  getAwsAccessKey(), getParentForChildren(), isClean());
          awsAccessKey_ = null;
        }
        return awsAccessKeyBuilder_;
      }

      private java.lang.Object path_ = "";
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        path_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {

        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * </pre>
       *
       * <code>string path = 3;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        path_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object roleArn_ = "";
      /**
       *
       *
       * <pre>
       * The Amazon Resource Name (ARN) of the role to support temporary
       * credentials via `AssumeRoleWithWebIdentity`. For more information about
       * ARNs, see [IAM
       * ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
       * When a role ARN is provided, Transfer Service fetches temporary
       * credentials for the session using a `AssumeRoleWithWebIdentity` call for
       * the provided role using the [GoogleServiceAccount][google.storagetransfer.v1.GoogleServiceAccount] for this project.
       * </pre>
       *
       * <code>string role_arn = 4;</code>
       *
       * @return The roleArn.
       */
      public java.lang.String getRoleArn() {
        java.lang.Object ref = roleArn_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          roleArn_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Amazon Resource Name (ARN) of the role to support temporary
       * credentials via `AssumeRoleWithWebIdentity`. For more information about
       * ARNs, see [IAM
       * ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
       * When a role ARN is provided, Transfer Service fetches temporary
       * credentials for the session using a `AssumeRoleWithWebIdentity` call for
       * the provided role using the [GoogleServiceAccount][google.storagetransfer.v1.GoogleServiceAccount] for this project.
       * </pre>
       *
       * <code>string role_arn = 4;</code>
       *
       * @return The bytes for roleArn.
       */
      public com.google.protobuf.ByteString getRoleArnBytes() {
        java.lang.Object ref = roleArn_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          roleArn_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Amazon Resource Name (ARN) of the role to support temporary
       * credentials via `AssumeRoleWithWebIdentity`. For more information about
       * ARNs, see [IAM
       * ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
       * When a role ARN is provided, Transfer Service fetches temporary
       * credentials for the session using a `AssumeRoleWithWebIdentity` call for
       * the provided role using the [GoogleServiceAccount][google.storagetransfer.v1.GoogleServiceAccount] for this project.
       * </pre>
       *
       * <code>string role_arn = 4;</code>
       *
       * @param value The roleArn to set.
       * @return This builder for chaining.
       */
      public Builder setRoleArn(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        roleArn_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Amazon Resource Name (ARN) of the role to support temporary
       * credentials via `AssumeRoleWithWebIdentity`. For more information about
       * ARNs, see [IAM
       * ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
       * When a role ARN is provided, Transfer Service fetches temporary
       * credentials for the session using a `AssumeRoleWithWebIdentity` call for
       * the provided role using the [GoogleServiceAccount][google.storagetransfer.v1.GoogleServiceAccount] for this project.
       * </pre>
       *
       * <code>string role_arn = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRoleArn() {

        roleArn_ = getDefaultInstance().getRoleArn();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Amazon Resource Name (ARN) of the role to support temporary
       * credentials via `AssumeRoleWithWebIdentity`. For more information about
       * ARNs, see [IAM
       * ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
       * When a role ARN is provided, Transfer Service fetches temporary
       * credentials for the session using a `AssumeRoleWithWebIdentity` call for
       * the provided role using the [GoogleServiceAccount][google.storagetransfer.v1.GoogleServiceAccount] for this project.
       * </pre>
       *
       * <code>string role_arn = 4;</code>
       *
       * @param value The bytes for roleArn to set.
       * @return This builder for chaining.
       */
      public Builder setRoleArnBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        roleArn_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.AwsS3Data)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.AwsS3Data)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AwsS3Data> PARSER =
        new com.google.protobuf.AbstractParser<AwsS3Data>() {
          @java.lang.Override
          public AwsS3Data parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AwsS3Data> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AwsS3Data> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AzureBlobStorageDataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.AzureBlobStorageData)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the Azure Storage account.
     * </pre>
     *
     * <code>string storage_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The storageAccount.
     */
    java.lang.String getStorageAccount();
    /**
     *
     *
     * <pre>
     * Required. The name of the Azure Storage account.
     * </pre>
     *
     * <code>string storage_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for storageAccount.
     */
    com.google.protobuf.ByteString getStorageAccountBytes();

    /**
     *
     *
     * <pre>
     * Required. Input only. Credentials used to authenticate API requests to Azure.
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the azureCredentials field is set.
     */
    boolean hasAzureCredentials();
    /**
     *
     *
     * <pre>
     * Required. Input only. Credentials used to authenticate API requests to Azure.
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The azureCredentials.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials getAzureCredentials();
    /**
     *
     *
     * <pre>
     * Required. Input only. Credentials used to authenticate API requests to Azure.
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentialsOrBuilder
        getAzureCredentialsOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The container to transfer from the Azure Storage account.
     * </pre>
     *
     * <code>string container = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The container.
     */
    java.lang.String getContainer();
    /**
     *
     *
     * <pre>
     * Required. The container to transfer from the Azure Storage account.
     * </pre>
     *
     * <code>string container = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for container.
     */
    com.google.protobuf.ByteString getContainerBytes();

    /**
     *
     *
     * <pre>
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * </pre>
     *
     * <code>string path = 5;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();
    /**
     *
     *
     * <pre>
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * </pre>
     *
     * <code>string path = 5;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();
  }
  /**
   *
   *
   * <pre>
   * An AzureBlobStorageData resource can be a data source, but not a data sink.
   * An AzureBlobStorageData resource represents one Azure container. The storage
   * account determines the [Azure
   * endpoint](https://docs.microsoft.com/en-us/azure/storage/common/storage-create-storage-account#storage-account-endpoints).
   * In an AzureBlobStorageData resource, a blobs's name is the [Azure Blob
   * Storage blob's key
   * name](https://docs.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#blob-names).
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.AzureBlobStorageData}
   */
  public static final class AzureBlobStorageData extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.AzureBlobStorageData)
      AzureBlobStorageDataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AzureBlobStorageData.newBuilder() to construct.
    private AzureBlobStorageData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AzureBlobStorageData() {
      storageAccount_ = "";
      container_ = "";
      path_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AzureBlobStorageData();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_AzureBlobStorageData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_AzureBlobStorageData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData.class,
              com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData.Builder.class);
    }

    public static final int STORAGE_ACCOUNT_FIELD_NUMBER = 1;
    private volatile java.lang.Object storageAccount_;
    /**
     *
     *
     * <pre>
     * Required. The name of the Azure Storage account.
     * </pre>
     *
     * <code>string storage_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The storageAccount.
     */
    @java.lang.Override
    public java.lang.String getStorageAccount() {
      java.lang.Object ref = storageAccount_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        storageAccount_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Azure Storage account.
     * </pre>
     *
     * <code>string storage_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for storageAccount.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStorageAccountBytes() {
      java.lang.Object ref = storageAccount_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        storageAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AZURE_CREDENTIALS_FIELD_NUMBER = 2;
    private com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials azureCredentials_;
    /**
     *
     *
     * <pre>
     * Required. Input only. Credentials used to authenticate API requests to Azure.
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the azureCredentials field is set.
     */
    @java.lang.Override
    public boolean hasAzureCredentials() {
      return azureCredentials_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. Credentials used to authenticate API requests to Azure.
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The azureCredentials.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials
        getAzureCredentials() {
      return azureCredentials_ == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials.getDefaultInstance()
          : azureCredentials_;
    }
    /**
     *
     *
     * <pre>
     * Required. Input only. Credentials used to authenticate API requests to Azure.
     * For information on our data retention policy for user credentials, see
     * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentialsOrBuilder
        getAzureCredentialsOrBuilder() {
      return getAzureCredentials();
    }

    public static final int CONTAINER_FIELD_NUMBER = 4;
    private volatile java.lang.Object container_;
    /**
     *
     *
     * <pre>
     * Required. The container to transfer from the Azure Storage account.
     * </pre>
     *
     * <code>string container = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The container.
     */
    @java.lang.Override
    public java.lang.String getContainer() {
      java.lang.Object ref = container_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        container_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The container to transfer from the Azure Storage account.
     * </pre>
     *
     * <code>string container = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for container.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContainerBytes() {
      java.lang.Object ref = container_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        container_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 5;
    private volatile java.lang.Object path_;
    /**
     *
     *
     * <pre>
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * </pre>
     *
     * <code>string path = 5;</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This field
     * is treated as an object prefix. As such, it should generally not begin with
     * a '/'.
     * </pre>
     *
     * <code>string path = 5;</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageAccount_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, storageAccount_);
      }
      if (azureCredentials_ != null) {
        output.writeMessage(2, getAzureCredentials());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(container_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, container_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, path_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageAccount_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, storageAccount_);
      }
      if (azureCredentials_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAzureCredentials());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(container_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, container_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, path_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData other =
          (com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData) obj;

      if (!getStorageAccount().equals(other.getStorageAccount())) return false;
      if (hasAzureCredentials() != other.hasAzureCredentials()) return false;
      if (hasAzureCredentials()) {
        if (!getAzureCredentials().equals(other.getAzureCredentials())) return false;
      }
      if (!getContainer().equals(other.getContainer())) return false;
      if (!getPath().equals(other.getPath())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STORAGE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getStorageAccount().hashCode();
      if (hasAzureCredentials()) {
        hash = (37 * hash) + AZURE_CREDENTIALS_FIELD_NUMBER;
        hash = (53 * hash) + getAzureCredentials().hashCode();
      }
      hash = (37 * hash) + CONTAINER_FIELD_NUMBER;
      hash = (53 * hash) + getContainer().hashCode();
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An AzureBlobStorageData resource can be a data source, but not a data sink.
     * An AzureBlobStorageData resource represents one Azure container. The storage
     * account determines the [Azure
     * endpoint](https://docs.microsoft.com/en-us/azure/storage/common/storage-create-storage-account#storage-account-endpoints).
     * In an AzureBlobStorageData resource, a blobs's name is the [Azure Blob
     * Storage blob's key
     * name](https://docs.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#blob-names).
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.AzureBlobStorageData}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.AzureBlobStorageData)
        com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AzureBlobStorageData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AzureBlobStorageData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData.class,
                com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        storageAccount_ = "";

        if (azureCredentialsBuilder_ == null) {
          azureCredentials_ = null;
        } else {
          azureCredentials_ = null;
          azureCredentialsBuilder_ = null;
        }
        container_ = "";

        path_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AzureBlobStorageData_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData build() {
        com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData result =
            new com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData(this);
        result.storageAccount_ = storageAccount_;
        if (azureCredentialsBuilder_ == null) {
          result.azureCredentials_ = azureCredentials_;
        } else {
          result.azureCredentials_ = azureCredentialsBuilder_.build();
        }
        result.container_ = container_;
        result.path_ = path_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
                .getDefaultInstance()) return this;
        if (!other.getStorageAccount().isEmpty()) {
          storageAccount_ = other.storageAccount_;
          onChanged();
        }
        if (other.hasAzureCredentials()) {
          mergeAzureCredentials(other.getAzureCredentials());
        }
        if (!other.getContainer().isEmpty()) {
          container_ = other.container_;
          onChanged();
        }
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  storageAccount_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getAzureCredentialsFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              case 34:
                {
                  container_ = input.readStringRequireUtf8();

                  break;
                } // case 34
              case 42:
                {
                  path_ = input.readStringRequireUtf8();

                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object storageAccount_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the Azure Storage account.
       * </pre>
       *
       * <code>string storage_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The storageAccount.
       */
      public java.lang.String getStorageAccount() {
        java.lang.Object ref = storageAccount_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          storageAccount_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the Azure Storage account.
       * </pre>
       *
       * <code>string storage_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for storageAccount.
       */
      public com.google.protobuf.ByteString getStorageAccountBytes() {
        java.lang.Object ref = storageAccount_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          storageAccount_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the Azure Storage account.
       * </pre>
       *
       * <code>string storage_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The storageAccount to set.
       * @return This builder for chaining.
       */
      public Builder setStorageAccount(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        storageAccount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the Azure Storage account.
       * </pre>
       *
       * <code>string storage_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStorageAccount() {

        storageAccount_ = getDefaultInstance().getStorageAccount();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the Azure Storage account.
       * </pre>
       *
       * <code>string storage_account = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for storageAccount to set.
       * @return This builder for chaining.
       */
      public Builder setStorageAccountBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        storageAccount_ = value;
        onChanged();
        return this;
      }

      private com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials azureCredentials_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials,
              com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentialsOrBuilder>
          azureCredentialsBuilder_;
      /**
       *
       *
       * <pre>
       * Required. Input only. Credentials used to authenticate API requests to Azure.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return Whether the azureCredentials field is set.
       */
      public boolean hasAzureCredentials() {
        return azureCredentialsBuilder_ != null || azureCredentials_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. Credentials used to authenticate API requests to Azure.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The azureCredentials.
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials
          getAzureCredentials() {
        if (azureCredentialsBuilder_ == null) {
          return azureCredentials_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials
                  .getDefaultInstance()
              : azureCredentials_;
        } else {
          return azureCredentialsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. Credentials used to authenticate API requests to Azure.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder setAzureCredentials(
          com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials value) {
        if (azureCredentialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          azureCredentials_ = value;
          onChanged();
        } else {
          azureCredentialsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. Credentials used to authenticate API requests to Azure.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder setAzureCredentials(
          com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials.Builder
              builderForValue) {
        if (azureCredentialsBuilder_ == null) {
          azureCredentials_ = builderForValue.build();
          onChanged();
        } else {
          azureCredentialsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. Credentials used to authenticate API requests to Azure.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder mergeAzureCredentials(
          com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials value) {
        if (azureCredentialsBuilder_ == null) {
          if (azureCredentials_ != null) {
            azureCredentials_ =
                com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials.newBuilder(
                        azureCredentials_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            azureCredentials_ = value;
          }
          onChanged();
        } else {
          azureCredentialsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. Credentials used to authenticate API requests to Azure.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public Builder clearAzureCredentials() {
        if (azureCredentialsBuilder_ == null) {
          azureCredentials_ = null;
          onChanged();
        } else {
          azureCredentials_ = null;
          azureCredentialsBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. Credentials used to authenticate API requests to Azure.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials.Builder
          getAzureCredentialsBuilder() {

        onChanged();
        return getAzureCredentialsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. Credentials used to authenticate API requests to Azure.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentialsOrBuilder
          getAzureCredentialsOrBuilder() {
        if (azureCredentialsBuilder_ != null) {
          return azureCredentialsBuilder_.getMessageOrBuilder();
        } else {
          return azureCredentials_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials
                  .getDefaultInstance()
              : azureCredentials_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Input only. Credentials used to authenticate API requests to Azure.
       * For information on our data retention policy for user credentials, see
       * [User credentials](/storage-transfer/docs/data-retention#user-credentials).
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AzureCredentials azure_credentials = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials,
              com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentialsOrBuilder>
          getAzureCredentialsFieldBuilder() {
        if (azureCredentialsBuilder_ == null) {
          azureCredentialsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials,
                  com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentials.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.AzureCredentialsOrBuilder>(
                  getAzureCredentials(), getParentForChildren(), isClean());
          azureCredentials_ = null;
        }
        return azureCredentialsBuilder_;
      }

      private java.lang.Object container_ = "";
      /**
       *
       *
       * <pre>
       * Required. The container to transfer from the Azure Storage account.
       * </pre>
       *
       * <code>string container = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The container.
       */
      public java.lang.String getContainer() {
        java.lang.Object ref = container_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          container_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The container to transfer from the Azure Storage account.
       * </pre>
       *
       * <code>string container = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for container.
       */
      public com.google.protobuf.ByteString getContainerBytes() {
        java.lang.Object ref = container_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          container_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The container to transfer from the Azure Storage account.
       * </pre>
       *
       * <code>string container = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The container to set.
       * @return This builder for chaining.
       */
      public Builder setContainer(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        container_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The container to transfer from the Azure Storage account.
       * </pre>
       *
       * <code>string container = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContainer() {

        container_ = getDefaultInstance().getContainer();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The container to transfer from the Azure Storage account.
       * </pre>
       *
       * <code>string container = 4 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for container to set.
       * @return This builder for chaining.
       */
      public Builder setContainerBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        container_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * </pre>
       *
       * <code>string path = 5;</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * </pre>
       *
       * <code>string path = 5;</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * </pre>
       *
       * <code>string path = 5;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        path_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * </pre>
       *
       * <code>string path = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {

        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This field
       * is treated as an object prefix. As such, it should generally not begin with
       * a '/'.
       * </pre>
       *
       * <code>string path = 5;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        path_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.AzureBlobStorageData)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.AzureBlobStorageData)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AzureBlobStorageData> PARSER =
        new com.google.protobuf.AbstractParser<AzureBlobStorageData>() {
          @java.lang.Override
          public AzureBlobStorageData parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AzureBlobStorageData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AzureBlobStorageData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HttpDataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.HttpData)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The URL that points to the file that stores the object list
     * entries. This file must allow public access.  Currently, only URLs with
     * HTTP and HTTPS schemes are supported.
     * </pre>
     *
     * <code>string list_url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The listUrl.
     */
    java.lang.String getListUrl();
    /**
     *
     *
     * <pre>
     * Required. The URL that points to the file that stores the object list
     * entries. This file must allow public access.  Currently, only URLs with
     * HTTP and HTTPS schemes are supported.
     * </pre>
     *
     * <code>string list_url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for listUrl.
     */
    com.google.protobuf.ByteString getListUrlBytes();
  }
  /**
   *
   *
   * <pre>
   * An HttpData resource specifies a list of objects on the web to be transferred
   * over HTTP.  The information of the objects to be transferred is contained in
   * a file referenced by a URL. The first line in the file must be
   * `"TsvHttpData-1.0"`, which specifies the format of the file.  Subsequent
   * lines specify the information of the list of objects, one object per list
   * entry. Each entry has the following tab-delimited fields:
   * * **HTTP URL** — The location of the object.
   * * **Length** — The size of the object in bytes.
   * * **MD5** — The base64-encoded MD5 hash of the object.
   * For an example of a valid TSV file, see
   * [Transferring data from
   * URLs](https://cloud.google.com/storage-transfer/docs/create-url-list).
   * When transferring data based on a URL list, keep the following in mind:
   * * When an object located at `http(s)://hostname:port/&lt;URL-path&gt;` is
   * transferred to a data sink, the name of the object at the data sink is
   * `&lt;hostname&gt;/&lt;URL-path&gt;`.
   * * If the specified size of an object does not match the actual size of the
   * object fetched, the object is not transferred.
   * * If the specified MD5 does not match the MD5 computed from the transferred
   * bytes, the object transfer fails.
   * * Ensure that each URL you specify is publicly accessible. For
   * example, in Cloud Storage you can
   * [share an object publicly]
   * (/storage/docs/cloud-console#_sharingdata) and get a link to it.
   * * Storage Transfer Service obeys `robots.txt` rules and requires the source
   * HTTP server to support `Range` requests and to return a `Content-Length`
   * header in each response.
   * * [ObjectConditions][google.storagetransfer.v1.ObjectConditions] have no effect when filtering objects to transfer.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.HttpData}
   */
  public static final class HttpData extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.HttpData)
      HttpDataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use HttpData.newBuilder() to construct.
    private HttpData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HttpData() {
      listUrl_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new HttpData();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_HttpData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_HttpData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.HttpData.class,
              com.google.storagetransfer.v1.proto.TransferTypes.HttpData.Builder.class);
    }

    public static final int LIST_URL_FIELD_NUMBER = 1;
    private volatile java.lang.Object listUrl_;
    /**
     *
     *
     * <pre>
     * Required. The URL that points to the file that stores the object list
     * entries. This file must allow public access.  Currently, only URLs with
     * HTTP and HTTPS schemes are supported.
     * </pre>
     *
     * <code>string list_url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The listUrl.
     */
    @java.lang.Override
    public java.lang.String getListUrl() {
      java.lang.Object ref = listUrl_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        listUrl_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The URL that points to the file that stores the object list
     * entries. This file must allow public access.  Currently, only URLs with
     * HTTP and HTTPS schemes are supported.
     * </pre>
     *
     * <code>string list_url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for listUrl.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getListUrlBytes() {
      java.lang.Object ref = listUrl_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        listUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(listUrl_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, listUrl_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(listUrl_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, listUrl_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.HttpData)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.HttpData other =
          (com.google.storagetransfer.v1.proto.TransferTypes.HttpData) obj;

      if (!getListUrl().equals(other.getListUrl())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LIST_URL_FIELD_NUMBER;
      hash = (53 * hash) + getListUrl().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.HttpData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An HttpData resource specifies a list of objects on the web to be transferred
     * over HTTP.  The information of the objects to be transferred is contained in
     * a file referenced by a URL. The first line in the file must be
     * `"TsvHttpData-1.0"`, which specifies the format of the file.  Subsequent
     * lines specify the information of the list of objects, one object per list
     * entry. Each entry has the following tab-delimited fields:
     * * **HTTP URL** — The location of the object.
     * * **Length** — The size of the object in bytes.
     * * **MD5** — The base64-encoded MD5 hash of the object.
     * For an example of a valid TSV file, see
     * [Transferring data from
     * URLs](https://cloud.google.com/storage-transfer/docs/create-url-list).
     * When transferring data based on a URL list, keep the following in mind:
     * * When an object located at `http(s)://hostname:port/&lt;URL-path&gt;` is
     * transferred to a data sink, the name of the object at the data sink is
     * `&lt;hostname&gt;/&lt;URL-path&gt;`.
     * * If the specified size of an object does not match the actual size of the
     * object fetched, the object is not transferred.
     * * If the specified MD5 does not match the MD5 computed from the transferred
     * bytes, the object transfer fails.
     * * Ensure that each URL you specify is publicly accessible. For
     * example, in Cloud Storage you can
     * [share an object publicly]
     * (/storage/docs/cloud-console#_sharingdata) and get a link to it.
     * * Storage Transfer Service obeys `robots.txt` rules and requires the source
     * HTTP server to support `Range` requests and to return a `Content-Length`
     * header in each response.
     * * [ObjectConditions][google.storagetransfer.v1.ObjectConditions] have no effect when filtering objects to transfer.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.HttpData}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.HttpData)
        com.google.storagetransfer.v1.proto.TransferTypes.HttpDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_HttpData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_HttpData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.HttpData.class,
                com.google.storagetransfer.v1.proto.TransferTypes.HttpData.Builder.class);
      }

      // Construct using com.google.storagetransfer.v1.proto.TransferTypes.HttpData.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        listUrl_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_HttpData_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.HttpData
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.HttpData.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.HttpData build() {
        com.google.storagetransfer.v1.proto.TransferTypes.HttpData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.HttpData buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.HttpData result =
            new com.google.storagetransfer.v1.proto.TransferTypes.HttpData(this);
        result.listUrl_ = listUrl_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storagetransfer.v1.proto.TransferTypes.HttpData) {
          return mergeFrom((com.google.storagetransfer.v1.proto.TransferTypes.HttpData) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storagetransfer.v1.proto.TransferTypes.HttpData other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.HttpData.getDefaultInstance())
          return this;
        if (!other.getListUrl().isEmpty()) {
          listUrl_ = other.listUrl_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  listUrl_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object listUrl_ = "";
      /**
       *
       *
       * <pre>
       * Required. The URL that points to the file that stores the object list
       * entries. This file must allow public access.  Currently, only URLs with
       * HTTP and HTTPS schemes are supported.
       * </pre>
       *
       * <code>string list_url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The listUrl.
       */
      public java.lang.String getListUrl() {
        java.lang.Object ref = listUrl_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          listUrl_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The URL that points to the file that stores the object list
       * entries. This file must allow public access.  Currently, only URLs with
       * HTTP and HTTPS schemes are supported.
       * </pre>
       *
       * <code>string list_url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for listUrl.
       */
      public com.google.protobuf.ByteString getListUrlBytes() {
        java.lang.Object ref = listUrl_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          listUrl_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The URL that points to the file that stores the object list
       * entries. This file must allow public access.  Currently, only URLs with
       * HTTP and HTTPS schemes are supported.
       * </pre>
       *
       * <code>string list_url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The listUrl to set.
       * @return This builder for chaining.
       */
      public Builder setListUrl(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        listUrl_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URL that points to the file that stores the object list
       * entries. This file must allow public access.  Currently, only URLs with
       * HTTP and HTTPS schemes are supported.
       * </pre>
       *
       * <code>string list_url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearListUrl() {

        listUrl_ = getDefaultInstance().getListUrl();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The URL that points to the file that stores the object list
       * entries. This file must allow public access.  Currently, only URLs with
       * HTTP and HTTPS schemes are supported.
       * </pre>
       *
       * <code>string list_url = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for listUrl to set.
       * @return This builder for chaining.
       */
      public Builder setListUrlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        listUrl_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.HttpData)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.HttpData)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.HttpData
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storagetransfer.v1.proto.TransferTypes.HttpData();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.HttpData getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HttpData> PARSER =
        new com.google.protobuf.AbstractParser<HttpData>() {
          @java.lang.Override
          public HttpData parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<HttpData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HttpData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.HttpData getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PosixFilesystemOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.PosixFilesystem)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Root directory path to the filesystem.
     * </pre>
     *
     * <code>string root_directory = 1;</code>
     *
     * @return The rootDirectory.
     */
    java.lang.String getRootDirectory();
    /**
     *
     *
     * <pre>
     * Root directory path to the filesystem.
     * </pre>
     *
     * <code>string root_directory = 1;</code>
     *
     * @return The bytes for rootDirectory.
     */
    com.google.protobuf.ByteString getRootDirectoryBytes();
  }
  /**
   *
   *
   * <pre>
   * A POSIX filesystem resource.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.PosixFilesystem}
   */
  public static final class PosixFilesystem extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.PosixFilesystem)
      PosixFilesystemOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PosixFilesystem.newBuilder() to construct.
    private PosixFilesystem(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PosixFilesystem() {
      rootDirectory_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PosixFilesystem();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_PosixFilesystem_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_PosixFilesystem_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.class,
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.Builder.class);
    }

    public static final int ROOT_DIRECTORY_FIELD_NUMBER = 1;
    private volatile java.lang.Object rootDirectory_;
    /**
     *
     *
     * <pre>
     * Root directory path to the filesystem.
     * </pre>
     *
     * <code>string root_directory = 1;</code>
     *
     * @return The rootDirectory.
     */
    @java.lang.Override
    public java.lang.String getRootDirectory() {
      java.lang.Object ref = rootDirectory_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rootDirectory_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Root directory path to the filesystem.
     * </pre>
     *
     * <code>string root_directory = 1;</code>
     *
     * @return The bytes for rootDirectory.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRootDirectoryBytes() {
      java.lang.Object ref = rootDirectory_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rootDirectory_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rootDirectory_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, rootDirectory_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rootDirectory_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, rootDirectory_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem other =
          (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) obj;

      if (!getRootDirectory().equals(other.getRootDirectory())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ROOT_DIRECTORY_FIELD_NUMBER;
      hash = (53 * hash) + getRootDirectory().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A POSIX filesystem resource.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.PosixFilesystem}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.PosixFilesystem)
        com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_PosixFilesystem_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_PosixFilesystem_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.class,
                com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.Builder.class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        rootDirectory_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_PosixFilesystem_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem build() {
        com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem result =
            new com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem(this);
        result.rootDirectory_ = rootDirectory_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
                .getDefaultInstance()) return this;
        if (!other.getRootDirectory().isEmpty()) {
          rootDirectory_ = other.rootDirectory_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  rootDirectory_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object rootDirectory_ = "";
      /**
       *
       *
       * <pre>
       * Root directory path to the filesystem.
       * </pre>
       *
       * <code>string root_directory = 1;</code>
       *
       * @return The rootDirectory.
       */
      public java.lang.String getRootDirectory() {
        java.lang.Object ref = rootDirectory_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          rootDirectory_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Root directory path to the filesystem.
       * </pre>
       *
       * <code>string root_directory = 1;</code>
       *
       * @return The bytes for rootDirectory.
       */
      public com.google.protobuf.ByteString getRootDirectoryBytes() {
        java.lang.Object ref = rootDirectory_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          rootDirectory_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Root directory path to the filesystem.
       * </pre>
       *
       * <code>string root_directory = 1;</code>
       *
       * @param value The rootDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setRootDirectory(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        rootDirectory_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Root directory path to the filesystem.
       * </pre>
       *
       * <code>string root_directory = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRootDirectory() {

        rootDirectory_ = getDefaultInstance().getRootDirectory();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Root directory path to the filesystem.
       * </pre>
       *
       * <code>string root_directory = 1;</code>
       *
       * @param value The bytes for rootDirectory to set.
       * @return This builder for chaining.
       */
      public Builder setRootDirectoryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        rootDirectory_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.PosixFilesystem)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.PosixFilesystem)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PosixFilesystem> PARSER =
        new com.google.protobuf.AbstractParser<PosixFilesystem>() {
          @java.lang.Override
          public PosixFilesystem parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PosixFilesystem> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PosixFilesystem> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AwsS3CompatibleDataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.AwsS3CompatibleData)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Specifies the name of the bucket.
     * </pre>
     *
     * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucketName.
     */
    java.lang.String getBucketName();
    /**
     *
     *
     * <pre>
     * Required. Specifies the name of the bucket.
     * </pre>
     *
     * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucketName.
     */
    com.google.protobuf.ByteString getBucketNameBytes();

    /**
     *
     *
     * <pre>
     * Specifies the root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This
     * field is treated as an object prefix. As such, it should generally not
     * begin with a '/'.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The path.
     */
    java.lang.String getPath();
    /**
     *
     *
     * <pre>
     * Specifies the root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This
     * field is treated as an object prefix. As such, it should generally not
     * begin with a '/'.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The bytes for path.
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * Required. Specifies the endpoint of the storage service.
     * </pre>
     *
     * <code>string endpoint = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The endpoint.
     */
    java.lang.String getEndpoint();
    /**
     *
     *
     * <pre>
     * Required. Specifies the endpoint of the storage service.
     * </pre>
     *
     * <code>string endpoint = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for endpoint.
     */
    com.google.protobuf.ByteString getEndpointBytes();

    /**
     *
     *
     * <pre>
     * Specifies the region to sign requests with. This can be left blank if
     * requests should be signed with an empty region.
     * </pre>
     *
     * <code>string region = 5;</code>
     *
     * @return The region.
     */
    java.lang.String getRegion();
    /**
     *
     *
     * <pre>
     * Specifies the region to sign requests with. This can be left blank if
     * requests should be signed with an empty region.
     * </pre>
     *
     * <code>string region = 5;</code>
     *
     * @return The bytes for region.
     */
    com.google.protobuf.ByteString getRegionBytes();

    /**
     *
     *
     * <pre>
     * A S3 compatible metadata.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
     *
     * @return Whether the s3Metadata field is set.
     */
    boolean hasS3Metadata();
    /**
     *
     *
     * <pre>
     * A S3 compatible metadata.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
     *
     * @return The s3Metadata.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata getS3Metadata();
    /**
     *
     *
     * <pre>
     * A S3 compatible metadata.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadataOrBuilder
        getS3MetadataOrBuilder();

    public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData.DataProviderCase
        getDataProviderCase();
  }
  /**
   *
   *
   * <pre>
   * An AwsS3CompatibleData resource.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.AwsS3CompatibleData}
   */
  public static final class AwsS3CompatibleData extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.AwsS3CompatibleData)
      AwsS3CompatibleDataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AwsS3CompatibleData.newBuilder() to construct.
    private AwsS3CompatibleData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AwsS3CompatibleData() {
      bucketName_ = "";
      path_ = "";
      endpoint_ = "";
      region_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AwsS3CompatibleData();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_AwsS3CompatibleData_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_AwsS3CompatibleData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData.class,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData.Builder.class);
    }

    private int dataProviderCase_ = 0;
    private java.lang.Object dataProvider_;

    public enum DataProviderCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      S3_METADATA(4),
      DATAPROVIDER_NOT_SET(0);
      private final int value;

      private DataProviderCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DataProviderCase valueOf(int value) {
        return forNumber(value);
      }

      public static DataProviderCase forNumber(int value) {
        switch (value) {
          case 4:
            return S3_METADATA;
          case 0:
            return DATAPROVIDER_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DataProviderCase getDataProviderCase() {
      return DataProviderCase.forNumber(dataProviderCase_);
    }

    public static final int BUCKET_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object bucketName_;
    /**
     *
     *
     * <pre>
     * Required. Specifies the name of the bucket.
     * </pre>
     *
     * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucketName.
     */
    @java.lang.Override
    public java.lang.String getBucketName() {
      java.lang.Object ref = bucketName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucketName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the name of the bucket.
     * </pre>
     *
     * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucketName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBucketNameBytes() {
      java.lang.Object ref = bucketName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucketName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 2;
    private volatile java.lang.Object path_;
    /**
     *
     *
     * <pre>
     * Specifies the root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This
     * field is treated as an object prefix. As such, it should generally not
     * begin with a '/'.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The path.
     */
    @java.lang.Override
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the root path to transfer objects.
     * Must be an empty string or full path name that ends with a '/'. This
     * field is treated as an object prefix. As such, it should generally not
     * begin with a '/'.
     * </pre>
     *
     * <code>string path = 2;</code>
     *
     * @return The bytes for path.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ENDPOINT_FIELD_NUMBER = 3;
    private volatile java.lang.Object endpoint_;
    /**
     *
     *
     * <pre>
     * Required. Specifies the endpoint of the storage service.
     * </pre>
     *
     * <code>string endpoint = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The endpoint.
     */
    @java.lang.Override
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies the endpoint of the storage service.
     * </pre>
     *
     * <code>string endpoint = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for endpoint.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REGION_FIELD_NUMBER = 5;
    private volatile java.lang.Object region_;
    /**
     *
     *
     * <pre>
     * Specifies the region to sign requests with. This can be left blank if
     * requests should be signed with an empty region.
     * </pre>
     *
     * <code>string region = 5;</code>
     *
     * @return The region.
     */
    @java.lang.Override
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the region to sign requests with. This can be left blank if
     * requests should be signed with an empty region.
     * </pre>
     *
     * <code>string region = 5;</code>
     *
     * @return The bytes for region.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int S3_METADATA_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * A S3 compatible metadata.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
     *
     * @return Whether the s3Metadata field is set.
     */
    @java.lang.Override
    public boolean hasS3Metadata() {
      return dataProviderCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A S3 compatible metadata.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
     *
     * @return The s3Metadata.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata getS3Metadata() {
      if (dataProviderCase_ == 4) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata)
            dataProvider_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A S3 compatible metadata.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadataOrBuilder
        getS3MetadataOrBuilder() {
      if (dataProviderCase_ == 4) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata)
            dataProvider_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucketName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, endpoint_);
      }
      if (dataProviderCase_ == 4) {
        output.writeMessage(
            4,
            (com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata) dataProvider_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, region_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, bucketName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, path_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, endpoint_);
      }
      if (dataProviderCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4,
                (com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata)
                    dataProvider_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(region_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, region_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData other =
          (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData) obj;

      if (!getBucketName().equals(other.getBucketName())) return false;
      if (!getPath().equals(other.getPath())) return false;
      if (!getEndpoint().equals(other.getEndpoint())) return false;
      if (!getRegion().equals(other.getRegion())) return false;
      if (!getDataProviderCase().equals(other.getDataProviderCase())) return false;
      switch (dataProviderCase_) {
        case 4:
          if (!getS3Metadata().equals(other.getS3Metadata())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BUCKET_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getBucketName().hashCode();
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPath().hashCode();
      hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getEndpoint().hashCode();
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
      switch (dataProviderCase_) {
        case 4:
          hash = (37 * hash) + S3_METADATA_FIELD_NUMBER;
          hash = (53 * hash) + getS3Metadata().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An AwsS3CompatibleData resource.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.AwsS3CompatibleData}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.AwsS3CompatibleData)
        com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AwsS3CompatibleData_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AwsS3CompatibleData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData.class,
                com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bucketName_ = "";

        path_ = "";

        endpoint_ = "";

        region_ = "";

        if (s3MetadataBuilder_ != null) {
          s3MetadataBuilder_.clear();
        }
        dataProviderCase_ = 0;
        dataProvider_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AwsS3CompatibleData_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData build() {
        com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData result =
            new com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData(this);
        result.bucketName_ = bucketName_;
        result.path_ = path_;
        result.endpoint_ = endpoint_;
        result.region_ = region_;
        if (dataProviderCase_ == 4) {
          if (s3MetadataBuilder_ == null) {
            result.dataProvider_ = dataProvider_;
          } else {
            result.dataProvider_ = s3MetadataBuilder_.build();
          }
        }
        result.dataProviderCase_ = dataProviderCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
                .getDefaultInstance()) return this;
        if (!other.getBucketName().isEmpty()) {
          bucketName_ = other.bucketName_;
          onChanged();
        }
        if (!other.getPath().isEmpty()) {
          path_ = other.path_;
          onChanged();
        }
        if (!other.getEndpoint().isEmpty()) {
          endpoint_ = other.endpoint_;
          onChanged();
        }
        if (!other.getRegion().isEmpty()) {
          region_ = other.region_;
          onChanged();
        }
        switch (other.getDataProviderCase()) {
          case S3_METADATA:
            {
              mergeS3Metadata(other.getS3Metadata());
              break;
            }
          case DATAPROVIDER_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  bucketName_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  path_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 26:
                {
                  endpoint_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getS3MetadataFieldBuilder().getBuilder(), extensionRegistry);
                  dataProviderCase_ = 4;
                  break;
                } // case 34
              case 42:
                {
                  region_ = input.readStringRequireUtf8();

                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int dataProviderCase_ = 0;
      private java.lang.Object dataProvider_;

      public DataProviderCase getDataProviderCase() {
        return DataProviderCase.forNumber(dataProviderCase_);
      }

      public Builder clearDataProvider() {
        dataProviderCase_ = 0;
        dataProvider_ = null;
        onChanged();
        return this;
      }

      private java.lang.Object bucketName_ = "";
      /**
       *
       *
       * <pre>
       * Required. Specifies the name of the bucket.
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bucketName.
       */
      public java.lang.String getBucketName() {
        java.lang.Object ref = bucketName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bucketName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies the name of the bucket.
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for bucketName.
       */
      public com.google.protobuf.ByteString getBucketNameBytes() {
        java.lang.Object ref = bucketName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bucketName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies the name of the bucket.
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bucketName to set.
       * @return This builder for chaining.
       */
      public Builder setBucketName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        bucketName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies the name of the bucket.
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBucketName() {

        bucketName_ = getDefaultInstance().getBucketName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies the name of the bucket.
       * </pre>
       *
       * <code>string bucket_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for bucketName to set.
       * @return This builder for chaining.
       */
      public Builder setBucketNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        bucketName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       *
       *
       * <pre>
       * Specifies the root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This
       * field is treated as an object prefix. As such, it should generally not
       * begin with a '/'.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return The path.
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          path_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This
       * field is treated as an object prefix. As such, it should generally not
       * begin with a '/'.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return The bytes for path.
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This
       * field is treated as an object prefix. As such, it should generally not
       * begin with a '/'.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @param value The path to set.
       * @return This builder for chaining.
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        path_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This
       * field is treated as an object prefix. As such, it should generally not
       * begin with a '/'.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPath() {

        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the root path to transfer objects.
       * Must be an empty string or full path name that ends with a '/'. This
       * field is treated as an object prefix. As such, it should generally not
       * begin with a '/'.
       * </pre>
       *
       * <code>string path = 2;</code>
       *
       * @param value The bytes for path to set.
       * @return This builder for chaining.
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        path_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object endpoint_ = "";
      /**
       *
       *
       * <pre>
       * Required. Specifies the endpoint of the storage service.
       * </pre>
       *
       * <code>string endpoint = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The endpoint.
       */
      public java.lang.String getEndpoint() {
        java.lang.Object ref = endpoint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          endpoint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies the endpoint of the storage service.
       * </pre>
       *
       * <code>string endpoint = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for endpoint.
       */
      public com.google.protobuf.ByteString getEndpointBytes() {
        java.lang.Object ref = endpoint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          endpoint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies the endpoint of the storage service.
       * </pre>
       *
       * <code>string endpoint = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The endpoint to set.
       * @return This builder for chaining.
       */
      public Builder setEndpoint(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        endpoint_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies the endpoint of the storage service.
       * </pre>
       *
       * <code>string endpoint = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndpoint() {

        endpoint_ = getDefaultInstance().getEndpoint();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies the endpoint of the storage service.
       * </pre>
       *
       * <code>string endpoint = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for endpoint to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        endpoint_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object region_ = "";
      /**
       *
       *
       * <pre>
       * Specifies the region to sign requests with. This can be left blank if
       * requests should be signed with an empty region.
       * </pre>
       *
       * <code>string region = 5;</code>
       *
       * @return The region.
       */
      public java.lang.String getRegion() {
        java.lang.Object ref = region_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          region_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the region to sign requests with. This can be left blank if
       * requests should be signed with an empty region.
       * </pre>
       *
       * <code>string region = 5;</code>
       *
       * @return The bytes for region.
       */
      public com.google.protobuf.ByteString getRegionBytes() {
        java.lang.Object ref = region_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          region_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the region to sign requests with. This can be left blank if
       * requests should be signed with an empty region.
       * </pre>
       *
       * <code>string region = 5;</code>
       *
       * @param value The region to set.
       * @return This builder for chaining.
       */
      public Builder setRegion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        region_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the region to sign requests with. This can be left blank if
       * requests should be signed with an empty region.
       * </pre>
       *
       * <code>string region = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRegion() {

        region_ = getDefaultInstance().getRegion();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the region to sign requests with. This can be left blank if
       * requests should be signed with an empty region.
       * </pre>
       *
       * <code>string region = 5;</code>
       *
       * @param value The bytes for region to set.
       * @return This builder for chaining.
       */
      public Builder setRegionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        region_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata,
              com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadataOrBuilder>
          s3MetadataBuilder_;
      /**
       *
       *
       * <pre>
       * A S3 compatible metadata.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
       *
       * @return Whether the s3Metadata field is set.
       */
      @java.lang.Override
      public boolean hasS3Metadata() {
        return dataProviderCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * A S3 compatible metadata.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
       *
       * @return The s3Metadata.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
          getS3Metadata() {
        if (s3MetadataBuilder_ == null) {
          if (dataProviderCase_ == 4) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata)
                dataProvider_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
              .getDefaultInstance();
        } else {
          if (dataProviderCase_ == 4) {
            return s3MetadataBuilder_.getMessage();
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A S3 compatible metadata.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
       */
      public Builder setS3Metadata(
          com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata value) {
        if (s3MetadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataProvider_ = value;
          onChanged();
        } else {
          s3MetadataBuilder_.setMessage(value);
        }
        dataProviderCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A S3 compatible metadata.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
       */
      public Builder setS3Metadata(
          com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.Builder
              builderForValue) {
        if (s3MetadataBuilder_ == null) {
          dataProvider_ = builderForValue.build();
          onChanged();
        } else {
          s3MetadataBuilder_.setMessage(builderForValue.build());
        }
        dataProviderCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A S3 compatible metadata.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
       */
      public Builder mergeS3Metadata(
          com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata value) {
        if (s3MetadataBuilder_ == null) {
          if (dataProviderCase_ == 4
              && dataProvider_
                  != com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
                      .getDefaultInstance()) {
            dataProvider_ =
                com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.newBuilder(
                        (com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata)
                            dataProvider_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataProvider_ = value;
          }
          onChanged();
        } else {
          if (dataProviderCase_ == 4) {
            s3MetadataBuilder_.mergeFrom(value);
          } else {
            s3MetadataBuilder_.setMessage(value);
          }
        }
        dataProviderCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A S3 compatible metadata.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
       */
      public Builder clearS3Metadata() {
        if (s3MetadataBuilder_ == null) {
          if (dataProviderCase_ == 4) {
            dataProviderCase_ = 0;
            dataProvider_ = null;
            onChanged();
          }
        } else {
          if (dataProviderCase_ == 4) {
            dataProviderCase_ = 0;
            dataProvider_ = null;
          }
          s3MetadataBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A S3 compatible metadata.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.Builder
          getS3MetadataBuilder() {
        return getS3MetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A S3 compatible metadata.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadataOrBuilder
          getS3MetadataOrBuilder() {
        if ((dataProviderCase_ == 4) && (s3MetadataBuilder_ != null)) {
          return s3MetadataBuilder_.getMessageOrBuilder();
        } else {
          if (dataProviderCase_ == 4) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata)
                dataProvider_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A S3 compatible metadata.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata s3_metadata = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata,
              com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadataOrBuilder>
          getS3MetadataFieldBuilder() {
        if (s3MetadataBuilder_ == null) {
          if (!(dataProviderCase_ == 4)) {
            dataProvider_ =
                com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
                    .getDefaultInstance();
          }
          s3MetadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata,
                  com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadataOrBuilder>(
                  (com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata)
                      dataProvider_,
                  getParentForChildren(),
                  isClean());
          dataProvider_ = null;
        }
        dataProviderCase_ = 4;
        onChanged();
        ;
        return s3MetadataBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.AwsS3CompatibleData)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.AwsS3CompatibleData)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AwsS3CompatibleData> PARSER =
        new com.google.protobuf.AbstractParser<AwsS3CompatibleData>() {
          @java.lang.Override
          public AwsS3CompatibleData parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AwsS3CompatibleData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AwsS3CompatibleData> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface S3CompatibleMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.S3CompatibleMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specifies the authentication and authorization method used by the storage
     * service. When not specified, Transfer Service will attempt to determine
     * right auth method to use.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod auth_method = 1;</code>
     *
     * @return The enum numeric value on the wire for authMethod.
     */
    int getAuthMethodValue();
    /**
     *
     *
     * <pre>
     * Specifies the authentication and authorization method used by the storage
     * service. When not specified, Transfer Service will attempt to determine
     * right auth method to use.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod auth_method = 1;</code>
     *
     * @return The authMethod.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.AuthMethod
        getAuthMethod();

    /**
     *
     *
     * <pre>
     * Specifies the API request model used to call the storage service. When not
     * specified, the default value of RequestModel
     * REQUEST_MODEL_VIRTUAL_HOSTED_STYLE is used.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.RequestModel request_model = 2;</code>
     *
     * @return The enum numeric value on the wire for requestModel.
     */
    int getRequestModelValue();
    /**
     *
     *
     * <pre>
     * Specifies the API request model used to call the storage service. When not
     * specified, the default value of RequestModel
     * REQUEST_MODEL_VIRTUAL_HOSTED_STYLE is used.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.RequestModel request_model = 2;</code>
     *
     * @return The requestModel.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.RequestModel
        getRequestModel();

    /**
     *
     *
     * <pre>
     * Specifies the network protocol of the agent. When not specified, the
     * default value of NetworkProtocol NETWORK_PROTOCOL_HTTPS is used.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol protocol = 3;</code>
     *
     * @return The enum numeric value on the wire for protocol.
     */
    int getProtocolValue();
    /**
     *
     *
     * <pre>
     * Specifies the network protocol of the agent. When not specified, the
     * default value of NetworkProtocol NETWORK_PROTOCOL_HTTPS is used.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol protocol = 3;</code>
     *
     * @return The protocol.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.NetworkProtocol
        getProtocol();

    /**
     *
     *
     * <pre>
     * The Listing API to use for discovering objects. When not specified,
     * Transfer Service will attempt to determine the right API to use.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.ListApi list_api = 4;</code>
     *
     * @return The enum numeric value on the wire for listApi.
     */
    int getListApiValue();
    /**
     *
     *
     * <pre>
     * The Listing API to use for discovering objects. When not specified,
     * Transfer Service will attempt to determine the right API to use.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.ListApi list_api = 4;</code>
     *
     * @return The listApi.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.ListApi getListApi();
  }
  /**
   *
   *
   * <pre>
   * S3CompatibleMetadata contains the metadata fields that apply to the basic
   * types of S3-compatible data providers.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.S3CompatibleMetadata}
   */
  public static final class S3CompatibleMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.S3CompatibleMetadata)
      S3CompatibleMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use S3CompatibleMetadata.newBuilder() to construct.
    private S3CompatibleMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private S3CompatibleMetadata() {
      authMethod_ = 0;
      requestModel_ = 0;
      protocol_ = 0;
      listApi_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new S3CompatibleMetadata();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_S3CompatibleMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_S3CompatibleMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.class,
              com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The authentication and authorization method used by the storage service.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod}
     */
    public enum AuthMethod implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * AuthMethod is not specified.
       * </pre>
       *
       * <code>AUTH_METHOD_UNSPECIFIED = 0;</code>
       */
      AUTH_METHOD_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Auth requests with AWS SigV4.
       * </pre>
       *
       * <code>AUTH_METHOD_AWS_SIGNATURE_V4 = 1;</code>
       */
      AUTH_METHOD_AWS_SIGNATURE_V4(1),
      /**
       *
       *
       * <pre>
       * Auth requests with AWS SigV2.
       * </pre>
       *
       * <code>AUTH_METHOD_AWS_SIGNATURE_V2 = 2;</code>
       */
      AUTH_METHOD_AWS_SIGNATURE_V2(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * AuthMethod is not specified.
       * </pre>
       *
       * <code>AUTH_METHOD_UNSPECIFIED = 0;</code>
       */
      public static final int AUTH_METHOD_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Auth requests with AWS SigV4.
       * </pre>
       *
       * <code>AUTH_METHOD_AWS_SIGNATURE_V4 = 1;</code>
       */
      public static final int AUTH_METHOD_AWS_SIGNATURE_V4_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Auth requests with AWS SigV2.
       * </pre>
       *
       * <code>AUTH_METHOD_AWS_SIGNATURE_V2 = 2;</code>
       */
      public static final int AUTH_METHOD_AWS_SIGNATURE_V2_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static AuthMethod valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static AuthMethod forNumber(int value) {
        switch (value) {
          case 0:
            return AUTH_METHOD_UNSPECIFIED;
          case 1:
            return AUTH_METHOD_AWS_SIGNATURE_V4;
          case 2:
            return AUTH_METHOD_AWS_SIGNATURE_V2;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<AuthMethod> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<AuthMethod> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<AuthMethod>() {
            public AuthMethod findValueByNumber(int number) {
              return AuthMethod.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final AuthMethod[] VALUES = values();

      public static AuthMethod valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private AuthMethod(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod)
    }

    /**
     *
     *
     * <pre>
     * The request model of the API.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.S3CompatibleMetadata.RequestModel}
     */
    public enum RequestModel implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * RequestModel is not specified.
       * </pre>
       *
       * <code>REQUEST_MODEL_UNSPECIFIED = 0;</code>
       */
      REQUEST_MODEL_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Perform requests using Virtual Hosted Style.
       * Example: https://bucket-name.s3.region.amazonaws.com/key-name
       * </pre>
       *
       * <code>REQUEST_MODEL_VIRTUAL_HOSTED_STYLE = 1;</code>
       */
      REQUEST_MODEL_VIRTUAL_HOSTED_STYLE(1),
      /**
       *
       *
       * <pre>
       * Perform requests using Path Style.
       * Example: https://s3.region.amazonaws.com/bucket-name/key-name
       * </pre>
       *
       * <code>REQUEST_MODEL_PATH_STYLE = 2;</code>
       */
      REQUEST_MODEL_PATH_STYLE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * RequestModel is not specified.
       * </pre>
       *
       * <code>REQUEST_MODEL_UNSPECIFIED = 0;</code>
       */
      public static final int REQUEST_MODEL_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Perform requests using Virtual Hosted Style.
       * Example: https://bucket-name.s3.region.amazonaws.com/key-name
       * </pre>
       *
       * <code>REQUEST_MODEL_VIRTUAL_HOSTED_STYLE = 1;</code>
       */
      public static final int REQUEST_MODEL_VIRTUAL_HOSTED_STYLE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Perform requests using Path Style.
       * Example: https://s3.region.amazonaws.com/bucket-name/key-name
       * </pre>
       *
       * <code>REQUEST_MODEL_PATH_STYLE = 2;</code>
       */
      public static final int REQUEST_MODEL_PATH_STYLE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RequestModel valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static RequestModel forNumber(int value) {
        switch (value) {
          case 0:
            return REQUEST_MODEL_UNSPECIFIED;
          case 1:
            return REQUEST_MODEL_VIRTUAL_HOSTED_STYLE;
          case 2:
            return REQUEST_MODEL_PATH_STYLE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<RequestModel> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<RequestModel> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<RequestModel>() {
            public RequestModel findValueByNumber(int number) {
              return RequestModel.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
            .getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final RequestModel[] VALUES = values();

      public static RequestModel valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private RequestModel(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.S3CompatibleMetadata.RequestModel)
    }

    /**
     *
     *
     * <pre>
     * The agent network protocol to access the storage service.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol}
     */
    public enum NetworkProtocol implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * NetworkProtocol is not specified.
       * </pre>
       *
       * <code>NETWORK_PROTOCOL_UNSPECIFIED = 0;</code>
       */
      NETWORK_PROTOCOL_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Perform requests using HTTPS.
       * </pre>
       *
       * <code>NETWORK_PROTOCOL_HTTPS = 1;</code>
       */
      NETWORK_PROTOCOL_HTTPS(1),
      /**
       *
       *
       * <pre>
       * Not recommended: This sends data in clear-text. This is only
       * appropriate within a closed network or for publicly available data.
       * Perform requests using HTTP.
       * </pre>
       *
       * <code>NETWORK_PROTOCOL_HTTP = 2;</code>
       */
      NETWORK_PROTOCOL_HTTP(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * NetworkProtocol is not specified.
       * </pre>
       *
       * <code>NETWORK_PROTOCOL_UNSPECIFIED = 0;</code>
       */
      public static final int NETWORK_PROTOCOL_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Perform requests using HTTPS.
       * </pre>
       *
       * <code>NETWORK_PROTOCOL_HTTPS = 1;</code>
       */
      public static final int NETWORK_PROTOCOL_HTTPS_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Not recommended: This sends data in clear-text. This is only
       * appropriate within a closed network or for publicly available data.
       * Perform requests using HTTP.
       * </pre>
       *
       * <code>NETWORK_PROTOCOL_HTTP = 2;</code>
       */
      public static final int NETWORK_PROTOCOL_HTTP_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static NetworkProtocol valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static NetworkProtocol forNumber(int value) {
        switch (value) {
          case 0:
            return NETWORK_PROTOCOL_UNSPECIFIED;
          case 1:
            return NETWORK_PROTOCOL_HTTPS;
          case 2:
            return NETWORK_PROTOCOL_HTTP;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<NetworkProtocol>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<NetworkProtocol>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<NetworkProtocol>() {
                public NetworkProtocol findValueByNumber(int number) {
                  return NetworkProtocol.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
            .getDescriptor()
            .getEnumTypes()
            .get(2);
      }

      private static final NetworkProtocol[] VALUES = values();

      public static NetworkProtocol valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private NetworkProtocol(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol)
    }

    /**
     *
     *
     * <pre>
     * The Listing API to use for discovering objects.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.S3CompatibleMetadata.ListApi}
     */
    public enum ListApi implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * ListApi is not specified.
       * </pre>
       *
       * <code>LIST_API_UNSPECIFIED = 0;</code>
       */
      LIST_API_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Perform listing using ListObjectsV2 API.
       * </pre>
       *
       * <code>LIST_OBJECTS_V2 = 1;</code>
       */
      LIST_OBJECTS_V2(1),
      /**
       *
       *
       * <pre>
       * Legacy ListObjects API.
       * </pre>
       *
       * <code>LIST_OBJECTS = 2;</code>
       */
      LIST_OBJECTS(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * ListApi is not specified.
       * </pre>
       *
       * <code>LIST_API_UNSPECIFIED = 0;</code>
       */
      public static final int LIST_API_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Perform listing using ListObjectsV2 API.
       * </pre>
       *
       * <code>LIST_OBJECTS_V2 = 1;</code>
       */
      public static final int LIST_OBJECTS_V2_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Legacy ListObjects API.
       * </pre>
       *
       * <code>LIST_OBJECTS = 2;</code>
       */
      public static final int LIST_OBJECTS_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ListApi valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ListApi forNumber(int value) {
        switch (value) {
          case 0:
            return LIST_API_UNSPECIFIED;
          case 1:
            return LIST_OBJECTS_V2;
          case 2:
            return LIST_OBJECTS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ListApi> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ListApi> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ListApi>() {
            public ListApi findValueByNumber(int number) {
              return ListApi.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
            .getDescriptor()
            .getEnumTypes()
            .get(3);
      }

      private static final ListApi[] VALUES = values();

      public static ListApi valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ListApi(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.S3CompatibleMetadata.ListApi)
    }

    public static final int AUTH_METHOD_FIELD_NUMBER = 1;
    private int authMethod_;
    /**
     *
     *
     * <pre>
     * Specifies the authentication and authorization method used by the storage
     * service. When not specified, Transfer Service will attempt to determine
     * right auth method to use.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod auth_method = 1;</code>
     *
     * @return The enum numeric value on the wire for authMethod.
     */
    @java.lang.Override
    public int getAuthMethodValue() {
      return authMethod_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the authentication and authorization method used by the storage
     * service. When not specified, Transfer Service will attempt to determine
     * right auth method to use.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod auth_method = 1;</code>
     *
     * @return The authMethod.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.AuthMethod
        getAuthMethod() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.AuthMethod result =
          com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.AuthMethod.valueOf(
              authMethod_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.AuthMethod
              .UNRECOGNIZED
          : result;
    }

    public static final int REQUEST_MODEL_FIELD_NUMBER = 2;
    private int requestModel_;
    /**
     *
     *
     * <pre>
     * Specifies the API request model used to call the storage service. When not
     * specified, the default value of RequestModel
     * REQUEST_MODEL_VIRTUAL_HOSTED_STYLE is used.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.RequestModel request_model = 2;</code>
     *
     * @return The enum numeric value on the wire for requestModel.
     */
    @java.lang.Override
    public int getRequestModelValue() {
      return requestModel_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the API request model used to call the storage service. When not
     * specified, the default value of RequestModel
     * REQUEST_MODEL_VIRTUAL_HOSTED_STYLE is used.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.RequestModel request_model = 2;</code>
     *
     * @return The requestModel.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.RequestModel
        getRequestModel() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.RequestModel result =
          com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.RequestModel
              .valueOf(requestModel_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.RequestModel
              .UNRECOGNIZED
          : result;
    }

    public static final int PROTOCOL_FIELD_NUMBER = 3;
    private int protocol_;
    /**
     *
     *
     * <pre>
     * Specifies the network protocol of the agent. When not specified, the
     * default value of NetworkProtocol NETWORK_PROTOCOL_HTTPS is used.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol protocol = 3;</code>
     *
     * @return The enum numeric value on the wire for protocol.
     */
    @java.lang.Override
    public int getProtocolValue() {
      return protocol_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the network protocol of the agent. When not specified, the
     * default value of NetworkProtocol NETWORK_PROTOCOL_HTTPS is used.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol protocol = 3;</code>
     *
     * @return The protocol.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.NetworkProtocol
        getProtocol() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.NetworkProtocol
          result =
              com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.NetworkProtocol
                  .valueOf(protocol_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.NetworkProtocol
              .UNRECOGNIZED
          : result;
    }

    public static final int LIST_API_FIELD_NUMBER = 4;
    private int listApi_;
    /**
     *
     *
     * <pre>
     * The Listing API to use for discovering objects. When not specified,
     * Transfer Service will attempt to determine the right API to use.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.ListApi list_api = 4;</code>
     *
     * @return The enum numeric value on the wire for listApi.
     */
    @java.lang.Override
    public int getListApiValue() {
      return listApi_;
    }
    /**
     *
     *
     * <pre>
     * The Listing API to use for discovering objects. When not specified,
     * Transfer Service will attempt to determine the right API to use.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.S3CompatibleMetadata.ListApi list_api = 4;</code>
     *
     * @return The listApi.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.ListApi
        getListApi() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.ListApi result =
          com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.ListApi.valueOf(
              listApi_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.ListApi
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (authMethod_
          != com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.AuthMethod
              .AUTH_METHOD_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, authMethod_);
      }
      if (requestModel_
          != com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.RequestModel
              .REQUEST_MODEL_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, requestModel_);
      }
      if (protocol_
          != com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.NetworkProtocol
              .NETWORK_PROTOCOL_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, protocol_);
      }
      if (listApi_
          != com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.ListApi
              .LIST_API_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, listApi_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (authMethod_
          != com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.AuthMethod
              .AUTH_METHOD_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, authMethod_);
      }
      if (requestModel_
          != com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.RequestModel
              .REQUEST_MODEL_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, requestModel_);
      }
      if (protocol_
          != com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.NetworkProtocol
              .NETWORK_PROTOCOL_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, protocol_);
      }
      if (listApi_
          != com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.ListApi
              .LIST_API_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, listApi_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata other =
          (com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata) obj;

      if (authMethod_ != other.authMethod_) return false;
      if (requestModel_ != other.requestModel_) return false;
      if (protocol_ != other.protocol_) return false;
      if (listApi_ != other.listApi_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + AUTH_METHOD_FIELD_NUMBER;
      hash = (53 * hash) + authMethod_;
      hash = (37 * hash) + REQUEST_MODEL_FIELD_NUMBER;
      hash = (53 * hash) + requestModel_;
      hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
      hash = (53 * hash) + protocol_;
      hash = (37 * hash) + LIST_API_FIELD_NUMBER;
      hash = (53 * hash) + listApi_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * S3CompatibleMetadata contains the metadata fields that apply to the basic
     * types of S3-compatible data providers.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.S3CompatibleMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.S3CompatibleMetadata)
        com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_S3CompatibleMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_S3CompatibleMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.class,
                com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        authMethod_ = 0;

        requestModel_ = 0;

        protocol_ = 0;

        listApi_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_S3CompatibleMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata build() {
        com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata result =
            new com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata(this);
        result.authMethod_ = authMethod_;
        result.requestModel_ = requestModel_;
        result.protocol_ = protocol_;
        result.listApi_ = listApi_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
                .getDefaultInstance()) return this;
        if (other.authMethod_ != 0) {
          setAuthMethodValue(other.getAuthMethodValue());
        }
        if (other.requestModel_ != 0) {
          setRequestModelValue(other.getRequestModelValue());
        }
        if (other.protocol_ != 0) {
          setProtocolValue(other.getProtocolValue());
        }
        if (other.listApi_ != 0) {
          setListApiValue(other.getListApiValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  authMethod_ = input.readEnum();

                  break;
                } // case 8
              case 16:
                {
                  requestModel_ = input.readEnum();

                  break;
                } // case 16
              case 24:
                {
                  protocol_ = input.readEnum();

                  break;
                } // case 24
              case 32:
                {
                  listApi_ = input.readEnum();

                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int authMethod_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies the authentication and authorization method used by the storage
       * service. When not specified, Transfer Service will attempt to determine
       * right auth method to use.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod auth_method = 1;</code>
       *
       * @return The enum numeric value on the wire for authMethod.
       */
      @java.lang.Override
      public int getAuthMethodValue() {
        return authMethod_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the authentication and authorization method used by the storage
       * service. When not specified, Transfer Service will attempt to determine
       * right auth method to use.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod auth_method = 1;</code>
       *
       * @param value The enum numeric value on the wire for authMethod to set.
       * @return This builder for chaining.
       */
      public Builder setAuthMethodValue(int value) {

        authMethod_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the authentication and authorization method used by the storage
       * service. When not specified, Transfer Service will attempt to determine
       * right auth method to use.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod auth_method = 1;</code>
       *
       * @return The authMethod.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.AuthMethod
          getAuthMethod() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.AuthMethod result =
            com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.AuthMethod
                .valueOf(authMethod_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.AuthMethod
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies the authentication and authorization method used by the storage
       * service. When not specified, Transfer Service will attempt to determine
       * right auth method to use.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod auth_method = 1;</code>
       *
       * @param value The authMethod to set.
       * @return This builder for chaining.
       */
      public Builder setAuthMethod(
          com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.AuthMethod value) {
        if (value == null) {
          throw new NullPointerException();
        }

        authMethod_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the authentication and authorization method used by the storage
       * service. When not specified, Transfer Service will attempt to determine
       * right auth method to use.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.AuthMethod auth_method = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAuthMethod() {

        authMethod_ = 0;
        onChanged();
        return this;
      }

      private int requestModel_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies the API request model used to call the storage service. When not
       * specified, the default value of RequestModel
       * REQUEST_MODEL_VIRTUAL_HOSTED_STYLE is used.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.RequestModel request_model = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for requestModel.
       */
      @java.lang.Override
      public int getRequestModelValue() {
        return requestModel_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the API request model used to call the storage service. When not
       * specified, the default value of RequestModel
       * REQUEST_MODEL_VIRTUAL_HOSTED_STYLE is used.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.RequestModel request_model = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for requestModel to set.
       * @return This builder for chaining.
       */
      public Builder setRequestModelValue(int value) {

        requestModel_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the API request model used to call the storage service. When not
       * specified, the default value of RequestModel
       * REQUEST_MODEL_VIRTUAL_HOSTED_STYLE is used.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.RequestModel request_model = 2;
       * </code>
       *
       * @return The requestModel.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.RequestModel
          getRequestModel() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.RequestModel result =
            com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.RequestModel
                .valueOf(requestModel_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.RequestModel
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies the API request model used to call the storage service. When not
       * specified, the default value of RequestModel
       * REQUEST_MODEL_VIRTUAL_HOSTED_STYLE is used.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.RequestModel request_model = 2;
       * </code>
       *
       * @param value The requestModel to set.
       * @return This builder for chaining.
       */
      public Builder setRequestModel(
          com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.RequestModel
              value) {
        if (value == null) {
          throw new NullPointerException();
        }

        requestModel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the API request model used to call the storage service. When not
       * specified, the default value of RequestModel
       * REQUEST_MODEL_VIRTUAL_HOSTED_STYLE is used.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.RequestModel request_model = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequestModel() {

        requestModel_ = 0;
        onChanged();
        return this;
      }

      private int protocol_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies the network protocol of the agent. When not specified, the
       * default value of NetworkProtocol NETWORK_PROTOCOL_HTTPS is used.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol protocol = 3;</code>
       *
       * @return The enum numeric value on the wire for protocol.
       */
      @java.lang.Override
      public int getProtocolValue() {
        return protocol_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the network protocol of the agent. When not specified, the
       * default value of NetworkProtocol NETWORK_PROTOCOL_HTTPS is used.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol protocol = 3;</code>
       *
       * @param value The enum numeric value on the wire for protocol to set.
       * @return This builder for chaining.
       */
      public Builder setProtocolValue(int value) {

        protocol_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the network protocol of the agent. When not specified, the
       * default value of NetworkProtocol NETWORK_PROTOCOL_HTTPS is used.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol protocol = 3;</code>
       *
       * @return The protocol.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.NetworkProtocol
          getProtocol() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.NetworkProtocol
            result =
                com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
                    .NetworkProtocol.valueOf(protocol_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.NetworkProtocol
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies the network protocol of the agent. When not specified, the
       * default value of NetworkProtocol NETWORK_PROTOCOL_HTTPS is used.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol protocol = 3;</code>
       *
       * @param value The protocol to set.
       * @return This builder for chaining.
       */
      public Builder setProtocol(
          com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.NetworkProtocol
              value) {
        if (value == null) {
          throw new NullPointerException();
        }

        protocol_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the network protocol of the agent. When not specified, the
       * default value of NetworkProtocol NETWORK_PROTOCOL_HTTPS is used.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.NetworkProtocol protocol = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProtocol() {

        protocol_ = 0;
        onChanged();
        return this;
      }

      private int listApi_ = 0;
      /**
       *
       *
       * <pre>
       * The Listing API to use for discovering objects. When not specified,
       * Transfer Service will attempt to determine the right API to use.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.ListApi list_api = 4;</code>
       *
       * @return The enum numeric value on the wire for listApi.
       */
      @java.lang.Override
      public int getListApiValue() {
        return listApi_;
      }
      /**
       *
       *
       * <pre>
       * The Listing API to use for discovering objects. When not specified,
       * Transfer Service will attempt to determine the right API to use.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.ListApi list_api = 4;</code>
       *
       * @param value The enum numeric value on the wire for listApi to set.
       * @return This builder for chaining.
       */
      public Builder setListApiValue(int value) {

        listApi_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Listing API to use for discovering objects. When not specified,
       * Transfer Service will attempt to determine the right API to use.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.ListApi list_api = 4;</code>
       *
       * @return The listApi.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.ListApi
          getListApi() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.ListApi result =
            com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.ListApi.valueOf(
                listApi_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.ListApi
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The Listing API to use for discovering objects. When not specified,
       * Transfer Service will attempt to determine the right API to use.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.ListApi list_api = 4;</code>
       *
       * @param value The listApi to set.
       * @return This builder for chaining.
       */
      public Builder setListApi(
          com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata.ListApi value) {
        if (value == null) {
          throw new NullPointerException();
        }

        listApi_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Listing API to use for discovering objects. When not specified,
       * Transfer Service will attempt to determine the right API to use.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.S3CompatibleMetadata.ListApi list_api = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearListApi() {

        listApi_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.S3CompatibleMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.S3CompatibleMetadata)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<S3CompatibleMetadata> PARSER =
        new com.google.protobuf.AbstractParser<S3CompatibleMetadata>() {
          @java.lang.Override
          public S3CompatibleMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<S3CompatibleMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<S3CompatibleMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.S3CompatibleMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AgentPoolOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.AgentPool)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Specifies a unique string that identifies the agent pool.
     * Format: `projects/{project_id}/agentPools/{agent_pool_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. Specifies a unique string that identifies the agent pool.
     * Format: `projects/{project_id}/agentPools/{agent_pool_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Specifies the client-specified AgentPool description.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * Specifies the client-specified AgentPool description.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Output only. Specifies the state of the AgentPool.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Output only. Specifies the state of the AgentPool.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.State getState();

    /**
     *
     *
     * <pre>
     * Specifies the bandwidth limit details. If this field is unspecified, the
     * default value is set as 'No Limit'.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
     *
     * @return Whether the bandwidthLimit field is set.
     */
    boolean hasBandwidthLimit();
    /**
     *
     *
     * <pre>
     * Specifies the bandwidth limit details. If this field is unspecified, the
     * default value is set as 'No Limit'.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
     *
     * @return The bandwidthLimit.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit getBandwidthLimit();
    /**
     *
     *
     * <pre>
     * Specifies the bandwidth limit details. If this field is unspecified, the
     * default value is set as 'No Limit'.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimitOrBuilder
        getBandwidthLimitOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Represents an On-Premises Agent pool.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.AgentPool}
   */
  public static final class AgentPool extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.AgentPool)
      AgentPoolOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AgentPool.newBuilder() to construct.
    private AgentPool(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AgentPool() {
      name_ = "";
      displayName_ = "";
      state_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AgentPool();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_AgentPool_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_AgentPool_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.class,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The state of an AgentPool.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.AgentPool.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * This is an initialization state. During this stage, the resources such as
       * Pub/Sub topics are allocated for the AgentPool.
       * </pre>
       *
       * <code>CREATING = 1;</code>
       */
      CREATING(1),
      /**
       *
       *
       * <pre>
       * Determines that the AgentPool is created for use. At this state, Agents
       * can join the AgentPool and participate in the transfer jobs in that pool.
       * </pre>
       *
       * <code>CREATED = 2;</code>
       */
      CREATED(2),
      /**
       *
       *
       * <pre>
       * Determines that the AgentPool deletion has been initiated, and all the
       * resources are scheduled to be cleaned up and freed.
       * </pre>
       *
       * <code>DELETING = 3;</code>
       */
      DELETING(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * This is an initialization state. During this stage, the resources such as
       * Pub/Sub topics are allocated for the AgentPool.
       * </pre>
       *
       * <code>CREATING = 1;</code>
       */
      public static final int CREATING_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Determines that the AgentPool is created for use. At this state, Agents
       * can join the AgentPool and participate in the transfer jobs in that pool.
       * </pre>
       *
       * <code>CREATED = 2;</code>
       */
      public static final int CREATED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Determines that the AgentPool deletion has been initiated, and all the
       * resources are scheduled to be cleaned up and freed.
       * </pre>
       *
       * <code>DELETING = 3;</code>
       */
      public static final int DELETING_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return CREATING;
          case 2:
            return CREATED;
          case 3:
            return DELETING;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.AgentPool.State)
    }

    public interface BandwidthLimitOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.AgentPool.BandwidthLimit)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Bandwidth rate in megabytes per second, distributed across all the agents
       * in the pool.
       * </pre>
       *
       * <code>int64 limit_mbps = 1;</code>
       *
       * @return The limitMbps.
       */
      long getLimitMbps();
    }
    /**
     *
     *
     * <pre>
     * Specifies a bandwidth limit for an agent pool.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.AgentPool.BandwidthLimit}
     */
    public static final class BandwidthLimit extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.AgentPool.BandwidthLimit)
        BandwidthLimitOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use BandwidthLimit.newBuilder() to construct.
      private BandwidthLimit(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private BandwidthLimit() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new BandwidthLimit();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AgentPool_BandwidthLimit_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AgentPool_BandwidthLimit_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit.class,
                com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit.Builder
                    .class);
      }

      public static final int LIMIT_MBPS_FIELD_NUMBER = 1;
      private long limitMbps_;
      /**
       *
       *
       * <pre>
       * Bandwidth rate in megabytes per second, distributed across all the agents
       * in the pool.
       * </pre>
       *
       * <code>int64 limit_mbps = 1;</code>
       *
       * @return The limitMbps.
       */
      @java.lang.Override
      public long getLimitMbps() {
        return limitMbps_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (limitMbps_ != 0L) {
          output.writeInt64(1, limitMbps_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (limitMbps_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, limitMbps_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit)) {
          return super.equals(obj);
        }
        com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit other =
            (com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit) obj;

        if (getLimitMbps() != other.getLimitMbps()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + LIMIT_MBPS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLimitMbps());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Specifies a bandwidth limit for an agent pool.
       * </pre>
       *
       * Protobuf type {@code google.storagetransfer.v1.AgentPool.BandwidthLimit}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.AgentPool.BandwidthLimit)
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimitOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.storagetransfer.v1.proto.TransferTypes
              .internal_static_google_storagetransfer_v1_AgentPool_BandwidthLimit_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.storagetransfer.v1.proto.TransferTypes
              .internal_static_google_storagetransfer_v1_AgentPool_BandwidthLimit_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit.class,
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit.Builder
                      .class);
        }

        // Construct using
        // com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          limitMbps_ = 0L;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.storagetransfer.v1.proto.TransferTypes
              .internal_static_google_storagetransfer_v1_AgentPool_BandwidthLimit_descriptor;
        }

        @java.lang.Override
        public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
            getDefaultInstanceForType() {
          return com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit build() {
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
            buildPartial() {
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit result =
              new com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit(this);
          result.limitMbps_ = limitMbps_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit) {
            return mergeFrom(
                (com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit other) {
          if (other
              == com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
                  .getDefaultInstance()) return this;
          if (other.getLimitMbps() != 0L) {
            setLimitMbps(other.getLimitMbps());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    limitMbps_ = input.readInt64();

                    break;
                  } // case 8
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private long limitMbps_;
        /**
         *
         *
         * <pre>
         * Bandwidth rate in megabytes per second, distributed across all the agents
         * in the pool.
         * </pre>
         *
         * <code>int64 limit_mbps = 1;</code>
         *
         * @return The limitMbps.
         */
        @java.lang.Override
        public long getLimitMbps() {
          return limitMbps_;
        }
        /**
         *
         *
         * <pre>
         * Bandwidth rate in megabytes per second, distributed across all the agents
         * in the pool.
         * </pre>
         *
         * <code>int64 limit_mbps = 1;</code>
         *
         * @param value The limitMbps to set.
         * @return This builder for chaining.
         */
        public Builder setLimitMbps(long value) {

          limitMbps_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Bandwidth rate in megabytes per second, distributed across all the agents
         * in the pool.
         * </pre>
         *
         * <code>int64 limit_mbps = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLimitMbps() {

          limitMbps_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.AgentPool.BandwidthLimit)
      }

      // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.AgentPool.BandwidthLimit)
      private static final com.google.storagetransfer.v1.proto.TransferTypes.AgentPool
              .BandwidthLimit
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit();
      }

      public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<BandwidthLimit> PARSER =
          new com.google.protobuf.AbstractParser<BandwidthLimit>() {
            @java.lang.Override
            public BandwidthLimit parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<BandwidthLimit> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<BandwidthLimit> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Required. Specifies a unique string that identifies the agent pool.
     * Format: `projects/{project_id}/agentPools/{agent_pool_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Specifies a unique string that identifies the agent pool.
     * Format: `projects/{project_id}/agentPools/{agent_pool_id}`
     * </pre>
     *
     * <code>string name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 3;
    private volatile java.lang.Object displayName_;
    /**
     *
     *
     * <pre>
     * Specifies the client-specified AgentPool description.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the client-specified AgentPool description.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATE_FIELD_NUMBER = 4;
    private int state_;
    /**
     *
     *
     * <pre>
     * Output only. Specifies the state of the AgentPool.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Specifies the state of the AgentPool.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.State getState() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.State result =
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.State.valueOf(state_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.State.UNRECOGNIZED
          : result;
    }

    public static final int BANDWIDTH_LIMIT_FIELD_NUMBER = 5;
    private com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
        bandwidthLimit_;
    /**
     *
     *
     * <pre>
     * Specifies the bandwidth limit details. If this field is unspecified, the
     * default value is set as 'No Limit'.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
     *
     * @return Whether the bandwidthLimit field is set.
     */
    @java.lang.Override
    public boolean hasBandwidthLimit() {
      return bandwidthLimit_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specifies the bandwidth limit details. If this field is unspecified, the
     * default value is set as 'No Limit'.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
     *
     * @return The bandwidthLimit.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
        getBandwidthLimit() {
      return bandwidthLimit_ == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
              .getDefaultInstance()
          : bandwidthLimit_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the bandwidth limit details. If this field is unspecified, the
     * default value is set as 'No Limit'.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimitOrBuilder
        getBandwidthLimitOrBuilder() {
      return getBandwidthLimit();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
      }
      if (state_
          != com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.State.STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, state_);
      }
      if (bandwidthLimit_ != null) {
        output.writeMessage(5, getBandwidthLimit());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
      }
      if (state_
          != com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.State.STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
      }
      if (bandwidthLimit_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getBandwidthLimit());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.AgentPool)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.AgentPool other =
          (com.google.storagetransfer.v1.proto.TransferTypes.AgentPool) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (state_ != other.state_) return false;
      if (hasBandwidthLimit() != other.hasBandwidthLimit()) return false;
      if (hasBandwidthLimit()) {
        if (!getBandwidthLimit().equals(other.getBandwidthLimit())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      if (hasBandwidthLimit()) {
        hash = (37 * hash) + BANDWIDTH_LIMIT_FIELD_NUMBER;
        hash = (53 * hash) + getBandwidthLimit().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.AgentPool prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents an On-Premises Agent pool.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.AgentPool}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.AgentPool)
        com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AgentPool_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AgentPool_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.class,
                com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder.class);
      }

      // Construct using com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        displayName_ = "";

        state_ = 0;

        if (bandwidthLimitBuilder_ == null) {
          bandwidthLimit_ = null;
        } else {
          bandwidthLimit_ = null;
          bandwidthLimitBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_AgentPool_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool build() {
        com.google.storagetransfer.v1.proto.TransferTypes.AgentPool result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.AgentPool result =
            new com.google.storagetransfer.v1.proto.TransferTypes.AgentPool(this);
        result.name_ = name_;
        result.displayName_ = displayName_;
        result.state_ = state_;
        if (bandwidthLimitBuilder_ == null) {
          result.bandwidthLimit_ = bandwidthLimit_;
        } else {
          result.bandwidthLimit_ = bandwidthLimitBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storagetransfer.v1.proto.TransferTypes.AgentPool) {
          return mergeFrom((com.google.storagetransfer.v1.proto.TransferTypes.AgentPool) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storagetransfer.v1.proto.TransferTypes.AgentPool other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          onChanged();
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (other.hasBandwidthLimit()) {
          mergeBandwidthLimit(other.getBandwidthLimit());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  name_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 26:
                {
                  displayName_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              case 32:
                {
                  state_ = input.readEnum();

                  break;
                } // case 32
              case 42:
                {
                  input.readMessage(
                      getBandwidthLimitFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. Specifies a unique string that identifies the agent pool.
       * Format: `projects/{project_id}/agentPools/{agent_pool_id}`
       * </pre>
       *
       * <code>string name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a unique string that identifies the agent pool.
       * Format: `projects/{project_id}/agentPools/{agent_pool_id}`
       * </pre>
       *
       * <code>string name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a unique string that identifies the agent pool.
       * Format: `projects/{project_id}/agentPools/{agent_pool_id}`
       * </pre>
       *
       * <code>string name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a unique string that identifies the agent pool.
       * Format: `projects/{project_id}/agentPools/{agent_pool_id}`
       * </pre>
       *
       * <code>string name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Specifies a unique string that identifies the agent pool.
       * Format: `projects/{project_id}/agentPools/{agent_pool_id}`
       * </pre>
       *
       * <code>string name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Specifies the client-specified AgentPool description.
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the client-specified AgentPool description.
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the client-specified AgentPool description.
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        displayName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the client-specified AgentPool description.
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {

        displayName_ = getDefaultInstance().getDisplayName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the client-specified AgentPool description.
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        displayName_ = value;
        onChanged();
        return this;
      }

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. Specifies the state of the AgentPool.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Specifies the state of the AgentPool.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {

        state_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Specifies the state of the AgentPool.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.State getState() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.State result =
            com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.State.valueOf(state_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.State.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. Specifies the state of the AgentPool.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.State value) {
        if (value == null) {
          throw new NullPointerException();
        }

        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Specifies the state of the AgentPool.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {

        state_ = 0;
        onChanged();
        return this;
      }

      private com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          bandwidthLimit_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimitOrBuilder>
          bandwidthLimitBuilder_;
      /**
       *
       *
       * <pre>
       * Specifies the bandwidth limit details. If this field is unspecified, the
       * default value is set as 'No Limit'.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
       *
       * @return Whether the bandwidthLimit field is set.
       */
      public boolean hasBandwidthLimit() {
        return bandwidthLimitBuilder_ != null || bandwidthLimit_ != null;
      }
      /**
       *
       *
       * <pre>
       * Specifies the bandwidth limit details. If this field is unspecified, the
       * default value is set as 'No Limit'.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
       *
       * @return The bandwidthLimit.
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
          getBandwidthLimit() {
        if (bandwidthLimitBuilder_ == null) {
          return bandwidthLimit_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
                  .getDefaultInstance()
              : bandwidthLimit_;
        } else {
          return bandwidthLimitBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the bandwidth limit details. If this field is unspecified, the
       * default value is set as 'No Limit'.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
       */
      public Builder setBandwidthLimit(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit value) {
        if (bandwidthLimitBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          bandwidthLimit_ = value;
          onChanged();
        } else {
          bandwidthLimitBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the bandwidth limit details. If this field is unspecified, the
       * default value is set as 'No Limit'.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
       */
      public Builder setBandwidthLimit(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit.Builder
              builderForValue) {
        if (bandwidthLimitBuilder_ == null) {
          bandwidthLimit_ = builderForValue.build();
          onChanged();
        } else {
          bandwidthLimitBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the bandwidth limit details. If this field is unspecified, the
       * default value is set as 'No Limit'.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
       */
      public Builder mergeBandwidthLimit(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit value) {
        if (bandwidthLimitBuilder_ == null) {
          if (bandwidthLimit_ != null) {
            bandwidthLimit_ =
                com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
                    .newBuilder(bandwidthLimit_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            bandwidthLimit_ = value;
          }
          onChanged();
        } else {
          bandwidthLimitBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the bandwidth limit details. If this field is unspecified, the
       * default value is set as 'No Limit'.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
       */
      public Builder clearBandwidthLimit() {
        if (bandwidthLimitBuilder_ == null) {
          bandwidthLimit_ = null;
          onChanged();
        } else {
          bandwidthLimit_ = null;
          bandwidthLimitBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the bandwidth limit details. If this field is unspecified, the
       * default value is set as 'No Limit'.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit.Builder
          getBandwidthLimitBuilder() {

        onChanged();
        return getBandwidthLimitFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Specifies the bandwidth limit details. If this field is unspecified, the
       * default value is set as 'No Limit'.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimitOrBuilder
          getBandwidthLimitOrBuilder() {
        if (bandwidthLimitBuilder_ != null) {
          return bandwidthLimitBuilder_.getMessageOrBuilder();
        } else {
          return bandwidthLimit_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
                  .getDefaultInstance()
              : bandwidthLimit_;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the bandwidth limit details. If this field is unspecified, the
       * default value is set as 'No Limit'.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AgentPool.BandwidthLimit bandwidth_limit = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimitOrBuilder>
          getBandwidthLimitFieldBuilder() {
        if (bandwidthLimitBuilder_ == null) {
          bandwidthLimitBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit,
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.BandwidthLimit
                      .Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPool
                      .BandwidthLimitOrBuilder>(
                  getBandwidthLimit(), getParentForChildren(), isClean());
          bandwidthLimit_ = null;
        }
        return bandwidthLimitBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.AgentPool)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.AgentPool)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.AgentPool
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storagetransfer.v1.proto.TransferTypes.AgentPool();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.AgentPool getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AgentPool> PARSER =
        new com.google.protobuf.AbstractParser<AgentPool>() {
          @java.lang.Override
          public AgentPool parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AgentPool> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AgentPool> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TransferOptionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.TransferOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * When to overwrite objects that already exist in the sink. The default is
     * that only objects that are different from the source are ovewritten. If
     * true, all objects in the sink whose name matches an object in the source
     * are overwritten with the source object.
     * </pre>
     *
     * <code>bool overwrite_objects_already_existing_in_sink = 1;</code>
     *
     * @return The overwriteObjectsAlreadyExistingInSink.
     */
    boolean getOverwriteObjectsAlreadyExistingInSink();

    /**
     *
     *
     * <pre>
     * Whether objects that exist only in the sink should be deleted.
     * **Note:** This option and [delete_objects_from_source_after_transfer][google.storagetransfer.v1.TransferOptions.delete_objects_from_source_after_transfer] are
     * mutually exclusive.
     * </pre>
     *
     * <code>bool delete_objects_unique_in_sink = 2;</code>
     *
     * @return The deleteObjectsUniqueInSink.
     */
    boolean getDeleteObjectsUniqueInSink();

    /**
     *
     *
     * <pre>
     * Whether objects should be deleted from the source after they are
     * transferred to the sink.
     * **Note:** This option and [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink] are mutually
     * exclusive.
     * </pre>
     *
     * <code>bool delete_objects_from_source_after_transfer = 3;</code>
     *
     * @return The deleteObjectsFromSourceAfterTransfer.
     */
    boolean getDeleteObjectsFromSourceAfterTransfer();

    /**
     *
     *
     * <pre>
     * When to overwrite objects that already exist in the sink. If not set,
     * overwrite behavior is determined by
     * [overwrite_objects_already_existing_in_sink][google.storagetransfer.v1.TransferOptions.overwrite_objects_already_existing_in_sink].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferOptions.OverwriteWhen overwrite_when = 4;</code>
     *
     * @return The enum numeric value on the wire for overwriteWhen.
     */
    int getOverwriteWhenValue();
    /**
     *
     *
     * <pre>
     * When to overwrite objects that already exist in the sink. If not set,
     * overwrite behavior is determined by
     * [overwrite_objects_already_existing_in_sink][google.storagetransfer.v1.TransferOptions.overwrite_objects_already_existing_in_sink].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferOptions.OverwriteWhen overwrite_when = 4;</code>
     *
     * @return The overwriteWhen.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.OverwriteWhen
        getOverwriteWhen();

    /**
     *
     *
     * <pre>
     * Represents the selected metadata options for a transfer job.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
     *
     * @return Whether the metadataOptions field is set.
     */
    boolean hasMetadataOptions();
    /**
     *
     *
     * <pre>
     * Represents the selected metadata options for a transfer job.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
     *
     * @return The metadataOptions.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions getMetadataOptions();
    /**
     *
     *
     * <pre>
     * Represents the selected metadata options for a transfer job.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptionsOrBuilder
        getMetadataOptionsOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * TransferOptions define the actions to be performed on objects in a transfer.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.TransferOptions}
   */
  public static final class TransferOptions extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.TransferOptions)
      TransferOptionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TransferOptions.newBuilder() to construct.
    private TransferOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TransferOptions() {
      overwriteWhen_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TransferOptions();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_TransferOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_TransferOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.class,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Specifies when to overwrite an object in the sink when an object with
     * matching name is found in the source.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.TransferOptions.OverwriteWhen}
     */
    public enum OverwriteWhen implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Overwrite behavior is unspecified.
       * </pre>
       *
       * <code>OVERWRITE_WHEN_UNSPECIFIED = 0;</code>
       */
      OVERWRITE_WHEN_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Overwrites destination objects with the source objects, only if the
       * objects have the same name but different HTTP ETags or checksum values.
       * </pre>
       *
       * <code>DIFFERENT = 1;</code>
       */
      DIFFERENT(1),
      /**
       *
       *
       * <pre>
       * Never overwrites a destination object if a source object has the
       * same name. In this case, the source object is not transferred.
       * </pre>
       *
       * <code>NEVER = 2;</code>
       */
      NEVER(2),
      /**
       *
       *
       * <pre>
       * Always overwrite the destination object with the source object, even if
       * the HTTP Etags or checksum values are the same.
       * </pre>
       *
       * <code>ALWAYS = 3;</code>
       */
      ALWAYS(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Overwrite behavior is unspecified.
       * </pre>
       *
       * <code>OVERWRITE_WHEN_UNSPECIFIED = 0;</code>
       */
      public static final int OVERWRITE_WHEN_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Overwrites destination objects with the source objects, only if the
       * objects have the same name but different HTTP ETags or checksum values.
       * </pre>
       *
       * <code>DIFFERENT = 1;</code>
       */
      public static final int DIFFERENT_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Never overwrites a destination object if a source object has the
       * same name. In this case, the source object is not transferred.
       * </pre>
       *
       * <code>NEVER = 2;</code>
       */
      public static final int NEVER_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Always overwrite the destination object with the source object, even if
       * the HTTP Etags or checksum values are the same.
       * </pre>
       *
       * <code>ALWAYS = 3;</code>
       */
      public static final int ALWAYS_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OverwriteWhen valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static OverwriteWhen forNumber(int value) {
        switch (value) {
          case 0:
            return OVERWRITE_WHEN_UNSPECIFIED;
          case 1:
            return DIFFERENT;
          case 2:
            return NEVER;
          case 3:
            return ALWAYS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<OverwriteWhen> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<OverwriteWhen>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<OverwriteWhen>() {
                public OverwriteWhen findValueByNumber(int number) {
                  return OverwriteWhen.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final OverwriteWhen[] VALUES = values();

      public static OverwriteWhen valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private OverwriteWhen(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.TransferOptions.OverwriteWhen)
    }

    public static final int OVERWRITE_OBJECTS_ALREADY_EXISTING_IN_SINK_FIELD_NUMBER = 1;
    private boolean overwriteObjectsAlreadyExistingInSink_;
    /**
     *
     *
     * <pre>
     * When to overwrite objects that already exist in the sink. The default is
     * that only objects that are different from the source are ovewritten. If
     * true, all objects in the sink whose name matches an object in the source
     * are overwritten with the source object.
     * </pre>
     *
     * <code>bool overwrite_objects_already_existing_in_sink = 1;</code>
     *
     * @return The overwriteObjectsAlreadyExistingInSink.
     */
    @java.lang.Override
    public boolean getOverwriteObjectsAlreadyExistingInSink() {
      return overwriteObjectsAlreadyExistingInSink_;
    }

    public static final int DELETE_OBJECTS_UNIQUE_IN_SINK_FIELD_NUMBER = 2;
    private boolean deleteObjectsUniqueInSink_;
    /**
     *
     *
     * <pre>
     * Whether objects that exist only in the sink should be deleted.
     * **Note:** This option and [delete_objects_from_source_after_transfer][google.storagetransfer.v1.TransferOptions.delete_objects_from_source_after_transfer] are
     * mutually exclusive.
     * </pre>
     *
     * <code>bool delete_objects_unique_in_sink = 2;</code>
     *
     * @return The deleteObjectsUniqueInSink.
     */
    @java.lang.Override
    public boolean getDeleteObjectsUniqueInSink() {
      return deleteObjectsUniqueInSink_;
    }

    public static final int DELETE_OBJECTS_FROM_SOURCE_AFTER_TRANSFER_FIELD_NUMBER = 3;
    private boolean deleteObjectsFromSourceAfterTransfer_;
    /**
     *
     *
     * <pre>
     * Whether objects should be deleted from the source after they are
     * transferred to the sink.
     * **Note:** This option and [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink] are mutually
     * exclusive.
     * </pre>
     *
     * <code>bool delete_objects_from_source_after_transfer = 3;</code>
     *
     * @return The deleteObjectsFromSourceAfterTransfer.
     */
    @java.lang.Override
    public boolean getDeleteObjectsFromSourceAfterTransfer() {
      return deleteObjectsFromSourceAfterTransfer_;
    }

    public static final int OVERWRITE_WHEN_FIELD_NUMBER = 4;
    private int overwriteWhen_;
    /**
     *
     *
     * <pre>
     * When to overwrite objects that already exist in the sink. If not set,
     * overwrite behavior is determined by
     * [overwrite_objects_already_existing_in_sink][google.storagetransfer.v1.TransferOptions.overwrite_objects_already_existing_in_sink].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferOptions.OverwriteWhen overwrite_when = 4;</code>
     *
     * @return The enum numeric value on the wire for overwriteWhen.
     */
    @java.lang.Override
    public int getOverwriteWhenValue() {
      return overwriteWhen_;
    }
    /**
     *
     *
     * <pre>
     * When to overwrite objects that already exist in the sink. If not set,
     * overwrite behavior is determined by
     * [overwrite_objects_already_existing_in_sink][google.storagetransfer.v1.TransferOptions.overwrite_objects_already_existing_in_sink].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferOptions.OverwriteWhen overwrite_when = 4;</code>
     *
     * @return The overwriteWhen.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.OverwriteWhen
        getOverwriteWhen() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.OverwriteWhen result =
          com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.OverwriteWhen.valueOf(
              overwriteWhen_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.OverwriteWhen
              .UNRECOGNIZED
          : result;
    }

    public static final int METADATA_OPTIONS_FIELD_NUMBER = 5;
    private com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions metadataOptions_;
    /**
     *
     *
     * <pre>
     * Represents the selected metadata options for a transfer job.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
     *
     * @return Whether the metadataOptions field is set.
     */
    @java.lang.Override
    public boolean hasMetadataOptions() {
      return metadataOptions_ != null;
    }
    /**
     *
     *
     * <pre>
     * Represents the selected metadata options for a transfer job.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
     *
     * @return The metadataOptions.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions getMetadataOptions() {
      return metadataOptions_ == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.getDefaultInstance()
          : metadataOptions_;
    }
    /**
     *
     *
     * <pre>
     * Represents the selected metadata options for a transfer job.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptionsOrBuilder
        getMetadataOptionsOrBuilder() {
      return getMetadataOptions();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (overwriteObjectsAlreadyExistingInSink_ != false) {
        output.writeBool(1, overwriteObjectsAlreadyExistingInSink_);
      }
      if (deleteObjectsUniqueInSink_ != false) {
        output.writeBool(2, deleteObjectsUniqueInSink_);
      }
      if (deleteObjectsFromSourceAfterTransfer_ != false) {
        output.writeBool(3, deleteObjectsFromSourceAfterTransfer_);
      }
      if (overwriteWhen_
          != com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.OverwriteWhen
              .OVERWRITE_WHEN_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, overwriteWhen_);
      }
      if (metadataOptions_ != null) {
        output.writeMessage(5, getMetadataOptions());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (overwriteObjectsAlreadyExistingInSink_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                1, overwriteObjectsAlreadyExistingInSink_);
      }
      if (deleteObjectsUniqueInSink_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(2, deleteObjectsUniqueInSink_);
      }
      if (deleteObjectsFromSourceAfterTransfer_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                3, deleteObjectsFromSourceAfterTransfer_);
      }
      if (overwriteWhen_
          != com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.OverwriteWhen
              .OVERWRITE_WHEN_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, overwriteWhen_);
      }
      if (metadataOptions_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMetadataOptions());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions other =
          (com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions) obj;

      if (getOverwriteObjectsAlreadyExistingInSink()
          != other.getOverwriteObjectsAlreadyExistingInSink()) return false;
      if (getDeleteObjectsUniqueInSink() != other.getDeleteObjectsUniqueInSink()) return false;
      if (getDeleteObjectsFromSourceAfterTransfer()
          != other.getDeleteObjectsFromSourceAfterTransfer()) return false;
      if (overwriteWhen_ != other.overwriteWhen_) return false;
      if (hasMetadataOptions() != other.hasMetadataOptions()) return false;
      if (hasMetadataOptions()) {
        if (!getMetadataOptions().equals(other.getMetadataOptions())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OVERWRITE_OBJECTS_ALREADY_EXISTING_IN_SINK_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(
                  getOverwriteObjectsAlreadyExistingInSink());
      hash = (37 * hash) + DELETE_OBJECTS_UNIQUE_IN_SINK_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDeleteObjectsUniqueInSink());
      hash = (37 * hash) + DELETE_OBJECTS_FROM_SOURCE_AFTER_TRANSFER_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getDeleteObjectsFromSourceAfterTransfer());
      hash = (37 * hash) + OVERWRITE_WHEN_FIELD_NUMBER;
      hash = (53 * hash) + overwriteWhen_;
      if (hasMetadataOptions()) {
        hash = (37 * hash) + METADATA_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getMetadataOptions().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * TransferOptions define the actions to be performed on objects in a transfer.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.TransferOptions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.TransferOptions)
        com.google.storagetransfer.v1.proto.TransferTypes.TransferOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_TransferOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_TransferOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.class,
                com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.Builder.class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        overwriteObjectsAlreadyExistingInSink_ = false;

        deleteObjectsUniqueInSink_ = false;

        deleteObjectsFromSourceAfterTransfer_ = false;

        overwriteWhen_ = 0;

        if (metadataOptionsBuilder_ == null) {
          metadataOptions_ = null;
        } else {
          metadataOptions_ = null;
          metadataOptionsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_TransferOptions_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions build() {
        com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions result =
            new com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions(this);
        result.overwriteObjectsAlreadyExistingInSink_ = overwriteObjectsAlreadyExistingInSink_;
        result.deleteObjectsUniqueInSink_ = deleteObjectsUniqueInSink_;
        result.deleteObjectsFromSourceAfterTransfer_ = deleteObjectsFromSourceAfterTransfer_;
        result.overwriteWhen_ = overwriteWhen_;
        if (metadataOptionsBuilder_ == null) {
          result.metadataOptions_ = metadataOptions_;
        } else {
          result.metadataOptions_ = metadataOptionsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions
                .getDefaultInstance()) return this;
        if (other.getOverwriteObjectsAlreadyExistingInSink() != false) {
          setOverwriteObjectsAlreadyExistingInSink(
              other.getOverwriteObjectsAlreadyExistingInSink());
        }
        if (other.getDeleteObjectsUniqueInSink() != false) {
          setDeleteObjectsUniqueInSink(other.getDeleteObjectsUniqueInSink());
        }
        if (other.getDeleteObjectsFromSourceAfterTransfer() != false) {
          setDeleteObjectsFromSourceAfterTransfer(other.getDeleteObjectsFromSourceAfterTransfer());
        }
        if (other.overwriteWhen_ != 0) {
          setOverwriteWhenValue(other.getOverwriteWhenValue());
        }
        if (other.hasMetadataOptions()) {
          mergeMetadataOptions(other.getMetadataOptions());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  overwriteObjectsAlreadyExistingInSink_ = input.readBool();

                  break;
                } // case 8
              case 16:
                {
                  deleteObjectsUniqueInSink_ = input.readBool();

                  break;
                } // case 16
              case 24:
                {
                  deleteObjectsFromSourceAfterTransfer_ = input.readBool();

                  break;
                } // case 24
              case 32:
                {
                  overwriteWhen_ = input.readEnum();

                  break;
                } // case 32
              case 42:
                {
                  input.readMessage(
                      getMetadataOptionsFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private boolean overwriteObjectsAlreadyExistingInSink_;
      /**
       *
       *
       * <pre>
       * When to overwrite objects that already exist in the sink. The default is
       * that only objects that are different from the source are ovewritten. If
       * true, all objects in the sink whose name matches an object in the source
       * are overwritten with the source object.
       * </pre>
       *
       * <code>bool overwrite_objects_already_existing_in_sink = 1;</code>
       *
       * @return The overwriteObjectsAlreadyExistingInSink.
       */
      @java.lang.Override
      public boolean getOverwriteObjectsAlreadyExistingInSink() {
        return overwriteObjectsAlreadyExistingInSink_;
      }
      /**
       *
       *
       * <pre>
       * When to overwrite objects that already exist in the sink. The default is
       * that only objects that are different from the source are ovewritten. If
       * true, all objects in the sink whose name matches an object in the source
       * are overwritten with the source object.
       * </pre>
       *
       * <code>bool overwrite_objects_already_existing_in_sink = 1;</code>
       *
       * @param value The overwriteObjectsAlreadyExistingInSink to set.
       * @return This builder for chaining.
       */
      public Builder setOverwriteObjectsAlreadyExistingInSink(boolean value) {

        overwriteObjectsAlreadyExistingInSink_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When to overwrite objects that already exist in the sink. The default is
       * that only objects that are different from the source are ovewritten. If
       * true, all objects in the sink whose name matches an object in the source
       * are overwritten with the source object.
       * </pre>
       *
       * <code>bool overwrite_objects_already_existing_in_sink = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOverwriteObjectsAlreadyExistingInSink() {

        overwriteObjectsAlreadyExistingInSink_ = false;
        onChanged();
        return this;
      }

      private boolean deleteObjectsUniqueInSink_;
      /**
       *
       *
       * <pre>
       * Whether objects that exist only in the sink should be deleted.
       * **Note:** This option and [delete_objects_from_source_after_transfer][google.storagetransfer.v1.TransferOptions.delete_objects_from_source_after_transfer] are
       * mutually exclusive.
       * </pre>
       *
       * <code>bool delete_objects_unique_in_sink = 2;</code>
       *
       * @return The deleteObjectsUniqueInSink.
       */
      @java.lang.Override
      public boolean getDeleteObjectsUniqueInSink() {
        return deleteObjectsUniqueInSink_;
      }
      /**
       *
       *
       * <pre>
       * Whether objects that exist only in the sink should be deleted.
       * **Note:** This option and [delete_objects_from_source_after_transfer][google.storagetransfer.v1.TransferOptions.delete_objects_from_source_after_transfer] are
       * mutually exclusive.
       * </pre>
       *
       * <code>bool delete_objects_unique_in_sink = 2;</code>
       *
       * @param value The deleteObjectsUniqueInSink to set.
       * @return This builder for chaining.
       */
      public Builder setDeleteObjectsUniqueInSink(boolean value) {

        deleteObjectsUniqueInSink_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether objects that exist only in the sink should be deleted.
       * **Note:** This option and [delete_objects_from_source_after_transfer][google.storagetransfer.v1.TransferOptions.delete_objects_from_source_after_transfer] are
       * mutually exclusive.
       * </pre>
       *
       * <code>bool delete_objects_unique_in_sink = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDeleteObjectsUniqueInSink() {

        deleteObjectsUniqueInSink_ = false;
        onChanged();
        return this;
      }

      private boolean deleteObjectsFromSourceAfterTransfer_;
      /**
       *
       *
       * <pre>
       * Whether objects should be deleted from the source after they are
       * transferred to the sink.
       * **Note:** This option and [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink] are mutually
       * exclusive.
       * </pre>
       *
       * <code>bool delete_objects_from_source_after_transfer = 3;</code>
       *
       * @return The deleteObjectsFromSourceAfterTransfer.
       */
      @java.lang.Override
      public boolean getDeleteObjectsFromSourceAfterTransfer() {
        return deleteObjectsFromSourceAfterTransfer_;
      }
      /**
       *
       *
       * <pre>
       * Whether objects should be deleted from the source after they are
       * transferred to the sink.
       * **Note:** This option and [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink] are mutually
       * exclusive.
       * </pre>
       *
       * <code>bool delete_objects_from_source_after_transfer = 3;</code>
       *
       * @param value The deleteObjectsFromSourceAfterTransfer to set.
       * @return This builder for chaining.
       */
      public Builder setDeleteObjectsFromSourceAfterTransfer(boolean value) {

        deleteObjectsFromSourceAfterTransfer_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Whether objects should be deleted from the source after they are
       * transferred to the sink.
       * **Note:** This option and [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink] are mutually
       * exclusive.
       * </pre>
       *
       * <code>bool delete_objects_from_source_after_transfer = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDeleteObjectsFromSourceAfterTransfer() {

        deleteObjectsFromSourceAfterTransfer_ = false;
        onChanged();
        return this;
      }

      private int overwriteWhen_ = 0;
      /**
       *
       *
       * <pre>
       * When to overwrite objects that already exist in the sink. If not set,
       * overwrite behavior is determined by
       * [overwrite_objects_already_existing_in_sink][google.storagetransfer.v1.TransferOptions.overwrite_objects_already_existing_in_sink].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions.OverwriteWhen overwrite_when = 4;</code>
       *
       * @return The enum numeric value on the wire for overwriteWhen.
       */
      @java.lang.Override
      public int getOverwriteWhenValue() {
        return overwriteWhen_;
      }
      /**
       *
       *
       * <pre>
       * When to overwrite objects that already exist in the sink. If not set,
       * overwrite behavior is determined by
       * [overwrite_objects_already_existing_in_sink][google.storagetransfer.v1.TransferOptions.overwrite_objects_already_existing_in_sink].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions.OverwriteWhen overwrite_when = 4;</code>
       *
       * @param value The enum numeric value on the wire for overwriteWhen to set.
       * @return This builder for chaining.
       */
      public Builder setOverwriteWhenValue(int value) {

        overwriteWhen_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When to overwrite objects that already exist in the sink. If not set,
       * overwrite behavior is determined by
       * [overwrite_objects_already_existing_in_sink][google.storagetransfer.v1.TransferOptions.overwrite_objects_already_existing_in_sink].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions.OverwriteWhen overwrite_when = 4;</code>
       *
       * @return The overwriteWhen.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.OverwriteWhen
          getOverwriteWhen() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.OverwriteWhen result =
            com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.OverwriteWhen.valueOf(
                overwriteWhen_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.OverwriteWhen
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * When to overwrite objects that already exist in the sink. If not set,
       * overwrite behavior is determined by
       * [overwrite_objects_already_existing_in_sink][google.storagetransfer.v1.TransferOptions.overwrite_objects_already_existing_in_sink].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions.OverwriteWhen overwrite_when = 4;</code>
       *
       * @param value The overwriteWhen to set.
       * @return This builder for chaining.
       */
      public Builder setOverwriteWhen(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.OverwriteWhen value) {
        if (value == null) {
          throw new NullPointerException();
        }

        overwriteWhen_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When to overwrite objects that already exist in the sink. If not set,
       * overwrite behavior is determined by
       * [overwrite_objects_already_existing_in_sink][google.storagetransfer.v1.TransferOptions.overwrite_objects_already_existing_in_sink].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions.OverwriteWhen overwrite_when = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOverwriteWhen() {

        overwriteWhen_ = 0;
        onChanged();
        return this;
      }

      private com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions metadataOptions_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions,
              com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptionsOrBuilder>
          metadataOptionsBuilder_;
      /**
       *
       *
       * <pre>
       * Represents the selected metadata options for a transfer job.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
       *
       * @return Whether the metadataOptions field is set.
       */
      public boolean hasMetadataOptions() {
        return metadataOptionsBuilder_ != null || metadataOptions_ != null;
      }
      /**
       *
       *
       * <pre>
       * Represents the selected metadata options for a transfer job.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
       *
       * @return The metadataOptions.
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions
          getMetadataOptions() {
        if (metadataOptionsBuilder_ == null) {
          return metadataOptions_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions
                  .getDefaultInstance()
              : metadataOptions_;
        } else {
          return metadataOptionsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the selected metadata options for a transfer job.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
       */
      public Builder setMetadataOptions(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions value) {
        if (metadataOptionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadataOptions_ = value;
          onChanged();
        } else {
          metadataOptionsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the selected metadata options for a transfer job.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
       */
      public Builder setMetadataOptions(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Builder
              builderForValue) {
        if (metadataOptionsBuilder_ == null) {
          metadataOptions_ = builderForValue.build();
          onChanged();
        } else {
          metadataOptionsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the selected metadata options for a transfer job.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
       */
      public Builder mergeMetadataOptions(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions value) {
        if (metadataOptionsBuilder_ == null) {
          if (metadataOptions_ != null) {
            metadataOptions_ =
                com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.newBuilder(
                        metadataOptions_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadataOptions_ = value;
          }
          onChanged();
        } else {
          metadataOptionsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the selected metadata options for a transfer job.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
       */
      public Builder clearMetadataOptions() {
        if (metadataOptionsBuilder_ == null) {
          metadataOptions_ = null;
          onChanged();
        } else {
          metadataOptions_ = null;
          metadataOptionsBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the selected metadata options for a transfer job.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Builder
          getMetadataOptionsBuilder() {

        onChanged();
        return getMetadataOptionsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Represents the selected metadata options for a transfer job.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptionsOrBuilder
          getMetadataOptionsOrBuilder() {
        if (metadataOptionsBuilder_ != null) {
          return metadataOptionsBuilder_.getMessageOrBuilder();
        } else {
          return metadataOptions_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions
                  .getDefaultInstance()
              : metadataOptions_;
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the selected metadata options for a transfer job.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions metadata_options = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions,
              com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptionsOrBuilder>
          getMetadataOptionsFieldBuilder() {
        if (metadataOptionsBuilder_ == null) {
          metadataOptionsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions,
                  com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptionsOrBuilder>(
                  getMetadataOptions(), getParentForChildren(), isClean());
          metadataOptions_ = null;
        }
        return metadataOptionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.TransferOptions)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.TransferOptions)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TransferOptions> PARSER =
        new com.google.protobuf.AbstractParser<TransferOptions>() {
          @java.lang.Override
          public TransferOptions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TransferOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TransferOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TransferSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.TransferSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A Cloud Storage data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
     *
     * @return Whether the gcsDataSink field is set.
     */
    boolean hasGcsDataSink();
    /**
     *
     *
     * <pre>
     * A Cloud Storage data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
     *
     * @return The gcsDataSink.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.GcsData getGcsDataSink();
    /**
     *
     *
     * <pre>
     * A Cloud Storage data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder getGcsDataSinkOrBuilder();

    /**
     *
     *
     * <pre>
     * A POSIX Filesystem data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
     *
     * @return Whether the posixDataSink field is set.
     */
    boolean hasPosixDataSink();
    /**
     *
     *
     * <pre>
     * A POSIX Filesystem data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
     *
     * @return The posixDataSink.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem getPosixDataSink();
    /**
     *
     *
     * <pre>
     * A POSIX Filesystem data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder
        getPosixDataSinkOrBuilder();

    /**
     *
     *
     * <pre>
     * A Cloud Storage data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
     *
     * @return Whether the gcsDataSource field is set.
     */
    boolean hasGcsDataSource();
    /**
     *
     *
     * <pre>
     * A Cloud Storage data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
     *
     * @return The gcsDataSource.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.GcsData getGcsDataSource();
    /**
     *
     *
     * <pre>
     * A Cloud Storage data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder getGcsDataSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * An AWS S3 data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
     *
     * @return Whether the awsS3DataSource field is set.
     */
    boolean hasAwsS3DataSource();
    /**
     *
     *
     * <pre>
     * An AWS S3 data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
     *
     * @return The awsS3DataSource.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data getAwsS3DataSource();
    /**
     *
     *
     * <pre>
     * An AWS S3 data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AwsS3DataOrBuilder
        getAwsS3DataSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * An HTTP URL data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
     *
     * @return Whether the httpDataSource field is set.
     */
    boolean hasHttpDataSource();
    /**
     *
     *
     * <pre>
     * An HTTP URL data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
     *
     * @return The httpDataSource.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.HttpData getHttpDataSource();
    /**
     *
     *
     * <pre>
     * An HTTP URL data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.HttpDataOrBuilder
        getHttpDataSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * A POSIX Filesystem data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
     *
     * @return Whether the posixDataSource field is set.
     */
    boolean hasPosixDataSource();
    /**
     *
     *
     * <pre>
     * A POSIX Filesystem data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
     *
     * @return The posixDataSource.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem getPosixDataSource();
    /**
     *
     *
     * <pre>
     * A POSIX Filesystem data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder
        getPosixDataSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * An Azure Blob Storage data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
     * </code>
     *
     * @return Whether the azureBlobStorageDataSource field is set.
     */
    boolean hasAzureBlobStorageDataSource();
    /**
     *
     *
     * <pre>
     * An Azure Blob Storage data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
     * </code>
     *
     * @return The azureBlobStorageDataSource.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
        getAzureBlobStorageDataSource();
    /**
     *
     *
     * <pre>
     * An Azure Blob Storage data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
     * </code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageDataOrBuilder
        getAzureBlobStorageDataSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * An AWS S3 compatible data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
     * </code>
     *
     * @return Whether the awsS3CompatibleDataSource field is set.
     */
    boolean hasAwsS3CompatibleDataSource();
    /**
     *
     *
     * <pre>
     * An AWS S3 compatible data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
     * </code>
     *
     * @return The awsS3CompatibleDataSource.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
        getAwsS3CompatibleDataSource();
    /**
     *
     *
     * <pre>
     * An AWS S3 compatible data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
     * </code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleDataOrBuilder
        getAwsS3CompatibleDataSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * Cloud Storage intermediate data location.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
     *
     * @return Whether the gcsIntermediateDataLocation field is set.
     */
    boolean hasGcsIntermediateDataLocation();
    /**
     *
     *
     * <pre>
     * Cloud Storage intermediate data location.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
     *
     * @return The gcsIntermediateDataLocation.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.GcsData getGcsIntermediateDataLocation();
    /**
     *
     *
     * <pre>
     * Cloud Storage intermediate data location.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder
        getGcsIntermediateDataLocationOrBuilder();

    /**
     *
     *
     * <pre>
     * Only objects that satisfy these object conditions are included in the set
     * of data source and data sink objects.  Object conditions based on
     * objects' "last modification time" do not exclude objects in a data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
     *
     * @return Whether the objectConditions field is set.
     */
    boolean hasObjectConditions();
    /**
     *
     *
     * <pre>
     * Only objects that satisfy these object conditions are included in the set
     * of data source and data sink objects.  Object conditions based on
     * objects' "last modification time" do not exclude objects in a data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
     *
     * @return The objectConditions.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions getObjectConditions();
    /**
     *
     *
     * <pre>
     * Only objects that satisfy these object conditions are included in the set
     * of data source and data sink objects.  Object conditions based on
     * objects' "last modification time" do not exclude objects in a data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditionsOrBuilder
        getObjectConditionsOrBuilder();

    /**
     *
     *
     * <pre>
     * If the option
     * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
     * is `true` and time-based object conditions such as 'last modification time'
     * are specified, the request fails with an
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
     *
     * @return Whether the transferOptions field is set.
     */
    boolean hasTransferOptions();
    /**
     *
     *
     * <pre>
     * If the option
     * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
     * is `true` and time-based object conditions such as 'last modification time'
     * are specified, the request fails with an
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
     *
     * @return The transferOptions.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions getTransferOptions();
    /**
     *
     *
     * <pre>
     * If the option
     * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
     * is `true` and time-based object conditions such as 'last modification time'
     * are specified, the request fails with an
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.TransferOptionsOrBuilder
        getTransferOptionsOrBuilder();

    /**
     *
     *
     * <pre>
     * A manifest file provides a list of objects to be transferred from the data
     * source. This field points to the location of the manifest file.
     * Otherwise, the entire source bucket is used. ObjectConditions still apply.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
     *
     * @return Whether the transferManifest field is set.
     */
    boolean hasTransferManifest();
    /**
     *
     *
     * <pre>
     * A manifest file provides a list of objects to be transferred from the data
     * source. This field points to the location of the manifest file.
     * Otherwise, the entire source bucket is used. ObjectConditions still apply.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
     *
     * @return The transferManifest.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest getTransferManifest();
    /**
     *
     *
     * <pre>
     * A manifest file provides a list of objects to be transferred from the data
     * source. This field points to the location of the manifest file.
     * Otherwise, the entire source bucket is used. ObjectConditions still apply.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.TransferManifestOrBuilder
        getTransferManifestOrBuilder();

    /**
     *
     *
     * <pre>
     * Specifies the agent pool name associated with the posix data source. When
     * unspecified, the default name is used.
     * </pre>
     *
     * <code>string source_agent_pool_name = 17;</code>
     *
     * @return The sourceAgentPoolName.
     */
    java.lang.String getSourceAgentPoolName();
    /**
     *
     *
     * <pre>
     * Specifies the agent pool name associated with the posix data source. When
     * unspecified, the default name is used.
     * </pre>
     *
     * <code>string source_agent_pool_name = 17;</code>
     *
     * @return The bytes for sourceAgentPoolName.
     */
    com.google.protobuf.ByteString getSourceAgentPoolNameBytes();

    /**
     *
     *
     * <pre>
     * Specifies the agent pool name associated with the posix data sink. When
     * unspecified, the default name is used.
     * </pre>
     *
     * <code>string sink_agent_pool_name = 18;</code>
     *
     * @return The sinkAgentPoolName.
     */
    java.lang.String getSinkAgentPoolName();
    /**
     *
     *
     * <pre>
     * Specifies the agent pool name associated with the posix data sink. When
     * unspecified, the default name is used.
     * </pre>
     *
     * <code>string sink_agent_pool_name = 18;</code>
     *
     * @return The bytes for sinkAgentPoolName.
     */
    com.google.protobuf.ByteString getSinkAgentPoolNameBytes();

    public com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec.DataSinkCase
        getDataSinkCase();

    public com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec.DataSourceCase
        getDataSourceCase();

    public com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec
            .IntermediateDataLocationCase
        getIntermediateDataLocationCase();
  }
  /**
   *
   *
   * <pre>
   * Configuration for running a transfer.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.TransferSpec}
   */
  public static final class TransferSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.TransferSpec)
      TransferSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TransferSpec.newBuilder() to construct.
    private TransferSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TransferSpec() {
      sourceAgentPoolName_ = "";
      sinkAgentPoolName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TransferSpec();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_TransferSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_TransferSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec.class,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec.Builder.class);
    }

    private int dataSinkCase_ = 0;
    private java.lang.Object dataSink_;

    public enum DataSinkCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_DATA_SINK(4),
      POSIX_DATA_SINK(13),
      DATASINK_NOT_SET(0);
      private final int value;

      private DataSinkCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DataSinkCase valueOf(int value) {
        return forNumber(value);
      }

      public static DataSinkCase forNumber(int value) {
        switch (value) {
          case 4:
            return GCS_DATA_SINK;
          case 13:
            return POSIX_DATA_SINK;
          case 0:
            return DATASINK_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DataSinkCase getDataSinkCase() {
      return DataSinkCase.forNumber(dataSinkCase_);
    }

    private int dataSourceCase_ = 0;
    private java.lang.Object dataSource_;

    public enum DataSourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_DATA_SOURCE(1),
      AWS_S3_DATA_SOURCE(2),
      HTTP_DATA_SOURCE(3),
      POSIX_DATA_SOURCE(14),
      AZURE_BLOB_STORAGE_DATA_SOURCE(8),
      AWS_S3_COMPATIBLE_DATA_SOURCE(19),
      DATASOURCE_NOT_SET(0);
      private final int value;

      private DataSourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DataSourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static DataSourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return GCS_DATA_SOURCE;
          case 2:
            return AWS_S3_DATA_SOURCE;
          case 3:
            return HTTP_DATA_SOURCE;
          case 14:
            return POSIX_DATA_SOURCE;
          case 8:
            return AZURE_BLOB_STORAGE_DATA_SOURCE;
          case 19:
            return AWS_S3_COMPATIBLE_DATA_SOURCE;
          case 0:
            return DATASOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public DataSourceCase getDataSourceCase() {
      return DataSourceCase.forNumber(dataSourceCase_);
    }

    private int intermediateDataLocationCase_ = 0;
    private java.lang.Object intermediateDataLocation_;

    public enum IntermediateDataLocationCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_INTERMEDIATE_DATA_LOCATION(16),
      INTERMEDIATEDATALOCATION_NOT_SET(0);
      private final int value;

      private IntermediateDataLocationCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static IntermediateDataLocationCase valueOf(int value) {
        return forNumber(value);
      }

      public static IntermediateDataLocationCase forNumber(int value) {
        switch (value) {
          case 16:
            return GCS_INTERMEDIATE_DATA_LOCATION;
          case 0:
            return INTERMEDIATEDATALOCATION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public IntermediateDataLocationCase getIntermediateDataLocationCase() {
      return IntermediateDataLocationCase.forNumber(intermediateDataLocationCase_);
    }

    public static final int GCS_DATA_SINK_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * A Cloud Storage data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
     *
     * @return Whether the gcsDataSink field is set.
     */
    @java.lang.Override
    public boolean hasGcsDataSink() {
      return dataSinkCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
     *
     * @return The gcsDataSink.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.GcsData getGcsDataSink() {
      if (dataSinkCase_ == 4) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSink_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder
        getGcsDataSinkOrBuilder() {
      if (dataSinkCase_ == 4) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSink_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
    }

    public static final int POSIX_DATA_SINK_FIELD_NUMBER = 13;
    /**
     *
     *
     * <pre>
     * A POSIX Filesystem data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
     *
     * @return Whether the posixDataSink field is set.
     */
    @java.lang.Override
    public boolean hasPosixDataSink() {
      return dataSinkCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * A POSIX Filesystem data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
     *
     * @return The posixDataSink.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem getPosixDataSink() {
      if (dataSinkCase_ == 13) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSink_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A POSIX Filesystem data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder
        getPosixDataSinkOrBuilder() {
      if (dataSinkCase_ == 13) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSink_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.getDefaultInstance();
    }

    public static final int GCS_DATA_SOURCE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * A Cloud Storage data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
     *
     * @return Whether the gcsDataSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsDataSource() {
      return dataSourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
     *
     * @return The gcsDataSource.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.GcsData getGcsDataSource() {
      if (dataSourceCase_ == 1) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSource_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A Cloud Storage data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder
        getGcsDataSourceOrBuilder() {
      if (dataSourceCase_ == 1) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSource_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
    }

    public static final int AWS_S3_DATA_SOURCE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * An AWS S3 data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
     *
     * @return Whether the awsS3DataSource field is set.
     */
    @java.lang.Override
    public boolean hasAwsS3DataSource() {
      return dataSourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * An AWS S3 data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
     *
     * @return The awsS3DataSource.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data getAwsS3DataSource() {
      if (dataSourceCase_ == 2) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data) dataSource_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * An AWS S3 data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3DataOrBuilder
        getAwsS3DataSourceOrBuilder() {
      if (dataSourceCase_ == 2) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data) dataSource_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.getDefaultInstance();
    }

    public static final int HTTP_DATA_SOURCE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * An HTTP URL data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
     *
     * @return Whether the httpDataSource field is set.
     */
    @java.lang.Override
    public boolean hasHttpDataSource() {
      return dataSourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * An HTTP URL data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
     *
     * @return The httpDataSource.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.HttpData getHttpDataSource() {
      if (dataSourceCase_ == 3) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.HttpData) dataSource_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.HttpData.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * An HTTP URL data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.HttpDataOrBuilder
        getHttpDataSourceOrBuilder() {
      if (dataSourceCase_ == 3) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.HttpData) dataSource_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.HttpData.getDefaultInstance();
    }

    public static final int POSIX_DATA_SOURCE_FIELD_NUMBER = 14;
    /**
     *
     *
     * <pre>
     * A POSIX Filesystem data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
     *
     * @return Whether the posixDataSource field is set.
     */
    @java.lang.Override
    public boolean hasPosixDataSource() {
      return dataSourceCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * A POSIX Filesystem data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
     *
     * @return The posixDataSource.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem getPosixDataSource() {
      if (dataSourceCase_ == 14) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSource_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A POSIX Filesystem data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder
        getPosixDataSourceOrBuilder() {
      if (dataSourceCase_ == 14) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSource_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.getDefaultInstance();
    }

    public static final int AZURE_BLOB_STORAGE_DATA_SOURCE_FIELD_NUMBER = 8;
    /**
     *
     *
     * <pre>
     * An Azure Blob Storage data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
     * </code>
     *
     * @return Whether the azureBlobStorageDataSource field is set.
     */
    @java.lang.Override
    public boolean hasAzureBlobStorageDataSource() {
      return dataSourceCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * An Azure Blob Storage data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
     * </code>
     *
     * @return The azureBlobStorageDataSource.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
        getAzureBlobStorageDataSource() {
      if (dataSourceCase_ == 8) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData) dataSource_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * An Azure Blob Storage data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageDataOrBuilder
        getAzureBlobStorageDataSourceOrBuilder() {
      if (dataSourceCase_ == 8) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData) dataSource_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
          .getDefaultInstance();
    }

    public static final int AWS_S3_COMPATIBLE_DATA_SOURCE_FIELD_NUMBER = 19;
    /**
     *
     *
     * <pre>
     * An AWS S3 compatible data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
     * </code>
     *
     * @return Whether the awsS3CompatibleDataSource field is set.
     */
    @java.lang.Override
    public boolean hasAwsS3CompatibleDataSource() {
      return dataSourceCase_ == 19;
    }
    /**
     *
     *
     * <pre>
     * An AWS S3 compatible data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
     * </code>
     *
     * @return The awsS3CompatibleDataSource.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
        getAwsS3CompatibleDataSource() {
      if (dataSourceCase_ == 19) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData) dataSource_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * An AWS S3 compatible data source.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
     * </code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleDataOrBuilder
        getAwsS3CompatibleDataSourceOrBuilder() {
      if (dataSourceCase_ == 19) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData) dataSource_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
          .getDefaultInstance();
    }

    public static final int GCS_INTERMEDIATE_DATA_LOCATION_FIELD_NUMBER = 16;
    /**
     *
     *
     * <pre>
     * Cloud Storage intermediate data location.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
     *
     * @return Whether the gcsIntermediateDataLocation field is set.
     */
    @java.lang.Override
    public boolean hasGcsIntermediateDataLocation() {
      return intermediateDataLocationCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage intermediate data location.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
     *
     * @return The gcsIntermediateDataLocation.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.GcsData
        getGcsIntermediateDataLocation() {
      if (intermediateDataLocationCase_ == 16) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.GcsData)
            intermediateDataLocation_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage intermediate data location.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder
        getGcsIntermediateDataLocationOrBuilder() {
      if (intermediateDataLocationCase_ == 16) {
        return (com.google.storagetransfer.v1.proto.TransferTypes.GcsData)
            intermediateDataLocation_;
      }
      return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
    }

    public static final int OBJECT_CONDITIONS_FIELD_NUMBER = 5;
    private com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions objectConditions_;
    /**
     *
     *
     * <pre>
     * Only objects that satisfy these object conditions are included in the set
     * of data source and data sink objects.  Object conditions based on
     * objects' "last modification time" do not exclude objects in a data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
     *
     * @return Whether the objectConditions field is set.
     */
    @java.lang.Override
    public boolean hasObjectConditions() {
      return objectConditions_ != null;
    }
    /**
     *
     *
     * <pre>
     * Only objects that satisfy these object conditions are included in the set
     * of data source and data sink objects.  Object conditions based on
     * objects' "last modification time" do not exclude objects in a data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
     *
     * @return The objectConditions.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions
        getObjectConditions() {
      return objectConditions_ == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions.getDefaultInstance()
          : objectConditions_;
    }
    /**
     *
     *
     * <pre>
     * Only objects that satisfy these object conditions are included in the set
     * of data source and data sink objects.  Object conditions based on
     * objects' "last modification time" do not exclude objects in a data sink.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditionsOrBuilder
        getObjectConditionsOrBuilder() {
      return getObjectConditions();
    }

    public static final int TRANSFER_OPTIONS_FIELD_NUMBER = 6;
    private com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions transferOptions_;
    /**
     *
     *
     * <pre>
     * If the option
     * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
     * is `true` and time-based object conditions such as 'last modification time'
     * are specified, the request fails with an
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
     *
     * @return Whether the transferOptions field is set.
     */
    @java.lang.Override
    public boolean hasTransferOptions() {
      return transferOptions_ != null;
    }
    /**
     *
     *
     * <pre>
     * If the option
     * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
     * is `true` and time-based object conditions such as 'last modification time'
     * are specified, the request fails with an
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
     *
     * @return The transferOptions.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions getTransferOptions() {
      return transferOptions_ == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.getDefaultInstance()
          : transferOptions_;
    }
    /**
     *
     *
     * <pre>
     * If the option
     * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
     * is `true` and time-based object conditions such as 'last modification time'
     * are specified, the request fails with an
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferOptionsOrBuilder
        getTransferOptionsOrBuilder() {
      return getTransferOptions();
    }

    public static final int TRANSFER_MANIFEST_FIELD_NUMBER = 15;
    private com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest transferManifest_;
    /**
     *
     *
     * <pre>
     * A manifest file provides a list of objects to be transferred from the data
     * source. This field points to the location of the manifest file.
     * Otherwise, the entire source bucket is used. ObjectConditions still apply.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
     *
     * @return Whether the transferManifest field is set.
     */
    @java.lang.Override
    public boolean hasTransferManifest() {
      return transferManifest_ != null;
    }
    /**
     *
     *
     * <pre>
     * A manifest file provides a list of objects to be transferred from the data
     * source. This field points to the location of the manifest file.
     * Otherwise, the entire source bucket is used. ObjectConditions still apply.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
     *
     * @return The transferManifest.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest
        getTransferManifest() {
      return transferManifest_ == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest.getDefaultInstance()
          : transferManifest_;
    }
    /**
     *
     *
     * <pre>
     * A manifest file provides a list of objects to be transferred from the data
     * source. This field points to the location of the manifest file.
     * Otherwise, the entire source bucket is used. ObjectConditions still apply.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferManifestOrBuilder
        getTransferManifestOrBuilder() {
      return getTransferManifest();
    }

    public static final int SOURCE_AGENT_POOL_NAME_FIELD_NUMBER = 17;
    private volatile java.lang.Object sourceAgentPoolName_;
    /**
     *
     *
     * <pre>
     * Specifies the agent pool name associated with the posix data source. When
     * unspecified, the default name is used.
     * </pre>
     *
     * <code>string source_agent_pool_name = 17;</code>
     *
     * @return The sourceAgentPoolName.
     */
    @java.lang.Override
    public java.lang.String getSourceAgentPoolName() {
      java.lang.Object ref = sourceAgentPoolName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceAgentPoolName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the agent pool name associated with the posix data source. When
     * unspecified, the default name is used.
     * </pre>
     *
     * <code>string source_agent_pool_name = 17;</code>
     *
     * @return The bytes for sourceAgentPoolName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceAgentPoolNameBytes() {
      java.lang.Object ref = sourceAgentPoolName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceAgentPoolName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SINK_AGENT_POOL_NAME_FIELD_NUMBER = 18;
    private volatile java.lang.Object sinkAgentPoolName_;
    /**
     *
     *
     * <pre>
     * Specifies the agent pool name associated with the posix data sink. When
     * unspecified, the default name is used.
     * </pre>
     *
     * <code>string sink_agent_pool_name = 18;</code>
     *
     * @return The sinkAgentPoolName.
     */
    @java.lang.Override
    public java.lang.String getSinkAgentPoolName() {
      java.lang.Object ref = sinkAgentPoolName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sinkAgentPoolName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the agent pool name associated with the posix data sink. When
     * unspecified, the default name is used.
     * </pre>
     *
     * <code>string sink_agent_pool_name = 18;</code>
     *
     * @return The bytes for sinkAgentPoolName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSinkAgentPoolNameBytes() {
      java.lang.Object ref = sinkAgentPoolName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sinkAgentPoolName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (dataSourceCase_ == 1) {
        output.writeMessage(
            1, (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSource_);
      }
      if (dataSourceCase_ == 2) {
        output.writeMessage(
            2, (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data) dataSource_);
      }
      if (dataSourceCase_ == 3) {
        output.writeMessage(
            3, (com.google.storagetransfer.v1.proto.TransferTypes.HttpData) dataSource_);
      }
      if (dataSinkCase_ == 4) {
        output.writeMessage(
            4, (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSink_);
      }
      if (objectConditions_ != null) {
        output.writeMessage(5, getObjectConditions());
      }
      if (transferOptions_ != null) {
        output.writeMessage(6, getTransferOptions());
      }
      if (dataSourceCase_ == 8) {
        output.writeMessage(
            8,
            (com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData) dataSource_);
      }
      if (dataSinkCase_ == 13) {
        output.writeMessage(
            13, (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSink_);
      }
      if (dataSourceCase_ == 14) {
        output.writeMessage(
            14, (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSource_);
      }
      if (transferManifest_ != null) {
        output.writeMessage(15, getTransferManifest());
      }
      if (intermediateDataLocationCase_ == 16) {
        output.writeMessage(
            16,
            (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) intermediateDataLocation_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceAgentPoolName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 17, sourceAgentPoolName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sinkAgentPoolName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 18, sinkAgentPoolName_);
      }
      if (dataSourceCase_ == 19) {
        output.writeMessage(
            19,
            (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData) dataSource_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (dataSourceCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSource_);
      }
      if (dataSourceCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data) dataSource_);
      }
      if (dataSourceCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.storagetransfer.v1.proto.TransferTypes.HttpData) dataSource_);
      }
      if (dataSinkCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSink_);
      }
      if (objectConditions_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getObjectConditions());
      }
      if (transferOptions_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getTransferOptions());
      }
      if (dataSourceCase_ == 8) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                8,
                (com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData)
                    dataSource_);
      }
      if (dataSinkCase_ == 13) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                13, (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSink_);
      }
      if (dataSourceCase_ == 14) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                14,
                (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSource_);
      }
      if (transferManifest_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getTransferManifest());
      }
      if (intermediateDataLocationCase_ == 16) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                16,
                (com.google.storagetransfer.v1.proto.TransferTypes.GcsData)
                    intermediateDataLocation_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceAgentPoolName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, sourceAgentPoolName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sinkAgentPoolName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, sinkAgentPoolName_);
      }
      if (dataSourceCase_ == 19) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                19,
                (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData)
                    dataSource_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec other =
          (com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec) obj;

      if (hasObjectConditions() != other.hasObjectConditions()) return false;
      if (hasObjectConditions()) {
        if (!getObjectConditions().equals(other.getObjectConditions())) return false;
      }
      if (hasTransferOptions() != other.hasTransferOptions()) return false;
      if (hasTransferOptions()) {
        if (!getTransferOptions().equals(other.getTransferOptions())) return false;
      }
      if (hasTransferManifest() != other.hasTransferManifest()) return false;
      if (hasTransferManifest()) {
        if (!getTransferManifest().equals(other.getTransferManifest())) return false;
      }
      if (!getSourceAgentPoolName().equals(other.getSourceAgentPoolName())) return false;
      if (!getSinkAgentPoolName().equals(other.getSinkAgentPoolName())) return false;
      if (!getDataSinkCase().equals(other.getDataSinkCase())) return false;
      switch (dataSinkCase_) {
        case 4:
          if (!getGcsDataSink().equals(other.getGcsDataSink())) return false;
          break;
        case 13:
          if (!getPosixDataSink().equals(other.getPosixDataSink())) return false;
          break;
        case 0:
        default:
      }
      if (!getDataSourceCase().equals(other.getDataSourceCase())) return false;
      switch (dataSourceCase_) {
        case 1:
          if (!getGcsDataSource().equals(other.getGcsDataSource())) return false;
          break;
        case 2:
          if (!getAwsS3DataSource().equals(other.getAwsS3DataSource())) return false;
          break;
        case 3:
          if (!getHttpDataSource().equals(other.getHttpDataSource())) return false;
          break;
        case 14:
          if (!getPosixDataSource().equals(other.getPosixDataSource())) return false;
          break;
        case 8:
          if (!getAzureBlobStorageDataSource().equals(other.getAzureBlobStorageDataSource()))
            return false;
          break;
        case 19:
          if (!getAwsS3CompatibleDataSource().equals(other.getAwsS3CompatibleDataSource()))
            return false;
          break;
        case 0:
        default:
      }
      if (!getIntermediateDataLocationCase().equals(other.getIntermediateDataLocationCase()))
        return false;
      switch (intermediateDataLocationCase_) {
        case 16:
          if (!getGcsIntermediateDataLocation().equals(other.getGcsIntermediateDataLocation()))
            return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasObjectConditions()) {
        hash = (37 * hash) + OBJECT_CONDITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getObjectConditions().hashCode();
      }
      if (hasTransferOptions()) {
        hash = (37 * hash) + TRANSFER_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getTransferOptions().hashCode();
      }
      if (hasTransferManifest()) {
        hash = (37 * hash) + TRANSFER_MANIFEST_FIELD_NUMBER;
        hash = (53 * hash) + getTransferManifest().hashCode();
      }
      hash = (37 * hash) + SOURCE_AGENT_POOL_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getSourceAgentPoolName().hashCode();
      hash = (37 * hash) + SINK_AGENT_POOL_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getSinkAgentPoolName().hashCode();
      switch (dataSinkCase_) {
        case 4:
          hash = (37 * hash) + GCS_DATA_SINK_FIELD_NUMBER;
          hash = (53 * hash) + getGcsDataSink().hashCode();
          break;
        case 13:
          hash = (37 * hash) + POSIX_DATA_SINK_FIELD_NUMBER;
          hash = (53 * hash) + getPosixDataSink().hashCode();
          break;
        case 0:
        default:
      }
      switch (dataSourceCase_) {
        case 1:
          hash = (37 * hash) + GCS_DATA_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getGcsDataSource().hashCode();
          break;
        case 2:
          hash = (37 * hash) + AWS_S3_DATA_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getAwsS3DataSource().hashCode();
          break;
        case 3:
          hash = (37 * hash) + HTTP_DATA_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getHttpDataSource().hashCode();
          break;
        case 14:
          hash = (37 * hash) + POSIX_DATA_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getPosixDataSource().hashCode();
          break;
        case 8:
          hash = (37 * hash) + AZURE_BLOB_STORAGE_DATA_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getAzureBlobStorageDataSource().hashCode();
          break;
        case 19:
          hash = (37 * hash) + AWS_S3_COMPATIBLE_DATA_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getAwsS3CompatibleDataSource().hashCode();
          break;
        case 0:
        default:
      }
      switch (intermediateDataLocationCase_) {
        case 16:
          hash = (37 * hash) + GCS_INTERMEDIATE_DATA_LOCATION_FIELD_NUMBER;
          hash = (53 * hash) + getGcsIntermediateDataLocation().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for running a transfer.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.TransferSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.TransferSpec)
        com.google.storagetransfer.v1.proto.TransferTypes.TransferSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_TransferSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_TransferSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec.class,
                com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec.Builder.class);
      }

      // Construct using com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (gcsDataSinkBuilder_ != null) {
          gcsDataSinkBuilder_.clear();
        }
        if (posixDataSinkBuilder_ != null) {
          posixDataSinkBuilder_.clear();
        }
        if (gcsDataSourceBuilder_ != null) {
          gcsDataSourceBuilder_.clear();
        }
        if (awsS3DataSourceBuilder_ != null) {
          awsS3DataSourceBuilder_.clear();
        }
        if (httpDataSourceBuilder_ != null) {
          httpDataSourceBuilder_.clear();
        }
        if (posixDataSourceBuilder_ != null) {
          posixDataSourceBuilder_.clear();
        }
        if (azureBlobStorageDataSourceBuilder_ != null) {
          azureBlobStorageDataSourceBuilder_.clear();
        }
        if (awsS3CompatibleDataSourceBuilder_ != null) {
          awsS3CompatibleDataSourceBuilder_.clear();
        }
        if (gcsIntermediateDataLocationBuilder_ != null) {
          gcsIntermediateDataLocationBuilder_.clear();
        }
        if (objectConditionsBuilder_ == null) {
          objectConditions_ = null;
        } else {
          objectConditions_ = null;
          objectConditionsBuilder_ = null;
        }
        if (transferOptionsBuilder_ == null) {
          transferOptions_ = null;
        } else {
          transferOptions_ = null;
          transferOptionsBuilder_ = null;
        }
        if (transferManifestBuilder_ == null) {
          transferManifest_ = null;
        } else {
          transferManifest_ = null;
          transferManifestBuilder_ = null;
        }
        sourceAgentPoolName_ = "";

        sinkAgentPoolName_ = "";

        dataSinkCase_ = 0;
        dataSink_ = null;
        dataSourceCase_ = 0;
        dataSource_ = null;
        intermediateDataLocationCase_ = 0;
        intermediateDataLocation_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_TransferSpec_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec build() {
        com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec result =
            new com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec(this);
        if (dataSinkCase_ == 4) {
          if (gcsDataSinkBuilder_ == null) {
            result.dataSink_ = dataSink_;
          } else {
            result.dataSink_ = gcsDataSinkBuilder_.build();
          }
        }
        if (dataSinkCase_ == 13) {
          if (posixDataSinkBuilder_ == null) {
            result.dataSink_ = dataSink_;
          } else {
            result.dataSink_ = posixDataSinkBuilder_.build();
          }
        }
        if (dataSourceCase_ == 1) {
          if (gcsDataSourceBuilder_ == null) {
            result.dataSource_ = dataSource_;
          } else {
            result.dataSource_ = gcsDataSourceBuilder_.build();
          }
        }
        if (dataSourceCase_ == 2) {
          if (awsS3DataSourceBuilder_ == null) {
            result.dataSource_ = dataSource_;
          } else {
            result.dataSource_ = awsS3DataSourceBuilder_.build();
          }
        }
        if (dataSourceCase_ == 3) {
          if (httpDataSourceBuilder_ == null) {
            result.dataSource_ = dataSource_;
          } else {
            result.dataSource_ = httpDataSourceBuilder_.build();
          }
        }
        if (dataSourceCase_ == 14) {
          if (posixDataSourceBuilder_ == null) {
            result.dataSource_ = dataSource_;
          } else {
            result.dataSource_ = posixDataSourceBuilder_.build();
          }
        }
        if (dataSourceCase_ == 8) {
          if (azureBlobStorageDataSourceBuilder_ == null) {
            result.dataSource_ = dataSource_;
          } else {
            result.dataSource_ = azureBlobStorageDataSourceBuilder_.build();
          }
        }
        if (dataSourceCase_ == 19) {
          if (awsS3CompatibleDataSourceBuilder_ == null) {
            result.dataSource_ = dataSource_;
          } else {
            result.dataSource_ = awsS3CompatibleDataSourceBuilder_.build();
          }
        }
        if (intermediateDataLocationCase_ == 16) {
          if (gcsIntermediateDataLocationBuilder_ == null) {
            result.intermediateDataLocation_ = intermediateDataLocation_;
          } else {
            result.intermediateDataLocation_ = gcsIntermediateDataLocationBuilder_.build();
          }
        }
        if (objectConditionsBuilder_ == null) {
          result.objectConditions_ = objectConditions_;
        } else {
          result.objectConditions_ = objectConditionsBuilder_.build();
        }
        if (transferOptionsBuilder_ == null) {
          result.transferOptions_ = transferOptions_;
        } else {
          result.transferOptions_ = transferOptionsBuilder_.build();
        }
        if (transferManifestBuilder_ == null) {
          result.transferManifest_ = transferManifest_;
        } else {
          result.transferManifest_ = transferManifestBuilder_.build();
        }
        result.sourceAgentPoolName_ = sourceAgentPoolName_;
        result.sinkAgentPoolName_ = sinkAgentPoolName_;
        result.dataSinkCase_ = dataSinkCase_;
        result.dataSourceCase_ = dataSourceCase_;
        result.intermediateDataLocationCase_ = intermediateDataLocationCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec) {
          return mergeFrom((com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec.getDefaultInstance())
          return this;
        if (other.hasObjectConditions()) {
          mergeObjectConditions(other.getObjectConditions());
        }
        if (other.hasTransferOptions()) {
          mergeTransferOptions(other.getTransferOptions());
        }
        if (other.hasTransferManifest()) {
          mergeTransferManifest(other.getTransferManifest());
        }
        if (!other.getSourceAgentPoolName().isEmpty()) {
          sourceAgentPoolName_ = other.sourceAgentPoolName_;
          onChanged();
        }
        if (!other.getSinkAgentPoolName().isEmpty()) {
          sinkAgentPoolName_ = other.sinkAgentPoolName_;
          onChanged();
        }
        switch (other.getDataSinkCase()) {
          case GCS_DATA_SINK:
            {
              mergeGcsDataSink(other.getGcsDataSink());
              break;
            }
          case POSIX_DATA_SINK:
            {
              mergePosixDataSink(other.getPosixDataSink());
              break;
            }
          case DATASINK_NOT_SET:
            {
              break;
            }
        }
        switch (other.getDataSourceCase()) {
          case GCS_DATA_SOURCE:
            {
              mergeGcsDataSource(other.getGcsDataSource());
              break;
            }
          case AWS_S3_DATA_SOURCE:
            {
              mergeAwsS3DataSource(other.getAwsS3DataSource());
              break;
            }
          case HTTP_DATA_SOURCE:
            {
              mergeHttpDataSource(other.getHttpDataSource());
              break;
            }
          case POSIX_DATA_SOURCE:
            {
              mergePosixDataSource(other.getPosixDataSource());
              break;
            }
          case AZURE_BLOB_STORAGE_DATA_SOURCE:
            {
              mergeAzureBlobStorageDataSource(other.getAzureBlobStorageDataSource());
              break;
            }
          case AWS_S3_COMPATIBLE_DATA_SOURCE:
            {
              mergeAwsS3CompatibleDataSource(other.getAwsS3CompatibleDataSource());
              break;
            }
          case DATASOURCE_NOT_SET:
            {
              break;
            }
        }
        switch (other.getIntermediateDataLocationCase()) {
          case GCS_INTERMEDIATE_DATA_LOCATION:
            {
              mergeGcsIntermediateDataLocation(other.getGcsIntermediateDataLocation());
              break;
            }
          case INTERMEDIATEDATALOCATION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getGcsDataSourceFieldBuilder().getBuilder(), extensionRegistry);
                  dataSourceCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getAwsS3DataSourceFieldBuilder().getBuilder(), extensionRegistry);
                  dataSourceCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getHttpDataSourceFieldBuilder().getBuilder(), extensionRegistry);
                  dataSourceCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getGcsDataSinkFieldBuilder().getBuilder(), extensionRegistry);
                  dataSinkCase_ = 4;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getObjectConditionsFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getTransferOptionsFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 50
              case 66:
                {
                  input.readMessage(
                      getAzureBlobStorageDataSourceFieldBuilder().getBuilder(), extensionRegistry);
                  dataSourceCase_ = 8;
                  break;
                } // case 66
              case 106:
                {
                  input.readMessage(getPosixDataSinkFieldBuilder().getBuilder(), extensionRegistry);
                  dataSinkCase_ = 13;
                  break;
                } // case 106
              case 114:
                {
                  input.readMessage(
                      getPosixDataSourceFieldBuilder().getBuilder(), extensionRegistry);
                  dataSourceCase_ = 14;
                  break;
                } // case 114
              case 122:
                {
                  input.readMessage(
                      getTransferManifestFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 122
              case 130:
                {
                  input.readMessage(
                      getGcsIntermediateDataLocationFieldBuilder().getBuilder(), extensionRegistry);
                  intermediateDataLocationCase_ = 16;
                  break;
                } // case 130
              case 138:
                {
                  sourceAgentPoolName_ = input.readStringRequireUtf8();

                  break;
                } // case 138
              case 146:
                {
                  sinkAgentPoolName_ = input.readStringRequireUtf8();

                  break;
                } // case 146
              case 154:
                {
                  input.readMessage(
                      getAwsS3CompatibleDataSourceFieldBuilder().getBuilder(), extensionRegistry);
                  dataSourceCase_ = 19;
                  break;
                } // case 154
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int dataSinkCase_ = 0;
      private java.lang.Object dataSink_;

      public DataSinkCase getDataSinkCase() {
        return DataSinkCase.forNumber(dataSinkCase_);
      }

      public Builder clearDataSink() {
        dataSinkCase_ = 0;
        dataSink_ = null;
        onChanged();
        return this;
      }

      private int dataSourceCase_ = 0;
      private java.lang.Object dataSource_;

      public DataSourceCase getDataSourceCase() {
        return DataSourceCase.forNumber(dataSourceCase_);
      }

      public Builder clearDataSource() {
        dataSourceCase_ = 0;
        dataSource_ = null;
        onChanged();
        return this;
      }

      private int intermediateDataLocationCase_ = 0;
      private java.lang.Object intermediateDataLocation_;

      public IntermediateDataLocationCase getIntermediateDataLocationCase() {
        return IntermediateDataLocationCase.forNumber(intermediateDataLocationCase_);
      }

      public Builder clearIntermediateDataLocation() {
        intermediateDataLocationCase_ = 0;
        intermediateDataLocation_ = null;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder>
          gcsDataSinkBuilder_;
      /**
       *
       *
       * <pre>
       * A Cloud Storage data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
       *
       * @return Whether the gcsDataSink field is set.
       */
      @java.lang.Override
      public boolean hasGcsDataSink() {
        return dataSinkCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
       *
       * @return The gcsDataSink.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.GcsData getGcsDataSink() {
        if (gcsDataSinkBuilder_ == null) {
          if (dataSinkCase_ == 4) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSink_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
        } else {
          if (dataSinkCase_ == 4) {
            return gcsDataSinkBuilder_.getMessage();
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
       */
      public Builder setGcsDataSink(
          com.google.storagetransfer.v1.proto.TransferTypes.GcsData value) {
        if (gcsDataSinkBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataSink_ = value;
          onChanged();
        } else {
          gcsDataSinkBuilder_.setMessage(value);
        }
        dataSinkCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
       */
      public Builder setGcsDataSink(
          com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder builderForValue) {
        if (gcsDataSinkBuilder_ == null) {
          dataSink_ = builderForValue.build();
          onChanged();
        } else {
          gcsDataSinkBuilder_.setMessage(builderForValue.build());
        }
        dataSinkCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
       */
      public Builder mergeGcsDataSink(
          com.google.storagetransfer.v1.proto.TransferTypes.GcsData value) {
        if (gcsDataSinkBuilder_ == null) {
          if (dataSinkCase_ == 4
              && dataSink_
                  != com.google.storagetransfer.v1.proto.TransferTypes.GcsData
                      .getDefaultInstance()) {
            dataSink_ =
                com.google.storagetransfer.v1.proto.TransferTypes.GcsData.newBuilder(
                        (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSink_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataSink_ = value;
          }
          onChanged();
        } else {
          if (dataSinkCase_ == 4) {
            gcsDataSinkBuilder_.mergeFrom(value);
          } else {
            gcsDataSinkBuilder_.setMessage(value);
          }
        }
        dataSinkCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
       */
      public Builder clearGcsDataSink() {
        if (gcsDataSinkBuilder_ == null) {
          if (dataSinkCase_ == 4) {
            dataSinkCase_ = 0;
            dataSink_ = null;
            onChanged();
          }
        } else {
          if (dataSinkCase_ == 4) {
            dataSinkCase_ = 0;
            dataSink_ = null;
          }
          gcsDataSinkBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder
          getGcsDataSinkBuilder() {
        return getGcsDataSinkFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder
          getGcsDataSinkOrBuilder() {
        if ((dataSinkCase_ == 4) && (gcsDataSinkBuilder_ != null)) {
          return gcsDataSinkBuilder_.getMessageOrBuilder();
        } else {
          if (dataSinkCase_ == 4) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSink_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_sink = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder>
          getGcsDataSinkFieldBuilder() {
        if (gcsDataSinkBuilder_ == null) {
          if (!(dataSinkCase_ == 4)) {
            dataSink_ =
                com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
          }
          gcsDataSinkBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.GcsData,
                  com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder>(
                  (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSink_,
                  getParentForChildren(),
                  isClean());
          dataSink_ = null;
        }
        dataSinkCase_ = 4;
        onChanged();
        ;
        return gcsDataSinkBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem,
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder>
          posixDataSinkBuilder_;
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
       *
       * @return Whether the posixDataSink field is set.
       */
      @java.lang.Override
      public boolean hasPosixDataSink() {
        return dataSinkCase_ == 13;
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
       *
       * @return The posixDataSink.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem getPosixDataSink() {
        if (posixDataSinkBuilder_ == null) {
          if (dataSinkCase_ == 13) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSink_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
              .getDefaultInstance();
        } else {
          if (dataSinkCase_ == 13) {
            return posixDataSinkBuilder_.getMessage();
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
       */
      public Builder setPosixDataSink(
          com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem value) {
        if (posixDataSinkBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataSink_ = value;
          onChanged();
        } else {
          posixDataSinkBuilder_.setMessage(value);
        }
        dataSinkCase_ = 13;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
       */
      public Builder setPosixDataSink(
          com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.Builder
              builderForValue) {
        if (posixDataSinkBuilder_ == null) {
          dataSink_ = builderForValue.build();
          onChanged();
        } else {
          posixDataSinkBuilder_.setMessage(builderForValue.build());
        }
        dataSinkCase_ = 13;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
       */
      public Builder mergePosixDataSink(
          com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem value) {
        if (posixDataSinkBuilder_ == null) {
          if (dataSinkCase_ == 13
              && dataSink_
                  != com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
                      .getDefaultInstance()) {
            dataSink_ =
                com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.newBuilder(
                        (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem)
                            dataSink_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataSink_ = value;
          }
          onChanged();
        } else {
          if (dataSinkCase_ == 13) {
            posixDataSinkBuilder_.mergeFrom(value);
          } else {
            posixDataSinkBuilder_.setMessage(value);
          }
        }
        dataSinkCase_ = 13;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
       */
      public Builder clearPosixDataSink() {
        if (posixDataSinkBuilder_ == null) {
          if (dataSinkCase_ == 13) {
            dataSinkCase_ = 0;
            dataSink_ = null;
            onChanged();
          }
        } else {
          if (dataSinkCase_ == 13) {
            dataSinkCase_ = 0;
            dataSink_ = null;
          }
          posixDataSinkBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.Builder
          getPosixDataSinkBuilder() {
        return getPosixDataSinkFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder
          getPosixDataSinkOrBuilder() {
        if ((dataSinkCase_ == 13) && (posixDataSinkBuilder_ != null)) {
          return posixDataSinkBuilder_.getMessageOrBuilder();
        } else {
          if (dataSinkCase_ == 13) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSink_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_sink = 13;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem,
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder>
          getPosixDataSinkFieldBuilder() {
        if (posixDataSinkBuilder_ == null) {
          if (!(dataSinkCase_ == 13)) {
            dataSink_ =
                com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
                    .getDefaultInstance();
          }
          posixDataSinkBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem,
                  com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder>(
                  (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSink_,
                  getParentForChildren(),
                  isClean());
          dataSink_ = null;
        }
        dataSinkCase_ = 13;
        onChanged();
        ;
        return posixDataSinkBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder>
          gcsDataSourceBuilder_;
      /**
       *
       *
       * <pre>
       * A Cloud Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
       *
       * @return Whether the gcsDataSource field is set.
       */
      @java.lang.Override
      public boolean hasGcsDataSource() {
        return dataSourceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
       *
       * @return The gcsDataSource.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.GcsData getGcsDataSource() {
        if (gcsDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 1) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSource_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
        } else {
          if (dataSourceCase_ == 1) {
            return gcsDataSourceBuilder_.getMessage();
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
       */
      public Builder setGcsDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.GcsData value) {
        if (gcsDataSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataSource_ = value;
          onChanged();
        } else {
          gcsDataSourceBuilder_.setMessage(value);
        }
        dataSourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
       */
      public Builder setGcsDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder builderForValue) {
        if (gcsDataSourceBuilder_ == null) {
          dataSource_ = builderForValue.build();
          onChanged();
        } else {
          gcsDataSourceBuilder_.setMessage(builderForValue.build());
        }
        dataSourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
       */
      public Builder mergeGcsDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.GcsData value) {
        if (gcsDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 1
              && dataSource_
                  != com.google.storagetransfer.v1.proto.TransferTypes.GcsData
                      .getDefaultInstance()) {
            dataSource_ =
                com.google.storagetransfer.v1.proto.TransferTypes.GcsData.newBuilder(
                        (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataSource_ = value;
          }
          onChanged();
        } else {
          if (dataSourceCase_ == 1) {
            gcsDataSourceBuilder_.mergeFrom(value);
          } else {
            gcsDataSourceBuilder_.setMessage(value);
          }
        }
        dataSourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
       */
      public Builder clearGcsDataSource() {
        if (gcsDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 1) {
            dataSourceCase_ = 0;
            dataSource_ = null;
            onChanged();
          }
        } else {
          if (dataSourceCase_ == 1) {
            dataSourceCase_ = 0;
            dataSource_ = null;
          }
          gcsDataSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder
          getGcsDataSourceBuilder() {
        return getGcsDataSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder
          getGcsDataSourceOrBuilder() {
        if ((dataSourceCase_ == 1) && (gcsDataSourceBuilder_ != null)) {
          return gcsDataSourceBuilder_.getMessageOrBuilder();
        } else {
          if (dataSourceCase_ == 1) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSource_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A Cloud Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_data_source = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder>
          getGcsDataSourceFieldBuilder() {
        if (gcsDataSourceBuilder_ == null) {
          if (!(dataSourceCase_ == 1)) {
            dataSource_ =
                com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
          }
          gcsDataSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.GcsData,
                  com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder>(
                  (com.google.storagetransfer.v1.proto.TransferTypes.GcsData) dataSource_,
                  getParentForChildren(),
                  isClean());
          dataSource_ = null;
        }
        dataSourceCase_ = 1;
        onChanged();
        ;
        return gcsDataSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3DataOrBuilder>
          awsS3DataSourceBuilder_;
      /**
       *
       *
       * <pre>
       * An AWS S3 data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
       *
       * @return Whether the awsS3DataSource field is set.
       */
      @java.lang.Override
      public boolean hasAwsS3DataSource() {
        return dataSourceCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
       *
       * @return The awsS3DataSource.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data getAwsS3DataSource() {
        if (awsS3DataSourceBuilder_ == null) {
          if (dataSourceCase_ == 2) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data) dataSource_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.getDefaultInstance();
        } else {
          if (dataSourceCase_ == 2) {
            return awsS3DataSourceBuilder_.getMessage();
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
       */
      public Builder setAwsS3DataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data value) {
        if (awsS3DataSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataSource_ = value;
          onChanged();
        } else {
          awsS3DataSourceBuilder_.setMessage(value);
        }
        dataSourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
       */
      public Builder setAwsS3DataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.Builder builderForValue) {
        if (awsS3DataSourceBuilder_ == null) {
          dataSource_ = builderForValue.build();
          onChanged();
        } else {
          awsS3DataSourceBuilder_.setMessage(builderForValue.build());
        }
        dataSourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
       */
      public Builder mergeAwsS3DataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data value) {
        if (awsS3DataSourceBuilder_ == null) {
          if (dataSourceCase_ == 2
              && dataSource_
                  != com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data
                      .getDefaultInstance()) {
            dataSource_ =
                com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.newBuilder(
                        (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data) dataSource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataSource_ = value;
          }
          onChanged();
        } else {
          if (dataSourceCase_ == 2) {
            awsS3DataSourceBuilder_.mergeFrom(value);
          } else {
            awsS3DataSourceBuilder_.setMessage(value);
          }
        }
        dataSourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
       */
      public Builder clearAwsS3DataSource() {
        if (awsS3DataSourceBuilder_ == null) {
          if (dataSourceCase_ == 2) {
            dataSourceCase_ = 0;
            dataSource_ = null;
            onChanged();
          }
        } else {
          if (dataSourceCase_ == 2) {
            dataSourceCase_ = 0;
            dataSource_ = null;
          }
          awsS3DataSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.Builder
          getAwsS3DataSourceBuilder() {
        return getAwsS3DataSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3DataOrBuilder
          getAwsS3DataSourceOrBuilder() {
        if ((dataSourceCase_ == 2) && (awsS3DataSourceBuilder_ != null)) {
          return awsS3DataSourceBuilder_.getMessageOrBuilder();
        } else {
          if (dataSourceCase_ == 2) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data) dataSource_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3Data aws_s3_data_source = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3DataOrBuilder>
          getAwsS3DataSourceFieldBuilder() {
        if (awsS3DataSourceBuilder_ == null) {
          if (!(dataSourceCase_ == 2)) {
            dataSource_ =
                com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.getDefaultInstance();
          }
          awsS3DataSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data,
                  com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.AwsS3DataOrBuilder>(
                  (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3Data) dataSource_,
                  getParentForChildren(),
                  isClean());
          dataSource_ = null;
        }
        dataSourceCase_ = 2;
        onChanged();
        ;
        return awsS3DataSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.HttpData,
              com.google.storagetransfer.v1.proto.TransferTypes.HttpData.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.HttpDataOrBuilder>
          httpDataSourceBuilder_;
      /**
       *
       *
       * <pre>
       * An HTTP URL data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
       *
       * @return Whether the httpDataSource field is set.
       */
      @java.lang.Override
      public boolean hasHttpDataSource() {
        return dataSourceCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * An HTTP URL data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
       *
       * @return The httpDataSource.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.HttpData getHttpDataSource() {
        if (httpDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 3) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.HttpData) dataSource_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.HttpData.getDefaultInstance();
        } else {
          if (dataSourceCase_ == 3) {
            return httpDataSourceBuilder_.getMessage();
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.HttpData.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * An HTTP URL data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
       */
      public Builder setHttpDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.HttpData value) {
        if (httpDataSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataSource_ = value;
          onChanged();
        } else {
          httpDataSourceBuilder_.setMessage(value);
        }
        dataSourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An HTTP URL data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
       */
      public Builder setHttpDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.HttpData.Builder builderForValue) {
        if (httpDataSourceBuilder_ == null) {
          dataSource_ = builderForValue.build();
          onChanged();
        } else {
          httpDataSourceBuilder_.setMessage(builderForValue.build());
        }
        dataSourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An HTTP URL data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
       */
      public Builder mergeHttpDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.HttpData value) {
        if (httpDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 3
              && dataSource_
                  != com.google.storagetransfer.v1.proto.TransferTypes.HttpData
                      .getDefaultInstance()) {
            dataSource_ =
                com.google.storagetransfer.v1.proto.TransferTypes.HttpData.newBuilder(
                        (com.google.storagetransfer.v1.proto.TransferTypes.HttpData) dataSource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataSource_ = value;
          }
          onChanged();
        } else {
          if (dataSourceCase_ == 3) {
            httpDataSourceBuilder_.mergeFrom(value);
          } else {
            httpDataSourceBuilder_.setMessage(value);
          }
        }
        dataSourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An HTTP URL data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
       */
      public Builder clearHttpDataSource() {
        if (httpDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 3) {
            dataSourceCase_ = 0;
            dataSource_ = null;
            onChanged();
          }
        } else {
          if (dataSourceCase_ == 3) {
            dataSourceCase_ = 0;
            dataSource_ = null;
          }
          httpDataSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An HTTP URL data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.HttpData.Builder
          getHttpDataSourceBuilder() {
        return getHttpDataSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * An HTTP URL data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.HttpDataOrBuilder
          getHttpDataSourceOrBuilder() {
        if ((dataSourceCase_ == 3) && (httpDataSourceBuilder_ != null)) {
          return httpDataSourceBuilder_.getMessageOrBuilder();
        } else {
          if (dataSourceCase_ == 3) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.HttpData) dataSource_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.HttpData.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * An HTTP URL data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.HttpData http_data_source = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.HttpData,
              com.google.storagetransfer.v1.proto.TransferTypes.HttpData.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.HttpDataOrBuilder>
          getHttpDataSourceFieldBuilder() {
        if (httpDataSourceBuilder_ == null) {
          if (!(dataSourceCase_ == 3)) {
            dataSource_ =
                com.google.storagetransfer.v1.proto.TransferTypes.HttpData.getDefaultInstance();
          }
          httpDataSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.HttpData,
                  com.google.storagetransfer.v1.proto.TransferTypes.HttpData.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.HttpDataOrBuilder>(
                  (com.google.storagetransfer.v1.proto.TransferTypes.HttpData) dataSource_,
                  getParentForChildren(),
                  isClean());
          dataSource_ = null;
        }
        dataSourceCase_ = 3;
        onChanged();
        ;
        return httpDataSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem,
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder>
          posixDataSourceBuilder_;
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
       *
       * @return Whether the posixDataSource field is set.
       */
      @java.lang.Override
      public boolean hasPosixDataSource() {
        return dataSourceCase_ == 14;
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
       *
       * @return The posixDataSource.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
          getPosixDataSource() {
        if (posixDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 14) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSource_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
              .getDefaultInstance();
        } else {
          if (dataSourceCase_ == 14) {
            return posixDataSourceBuilder_.getMessage();
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
       */
      public Builder setPosixDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem value) {
        if (posixDataSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataSource_ = value;
          onChanged();
        } else {
          posixDataSourceBuilder_.setMessage(value);
        }
        dataSourceCase_ = 14;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
       */
      public Builder setPosixDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.Builder
              builderForValue) {
        if (posixDataSourceBuilder_ == null) {
          dataSource_ = builderForValue.build();
          onChanged();
        } else {
          posixDataSourceBuilder_.setMessage(builderForValue.build());
        }
        dataSourceCase_ = 14;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
       */
      public Builder mergePosixDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem value) {
        if (posixDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 14
              && dataSource_
                  != com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
                      .getDefaultInstance()) {
            dataSource_ =
                com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.newBuilder(
                        (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem)
                            dataSource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataSource_ = value;
          }
          onChanged();
        } else {
          if (dataSourceCase_ == 14) {
            posixDataSourceBuilder_.mergeFrom(value);
          } else {
            posixDataSourceBuilder_.setMessage(value);
          }
        }
        dataSourceCase_ = 14;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
       */
      public Builder clearPosixDataSource() {
        if (posixDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 14) {
            dataSourceCase_ = 0;
            dataSource_ = null;
            onChanged();
          }
        } else {
          if (dataSourceCase_ == 14) {
            dataSourceCase_ = 0;
            dataSource_ = null;
          }
          posixDataSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.Builder
          getPosixDataSourceBuilder() {
        return getPosixDataSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder
          getPosixDataSourceOrBuilder() {
        if ((dataSourceCase_ == 14) && (posixDataSourceBuilder_ != null)) {
          return posixDataSourceBuilder_.getMessageOrBuilder();
        } else {
          if (dataSourceCase_ == 14) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSource_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A POSIX Filesystem data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.PosixFilesystem posix_data_source = 14;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem,
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder>
          getPosixDataSourceFieldBuilder() {
        if (posixDataSourceBuilder_ == null) {
          if (!(dataSourceCase_ == 14)) {
            dataSource_ =
                com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem
                    .getDefaultInstance();
          }
          posixDataSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem,
                  com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystemOrBuilder>(
                  (com.google.storagetransfer.v1.proto.TransferTypes.PosixFilesystem) dataSource_,
                  getParentForChildren(),
                  isClean());
          dataSource_ = null;
        }
        dataSourceCase_ = 14;
        onChanged();
        ;
        return posixDataSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData,
              com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageDataOrBuilder>
          azureBlobStorageDataSourceBuilder_;
      /**
       *
       *
       * <pre>
       * An Azure Blob Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
       * </code>
       *
       * @return Whether the azureBlobStorageDataSource field is set.
       */
      @java.lang.Override
      public boolean hasAzureBlobStorageDataSource() {
        return dataSourceCase_ == 8;
      }
      /**
       *
       *
       * <pre>
       * An Azure Blob Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
       * </code>
       *
       * @return The azureBlobStorageDataSource.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
          getAzureBlobStorageDataSource() {
        if (azureBlobStorageDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 8) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData)
                dataSource_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
              .getDefaultInstance();
        } else {
          if (dataSourceCase_ == 8) {
            return azureBlobStorageDataSourceBuilder_.getMessage();
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * An Azure Blob Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
       * </code>
       */
      public Builder setAzureBlobStorageDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData value) {
        if (azureBlobStorageDataSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataSource_ = value;
          onChanged();
        } else {
          azureBlobStorageDataSourceBuilder_.setMessage(value);
        }
        dataSourceCase_ = 8;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An Azure Blob Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
       * </code>
       */
      public Builder setAzureBlobStorageDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData.Builder
              builderForValue) {
        if (azureBlobStorageDataSourceBuilder_ == null) {
          dataSource_ = builderForValue.build();
          onChanged();
        } else {
          azureBlobStorageDataSourceBuilder_.setMessage(builderForValue.build());
        }
        dataSourceCase_ = 8;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An Azure Blob Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
       * </code>
       */
      public Builder mergeAzureBlobStorageDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData value) {
        if (azureBlobStorageDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 8
              && dataSource_
                  != com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
                      .getDefaultInstance()) {
            dataSource_ =
                com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData.newBuilder(
                        (com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData)
                            dataSource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataSource_ = value;
          }
          onChanged();
        } else {
          if (dataSourceCase_ == 8) {
            azureBlobStorageDataSourceBuilder_.mergeFrom(value);
          } else {
            azureBlobStorageDataSourceBuilder_.setMessage(value);
          }
        }
        dataSourceCase_ = 8;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An Azure Blob Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
       * </code>
       */
      public Builder clearAzureBlobStorageDataSource() {
        if (azureBlobStorageDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 8) {
            dataSourceCase_ = 0;
            dataSource_ = null;
            onChanged();
          }
        } else {
          if (dataSourceCase_ == 8) {
            dataSourceCase_ = 0;
            dataSource_ = null;
          }
          azureBlobStorageDataSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An Azure Blob Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData.Builder
          getAzureBlobStorageDataSourceBuilder() {
        return getAzureBlobStorageDataSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * An Azure Blob Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
       * </code>
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageDataOrBuilder
          getAzureBlobStorageDataSourceOrBuilder() {
        if ((dataSourceCase_ == 8) && (azureBlobStorageDataSourceBuilder_ != null)) {
          return azureBlobStorageDataSourceBuilder_.getMessageOrBuilder();
        } else {
          if (dataSourceCase_ == 8) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData)
                dataSource_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * An Azure Blob Storage data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AzureBlobStorageData azure_blob_storage_data_source = 8;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData,
              com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageDataOrBuilder>
          getAzureBlobStorageDataSourceFieldBuilder() {
        if (azureBlobStorageDataSourceBuilder_ == null) {
          if (!(dataSourceCase_ == 8)) {
            dataSource_ =
                com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData
                    .getDefaultInstance();
          }
          azureBlobStorageDataSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData,
                  com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageDataOrBuilder>(
                  (com.google.storagetransfer.v1.proto.TransferTypes.AzureBlobStorageData)
                      dataSource_,
                  getParentForChildren(),
                  isClean());
          dataSource_ = null;
        }
        dataSourceCase_ = 8;
        onChanged();
        ;
        return azureBlobStorageDataSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleDataOrBuilder>
          awsS3CompatibleDataSourceBuilder_;
      /**
       *
       *
       * <pre>
       * An AWS S3 compatible data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
       * </code>
       *
       * @return Whether the awsS3CompatibleDataSource field is set.
       */
      @java.lang.Override
      public boolean hasAwsS3CompatibleDataSource() {
        return dataSourceCase_ == 19;
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 compatible data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
       * </code>
       *
       * @return The awsS3CompatibleDataSource.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
          getAwsS3CompatibleDataSource() {
        if (awsS3CompatibleDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 19) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData)
                dataSource_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
              .getDefaultInstance();
        } else {
          if (dataSourceCase_ == 19) {
            return awsS3CompatibleDataSourceBuilder_.getMessage();
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 compatible data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
       * </code>
       */
      public Builder setAwsS3CompatibleDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData value) {
        if (awsS3CompatibleDataSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataSource_ = value;
          onChanged();
        } else {
          awsS3CompatibleDataSourceBuilder_.setMessage(value);
        }
        dataSourceCase_ = 19;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 compatible data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
       * </code>
       */
      public Builder setAwsS3CompatibleDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData.Builder
              builderForValue) {
        if (awsS3CompatibleDataSourceBuilder_ == null) {
          dataSource_ = builderForValue.build();
          onChanged();
        } else {
          awsS3CompatibleDataSourceBuilder_.setMessage(builderForValue.build());
        }
        dataSourceCase_ = 19;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 compatible data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
       * </code>
       */
      public Builder mergeAwsS3CompatibleDataSource(
          com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData value) {
        if (awsS3CompatibleDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 19
              && dataSource_
                  != com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
                      .getDefaultInstance()) {
            dataSource_ =
                com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData.newBuilder(
                        (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData)
                            dataSource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            dataSource_ = value;
          }
          onChanged();
        } else {
          if (dataSourceCase_ == 19) {
            awsS3CompatibleDataSourceBuilder_.mergeFrom(value);
          } else {
            awsS3CompatibleDataSourceBuilder_.setMessage(value);
          }
        }
        dataSourceCase_ = 19;
        return this;
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 compatible data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
       * </code>
       */
      public Builder clearAwsS3CompatibleDataSource() {
        if (awsS3CompatibleDataSourceBuilder_ == null) {
          if (dataSourceCase_ == 19) {
            dataSourceCase_ = 0;
            dataSource_ = null;
            onChanged();
          }
        } else {
          if (dataSourceCase_ == 19) {
            dataSourceCase_ = 0;
            dataSource_ = null;
          }
          awsS3CompatibleDataSourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 compatible data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData.Builder
          getAwsS3CompatibleDataSourceBuilder() {
        return getAwsS3CompatibleDataSourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 compatible data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
       * </code>
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleDataOrBuilder
          getAwsS3CompatibleDataSourceOrBuilder() {
        if ((dataSourceCase_ == 19) && (awsS3CompatibleDataSourceBuilder_ != null)) {
          return awsS3CompatibleDataSourceBuilder_.getMessageOrBuilder();
        } else {
          if (dataSourceCase_ == 19) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData)
                dataSource_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * An AWS S3 compatible data source.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.AwsS3CompatibleData aws_s3_compatible_data_source = 19;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleDataOrBuilder>
          getAwsS3CompatibleDataSourceFieldBuilder() {
        if (awsS3CompatibleDataSourceBuilder_ == null) {
          if (!(dataSourceCase_ == 19)) {
            dataSource_ =
                com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData
                    .getDefaultInstance();
          }
          awsS3CompatibleDataSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData,
                  com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleDataOrBuilder>(
                  (com.google.storagetransfer.v1.proto.TransferTypes.AwsS3CompatibleData)
                      dataSource_,
                  getParentForChildren(),
                  isClean());
          dataSource_ = null;
        }
        dataSourceCase_ = 19;
        onChanged();
        ;
        return awsS3CompatibleDataSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder>
          gcsIntermediateDataLocationBuilder_;
      /**
       *
       *
       * <pre>
       * Cloud Storage intermediate data location.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
       *
       * @return Whether the gcsIntermediateDataLocation field is set.
       */
      @java.lang.Override
      public boolean hasGcsIntermediateDataLocation() {
        return intermediateDataLocationCase_ == 16;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage intermediate data location.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
       *
       * @return The gcsIntermediateDataLocation.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.GcsData
          getGcsIntermediateDataLocation() {
        if (gcsIntermediateDataLocationBuilder_ == null) {
          if (intermediateDataLocationCase_ == 16) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.GcsData)
                intermediateDataLocation_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
        } else {
          if (intermediateDataLocationCase_ == 16) {
            return gcsIntermediateDataLocationBuilder_.getMessage();
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage intermediate data location.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
       */
      public Builder setGcsIntermediateDataLocation(
          com.google.storagetransfer.v1.proto.TransferTypes.GcsData value) {
        if (gcsIntermediateDataLocationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          intermediateDataLocation_ = value;
          onChanged();
        } else {
          gcsIntermediateDataLocationBuilder_.setMessage(value);
        }
        intermediateDataLocationCase_ = 16;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage intermediate data location.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
       */
      public Builder setGcsIntermediateDataLocation(
          com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder builderForValue) {
        if (gcsIntermediateDataLocationBuilder_ == null) {
          intermediateDataLocation_ = builderForValue.build();
          onChanged();
        } else {
          gcsIntermediateDataLocationBuilder_.setMessage(builderForValue.build());
        }
        intermediateDataLocationCase_ = 16;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage intermediate data location.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
       */
      public Builder mergeGcsIntermediateDataLocation(
          com.google.storagetransfer.v1.proto.TransferTypes.GcsData value) {
        if (gcsIntermediateDataLocationBuilder_ == null) {
          if (intermediateDataLocationCase_ == 16
              && intermediateDataLocation_
                  != com.google.storagetransfer.v1.proto.TransferTypes.GcsData
                      .getDefaultInstance()) {
            intermediateDataLocation_ =
                com.google.storagetransfer.v1.proto.TransferTypes.GcsData.newBuilder(
                        (com.google.storagetransfer.v1.proto.TransferTypes.GcsData)
                            intermediateDataLocation_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            intermediateDataLocation_ = value;
          }
          onChanged();
        } else {
          if (intermediateDataLocationCase_ == 16) {
            gcsIntermediateDataLocationBuilder_.mergeFrom(value);
          } else {
            gcsIntermediateDataLocationBuilder_.setMessage(value);
          }
        }
        intermediateDataLocationCase_ = 16;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage intermediate data location.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
       */
      public Builder clearGcsIntermediateDataLocation() {
        if (gcsIntermediateDataLocationBuilder_ == null) {
          if (intermediateDataLocationCase_ == 16) {
            intermediateDataLocationCase_ = 0;
            intermediateDataLocation_ = null;
            onChanged();
          }
        } else {
          if (intermediateDataLocationCase_ == 16) {
            intermediateDataLocationCase_ = 0;
            intermediateDataLocation_ = null;
          }
          gcsIntermediateDataLocationBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage intermediate data location.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder
          getGcsIntermediateDataLocationBuilder() {
        return getGcsIntermediateDataLocationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage intermediate data location.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder
          getGcsIntermediateDataLocationOrBuilder() {
        if ((intermediateDataLocationCase_ == 16)
            && (gcsIntermediateDataLocationBuilder_ != null)) {
          return gcsIntermediateDataLocationBuilder_.getMessageOrBuilder();
        } else {
          if (intermediateDataLocationCase_ == 16) {
            return (com.google.storagetransfer.v1.proto.TransferTypes.GcsData)
                intermediateDataLocation_;
          }
          return com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Storage intermediate data location.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.GcsData gcs_intermediate_data_location = 16;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder>
          getGcsIntermediateDataLocationFieldBuilder() {
        if (gcsIntermediateDataLocationBuilder_ == null) {
          if (!(intermediateDataLocationCase_ == 16)) {
            intermediateDataLocation_ =
                com.google.storagetransfer.v1.proto.TransferTypes.GcsData.getDefaultInstance();
          }
          gcsIntermediateDataLocationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.GcsData,
                  com.google.storagetransfer.v1.proto.TransferTypes.GcsData.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.GcsDataOrBuilder>(
                  (com.google.storagetransfer.v1.proto.TransferTypes.GcsData)
                      intermediateDataLocation_,
                  getParentForChildren(),
                  isClean());
          intermediateDataLocation_ = null;
        }
        intermediateDataLocationCase_ = 16;
        onChanged();
        ;
        return gcsIntermediateDataLocationBuilder_;
      }

      private com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions objectConditions_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions,
              com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditionsOrBuilder>
          objectConditionsBuilder_;
      /**
       *
       *
       * <pre>
       * Only objects that satisfy these object conditions are included in the set
       * of data source and data sink objects.  Object conditions based on
       * objects' "last modification time" do not exclude objects in a data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
       *
       * @return Whether the objectConditions field is set.
       */
      public boolean hasObjectConditions() {
        return objectConditionsBuilder_ != null || objectConditions_ != null;
      }
      /**
       *
       *
       * <pre>
       * Only objects that satisfy these object conditions are included in the set
       * of data source and data sink objects.  Object conditions based on
       * objects' "last modification time" do not exclude objects in a data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
       *
       * @return The objectConditions.
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions
          getObjectConditions() {
        if (objectConditionsBuilder_ == null) {
          return objectConditions_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions
                  .getDefaultInstance()
              : objectConditions_;
        } else {
          return objectConditionsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Only objects that satisfy these object conditions are included in the set
       * of data source and data sink objects.  Object conditions based on
       * objects' "last modification time" do not exclude objects in a data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
       */
      public Builder setObjectConditions(
          com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions value) {
        if (objectConditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          objectConditions_ = value;
          onChanged();
        } else {
          objectConditionsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Only objects that satisfy these object conditions are included in the set
       * of data source and data sink objects.  Object conditions based on
       * objects' "last modification time" do not exclude objects in a data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
       */
      public Builder setObjectConditions(
          com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions.Builder
              builderForValue) {
        if (objectConditionsBuilder_ == null) {
          objectConditions_ = builderForValue.build();
          onChanged();
        } else {
          objectConditionsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Only objects that satisfy these object conditions are included in the set
       * of data source and data sink objects.  Object conditions based on
       * objects' "last modification time" do not exclude objects in a data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
       */
      public Builder mergeObjectConditions(
          com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions value) {
        if (objectConditionsBuilder_ == null) {
          if (objectConditions_ != null) {
            objectConditions_ =
                com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions.newBuilder(
                        objectConditions_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            objectConditions_ = value;
          }
          onChanged();
        } else {
          objectConditionsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Only objects that satisfy these object conditions are included in the set
       * of data source and data sink objects.  Object conditions based on
       * objects' "last modification time" do not exclude objects in a data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
       */
      public Builder clearObjectConditions() {
        if (objectConditionsBuilder_ == null) {
          objectConditions_ = null;
          onChanged();
        } else {
          objectConditions_ = null;
          objectConditionsBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Only objects that satisfy these object conditions are included in the set
       * of data source and data sink objects.  Object conditions based on
       * objects' "last modification time" do not exclude objects in a data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions.Builder
          getObjectConditionsBuilder() {

        onChanged();
        return getObjectConditionsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Only objects that satisfy these object conditions are included in the set
       * of data source and data sink objects.  Object conditions based on
       * objects' "last modification time" do not exclude objects in a data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditionsOrBuilder
          getObjectConditionsOrBuilder() {
        if (objectConditionsBuilder_ != null) {
          return objectConditionsBuilder_.getMessageOrBuilder();
        } else {
          return objectConditions_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions
                  .getDefaultInstance()
              : objectConditions_;
        }
      }
      /**
       *
       *
       * <pre>
       * Only objects that satisfy these object conditions are included in the set
       * of data source and data sink objects.  Object conditions based on
       * objects' "last modification time" do not exclude objects in a data sink.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.ObjectConditions object_conditions = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions,
              com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditionsOrBuilder>
          getObjectConditionsFieldBuilder() {
        if (objectConditionsBuilder_ == null) {
          objectConditionsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions,
                  com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditions.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.ObjectConditionsOrBuilder>(
                  getObjectConditions(), getParentForChildren(), isClean());
          objectConditions_ = null;
        }
        return objectConditionsBuilder_;
      }

      private com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions transferOptions_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferOptionsOrBuilder>
          transferOptionsBuilder_;
      /**
       *
       *
       * <pre>
       * If the option
       * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
       * is `true` and time-based object conditions such as 'last modification time'
       * are specified, the request fails with an
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
       *
       * @return Whether the transferOptions field is set.
       */
      public boolean hasTransferOptions() {
        return transferOptionsBuilder_ != null || transferOptions_ != null;
      }
      /**
       *
       *
       * <pre>
       * If the option
       * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
       * is `true` and time-based object conditions such as 'last modification time'
       * are specified, the request fails with an
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
       *
       * @return The transferOptions.
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions
          getTransferOptions() {
        if (transferOptionsBuilder_ == null) {
          return transferOptions_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions
                  .getDefaultInstance()
              : transferOptions_;
        } else {
          return transferOptionsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If the option
       * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
       * is `true` and time-based object conditions such as 'last modification time'
       * are specified, the request fails with an
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
       */
      public Builder setTransferOptions(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions value) {
        if (transferOptionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          transferOptions_ = value;
          onChanged();
        } else {
          transferOptionsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If the option
       * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
       * is `true` and time-based object conditions such as 'last modification time'
       * are specified, the request fails with an
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
       */
      public Builder setTransferOptions(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.Builder
              builderForValue) {
        if (transferOptionsBuilder_ == null) {
          transferOptions_ = builderForValue.build();
          onChanged();
        } else {
          transferOptionsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If the option
       * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
       * is `true` and time-based object conditions such as 'last modification time'
       * are specified, the request fails with an
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
       */
      public Builder mergeTransferOptions(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions value) {
        if (transferOptionsBuilder_ == null) {
          if (transferOptions_ != null) {
            transferOptions_ =
                com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.newBuilder(
                        transferOptions_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            transferOptions_ = value;
          }
          onChanged();
        } else {
          transferOptionsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If the option
       * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
       * is `true` and time-based object conditions such as 'last modification time'
       * are specified, the request fails with an
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
       */
      public Builder clearTransferOptions() {
        if (transferOptionsBuilder_ == null) {
          transferOptions_ = null;
          onChanged();
        } else {
          transferOptions_ = null;
          transferOptionsBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If the option
       * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
       * is `true` and time-based object conditions such as 'last modification time'
       * are specified, the request fails with an
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.Builder
          getTransferOptionsBuilder() {

        onChanged();
        return getTransferOptionsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If the option
       * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
       * is `true` and time-based object conditions such as 'last modification time'
       * are specified, the request fails with an
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferOptionsOrBuilder
          getTransferOptionsOrBuilder() {
        if (transferOptionsBuilder_ != null) {
          return transferOptionsBuilder_.getMessageOrBuilder();
        } else {
          return transferOptions_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions
                  .getDefaultInstance()
              : transferOptions_;
        }
      }
      /**
       *
       *
       * <pre>
       * If the option
       * [delete_objects_unique_in_sink][google.storagetransfer.v1.TransferOptions.delete_objects_unique_in_sink]
       * is `true` and time-based object conditions such as 'last modification time'
       * are specified, the request fails with an
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferOptions transfer_options = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferOptionsOrBuilder>
          getTransferOptionsFieldBuilder() {
        if (transferOptionsBuilder_ == null) {
          transferOptionsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions,
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferOptions.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferOptionsOrBuilder>(
                  getTransferOptions(), getParentForChildren(), isClean());
          transferOptions_ = null;
        }
        return transferOptionsBuilder_;
      }

      private com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest transferManifest_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferManifestOrBuilder>
          transferManifestBuilder_;
      /**
       *
       *
       * <pre>
       * A manifest file provides a list of objects to be transferred from the data
       * source. This field points to the location of the manifest file.
       * Otherwise, the entire source bucket is used. ObjectConditions still apply.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
       *
       * @return Whether the transferManifest field is set.
       */
      public boolean hasTransferManifest() {
        return transferManifestBuilder_ != null || transferManifest_ != null;
      }
      /**
       *
       *
       * <pre>
       * A manifest file provides a list of objects to be transferred from the data
       * source. This field points to the location of the manifest file.
       * Otherwise, the entire source bucket is used. ObjectConditions still apply.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
       *
       * @return The transferManifest.
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest
          getTransferManifest() {
        if (transferManifestBuilder_ == null) {
          return transferManifest_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest
                  .getDefaultInstance()
              : transferManifest_;
        } else {
          return transferManifestBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A manifest file provides a list of objects to be transferred from the data
       * source. This field points to the location of the manifest file.
       * Otherwise, the entire source bucket is used. ObjectConditions still apply.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
       */
      public Builder setTransferManifest(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest value) {
        if (transferManifestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          transferManifest_ = value;
          onChanged();
        } else {
          transferManifestBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A manifest file provides a list of objects to be transferred from the data
       * source. This field points to the location of the manifest file.
       * Otherwise, the entire source bucket is used. ObjectConditions still apply.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
       */
      public Builder setTransferManifest(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest.Builder
              builderForValue) {
        if (transferManifestBuilder_ == null) {
          transferManifest_ = builderForValue.build();
          onChanged();
        } else {
          transferManifestBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A manifest file provides a list of objects to be transferred from the data
       * source. This field points to the location of the manifest file.
       * Otherwise, the entire source bucket is used. ObjectConditions still apply.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
       */
      public Builder mergeTransferManifest(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest value) {
        if (transferManifestBuilder_ == null) {
          if (transferManifest_ != null) {
            transferManifest_ =
                com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest.newBuilder(
                        transferManifest_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            transferManifest_ = value;
          }
          onChanged();
        } else {
          transferManifestBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A manifest file provides a list of objects to be transferred from the data
       * source. This field points to the location of the manifest file.
       * Otherwise, the entire source bucket is used. ObjectConditions still apply.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
       */
      public Builder clearTransferManifest() {
        if (transferManifestBuilder_ == null) {
          transferManifest_ = null;
          onChanged();
        } else {
          transferManifest_ = null;
          transferManifestBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A manifest file provides a list of objects to be transferred from the data
       * source. This field points to the location of the manifest file.
       * Otherwise, the entire source bucket is used. ObjectConditions still apply.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest.Builder
          getTransferManifestBuilder() {

        onChanged();
        return getTransferManifestFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A manifest file provides a list of objects to be transferred from the data
       * source. This field points to the location of the manifest file.
       * Otherwise, the entire source bucket is used. ObjectConditions still apply.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferManifestOrBuilder
          getTransferManifestOrBuilder() {
        if (transferManifestBuilder_ != null) {
          return transferManifestBuilder_.getMessageOrBuilder();
        } else {
          return transferManifest_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest
                  .getDefaultInstance()
              : transferManifest_;
        }
      }
      /**
       *
       *
       * <pre>
       * A manifest file provides a list of objects to be transferred from the data
       * source. This field points to the location of the manifest file.
       * Otherwise, the entire source bucket is used. ObjectConditions still apply.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.TransferManifest transfer_manifest = 15;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferManifestOrBuilder>
          getTransferManifestFieldBuilder() {
        if (transferManifestBuilder_ == null) {
          transferManifestBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest,
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferManifestOrBuilder>(
                  getTransferManifest(), getParentForChildren(), isClean());
          transferManifest_ = null;
        }
        return transferManifestBuilder_;
      }

      private java.lang.Object sourceAgentPoolName_ = "";
      /**
       *
       *
       * <pre>
       * Specifies the agent pool name associated with the posix data source. When
       * unspecified, the default name is used.
       * </pre>
       *
       * <code>string source_agent_pool_name = 17;</code>
       *
       * @return The sourceAgentPoolName.
       */
      public java.lang.String getSourceAgentPoolName() {
        java.lang.Object ref = sourceAgentPoolName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceAgentPoolName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the agent pool name associated with the posix data source. When
       * unspecified, the default name is used.
       * </pre>
       *
       * <code>string source_agent_pool_name = 17;</code>
       *
       * @return The bytes for sourceAgentPoolName.
       */
      public com.google.protobuf.ByteString getSourceAgentPoolNameBytes() {
        java.lang.Object ref = sourceAgentPoolName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourceAgentPoolName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the agent pool name associated with the posix data source. When
       * unspecified, the default name is used.
       * </pre>
       *
       * <code>string source_agent_pool_name = 17;</code>
       *
       * @param value The sourceAgentPoolName to set.
       * @return This builder for chaining.
       */
      public Builder setSourceAgentPoolName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        sourceAgentPoolName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the agent pool name associated with the posix data source. When
       * unspecified, the default name is used.
       * </pre>
       *
       * <code>string source_agent_pool_name = 17;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSourceAgentPoolName() {

        sourceAgentPoolName_ = getDefaultInstance().getSourceAgentPoolName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the agent pool name associated with the posix data source. When
       * unspecified, the default name is used.
       * </pre>
       *
       * <code>string source_agent_pool_name = 17;</code>
       *
       * @param value The bytes for sourceAgentPoolName to set.
       * @return This builder for chaining.
       */
      public Builder setSourceAgentPoolNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        sourceAgentPoolName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object sinkAgentPoolName_ = "";
      /**
       *
       *
       * <pre>
       * Specifies the agent pool name associated with the posix data sink. When
       * unspecified, the default name is used.
       * </pre>
       *
       * <code>string sink_agent_pool_name = 18;</code>
       *
       * @return The sinkAgentPoolName.
       */
      public java.lang.String getSinkAgentPoolName() {
        java.lang.Object ref = sinkAgentPoolName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sinkAgentPoolName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the agent pool name associated with the posix data sink. When
       * unspecified, the default name is used.
       * </pre>
       *
       * <code>string sink_agent_pool_name = 18;</code>
       *
       * @return The bytes for sinkAgentPoolName.
       */
      public com.google.protobuf.ByteString getSinkAgentPoolNameBytes() {
        java.lang.Object ref = sinkAgentPoolName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sinkAgentPoolName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the agent pool name associated with the posix data sink. When
       * unspecified, the default name is used.
       * </pre>
       *
       * <code>string sink_agent_pool_name = 18;</code>
       *
       * @param value The sinkAgentPoolName to set.
       * @return This builder for chaining.
       */
      public Builder setSinkAgentPoolName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        sinkAgentPoolName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the agent pool name associated with the posix data sink. When
       * unspecified, the default name is used.
       * </pre>
       *
       * <code>string sink_agent_pool_name = 18;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSinkAgentPoolName() {

        sinkAgentPoolName_ = getDefaultInstance().getSinkAgentPoolName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the agent pool name associated with the posix data sink. When
       * unspecified, the default name is used.
       * </pre>
       *
       * <code>string sink_agent_pool_name = 18;</code>
       *
       * @param value The bytes for sinkAgentPoolName to set.
       * @return This builder for chaining.
       */
      public Builder setSinkAgentPoolNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        sinkAgentPoolName_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.TransferSpec)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.TransferSpec)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TransferSpec> PARSER =
        new com.google.protobuf.AbstractParser<TransferSpec>() {
          @java.lang.Override
          public TransferSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TransferSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TransferSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MetadataOptionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.MetadataOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specifies how symlinks should be handled by the transfer. By default,
     * symlinks are not preserved. Only applicable to transfers involving
     * POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.Symlink symlink = 1;</code>
     *
     * @return The enum numeric value on the wire for symlink.
     */
    int getSymlinkValue();
    /**
     *
     *
     * <pre>
     * Specifies how symlinks should be handled by the transfer. By default,
     * symlinks are not preserved. Only applicable to transfers involving
     * POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.Symlink symlink = 1;</code>
     *
     * @return The symlink.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Symlink getSymlink();

    /**
     *
     *
     * <pre>
     * Specifies how each file's mode attribute should be handled by the transfer.
     * By default, mode is not preserved. Only applicable to transfers involving
     * POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.Mode mode = 2;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    int getModeValue();
    /**
     *
     *
     * <pre>
     * Specifies how each file's mode attribute should be handled by the transfer.
     * By default, mode is not preserved. Only applicable to transfers involving
     * POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.Mode mode = 2;</code>
     *
     * @return The mode.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Mode getMode();

    /**
     *
     *
     * <pre>
     * Specifies how each file's POSIX group ID (GID) attribute should be handled
     * by the transfer. By default, GID is not preserved. Only applicable to
     * transfers involving POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.GID gid = 3;</code>
     *
     * @return The enum numeric value on the wire for gid.
     */
    int getGidValue();
    /**
     *
     *
     * <pre>
     * Specifies how each file's POSIX group ID (GID) attribute should be handled
     * by the transfer. By default, GID is not preserved. Only applicable to
     * transfers involving POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.GID gid = 3;</code>
     *
     * @return The gid.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.GID getGid();

    /**
     *
     *
     * <pre>
     * Specifies how each file's POSIX user ID (UID) attribute should be handled
     * by the transfer. By default, UID is not preserved. Only applicable to
     * transfers involving POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.UID uid = 4;</code>
     *
     * @return The enum numeric value on the wire for uid.
     */
    int getUidValue();
    /**
     *
     *
     * <pre>
     * Specifies how each file's POSIX user ID (UID) attribute should be handled
     * by the transfer. By default, UID is not preserved. Only applicable to
     * transfers involving POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.UID uid = 4;</code>
     *
     * @return The uid.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.UID getUid();

    /**
     *
     *
     * <pre>
     * Specifies how each object's ACLs should be preserved for transfers between
     * Google Cloud Storage buckets. If unspecified, the default behavior is the
     * same as ACL_DESTINATION_BUCKET_DEFAULT.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.Acl acl = 5;</code>
     *
     * @return The enum numeric value on the wire for acl.
     */
    int getAclValue();
    /**
     *
     *
     * <pre>
     * Specifies how each object's ACLs should be preserved for transfers between
     * Google Cloud Storage buckets. If unspecified, the default behavior is the
     * same as ACL_DESTINATION_BUCKET_DEFAULT.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.Acl acl = 5;</code>
     *
     * @return The acl.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Acl getAcl();

    /**
     *
     *
     * <pre>
     * Specifies the storage class to set on objects being transferred to Google
     * Cloud Storage buckets.  If unspecified, the default behavior is the same as
     * [STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.StorageClass.STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.StorageClass storage_class = 6;</code>
     *
     * @return The enum numeric value on the wire for storageClass.
     */
    int getStorageClassValue();
    /**
     *
     *
     * <pre>
     * Specifies the storage class to set on objects being transferred to Google
     * Cloud Storage buckets.  If unspecified, the default behavior is the same as
     * [STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.StorageClass.STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.StorageClass storage_class = 6;</code>
     *
     * @return The storageClass.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.StorageClass
        getStorageClass();

    /**
     *
     *
     * <pre>
     * Specifies how each object's temporary hold status should be preserved for
     * transfers between Google Cloud Storage buckets.  If unspecified, the
     * default behavior is the same as
     * [TEMPORARY_HOLD_PRESERVE][google.storagetransfer.v1.MetadataOptions.TemporaryHold.TEMPORARY_HOLD_PRESERVE].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.TemporaryHold temporary_hold = 7;</code>
     *
     * @return The enum numeric value on the wire for temporaryHold.
     */
    int getTemporaryHoldValue();
    /**
     *
     *
     * <pre>
     * Specifies how each object's temporary hold status should be preserved for
     * transfers between Google Cloud Storage buckets.  If unspecified, the
     * default behavior is the same as
     * [TEMPORARY_HOLD_PRESERVE][google.storagetransfer.v1.MetadataOptions.TemporaryHold.TEMPORARY_HOLD_PRESERVE].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.TemporaryHold temporary_hold = 7;</code>
     *
     * @return The temporaryHold.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TemporaryHold
        getTemporaryHold();

    /**
     *
     *
     * <pre>
     * Specifies how each object's Cloud KMS customer-managed encryption key
     * (CMEK) is preserved for transfers between Google Cloud Storage buckets.  If
     * unspecified, the default behavior is the same as
     * [KMS_KEY_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.KmsKey.KMS_KEY_DESTINATION_BUCKET_DEFAULT].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.KmsKey kms_key = 8;</code>
     *
     * @return The enum numeric value on the wire for kmsKey.
     */
    int getKmsKeyValue();
    /**
     *
     *
     * <pre>
     * Specifies how each object's Cloud KMS customer-managed encryption key
     * (CMEK) is preserved for transfers between Google Cloud Storage buckets.  If
     * unspecified, the default behavior is the same as
     * [KMS_KEY_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.KmsKey.KMS_KEY_DESTINATION_BUCKET_DEFAULT].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.KmsKey kms_key = 8;</code>
     *
     * @return The kmsKey.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.KmsKey getKmsKey();

    /**
     *
     *
     * <pre>
     * Specifies how each object's `timeCreated` metadata is preserved for
     * transfers between Google Cloud Storage buckets.  If unspecified, the
     * default behavior is the same as
     * [TIME_CREATED_SKIP][google.storagetransfer.v1.MetadataOptions.TimeCreated.TIME_CREATED_SKIP].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.TimeCreated time_created = 9;</code>
     *
     * @return The enum numeric value on the wire for timeCreated.
     */
    int getTimeCreatedValue();
    /**
     *
     *
     * <pre>
     * Specifies how each object's `timeCreated` metadata is preserved for
     * transfers between Google Cloud Storage buckets.  If unspecified, the
     * default behavior is the same as
     * [TIME_CREATED_SKIP][google.storagetransfer.v1.MetadataOptions.TimeCreated.TIME_CREATED_SKIP].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.TimeCreated time_created = 9;</code>
     *
     * @return The timeCreated.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TimeCreated getTimeCreated();
  }
  /**
   *
   *
   * <pre>
   * Specifies the metadata options for running a transfer.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.MetadataOptions}
   */
  public static final class MetadataOptions extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.MetadataOptions)
      MetadataOptionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MetadataOptions.newBuilder() to construct.
    private MetadataOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MetadataOptions() {
      symlink_ = 0;
      mode_ = 0;
      gid_ = 0;
      uid_ = 0;
      acl_ = 0;
      storageClass_ = 0;
      temporaryHold_ = 0;
      kmsKey_ = 0;
      timeCreated_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MetadataOptions();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_MetadataOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_MetadataOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.class,
              com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Whether symlinks should be skipped or preserved during a transfer job.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.MetadataOptions.Symlink}
     */
    public enum Symlink implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Symlink behavior is unspecified.
       * </pre>
       *
       * <code>SYMLINK_UNSPECIFIED = 0;</code>
       */
      SYMLINK_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Do not preserve symlinks during a transfer job.
       * </pre>
       *
       * <code>SYMLINK_SKIP = 1;</code>
       */
      SYMLINK_SKIP(1),
      /**
       *
       *
       * <pre>
       * Preserve symlinks during a transfer job.
       * </pre>
       *
       * <code>SYMLINK_PRESERVE = 2;</code>
       */
      SYMLINK_PRESERVE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Symlink behavior is unspecified.
       * </pre>
       *
       * <code>SYMLINK_UNSPECIFIED = 0;</code>
       */
      public static final int SYMLINK_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Do not preserve symlinks during a transfer job.
       * </pre>
       *
       * <code>SYMLINK_SKIP = 1;</code>
       */
      public static final int SYMLINK_SKIP_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Preserve symlinks during a transfer job.
       * </pre>
       *
       * <code>SYMLINK_PRESERVE = 2;</code>
       */
      public static final int SYMLINK_PRESERVE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Symlink valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Symlink forNumber(int value) {
        switch (value) {
          case 0:
            return SYMLINK_UNSPECIFIED;
          case 1:
            return SYMLINK_SKIP;
          case 2:
            return SYMLINK_PRESERVE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Symlink> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Symlink> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Symlink>() {
            public Symlink findValueByNumber(int number) {
              return Symlink.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Symlink[] VALUES = values();

      public static Symlink valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Symlink(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.MetadataOptions.Symlink)
    }

    /**
     *
     *
     * <pre>
     * Options for handling file mode attribute.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.MetadataOptions.Mode}
     */
    public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Mode behavior is unspecified.
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      MODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Do not preserve mode during a transfer job.
       * </pre>
       *
       * <code>MODE_SKIP = 1;</code>
       */
      MODE_SKIP(1),
      /**
       *
       *
       * <pre>
       * Preserve mode during a transfer job.
       * </pre>
       *
       * <code>MODE_PRESERVE = 2;</code>
       */
      MODE_PRESERVE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Mode behavior is unspecified.
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      public static final int MODE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Do not preserve mode during a transfer job.
       * </pre>
       *
       * <code>MODE_SKIP = 1;</code>
       */
      public static final int MODE_SKIP_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Preserve mode during a transfer job.
       * </pre>
       *
       * <code>MODE_PRESERVE = 2;</code>
       */
      public static final int MODE_PRESERVE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Mode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Mode forNumber(int value) {
        switch (value) {
          case 0:
            return MODE_UNSPECIFIED;
          case 1:
            return MODE_SKIP;
          case 2:
            return MODE_PRESERVE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
            public Mode findValueByNumber(int number) {
              return Mode.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final Mode[] VALUES = values();

      public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Mode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.MetadataOptions.Mode)
    }

    /**
     *
     *
     * <pre>
     * Options for handling file GID attribute.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.MetadataOptions.GID}
     */
    public enum GID implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * GID behavior is unspecified.
       * </pre>
       *
       * <code>GID_UNSPECIFIED = 0;</code>
       */
      GID_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Do not preserve GID during a transfer job.
       * </pre>
       *
       * <code>GID_SKIP = 1;</code>
       */
      GID_SKIP(1),
      /**
       *
       *
       * <pre>
       * Preserve GID during a transfer job.
       * </pre>
       *
       * <code>GID_NUMBER = 2;</code>
       */
      GID_NUMBER(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * GID behavior is unspecified.
       * </pre>
       *
       * <code>GID_UNSPECIFIED = 0;</code>
       */
      public static final int GID_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Do not preserve GID during a transfer job.
       * </pre>
       *
       * <code>GID_SKIP = 1;</code>
       */
      public static final int GID_SKIP_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Preserve GID during a transfer job.
       * </pre>
       *
       * <code>GID_NUMBER = 2;</code>
       */
      public static final int GID_NUMBER_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static GID valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static GID forNumber(int value) {
        switch (value) {
          case 0:
            return GID_UNSPECIFIED;
          case 1:
            return GID_SKIP;
          case 2:
            return GID_NUMBER;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<GID> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<GID> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<GID>() {
            public GID findValueByNumber(int number) {
              return GID.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.getDescriptor()
            .getEnumTypes()
            .get(2);
      }

      private static final GID[] VALUES = values();

      public static GID valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private GID(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.MetadataOptions.GID)
    }

    /**
     *
     *
     * <pre>
     * Options for handling file UID attribute.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.MetadataOptions.UID}
     */
    public enum UID implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * UID behavior is unspecified.
       * </pre>
       *
       * <code>UID_UNSPECIFIED = 0;</code>
       */
      UID_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Do not preserve UID during a transfer job.
       * </pre>
       *
       * <code>UID_SKIP = 1;</code>
       */
      UID_SKIP(1),
      /**
       *
       *
       * <pre>
       * Preserve UID during a transfer job.
       * </pre>
       *
       * <code>UID_NUMBER = 2;</code>
       */
      UID_NUMBER(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * UID behavior is unspecified.
       * </pre>
       *
       * <code>UID_UNSPECIFIED = 0;</code>
       */
      public static final int UID_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Do not preserve UID during a transfer job.
       * </pre>
       *
       * <code>UID_SKIP = 1;</code>
       */
      public static final int UID_SKIP_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Preserve UID during a transfer job.
       * </pre>
       *
       * <code>UID_NUMBER = 2;</code>
       */
      public static final int UID_NUMBER_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static UID valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static UID forNumber(int value) {
        switch (value) {
          case 0:
            return UID_UNSPECIFIED;
          case 1:
            return UID_SKIP;
          case 2:
            return UID_NUMBER;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<UID> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<UID> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<UID>() {
            public UID findValueByNumber(int number) {
              return UID.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.getDescriptor()
            .getEnumTypes()
            .get(3);
      }

      private static final UID[] VALUES = values();

      public static UID valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private UID(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.MetadataOptions.UID)
    }

    /**
     *
     *
     * <pre>
     * Options for handling Cloud Storage object ACLs.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.MetadataOptions.Acl}
     */
    public enum Acl implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * ACL behavior is unspecified.
       * </pre>
       *
       * <code>ACL_UNSPECIFIED = 0;</code>
       */
      ACL_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Use the destination bucket's default object ACLS, if applicable.
       * </pre>
       *
       * <code>ACL_DESTINATION_BUCKET_DEFAULT = 1;</code>
       */
      ACL_DESTINATION_BUCKET_DEFAULT(1),
      /**
       *
       *
       * <pre>
       * Preserve the object's original ACLs. This requires the service account
       * to have `storage.objects.getIamPolicy` permission for the source object.
       * [Uniform bucket-level
       * access](https://cloud.google.com/storage/docs/uniform-bucket-level-access)
       * must not be enabled on either the source or destination buckets.
       * </pre>
       *
       * <code>ACL_PRESERVE = 2;</code>
       */
      ACL_PRESERVE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * ACL behavior is unspecified.
       * </pre>
       *
       * <code>ACL_UNSPECIFIED = 0;</code>
       */
      public static final int ACL_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Use the destination bucket's default object ACLS, if applicable.
       * </pre>
       *
       * <code>ACL_DESTINATION_BUCKET_DEFAULT = 1;</code>
       */
      public static final int ACL_DESTINATION_BUCKET_DEFAULT_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Preserve the object's original ACLs. This requires the service account
       * to have `storage.objects.getIamPolicy` permission for the source object.
       * [Uniform bucket-level
       * access](https://cloud.google.com/storage/docs/uniform-bucket-level-access)
       * must not be enabled on either the source or destination buckets.
       * </pre>
       *
       * <code>ACL_PRESERVE = 2;</code>
       */
      public static final int ACL_PRESERVE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Acl valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Acl forNumber(int value) {
        switch (value) {
          case 0:
            return ACL_UNSPECIFIED;
          case 1:
            return ACL_DESTINATION_BUCKET_DEFAULT;
          case 2:
            return ACL_PRESERVE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Acl> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Acl> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Acl>() {
            public Acl findValueByNumber(int number) {
              return Acl.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.getDescriptor()
            .getEnumTypes()
            .get(4);
      }

      private static final Acl[] VALUES = values();

      public static Acl valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Acl(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.MetadataOptions.Acl)
    }

    /**
     *
     *
     * <pre>
     * Options for handling Google Cloud Storage object storage class.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.MetadataOptions.StorageClass}
     */
    public enum StorageClass implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Storage class behavior is unspecified.
       * </pre>
       *
       * <code>STORAGE_CLASS_UNSPECIFIED = 0;</code>
       */
      STORAGE_CLASS_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Use the destination bucket's default storage class.
       * </pre>
       *
       * <code>STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT = 1;</code>
       */
      STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT(1),
      /**
       *
       *
       * <pre>
       * Preserve the object's original storage class. This is only supported for
       * transfers from Google Cloud Storage buckets.
       * </pre>
       *
       * <code>STORAGE_CLASS_PRESERVE = 2;</code>
       */
      STORAGE_CLASS_PRESERVE(2),
      /**
       *
       *
       * <pre>
       * Set the storage class to STANDARD.
       * </pre>
       *
       * <code>STORAGE_CLASS_STANDARD = 3;</code>
       */
      STORAGE_CLASS_STANDARD(3),
      /**
       *
       *
       * <pre>
       * Set the storage class to NEARLINE.
       * </pre>
       *
       * <code>STORAGE_CLASS_NEARLINE = 4;</code>
       */
      STORAGE_CLASS_NEARLINE(4),
      /**
       *
       *
       * <pre>
       * Set the storage class to COLDLINE.
       * </pre>
       *
       * <code>STORAGE_CLASS_COLDLINE = 5;</code>
       */
      STORAGE_CLASS_COLDLINE(5),
      /**
       *
       *
       * <pre>
       * Set the storage class to ARCHIVE.
       * </pre>
       *
       * <code>STORAGE_CLASS_ARCHIVE = 6;</code>
       */
      STORAGE_CLASS_ARCHIVE(6),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Storage class behavior is unspecified.
       * </pre>
       *
       * <code>STORAGE_CLASS_UNSPECIFIED = 0;</code>
       */
      public static final int STORAGE_CLASS_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Use the destination bucket's default storage class.
       * </pre>
       *
       * <code>STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT = 1;</code>
       */
      public static final int STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Preserve the object's original storage class. This is only supported for
       * transfers from Google Cloud Storage buckets.
       * </pre>
       *
       * <code>STORAGE_CLASS_PRESERVE = 2;</code>
       */
      public static final int STORAGE_CLASS_PRESERVE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Set the storage class to STANDARD.
       * </pre>
       *
       * <code>STORAGE_CLASS_STANDARD = 3;</code>
       */
      public static final int STORAGE_CLASS_STANDARD_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Set the storage class to NEARLINE.
       * </pre>
       *
       * <code>STORAGE_CLASS_NEARLINE = 4;</code>
       */
      public static final int STORAGE_CLASS_NEARLINE_VALUE = 4;
      /**
       *
       *
       * <pre>
       * Set the storage class to COLDLINE.
       * </pre>
       *
       * <code>STORAGE_CLASS_COLDLINE = 5;</code>
       */
      public static final int STORAGE_CLASS_COLDLINE_VALUE = 5;
      /**
       *
       *
       * <pre>
       * Set the storage class to ARCHIVE.
       * </pre>
       *
       * <code>STORAGE_CLASS_ARCHIVE = 6;</code>
       */
      public static final int STORAGE_CLASS_ARCHIVE_VALUE = 6;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static StorageClass valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static StorageClass forNumber(int value) {
        switch (value) {
          case 0:
            return STORAGE_CLASS_UNSPECIFIED;
          case 1:
            return STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT;
          case 2:
            return STORAGE_CLASS_PRESERVE;
          case 3:
            return STORAGE_CLASS_STANDARD;
          case 4:
            return STORAGE_CLASS_NEARLINE;
          case 5:
            return STORAGE_CLASS_COLDLINE;
          case 6:
            return STORAGE_CLASS_ARCHIVE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<StorageClass> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<StorageClass> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<StorageClass>() {
            public StorageClass findValueByNumber(int number) {
              return StorageClass.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.getDescriptor()
            .getEnumTypes()
            .get(5);
      }

      private static final StorageClass[] VALUES = values();

      public static StorageClass valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private StorageClass(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.MetadataOptions.StorageClass)
    }

    /**
     *
     *
     * <pre>
     * Options for handling temporary holds for Google Cloud Storage objects.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.MetadataOptions.TemporaryHold}
     */
    public enum TemporaryHold implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Temporary hold behavior is unspecified.
       * </pre>
       *
       * <code>TEMPORARY_HOLD_UNSPECIFIED = 0;</code>
       */
      TEMPORARY_HOLD_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Do not set a temporary hold on the destination object.
       * </pre>
       *
       * <code>TEMPORARY_HOLD_SKIP = 1;</code>
       */
      TEMPORARY_HOLD_SKIP(1),
      /**
       *
       *
       * <pre>
       * Preserve the object's original temporary hold status.
       * </pre>
       *
       * <code>TEMPORARY_HOLD_PRESERVE = 2;</code>
       */
      TEMPORARY_HOLD_PRESERVE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Temporary hold behavior is unspecified.
       * </pre>
       *
       * <code>TEMPORARY_HOLD_UNSPECIFIED = 0;</code>
       */
      public static final int TEMPORARY_HOLD_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Do not set a temporary hold on the destination object.
       * </pre>
       *
       * <code>TEMPORARY_HOLD_SKIP = 1;</code>
       */
      public static final int TEMPORARY_HOLD_SKIP_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Preserve the object's original temporary hold status.
       * </pre>
       *
       * <code>TEMPORARY_HOLD_PRESERVE = 2;</code>
       */
      public static final int TEMPORARY_HOLD_PRESERVE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TemporaryHold valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static TemporaryHold forNumber(int value) {
        switch (value) {
          case 0:
            return TEMPORARY_HOLD_UNSPECIFIED;
          case 1:
            return TEMPORARY_HOLD_SKIP;
          case 2:
            return TEMPORARY_HOLD_PRESERVE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<TemporaryHold> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<TemporaryHold>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<TemporaryHold>() {
                public TemporaryHold findValueByNumber(int number) {
                  return TemporaryHold.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.getDescriptor()
            .getEnumTypes()
            .get(6);
      }

      private static final TemporaryHold[] VALUES = values();

      public static TemporaryHold valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private TemporaryHold(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.MetadataOptions.TemporaryHold)
    }

    /**
     *
     *
     * <pre>
     * Options for handling the KmsKey setting for Google Cloud Storage objects.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.MetadataOptions.KmsKey}
     */
    public enum KmsKey implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * KmsKey behavior is unspecified.
       * </pre>
       *
       * <code>KMS_KEY_UNSPECIFIED = 0;</code>
       */
      KMS_KEY_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Use the destination bucket's default encryption settings.
       * </pre>
       *
       * <code>KMS_KEY_DESTINATION_BUCKET_DEFAULT = 1;</code>
       */
      KMS_KEY_DESTINATION_BUCKET_DEFAULT(1),
      /**
       *
       *
       * <pre>
       * Preserve the object's original Cloud KMS customer-managed encryption key
       * (CMEK) if present. Objects that do not use a Cloud KMS encryption key
       * will be encrypted using the destination bucket's encryption settings.
       * </pre>
       *
       * <code>KMS_KEY_PRESERVE = 2;</code>
       */
      KMS_KEY_PRESERVE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * KmsKey behavior is unspecified.
       * </pre>
       *
       * <code>KMS_KEY_UNSPECIFIED = 0;</code>
       */
      public static final int KMS_KEY_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Use the destination bucket's default encryption settings.
       * </pre>
       *
       * <code>KMS_KEY_DESTINATION_BUCKET_DEFAULT = 1;</code>
       */
      public static final int KMS_KEY_DESTINATION_BUCKET_DEFAULT_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Preserve the object's original Cloud KMS customer-managed encryption key
       * (CMEK) if present. Objects that do not use a Cloud KMS encryption key
       * will be encrypted using the destination bucket's encryption settings.
       * </pre>
       *
       * <code>KMS_KEY_PRESERVE = 2;</code>
       */
      public static final int KMS_KEY_PRESERVE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static KmsKey valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static KmsKey forNumber(int value) {
        switch (value) {
          case 0:
            return KMS_KEY_UNSPECIFIED;
          case 1:
            return KMS_KEY_DESTINATION_BUCKET_DEFAULT;
          case 2:
            return KMS_KEY_PRESERVE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<KmsKey> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<KmsKey> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<KmsKey>() {
            public KmsKey findValueByNumber(int number) {
              return KmsKey.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.getDescriptor()
            .getEnumTypes()
            .get(7);
      }

      private static final KmsKey[] VALUES = values();

      public static KmsKey valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private KmsKey(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.MetadataOptions.KmsKey)
    }

    /**
     *
     *
     * <pre>
     * Options for handling `timeCreated` metadata for Google Cloud Storage
     * objects.
     * </pre>
     *
     * Protobuf enum {@code google.storagetransfer.v1.MetadataOptions.TimeCreated}
     */
    public enum TimeCreated implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * TimeCreated behavior is unspecified.
       * </pre>
       *
       * <code>TIME_CREATED_UNSPECIFIED = 0;</code>
       */
      TIME_CREATED_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Do not preserve the `timeCreated` metadata from the source object.
       * </pre>
       *
       * <code>TIME_CREATED_SKIP = 1;</code>
       */
      TIME_CREATED_SKIP(1),
      /**
       *
       *
       * <pre>
       * Preserves the source object's `timeCreated` metadata in the `customTime`
       * field in the destination object.  Note that any value stored in the
       * source object's `customTime` field will not be propagated to the
       * destination object.
       * </pre>
       *
       * <code>TIME_CREATED_PRESERVE_AS_CUSTOM_TIME = 2;</code>
       */
      TIME_CREATED_PRESERVE_AS_CUSTOM_TIME(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * TimeCreated behavior is unspecified.
       * </pre>
       *
       * <code>TIME_CREATED_UNSPECIFIED = 0;</code>
       */
      public static final int TIME_CREATED_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Do not preserve the `timeCreated` metadata from the source object.
       * </pre>
       *
       * <code>TIME_CREATED_SKIP = 1;</code>
       */
      public static final int TIME_CREATED_SKIP_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Preserves the source object's `timeCreated` metadata in the `customTime`
       * field in the destination object.  Note that any value stored in the
       * source object's `customTime` field will not be propagated to the
       * destination object.
       * </pre>
       *
       * <code>TIME_CREATED_PRESERVE_AS_CUSTOM_TIME = 2;</code>
       */
      public static final int TIME_CREATED_PRESERVE_AS_CUSTOM_TIME_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TimeCreated valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static TimeCreated forNumber(int value) {
        switch (value) {
          case 0:
            return TIME_CREATED_UNSPECIFIED;
          case 1:
            return TIME_CREATED_SKIP;
          case 2:
            return TIME_CREATED_PRESERVE_AS_CUSTOM_TIME;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<TimeCreated> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<TimeCreated> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<TimeCreated>() {
            public TimeCreated findValueByNumber(int number) {
              return TimeCreated.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.getDescriptor()
            .getEnumTypes()
            .get(8);
      }

      private static final TimeCreated[] VALUES = values();

      public static TimeCreated valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private TimeCreated(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storagetransfer.v1.MetadataOptions.TimeCreated)
    }

    public static final int SYMLINK_FIELD_NUMBER = 1;
    private int symlink_;
    /**
     *
     *
     * <pre>
     * Specifies how symlinks should be handled by the transfer. By default,
     * symlinks are not preserved. Only applicable to transfers involving
     * POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.Symlink symlink = 1;</code>
     *
     * @return The enum numeric value on the wire for symlink.
     */
    @java.lang.Override
    public int getSymlinkValue() {
      return symlink_;
    }
    /**
     *
     *
     * <pre>
     * Specifies how symlinks should be handled by the transfer. By default,
     * symlinks are not preserved. Only applicable to transfers involving
     * POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.Symlink symlink = 1;</code>
     *
     * @return The symlink.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Symlink getSymlink() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Symlink result =
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Symlink.valueOf(
              symlink_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Symlink.UNRECOGNIZED
          : result;
    }

    public static final int MODE_FIELD_NUMBER = 2;
    private int mode_;
    /**
     *
     *
     * <pre>
     * Specifies how each file's mode attribute should be handled by the transfer.
     * By default, mode is not preserved. Only applicable to transfers involving
     * POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.Mode mode = 2;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }
    /**
     *
     *
     * <pre>
     * Specifies how each file's mode attribute should be handled by the transfer.
     * By default, mode is not preserved. Only applicable to transfers involving
     * POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.Mode mode = 2;</code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Mode getMode() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Mode result =
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Mode.valueOf(mode_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Mode.UNRECOGNIZED
          : result;
    }

    public static final int GID_FIELD_NUMBER = 3;
    private int gid_;
    /**
     *
     *
     * <pre>
     * Specifies how each file's POSIX group ID (GID) attribute should be handled
     * by the transfer. By default, GID is not preserved. Only applicable to
     * transfers involving POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.GID gid = 3;</code>
     *
     * @return The enum numeric value on the wire for gid.
     */
    @java.lang.Override
    public int getGidValue() {
      return gid_;
    }
    /**
     *
     *
     * <pre>
     * Specifies how each file's POSIX group ID (GID) attribute should be handled
     * by the transfer. By default, GID is not preserved. Only applicable to
     * transfers involving POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.GID gid = 3;</code>
     *
     * @return The gid.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.GID getGid() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.GID result =
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.GID.valueOf(gid_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.GID.UNRECOGNIZED
          : result;
    }

    public static final int UID_FIELD_NUMBER = 4;
    private int uid_;
    /**
     *
     *
     * <pre>
     * Specifies how each file's POSIX user ID (UID) attribute should be handled
     * by the transfer. By default, UID is not preserved. Only applicable to
     * transfers involving POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.UID uid = 4;</code>
     *
     * @return The enum numeric value on the wire for uid.
     */
    @java.lang.Override
    public int getUidValue() {
      return uid_;
    }
    /**
     *
     *
     * <pre>
     * Specifies how each file's POSIX user ID (UID) attribute should be handled
     * by the transfer. By default, UID is not preserved. Only applicable to
     * transfers involving POSIX file systems, and ignored for other transfers.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.UID uid = 4;</code>
     *
     * @return The uid.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.UID getUid() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.UID result =
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.UID.valueOf(uid_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.UID.UNRECOGNIZED
          : result;
    }

    public static final int ACL_FIELD_NUMBER = 5;
    private int acl_;
    /**
     *
     *
     * <pre>
     * Specifies how each object's ACLs should be preserved for transfers between
     * Google Cloud Storage buckets. If unspecified, the default behavior is the
     * same as ACL_DESTINATION_BUCKET_DEFAULT.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.Acl acl = 5;</code>
     *
     * @return The enum numeric value on the wire for acl.
     */
    @java.lang.Override
    public int getAclValue() {
      return acl_;
    }
    /**
     *
     *
     * <pre>
     * Specifies how each object's ACLs should be preserved for transfers between
     * Google Cloud Storage buckets. If unspecified, the default behavior is the
     * same as ACL_DESTINATION_BUCKET_DEFAULT.
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.Acl acl = 5;</code>
     *
     * @return The acl.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Acl getAcl() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Acl result =
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Acl.valueOf(acl_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Acl.UNRECOGNIZED
          : result;
    }

    public static final int STORAGE_CLASS_FIELD_NUMBER = 6;
    private int storageClass_;
    /**
     *
     *
     * <pre>
     * Specifies the storage class to set on objects being transferred to Google
     * Cloud Storage buckets.  If unspecified, the default behavior is the same as
     * [STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.StorageClass.STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.StorageClass storage_class = 6;</code>
     *
     * @return The enum numeric value on the wire for storageClass.
     */
    @java.lang.Override
    public int getStorageClassValue() {
      return storageClass_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the storage class to set on objects being transferred to Google
     * Cloud Storage buckets.  If unspecified, the default behavior is the same as
     * [STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.StorageClass.STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.StorageClass storage_class = 6;</code>
     *
     * @return The storageClass.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.StorageClass
        getStorageClass() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.StorageClass result =
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.StorageClass.valueOf(
              storageClass_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.StorageClass
              .UNRECOGNIZED
          : result;
    }

    public static final int TEMPORARY_HOLD_FIELD_NUMBER = 7;
    private int temporaryHold_;
    /**
     *
     *
     * <pre>
     * Specifies how each object's temporary hold status should be preserved for
     * transfers between Google Cloud Storage buckets.  If unspecified, the
     * default behavior is the same as
     * [TEMPORARY_HOLD_PRESERVE][google.storagetransfer.v1.MetadataOptions.TemporaryHold.TEMPORARY_HOLD_PRESERVE].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.TemporaryHold temporary_hold = 7;</code>
     *
     * @return The enum numeric value on the wire for temporaryHold.
     */
    @java.lang.Override
    public int getTemporaryHoldValue() {
      return temporaryHold_;
    }
    /**
     *
     *
     * <pre>
     * Specifies how each object's temporary hold status should be preserved for
     * transfers between Google Cloud Storage buckets.  If unspecified, the
     * default behavior is the same as
     * [TEMPORARY_HOLD_PRESERVE][google.storagetransfer.v1.MetadataOptions.TemporaryHold.TEMPORARY_HOLD_PRESERVE].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.TemporaryHold temporary_hold = 7;</code>
     *
     * @return The temporaryHold.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TemporaryHold
        getTemporaryHold() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TemporaryHold result =
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TemporaryHold.valueOf(
              temporaryHold_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TemporaryHold
              .UNRECOGNIZED
          : result;
    }

    public static final int KMS_KEY_FIELD_NUMBER = 8;
    private int kmsKey_;
    /**
     *
     *
     * <pre>
     * Specifies how each object's Cloud KMS customer-managed encryption key
     * (CMEK) is preserved for transfers between Google Cloud Storage buckets.  If
     * unspecified, the default behavior is the same as
     * [KMS_KEY_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.KmsKey.KMS_KEY_DESTINATION_BUCKET_DEFAULT].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.KmsKey kms_key = 8;</code>
     *
     * @return The enum numeric value on the wire for kmsKey.
     */
    @java.lang.Override
    public int getKmsKeyValue() {
      return kmsKey_;
    }
    /**
     *
     *
     * <pre>
     * Specifies how each object's Cloud KMS customer-managed encryption key
     * (CMEK) is preserved for transfers between Google Cloud Storage buckets.  If
     * unspecified, the default behavior is the same as
     * [KMS_KEY_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.KmsKey.KMS_KEY_DESTINATION_BUCKET_DEFAULT].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.KmsKey kms_key = 8;</code>
     *
     * @return The kmsKey.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.KmsKey getKmsKey() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.KmsKey result =
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.KmsKey.valueOf(kmsKey_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.KmsKey.UNRECOGNIZED
          : result;
    }

    public static final int TIME_CREATED_FIELD_NUMBER = 9;
    private int timeCreated_;
    /**
     *
     *
     * <pre>
     * Specifies how each object's `timeCreated` metadata is preserved for
     * transfers between Google Cloud Storage buckets.  If unspecified, the
     * default behavior is the same as
     * [TIME_CREATED_SKIP][google.storagetransfer.v1.MetadataOptions.TimeCreated.TIME_CREATED_SKIP].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.TimeCreated time_created = 9;</code>
     *
     * @return The enum numeric value on the wire for timeCreated.
     */
    @java.lang.Override
    public int getTimeCreatedValue() {
      return timeCreated_;
    }
    /**
     *
     *
     * <pre>
     * Specifies how each object's `timeCreated` metadata is preserved for
     * transfers between Google Cloud Storage buckets.  If unspecified, the
     * default behavior is the same as
     * [TIME_CREATED_SKIP][google.storagetransfer.v1.MetadataOptions.TimeCreated.TIME_CREATED_SKIP].
     * </pre>
     *
     * <code>.google.storagetransfer.v1.MetadataOptions.TimeCreated time_created = 9;</code>
     *
     * @return The timeCreated.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TimeCreated
        getTimeCreated() {
      @SuppressWarnings("deprecation")
      com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TimeCreated result =
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TimeCreated.valueOf(
              timeCreated_);
      return result == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TimeCreated
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (symlink_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Symlink
              .SYMLINK_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, symlink_);
      }
      if (mode_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Mode.MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, mode_);
      }
      if (gid_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.GID.GID_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, gid_);
      }
      if (uid_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.UID.UID_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, uid_);
      }
      if (acl_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Acl.ACL_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(5, acl_);
      }
      if (storageClass_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.StorageClass
              .STORAGE_CLASS_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(6, storageClass_);
      }
      if (temporaryHold_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TemporaryHold
              .TEMPORARY_HOLD_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(7, temporaryHold_);
      }
      if (kmsKey_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.KmsKey
              .KMS_KEY_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(8, kmsKey_);
      }
      if (timeCreated_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TimeCreated
              .TIME_CREATED_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(9, timeCreated_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (symlink_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Symlink
              .SYMLINK_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, symlink_);
      }
      if (mode_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Mode.MODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, mode_);
      }
      if (gid_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.GID.GID_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, gid_);
      }
      if (uid_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.UID.UID_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, uid_);
      }
      if (acl_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Acl.ACL_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, acl_);
      }
      if (storageClass_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.StorageClass
              .STORAGE_CLASS_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, storageClass_);
      }
      if (temporaryHold_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TemporaryHold
              .TEMPORARY_HOLD_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, temporaryHold_);
      }
      if (kmsKey_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.KmsKey
              .KMS_KEY_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, kmsKey_);
      }
      if (timeCreated_
          != com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TimeCreated
              .TIME_CREATED_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, timeCreated_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions other =
          (com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions) obj;

      if (symlink_ != other.symlink_) return false;
      if (mode_ != other.mode_) return false;
      if (gid_ != other.gid_) return false;
      if (uid_ != other.uid_) return false;
      if (acl_ != other.acl_) return false;
      if (storageClass_ != other.storageClass_) return false;
      if (temporaryHold_ != other.temporaryHold_) return false;
      if (kmsKey_ != other.kmsKey_) return false;
      if (timeCreated_ != other.timeCreated_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SYMLINK_FIELD_NUMBER;
      hash = (53 * hash) + symlink_;
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
      hash = (37 * hash) + GID_FIELD_NUMBER;
      hash = (53 * hash) + gid_;
      hash = (37 * hash) + UID_FIELD_NUMBER;
      hash = (53 * hash) + uid_;
      hash = (37 * hash) + ACL_FIELD_NUMBER;
      hash = (53 * hash) + acl_;
      hash = (37 * hash) + STORAGE_CLASS_FIELD_NUMBER;
      hash = (53 * hash) + storageClass_;
      hash = (37 * hash) + TEMPORARY_HOLD_FIELD_NUMBER;
      hash = (53 * hash) + temporaryHold_;
      hash = (37 * hash) + KMS_KEY_FIELD_NUMBER;
      hash = (53 * hash) + kmsKey_;
      hash = (37 * hash) + TIME_CREATED_FIELD_NUMBER;
      hash = (53 * hash) + timeCreated_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies the metadata options for running a transfer.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.MetadataOptions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.MetadataOptions)
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_MetadataOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_MetadataOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.class,
                com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Builder.class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        symlink_ = 0;

        mode_ = 0;

        gid_ = 0;

        uid_ = 0;

        acl_ = 0;

        storageClass_ = 0;

        temporaryHold_ = 0;

        kmsKey_ = 0;

        timeCreated_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_MetadataOptions_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions build() {
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions result =
            new com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions(this);
        result.symlink_ = symlink_;
        result.mode_ = mode_;
        result.gid_ = gid_;
        result.uid_ = uid_;
        result.acl_ = acl_;
        result.storageClass_ = storageClass_;
        result.temporaryHold_ = temporaryHold_;
        result.kmsKey_ = kmsKey_;
        result.timeCreated_ = timeCreated_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions
                .getDefaultInstance()) return this;
        if (other.symlink_ != 0) {
          setSymlinkValue(other.getSymlinkValue());
        }
        if (other.mode_ != 0) {
          setModeValue(other.getModeValue());
        }
        if (other.gid_ != 0) {
          setGidValue(other.getGidValue());
        }
        if (other.uid_ != 0) {
          setUidValue(other.getUidValue());
        }
        if (other.acl_ != 0) {
          setAclValue(other.getAclValue());
        }
        if (other.storageClass_ != 0) {
          setStorageClassValue(other.getStorageClassValue());
        }
        if (other.temporaryHold_ != 0) {
          setTemporaryHoldValue(other.getTemporaryHoldValue());
        }
        if (other.kmsKey_ != 0) {
          setKmsKeyValue(other.getKmsKeyValue());
        }
        if (other.timeCreated_ != 0) {
          setTimeCreatedValue(other.getTimeCreatedValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  symlink_ = input.readEnum();

                  break;
                } // case 8
              case 16:
                {
                  mode_ = input.readEnum();

                  break;
                } // case 16
              case 24:
                {
                  gid_ = input.readEnum();

                  break;
                } // case 24
              case 32:
                {
                  uid_ = input.readEnum();

                  break;
                } // case 32
              case 40:
                {
                  acl_ = input.readEnum();

                  break;
                } // case 40
              case 48:
                {
                  storageClass_ = input.readEnum();

                  break;
                } // case 48
              case 56:
                {
                  temporaryHold_ = input.readEnum();

                  break;
                } // case 56
              case 64:
                {
                  kmsKey_ = input.readEnum();

                  break;
                } // case 64
              case 72:
                {
                  timeCreated_ = input.readEnum();

                  break;
                } // case 72
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int symlink_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies how symlinks should be handled by the transfer. By default,
       * symlinks are not preserved. Only applicable to transfers involving
       * POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Symlink symlink = 1;</code>
       *
       * @return The enum numeric value on the wire for symlink.
       */
      @java.lang.Override
      public int getSymlinkValue() {
        return symlink_;
      }
      /**
       *
       *
       * <pre>
       * Specifies how symlinks should be handled by the transfer. By default,
       * symlinks are not preserved. Only applicable to transfers involving
       * POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Symlink symlink = 1;</code>
       *
       * @param value The enum numeric value on the wire for symlink to set.
       * @return This builder for chaining.
       */
      public Builder setSymlinkValue(int value) {

        symlink_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how symlinks should be handled by the transfer. By default,
       * symlinks are not preserved. Only applicable to transfers involving
       * POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Symlink symlink = 1;</code>
       *
       * @return The symlink.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Symlink
          getSymlink() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Symlink result =
            com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Symlink.valueOf(
                symlink_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Symlink.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies how symlinks should be handled by the transfer. By default,
       * symlinks are not preserved. Only applicable to transfers involving
       * POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Symlink symlink = 1;</code>
       *
       * @param value The symlink to set.
       * @return This builder for chaining.
       */
      public Builder setSymlink(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Symlink value) {
        if (value == null) {
          throw new NullPointerException();
        }

        symlink_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how symlinks should be handled by the transfer. By default,
       * symlinks are not preserved. Only applicable to transfers involving
       * POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Symlink symlink = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSymlink() {

        symlink_ = 0;
        onChanged();
        return this;
      }

      private int mode_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies how each file's mode attribute should be handled by the transfer.
       * By default, mode is not preserved. Only applicable to transfers involving
       * POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Mode mode = 2;</code>
       *
       * @return The enum numeric value on the wire for mode.
       */
      @java.lang.Override
      public int getModeValue() {
        return mode_;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each file's mode attribute should be handled by the transfer.
       * By default, mode is not preserved. Only applicable to transfers involving
       * POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Mode mode = 2;</code>
       *
       * @param value The enum numeric value on the wire for mode to set.
       * @return This builder for chaining.
       */
      public Builder setModeValue(int value) {

        mode_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each file's mode attribute should be handled by the transfer.
       * By default, mode is not preserved. Only applicable to transfers involving
       * POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Mode mode = 2;</code>
       *
       * @return The mode.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Mode getMode() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Mode result =
            com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Mode.valueOf(mode_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Mode.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each file's mode attribute should be handled by the transfer.
       * By default, mode is not preserved. Only applicable to transfers involving
       * POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Mode mode = 2;</code>
       *
       * @param value The mode to set.
       * @return This builder for chaining.
       */
      public Builder setMode(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Mode value) {
        if (value == null) {
          throw new NullPointerException();
        }

        mode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each file's mode attribute should be handled by the transfer.
       * By default, mode is not preserved. Only applicable to transfers involving
       * POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Mode mode = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMode() {

        mode_ = 0;
        onChanged();
        return this;
      }

      private int gid_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies how each file's POSIX group ID (GID) attribute should be handled
       * by the transfer. By default, GID is not preserved. Only applicable to
       * transfers involving POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.GID gid = 3;</code>
       *
       * @return The enum numeric value on the wire for gid.
       */
      @java.lang.Override
      public int getGidValue() {
        return gid_;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each file's POSIX group ID (GID) attribute should be handled
       * by the transfer. By default, GID is not preserved. Only applicable to
       * transfers involving POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.GID gid = 3;</code>
       *
       * @param value The enum numeric value on the wire for gid to set.
       * @return This builder for chaining.
       */
      public Builder setGidValue(int value) {

        gid_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each file's POSIX group ID (GID) attribute should be handled
       * by the transfer. By default, GID is not preserved. Only applicable to
       * transfers involving POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.GID gid = 3;</code>
       *
       * @return The gid.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.GID getGid() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.GID result =
            com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.GID.valueOf(gid_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.GID.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each file's POSIX group ID (GID) attribute should be handled
       * by the transfer. By default, GID is not preserved. Only applicable to
       * transfers involving POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.GID gid = 3;</code>
       *
       * @param value The gid to set.
       * @return This builder for chaining.
       */
      public Builder setGid(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.GID value) {
        if (value == null) {
          throw new NullPointerException();
        }

        gid_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each file's POSIX group ID (GID) attribute should be handled
       * by the transfer. By default, GID is not preserved. Only applicable to
       * transfers involving POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.GID gid = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGid() {

        gid_ = 0;
        onChanged();
        return this;
      }

      private int uid_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies how each file's POSIX user ID (UID) attribute should be handled
       * by the transfer. By default, UID is not preserved. Only applicable to
       * transfers involving POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.UID uid = 4;</code>
       *
       * @return The enum numeric value on the wire for uid.
       */
      @java.lang.Override
      public int getUidValue() {
        return uid_;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each file's POSIX user ID (UID) attribute should be handled
       * by the transfer. By default, UID is not preserved. Only applicable to
       * transfers involving POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.UID uid = 4;</code>
       *
       * @param value The enum numeric value on the wire for uid to set.
       * @return This builder for chaining.
       */
      public Builder setUidValue(int value) {

        uid_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each file's POSIX user ID (UID) attribute should be handled
       * by the transfer. By default, UID is not preserved. Only applicable to
       * transfers involving POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.UID uid = 4;</code>
       *
       * @return The uid.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.UID getUid() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.UID result =
            com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.UID.valueOf(uid_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.UID.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each file's POSIX user ID (UID) attribute should be handled
       * by the transfer. By default, UID is not preserved. Only applicable to
       * transfers involving POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.UID uid = 4;</code>
       *
       * @param value The uid to set.
       * @return This builder for chaining.
       */
      public Builder setUid(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.UID value) {
        if (value == null) {
          throw new NullPointerException();
        }

        uid_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each file's POSIX user ID (UID) attribute should be handled
       * by the transfer. By default, UID is not preserved. Only applicable to
       * transfers involving POSIX file systems, and ignored for other transfers.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.UID uid = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUid() {

        uid_ = 0;
        onChanged();
        return this;
      }

      private int acl_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies how each object's ACLs should be preserved for transfers between
       * Google Cloud Storage buckets. If unspecified, the default behavior is the
       * same as ACL_DESTINATION_BUCKET_DEFAULT.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Acl acl = 5;</code>
       *
       * @return The enum numeric value on the wire for acl.
       */
      @java.lang.Override
      public int getAclValue() {
        return acl_;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's ACLs should be preserved for transfers between
       * Google Cloud Storage buckets. If unspecified, the default behavior is the
       * same as ACL_DESTINATION_BUCKET_DEFAULT.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Acl acl = 5;</code>
       *
       * @param value The enum numeric value on the wire for acl to set.
       * @return This builder for chaining.
       */
      public Builder setAclValue(int value) {

        acl_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's ACLs should be preserved for transfers between
       * Google Cloud Storage buckets. If unspecified, the default behavior is the
       * same as ACL_DESTINATION_BUCKET_DEFAULT.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Acl acl = 5;</code>
       *
       * @return The acl.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Acl getAcl() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Acl result =
            com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Acl.valueOf(acl_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Acl.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's ACLs should be preserved for transfers between
       * Google Cloud Storage buckets. If unspecified, the default behavior is the
       * same as ACL_DESTINATION_BUCKET_DEFAULT.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Acl acl = 5;</code>
       *
       * @param value The acl to set.
       * @return This builder for chaining.
       */
      public Builder setAcl(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.Acl value) {
        if (value == null) {
          throw new NullPointerException();
        }

        acl_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's ACLs should be preserved for transfers between
       * Google Cloud Storage buckets. If unspecified, the default behavior is the
       * same as ACL_DESTINATION_BUCKET_DEFAULT.
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.Acl acl = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAcl() {

        acl_ = 0;
        onChanged();
        return this;
      }

      private int storageClass_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies the storage class to set on objects being transferred to Google
       * Cloud Storage buckets.  If unspecified, the default behavior is the same as
       * [STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.StorageClass.STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.StorageClass storage_class = 6;</code>
       *
       * @return The enum numeric value on the wire for storageClass.
       */
      @java.lang.Override
      public int getStorageClassValue() {
        return storageClass_;
      }
      /**
       *
       *
       * <pre>
       * Specifies the storage class to set on objects being transferred to Google
       * Cloud Storage buckets.  If unspecified, the default behavior is the same as
       * [STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.StorageClass.STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.StorageClass storage_class = 6;</code>
       *
       * @param value The enum numeric value on the wire for storageClass to set.
       * @return This builder for chaining.
       */
      public Builder setStorageClassValue(int value) {

        storageClass_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the storage class to set on objects being transferred to Google
       * Cloud Storage buckets.  If unspecified, the default behavior is the same as
       * [STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.StorageClass.STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.StorageClass storage_class = 6;</code>
       *
       * @return The storageClass.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.StorageClass
          getStorageClass() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.StorageClass result =
            com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.StorageClass.valueOf(
                storageClass_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.StorageClass
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies the storage class to set on objects being transferred to Google
       * Cloud Storage buckets.  If unspecified, the default behavior is the same as
       * [STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.StorageClass.STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.StorageClass storage_class = 6;</code>
       *
       * @param value The storageClass to set.
       * @return This builder for chaining.
       */
      public Builder setStorageClass(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.StorageClass value) {
        if (value == null) {
          throw new NullPointerException();
        }

        storageClass_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the storage class to set on objects being transferred to Google
       * Cloud Storage buckets.  If unspecified, the default behavior is the same as
       * [STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.StorageClass.STORAGE_CLASS_DESTINATION_BUCKET_DEFAULT].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.StorageClass storage_class = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStorageClass() {

        storageClass_ = 0;
        onChanged();
        return this;
      }

      private int temporaryHold_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies how each object's temporary hold status should be preserved for
       * transfers between Google Cloud Storage buckets.  If unspecified, the
       * default behavior is the same as
       * [TEMPORARY_HOLD_PRESERVE][google.storagetransfer.v1.MetadataOptions.TemporaryHold.TEMPORARY_HOLD_PRESERVE].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.TemporaryHold temporary_hold = 7;</code>
       *
       * @return The enum numeric value on the wire for temporaryHold.
       */
      @java.lang.Override
      public int getTemporaryHoldValue() {
        return temporaryHold_;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's temporary hold status should be preserved for
       * transfers between Google Cloud Storage buckets.  If unspecified, the
       * default behavior is the same as
       * [TEMPORARY_HOLD_PRESERVE][google.storagetransfer.v1.MetadataOptions.TemporaryHold.TEMPORARY_HOLD_PRESERVE].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.TemporaryHold temporary_hold = 7;</code>
       *
       * @param value The enum numeric value on the wire for temporaryHold to set.
       * @return This builder for chaining.
       */
      public Builder setTemporaryHoldValue(int value) {

        temporaryHold_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's temporary hold status should be preserved for
       * transfers between Google Cloud Storage buckets.  If unspecified, the
       * default behavior is the same as
       * [TEMPORARY_HOLD_PRESERVE][google.storagetransfer.v1.MetadataOptions.TemporaryHold.TEMPORARY_HOLD_PRESERVE].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.TemporaryHold temporary_hold = 7;</code>
       *
       * @return The temporaryHold.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TemporaryHold
          getTemporaryHold() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TemporaryHold result =
            com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TemporaryHold.valueOf(
                temporaryHold_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TemporaryHold
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's temporary hold status should be preserved for
       * transfers between Google Cloud Storage buckets.  If unspecified, the
       * default behavior is the same as
       * [TEMPORARY_HOLD_PRESERVE][google.storagetransfer.v1.MetadataOptions.TemporaryHold.TEMPORARY_HOLD_PRESERVE].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.TemporaryHold temporary_hold = 7;</code>
       *
       * @param value The temporaryHold to set.
       * @return This builder for chaining.
       */
      public Builder setTemporaryHold(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TemporaryHold value) {
        if (value == null) {
          throw new NullPointerException();
        }

        temporaryHold_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's temporary hold status should be preserved for
       * transfers between Google Cloud Storage buckets.  If unspecified, the
       * default behavior is the same as
       * [TEMPORARY_HOLD_PRESERVE][google.storagetransfer.v1.MetadataOptions.TemporaryHold.TEMPORARY_HOLD_PRESERVE].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.TemporaryHold temporary_hold = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTemporaryHold() {

        temporaryHold_ = 0;
        onChanged();
        return this;
      }

      private int kmsKey_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies how each object's Cloud KMS customer-managed encryption key
       * (CMEK) is preserved for transfers between Google Cloud Storage buckets.  If
       * unspecified, the default behavior is the same as
       * [KMS_KEY_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.KmsKey.KMS_KEY_DESTINATION_BUCKET_DEFAULT].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.KmsKey kms_key = 8;</code>
       *
       * @return The enum numeric value on the wire for kmsKey.
       */
      @java.lang.Override
      public int getKmsKeyValue() {
        return kmsKey_;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's Cloud KMS customer-managed encryption key
       * (CMEK) is preserved for transfers between Google Cloud Storage buckets.  If
       * unspecified, the default behavior is the same as
       * [KMS_KEY_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.KmsKey.KMS_KEY_DESTINATION_BUCKET_DEFAULT].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.KmsKey kms_key = 8;</code>
       *
       * @param value The enum numeric value on the wire for kmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKeyValue(int value) {

        kmsKey_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's Cloud KMS customer-managed encryption key
       * (CMEK) is preserved for transfers between Google Cloud Storage buckets.  If
       * unspecified, the default behavior is the same as
       * [KMS_KEY_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.KmsKey.KMS_KEY_DESTINATION_BUCKET_DEFAULT].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.KmsKey kms_key = 8;</code>
       *
       * @return The kmsKey.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.KmsKey getKmsKey() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.KmsKey result =
            com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.KmsKey.valueOf(
                kmsKey_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.KmsKey.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's Cloud KMS customer-managed encryption key
       * (CMEK) is preserved for transfers between Google Cloud Storage buckets.  If
       * unspecified, the default behavior is the same as
       * [KMS_KEY_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.KmsKey.KMS_KEY_DESTINATION_BUCKET_DEFAULT].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.KmsKey kms_key = 8;</code>
       *
       * @param value The kmsKey to set.
       * @return This builder for chaining.
       */
      public Builder setKmsKey(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.KmsKey value) {
        if (value == null) {
          throw new NullPointerException();
        }

        kmsKey_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's Cloud KMS customer-managed encryption key
       * (CMEK) is preserved for transfers between Google Cloud Storage buckets.  If
       * unspecified, the default behavior is the same as
       * [KMS_KEY_DESTINATION_BUCKET_DEFAULT][google.storagetransfer.v1.MetadataOptions.KmsKey.KMS_KEY_DESTINATION_BUCKET_DEFAULT].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.KmsKey kms_key = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKmsKey() {

        kmsKey_ = 0;
        onChanged();
        return this;
      }

      private int timeCreated_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies how each object's `timeCreated` metadata is preserved for
       * transfers between Google Cloud Storage buckets.  If unspecified, the
       * default behavior is the same as
       * [TIME_CREATED_SKIP][google.storagetransfer.v1.MetadataOptions.TimeCreated.TIME_CREATED_SKIP].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.TimeCreated time_created = 9;</code>
       *
       * @return The enum numeric value on the wire for timeCreated.
       */
      @java.lang.Override
      public int getTimeCreatedValue() {
        return timeCreated_;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's `timeCreated` metadata is preserved for
       * transfers between Google Cloud Storage buckets.  If unspecified, the
       * default behavior is the same as
       * [TIME_CREATED_SKIP][google.storagetransfer.v1.MetadataOptions.TimeCreated.TIME_CREATED_SKIP].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.TimeCreated time_created = 9;</code>
       *
       * @param value The enum numeric value on the wire for timeCreated to set.
       * @return This builder for chaining.
       */
      public Builder setTimeCreatedValue(int value) {

        timeCreated_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's `timeCreated` metadata is preserved for
       * transfers between Google Cloud Storage buckets.  If unspecified, the
       * default behavior is the same as
       * [TIME_CREATED_SKIP][google.storagetransfer.v1.MetadataOptions.TimeCreated.TIME_CREATED_SKIP].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.TimeCreated time_created = 9;</code>
       *
       * @return The timeCreated.
       */
      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TimeCreated
          getTimeCreated() {
        @SuppressWarnings("deprecation")
        com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TimeCreated result =
            com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TimeCreated.valueOf(
                timeCreated_);
        return result == null
            ? com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TimeCreated
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's `timeCreated` metadata is preserved for
       * transfers between Google Cloud Storage buckets.  If unspecified, the
       * default behavior is the same as
       * [TIME_CREATED_SKIP][google.storagetransfer.v1.MetadataOptions.TimeCreated.TIME_CREATED_SKIP].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.TimeCreated time_created = 9;</code>
       *
       * @param value The timeCreated to set.
       * @return This builder for chaining.
       */
      public Builder setTimeCreated(
          com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions.TimeCreated value) {
        if (value == null) {
          throw new NullPointerException();
        }

        timeCreated_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies how each object's `timeCreated` metadata is preserved for
       * transfers between Google Cloud Storage buckets.  If unspecified, the
       * default behavior is the same as
       * [TIME_CREATED_SKIP][google.storagetransfer.v1.MetadataOptions.TimeCreated.TIME_CREATED_SKIP].
       * </pre>
       *
       * <code>.google.storagetransfer.v1.MetadataOptions.TimeCreated time_created = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTimeCreated() {

        timeCreated_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.MetadataOptions)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.MetadataOptions)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MetadataOptions> PARSER =
        new com.google.protobuf.AbstractParser<MetadataOptions>() {
          @java.lang.Override
          public MetadataOptions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MetadataOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MetadataOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.MetadataOptions
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TransferManifestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.TransferManifest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Specifies the path to the manifest in Cloud Storage. The Google-managed
     * service account for the transfer must have `storage.objects.get`
     * permission for this object. An example path is
     * `gs://bucket_name/path/manifest.csv`.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    java.lang.String getLocation();
    /**
     *
     *
     * <pre>
     * Specifies the path to the manifest in Cloud Storage. The Google-managed
     * service account for the transfer must have `storage.objects.get`
     * permission for this object. An example path is
     * `gs://bucket_name/path/manifest.csv`.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    com.google.protobuf.ByteString getLocationBytes();
  }
  /**
   *
   *
   * <pre>
   * Specifies where the manifest is located.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.TransferManifest}
   */
  public static final class TransferManifest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.TransferManifest)
      TransferManifestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TransferManifest.newBuilder() to construct.
    private TransferManifest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TransferManifest() {
      location_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TransferManifest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_TransferManifest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferTypes
          .internal_static_google_storagetransfer_v1_TransferManifest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest.class,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest.Builder.class);
    }

    public static final int LOCATION_FIELD_NUMBER = 1;
    private volatile java.lang.Object location_;
    /**
     *
     *
     * <pre>
     * Specifies the path to the manifest in Cloud Storage. The Google-managed
     * service account for the transfer must have `storage.objects.get`
     * permission for this object. An example path is
     * `gs://bucket_name/path/manifest.csv`.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The location.
     */
    @java.lang.Override
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the path to the manifest in Cloud Storage. The Google-managed
     * service account for the transfer must have `storage.objects.get`
     * permission for this object. An example path is
     * `gs://bucket_name/path/manifest.csv`.
     * </pre>
     *
     * <code>string location = 1;</code>
     *
     * @return The bytes for location.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest other =
          (com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest) obj;

      if (!getLocation().equals(other.getLocation())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies where the manifest is located.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.TransferManifest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.TransferManifest)
        com.google.storagetransfer.v1.proto.TransferTypes.TransferManifestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_TransferManifest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_TransferManifest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest.class,
                com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest.Builder.class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        location_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes
            .internal_static_google_storagetransfer_v1_TransferManifest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest build() {
        com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest buildPartial() {
        com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest result =
            new com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest(this);
        result.location_ = location_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest
                .getDefaultInstance()) return this;
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  location_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object location_ = "";
      /**
       *
       *
       * <pre>
       * Specifies the path to the manifest in Cloud Storage. The Google-managed
       * service account for the transfer must have `storage.objects.get`
       * permission for this object. An example path is
       * `gs://bucket_name/path/manifest.csv`.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The location.
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the path to the manifest in Cloud Storage. The Google-managed
       * service account for the transfer must have `storage.objects.get`
       * permission for this object. An example path is
       * `gs://bucket_name/path/manifest.csv`.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return The bytes for location.
       */
      public com.google.protobuf.ByteString getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Specifies the path to the manifest in Cloud Storage. The Google-managed
       * service account for the transfer must have `storage.objects.get`
       * permission for this object. An example path is
       * `gs://bucket_name/path/manifest.csv`.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The location to set.
       * @return This builder for chaining.
       */
      public Builder setLocation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        location_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the path to the manifest in Cloud Storage. The Google-managed
       * service account for the transfer must have `storage.objects.get`
       * permission for this object. An example path is
       * `gs://bucket_name/path/manifest.csv`.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLocation() {

        location_ = getDefaultInstance().getLocation();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies the path to the manifest in Cloud Storage. The Google-managed
       * service account for the transfer must have `storage.objects.get`
       * permission for this object. An example path is
       * `gs://bucket_name/path/manifest.csv`.
       * </pre>
       *
       * <code>string location = 1;</code>
       *
       * @param value The bytes for location to set.
       * @return This builder for chaining.
       */
      public Builder setLocationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        location_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.TransferManifest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.TransferManifest)
    private static final com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest();
    }

    public static com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TransferManifest> PARSER =
        new com.google.protobuf.AbstractParser<TransferManifest>() {
          @java.lang.Override
          public TransferManifest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TransferManifest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TransferManifest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferManifest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ScheduleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1