/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storagetransfer/v1/transfer.proto

package com.google.storagetransfer.v1.proto;

public final class TransferProto {
  private TransferProto() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface GetGoogleServiceAccountRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.GetGoogleServiceAccountRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that the Google service
     * account is associated with.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    java.lang.String getProjectId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that the Google service
     * account is associated with.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    com.google.protobuf.ByteString getProjectIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Request passed to GetGoogleServiceAccount.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.GetGoogleServiceAccountRequest}
   */
  public static final class GetGoogleServiceAccountRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.GetGoogleServiceAccountRequest)
      GetGoogleServiceAccountRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GetGoogleServiceAccountRequest.newBuilder() to construct.
    private GetGoogleServiceAccountRequest(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GetGoogleServiceAccountRequest() {
      projectId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GetGoogleServiceAccountRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_GetGoogleServiceAccountRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_GetGoogleServiceAccountRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
                  .class,
              com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
                  .Builder.class);
    }

    public static final int PROJECT_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object projectId_;
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that the Google service
     * account is associated with.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    @java.lang.Override
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that the Google service
     * account is associated with.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest) obj;

      if (!getProjectId().equals(other.getProjectId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getProjectId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request passed to GetGoogleServiceAccount.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.GetGoogleServiceAccountRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.GetGoogleServiceAccountRequest)
        com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_GetGoogleServiceAccountRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_GetGoogleServiceAccountRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
                    .class,
                com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
                    .Builder.class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        projectId_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_GetGoogleServiceAccountRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
          build() {
        com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest(
                this);
        result.projectId_ = projectId_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
                .getDefaultInstance()) return this;
        if (!other.getProjectId().isEmpty()) {
          projectId_ = other.projectId_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  projectId_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object projectId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that the Google service
       * account is associated with.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The projectId.
       */
      public java.lang.String getProjectId() {
        java.lang.Object ref = projectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that the Google service
       * account is associated with.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for projectId.
       */
      public com.google.protobuf.ByteString getProjectIdBytes() {
        java.lang.Object ref = projectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that the Google service
       * account is associated with.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        projectId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that the Google service
       * account is associated with.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectId() {

        projectId_ = getDefaultInstance().getProjectId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that the Google service
       * account is associated with.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        projectId_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.GetGoogleServiceAccountRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.GetGoogleServiceAccountRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto
            .GetGoogleServiceAccountRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GetGoogleServiceAccountRequest> PARSER =
        new com.google.protobuf.AbstractParser<GetGoogleServiceAccountRequest>() {
          @java.lang.Override
          public GetGoogleServiceAccountRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GetGoogleServiceAccountRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetGoogleServiceAccountRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.GetGoogleServiceAccountRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CreateTransferJobRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.CreateTransferJobRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The job to create.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the transferJob field is set.
     */
    boolean hasTransferJob();
    /**
     *
     *
     * <pre>
     * Required. The job to create.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The transferJob.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.TransferJob getTransferJob();
    /**
     *
     *
     * <pre>
     * Required. The job to create.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder
        getTransferJobOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Request passed to CreateTransferJob.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.CreateTransferJobRequest}
   */
  public static final class CreateTransferJobRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.CreateTransferJobRequest)
      CreateTransferJobRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CreateTransferJobRequest.newBuilder() to construct.
    private CreateTransferJobRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CreateTransferJobRequest() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CreateTransferJobRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_CreateTransferJobRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_CreateTransferJobRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest.class,
              com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest.Builder
                  .class);
    }

    public static final int TRANSFER_JOB_FIELD_NUMBER = 1;
    private com.google.storagetransfer.v1.proto.TransferTypes.TransferJob transferJob_;
    /**
     *
     *
     * <pre>
     * Required. The job to create.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the transferJob field is set.
     */
    @java.lang.Override
    public boolean hasTransferJob() {
      return transferJob_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The job to create.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The transferJob.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferJob getTransferJob() {
      return transferJob_ == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.getDefaultInstance()
          : transferJob_;
    }
    /**
     *
     *
     * <pre>
     * Required. The job to create.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder
        getTransferJobOrBuilder() {
      return getTransferJob();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (transferJob_ != null) {
        output.writeMessage(1, getTransferJob());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (transferJob_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTransferJob());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest) obj;

      if (hasTransferJob() != other.hasTransferJob()) return false;
      if (hasTransferJob()) {
        if (!getTransferJob().equals(other.getTransferJob())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTransferJob()) {
        hash = (37 * hash) + TRANSFER_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getTransferJob().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request passed to CreateTransferJob.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.CreateTransferJobRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.CreateTransferJobRequest)
        com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_CreateTransferJobRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_CreateTransferJobRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest.class,
                com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (transferJobBuilder_ == null) {
          transferJob_ = null;
        } else {
          transferJob_ = null;
          transferJobBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_CreateTransferJobRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest build() {
        com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest(this);
        if (transferJobBuilder_ == null) {
          result.transferJob_ = transferJob_;
        } else {
          result.transferJob_ = transferJobBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
                .getDefaultInstance()) return this;
        if (other.hasTransferJob()) {
          mergeTransferJob(other.getTransferJob());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getTransferJobFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.storagetransfer.v1.proto.TransferTypes.TransferJob transferJob_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJob,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder>
          transferJobBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The job to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the transferJob field is set.
       */
      public boolean hasTransferJob() {
        return transferJobBuilder_ != null || transferJob_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The transferJob.
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferJob getTransferJob() {
        if (transferJobBuilder_ == null) {
          return transferJob_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.getDefaultInstance()
              : transferJob_;
        } else {
          return transferJobBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The job to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setTransferJob(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferJob value) {
        if (transferJobBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          transferJob_ = value;
          onChanged();
        } else {
          transferJobBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setTransferJob(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder builderForValue) {
        if (transferJobBuilder_ == null) {
          transferJob_ = builderForValue.build();
          onChanged();
        } else {
          transferJobBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeTransferJob(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferJob value) {
        if (transferJobBuilder_ == null) {
          if (transferJob_ != null) {
            transferJob_ =
                com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.newBuilder(
                        transferJob_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            transferJob_ = value;
          }
          onChanged();
        } else {
          transferJobBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearTransferJob() {
        if (transferJobBuilder_ == null) {
          transferJob_ = null;
          onChanged();
        } else {
          transferJob_ = null;
          transferJobBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder
          getTransferJobBuilder() {

        onChanged();
        return getTransferJobFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The job to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder
          getTransferJobOrBuilder() {
        if (transferJobBuilder_ != null) {
          return transferJobBuilder_.getMessageOrBuilder();
        } else {
          return transferJob_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.getDefaultInstance()
              : transferJob_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The job to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJob,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder>
          getTransferJobFieldBuilder() {
        if (transferJobBuilder_ == null) {
          transferJobBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferJob,
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder>(
                  getTransferJob(), getParentForChildren(), isClean());
          transferJob_ = null;
        }
        return transferJobBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.CreateTransferJobRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.CreateTransferJobRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CreateTransferJobRequest> PARSER =
        new com.google.protobuf.AbstractParser<CreateTransferJobRequest>() {
          @java.lang.Override
          public CreateTransferJobRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CreateTransferJobRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CreateTransferJobRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.CreateTransferJobRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UpdateTransferJobRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.UpdateTransferJobRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of job to update.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The jobName.
     */
    java.lang.String getJobName();
    /**
     *
     *
     * <pre>
     * Required. The name of job to update.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for jobName.
     */
    com.google.protobuf.ByteString getJobNameBytes();

    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    java.lang.String getProjectId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    com.google.protobuf.ByteString getProjectIdBytes();

    /**
     *
     *
     * <pre>
     * Required. The job to update. `transferJob` is expected to specify one or more of
     * five fields: [description][google.storagetransfer.v1.TransferJob.description],
     * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
     * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
     * other fields are rejected with the error
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
     * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
     * `storagetransfer.jobs.delete` permission.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the transferJob field is set.
     */
    boolean hasTransferJob();
    /**
     *
     *
     * <pre>
     * Required. The job to update. `transferJob` is expected to specify one or more of
     * five fields: [description][google.storagetransfer.v1.TransferJob.description],
     * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
     * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
     * other fields are rejected with the error
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
     * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
     * `storagetransfer.jobs.delete` permission.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The transferJob.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.TransferJob getTransferJob();
    /**
     *
     *
     * <pre>
     * Required. The job to update. `transferJob` is expected to specify one or more of
     * five fields: [description][google.storagetransfer.v1.TransferJob.description],
     * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
     * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
     * other fields are rejected with the error
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
     * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
     * `storagetransfer.jobs.delete` permission.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder
        getTransferJobOrBuilder();

    /**
     *
     *
     * <pre>
     * The field mask of the fields in `transferJob` that are to be updated in
     * this request.  Fields in `transferJob` that can be updated are:
     * [description][google.storagetransfer.v1.TransferJob.description],
     * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
     * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
     * complete transfer specification must be provided. An incomplete
     * specification missing any required fields is rejected with the error
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
     *
     * @return Whether the updateTransferJobFieldMask field is set.
     */
    boolean hasUpdateTransferJobFieldMask();
    /**
     *
     *
     * <pre>
     * The field mask of the fields in `transferJob` that are to be updated in
     * this request.  Fields in `transferJob` that can be updated are:
     * [description][google.storagetransfer.v1.TransferJob.description],
     * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
     * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
     * complete transfer specification must be provided. An incomplete
     * specification missing any required fields is rejected with the error
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
     *
     * @return The updateTransferJobFieldMask.
     */
    com.google.protobuf.FieldMask getUpdateTransferJobFieldMask();
    /**
     *
     *
     * <pre>
     * The field mask of the fields in `transferJob` that are to be updated in
     * this request.  Fields in `transferJob` that can be updated are:
     * [description][google.storagetransfer.v1.TransferJob.description],
     * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
     * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
     * complete transfer specification must be provided. An incomplete
     * specification missing any required fields is rejected with the error
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
     */
    com.google.protobuf.FieldMaskOrBuilder getUpdateTransferJobFieldMaskOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Request passed to UpdateTransferJob.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.UpdateTransferJobRequest}
   */
  public static final class UpdateTransferJobRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.UpdateTransferJobRequest)
      UpdateTransferJobRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UpdateTransferJobRequest.newBuilder() to construct.
    private UpdateTransferJobRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UpdateTransferJobRequest() {
      jobName_ = "";
      projectId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UpdateTransferJobRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_UpdateTransferJobRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_UpdateTransferJobRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest.class,
              com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest.Builder
                  .class);
    }

    public static final int JOB_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object jobName_;
    /**
     *
     *
     * <pre>
     * Required. The name of job to update.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The jobName.
     */
    @java.lang.Override
    public java.lang.String getJobName() {
      java.lang.Object ref = jobName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of job to update.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for jobName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJobNameBytes() {
      java.lang.Object ref = jobName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROJECT_ID_FIELD_NUMBER = 2;
    private volatile java.lang.Object projectId_;
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    @java.lang.Override
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TRANSFER_JOB_FIELD_NUMBER = 3;
    private com.google.storagetransfer.v1.proto.TransferTypes.TransferJob transferJob_;
    /**
     *
     *
     * <pre>
     * Required. The job to update. `transferJob` is expected to specify one or more of
     * five fields: [description][google.storagetransfer.v1.TransferJob.description],
     * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
     * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
     * other fields are rejected with the error
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
     * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
     * `storagetransfer.jobs.delete` permission.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the transferJob field is set.
     */
    @java.lang.Override
    public boolean hasTransferJob() {
      return transferJob_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The job to update. `transferJob` is expected to specify one or more of
     * five fields: [description][google.storagetransfer.v1.TransferJob.description],
     * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
     * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
     * other fields are rejected with the error
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
     * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
     * `storagetransfer.jobs.delete` permission.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The transferJob.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferJob getTransferJob() {
      return transferJob_ == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.getDefaultInstance()
          : transferJob_;
    }
    /**
     *
     *
     * <pre>
     * Required. The job to update. `transferJob` is expected to specify one or more of
     * five fields: [description][google.storagetransfer.v1.TransferJob.description],
     * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
     * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
     * other fields are rejected with the error
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
     * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
     * `storagetransfer.jobs.delete` permission.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder
        getTransferJobOrBuilder() {
      return getTransferJob();
    }

    public static final int UPDATE_TRANSFER_JOB_FIELD_MASK_FIELD_NUMBER = 4;
    private com.google.protobuf.FieldMask updateTransferJobFieldMask_;
    /**
     *
     *
     * <pre>
     * The field mask of the fields in `transferJob` that are to be updated in
     * this request.  Fields in `transferJob` that can be updated are:
     * [description][google.storagetransfer.v1.TransferJob.description],
     * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
     * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
     * complete transfer specification must be provided. An incomplete
     * specification missing any required fields is rejected with the error
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
     *
     * @return Whether the updateTransferJobFieldMask field is set.
     */
    @java.lang.Override
    public boolean hasUpdateTransferJobFieldMask() {
      return updateTransferJobFieldMask_ != null;
    }
    /**
     *
     *
     * <pre>
     * The field mask of the fields in `transferJob` that are to be updated in
     * this request.  Fields in `transferJob` that can be updated are:
     * [description][google.storagetransfer.v1.TransferJob.description],
     * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
     * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
     * complete transfer specification must be provided. An incomplete
     * specification missing any required fields is rejected with the error
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
     *
     * @return The updateTransferJobFieldMask.
     */
    @java.lang.Override
    public com.google.protobuf.FieldMask getUpdateTransferJobFieldMask() {
      return updateTransferJobFieldMask_ == null
          ? com.google.protobuf.FieldMask.getDefaultInstance()
          : updateTransferJobFieldMask_;
    }
    /**
     *
     *
     * <pre>
     * The field mask of the fields in `transferJob` that are to be updated in
     * this request.  Fields in `transferJob` that can be updated are:
     * [description][google.storagetransfer.v1.TransferJob.description],
     * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
     * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
     * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
     * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
     * complete transfer specification must be provided. An incomplete
     * specification missing any required fields is rejected with the error
     * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.FieldMaskOrBuilder getUpdateTransferJobFieldMaskOrBuilder() {
      return getUpdateTransferJobFieldMask();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, jobName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
      }
      if (transferJob_ != null) {
        output.writeMessage(3, getTransferJob());
      }
      if (updateTransferJobFieldMask_ != null) {
        output.writeMessage(4, getUpdateTransferJobFieldMask());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, jobName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
      }
      if (transferJob_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTransferJob());
      }
      if (updateTransferJobFieldMask_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, getUpdateTransferJobFieldMask());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest) obj;

      if (!getJobName().equals(other.getJobName())) return false;
      if (!getProjectId().equals(other.getProjectId())) return false;
      if (hasTransferJob() != other.hasTransferJob()) return false;
      if (hasTransferJob()) {
        if (!getTransferJob().equals(other.getTransferJob())) return false;
      }
      if (hasUpdateTransferJobFieldMask() != other.hasUpdateTransferJobFieldMask()) return false;
      if (hasUpdateTransferJobFieldMask()) {
        if (!getUpdateTransferJobFieldMask().equals(other.getUpdateTransferJobFieldMask()))
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + JOB_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getJobName().hashCode();
      hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getProjectId().hashCode();
      if (hasTransferJob()) {
        hash = (37 * hash) + TRANSFER_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getTransferJob().hashCode();
      }
      if (hasUpdateTransferJobFieldMask()) {
        hash = (37 * hash) + UPDATE_TRANSFER_JOB_FIELD_MASK_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateTransferJobFieldMask().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request passed to UpdateTransferJob.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.UpdateTransferJobRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.UpdateTransferJobRequest)
        com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_UpdateTransferJobRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_UpdateTransferJobRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest.class,
                com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        jobName_ = "";

        projectId_ = "";

        if (transferJobBuilder_ == null) {
          transferJob_ = null;
        } else {
          transferJob_ = null;
          transferJobBuilder_ = null;
        }
        if (updateTransferJobFieldMaskBuilder_ == null) {
          updateTransferJobFieldMask_ = null;
        } else {
          updateTransferJobFieldMask_ = null;
          updateTransferJobFieldMaskBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_UpdateTransferJobRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest build() {
        com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest(this);
        result.jobName_ = jobName_;
        result.projectId_ = projectId_;
        if (transferJobBuilder_ == null) {
          result.transferJob_ = transferJob_;
        } else {
          result.transferJob_ = transferJobBuilder_.build();
        }
        if (updateTransferJobFieldMaskBuilder_ == null) {
          result.updateTransferJobFieldMask_ = updateTransferJobFieldMask_;
        } else {
          result.updateTransferJobFieldMask_ = updateTransferJobFieldMaskBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
                .getDefaultInstance()) return this;
        if (!other.getJobName().isEmpty()) {
          jobName_ = other.jobName_;
          onChanged();
        }
        if (!other.getProjectId().isEmpty()) {
          projectId_ = other.projectId_;
          onChanged();
        }
        if (other.hasTransferJob()) {
          mergeTransferJob(other.getTransferJob());
        }
        if (other.hasUpdateTransferJobFieldMask()) {
          mergeUpdateTransferJobFieldMask(other.getUpdateTransferJobFieldMask());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  jobName_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  projectId_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getTransferJobFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getUpdateTransferJobFieldMaskFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object jobName_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of job to update.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The jobName.
       */
      public java.lang.String getJobName() {
        java.lang.Object ref = jobName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jobName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of job to update.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for jobName.
       */
      public com.google.protobuf.ByteString getJobNameBytes() {
        java.lang.Object ref = jobName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          jobName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of job to update.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The jobName to set.
       * @return This builder for chaining.
       */
      public Builder setJobName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        jobName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of job to update.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJobName() {

        jobName_ = getDefaultInstance().getJobName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of job to update.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for jobName to set.
       * @return This builder for chaining.
       */
      public Builder setJobNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        jobName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object projectId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The projectId.
       */
      public java.lang.String getProjectId() {
        java.lang.Object ref = projectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for projectId.
       */
      public com.google.protobuf.ByteString getProjectIdBytes() {
        java.lang.Object ref = projectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        projectId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectId() {

        projectId_ = getDefaultInstance().getProjectId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        projectId_ = value;
        onChanged();
        return this;
      }

      private com.google.storagetransfer.v1.proto.TransferTypes.TransferJob transferJob_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJob,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder>
          transferJobBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The job to update. `transferJob` is expected to specify one or more of
       * five fields: [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
       * other fields are rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
       * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
       * `storagetransfer.jobs.delete` permission.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the transferJob field is set.
       */
      public boolean hasTransferJob() {
        return transferJobBuilder_ != null || transferJob_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to update. `transferJob` is expected to specify one or more of
       * five fields: [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
       * other fields are rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
       * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
       * `storagetransfer.jobs.delete` permission.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The transferJob.
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferJob getTransferJob() {
        if (transferJobBuilder_ == null) {
          return transferJob_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.getDefaultInstance()
              : transferJob_;
        } else {
          return transferJobBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The job to update. `transferJob` is expected to specify one or more of
       * five fields: [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
       * other fields are rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
       * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
       * `storagetransfer.jobs.delete` permission.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setTransferJob(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferJob value) {
        if (transferJobBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          transferJob_ = value;
          onChanged();
        } else {
          transferJobBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to update. `transferJob` is expected to specify one or more of
       * five fields: [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
       * other fields are rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
       * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
       * `storagetransfer.jobs.delete` permission.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setTransferJob(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder builderForValue) {
        if (transferJobBuilder_ == null) {
          transferJob_ = builderForValue.build();
          onChanged();
        } else {
          transferJobBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to update. `transferJob` is expected to specify one or more of
       * five fields: [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
       * other fields are rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
       * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
       * `storagetransfer.jobs.delete` permission.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeTransferJob(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferJob value) {
        if (transferJobBuilder_ == null) {
          if (transferJob_ != null) {
            transferJob_ =
                com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.newBuilder(
                        transferJob_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            transferJob_ = value;
          }
          onChanged();
        } else {
          transferJobBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to update. `transferJob` is expected to specify one or more of
       * five fields: [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
       * other fields are rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
       * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
       * `storagetransfer.jobs.delete` permission.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearTransferJob() {
        if (transferJobBuilder_ == null) {
          transferJob_ = null;
          onChanged();
        } else {
          transferJob_ = null;
          transferJobBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to update. `transferJob` is expected to specify one or more of
       * five fields: [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
       * other fields are rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
       * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
       * `storagetransfer.jobs.delete` permission.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder
          getTransferJobBuilder() {

        onChanged();
        return getTransferJobFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The job to update. `transferJob` is expected to specify one or more of
       * five fields: [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
       * other fields are rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
       * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
       * `storagetransfer.jobs.delete` permission.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder
          getTransferJobOrBuilder() {
        if (transferJobBuilder_ != null) {
          return transferJobBuilder_.getMessageOrBuilder();
        } else {
          return transferJob_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.getDefaultInstance()
              : transferJob_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The job to update. `transferJob` is expected to specify one or more of
       * five fields: [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  An `UpdateTransferJobRequest` that specifies
       * other fields are rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. Updating a job status
       * to [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED] requires
       * `storagetransfer.jobs.delete` permission.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.TransferJob transfer_job = 3 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJob,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder>
          getTransferJobFieldBuilder() {
        if (transferJobBuilder_ == null) {
          transferJobBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferJob,
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder>(
                  getTransferJob(), getParentForChildren(), isClean());
          transferJob_ = null;
        }
        return transferJobBuilder_;
      }

      private com.google.protobuf.FieldMask updateTransferJobFieldMask_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder,
              com.google.protobuf.FieldMaskOrBuilder>
          updateTransferJobFieldMaskBuilder_;
      /**
       *
       *
       * <pre>
       * The field mask of the fields in `transferJob` that are to be updated in
       * this request.  Fields in `transferJob` that can be updated are:
       * [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
       * complete transfer specification must be provided. An incomplete
       * specification missing any required fields is rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
       *
       * @return Whether the updateTransferJobFieldMask field is set.
       */
      public boolean hasUpdateTransferJobFieldMask() {
        return updateTransferJobFieldMaskBuilder_ != null || updateTransferJobFieldMask_ != null;
      }
      /**
       *
       *
       * <pre>
       * The field mask of the fields in `transferJob` that are to be updated in
       * this request.  Fields in `transferJob` that can be updated are:
       * [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
       * complete transfer specification must be provided. An incomplete
       * specification missing any required fields is rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
       *
       * @return The updateTransferJobFieldMask.
       */
      public com.google.protobuf.FieldMask getUpdateTransferJobFieldMask() {
        if (updateTransferJobFieldMaskBuilder_ == null) {
          return updateTransferJobFieldMask_ == null
              ? com.google.protobuf.FieldMask.getDefaultInstance()
              : updateTransferJobFieldMask_;
        } else {
          return updateTransferJobFieldMaskBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The field mask of the fields in `transferJob` that are to be updated in
       * this request.  Fields in `transferJob` that can be updated are:
       * [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
       * complete transfer specification must be provided. An incomplete
       * specification missing any required fields is rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
       */
      public Builder setUpdateTransferJobFieldMask(com.google.protobuf.FieldMask value) {
        if (updateTransferJobFieldMaskBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateTransferJobFieldMask_ = value;
          onChanged();
        } else {
          updateTransferJobFieldMaskBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The field mask of the fields in `transferJob` that are to be updated in
       * this request.  Fields in `transferJob` that can be updated are:
       * [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
       * complete transfer specification must be provided. An incomplete
       * specification missing any required fields is rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
       */
      public Builder setUpdateTransferJobFieldMask(
          com.google.protobuf.FieldMask.Builder builderForValue) {
        if (updateTransferJobFieldMaskBuilder_ == null) {
          updateTransferJobFieldMask_ = builderForValue.build();
          onChanged();
        } else {
          updateTransferJobFieldMaskBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The field mask of the fields in `transferJob` that are to be updated in
       * this request.  Fields in `transferJob` that can be updated are:
       * [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
       * complete transfer specification must be provided. An incomplete
       * specification missing any required fields is rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
       */
      public Builder mergeUpdateTransferJobFieldMask(com.google.protobuf.FieldMask value) {
        if (updateTransferJobFieldMaskBuilder_ == null) {
          if (updateTransferJobFieldMask_ != null) {
            updateTransferJobFieldMask_ =
                com.google.protobuf.FieldMask.newBuilder(updateTransferJobFieldMask_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            updateTransferJobFieldMask_ = value;
          }
          onChanged();
        } else {
          updateTransferJobFieldMaskBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The field mask of the fields in `transferJob` that are to be updated in
       * this request.  Fields in `transferJob` that can be updated are:
       * [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
       * complete transfer specification must be provided. An incomplete
       * specification missing any required fields is rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
       */
      public Builder clearUpdateTransferJobFieldMask() {
        if (updateTransferJobFieldMaskBuilder_ == null) {
          updateTransferJobFieldMask_ = null;
          onChanged();
        } else {
          updateTransferJobFieldMask_ = null;
          updateTransferJobFieldMaskBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The field mask of the fields in `transferJob` that are to be updated in
       * this request.  Fields in `transferJob` that can be updated are:
       * [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
       * complete transfer specification must be provided. An incomplete
       * specification missing any required fields is rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
       */
      public com.google.protobuf.FieldMask.Builder getUpdateTransferJobFieldMaskBuilder() {

        onChanged();
        return getUpdateTransferJobFieldMaskFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The field mask of the fields in `transferJob` that are to be updated in
       * this request.  Fields in `transferJob` that can be updated are:
       * [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
       * complete transfer specification must be provided. An incomplete
       * specification missing any required fields is rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
       */
      public com.google.protobuf.FieldMaskOrBuilder getUpdateTransferJobFieldMaskOrBuilder() {
        if (updateTransferJobFieldMaskBuilder_ != null) {
          return updateTransferJobFieldMaskBuilder_.getMessageOrBuilder();
        } else {
          return updateTransferJobFieldMask_ == null
              ? com.google.protobuf.FieldMask.getDefaultInstance()
              : updateTransferJobFieldMask_;
        }
      }
      /**
       *
       *
       * <pre>
       * The field mask of the fields in `transferJob` that are to be updated in
       * this request.  Fields in `transferJob` that can be updated are:
       * [description][google.storagetransfer.v1.TransferJob.description],
       * [transfer_spec][google.storagetransfer.v1.TransferJob.transfer_spec],
       * [notification_config][google.storagetransfer.v1.TransferJob.notification_config],
       * [logging_config][google.storagetransfer.v1.TransferJob.logging_config], and
       * [status][google.storagetransfer.v1.TransferJob.status].  To update the `transfer_spec` of the job, a
       * complete transfer specification must be provided. An incomplete
       * specification missing any required fields is rejected with the error
       * [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_transfer_job_field_mask = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder,
              com.google.protobuf.FieldMaskOrBuilder>
          getUpdateTransferJobFieldMaskFieldBuilder() {
        if (updateTransferJobFieldMaskBuilder_ == null) {
          updateTransferJobFieldMaskBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.FieldMask,
                  com.google.protobuf.FieldMask.Builder,
                  com.google.protobuf.FieldMaskOrBuilder>(
                  getUpdateTransferJobFieldMask(), getParentForChildren(), isClean());
          updateTransferJobFieldMask_ = null;
        }
        return updateTransferJobFieldMaskBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.UpdateTransferJobRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.UpdateTransferJobRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UpdateTransferJobRequest> PARSER =
        new com.google.protobuf.AbstractParser<UpdateTransferJobRequest>() {
          @java.lang.Override
          public UpdateTransferJobRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UpdateTransferJobRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UpdateTransferJobRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.UpdateTransferJobRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GetTransferJobRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.GetTransferJobRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The job to get.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The jobName.
     */
    java.lang.String getJobName();
    /**
     *
     *
     * <pre>
     * Required. The job to get.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for jobName.
     */
    com.google.protobuf.ByteString getJobNameBytes();

    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    java.lang.String getProjectId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    com.google.protobuf.ByteString getProjectIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Request passed to GetTransferJob.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.GetTransferJobRequest}
   */
  public static final class GetTransferJobRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.GetTransferJobRequest)
      GetTransferJobRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GetTransferJobRequest.newBuilder() to construct.
    private GetTransferJobRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GetTransferJobRequest() {
      jobName_ = "";
      projectId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GetTransferJobRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_GetTransferJobRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_GetTransferJobRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest.class,
              com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest.Builder
                  .class);
    }

    public static final int JOB_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object jobName_;
    /**
     *
     *
     * <pre>
     * Required. The job to get.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The jobName.
     */
    @java.lang.Override
    public java.lang.String getJobName() {
      java.lang.Object ref = jobName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The job to get.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for jobName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJobNameBytes() {
      java.lang.Object ref = jobName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROJECT_ID_FIELD_NUMBER = 2;
    private volatile java.lang.Object projectId_;
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    @java.lang.Override
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, jobName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, jobName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest) obj;

      if (!getJobName().equals(other.getJobName())) return false;
      if (!getProjectId().equals(other.getProjectId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + JOB_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getJobName().hashCode();
      hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getProjectId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request passed to GetTransferJob.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.GetTransferJobRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.GetTransferJobRequest)
        com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_GetTransferJobRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_GetTransferJobRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest.class,
                com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        jobName_ = "";

        projectId_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_GetTransferJobRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest build() {
        com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest(this);
        result.jobName_ = jobName_;
        result.projectId_ = projectId_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest
                .getDefaultInstance()) return this;
        if (!other.getJobName().isEmpty()) {
          jobName_ = other.jobName_;
          onChanged();
        }
        if (!other.getProjectId().isEmpty()) {
          projectId_ = other.projectId_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  jobName_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  projectId_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object jobName_ = "";
      /**
       *
       *
       * <pre>
       * Required. The job to get.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The jobName.
       */
      public java.lang.String getJobName() {
        java.lang.Object ref = jobName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jobName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The job to get.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for jobName.
       */
      public com.google.protobuf.ByteString getJobNameBytes() {
        java.lang.Object ref = jobName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          jobName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The job to get.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The jobName to set.
       * @return This builder for chaining.
       */
      public Builder setJobName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        jobName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to get.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJobName() {

        jobName_ = getDefaultInstance().getJobName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to get.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for jobName to set.
       * @return This builder for chaining.
       */
      public Builder setJobNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        jobName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object projectId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The projectId.
       */
      public java.lang.String getProjectId() {
        java.lang.Object ref = projectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for projectId.
       */
      public com.google.protobuf.ByteString getProjectIdBytes() {
        java.lang.Object ref = projectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        projectId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectId() {

        projectId_ = getDefaultInstance().getProjectId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        projectId_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.GetTransferJobRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.GetTransferJobRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GetTransferJobRequest> PARSER =
        new com.google.protobuf.AbstractParser<GetTransferJobRequest>() {
          @java.lang.Override
          public GetTransferJobRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GetTransferJobRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetTransferJobRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.GetTransferJobRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeleteTransferJobRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.DeleteTransferJobRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The job to delete.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The jobName.
     */
    java.lang.String getJobName();
    /**
     *
     *
     * <pre>
     * Required. The job to delete.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for jobName.
     */
    com.google.protobuf.ByteString getJobNameBytes();

    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    java.lang.String getProjectId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    com.google.protobuf.ByteString getProjectIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Request passed to DeleteTransferJob.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.DeleteTransferJobRequest}
   */
  public static final class DeleteTransferJobRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.DeleteTransferJobRequest)
      DeleteTransferJobRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeleteTransferJobRequest.newBuilder() to construct.
    private DeleteTransferJobRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeleteTransferJobRequest() {
      jobName_ = "";
      projectId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeleteTransferJobRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_DeleteTransferJobRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_DeleteTransferJobRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest.class,
              com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest.Builder
                  .class);
    }

    public static final int JOB_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object jobName_;
    /**
     *
     *
     * <pre>
     * Required. The job to delete.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The jobName.
     */
    @java.lang.Override
    public java.lang.String getJobName() {
      java.lang.Object ref = jobName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The job to delete.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for jobName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJobNameBytes() {
      java.lang.Object ref = jobName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROJECT_ID_FIELD_NUMBER = 2;
    private volatile java.lang.Object projectId_;
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    @java.lang.Override
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, jobName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, jobName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest) obj;

      if (!getJobName().equals(other.getJobName())) return false;
      if (!getProjectId().equals(other.getProjectId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + JOB_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getJobName().hashCode();
      hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getProjectId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request passed to DeleteTransferJob.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.DeleteTransferJobRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.DeleteTransferJobRequest)
        com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_DeleteTransferJobRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_DeleteTransferJobRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest.class,
                com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        jobName_ = "";

        projectId_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_DeleteTransferJobRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest build() {
        com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest(this);
        result.jobName_ = jobName_;
        result.projectId_ = projectId_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
                .getDefaultInstance()) return this;
        if (!other.getJobName().isEmpty()) {
          jobName_ = other.jobName_;
          onChanged();
        }
        if (!other.getProjectId().isEmpty()) {
          projectId_ = other.projectId_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  jobName_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  projectId_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object jobName_ = "";
      /**
       *
       *
       * <pre>
       * Required. The job to delete.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The jobName.
       */
      public java.lang.String getJobName() {
        java.lang.Object ref = jobName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jobName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The job to delete.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for jobName.
       */
      public com.google.protobuf.ByteString getJobNameBytes() {
        java.lang.Object ref = jobName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          jobName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The job to delete.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The jobName to set.
       * @return This builder for chaining.
       */
      public Builder setJobName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        jobName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to delete.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJobName() {

        jobName_ = getDefaultInstance().getJobName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The job to delete.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for jobName to set.
       * @return This builder for chaining.
       */
      public Builder setJobNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        jobName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object projectId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The projectId.
       */
      public java.lang.String getProjectId() {
        java.lang.Object ref = projectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for projectId.
       */
      public com.google.protobuf.ByteString getProjectIdBytes() {
        java.lang.Object ref = projectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        projectId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectId() {

        projectId_ = getDefaultInstance().getProjectId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        projectId_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.DeleteTransferJobRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.DeleteTransferJobRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeleteTransferJobRequest> PARSER =
        new com.google.protobuf.AbstractParser<DeleteTransferJobRequest>() {
          @java.lang.Override
          public DeleteTransferJobRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeleteTransferJobRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeleteTransferJobRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.DeleteTransferJobRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ListTransferJobsRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.ListTransferJobsRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. A list of query parameters specified as JSON text in the form of:
     * `{"projectId":"my_project_id",
     *  "jobNames":["jobid1","jobid2",...],
     *  "jobStatuses":["status1","status2",...]}`
     * Since `jobNames` and `jobStatuses` support multiple values, their values
     * must be specified with array notation. `projectId` is required.
     * `jobNames` and `jobStatuses` are optional.  The valid values for
     * `jobStatuses` are case-insensitive:
     * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED],
     * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and
     * [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();
    /**
     *
     *
     * <pre>
     * Required. A list of query parameters specified as JSON text in the form of:
     * `{"projectId":"my_project_id",
     *  "jobNames":["jobid1","jobid2",...],
     *  "jobStatuses":["status1","status2",...]}`
     * Since `jobNames` and `jobStatuses` support multiple values, their values
     * must be specified with array notation. `projectId` is required.
     * `jobNames` and `jobStatuses` are optional.  The valid values for
     * `jobStatuses` are case-insensitive:
     * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED],
     * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and
     * [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();

    /**
     *
     *
     * <pre>
     * The list page size. The max allowed value is 256.
     * </pre>
     *
     * <code>int32 page_size = 4;</code>
     *
     * @return The pageSize.
     */
    int getPageSize();

    /**
     *
     *
     * <pre>
     * The list page token.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @return The pageToken.
     */
    java.lang.String getPageToken();
    /**
     *
     *
     * <pre>
     * The list page token.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @return The bytes for pageToken.
     */
    com.google.protobuf.ByteString getPageTokenBytes();
  }
  /**
   *
   *
   * <pre>
   * `projectId`, `jobNames`, and `jobStatuses` are query parameters that can
   * be specified when listing transfer jobs.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.ListTransferJobsRequest}
   */
  public static final class ListTransferJobsRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.ListTransferJobsRequest)
      ListTransferJobsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListTransferJobsRequest.newBuilder() to construct.
    private ListTransferJobsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListTransferJobsRequest() {
      filter_ = "";
      pageToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListTransferJobsRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_ListTransferJobsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_ListTransferJobsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest.class,
              com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest.Builder
                  .class);
    }

    public static final int FILTER_FIELD_NUMBER = 1;
    private volatile java.lang.Object filter_;
    /**
     *
     *
     * <pre>
     * Required. A list of query parameters specified as JSON text in the form of:
     * `{"projectId":"my_project_id",
     *  "jobNames":["jobid1","jobid2",...],
     *  "jobStatuses":["status1","status2",...]}`
     * Since `jobNames` and `jobStatuses` support multiple values, their values
     * must be specified with array notation. `projectId` is required.
     * `jobNames` and `jobStatuses` are optional.  The valid values for
     * `jobStatuses` are case-insensitive:
     * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED],
     * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and
     * [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A list of query parameters specified as JSON text in the form of:
     * `{"projectId":"my_project_id",
     *  "jobNames":["jobid1","jobid2",...],
     *  "jobStatuses":["status1","status2",...]}`
     * Since `jobNames` and `jobStatuses` support multiple values, their values
     * must be specified with array notation. `projectId` is required.
     * `jobNames` and `jobStatuses` are optional.  The valid values for
     * `jobStatuses` are case-insensitive:
     * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED],
     * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and
     * [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
     * </pre>
     *
     * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PAGE_SIZE_FIELD_NUMBER = 4;
    private int pageSize_;
    /**
     *
     *
     * <pre>
     * The list page size. The max allowed value is 256.
     * </pre>
     *
     * <code>int32 page_size = 4;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    public static final int PAGE_TOKEN_FIELD_NUMBER = 5;
    private volatile java.lang.Object pageToken_;
    /**
     *
     *
     * <pre>
     * The list page token.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @return The pageToken.
     */
    @java.lang.Override
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The list page token.
     * </pre>
     *
     * <code>string page_token = 5;</code>
     *
     * @return The bytes for pageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, filter_);
      }
      if (pageSize_ != 0) {
        output.writeInt32(4, pageSize_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, pageToken_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, filter_);
      }
      if (pageSize_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, pageSize_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, pageToken_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest) obj;

      if (!getFilter().equals(other.getFilter())) return false;
      if (getPageSize() != other.getPageSize()) return false;
      if (!getPageToken().equals(other.getPageToken())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getPageSize();
      hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getPageToken().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * `projectId`, `jobNames`, and `jobStatuses` are query parameters that can
     * be specified when listing transfer jobs.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.ListTransferJobsRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.ListTransferJobsRequest)
        com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ListTransferJobsRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ListTransferJobsRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest.class,
                com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        filter_ = "";

        pageSize_ = 0;

        pageToken_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ListTransferJobsRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest build() {
        com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest(this);
        result.filter_ = filter_;
        result.pageSize_ = pageSize_;
        result.pageToken_ = pageToken_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
                .getDefaultInstance()) return this;
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          onChanged();
        }
        if (other.getPageSize() != 0) {
          setPageSize(other.getPageSize());
        }
        if (!other.getPageToken().isEmpty()) {
          pageToken_ = other.pageToken_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  filter_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 32:
                {
                  pageSize_ = input.readInt32();

                  break;
                } // case 32
              case 42:
                {
                  pageToken_ = input.readStringRequireUtf8();

                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * Required. A list of query parameters specified as JSON text in the form of:
       * `{"projectId":"my_project_id",
       *  "jobNames":["jobid1","jobid2",...],
       *  "jobStatuses":["status1","status2",...]}`
       * Since `jobNames` and `jobStatuses` support multiple values, their values
       * must be specified with array notation. `projectId` is required.
       * `jobNames` and `jobStatuses` are optional.  The valid values for
       * `jobStatuses` are case-insensitive:
       * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED],
       * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and
       * [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of query parameters specified as JSON text in the form of:
       * `{"projectId":"my_project_id",
       *  "jobNames":["jobid1","jobid2",...],
       *  "jobStatuses":["status1","status2",...]}`
       * Since `jobNames` and `jobStatuses` support multiple values, their values
       * must be specified with array notation. `projectId` is required.
       * `jobNames` and `jobStatuses` are optional.  The valid values for
       * `jobStatuses` are case-insensitive:
       * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED],
       * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and
       * [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A list of query parameters specified as JSON text in the form of:
       * `{"projectId":"my_project_id",
       *  "jobNames":["jobid1","jobid2",...],
       *  "jobStatuses":["status1","status2",...]}`
       * Since `jobNames` and `jobStatuses` support multiple values, their values
       * must be specified with array notation. `projectId` is required.
       * `jobNames` and `jobStatuses` are optional.  The valid values for
       * `jobStatuses` are case-insensitive:
       * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED],
       * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and
       * [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        filter_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of query parameters specified as JSON text in the form of:
       * `{"projectId":"my_project_id",
       *  "jobNames":["jobid1","jobid2",...],
       *  "jobStatuses":["status1","status2",...]}`
       * Since `jobNames` and `jobStatuses` support multiple values, their values
       * must be specified with array notation. `projectId` is required.
       * `jobNames` and `jobStatuses` are optional.  The valid values for
       * `jobStatuses` are case-insensitive:
       * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED],
       * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and
       * [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {

        filter_ = getDefaultInstance().getFilter();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of query parameters specified as JSON text in the form of:
       * `{"projectId":"my_project_id",
       *  "jobNames":["jobid1","jobid2",...],
       *  "jobStatuses":["status1","status2",...]}`
       * Since `jobNames` and `jobStatuses` support multiple values, their values
       * must be specified with array notation. `projectId` is required.
       * `jobNames` and `jobStatuses` are optional.  The valid values for
       * `jobStatuses` are case-insensitive:
       * [ENABLED][google.storagetransfer.v1.TransferJob.Status.ENABLED],
       * [DISABLED][google.storagetransfer.v1.TransferJob.Status.DISABLED], and
       * [DELETED][google.storagetransfer.v1.TransferJob.Status.DELETED].
       * </pre>
       *
       * <code>string filter = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        filter_ = value;
        onChanged();
        return this;
      }

      private int pageSize_;
      /**
       *
       *
       * <pre>
       * The list page size. The max allowed value is 256.
       * </pre>
       *
       * <code>int32 page_size = 4;</code>
       *
       * @return The pageSize.
       */
      @java.lang.Override
      public int getPageSize() {
        return pageSize_;
      }
      /**
       *
       *
       * <pre>
       * The list page size. The max allowed value is 256.
       * </pre>
       *
       * <code>int32 page_size = 4;</code>
       *
       * @param value The pageSize to set.
       * @return This builder for chaining.
       */
      public Builder setPageSize(int value) {

        pageSize_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list page size. The max allowed value is 256.
       * </pre>
       *
       * <code>int32 page_size = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageSize() {

        pageSize_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object pageToken_ = "";
      /**
       *
       *
       * <pre>
       * The list page token.
       * </pre>
       *
       * <code>string page_token = 5;</code>
       *
       * @return The pageToken.
       */
      public java.lang.String getPageToken() {
        java.lang.Object ref = pageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The list page token.
       * </pre>
       *
       * <code>string page_token = 5;</code>
       *
       * @return The bytes for pageToken.
       */
      public com.google.protobuf.ByteString getPageTokenBytes() {
        java.lang.Object ref = pageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The list page token.
       * </pre>
       *
       * <code>string page_token = 5;</code>
       *
       * @param value The pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        pageToken_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list page token.
       * </pre>
       *
       * <code>string page_token = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageToken() {

        pageToken_ = getDefaultInstance().getPageToken();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list page token.
       * </pre>
       *
       * <code>string page_token = 5;</code>
       *
       * @param value The bytes for pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        pageToken_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.ListTransferJobsRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.ListTransferJobsRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListTransferJobsRequest> PARSER =
        new com.google.protobuf.AbstractParser<ListTransferJobsRequest>() {
          @java.lang.Override
          public ListTransferJobsRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListTransferJobsRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListTransferJobsRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ListTransferJobsResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.ListTransferJobsResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of transfer jobs.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
     */
    java.util.List<com.google.storagetransfer.v1.proto.TransferTypes.TransferJob>
        getTransferJobsList();
    /**
     *
     *
     * <pre>
     * A list of transfer jobs.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.TransferJob getTransferJobs(int index);
    /**
     *
     *
     * <pre>
     * A list of transfer jobs.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
     */
    int getTransferJobsCount();
    /**
     *
     *
     * <pre>
     * A list of transfer jobs.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
     */
    java.util.List<? extends com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder>
        getTransferJobsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of transfer jobs.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder getTransferJobsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * The list next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    java.lang.String getNextPageToken();
    /**
     *
     *
     * <pre>
     * The list next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    com.google.protobuf.ByteString getNextPageTokenBytes();
  }
  /**
   *
   *
   * <pre>
   * Response from ListTransferJobs.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.ListTransferJobsResponse}
   */
  public static final class ListTransferJobsResponse extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.ListTransferJobsResponse)
      ListTransferJobsResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListTransferJobsResponse.newBuilder() to construct.
    private ListTransferJobsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListTransferJobsResponse() {
      transferJobs_ = java.util.Collections.emptyList();
      nextPageToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListTransferJobsResponse();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_ListTransferJobsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_ListTransferJobsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse.class,
              com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse.Builder
                  .class);
    }

    public static final int TRANSFER_JOBS_FIELD_NUMBER = 1;
    private java.util.List<com.google.storagetransfer.v1.proto.TransferTypes.TransferJob>
        transferJobs_;
    /**
     *
     *
     * <pre>
     * A list of transfer jobs.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.storagetransfer.v1.proto.TransferTypes.TransferJob>
        getTransferJobsList() {
      return transferJobs_;
    }
    /**
     *
     *
     * <pre>
     * A list of transfer jobs.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder>
        getTransferJobsOrBuilderList() {
      return transferJobs_;
    }
    /**
     *
     *
     * <pre>
     * A list of transfer jobs.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
     */
    @java.lang.Override
    public int getTransferJobsCount() {
      return transferJobs_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of transfer jobs.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferJob getTransferJobs(
        int index) {
      return transferJobs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of transfer jobs.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder
        getTransferJobsOrBuilder(int index) {
      return transferJobs_.get(index);
    }

    public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;
    private volatile java.lang.Object nextPageToken_;
    /**
     *
     *
     * <pre>
     * The list next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    @java.lang.Override
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The list next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < transferJobs_.size(); i++) {
        output.writeMessage(1, transferJobs_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < transferJobs_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, transferJobs_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse other =
          (com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse) obj;

      if (!getTransferJobsList().equals(other.getTransferJobsList())) return false;
      if (!getNextPageToken().equals(other.getNextPageToken())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getTransferJobsCount() > 0) {
        hash = (37 * hash) + TRANSFER_JOBS_FIELD_NUMBER;
        hash = (53 * hash) + getTransferJobsList().hashCode();
      }
      hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getNextPageToken().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Response from ListTransferJobs.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.ListTransferJobsResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.ListTransferJobsResponse)
        com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ListTransferJobsResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ListTransferJobsResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse.class,
                com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (transferJobsBuilder_ == null) {
          transferJobs_ = java.util.Collections.emptyList();
        } else {
          transferJobs_ = null;
          transferJobsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        nextPageToken_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ListTransferJobsResponse_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse build() {
        com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse result =
            new com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse(this);
        int from_bitField0_ = bitField0_;
        if (transferJobsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            transferJobs_ = java.util.Collections.unmodifiableList(transferJobs_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.transferJobs_ = transferJobs_;
        } else {
          result.transferJobs_ = transferJobsBuilder_.build();
        }
        result.nextPageToken_ = nextPageToken_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
                .getDefaultInstance()) return this;
        if (transferJobsBuilder_ == null) {
          if (!other.transferJobs_.isEmpty()) {
            if (transferJobs_.isEmpty()) {
              transferJobs_ = other.transferJobs_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureTransferJobsIsMutable();
              transferJobs_.addAll(other.transferJobs_);
            }
            onChanged();
          }
        } else {
          if (!other.transferJobs_.isEmpty()) {
            if (transferJobsBuilder_.isEmpty()) {
              transferJobsBuilder_.dispose();
              transferJobsBuilder_ = null;
              transferJobs_ = other.transferJobs_;
              bitField0_ = (bitField0_ & ~0x00000001);
              transferJobsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getTransferJobsFieldBuilder()
                      : null;
            } else {
              transferJobsBuilder_.addAllMessages(other.transferJobs_);
            }
          }
        }
        if (!other.getNextPageToken().isEmpty()) {
          nextPageToken_ = other.nextPageToken_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferJob m =
                      input.readMessage(
                          com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.parser(),
                          extensionRegistry);
                  if (transferJobsBuilder_ == null) {
                    ensureTransferJobsIsMutable();
                    transferJobs_.add(m);
                  } else {
                    transferJobsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  nextPageToken_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.storagetransfer.v1.proto.TransferTypes.TransferJob>
          transferJobs_ = java.util.Collections.emptyList();

      private void ensureTransferJobsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          transferJobs_ =
              new java.util.ArrayList<
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferJob>(transferJobs_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJob,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder>
          transferJobsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public java.util.List<com.google.storagetransfer.v1.proto.TransferTypes.TransferJob>
          getTransferJobsList() {
        if (transferJobsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(transferJobs_);
        } else {
          return transferJobsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public int getTransferJobsCount() {
        if (transferJobsBuilder_ == null) {
          return transferJobs_.size();
        } else {
          return transferJobsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferJob getTransferJobs(
          int index) {
        if (transferJobsBuilder_ == null) {
          return transferJobs_.get(index);
        } else {
          return transferJobsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public Builder setTransferJobs(
          int index, com.google.storagetransfer.v1.proto.TransferTypes.TransferJob value) {
        if (transferJobsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTransferJobsIsMutable();
          transferJobs_.set(index, value);
          onChanged();
        } else {
          transferJobsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public Builder setTransferJobs(
          int index,
          com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder builderForValue) {
        if (transferJobsBuilder_ == null) {
          ensureTransferJobsIsMutable();
          transferJobs_.set(index, builderForValue.build());
          onChanged();
        } else {
          transferJobsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public Builder addTransferJobs(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferJob value) {
        if (transferJobsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTransferJobsIsMutable();
          transferJobs_.add(value);
          onChanged();
        } else {
          transferJobsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public Builder addTransferJobs(
          int index, com.google.storagetransfer.v1.proto.TransferTypes.TransferJob value) {
        if (transferJobsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTransferJobsIsMutable();
          transferJobs_.add(index, value);
          onChanged();
        } else {
          transferJobsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public Builder addTransferJobs(
          com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder builderForValue) {
        if (transferJobsBuilder_ == null) {
          ensureTransferJobsIsMutable();
          transferJobs_.add(builderForValue.build());
          onChanged();
        } else {
          transferJobsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public Builder addTransferJobs(
          int index,
          com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder builderForValue) {
        if (transferJobsBuilder_ == null) {
          ensureTransferJobsIsMutable();
          transferJobs_.add(index, builderForValue.build());
          onChanged();
        } else {
          transferJobsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public Builder addAllTransferJobs(
          java.lang.Iterable<
                  ? extends com.google.storagetransfer.v1.proto.TransferTypes.TransferJob>
              values) {
        if (transferJobsBuilder_ == null) {
          ensureTransferJobsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transferJobs_);
          onChanged();
        } else {
          transferJobsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public Builder clearTransferJobs() {
        if (transferJobsBuilder_ == null) {
          transferJobs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          transferJobsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public Builder removeTransferJobs(int index) {
        if (transferJobsBuilder_ == null) {
          ensureTransferJobsIsMutable();
          transferJobs_.remove(index);
          onChanged();
        } else {
          transferJobsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder
          getTransferJobsBuilder(int index) {
        return getTransferJobsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder
          getTransferJobsOrBuilder(int index) {
        if (transferJobsBuilder_ == null) {
          return transferJobs_.get(index);
        } else {
          return transferJobsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public java.util.List<
              ? extends com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder>
          getTransferJobsOrBuilderList() {
        if (transferJobsBuilder_ != null) {
          return transferJobsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(transferJobs_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder
          addTransferJobsBuilder() {
        return getTransferJobsFieldBuilder()
            .addBuilder(
                com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder
          addTransferJobsBuilder(int index) {
        return getTransferJobsFieldBuilder()
            .addBuilder(
                index,
                com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of transfer jobs.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.TransferJob transfer_jobs = 1;</code>
       */
      public java.util.List<com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder>
          getTransferJobsBuilderList() {
        return getTransferJobsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJob,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder>
          getTransferJobsFieldBuilder() {
        if (transferJobsBuilder_ == null) {
          transferJobsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferJob,
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferJob.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.TransferJobOrBuilder>(
                  transferJobs_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          transferJobs_ = null;
        }
        return transferJobsBuilder_;
      }

      private java.lang.Object nextPageToken_ = "";
      /**
       *
       *
       * <pre>
       * The list next page token.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return The nextPageToken.
       */
      public java.lang.String getNextPageToken() {
        java.lang.Object ref = nextPageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          nextPageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The list next page token.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return The bytes for nextPageToken.
       */
      public com.google.protobuf.ByteString getNextPageTokenBytes() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          nextPageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The list next page token.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @param value The nextPageToken to set.
       * @return This builder for chaining.
       */
      public Builder setNextPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        nextPageToken_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list next page token.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNextPageToken() {

        nextPageToken_ = getDefaultInstance().getNextPageToken();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list next page token.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @param value The bytes for nextPageToken to set.
       * @return This builder for chaining.
       */
      public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        nextPageToken_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.ListTransferJobsResponse)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.ListTransferJobsResponse)
    private static final com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListTransferJobsResponse> PARSER =
        new com.google.protobuf.AbstractParser<ListTransferJobsResponse>() {
          @java.lang.Override
          public ListTransferJobsResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListTransferJobsResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListTransferJobsResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.ListTransferJobsResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PauseTransferOperationRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.PauseTransferOperationRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the transfer operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The name of the transfer operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Request passed to PauseTransferOperation.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.PauseTransferOperationRequest}
   */
  public static final class PauseTransferOperationRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.PauseTransferOperationRequest)
      PauseTransferOperationRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PauseTransferOperationRequest.newBuilder() to construct.
    private PauseTransferOperationRequest(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PauseTransferOperationRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PauseTransferOperationRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_PauseTransferOperationRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_PauseTransferOperationRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest.class,
              com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
                  .Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Required. The name of the transfer operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the transfer operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request passed to PauseTransferOperation.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.PauseTransferOperationRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.PauseTransferOperationRequest)
        com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_PauseTransferOperationRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_PauseTransferOperationRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
                    .class,
                com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
                    .Builder.class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_PauseTransferOperationRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
          build() {
        com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest(
                this);
        result.name_ = name_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer operation.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer operation.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer operation.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer operation.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer operation.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.PauseTransferOperationRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.PauseTransferOperationRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto
            .PauseTransferOperationRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PauseTransferOperationRequest> PARSER =
        new com.google.protobuf.AbstractParser<PauseTransferOperationRequest>() {
          @java.lang.Override
          public PauseTransferOperationRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PauseTransferOperationRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PauseTransferOperationRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.PauseTransferOperationRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ResumeTransferOperationRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.ResumeTransferOperationRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the transfer operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The name of the transfer operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Request passed to ResumeTransferOperation.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.ResumeTransferOperationRequest}
   */
  public static final class ResumeTransferOperationRequest
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.ResumeTransferOperationRequest)
      ResumeTransferOperationRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ResumeTransferOperationRequest.newBuilder() to construct.
    private ResumeTransferOperationRequest(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ResumeTransferOperationRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ResumeTransferOperationRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_ResumeTransferOperationRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_ResumeTransferOperationRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
                  .class,
              com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
                  .Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Required. The name of the transfer operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the transfer operation.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request passed to ResumeTransferOperation.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.ResumeTransferOperationRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.ResumeTransferOperationRequest)
        com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ResumeTransferOperationRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ResumeTransferOperationRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
                    .class,
                com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
                    .Builder.class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ResumeTransferOperationRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
          build() {
        com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest(
                this);
        result.name_ = name_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer operation.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer operation.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer operation.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer operation.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer operation.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.ResumeTransferOperationRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.ResumeTransferOperationRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto
            .ResumeTransferOperationRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ResumeTransferOperationRequest> PARSER =
        new com.google.protobuf.AbstractParser<ResumeTransferOperationRequest>() {
          @java.lang.Override
          public ResumeTransferOperationRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ResumeTransferOperationRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ResumeTransferOperationRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.ResumeTransferOperationRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RunTransferJobRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.RunTransferJobRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the transfer job.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The jobName.
     */
    java.lang.String getJobName();
    /**
     *
     *
     * <pre>
     * Required. The name of the transfer job.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for jobName.
     */
    com.google.protobuf.ByteString getJobNameBytes();

    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the transfer
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    java.lang.String getProjectId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the transfer
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    com.google.protobuf.ByteString getProjectIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Request passed to RunTransferJob.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.RunTransferJobRequest}
   */
  public static final class RunTransferJobRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.RunTransferJobRequest)
      RunTransferJobRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RunTransferJobRequest.newBuilder() to construct.
    private RunTransferJobRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RunTransferJobRequest() {
      jobName_ = "";
      projectId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RunTransferJobRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_RunTransferJobRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_RunTransferJobRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest.class,
              com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest.Builder
                  .class);
    }

    public static final int JOB_NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object jobName_;
    /**
     *
     *
     * <pre>
     * Required. The name of the transfer job.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The jobName.
     */
    @java.lang.Override
    public java.lang.String getJobName() {
      java.lang.Object ref = jobName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the transfer job.
     * </pre>
     *
     * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for jobName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJobNameBytes() {
      java.lang.Object ref = jobName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROJECT_ID_FIELD_NUMBER = 2;
    private volatile java.lang.Object projectId_;
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the transfer
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    @java.lang.Override
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the transfer
     * job.
     * </pre>
     *
     * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, jobName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, projectId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, jobName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, projectId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest) obj;

      if (!getJobName().equals(other.getJobName())) return false;
      if (!getProjectId().equals(other.getProjectId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + JOB_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getJobName().hashCode();
      hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getProjectId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Request passed to RunTransferJob.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.RunTransferJobRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.RunTransferJobRequest)
        com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_RunTransferJobRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_RunTransferJobRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest.class,
                com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        jobName_ = "";

        projectId_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_RunTransferJobRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest build() {
        com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest(this);
        result.jobName_ = jobName_;
        result.projectId_ = projectId_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest
                .getDefaultInstance()) return this;
        if (!other.getJobName().isEmpty()) {
          jobName_ = other.jobName_;
          onChanged();
        }
        if (!other.getProjectId().isEmpty()) {
          projectId_ = other.projectId_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  jobName_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  projectId_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object jobName_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer job.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The jobName.
       */
      public java.lang.String getJobName() {
        java.lang.Object ref = jobName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jobName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer job.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for jobName.
       */
      public com.google.protobuf.ByteString getJobNameBytes() {
        java.lang.Object ref = jobName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          jobName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer job.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The jobName to set.
       * @return This builder for chaining.
       */
      public Builder setJobName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        jobName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer job.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJobName() {

        jobName_ = getDefaultInstance().getJobName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the transfer job.
       * </pre>
       *
       * <code>string job_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for jobName to set.
       * @return This builder for chaining.
       */
      public Builder setJobNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        jobName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object projectId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the transfer
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The projectId.
       */
      public java.lang.String getProjectId() {
        java.lang.Object ref = projectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the transfer
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for projectId.
       */
      public com.google.protobuf.ByteString getProjectIdBytes() {
        java.lang.Object ref = projectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the transfer
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        projectId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the transfer
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectId() {

        projectId_ = getDefaultInstance().getProjectId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the transfer
       * job.
       * </pre>
       *
       * <code>string project_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        projectId_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.RunTransferJobRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.RunTransferJobRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RunTransferJobRequest> PARSER =
        new com.google.protobuf.AbstractParser<RunTransferJobRequest>() {
          @java.lang.Override
          public RunTransferJobRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RunTransferJobRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RunTransferJobRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.RunTransferJobRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CreateAgentPoolRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.CreateAgentPoolRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * agent pool.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    java.lang.String getProjectId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * agent pool.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    com.google.protobuf.ByteString getProjectIdBytes();

    /**
     *
     *
     * <pre>
     * Required. The agent pool to create.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the agentPool field is set.
     */
    boolean hasAgentPool();
    /**
     *
     *
     * <pre>
     * Required. The agent pool to create.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The agentPool.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AgentPool getAgentPool();
    /**
     *
     *
     * <pre>
     * Required. The agent pool to create.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder getAgentPoolOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The ID of the agent pool to create.
     * The `agent_pool_id` must meet the following requirements:
     * *   Length of 128 characters or less.
     * *   Not start with the string `goog`.
     * *   Start with a lowercase ASCII character, followed by:
     *     *   Zero or more: lowercase Latin alphabet characters, numerals,
     *         hyphens (`-`), periods (`.`), underscores (`_`), or tildes (`~`).
     *     *   One or more numerals or lowercase ASCII characters.
     * As expressed by the regular expression:
     * `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
     * </pre>
     *
     * <code>string agent_pool_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The agentPoolId.
     */
    java.lang.String getAgentPoolId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the agent pool to create.
     * The `agent_pool_id` must meet the following requirements:
     * *   Length of 128 characters or less.
     * *   Not start with the string `goog`.
     * *   Start with a lowercase ASCII character, followed by:
     *     *   Zero or more: lowercase Latin alphabet characters, numerals,
     *         hyphens (`-`), periods (`.`), underscores (`_`), or tildes (`~`).
     *     *   One or more numerals or lowercase ASCII characters.
     * As expressed by the regular expression:
     * `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
     * </pre>
     *
     * <code>string agent_pool_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for agentPoolId.
     */
    com.google.protobuf.ByteString getAgentPoolIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Specifies the request passed to CreateAgentPool.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.CreateAgentPoolRequest}
   */
  public static final class CreateAgentPoolRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.CreateAgentPoolRequest)
      CreateAgentPoolRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CreateAgentPoolRequest.newBuilder() to construct.
    private CreateAgentPoolRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CreateAgentPoolRequest() {
      projectId_ = "";
      agentPoolId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CreateAgentPoolRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_CreateAgentPoolRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_CreateAgentPoolRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest.class,
              com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest.Builder
                  .class);
    }

    public static final int PROJECT_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object projectId_;
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * agent pool.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    @java.lang.Override
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the
     * agent pool.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AGENT_POOL_FIELD_NUMBER = 2;
    private com.google.storagetransfer.v1.proto.TransferTypes.AgentPool agentPool_;
    /**
     *
     *
     * <pre>
     * Required. The agent pool to create.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the agentPool field is set.
     */
    @java.lang.Override
    public boolean hasAgentPool() {
      return agentPool_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The agent pool to create.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The agentPool.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool getAgentPool() {
      return agentPool_ == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.getDefaultInstance()
          : agentPool_;
    }
    /**
     *
     *
     * <pre>
     * Required. The agent pool to create.
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder
        getAgentPoolOrBuilder() {
      return getAgentPool();
    }

    public static final int AGENT_POOL_ID_FIELD_NUMBER = 3;
    private volatile java.lang.Object agentPoolId_;
    /**
     *
     *
     * <pre>
     * Required. The ID of the agent pool to create.
     * The `agent_pool_id` must meet the following requirements:
     * *   Length of 128 characters or less.
     * *   Not start with the string `goog`.
     * *   Start with a lowercase ASCII character, followed by:
     *     *   Zero or more: lowercase Latin alphabet characters, numerals,
     *         hyphens (`-`), periods (`.`), underscores (`_`), or tildes (`~`).
     *     *   One or more numerals or lowercase ASCII characters.
     * As expressed by the regular expression:
     * `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
     * </pre>
     *
     * <code>string agent_pool_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The agentPoolId.
     */
    @java.lang.Override
    public java.lang.String getAgentPoolId() {
      java.lang.Object ref = agentPoolId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agentPoolId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the agent pool to create.
     * The `agent_pool_id` must meet the following requirements:
     * *   Length of 128 characters or less.
     * *   Not start with the string `goog`.
     * *   Start with a lowercase ASCII character, followed by:
     *     *   Zero or more: lowercase Latin alphabet characters, numerals,
     *         hyphens (`-`), periods (`.`), underscores (`_`), or tildes (`~`).
     *     *   One or more numerals or lowercase ASCII characters.
     * As expressed by the regular expression:
     * `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
     * </pre>
     *
     * <code>string agent_pool_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for agentPoolId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAgentPoolIdBytes() {
      java.lang.Object ref = agentPoolId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agentPoolId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
      }
      if (agentPool_ != null) {
        output.writeMessage(2, getAgentPool());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentPoolId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, agentPoolId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
      }
      if (agentPool_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAgentPool());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentPoolId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, agentPoolId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest) obj;

      if (!getProjectId().equals(other.getProjectId())) return false;
      if (hasAgentPool() != other.hasAgentPool()) return false;
      if (hasAgentPool()) {
        if (!getAgentPool().equals(other.getAgentPool())) return false;
      }
      if (!getAgentPoolId().equals(other.getAgentPoolId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getProjectId().hashCode();
      if (hasAgentPool()) {
        hash = (37 * hash) + AGENT_POOL_FIELD_NUMBER;
        hash = (53 * hash) + getAgentPool().hashCode();
      }
      hash = (37 * hash) + AGENT_POOL_ID_FIELD_NUMBER;
      hash = (53 * hash) + getAgentPoolId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies the request passed to CreateAgentPool.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.CreateAgentPoolRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.CreateAgentPoolRequest)
        com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_CreateAgentPoolRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_CreateAgentPoolRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest.class,
                com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        projectId_ = "";

        if (agentPoolBuilder_ == null) {
          agentPool_ = null;
        } else {
          agentPool_ = null;
          agentPoolBuilder_ = null;
        }
        agentPoolId_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_CreateAgentPoolRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest build() {
        com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest(this);
        result.projectId_ = projectId_;
        if (agentPoolBuilder_ == null) {
          result.agentPool_ = agentPool_;
        } else {
          result.agentPool_ = agentPoolBuilder_.build();
        }
        result.agentPoolId_ = agentPoolId_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
                .getDefaultInstance()) return this;
        if (!other.getProjectId().isEmpty()) {
          projectId_ = other.projectId_;
          onChanged();
        }
        if (other.hasAgentPool()) {
          mergeAgentPool(other.getAgentPool());
        }
        if (!other.getAgentPoolId().isEmpty()) {
          agentPoolId_ = other.agentPoolId_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  projectId_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getAgentPoolFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              case 26:
                {
                  agentPoolId_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object projectId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * agent pool.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The projectId.
       */
      public java.lang.String getProjectId() {
        java.lang.Object ref = projectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * agent pool.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for projectId.
       */
      public com.google.protobuf.ByteString getProjectIdBytes() {
        java.lang.Object ref = projectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * agent pool.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        projectId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * agent pool.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectId() {

        projectId_ = getDefaultInstance().getProjectId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the
       * agent pool.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        projectId_ = value;
        onChanged();
        return this;
      }

      private com.google.storagetransfer.v1.proto.TransferTypes.AgentPool agentPool_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder>
          agentPoolBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The agent pool to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the agentPool field is set.
       */
      public boolean hasAgentPool() {
        return agentPoolBuilder_ != null || agentPool_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The agentPool.
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool getAgentPool() {
        if (agentPoolBuilder_ == null) {
          return agentPool_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.getDefaultInstance()
              : agentPool_;
        } else {
          return agentPoolBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setAgentPool(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool value) {
        if (agentPoolBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          agentPool_ = value;
          onChanged();
        } else {
          agentPoolBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setAgentPool(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder builderForValue) {
        if (agentPoolBuilder_ == null) {
          agentPool_ = builderForValue.build();
          onChanged();
        } else {
          agentPoolBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeAgentPool(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool value) {
        if (agentPoolBuilder_ == null) {
          if (agentPool_ != null) {
            agentPool_ =
                com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.newBuilder(agentPool_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            agentPool_ = value;
          }
          onChanged();
        } else {
          agentPoolBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearAgentPool() {
        if (agentPoolBuilder_ == null) {
          agentPool_ = null;
          onChanged();
        } else {
          agentPool_ = null;
          agentPoolBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder
          getAgentPoolBuilder() {

        onChanged();
        return getAgentPoolFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder
          getAgentPoolOrBuilder() {
        if (agentPoolBuilder_ != null) {
          return agentPoolBuilder_.getMessageOrBuilder();
        } else {
          return agentPool_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.getDefaultInstance()
              : agentPool_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to create.
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder>
          getAgentPoolFieldBuilder() {
        if (agentPoolBuilder_ == null) {
          agentPoolBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPool,
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder>(
                  getAgentPool(), getParentForChildren(), isClean());
          agentPool_ = null;
        }
        return agentPoolBuilder_;
      }

      private java.lang.Object agentPoolId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the agent pool to create.
       * The `agent_pool_id` must meet the following requirements:
       * *   Length of 128 characters or less.
       * *   Not start with the string `goog`.
       * *   Start with a lowercase ASCII character, followed by:
       *     *   Zero or more: lowercase Latin alphabet characters, numerals,
       *         hyphens (`-`), periods (`.`), underscores (`_`), or tildes (`~`).
       *     *   One or more numerals or lowercase ASCII characters.
       * As expressed by the regular expression:
       * `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
       * </pre>
       *
       * <code>string agent_pool_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The agentPoolId.
       */
      public java.lang.String getAgentPoolId() {
        java.lang.Object ref = agentPoolId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          agentPoolId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the agent pool to create.
       * The `agent_pool_id` must meet the following requirements:
       * *   Length of 128 characters or less.
       * *   Not start with the string `goog`.
       * *   Start with a lowercase ASCII character, followed by:
       *     *   Zero or more: lowercase Latin alphabet characters, numerals,
       *         hyphens (`-`), periods (`.`), underscores (`_`), or tildes (`~`).
       *     *   One or more numerals or lowercase ASCII characters.
       * As expressed by the regular expression:
       * `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
       * </pre>
       *
       * <code>string agent_pool_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for agentPoolId.
       */
      public com.google.protobuf.ByteString getAgentPoolIdBytes() {
        java.lang.Object ref = agentPoolId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          agentPoolId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the agent pool to create.
       * The `agent_pool_id` must meet the following requirements:
       * *   Length of 128 characters or less.
       * *   Not start with the string `goog`.
       * *   Start with a lowercase ASCII character, followed by:
       *     *   Zero or more: lowercase Latin alphabet characters, numerals,
       *         hyphens (`-`), periods (`.`), underscores (`_`), or tildes (`~`).
       *     *   One or more numerals or lowercase ASCII characters.
       * As expressed by the regular expression:
       * `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
       * </pre>
       *
       * <code>string agent_pool_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The agentPoolId to set.
       * @return This builder for chaining.
       */
      public Builder setAgentPoolId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        agentPoolId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the agent pool to create.
       * The `agent_pool_id` must meet the following requirements:
       * *   Length of 128 characters or less.
       * *   Not start with the string `goog`.
       * *   Start with a lowercase ASCII character, followed by:
       *     *   Zero or more: lowercase Latin alphabet characters, numerals,
       *         hyphens (`-`), periods (`.`), underscores (`_`), or tildes (`~`).
       *     *   One or more numerals or lowercase ASCII characters.
       * As expressed by the regular expression:
       * `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
       * </pre>
       *
       * <code>string agent_pool_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAgentPoolId() {

        agentPoolId_ = getDefaultInstance().getAgentPoolId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the agent pool to create.
       * The `agent_pool_id` must meet the following requirements:
       * *   Length of 128 characters or less.
       * *   Not start with the string `goog`.
       * *   Start with a lowercase ASCII character, followed by:
       *     *   Zero or more: lowercase Latin alphabet characters, numerals,
       *         hyphens (`-`), periods (`.`), underscores (`_`), or tildes (`~`).
       *     *   One or more numerals or lowercase ASCII characters.
       * As expressed by the regular expression:
       * `^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$`.
       * </pre>
       *
       * <code>string agent_pool_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for agentPoolId to set.
       * @return This builder for chaining.
       */
      public Builder setAgentPoolIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        agentPoolId_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.CreateAgentPoolRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.CreateAgentPoolRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CreateAgentPoolRequest> PARSER =
        new com.google.protobuf.AbstractParser<CreateAgentPoolRequest>() {
          @java.lang.Override
          public CreateAgentPoolRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CreateAgentPoolRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CreateAgentPoolRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.CreateAgentPoolRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UpdateAgentPoolRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.UpdateAgentPoolRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The agent pool to update. `agent_pool` is expected to specify following
     * fields:
     * *  [name][google.storagetransfer.v1.AgentPool.name]
     * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
     * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
     * An `UpdateAgentPoolRequest` with any other fields is rejected
     * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the agentPool field is set.
     */
    boolean hasAgentPool();
    /**
     *
     *
     * <pre>
     * Required. The agent pool to update. `agent_pool` is expected to specify following
     * fields:
     * *  [name][google.storagetransfer.v1.AgentPool.name]
     * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
     * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
     * An `UpdateAgentPoolRequest` with any other fields is rejected
     * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The agentPool.
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AgentPool getAgentPool();
    /**
     *
     *
     * <pre>
     * Required. The agent pool to update. `agent_pool` is expected to specify following
     * fields:
     * *  [name][google.storagetransfer.v1.AgentPool.name]
     * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
     * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
     * An `UpdateAgentPoolRequest` with any other fields is rejected
     * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder getAgentPoolOrBuilder();

    /**
     *
     *
     * <pre>
     * The [field mask]
     * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
     * of the fields in `agentPool` to update in this request.
     * The following `agentPool` fields can be updated:
     * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
     * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     *
     * @return Whether the updateMask field is set.
     */
    boolean hasUpdateMask();
    /**
     *
     *
     * <pre>
     * The [field mask]
     * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
     * of the fields in `agentPool` to update in this request.
     * The following `agentPool` fields can be updated:
     * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
     * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     *
     * @return The updateMask.
     */
    com.google.protobuf.FieldMask getUpdateMask();
    /**
     *
     *
     * <pre>
     * The [field mask]
     * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
     * of the fields in `agentPool` to update in this request.
     * The following `agentPool` fields can be updated:
     * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
     * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     */
    com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Specifies the request passed to UpdateAgentPool.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.UpdateAgentPoolRequest}
   */
  public static final class UpdateAgentPoolRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.UpdateAgentPoolRequest)
      UpdateAgentPoolRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UpdateAgentPoolRequest.newBuilder() to construct.
    private UpdateAgentPoolRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UpdateAgentPoolRequest() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UpdateAgentPoolRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_UpdateAgentPoolRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_UpdateAgentPoolRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest.class,
              com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest.Builder
                  .class);
    }

    public static final int AGENT_POOL_FIELD_NUMBER = 1;
    private com.google.storagetransfer.v1.proto.TransferTypes.AgentPool agentPool_;
    /**
     *
     *
     * <pre>
     * Required. The agent pool to update. `agent_pool` is expected to specify following
     * fields:
     * *  [name][google.storagetransfer.v1.AgentPool.name]
     * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
     * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
     * An `UpdateAgentPoolRequest` with any other fields is rejected
     * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the agentPool field is set.
     */
    @java.lang.Override
    public boolean hasAgentPool() {
      return agentPool_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The agent pool to update. `agent_pool` is expected to specify following
     * fields:
     * *  [name][google.storagetransfer.v1.AgentPool.name]
     * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
     * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
     * An `UpdateAgentPoolRequest` with any other fields is rejected
     * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The agentPool.
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool getAgentPool() {
      return agentPool_ == null
          ? com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.getDefaultInstance()
          : agentPool_;
    }
    /**
     *
     *
     * <pre>
     * Required. The agent pool to update. `agent_pool` is expected to specify following
     * fields:
     * *  [name][google.storagetransfer.v1.AgentPool.name]
     * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
     * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
     * An `UpdateAgentPoolRequest` with any other fields is rejected
     * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
     * </pre>
     *
     * <code>
     * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder
        getAgentPoolOrBuilder() {
      return getAgentPool();
    }

    public static final int UPDATE_MASK_FIELD_NUMBER = 2;
    private com.google.protobuf.FieldMask updateMask_;
    /**
     *
     *
     * <pre>
     * The [field mask]
     * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
     * of the fields in `agentPool` to update in this request.
     * The following `agentPool` fields can be updated:
     * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
     * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     *
     * @return Whether the updateMask field is set.
     */
    @java.lang.Override
    public boolean hasUpdateMask() {
      return updateMask_ != null;
    }
    /**
     *
     *
     * <pre>
     * The [field mask]
     * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
     * of the fields in `agentPool` to update in this request.
     * The following `agentPool` fields can be updated:
     * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
     * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     *
     * @return The updateMask.
     */
    @java.lang.Override
    public com.google.protobuf.FieldMask getUpdateMask() {
      return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
    }
    /**
     *
     *
     * <pre>
     * The [field mask]
     * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
     * of the fields in `agentPool` to update in this request.
     * The following `agentPool` fields can be updated:
     * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
     * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      return getUpdateMask();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (agentPool_ != null) {
        output.writeMessage(1, getAgentPool());
      }
      if (updateMask_ != null) {
        output.writeMessage(2, getUpdateMask());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (agentPool_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAgentPool());
      }
      if (updateMask_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdateMask());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest) obj;

      if (hasAgentPool() != other.hasAgentPool()) return false;
      if (hasAgentPool()) {
        if (!getAgentPool().equals(other.getAgentPool())) return false;
      }
      if (hasUpdateMask() != other.hasUpdateMask()) return false;
      if (hasUpdateMask()) {
        if (!getUpdateMask().equals(other.getUpdateMask())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAgentPool()) {
        hash = (37 * hash) + AGENT_POOL_FIELD_NUMBER;
        hash = (53 * hash) + getAgentPool().hashCode();
      }
      if (hasUpdateMask()) {
        hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateMask().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies the request passed to UpdateAgentPool.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.UpdateAgentPoolRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.UpdateAgentPoolRequest)
        com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_UpdateAgentPoolRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_UpdateAgentPoolRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest.class,
                com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (agentPoolBuilder_ == null) {
          agentPool_ = null;
        } else {
          agentPool_ = null;
          agentPoolBuilder_ = null;
        }
        if (updateMaskBuilder_ == null) {
          updateMask_ = null;
        } else {
          updateMask_ = null;
          updateMaskBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_UpdateAgentPoolRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest build() {
        com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest(this);
        if (agentPoolBuilder_ == null) {
          result.agentPool_ = agentPool_;
        } else {
          result.agentPool_ = agentPoolBuilder_.build();
        }
        if (updateMaskBuilder_ == null) {
          result.updateMask_ = updateMask_;
        } else {
          result.updateMask_ = updateMaskBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
                .getDefaultInstance()) return this;
        if (other.hasAgentPool()) {
          mergeAgentPool(other.getAgentPool());
        }
        if (other.hasUpdateMask()) {
          mergeUpdateMask(other.getUpdateMask());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getAgentPoolFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.storagetransfer.v1.proto.TransferTypes.AgentPool agentPool_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder>
          agentPoolBuilder_;
      /**
       *
       *
       * <pre>
       * Required. The agent pool to update. `agent_pool` is expected to specify following
       * fields:
       * *  [name][google.storagetransfer.v1.AgentPool.name]
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * An `UpdateAgentPoolRequest` with any other fields is rejected
       * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the agentPool field is set.
       */
      public boolean hasAgentPool() {
        return agentPoolBuilder_ != null || agentPool_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to update. `agent_pool` is expected to specify following
       * fields:
       * *  [name][google.storagetransfer.v1.AgentPool.name]
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * An `UpdateAgentPoolRequest` with any other fields is rejected
       * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The agentPool.
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool getAgentPool() {
        if (agentPoolBuilder_ == null) {
          return agentPool_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.getDefaultInstance()
              : agentPool_;
        } else {
          return agentPoolBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to update. `agent_pool` is expected to specify following
       * fields:
       * *  [name][google.storagetransfer.v1.AgentPool.name]
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * An `UpdateAgentPoolRequest` with any other fields is rejected
       * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setAgentPool(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool value) {
        if (agentPoolBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          agentPool_ = value;
          onChanged();
        } else {
          agentPoolBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to update. `agent_pool` is expected to specify following
       * fields:
       * *  [name][google.storagetransfer.v1.AgentPool.name]
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * An `UpdateAgentPoolRequest` with any other fields is rejected
       * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setAgentPool(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder builderForValue) {
        if (agentPoolBuilder_ == null) {
          agentPool_ = builderForValue.build();
          onChanged();
        } else {
          agentPoolBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to update. `agent_pool` is expected to specify following
       * fields:
       * *  [name][google.storagetransfer.v1.AgentPool.name]
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * An `UpdateAgentPoolRequest` with any other fields is rejected
       * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeAgentPool(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool value) {
        if (agentPoolBuilder_ == null) {
          if (agentPool_ != null) {
            agentPool_ =
                com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.newBuilder(agentPool_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            agentPool_ = value;
          }
          onChanged();
        } else {
          agentPoolBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to update. `agent_pool` is expected to specify following
       * fields:
       * *  [name][google.storagetransfer.v1.AgentPool.name]
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * An `UpdateAgentPoolRequest` with any other fields is rejected
       * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearAgentPool() {
        if (agentPoolBuilder_ == null) {
          agentPool_ = null;
          onChanged();
        } else {
          agentPool_ = null;
          agentPoolBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to update. `agent_pool` is expected to specify following
       * fields:
       * *  [name][google.storagetransfer.v1.AgentPool.name]
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * An `UpdateAgentPoolRequest` with any other fields is rejected
       * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder
          getAgentPoolBuilder() {

        onChanged();
        return getAgentPoolFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to update. `agent_pool` is expected to specify following
       * fields:
       * *  [name][google.storagetransfer.v1.AgentPool.name]
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * An `UpdateAgentPoolRequest` with any other fields is rejected
       * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder
          getAgentPoolOrBuilder() {
        if (agentPoolBuilder_ != null) {
          return agentPoolBuilder_.getMessageOrBuilder();
        } else {
          return agentPool_ == null
              ? com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.getDefaultInstance()
              : agentPool_;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The agent pool to update. `agent_pool` is expected to specify following
       * fields:
       * *  [name][google.storagetransfer.v1.AgentPool.name]
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * An `UpdateAgentPoolRequest` with any other fields is rejected
       * with the error [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
       * </pre>
       *
       * <code>
       * .google.storagetransfer.v1.AgentPool agent_pool = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder>
          getAgentPoolFieldBuilder() {
        if (agentPoolBuilder_ == null) {
          agentPoolBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPool,
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder>(
                  getAgentPool(), getParentForChildren(), isClean());
          agentPool_ = null;
        }
        return agentPoolBuilder_;
      }

      private com.google.protobuf.FieldMask updateMask_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder,
              com.google.protobuf.FieldMaskOrBuilder>
          updateMaskBuilder_;
      /**
       *
       *
       * <pre>
       * The [field mask]
       * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
       * of the fields in `agentPool` to update in this request.
       * The following `agentPool` fields can be updated:
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2;</code>
       *
       * @return Whether the updateMask field is set.
       */
      public boolean hasUpdateMask() {
        return updateMaskBuilder_ != null || updateMask_ != null;
      }
      /**
       *
       *
       * <pre>
       * The [field mask]
       * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
       * of the fields in `agentPool` to update in this request.
       * The following `agentPool` fields can be updated:
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2;</code>
       *
       * @return The updateMask.
       */
      public com.google.protobuf.FieldMask getUpdateMask() {
        if (updateMaskBuilder_ == null) {
          return updateMask_ == null
              ? com.google.protobuf.FieldMask.getDefaultInstance()
              : updateMask_;
        } else {
          return updateMaskBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The [field mask]
       * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
       * of the fields in `agentPool` to update in this request.
       * The following `agentPool` fields can be updated:
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2;</code>
       */
      public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
        if (updateMaskBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateMask_ = value;
          onChanged();
        } else {
          updateMaskBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The [field mask]
       * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
       * of the fields in `agentPool` to update in this request.
       * The following `agentPool` fields can be updated:
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2;</code>
       */
      public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
        if (updateMaskBuilder_ == null) {
          updateMask_ = builderForValue.build();
          onChanged();
        } else {
          updateMaskBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The [field mask]
       * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
       * of the fields in `agentPool` to update in this request.
       * The following `agentPool` fields can be updated:
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2;</code>
       */
      public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
        if (updateMaskBuilder_ == null) {
          if (updateMask_ != null) {
            updateMask_ =
                com.google.protobuf.FieldMask.newBuilder(updateMask_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            updateMask_ = value;
          }
          onChanged();
        } else {
          updateMaskBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The [field mask]
       * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
       * of the fields in `agentPool` to update in this request.
       * The following `agentPool` fields can be updated:
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2;</code>
       */
      public Builder clearUpdateMask() {
        if (updateMaskBuilder_ == null) {
          updateMask_ = null;
          onChanged();
        } else {
          updateMask_ = null;
          updateMaskBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The [field mask]
       * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
       * of the fields in `agentPool` to update in this request.
       * The following `agentPool` fields can be updated:
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2;</code>
       */
      public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {

        onChanged();
        return getUpdateMaskFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The [field mask]
       * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
       * of the fields in `agentPool` to update in this request.
       * The following `agentPool` fields can be updated:
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2;</code>
       */
      public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
        if (updateMaskBuilder_ != null) {
          return updateMaskBuilder_.getMessageOrBuilder();
        } else {
          return updateMask_ == null
              ? com.google.protobuf.FieldMask.getDefaultInstance()
              : updateMask_;
        }
      }
      /**
       *
       *
       * <pre>
       * The [field mask]
       * (https://developers.google.com/protocol-buffers/docs/reference/google.protobuf)
       * of the fields in `agentPool` to update in this request.
       * The following `agentPool` fields can be updated:
       * *  [display_name][google.storagetransfer.v1.AgentPool.display_name]
       * *  [bandwidth_limit][google.storagetransfer.v1.AgentPool.bandwidth_limit]
       * </pre>
       *
       * <code>.google.protobuf.FieldMask update_mask = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.FieldMask,
              com.google.protobuf.FieldMask.Builder,
              com.google.protobuf.FieldMaskOrBuilder>
          getUpdateMaskFieldBuilder() {
        if (updateMaskBuilder_ == null) {
          updateMaskBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.FieldMask,
                  com.google.protobuf.FieldMask.Builder,
                  com.google.protobuf.FieldMaskOrBuilder>(
                  getUpdateMask(), getParentForChildren(), isClean());
          updateMask_ = null;
        }
        return updateMaskBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.UpdateAgentPoolRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.UpdateAgentPoolRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UpdateAgentPoolRequest> PARSER =
        new com.google.protobuf.AbstractParser<UpdateAgentPoolRequest>() {
          @java.lang.Override
          public UpdateAgentPoolRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UpdateAgentPoolRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UpdateAgentPoolRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.UpdateAgentPoolRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GetAgentPoolRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.GetAgentPoolRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the agent pool to get.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The name of the agent pool to get.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Specifies the request passed to GetAgentPool.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.GetAgentPoolRequest}
   */
  public static final class GetAgentPoolRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.GetAgentPoolRequest)
      GetAgentPoolRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GetAgentPoolRequest.newBuilder() to construct.
    private GetAgentPoolRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GetAgentPoolRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GetAgentPoolRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_GetAgentPoolRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_GetAgentPoolRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest.class,
              com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Required. The name of the agent pool to get.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent pool to get.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies the request passed to GetAgentPool.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.GetAgentPoolRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.GetAgentPoolRequest)
        com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_GetAgentPoolRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_GetAgentPoolRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest.class,
                com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_GetAgentPoolRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest build() {
        com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest(this);
        result.name_ = name_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the agent pool to get.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the agent pool to get.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the agent pool to get.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the agent pool to get.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the agent pool to get.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.GetAgentPoolRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.GetAgentPoolRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GetAgentPoolRequest> PARSER =
        new com.google.protobuf.AbstractParser<GetAgentPoolRequest>() {
          @java.lang.Override
          public GetAgentPoolRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GetAgentPoolRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetAgentPoolRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.GetAgentPoolRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeleteAgentPoolRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.DeleteAgentPoolRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of the agent pool to delete.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required. The name of the agent pool to delete.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Specifies the request passed to DeleteAgentPool.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.DeleteAgentPoolRequest}
   */
  public static final class DeleteAgentPoolRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.DeleteAgentPoolRequest)
      DeleteAgentPoolRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeleteAgentPoolRequest.newBuilder() to construct.
    private DeleteAgentPoolRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeleteAgentPoolRequest() {
      name_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeleteAgentPoolRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_DeleteAgentPoolRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_DeleteAgentPoolRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest.class,
              com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest.Builder
                  .class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Required. The name of the agent pool to delete.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent pool to delete.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies the request passed to DeleteAgentPool.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.DeleteAgentPoolRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.DeleteAgentPoolRequest)
        com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_DeleteAgentPoolRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_DeleteAgentPoolRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest.class,
                com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_DeleteAgentPoolRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest build() {
        com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest(this);
        result.name_ = name_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the agent pool to delete.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the agent pool to delete.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the agent pool to delete.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the agent pool to delete.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {

        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the agent pool to delete.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        name_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.DeleteAgentPoolRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.DeleteAgentPoolRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeleteAgentPoolRequest> PARSER =
        new com.google.protobuf.AbstractParser<DeleteAgentPoolRequest>() {
          @java.lang.Override
          public DeleteAgentPoolRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeleteAgentPoolRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeleteAgentPoolRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.DeleteAgentPoolRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ListAgentPoolsRequestOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.ListAgentPoolsRequest)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the job.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    java.lang.String getProjectId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the job.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    com.google.protobuf.ByteString getProjectIdBytes();

    /**
     *
     *
     * <pre>
     * An optional list of query parameters specified as JSON text in the
     * form of:
     * `{"agentPoolNames":["agentpool1","agentpool2",...]}`
     * Since `agentPoolNames` support multiple values, its values must be
     * specified with array notation. When the filter is either empty or not
     * provided, the list returns all agent pools for the project.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();
    /**
     *
     *
     * <pre>
     * An optional list of query parameters specified as JSON text in the
     * form of:
     * `{"agentPoolNames":["agentpool1","agentpool2",...]}`
     * Since `agentPoolNames` support multiple values, its values must be
     * specified with array notation. When the filter is either empty or not
     * provided, the list returns all agent pools for the project.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();

    /**
     *
     *
     * <pre>
     * The list page size. The max allowed value is `256`.
     * </pre>
     *
     * <code>int32 page_size = 3;</code>
     *
     * @return The pageSize.
     */
    int getPageSize();

    /**
     *
     *
     * <pre>
     * The list page token.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The pageToken.
     */
    java.lang.String getPageToken();
    /**
     *
     *
     * <pre>
     * The list page token.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The bytes for pageToken.
     */
    com.google.protobuf.ByteString getPageTokenBytes();
  }
  /**
   *
   *
   * <pre>
   * The request passed to ListAgentPools.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.ListAgentPoolsRequest}
   */
  public static final class ListAgentPoolsRequest extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.ListAgentPoolsRequest)
      ListAgentPoolsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListAgentPoolsRequest.newBuilder() to construct.
    private ListAgentPoolsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListAgentPoolsRequest() {
      projectId_ = "";
      filter_ = "";
      pageToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListAgentPoolsRequest();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_ListAgentPoolsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_ListAgentPoolsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest.class,
              com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest.Builder
                  .class);
    }

    public static final int PROJECT_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object projectId_;
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the job.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    @java.lang.Override
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the Google Cloud project that owns the job.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FILTER_FIELD_NUMBER = 2;
    private volatile java.lang.Object filter_;
    /**
     *
     *
     * <pre>
     * An optional list of query parameters specified as JSON text in the
     * form of:
     * `{"agentPoolNames":["agentpool1","agentpool2",...]}`
     * Since `agentPoolNames` support multiple values, its values must be
     * specified with array notation. When the filter is either empty or not
     * provided, the list returns all agent pools for the project.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional list of query parameters specified as JSON text in the
     * form of:
     * `{"agentPoolNames":["agentpool1","agentpool2",...]}`
     * Since `agentPoolNames` support multiple values, its values must be
     * specified with array notation. When the filter is either empty or not
     * provided, the list returns all agent pools for the project.
     * </pre>
     *
     * <code>string filter = 2;</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PAGE_SIZE_FIELD_NUMBER = 3;
    private int pageSize_;
    /**
     *
     *
     * <pre>
     * The list page size. The max allowed value is `256`.
     * </pre>
     *
     * <code>int32 page_size = 3;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    public static final int PAGE_TOKEN_FIELD_NUMBER = 4;
    private volatile java.lang.Object pageToken_;
    /**
     *
     *
     * <pre>
     * The list page token.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The pageToken.
     */
    @java.lang.Override
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The list page token.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The bytes for pageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
      }
      if (pageSize_ != 0) {
        output.writeInt32(3, pageSize_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pageToken_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
      }
      if (pageSize_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, pageSize_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pageToken_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest other =
          (com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest) obj;

      if (!getProjectId().equals(other.getProjectId())) return false;
      if (!getFilter().equals(other.getFilter())) return false;
      if (getPageSize() != other.getPageSize()) return false;
      if (!getPageToken().equals(other.getPageToken())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getProjectId().hashCode();
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getPageSize();
      hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getPageToken().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The request passed to ListAgentPools.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.ListAgentPoolsRequest}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.ListAgentPoolsRequest)
        com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ListAgentPoolsRequest_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ListAgentPoolsRequest_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest.class,
                com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        projectId_ = "";

        filter_ = "";

        pageSize_ = 0;

        pageToken_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ListAgentPoolsRequest_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest build() {
        com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest result =
            new com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest(this);
        result.projectId_ = projectId_;
        result.filter_ = filter_;
        result.pageSize_ = pageSize_;
        result.pageToken_ = pageToken_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest
                .getDefaultInstance()) return this;
        if (!other.getProjectId().isEmpty()) {
          projectId_ = other.projectId_;
          onChanged();
        }
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          onChanged();
        }
        if (other.getPageSize() != 0) {
          setPageSize(other.getPageSize());
        }
        if (!other.getPageToken().isEmpty()) {
          pageToken_ = other.pageToken_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  projectId_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  filter_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 24:
                {
                  pageSize_ = input.readInt32();

                  break;
                } // case 24
              case 34:
                {
                  pageToken_ = input.readStringRequireUtf8();

                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object projectId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the job.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The projectId.
       */
      public java.lang.String getProjectId() {
        java.lang.Object ref = projectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the job.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for projectId.
       */
      public com.google.protobuf.ByteString getProjectIdBytes() {
        java.lang.Object ref = projectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the job.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        projectId_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the job.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectId() {

        projectId_ = getDefaultInstance().getProjectId();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the Google Cloud project that owns the job.
       * </pre>
       *
       * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        projectId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * An optional list of query parameters specified as JSON text in the
       * form of:
       * `{"agentPoolNames":["agentpool1","agentpool2",...]}`
       * Since `agentPoolNames` support multiple values, its values must be
       * specified with array notation. When the filter is either empty or not
       * provided, the list returns all agent pools for the project.
       * </pre>
       *
       * <code>string filter = 2;</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An optional list of query parameters specified as JSON text in the
       * form of:
       * `{"agentPoolNames":["agentpool1","agentpool2",...]}`
       * Since `agentPoolNames` support multiple values, its values must be
       * specified with array notation. When the filter is either empty or not
       * provided, the list returns all agent pools for the project.
       * </pre>
       *
       * <code>string filter = 2;</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * An optional list of query parameters specified as JSON text in the
       * form of:
       * `{"agentPoolNames":["agentpool1","agentpool2",...]}`
       * Since `agentPoolNames` support multiple values, its values must be
       * specified with array notation. When the filter is either empty or not
       * provided, the list returns all agent pools for the project.
       * </pre>
       *
       * <code>string filter = 2;</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        filter_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An optional list of query parameters specified as JSON text in the
       * form of:
       * `{"agentPoolNames":["agentpool1","agentpool2",...]}`
       * Since `agentPoolNames` support multiple values, its values must be
       * specified with array notation. When the filter is either empty or not
       * provided, the list returns all agent pools for the project.
       * </pre>
       *
       * <code>string filter = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {

        filter_ = getDefaultInstance().getFilter();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * An optional list of query parameters specified as JSON text in the
       * form of:
       * `{"agentPoolNames":["agentpool1","agentpool2",...]}`
       * Since `agentPoolNames` support multiple values, its values must be
       * specified with array notation. When the filter is either empty or not
       * provided, the list returns all agent pools for the project.
       * </pre>
       *
       * <code>string filter = 2;</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        filter_ = value;
        onChanged();
        return this;
      }

      private int pageSize_;
      /**
       *
       *
       * <pre>
       * The list page size. The max allowed value is `256`.
       * </pre>
       *
       * <code>int32 page_size = 3;</code>
       *
       * @return The pageSize.
       */
      @java.lang.Override
      public int getPageSize() {
        return pageSize_;
      }
      /**
       *
       *
       * <pre>
       * The list page size. The max allowed value is `256`.
       * </pre>
       *
       * <code>int32 page_size = 3;</code>
       *
       * @param value The pageSize to set.
       * @return This builder for chaining.
       */
      public Builder setPageSize(int value) {

        pageSize_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list page size. The max allowed value is `256`.
       * </pre>
       *
       * <code>int32 page_size = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageSize() {

        pageSize_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object pageToken_ = "";
      /**
       *
       *
       * <pre>
       * The list page token.
       * </pre>
       *
       * <code>string page_token = 4;</code>
       *
       * @return The pageToken.
       */
      public java.lang.String getPageToken() {
        java.lang.Object ref = pageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The list page token.
       * </pre>
       *
       * <code>string page_token = 4;</code>
       *
       * @return The bytes for pageToken.
       */
      public com.google.protobuf.ByteString getPageTokenBytes() {
        java.lang.Object ref = pageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The list page token.
       * </pre>
       *
       * <code>string page_token = 4;</code>
       *
       * @param value The pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        pageToken_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list page token.
       * </pre>
       *
       * <code>string page_token = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageToken() {

        pageToken_ = getDefaultInstance().getPageToken();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list page token.
       * </pre>
       *
       * <code>string page_token = 4;</code>
       *
       * @param value The bytes for pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        pageToken_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.ListAgentPoolsRequest)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.ListAgentPoolsRequest)
    private static final com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListAgentPoolsRequest> PARSER =
        new com.google.protobuf.AbstractParser<ListAgentPoolsRequest>() {
          @java.lang.Override
          public ListAgentPoolsRequest parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListAgentPoolsRequest> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListAgentPoolsRequest> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsRequest
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ListAgentPoolsResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storagetransfer.v1.ListAgentPoolsResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of agent pools.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
     */
    java.util.List<com.google.storagetransfer.v1.proto.TransferTypes.AgentPool> getAgentPoolsList();
    /**
     *
     *
     * <pre>
     * A list of agent pools.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AgentPool getAgentPools(int index);
    /**
     *
     *
     * <pre>
     * A list of agent pools.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
     */
    int getAgentPoolsCount();
    /**
     *
     *
     * <pre>
     * A list of agent pools.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
     */
    java.util.List<? extends com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder>
        getAgentPoolsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of agent pools.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
     */
    com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder getAgentPoolsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * The list next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    java.lang.String getNextPageToken();
    /**
     *
     *
     * <pre>
     * The list next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    com.google.protobuf.ByteString getNextPageTokenBytes();
  }
  /**
   *
   *
   * <pre>
   * Response from ListAgentPools.
   * </pre>
   *
   * Protobuf type {@code google.storagetransfer.v1.ListAgentPoolsResponse}
   */
  public static final class ListAgentPoolsResponse extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storagetransfer.v1.ListAgentPoolsResponse)
      ListAgentPoolsResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ListAgentPoolsResponse.newBuilder() to construct.
    private ListAgentPoolsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ListAgentPoolsResponse() {
      agentPools_ = java.util.Collections.emptyList();
      nextPageToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ListAgentPoolsResponse();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_ListAgentPoolsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storagetransfer.v1.proto.TransferProto
          .internal_static_google_storagetransfer_v1_ListAgentPoolsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse.class,
              com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse.Builder
                  .class);
    }

    public static final int AGENT_POOLS_FIELD_NUMBER = 1;
    private java.util.List<com.google.storagetransfer.v1.proto.TransferTypes.AgentPool> agentPools_;
    /**
     *
     *
     * <pre>
     * A list of agent pools.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.storagetransfer.v1.proto.TransferTypes.AgentPool>
        getAgentPoolsList() {
      return agentPools_;
    }
    /**
     *
     *
     * <pre>
     * A list of agent pools.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder>
        getAgentPoolsOrBuilderList() {
      return agentPools_;
    }
    /**
     *
     *
     * <pre>
     * A list of agent pools.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
     */
    @java.lang.Override
    public int getAgentPoolsCount() {
      return agentPools_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of agent pools.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool getAgentPools(int index) {
      return agentPools_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of agent pools.
     * </pre>
     *
     * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
     */
    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder
        getAgentPoolsOrBuilder(int index) {
      return agentPools_.get(index);
    }

    public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;
    private volatile java.lang.Object nextPageToken_;
    /**
     *
     *
     * <pre>
     * The list next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    @java.lang.Override
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The list next page token.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < agentPools_.size(); i++) {
        output.writeMessage(1, agentPools_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < agentPools_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, agentPools_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse)) {
        return super.equals(obj);
      }
      com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse other =
          (com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse) obj;

      if (!getAgentPoolsList().equals(other.getAgentPoolsList())) return false;
      if (!getNextPageToken().equals(other.getNextPageToken())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAgentPoolsCount() > 0) {
        hash = (37 * hash) + AGENT_POOLS_FIELD_NUMBER;
        hash = (53 * hash) + getAgentPoolsList().hashCode();
      }
      hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getNextPageToken().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Response from ListAgentPools.
     * </pre>
     *
     * Protobuf type {@code google.storagetransfer.v1.ListAgentPoolsResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storagetransfer.v1.ListAgentPoolsResponse)
        com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ListAgentPoolsResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ListAgentPoolsResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse.class,
                com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse.Builder
                    .class);
      }

      // Construct using
      // com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (agentPoolsBuilder_ == null) {
          agentPools_ = java.util.Collections.emptyList();
        } else {
          agentPools_ = null;
          agentPoolsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        nextPageToken_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storagetransfer.v1.proto.TransferProto
            .internal_static_google_storagetransfer_v1_ListAgentPoolsResponse_descriptor;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
          getDefaultInstanceForType() {
        return com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse build() {
        com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
          buildPartial() {
        com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse result =
            new com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse(this);
        int from_bitField0_ = bitField0_;
        if (agentPoolsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            agentPools_ = java.util.Collections.unmodifiableList(agentPools_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.agentPools_ = agentPools_;
        } else {
          result.agentPools_ = agentPoolsBuilder_.build();
        }
        result.nextPageToken_ = nextPageToken_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse) {
          return mergeFrom(
              (com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse other) {
        if (other
            == com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
                .getDefaultInstance()) return this;
        if (agentPoolsBuilder_ == null) {
          if (!other.agentPools_.isEmpty()) {
            if (agentPools_.isEmpty()) {
              agentPools_ = other.agentPools_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureAgentPoolsIsMutable();
              agentPools_.addAll(other.agentPools_);
            }
            onChanged();
          }
        } else {
          if (!other.agentPools_.isEmpty()) {
            if (agentPoolsBuilder_.isEmpty()) {
              agentPoolsBuilder_.dispose();
              agentPoolsBuilder_ = null;
              agentPools_ = other.agentPools_;
              bitField0_ = (bitField0_ & ~0x00000001);
              agentPoolsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAgentPoolsFieldBuilder()
                      : null;
            } else {
              agentPoolsBuilder_.addAllMessages(other.agentPools_);
            }
          }
        }
        if (!other.getNextPageToken().isEmpty()) {
          nextPageToken_ = other.nextPageToken_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPool m =
                      input.readMessage(
                          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.parser(),
                          extensionRegistry);
                  if (agentPoolsBuilder_ == null) {
                    ensureAgentPoolsIsMutable();
                    agentPools_.add(m);
                  } else {
                    agentPoolsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  nextPageToken_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.storagetransfer.v1.proto.TransferTypes.AgentPool>
          agentPools_ = java.util.Collections.emptyList();

      private void ensureAgentPoolsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          agentPools_ =
              new java.util.ArrayList<com.google.storagetransfer.v1.proto.TransferTypes.AgentPool>(
                  agentPools_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder>
          agentPoolsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public java.util.List<com.google.storagetransfer.v1.proto.TransferTypes.AgentPool>
          getAgentPoolsList() {
        if (agentPoolsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(agentPools_);
        } else {
          return agentPoolsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public int getAgentPoolsCount() {
        if (agentPoolsBuilder_ == null) {
          return agentPools_.size();
        } else {
          return agentPoolsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool getAgentPools(int index) {
        if (agentPoolsBuilder_ == null) {
          return agentPools_.get(index);
        } else {
          return agentPoolsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public Builder setAgentPools(
          int index, com.google.storagetransfer.v1.proto.TransferTypes.AgentPool value) {
        if (agentPoolsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAgentPoolsIsMutable();
          agentPools_.set(index, value);
          onChanged();
        } else {
          agentPoolsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public Builder setAgentPools(
          int index,
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder builderForValue) {
        if (agentPoolsBuilder_ == null) {
          ensureAgentPoolsIsMutable();
          agentPools_.set(index, builderForValue.build());
          onChanged();
        } else {
          agentPoolsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public Builder addAgentPools(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool value) {
        if (agentPoolsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAgentPoolsIsMutable();
          agentPools_.add(value);
          onChanged();
        } else {
          agentPoolsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public Builder addAgentPools(
          int index, com.google.storagetransfer.v1.proto.TransferTypes.AgentPool value) {
        if (agentPoolsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAgentPoolsIsMutable();
          agentPools_.add(index, value);
          onChanged();
        } else {
          agentPoolsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public Builder addAgentPools(
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder builderForValue) {
        if (agentPoolsBuilder_ == null) {
          ensureAgentPoolsIsMutable();
          agentPools_.add(builderForValue.build());
          onChanged();
        } else {
          agentPoolsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public Builder addAgentPools(
          int index,
          com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder builderForValue) {
        if (agentPoolsBuilder_ == null) {
          ensureAgentPoolsIsMutable();
          agentPools_.add(index, builderForValue.build());
          onChanged();
        } else {
          agentPoolsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public Builder addAllAgentPools(
          java.lang.Iterable<? extends com.google.storagetransfer.v1.proto.TransferTypes.AgentPool>
              values) {
        if (agentPoolsBuilder_ == null) {
          ensureAgentPoolsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, agentPools_);
          onChanged();
        } else {
          agentPoolsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public Builder clearAgentPools() {
        if (agentPoolsBuilder_ == null) {
          agentPools_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          agentPoolsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public Builder removeAgentPools(int index) {
        if (agentPoolsBuilder_ == null) {
          ensureAgentPoolsIsMutable();
          agentPools_.remove(index);
          onChanged();
        } else {
          agentPoolsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder
          getAgentPoolsBuilder(int index) {
        return getAgentPoolsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder
          getAgentPoolsOrBuilder(int index) {
        if (agentPoolsBuilder_ == null) {
          return agentPools_.get(index);
        } else {
          return agentPoolsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public java.util.List<
              ? extends com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder>
          getAgentPoolsOrBuilderList() {
        if (agentPoolsBuilder_ != null) {
          return agentPoolsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(agentPools_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder
          addAgentPoolsBuilder() {
        return getAgentPoolsFieldBuilder()
            .addBuilder(
                com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder
          addAgentPoolsBuilder(int index) {
        return getAgentPoolsFieldBuilder()
            .addBuilder(
                index,
                com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of agent pools.
       * </pre>
       *
       * <code>repeated .google.storagetransfer.v1.AgentPool agent_pools = 1;</code>
       */
      public java.util.List<com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder>
          getAgentPoolsBuilderList() {
        return getAgentPoolsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder,
              com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder>
          getAgentPoolsFieldBuilder() {
        if (agentPoolsBuilder_ == null) {
          agentPoolsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPool,
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPool.Builder,
                  com.google.storagetransfer.v1.proto.TransferTypes.AgentPoolOrBuilder>(
                  agentPools_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          agentPools_ = null;
        }
        return agentPoolsBuilder_;
      }

      private java.lang.Object nextPageToken_ = "";
      /**
       *
       *
       * <pre>
       * The list next page token.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return The nextPageToken.
       */
      public java.lang.String getNextPageToken() {
        java.lang.Object ref = nextPageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          nextPageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The list next page token.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return The bytes for nextPageToken.
       */
      public com.google.protobuf.ByteString getNextPageTokenBytes() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          nextPageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The list next page token.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @param value The nextPageToken to set.
       * @return This builder for chaining.
       */
      public Builder setNextPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        nextPageToken_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list next page token.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNextPageToken() {

        nextPageToken_ = getDefaultInstance().getNextPageToken();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list next page token.
       * </pre>
       *
       * <code>string next_page_token = 2;</code>
       *
       * @param value The bytes for nextPageToken to set.
       * @return This builder for chaining.
       */
      public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        nextPageToken_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storagetransfer.v1.ListAgentPoolsResponse)
    }

    // @@protoc_insertion_point(class_scope:google.storagetransfer.v1.ListAgentPoolsResponse)
    private static final com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse();
    }

    public static com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ListAgentPoolsResponse> PARSER =
        new com.google.protobuf.AbstractParser<ListAgentPoolsResponse>() {
          @java.lang.Override
          public ListAgentPoolsResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ListAgentPoolsResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ListAgentPoolsResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storagetransfer.v1.proto.TransferProto.ListAgentPoolsResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_GetGoogleServiceAccountRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_GetGoogleServiceAccountRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_CreateTransferJobRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_CreateTransferJobRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_UpdateTransferJobRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_UpdateTransferJobRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_GetTransferJobRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_GetTransferJobRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_DeleteTransferJobRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_DeleteTransferJobRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_ListTransferJobsRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_ListTransferJobsRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_ListTransferJobsResponse_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_ListTransferJobsResponse_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_PauseTransferOperationRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_PauseTransferOperationRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_ResumeTransferOperationRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_ResumeTransferOperationRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_RunTransferJobRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_RunTransferJobRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_CreateAgentPoolRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_CreateAgentPoolRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_UpdateAgentPoolRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_UpdateAgentPoolRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_GetAgentPoolRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_GetAgentPoolRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_DeleteAgentPoolRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_DeleteAgentPoolRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_ListAgentPoolsRequest_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_ListAgentPoolsRequest_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_storagetransfer_v1_ListAgentPoolsResponse_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_storagetransfer_v1_ListAgentPoolsResponse_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  private static com.google.protobuf.Descriptors.FileDescriptor descriptor;

  static {
    java.lang.String[] descriptorData = {
      "\n(google/storagetransfer/v1/transfer.pro"
          + "to\022\031google.storagetransfer.v1\032\034google/ap"
          + "i/annotations.proto\032\027google/api/client.p"
          + "roto\032\037google/api/field_behavior.proto\032#g"
          + "oogle/longrunning/operations.proto\032\033goog"
          + "le/protobuf/empty.proto\032 google/protobuf"
          + "/field_mask.proto\032.google/storagetransfe"
          + "r/v1/transfer_types.proto\"9\n\036GetGoogleSe"
          + "rviceAccountRequest\022\027\n\nproject_id\030\001 \001(\tB"
          + "\003\340A\002\"]\n\030CreateTransferJobRequest\022A\n\014tran"
          + "sfer_job\030\001 \001(\0132&.google.storagetransfer."
          + "v1.TransferJobB\003\340A\002\"\321\001\n\030UpdateTransferJo"
          + "bRequest\022\025\n\010job_name\030\001 \001(\tB\003\340A\002\022\027\n\nproje"
          + "ct_id\030\002 \001(\tB\003\340A\002\022A\n\014transfer_job\030\003 \001(\0132&"
          + ".google.storagetransfer.v1.TransferJobB\003"
          + "\340A\002\022B\n\036update_transfer_job_field_mask\030\004 "
          + "\001(\0132\032.google.protobuf.FieldMask\"G\n\025GetTr"
          + "ansferJobRequest\022\025\n\010job_name\030\001 \001(\tB\003\340A\002\022"
          + "\027\n\nproject_id\030\002 \001(\tB\003\340A\002\"J\n\030DeleteTransf"
          + "erJobRequest\022\025\n\010job_name\030\001 \001(\tB\003\340A\002\022\027\n\np"
          + "roject_id\030\002 \001(\tB\003\340A\002\"U\n\027ListTransferJobs"
          + "Request\022\023\n\006filter\030\001 \001(\tB\003\340A\002\022\021\n\tpage_siz"
          + "e\030\004 \001(\005\022\022\n\npage_token\030\005 \001(\t\"r\n\030ListTrans"
          + "ferJobsResponse\022=\n\rtransfer_jobs\030\001 \003(\0132&"
          + ".google.storagetransfer.v1.TransferJob\022\027"
          + "\n\017next_page_token\030\002 \001(\t\"2\n\035PauseTransfer"
          + "OperationRequest\022\021\n\004name\030\001 \001(\tB\003\340A\002\"3\n\036R"
          + "esumeTransferOperationRequest\022\021\n\004name\030\001 "
          + "\001(\tB\003\340A\002\"G\n\025RunTransferJobRequest\022\025\n\010job"
          + "_name\030\001 \001(\tB\003\340A\002\022\027\n\nproject_id\030\002 \001(\tB\003\340A"
          + "\002\"\214\001\n\026CreateAgentPoolRequest\022\027\n\nproject_"
          + "id\030\001 \001(\tB\003\340A\002\022=\n\nagent_pool\030\002 \001(\0132$.goog"
          + "le.storagetransfer.v1.AgentPoolB\003\340A\002\022\032\n\r"
          + "agent_pool_id\030\003 \001(\tB\003\340A\002\"\210\001\n\026UpdateAgent"
          + "PoolRequest\022=\n\nagent_pool\030\001 \001(\0132$.google"
          + ".storagetransfer.v1.AgentPoolB\003\340A\002\022/\n\013up"
          + "date_mask\030\002 \001(\0132\032.google.protobuf.FieldM"
          + "ask\"(\n\023GetAgentPoolRequest\022\021\n\004name\030\001 \001(\t"
          + "B\003\340A\002\"+\n\026DeleteAgentPoolRequest\022\021\n\004name\030"
          + "\001 \001(\tB\003\340A\002\"g\n\025ListAgentPoolsRequest\022\027\n\np"
          + "roject_id\030\001 \001(\tB\003\340A\002\022\016\n\006filter\030\002 \001(\t\022\021\n\t"
          + "page_size\030\003 \001(\005\022\022\n\npage_token\030\004 \001(\t\"l\n\026L"
          + "istAgentPoolsResponse\0229\n\013agent_pools\030\001 \003"
          + "(\0132$.google.storagetransfer.v1.AgentPool"
          + "\022\027\n\017next_page_token\030\002 \001(\t2\221\023\n\026StorageTra"
          + "nsferService\022\265\001\n\027GetGoogleServiceAccount"
          + "\0229.google.storagetransfer.v1.GetGoogleSe"
          + "rviceAccountRequest\032/.google.storagetran"
          + "sfer.v1.GoogleServiceAccount\".\202\323\344\223\002(\022&/v"
          + "1/googleServiceAccounts/{project_id}\022\230\001\n"
          + "\021CreateTransferJob\0223.google.storagetrans"
          + "fer.v1.CreateTransferJobRequest\032&.google"
          + ".storagetransfer.v1.TransferJob\"&\202\323\344\223\002 \""
          + "\020/v1/transferJobs:\014transfer_job\022\233\001\n\021Upda"
          + "teTransferJob\0223.google.storagetransfer.v"
          + "1.UpdateTransferJobRequest\032&.google.stor"
          + "agetransfer.v1.TransferJob\")\202\323\344\223\002#2\036/v1/"
          + "{job_name=transferJobs/**}:\001*\022\222\001\n\016GetTra"
          + "nsferJob\0220.google.storagetransfer.v1.Get"
          + "TransferJobRequest\032&.google.storagetrans"
          + "fer.v1.TransferJob\"&\202\323\344\223\002 \022\036/v1/{job_nam"
          + "e=transferJobs/**}\022\225\001\n\020ListTransferJobs\022"
          + "2.google.storagetransfer.v1.ListTransfer"
          + "JobsRequest\0323.google.storagetransfer.v1."
          + "ListTransferJobsResponse\"\030\202\323\344\223\002\022\022\020/v1/tr"
          + "ansferJobs\022\235\001\n\026PauseTransferOperation\0228."
          + "google.storagetransfer.v1.PauseTransferO"
          + "perationRequest\032\026.google.protobuf.Empty\""
          + "1\202\323\344\223\002+\"&/v1/{name=transferOperations/**"
          + "}:pause:\001*\022\240\001\n\027ResumeTransferOperation\0229"
          + ".google.storagetransfer.v1.ResumeTransfe"
          + "rOperationRequest\032\026.google.protobuf.Empt"
          + "y\"2\202\323\344\223\002,\"\'/v1/{name=transferOperations/"
          + "**}:resume:\001*\022\275\001\n\016RunTransferJob\0220.googl"
          + "e.storagetransfer.v1.RunTransferJobReque"
          + "st\032\035.google.longrunning.Operation\"Z\202\323\344\223\002"
          + "\'\"\"/v1/{job_name=transferJobs/**}:run:\001*"
          + "\312A*\n\025google.protobuf.Empty\022\021TransferOper"
          + "ation\022\210\001\n\021DeleteTransferJob\0223.google.sto"
          + "ragetransfer.v1.DeleteTransferJobRequest"
          + "\032\026.google.protobuf.Empty\"&\202\323\344\223\002 *\036/v1/{j"
          + "ob_name=transferJobs/**}\022\314\001\n\017CreateAgent"
          + "Pool\0221.google.storagetransfer.v1.CreateA"
          + "gentPoolRequest\032$.google.storagetransfer"
          + ".v1.AgentPool\"`\202\323\344\223\0024\"&/v1/projects/{pro"
          + "ject_id=*}/agentPools:\nagent_pool\332A#proj"
          + "ect_id,agent_pool,agent_pool_id\022\306\001\n\017Upda"
          + "teAgentPool\0221.google.storagetransfer.v1."
          + "UpdateAgentPoolRequest\032$.google.storaget"
          + "ransfer.v1.AgentPool\"Z\202\323\344\223\002;2-/v1/{agent"
          + "_pool.name=projects/*/agentPools/*}:\nage"
          + "nt_pool\332A\026agent_pool,update_mask\022\227\001\n\014Get"
          + "AgentPool\022..google.storagetransfer.v1.Ge"
          + "tAgentPoolRequest\032$.google.storagetransf"
          + "er.v1.AgentPool\"1\202\323\344\223\002$\022\"/v1/{name=proje"
          + "cts/*/agentPools/*}\332A\004name\022\262\001\n\016ListAgent"
          + "Pools\0220.google.storagetransfer.v1.ListAg"
          + "entPoolsRequest\0321.google.storagetransfer"
          + ".v1.ListAgentPoolsResponse\";\202\323\344\223\002(\022&/v1/"
          + "projects/{project_id=*}/agentPools\332A\npro"
          + "ject_id\022\217\001\n\017DeleteAgentPool\0221.google.sto"
          + "ragetransfer.v1.DeleteAgentPoolRequest\032\026"
          + ".google.protobuf.Empty\"1\202\323\344\223\002$*\"/v1/{nam"
          + "e=projects/*/agentPools/*}\332A\004name\032R\312A\036st"
          + "oragetransfer.googleapis.com\322A.https://w"
          + "ww.googleapis.com/auth/cloud-platformB\352\001"
          + "\n#com.google.storagetransfer.v1.protoB\rT"
          + "ransferProtoZHgoogle.golang.org/genproto"
          + "/googleapis/storagetransfer/v1;storagetr"
          + "ansfer\370\001\001\252\002\037Google.Cloud.StorageTransfer"
          + ".V1\312\002\037Google\\Cloud\\StorageTransfer\\V1\352\002\""
          + "Google::Cloud::StorageTransfer::V1b\006prot"
          + "o3"
    };
    descriptor =
        com.google.protobuf.Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(
            descriptorData,
            new com.google.protobuf.Descriptors.FileDescriptor[] {
              com.google.api.AnnotationsProto.getDescriptor(),
              com.google.api.ClientProto.getDescriptor(),
              com.google.api.FieldBehaviorProto.getDescriptor(),
              com.google.longrunning.OperationsProto.getDescriptor(),
              com.google.protobuf.EmptyProto.getDescriptor(),
              com.google.protobuf.FieldMaskProto.getDescriptor(),
              com.google.storagetransfer.v1.proto.TransferTypes.getDescriptor(),
            });
    internal_static_google_storagetransfer_v1_GetGoogleServiceAccountRequest_descriptor =
        getDescriptor().getMessageTypes().get(0);
    internal_static_google_storagetransfer_v1_GetGoogleServiceAccountRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_GetGoogleServiceAccountRequest_descriptor,
            new java.lang.String[] {
              "ProjectId",
            });
    internal_static_google_storagetransfer_v1_CreateTransferJobRequest_descriptor =
        getDescriptor().getMessageTypes().get(1);
    internal_static_google_storagetransfer_v1_CreateTransferJobRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_CreateTransferJobRequest_descriptor,
            new java.lang.String[] {
              "TransferJob",
            });
    internal_static_google_storagetransfer_v1_UpdateTransferJobRequest_descriptor =
        getDescriptor().getMessageTypes().get(2);
    internal_static_google_storagetransfer_v1_UpdateTransferJobRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_UpdateTransferJobRequest_descriptor,
            new java.lang.String[] {
              "JobName", "ProjectId", "TransferJob", "UpdateTransferJobFieldMask",
            });
    internal_static_google_storagetransfer_v1_GetTransferJobRequest_descriptor =
        getDescriptor().getMessageTypes().get(3);
    internal_static_google_storagetransfer_v1_GetTransferJobRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_GetTransferJobRequest_descriptor,
            new java.lang.String[] {
              "JobName", "ProjectId",
            });
    internal_static_google_storagetransfer_v1_DeleteTransferJobRequest_descriptor =
        getDescriptor().getMessageTypes().get(4);
    internal_static_google_storagetransfer_v1_DeleteTransferJobRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_DeleteTransferJobRequest_descriptor,
            new java.lang.String[] {
              "JobName", "ProjectId",
            });
    internal_static_google_storagetransfer_v1_ListTransferJobsRequest_descriptor =
        getDescriptor().getMessageTypes().get(5);
    internal_static_google_storagetransfer_v1_ListTransferJobsRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_ListTransferJobsRequest_descriptor,
            new java.lang.String[] {
              "Filter", "PageSize", "PageToken",
            });
    internal_static_google_storagetransfer_v1_ListTransferJobsResponse_descriptor =
        getDescriptor().getMessageTypes().get(6);
    internal_static_google_storagetransfer_v1_ListTransferJobsResponse_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_ListTransferJobsResponse_descriptor,
            new java.lang.String[] {
              "TransferJobs", "NextPageToken",
            });
    internal_static_google_storagetransfer_v1_PauseTransferOperationRequest_descriptor =
        getDescriptor().getMessageTypes().get(7);
    internal_static_google_storagetransfer_v1_PauseTransferOperationRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_PauseTransferOperationRequest_descriptor,
            new java.lang.String[] {
              "Name",
            });
    internal_static_google_storagetransfer_v1_ResumeTransferOperationRequest_descriptor =
        getDescriptor().getMessageTypes().get(8);
    internal_static_google_storagetransfer_v1_ResumeTransferOperationRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_ResumeTransferOperationRequest_descriptor,
            new java.lang.String[] {
              "Name",
            });
    internal_static_google_storagetransfer_v1_RunTransferJobRequest_descriptor =
        getDescriptor().getMessageTypes().get(9);
    internal_static_google_storagetransfer_v1_RunTransferJobRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_RunTransferJobRequest_descriptor,
            new java.lang.String[] {
              "JobName", "ProjectId",
            });
    internal_static_google_storagetransfer_v1_CreateAgentPoolRequest_descriptor =
        getDescriptor().getMessageTypes().get(10);
    internal_static_google_storagetransfer_v1_CreateAgentPoolRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_CreateAgentPoolRequest_descriptor,
            new java.lang.String[] {
              "ProjectId", "AgentPool", "AgentPoolId",
            });
    internal_static_google_storagetransfer_v1_UpdateAgentPoolRequest_descriptor =
        getDescriptor().getMessageTypes().get(11);
    internal_static_google_storagetransfer_v1_UpdateAgentPoolRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_UpdateAgentPoolRequest_descriptor,
            new java.lang.String[] {
              "AgentPool", "UpdateMask",
            });
    internal_static_google_storagetransfer_v1_GetAgentPoolRequest_descriptor =
        getDescriptor().getMessageTypes().get(12);
    internal_static_google_storagetransfer_v1_GetAgentPoolRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_GetAgentPoolRequest_descriptor,
            new java.lang.String[] {
              "Name",
            });
    internal_static_google_storagetransfer_v1_DeleteAgentPoolRequest_descriptor =
        getDescriptor().getMessageTypes().get(13);
    internal_static_google_storagetransfer_v1_DeleteAgentPoolRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_DeleteAgentPoolRequest_descriptor,
            new java.lang.String[] {
              "Name",
            });
    internal_static_google_storagetransfer_v1_ListAgentPoolsRequest_descriptor =
        getDescriptor().getMessageTypes().get(14);
    internal_static_google_storagetransfer_v1_ListAgentPoolsRequest_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_ListAgentPoolsRequest_descriptor,
            new java.lang.String[] {
              "ProjectId", "Filter", "PageSize", "PageToken",
            });
    internal_static_google_storagetransfer_v1_ListAgentPoolsResponse_descriptor =
        getDescriptor().getMessageTypes().get(15);
    internal_static_google_storagetransfer_v1_ListAgentPoolsResponse_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_storagetransfer_v1_ListAgentPoolsResponse_descriptor,
            new java.lang.String[] {
              "AgentPools", "NextPageToken",
            });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.google.api.ClientProto.defaultHost);
    registry.add(com.google.api.FieldBehaviorProto.fieldBehavior);
    registry.add(com.google.api.AnnotationsProto.http);
    registry.add(com.google.api.ClientProto.methodSignature);
    registry.add(com.google.api.ClientProto.oauthScopes);
    registry.add(com.google.longrunning.OperationsProto.operationInfo);
    com.google.protobuf.Descriptors.FileDescriptor.internalUpdateFileDescriptor(
        descriptor, registry);
    com.google.api.AnnotationsProto.getDescriptor();
    com.google.api.ClientProto.getDescriptor();
    com.google.api.FieldBehaviorProto.getDescriptor();
    com.google.longrunning.OperationsProto.getDescriptor();
    com.google.protobuf.EmptyProto.getDescriptor();
    com.google.protobuf.FieldMaskProto.getDescriptor();
    com.google.storagetransfer.v1.proto.TransferTypes.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
