/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/serviceusage/v1beta1/serviceusage.proto

package com.google.api.serviceusage.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for UpdateConsumerOverride.
 * </pre>
 *
 * Protobuf type {@code google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest}
 */
public final class UpdateConsumerOverrideRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest)
    UpdateConsumerOverrideRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateConsumerOverrideRequest.newBuilder() to construct.
  private UpdateConsumerOverrideRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateConsumerOverrideRequest() {
    name_ = "";
    forceOnly_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateConsumerOverrideRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.serviceusage.v1beta1.ServiceUsageProto
        .internal_static_google_api_serviceusage_v1beta1_UpdateConsumerOverrideRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.serviceusage.v1beta1.ServiceUsageProto
        .internal_static_google_api_serviceusage_v1beta1_UpdateConsumerOverrideRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest.class,
            com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the override to update.
   * An example name would be:
   * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the override to update.
   * An example name would be:
   * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OVERRIDE_FIELD_NUMBER = 2;
  private com.google.api.serviceusage.v1beta1.QuotaOverride override_;
  /**
   *
   *
   * <pre>
   * The new override.
   * Only the override_value is updated; all other fields are ignored.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.QuotaOverride override = 2;</code>
   *
   * @return Whether the override field is set.
   */
  @java.lang.Override
  public boolean hasOverride() {
    return override_ != null;
  }
  /**
   *
   *
   * <pre>
   * The new override.
   * Only the override_value is updated; all other fields are ignored.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.QuotaOverride override = 2;</code>
   *
   * @return The override.
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaOverride getOverride() {
    return override_ == null
        ? com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance()
        : override_;
  }
  /**
   *
   *
   * <pre>
   * The new override.
   * Only the override_value is updated; all other fields are ignored.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.QuotaOverride override = 2;</code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder getOverrideOrBuilder() {
    return getOverride();
  }

  public static final int FORCE_FIELD_NUMBER = 3;
  private boolean force_;
  /**
   *
   *
   * <pre>
   * Whether to force the update of the quota override.
   * Setting the force parameter to 'true' ignores all quota safety checks that
   * would fail the request. QuotaSafetyCheck lists all such validations.
   * </pre>
   *
   * <code>bool force = 3;</code>
   *
   * @return The force.
   */
  @java.lang.Override
  public boolean getForce() {
    return force_;
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 4;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Update only the specified fields of the override.
   * If unset, all fields will be updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4;</code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return updateMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * Update only the specified fields of the override.
   * If unset, all fields will be updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4;</code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Update only the specified fields of the override.
   * If unset, all fields will be updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return getUpdateMask();
  }

  public static final int FORCE_ONLY_FIELD_NUMBER = 5;
  private java.util.List<java.lang.Integer> forceOnly_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.api.serviceusage.v1beta1.QuotaSafetyCheck>
      forceOnly_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.api.serviceusage.v1beta1.QuotaSafetyCheck>() {
            public com.google.api.serviceusage.v1beta1.QuotaSafetyCheck convert(
                java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.api.serviceusage.v1beta1.QuotaSafetyCheck result =
                  com.google.api.serviceusage.v1beta1.QuotaSafetyCheck.valueOf(from);
              return result == null
                  ? com.google.api.serviceusage.v1beta1.QuotaSafetyCheck.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The list of quota safety checks to ignore before the override mutation.
   * Unlike 'force' field that ignores all the quota safety checks, the
   * 'force_only' field ignores only the specified checks; other checks are
   * still enforced. The 'force' and 'force_only' fields cannot both be set.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
   *
   * @return A list containing the forceOnly.
   */
  @java.lang.Override
  public java.util.List<com.google.api.serviceusage.v1beta1.QuotaSafetyCheck> getForceOnlyList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.api.serviceusage.v1beta1.QuotaSafetyCheck>(
        forceOnly_, forceOnly_converter_);
  }
  /**
   *
   *
   * <pre>
   * The list of quota safety checks to ignore before the override mutation.
   * Unlike 'force' field that ignores all the quota safety checks, the
   * 'force_only' field ignores only the specified checks; other checks are
   * still enforced. The 'force' and 'force_only' fields cannot both be set.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
   *
   * @return The count of forceOnly.
   */
  @java.lang.Override
  public int getForceOnlyCount() {
    return forceOnly_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of quota safety checks to ignore before the override mutation.
   * Unlike 'force' field that ignores all the quota safety checks, the
   * 'force_only' field ignores only the specified checks; other checks are
   * still enforced. The 'force' and 'force_only' fields cannot both be set.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The forceOnly at the given index.
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaSafetyCheck getForceOnly(int index) {
    return forceOnly_converter_.convert(forceOnly_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The list of quota safety checks to ignore before the override mutation.
   * Unlike 'force' field that ignores all the quota safety checks, the
   * 'force_only' field ignores only the specified checks; other checks are
   * still enforced. The 'force' and 'force_only' fields cannot both be set.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
   *
   * @return A list containing the enum numeric values on the wire for forceOnly.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getForceOnlyValueList() {
    return forceOnly_;
  }
  /**
   *
   *
   * <pre>
   * The list of quota safety checks to ignore before the override mutation.
   * Unlike 'force' field that ignores all the quota safety checks, the
   * 'force_only' field ignores only the specified checks; other checks are
   * still enforced. The 'force' and 'force_only' fields cannot both be set.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of forceOnly at the given index.
   */
  @java.lang.Override
  public int getForceOnlyValue(int index) {
    return forceOnly_.get(index);
  }

  private int forceOnlyMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (override_ != null) {
      output.writeMessage(2, getOverride());
    }
    if (force_ != false) {
      output.writeBool(3, force_);
    }
    if (updateMask_ != null) {
      output.writeMessage(4, getUpdateMask());
    }
    if (getForceOnlyList().size() > 0) {
      output.writeUInt32NoTag(42);
      output.writeUInt32NoTag(forceOnlyMemoizedSerializedSize);
    }
    for (int i = 0; i < forceOnly_.size(); i++) {
      output.writeEnumNoTag(forceOnly_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (override_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOverride());
    }
    if (force_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, force_);
    }
    if (updateMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateMask());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < forceOnly_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(forceOnly_.get(i));
      }
      size += dataSize;
      if (!getForceOnlyList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      forceOnlyMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest)) {
      return super.equals(obj);
    }
    com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest other =
        (com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasOverride() != other.hasOverride()) return false;
    if (hasOverride()) {
      if (!getOverride().equals(other.getOverride())) return false;
    }
    if (getForce() != other.getForce()) return false;
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (!forceOnly_.equals(other.forceOnly_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasOverride()) {
      hash = (37 * hash) + OVERRIDE_FIELD_NUMBER;
      hash = (53 * hash) + getOverride().hashCode();
    }
    hash = (37 * hash) + FORCE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getForce());
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    if (getForceOnlyCount() > 0) {
      hash = (37 * hash) + FORCE_ONLY_FIELD_NUMBER;
      hash = (53 * hash) + forceOnly_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for UpdateConsumerOverride.
   * </pre>
   *
   * Protobuf type {@code google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest)
      com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.serviceusage.v1beta1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1beta1_UpdateConsumerOverrideRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.serviceusage.v1beta1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1beta1_UpdateConsumerOverrideRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest.class,
              com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest.Builder.class);
    }

    // Construct using
    // com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      if (overrideBuilder_ == null) {
        override_ = null;
      } else {
        override_ = null;
        overrideBuilder_ = null;
      }
      force_ = false;

      if (updateMaskBuilder_ == null) {
        updateMask_ = null;
      } else {
        updateMask_ = null;
        updateMaskBuilder_ = null;
      }
      forceOnly_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.serviceusage.v1beta1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1beta1_UpdateConsumerOverrideRequest_descriptor;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest
        getDefaultInstanceForType() {
      return com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest build() {
      com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest buildPartial() {
      com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest result =
          new com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      if (overrideBuilder_ == null) {
        result.override_ = override_;
      } else {
        result.override_ = overrideBuilder_.build();
      }
      result.force_ = force_;
      if (updateMaskBuilder_ == null) {
        result.updateMask_ = updateMask_;
      } else {
        result.updateMask_ = updateMaskBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        forceOnly_ = java.util.Collections.unmodifiableList(forceOnly_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.forceOnly_ = forceOnly_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest) {
        return mergeFrom((com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest other) {
      if (other
          == com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasOverride()) {
        mergeOverride(other.getOverride());
      }
      if (other.getForce() != false) {
        setForce(other.getForce());
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (!other.forceOnly_.isEmpty()) {
        if (forceOnly_.isEmpty()) {
          forceOnly_ = other.forceOnly_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureForceOnlyIsMutable();
          forceOnly_.addAll(other.forceOnly_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getOverrideFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 24:
              {
                force_ = input.readBool();

                break;
              } // case 24
            case 34:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 40:
              {
                int tmpRaw = input.readEnum();
                ensureForceOnlyIsMutable();
                forceOnly_.add(tmpRaw);
                break;
              } // case 40
            case 42:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureForceOnlyIsMutable();
                  forceOnly_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the override to update.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the override to update.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the override to update.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the override to update.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the override to update.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.api.serviceusage.v1beta1.QuotaOverride override_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.QuotaOverride,
            com.google.api.serviceusage.v1beta1.QuotaOverride.Builder,
            com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder>
        overrideBuilder_;
    /**
     *
     *
     * <pre>
     * The new override.
     * Only the override_value is updated; all other fields are ignored.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride override = 2;</code>
     *
     * @return Whether the override field is set.
     */
    public boolean hasOverride() {
      return overrideBuilder_ != null || override_ != null;
    }
    /**
     *
     *
     * <pre>
     * The new override.
     * Only the override_value is updated; all other fields are ignored.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride override = 2;</code>
     *
     * @return The override.
     */
    public com.google.api.serviceusage.v1beta1.QuotaOverride getOverride() {
      if (overrideBuilder_ == null) {
        return override_ == null
            ? com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance()
            : override_;
      } else {
        return overrideBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The new override.
     * Only the override_value is updated; all other fields are ignored.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride override = 2;</code>
     */
    public Builder setOverride(com.google.api.serviceusage.v1beta1.QuotaOverride value) {
      if (overrideBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        override_ = value;
        onChanged();
      } else {
        overrideBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The new override.
     * Only the override_value is updated; all other fields are ignored.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride override = 2;</code>
     */
    public Builder setOverride(
        com.google.api.serviceusage.v1beta1.QuotaOverride.Builder builderForValue) {
      if (overrideBuilder_ == null) {
        override_ = builderForValue.build();
        onChanged();
      } else {
        overrideBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The new override.
     * Only the override_value is updated; all other fields are ignored.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride override = 2;</code>
     */
    public Builder mergeOverride(com.google.api.serviceusage.v1beta1.QuotaOverride value) {
      if (overrideBuilder_ == null) {
        if (override_ != null) {
          override_ =
              com.google.api.serviceusage.v1beta1.QuotaOverride.newBuilder(override_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          override_ = value;
        }
        onChanged();
      } else {
        overrideBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The new override.
     * Only the override_value is updated; all other fields are ignored.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride override = 2;</code>
     */
    public Builder clearOverride() {
      if (overrideBuilder_ == null) {
        override_ = null;
        onChanged();
      } else {
        override_ = null;
        overrideBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The new override.
     * Only the override_value is updated; all other fields are ignored.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride override = 2;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaOverride.Builder getOverrideBuilder() {

      onChanged();
      return getOverrideFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The new override.
     * Only the override_value is updated; all other fields are ignored.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride override = 2;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder getOverrideOrBuilder() {
      if (overrideBuilder_ != null) {
        return overrideBuilder_.getMessageOrBuilder();
      } else {
        return override_ == null
            ? com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance()
            : override_;
      }
    }
    /**
     *
     *
     * <pre>
     * The new override.
     * Only the override_value is updated; all other fields are ignored.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride override = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.QuotaOverride,
            com.google.api.serviceusage.v1beta1.QuotaOverride.Builder,
            com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder>
        getOverrideFieldBuilder() {
      if (overrideBuilder_ == null) {
        overrideBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.serviceusage.v1beta1.QuotaOverride,
                com.google.api.serviceusage.v1beta1.QuotaOverride.Builder,
                com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder>(
                getOverride(), getParentForChildren(), isClean());
        override_ = null;
      }
      return overrideBuilder_;
    }

    private boolean force_;
    /**
     *
     *
     * <pre>
     * Whether to force the update of the quota override.
     * Setting the force parameter to 'true' ignores all quota safety checks that
     * would fail the request. QuotaSafetyCheck lists all such validations.
     * </pre>
     *
     * <code>bool force = 3;</code>
     *
     * @return The force.
     */
    @java.lang.Override
    public boolean getForce() {
      return force_;
    }
    /**
     *
     *
     * <pre>
     * Whether to force the update of the quota override.
     * Setting the force parameter to 'true' ignores all quota safety checks that
     * would fail the request. QuotaSafetyCheck lists all such validations.
     * </pre>
     *
     * <code>bool force = 3;</code>
     *
     * @param value The force to set.
     * @return This builder for chaining.
     */
    public Builder setForce(boolean value) {

      force_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to force the update of the quota override.
     * Setting the force parameter to 'true' ignores all quota safety checks that
     * would fail the request. QuotaSafetyCheck lists all such validations.
     * </pre>
     *
     * <code>bool force = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearForce() {

      force_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Update only the specified fields of the override.
     * If unset, all fields will be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return updateMaskBuilder_ != null || updateMask_ != null;
    }
    /**
     *
     *
     * <pre>
     * Update only the specified fields of the override.
     * If unset, all fields will be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Update only the specified fields of the override.
     * If unset, all fields will be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
        onChanged();
      } else {
        updateMaskBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Update only the specified fields of the override.
     * If unset, all fields will be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
        onChanged();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Update only the specified fields of the override.
     * If unset, all fields will be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (updateMask_ != null) {
          updateMask_ =
              com.google.protobuf.FieldMask.newBuilder(updateMask_).mergeFrom(value).buildPartial();
        } else {
          updateMask_ = value;
        }
        onChanged();
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Update only the specified fields of the override.
     * If unset, all fields will be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    public Builder clearUpdateMask() {
      if (updateMaskBuilder_ == null) {
        updateMask_ = null;
        onChanged();
      } else {
        updateMask_ = null;
        updateMaskBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Update only the specified fields of the override.
     * If unset, all fields will be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {

      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Update only the specified fields of the override.
     * If unset, all fields will be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Update only the specified fields of the override.
     * If unset, all fields will be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private java.util.List<java.lang.Integer> forceOnly_ = java.util.Collections.emptyList();

    private void ensureForceOnlyIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        forceOnly_ = new java.util.ArrayList<java.lang.Integer>(forceOnly_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
     *
     * @return A list containing the forceOnly.
     */
    public java.util.List<com.google.api.serviceusage.v1beta1.QuotaSafetyCheck> getForceOnlyList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.api.serviceusage.v1beta1.QuotaSafetyCheck>(
          forceOnly_, forceOnly_converter_);
    }
    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
     *
     * @return The count of forceOnly.
     */
    public int getForceOnlyCount() {
      return forceOnly_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The forceOnly at the given index.
     */
    public com.google.api.serviceusage.v1beta1.QuotaSafetyCheck getForceOnly(int index) {
      return forceOnly_converter_.convert(forceOnly_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The forceOnly to set.
     * @return This builder for chaining.
     */
    public Builder setForceOnly(
        int index, com.google.api.serviceusage.v1beta1.QuotaSafetyCheck value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureForceOnlyIsMutable();
      forceOnly_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
     *
     * @param value The forceOnly to add.
     * @return This builder for chaining.
     */
    public Builder addForceOnly(com.google.api.serviceusage.v1beta1.QuotaSafetyCheck value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureForceOnlyIsMutable();
      forceOnly_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
     *
     * @param values The forceOnly to add.
     * @return This builder for chaining.
     */
    public Builder addAllForceOnly(
        java.lang.Iterable<? extends com.google.api.serviceusage.v1beta1.QuotaSafetyCheck> values) {
      ensureForceOnlyIsMutable();
      for (com.google.api.serviceusage.v1beta1.QuotaSafetyCheck value : values) {
        forceOnly_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearForceOnly() {
      forceOnly_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
     *
     * @return A list containing the enum numeric values on the wire for forceOnly.
     */
    public java.util.List<java.lang.Integer> getForceOnlyValueList() {
      return java.util.Collections.unmodifiableList(forceOnly_);
    }
    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of forceOnly at the given index.
     */
    public int getForceOnlyValue(int index) {
      return forceOnly_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for forceOnly to set.
     * @return This builder for chaining.
     */
    public Builder setForceOnlyValue(int index, int value) {
      ensureForceOnlyIsMutable();
      forceOnly_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
     *
     * @param value The enum numeric value on the wire for forceOnly to add.
     * @return This builder for chaining.
     */
    public Builder addForceOnlyValue(int value) {
      ensureForceOnlyIsMutable();
      forceOnly_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of quota safety checks to ignore before the override mutation.
     * Unlike 'force' field that ignores all the quota safety checks, the
     * 'force_only' field ignores only the specified checks; other checks are
     * still enforced. The 'force' and 'force_only' fields cannot both be set.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaSafetyCheck force_only = 5;</code>
     *
     * @param values The enum numeric values on the wire for forceOnly to add.
     * @return This builder for chaining.
     */
    public Builder addAllForceOnlyValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureForceOnlyIsMutable();
      for (int value : values) {
        forceOnly_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest)
  }

  // @@protoc_insertion_point(class_scope:google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest)
  private static final com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest();
  }

  public static com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateConsumerOverrideRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateConsumerOverrideRequest>() {
        @java.lang.Override
        public UpdateConsumerOverrideRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateConsumerOverrideRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateConsumerOverrideRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.UpdateConsumerOverrideRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
