/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/serviceusage/v1beta1/resources.proto

package com.google.api.serviceusage.v1beta1;

/**
 *
 *
 * <pre>
 * The configuration of the service.
 * </pre>
 *
 * Protobuf type {@code google.api.serviceusage.v1beta1.ServiceConfig}
 */
public final class ServiceConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.serviceusage.v1beta1.ServiceConfig)
    ServiceConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ServiceConfig.newBuilder() to construct.
  private ServiceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServiceConfig() {
    name_ = "";
    title_ = "";
    apis_ = java.util.Collections.emptyList();
    endpoints_ = java.util.Collections.emptyList();
    monitoredResources_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServiceConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.serviceusage.v1beta1.ResourcesProto
        .internal_static_google_api_serviceusage_v1beta1_ServiceConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.serviceusage.v1beta1.ResourcesProto
        .internal_static_google_api_serviceusage_v1beta1_ServiceConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.serviceusage.v1beta1.ServiceConfig.class,
            com.google.api.serviceusage.v1beta1.ServiceConfig.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The DNS address at which this service is available.
   * An example DNS address would be:
   * `calendar.googleapis.com`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The DNS address at which this service is available.
   * An example DNS address would be:
   * `calendar.googleapis.com`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TITLE_FIELD_NUMBER = 2;
  private volatile java.lang.Object title_;
  /**
   *
   *
   * <pre>
   * The product title for this service.
   * </pre>
   *
   * <code>string title = 2;</code>
   *
   * @return The title.
   */
  @java.lang.Override
  public java.lang.String getTitle() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      title_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The product title for this service.
   * </pre>
   *
   * <code>string title = 2;</code>
   *
   * @return The bytes for title.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTitleBytes() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      title_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APIS_FIELD_NUMBER = 3;
  private java.util.List<com.google.protobuf.Api> apis_;
  /**
   *
   *
   * <pre>
   * A list of API interfaces exported by this service. Contains only the names,
   * versions, and method names of the interfaces.
   * </pre>
   *
   * <code>repeated .google.protobuf.Api apis = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Api> getApisList() {
    return apis_;
  }
  /**
   *
   *
   * <pre>
   * A list of API interfaces exported by this service. Contains only the names,
   * versions, and method names of the interfaces.
   * </pre>
   *
   * <code>repeated .google.protobuf.Api apis = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.ApiOrBuilder> getApisOrBuilderList() {
    return apis_;
  }
  /**
   *
   *
   * <pre>
   * A list of API interfaces exported by this service. Contains only the names,
   * versions, and method names of the interfaces.
   * </pre>
   *
   * <code>repeated .google.protobuf.Api apis = 3;</code>
   */
  @java.lang.Override
  public int getApisCount() {
    return apis_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of API interfaces exported by this service. Contains only the names,
   * versions, and method names of the interfaces.
   * </pre>
   *
   * <code>repeated .google.protobuf.Api apis = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Api getApis(int index) {
    return apis_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of API interfaces exported by this service. Contains only the names,
   * versions, and method names of the interfaces.
   * </pre>
   *
   * <code>repeated .google.protobuf.Api apis = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ApiOrBuilder getApisOrBuilder(int index) {
    return apis_.get(index);
  }

  public static final int DOCUMENTATION_FIELD_NUMBER = 6;
  private com.google.api.Documentation documentation_;
  /**
   *
   *
   * <pre>
   * Additional API documentation. Contains only the summary and the
   * documentation URL.
   * </pre>
   *
   * <code>.google.api.Documentation documentation = 6;</code>
   *
   * @return Whether the documentation field is set.
   */
  @java.lang.Override
  public boolean hasDocumentation() {
    return documentation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Additional API documentation. Contains only the summary and the
   * documentation URL.
   * </pre>
   *
   * <code>.google.api.Documentation documentation = 6;</code>
   *
   * @return The documentation.
   */
  @java.lang.Override
  public com.google.api.Documentation getDocumentation() {
    return documentation_ == null
        ? com.google.api.Documentation.getDefaultInstance()
        : documentation_;
  }
  /**
   *
   *
   * <pre>
   * Additional API documentation. Contains only the summary and the
   * documentation URL.
   * </pre>
   *
   * <code>.google.api.Documentation documentation = 6;</code>
   */
  @java.lang.Override
  public com.google.api.DocumentationOrBuilder getDocumentationOrBuilder() {
    return getDocumentation();
  }

  public static final int QUOTA_FIELD_NUMBER = 10;
  private com.google.api.Quota quota_;
  /**
   *
   *
   * <pre>
   * Quota configuration.
   * </pre>
   *
   * <code>.google.api.Quota quota = 10;</code>
   *
   * @return Whether the quota field is set.
   */
  @java.lang.Override
  public boolean hasQuota() {
    return quota_ != null;
  }
  /**
   *
   *
   * <pre>
   * Quota configuration.
   * </pre>
   *
   * <code>.google.api.Quota quota = 10;</code>
   *
   * @return The quota.
   */
  @java.lang.Override
  public com.google.api.Quota getQuota() {
    return quota_ == null ? com.google.api.Quota.getDefaultInstance() : quota_;
  }
  /**
   *
   *
   * <pre>
   * Quota configuration.
   * </pre>
   *
   * <code>.google.api.Quota quota = 10;</code>
   */
  @java.lang.Override
  public com.google.api.QuotaOrBuilder getQuotaOrBuilder() {
    return getQuota();
  }

  public static final int AUTHENTICATION_FIELD_NUMBER = 11;
  private com.google.api.Authentication authentication_;
  /**
   *
   *
   * <pre>
   * Auth configuration. Contains only the OAuth rules.
   * </pre>
   *
   * <code>.google.api.Authentication authentication = 11;</code>
   *
   * @return Whether the authentication field is set.
   */
  @java.lang.Override
  public boolean hasAuthentication() {
    return authentication_ != null;
  }
  /**
   *
   *
   * <pre>
   * Auth configuration. Contains only the OAuth rules.
   * </pre>
   *
   * <code>.google.api.Authentication authentication = 11;</code>
   *
   * @return The authentication.
   */
  @java.lang.Override
  public com.google.api.Authentication getAuthentication() {
    return authentication_ == null
        ? com.google.api.Authentication.getDefaultInstance()
        : authentication_;
  }
  /**
   *
   *
   * <pre>
   * Auth configuration. Contains only the OAuth rules.
   * </pre>
   *
   * <code>.google.api.Authentication authentication = 11;</code>
   */
  @java.lang.Override
  public com.google.api.AuthenticationOrBuilder getAuthenticationOrBuilder() {
    return getAuthentication();
  }

  public static final int USAGE_FIELD_NUMBER = 15;
  private com.google.api.Usage usage_;
  /**
   *
   *
   * <pre>
   * Configuration controlling usage of this service.
   * </pre>
   *
   * <code>.google.api.Usage usage = 15;</code>
   *
   * @return Whether the usage field is set.
   */
  @java.lang.Override
  public boolean hasUsage() {
    return usage_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration controlling usage of this service.
   * </pre>
   *
   * <code>.google.api.Usage usage = 15;</code>
   *
   * @return The usage.
   */
  @java.lang.Override
  public com.google.api.Usage getUsage() {
    return usage_ == null ? com.google.api.Usage.getDefaultInstance() : usage_;
  }
  /**
   *
   *
   * <pre>
   * Configuration controlling usage of this service.
   * </pre>
   *
   * <code>.google.api.Usage usage = 15;</code>
   */
  @java.lang.Override
  public com.google.api.UsageOrBuilder getUsageOrBuilder() {
    return getUsage();
  }

  public static final int ENDPOINTS_FIELD_NUMBER = 18;
  private java.util.List<com.google.api.Endpoint> endpoints_;
  /**
   *
   *
   * <pre>
   * Configuration for network endpoints. Contains only the names and aliases
   * of the endpoints.
   * </pre>
   *
   * <code>repeated .google.api.Endpoint endpoints = 18;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.Endpoint> getEndpointsList() {
    return endpoints_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for network endpoints. Contains only the names and aliases
   * of the endpoints.
   * </pre>
   *
   * <code>repeated .google.api.Endpoint endpoints = 18;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.EndpointOrBuilder> getEndpointsOrBuilderList() {
    return endpoints_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for network endpoints. Contains only the names and aliases
   * of the endpoints.
   * </pre>
   *
   * <code>repeated .google.api.Endpoint endpoints = 18;</code>
   */
  @java.lang.Override
  public int getEndpointsCount() {
    return endpoints_.size();
  }
  /**
   *
   *
   * <pre>
   * Configuration for network endpoints. Contains only the names and aliases
   * of the endpoints.
   * </pre>
   *
   * <code>repeated .google.api.Endpoint endpoints = 18;</code>
   */
  @java.lang.Override
  public com.google.api.Endpoint getEndpoints(int index) {
    return endpoints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Configuration for network endpoints. Contains only the names and aliases
   * of the endpoints.
   * </pre>
   *
   * <code>repeated .google.api.Endpoint endpoints = 18;</code>
   */
  @java.lang.Override
  public com.google.api.EndpointOrBuilder getEndpointsOrBuilder(int index) {
    return endpoints_.get(index);
  }

  public static final int MONITORED_RESOURCES_FIELD_NUMBER = 25;
  private java.util.List<com.google.api.MonitoredResourceDescriptor> monitoredResources_;
  /**
   *
   *
   * <pre>
   * Defines the monitored resources used by this service. This is required
   * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
   * </pre>
   *
   * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.MonitoredResourceDescriptor> getMonitoredResourcesList() {
    return monitoredResources_;
  }
  /**
   *
   *
   * <pre>
   * Defines the monitored resources used by this service. This is required
   * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
   * </pre>
   *
   * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.MonitoredResourceDescriptorOrBuilder>
      getMonitoredResourcesOrBuilderList() {
    return monitoredResources_;
  }
  /**
   *
   *
   * <pre>
   * Defines the monitored resources used by this service. This is required
   * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
   * </pre>
   *
   * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
   */
  @java.lang.Override
  public int getMonitoredResourcesCount() {
    return monitoredResources_.size();
  }
  /**
   *
   *
   * <pre>
   * Defines the monitored resources used by this service. This is required
   * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
   * </pre>
   *
   * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
   */
  @java.lang.Override
  public com.google.api.MonitoredResourceDescriptor getMonitoredResources(int index) {
    return monitoredResources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Defines the monitored resources used by this service. This is required
   * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
   * </pre>
   *
   * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
   */
  @java.lang.Override
  public com.google.api.MonitoredResourceDescriptorOrBuilder getMonitoredResourcesOrBuilder(
      int index) {
    return monitoredResources_.get(index);
  }

  public static final int MONITORING_FIELD_NUMBER = 28;
  private com.google.api.Monitoring monitoring_;
  /**
   *
   *
   * <pre>
   * Monitoring configuration.
   * This should not include the 'producer_destinations' field.
   * </pre>
   *
   * <code>.google.api.Monitoring monitoring = 28;</code>
   *
   * @return Whether the monitoring field is set.
   */
  @java.lang.Override
  public boolean hasMonitoring() {
    return monitoring_ != null;
  }
  /**
   *
   *
   * <pre>
   * Monitoring configuration.
   * This should not include the 'producer_destinations' field.
   * </pre>
   *
   * <code>.google.api.Monitoring monitoring = 28;</code>
   *
   * @return The monitoring.
   */
  @java.lang.Override
  public com.google.api.Monitoring getMonitoring() {
    return monitoring_ == null ? com.google.api.Monitoring.getDefaultInstance() : monitoring_;
  }
  /**
   *
   *
   * <pre>
   * Monitoring configuration.
   * This should not include the 'producer_destinations' field.
   * </pre>
   *
   * <code>.google.api.Monitoring monitoring = 28;</code>
   */
  @java.lang.Override
  public com.google.api.MonitoringOrBuilder getMonitoringOrBuilder() {
    return getMonitoring();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, title_);
    }
    for (int i = 0; i < apis_.size(); i++) {
      output.writeMessage(3, apis_.get(i));
    }
    if (documentation_ != null) {
      output.writeMessage(6, getDocumentation());
    }
    if (quota_ != null) {
      output.writeMessage(10, getQuota());
    }
    if (authentication_ != null) {
      output.writeMessage(11, getAuthentication());
    }
    if (usage_ != null) {
      output.writeMessage(15, getUsage());
    }
    for (int i = 0; i < endpoints_.size(); i++) {
      output.writeMessage(18, endpoints_.get(i));
    }
    for (int i = 0; i < monitoredResources_.size(); i++) {
      output.writeMessage(25, monitoredResources_.get(i));
    }
    if (monitoring_ != null) {
      output.writeMessage(28, getMonitoring());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, title_);
    }
    for (int i = 0; i < apis_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, apis_.get(i));
    }
    if (documentation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDocumentation());
    }
    if (quota_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getQuota());
    }
    if (authentication_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getAuthentication());
    }
    if (usage_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getUsage());
    }
    for (int i = 0; i < endpoints_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, endpoints_.get(i));
    }
    for (int i = 0; i < monitoredResources_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(25, monitoredResources_.get(i));
    }
    if (monitoring_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(28, getMonitoring());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.serviceusage.v1beta1.ServiceConfig)) {
      return super.equals(obj);
    }
    com.google.api.serviceusage.v1beta1.ServiceConfig other =
        (com.google.api.serviceusage.v1beta1.ServiceConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTitle().equals(other.getTitle())) return false;
    if (!getApisList().equals(other.getApisList())) return false;
    if (hasDocumentation() != other.hasDocumentation()) return false;
    if (hasDocumentation()) {
      if (!getDocumentation().equals(other.getDocumentation())) return false;
    }
    if (hasQuota() != other.hasQuota()) return false;
    if (hasQuota()) {
      if (!getQuota().equals(other.getQuota())) return false;
    }
    if (hasAuthentication() != other.hasAuthentication()) return false;
    if (hasAuthentication()) {
      if (!getAuthentication().equals(other.getAuthentication())) return false;
    }
    if (hasUsage() != other.hasUsage()) return false;
    if (hasUsage()) {
      if (!getUsage().equals(other.getUsage())) return false;
    }
    if (!getEndpointsList().equals(other.getEndpointsList())) return false;
    if (!getMonitoredResourcesList().equals(other.getMonitoredResourcesList())) return false;
    if (hasMonitoring() != other.hasMonitoring()) return false;
    if (hasMonitoring()) {
      if (!getMonitoring().equals(other.getMonitoring())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TITLE_FIELD_NUMBER;
    hash = (53 * hash) + getTitle().hashCode();
    if (getApisCount() > 0) {
      hash = (37 * hash) + APIS_FIELD_NUMBER;
      hash = (53 * hash) + getApisList().hashCode();
    }
    if (hasDocumentation()) {
      hash = (37 * hash) + DOCUMENTATION_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentation().hashCode();
    }
    if (hasQuota()) {
      hash = (37 * hash) + QUOTA_FIELD_NUMBER;
      hash = (53 * hash) + getQuota().hashCode();
    }
    if (hasAuthentication()) {
      hash = (37 * hash) + AUTHENTICATION_FIELD_NUMBER;
      hash = (53 * hash) + getAuthentication().hashCode();
    }
    if (hasUsage()) {
      hash = (37 * hash) + USAGE_FIELD_NUMBER;
      hash = (53 * hash) + getUsage().hashCode();
    }
    if (getEndpointsCount() > 0) {
      hash = (37 * hash) + ENDPOINTS_FIELD_NUMBER;
      hash = (53 * hash) + getEndpointsList().hashCode();
    }
    if (getMonitoredResourcesCount() > 0) {
      hash = (37 * hash) + MONITORED_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoredResourcesList().hashCode();
    }
    if (hasMonitoring()) {
      hash = (37 * hash) + MONITORING_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoring().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.serviceusage.v1beta1.ServiceConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration of the service.
   * </pre>
   *
   * Protobuf type {@code google.api.serviceusage.v1beta1.ServiceConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.serviceusage.v1beta1.ServiceConfig)
      com.google.api.serviceusage.v1beta1.ServiceConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_ServiceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_ServiceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.serviceusage.v1beta1.ServiceConfig.class,
              com.google.api.serviceusage.v1beta1.ServiceConfig.Builder.class);
    }

    // Construct using com.google.api.serviceusage.v1beta1.ServiceConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      title_ = "";

      if (apisBuilder_ == null) {
        apis_ = java.util.Collections.emptyList();
      } else {
        apis_ = null;
        apisBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (documentationBuilder_ == null) {
        documentation_ = null;
      } else {
        documentation_ = null;
        documentationBuilder_ = null;
      }
      if (quotaBuilder_ == null) {
        quota_ = null;
      } else {
        quota_ = null;
        quotaBuilder_ = null;
      }
      if (authenticationBuilder_ == null) {
        authentication_ = null;
      } else {
        authentication_ = null;
        authenticationBuilder_ = null;
      }
      if (usageBuilder_ == null) {
        usage_ = null;
      } else {
        usage_ = null;
        usageBuilder_ = null;
      }
      if (endpointsBuilder_ == null) {
        endpoints_ = java.util.Collections.emptyList();
      } else {
        endpoints_ = null;
        endpointsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (monitoredResourcesBuilder_ == null) {
        monitoredResources_ = java.util.Collections.emptyList();
      } else {
        monitoredResources_ = null;
        monitoredResourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (monitoringBuilder_ == null) {
        monitoring_ = null;
      } else {
        monitoring_ = null;
        monitoringBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_ServiceConfig_descriptor;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.ServiceConfig getDefaultInstanceForType() {
      return com.google.api.serviceusage.v1beta1.ServiceConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.ServiceConfig build() {
      com.google.api.serviceusage.v1beta1.ServiceConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.ServiceConfig buildPartial() {
      com.google.api.serviceusage.v1beta1.ServiceConfig result =
          new com.google.api.serviceusage.v1beta1.ServiceConfig(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.title_ = title_;
      if (apisBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          apis_ = java.util.Collections.unmodifiableList(apis_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.apis_ = apis_;
      } else {
        result.apis_ = apisBuilder_.build();
      }
      if (documentationBuilder_ == null) {
        result.documentation_ = documentation_;
      } else {
        result.documentation_ = documentationBuilder_.build();
      }
      if (quotaBuilder_ == null) {
        result.quota_ = quota_;
      } else {
        result.quota_ = quotaBuilder_.build();
      }
      if (authenticationBuilder_ == null) {
        result.authentication_ = authentication_;
      } else {
        result.authentication_ = authenticationBuilder_.build();
      }
      if (usageBuilder_ == null) {
        result.usage_ = usage_;
      } else {
        result.usage_ = usageBuilder_.build();
      }
      if (endpointsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          endpoints_ = java.util.Collections.unmodifiableList(endpoints_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.endpoints_ = endpoints_;
      } else {
        result.endpoints_ = endpointsBuilder_.build();
      }
      if (monitoredResourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          monitoredResources_ = java.util.Collections.unmodifiableList(monitoredResources_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.monitoredResources_ = monitoredResources_;
      } else {
        result.monitoredResources_ = monitoredResourcesBuilder_.build();
      }
      if (monitoringBuilder_ == null) {
        result.monitoring_ = monitoring_;
      } else {
        result.monitoring_ = monitoringBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.serviceusage.v1beta1.ServiceConfig) {
        return mergeFrom((com.google.api.serviceusage.v1beta1.ServiceConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.serviceusage.v1beta1.ServiceConfig other) {
      if (other == com.google.api.serviceusage.v1beta1.ServiceConfig.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getTitle().isEmpty()) {
        title_ = other.title_;
        onChanged();
      }
      if (apisBuilder_ == null) {
        if (!other.apis_.isEmpty()) {
          if (apis_.isEmpty()) {
            apis_ = other.apis_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureApisIsMutable();
            apis_.addAll(other.apis_);
          }
          onChanged();
        }
      } else {
        if (!other.apis_.isEmpty()) {
          if (apisBuilder_.isEmpty()) {
            apisBuilder_.dispose();
            apisBuilder_ = null;
            apis_ = other.apis_;
            bitField0_ = (bitField0_ & ~0x00000001);
            apisBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getApisFieldBuilder()
                    : null;
          } else {
            apisBuilder_.addAllMessages(other.apis_);
          }
        }
      }
      if (other.hasDocumentation()) {
        mergeDocumentation(other.getDocumentation());
      }
      if (other.hasQuota()) {
        mergeQuota(other.getQuota());
      }
      if (other.hasAuthentication()) {
        mergeAuthentication(other.getAuthentication());
      }
      if (other.hasUsage()) {
        mergeUsage(other.getUsage());
      }
      if (endpointsBuilder_ == null) {
        if (!other.endpoints_.isEmpty()) {
          if (endpoints_.isEmpty()) {
            endpoints_ = other.endpoints_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureEndpointsIsMutable();
            endpoints_.addAll(other.endpoints_);
          }
          onChanged();
        }
      } else {
        if (!other.endpoints_.isEmpty()) {
          if (endpointsBuilder_.isEmpty()) {
            endpointsBuilder_.dispose();
            endpointsBuilder_ = null;
            endpoints_ = other.endpoints_;
            bitField0_ = (bitField0_ & ~0x00000002);
            endpointsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEndpointsFieldBuilder()
                    : null;
          } else {
            endpointsBuilder_.addAllMessages(other.endpoints_);
          }
        }
      }
      if (monitoredResourcesBuilder_ == null) {
        if (!other.monitoredResources_.isEmpty()) {
          if (monitoredResources_.isEmpty()) {
            monitoredResources_ = other.monitoredResources_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureMonitoredResourcesIsMutable();
            monitoredResources_.addAll(other.monitoredResources_);
          }
          onChanged();
        }
      } else {
        if (!other.monitoredResources_.isEmpty()) {
          if (monitoredResourcesBuilder_.isEmpty()) {
            monitoredResourcesBuilder_.dispose();
            monitoredResourcesBuilder_ = null;
            monitoredResources_ = other.monitoredResources_;
            bitField0_ = (bitField0_ & ~0x00000004);
            monitoredResourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMonitoredResourcesFieldBuilder()
                    : null;
          } else {
            monitoredResourcesBuilder_.addAllMessages(other.monitoredResources_);
          }
        }
      }
      if (other.hasMonitoring()) {
        mergeMonitoring(other.getMonitoring());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                title_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.Api m =
                    input.readMessage(com.google.protobuf.Api.parser(), extensionRegistry);
                if (apisBuilder_ == null) {
                  ensureApisIsMutable();
                  apis_.add(m);
                } else {
                  apisBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 50:
              {
                input.readMessage(getDocumentationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 82:
              {
                input.readMessage(getQuotaFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 82
            case 90:
              {
                input.readMessage(getAuthenticationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 90
            case 122:
              {
                input.readMessage(getUsageFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 122
            case 146:
              {
                com.google.api.Endpoint m =
                    input.readMessage(com.google.api.Endpoint.parser(), extensionRegistry);
                if (endpointsBuilder_ == null) {
                  ensureEndpointsIsMutable();
                  endpoints_.add(m);
                } else {
                  endpointsBuilder_.addMessage(m);
                }
                break;
              } // case 146
            case 202:
              {
                com.google.api.MonitoredResourceDescriptor m =
                    input.readMessage(
                        com.google.api.MonitoredResourceDescriptor.parser(), extensionRegistry);
                if (monitoredResourcesBuilder_ == null) {
                  ensureMonitoredResourcesIsMutable();
                  monitoredResources_.add(m);
                } else {
                  monitoredResourcesBuilder_.addMessage(m);
                }
                break;
              } // case 202
            case 226:
              {
                input.readMessage(getMonitoringFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 226
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The DNS address at which this service is available.
     * An example DNS address would be:
     * `calendar.googleapis.com`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The DNS address at which this service is available.
     * An example DNS address would be:
     * `calendar.googleapis.com`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The DNS address at which this service is available.
     * An example DNS address would be:
     * `calendar.googleapis.com`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DNS address at which this service is available.
     * An example DNS address would be:
     * `calendar.googleapis.com`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DNS address at which this service is available.
     * An example DNS address would be:
     * `calendar.googleapis.com`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object title_ = "";
    /**
     *
     *
     * <pre>
     * The product title for this service.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return The title.
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The product title for this service.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return The bytes for title.
     */
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The product title for this service.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @param value The title to set.
     * @return This builder for chaining.
     */
    public Builder setTitle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      title_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product title for this service.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTitle() {

      title_ = getDefaultInstance().getTitle();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The product title for this service.
     * </pre>
     *
     * <code>string title = 2;</code>
     *
     * @param value The bytes for title to set.
     * @return This builder for chaining.
     */
    public Builder setTitleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      title_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.protobuf.Api> apis_ = java.util.Collections.emptyList();

    private void ensureApisIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        apis_ = new java.util.ArrayList<com.google.protobuf.Api>(apis_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Api,
            com.google.protobuf.Api.Builder,
            com.google.protobuf.ApiOrBuilder>
        apisBuilder_;

    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public java.util.List<com.google.protobuf.Api> getApisList() {
      if (apisBuilder_ == null) {
        return java.util.Collections.unmodifiableList(apis_);
      } else {
        return apisBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public int getApisCount() {
      if (apisBuilder_ == null) {
        return apis_.size();
      } else {
        return apisBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public com.google.protobuf.Api getApis(int index) {
      if (apisBuilder_ == null) {
        return apis_.get(index);
      } else {
        return apisBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder setApis(int index, com.google.protobuf.Api value) {
      if (apisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureApisIsMutable();
        apis_.set(index, value);
        onChanged();
      } else {
        apisBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder setApis(int index, com.google.protobuf.Api.Builder builderForValue) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        apis_.set(index, builderForValue.build());
        onChanged();
      } else {
        apisBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder addApis(com.google.protobuf.Api value) {
      if (apisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureApisIsMutable();
        apis_.add(value);
        onChanged();
      } else {
        apisBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder addApis(int index, com.google.protobuf.Api value) {
      if (apisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureApisIsMutable();
        apis_.add(index, value);
        onChanged();
      } else {
        apisBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder addApis(com.google.protobuf.Api.Builder builderForValue) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        apis_.add(builderForValue.build());
        onChanged();
      } else {
        apisBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder addApis(int index, com.google.protobuf.Api.Builder builderForValue) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        apis_.add(index, builderForValue.build());
        onChanged();
      } else {
        apisBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder addAllApis(java.lang.Iterable<? extends com.google.protobuf.Api> values) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, apis_);
        onChanged();
      } else {
        apisBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder clearApis() {
      if (apisBuilder_ == null) {
        apis_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        apisBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public Builder removeApis(int index) {
      if (apisBuilder_ == null) {
        ensureApisIsMutable();
        apis_.remove(index);
        onChanged();
      } else {
        apisBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public com.google.protobuf.Api.Builder getApisBuilder(int index) {
      return getApisFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public com.google.protobuf.ApiOrBuilder getApisOrBuilder(int index) {
      if (apisBuilder_ == null) {
        return apis_.get(index);
      } else {
        return apisBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public java.util.List<? extends com.google.protobuf.ApiOrBuilder> getApisOrBuilderList() {
      if (apisBuilder_ != null) {
        return apisBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(apis_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public com.google.protobuf.Api.Builder addApisBuilder() {
      return getApisFieldBuilder().addBuilder(com.google.protobuf.Api.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public com.google.protobuf.Api.Builder addApisBuilder(int index) {
      return getApisFieldBuilder().addBuilder(index, com.google.protobuf.Api.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of API interfaces exported by this service. Contains only the names,
     * versions, and method names of the interfaces.
     * </pre>
     *
     * <code>repeated .google.protobuf.Api apis = 3;</code>
     */
    public java.util.List<com.google.protobuf.Api.Builder> getApisBuilderList() {
      return getApisFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Api,
            com.google.protobuf.Api.Builder,
            com.google.protobuf.ApiOrBuilder>
        getApisFieldBuilder() {
      if (apisBuilder_ == null) {
        apisBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Api,
                com.google.protobuf.Api.Builder,
                com.google.protobuf.ApiOrBuilder>(
                apis_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        apis_ = null;
      }
      return apisBuilder_;
    }

    private com.google.api.Documentation documentation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Documentation,
            com.google.api.Documentation.Builder,
            com.google.api.DocumentationOrBuilder>
        documentationBuilder_;
    /**
     *
     *
     * <pre>
     * Additional API documentation. Contains only the summary and the
     * documentation URL.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     *
     * @return Whether the documentation field is set.
     */
    public boolean hasDocumentation() {
      return documentationBuilder_ != null || documentation_ != null;
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation. Contains only the summary and the
     * documentation URL.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     *
     * @return The documentation.
     */
    public com.google.api.Documentation getDocumentation() {
      if (documentationBuilder_ == null) {
        return documentation_ == null
            ? com.google.api.Documentation.getDefaultInstance()
            : documentation_;
      } else {
        return documentationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation. Contains only the summary and the
     * documentation URL.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    public Builder setDocumentation(com.google.api.Documentation value) {
      if (documentationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentation_ = value;
        onChanged();
      } else {
        documentationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation. Contains only the summary and the
     * documentation URL.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    public Builder setDocumentation(com.google.api.Documentation.Builder builderForValue) {
      if (documentationBuilder_ == null) {
        documentation_ = builderForValue.build();
        onChanged();
      } else {
        documentationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation. Contains only the summary and the
     * documentation URL.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    public Builder mergeDocumentation(com.google.api.Documentation value) {
      if (documentationBuilder_ == null) {
        if (documentation_ != null) {
          documentation_ =
              com.google.api.Documentation.newBuilder(documentation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          documentation_ = value;
        }
        onChanged();
      } else {
        documentationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation. Contains only the summary and the
     * documentation URL.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    public Builder clearDocumentation() {
      if (documentationBuilder_ == null) {
        documentation_ = null;
        onChanged();
      } else {
        documentation_ = null;
        documentationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation. Contains only the summary and the
     * documentation URL.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    public com.google.api.Documentation.Builder getDocumentationBuilder() {

      onChanged();
      return getDocumentationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation. Contains only the summary and the
     * documentation URL.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    public com.google.api.DocumentationOrBuilder getDocumentationOrBuilder() {
      if (documentationBuilder_ != null) {
        return documentationBuilder_.getMessageOrBuilder();
      } else {
        return documentation_ == null
            ? com.google.api.Documentation.getDefaultInstance()
            : documentation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional API documentation. Contains only the summary and the
     * documentation URL.
     * </pre>
     *
     * <code>.google.api.Documentation documentation = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Documentation,
            com.google.api.Documentation.Builder,
            com.google.api.DocumentationOrBuilder>
        getDocumentationFieldBuilder() {
      if (documentationBuilder_ == null) {
        documentationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Documentation,
                com.google.api.Documentation.Builder,
                com.google.api.DocumentationOrBuilder>(
                getDocumentation(), getParentForChildren(), isClean());
        documentation_ = null;
      }
      return documentationBuilder_;
    }

    private com.google.api.Quota quota_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Quota, com.google.api.Quota.Builder, com.google.api.QuotaOrBuilder>
        quotaBuilder_;
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     *
     * @return Whether the quota field is set.
     */
    public boolean hasQuota() {
      return quotaBuilder_ != null || quota_ != null;
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     *
     * @return The quota.
     */
    public com.google.api.Quota getQuota() {
      if (quotaBuilder_ == null) {
        return quota_ == null ? com.google.api.Quota.getDefaultInstance() : quota_;
      } else {
        return quotaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    public Builder setQuota(com.google.api.Quota value) {
      if (quotaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        quota_ = value;
        onChanged();
      } else {
        quotaBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    public Builder setQuota(com.google.api.Quota.Builder builderForValue) {
      if (quotaBuilder_ == null) {
        quota_ = builderForValue.build();
        onChanged();
      } else {
        quotaBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    public Builder mergeQuota(com.google.api.Quota value) {
      if (quotaBuilder_ == null) {
        if (quota_ != null) {
          quota_ = com.google.api.Quota.newBuilder(quota_).mergeFrom(value).buildPartial();
        } else {
          quota_ = value;
        }
        onChanged();
      } else {
        quotaBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    public Builder clearQuota() {
      if (quotaBuilder_ == null) {
        quota_ = null;
        onChanged();
      } else {
        quota_ = null;
        quotaBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    public com.google.api.Quota.Builder getQuotaBuilder() {

      onChanged();
      return getQuotaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    public com.google.api.QuotaOrBuilder getQuotaOrBuilder() {
      if (quotaBuilder_ != null) {
        return quotaBuilder_.getMessageOrBuilder();
      } else {
        return quota_ == null ? com.google.api.Quota.getDefaultInstance() : quota_;
      }
    }
    /**
     *
     *
     * <pre>
     * Quota configuration.
     * </pre>
     *
     * <code>.google.api.Quota quota = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Quota, com.google.api.Quota.Builder, com.google.api.QuotaOrBuilder>
        getQuotaFieldBuilder() {
      if (quotaBuilder_ == null) {
        quotaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Quota, com.google.api.Quota.Builder, com.google.api.QuotaOrBuilder>(
                getQuota(), getParentForChildren(), isClean());
        quota_ = null;
      }
      return quotaBuilder_;
    }

    private com.google.api.Authentication authentication_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Authentication,
            com.google.api.Authentication.Builder,
            com.google.api.AuthenticationOrBuilder>
        authenticationBuilder_;
    /**
     *
     *
     * <pre>
     * Auth configuration. Contains only the OAuth rules.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     *
     * @return Whether the authentication field is set.
     */
    public boolean hasAuthentication() {
      return authenticationBuilder_ != null || authentication_ != null;
    }
    /**
     *
     *
     * <pre>
     * Auth configuration. Contains only the OAuth rules.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     *
     * @return The authentication.
     */
    public com.google.api.Authentication getAuthentication() {
      if (authenticationBuilder_ == null) {
        return authentication_ == null
            ? com.google.api.Authentication.getDefaultInstance()
            : authentication_;
      } else {
        return authenticationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Auth configuration. Contains only the OAuth rules.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    public Builder setAuthentication(com.google.api.Authentication value) {
      if (authenticationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authentication_ = value;
        onChanged();
      } else {
        authenticationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Auth configuration. Contains only the OAuth rules.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    public Builder setAuthentication(com.google.api.Authentication.Builder builderForValue) {
      if (authenticationBuilder_ == null) {
        authentication_ = builderForValue.build();
        onChanged();
      } else {
        authenticationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Auth configuration. Contains only the OAuth rules.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    public Builder mergeAuthentication(com.google.api.Authentication value) {
      if (authenticationBuilder_ == null) {
        if (authentication_ != null) {
          authentication_ =
              com.google.api.Authentication.newBuilder(authentication_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authentication_ = value;
        }
        onChanged();
      } else {
        authenticationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Auth configuration. Contains only the OAuth rules.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    public Builder clearAuthentication() {
      if (authenticationBuilder_ == null) {
        authentication_ = null;
        onChanged();
      } else {
        authentication_ = null;
        authenticationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Auth configuration. Contains only the OAuth rules.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    public com.google.api.Authentication.Builder getAuthenticationBuilder() {

      onChanged();
      return getAuthenticationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Auth configuration. Contains only the OAuth rules.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    public com.google.api.AuthenticationOrBuilder getAuthenticationOrBuilder() {
      if (authenticationBuilder_ != null) {
        return authenticationBuilder_.getMessageOrBuilder();
      } else {
        return authentication_ == null
            ? com.google.api.Authentication.getDefaultInstance()
            : authentication_;
      }
    }
    /**
     *
     *
     * <pre>
     * Auth configuration. Contains only the OAuth rules.
     * </pre>
     *
     * <code>.google.api.Authentication authentication = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Authentication,
            com.google.api.Authentication.Builder,
            com.google.api.AuthenticationOrBuilder>
        getAuthenticationFieldBuilder() {
      if (authenticationBuilder_ == null) {
        authenticationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Authentication,
                com.google.api.Authentication.Builder,
                com.google.api.AuthenticationOrBuilder>(
                getAuthentication(), getParentForChildren(), isClean());
        authentication_ = null;
      }
      return authenticationBuilder_;
    }

    private com.google.api.Usage usage_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Usage, com.google.api.Usage.Builder, com.google.api.UsageOrBuilder>
        usageBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     *
     * @return Whether the usage field is set.
     */
    public boolean hasUsage() {
      return usageBuilder_ != null || usage_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     *
     * @return The usage.
     */
    public com.google.api.Usage getUsage() {
      if (usageBuilder_ == null) {
        return usage_ == null ? com.google.api.Usage.getDefaultInstance() : usage_;
      } else {
        return usageBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    public Builder setUsage(com.google.api.Usage value) {
      if (usageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        usage_ = value;
        onChanged();
      } else {
        usageBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    public Builder setUsage(com.google.api.Usage.Builder builderForValue) {
      if (usageBuilder_ == null) {
        usage_ = builderForValue.build();
        onChanged();
      } else {
        usageBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    public Builder mergeUsage(com.google.api.Usage value) {
      if (usageBuilder_ == null) {
        if (usage_ != null) {
          usage_ = com.google.api.Usage.newBuilder(usage_).mergeFrom(value).buildPartial();
        } else {
          usage_ = value;
        }
        onChanged();
      } else {
        usageBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    public Builder clearUsage() {
      if (usageBuilder_ == null) {
        usage_ = null;
        onChanged();
      } else {
        usage_ = null;
        usageBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    public com.google.api.Usage.Builder getUsageBuilder() {

      onChanged();
      return getUsageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    public com.google.api.UsageOrBuilder getUsageOrBuilder() {
      if (usageBuilder_ != null) {
        return usageBuilder_.getMessageOrBuilder();
      } else {
        return usage_ == null ? com.google.api.Usage.getDefaultInstance() : usage_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration controlling usage of this service.
     * </pre>
     *
     * <code>.google.api.Usage usage = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Usage, com.google.api.Usage.Builder, com.google.api.UsageOrBuilder>
        getUsageFieldBuilder() {
      if (usageBuilder_ == null) {
        usageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Usage, com.google.api.Usage.Builder, com.google.api.UsageOrBuilder>(
                getUsage(), getParentForChildren(), isClean());
        usage_ = null;
      }
      return usageBuilder_;
    }

    private java.util.List<com.google.api.Endpoint> endpoints_ = java.util.Collections.emptyList();

    private void ensureEndpointsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        endpoints_ = new java.util.ArrayList<com.google.api.Endpoint>(endpoints_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Endpoint,
            com.google.api.Endpoint.Builder,
            com.google.api.EndpointOrBuilder>
        endpointsBuilder_;

    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public java.util.List<com.google.api.Endpoint> getEndpointsList() {
      if (endpointsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(endpoints_);
      } else {
        return endpointsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public int getEndpointsCount() {
      if (endpointsBuilder_ == null) {
        return endpoints_.size();
      } else {
        return endpointsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public com.google.api.Endpoint getEndpoints(int index) {
      if (endpointsBuilder_ == null) {
        return endpoints_.get(index);
      } else {
        return endpointsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder setEndpoints(int index, com.google.api.Endpoint value) {
      if (endpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndpointsIsMutable();
        endpoints_.set(index, value);
        onChanged();
      } else {
        endpointsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder setEndpoints(int index, com.google.api.Endpoint.Builder builderForValue) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        endpoints_.set(index, builderForValue.build());
        onChanged();
      } else {
        endpointsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder addEndpoints(com.google.api.Endpoint value) {
      if (endpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndpointsIsMutable();
        endpoints_.add(value);
        onChanged();
      } else {
        endpointsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder addEndpoints(int index, com.google.api.Endpoint value) {
      if (endpointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEndpointsIsMutable();
        endpoints_.add(index, value);
        onChanged();
      } else {
        endpointsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder addEndpoints(com.google.api.Endpoint.Builder builderForValue) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        endpoints_.add(builderForValue.build());
        onChanged();
      } else {
        endpointsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder addEndpoints(int index, com.google.api.Endpoint.Builder builderForValue) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        endpoints_.add(index, builderForValue.build());
        onChanged();
      } else {
        endpointsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder addAllEndpoints(java.lang.Iterable<? extends com.google.api.Endpoint> values) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, endpoints_);
        onChanged();
      } else {
        endpointsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder clearEndpoints() {
      if (endpointsBuilder_ == null) {
        endpoints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        endpointsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public Builder removeEndpoints(int index) {
      if (endpointsBuilder_ == null) {
        ensureEndpointsIsMutable();
        endpoints_.remove(index);
        onChanged();
      } else {
        endpointsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public com.google.api.Endpoint.Builder getEndpointsBuilder(int index) {
      return getEndpointsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public com.google.api.EndpointOrBuilder getEndpointsOrBuilder(int index) {
      if (endpointsBuilder_ == null) {
        return endpoints_.get(index);
      } else {
        return endpointsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public java.util.List<? extends com.google.api.EndpointOrBuilder> getEndpointsOrBuilderList() {
      if (endpointsBuilder_ != null) {
        return endpointsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(endpoints_);
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public com.google.api.Endpoint.Builder addEndpointsBuilder() {
      return getEndpointsFieldBuilder().addBuilder(com.google.api.Endpoint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public com.google.api.Endpoint.Builder addEndpointsBuilder(int index) {
      return getEndpointsFieldBuilder()
          .addBuilder(index, com.google.api.Endpoint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Configuration for network endpoints. Contains only the names and aliases
     * of the endpoints.
     * </pre>
     *
     * <code>repeated .google.api.Endpoint endpoints = 18;</code>
     */
    public java.util.List<com.google.api.Endpoint.Builder> getEndpointsBuilderList() {
      return getEndpointsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Endpoint,
            com.google.api.Endpoint.Builder,
            com.google.api.EndpointOrBuilder>
        getEndpointsFieldBuilder() {
      if (endpointsBuilder_ == null) {
        endpointsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.Endpoint,
                com.google.api.Endpoint.Builder,
                com.google.api.EndpointOrBuilder>(
                endpoints_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        endpoints_ = null;
      }
      return endpointsBuilder_;
    }

    private java.util.List<com.google.api.MonitoredResourceDescriptor> monitoredResources_ =
        java.util.Collections.emptyList();

    private void ensureMonitoredResourcesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        monitoredResources_ =
            new java.util.ArrayList<com.google.api.MonitoredResourceDescriptor>(
                monitoredResources_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.MonitoredResourceDescriptor,
            com.google.api.MonitoredResourceDescriptor.Builder,
            com.google.api.MonitoredResourceDescriptorOrBuilder>
        monitoredResourcesBuilder_;

    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public java.util.List<com.google.api.MonitoredResourceDescriptor> getMonitoredResourcesList() {
      if (monitoredResourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(monitoredResources_);
      } else {
        return monitoredResourcesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public int getMonitoredResourcesCount() {
      if (monitoredResourcesBuilder_ == null) {
        return monitoredResources_.size();
      } else {
        return monitoredResourcesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public com.google.api.MonitoredResourceDescriptor getMonitoredResources(int index) {
      if (monitoredResourcesBuilder_ == null) {
        return monitoredResources_.get(index);
      } else {
        return monitoredResourcesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder setMonitoredResources(
        int index, com.google.api.MonitoredResourceDescriptor value) {
      if (monitoredResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.set(index, value);
        onChanged();
      } else {
        monitoredResourcesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder setMonitoredResources(
        int index, com.google.api.MonitoredResourceDescriptor.Builder builderForValue) {
      if (monitoredResourcesBuilder_ == null) {
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.set(index, builderForValue.build());
        onChanged();
      } else {
        monitoredResourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder addMonitoredResources(com.google.api.MonitoredResourceDescriptor value) {
      if (monitoredResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.add(value);
        onChanged();
      } else {
        monitoredResourcesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder addMonitoredResources(
        int index, com.google.api.MonitoredResourceDescriptor value) {
      if (monitoredResourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.add(index, value);
        onChanged();
      } else {
        monitoredResourcesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder addMonitoredResources(
        com.google.api.MonitoredResourceDescriptor.Builder builderForValue) {
      if (monitoredResourcesBuilder_ == null) {
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.add(builderForValue.build());
        onChanged();
      } else {
        monitoredResourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder addMonitoredResources(
        int index, com.google.api.MonitoredResourceDescriptor.Builder builderForValue) {
      if (monitoredResourcesBuilder_ == null) {
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.add(index, builderForValue.build());
        onChanged();
      } else {
        monitoredResourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder addAllMonitoredResources(
        java.lang.Iterable<? extends com.google.api.MonitoredResourceDescriptor> values) {
      if (monitoredResourcesBuilder_ == null) {
        ensureMonitoredResourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, monitoredResources_);
        onChanged();
      } else {
        monitoredResourcesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder clearMonitoredResources() {
      if (monitoredResourcesBuilder_ == null) {
        monitoredResources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        monitoredResourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public Builder removeMonitoredResources(int index) {
      if (monitoredResourcesBuilder_ == null) {
        ensureMonitoredResourcesIsMutable();
        monitoredResources_.remove(index);
        onChanged();
      } else {
        monitoredResourcesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public com.google.api.MonitoredResourceDescriptor.Builder getMonitoredResourcesBuilder(
        int index) {
      return getMonitoredResourcesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public com.google.api.MonitoredResourceDescriptorOrBuilder getMonitoredResourcesOrBuilder(
        int index) {
      if (monitoredResourcesBuilder_ == null) {
        return monitoredResources_.get(index);
      } else {
        return monitoredResourcesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public java.util.List<? extends com.google.api.MonitoredResourceDescriptorOrBuilder>
        getMonitoredResourcesOrBuilderList() {
      if (monitoredResourcesBuilder_ != null) {
        return monitoredResourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(monitoredResources_);
      }
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public com.google.api.MonitoredResourceDescriptor.Builder addMonitoredResourcesBuilder() {
      return getMonitoredResourcesFieldBuilder()
          .addBuilder(com.google.api.MonitoredResourceDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public com.google.api.MonitoredResourceDescriptor.Builder addMonitoredResourcesBuilder(
        int index) {
      return getMonitoredResourcesFieldBuilder()
          .addBuilder(index, com.google.api.MonitoredResourceDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Defines the monitored resources used by this service. This is required
     * by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
     * </pre>
     *
     * <code>repeated .google.api.MonitoredResourceDescriptor monitored_resources = 25;</code>
     */
    public java.util.List<com.google.api.MonitoredResourceDescriptor.Builder>
        getMonitoredResourcesBuilderList() {
      return getMonitoredResourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.MonitoredResourceDescriptor,
            com.google.api.MonitoredResourceDescriptor.Builder,
            com.google.api.MonitoredResourceDescriptorOrBuilder>
        getMonitoredResourcesFieldBuilder() {
      if (monitoredResourcesBuilder_ == null) {
        monitoredResourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.MonitoredResourceDescriptor,
                com.google.api.MonitoredResourceDescriptor.Builder,
                com.google.api.MonitoredResourceDescriptorOrBuilder>(
                monitoredResources_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        monitoredResources_ = null;
      }
      return monitoredResourcesBuilder_;
    }

    private com.google.api.Monitoring monitoring_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Monitoring,
            com.google.api.Monitoring.Builder,
            com.google.api.MonitoringOrBuilder>
        monitoringBuilder_;
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * This should not include the 'producer_destinations' field.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     *
     * @return Whether the monitoring field is set.
     */
    public boolean hasMonitoring() {
      return monitoringBuilder_ != null || monitoring_ != null;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * This should not include the 'producer_destinations' field.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     *
     * @return The monitoring.
     */
    public com.google.api.Monitoring getMonitoring() {
      if (monitoringBuilder_ == null) {
        return monitoring_ == null ? com.google.api.Monitoring.getDefaultInstance() : monitoring_;
      } else {
        return monitoringBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * This should not include the 'producer_destinations' field.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    public Builder setMonitoring(com.google.api.Monitoring value) {
      if (monitoringBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        monitoring_ = value;
        onChanged();
      } else {
        monitoringBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * This should not include the 'producer_destinations' field.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    public Builder setMonitoring(com.google.api.Monitoring.Builder builderForValue) {
      if (monitoringBuilder_ == null) {
        monitoring_ = builderForValue.build();
        onChanged();
      } else {
        monitoringBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * This should not include the 'producer_destinations' field.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    public Builder mergeMonitoring(com.google.api.Monitoring value) {
      if (monitoringBuilder_ == null) {
        if (monitoring_ != null) {
          monitoring_ =
              com.google.api.Monitoring.newBuilder(monitoring_).mergeFrom(value).buildPartial();
        } else {
          monitoring_ = value;
        }
        onChanged();
      } else {
        monitoringBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * This should not include the 'producer_destinations' field.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    public Builder clearMonitoring() {
      if (monitoringBuilder_ == null) {
        monitoring_ = null;
        onChanged();
      } else {
        monitoring_ = null;
        monitoringBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * This should not include the 'producer_destinations' field.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    public com.google.api.Monitoring.Builder getMonitoringBuilder() {

      onChanged();
      return getMonitoringFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * This should not include the 'producer_destinations' field.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    public com.google.api.MonitoringOrBuilder getMonitoringOrBuilder() {
      if (monitoringBuilder_ != null) {
        return monitoringBuilder_.getMessageOrBuilder();
      } else {
        return monitoring_ == null ? com.google.api.Monitoring.getDefaultInstance() : monitoring_;
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configuration.
     * This should not include the 'producer_destinations' field.
     * </pre>
     *
     * <code>.google.api.Monitoring monitoring = 28;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Monitoring,
            com.google.api.Monitoring.Builder,
            com.google.api.MonitoringOrBuilder>
        getMonitoringFieldBuilder() {
      if (monitoringBuilder_ == null) {
        monitoringBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Monitoring,
                com.google.api.Monitoring.Builder,
                com.google.api.MonitoringOrBuilder>(
                getMonitoring(), getParentForChildren(), isClean());
        monitoring_ = null;
      }
      return monitoringBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.serviceusage.v1beta1.ServiceConfig)
  }

  // @@protoc_insertion_point(class_scope:google.api.serviceusage.v1beta1.ServiceConfig)
  private static final com.google.api.serviceusage.v1beta1.ServiceConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.serviceusage.v1beta1.ServiceConfig();
  }

  public static com.google.api.serviceusage.v1beta1.ServiceConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServiceConfig> PARSER =
      new com.google.protobuf.AbstractParser<ServiceConfig>() {
        @java.lang.Override
        public ServiceConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServiceConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServiceConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.ServiceConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
