/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/serviceusage/v1beta1/resources.proto

package com.google.api.serviceusage.v1beta1;

/**
 *
 *
 * <pre>
 * A quota override
 * </pre>
 *
 * Protobuf type {@code google.api.serviceusage.v1beta1.QuotaOverride}
 */
public final class QuotaOverride extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.serviceusage.v1beta1.QuotaOverride)
    QuotaOverrideOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QuotaOverride.newBuilder() to construct.
  private QuotaOverride(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QuotaOverride() {
    name_ = "";
    metric_ = "";
    unit_ = "";
    adminOverrideAncestor_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QuotaOverride();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.serviceusage.v1beta1.ResourcesProto
        .internal_static_google_api_serviceusage_v1beta1_QuotaOverride_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetDimensions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.serviceusage.v1beta1.ResourcesProto
        .internal_static_google_api_serviceusage_v1beta1_QuotaOverride_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.serviceusage.v1beta1.QuotaOverride.class,
            com.google.api.serviceusage.v1beta1.QuotaOverride.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the override.
   * This name is generated by the server when the override is created.
   * Example names would be:
   * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminOverrides/4a3f2c1d`
   * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
   * The resource name is intended to be opaque and should not be parsed for
   * its component strings, since its representation could change in the future.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the override.
   * This name is generated by the server when the override is created.
   * Example names would be:
   * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminOverrides/4a3f2c1d`
   * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
   * The resource name is intended to be opaque and should not be parsed for
   * its component strings, since its representation could change in the future.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OVERRIDE_VALUE_FIELD_NUMBER = 2;
  private long overrideValue_;
  /**
   *
   *
   * <pre>
   * The overriding quota limit value.
   * Can be any nonnegative integer, or -1 (unlimited quota).
   * </pre>
   *
   * <code>int64 override_value = 2;</code>
   *
   * @return The overrideValue.
   */
  @java.lang.Override
  public long getOverrideValue() {
    return overrideValue_;
  }

  public static final int DIMENSIONS_FIELD_NUMBER = 3;

  private static final class DimensionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.api.serviceusage.v1beta1.ResourcesProto
                .internal_static_google_api_serviceusage_v1beta1_QuotaOverride_DimensionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> dimensions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetDimensions() {
    if (dimensions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(DimensionsDefaultEntryHolder.defaultEntry);
    }
    return dimensions_;
  }

  public int getDimensionsCount() {
    return internalGetDimensions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * If this map is nonempty, then this override applies only to specific values
   * for dimensions defined in the limit unit.
   * For example, an override on a limit with the unit `1/{project}/{region}`
   * could contain an entry with the key `region` and the value `us-east-1`;
   * the override is only applied to quota consumed in that region.
   * This map has the following restrictions:
   * *   Keys that are not defined in the limit's unit are not valid keys.
   *     Any string appearing in `{brackets}` in the unit (besides `{project}`
   *     or
   *     `{user}`) is a defined key.
   * *   `project` is not a valid key; the project is already specified in
   *     the parent resource name.
   * *   `user` is not a valid key; the API does not support quota overrides
   *     that apply only to a specific user.
   * *   If `region` appears as a key, its value must be a valid Cloud region.
   * *   If `zone` appears as a key, its value must be a valid Cloud zone.
   * *   If any valid key other than `region` or `zone` appears in the map, then
   *     all valid keys other than `region` or `zone` must also appear in the
   *     map.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 3;</code>
   */
  @java.lang.Override
  public boolean containsDimensions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDimensions().getMap().containsKey(key);
  }
  /** Use {@link #getDimensionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDimensions() {
    return getDimensionsMap();
  }
  /**
   *
   *
   * <pre>
   * If this map is nonempty, then this override applies only to specific values
   * for dimensions defined in the limit unit.
   * For example, an override on a limit with the unit `1/{project}/{region}`
   * could contain an entry with the key `region` and the value `us-east-1`;
   * the override is only applied to quota consumed in that region.
   * This map has the following restrictions:
   * *   Keys that are not defined in the limit's unit are not valid keys.
   *     Any string appearing in `{brackets}` in the unit (besides `{project}`
   *     or
   *     `{user}`) is a defined key.
   * *   `project` is not a valid key; the project is already specified in
   *     the parent resource name.
   * *   `user` is not a valid key; the API does not support quota overrides
   *     that apply only to a specific user.
   * *   If `region` appears as a key, its value must be a valid Cloud region.
   * *   If `zone` appears as a key, its value must be a valid Cloud zone.
   * *   If any valid key other than `region` or `zone` appears in the map, then
   *     all valid keys other than `region` or `zone` must also appear in the
   *     map.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
    return internalGetDimensions().getMap();
  }
  /**
   *
   *
   * <pre>
   * If this map is nonempty, then this override applies only to specific values
   * for dimensions defined in the limit unit.
   * For example, an override on a limit with the unit `1/{project}/{region}`
   * could contain an entry with the key `region` and the value `us-east-1`;
   * the override is only applied to quota consumed in that region.
   * This map has the following restrictions:
   * *   Keys that are not defined in the limit's unit are not valid keys.
   *     Any string appearing in `{brackets}` in the unit (besides `{project}`
   *     or
   *     `{user}`) is a defined key.
   * *   `project` is not a valid key; the project is already specified in
   *     the parent resource name.
   * *   `user` is not a valid key; the API does not support quota overrides
   *     that apply only to a specific user.
   * *   If `region` appears as a key, its value must be a valid Cloud region.
   * *   If `zone` appears as a key, its value must be a valid Cloud zone.
   * *   If any valid key other than `region` or `zone` appears in the map, then
   *     all valid keys other than `region` or `zone` must also appear in the
   *     map.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getDimensionsOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * If this map is nonempty, then this override applies only to specific values
   * for dimensions defined in the limit unit.
   * For example, an override on a limit with the unit `1/{project}/{region}`
   * could contain an entry with the key `region` and the value `us-east-1`;
   * the override is only applied to quota consumed in that region.
   * This map has the following restrictions:
   * *   Keys that are not defined in the limit's unit are not valid keys.
   *     Any string appearing in `{brackets}` in the unit (besides `{project}`
   *     or
   *     `{user}`) is a defined key.
   * *   `project` is not a valid key; the project is already specified in
   *     the parent resource name.
   * *   `user` is not a valid key; the API does not support quota overrides
   *     that apply only to a specific user.
   * *   If `region` appears as a key, its value must be a valid Cloud region.
   * *   If `zone` appears as a key, its value must be a valid Cloud zone.
   * *   If any valid key other than `region` or `zone` appears in the map, then
   *     all valid keys other than `region` or `zone` must also appear in the
   *     map.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getDimensionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int METRIC_FIELD_NUMBER = 4;
  private volatile java.lang.Object metric_;
  /**
   *
   *
   * <pre>
   * The name of the metric to which this override applies.
   * An example name would be:
   * `compute.googleapis.com/cpus`
   * </pre>
   *
   * <code>string metric = 4;</code>
   *
   * @return The metric.
   */
  @java.lang.Override
  public java.lang.String getMetric() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metric_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the metric to which this override applies.
   * An example name would be:
   * `compute.googleapis.com/cpus`
   * </pre>
   *
   * <code>string metric = 4;</code>
   *
   * @return The bytes for metric.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricBytes() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metric_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNIT_FIELD_NUMBER = 5;
  private volatile java.lang.Object unit_;
  /**
   *
   *
   * <pre>
   * The limit unit of the limit to which this override applies.
   * An example unit would be:
   * `1/{project}/{region}`
   * Note that `{project}` and `{region}` are not placeholders in this example;
   * the literal characters `{` and `}` occur in the string.
   * </pre>
   *
   * <code>string unit = 5;</code>
   *
   * @return The unit.
   */
  @java.lang.Override
  public java.lang.String getUnit() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      unit_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The limit unit of the limit to which this override applies.
   * An example unit would be:
   * `1/{project}/{region}`
   * Note that `{project}` and `{region}` are not placeholders in this example;
   * the literal characters `{` and `}` occur in the string.
   * </pre>
   *
   * <code>string unit = 5;</code>
   *
   * @return The bytes for unit.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUnitBytes() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      unit_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADMIN_OVERRIDE_ANCESTOR_FIELD_NUMBER = 6;
  private volatile java.lang.Object adminOverrideAncestor_;
  /**
   *
   *
   * <pre>
   * The resource name of the ancestor that requested the override. For example:
   * `organizations/12345` or `folders/67890`.
   * Used by admin overrides only.
   * </pre>
   *
   * <code>string admin_override_ancestor = 6;</code>
   *
   * @return The adminOverrideAncestor.
   */
  @java.lang.Override
  public java.lang.String getAdminOverrideAncestor() {
    java.lang.Object ref = adminOverrideAncestor_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      adminOverrideAncestor_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the ancestor that requested the override. For example:
   * `organizations/12345` or `folders/67890`.
   * Used by admin overrides only.
   * </pre>
   *
   * <code>string admin_override_ancestor = 6;</code>
   *
   * @return The bytes for adminOverrideAncestor.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAdminOverrideAncestorBytes() {
    java.lang.Object ref = adminOverrideAncestor_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      adminOverrideAncestor_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (overrideValue_ != 0L) {
      output.writeInt64(2, overrideValue_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDimensions(), DimensionsDefaultEntryHolder.defaultEntry, 3);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, metric_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, unit_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(adminOverrideAncestor_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, adminOverrideAncestor_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (overrideValue_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, overrideValue_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDimensions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dimensions__ =
          DimensionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, dimensions__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, metric_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, unit_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(adminOverrideAncestor_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, adminOverrideAncestor_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.serviceusage.v1beta1.QuotaOverride)) {
      return super.equals(obj);
    }
    com.google.api.serviceusage.v1beta1.QuotaOverride other =
        (com.google.api.serviceusage.v1beta1.QuotaOverride) obj;

    if (!getName().equals(other.getName())) return false;
    if (getOverrideValue() != other.getOverrideValue()) return false;
    if (!internalGetDimensions().equals(other.internalGetDimensions())) return false;
    if (!getMetric().equals(other.getMetric())) return false;
    if (!getUnit().equals(other.getUnit())) return false;
    if (!getAdminOverrideAncestor().equals(other.getAdminOverrideAncestor())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + OVERRIDE_VALUE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getOverrideValue());
    if (!internalGetDimensions().getMap().isEmpty()) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDimensions().hashCode();
    }
    hash = (37 * hash) + METRIC_FIELD_NUMBER;
    hash = (53 * hash) + getMetric().hashCode();
    hash = (37 * hash) + UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getUnit().hashCode();
    hash = (37 * hash) + ADMIN_OVERRIDE_ANCESTOR_FIELD_NUMBER;
    hash = (53 * hash) + getAdminOverrideAncestor().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.serviceusage.v1beta1.QuotaOverride prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A quota override
   * </pre>
   *
   * Protobuf type {@code google.api.serviceusage.v1beta1.QuotaOverride}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.serviceusage.v1beta1.QuotaOverride)
      com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_QuotaOverride_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetDimensions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableDimensions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_QuotaOverride_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.serviceusage.v1beta1.QuotaOverride.class,
              com.google.api.serviceusage.v1beta1.QuotaOverride.Builder.class);
    }

    // Construct using com.google.api.serviceusage.v1beta1.QuotaOverride.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      overrideValue_ = 0L;

      internalGetMutableDimensions().clear();
      metric_ = "";

      unit_ = "";

      adminOverrideAncestor_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_QuotaOverride_descriptor;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.QuotaOverride getDefaultInstanceForType() {
      return com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.QuotaOverride build() {
      com.google.api.serviceusage.v1beta1.QuotaOverride result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.QuotaOverride buildPartial() {
      com.google.api.serviceusage.v1beta1.QuotaOverride result =
          new com.google.api.serviceusage.v1beta1.QuotaOverride(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.overrideValue_ = overrideValue_;
      result.dimensions_ = internalGetDimensions();
      result.dimensions_.makeImmutable();
      result.metric_ = metric_;
      result.unit_ = unit_;
      result.adminOverrideAncestor_ = adminOverrideAncestor_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.serviceusage.v1beta1.QuotaOverride) {
        return mergeFrom((com.google.api.serviceusage.v1beta1.QuotaOverride) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.serviceusage.v1beta1.QuotaOverride other) {
      if (other == com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.getOverrideValue() != 0L) {
        setOverrideValue(other.getOverrideValue());
      }
      internalGetMutableDimensions().mergeFrom(other.internalGetDimensions());
      if (!other.getMetric().isEmpty()) {
        metric_ = other.metric_;
        onChanged();
      }
      if (!other.getUnit().isEmpty()) {
        unit_ = other.unit_;
        onChanged();
      }
      if (!other.getAdminOverrideAncestor().isEmpty()) {
        adminOverrideAncestor_ = other.adminOverrideAncestor_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                overrideValue_ = input.readInt64();

                break;
              } // case 16
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dimensions__ =
                    input.readMessage(
                        DimensionsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableDimensions()
                    .getMutableMap()
                    .put(dimensions__.getKey(), dimensions__.getValue());
                break;
              } // case 26
            case 34:
              {
                metric_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                unit_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                adminOverrideAncestor_ = input.readStringRequireUtf8();

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the override.
     * This name is generated by the server when the override is created.
     * Example names would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminOverrides/4a3f2c1d`
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the override.
     * This name is generated by the server when the override is created.
     * Example names would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminOverrides/4a3f2c1d`
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the override.
     * This name is generated by the server when the override is created.
     * Example names would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminOverrides/4a3f2c1d`
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the override.
     * This name is generated by the server when the override is created.
     * Example names would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminOverrides/4a3f2c1d`
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the override.
     * This name is generated by the server when the override is created.
     * Example names would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminOverrides/4a3f2c1d`
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/consumerOverrides/4a3f2c1d`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private long overrideValue_;
    /**
     *
     *
     * <pre>
     * The overriding quota limit value.
     * Can be any nonnegative integer, or -1 (unlimited quota).
     * </pre>
     *
     * <code>int64 override_value = 2;</code>
     *
     * @return The overrideValue.
     */
    @java.lang.Override
    public long getOverrideValue() {
      return overrideValue_;
    }
    /**
     *
     *
     * <pre>
     * The overriding quota limit value.
     * Can be any nonnegative integer, or -1 (unlimited quota).
     * </pre>
     *
     * <code>int64 override_value = 2;</code>
     *
     * @param value The overrideValue to set.
     * @return This builder for chaining.
     */
    public Builder setOverrideValue(long value) {

      overrideValue_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overriding quota limit value.
     * Can be any nonnegative integer, or -1 (unlimited quota).
     * </pre>
     *
     * <code>int64 override_value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOverrideValue() {

      overrideValue_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> dimensions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetDimensions() {
      if (dimensions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DimensionsDefaultEntryHolder.defaultEntry);
      }
      return dimensions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDimensions() {
      onChanged();
      ;
      if (dimensions_ == null) {
        dimensions_ =
            com.google.protobuf.MapField.newMapField(DimensionsDefaultEntryHolder.defaultEntry);
      }
      if (!dimensions_.isMutable()) {
        dimensions_ = dimensions_.copy();
      }
      return dimensions_;
    }

    public int getDimensionsCount() {
      return internalGetDimensions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this override applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an override on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the override is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   Keys that are not defined in the limit's unit are not valid keys.
     *     Any string appearing in `{brackets}` in the unit (besides `{project}`
     *     or
     *     `{user}`) is a defined key.
     * *   `project` is not a valid key; the project is already specified in
     *     the parent resource name.
     * *   `user` is not a valid key; the API does not support quota overrides
     *     that apply only to a specific user.
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   If any valid key other than `region` or `zone` appears in the map, then
     *     all valid keys other than `region` or `zone` must also appear in the
     *     map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    @java.lang.Override
    public boolean containsDimensions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDimensions().getMap().containsKey(key);
    }
    /** Use {@link #getDimensionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDimensions() {
      return getDimensionsMap();
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this override applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an override on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the override is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   Keys that are not defined in the limit's unit are not valid keys.
     *     Any string appearing in `{brackets}` in the unit (besides `{project}`
     *     or
     *     `{user}`) is a defined key.
     * *   `project` is not a valid key; the project is already specified in
     *     the parent resource name.
     * *   `user` is not a valid key; the API does not support quota overrides
     *     that apply only to a specific user.
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   If any valid key other than `region` or `zone` appears in the map, then
     *     all valid keys other than `region` or `zone` must also appear in the
     *     map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
      return internalGetDimensions().getMap();
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this override applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an override on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the override is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   Keys that are not defined in the limit's unit are not valid keys.
     *     Any string appearing in `{brackets}` in the unit (besides `{project}`
     *     or
     *     `{user}`) is a defined key.
     * *   `project` is not a valid key; the project is already specified in
     *     the parent resource name.
     * *   `user` is not a valid key; the API does not support quota overrides
     *     that apply only to a specific user.
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   If any valid key other than `region` or `zone` appears in the map, then
     *     all valid keys other than `region` or `zone` must also appear in the
     *     map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getDimensionsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this override applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an override on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the override is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   Keys that are not defined in the limit's unit are not valid keys.
     *     Any string appearing in `{brackets}` in the unit (besides `{project}`
     *     or
     *     `{user}`) is a defined key.
     * *   `project` is not a valid key; the project is already specified in
     *     the parent resource name.
     * *   `user` is not a valid key; the API does not support quota overrides
     *     that apply only to a specific user.
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   If any valid key other than `region` or `zone` appears in the map, then
     *     all valid keys other than `region` or `zone` must also appear in the
     *     map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getDimensionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDimensions() {
      internalGetMutableDimensions().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this override applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an override on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the override is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   Keys that are not defined in the limit's unit are not valid keys.
     *     Any string appearing in `{brackets}` in the unit (besides `{project}`
     *     or
     *     `{user}`) is a defined key.
     * *   `project` is not a valid key; the project is already specified in
     *     the parent resource name.
     * *   `user` is not a valid key; the API does not support quota overrides
     *     that apply only to a specific user.
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   If any valid key other than `region` or `zone` appears in the map, then
     *     all valid keys other than `region` or `zone` must also appear in the
     *     map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    public Builder removeDimensions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDimensions().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDimensions() {
      return internalGetMutableDimensions().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this override applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an override on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the override is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   Keys that are not defined in the limit's unit are not valid keys.
     *     Any string appearing in `{brackets}` in the unit (besides `{project}`
     *     or
     *     `{user}`) is a defined key.
     * *   `project` is not a valid key; the project is already specified in
     *     the parent resource name.
     * *   `user` is not a valid key; the API does not support quota overrides
     *     that apply only to a specific user.
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   If any valid key other than `region` or `zone` appears in the map, then
     *     all valid keys other than `region` or `zone` must also appear in the
     *     map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    public Builder putDimensions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableDimensions().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this override applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an override on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the override is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   Keys that are not defined in the limit's unit are not valid keys.
     *     Any string appearing in `{brackets}` in the unit (besides `{project}`
     *     or
     *     `{user}`) is a defined key.
     * *   `project` is not a valid key; the project is already specified in
     *     the parent resource name.
     * *   `user` is not a valid key; the API does not support quota overrides
     *     that apply only to a specific user.
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   If any valid key other than `region` or `zone` appears in the map, then
     *     all valid keys other than `region` or `zone` must also appear in the
     *     map.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    public Builder putAllDimensions(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDimensions().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object metric_ = "";
    /**
     *
     *
     * <pre>
     * The name of the metric to which this override applies.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @return The metric.
     */
    public java.lang.String getMetric() {
      java.lang.Object ref = metric_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metric_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the metric to which this override applies.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @return The bytes for metric.
     */
    public com.google.protobuf.ByteString getMetricBytes() {
      java.lang.Object ref = metric_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metric_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the metric to which this override applies.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @param value The metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetric(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      metric_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the metric to which this override applies.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetric() {

      metric_ = getDefaultInstance().getMetric();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the metric to which this override applies.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @param value The bytes for metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetricBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      metric_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object unit_ = "";
    /**
     *
     *
     * <pre>
     * The limit unit of the limit to which this override applies.
     * An example unit would be:
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return The unit.
     */
    public java.lang.String getUnit() {
      java.lang.Object ref = unit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        unit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The limit unit of the limit to which this override applies.
     * An example unit would be:
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return The bytes for unit.
     */
    public com.google.protobuf.ByteString getUnitBytes() {
      java.lang.Object ref = unit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        unit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The limit unit of the limit to which this override applies.
     * An example unit would be:
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @param value The unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnit(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      unit_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The limit unit of the limit to which this override applies.
     * An example unit would be:
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnit() {

      unit_ = getDefaultInstance().getUnit();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The limit unit of the limit to which this override applies.
     * An example unit would be:
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @param value The bytes for unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnitBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      unit_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object adminOverrideAncestor_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the ancestor that requested the override. For example:
     * `organizations/12345` or `folders/67890`.
     * Used by admin overrides only.
     * </pre>
     *
     * <code>string admin_override_ancestor = 6;</code>
     *
     * @return The adminOverrideAncestor.
     */
    public java.lang.String getAdminOverrideAncestor() {
      java.lang.Object ref = adminOverrideAncestor_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        adminOverrideAncestor_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ancestor that requested the override. For example:
     * `organizations/12345` or `folders/67890`.
     * Used by admin overrides only.
     * </pre>
     *
     * <code>string admin_override_ancestor = 6;</code>
     *
     * @return The bytes for adminOverrideAncestor.
     */
    public com.google.protobuf.ByteString getAdminOverrideAncestorBytes() {
      java.lang.Object ref = adminOverrideAncestor_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        adminOverrideAncestor_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ancestor that requested the override. For example:
     * `organizations/12345` or `folders/67890`.
     * Used by admin overrides only.
     * </pre>
     *
     * <code>string admin_override_ancestor = 6;</code>
     *
     * @param value The adminOverrideAncestor to set.
     * @return This builder for chaining.
     */
    public Builder setAdminOverrideAncestor(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      adminOverrideAncestor_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ancestor that requested the override. For example:
     * `organizations/12345` or `folders/67890`.
     * Used by admin overrides only.
     * </pre>
     *
     * <code>string admin_override_ancestor = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdminOverrideAncestor() {

      adminOverrideAncestor_ = getDefaultInstance().getAdminOverrideAncestor();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the ancestor that requested the override. For example:
     * `organizations/12345` or `folders/67890`.
     * Used by admin overrides only.
     * </pre>
     *
     * <code>string admin_override_ancestor = 6;</code>
     *
     * @param value The bytes for adminOverrideAncestor to set.
     * @return This builder for chaining.
     */
    public Builder setAdminOverrideAncestorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      adminOverrideAncestor_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.serviceusage.v1beta1.QuotaOverride)
  }

  // @@protoc_insertion_point(class_scope:google.api.serviceusage.v1beta1.QuotaOverride)
  private static final com.google.api.serviceusage.v1beta1.QuotaOverride DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.serviceusage.v1beta1.QuotaOverride();
  }

  public static com.google.api.serviceusage.v1beta1.QuotaOverride getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QuotaOverride> PARSER =
      new com.google.protobuf.AbstractParser<QuotaOverride>() {
        @java.lang.Override
        public QuotaOverride parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QuotaOverride> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QuotaOverride> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaOverride getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
