/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/serviceusage/v1beta1/resources.proto

package com.google.api.serviceusage.v1beta1;

/**
 *
 *
 * <pre>
 * A quota bucket is a quota provisioning unit for a specific set of dimensions.
 * </pre>
 *
 * Protobuf type {@code google.api.serviceusage.v1beta1.QuotaBucket}
 */
public final class QuotaBucket extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.serviceusage.v1beta1.QuotaBucket)
    QuotaBucketOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QuotaBucket.newBuilder() to construct.
  private QuotaBucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QuotaBucket() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QuotaBucket();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.serviceusage.v1beta1.ResourcesProto
        .internal_static_google_api_serviceusage_v1beta1_QuotaBucket_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetDimensions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.serviceusage.v1beta1.ResourcesProto
        .internal_static_google_api_serviceusage_v1beta1_QuotaBucket_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.serviceusage.v1beta1.QuotaBucket.class,
            com.google.api.serviceusage.v1beta1.QuotaBucket.Builder.class);
  }

  public static final int EFFECTIVE_LIMIT_FIELD_NUMBER = 1;
  private long effectiveLimit_;
  /**
   *
   *
   * <pre>
   * The effective limit of this quota bucket. Equal to default_limit if there
   * are no overrides.
   * </pre>
   *
   * <code>int64 effective_limit = 1;</code>
   *
   * @return The effectiveLimit.
   */
  @java.lang.Override
  public long getEffectiveLimit() {
    return effectiveLimit_;
  }

  public static final int DEFAULT_LIMIT_FIELD_NUMBER = 2;
  private long defaultLimit_;
  /**
   *
   *
   * <pre>
   * The default limit of this quota bucket, as specified by the service
   * configuration.
   * </pre>
   *
   * <code>int64 default_limit = 2;</code>
   *
   * @return The defaultLimit.
   */
  @java.lang.Override
  public long getDefaultLimit() {
    return defaultLimit_;
  }

  public static final int PRODUCER_OVERRIDE_FIELD_NUMBER = 3;
  private com.google.api.serviceusage.v1beta1.QuotaOverride producerOverride_;
  /**
   *
   *
   * <pre>
   * Producer override on this quota bucket.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.QuotaOverride producer_override = 3;</code>
   *
   * @return Whether the producerOverride field is set.
   */
  @java.lang.Override
  public boolean hasProducerOverride() {
    return producerOverride_ != null;
  }
  /**
   *
   *
   * <pre>
   * Producer override on this quota bucket.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.QuotaOverride producer_override = 3;</code>
   *
   * @return The producerOverride.
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaOverride getProducerOverride() {
    return producerOverride_ == null
        ? com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance()
        : producerOverride_;
  }
  /**
   *
   *
   * <pre>
   * Producer override on this quota bucket.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.QuotaOverride producer_override = 3;</code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder getProducerOverrideOrBuilder() {
    return getProducerOverride();
  }

  public static final int CONSUMER_OVERRIDE_FIELD_NUMBER = 4;
  private com.google.api.serviceusage.v1beta1.QuotaOverride consumerOverride_;
  /**
   *
   *
   * <pre>
   * Consumer override on this quota bucket.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.QuotaOverride consumer_override = 4;</code>
   *
   * @return Whether the consumerOverride field is set.
   */
  @java.lang.Override
  public boolean hasConsumerOverride() {
    return consumerOverride_ != null;
  }
  /**
   *
   *
   * <pre>
   * Consumer override on this quota bucket.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.QuotaOverride consumer_override = 4;</code>
   *
   * @return The consumerOverride.
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaOverride getConsumerOverride() {
    return consumerOverride_ == null
        ? com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance()
        : consumerOverride_;
  }
  /**
   *
   *
   * <pre>
   * Consumer override on this quota bucket.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.QuotaOverride consumer_override = 4;</code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder getConsumerOverrideOrBuilder() {
    return getConsumerOverride();
  }

  public static final int ADMIN_OVERRIDE_FIELD_NUMBER = 5;
  private com.google.api.serviceusage.v1beta1.QuotaOverride adminOverride_;
  /**
   *
   *
   * <pre>
   * Admin override on this quota bucket.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.QuotaOverride admin_override = 5;</code>
   *
   * @return Whether the adminOverride field is set.
   */
  @java.lang.Override
  public boolean hasAdminOverride() {
    return adminOverride_ != null;
  }
  /**
   *
   *
   * <pre>
   * Admin override on this quota bucket.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.QuotaOverride admin_override = 5;</code>
   *
   * @return The adminOverride.
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaOverride getAdminOverride() {
    return adminOverride_ == null
        ? com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance()
        : adminOverride_;
  }
  /**
   *
   *
   * <pre>
   * Admin override on this quota bucket.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.QuotaOverride admin_override = 5;</code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder getAdminOverrideOrBuilder() {
    return getAdminOverride();
  }

  public static final int DIMENSIONS_FIELD_NUMBER = 6;

  private static final class DimensionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.api.serviceusage.v1beta1.ResourcesProto
                .internal_static_google_api_serviceusage_v1beta1_QuotaBucket_DimensionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> dimensions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetDimensions() {
    if (dimensions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(DimensionsDefaultEntryHolder.defaultEntry);
    }
    return dimensions_;
  }

  public int getDimensionsCount() {
    return internalGetDimensions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The dimensions of this quota bucket.
   * If this map is empty, this is the global bucket, which is the default quota
   * value applied to all requests that do not have a more specific override.
   * If this map is nonempty, the default limit, effective limit, and quota
   * overrides apply only to requests that have the dimensions given in the map.
   * For example, if the map has key `region` and value `us-east-1`, then the
   * specified effective limit is only effective in that region, and the
   * specified overrides apply only in that region.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 6;</code>
   */
  @java.lang.Override
  public boolean containsDimensions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDimensions().getMap().containsKey(key);
  }
  /** Use {@link #getDimensionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDimensions() {
    return getDimensionsMap();
  }
  /**
   *
   *
   * <pre>
   * The dimensions of this quota bucket.
   * If this map is empty, this is the global bucket, which is the default quota
   * value applied to all requests that do not have a more specific override.
   * If this map is nonempty, the default limit, effective limit, and quota
   * overrides apply only to requests that have the dimensions given in the map.
   * For example, if the map has key `region` and value `us-east-1`, then the
   * specified effective limit is only effective in that region, and the
   * specified overrides apply only in that region.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 6;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
    return internalGetDimensions().getMap();
  }
  /**
   *
   *
   * <pre>
   * The dimensions of this quota bucket.
   * If this map is empty, this is the global bucket, which is the default quota
   * value applied to all requests that do not have a more specific override.
   * If this map is nonempty, the default limit, effective limit, and quota
   * overrides apply only to requests that have the dimensions given in the map.
   * For example, if the map has key `region` and value `us-east-1`, then the
   * specified effective limit is only effective in that region, and the
   * specified overrides apply only in that region.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 6;</code>
   */
  @java.lang.Override
  public java.lang.String getDimensionsOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The dimensions of this quota bucket.
   * If this map is empty, this is the global bucket, which is the default quota
   * value applied to all requests that do not have a more specific override.
   * If this map is nonempty, the default limit, effective limit, and quota
   * overrides apply only to requests that have the dimensions given in the map.
   * For example, if the map has key `region` and value `us-east-1`, then the
   * specified effective limit is only effective in that region, and the
   * specified overrides apply only in that region.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 6;</code>
   */
  @java.lang.Override
  public java.lang.String getDimensionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (effectiveLimit_ != 0L) {
      output.writeInt64(1, effectiveLimit_);
    }
    if (defaultLimit_ != 0L) {
      output.writeInt64(2, defaultLimit_);
    }
    if (producerOverride_ != null) {
      output.writeMessage(3, getProducerOverride());
    }
    if (consumerOverride_ != null) {
      output.writeMessage(4, getConsumerOverride());
    }
    if (adminOverride_ != null) {
      output.writeMessage(5, getAdminOverride());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDimensions(), DimensionsDefaultEntryHolder.defaultEntry, 6);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (effectiveLimit_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, effectiveLimit_);
    }
    if (defaultLimit_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, defaultLimit_);
    }
    if (producerOverride_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getProducerOverride());
    }
    if (consumerOverride_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getConsumerOverride());
    }
    if (adminOverride_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAdminOverride());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDimensions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dimensions__ =
          DimensionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, dimensions__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.serviceusage.v1beta1.QuotaBucket)) {
      return super.equals(obj);
    }
    com.google.api.serviceusage.v1beta1.QuotaBucket other =
        (com.google.api.serviceusage.v1beta1.QuotaBucket) obj;

    if (getEffectiveLimit() != other.getEffectiveLimit()) return false;
    if (getDefaultLimit() != other.getDefaultLimit()) return false;
    if (hasProducerOverride() != other.hasProducerOverride()) return false;
    if (hasProducerOverride()) {
      if (!getProducerOverride().equals(other.getProducerOverride())) return false;
    }
    if (hasConsumerOverride() != other.hasConsumerOverride()) return false;
    if (hasConsumerOverride()) {
      if (!getConsumerOverride().equals(other.getConsumerOverride())) return false;
    }
    if (hasAdminOverride() != other.hasAdminOverride()) return false;
    if (hasAdminOverride()) {
      if (!getAdminOverride().equals(other.getAdminOverride())) return false;
    }
    if (!internalGetDimensions().equals(other.internalGetDimensions())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + EFFECTIVE_LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEffectiveLimit());
    hash = (37 * hash) + DEFAULT_LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDefaultLimit());
    if (hasProducerOverride()) {
      hash = (37 * hash) + PRODUCER_OVERRIDE_FIELD_NUMBER;
      hash = (53 * hash) + getProducerOverride().hashCode();
    }
    if (hasConsumerOverride()) {
      hash = (37 * hash) + CONSUMER_OVERRIDE_FIELD_NUMBER;
      hash = (53 * hash) + getConsumerOverride().hashCode();
    }
    if (hasAdminOverride()) {
      hash = (37 * hash) + ADMIN_OVERRIDE_FIELD_NUMBER;
      hash = (53 * hash) + getAdminOverride().hashCode();
    }
    if (!internalGetDimensions().getMap().isEmpty()) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDimensions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.serviceusage.v1beta1.QuotaBucket prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A quota bucket is a quota provisioning unit for a specific set of dimensions.
   * </pre>
   *
   * Protobuf type {@code google.api.serviceusage.v1beta1.QuotaBucket}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.serviceusage.v1beta1.QuotaBucket)
      com.google.api.serviceusage.v1beta1.QuotaBucketOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_QuotaBucket_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetDimensions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutableDimensions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_QuotaBucket_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.serviceusage.v1beta1.QuotaBucket.class,
              com.google.api.serviceusage.v1beta1.QuotaBucket.Builder.class);
    }

    // Construct using com.google.api.serviceusage.v1beta1.QuotaBucket.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      effectiveLimit_ = 0L;

      defaultLimit_ = 0L;

      if (producerOverrideBuilder_ == null) {
        producerOverride_ = null;
      } else {
        producerOverride_ = null;
        producerOverrideBuilder_ = null;
      }
      if (consumerOverrideBuilder_ == null) {
        consumerOverride_ = null;
      } else {
        consumerOverride_ = null;
        consumerOverrideBuilder_ = null;
      }
      if (adminOverrideBuilder_ == null) {
        adminOverride_ = null;
      } else {
        adminOverride_ = null;
        adminOverrideBuilder_ = null;
      }
      internalGetMutableDimensions().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_QuotaBucket_descriptor;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.QuotaBucket getDefaultInstanceForType() {
      return com.google.api.serviceusage.v1beta1.QuotaBucket.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.QuotaBucket build() {
      com.google.api.serviceusage.v1beta1.QuotaBucket result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.QuotaBucket buildPartial() {
      com.google.api.serviceusage.v1beta1.QuotaBucket result =
          new com.google.api.serviceusage.v1beta1.QuotaBucket(this);
      int from_bitField0_ = bitField0_;
      result.effectiveLimit_ = effectiveLimit_;
      result.defaultLimit_ = defaultLimit_;
      if (producerOverrideBuilder_ == null) {
        result.producerOverride_ = producerOverride_;
      } else {
        result.producerOverride_ = producerOverrideBuilder_.build();
      }
      if (consumerOverrideBuilder_ == null) {
        result.consumerOverride_ = consumerOverride_;
      } else {
        result.consumerOverride_ = consumerOverrideBuilder_.build();
      }
      if (adminOverrideBuilder_ == null) {
        result.adminOverride_ = adminOverride_;
      } else {
        result.adminOverride_ = adminOverrideBuilder_.build();
      }
      result.dimensions_ = internalGetDimensions();
      result.dimensions_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.serviceusage.v1beta1.QuotaBucket) {
        return mergeFrom((com.google.api.serviceusage.v1beta1.QuotaBucket) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.serviceusage.v1beta1.QuotaBucket other) {
      if (other == com.google.api.serviceusage.v1beta1.QuotaBucket.getDefaultInstance())
        return this;
      if (other.getEffectiveLimit() != 0L) {
        setEffectiveLimit(other.getEffectiveLimit());
      }
      if (other.getDefaultLimit() != 0L) {
        setDefaultLimit(other.getDefaultLimit());
      }
      if (other.hasProducerOverride()) {
        mergeProducerOverride(other.getProducerOverride());
      }
      if (other.hasConsumerOverride()) {
        mergeConsumerOverride(other.getConsumerOverride());
      }
      if (other.hasAdminOverride()) {
        mergeAdminOverride(other.getAdminOverride());
      }
      internalGetMutableDimensions().mergeFrom(other.internalGetDimensions());
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                effectiveLimit_ = input.readInt64();

                break;
              } // case 8
            case 16:
              {
                defaultLimit_ = input.readInt64();

                break;
              } // case 16
            case 26:
              {
                input.readMessage(
                    getProducerOverrideFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getConsumerOverrideFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getAdminOverrideFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dimensions__ =
                    input.readMessage(
                        DimensionsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableDimensions()
                    .getMutableMap()
                    .put(dimensions__.getKey(), dimensions__.getValue());
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long effectiveLimit_;
    /**
     *
     *
     * <pre>
     * The effective limit of this quota bucket. Equal to default_limit if there
     * are no overrides.
     * </pre>
     *
     * <code>int64 effective_limit = 1;</code>
     *
     * @return The effectiveLimit.
     */
    @java.lang.Override
    public long getEffectiveLimit() {
      return effectiveLimit_;
    }
    /**
     *
     *
     * <pre>
     * The effective limit of this quota bucket. Equal to default_limit if there
     * are no overrides.
     * </pre>
     *
     * <code>int64 effective_limit = 1;</code>
     *
     * @param value The effectiveLimit to set.
     * @return This builder for chaining.
     */
    public Builder setEffectiveLimit(long value) {

      effectiveLimit_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The effective limit of this quota bucket. Equal to default_limit if there
     * are no overrides.
     * </pre>
     *
     * <code>int64 effective_limit = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEffectiveLimit() {

      effectiveLimit_ = 0L;
      onChanged();
      return this;
    }

    private long defaultLimit_;
    /**
     *
     *
     * <pre>
     * The default limit of this quota bucket, as specified by the service
     * configuration.
     * </pre>
     *
     * <code>int64 default_limit = 2;</code>
     *
     * @return The defaultLimit.
     */
    @java.lang.Override
    public long getDefaultLimit() {
      return defaultLimit_;
    }
    /**
     *
     *
     * <pre>
     * The default limit of this quota bucket, as specified by the service
     * configuration.
     * </pre>
     *
     * <code>int64 default_limit = 2;</code>
     *
     * @param value The defaultLimit to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultLimit(long value) {

      defaultLimit_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default limit of this quota bucket, as specified by the service
     * configuration.
     * </pre>
     *
     * <code>int64 default_limit = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultLimit() {

      defaultLimit_ = 0L;
      onChanged();
      return this;
    }

    private com.google.api.serviceusage.v1beta1.QuotaOverride producerOverride_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.QuotaOverride,
            com.google.api.serviceusage.v1beta1.QuotaOverride.Builder,
            com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder>
        producerOverrideBuilder_;
    /**
     *
     *
     * <pre>
     * Producer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride producer_override = 3;</code>
     *
     * @return Whether the producerOverride field is set.
     */
    public boolean hasProducerOverride() {
      return producerOverrideBuilder_ != null || producerOverride_ != null;
    }
    /**
     *
     *
     * <pre>
     * Producer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride producer_override = 3;</code>
     *
     * @return The producerOverride.
     */
    public com.google.api.serviceusage.v1beta1.QuotaOverride getProducerOverride() {
      if (producerOverrideBuilder_ == null) {
        return producerOverride_ == null
            ? com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance()
            : producerOverride_;
      } else {
        return producerOverrideBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Producer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride producer_override = 3;</code>
     */
    public Builder setProducerOverride(com.google.api.serviceusage.v1beta1.QuotaOverride value) {
      if (producerOverrideBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        producerOverride_ = value;
        onChanged();
      } else {
        producerOverrideBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Producer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride producer_override = 3;</code>
     */
    public Builder setProducerOverride(
        com.google.api.serviceusage.v1beta1.QuotaOverride.Builder builderForValue) {
      if (producerOverrideBuilder_ == null) {
        producerOverride_ = builderForValue.build();
        onChanged();
      } else {
        producerOverrideBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Producer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride producer_override = 3;</code>
     */
    public Builder mergeProducerOverride(com.google.api.serviceusage.v1beta1.QuotaOverride value) {
      if (producerOverrideBuilder_ == null) {
        if (producerOverride_ != null) {
          producerOverride_ =
              com.google.api.serviceusage.v1beta1.QuotaOverride.newBuilder(producerOverride_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          producerOverride_ = value;
        }
        onChanged();
      } else {
        producerOverrideBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Producer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride producer_override = 3;</code>
     */
    public Builder clearProducerOverride() {
      if (producerOverrideBuilder_ == null) {
        producerOverride_ = null;
        onChanged();
      } else {
        producerOverride_ = null;
        producerOverrideBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Producer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride producer_override = 3;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaOverride.Builder getProducerOverrideBuilder() {

      onChanged();
      return getProducerOverrideFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Producer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride producer_override = 3;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder
        getProducerOverrideOrBuilder() {
      if (producerOverrideBuilder_ != null) {
        return producerOverrideBuilder_.getMessageOrBuilder();
      } else {
        return producerOverride_ == null
            ? com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance()
            : producerOverride_;
      }
    }
    /**
     *
     *
     * <pre>
     * Producer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride producer_override = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.QuotaOverride,
            com.google.api.serviceusage.v1beta1.QuotaOverride.Builder,
            com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder>
        getProducerOverrideFieldBuilder() {
      if (producerOverrideBuilder_ == null) {
        producerOverrideBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.serviceusage.v1beta1.QuotaOverride,
                com.google.api.serviceusage.v1beta1.QuotaOverride.Builder,
                com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder>(
                getProducerOverride(), getParentForChildren(), isClean());
        producerOverride_ = null;
      }
      return producerOverrideBuilder_;
    }

    private com.google.api.serviceusage.v1beta1.QuotaOverride consumerOverride_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.QuotaOverride,
            com.google.api.serviceusage.v1beta1.QuotaOverride.Builder,
            com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder>
        consumerOverrideBuilder_;
    /**
     *
     *
     * <pre>
     * Consumer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride consumer_override = 4;</code>
     *
     * @return Whether the consumerOverride field is set.
     */
    public boolean hasConsumerOverride() {
      return consumerOverrideBuilder_ != null || consumerOverride_ != null;
    }
    /**
     *
     *
     * <pre>
     * Consumer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride consumer_override = 4;</code>
     *
     * @return The consumerOverride.
     */
    public com.google.api.serviceusage.v1beta1.QuotaOverride getConsumerOverride() {
      if (consumerOverrideBuilder_ == null) {
        return consumerOverride_ == null
            ? com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance()
            : consumerOverride_;
      } else {
        return consumerOverrideBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Consumer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride consumer_override = 4;</code>
     */
    public Builder setConsumerOverride(com.google.api.serviceusage.v1beta1.QuotaOverride value) {
      if (consumerOverrideBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consumerOverride_ = value;
        onChanged();
      } else {
        consumerOverrideBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Consumer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride consumer_override = 4;</code>
     */
    public Builder setConsumerOverride(
        com.google.api.serviceusage.v1beta1.QuotaOverride.Builder builderForValue) {
      if (consumerOverrideBuilder_ == null) {
        consumerOverride_ = builderForValue.build();
        onChanged();
      } else {
        consumerOverrideBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Consumer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride consumer_override = 4;</code>
     */
    public Builder mergeConsumerOverride(com.google.api.serviceusage.v1beta1.QuotaOverride value) {
      if (consumerOverrideBuilder_ == null) {
        if (consumerOverride_ != null) {
          consumerOverride_ =
              com.google.api.serviceusage.v1beta1.QuotaOverride.newBuilder(consumerOverride_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          consumerOverride_ = value;
        }
        onChanged();
      } else {
        consumerOverrideBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Consumer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride consumer_override = 4;</code>
     */
    public Builder clearConsumerOverride() {
      if (consumerOverrideBuilder_ == null) {
        consumerOverride_ = null;
        onChanged();
      } else {
        consumerOverride_ = null;
        consumerOverrideBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Consumer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride consumer_override = 4;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaOverride.Builder getConsumerOverrideBuilder() {

      onChanged();
      return getConsumerOverrideFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Consumer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride consumer_override = 4;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder
        getConsumerOverrideOrBuilder() {
      if (consumerOverrideBuilder_ != null) {
        return consumerOverrideBuilder_.getMessageOrBuilder();
      } else {
        return consumerOverride_ == null
            ? com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance()
            : consumerOverride_;
      }
    }
    /**
     *
     *
     * <pre>
     * Consumer override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride consumer_override = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.QuotaOverride,
            com.google.api.serviceusage.v1beta1.QuotaOverride.Builder,
            com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder>
        getConsumerOverrideFieldBuilder() {
      if (consumerOverrideBuilder_ == null) {
        consumerOverrideBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.serviceusage.v1beta1.QuotaOverride,
                com.google.api.serviceusage.v1beta1.QuotaOverride.Builder,
                com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder>(
                getConsumerOverride(), getParentForChildren(), isClean());
        consumerOverride_ = null;
      }
      return consumerOverrideBuilder_;
    }

    private com.google.api.serviceusage.v1beta1.QuotaOverride adminOverride_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.QuotaOverride,
            com.google.api.serviceusage.v1beta1.QuotaOverride.Builder,
            com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder>
        adminOverrideBuilder_;
    /**
     *
     *
     * <pre>
     * Admin override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride admin_override = 5;</code>
     *
     * @return Whether the adminOverride field is set.
     */
    public boolean hasAdminOverride() {
      return adminOverrideBuilder_ != null || adminOverride_ != null;
    }
    /**
     *
     *
     * <pre>
     * Admin override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride admin_override = 5;</code>
     *
     * @return The adminOverride.
     */
    public com.google.api.serviceusage.v1beta1.QuotaOverride getAdminOverride() {
      if (adminOverrideBuilder_ == null) {
        return adminOverride_ == null
            ? com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance()
            : adminOverride_;
      } else {
        return adminOverrideBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Admin override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride admin_override = 5;</code>
     */
    public Builder setAdminOverride(com.google.api.serviceusage.v1beta1.QuotaOverride value) {
      if (adminOverrideBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        adminOverride_ = value;
        onChanged();
      } else {
        adminOverrideBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Admin override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride admin_override = 5;</code>
     */
    public Builder setAdminOverride(
        com.google.api.serviceusage.v1beta1.QuotaOverride.Builder builderForValue) {
      if (adminOverrideBuilder_ == null) {
        adminOverride_ = builderForValue.build();
        onChanged();
      } else {
        adminOverrideBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Admin override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride admin_override = 5;</code>
     */
    public Builder mergeAdminOverride(com.google.api.serviceusage.v1beta1.QuotaOverride value) {
      if (adminOverrideBuilder_ == null) {
        if (adminOverride_ != null) {
          adminOverride_ =
              com.google.api.serviceusage.v1beta1.QuotaOverride.newBuilder(adminOverride_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          adminOverride_ = value;
        }
        onChanged();
      } else {
        adminOverrideBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Admin override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride admin_override = 5;</code>
     */
    public Builder clearAdminOverride() {
      if (adminOverrideBuilder_ == null) {
        adminOverride_ = null;
        onChanged();
      } else {
        adminOverride_ = null;
        adminOverrideBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Admin override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride admin_override = 5;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaOverride.Builder getAdminOverrideBuilder() {

      onChanged();
      return getAdminOverrideFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Admin override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride admin_override = 5;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder getAdminOverrideOrBuilder() {
      if (adminOverrideBuilder_ != null) {
        return adminOverrideBuilder_.getMessageOrBuilder();
      } else {
        return adminOverride_ == null
            ? com.google.api.serviceusage.v1beta1.QuotaOverride.getDefaultInstance()
            : adminOverride_;
      }
    }
    /**
     *
     *
     * <pre>
     * Admin override on this quota bucket.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.QuotaOverride admin_override = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.QuotaOverride,
            com.google.api.serviceusage.v1beta1.QuotaOverride.Builder,
            com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder>
        getAdminOverrideFieldBuilder() {
      if (adminOverrideBuilder_ == null) {
        adminOverrideBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.serviceusage.v1beta1.QuotaOverride,
                com.google.api.serviceusage.v1beta1.QuotaOverride.Builder,
                com.google.api.serviceusage.v1beta1.QuotaOverrideOrBuilder>(
                getAdminOverride(), getParentForChildren(), isClean());
        adminOverride_ = null;
      }
      return adminOverrideBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> dimensions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetDimensions() {
      if (dimensions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DimensionsDefaultEntryHolder.defaultEntry);
      }
      return dimensions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDimensions() {
      onChanged();
      ;
      if (dimensions_ == null) {
        dimensions_ =
            com.google.protobuf.MapField.newMapField(DimensionsDefaultEntryHolder.defaultEntry);
      }
      if (!dimensions_.isMutable()) {
        dimensions_ = dimensions_.copy();
      }
      return dimensions_;
    }

    public int getDimensionsCount() {
      return internalGetDimensions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The dimensions of this quota bucket.
     * If this map is empty, this is the global bucket, which is the default quota
     * value applied to all requests that do not have a more specific override.
     * If this map is nonempty, the default limit, effective limit, and quota
     * overrides apply only to requests that have the dimensions given in the map.
     * For example, if the map has key `region` and value `us-east-1`, then the
     * specified effective limit is only effective in that region, and the
     * specified overrides apply only in that region.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 6;</code>
     */
    @java.lang.Override
    public boolean containsDimensions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDimensions().getMap().containsKey(key);
    }
    /** Use {@link #getDimensionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDimensions() {
      return getDimensionsMap();
    }
    /**
     *
     *
     * <pre>
     * The dimensions of this quota bucket.
     * If this map is empty, this is the global bucket, which is the default quota
     * value applied to all requests that do not have a more specific override.
     * If this map is nonempty, the default limit, effective limit, and quota
     * overrides apply only to requests that have the dimensions given in the map.
     * For example, if the map has key `region` and value `us-east-1`, then the
     * specified effective limit is only effective in that region, and the
     * specified overrides apply only in that region.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
      return internalGetDimensions().getMap();
    }
    /**
     *
     *
     * <pre>
     * The dimensions of this quota bucket.
     * If this map is empty, this is the global bucket, which is the default quota
     * value applied to all requests that do not have a more specific override.
     * If this map is nonempty, the default limit, effective limit, and quota
     * overrides apply only to requests that have the dimensions given in the map.
     * For example, if the map has key `region` and value `us-east-1`, then the
     * specified effective limit is only effective in that region, and the
     * specified overrides apply only in that region.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getDimensionsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The dimensions of this quota bucket.
     * If this map is empty, this is the global bucket, which is the default quota
     * value applied to all requests that do not have a more specific override.
     * If this map is nonempty, the default limit, effective limit, and quota
     * overrides apply only to requests that have the dimensions given in the map.
     * For example, if the map has key `region` and value `us-east-1`, then the
     * specified effective limit is only effective in that region, and the
     * specified overrides apply only in that region.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getDimensionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDimensions() {
      internalGetMutableDimensions().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions of this quota bucket.
     * If this map is empty, this is the global bucket, which is the default quota
     * value applied to all requests that do not have a more specific override.
     * If this map is nonempty, the default limit, effective limit, and quota
     * overrides apply only to requests that have the dimensions given in the map.
     * For example, if the map has key `region` and value `us-east-1`, then the
     * specified effective limit is only effective in that region, and the
     * specified overrides apply only in that region.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 6;</code>
     */
    public Builder removeDimensions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDimensions().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDimensions() {
      return internalGetMutableDimensions().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The dimensions of this quota bucket.
     * If this map is empty, this is the global bucket, which is the default quota
     * value applied to all requests that do not have a more specific override.
     * If this map is nonempty, the default limit, effective limit, and quota
     * overrides apply only to requests that have the dimensions given in the map.
     * For example, if the map has key `region` and value `us-east-1`, then the
     * specified effective limit is only effective in that region, and the
     * specified overrides apply only in that region.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 6;</code>
     */
    public Builder putDimensions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableDimensions().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions of this quota bucket.
     * If this map is empty, this is the global bucket, which is the default quota
     * value applied to all requests that do not have a more specific override.
     * If this map is nonempty, the default limit, effective limit, and quota
     * overrides apply only to requests that have the dimensions given in the map.
     * For example, if the map has key `region` and value `us-east-1`, then the
     * specified effective limit is only effective in that region, and the
     * specified overrides apply only in that region.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 6;</code>
     */
    public Builder putAllDimensions(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDimensions().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.serviceusage.v1beta1.QuotaBucket)
  }

  // @@protoc_insertion_point(class_scope:google.api.serviceusage.v1beta1.QuotaBucket)
  private static final com.google.api.serviceusage.v1beta1.QuotaBucket DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.serviceusage.v1beta1.QuotaBucket();
  }

  public static com.google.api.serviceusage.v1beta1.QuotaBucket getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QuotaBucket> PARSER =
      new com.google.protobuf.AbstractParser<QuotaBucket>() {
        @java.lang.Override
        public QuotaBucket parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QuotaBucket> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QuotaBucket> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaBucket getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
