/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/serviceusage/v1beta1/serviceusage.proto

package com.google.api.serviceusage.v1beta1;

/**
 *
 *
 * <pre>
 * Response message for getting service identity.
 * </pre>
 *
 * Protobuf type {@code google.api.serviceusage.v1beta1.GetServiceIdentityResponse}
 */
public final class GetServiceIdentityResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.serviceusage.v1beta1.GetServiceIdentityResponse)
    GetServiceIdentityResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GetServiceIdentityResponse.newBuilder() to construct.
  private GetServiceIdentityResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GetServiceIdentityResponse() {
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GetServiceIdentityResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.serviceusage.v1beta1.ServiceUsageProto
        .internal_static_google_api_serviceusage_v1beta1_GetServiceIdentityResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.serviceusage.v1beta1.ServiceUsageProto
        .internal_static_google_api_serviceusage_v1beta1_GetServiceIdentityResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.class,
            com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enum for service identity state.
   * </pre>
   *
   * Protobuf enum {@code google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState}
   */
  public enum IdentityState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default service identity state. This value is used if the state is
     * omitted.
     * </pre>
     *
     * <code>IDENTITY_STATE_UNSPECIFIED = 0;</code>
     */
    IDENTITY_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Service identity has been created and can be used.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default service identity state. This value is used if the state is
     * omitted.
     * </pre>
     *
     * <code>IDENTITY_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int IDENTITY_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Service identity has been created and can be used.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IdentityState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IdentityState forNumber(int value) {
      switch (value) {
        case 0:
          return IDENTITY_STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IdentityState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IdentityState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IdentityState>() {
          public IdentityState findValueByNumber(int number) {
            return IdentityState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final IdentityState[] VALUES = values();

    public static IdentityState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IdentityState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState)
  }

  public static final int IDENTITY_FIELD_NUMBER = 1;
  private com.google.api.serviceusage.v1beta1.ServiceIdentity identity_;
  /**
   *
   *
   * <pre>
   * Service identity that service producer can use to access consumer
   * resources. If exists is true, it contains email and unique_id. If exists is
   * false, it contains pre-constructed email and empty unique_id.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.ServiceIdentity identity = 1;</code>
   *
   * @return Whether the identity field is set.
   */
  @java.lang.Override
  public boolean hasIdentity() {
    return identity_ != null;
  }
  /**
   *
   *
   * <pre>
   * Service identity that service producer can use to access consumer
   * resources. If exists is true, it contains email and unique_id. If exists is
   * false, it contains pre-constructed email and empty unique_id.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.ServiceIdentity identity = 1;</code>
   *
   * @return The identity.
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.ServiceIdentity getIdentity() {
    return identity_ == null
        ? com.google.api.serviceusage.v1beta1.ServiceIdentity.getDefaultInstance()
        : identity_;
  }
  /**
   *
   *
   * <pre>
   * Service identity that service producer can use to access consumer
   * resources. If exists is true, it contains email and unique_id. If exists is
   * false, it contains pre-constructed email and empty unique_id.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.ServiceIdentity identity = 1;</code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.ServiceIdentityOrBuilder getIdentityOrBuilder() {
    return getIdentity();
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_;
  /**
   *
   *
   * <pre>
   * Service identity state.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState state = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Service identity state.
   * </pre>
   *
   * <code>.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState state = 2;
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState getState() {
    @SuppressWarnings("deprecation")
    com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState result =
        com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState.valueOf(
            state_);
    return result == null
        ? com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (identity_ != null) {
      output.writeMessage(1, getIdentity());
    }
    if (state_
        != com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState
            .IDENTITY_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, state_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (identity_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getIdentity());
    }
    if (state_
        != com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState
            .IDENTITY_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse)) {
      return super.equals(obj);
    }
    com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse other =
        (com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse) obj;

    if (hasIdentity() != other.hasIdentity()) return false;
    if (hasIdentity()) {
      if (!getIdentity().equals(other.getIdentity())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasIdentity()) {
      hash = (37 * hash) + IDENTITY_FIELD_NUMBER;
      hash = (53 * hash) + getIdentity().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for getting service identity.
   * </pre>
   *
   * Protobuf type {@code google.api.serviceusage.v1beta1.GetServiceIdentityResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.serviceusage.v1beta1.GetServiceIdentityResponse)
      com.google.api.serviceusage.v1beta1.GetServiceIdentityResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.serviceusage.v1beta1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1beta1_GetServiceIdentityResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.serviceusage.v1beta1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1beta1_GetServiceIdentityResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.class,
              com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.Builder.class);
    }

    // Construct using com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (identityBuilder_ == null) {
        identity_ = null;
      } else {
        identity_ = null;
        identityBuilder_ = null;
      }
      state_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.serviceusage.v1beta1.ServiceUsageProto
          .internal_static_google_api_serviceusage_v1beta1_GetServiceIdentityResponse_descriptor;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse
        getDefaultInstanceForType() {
      return com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse build() {
      com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse buildPartial() {
      com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse result =
          new com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse(this);
      if (identityBuilder_ == null) {
        result.identity_ = identity_;
      } else {
        result.identity_ = identityBuilder_.build();
      }
      result.state_ = state_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse) {
        return mergeFrom((com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse other) {
      if (other
          == com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.getDefaultInstance())
        return this;
      if (other.hasIdentity()) {
        mergeIdentity(other.getIdentity());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getIdentityFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();

                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.api.serviceusage.v1beta1.ServiceIdentity identity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.ServiceIdentity,
            com.google.api.serviceusage.v1beta1.ServiceIdentity.Builder,
            com.google.api.serviceusage.v1beta1.ServiceIdentityOrBuilder>
        identityBuilder_;
    /**
     *
     *
     * <pre>
     * Service identity that service producer can use to access consumer
     * resources. If exists is true, it contains email and unique_id. If exists is
     * false, it contains pre-constructed email and empty unique_id.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.ServiceIdentity identity = 1;</code>
     *
     * @return Whether the identity field is set.
     */
    public boolean hasIdentity() {
      return identityBuilder_ != null || identity_ != null;
    }
    /**
     *
     *
     * <pre>
     * Service identity that service producer can use to access consumer
     * resources. If exists is true, it contains email and unique_id. If exists is
     * false, it contains pre-constructed email and empty unique_id.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.ServiceIdentity identity = 1;</code>
     *
     * @return The identity.
     */
    public com.google.api.serviceusage.v1beta1.ServiceIdentity getIdentity() {
      if (identityBuilder_ == null) {
        return identity_ == null
            ? com.google.api.serviceusage.v1beta1.ServiceIdentity.getDefaultInstance()
            : identity_;
      } else {
        return identityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Service identity that service producer can use to access consumer
     * resources. If exists is true, it contains email and unique_id. If exists is
     * false, it contains pre-constructed email and empty unique_id.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.ServiceIdentity identity = 1;</code>
     */
    public Builder setIdentity(com.google.api.serviceusage.v1beta1.ServiceIdentity value) {
      if (identityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        identity_ = value;
        onChanged();
      } else {
        identityBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Service identity that service producer can use to access consumer
     * resources. If exists is true, it contains email and unique_id. If exists is
     * false, it contains pre-constructed email and empty unique_id.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.ServiceIdentity identity = 1;</code>
     */
    public Builder setIdentity(
        com.google.api.serviceusage.v1beta1.ServiceIdentity.Builder builderForValue) {
      if (identityBuilder_ == null) {
        identity_ = builderForValue.build();
        onChanged();
      } else {
        identityBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Service identity that service producer can use to access consumer
     * resources. If exists is true, it contains email and unique_id. If exists is
     * false, it contains pre-constructed email and empty unique_id.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.ServiceIdentity identity = 1;</code>
     */
    public Builder mergeIdentity(com.google.api.serviceusage.v1beta1.ServiceIdentity value) {
      if (identityBuilder_ == null) {
        if (identity_ != null) {
          identity_ =
              com.google.api.serviceusage.v1beta1.ServiceIdentity.newBuilder(identity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          identity_ = value;
        }
        onChanged();
      } else {
        identityBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Service identity that service producer can use to access consumer
     * resources. If exists is true, it contains email and unique_id. If exists is
     * false, it contains pre-constructed email and empty unique_id.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.ServiceIdentity identity = 1;</code>
     */
    public Builder clearIdentity() {
      if (identityBuilder_ == null) {
        identity_ = null;
        onChanged();
      } else {
        identity_ = null;
        identityBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Service identity that service producer can use to access consumer
     * resources. If exists is true, it contains email and unique_id. If exists is
     * false, it contains pre-constructed email and empty unique_id.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.ServiceIdentity identity = 1;</code>
     */
    public com.google.api.serviceusage.v1beta1.ServiceIdentity.Builder getIdentityBuilder() {

      onChanged();
      return getIdentityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Service identity that service producer can use to access consumer
     * resources. If exists is true, it contains email and unique_id. If exists is
     * false, it contains pre-constructed email and empty unique_id.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.ServiceIdentity identity = 1;</code>
     */
    public com.google.api.serviceusage.v1beta1.ServiceIdentityOrBuilder getIdentityOrBuilder() {
      if (identityBuilder_ != null) {
        return identityBuilder_.getMessageOrBuilder();
      } else {
        return identity_ == null
            ? com.google.api.serviceusage.v1beta1.ServiceIdentity.getDefaultInstance()
            : identity_;
      }
    }
    /**
     *
     *
     * <pre>
     * Service identity that service producer can use to access consumer
     * resources. If exists is true, it contains email and unique_id. If exists is
     * false, it contains pre-constructed email and empty unique_id.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.ServiceIdentity identity = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.ServiceIdentity,
            com.google.api.serviceusage.v1beta1.ServiceIdentity.Builder,
            com.google.api.serviceusage.v1beta1.ServiceIdentityOrBuilder>
        getIdentityFieldBuilder() {
      if (identityBuilder_ == null) {
        identityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.serviceusage.v1beta1.ServiceIdentity,
                com.google.api.serviceusage.v1beta1.ServiceIdentity.Builder,
                com.google.api.serviceusage.v1beta1.ServiceIdentityOrBuilder>(
                getIdentity(), getParentForChildren(), isClean());
        identity_ = null;
      }
      return identityBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Service identity state.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState state = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Service identity state.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState state = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service identity state.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState state = 2;
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState getState() {
      @SuppressWarnings("deprecation")
      com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState result =
          com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState.valueOf(
              state_);
      return result == null
          ? com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Service identity state.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState state = 2;
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(
        com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service identity state.
     * </pre>
     *
     * <code>.google.api.serviceusage.v1beta1.GetServiceIdentityResponse.IdentityState state = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.serviceusage.v1beta1.GetServiceIdentityResponse)
  }

  // @@protoc_insertion_point(class_scope:google.api.serviceusage.v1beta1.GetServiceIdentityResponse)
  private static final com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse();
  }

  public static com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GetServiceIdentityResponse> PARSER =
      new com.google.protobuf.AbstractParser<GetServiceIdentityResponse>() {
        @java.lang.Override
        public GetServiceIdentityResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GetServiceIdentityResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GetServiceIdentityResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.GetServiceIdentityResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
