/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/serviceusage/v1beta1/resources.proto

package com.google.api.serviceusage.v1beta1;

/**
 *
 *
 * <pre>
 * Consumer quota settings for a quota metric.
 * </pre>
 *
 * Protobuf type {@code google.api.serviceusage.v1beta1.ConsumerQuotaMetric}
 */
public final class ConsumerQuotaMetric extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.serviceusage.v1beta1.ConsumerQuotaMetric)
    ConsumerQuotaMetricOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConsumerQuotaMetric.newBuilder() to construct.
  private ConsumerQuotaMetric(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConsumerQuotaMetric() {
    name_ = "";
    metric_ = "";
    displayName_ = "";
    consumerQuotaLimits_ = java.util.Collections.emptyList();
    descendantConsumerQuotaLimits_ = java.util.Collections.emptyList();
    unit_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConsumerQuotaMetric();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.serviceusage.v1beta1.ResourcesProto
        .internal_static_google_api_serviceusage_v1beta1_ConsumerQuotaMetric_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.serviceusage.v1beta1.ResourcesProto
        .internal_static_google_api_serviceusage_v1beta1_ConsumerQuotaMetric_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric.class,
            com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the quota settings on this metric for this consumer.
   * An example name would be:
   * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus`
   * The resource name is intended to be opaque and should not be parsed for
   * its component strings, since its representation could change in the future.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the quota settings on this metric for this consumer.
   * An example name would be:
   * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus`
   * The resource name is intended to be opaque and should not be parsed for
   * its component strings, since its representation could change in the future.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRIC_FIELD_NUMBER = 4;
  private volatile java.lang.Object metric_;
  /**
   *
   *
   * <pre>
   * The name of the metric.
   * An example name would be:
   * `compute.googleapis.com/cpus`
   * </pre>
   *
   * <code>string metric = 4;</code>
   *
   * @return The metric.
   */
  @java.lang.Override
  public java.lang.String getMetric() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metric_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the metric.
   * An example name would be:
   * `compute.googleapis.com/cpus`
   * </pre>
   *
   * <code>string metric = 4;</code>
   *
   * @return The bytes for metric.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricBytes() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metric_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * The display name of the metric.
   * An example name would be:
   * `CPUs`
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the metric.
   * An example name would be:
   * `CPUs`
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONSUMER_QUOTA_LIMITS_FIELD_NUMBER = 3;
  private java.util.List<com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit>
      consumerQuotaLimits_;
  /**
   *
   *
   * <pre>
   * The consumer quota for each quota limit defined on the metric.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit>
      getConsumerQuotaLimitsList() {
    return consumerQuotaLimits_;
  }
  /**
   *
   *
   * <pre>
   * The consumer quota for each quota limit defined on the metric.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder>
      getConsumerQuotaLimitsOrBuilderList() {
    return consumerQuotaLimits_;
  }
  /**
   *
   *
   * <pre>
   * The consumer quota for each quota limit defined on the metric.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
   * </code>
   */
  @java.lang.Override
  public int getConsumerQuotaLimitsCount() {
    return consumerQuotaLimits_.size();
  }
  /**
   *
   *
   * <pre>
   * The consumer quota for each quota limit defined on the metric.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit getConsumerQuotaLimits(int index) {
    return consumerQuotaLimits_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The consumer quota for each quota limit defined on the metric.
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder
      getConsumerQuotaLimitsOrBuilder(int index) {
    return consumerQuotaLimits_.get(index);
  }

  public static final int DESCENDANT_CONSUMER_QUOTA_LIMITS_FIELD_NUMBER = 6;
  private java.util.List<com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit>
      descendantConsumerQuotaLimits_;
  /**
   *
   *
   * <pre>
   * The quota limits targeting the descendant containers of the
   * consumer in request.
   * If the consumer in request is of type `organizations`
   * or `folders`, the field will list per-project limits in the metric; if the
   * consumer in request is of type `project`, the field will be empty.
   * The `quota_buckets` field of each descendant consumer quota limit will not
   * be populated.
   * </pre>
   *
   * <code>
   * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit>
      getDescendantConsumerQuotaLimitsList() {
    return descendantConsumerQuotaLimits_;
  }
  /**
   *
   *
   * <pre>
   * The quota limits targeting the descendant containers of the
   * consumer in request.
   * If the consumer in request is of type `organizations`
   * or `folders`, the field will list per-project limits in the metric; if the
   * consumer in request is of type `project`, the field will be empty.
   * The `quota_buckets` field of each descendant consumer quota limit will not
   * be populated.
   * </pre>
   *
   * <code>
   * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder>
      getDescendantConsumerQuotaLimitsOrBuilderList() {
    return descendantConsumerQuotaLimits_;
  }
  /**
   *
   *
   * <pre>
   * The quota limits targeting the descendant containers of the
   * consumer in request.
   * If the consumer in request is of type `organizations`
   * or `folders`, the field will list per-project limits in the metric; if the
   * consumer in request is of type `project`, the field will be empty.
   * The `quota_buckets` field of each descendant consumer quota limit will not
   * be populated.
   * </pre>
   *
   * <code>
   * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
   * </code>
   */
  @java.lang.Override
  public int getDescendantConsumerQuotaLimitsCount() {
    return descendantConsumerQuotaLimits_.size();
  }
  /**
   *
   *
   * <pre>
   * The quota limits targeting the descendant containers of the
   * consumer in request.
   * If the consumer in request is of type `organizations`
   * or `folders`, the field will list per-project limits in the metric; if the
   * consumer in request is of type `project`, the field will be empty.
   * The `quota_buckets` field of each descendant consumer quota limit will not
   * be populated.
   * </pre>
   *
   * <code>
   * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit getDescendantConsumerQuotaLimits(
      int index) {
    return descendantConsumerQuotaLimits_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The quota limits targeting the descendant containers of the
   * consumer in request.
   * If the consumer in request is of type `organizations`
   * or `folders`, the field will list per-project limits in the metric; if the
   * consumer in request is of type `project`, the field will be empty.
   * The `quota_buckets` field of each descendant consumer quota limit will not
   * be populated.
   * </pre>
   *
   * <code>
   * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder
      getDescendantConsumerQuotaLimitsOrBuilder(int index) {
    return descendantConsumerQuotaLimits_.get(index);
  }

  public static final int UNIT_FIELD_NUMBER = 5;
  private volatile java.lang.Object unit_;
  /**
   *
   *
   * <pre>
   * The units in which the metric value is reported.
   * </pre>
   *
   * <code>string unit = 5;</code>
   *
   * @return The unit.
   */
  @java.lang.Override
  public java.lang.String getUnit() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      unit_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The units in which the metric value is reported.
   * </pre>
   *
   * <code>string unit = 5;</code>
   *
   * @return The bytes for unit.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUnitBytes() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      unit_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    for (int i = 0; i < consumerQuotaLimits_.size(); i++) {
      output.writeMessage(3, consumerQuotaLimits_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, metric_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, unit_);
    }
    for (int i = 0; i < descendantConsumerQuotaLimits_.size(); i++) {
      output.writeMessage(6, descendantConsumerQuotaLimits_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    for (int i = 0; i < consumerQuotaLimits_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, consumerQuotaLimits_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, metric_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, unit_);
    }
    for (int i = 0; i < descendantConsumerQuotaLimits_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, descendantConsumerQuotaLimits_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric)) {
      return super.equals(obj);
    }
    com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric other =
        (com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getMetric().equals(other.getMetric())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getConsumerQuotaLimitsList().equals(other.getConsumerQuotaLimitsList())) return false;
    if (!getDescendantConsumerQuotaLimitsList()
        .equals(other.getDescendantConsumerQuotaLimitsList())) return false;
    if (!getUnit().equals(other.getUnit())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + METRIC_FIELD_NUMBER;
    hash = (53 * hash) + getMetric().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getConsumerQuotaLimitsCount() > 0) {
      hash = (37 * hash) + CONSUMER_QUOTA_LIMITS_FIELD_NUMBER;
      hash = (53 * hash) + getConsumerQuotaLimitsList().hashCode();
    }
    if (getDescendantConsumerQuotaLimitsCount() > 0) {
      hash = (37 * hash) + DESCENDANT_CONSUMER_QUOTA_LIMITS_FIELD_NUMBER;
      hash = (53 * hash) + getDescendantConsumerQuotaLimitsList().hashCode();
    }
    hash = (37 * hash) + UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getUnit().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Consumer quota settings for a quota metric.
   * </pre>
   *
   * Protobuf type {@code google.api.serviceusage.v1beta1.ConsumerQuotaMetric}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.serviceusage.v1beta1.ConsumerQuotaMetric)
      com.google.api.serviceusage.v1beta1.ConsumerQuotaMetricOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_ConsumerQuotaMetric_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_ConsumerQuotaMetric_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric.class,
              com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric.Builder.class);
    }

    // Construct using com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      metric_ = "";

      displayName_ = "";

      if (consumerQuotaLimitsBuilder_ == null) {
        consumerQuotaLimits_ = java.util.Collections.emptyList();
      } else {
        consumerQuotaLimits_ = null;
        consumerQuotaLimitsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        descendantConsumerQuotaLimits_ = java.util.Collections.emptyList();
      } else {
        descendantConsumerQuotaLimits_ = null;
        descendantConsumerQuotaLimitsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      unit_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_ConsumerQuotaMetric_descriptor;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric getDefaultInstanceForType() {
      return com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric build() {
      com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric buildPartial() {
      com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric result =
          new com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.metric_ = metric_;
      result.displayName_ = displayName_;
      if (consumerQuotaLimitsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          consumerQuotaLimits_ = java.util.Collections.unmodifiableList(consumerQuotaLimits_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.consumerQuotaLimits_ = consumerQuotaLimits_;
      } else {
        result.consumerQuotaLimits_ = consumerQuotaLimitsBuilder_.build();
      }
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          descendantConsumerQuotaLimits_ =
              java.util.Collections.unmodifiableList(descendantConsumerQuotaLimits_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.descendantConsumerQuotaLimits_ = descendantConsumerQuotaLimits_;
      } else {
        result.descendantConsumerQuotaLimits_ = descendantConsumerQuotaLimitsBuilder_.build();
      }
      result.unit_ = unit_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric) {
        return mergeFrom((com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric other) {
      if (other == com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getMetric().isEmpty()) {
        metric_ = other.metric_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (consumerQuotaLimitsBuilder_ == null) {
        if (!other.consumerQuotaLimits_.isEmpty()) {
          if (consumerQuotaLimits_.isEmpty()) {
            consumerQuotaLimits_ = other.consumerQuotaLimits_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureConsumerQuotaLimitsIsMutable();
            consumerQuotaLimits_.addAll(other.consumerQuotaLimits_);
          }
          onChanged();
        }
      } else {
        if (!other.consumerQuotaLimits_.isEmpty()) {
          if (consumerQuotaLimitsBuilder_.isEmpty()) {
            consumerQuotaLimitsBuilder_.dispose();
            consumerQuotaLimitsBuilder_ = null;
            consumerQuotaLimits_ = other.consumerQuotaLimits_;
            bitField0_ = (bitField0_ & ~0x00000001);
            consumerQuotaLimitsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConsumerQuotaLimitsFieldBuilder()
                    : null;
          } else {
            consumerQuotaLimitsBuilder_.addAllMessages(other.consumerQuotaLimits_);
          }
        }
      }
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        if (!other.descendantConsumerQuotaLimits_.isEmpty()) {
          if (descendantConsumerQuotaLimits_.isEmpty()) {
            descendantConsumerQuotaLimits_ = other.descendantConsumerQuotaLimits_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDescendantConsumerQuotaLimitsIsMutable();
            descendantConsumerQuotaLimits_.addAll(other.descendantConsumerQuotaLimits_);
          }
          onChanged();
        }
      } else {
        if (!other.descendantConsumerQuotaLimits_.isEmpty()) {
          if (descendantConsumerQuotaLimitsBuilder_.isEmpty()) {
            descendantConsumerQuotaLimitsBuilder_.dispose();
            descendantConsumerQuotaLimitsBuilder_ = null;
            descendantConsumerQuotaLimits_ = other.descendantConsumerQuotaLimits_;
            bitField0_ = (bitField0_ & ~0x00000002);
            descendantConsumerQuotaLimitsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDescendantConsumerQuotaLimitsFieldBuilder()
                    : null;
          } else {
            descendantConsumerQuotaLimitsBuilder_.addAllMessages(
                other.descendantConsumerQuotaLimits_);
          }
        }
      }
      if (!other.getUnit().isEmpty()) {
        unit_ = other.unit_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit m =
                    input.readMessage(
                        com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.parser(),
                        extensionRegistry);
                if (consumerQuotaLimitsBuilder_ == null) {
                  ensureConsumerQuotaLimitsIsMutable();
                  consumerQuotaLimits_.add(m);
                } else {
                  consumerQuotaLimitsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                metric_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                unit_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit m =
                    input.readMessage(
                        com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.parser(),
                        extensionRegistry);
                if (descendantConsumerQuotaLimitsBuilder_ == null) {
                  ensureDescendantConsumerQuotaLimitsIsMutable();
                  descendantConsumerQuotaLimits_.add(m);
                } else {
                  descendantConsumerQuotaLimitsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the quota settings on this metric for this consumer.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the quota settings on this metric for this consumer.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the quota settings on this metric for this consumer.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the quota settings on this metric for this consumer.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the quota settings on this metric for this consumer.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object metric_ = "";
    /**
     *
     *
     * <pre>
     * The name of the metric.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @return The metric.
     */
    public java.lang.String getMetric() {
      java.lang.Object ref = metric_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metric_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the metric.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @return The bytes for metric.
     */
    public com.google.protobuf.ByteString getMetricBytes() {
      java.lang.Object ref = metric_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metric_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the metric.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @param value The metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetric(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      metric_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the metric.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetric() {

      metric_ = getDefaultInstance().getMetric();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the metric.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @param value The bytes for metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetricBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      metric_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the metric.
     * An example name would be:
     * `CPUs`
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the metric.
     * An example name would be:
     * `CPUs`
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the metric.
     * An example name would be:
     * `CPUs`
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the metric.
     * An example name would be:
     * `CPUs`
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the metric.
     * An example name would be:
     * `CPUs`
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit>
        consumerQuotaLimits_ = java.util.Collections.emptyList();

    private void ensureConsumerQuotaLimitsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        consumerQuotaLimits_ =
            new java.util.ArrayList<com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit>(
                consumerQuotaLimits_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit,
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder,
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder>
        consumerQuotaLimitsBuilder_;

    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public java.util.List<com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit>
        getConsumerQuotaLimitsList() {
      if (consumerQuotaLimitsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(consumerQuotaLimits_);
      } else {
        return consumerQuotaLimitsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public int getConsumerQuotaLimitsCount() {
      if (consumerQuotaLimitsBuilder_ == null) {
        return consumerQuotaLimits_.size();
      } else {
        return consumerQuotaLimitsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit getConsumerQuotaLimits(
        int index) {
      if (consumerQuotaLimitsBuilder_ == null) {
        return consumerQuotaLimits_.get(index);
      } else {
        return consumerQuotaLimitsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public Builder setConsumerQuotaLimits(
        int index, com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit value) {
      if (consumerQuotaLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerQuotaLimitsIsMutable();
        consumerQuotaLimits_.set(index, value);
        onChanged();
      } else {
        consumerQuotaLimitsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public Builder setConsumerQuotaLimits(
        int index, com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder builderForValue) {
      if (consumerQuotaLimitsBuilder_ == null) {
        ensureConsumerQuotaLimitsIsMutable();
        consumerQuotaLimits_.set(index, builderForValue.build());
        onChanged();
      } else {
        consumerQuotaLimitsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public Builder addConsumerQuotaLimits(
        com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit value) {
      if (consumerQuotaLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerQuotaLimitsIsMutable();
        consumerQuotaLimits_.add(value);
        onChanged();
      } else {
        consumerQuotaLimitsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public Builder addConsumerQuotaLimits(
        int index, com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit value) {
      if (consumerQuotaLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerQuotaLimitsIsMutable();
        consumerQuotaLimits_.add(index, value);
        onChanged();
      } else {
        consumerQuotaLimitsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public Builder addConsumerQuotaLimits(
        com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder builderForValue) {
      if (consumerQuotaLimitsBuilder_ == null) {
        ensureConsumerQuotaLimitsIsMutable();
        consumerQuotaLimits_.add(builderForValue.build());
        onChanged();
      } else {
        consumerQuotaLimitsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public Builder addConsumerQuotaLimits(
        int index, com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder builderForValue) {
      if (consumerQuotaLimitsBuilder_ == null) {
        ensureConsumerQuotaLimitsIsMutable();
        consumerQuotaLimits_.add(index, builderForValue.build());
        onChanged();
      } else {
        consumerQuotaLimitsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public Builder addAllConsumerQuotaLimits(
        java.lang.Iterable<? extends com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit>
            values) {
      if (consumerQuotaLimitsBuilder_ == null) {
        ensureConsumerQuotaLimitsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, consumerQuotaLimits_);
        onChanged();
      } else {
        consumerQuotaLimitsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public Builder clearConsumerQuotaLimits() {
      if (consumerQuotaLimitsBuilder_ == null) {
        consumerQuotaLimits_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        consumerQuotaLimitsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public Builder removeConsumerQuotaLimits(int index) {
      if (consumerQuotaLimitsBuilder_ == null) {
        ensureConsumerQuotaLimitsIsMutable();
        consumerQuotaLimits_.remove(index);
        onChanged();
      } else {
        consumerQuotaLimitsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder
        getConsumerQuotaLimitsBuilder(int index) {
      return getConsumerQuotaLimitsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder
        getConsumerQuotaLimitsOrBuilder(int index) {
      if (consumerQuotaLimitsBuilder_ == null) {
        return consumerQuotaLimits_.get(index);
      } else {
        return consumerQuotaLimitsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public java.util.List<? extends com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder>
        getConsumerQuotaLimitsOrBuilderList() {
      if (consumerQuotaLimitsBuilder_ != null) {
        return consumerQuotaLimitsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(consumerQuotaLimits_);
      }
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder
        addConsumerQuotaLimitsBuilder() {
      return getConsumerQuotaLimitsFieldBuilder()
          .addBuilder(com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder
        addConsumerQuotaLimitsBuilder(int index) {
      return getConsumerQuotaLimitsFieldBuilder()
          .addBuilder(
              index, com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The consumer quota for each quota limit defined on the metric.
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit consumer_quota_limits = 3;
     * </code>
     */
    public java.util.List<com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder>
        getConsumerQuotaLimitsBuilderList() {
      return getConsumerQuotaLimitsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit,
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder,
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder>
        getConsumerQuotaLimitsFieldBuilder() {
      if (consumerQuotaLimitsBuilder_ == null) {
        consumerQuotaLimitsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit,
                com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder,
                com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder>(
                consumerQuotaLimits_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        consumerQuotaLimits_ = null;
      }
      return consumerQuotaLimitsBuilder_;
    }

    private java.util.List<com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit>
        descendantConsumerQuotaLimits_ = java.util.Collections.emptyList();

    private void ensureDescendantConsumerQuotaLimitsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        descendantConsumerQuotaLimits_ =
            new java.util.ArrayList<com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit>(
                descendantConsumerQuotaLimits_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit,
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder,
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder>
        descendantConsumerQuotaLimitsBuilder_;

    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public java.util.List<com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit>
        getDescendantConsumerQuotaLimitsList() {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(descendantConsumerQuotaLimits_);
      } else {
        return descendantConsumerQuotaLimitsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public int getDescendantConsumerQuotaLimitsCount() {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        return descendantConsumerQuotaLimits_.size();
      } else {
        return descendantConsumerQuotaLimitsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit getDescendantConsumerQuotaLimits(
        int index) {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        return descendantConsumerQuotaLimits_.get(index);
      } else {
        return descendantConsumerQuotaLimitsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public Builder setDescendantConsumerQuotaLimits(
        int index, com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit value) {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDescendantConsumerQuotaLimitsIsMutable();
        descendantConsumerQuotaLimits_.set(index, value);
        onChanged();
      } else {
        descendantConsumerQuotaLimitsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public Builder setDescendantConsumerQuotaLimits(
        int index, com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder builderForValue) {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        ensureDescendantConsumerQuotaLimitsIsMutable();
        descendantConsumerQuotaLimits_.set(index, builderForValue.build());
        onChanged();
      } else {
        descendantConsumerQuotaLimitsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public Builder addDescendantConsumerQuotaLimits(
        com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit value) {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDescendantConsumerQuotaLimitsIsMutable();
        descendantConsumerQuotaLimits_.add(value);
        onChanged();
      } else {
        descendantConsumerQuotaLimitsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public Builder addDescendantConsumerQuotaLimits(
        int index, com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit value) {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDescendantConsumerQuotaLimitsIsMutable();
        descendantConsumerQuotaLimits_.add(index, value);
        onChanged();
      } else {
        descendantConsumerQuotaLimitsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public Builder addDescendantConsumerQuotaLimits(
        com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder builderForValue) {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        ensureDescendantConsumerQuotaLimitsIsMutable();
        descendantConsumerQuotaLimits_.add(builderForValue.build());
        onChanged();
      } else {
        descendantConsumerQuotaLimitsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public Builder addDescendantConsumerQuotaLimits(
        int index, com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder builderForValue) {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        ensureDescendantConsumerQuotaLimitsIsMutable();
        descendantConsumerQuotaLimits_.add(index, builderForValue.build());
        onChanged();
      } else {
        descendantConsumerQuotaLimitsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public Builder addAllDescendantConsumerQuotaLimits(
        java.lang.Iterable<? extends com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit>
            values) {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        ensureDescendantConsumerQuotaLimitsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, descendantConsumerQuotaLimits_);
        onChanged();
      } else {
        descendantConsumerQuotaLimitsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public Builder clearDescendantConsumerQuotaLimits() {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        descendantConsumerQuotaLimits_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        descendantConsumerQuotaLimitsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public Builder removeDescendantConsumerQuotaLimits(int index) {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        ensureDescendantConsumerQuotaLimitsIsMutable();
        descendantConsumerQuotaLimits_.remove(index);
        onChanged();
      } else {
        descendantConsumerQuotaLimitsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder
        getDescendantConsumerQuotaLimitsBuilder(int index) {
      return getDescendantConsumerQuotaLimitsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder
        getDescendantConsumerQuotaLimitsOrBuilder(int index) {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        return descendantConsumerQuotaLimits_.get(index);
      } else {
        return descendantConsumerQuotaLimitsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public java.util.List<? extends com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder>
        getDescendantConsumerQuotaLimitsOrBuilderList() {
      if (descendantConsumerQuotaLimitsBuilder_ != null) {
        return descendantConsumerQuotaLimitsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(descendantConsumerQuotaLimits_);
      }
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder
        addDescendantConsumerQuotaLimitsBuilder() {
      return getDescendantConsumerQuotaLimitsFieldBuilder()
          .addBuilder(com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder
        addDescendantConsumerQuotaLimitsBuilder(int index) {
      return getDescendantConsumerQuotaLimitsFieldBuilder()
          .addBuilder(
              index, com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The quota limits targeting the descendant containers of the
     * consumer in request.
     * If the consumer in request is of type `organizations`
     * or `folders`, the field will list per-project limits in the metric; if the
     * consumer in request is of type `project`, the field will be empty.
     * The `quota_buckets` field of each descendant consumer quota limit will not
     * be populated.
     * </pre>
     *
     * <code>
     * repeated .google.api.serviceusage.v1beta1.ConsumerQuotaLimit descendant_consumer_quota_limits = 6;
     * </code>
     */
    public java.util.List<com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder>
        getDescendantConsumerQuotaLimitsBuilderList() {
      return getDescendantConsumerQuotaLimitsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit,
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder,
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder>
        getDescendantConsumerQuotaLimitsFieldBuilder() {
      if (descendantConsumerQuotaLimitsBuilder_ == null) {
        descendantConsumerQuotaLimitsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit,
                com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder,
                com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder>(
                descendantConsumerQuotaLimits_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        descendantConsumerQuotaLimits_ = null;
      }
      return descendantConsumerQuotaLimitsBuilder_;
    }

    private java.lang.Object unit_ = "";
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return The unit.
     */
    public java.lang.String getUnit() {
      java.lang.Object ref = unit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        unit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return The bytes for unit.
     */
    public com.google.protobuf.ByteString getUnitBytes() {
      java.lang.Object ref = unit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        unit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @param value The unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnit(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      unit_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnit() {

      unit_ = getDefaultInstance().getUnit();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The units in which the metric value is reported.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @param value The bytes for unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnitBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      unit_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.serviceusage.v1beta1.ConsumerQuotaMetric)
  }

  // @@protoc_insertion_point(class_scope:google.api.serviceusage.v1beta1.ConsumerQuotaMetric)
  private static final com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric();
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConsumerQuotaMetric> PARSER =
      new com.google.protobuf.AbstractParser<ConsumerQuotaMetric>() {
        @java.lang.Override
        public ConsumerQuotaMetric parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConsumerQuotaMetric> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConsumerQuotaMetric> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.ConsumerQuotaMetric getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
