/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/serviceusage/v1beta1/resources.proto

package com.google.api.serviceusage.v1beta1;

/**
 *
 *
 * <pre>
 * Consumer quota settings for a quota limit.
 * </pre>
 *
 * Protobuf type {@code google.api.serviceusage.v1beta1.ConsumerQuotaLimit}
 */
public final class ConsumerQuotaLimit extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.serviceusage.v1beta1.ConsumerQuotaLimit)
    ConsumerQuotaLimitOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConsumerQuotaLimit.newBuilder() to construct.
  private ConsumerQuotaLimit(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConsumerQuotaLimit() {
    name_ = "";
    metric_ = "";
    unit_ = "";
    quotaBuckets_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConsumerQuotaLimit();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.serviceusage.v1beta1.ResourcesProto
        .internal_static_google_api_serviceusage_v1beta1_ConsumerQuotaLimit_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.serviceusage.v1beta1.ResourcesProto
        .internal_static_google_api_serviceusage_v1beta1_ConsumerQuotaLimit_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.class,
            com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the quota limit.
   * An example name would be:
   * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`
   * The resource name is intended to be opaque and should not be parsed for
   * its component strings, since its representation could change in the future.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the quota limit.
   * An example name would be:
   * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`
   * The resource name is intended to be opaque and should not be parsed for
   * its component strings, since its representation could change in the future.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRIC_FIELD_NUMBER = 8;
  private volatile java.lang.Object metric_;
  /**
   *
   *
   * <pre>
   * The name of the parent metric of this limit.
   * An example name would be:
   * `compute.googleapis.com/cpus`
   * </pre>
   *
   * <code>string metric = 8;</code>
   *
   * @return The metric.
   */
  @java.lang.Override
  public java.lang.String getMetric() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metric_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the parent metric of this limit.
   * An example name would be:
   * `compute.googleapis.com/cpus`
   * </pre>
   *
   * <code>string metric = 8;</code>
   *
   * @return The bytes for metric.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricBytes() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metric_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNIT_FIELD_NUMBER = 2;
  private volatile java.lang.Object unit_;
  /**
   *
   *
   * <pre>
   * The limit unit.
   * An example unit would be
   * `1/{project}/{region}`
   * Note that `{project}` and `{region}` are not placeholders in this example;
   * the literal characters `{` and `}` occur in the string.
   * </pre>
   *
   * <code>string unit = 2;</code>
   *
   * @return The unit.
   */
  @java.lang.Override
  public java.lang.String getUnit() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      unit_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The limit unit.
   * An example unit would be
   * `1/{project}/{region}`
   * Note that `{project}` and `{region}` are not placeholders in this example;
   * the literal characters `{` and `}` occur in the string.
   * </pre>
   *
   * <code>string unit = 2;</code>
   *
   * @return The bytes for unit.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUnitBytes() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      unit_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_PRECISE_FIELD_NUMBER = 3;
  private boolean isPrecise_;
  /**
   *
   *
   * <pre>
   * Whether this limit is precise or imprecise.
   * </pre>
   *
   * <code>bool is_precise = 3;</code>
   *
   * @return The isPrecise.
   */
  @java.lang.Override
  public boolean getIsPrecise() {
    return isPrecise_;
  }

  public static final int ALLOWS_ADMIN_OVERRIDES_FIELD_NUMBER = 7;
  private boolean allowsAdminOverrides_;
  /**
   *
   *
   * <pre>
   * Whether admin overrides are allowed on this limit
   * </pre>
   *
   * <code>bool allows_admin_overrides = 7;</code>
   *
   * @return The allowsAdminOverrides.
   */
  @java.lang.Override
  public boolean getAllowsAdminOverrides() {
    return allowsAdminOverrides_;
  }

  public static final int QUOTA_BUCKETS_FIELD_NUMBER = 9;
  private java.util.List<com.google.api.serviceusage.v1beta1.QuotaBucket> quotaBuckets_;
  /**
   *
   *
   * <pre>
   * Summary of the enforced quota buckets, organized by quota dimension,
   * ordered from least specific to most specific (for example, the global
   * default bucket, with no quota dimensions, will always appear first).
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.serviceusage.v1beta1.QuotaBucket> getQuotaBucketsList() {
    return quotaBuckets_;
  }
  /**
   *
   *
   * <pre>
   * Summary of the enforced quota buckets, organized by quota dimension,
   * ordered from least specific to most specific (for example, the global
   * default bucket, with no quota dimensions, will always appear first).
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.serviceusage.v1beta1.QuotaBucketOrBuilder>
      getQuotaBucketsOrBuilderList() {
    return quotaBuckets_;
  }
  /**
   *
   *
   * <pre>
   * Summary of the enforced quota buckets, organized by quota dimension,
   * ordered from least specific to most specific (for example, the global
   * default bucket, with no quota dimensions, will always appear first).
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
   */
  @java.lang.Override
  public int getQuotaBucketsCount() {
    return quotaBuckets_.size();
  }
  /**
   *
   *
   * <pre>
   * Summary of the enforced quota buckets, organized by quota dimension,
   * ordered from least specific to most specific (for example, the global
   * default bucket, with no quota dimensions, will always appear first).
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaBucket getQuotaBuckets(int index) {
    return quotaBuckets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Summary of the enforced quota buckets, organized by quota dimension,
   * ordered from least specific to most specific (for example, the global
   * default bucket, with no quota dimensions, will always appear first).
   * </pre>
   *
   * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
   */
  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.QuotaBucketOrBuilder getQuotaBucketsOrBuilder(
      int index) {
    return quotaBuckets_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, unit_);
    }
    if (isPrecise_ != false) {
      output.writeBool(3, isPrecise_);
    }
    if (allowsAdminOverrides_ != false) {
      output.writeBool(7, allowsAdminOverrides_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, metric_);
    }
    for (int i = 0; i < quotaBuckets_.size(); i++) {
      output.writeMessage(9, quotaBuckets_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, unit_);
    }
    if (isPrecise_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, isPrecise_);
    }
    if (allowsAdminOverrides_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, allowsAdminOverrides_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, metric_);
    }
    for (int i = 0; i < quotaBuckets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, quotaBuckets_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit)) {
      return super.equals(obj);
    }
    com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit other =
        (com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getMetric().equals(other.getMetric())) return false;
    if (!getUnit().equals(other.getUnit())) return false;
    if (getIsPrecise() != other.getIsPrecise()) return false;
    if (getAllowsAdminOverrides() != other.getAllowsAdminOverrides()) return false;
    if (!getQuotaBucketsList().equals(other.getQuotaBucketsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + METRIC_FIELD_NUMBER;
    hash = (53 * hash) + getMetric().hashCode();
    hash = (37 * hash) + UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getUnit().hashCode();
    hash = (37 * hash) + IS_PRECISE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsPrecise());
    hash = (37 * hash) + ALLOWS_ADMIN_OVERRIDES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowsAdminOverrides());
    if (getQuotaBucketsCount() > 0) {
      hash = (37 * hash) + QUOTA_BUCKETS_FIELD_NUMBER;
      hash = (53 * hash) + getQuotaBucketsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Consumer quota settings for a quota limit.
   * </pre>
   *
   * Protobuf type {@code google.api.serviceusage.v1beta1.ConsumerQuotaLimit}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.serviceusage.v1beta1.ConsumerQuotaLimit)
      com.google.api.serviceusage.v1beta1.ConsumerQuotaLimitOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_ConsumerQuotaLimit_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_ConsumerQuotaLimit_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.class,
              com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.Builder.class);
    }

    // Construct using com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      metric_ = "";

      unit_ = "";

      isPrecise_ = false;

      allowsAdminOverrides_ = false;

      if (quotaBucketsBuilder_ == null) {
        quotaBuckets_ = java.util.Collections.emptyList();
      } else {
        quotaBuckets_ = null;
        quotaBucketsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_ConsumerQuotaLimit_descriptor;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit getDefaultInstanceForType() {
      return com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit build() {
      com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit buildPartial() {
      com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit result =
          new com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.metric_ = metric_;
      result.unit_ = unit_;
      result.isPrecise_ = isPrecise_;
      result.allowsAdminOverrides_ = allowsAdminOverrides_;
      if (quotaBucketsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          quotaBuckets_ = java.util.Collections.unmodifiableList(quotaBuckets_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.quotaBuckets_ = quotaBuckets_;
      } else {
        result.quotaBuckets_ = quotaBucketsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit) {
        return mergeFrom((com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit other) {
      if (other == com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getMetric().isEmpty()) {
        metric_ = other.metric_;
        onChanged();
      }
      if (!other.getUnit().isEmpty()) {
        unit_ = other.unit_;
        onChanged();
      }
      if (other.getIsPrecise() != false) {
        setIsPrecise(other.getIsPrecise());
      }
      if (other.getAllowsAdminOverrides() != false) {
        setAllowsAdminOverrides(other.getAllowsAdminOverrides());
      }
      if (quotaBucketsBuilder_ == null) {
        if (!other.quotaBuckets_.isEmpty()) {
          if (quotaBuckets_.isEmpty()) {
            quotaBuckets_ = other.quotaBuckets_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureQuotaBucketsIsMutable();
            quotaBuckets_.addAll(other.quotaBuckets_);
          }
          onChanged();
        }
      } else {
        if (!other.quotaBuckets_.isEmpty()) {
          if (quotaBucketsBuilder_.isEmpty()) {
            quotaBucketsBuilder_.dispose();
            quotaBucketsBuilder_ = null;
            quotaBuckets_ = other.quotaBuckets_;
            bitField0_ = (bitField0_ & ~0x00000001);
            quotaBucketsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQuotaBucketsFieldBuilder()
                    : null;
          } else {
            quotaBucketsBuilder_.addAllMessages(other.quotaBuckets_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                unit_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 24:
              {
                isPrecise_ = input.readBool();

                break;
              } // case 24
            case 56:
              {
                allowsAdminOverrides_ = input.readBool();

                break;
              } // case 56
            case 66:
              {
                metric_ = input.readStringRequireUtf8();

                break;
              } // case 66
            case 74:
              {
                com.google.api.serviceusage.v1beta1.QuotaBucket m =
                    input.readMessage(
                        com.google.api.serviceusage.v1beta1.QuotaBucket.parser(),
                        extensionRegistry);
                if (quotaBucketsBuilder_ == null) {
                  ensureQuotaBucketsIsMutable();
                  quotaBuckets_.add(m);
                } else {
                  quotaBucketsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the quota limit.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the quota limit.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the quota limit.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the quota limit.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the quota limit.
     * An example name would be:
     * `projects/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion`
     * The resource name is intended to be opaque and should not be parsed for
     * its component strings, since its representation could change in the future.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object metric_ = "";
    /**
     *
     *
     * <pre>
     * The name of the parent metric of this limit.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 8;</code>
     *
     * @return The metric.
     */
    public java.lang.String getMetric() {
      java.lang.Object ref = metric_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metric_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the parent metric of this limit.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 8;</code>
     *
     * @return The bytes for metric.
     */
    public com.google.protobuf.ByteString getMetricBytes() {
      java.lang.Object ref = metric_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metric_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the parent metric of this limit.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 8;</code>
     *
     * @param value The metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetric(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      metric_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the parent metric of this limit.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetric() {

      metric_ = getDefaultInstance().getMetric();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the parent metric of this limit.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 8;</code>
     *
     * @param value The bytes for metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetricBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      metric_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object unit_ = "";
    /**
     *
     *
     * <pre>
     * The limit unit.
     * An example unit would be
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 2;</code>
     *
     * @return The unit.
     */
    public java.lang.String getUnit() {
      java.lang.Object ref = unit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        unit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The limit unit.
     * An example unit would be
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 2;</code>
     *
     * @return The bytes for unit.
     */
    public com.google.protobuf.ByteString getUnitBytes() {
      java.lang.Object ref = unit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        unit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The limit unit.
     * An example unit would be
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 2;</code>
     *
     * @param value The unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnit(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      unit_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The limit unit.
     * An example unit would be
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnit() {

      unit_ = getDefaultInstance().getUnit();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The limit unit.
     * An example unit would be
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 2;</code>
     *
     * @param value The bytes for unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnitBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      unit_ = value;
      onChanged();
      return this;
    }

    private boolean isPrecise_;
    /**
     *
     *
     * <pre>
     * Whether this limit is precise or imprecise.
     * </pre>
     *
     * <code>bool is_precise = 3;</code>
     *
     * @return The isPrecise.
     */
    @java.lang.Override
    public boolean getIsPrecise() {
      return isPrecise_;
    }
    /**
     *
     *
     * <pre>
     * Whether this limit is precise or imprecise.
     * </pre>
     *
     * <code>bool is_precise = 3;</code>
     *
     * @param value The isPrecise to set.
     * @return This builder for chaining.
     */
    public Builder setIsPrecise(boolean value) {

      isPrecise_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether this limit is precise or imprecise.
     * </pre>
     *
     * <code>bool is_precise = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsPrecise() {

      isPrecise_ = false;
      onChanged();
      return this;
    }

    private boolean allowsAdminOverrides_;
    /**
     *
     *
     * <pre>
     * Whether admin overrides are allowed on this limit
     * </pre>
     *
     * <code>bool allows_admin_overrides = 7;</code>
     *
     * @return The allowsAdminOverrides.
     */
    @java.lang.Override
    public boolean getAllowsAdminOverrides() {
      return allowsAdminOverrides_;
    }
    /**
     *
     *
     * <pre>
     * Whether admin overrides are allowed on this limit
     * </pre>
     *
     * <code>bool allows_admin_overrides = 7;</code>
     *
     * @param value The allowsAdminOverrides to set.
     * @return This builder for chaining.
     */
    public Builder setAllowsAdminOverrides(boolean value) {

      allowsAdminOverrides_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether admin overrides are allowed on this limit
     * </pre>
     *
     * <code>bool allows_admin_overrides = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowsAdminOverrides() {

      allowsAdminOverrides_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.api.serviceusage.v1beta1.QuotaBucket> quotaBuckets_ =
        java.util.Collections.emptyList();

    private void ensureQuotaBucketsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        quotaBuckets_ =
            new java.util.ArrayList<com.google.api.serviceusage.v1beta1.QuotaBucket>(quotaBuckets_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.QuotaBucket,
            com.google.api.serviceusage.v1beta1.QuotaBucket.Builder,
            com.google.api.serviceusage.v1beta1.QuotaBucketOrBuilder>
        quotaBucketsBuilder_;

    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public java.util.List<com.google.api.serviceusage.v1beta1.QuotaBucket> getQuotaBucketsList() {
      if (quotaBucketsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(quotaBuckets_);
      } else {
        return quotaBucketsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public int getQuotaBucketsCount() {
      if (quotaBucketsBuilder_ == null) {
        return quotaBuckets_.size();
      } else {
        return quotaBucketsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaBucket getQuotaBuckets(int index) {
      if (quotaBucketsBuilder_ == null) {
        return quotaBuckets_.get(index);
      } else {
        return quotaBucketsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public Builder setQuotaBuckets(
        int index, com.google.api.serviceusage.v1beta1.QuotaBucket value) {
      if (quotaBucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuotaBucketsIsMutable();
        quotaBuckets_.set(index, value);
        onChanged();
      } else {
        quotaBucketsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public Builder setQuotaBuckets(
        int index, com.google.api.serviceusage.v1beta1.QuotaBucket.Builder builderForValue) {
      if (quotaBucketsBuilder_ == null) {
        ensureQuotaBucketsIsMutable();
        quotaBuckets_.set(index, builderForValue.build());
        onChanged();
      } else {
        quotaBucketsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public Builder addQuotaBuckets(com.google.api.serviceusage.v1beta1.QuotaBucket value) {
      if (quotaBucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuotaBucketsIsMutable();
        quotaBuckets_.add(value);
        onChanged();
      } else {
        quotaBucketsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public Builder addQuotaBuckets(
        int index, com.google.api.serviceusage.v1beta1.QuotaBucket value) {
      if (quotaBucketsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuotaBucketsIsMutable();
        quotaBuckets_.add(index, value);
        onChanged();
      } else {
        quotaBucketsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public Builder addQuotaBuckets(
        com.google.api.serviceusage.v1beta1.QuotaBucket.Builder builderForValue) {
      if (quotaBucketsBuilder_ == null) {
        ensureQuotaBucketsIsMutable();
        quotaBuckets_.add(builderForValue.build());
        onChanged();
      } else {
        quotaBucketsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public Builder addQuotaBuckets(
        int index, com.google.api.serviceusage.v1beta1.QuotaBucket.Builder builderForValue) {
      if (quotaBucketsBuilder_ == null) {
        ensureQuotaBucketsIsMutable();
        quotaBuckets_.add(index, builderForValue.build());
        onChanged();
      } else {
        quotaBucketsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public Builder addAllQuotaBuckets(
        java.lang.Iterable<? extends com.google.api.serviceusage.v1beta1.QuotaBucket> values) {
      if (quotaBucketsBuilder_ == null) {
        ensureQuotaBucketsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, quotaBuckets_);
        onChanged();
      } else {
        quotaBucketsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public Builder clearQuotaBuckets() {
      if (quotaBucketsBuilder_ == null) {
        quotaBuckets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        quotaBucketsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public Builder removeQuotaBuckets(int index) {
      if (quotaBucketsBuilder_ == null) {
        ensureQuotaBucketsIsMutable();
        quotaBuckets_.remove(index);
        onChanged();
      } else {
        quotaBucketsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaBucket.Builder getQuotaBucketsBuilder(
        int index) {
      return getQuotaBucketsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaBucketOrBuilder getQuotaBucketsOrBuilder(
        int index) {
      if (quotaBucketsBuilder_ == null) {
        return quotaBuckets_.get(index);
      } else {
        return quotaBucketsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public java.util.List<? extends com.google.api.serviceusage.v1beta1.QuotaBucketOrBuilder>
        getQuotaBucketsOrBuilderList() {
      if (quotaBucketsBuilder_ != null) {
        return quotaBucketsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(quotaBuckets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaBucket.Builder addQuotaBucketsBuilder() {
      return getQuotaBucketsFieldBuilder()
          .addBuilder(com.google.api.serviceusage.v1beta1.QuotaBucket.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public com.google.api.serviceusage.v1beta1.QuotaBucket.Builder addQuotaBucketsBuilder(
        int index) {
      return getQuotaBucketsFieldBuilder()
          .addBuilder(index, com.google.api.serviceusage.v1beta1.QuotaBucket.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Summary of the enforced quota buckets, organized by quota dimension,
     * ordered from least specific to most specific (for example, the global
     * default bucket, with no quota dimensions, will always appear first).
     * </pre>
     *
     * <code>repeated .google.api.serviceusage.v1beta1.QuotaBucket quota_buckets = 9;</code>
     */
    public java.util.List<com.google.api.serviceusage.v1beta1.QuotaBucket.Builder>
        getQuotaBucketsBuilderList() {
      return getQuotaBucketsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.serviceusage.v1beta1.QuotaBucket,
            com.google.api.serviceusage.v1beta1.QuotaBucket.Builder,
            com.google.api.serviceusage.v1beta1.QuotaBucketOrBuilder>
        getQuotaBucketsFieldBuilder() {
      if (quotaBucketsBuilder_ == null) {
        quotaBucketsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.serviceusage.v1beta1.QuotaBucket,
                com.google.api.serviceusage.v1beta1.QuotaBucket.Builder,
                com.google.api.serviceusage.v1beta1.QuotaBucketOrBuilder>(
                quotaBuckets_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        quotaBuckets_ = null;
      }
      return quotaBucketsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.serviceusage.v1beta1.ConsumerQuotaLimit)
  }

  // @@protoc_insertion_point(class_scope:google.api.serviceusage.v1beta1.ConsumerQuotaLimit)
  private static final com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit();
  }

  public static com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConsumerQuotaLimit> PARSER =
      new com.google.protobuf.AbstractParser<ConsumerQuotaLimit>() {
        @java.lang.Override
        public ConsumerQuotaLimit parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConsumerQuotaLimit> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConsumerQuotaLimit> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.ConsumerQuotaLimit getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
