/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/serviceusage/v1beta1/resources.proto

package com.google.api.serviceusage.v1beta1;

/**
 *
 *
 * <pre>
 * Quota policy created by quota administrator.
 * </pre>
 *
 * Protobuf type {@code google.api.serviceusage.v1beta1.AdminQuotaPolicy}
 */
public final class AdminQuotaPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.serviceusage.v1beta1.AdminQuotaPolicy)
    AdminQuotaPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AdminQuotaPolicy.newBuilder() to construct.
  private AdminQuotaPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AdminQuotaPolicy() {
    name_ = "";
    metric_ = "";
    unit_ = "";
    container_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AdminQuotaPolicy();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.serviceusage.v1beta1.ResourcesProto
        .internal_static_google_api_serviceusage_v1beta1_AdminQuotaPolicy_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetDimensions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.serviceusage.v1beta1.ResourcesProto
        .internal_static_google_api_serviceusage_v1beta1_AdminQuotaPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.serviceusage.v1beta1.AdminQuotaPolicy.class,
            com.google.api.serviceusage.v1beta1.AdminQuotaPolicy.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the policy.
   * This name is generated by the server when the policy is created.
   * Example names would be:
   * `organizations/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminQuotaPolicies/4a3f2c1d`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the policy.
   * This name is generated by the server when the policy is created.
   * Example names would be:
   * `organizations/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminQuotaPolicies/4a3f2c1d`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POLICY_VALUE_FIELD_NUMBER = 2;
  private long policyValue_;
  /**
   *
   *
   * <pre>
   * The quota policy value.
   * Can be any nonnegative integer, or -1 (unlimited quota).
   * </pre>
   *
   * <code>int64 policy_value = 2;</code>
   *
   * @return The policyValue.
   */
  @java.lang.Override
  public long getPolicyValue() {
    return policyValue_;
  }

  public static final int DIMENSIONS_FIELD_NUMBER = 3;

  private static final class DimensionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.api.serviceusage.v1beta1.ResourcesProto
                .internal_static_google_api_serviceusage_v1beta1_AdminQuotaPolicy_DimensionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> dimensions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetDimensions() {
    if (dimensions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(DimensionsDefaultEntryHolder.defaultEntry);
    }
    return dimensions_;
  }

  public int getDimensionsCount() {
    return internalGetDimensions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * If this map is nonempty, then this policy applies only to specific values
   * for dimensions defined in the limit unit.
   * For example, an policy on a limit with the unit `1/{project}/{region}`
   * could contain an entry with the key `region` and the value `us-east-1`;
   * the policy is only applied to quota consumed in that region.
   * This map has the following restrictions:
   * *   If `region` appears as a key, its value must be a valid Cloud region.
   * *   If `zone` appears as a key, its value must be a valid Cloud zone.
   * *   Keys other than `region` or `zone` are not valid.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 3;</code>
   */
  @java.lang.Override
  public boolean containsDimensions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDimensions().getMap().containsKey(key);
  }
  /** Use {@link #getDimensionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDimensions() {
    return getDimensionsMap();
  }
  /**
   *
   *
   * <pre>
   * If this map is nonempty, then this policy applies only to specific values
   * for dimensions defined in the limit unit.
   * For example, an policy on a limit with the unit `1/{project}/{region}`
   * could contain an entry with the key `region` and the value `us-east-1`;
   * the policy is only applied to quota consumed in that region.
   * This map has the following restrictions:
   * *   If `region` appears as a key, its value must be a valid Cloud region.
   * *   If `zone` appears as a key, its value must be a valid Cloud zone.
   * *   Keys other than `region` or `zone` are not valid.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
    return internalGetDimensions().getMap();
  }
  /**
   *
   *
   * <pre>
   * If this map is nonempty, then this policy applies only to specific values
   * for dimensions defined in the limit unit.
   * For example, an policy on a limit with the unit `1/{project}/{region}`
   * could contain an entry with the key `region` and the value `us-east-1`;
   * the policy is only applied to quota consumed in that region.
   * This map has the following restrictions:
   * *   If `region` appears as a key, its value must be a valid Cloud region.
   * *   If `zone` appears as a key, its value must be a valid Cloud zone.
   * *   Keys other than `region` or `zone` are not valid.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getDimensionsOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * If this map is nonempty, then this policy applies only to specific values
   * for dimensions defined in the limit unit.
   * For example, an policy on a limit with the unit `1/{project}/{region}`
   * could contain an entry with the key `region` and the value `us-east-1`;
   * the policy is only applied to quota consumed in that region.
   * This map has the following restrictions:
   * *   If `region` appears as a key, its value must be a valid Cloud region.
   * *   If `zone` appears as a key, its value must be a valid Cloud zone.
   * *   Keys other than `region` or `zone` are not valid.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getDimensionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int METRIC_FIELD_NUMBER = 4;
  private volatile java.lang.Object metric_;
  /**
   *
   *
   * <pre>
   * The name of the metric to which this policy applies.
   * An example name would be:
   * `compute.googleapis.com/cpus`
   * </pre>
   *
   * <code>string metric = 4;</code>
   *
   * @return The metric.
   */
  @java.lang.Override
  public java.lang.String getMetric() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metric_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the metric to which this policy applies.
   * An example name would be:
   * `compute.googleapis.com/cpus`
   * </pre>
   *
   * <code>string metric = 4;</code>
   *
   * @return The bytes for metric.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricBytes() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metric_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNIT_FIELD_NUMBER = 5;
  private volatile java.lang.Object unit_;
  /**
   *
   *
   * <pre>
   * The limit unit of the limit to which this policy applies.
   * An example unit would be:
   * `1/{project}/{region}`
   * Note that `{project}` and `{region}` are not placeholders in this example;
   * the literal characters `{` and `}` occur in the string.
   * </pre>
   *
   * <code>string unit = 5;</code>
   *
   * @return The unit.
   */
  @java.lang.Override
  public java.lang.String getUnit() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      unit_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The limit unit of the limit to which this policy applies.
   * An example unit would be:
   * `1/{project}/{region}`
   * Note that `{project}` and `{region}` are not placeholders in this example;
   * the literal characters `{` and `}` occur in the string.
   * </pre>
   *
   * <code>string unit = 5;</code>
   *
   * @return The bytes for unit.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUnitBytes() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      unit_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTAINER_FIELD_NUMBER = 6;
  private volatile java.lang.Object container_;
  /**
   *
   *
   * <pre>
   * The cloud resource container at which the quota policy is created. The
   * format is `{container_type}/{container_number}`
   * </pre>
   *
   * <code>string container = 6;</code>
   *
   * @return The container.
   */
  @java.lang.Override
  public java.lang.String getContainer() {
    java.lang.Object ref = container_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      container_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The cloud resource container at which the quota policy is created. The
   * format is `{container_type}/{container_number}`
   * </pre>
   *
   * <code>string container = 6;</code>
   *
   * @return The bytes for container.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContainerBytes() {
    java.lang.Object ref = container_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      container_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (policyValue_ != 0L) {
      output.writeInt64(2, policyValue_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDimensions(), DimensionsDefaultEntryHolder.defaultEntry, 3);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, metric_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, unit_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(container_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, container_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (policyValue_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, policyValue_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDimensions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dimensions__ =
          DimensionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, dimensions__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, metric_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(unit_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, unit_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(container_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, container_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.serviceusage.v1beta1.AdminQuotaPolicy)) {
      return super.equals(obj);
    }
    com.google.api.serviceusage.v1beta1.AdminQuotaPolicy other =
        (com.google.api.serviceusage.v1beta1.AdminQuotaPolicy) obj;

    if (!getName().equals(other.getName())) return false;
    if (getPolicyValue() != other.getPolicyValue()) return false;
    if (!internalGetDimensions().equals(other.internalGetDimensions())) return false;
    if (!getMetric().equals(other.getMetric())) return false;
    if (!getUnit().equals(other.getUnit())) return false;
    if (!getContainer().equals(other.getContainer())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + POLICY_VALUE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPolicyValue());
    if (!internalGetDimensions().getMap().isEmpty()) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDimensions().hashCode();
    }
    hash = (37 * hash) + METRIC_FIELD_NUMBER;
    hash = (53 * hash) + getMetric().hashCode();
    hash = (37 * hash) + UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getUnit().hashCode();
    hash = (37 * hash) + CONTAINER_FIELD_NUMBER;
    hash = (53 * hash) + getContainer().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.serviceusage.v1beta1.AdminQuotaPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Quota policy created by quota administrator.
   * </pre>
   *
   * Protobuf type {@code google.api.serviceusage.v1beta1.AdminQuotaPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.serviceusage.v1beta1.AdminQuotaPolicy)
      com.google.api.serviceusage.v1beta1.AdminQuotaPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_AdminQuotaPolicy_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetDimensions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableDimensions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_AdminQuotaPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.serviceusage.v1beta1.AdminQuotaPolicy.class,
              com.google.api.serviceusage.v1beta1.AdminQuotaPolicy.Builder.class);
    }

    // Construct using com.google.api.serviceusage.v1beta1.AdminQuotaPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      policyValue_ = 0L;

      internalGetMutableDimensions().clear();
      metric_ = "";

      unit_ = "";

      container_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.serviceusage.v1beta1.ResourcesProto
          .internal_static_google_api_serviceusage_v1beta1_AdminQuotaPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.AdminQuotaPolicy getDefaultInstanceForType() {
      return com.google.api.serviceusage.v1beta1.AdminQuotaPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.AdminQuotaPolicy build() {
      com.google.api.serviceusage.v1beta1.AdminQuotaPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.serviceusage.v1beta1.AdminQuotaPolicy buildPartial() {
      com.google.api.serviceusage.v1beta1.AdminQuotaPolicy result =
          new com.google.api.serviceusage.v1beta1.AdminQuotaPolicy(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.policyValue_ = policyValue_;
      result.dimensions_ = internalGetDimensions();
      result.dimensions_.makeImmutable();
      result.metric_ = metric_;
      result.unit_ = unit_;
      result.container_ = container_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.serviceusage.v1beta1.AdminQuotaPolicy) {
        return mergeFrom((com.google.api.serviceusage.v1beta1.AdminQuotaPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.serviceusage.v1beta1.AdminQuotaPolicy other) {
      if (other == com.google.api.serviceusage.v1beta1.AdminQuotaPolicy.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.getPolicyValue() != 0L) {
        setPolicyValue(other.getPolicyValue());
      }
      internalGetMutableDimensions().mergeFrom(other.internalGetDimensions());
      if (!other.getMetric().isEmpty()) {
        metric_ = other.metric_;
        onChanged();
      }
      if (!other.getUnit().isEmpty()) {
        unit_ = other.unit_;
        onChanged();
      }
      if (!other.getContainer().isEmpty()) {
        container_ = other.container_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                policyValue_ = input.readInt64();

                break;
              } // case 16
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dimensions__ =
                    input.readMessage(
                        DimensionsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableDimensions()
                    .getMutableMap()
                    .put(dimensions__.getKey(), dimensions__.getValue());
                break;
              } // case 26
            case 34:
              {
                metric_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                unit_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                container_ = input.readStringRequireUtf8();

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the policy.
     * This name is generated by the server when the policy is created.
     * Example names would be:
     * `organizations/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminQuotaPolicies/4a3f2c1d`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the policy.
     * This name is generated by the server when the policy is created.
     * Example names would be:
     * `organizations/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminQuotaPolicies/4a3f2c1d`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the policy.
     * This name is generated by the server when the policy is created.
     * Example names would be:
     * `organizations/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminQuotaPolicies/4a3f2c1d`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the policy.
     * This name is generated by the server when the policy is created.
     * Example names would be:
     * `organizations/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminQuotaPolicies/4a3f2c1d`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the policy.
     * This name is generated by the server when the policy is created.
     * Example names would be:
     * `organizations/123/services/compute.googleapis.com/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/adminQuotaPolicies/4a3f2c1d`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private long policyValue_;
    /**
     *
     *
     * <pre>
     * The quota policy value.
     * Can be any nonnegative integer, or -1 (unlimited quota).
     * </pre>
     *
     * <code>int64 policy_value = 2;</code>
     *
     * @return The policyValue.
     */
    @java.lang.Override
    public long getPolicyValue() {
      return policyValue_;
    }
    /**
     *
     *
     * <pre>
     * The quota policy value.
     * Can be any nonnegative integer, or -1 (unlimited quota).
     * </pre>
     *
     * <code>int64 policy_value = 2;</code>
     *
     * @param value The policyValue to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyValue(long value) {

      policyValue_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The quota policy value.
     * Can be any nonnegative integer, or -1 (unlimited quota).
     * </pre>
     *
     * <code>int64 policy_value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolicyValue() {

      policyValue_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> dimensions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetDimensions() {
      if (dimensions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DimensionsDefaultEntryHolder.defaultEntry);
      }
      return dimensions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDimensions() {
      onChanged();
      ;
      if (dimensions_ == null) {
        dimensions_ =
            com.google.protobuf.MapField.newMapField(DimensionsDefaultEntryHolder.defaultEntry);
      }
      if (!dimensions_.isMutable()) {
        dimensions_ = dimensions_.copy();
      }
      return dimensions_;
    }

    public int getDimensionsCount() {
      return internalGetDimensions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this policy applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an policy on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the policy is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   Keys other than `region` or `zone` are not valid.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    @java.lang.Override
    public boolean containsDimensions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDimensions().getMap().containsKey(key);
    }
    /** Use {@link #getDimensionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDimensions() {
      return getDimensionsMap();
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this policy applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an policy on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the policy is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   Keys other than `region` or `zone` are not valid.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
      return internalGetDimensions().getMap();
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this policy applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an policy on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the policy is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   Keys other than `region` or `zone` are not valid.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getDimensionsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this policy applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an policy on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the policy is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   Keys other than `region` or `zone` are not valid.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getDimensionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDimensions() {
      internalGetMutableDimensions().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this policy applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an policy on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the policy is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   Keys other than `region` or `zone` are not valid.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    public Builder removeDimensions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDimensions().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDimensions() {
      return internalGetMutableDimensions().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this policy applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an policy on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the policy is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   Keys other than `region` or `zone` are not valid.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    public Builder putDimensions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableDimensions().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this map is nonempty, then this policy applies only to specific values
     * for dimensions defined in the limit unit.
     * For example, an policy on a limit with the unit `1/{project}/{region}`
     * could contain an entry with the key `region` and the value `us-east-1`;
     * the policy is only applied to quota consumed in that region.
     * This map has the following restrictions:
     * *   If `region` appears as a key, its value must be a valid Cloud region.
     * *   If `zone` appears as a key, its value must be a valid Cloud zone.
     * *   Keys other than `region` or `zone` are not valid.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 3;</code>
     */
    public Builder putAllDimensions(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDimensions().getMutableMap().putAll(values);
      return this;
    }

    private java.lang.Object metric_ = "";
    /**
     *
     *
     * <pre>
     * The name of the metric to which this policy applies.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @return The metric.
     */
    public java.lang.String getMetric() {
      java.lang.Object ref = metric_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metric_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the metric to which this policy applies.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @return The bytes for metric.
     */
    public com.google.protobuf.ByteString getMetricBytes() {
      java.lang.Object ref = metric_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metric_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the metric to which this policy applies.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @param value The metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetric(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      metric_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the metric to which this policy applies.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetric() {

      metric_ = getDefaultInstance().getMetric();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the metric to which this policy applies.
     * An example name would be:
     * `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 4;</code>
     *
     * @param value The bytes for metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetricBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      metric_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object unit_ = "";
    /**
     *
     *
     * <pre>
     * The limit unit of the limit to which this policy applies.
     * An example unit would be:
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return The unit.
     */
    public java.lang.String getUnit() {
      java.lang.Object ref = unit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        unit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The limit unit of the limit to which this policy applies.
     * An example unit would be:
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return The bytes for unit.
     */
    public com.google.protobuf.ByteString getUnitBytes() {
      java.lang.Object ref = unit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        unit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The limit unit of the limit to which this policy applies.
     * An example unit would be:
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @param value The unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnit(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      unit_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The limit unit of the limit to which this policy applies.
     * An example unit would be:
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnit() {

      unit_ = getDefaultInstance().getUnit();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The limit unit of the limit to which this policy applies.
     * An example unit would be:
     * `1/{project}/{region}`
     * Note that `{project}` and `{region}` are not placeholders in this example;
     * the literal characters `{` and `}` occur in the string.
     * </pre>
     *
     * <code>string unit = 5;</code>
     *
     * @param value The bytes for unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnitBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      unit_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object container_ = "";
    /**
     *
     *
     * <pre>
     * The cloud resource container at which the quota policy is created. The
     * format is `{container_type}/{container_number}`
     * </pre>
     *
     * <code>string container = 6;</code>
     *
     * @return The container.
     */
    public java.lang.String getContainer() {
      java.lang.Object ref = container_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        container_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The cloud resource container at which the quota policy is created. The
     * format is `{container_type}/{container_number}`
     * </pre>
     *
     * <code>string container = 6;</code>
     *
     * @return The bytes for container.
     */
    public com.google.protobuf.ByteString getContainerBytes() {
      java.lang.Object ref = container_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        container_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The cloud resource container at which the quota policy is created. The
     * format is `{container_type}/{container_number}`
     * </pre>
     *
     * <code>string container = 6;</code>
     *
     * @param value The container to set.
     * @return This builder for chaining.
     */
    public Builder setContainer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      container_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The cloud resource container at which the quota policy is created. The
     * format is `{container_type}/{container_number}`
     * </pre>
     *
     * <code>string container = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContainer() {

      container_ = getDefaultInstance().getContainer();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The cloud resource container at which the quota policy is created. The
     * format is `{container_type}/{container_number}`
     * </pre>
     *
     * <code>string container = 6;</code>
     *
     * @param value The bytes for container to set.
     * @return This builder for chaining.
     */
    public Builder setContainerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      container_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.serviceusage.v1beta1.AdminQuotaPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.api.serviceusage.v1beta1.AdminQuotaPolicy)
  private static final com.google.api.serviceusage.v1beta1.AdminQuotaPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.serviceusage.v1beta1.AdminQuotaPolicy();
  }

  public static com.google.api.serviceusage.v1beta1.AdminQuotaPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdminQuotaPolicy> PARSER =
      new com.google.protobuf.AbstractParser<AdminQuotaPolicy>() {
        @java.lang.Override
        public AdminQuotaPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AdminQuotaPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdminQuotaPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.serviceusage.v1beta1.AdminQuotaPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
