/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/policytroubleshooter/v1/explanations.proto

package google.cloud.policytroubleshooter.v1;

public final class Explanations {
  private Explanations() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   *
   *
   * <pre>
   * Whether a member has a permission for a resource.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.policytroubleshooter.v1.AccessState}
   */
  public enum AccessState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Reserved for future use.
     * </pre>
     *
     * <code>ACCESS_STATE_UNSPECIFIED = 0;</code>
     */
    ACCESS_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The member has the permission.
     * </pre>
     *
     * <code>GRANTED = 1;</code>
     */
    GRANTED(1),
    /**
     *
     *
     * <pre>
     * The member does not have the permission.
     * </pre>
     *
     * <code>NOT_GRANTED = 2;</code>
     */
    NOT_GRANTED(2),
    /**
     *
     *
     * <pre>
     * The member has the permission only if a condition expression evaluates to
     * `true`.
     * </pre>
     *
     * <code>UNKNOWN_CONDITIONAL = 3;</code>
     */
    UNKNOWN_CONDITIONAL(3),
    /**
     *
     *
     * <pre>
     * The sender of the request does not have access to all of the policies that
     * Policy Troubleshooter needs to evaluate.
     * </pre>
     *
     * <code>UNKNOWN_INFO_DENIED = 4;</code>
     */
    UNKNOWN_INFO_DENIED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Reserved for future use.
     * </pre>
     *
     * <code>ACCESS_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int ACCESS_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The member has the permission.
     * </pre>
     *
     * <code>GRANTED = 1;</code>
     */
    public static final int GRANTED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The member does not have the permission.
     * </pre>
     *
     * <code>NOT_GRANTED = 2;</code>
     */
    public static final int NOT_GRANTED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The member has the permission only if a condition expression evaluates to
     * `true`.
     * </pre>
     *
     * <code>UNKNOWN_CONDITIONAL = 3;</code>
     */
    public static final int UNKNOWN_CONDITIONAL_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The sender of the request does not have access to all of the policies that
     * Policy Troubleshooter needs to evaluate.
     * </pre>
     *
     * <code>UNKNOWN_INFO_DENIED = 4;</code>
     */
    public static final int UNKNOWN_INFO_DENIED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AccessState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AccessState forNumber(int value) {
      switch (value) {
        case 0:
          return ACCESS_STATE_UNSPECIFIED;
        case 1:
          return GRANTED;
        case 2:
          return NOT_GRANTED;
        case 3:
          return UNKNOWN_CONDITIONAL;
        case 4:
          return UNKNOWN_INFO_DENIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AccessState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AccessState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<AccessState>() {
          public AccessState findValueByNumber(int number) {
            return AccessState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return google.cloud.policytroubleshooter.v1.Explanations.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final AccessState[] VALUES = values();

    public static AccessState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AccessState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.policytroubleshooter.v1.AccessState)
  }

  /**
   *
   *
   * <pre>
   * The extent to which a single data point contributes to an overall
   * determination.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.policytroubleshooter.v1.HeuristicRelevance}
   */
  public enum HeuristicRelevance implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Reserved for future use.
     * </pre>
     *
     * <code>HEURISTIC_RELEVANCE_UNSPECIFIED = 0;</code>
     */
    HEURISTIC_RELEVANCE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The data point has a limited effect on the result. Changing the data point
     * is unlikely to affect the overall determination.
     * </pre>
     *
     * <code>NORMAL = 1;</code>
     */
    NORMAL(1),
    /**
     *
     *
     * <pre>
     * The data point has a strong effect on the result. Changing the data point
     * is likely to affect the overall determination.
     * </pre>
     *
     * <code>HIGH = 2;</code>
     */
    HIGH(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Reserved for future use.
     * </pre>
     *
     * <code>HEURISTIC_RELEVANCE_UNSPECIFIED = 0;</code>
     */
    public static final int HEURISTIC_RELEVANCE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The data point has a limited effect on the result. Changing the data point
     * is unlikely to affect the overall determination.
     * </pre>
     *
     * <code>NORMAL = 1;</code>
     */
    public static final int NORMAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The data point has a strong effect on the result. Changing the data point
     * is likely to affect the overall determination.
     * </pre>
     *
     * <code>HIGH = 2;</code>
     */
    public static final int HIGH_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HeuristicRelevance valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static HeuristicRelevance forNumber(int value) {
      switch (value) {
        case 0:
          return HEURISTIC_RELEVANCE_UNSPECIFIED;
        case 1:
          return NORMAL;
        case 2:
          return HIGH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<HeuristicRelevance>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<HeuristicRelevance>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<HeuristicRelevance>() {
              public HeuristicRelevance findValueByNumber(int number) {
                return HeuristicRelevance.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return google.cloud.policytroubleshooter.v1.Explanations.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final HeuristicRelevance[] VALUES = values();

    public static HeuristicRelevance valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private HeuristicRelevance(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.policytroubleshooter.v1.HeuristicRelevance)
  }

  public interface AccessTupleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.policytroubleshooter.v1.AccessTuple)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The member, or principal, whose access you want to check, in the form of
     * the email address that represents that member. For example,
     * `alice&#64;example.com` or
     * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
     * The member must be a Google Account or a service account. Other types of
     * members are not supported.
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The principal.
     */
    java.lang.String getPrincipal();
    /**
     *
     *
     * <pre>
     * Required. The member, or principal, whose access you want to check, in the form of
     * the email address that represents that member. For example,
     * `alice&#64;example.com` or
     * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
     * The member must be a Google Account or a service account. Other types of
     * members are not supported.
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for principal.
     */
    com.google.protobuf.ByteString getPrincipalBytes();

    /**
     *
     *
     * <pre>
     * Required. The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The fullResourceName.
     */
    java.lang.String getFullResourceName();
    /**
     *
     *
     * <pre>
     * Required. The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for fullResourceName.
     */
    com.google.protobuf.ByteString getFullResourceNameBytes();

    /**
     *
     *
     * <pre>
     * Required. The IAM permission to check for the specified member and resource.
     * For a complete list of IAM permissions, see
     * https://cloud.google.com/iam/help/permissions/reference.
     * For a complete list of predefined IAM roles and the permissions in each
     * role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The permission.
     */
    java.lang.String getPermission();
    /**
     *
     *
     * <pre>
     * Required. The IAM permission to check for the specified member and resource.
     * For a complete list of IAM permissions, see
     * https://cloud.google.com/iam/help/permissions/reference.
     * For a complete list of predefined IAM roles and the permissions in each
     * role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for permission.
     */
    com.google.protobuf.ByteString getPermissionBytes();
  }
  /**
   *
   *
   * <pre>
   * Information about the member, resource, and permission to check.
   * </pre>
   *
   * Protobuf type {@code google.cloud.policytroubleshooter.v1.AccessTuple}
   */
  public static final class AccessTuple extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.policytroubleshooter.v1.AccessTuple)
      AccessTupleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AccessTuple.newBuilder() to construct.
    private AccessTuple(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AccessTuple() {
      principal_ = "";
      fullResourceName_ = "";
      permission_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AccessTuple();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return google.cloud.policytroubleshooter.v1.Explanations
          .internal_static_google_cloud_policytroubleshooter_v1_AccessTuple_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return google.cloud.policytroubleshooter.v1.Explanations
          .internal_static_google_cloud_policytroubleshooter_v1_AccessTuple_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              google.cloud.policytroubleshooter.v1.Explanations.AccessTuple.class,
              google.cloud.policytroubleshooter.v1.Explanations.AccessTuple.Builder.class);
    }

    public static final int PRINCIPAL_FIELD_NUMBER = 1;
    private volatile java.lang.Object principal_;
    /**
     *
     *
     * <pre>
     * Required. The member, or principal, whose access you want to check, in the form of
     * the email address that represents that member. For example,
     * `alice&#64;example.com` or
     * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
     * The member must be a Google Account or a service account. Other types of
     * members are not supported.
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The principal.
     */
    @java.lang.Override
    public java.lang.String getPrincipal() {
      java.lang.Object ref = principal_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        principal_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The member, or principal, whose access you want to check, in the form of
     * the email address that represents that member. For example,
     * `alice&#64;example.com` or
     * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
     * The member must be a Google Account or a service account. Other types of
     * members are not supported.
     * </pre>
     *
     * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for principal.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrincipalBytes() {
      java.lang.Object ref = principal_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        principal_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FULL_RESOURCE_NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object fullResourceName_;
    /**
     *
     *
     * <pre>
     * Required. The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The fullResourceName.
     */
    @java.lang.Override
    public java.lang.String getFullResourceName() {
      java.lang.Object ref = fullResourceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fullResourceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for fullResourceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFullResourceNameBytes() {
      java.lang.Object ref = fullResourceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fullResourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PERMISSION_FIELD_NUMBER = 3;
    private volatile java.lang.Object permission_;
    /**
     *
     *
     * <pre>
     * Required. The IAM permission to check for the specified member and resource.
     * For a complete list of IAM permissions, see
     * https://cloud.google.com/iam/help/permissions/reference.
     * For a complete list of predefined IAM roles and the permissions in each
     * role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The permission.
     */
    @java.lang.Override
    public java.lang.String getPermission() {
      java.lang.Object ref = permission_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        permission_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The IAM permission to check for the specified member and resource.
     * For a complete list of IAM permissions, see
     * https://cloud.google.com/iam/help/permissions/reference.
     * For a complete list of predefined IAM roles and the permissions in each
     * role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for permission.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPermissionBytes() {
      java.lang.Object ref = permission_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        permission_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principal_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, principal_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullResourceName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fullResourceName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(permission_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, permission_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principal_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, principal_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullResourceName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fullResourceName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(permission_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, permission_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof google.cloud.policytroubleshooter.v1.Explanations.AccessTuple)) {
        return super.equals(obj);
      }
      google.cloud.policytroubleshooter.v1.Explanations.AccessTuple other =
          (google.cloud.policytroubleshooter.v1.Explanations.AccessTuple) obj;

      if (!getPrincipal().equals(other.getPrincipal())) return false;
      if (!getFullResourceName().equals(other.getFullResourceName())) return false;
      if (!getPermission().equals(other.getPermission())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PRINCIPAL_FIELD_NUMBER;
      hash = (53 * hash) + getPrincipal().hashCode();
      hash = (37 * hash) + FULL_RESOURCE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFullResourceName().hashCode();
      hash = (37 * hash) + PERMISSION_FIELD_NUMBER;
      hash = (53 * hash) + getPermission().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        google.cloud.policytroubleshooter.v1.Explanations.AccessTuple prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information about the member, resource, and permission to check.
     * </pre>
     *
     * Protobuf type {@code google.cloud.policytroubleshooter.v1.AccessTuple}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.policytroubleshooter.v1.AccessTuple)
        google.cloud.policytroubleshooter.v1.Explanations.AccessTupleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return google.cloud.policytroubleshooter.v1.Explanations
            .internal_static_google_cloud_policytroubleshooter_v1_AccessTuple_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return google.cloud.policytroubleshooter.v1.Explanations
            .internal_static_google_cloud_policytroubleshooter_v1_AccessTuple_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                google.cloud.policytroubleshooter.v1.Explanations.AccessTuple.class,
                google.cloud.policytroubleshooter.v1.Explanations.AccessTuple.Builder.class);
      }

      // Construct using google.cloud.policytroubleshooter.v1.Explanations.AccessTuple.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        principal_ = "";

        fullResourceName_ = "";

        permission_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return google.cloud.policytroubleshooter.v1.Explanations
            .internal_static_google_cloud_policytroubleshooter_v1_AccessTuple_descriptor;
      }

      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.AccessTuple
          getDefaultInstanceForType() {
        return google.cloud.policytroubleshooter.v1.Explanations.AccessTuple.getDefaultInstance();
      }

      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.AccessTuple build() {
        google.cloud.policytroubleshooter.v1.Explanations.AccessTuple result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.AccessTuple buildPartial() {
        google.cloud.policytroubleshooter.v1.Explanations.AccessTuple result =
            new google.cloud.policytroubleshooter.v1.Explanations.AccessTuple(this);
        result.principal_ = principal_;
        result.fullResourceName_ = fullResourceName_;
        result.permission_ = permission_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof google.cloud.policytroubleshooter.v1.Explanations.AccessTuple) {
          return mergeFrom((google.cloud.policytroubleshooter.v1.Explanations.AccessTuple) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          google.cloud.policytroubleshooter.v1.Explanations.AccessTuple other) {
        if (other
            == google.cloud.policytroubleshooter.v1.Explanations.AccessTuple.getDefaultInstance())
          return this;
        if (!other.getPrincipal().isEmpty()) {
          principal_ = other.principal_;
          onChanged();
        }
        if (!other.getFullResourceName().isEmpty()) {
          fullResourceName_ = other.fullResourceName_;
          onChanged();
        }
        if (!other.getPermission().isEmpty()) {
          permission_ = other.permission_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  principal_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  fullResourceName_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 26:
                {
                  permission_ = input.readStringRequireUtf8();

                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object principal_ = "";
      /**
       *
       *
       * <pre>
       * Required. The member, or principal, whose access you want to check, in the form of
       * the email address that represents that member. For example,
       * `alice&#64;example.com` or
       * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
       * The member must be a Google Account or a service account. Other types of
       * members are not supported.
       * </pre>
       *
       * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The principal.
       */
      public java.lang.String getPrincipal() {
        java.lang.Object ref = principal_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          principal_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The member, or principal, whose access you want to check, in the form of
       * the email address that represents that member. For example,
       * `alice&#64;example.com` or
       * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
       * The member must be a Google Account or a service account. Other types of
       * members are not supported.
       * </pre>
       *
       * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for principal.
       */
      public com.google.protobuf.ByteString getPrincipalBytes() {
        java.lang.Object ref = principal_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          principal_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The member, or principal, whose access you want to check, in the form of
       * the email address that represents that member. For example,
       * `alice&#64;example.com` or
       * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
       * The member must be a Google Account or a service account. Other types of
       * members are not supported.
       * </pre>
       *
       * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The principal to set.
       * @return This builder for chaining.
       */
      public Builder setPrincipal(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        principal_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The member, or principal, whose access you want to check, in the form of
       * the email address that represents that member. For example,
       * `alice&#64;example.com` or
       * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
       * The member must be a Google Account or a service account. Other types of
       * members are not supported.
       * </pre>
       *
       * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrincipal() {

        principal_ = getDefaultInstance().getPrincipal();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The member, or principal, whose access you want to check, in the form of
       * the email address that represents that member. For example,
       * `alice&#64;example.com` or
       * `my-service-account&#64;my-project.iam.gserviceaccount.com`.
       * The member must be a Google Account or a service account. Other types of
       * members are not supported.
       * </pre>
       *
       * <code>string principal = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for principal to set.
       * @return This builder for chaining.
       */
      public Builder setPrincipalBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        principal_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object fullResourceName_ = "";
      /**
       *
       *
       * <pre>
       * Required. The full resource name that identifies the resource. For example,
       * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
       * For examples of full resource names for Google Cloud services, see
       * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
       * </pre>
       *
       * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The fullResourceName.
       */
      public java.lang.String getFullResourceName() {
        java.lang.Object ref = fullResourceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fullResourceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The full resource name that identifies the resource. For example,
       * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
       * For examples of full resource names for Google Cloud services, see
       * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
       * </pre>
       *
       * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for fullResourceName.
       */
      public com.google.protobuf.ByteString getFullResourceNameBytes() {
        java.lang.Object ref = fullResourceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fullResourceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The full resource name that identifies the resource. For example,
       * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
       * For examples of full resource names for Google Cloud services, see
       * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
       * </pre>
       *
       * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The fullResourceName to set.
       * @return This builder for chaining.
       */
      public Builder setFullResourceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        fullResourceName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The full resource name that identifies the resource. For example,
       * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
       * For examples of full resource names for Google Cloud services, see
       * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
       * </pre>
       *
       * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFullResourceName() {

        fullResourceName_ = getDefaultInstance().getFullResourceName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The full resource name that identifies the resource. For example,
       * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
       * For examples of full resource names for Google Cloud services, see
       * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
       * </pre>
       *
       * <code>string full_resource_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for fullResourceName to set.
       * @return This builder for chaining.
       */
      public Builder setFullResourceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        fullResourceName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object permission_ = "";
      /**
       *
       *
       * <pre>
       * Required. The IAM permission to check for the specified member and resource.
       * For a complete list of IAM permissions, see
       * https://cloud.google.com/iam/help/permissions/reference.
       * For a complete list of predefined IAM roles and the permissions in each
       * role, see https://cloud.google.com/iam/help/roles/reference.
       * </pre>
       *
       * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The permission.
       */
      public java.lang.String getPermission() {
        java.lang.Object ref = permission_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          permission_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The IAM permission to check for the specified member and resource.
       * For a complete list of IAM permissions, see
       * https://cloud.google.com/iam/help/permissions/reference.
       * For a complete list of predefined IAM roles and the permissions in each
       * role, see https://cloud.google.com/iam/help/roles/reference.
       * </pre>
       *
       * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for permission.
       */
      public com.google.protobuf.ByteString getPermissionBytes() {
        java.lang.Object ref = permission_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          permission_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The IAM permission to check for the specified member and resource.
       * For a complete list of IAM permissions, see
       * https://cloud.google.com/iam/help/permissions/reference.
       * For a complete list of predefined IAM roles and the permissions in each
       * role, see https://cloud.google.com/iam/help/roles/reference.
       * </pre>
       *
       * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The permission to set.
       * @return This builder for chaining.
       */
      public Builder setPermission(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        permission_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The IAM permission to check for the specified member and resource.
       * For a complete list of IAM permissions, see
       * https://cloud.google.com/iam/help/permissions/reference.
       * For a complete list of predefined IAM roles and the permissions in each
       * role, see https://cloud.google.com/iam/help/roles/reference.
       * </pre>
       *
       * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPermission() {

        permission_ = getDefaultInstance().getPermission();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The IAM permission to check for the specified member and resource.
       * For a complete list of IAM permissions, see
       * https://cloud.google.com/iam/help/permissions/reference.
       * For a complete list of predefined IAM roles and the permissions in each
       * role, see https://cloud.google.com/iam/help/roles/reference.
       * </pre>
       *
       * <code>string permission = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for permission to set.
       * @return This builder for chaining.
       */
      public Builder setPermissionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        permission_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.policytroubleshooter.v1.AccessTuple)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.policytroubleshooter.v1.AccessTuple)
    private static final google.cloud.policytroubleshooter.v1.Explanations.AccessTuple
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new google.cloud.policytroubleshooter.v1.Explanations.AccessTuple();
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.AccessTuple
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AccessTuple> PARSER =
        new com.google.protobuf.AbstractParser<AccessTuple>() {
          @java.lang.Override
          public AccessTuple parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AccessTuple> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AccessTuple> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.AccessTuple
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ExplainedPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.policytroubleshooter.v1.ExplainedPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Indicates whether _this policy_ provides the specified permission to the
     * specified member for the specified resource.
     * This field does _not_ indicate whether the member actually has the
     * permission for the resource. There might be another policy that overrides
     * this policy. To determine whether the member actually has the permission,
     * use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.AccessState access = 1;</code>
     *
     * @return The enum numeric value on the wire for access.
     */
    int getAccessValue();
    /**
     *
     *
     * <pre>
     * Indicates whether _this policy_ provides the specified permission to the
     * specified member for the specified resource.
     * This field does _not_ indicate whether the member actually has the
     * permission for the resource. There might be another policy that overrides
     * this policy. To determine whether the member actually has the permission,
     * use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.AccessState access = 1;</code>
     *
     * @return The access.
     */
    google.cloud.policytroubleshooter.v1.Explanations.AccessState getAccess();

    /**
     *
     *
     * <pre>
     * The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2;</code>
     *
     * @return The fullResourceName.
     */
    java.lang.String getFullResourceName();
    /**
     *
     *
     * <pre>
     * The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2;</code>
     *
     * @return The bytes for fullResourceName.
     */
    com.google.protobuf.ByteString getFullResourceNameBytes();

    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     * If the sender of the request does not have access to the policy, this field
     * is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     *
     * @return Whether the policy field is set.
     */
    boolean hasPolicy();
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     * If the sender of the request does not have access to the policy, this field
     * is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     *
     * @return The policy.
     */
    com.google.iam.v1.Policy getPolicy();
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     * If the sender of the request does not have access to the policy, this field
     * is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     */
    com.google.iam.v1.PolicyOrBuilder getPolicyOrBuilder();

    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the member's ability,
     * or inability, to use the permission for the resource.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    java.util.List<google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation>
        getBindingExplanationsList();
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the member's ability,
     * or inability, to use the permission for the resource.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation getBindingExplanations(
        int index);
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the member's ability,
     * or inability, to use the permission for the resource.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    int getBindingExplanationsCount();
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the member's ability,
     * or inability, to use the permission for the resource.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    java.util.List<
            ? extends google.cloud.policytroubleshooter.v1.Explanations.BindingExplanationOrBuilder>
        getBindingExplanationsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the member's ability,
     * or inability, to use the permission for the resource.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    google.cloud.policytroubleshooter.v1.Explanations.BindingExplanationOrBuilder
        getBindingExplanationsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * The relevance of this policy to the overall determination in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 5;</code>
     *
     * @return The enum numeric value on the wire for relevance.
     */
    int getRelevanceValue();
    /**
     *
     *
     * <pre>
     * The relevance of this policy to the overall determination in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 5;</code>
     *
     * @return The relevance.
     */
    google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance getRelevance();
  }
  /**
   *
   *
   * <pre>
   * Details about how a specific IAM [Policy][google.iam.v1.Policy] contributed
   * to the access check.
   * </pre>
   *
   * Protobuf type {@code google.cloud.policytroubleshooter.v1.ExplainedPolicy}
   */
  public static final class ExplainedPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.policytroubleshooter.v1.ExplainedPolicy)
      ExplainedPolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ExplainedPolicy.newBuilder() to construct.
    private ExplainedPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ExplainedPolicy() {
      access_ = 0;
      fullResourceName_ = "";
      bindingExplanations_ = java.util.Collections.emptyList();
      relevance_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ExplainedPolicy();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return google.cloud.policytroubleshooter.v1.Explanations
          .internal_static_google_cloud_policytroubleshooter_v1_ExplainedPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return google.cloud.policytroubleshooter.v1.Explanations
          .internal_static_google_cloud_policytroubleshooter_v1_ExplainedPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy.class,
              google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy.Builder.class);
    }

    public static final int ACCESS_FIELD_NUMBER = 1;
    private int access_;
    /**
     *
     *
     * <pre>
     * Indicates whether _this policy_ provides the specified permission to the
     * specified member for the specified resource.
     * This field does _not_ indicate whether the member actually has the
     * permission for the resource. There might be another policy that overrides
     * this policy. To determine whether the member actually has the permission,
     * use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.AccessState access = 1;</code>
     *
     * @return The enum numeric value on the wire for access.
     */
    @java.lang.Override
    public int getAccessValue() {
      return access_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether _this policy_ provides the specified permission to the
     * specified member for the specified resource.
     * This field does _not_ indicate whether the member actually has the
     * permission for the resource. There might be another policy that overrides
     * this policy. To determine whether the member actually has the permission,
     * use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.AccessState access = 1;</code>
     *
     * @return The access.
     */
    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.AccessState getAccess() {
      @SuppressWarnings("deprecation")
      google.cloud.policytroubleshooter.v1.Explanations.AccessState result =
          google.cloud.policytroubleshooter.v1.Explanations.AccessState.valueOf(access_);
      return result == null
          ? google.cloud.policytroubleshooter.v1.Explanations.AccessState.UNRECOGNIZED
          : result;
    }

    public static final int FULL_RESOURCE_NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object fullResourceName_;
    /**
     *
     *
     * <pre>
     * The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2;</code>
     *
     * @return The fullResourceName.
     */
    @java.lang.Override
    public java.lang.String getFullResourceName() {
      java.lang.Object ref = fullResourceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fullResourceName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The full resource name that identifies the resource. For example,
     * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * For examples of full resource names for Google Cloud services, see
     * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
     * </pre>
     *
     * <code>string full_resource_name = 2;</code>
     *
     * @return The bytes for fullResourceName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFullResourceNameBytes() {
      java.lang.Object ref = fullResourceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fullResourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int POLICY_FIELD_NUMBER = 3;
    private com.google.iam.v1.Policy policy_;
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     * If the sender of the request does not have access to the policy, this field
     * is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     *
     * @return Whether the policy field is set.
     */
    @java.lang.Override
    public boolean hasPolicy() {
      return policy_ != null;
    }
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     * If the sender of the request does not have access to the policy, this field
     * is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     *
     * @return The policy.
     */
    @java.lang.Override
    public com.google.iam.v1.Policy getPolicy() {
      return policy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : policy_;
    }
    /**
     *
     *
     * <pre>
     * The IAM policy attached to the resource.
     * If the sender of the request does not have access to the policy, this field
     * is empty.
     * </pre>
     *
     * <code>.google.iam.v1.Policy policy = 3;</code>
     */
    @java.lang.Override
    public com.google.iam.v1.PolicyOrBuilder getPolicyOrBuilder() {
      return getPolicy();
    }

    public static final int BINDING_EXPLANATIONS_FIELD_NUMBER = 4;
    private java.util.List<google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation>
        bindingExplanations_;
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the member's ability,
     * or inability, to use the permission for the resource.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation>
        getBindingExplanationsList() {
      return bindingExplanations_;
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the member's ability,
     * or inability, to use the permission for the resource.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends google.cloud.policytroubleshooter.v1.Explanations.BindingExplanationOrBuilder>
        getBindingExplanationsOrBuilderList() {
      return bindingExplanations_;
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the member's ability,
     * or inability, to use the permission for the resource.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    @java.lang.Override
    public int getBindingExplanationsCount() {
      return bindingExplanations_.size();
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the member's ability,
     * or inability, to use the permission for the resource.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
        getBindingExplanations(int index) {
      return bindingExplanations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Details about how each binding in the policy affects the member's ability,
     * or inability, to use the permission for the resource.
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
     * </code>
     */
    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanationOrBuilder
        getBindingExplanationsOrBuilder(int index) {
      return bindingExplanations_.get(index);
    }

    public static final int RELEVANCE_FIELD_NUMBER = 5;
    private int relevance_;
    /**
     *
     *
     * <pre>
     * The relevance of this policy to the overall determination in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 5;</code>
     *
     * @return The enum numeric value on the wire for relevance.
     */
    @java.lang.Override
    public int getRelevanceValue() {
      return relevance_;
    }
    /**
     *
     *
     * <pre>
     * The relevance of this policy to the overall determination in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * If the sender of the request does not have access to the policy, this field
     * is omitted.
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 5;</code>
     *
     * @return The relevance.
     */
    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance getRelevance() {
      @SuppressWarnings("deprecation")
      google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance result =
          google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.valueOf(relevance_);
      return result == null
          ? google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (access_
          != google.cloud.policytroubleshooter.v1.Explanations.AccessState.ACCESS_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, access_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullResourceName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fullResourceName_);
      }
      if (policy_ != null) {
        output.writeMessage(3, getPolicy());
      }
      for (int i = 0; i < bindingExplanations_.size(); i++) {
        output.writeMessage(4, bindingExplanations_.get(i));
      }
      if (relevance_
          != google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance
              .HEURISTIC_RELEVANCE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(5, relevance_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (access_
          != google.cloud.policytroubleshooter.v1.Explanations.AccessState.ACCESS_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, access_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullResourceName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fullResourceName_);
      }
      if (policy_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPolicy());
      }
      for (int i = 0; i < bindingExplanations_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, bindingExplanations_.get(i));
      }
      if (relevance_
          != google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance
              .HEURISTIC_RELEVANCE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, relevance_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy)) {
        return super.equals(obj);
      }
      google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy other =
          (google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy) obj;

      if (access_ != other.access_) return false;
      if (!getFullResourceName().equals(other.getFullResourceName())) return false;
      if (hasPolicy() != other.hasPolicy()) return false;
      if (hasPolicy()) {
        if (!getPolicy().equals(other.getPolicy())) return false;
      }
      if (!getBindingExplanationsList().equals(other.getBindingExplanationsList())) return false;
      if (relevance_ != other.relevance_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACCESS_FIELD_NUMBER;
      hash = (53 * hash) + access_;
      hash = (37 * hash) + FULL_RESOURCE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFullResourceName().hashCode();
      if (hasPolicy()) {
        hash = (37 * hash) + POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getPolicy().hashCode();
      }
      if (getBindingExplanationsCount() > 0) {
        hash = (37 * hash) + BINDING_EXPLANATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getBindingExplanationsList().hashCode();
      }
      hash = (37 * hash) + RELEVANCE_FIELD_NUMBER;
      hash = (53 * hash) + relevance_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details about how a specific IAM [Policy][google.iam.v1.Policy] contributed
     * to the access check.
     * </pre>
     *
     * Protobuf type {@code google.cloud.policytroubleshooter.v1.ExplainedPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.policytroubleshooter.v1.ExplainedPolicy)
        google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return google.cloud.policytroubleshooter.v1.Explanations
            .internal_static_google_cloud_policytroubleshooter_v1_ExplainedPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return google.cloud.policytroubleshooter.v1.Explanations
            .internal_static_google_cloud_policytroubleshooter_v1_ExplainedPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy.class,
                google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy.Builder.class);
      }

      // Construct using
      // google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        access_ = 0;

        fullResourceName_ = "";

        if (policyBuilder_ == null) {
          policy_ = null;
        } else {
          policy_ = null;
          policyBuilder_ = null;
        }
        if (bindingExplanationsBuilder_ == null) {
          bindingExplanations_ = java.util.Collections.emptyList();
        } else {
          bindingExplanations_ = null;
          bindingExplanationsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        relevance_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return google.cloud.policytroubleshooter.v1.Explanations
            .internal_static_google_cloud_policytroubleshooter_v1_ExplainedPolicy_descriptor;
      }

      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy
          getDefaultInstanceForType() {
        return google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy
            .getDefaultInstance();
      }

      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy build() {
        google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy buildPartial() {
        google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy result =
            new google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy(this);
        int from_bitField0_ = bitField0_;
        result.access_ = access_;
        result.fullResourceName_ = fullResourceName_;
        if (policyBuilder_ == null) {
          result.policy_ = policy_;
        } else {
          result.policy_ = policyBuilder_.build();
        }
        if (bindingExplanationsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            bindingExplanations_ = java.util.Collections.unmodifiableList(bindingExplanations_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.bindingExplanations_ = bindingExplanations_;
        } else {
          result.bindingExplanations_ = bindingExplanationsBuilder_.build();
        }
        result.relevance_ = relevance_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy) {
          return mergeFrom(
              (google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy other) {
        if (other
            == google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy
                .getDefaultInstance()) return this;
        if (other.access_ != 0) {
          setAccessValue(other.getAccessValue());
        }
        if (!other.getFullResourceName().isEmpty()) {
          fullResourceName_ = other.fullResourceName_;
          onChanged();
        }
        if (other.hasPolicy()) {
          mergePolicy(other.getPolicy());
        }
        if (bindingExplanationsBuilder_ == null) {
          if (!other.bindingExplanations_.isEmpty()) {
            if (bindingExplanations_.isEmpty()) {
              bindingExplanations_ = other.bindingExplanations_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureBindingExplanationsIsMutable();
              bindingExplanations_.addAll(other.bindingExplanations_);
            }
            onChanged();
          }
        } else {
          if (!other.bindingExplanations_.isEmpty()) {
            if (bindingExplanationsBuilder_.isEmpty()) {
              bindingExplanationsBuilder_.dispose();
              bindingExplanationsBuilder_ = null;
              bindingExplanations_ = other.bindingExplanations_;
              bitField0_ = (bitField0_ & ~0x00000001);
              bindingExplanationsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getBindingExplanationsFieldBuilder()
                      : null;
            } else {
              bindingExplanationsBuilder_.addAllMessages(other.bindingExplanations_);
            }
          }
        }
        if (other.relevance_ != 0) {
          setRelevanceValue(other.getRelevanceValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  access_ = input.readEnum();

                  break;
                } // case 8
              case 18:
                {
                  fullResourceName_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getPolicyFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              case 34:
                {
                  google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation m =
                      input.readMessage(
                          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                              .parser(),
                          extensionRegistry);
                  if (bindingExplanationsBuilder_ == null) {
                    ensureBindingExplanationsIsMutable();
                    bindingExplanations_.add(m);
                  } else {
                    bindingExplanationsBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              case 40:
                {
                  relevance_ = input.readEnum();

                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int access_ = 0;
      /**
       *
       *
       * <pre>
       * Indicates whether _this policy_ provides the specified permission to the
       * specified member for the specified resource.
       * This field does _not_ indicate whether the member actually has the
       * permission for the resource. There might be another policy that overrides
       * this policy. To determine whether the member actually has the permission,
       * use the `access` field in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.AccessState access = 1;</code>
       *
       * @return The enum numeric value on the wire for access.
       */
      @java.lang.Override
      public int getAccessValue() {
        return access_;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether _this policy_ provides the specified permission to the
       * specified member for the specified resource.
       * This field does _not_ indicate whether the member actually has the
       * permission for the resource. There might be another policy that overrides
       * this policy. To determine whether the member actually has the permission,
       * use the `access` field in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.AccessState access = 1;</code>
       *
       * @param value The enum numeric value on the wire for access to set.
       * @return This builder for chaining.
       */
      public Builder setAccessValue(int value) {

        access_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether _this policy_ provides the specified permission to the
       * specified member for the specified resource.
       * This field does _not_ indicate whether the member actually has the
       * permission for the resource. There might be another policy that overrides
       * this policy. To determine whether the member actually has the permission,
       * use the `access` field in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.AccessState access = 1;</code>
       *
       * @return The access.
       */
      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.AccessState getAccess() {
        @SuppressWarnings("deprecation")
        google.cloud.policytroubleshooter.v1.Explanations.AccessState result =
            google.cloud.policytroubleshooter.v1.Explanations.AccessState.valueOf(access_);
        return result == null
            ? google.cloud.policytroubleshooter.v1.Explanations.AccessState.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether _this policy_ provides the specified permission to the
       * specified member for the specified resource.
       * This field does _not_ indicate whether the member actually has the
       * permission for the resource. There might be another policy that overrides
       * this policy. To determine whether the member actually has the permission,
       * use the `access` field in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.AccessState access = 1;</code>
       *
       * @param value The access to set.
       * @return This builder for chaining.
       */
      public Builder setAccess(
          google.cloud.policytroubleshooter.v1.Explanations.AccessState value) {
        if (value == null) {
          throw new NullPointerException();
        }

        access_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether _this policy_ provides the specified permission to the
       * specified member for the specified resource.
       * This field does _not_ indicate whether the member actually has the
       * permission for the resource. There might be another policy that overrides
       * this policy. To determine whether the member actually has the permission,
       * use the `access` field in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.AccessState access = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAccess() {

        access_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object fullResourceName_ = "";
      /**
       *
       *
       * <pre>
       * The full resource name that identifies the resource. For example,
       * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * For examples of full resource names for Google Cloud services, see
       * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
       * </pre>
       *
       * <code>string full_resource_name = 2;</code>
       *
       * @return The fullResourceName.
       */
      public java.lang.String getFullResourceName() {
        java.lang.Object ref = fullResourceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fullResourceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name that identifies the resource. For example,
       * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * For examples of full resource names for Google Cloud services, see
       * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
       * </pre>
       *
       * <code>string full_resource_name = 2;</code>
       *
       * @return The bytes for fullResourceName.
       */
      public com.google.protobuf.ByteString getFullResourceNameBytes() {
        java.lang.Object ref = fullResourceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          fullResourceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The full resource name that identifies the resource. For example,
       * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * For examples of full resource names for Google Cloud services, see
       * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
       * </pre>
       *
       * <code>string full_resource_name = 2;</code>
       *
       * @param value The fullResourceName to set.
       * @return This builder for chaining.
       */
      public Builder setFullResourceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        fullResourceName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name that identifies the resource. For example,
       * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * For examples of full resource names for Google Cloud services, see
       * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
       * </pre>
       *
       * <code>string full_resource_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFullResourceName() {

        fullResourceName_ = getDefaultInstance().getFullResourceName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The full resource name that identifies the resource. For example,
       * `//compute.googleapis.com/projects/my-project/zones/us-central1-a/instances/my-instance`.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * For examples of full resource names for Google Cloud services, see
       * https://cloud.google.com/iam/help/troubleshooter/full-resource-names.
       * </pre>
       *
       * <code>string full_resource_name = 2;</code>
       *
       * @param value The bytes for fullResourceName to set.
       * @return This builder for chaining.
       */
      public Builder setFullResourceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        fullResourceName_ = value;
        onChanged();
        return this;
      }

      private com.google.iam.v1.Policy policy_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.iam.v1.Policy,
              com.google.iam.v1.Policy.Builder,
              com.google.iam.v1.PolicyOrBuilder>
          policyBuilder_;
      /**
       *
       *
       * <pre>
       * The IAM policy attached to the resource.
       * If the sender of the request does not have access to the policy, this field
       * is empty.
       * </pre>
       *
       * <code>.google.iam.v1.Policy policy = 3;</code>
       *
       * @return Whether the policy field is set.
       */
      public boolean hasPolicy() {
        return policyBuilder_ != null || policy_ != null;
      }
      /**
       *
       *
       * <pre>
       * The IAM policy attached to the resource.
       * If the sender of the request does not have access to the policy, this field
       * is empty.
       * </pre>
       *
       * <code>.google.iam.v1.Policy policy = 3;</code>
       *
       * @return The policy.
       */
      public com.google.iam.v1.Policy getPolicy() {
        if (policyBuilder_ == null) {
          return policy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : policy_;
        } else {
          return policyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The IAM policy attached to the resource.
       * If the sender of the request does not have access to the policy, this field
       * is empty.
       * </pre>
       *
       * <code>.google.iam.v1.Policy policy = 3;</code>
       */
      public Builder setPolicy(com.google.iam.v1.Policy value) {
        if (policyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          policy_ = value;
          onChanged();
        } else {
          policyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The IAM policy attached to the resource.
       * If the sender of the request does not have access to the policy, this field
       * is empty.
       * </pre>
       *
       * <code>.google.iam.v1.Policy policy = 3;</code>
       */
      public Builder setPolicy(com.google.iam.v1.Policy.Builder builderForValue) {
        if (policyBuilder_ == null) {
          policy_ = builderForValue.build();
          onChanged();
        } else {
          policyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The IAM policy attached to the resource.
       * If the sender of the request does not have access to the policy, this field
       * is empty.
       * </pre>
       *
       * <code>.google.iam.v1.Policy policy = 3;</code>
       */
      public Builder mergePolicy(com.google.iam.v1.Policy value) {
        if (policyBuilder_ == null) {
          if (policy_ != null) {
            policy_ = com.google.iam.v1.Policy.newBuilder(policy_).mergeFrom(value).buildPartial();
          } else {
            policy_ = value;
          }
          onChanged();
        } else {
          policyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The IAM policy attached to the resource.
       * If the sender of the request does not have access to the policy, this field
       * is empty.
       * </pre>
       *
       * <code>.google.iam.v1.Policy policy = 3;</code>
       */
      public Builder clearPolicy() {
        if (policyBuilder_ == null) {
          policy_ = null;
          onChanged();
        } else {
          policy_ = null;
          policyBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The IAM policy attached to the resource.
       * If the sender of the request does not have access to the policy, this field
       * is empty.
       * </pre>
       *
       * <code>.google.iam.v1.Policy policy = 3;</code>
       */
      public com.google.iam.v1.Policy.Builder getPolicyBuilder() {

        onChanged();
        return getPolicyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The IAM policy attached to the resource.
       * If the sender of the request does not have access to the policy, this field
       * is empty.
       * </pre>
       *
       * <code>.google.iam.v1.Policy policy = 3;</code>
       */
      public com.google.iam.v1.PolicyOrBuilder getPolicyOrBuilder() {
        if (policyBuilder_ != null) {
          return policyBuilder_.getMessageOrBuilder();
        } else {
          return policy_ == null ? com.google.iam.v1.Policy.getDefaultInstance() : policy_;
        }
      }
      /**
       *
       *
       * <pre>
       * The IAM policy attached to the resource.
       * If the sender of the request does not have access to the policy, this field
       * is empty.
       * </pre>
       *
       * <code>.google.iam.v1.Policy policy = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.iam.v1.Policy,
              com.google.iam.v1.Policy.Builder,
              com.google.iam.v1.PolicyOrBuilder>
          getPolicyFieldBuilder() {
        if (policyBuilder_ == null) {
          policyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.iam.v1.Policy,
                  com.google.iam.v1.Policy.Builder,
                  com.google.iam.v1.PolicyOrBuilder>(
                  getPolicy(), getParentForChildren(), isClean());
          policy_ = null;
        }
        return policyBuilder_;
      }

      private java.util.List<google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation>
          bindingExplanations_ = java.util.Collections.emptyList();

      private void ensureBindingExplanationsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          bindingExplanations_ =
              new java.util.ArrayList<
                  google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation>(
                  bindingExplanations_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Builder,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanationOrBuilder>
          bindingExplanationsBuilder_;

      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public java.util.List<google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation>
          getBindingExplanationsList() {
        if (bindingExplanationsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(bindingExplanations_);
        } else {
          return bindingExplanationsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public int getBindingExplanationsCount() {
        if (bindingExplanationsBuilder_ == null) {
          return bindingExplanations_.size();
        } else {
          return bindingExplanationsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
          getBindingExplanations(int index) {
        if (bindingExplanationsBuilder_ == null) {
          return bindingExplanations_.get(index);
        } else {
          return bindingExplanationsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public Builder setBindingExplanations(
          int index, google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation value) {
        if (bindingExplanationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBindingExplanationsIsMutable();
          bindingExplanations_.set(index, value);
          onChanged();
        } else {
          bindingExplanationsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public Builder setBindingExplanations(
          int index,
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Builder
              builderForValue) {
        if (bindingExplanationsBuilder_ == null) {
          ensureBindingExplanationsIsMutable();
          bindingExplanations_.set(index, builderForValue.build());
          onChanged();
        } else {
          bindingExplanationsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public Builder addBindingExplanations(
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation value) {
        if (bindingExplanationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBindingExplanationsIsMutable();
          bindingExplanations_.add(value);
          onChanged();
        } else {
          bindingExplanationsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public Builder addBindingExplanations(
          int index, google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation value) {
        if (bindingExplanationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBindingExplanationsIsMutable();
          bindingExplanations_.add(index, value);
          onChanged();
        } else {
          bindingExplanationsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public Builder addBindingExplanations(
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Builder
              builderForValue) {
        if (bindingExplanationsBuilder_ == null) {
          ensureBindingExplanationsIsMutable();
          bindingExplanations_.add(builderForValue.build());
          onChanged();
        } else {
          bindingExplanationsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public Builder addBindingExplanations(
          int index,
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Builder
              builderForValue) {
        if (bindingExplanationsBuilder_ == null) {
          ensureBindingExplanationsIsMutable();
          bindingExplanations_.add(index, builderForValue.build());
          onChanged();
        } else {
          bindingExplanationsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public Builder addAllBindingExplanations(
          java.lang.Iterable<
                  ? extends google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation>
              values) {
        if (bindingExplanationsBuilder_ == null) {
          ensureBindingExplanationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, bindingExplanations_);
          onChanged();
        } else {
          bindingExplanationsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public Builder clearBindingExplanations() {
        if (bindingExplanationsBuilder_ == null) {
          bindingExplanations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          bindingExplanationsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public Builder removeBindingExplanations(int index) {
        if (bindingExplanationsBuilder_ == null) {
          ensureBindingExplanationsIsMutable();
          bindingExplanations_.remove(index);
          onChanged();
        } else {
          bindingExplanationsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Builder
          getBindingExplanationsBuilder(int index) {
        return getBindingExplanationsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanationOrBuilder
          getBindingExplanationsOrBuilder(int index) {
        if (bindingExplanationsBuilder_ == null) {
          return bindingExplanations_.get(index);
        } else {
          return bindingExplanationsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public java.util.List<
              ? extends
                  google.cloud.policytroubleshooter.v1.Explanations.BindingExplanationOrBuilder>
          getBindingExplanationsOrBuilderList() {
        if (bindingExplanationsBuilder_ != null) {
          return bindingExplanationsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(bindingExplanations_);
        }
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Builder
          addBindingExplanationsBuilder() {
        return getBindingExplanationsFieldBuilder()
            .addBuilder(
                google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Builder
          addBindingExplanationsBuilder(int index) {
        return getBindingExplanationsFieldBuilder()
            .addBuilder(
                index,
                google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Details about how each binding in the policy affects the member's ability,
       * or inability, to use the permission for the resource.
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.policytroubleshooter.v1.BindingExplanation binding_explanations = 4;
       * </code>
       */
      public java.util.List<
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Builder>
          getBindingExplanationsBuilderList() {
        return getBindingExplanationsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Builder,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanationOrBuilder>
          getBindingExplanationsFieldBuilder() {
        if (bindingExplanationsBuilder_ == null) {
          bindingExplanationsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation,
                  google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Builder,
                  google.cloud.policytroubleshooter.v1.Explanations.BindingExplanationOrBuilder>(
                  bindingExplanations_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          bindingExplanations_ = null;
        }
        return bindingExplanationsBuilder_;
      }

      private int relevance_ = 0;
      /**
       *
       *
       * <pre>
       * The relevance of this policy to the overall determination in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 5;</code>
       *
       * @return The enum numeric value on the wire for relevance.
       */
      @java.lang.Override
      public int getRelevanceValue() {
        return relevance_;
      }
      /**
       *
       *
       * <pre>
       * The relevance of this policy to the overall determination in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 5;</code>
       *
       * @param value The enum numeric value on the wire for relevance to set.
       * @return This builder for chaining.
       */
      public Builder setRelevanceValue(int value) {

        relevance_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The relevance of this policy to the overall determination in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 5;</code>
       *
       * @return The relevance.
       */
      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance getRelevance() {
        @SuppressWarnings("deprecation")
        google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance result =
            google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.valueOf(
                relevance_);
        return result == null
            ? google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The relevance of this policy to the overall determination in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 5;</code>
       *
       * @param value The relevance to set.
       * @return This builder for chaining.
       */
      public Builder setRelevance(
          google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance value) {
        if (value == null) {
          throw new NullPointerException();
        }

        relevance_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The relevance of this policy to the overall determination in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * If the sender of the request does not have access to the policy, this field
       * is omitted.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRelevance() {

        relevance_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.policytroubleshooter.v1.ExplainedPolicy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.policytroubleshooter.v1.ExplainedPolicy)
    private static final google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy();
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExplainedPolicy> PARSER =
        new com.google.protobuf.AbstractParser<ExplainedPolicy>() {
          @java.lang.Override
          public ExplainedPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ExplainedPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExplainedPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.ExplainedPolicy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BindingExplanationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.policytroubleshooter.v1.BindingExplanation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Indicates whether _this binding_ provides the specified permission to the
     * specified member for the specified resource.
     * This field does _not_ indicate whether the member actually has the
     * permission for the resource. There might be another binding that overrides
     * this binding. To determine whether the member actually has the permission,
     * use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>
     * .google.cloud.policytroubleshooter.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for access.
     */
    int getAccessValue();
    /**
     *
     *
     * <pre>
     * Required. Indicates whether _this binding_ provides the specified permission to the
     * specified member for the specified resource.
     * This field does _not_ indicate whether the member actually has the
     * permission for the resource. There might be another binding that overrides
     * this binding. To determine whether the member actually has the permission,
     * use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>
     * .google.cloud.policytroubleshooter.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The access.
     */
    google.cloud.policytroubleshooter.v1.Explanations.AccessState getAccess();

    /**
     *
     *
     * <pre>
     * The role that this binding grants. For example,
     * `roles/compute.serviceAgent`.
     * For a complete list of predefined IAM roles, as well as the permissions in
     * each role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string role = 2;</code>
     *
     * @return The role.
     */
    java.lang.String getRole();
    /**
     *
     *
     * <pre>
     * The role that this binding grants. For example,
     * `roles/compute.serviceAgent`.
     * For a complete list of predefined IAM roles, as well as the permissions in
     * each role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string role = 2;</code>
     *
     * @return The bytes for role.
     */
    com.google.protobuf.ByteString getRoleBytes();

    /**
     *
     *
     * <pre>
     * Indicates whether the role granted by this binding contains the specified
     * permission.
     * </pre>
     *
     * <code>
     * .google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission role_permission = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for rolePermission.
     */
    int getRolePermissionValue();
    /**
     *
     *
     * <pre>
     * Indicates whether the role granted by this binding contains the specified
     * permission.
     * </pre>
     *
     * <code>
     * .google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission role_permission = 3;
     * </code>
     *
     * @return The rolePermission.
     */
    google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.RolePermission
        getRolePermission();

    /**
     *
     *
     * <pre>
     * The relevance of the permission's existence, or nonexistence, in the role
     * to the overall determination for the entire policy.
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance role_permission_relevance = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for rolePermissionRelevance.
     */
    int getRolePermissionRelevanceValue();
    /**
     *
     *
     * <pre>
     * The relevance of the permission's existence, or nonexistence, in the role
     * to the overall determination for the entire policy.
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance role_permission_relevance = 4;
     * </code>
     *
     * @return The rolePermissionRelevance.
     */
    google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance
        getRolePermissionRelevance();

    /**
     *
     *
     * <pre>
     * Indicates whether each member in the binding includes the member specified
     * in the request, either directly or indirectly. Each key identifies a member
     * in the binding, and each value indicates whether the member in the binding
     * includes the member in the request.
     * For example, suppose that a binding includes the following members:
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
     * member of the group `group:product-eng&#64;example.com`.
     * For the first member in the binding, the key is `user:alice&#64;example.com`,
     * and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     * For the second member in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    int getMembershipsCount();
    /**
     *
     *
     * <pre>
     * Indicates whether each member in the binding includes the member specified
     * in the request, either directly or indirectly. Each key identifies a member
     * in the binding, and each value indicates whether the member in the binding
     * includes the member in the request.
     * For example, suppose that a binding includes the following members:
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
     * member of the group `group:product-eng&#64;example.com`.
     * For the first member in the binding, the key is `user:alice&#64;example.com`,
     * and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     * For the second member in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    boolean containsMemberships(java.lang.String key);
    /** Use {@link #getMembershipsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<
            java.lang.String,
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                .AnnotatedMembership>
        getMemberships();
    /**
     *
     *
     * <pre>
     * Indicates whether each member in the binding includes the member specified
     * in the request, either directly or indirectly. Each key identifies a member
     * in the binding, and each value indicates whether the member in the binding
     * includes the member in the request.
     * For example, suppose that a binding includes the following members:
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
     * member of the group `group:product-eng&#64;example.com`.
     * For the first member in the binding, the key is `user:alice&#64;example.com`,
     * and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     * For the second member in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    java.util.Map<
            java.lang.String,
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                .AnnotatedMembership>
        getMembershipsMap();
    /**
     *
     *
     * <pre>
     * Indicates whether each member in the binding includes the member specified
     * in the request, either directly or indirectly. Each key identifies a member
     * in the binding, and each value indicates whether the member in the binding
     * includes the member in the request.
     * For example, suppose that a binding includes the following members:
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
     * member of the group `group:product-eng&#64;example.com`.
     * For the first member in the binding, the key is `user:alice&#64;example.com`,
     * and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     * For the second member in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */

    /* nullable */
    google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership
        getMembershipsOrDefault(
            java.lang.String key,
            /* nullable */
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership
                defaultValue);
    /**
     *
     *
     * <pre>
     * Indicates whether each member in the binding includes the member specified
     * in the request, either directly or indirectly. Each key identifies a member
     * in the binding, and each value indicates whether the member in the binding
     * includes the member in the request.
     * For example, suppose that a binding includes the following members:
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
     * member of the group `group:product-eng&#64;example.com`.
     * For the first member in the binding, the key is `user:alice&#64;example.com`,
     * and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     * For the second member in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership
        getMembershipsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * The relevance of this binding to the overall determination for the entire
     * policy.
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 6;</code>
     *
     * @return The enum numeric value on the wire for relevance.
     */
    int getRelevanceValue();
    /**
     *
     *
     * <pre>
     * The relevance of this binding to the overall determination for the entire
     * policy.
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 6;</code>
     *
     * @return The relevance.
     */
    google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance getRelevance();

    /**
     *
     *
     * <pre>
     * A condition expression that prevents access unless the expression evaluates
     * to `true`.
     * To learn about IAM Conditions, see
     * http://cloud.google.com/iam/help/conditions/overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     *
     * @return Whether the condition field is set.
     */
    boolean hasCondition();
    /**
     *
     *
     * <pre>
     * A condition expression that prevents access unless the expression evaluates
     * to `true`.
     * To learn about IAM Conditions, see
     * http://cloud.google.com/iam/help/conditions/overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     *
     * @return The condition.
     */
    com.google.type.Expr getCondition();
    /**
     *
     *
     * <pre>
     * A condition expression that prevents access unless the expression evaluates
     * to `true`.
     * To learn about IAM Conditions, see
     * http://cloud.google.com/iam/help/conditions/overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     */
    com.google.type.ExprOrBuilder getConditionOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Details about how a binding in a policy affects a member's ability to use a
   * permission.
   * </pre>
   *
   * Protobuf type {@code google.cloud.policytroubleshooter.v1.BindingExplanation}
   */
  public static final class BindingExplanation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.policytroubleshooter.v1.BindingExplanation)
      BindingExplanationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BindingExplanation.newBuilder() to construct.
    private BindingExplanation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BindingExplanation() {
      access_ = 0;
      role_ = "";
      rolePermission_ = 0;
      rolePermissionRelevance_ = 0;
      relevance_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BindingExplanation();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return google.cloud.policytroubleshooter.v1.Explanations
          .internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMemberships();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return google.cloud.policytroubleshooter.v1.Explanations
          .internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.class,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Whether a role includes a specific permission.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission}
     */
    public enum RolePermission implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Reserved for future use.
       * </pre>
       *
       * <code>ROLE_PERMISSION_UNSPECIFIED = 0;</code>
       */
      ROLE_PERMISSION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The permission is included in the role.
       * </pre>
       *
       * <code>ROLE_PERMISSION_INCLUDED = 1;</code>
       */
      ROLE_PERMISSION_INCLUDED(1),
      /**
       *
       *
       * <pre>
       * The permission is not included in the role.
       * </pre>
       *
       * <code>ROLE_PERMISSION_NOT_INCLUDED = 2;</code>
       */
      ROLE_PERMISSION_NOT_INCLUDED(2),
      /**
       *
       *
       * <pre>
       * The sender of the request is not allowed to access the binding.
       * </pre>
       *
       * <code>ROLE_PERMISSION_UNKNOWN_INFO_DENIED = 3;</code>
       */
      ROLE_PERMISSION_UNKNOWN_INFO_DENIED(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Reserved for future use.
       * </pre>
       *
       * <code>ROLE_PERMISSION_UNSPECIFIED = 0;</code>
       */
      public static final int ROLE_PERMISSION_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The permission is included in the role.
       * </pre>
       *
       * <code>ROLE_PERMISSION_INCLUDED = 1;</code>
       */
      public static final int ROLE_PERMISSION_INCLUDED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The permission is not included in the role.
       * </pre>
       *
       * <code>ROLE_PERMISSION_NOT_INCLUDED = 2;</code>
       */
      public static final int ROLE_PERMISSION_NOT_INCLUDED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The sender of the request is not allowed to access the binding.
       * </pre>
       *
       * <code>ROLE_PERMISSION_UNKNOWN_INFO_DENIED = 3;</code>
       */
      public static final int ROLE_PERMISSION_UNKNOWN_INFO_DENIED_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RolePermission valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static RolePermission forNumber(int value) {
        switch (value) {
          case 0:
            return ROLE_PERMISSION_UNSPECIFIED;
          case 1:
            return ROLE_PERMISSION_INCLUDED;
          case 2:
            return ROLE_PERMISSION_NOT_INCLUDED;
          case 3:
            return ROLE_PERMISSION_UNKNOWN_INFO_DENIED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<RolePermission> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<RolePermission>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<RolePermission>() {
                public RolePermission findValueByNumber(int number) {
                  return RolePermission.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final RolePermission[] VALUES = values();

      public static RolePermission valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private RolePermission(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission)
    }

    /**
     *
     *
     * <pre>
     * Whether the binding includes the member.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.policytroubleshooter.v1.BindingExplanation.Membership}
     */
    public enum Membership implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Reserved for future use.
       * </pre>
       *
       * <code>MEMBERSHIP_UNSPECIFIED = 0;</code>
       */
      MEMBERSHIP_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The binding includes the member. The member can be included directly
       * or indirectly. For example:
       * * A member is included directly if that member is listed in the binding.
       * * A member is included indirectly if that member is in a Google group or
       *   G Suite domain that is listed in the binding.
       * </pre>
       *
       * <code>MEMBERSHIP_INCLUDED = 1;</code>
       */
      MEMBERSHIP_INCLUDED(1),
      /**
       *
       *
       * <pre>
       * The binding does not include the member.
       * </pre>
       *
       * <code>MEMBERSHIP_NOT_INCLUDED = 2;</code>
       */
      MEMBERSHIP_NOT_INCLUDED(2),
      /**
       *
       *
       * <pre>
       * The sender of the request is not allowed to access the binding.
       * </pre>
       *
       * <code>MEMBERSHIP_UNKNOWN_INFO_DENIED = 3;</code>
       */
      MEMBERSHIP_UNKNOWN_INFO_DENIED(3),
      /**
       *
       *
       * <pre>
       * The member is an unsupported type. Only Google Accounts and service
       * accounts are supported.
       * </pre>
       *
       * <code>MEMBERSHIP_UNKNOWN_UNSUPPORTED = 4;</code>
       */
      MEMBERSHIP_UNKNOWN_UNSUPPORTED(4),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Reserved for future use.
       * </pre>
       *
       * <code>MEMBERSHIP_UNSPECIFIED = 0;</code>
       */
      public static final int MEMBERSHIP_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The binding includes the member. The member can be included directly
       * or indirectly. For example:
       * * A member is included directly if that member is listed in the binding.
       * * A member is included indirectly if that member is in a Google group or
       *   G Suite domain that is listed in the binding.
       * </pre>
       *
       * <code>MEMBERSHIP_INCLUDED = 1;</code>
       */
      public static final int MEMBERSHIP_INCLUDED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The binding does not include the member.
       * </pre>
       *
       * <code>MEMBERSHIP_NOT_INCLUDED = 2;</code>
       */
      public static final int MEMBERSHIP_NOT_INCLUDED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The sender of the request is not allowed to access the binding.
       * </pre>
       *
       * <code>MEMBERSHIP_UNKNOWN_INFO_DENIED = 3;</code>
       */
      public static final int MEMBERSHIP_UNKNOWN_INFO_DENIED_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The member is an unsupported type. Only Google Accounts and service
       * accounts are supported.
       * </pre>
       *
       * <code>MEMBERSHIP_UNKNOWN_UNSUPPORTED = 4;</code>
       */
      public static final int MEMBERSHIP_UNKNOWN_UNSUPPORTED_VALUE = 4;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Membership valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Membership forNumber(int value) {
        switch (value) {
          case 0:
            return MEMBERSHIP_UNSPECIFIED;
          case 1:
            return MEMBERSHIP_INCLUDED;
          case 2:
            return MEMBERSHIP_NOT_INCLUDED;
          case 3:
            return MEMBERSHIP_UNKNOWN_INFO_DENIED;
          case 4:
            return MEMBERSHIP_UNKNOWN_UNSUPPORTED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Membership> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Membership> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Membership>() {
            public Membership findValueByNumber(int number) {
              return Membership.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final Membership[] VALUES = values();

      public static Membership valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Membership(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.policytroubleshooter.v1.BindingExplanation.Membership)
    }

    public interface AnnotatedMembershipOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Indicates whether the binding includes the member.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.BindingExplanation.Membership membership = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for membership.
       */
      int getMembershipValue();
      /**
       *
       *
       * <pre>
       * Indicates whether the binding includes the member.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.BindingExplanation.Membership membership = 1;
       * </code>
       *
       * @return The membership.
       */
      google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Membership
          getMembership();

      /**
       *
       *
       * <pre>
       * The relevance of the member's status to the overall determination for the
       * binding.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 2;</code>
       *
       * @return The enum numeric value on the wire for relevance.
       */
      int getRelevanceValue();
      /**
       *
       *
       * <pre>
       * The relevance of the member's status to the overall determination for the
       * binding.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 2;</code>
       *
       * @return The relevance.
       */
      google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance getRelevance();
    }
    /**
     *
     *
     * <pre>
     * Details about whether the binding includes the member.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership}
     */
    public static final class AnnotatedMembership extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership)
        AnnotatedMembershipOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use AnnotatedMembership.newBuilder() to construct.
      private AnnotatedMembership(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private AnnotatedMembership() {
        membership_ = 0;
        relevance_ = 0;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new AnnotatedMembership();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return google.cloud.policytroubleshooter.v1.Explanations
            .internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_AnnotatedMembership_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return google.cloud.policytroubleshooter.v1.Explanations
            .internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_AnnotatedMembership_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                    .AnnotatedMembership.class,
                google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                    .AnnotatedMembership.Builder.class);
      }

      public static final int MEMBERSHIP_FIELD_NUMBER = 1;
      private int membership_;
      /**
       *
       *
       * <pre>
       * Indicates whether the binding includes the member.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.BindingExplanation.Membership membership = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for membership.
       */
      @java.lang.Override
      public int getMembershipValue() {
        return membership_;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the binding includes the member.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.BindingExplanation.Membership membership = 1;
       * </code>
       *
       * @return The membership.
       */
      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Membership
          getMembership() {
        @SuppressWarnings("deprecation")
        google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Membership result =
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Membership.valueOf(
                membership_);
        return result == null
            ? google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Membership
                .UNRECOGNIZED
            : result;
      }

      public static final int RELEVANCE_FIELD_NUMBER = 2;
      private int relevance_;
      /**
       *
       *
       * <pre>
       * The relevance of the member's status to the overall determination for the
       * binding.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 2;</code>
       *
       * @return The enum numeric value on the wire for relevance.
       */
      @java.lang.Override
      public int getRelevanceValue() {
        return relevance_;
      }
      /**
       *
       *
       * <pre>
       * The relevance of the member's status to the overall determination for the
       * binding.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 2;</code>
       *
       * @return The relevance.
       */
      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance getRelevance() {
        @SuppressWarnings("deprecation")
        google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance result =
            google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.valueOf(
                relevance_);
        return result == null
            ? google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.UNRECOGNIZED
            : result;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (membership_
            != google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Membership
                .MEMBERSHIP_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(1, membership_);
        }
        if (relevance_
            != google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance
                .HEURISTIC_RELEVANCE_UNSPECIFIED
                .getNumber()) {
          output.writeEnum(2, relevance_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (membership_
            != google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Membership
                .MEMBERSHIP_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, membership_);
        }
        if (relevance_
            != google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance
                .HEURISTIC_RELEVANCE_UNSPECIFIED
                .getNumber()) {
          size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, relevance_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                .AnnotatedMembership)) {
          return super.equals(obj);
        }
        google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership
            other =
                (google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                        .AnnotatedMembership)
                    obj;

        if (membership_ != other.membership_) return false;
        if (relevance_ != other.relevance_) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MEMBERSHIP_FIELD_NUMBER;
        hash = (53 * hash) + membership_;
        hash = (37 * hash) + RELEVANCE_FIELD_NUMBER;
        hash = (53 * hash) + relevance_;
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Details about whether the binding includes the member.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership)
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembershipOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return google.cloud.policytroubleshooter.v1.Explanations
              .internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_AnnotatedMembership_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return google.cloud.policytroubleshooter.v1.Explanations
              .internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_AnnotatedMembership_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                      .AnnotatedMembership.class,
                  google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                      .AnnotatedMembership.Builder.class);
        }

        // Construct using
        // google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          membership_ = 0;

          relevance_ = 0;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return google.cloud.policytroubleshooter.v1.Explanations
              .internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_AnnotatedMembership_descriptor;
        }

        @java.lang.Override
        public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                .AnnotatedMembership
            getDefaultInstanceForType() {
          return google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership.getDefaultInstance();
        }

        @java.lang.Override
        public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                .AnnotatedMembership
            build() {
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                .AnnotatedMembership
            buildPartial() {
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership
              result =
                  new google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                      .AnnotatedMembership(this);
          result.membership_ = membership_;
          result.relevance_ = relevance_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                  .AnnotatedMembership) {
            return mergeFrom(
                (google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                        .AnnotatedMembership)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership
                other) {
          if (other
              == google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                  .AnnotatedMembership.getDefaultInstance()) return this;
          if (other.membership_ != 0) {
            setMembershipValue(other.getMembershipValue());
          }
          if (other.relevance_ != 0) {
            setRelevanceValue(other.getRelevanceValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    membership_ = input.readEnum();

                    break;
                  } // case 8
                case 16:
                  {
                    relevance_ = input.readEnum();

                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int membership_ = 0;
        /**
         *
         *
         * <pre>
         * Indicates whether the binding includes the member.
         * </pre>
         *
         * <code>.google.cloud.policytroubleshooter.v1.BindingExplanation.Membership membership = 1;
         * </code>
         *
         * @return The enum numeric value on the wire for membership.
         */
        @java.lang.Override
        public int getMembershipValue() {
          return membership_;
        }
        /**
         *
         *
         * <pre>
         * Indicates whether the binding includes the member.
         * </pre>
         *
         * <code>.google.cloud.policytroubleshooter.v1.BindingExplanation.Membership membership = 1;
         * </code>
         *
         * @param value The enum numeric value on the wire for membership to set.
         * @return This builder for chaining.
         */
        public Builder setMembershipValue(int value) {

          membership_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Indicates whether the binding includes the member.
         * </pre>
         *
         * <code>.google.cloud.policytroubleshooter.v1.BindingExplanation.Membership membership = 1;
         * </code>
         *
         * @return The membership.
         */
        @java.lang.Override
        public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Membership
            getMembership() {
          @SuppressWarnings("deprecation")
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Membership result =
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Membership
                  .valueOf(membership_);
          return result == null
              ? google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Membership
                  .UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * Indicates whether the binding includes the member.
         * </pre>
         *
         * <code>.google.cloud.policytroubleshooter.v1.BindingExplanation.Membership membership = 1;
         * </code>
         *
         * @param value The membership to set.
         * @return This builder for chaining.
         */
        public Builder setMembership(
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Membership value) {
          if (value == null) {
            throw new NullPointerException();
          }

          membership_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Indicates whether the binding includes the member.
         * </pre>
         *
         * <code>.google.cloud.policytroubleshooter.v1.BindingExplanation.Membership membership = 1;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMembership() {

          membership_ = 0;
          onChanged();
          return this;
        }

        private int relevance_ = 0;
        /**
         *
         *
         * <pre>
         * The relevance of the member's status to the overall determination for the
         * binding.
         * </pre>
         *
         * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 2;</code>
         *
         * @return The enum numeric value on the wire for relevance.
         */
        @java.lang.Override
        public int getRelevanceValue() {
          return relevance_;
        }
        /**
         *
         *
         * <pre>
         * The relevance of the member's status to the overall determination for the
         * binding.
         * </pre>
         *
         * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 2;</code>
         *
         * @param value The enum numeric value on the wire for relevance to set.
         * @return This builder for chaining.
         */
        public Builder setRelevanceValue(int value) {

          relevance_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The relevance of the member's status to the overall determination for the
         * binding.
         * </pre>
         *
         * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 2;</code>
         *
         * @return The relevance.
         */
        @java.lang.Override
        public google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance getRelevance() {
          @SuppressWarnings("deprecation")
          google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance result =
              google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.valueOf(
                  relevance_);
          return result == null
              ? google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.UNRECOGNIZED
              : result;
        }
        /**
         *
         *
         * <pre>
         * The relevance of the member's status to the overall determination for the
         * binding.
         * </pre>
         *
         * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 2;</code>
         *
         * @param value The relevance to set.
         * @return This builder for chaining.
         */
        public Builder setRelevance(
            google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance value) {
          if (value == null) {
            throw new NullPointerException();
          }

          relevance_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The relevance of the member's status to the overall determination for the
         * binding.
         * </pre>
         *
         * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRelevance() {

          relevance_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership)
      private static final google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                .AnnotatedMembership();
      }

      public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AnnotatedMembership> PARSER =
          new com.google.protobuf.AbstractParser<AnnotatedMembership>() {
            @java.lang.Override
            public AnnotatedMembership parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<AnnotatedMembership> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AnnotatedMembership> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int ACCESS_FIELD_NUMBER = 1;
    private int access_;
    /**
     *
     *
     * <pre>
     * Required. Indicates whether _this binding_ provides the specified permission to the
     * specified member for the specified resource.
     * This field does _not_ indicate whether the member actually has the
     * permission for the resource. There might be another binding that overrides
     * this binding. To determine whether the member actually has the permission,
     * use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>
     * .google.cloud.policytroubleshooter.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for access.
     */
    @java.lang.Override
    public int getAccessValue() {
      return access_;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates whether _this binding_ provides the specified permission to the
     * specified member for the specified resource.
     * This field does _not_ indicate whether the member actually has the
     * permission for the resource. There might be another binding that overrides
     * this binding. To determine whether the member actually has the permission,
     * use the `access` field in the
     * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
     * </pre>
     *
     * <code>
     * .google.cloud.policytroubleshooter.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The access.
     */
    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.AccessState getAccess() {
      @SuppressWarnings("deprecation")
      google.cloud.policytroubleshooter.v1.Explanations.AccessState result =
          google.cloud.policytroubleshooter.v1.Explanations.AccessState.valueOf(access_);
      return result == null
          ? google.cloud.policytroubleshooter.v1.Explanations.AccessState.UNRECOGNIZED
          : result;
    }

    public static final int ROLE_FIELD_NUMBER = 2;
    private volatile java.lang.Object role_;
    /**
     *
     *
     * <pre>
     * The role that this binding grants. For example,
     * `roles/compute.serviceAgent`.
     * For a complete list of predefined IAM roles, as well as the permissions in
     * each role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string role = 2;</code>
     *
     * @return The role.
     */
    @java.lang.Override
    public java.lang.String getRole() {
      java.lang.Object ref = role_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        role_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The role that this binding grants. For example,
     * `roles/compute.serviceAgent`.
     * For a complete list of predefined IAM roles, as well as the permissions in
     * each role, see https://cloud.google.com/iam/help/roles/reference.
     * </pre>
     *
     * <code>string role = 2;</code>
     *
     * @return The bytes for role.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRoleBytes() {
      java.lang.Object ref = role_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        role_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ROLE_PERMISSION_FIELD_NUMBER = 3;
    private int rolePermission_;
    /**
     *
     *
     * <pre>
     * Indicates whether the role granted by this binding contains the specified
     * permission.
     * </pre>
     *
     * <code>
     * .google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission role_permission = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for rolePermission.
     */
    @java.lang.Override
    public int getRolePermissionValue() {
      return rolePermission_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the role granted by this binding contains the specified
     * permission.
     * </pre>
     *
     * <code>
     * .google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission role_permission = 3;
     * </code>
     *
     * @return The rolePermission.
     */
    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.RolePermission
        getRolePermission() {
      @SuppressWarnings("deprecation")
      google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.RolePermission result =
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.RolePermission
              .valueOf(rolePermission_);
      return result == null
          ? google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.RolePermission
              .UNRECOGNIZED
          : result;
    }

    public static final int ROLE_PERMISSION_RELEVANCE_FIELD_NUMBER = 4;
    private int rolePermissionRelevance_;
    /**
     *
     *
     * <pre>
     * The relevance of the permission's existence, or nonexistence, in the role
     * to the overall determination for the entire policy.
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance role_permission_relevance = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for rolePermissionRelevance.
     */
    @java.lang.Override
    public int getRolePermissionRelevanceValue() {
      return rolePermissionRelevance_;
    }
    /**
     *
     *
     * <pre>
     * The relevance of the permission's existence, or nonexistence, in the role
     * to the overall determination for the entire policy.
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance role_permission_relevance = 4;
     * </code>
     *
     * @return The rolePermissionRelevance.
     */
    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance
        getRolePermissionRelevance() {
      @SuppressWarnings("deprecation")
      google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance result =
          google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.valueOf(
              rolePermissionRelevance_);
      return result == null
          ? google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.UNRECOGNIZED
          : result;
    }

    public static final int MEMBERSHIPS_FIELD_NUMBER = 5;

    private static final class MembershipsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                  .AnnotatedMembership>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String,
                      google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                          .AnnotatedMembership>
                      newDefaultInstance(
                          google.cloud.policytroubleshooter.v1.Explanations
                              .internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_MembershipsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                              .AnnotatedMembership.getDefaultInstance());
    }

    private com.google.protobuf.MapField<
            java.lang.String,
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                .AnnotatedMembership>
        memberships_;

    private com.google.protobuf.MapField<
            java.lang.String,
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                .AnnotatedMembership>
        internalGetMemberships() {
      if (memberships_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            MembershipsDefaultEntryHolder.defaultEntry);
      }
      return memberships_;
    }

    public int getMembershipsCount() {
      return internalGetMemberships().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Indicates whether each member in the binding includes the member specified
     * in the request, either directly or indirectly. Each key identifies a member
     * in the binding, and each value indicates whether the member in the binding
     * includes the member in the request.
     * For example, suppose that a binding includes the following members:
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
     * member of the group `group:product-eng&#64;example.com`.
     * For the first member in the binding, the key is `user:alice&#64;example.com`,
     * and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     * For the second member in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    @java.lang.Override
    public boolean containsMemberships(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMemberships().getMap().containsKey(key);
    }
    /** Use {@link #getMembershipsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                .AnnotatedMembership>
        getMemberships() {
      return getMembershipsMap();
    }
    /**
     *
     *
     * <pre>
     * Indicates whether each member in the binding includes the member specified
     * in the request, either directly or indirectly. Each key identifies a member
     * in the binding, and each value indicates whether the member in the binding
     * includes the member in the request.
     * For example, suppose that a binding includes the following members:
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
     * member of the group `group:product-eng&#64;example.com`.
     * For the first member in the binding, the key is `user:alice&#64;example.com`,
     * and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     * For the second member in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                .AnnotatedMembership>
        getMembershipsMap() {
      return internalGetMemberships().getMap();
    }
    /**
     *
     *
     * <pre>
     * Indicates whether each member in the binding includes the member specified
     * in the request, either directly or indirectly. Each key identifies a member
     * in the binding, and each value indicates whether the member in the binding
     * includes the member in the request.
     * For example, suppose that a binding includes the following members:
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
     * member of the group `group:product-eng&#64;example.com`.
     * For the first member in the binding, the key is `user:alice&#64;example.com`,
     * and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     * For the second member in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership
        getMembershipsOrDefault(
            java.lang.String key,
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                  .AnnotatedMembership>
          map = internalGetMemberships().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether each member in the binding includes the member specified
     * in the request, either directly or indirectly. Each key identifies a member
     * in the binding, and each value indicates whether the member in the binding
     * includes the member in the request.
     * For example, suppose that a binding includes the following members:
     * * `user:alice&#64;example.com`
     * * `group:product-eng&#64;example.com`
     * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
     * member of the group `group:product-eng&#64;example.com`.
     * For the first member in the binding, the key is `user:alice&#64;example.com`,
     * and the `membership` field in the value is set to
     * `MEMBERSHIP_NOT_INCLUDED`.
     * For the second member in the binding, the key is
     * `group:product-eng&#64;example.com`, and the `membership` field in the value is
     * set to `MEMBERSHIP_INCLUDED`.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
     * </code>
     */
    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership
        getMembershipsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                  .AnnotatedMembership>
          map = internalGetMemberships().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int RELEVANCE_FIELD_NUMBER = 6;
    private int relevance_;
    /**
     *
     *
     * <pre>
     * The relevance of this binding to the overall determination for the entire
     * policy.
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 6;</code>
     *
     * @return The enum numeric value on the wire for relevance.
     */
    @java.lang.Override
    public int getRelevanceValue() {
      return relevance_;
    }
    /**
     *
     *
     * <pre>
     * The relevance of this binding to the overall determination for the entire
     * policy.
     * </pre>
     *
     * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 6;</code>
     *
     * @return The relevance.
     */
    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance getRelevance() {
      @SuppressWarnings("deprecation")
      google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance result =
          google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.valueOf(relevance_);
      return result == null
          ? google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.UNRECOGNIZED
          : result;
    }

    public static final int CONDITION_FIELD_NUMBER = 7;
    private com.google.type.Expr condition_;
    /**
     *
     *
     * <pre>
     * A condition expression that prevents access unless the expression evaluates
     * to `true`.
     * To learn about IAM Conditions, see
     * http://cloud.google.com/iam/help/conditions/overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     *
     * @return Whether the condition field is set.
     */
    @java.lang.Override
    public boolean hasCondition() {
      return condition_ != null;
    }
    /**
     *
     *
     * <pre>
     * A condition expression that prevents access unless the expression evaluates
     * to `true`.
     * To learn about IAM Conditions, see
     * http://cloud.google.com/iam/help/conditions/overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     *
     * @return The condition.
     */
    @java.lang.Override
    public com.google.type.Expr getCondition() {
      return condition_ == null ? com.google.type.Expr.getDefaultInstance() : condition_;
    }
    /**
     *
     *
     * <pre>
     * A condition expression that prevents access unless the expression evaluates
     * to `true`.
     * To learn about IAM Conditions, see
     * http://cloud.google.com/iam/help/conditions/overview.
     * </pre>
     *
     * <code>.google.type.Expr condition = 7;</code>
     */
    @java.lang.Override
    public com.google.type.ExprOrBuilder getConditionOrBuilder() {
      return getCondition();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (access_
          != google.cloud.policytroubleshooter.v1.Explanations.AccessState.ACCESS_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, access_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(role_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, role_);
      }
      if (rolePermission_
          != google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.RolePermission
              .ROLE_PERMISSION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, rolePermission_);
      }
      if (rolePermissionRelevance_
          != google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance
              .HEURISTIC_RELEVANCE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, rolePermissionRelevance_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetMemberships(), MembershipsDefaultEntryHolder.defaultEntry, 5);
      if (relevance_
          != google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance
              .HEURISTIC_RELEVANCE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(6, relevance_);
      }
      if (condition_ != null) {
        output.writeMessage(7, getCondition());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (access_
          != google.cloud.policytroubleshooter.v1.Explanations.AccessState.ACCESS_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, access_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(role_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, role_);
      }
      if (rolePermission_
          != google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.RolePermission
              .ROLE_PERMISSION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, rolePermission_);
      }
      if (rolePermissionRelevance_
          != google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance
              .HEURISTIC_RELEVANCE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, rolePermissionRelevance_);
      }
      for (java.util.Map.Entry<
              java.lang.String,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                  .AnnotatedMembership>
          entry : internalGetMemberships().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String,
                google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                    .AnnotatedMembership>
            memberships__ =
                MembershipsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, memberships__);
      }
      if (relevance_
          != google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance
              .HEURISTIC_RELEVANCE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, relevance_);
      }
      if (condition_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCondition());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation)) {
        return super.equals(obj);
      }
      google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation other =
          (google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation) obj;

      if (access_ != other.access_) return false;
      if (!getRole().equals(other.getRole())) return false;
      if (rolePermission_ != other.rolePermission_) return false;
      if (rolePermissionRelevance_ != other.rolePermissionRelevance_) return false;
      if (!internalGetMemberships().equals(other.internalGetMemberships())) return false;
      if (relevance_ != other.relevance_) return false;
      if (hasCondition() != other.hasCondition()) return false;
      if (hasCondition()) {
        if (!getCondition().equals(other.getCondition())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACCESS_FIELD_NUMBER;
      hash = (53 * hash) + access_;
      hash = (37 * hash) + ROLE_FIELD_NUMBER;
      hash = (53 * hash) + getRole().hashCode();
      hash = (37 * hash) + ROLE_PERMISSION_FIELD_NUMBER;
      hash = (53 * hash) + rolePermission_;
      hash = (37 * hash) + ROLE_PERMISSION_RELEVANCE_FIELD_NUMBER;
      hash = (53 * hash) + rolePermissionRelevance_;
      if (!internalGetMemberships().getMap().isEmpty()) {
        hash = (37 * hash) + MEMBERSHIPS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetMemberships().hashCode();
      }
      hash = (37 * hash) + RELEVANCE_FIELD_NUMBER;
      hash = (53 * hash) + relevance_;
      if (hasCondition()) {
        hash = (37 * hash) + CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getCondition().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details about how a binding in a policy affects a member's ability to use a
     * permission.
     * </pre>
     *
     * Protobuf type {@code google.cloud.policytroubleshooter.v1.BindingExplanation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.policytroubleshooter.v1.BindingExplanation)
        google.cloud.policytroubleshooter.v1.Explanations.BindingExplanationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return google.cloud.policytroubleshooter.v1.Explanations
            .internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 5:
            return internalGetMemberships();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 5:
            return internalGetMutableMemberships();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return google.cloud.policytroubleshooter.v1.Explanations
            .internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.class,
                google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.Builder.class);
      }

      // Construct using
      // google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        access_ = 0;

        role_ = "";

        rolePermission_ = 0;

        rolePermissionRelevance_ = 0;

        internalGetMutableMemberships().clear();
        relevance_ = 0;

        if (conditionBuilder_ == null) {
          condition_ = null;
        } else {
          condition_ = null;
          conditionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return google.cloud.policytroubleshooter.v1.Explanations
            .internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_descriptor;
      }

      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
          getDefaultInstanceForType() {
        return google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
            .getDefaultInstance();
      }

      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation build() {
        google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation buildPartial() {
        google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation result =
            new google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation(this);
        int from_bitField0_ = bitField0_;
        result.access_ = access_;
        result.role_ = role_;
        result.rolePermission_ = rolePermission_;
        result.rolePermissionRelevance_ = rolePermissionRelevance_;
        result.memberships_ = internalGetMemberships();
        result.memberships_.makeImmutable();
        result.relevance_ = relevance_;
        if (conditionBuilder_ == null) {
          result.condition_ = condition_;
        } else {
          result.condition_ = conditionBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation) {
          return mergeFrom(
              (google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation other) {
        if (other
            == google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                .getDefaultInstance()) return this;
        if (other.access_ != 0) {
          setAccessValue(other.getAccessValue());
        }
        if (!other.getRole().isEmpty()) {
          role_ = other.role_;
          onChanged();
        }
        if (other.rolePermission_ != 0) {
          setRolePermissionValue(other.getRolePermissionValue());
        }
        if (other.rolePermissionRelevance_ != 0) {
          setRolePermissionRelevanceValue(other.getRolePermissionRelevanceValue());
        }
        internalGetMutableMemberships().mergeFrom(other.internalGetMemberships());
        if (other.relevance_ != 0) {
          setRelevanceValue(other.getRelevanceValue());
        }
        if (other.hasCondition()) {
          mergeCondition(other.getCondition());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  access_ = input.readEnum();

                  break;
                } // case 8
              case 18:
                {
                  role_ = input.readStringRequireUtf8();

                  break;
                } // case 18
              case 24:
                {
                  rolePermission_ = input.readEnum();

                  break;
                } // case 24
              case 32:
                {
                  rolePermissionRelevance_ = input.readEnum();

                  break;
                } // case 32
              case 42:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                              .AnnotatedMembership>
                      memberships__ =
                          input.readMessage(
                              MembershipsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableMemberships()
                      .getMutableMap()
                      .put(memberships__.getKey(), memberships__.getValue());
                  break;
                } // case 42
              case 48:
                {
                  relevance_ = input.readEnum();

                  break;
                } // case 48
              case 58:
                {
                  input.readMessage(getConditionFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int access_ = 0;
      /**
       *
       *
       * <pre>
       * Required. Indicates whether _this binding_ provides the specified permission to the
       * specified member for the specified resource.
       * This field does _not_ indicate whether the member actually has the
       * permission for the resource. There might be another binding that overrides
       * this binding. To determine whether the member actually has the permission,
       * use the `access` field in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for access.
       */
      @java.lang.Override
      public int getAccessValue() {
        return access_;
      }
      /**
       *
       *
       * <pre>
       * Required. Indicates whether _this binding_ provides the specified permission to the
       * specified member for the specified resource.
       * This field does _not_ indicate whether the member actually has the
       * permission for the resource. There might be another binding that overrides
       * this binding. To determine whether the member actually has the permission,
       * use the `access` field in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for access to set.
       * @return This builder for chaining.
       */
      public Builder setAccessValue(int value) {

        access_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Indicates whether _this binding_ provides the specified permission to the
       * specified member for the specified resource.
       * This field does _not_ indicate whether the member actually has the
       * permission for the resource. There might be another binding that overrides
       * this binding. To determine whether the member actually has the permission,
       * use the `access` field in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The access.
       */
      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.AccessState getAccess() {
        @SuppressWarnings("deprecation")
        google.cloud.policytroubleshooter.v1.Explanations.AccessState result =
            google.cloud.policytroubleshooter.v1.Explanations.AccessState.valueOf(access_);
        return result == null
            ? google.cloud.policytroubleshooter.v1.Explanations.AccessState.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. Indicates whether _this binding_ provides the specified permission to the
       * specified member for the specified resource.
       * This field does _not_ indicate whether the member actually has the
       * permission for the resource. There might be another binding that overrides
       * this binding. To determine whether the member actually has the permission,
       * use the `access` field in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The access to set.
       * @return This builder for chaining.
       */
      public Builder setAccess(
          google.cloud.policytroubleshooter.v1.Explanations.AccessState value) {
        if (value == null) {
          throw new NullPointerException();
        }

        access_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Indicates whether _this binding_ provides the specified permission to the
       * specified member for the specified resource.
       * This field does _not_ indicate whether the member actually has the
       * permission for the resource. There might be another binding that overrides
       * this binding. To determine whether the member actually has the permission,
       * use the `access` field in the
       * [TroubleshootIamPolicyResponse][IamChecker.TroubleshootIamPolicyResponse].
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.AccessState access = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAccess() {

        access_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object role_ = "";
      /**
       *
       *
       * <pre>
       * The role that this binding grants. For example,
       * `roles/compute.serviceAgent`.
       * For a complete list of predefined IAM roles, as well as the permissions in
       * each role, see https://cloud.google.com/iam/help/roles/reference.
       * </pre>
       *
       * <code>string role = 2;</code>
       *
       * @return The role.
       */
      public java.lang.String getRole() {
        java.lang.Object ref = role_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          role_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The role that this binding grants. For example,
       * `roles/compute.serviceAgent`.
       * For a complete list of predefined IAM roles, as well as the permissions in
       * each role, see https://cloud.google.com/iam/help/roles/reference.
       * </pre>
       *
       * <code>string role = 2;</code>
       *
       * @return The bytes for role.
       */
      public com.google.protobuf.ByteString getRoleBytes() {
        java.lang.Object ref = role_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          role_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The role that this binding grants. For example,
       * `roles/compute.serviceAgent`.
       * For a complete list of predefined IAM roles, as well as the permissions in
       * each role, see https://cloud.google.com/iam/help/roles/reference.
       * </pre>
       *
       * <code>string role = 2;</code>
       *
       * @param value The role to set.
       * @return This builder for chaining.
       */
      public Builder setRole(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        role_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The role that this binding grants. For example,
       * `roles/compute.serviceAgent`.
       * For a complete list of predefined IAM roles, as well as the permissions in
       * each role, see https://cloud.google.com/iam/help/roles/reference.
       * </pre>
       *
       * <code>string role = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRole() {

        role_ = getDefaultInstance().getRole();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The role that this binding grants. For example,
       * `roles/compute.serviceAgent`.
       * For a complete list of predefined IAM roles, as well as the permissions in
       * each role, see https://cloud.google.com/iam/help/roles/reference.
       * </pre>
       *
       * <code>string role = 2;</code>
       *
       * @param value The bytes for role to set.
       * @return This builder for chaining.
       */
      public Builder setRoleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        role_ = value;
        onChanged();
        return this;
      }

      private int rolePermission_ = 0;
      /**
       *
       *
       * <pre>
       * Indicates whether the role granted by this binding contains the specified
       * permission.
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission role_permission = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for rolePermission.
       */
      @java.lang.Override
      public int getRolePermissionValue() {
        return rolePermission_;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the role granted by this binding contains the specified
       * permission.
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission role_permission = 3;
       * </code>
       *
       * @param value The enum numeric value on the wire for rolePermission to set.
       * @return This builder for chaining.
       */
      public Builder setRolePermissionValue(int value) {

        rolePermission_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the role granted by this binding contains the specified
       * permission.
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission role_permission = 3;
       * </code>
       *
       * @return The rolePermission.
       */
      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.RolePermission
          getRolePermission() {
        @SuppressWarnings("deprecation")
        google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.RolePermission result =
            google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.RolePermission
                .valueOf(rolePermission_);
        return result == null
            ? google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.RolePermission
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the role granted by this binding contains the specified
       * permission.
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission role_permission = 3;
       * </code>
       *
       * @param value The rolePermission to set.
       * @return This builder for chaining.
       */
      public Builder setRolePermission(
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.RolePermission
              value) {
        if (value == null) {
          throw new NullPointerException();
        }

        rolePermission_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether the role granted by this binding contains the specified
       * permission.
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.BindingExplanation.RolePermission role_permission = 3;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRolePermission() {

        rolePermission_ = 0;
        onChanged();
        return this;
      }

      private int rolePermissionRelevance_ = 0;
      /**
       *
       *
       * <pre>
       * The relevance of the permission's existence, or nonexistence, in the role
       * to the overall determination for the entire policy.
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.HeuristicRelevance role_permission_relevance = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for rolePermissionRelevance.
       */
      @java.lang.Override
      public int getRolePermissionRelevanceValue() {
        return rolePermissionRelevance_;
      }
      /**
       *
       *
       * <pre>
       * The relevance of the permission's existence, or nonexistence, in the role
       * to the overall determination for the entire policy.
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.HeuristicRelevance role_permission_relevance = 4;
       * </code>
       *
       * @param value The enum numeric value on the wire for rolePermissionRelevance to set.
       * @return This builder for chaining.
       */
      public Builder setRolePermissionRelevanceValue(int value) {

        rolePermissionRelevance_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The relevance of the permission's existence, or nonexistence, in the role
       * to the overall determination for the entire policy.
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.HeuristicRelevance role_permission_relevance = 4;
       * </code>
       *
       * @return The rolePermissionRelevance.
       */
      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance
          getRolePermissionRelevance() {
        @SuppressWarnings("deprecation")
        google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance result =
            google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.valueOf(
                rolePermissionRelevance_);
        return result == null
            ? google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The relevance of the permission's existence, or nonexistence, in the role
       * to the overall determination for the entire policy.
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.HeuristicRelevance role_permission_relevance = 4;
       * </code>
       *
       * @param value The rolePermissionRelevance to set.
       * @return This builder for chaining.
       */
      public Builder setRolePermissionRelevance(
          google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance value) {
        if (value == null) {
          throw new NullPointerException();
        }

        rolePermissionRelevance_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The relevance of the permission's existence, or nonexistence, in the role
       * to the overall determination for the entire policy.
       * </pre>
       *
       * <code>
       * .google.cloud.policytroubleshooter.v1.HeuristicRelevance role_permission_relevance = 4;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRolePermissionRelevance() {

        rolePermissionRelevance_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<
              java.lang.String,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                  .AnnotatedMembership>
          memberships_;

      private com.google.protobuf.MapField<
              java.lang.String,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                  .AnnotatedMembership>
          internalGetMemberships() {
        if (memberships_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              MembershipsDefaultEntryHolder.defaultEntry);
        }
        return memberships_;
      }

      private com.google.protobuf.MapField<
              java.lang.String,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                  .AnnotatedMembership>
          internalGetMutableMemberships() {
        onChanged();
        ;
        if (memberships_ == null) {
          memberships_ =
              com.google.protobuf.MapField.newMapField(MembershipsDefaultEntryHolder.defaultEntry);
        }
        if (!memberships_.isMutable()) {
          memberships_ = memberships_.copy();
        }
        return memberships_;
      }

      public int getMembershipsCount() {
        return internalGetMemberships().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Indicates whether each member in the binding includes the member specified
       * in the request, either directly or indirectly. Each key identifies a member
       * in the binding, and each value indicates whether the member in the binding
       * includes the member in the request.
       * For example, suppose that a binding includes the following members:
       * * `user:alice&#64;example.com`
       * * `group:product-eng&#64;example.com`
       * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
       * member of the group `group:product-eng&#64;example.com`.
       * For the first member in the binding, the key is `user:alice&#64;example.com`,
       * and the `membership` field in the value is set to
       * `MEMBERSHIP_NOT_INCLUDED`.
       * For the second member in the binding, the key is
       * `group:product-eng&#64;example.com`, and the `membership` field in the value is
       * set to `MEMBERSHIP_INCLUDED`.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
       * </code>
       */
      @java.lang.Override
      public boolean containsMemberships(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetMemberships().getMap().containsKey(key);
      }
      /** Use {@link #getMembershipsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                  .AnnotatedMembership>
          getMemberships() {
        return getMembershipsMap();
      }
      /**
       *
       *
       * <pre>
       * Indicates whether each member in the binding includes the member specified
       * in the request, either directly or indirectly. Each key identifies a member
       * in the binding, and each value indicates whether the member in the binding
       * includes the member in the request.
       * For example, suppose that a binding includes the following members:
       * * `user:alice&#64;example.com`
       * * `group:product-eng&#64;example.com`
       * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
       * member of the group `group:product-eng&#64;example.com`.
       * For the first member in the binding, the key is `user:alice&#64;example.com`,
       * and the `membership` field in the value is set to
       * `MEMBERSHIP_NOT_INCLUDED`.
       * For the second member in the binding, the key is
       * `group:product-eng&#64;example.com`, and the `membership` field in the value is
       * set to `MEMBERSHIP_INCLUDED`.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                  .AnnotatedMembership>
          getMembershipsMap() {
        return internalGetMemberships().getMap();
      }
      /**
       *
       *
       * <pre>
       * Indicates whether each member in the binding includes the member specified
       * in the request, either directly or indirectly. Each key identifies a member
       * in the binding, and each value indicates whether the member in the binding
       * includes the member in the request.
       * For example, suppose that a binding includes the following members:
       * * `user:alice&#64;example.com`
       * * `group:product-eng&#64;example.com`
       * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
       * member of the group `group:product-eng&#64;example.com`.
       * For the first member in the binding, the key is `user:alice&#64;example.com`,
       * and the `membership` field in the value is set to
       * `MEMBERSHIP_NOT_INCLUDED`.
       * For the second member in the binding, the key is
       * `group:product-eng&#64;example.com`, and the `membership` field in the value is
       * set to `MEMBERSHIP_INCLUDED`.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
       * </code>
       */
      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          getMembershipsOrDefault(
              java.lang.String key,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                      .AnnotatedMembership
                  defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                    .AnnotatedMembership>
            map = internalGetMemberships().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether each member in the binding includes the member specified
       * in the request, either directly or indirectly. Each key identifies a member
       * in the binding, and each value indicates whether the member in the binding
       * includes the member in the request.
       * For example, suppose that a binding includes the following members:
       * * `user:alice&#64;example.com`
       * * `group:product-eng&#64;example.com`
       * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
       * member of the group `group:product-eng&#64;example.com`.
       * For the first member in the binding, the key is `user:alice&#64;example.com`,
       * and the `membership` field in the value is set to
       * `MEMBERSHIP_NOT_INCLUDED`.
       * For the second member in the binding, the key is
       * `group:product-eng&#64;example.com`, and the `membership` field in the value is
       * set to `MEMBERSHIP_INCLUDED`.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
       * </code>
       */
      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
              .AnnotatedMembership
          getMembershipsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<
                java.lang.String,
                google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                    .AnnotatedMembership>
            map = internalGetMemberships().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearMemberships() {
        internalGetMutableMemberships().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether each member in the binding includes the member specified
       * in the request, either directly or indirectly. Each key identifies a member
       * in the binding, and each value indicates whether the member in the binding
       * includes the member in the request.
       * For example, suppose that a binding includes the following members:
       * * `user:alice&#64;example.com`
       * * `group:product-eng&#64;example.com`
       * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
       * member of the group `group:product-eng&#64;example.com`.
       * For the first member in the binding, the key is `user:alice&#64;example.com`,
       * and the `membership` field in the value is set to
       * `MEMBERSHIP_NOT_INCLUDED`.
       * For the second member in the binding, the key is
       * `group:product-eng&#64;example.com`, and the `membership` field in the value is
       * set to `MEMBERSHIP_INCLUDED`.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
       * </code>
       */
      public Builder removeMemberships(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableMemberships().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String,
              google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                  .AnnotatedMembership>
          getMutableMemberships() {
        return internalGetMutableMemberships().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Indicates whether each member in the binding includes the member specified
       * in the request, either directly or indirectly. Each key identifies a member
       * in the binding, and each value indicates whether the member in the binding
       * includes the member in the request.
       * For example, suppose that a binding includes the following members:
       * * `user:alice&#64;example.com`
       * * `group:product-eng&#64;example.com`
       * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
       * member of the group `group:product-eng&#64;example.com`.
       * For the first member in the binding, the key is `user:alice&#64;example.com`,
       * and the `membership` field in the value is set to
       * `MEMBERSHIP_NOT_INCLUDED`.
       * For the second member in the binding, the key is
       * `group:product-eng&#64;example.com`, and the `membership` field in the value is
       * set to `MEMBERSHIP_INCLUDED`.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
       * </code>
       */
      public Builder putMemberships(
          java.lang.String key,
          google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation.AnnotatedMembership
              value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }

        internalGetMutableMemberships().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates whether each member in the binding includes the member specified
       * in the request, either directly or indirectly. Each key identifies a member
       * in the binding, and each value indicates whether the member in the binding
       * includes the member in the request.
       * For example, suppose that a binding includes the following members:
       * * `user:alice&#64;example.com`
       * * `group:product-eng&#64;example.com`
       * You want to troubleshoot access for `user:bob&#64;example.com`. This user is a
       * member of the group `group:product-eng&#64;example.com`.
       * For the first member in the binding, the key is `user:alice&#64;example.com`,
       * and the `membership` field in the value is set to
       * `MEMBERSHIP_NOT_INCLUDED`.
       * For the second member in the binding, the key is
       * `group:product-eng&#64;example.com`, and the `membership` field in the value is
       * set to `MEMBERSHIP_INCLUDED`.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.policytroubleshooter.v1.BindingExplanation.AnnotatedMembership&gt; memberships = 5;
       * </code>
       */
      public Builder putAllMemberships(
          java.util.Map<
                  java.lang.String,
                  google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
                      .AnnotatedMembership>
              values) {
        internalGetMutableMemberships().getMutableMap().putAll(values);
        return this;
      }

      private int relevance_ = 0;
      /**
       *
       *
       * <pre>
       * The relevance of this binding to the overall determination for the entire
       * policy.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 6;</code>
       *
       * @return The enum numeric value on the wire for relevance.
       */
      @java.lang.Override
      public int getRelevanceValue() {
        return relevance_;
      }
      /**
       *
       *
       * <pre>
       * The relevance of this binding to the overall determination for the entire
       * policy.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 6;</code>
       *
       * @param value The enum numeric value on the wire for relevance to set.
       * @return This builder for chaining.
       */
      public Builder setRelevanceValue(int value) {

        relevance_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The relevance of this binding to the overall determination for the entire
       * policy.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 6;</code>
       *
       * @return The relevance.
       */
      @java.lang.Override
      public google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance getRelevance() {
        @SuppressWarnings("deprecation")
        google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance result =
            google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.valueOf(
                relevance_);
        return result == null
            ? google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The relevance of this binding to the overall determination for the entire
       * policy.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 6;</code>
       *
       * @param value The relevance to set.
       * @return This builder for chaining.
       */
      public Builder setRelevance(
          google.cloud.policytroubleshooter.v1.Explanations.HeuristicRelevance value) {
        if (value == null) {
          throw new NullPointerException();
        }

        relevance_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The relevance of this binding to the overall determination for the entire
       * policy.
       * </pre>
       *
       * <code>.google.cloud.policytroubleshooter.v1.HeuristicRelevance relevance = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRelevance() {

        relevance_ = 0;
        onChanged();
        return this;
      }

      private com.google.type.Expr condition_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Expr, com.google.type.Expr.Builder, com.google.type.ExprOrBuilder>
          conditionBuilder_;
      /**
       *
       *
       * <pre>
       * A condition expression that prevents access unless the expression evaluates
       * to `true`.
       * To learn about IAM Conditions, see
       * http://cloud.google.com/iam/help/conditions/overview.
       * </pre>
       *
       * <code>.google.type.Expr condition = 7;</code>
       *
       * @return Whether the condition field is set.
       */
      public boolean hasCondition() {
        return conditionBuilder_ != null || condition_ != null;
      }
      /**
       *
       *
       * <pre>
       * A condition expression that prevents access unless the expression evaluates
       * to `true`.
       * To learn about IAM Conditions, see
       * http://cloud.google.com/iam/help/conditions/overview.
       * </pre>
       *
       * <code>.google.type.Expr condition = 7;</code>
       *
       * @return The condition.
       */
      public com.google.type.Expr getCondition() {
        if (conditionBuilder_ == null) {
          return condition_ == null ? com.google.type.Expr.getDefaultInstance() : condition_;
        } else {
          return conditionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A condition expression that prevents access unless the expression evaluates
       * to `true`.
       * To learn about IAM Conditions, see
       * http://cloud.google.com/iam/help/conditions/overview.
       * </pre>
       *
       * <code>.google.type.Expr condition = 7;</code>
       */
      public Builder setCondition(com.google.type.Expr value) {
        if (conditionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          condition_ = value;
          onChanged();
        } else {
          conditionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition expression that prevents access unless the expression evaluates
       * to `true`.
       * To learn about IAM Conditions, see
       * http://cloud.google.com/iam/help/conditions/overview.
       * </pre>
       *
       * <code>.google.type.Expr condition = 7;</code>
       */
      public Builder setCondition(com.google.type.Expr.Builder builderForValue) {
        if (conditionBuilder_ == null) {
          condition_ = builderForValue.build();
          onChanged();
        } else {
          conditionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition expression that prevents access unless the expression evaluates
       * to `true`.
       * To learn about IAM Conditions, see
       * http://cloud.google.com/iam/help/conditions/overview.
       * </pre>
       *
       * <code>.google.type.Expr condition = 7;</code>
       */
      public Builder mergeCondition(com.google.type.Expr value) {
        if (conditionBuilder_ == null) {
          if (condition_ != null) {
            condition_ =
                com.google.type.Expr.newBuilder(condition_).mergeFrom(value).buildPartial();
          } else {
            condition_ = value;
          }
          onChanged();
        } else {
          conditionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition expression that prevents access unless the expression evaluates
       * to `true`.
       * To learn about IAM Conditions, see
       * http://cloud.google.com/iam/help/conditions/overview.
       * </pre>
       *
       * <code>.google.type.Expr condition = 7;</code>
       */
      public Builder clearCondition() {
        if (conditionBuilder_ == null) {
          condition_ = null;
          onChanged();
        } else {
          condition_ = null;
          conditionBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * A condition expression that prevents access unless the expression evaluates
       * to `true`.
       * To learn about IAM Conditions, see
       * http://cloud.google.com/iam/help/conditions/overview.
       * </pre>
       *
       * <code>.google.type.Expr condition = 7;</code>
       */
      public com.google.type.Expr.Builder getConditionBuilder() {

        onChanged();
        return getConditionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A condition expression that prevents access unless the expression evaluates
       * to `true`.
       * To learn about IAM Conditions, see
       * http://cloud.google.com/iam/help/conditions/overview.
       * </pre>
       *
       * <code>.google.type.Expr condition = 7;</code>
       */
      public com.google.type.ExprOrBuilder getConditionOrBuilder() {
        if (conditionBuilder_ != null) {
          return conditionBuilder_.getMessageOrBuilder();
        } else {
          return condition_ == null ? com.google.type.Expr.getDefaultInstance() : condition_;
        }
      }
      /**
       *
       *
       * <pre>
       * A condition expression that prevents access unless the expression evaluates
       * to `true`.
       * To learn about IAM Conditions, see
       * http://cloud.google.com/iam/help/conditions/overview.
       * </pre>
       *
       * <code>.google.type.Expr condition = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.type.Expr, com.google.type.Expr.Builder, com.google.type.ExprOrBuilder>
          getConditionFieldBuilder() {
        if (conditionBuilder_ == null) {
          conditionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.type.Expr,
                  com.google.type.Expr.Builder,
                  com.google.type.ExprOrBuilder>(getCondition(), getParentForChildren(), isClean());
          condition_ = null;
        }
        return conditionBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.policytroubleshooter.v1.BindingExplanation)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.policytroubleshooter.v1.BindingExplanation)
    private static final google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation();
    }

    public static google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BindingExplanation> PARSER =
        new com.google.protobuf.AbstractParser<BindingExplanation>() {
          @java.lang.Override
          public BindingExplanation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BindingExplanation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BindingExplanation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public google.cloud.policytroubleshooter.v1.Explanations.BindingExplanation
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_policytroubleshooter_v1_AccessTuple_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_policytroubleshooter_v1_AccessTuple_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_policytroubleshooter_v1_ExplainedPolicy_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_policytroubleshooter_v1_ExplainedPolicy_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_AnnotatedMembership_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_AnnotatedMembership_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
      internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_MembershipsEntry_descriptor;
  private static final com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_MembershipsEntry_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor getDescriptor() {
    return descriptor;
  }

  private static com.google.protobuf.Descriptors.FileDescriptor descriptor;

  static {
    java.lang.String[] descriptorData = {
      "\n7google/cloud/policytroubleshooter/v1/e"
          + "xplanations.proto\022$google.cloud.policytr"
          + "oubleshooter.v1\032\037google/api/field_behavi"
          + "or.proto\032\032google/iam/v1/policy.proto\032\026go"
          + "ogle/type/expr.proto\"_\n\013AccessTuple\022\026\n\tp"
          + "rincipal\030\001 \001(\tB\003\340A\002\022\037\n\022full_resource_nam"
          + "e\030\002 \001(\tB\003\340A\002\022\027\n\npermission\030\003 \001(\tB\003\340A\002\"\274\002"
          + "\n\017ExplainedPolicy\022A\n\006access\030\001 \001(\01621.goog"
          + "le.cloud.policytroubleshooter.v1.AccessS"
          + "tate\022\032\n\022full_resource_name\030\002 \001(\t\022%\n\006poli"
          + "cy\030\003 \001(\0132\025.google.iam.v1.Policy\022V\n\024bindi"
          + "ng_explanations\030\004 \003(\01328.google.cloud.pol"
          + "icytroubleshooter.v1.BindingExplanation\022"
          + "K\n\trelevance\030\005 \001(\01628.google.cloud.policy"
          + "troubleshooter.v1.HeuristicRelevance\"\203\t\n"
          + "\022BindingExplanation\022F\n\006access\030\001 \001(\01621.go"
          + "ogle.cloud.policytroubleshooter.v1.Acces"
          + "sStateB\003\340A\002\022\014\n\004role\030\002 \001(\t\022`\n\017role_permis"
          + "sion\030\003 \001(\0162G.google.cloud.policytroubles"
          + "hooter.v1.BindingExplanation.RolePermiss"
          + "ion\022[\n\031role_permission_relevance\030\004 \001(\01628"
          + ".google.cloud.policytroubleshooter.v1.He"
          + "uristicRelevance\022^\n\013memberships\030\005 \003(\0132I."
          + "google.cloud.policytroubleshooter.v1.Bin"
          + "dingExplanation.MembershipsEntry\022K\n\trele"
          + "vance\030\006 \001(\01628.google.cloud.policytrouble"
          + "shooter.v1.HeuristicRelevance\022$\n\tconditi"
          + "on\030\007 \001(\0132\021.google.type.Expr\032\273\001\n\023Annotate"
          + "dMembership\022W\n\nmembership\030\001 \001(\0162C.google"
          + ".cloud.policytroubleshooter.v1.BindingEx"
          + "planation.Membership\022K\n\trelevance\030\002 \001(\0162"
          + "8.google.cloud.policytroubleshooter.v1.H"
          + "euristicRelevance\032\200\001\n\020MembershipsEntry\022\013"
          + "\n\003key\030\001 \001(\t\022[\n\005value\030\002 \001(\0132L.google.clou"
          + "d.policytroubleshooter.v1.BindingExplana"
          + "tion.AnnotatedMembership:\0028\001\"\232\001\n\016RolePer"
          + "mission\022\037\n\033ROLE_PERMISSION_UNSPECIFIED\020\000"
          + "\022\034\n\030ROLE_PERMISSION_INCLUDED\020\001\022 \n\034ROLE_P"
          + "ERMISSION_NOT_INCLUDED\020\002\022\'\n#ROLE_PERMISS"
          + "ION_UNKNOWN_INFO_DENIED\020\003\"\246\001\n\nMembership"
          + "\022\032\n\026MEMBERSHIP_UNSPECIFIED\020\000\022\027\n\023MEMBERSH"
          + "IP_INCLUDED\020\001\022\033\n\027MEMBERSHIP_NOT_INCLUDED"
          + "\020\002\022\"\n\036MEMBERSHIP_UNKNOWN_INFO_DENIED\020\003\022\""
          + "\n\036MEMBERSHIP_UNKNOWN_UNSUPPORTED\020\004*{\n\013Ac"
          + "cessState\022\034\n\030ACCESS_STATE_UNSPECIFIED\020\000\022"
          + "\013\n\007GRANTED\020\001\022\017\n\013NOT_GRANTED\020\002\022\027\n\023UNKNOWN"
          + "_CONDITIONAL\020\003\022\027\n\023UNKNOWN_INFO_DENIED\020\004*"
          + "O\n\022HeuristicRelevance\022#\n\037HEURISTIC_RELEV"
          + "ANCE_UNSPECIFIED\020\000\022\n\n\006NORMAL\020\001\022\010\n\004HIGH\020\002"
          + "B\322\001ZXgoogle.golang.org/genproto/googleap"
          + "is/cloud/policytroubleshooter/v1;policyt"
          + "roubleshooter\252\002$Google.Cloud.PolicyTroub"
          + "leshooter.V1\312\002$Google\\Cloud\\PolicyTroubl"
          + "eshooter\\V1\352\002\'Google::Cloud::PolicyTroub"
          + "leshooter::V1b\006proto3"
    };
    descriptor =
        com.google.protobuf.Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(
            descriptorData,
            new com.google.protobuf.Descriptors.FileDescriptor[] {
              com.google.api.FieldBehaviorProto.getDescriptor(),
              com.google.iam.v1.PolicyProto.getDescriptor(),
              com.google.type.ExprProto.getDescriptor(),
            });
    internal_static_google_cloud_policytroubleshooter_v1_AccessTuple_descriptor =
        getDescriptor().getMessageTypes().get(0);
    internal_static_google_cloud_policytroubleshooter_v1_AccessTuple_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_policytroubleshooter_v1_AccessTuple_descriptor,
            new java.lang.String[] {
              "Principal", "FullResourceName", "Permission",
            });
    internal_static_google_cloud_policytroubleshooter_v1_ExplainedPolicy_descriptor =
        getDescriptor().getMessageTypes().get(1);
    internal_static_google_cloud_policytroubleshooter_v1_ExplainedPolicy_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_policytroubleshooter_v1_ExplainedPolicy_descriptor,
            new java.lang.String[] {
              "Access", "FullResourceName", "Policy", "BindingExplanations", "Relevance",
            });
    internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_descriptor =
        getDescriptor().getMessageTypes().get(2);
    internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_descriptor,
            new java.lang.String[] {
              "Access",
              "Role",
              "RolePermission",
              "RolePermissionRelevance",
              "Memberships",
              "Relevance",
              "Condition",
            });
    internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_AnnotatedMembership_descriptor =
        internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_descriptor
            .getNestedTypes()
            .get(0);
    internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_AnnotatedMembership_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_AnnotatedMembership_descriptor,
            new java.lang.String[] {
              "Membership", "Relevance",
            });
    internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_MembershipsEntry_descriptor =
        internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_descriptor
            .getNestedTypes()
            .get(1);
    internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_MembershipsEntry_fieldAccessorTable =
        new com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_google_cloud_policytroubleshooter_v1_BindingExplanation_MembershipsEntry_descriptor,
            new java.lang.String[] {
              "Key", "Value",
            });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.google.api.FieldBehaviorProto.fieldBehavior);
    com.google.protobuf.Descriptors.FileDescriptor.internalUpdateFileDescriptor(
        descriptor, registry);
    com.google.api.FieldBehaviorProto.getDescriptor();
    com.google.iam.v1.PolicyProto.getDescriptor();
    com.google.type.ExprProto.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
