/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Specifies the location of a transformation.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.TransformationLocation}
 */
public final class TransformationLocation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.TransformationLocation)
    TransformationLocationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransformationLocation.newBuilder() to construct.
  private TransformationLocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransformationLocation() {
    containerType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransformationLocation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_TransformationLocation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_TransformationLocation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.TransformationLocation.class,
            com.google.privacy.dlp.v2.TransformationLocation.Builder.class);
  }

  private int locationTypeCase_ = 0;
  private java.lang.Object locationType_;

  public enum LocationTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    FINDING_ID(1),
    RECORD_TRANSFORMATION(2),
    LOCATIONTYPE_NOT_SET(0);
    private final int value;

    private LocationTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LocationTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static LocationTypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return FINDING_ID;
        case 2:
          return RECORD_TRANSFORMATION;
        case 0:
          return LOCATIONTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public LocationTypeCase getLocationTypeCase() {
    return LocationTypeCase.forNumber(locationTypeCase_);
  }

  public static final int FINDING_ID_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * For infotype transformations, link to the corresponding findings ID so
   * that location information does not need to be duplicated. Each findings
   * ID correlates to an entry in the findings output table, this table only
   * gets created when users specify to save findings (add the save findings
   * action to the request).
   * </pre>
   *
   * <code>string finding_id = 1;</code>
   *
   * @return Whether the findingId field is set.
   */
  public boolean hasFindingId() {
    return locationTypeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * For infotype transformations, link to the corresponding findings ID so
   * that location information does not need to be duplicated. Each findings
   * ID correlates to an entry in the findings output table, this table only
   * gets created when users specify to save findings (add the save findings
   * action to the request).
   * </pre>
   *
   * <code>string finding_id = 1;</code>
   *
   * @return The findingId.
   */
  public java.lang.String getFindingId() {
    java.lang.Object ref = "";
    if (locationTypeCase_ == 1) {
      ref = locationType_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (locationTypeCase_ == 1) {
        locationType_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * For infotype transformations, link to the corresponding findings ID so
   * that location information does not need to be duplicated. Each findings
   * ID correlates to an entry in the findings output table, this table only
   * gets created when users specify to save findings (add the save findings
   * action to the request).
   * </pre>
   *
   * <code>string finding_id = 1;</code>
   *
   * @return The bytes for findingId.
   */
  public com.google.protobuf.ByteString getFindingIdBytes() {
    java.lang.Object ref = "";
    if (locationTypeCase_ == 1) {
      ref = locationType_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (locationTypeCase_ == 1) {
        locationType_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECORD_TRANSFORMATION_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * For record transformations, provide a field and container information.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordTransformation record_transformation = 2;</code>
   *
   * @return Whether the recordTransformation field is set.
   */
  @java.lang.Override
  public boolean hasRecordTransformation() {
    return locationTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * For record transformations, provide a field and container information.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordTransformation record_transformation = 2;</code>
   *
   * @return The recordTransformation.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordTransformation getRecordTransformation() {
    if (locationTypeCase_ == 2) {
      return (com.google.privacy.dlp.v2.RecordTransformation) locationType_;
    }
    return com.google.privacy.dlp.v2.RecordTransformation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * For record transformations, provide a field and container information.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordTransformation record_transformation = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordTransformationOrBuilder
      getRecordTransformationOrBuilder() {
    if (locationTypeCase_ == 2) {
      return (com.google.privacy.dlp.v2.RecordTransformation) locationType_;
    }
    return com.google.privacy.dlp.v2.RecordTransformation.getDefaultInstance();
  }

  public static final int CONTAINER_TYPE_FIELD_NUMBER = 3;
  private int containerType_;
  /**
   *
   *
   * <pre>
   * Information about the functionality of the container where this finding
   * occurred, if available.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationContainerType container_type = 3;</code>
   *
   * @return The enum numeric value on the wire for containerType.
   */
  @java.lang.Override
  public int getContainerTypeValue() {
    return containerType_;
  }
  /**
   *
   *
   * <pre>
   * Information about the functionality of the container where this finding
   * occurred, if available.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationContainerType container_type = 3;</code>
   *
   * @return The containerType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationContainerType getContainerType() {
    @SuppressWarnings("deprecation")
    com.google.privacy.dlp.v2.TransformationContainerType result =
        com.google.privacy.dlp.v2.TransformationContainerType.valueOf(containerType_);
    return result == null
        ? com.google.privacy.dlp.v2.TransformationContainerType.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (locationTypeCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, locationType_);
    }
    if (locationTypeCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.RecordTransformation) locationType_);
    }
    if (containerType_
        != com.google.privacy.dlp.v2.TransformationContainerType.TRANSFORM_UNKNOWN_CONTAINER
            .getNumber()) {
      output.writeEnum(3, containerType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (locationTypeCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, locationType_);
    }
    if (locationTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.RecordTransformation) locationType_);
    }
    if (containerType_
        != com.google.privacy.dlp.v2.TransformationContainerType.TRANSFORM_UNKNOWN_CONTAINER
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, containerType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.TransformationLocation)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.TransformationLocation other =
        (com.google.privacy.dlp.v2.TransformationLocation) obj;

    if (containerType_ != other.containerType_) return false;
    if (!getLocationTypeCase().equals(other.getLocationTypeCase())) return false;
    switch (locationTypeCase_) {
      case 1:
        if (!getFindingId().equals(other.getFindingId())) return false;
        break;
      case 2:
        if (!getRecordTransformation().equals(other.getRecordTransformation())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONTAINER_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + containerType_;
    switch (locationTypeCase_) {
      case 1:
        hash = (37 * hash) + FINDING_ID_FIELD_NUMBER;
        hash = (53 * hash) + getFindingId().hashCode();
        break;
      case 2:
        hash = (37 * hash) + RECORD_TRANSFORMATION_FIELD_NUMBER;
        hash = (53 * hash) + getRecordTransformation().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.TransformationLocation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationLocation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationLocation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationLocation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationLocation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationLocation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationLocation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationLocation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationLocation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationLocation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationLocation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationLocation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.TransformationLocation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies the location of a transformation.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.TransformationLocation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.TransformationLocation)
      com.google.privacy.dlp.v2.TransformationLocationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationLocation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationLocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.TransformationLocation.class,
              com.google.privacy.dlp.v2.TransformationLocation.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.TransformationLocation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (recordTransformationBuilder_ != null) {
        recordTransformationBuilder_.clear();
      }
      containerType_ = 0;

      locationTypeCase_ = 0;
      locationType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationLocation_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationLocation getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.TransformationLocation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationLocation build() {
      com.google.privacy.dlp.v2.TransformationLocation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationLocation buildPartial() {
      com.google.privacy.dlp.v2.TransformationLocation result =
          new com.google.privacy.dlp.v2.TransformationLocation(this);
      if (locationTypeCase_ == 1) {
        result.locationType_ = locationType_;
      }
      if (locationTypeCase_ == 2) {
        if (recordTransformationBuilder_ == null) {
          result.locationType_ = locationType_;
        } else {
          result.locationType_ = recordTransformationBuilder_.build();
        }
      }
      result.containerType_ = containerType_;
      result.locationTypeCase_ = locationTypeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.TransformationLocation) {
        return mergeFrom((com.google.privacy.dlp.v2.TransformationLocation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.TransformationLocation other) {
      if (other == com.google.privacy.dlp.v2.TransformationLocation.getDefaultInstance())
        return this;
      if (other.containerType_ != 0) {
        setContainerTypeValue(other.getContainerTypeValue());
      }
      switch (other.getLocationTypeCase()) {
        case FINDING_ID:
          {
            locationTypeCase_ = 1;
            locationType_ = other.locationType_;
            onChanged();
            break;
          }
        case RECORD_TRANSFORMATION:
          {
            mergeRecordTransformation(other.getRecordTransformation());
            break;
          }
        case LOCATIONTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                locationTypeCase_ = 1;
                locationType_ = s;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getRecordTransformationFieldBuilder().getBuilder(), extensionRegistry);
                locationTypeCase_ = 2;
                break;
              } // case 18
            case 24:
              {
                containerType_ = input.readEnum();

                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int locationTypeCase_ = 0;
    private java.lang.Object locationType_;

    public LocationTypeCase getLocationTypeCase() {
      return LocationTypeCase.forNumber(locationTypeCase_);
    }

    public Builder clearLocationType() {
      locationTypeCase_ = 0;
      locationType_ = null;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * For infotype transformations, link to the corresponding findings ID so
     * that location information does not need to be duplicated. Each findings
     * ID correlates to an entry in the findings output table, this table only
     * gets created when users specify to save findings (add the save findings
     * action to the request).
     * </pre>
     *
     * <code>string finding_id = 1;</code>
     *
     * @return Whether the findingId field is set.
     */
    @java.lang.Override
    public boolean hasFindingId() {
      return locationTypeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * For infotype transformations, link to the corresponding findings ID so
     * that location information does not need to be duplicated. Each findings
     * ID correlates to an entry in the findings output table, this table only
     * gets created when users specify to save findings (add the save findings
     * action to the request).
     * </pre>
     *
     * <code>string finding_id = 1;</code>
     *
     * @return The findingId.
     */
    @java.lang.Override
    public java.lang.String getFindingId() {
      java.lang.Object ref = "";
      if (locationTypeCase_ == 1) {
        ref = locationType_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (locationTypeCase_ == 1) {
          locationType_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For infotype transformations, link to the corresponding findings ID so
     * that location information does not need to be duplicated. Each findings
     * ID correlates to an entry in the findings output table, this table only
     * gets created when users specify to save findings (add the save findings
     * action to the request).
     * </pre>
     *
     * <code>string finding_id = 1;</code>
     *
     * @return The bytes for findingId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFindingIdBytes() {
      java.lang.Object ref = "";
      if (locationTypeCase_ == 1) {
        ref = locationType_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (locationTypeCase_ == 1) {
          locationType_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * For infotype transformations, link to the corresponding findings ID so
     * that location information does not need to be duplicated. Each findings
     * ID correlates to an entry in the findings output table, this table only
     * gets created when users specify to save findings (add the save findings
     * action to the request).
     * </pre>
     *
     * <code>string finding_id = 1;</code>
     *
     * @param value The findingId to set.
     * @return This builder for chaining.
     */
    public Builder setFindingId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationTypeCase_ = 1;
      locationType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For infotype transformations, link to the corresponding findings ID so
     * that location information does not need to be duplicated. Each findings
     * ID correlates to an entry in the findings output table, this table only
     * gets created when users specify to save findings (add the save findings
     * action to the request).
     * </pre>
     *
     * <code>string finding_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFindingId() {
      if (locationTypeCase_ == 1) {
        locationTypeCase_ = 0;
        locationType_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For infotype transformations, link to the corresponding findings ID so
     * that location information does not need to be duplicated. Each findings
     * ID correlates to an entry in the findings output table, this table only
     * gets created when users specify to save findings (add the save findings
     * action to the request).
     * </pre>
     *
     * <code>string finding_id = 1;</code>
     *
     * @param value The bytes for findingId to set.
     * @return This builder for chaining.
     */
    public Builder setFindingIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationTypeCase_ = 1;
      locationType_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RecordTransformation,
            com.google.privacy.dlp.v2.RecordTransformation.Builder,
            com.google.privacy.dlp.v2.RecordTransformationOrBuilder>
        recordTransformationBuilder_;
    /**
     *
     *
     * <pre>
     * For record transformations, provide a field and container information.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformation record_transformation = 2;</code>
     *
     * @return Whether the recordTransformation field is set.
     */
    @java.lang.Override
    public boolean hasRecordTransformation() {
      return locationTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * For record transformations, provide a field and container information.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformation record_transformation = 2;</code>
     *
     * @return The recordTransformation.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordTransformation getRecordTransformation() {
      if (recordTransformationBuilder_ == null) {
        if (locationTypeCase_ == 2) {
          return (com.google.privacy.dlp.v2.RecordTransformation) locationType_;
        }
        return com.google.privacy.dlp.v2.RecordTransformation.getDefaultInstance();
      } else {
        if (locationTypeCase_ == 2) {
          return recordTransformationBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.RecordTransformation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * For record transformations, provide a field and container information.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformation record_transformation = 2;</code>
     */
    public Builder setRecordTransformation(com.google.privacy.dlp.v2.RecordTransformation value) {
      if (recordTransformationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        locationType_ = value;
        onChanged();
      } else {
        recordTransformationBuilder_.setMessage(value);
      }
      locationTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For record transformations, provide a field and container information.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformation record_transformation = 2;</code>
     */
    public Builder setRecordTransformation(
        com.google.privacy.dlp.v2.RecordTransformation.Builder builderForValue) {
      if (recordTransformationBuilder_ == null) {
        locationType_ = builderForValue.build();
        onChanged();
      } else {
        recordTransformationBuilder_.setMessage(builderForValue.build());
      }
      locationTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For record transformations, provide a field and container information.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformation record_transformation = 2;</code>
     */
    public Builder mergeRecordTransformation(com.google.privacy.dlp.v2.RecordTransformation value) {
      if (recordTransformationBuilder_ == null) {
        if (locationTypeCase_ == 2
            && locationType_
                != com.google.privacy.dlp.v2.RecordTransformation.getDefaultInstance()) {
          locationType_ =
              com.google.privacy.dlp.v2.RecordTransformation.newBuilder(
                      (com.google.privacy.dlp.v2.RecordTransformation) locationType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          locationType_ = value;
        }
        onChanged();
      } else {
        if (locationTypeCase_ == 2) {
          recordTransformationBuilder_.mergeFrom(value);
        } else {
          recordTransformationBuilder_.setMessage(value);
        }
      }
      locationTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * For record transformations, provide a field and container information.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformation record_transformation = 2;</code>
     */
    public Builder clearRecordTransformation() {
      if (recordTransformationBuilder_ == null) {
        if (locationTypeCase_ == 2) {
          locationTypeCase_ = 0;
          locationType_ = null;
          onChanged();
        }
      } else {
        if (locationTypeCase_ == 2) {
          locationTypeCase_ = 0;
          locationType_ = null;
        }
        recordTransformationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For record transformations, provide a field and container information.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformation record_transformation = 2;</code>
     */
    public com.google.privacy.dlp.v2.RecordTransformation.Builder getRecordTransformationBuilder() {
      return getRecordTransformationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * For record transformations, provide a field and container information.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformation record_transformation = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordTransformationOrBuilder
        getRecordTransformationOrBuilder() {
      if ((locationTypeCase_ == 2) && (recordTransformationBuilder_ != null)) {
        return recordTransformationBuilder_.getMessageOrBuilder();
      } else {
        if (locationTypeCase_ == 2) {
          return (com.google.privacy.dlp.v2.RecordTransformation) locationType_;
        }
        return com.google.privacy.dlp.v2.RecordTransformation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * For record transformations, provide a field and container information.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformation record_transformation = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RecordTransformation,
            com.google.privacy.dlp.v2.RecordTransformation.Builder,
            com.google.privacy.dlp.v2.RecordTransformationOrBuilder>
        getRecordTransformationFieldBuilder() {
      if (recordTransformationBuilder_ == null) {
        if (!(locationTypeCase_ == 2)) {
          locationType_ = com.google.privacy.dlp.v2.RecordTransformation.getDefaultInstance();
        }
        recordTransformationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.RecordTransformation,
                com.google.privacy.dlp.v2.RecordTransformation.Builder,
                com.google.privacy.dlp.v2.RecordTransformationOrBuilder>(
                (com.google.privacy.dlp.v2.RecordTransformation) locationType_,
                getParentForChildren(),
                isClean());
        locationType_ = null;
      }
      locationTypeCase_ = 2;
      onChanged();
      ;
      return recordTransformationBuilder_;
    }

    private int containerType_ = 0;
    /**
     *
     *
     * <pre>
     * Information about the functionality of the container where this finding
     * occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationContainerType container_type = 3;</code>
     *
     * @return The enum numeric value on the wire for containerType.
     */
    @java.lang.Override
    public int getContainerTypeValue() {
      return containerType_;
    }
    /**
     *
     *
     * <pre>
     * Information about the functionality of the container where this finding
     * occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationContainerType container_type = 3;</code>
     *
     * @param value The enum numeric value on the wire for containerType to set.
     * @return This builder for chaining.
     */
    public Builder setContainerTypeValue(int value) {

      containerType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the functionality of the container where this finding
     * occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationContainerType container_type = 3;</code>
     *
     * @return The containerType.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationContainerType getContainerType() {
      @SuppressWarnings("deprecation")
      com.google.privacy.dlp.v2.TransformationContainerType result =
          com.google.privacy.dlp.v2.TransformationContainerType.valueOf(containerType_);
      return result == null
          ? com.google.privacy.dlp.v2.TransformationContainerType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Information about the functionality of the container where this finding
     * occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationContainerType container_type = 3;</code>
     *
     * @param value The containerType to set.
     * @return This builder for chaining.
     */
    public Builder setContainerType(com.google.privacy.dlp.v2.TransformationContainerType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      containerType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the functionality of the container where this finding
     * occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationContainerType container_type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContainerType() {

      containerType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.TransformationLocation)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.TransformationLocation)
  private static final com.google.privacy.dlp.v2.TransformationLocation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.TransformationLocation();
  }

  public static com.google.privacy.dlp.v2.TransformationLocation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransformationLocation> PARSER =
      new com.google.protobuf.AbstractParser<TransformationLocation>() {
        @java.lang.Override
        public TransformationLocation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransformationLocation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransformationLocation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationLocation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
