/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * How to handle transformation errors during de-identification. A
 * transformation error occurs when the requested transformation is incompatible
 * with the data. For example, trying to de-identify an IP address using a
 * `DateShift` transformation would result in a transformation error, since date
 * info cannot be extracted from an IP address.
 * Information about any incompatible transformations, and how they were
 * handled, is returned in the response as part of the
 * `TransformationOverviews`.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.TransformationErrorHandling}
 */
public final class TransformationErrorHandling extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.TransformationErrorHandling)
    TransformationErrorHandlingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransformationErrorHandling.newBuilder() to construct.
  private TransformationErrorHandling(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransformationErrorHandling() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransformationErrorHandling();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.TransformationErrorHandling.class,
            com.google.privacy.dlp.v2.TransformationErrorHandling.Builder.class);
  }

  public interface ThrowErrorOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.TransformationErrorHandling.ThrowError)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Throw an error and fail the request when a transformation error occurs.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.TransformationErrorHandling.ThrowError}
   */
  public static final class ThrowError extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.TransformationErrorHandling.ThrowError)
      ThrowErrorOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ThrowError.newBuilder() to construct.
    private ThrowError(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ThrowError() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ThrowError();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_ThrowError_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_ThrowError_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.class,
              com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError other =
          (com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Throw an error and fail the request when a transformation error occurs.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.TransformationErrorHandling.ThrowError}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.TransformationErrorHandling.ThrowError)
        com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowErrorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_ThrowError_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_ThrowError_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.class,
                com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.Builder.class);
      }

      // Construct using
      // com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_ThrowError_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError build() {
        com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError buildPartial() {
        com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError result =
            new com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError) {
          return mergeFrom(
              (com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError other) {
        if (other
            == com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.TransformationErrorHandling.ThrowError)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.TransformationErrorHandling.ThrowError)
    private static final com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError();
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ThrowError> PARSER =
        new com.google.protobuf.AbstractParser<ThrowError>() {
          @java.lang.Override
          public ThrowError parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ThrowError> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ThrowError> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface LeaveUntransformedOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Skips the data without modifying it if the requested transformation would
   * cause an error. For example, if a `DateShift` transformation were applied
   * an an IP address, this mode would leave the IP address unchanged in the
   * response.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed}
   */
  public static final class LeaveUntransformed extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed)
      LeaveUntransformedOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use LeaveUntransformed.newBuilder() to construct.
    private LeaveUntransformed(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private LeaveUntransformed() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new LeaveUntransformed();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_LeaveUntransformed_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_LeaveUntransformed_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed.class,
              com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed.Builder
                  .class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed other =
          (com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Skips the data without modifying it if the requested transformation would
     * cause an error. For example, if a `DateShift` transformation were applied
     * an an IP address, this mode would leave the IP address unchanged in the
     * response.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed)
        com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformedOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_LeaveUntransformed_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_LeaveUntransformed_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed.class,
                com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed.Builder
                    .class);
      }

      // Construct using
      // com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_LeaveUntransformed_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed build() {
        com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
          buildPartial() {
        com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed result =
            new com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed) {
          return mergeFrom(
              (com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed other) {
        if (other
            == com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed)
    private static final com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed();
    }

    public static com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LeaveUntransformed> PARSER =
        new com.google.protobuf.AbstractParser<LeaveUntransformed>() {
          @java.lang.Override
          public LeaveUntransformed parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<LeaveUntransformed> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LeaveUntransformed> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int modeCase_ = 0;
  private java.lang.Object mode_;

  public enum ModeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    THROW_ERROR(1),
    LEAVE_UNTRANSFORMED(2),
    MODE_NOT_SET(0);
    private final int value;

    private ModeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ModeCase forNumber(int value) {
      switch (value) {
        case 1:
          return THROW_ERROR;
        case 2:
          return LEAVE_UNTRANSFORMED;
        case 0:
          return MODE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ModeCase getModeCase() {
    return ModeCase.forNumber(modeCase_);
  }

  public static final int THROW_ERROR_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Throw an error
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError throw_error = 1;</code>
   *
   * @return Whether the throwError field is set.
   */
  @java.lang.Override
  public boolean hasThrowError() {
    return modeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Throw an error
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError throw_error = 1;</code>
   *
   * @return The throwError.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError getThrowError() {
    if (modeCase_ == 1) {
      return (com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError) mode_;
    }
    return com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Throw an error
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError throw_error = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowErrorOrBuilder
      getThrowErrorOrBuilder() {
    if (modeCase_ == 1) {
      return (com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError) mode_;
    }
    return com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.getDefaultInstance();
  }

  public static final int LEAVE_UNTRANSFORMED_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Ignore errors
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed leave_untransformed = 2;
   * </code>
   *
   * @return Whether the leaveUntransformed field is set.
   */
  @java.lang.Override
  public boolean hasLeaveUntransformed() {
    return modeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Ignore errors
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed leave_untransformed = 2;
   * </code>
   *
   * @return The leaveUntransformed.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
      getLeaveUntransformed() {
    if (modeCase_ == 2) {
      return (com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed) mode_;
    }
    return com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Ignore errors
   * </pre>
   *
   * <code>
   * .google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed leave_untransformed = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformedOrBuilder
      getLeaveUntransformedOrBuilder() {
    if (modeCase_ == 2) {
      return (com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed) mode_;
    }
    return com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (modeCase_ == 1) {
      output.writeMessage(
          1, (com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError) mode_);
    }
    if (modeCase_ == 2) {
      output.writeMessage(
          2, (com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed) mode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (modeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError) mode_);
    }
    if (modeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed) mode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.TransformationErrorHandling)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.TransformationErrorHandling other =
        (com.google.privacy.dlp.v2.TransformationErrorHandling) obj;

    if (!getModeCase().equals(other.getModeCase())) return false;
    switch (modeCase_) {
      case 1:
        if (!getThrowError().equals(other.getThrowError())) return false;
        break;
      case 2:
        if (!getLeaveUntransformed().equals(other.getLeaveUntransformed())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (modeCase_) {
      case 1:
        hash = (37 * hash) + THROW_ERROR_FIELD_NUMBER;
        hash = (53 * hash) + getThrowError().hashCode();
        break;
      case 2:
        hash = (37 * hash) + LEAVE_UNTRANSFORMED_FIELD_NUMBER;
        hash = (53 * hash) + getLeaveUntransformed().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.privacy.dlp.v2.TransformationErrorHandling prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * How to handle transformation errors during de-identification. A
   * transformation error occurs when the requested transformation is incompatible
   * with the data. For example, trying to de-identify an IP address using a
   * `DateShift` transformation would result in a transformation error, since date
   * info cannot be extracted from an IP address.
   * Information about any incompatible transformations, and how they were
   * handled, is returned in the response as part of the
   * `TransformationOverviews`.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.TransformationErrorHandling}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.TransformationErrorHandling)
      com.google.privacy.dlp.v2.TransformationErrorHandlingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.TransformationErrorHandling.class,
              com.google.privacy.dlp.v2.TransformationErrorHandling.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.TransformationErrorHandling.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (throwErrorBuilder_ != null) {
        throwErrorBuilder_.clear();
      }
      if (leaveUntransformedBuilder_ != null) {
        leaveUntransformedBuilder_.clear();
      }
      modeCase_ = 0;
      mode_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationErrorHandling_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationErrorHandling getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.TransformationErrorHandling.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationErrorHandling build() {
      com.google.privacy.dlp.v2.TransformationErrorHandling result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationErrorHandling buildPartial() {
      com.google.privacy.dlp.v2.TransformationErrorHandling result =
          new com.google.privacy.dlp.v2.TransformationErrorHandling(this);
      if (modeCase_ == 1) {
        if (throwErrorBuilder_ == null) {
          result.mode_ = mode_;
        } else {
          result.mode_ = throwErrorBuilder_.build();
        }
      }
      if (modeCase_ == 2) {
        if (leaveUntransformedBuilder_ == null) {
          result.mode_ = mode_;
        } else {
          result.mode_ = leaveUntransformedBuilder_.build();
        }
      }
      result.modeCase_ = modeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.TransformationErrorHandling) {
        return mergeFrom((com.google.privacy.dlp.v2.TransformationErrorHandling) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.TransformationErrorHandling other) {
      if (other == com.google.privacy.dlp.v2.TransformationErrorHandling.getDefaultInstance())
        return this;
      switch (other.getModeCase()) {
        case THROW_ERROR:
          {
            mergeThrowError(other.getThrowError());
            break;
          }
        case LEAVE_UNTRANSFORMED:
          {
            mergeLeaveUntransformed(other.getLeaveUntransformed());
            break;
          }
        case MODE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getThrowErrorFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getLeaveUntransformedFieldBuilder().getBuilder(), extensionRegistry);
                modeCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int modeCase_ = 0;
    private java.lang.Object mode_;

    public ModeCase getModeCase() {
      return ModeCase.forNumber(modeCase_);
    }

    public Builder clearMode() {
      modeCase_ = 0;
      mode_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError,
            com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.Builder,
            com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowErrorOrBuilder>
        throwErrorBuilder_;
    /**
     *
     *
     * <pre>
     * Throw an error
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError throw_error = 1;</code>
     *
     * @return Whether the throwError field is set.
     */
    @java.lang.Override
    public boolean hasThrowError() {
      return modeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Throw an error
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError throw_error = 1;</code>
     *
     * @return The throwError.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError getThrowError() {
      if (throwErrorBuilder_ == null) {
        if (modeCase_ == 1) {
          return (com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError) mode_;
        }
        return com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
            .getDefaultInstance();
      } else {
        if (modeCase_ == 1) {
          return throwErrorBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Throw an error
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError throw_error = 1;</code>
     */
    public Builder setThrowError(
        com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError value) {
      if (throwErrorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        throwErrorBuilder_.setMessage(value);
      }
      modeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Throw an error
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError throw_error = 1;</code>
     */
    public Builder setThrowError(
        com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.Builder builderForValue) {
      if (throwErrorBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        throwErrorBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Throw an error
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError throw_error = 1;</code>
     */
    public Builder mergeThrowError(
        com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError value) {
      if (throwErrorBuilder_ == null) {
        if (modeCase_ == 1
            && mode_
                != com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
                    .getDefaultInstance()) {
          mode_ =
              com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.newBuilder(
                      (com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError) mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 1) {
          throwErrorBuilder_.mergeFrom(value);
        } else {
          throwErrorBuilder_.setMessage(value);
        }
      }
      modeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Throw an error
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError throw_error = 1;</code>
     */
    public Builder clearThrowError() {
      if (throwErrorBuilder_ == null) {
        if (modeCase_ == 1) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 1) {
          modeCase_ = 0;
          mode_ = null;
        }
        throwErrorBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Throw an error
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError throw_error = 1;</code>
     */
    public com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.Builder
        getThrowErrorBuilder() {
      return getThrowErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Throw an error
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError throw_error = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowErrorOrBuilder
        getThrowErrorOrBuilder() {
      if ((modeCase_ == 1) && (throwErrorBuilder_ != null)) {
        return throwErrorBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 1) {
          return (com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError) mode_;
        }
        return com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Throw an error
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError throw_error = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError,
            com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.Builder,
            com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowErrorOrBuilder>
        getThrowErrorFieldBuilder() {
      if (throwErrorBuilder_ == null) {
        if (!(modeCase_ == 1)) {
          mode_ =
              com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.getDefaultInstance();
        }
        throwErrorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError,
                com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError.Builder,
                com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowErrorOrBuilder>(
                (com.google.privacy.dlp.v2.TransformationErrorHandling.ThrowError) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 1;
      onChanged();
      ;
      return throwErrorBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed,
            com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed.Builder,
            com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformedOrBuilder>
        leaveUntransformedBuilder_;
    /**
     *
     *
     * <pre>
     * Ignore errors
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed leave_untransformed = 2;
     * </code>
     *
     * @return Whether the leaveUntransformed field is set.
     */
    @java.lang.Override
    public boolean hasLeaveUntransformed() {
      return modeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Ignore errors
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed leave_untransformed = 2;
     * </code>
     *
     * @return The leaveUntransformed.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
        getLeaveUntransformed() {
      if (leaveUntransformedBuilder_ == null) {
        if (modeCase_ == 2) {
          return (com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed) mode_;
        }
        return com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
            .getDefaultInstance();
      } else {
        if (modeCase_ == 2) {
          return leaveUntransformedBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Ignore errors
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed leave_untransformed = 2;
     * </code>
     */
    public Builder setLeaveUntransformed(
        com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed value) {
      if (leaveUntransformedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mode_ = value;
        onChanged();
      } else {
        leaveUntransformedBuilder_.setMessage(value);
      }
      modeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ignore errors
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed leave_untransformed = 2;
     * </code>
     */
    public Builder setLeaveUntransformed(
        com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed.Builder
            builderForValue) {
      if (leaveUntransformedBuilder_ == null) {
        mode_ = builderForValue.build();
        onChanged();
      } else {
        leaveUntransformedBuilder_.setMessage(builderForValue.build());
      }
      modeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ignore errors
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed leave_untransformed = 2;
     * </code>
     */
    public Builder mergeLeaveUntransformed(
        com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed value) {
      if (leaveUntransformedBuilder_ == null) {
        if (modeCase_ == 2
            && mode_
                != com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
                    .getDefaultInstance()) {
          mode_ =
              com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed.newBuilder(
                      (com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed)
                          mode_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mode_ = value;
        }
        onChanged();
      } else {
        if (modeCase_ == 2) {
          leaveUntransformedBuilder_.mergeFrom(value);
        } else {
          leaveUntransformedBuilder_.setMessage(value);
        }
      }
      modeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ignore errors
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed leave_untransformed = 2;
     * </code>
     */
    public Builder clearLeaveUntransformed() {
      if (leaveUntransformedBuilder_ == null) {
        if (modeCase_ == 2) {
          modeCase_ = 0;
          mode_ = null;
          onChanged();
        }
      } else {
        if (modeCase_ == 2) {
          modeCase_ = 0;
          mode_ = null;
        }
        leaveUntransformedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Ignore errors
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed leave_untransformed = 2;
     * </code>
     */
    public com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed.Builder
        getLeaveUntransformedBuilder() {
      return getLeaveUntransformedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Ignore errors
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed leave_untransformed = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformedOrBuilder
        getLeaveUntransformedOrBuilder() {
      if ((modeCase_ == 2) && (leaveUntransformedBuilder_ != null)) {
        return leaveUntransformedBuilder_.getMessageOrBuilder();
      } else {
        if (modeCase_ == 2) {
          return (com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed) mode_;
        }
        return com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Ignore errors
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed leave_untransformed = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed,
            com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed.Builder,
            com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformedOrBuilder>
        getLeaveUntransformedFieldBuilder() {
      if (leaveUntransformedBuilder_ == null) {
        if (!(modeCase_ == 2)) {
          mode_ =
              com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed
                  .getDefaultInstance();
        }
        leaveUntransformedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed,
                com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed.Builder,
                com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformedOrBuilder>(
                (com.google.privacy.dlp.v2.TransformationErrorHandling.LeaveUntransformed) mode_,
                getParentForChildren(),
                isClean());
        mode_ = null;
      }
      modeCase_ = 2;
      onChanged();
      ;
      return leaveUntransformedBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.TransformationErrorHandling)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.TransformationErrorHandling)
  private static final com.google.privacy.dlp.v2.TransformationErrorHandling DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.TransformationErrorHandling();
  }

  public static com.google.privacy.dlp.v2.TransformationErrorHandling getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransformationErrorHandling> PARSER =
      new com.google.protobuf.AbstractParser<TransformationErrorHandling>() {
        @java.lang.Override
        public TransformationErrorHandling parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransformationErrorHandling> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransformationErrorHandling> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationErrorHandling getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
