/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Details about a single transformation. This object contains a description of
 * the transformation, information about whether the transformation was
 * successfully applied, and the precise location where the transformation
 * occurred. These details are stored in a user-specified BigQuery table.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.TransformationDetails}
 */
public final class TransformationDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.TransformationDetails)
    TransformationDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransformationDetails.newBuilder() to construct.
  private TransformationDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransformationDetails() {
    resourceName_ = "";
    containerName_ = "";
    transformation_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransformationDetails();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_TransformationDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_TransformationDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.TransformationDetails.class,
            com.google.privacy.dlp.v2.TransformationDetails.Builder.class);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object resourceName_;
  /**
   *
   *
   * <pre>
   * The name of the job that completed the transformation.
   * </pre>
   *
   * <code>string resource_name = 1;</code>
   *
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the job that completed the transformation.
   * </pre>
   *
   * <code>string resource_name = 1;</code>
   *
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTAINER_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object containerName_;
  /**
   *
   *
   * <pre>
   * The top level name of the container where the transformation is located
   * (this will be the source file name or table name).
   * </pre>
   *
   * <code>string container_name = 2;</code>
   *
   * @return The containerName.
   */
  @java.lang.Override
  public java.lang.String getContainerName() {
    java.lang.Object ref = containerName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      containerName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The top level name of the container where the transformation is located
   * (this will be the source file name or table name).
   * </pre>
   *
   * <code>string container_name = 2;</code>
   *
   * @return The bytes for containerName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContainerNameBytes() {
    java.lang.Object ref = containerName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      containerName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRANSFORMATION_FIELD_NUMBER = 3;
  private java.util.List<com.google.privacy.dlp.v2.TransformationDescription> transformation_;
  /**
   *
   *
   * <pre>
   * Description of transformation. This would only contain more than one
   * element if there were multiple matching transformations and which one to
   * apply was ambiguous. Not set for states that contain no transformation,
   * currently only state that contains no transformation is
   * TransformationResultStateType.METADATA_UNRETRIEVABLE.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.TransformationDescription>
      getTransformationList() {
    return transformation_;
  }
  /**
   *
   *
   * <pre>
   * Description of transformation. This would only contain more than one
   * element if there were multiple matching transformations and which one to
   * apply was ambiguous. Not set for states that contain no transformation,
   * currently only state that contains no transformation is
   * TransformationResultStateType.METADATA_UNRETRIEVABLE.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.TransformationDescriptionOrBuilder>
      getTransformationOrBuilderList() {
    return transformation_;
  }
  /**
   *
   *
   * <pre>
   * Description of transformation. This would only contain more than one
   * element if there were multiple matching transformations and which one to
   * apply was ambiguous. Not set for states that contain no transformation,
   * currently only state that contains no transformation is
   * TransformationResultStateType.METADATA_UNRETRIEVABLE.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
   */
  @java.lang.Override
  public int getTransformationCount() {
    return transformation_.size();
  }
  /**
   *
   *
   * <pre>
   * Description of transformation. This would only contain more than one
   * element if there were multiple matching transformations and which one to
   * apply was ambiguous. Not set for states that contain no transformation,
   * currently only state that contains no transformation is
   * TransformationResultStateType.METADATA_UNRETRIEVABLE.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationDescription getTransformation(int index) {
    return transformation_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Description of transformation. This would only contain more than one
   * element if there were multiple matching transformations and which one to
   * apply was ambiguous. Not set for states that contain no transformation,
   * currently only state that contains no transformation is
   * TransformationResultStateType.METADATA_UNRETRIEVABLE.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationDescriptionOrBuilder getTransformationOrBuilder(
      int index) {
    return transformation_.get(index);
  }

  public static final int STATUS_DETAILS_FIELD_NUMBER = 4;
  private com.google.privacy.dlp.v2.TransformationResultStatus statusDetails_;
  /**
   *
   *
   * <pre>
   * Status of the transformation, if transformation was not successful, this
   * will specify what caused it to fail, otherwise it will show that the
   * transformation was successful.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
   *
   * @return Whether the statusDetails field is set.
   */
  @java.lang.Override
  public boolean hasStatusDetails() {
    return statusDetails_ != null;
  }
  /**
   *
   *
   * <pre>
   * Status of the transformation, if transformation was not successful, this
   * will specify what caused it to fail, otherwise it will show that the
   * transformation was successful.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
   *
   * @return The statusDetails.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationResultStatus getStatusDetails() {
    return statusDetails_ == null
        ? com.google.privacy.dlp.v2.TransformationResultStatus.getDefaultInstance()
        : statusDetails_;
  }
  /**
   *
   *
   * <pre>
   * Status of the transformation, if transformation was not successful, this
   * will specify what caused it to fail, otherwise it will show that the
   * transformation was successful.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationResultStatusOrBuilder getStatusDetailsOrBuilder() {
    return getStatusDetails();
  }

  public static final int TRANSFORMED_BYTES_FIELD_NUMBER = 5;
  private long transformedBytes_;
  /**
   *
   *
   * <pre>
   * The number of bytes that were transformed. If transformation was
   * unsuccessful or did not take place because there was no content to
   * transform, this will be zero.
   * </pre>
   *
   * <code>int64 transformed_bytes = 5;</code>
   *
   * @return The transformedBytes.
   */
  @java.lang.Override
  public long getTransformedBytes() {
    return transformedBytes_;
  }

  public static final int TRANSFORMATION_LOCATION_FIELD_NUMBER = 6;
  private com.google.privacy.dlp.v2.TransformationLocation transformationLocation_;
  /**
   *
   *
   * <pre>
   * The precise location of the transformed content in the original container.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
   *
   * @return Whether the transformationLocation field is set.
   */
  @java.lang.Override
  public boolean hasTransformationLocation() {
    return transformationLocation_ != null;
  }
  /**
   *
   *
   * <pre>
   * The precise location of the transformed content in the original container.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
   *
   * @return The transformationLocation.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationLocation getTransformationLocation() {
    return transformationLocation_ == null
        ? com.google.privacy.dlp.v2.TransformationLocation.getDefaultInstance()
        : transformationLocation_;
  }
  /**
   *
   *
   * <pre>
   * The precise location of the transformed content in the original container.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationLocationOrBuilder
      getTransformationLocationOrBuilder() {
    return getTransformationLocation();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, containerName_);
    }
    for (int i = 0; i < transformation_.size(); i++) {
      output.writeMessage(3, transformation_.get(i));
    }
    if (statusDetails_ != null) {
      output.writeMessage(4, getStatusDetails());
    }
    if (transformedBytes_ != 0L) {
      output.writeInt64(5, transformedBytes_);
    }
    if (transformationLocation_ != null) {
      output.writeMessage(6, getTransformationLocation());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, containerName_);
    }
    for (int i = 0; i < transformation_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, transformation_.get(i));
    }
    if (statusDetails_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStatusDetails());
    }
    if (transformedBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, transformedBytes_);
    }
    if (transformationLocation_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, getTransformationLocation());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.TransformationDetails)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.TransformationDetails other =
        (com.google.privacy.dlp.v2.TransformationDetails) obj;

    if (!getResourceName().equals(other.getResourceName())) return false;
    if (!getContainerName().equals(other.getContainerName())) return false;
    if (!getTransformationList().equals(other.getTransformationList())) return false;
    if (hasStatusDetails() != other.hasStatusDetails()) return false;
    if (hasStatusDetails()) {
      if (!getStatusDetails().equals(other.getStatusDetails())) return false;
    }
    if (getTransformedBytes() != other.getTransformedBytes()) return false;
    if (hasTransformationLocation() != other.hasTransformationLocation()) return false;
    if (hasTransformationLocation()) {
      if (!getTransformationLocation().equals(other.getTransformationLocation())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + CONTAINER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getContainerName().hashCode();
    if (getTransformationCount() > 0) {
      hash = (37 * hash) + TRANSFORMATION_FIELD_NUMBER;
      hash = (53 * hash) + getTransformationList().hashCode();
    }
    if (hasStatusDetails()) {
      hash = (37 * hash) + STATUS_DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getStatusDetails().hashCode();
    }
    hash = (37 * hash) + TRANSFORMED_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTransformedBytes());
    if (hasTransformationLocation()) {
      hash = (37 * hash) + TRANSFORMATION_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getTransformationLocation().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.TransformationDetails parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationDetails parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.TransformationDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationDetails parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.TransformationDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.TransformationDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.TransformationDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details about a single transformation. This object contains a description of
   * the transformation, information about whether the transformation was
   * successfully applied, and the precise location where the transformation
   * occurred. These details are stored in a user-specified BigQuery table.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.TransformationDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.TransformationDetails)
      com.google.privacy.dlp.v2.TransformationDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.TransformationDetails.class,
              com.google.privacy.dlp.v2.TransformationDetails.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.TransformationDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      resourceName_ = "";

      containerName_ = "";

      if (transformationBuilder_ == null) {
        transformation_ = java.util.Collections.emptyList();
      } else {
        transformation_ = null;
        transformationBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (statusDetailsBuilder_ == null) {
        statusDetails_ = null;
      } else {
        statusDetails_ = null;
        statusDetailsBuilder_ = null;
      }
      transformedBytes_ = 0L;

      if (transformationLocationBuilder_ == null) {
        transformationLocation_ = null;
      } else {
        transformationLocation_ = null;
        transformationLocationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_TransformationDetails_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationDetails getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.TransformationDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationDetails build() {
      com.google.privacy.dlp.v2.TransformationDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.TransformationDetails buildPartial() {
      com.google.privacy.dlp.v2.TransformationDetails result =
          new com.google.privacy.dlp.v2.TransformationDetails(this);
      int from_bitField0_ = bitField0_;
      result.resourceName_ = resourceName_;
      result.containerName_ = containerName_;
      if (transformationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          transformation_ = java.util.Collections.unmodifiableList(transformation_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.transformation_ = transformation_;
      } else {
        result.transformation_ = transformationBuilder_.build();
      }
      if (statusDetailsBuilder_ == null) {
        result.statusDetails_ = statusDetails_;
      } else {
        result.statusDetails_ = statusDetailsBuilder_.build();
      }
      result.transformedBytes_ = transformedBytes_;
      if (transformationLocationBuilder_ == null) {
        result.transformationLocation_ = transformationLocation_;
      } else {
        result.transformationLocation_ = transformationLocationBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.TransformationDetails) {
        return mergeFrom((com.google.privacy.dlp.v2.TransformationDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.TransformationDetails other) {
      if (other == com.google.privacy.dlp.v2.TransformationDetails.getDefaultInstance())
        return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        onChanged();
      }
      if (!other.getContainerName().isEmpty()) {
        containerName_ = other.containerName_;
        onChanged();
      }
      if (transformationBuilder_ == null) {
        if (!other.transformation_.isEmpty()) {
          if (transformation_.isEmpty()) {
            transformation_ = other.transformation_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTransformationIsMutable();
            transformation_.addAll(other.transformation_);
          }
          onChanged();
        }
      } else {
        if (!other.transformation_.isEmpty()) {
          if (transformationBuilder_.isEmpty()) {
            transformationBuilder_.dispose();
            transformationBuilder_ = null;
            transformation_ = other.transformation_;
            bitField0_ = (bitField0_ & ~0x00000001);
            transformationBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTransformationFieldBuilder()
                    : null;
          } else {
            transformationBuilder_.addAllMessages(other.transformation_);
          }
        }
      }
      if (other.hasStatusDetails()) {
        mergeStatusDetails(other.getStatusDetails());
      }
      if (other.getTransformedBytes() != 0L) {
        setTransformedBytes(other.getTransformedBytes());
      }
      if (other.hasTransformationLocation()) {
        mergeTransformationLocation(other.getTransformationLocation());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                resourceName_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                containerName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                com.google.privacy.dlp.v2.TransformationDescription m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.TransformationDescription.parser(),
                        extensionRegistry);
                if (transformationBuilder_ == null) {
                  ensureTransformationIsMutable();
                  transformation_.add(m);
                } else {
                  transformationBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getStatusDetailsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 40:
              {
                transformedBytes_ = input.readInt64();

                break;
              } // case 40
            case 50:
              {
                input.readMessage(
                    getTransformationLocationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the job that completed the transformation.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the job that completed the transformation.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the job that completed the transformation.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      resourceName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the job that completed the transformation.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {

      resourceName_ = getDefaultInstance().getResourceName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the job that completed the transformation.
     * </pre>
     *
     * <code>string resource_name = 1;</code>
     *
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      resourceName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object containerName_ = "";
    /**
     *
     *
     * <pre>
     * The top level name of the container where the transformation is located
     * (this will be the source file name or table name).
     * </pre>
     *
     * <code>string container_name = 2;</code>
     *
     * @return The containerName.
     */
    public java.lang.String getContainerName() {
      java.lang.Object ref = containerName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        containerName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The top level name of the container where the transformation is located
     * (this will be the source file name or table name).
     * </pre>
     *
     * <code>string container_name = 2;</code>
     *
     * @return The bytes for containerName.
     */
    public com.google.protobuf.ByteString getContainerNameBytes() {
      java.lang.Object ref = containerName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        containerName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The top level name of the container where the transformation is located
     * (this will be the source file name or table name).
     * </pre>
     *
     * <code>string container_name = 2;</code>
     *
     * @param value The containerName to set.
     * @return This builder for chaining.
     */
    public Builder setContainerName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      containerName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The top level name of the container where the transformation is located
     * (this will be the source file name or table name).
     * </pre>
     *
     * <code>string container_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContainerName() {

      containerName_ = getDefaultInstance().getContainerName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The top level name of the container where the transformation is located
     * (this will be the source file name or table name).
     * </pre>
     *
     * <code>string container_name = 2;</code>
     *
     * @param value The bytes for containerName to set.
     * @return This builder for chaining.
     */
    public Builder setContainerNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      containerName_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.privacy.dlp.v2.TransformationDescription> transformation_ =
        java.util.Collections.emptyList();

    private void ensureTransformationIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        transformation_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.TransformationDescription>(
                transformation_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationDescription,
            com.google.privacy.dlp.v2.TransformationDescription.Builder,
            com.google.privacy.dlp.v2.TransformationDescriptionOrBuilder>
        transformationBuilder_;

    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.TransformationDescription>
        getTransformationList() {
      if (transformationBuilder_ == null) {
        return java.util.Collections.unmodifiableList(transformation_);
      } else {
        return transformationBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public int getTransformationCount() {
      if (transformationBuilder_ == null) {
        return transformation_.size();
      } else {
        return transformationBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public com.google.privacy.dlp.v2.TransformationDescription getTransformation(int index) {
      if (transformationBuilder_ == null) {
        return transformation_.get(index);
      } else {
        return transformationBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public Builder setTransformation(
        int index, com.google.privacy.dlp.v2.TransformationDescription value) {
      if (transformationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransformationIsMutable();
        transformation_.set(index, value);
        onChanged();
      } else {
        transformationBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public Builder setTransformation(
        int index, com.google.privacy.dlp.v2.TransformationDescription.Builder builderForValue) {
      if (transformationBuilder_ == null) {
        ensureTransformationIsMutable();
        transformation_.set(index, builderForValue.build());
        onChanged();
      } else {
        transformationBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public Builder addTransformation(com.google.privacy.dlp.v2.TransformationDescription value) {
      if (transformationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransformationIsMutable();
        transformation_.add(value);
        onChanged();
      } else {
        transformationBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public Builder addTransformation(
        int index, com.google.privacy.dlp.v2.TransformationDescription value) {
      if (transformationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTransformationIsMutable();
        transformation_.add(index, value);
        onChanged();
      } else {
        transformationBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public Builder addTransformation(
        com.google.privacy.dlp.v2.TransformationDescription.Builder builderForValue) {
      if (transformationBuilder_ == null) {
        ensureTransformationIsMutable();
        transformation_.add(builderForValue.build());
        onChanged();
      } else {
        transformationBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public Builder addTransformation(
        int index, com.google.privacy.dlp.v2.TransformationDescription.Builder builderForValue) {
      if (transformationBuilder_ == null) {
        ensureTransformationIsMutable();
        transformation_.add(index, builderForValue.build());
        onChanged();
      } else {
        transformationBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public Builder addAllTransformation(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.TransformationDescription> values) {
      if (transformationBuilder_ == null) {
        ensureTransformationIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transformation_);
        onChanged();
      } else {
        transformationBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public Builder clearTransformation() {
      if (transformationBuilder_ == null) {
        transformation_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        transformationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public Builder removeTransformation(int index) {
      if (transformationBuilder_ == null) {
        ensureTransformationIsMutable();
        transformation_.remove(index);
        onChanged();
      } else {
        transformationBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public com.google.privacy.dlp.v2.TransformationDescription.Builder getTransformationBuilder(
        int index) {
      return getTransformationFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public com.google.privacy.dlp.v2.TransformationDescriptionOrBuilder getTransformationOrBuilder(
        int index) {
      if (transformationBuilder_ == null) {
        return transformation_.get(index);
      } else {
        return transformationBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.TransformationDescriptionOrBuilder>
        getTransformationOrBuilderList() {
      if (transformationBuilder_ != null) {
        return transformationBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(transformation_);
      }
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public com.google.privacy.dlp.v2.TransformationDescription.Builder addTransformationBuilder() {
      return getTransformationFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.TransformationDescription.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public com.google.privacy.dlp.v2.TransformationDescription.Builder addTransformationBuilder(
        int index) {
      return getTransformationFieldBuilder()
          .addBuilder(
              index, com.google.privacy.dlp.v2.TransformationDescription.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Description of transformation. This would only contain more than one
     * element if there were multiple matching transformations and which one to
     * apply was ambiguous. Not set for states that contain no transformation,
     * currently only state that contains no transformation is
     * TransformationResultStateType.METADATA_UNRETRIEVABLE.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.TransformationDescription transformation = 3;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.TransformationDescription.Builder>
        getTransformationBuilderList() {
      return getTransformationFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationDescription,
            com.google.privacy.dlp.v2.TransformationDescription.Builder,
            com.google.privacy.dlp.v2.TransformationDescriptionOrBuilder>
        getTransformationFieldBuilder() {
      if (transformationBuilder_ == null) {
        transformationBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.TransformationDescription,
                com.google.privacy.dlp.v2.TransformationDescription.Builder,
                com.google.privacy.dlp.v2.TransformationDescriptionOrBuilder>(
                transformation_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      return transformationBuilder_;
    }

    private com.google.privacy.dlp.v2.TransformationResultStatus statusDetails_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationResultStatus,
            com.google.privacy.dlp.v2.TransformationResultStatus.Builder,
            com.google.privacy.dlp.v2.TransformationResultStatusOrBuilder>
        statusDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Status of the transformation, if transformation was not successful, this
     * will specify what caused it to fail, otherwise it will show that the
     * transformation was successful.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
     *
     * @return Whether the statusDetails field is set.
     */
    public boolean hasStatusDetails() {
      return statusDetailsBuilder_ != null || statusDetails_ != null;
    }
    /**
     *
     *
     * <pre>
     * Status of the transformation, if transformation was not successful, this
     * will specify what caused it to fail, otherwise it will show that the
     * transformation was successful.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
     *
     * @return The statusDetails.
     */
    public com.google.privacy.dlp.v2.TransformationResultStatus getStatusDetails() {
      if (statusDetailsBuilder_ == null) {
        return statusDetails_ == null
            ? com.google.privacy.dlp.v2.TransformationResultStatus.getDefaultInstance()
            : statusDetails_;
      } else {
        return statusDetailsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Status of the transformation, if transformation was not successful, this
     * will specify what caused it to fail, otherwise it will show that the
     * transformation was successful.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
     */
    public Builder setStatusDetails(com.google.privacy.dlp.v2.TransformationResultStatus value) {
      if (statusDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        statusDetails_ = value;
        onChanged();
      } else {
        statusDetailsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of the transformation, if transformation was not successful, this
     * will specify what caused it to fail, otherwise it will show that the
     * transformation was successful.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
     */
    public Builder setStatusDetails(
        com.google.privacy.dlp.v2.TransformationResultStatus.Builder builderForValue) {
      if (statusDetailsBuilder_ == null) {
        statusDetails_ = builderForValue.build();
        onChanged();
      } else {
        statusDetailsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of the transformation, if transformation was not successful, this
     * will specify what caused it to fail, otherwise it will show that the
     * transformation was successful.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
     */
    public Builder mergeStatusDetails(com.google.privacy.dlp.v2.TransformationResultStatus value) {
      if (statusDetailsBuilder_ == null) {
        if (statusDetails_ != null) {
          statusDetails_ =
              com.google.privacy.dlp.v2.TransformationResultStatus.newBuilder(statusDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          statusDetails_ = value;
        }
        onChanged();
      } else {
        statusDetailsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of the transformation, if transformation was not successful, this
     * will specify what caused it to fail, otherwise it will show that the
     * transformation was successful.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
     */
    public Builder clearStatusDetails() {
      if (statusDetailsBuilder_ == null) {
        statusDetails_ = null;
        onChanged();
      } else {
        statusDetails_ = null;
        statusDetailsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Status of the transformation, if transformation was not successful, this
     * will specify what caused it to fail, otherwise it will show that the
     * transformation was successful.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
     */
    public com.google.privacy.dlp.v2.TransformationResultStatus.Builder getStatusDetailsBuilder() {

      onChanged();
      return getStatusDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Status of the transformation, if transformation was not successful, this
     * will specify what caused it to fail, otherwise it will show that the
     * transformation was successful.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
     */
    public com.google.privacy.dlp.v2.TransformationResultStatusOrBuilder
        getStatusDetailsOrBuilder() {
      if (statusDetailsBuilder_ != null) {
        return statusDetailsBuilder_.getMessageOrBuilder();
      } else {
        return statusDetails_ == null
            ? com.google.privacy.dlp.v2.TransformationResultStatus.getDefaultInstance()
            : statusDetails_;
      }
    }
    /**
     *
     *
     * <pre>
     * Status of the transformation, if transformation was not successful, this
     * will specify what caused it to fail, otherwise it will show that the
     * transformation was successful.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationResultStatus status_details = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationResultStatus,
            com.google.privacy.dlp.v2.TransformationResultStatus.Builder,
            com.google.privacy.dlp.v2.TransformationResultStatusOrBuilder>
        getStatusDetailsFieldBuilder() {
      if (statusDetailsBuilder_ == null) {
        statusDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.TransformationResultStatus,
                com.google.privacy.dlp.v2.TransformationResultStatus.Builder,
                com.google.privacy.dlp.v2.TransformationResultStatusOrBuilder>(
                getStatusDetails(), getParentForChildren(), isClean());
        statusDetails_ = null;
      }
      return statusDetailsBuilder_;
    }

    private long transformedBytes_;
    /**
     *
     *
     * <pre>
     * The number of bytes that were transformed. If transformation was
     * unsuccessful or did not take place because there was no content to
     * transform, this will be zero.
     * </pre>
     *
     * <code>int64 transformed_bytes = 5;</code>
     *
     * @return The transformedBytes.
     */
    @java.lang.Override
    public long getTransformedBytes() {
      return transformedBytes_;
    }
    /**
     *
     *
     * <pre>
     * The number of bytes that were transformed. If transformation was
     * unsuccessful or did not take place because there was no content to
     * transform, this will be zero.
     * </pre>
     *
     * <code>int64 transformed_bytes = 5;</code>
     *
     * @param value The transformedBytes to set.
     * @return This builder for chaining.
     */
    public Builder setTransformedBytes(long value) {

      transformedBytes_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of bytes that were transformed. If transformation was
     * unsuccessful or did not take place because there was no content to
     * transform, this will be zero.
     * </pre>
     *
     * <code>int64 transformed_bytes = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransformedBytes() {

      transformedBytes_ = 0L;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.TransformationLocation transformationLocation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationLocation,
            com.google.privacy.dlp.v2.TransformationLocation.Builder,
            com.google.privacy.dlp.v2.TransformationLocationOrBuilder>
        transformationLocationBuilder_;
    /**
     *
     *
     * <pre>
     * The precise location of the transformed content in the original container.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
     *
     * @return Whether the transformationLocation field is set.
     */
    public boolean hasTransformationLocation() {
      return transformationLocationBuilder_ != null || transformationLocation_ != null;
    }
    /**
     *
     *
     * <pre>
     * The precise location of the transformed content in the original container.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
     *
     * @return The transformationLocation.
     */
    public com.google.privacy.dlp.v2.TransformationLocation getTransformationLocation() {
      if (transformationLocationBuilder_ == null) {
        return transformationLocation_ == null
            ? com.google.privacy.dlp.v2.TransformationLocation.getDefaultInstance()
            : transformationLocation_;
      } else {
        return transformationLocationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The precise location of the transformed content in the original container.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
     */
    public Builder setTransformationLocation(
        com.google.privacy.dlp.v2.TransformationLocation value) {
      if (transformationLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformationLocation_ = value;
        onChanged();
      } else {
        transformationLocationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The precise location of the transformed content in the original container.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
     */
    public Builder setTransformationLocation(
        com.google.privacy.dlp.v2.TransformationLocation.Builder builderForValue) {
      if (transformationLocationBuilder_ == null) {
        transformationLocation_ = builderForValue.build();
        onChanged();
      } else {
        transformationLocationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The precise location of the transformed content in the original container.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
     */
    public Builder mergeTransformationLocation(
        com.google.privacy.dlp.v2.TransformationLocation value) {
      if (transformationLocationBuilder_ == null) {
        if (transformationLocation_ != null) {
          transformationLocation_ =
              com.google.privacy.dlp.v2.TransformationLocation.newBuilder(transformationLocation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformationLocation_ = value;
        }
        onChanged();
      } else {
        transformationLocationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The precise location of the transformed content in the original container.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
     */
    public Builder clearTransformationLocation() {
      if (transformationLocationBuilder_ == null) {
        transformationLocation_ = null;
        onChanged();
      } else {
        transformationLocation_ = null;
        transformationLocationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The precise location of the transformed content in the original container.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
     */
    public com.google.privacy.dlp.v2.TransformationLocation.Builder
        getTransformationLocationBuilder() {

      onChanged();
      return getTransformationLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The precise location of the transformed content in the original container.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
     */
    public com.google.privacy.dlp.v2.TransformationLocationOrBuilder
        getTransformationLocationOrBuilder() {
      if (transformationLocationBuilder_ != null) {
        return transformationLocationBuilder_.getMessageOrBuilder();
      } else {
        return transformationLocation_ == null
            ? com.google.privacy.dlp.v2.TransformationLocation.getDefaultInstance()
            : transformationLocation_;
      }
    }
    /**
     *
     *
     * <pre>
     * The precise location of the transformed content in the original container.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationLocation transformation_location = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationLocation,
            com.google.privacy.dlp.v2.TransformationLocation.Builder,
            com.google.privacy.dlp.v2.TransformationLocationOrBuilder>
        getTransformationLocationFieldBuilder() {
      if (transformationLocationBuilder_ == null) {
        transformationLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.TransformationLocation,
                com.google.privacy.dlp.v2.TransformationLocation.Builder,
                com.google.privacy.dlp.v2.TransformationLocationOrBuilder>(
                getTransformationLocation(), getParentForChildren(), isClean());
        transformationLocation_ = null;
      }
      return transformationLocationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.TransformationDetails)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.TransformationDetails)
  private static final com.google.privacy.dlp.v2.TransformationDetails DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.TransformationDetails();
  }

  public static com.google.privacy.dlp.v2.TransformationDetails getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransformationDetails> PARSER =
      new com.google.protobuf.AbstractParser<TransformationDetails>() {
        @java.lang.Override
        public TransformationDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransformationDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransformationDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationDetails getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
