/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Version of a StoredInfoType, including the configuration used to build it,
 * create timestamp, and current state.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.StoredInfoTypeVersion}
 */
public final class StoredInfoTypeVersion extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.StoredInfoTypeVersion)
    StoredInfoTypeVersionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StoredInfoTypeVersion.newBuilder() to construct.
  private StoredInfoTypeVersion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StoredInfoTypeVersion() {
    state_ = 0;
    errors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StoredInfoTypeVersion();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_StoredInfoTypeVersion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_StoredInfoTypeVersion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.StoredInfoTypeVersion.class,
            com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder.class);
  }

  public static final int CONFIG_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.StoredInfoTypeConfig config_;
  /**
   *
   *
   * <pre>
   * StoredInfoType configuration.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredInfoTypeConfig config = 1;</code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return config_ != null;
  }
  /**
   *
   *
   * <pre>
   * StoredInfoType configuration.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredInfoTypeConfig config = 1;</code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredInfoTypeConfig getConfig() {
    return config_ == null
        ? com.google.privacy.dlp.v2.StoredInfoTypeConfig.getDefaultInstance()
        : config_;
  }
  /**
   *
   *
   * <pre>
   * StoredInfoType configuration.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredInfoTypeConfig config = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredInfoTypeConfigOrBuilder getConfigOrBuilder() {
    return getConfig();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Create timestamp of the version. Read-only, determined by the system
   * when the version is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Create timestamp of the version. Read-only, determined by the system
   * when the version is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Create timestamp of the version. Read-only, determined by the system
   * when the version is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_;
  /**
   *
   *
   * <pre>
   * Stored info type version state. Read-only, updated by the system
   * during dictionary creation.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredInfoTypeState state = 3;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Stored info type version state. Read-only, updated by the system
   * during dictionary creation.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredInfoTypeState state = 3;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredInfoTypeState getState() {
    @SuppressWarnings("deprecation")
    com.google.privacy.dlp.v2.StoredInfoTypeState result =
        com.google.privacy.dlp.v2.StoredInfoTypeState.valueOf(state_);
    return result == null ? com.google.privacy.dlp.v2.StoredInfoTypeState.UNRECOGNIZED : result;
  }

  public static final int ERRORS_FIELD_NUMBER = 4;
  private java.util.List<com.google.privacy.dlp.v2.Error> errors_;
  /**
   *
   *
   * <pre>
   * Errors that occurred when creating this storedInfoType version, or
   * anomalies detected in the storedInfoType data that render it unusable. Only
   * the five most recent errors will be displayed, with the most recent error
   * appearing first.
   * For example, some of the data for stored custom dictionaries is put in
   * the user's Cloud Storage bucket, and if this data is modified or
   * deleted by the user or another system, the dictionary becomes invalid.
   * If any errors occur, fix the problem indicated by the error message and
   * use the UpdateStoredInfoType API method to create another version of the
   * storedInfoType to continue using it, reusing the same `config` if it was
   * not the source of the error.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.Error> getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Errors that occurred when creating this storedInfoType version, or
   * anomalies detected in the storedInfoType data that render it unusable. Only
   * the five most recent errors will be displayed, with the most recent error
   * appearing first.
   * For example, some of the data for stored custom dictionaries is put in
   * the user's Cloud Storage bucket, and if this data is modified or
   * deleted by the user or another system, the dictionary becomes invalid.
   * If any errors occur, fix the problem indicated by the error message and
   * use the UpdateStoredInfoType API method to create another version of the
   * storedInfoType to continue using it, reusing the same `config` if it was
   * not the source of the error.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.ErrorOrBuilder>
      getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Errors that occurred when creating this storedInfoType version, or
   * anomalies detected in the storedInfoType data that render it unusable. Only
   * the five most recent errors will be displayed, with the most recent error
   * appearing first.
   * For example, some of the data for stored custom dictionaries is put in
   * the user's Cloud Storage bucket, and if this data is modified or
   * deleted by the user or another system, the dictionary becomes invalid.
   * If any errors occur, fix the problem indicated by the error message and
   * use the UpdateStoredInfoType API method to create another version of the
   * storedInfoType to continue using it, reusing the same `config` if it was
   * not the source of the error.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * Errors that occurred when creating this storedInfoType version, or
   * anomalies detected in the storedInfoType data that render it unusable. Only
   * the five most recent errors will be displayed, with the most recent error
   * appearing first.
   * For example, some of the data for stored custom dictionaries is put in
   * the user's Cloud Storage bucket, and if this data is modified or
   * deleted by the user or another system, the dictionary becomes invalid.
   * If any errors occur, fix the problem indicated by the error message and
   * use the UpdateStoredInfoType API method to create another version of the
   * storedInfoType to continue using it, reusing the same `config` if it was
   * not the source of the error.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Error getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Errors that occurred when creating this storedInfoType version, or
   * anomalies detected in the storedInfoType data that render it unusable. Only
   * the five most recent errors will be displayed, with the most recent error
   * appearing first.
   * For example, some of the data for stored custom dictionaries is put in
   * the user's Cloud Storage bucket, and if this data is modified or
   * deleted by the user or another system, the dictionary becomes invalid.
   * If any errors occur, fix the problem indicated by the error message and
   * use the UpdateStoredInfoType API method to create another version of the
   * storedInfoType to continue using it, reusing the same `config` if it was
   * not the source of the error.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ErrorOrBuilder getErrorsOrBuilder(int index) {
    return errors_.get(index);
  }

  public static final int STATS_FIELD_NUMBER = 5;
  private com.google.privacy.dlp.v2.StoredInfoTypeStats stats_;
  /**
   *
   *
   * <pre>
   * Statistics about this storedInfoType version.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredInfoTypeStats stats = 5;</code>
   *
   * @return Whether the stats field is set.
   */
  @java.lang.Override
  public boolean hasStats() {
    return stats_ != null;
  }
  /**
   *
   *
   * <pre>
   * Statistics about this storedInfoType version.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredInfoTypeStats stats = 5;</code>
   *
   * @return The stats.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredInfoTypeStats getStats() {
    return stats_ == null
        ? com.google.privacy.dlp.v2.StoredInfoTypeStats.getDefaultInstance()
        : stats_;
  }
  /**
   *
   *
   * <pre>
   * Statistics about this storedInfoType version.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredInfoTypeStats stats = 5;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredInfoTypeStatsOrBuilder getStatsOrBuilder() {
    return getStats();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (config_ != null) {
      output.writeMessage(1, getConfig());
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (state_
        != com.google.privacy.dlp.v2.StoredInfoTypeState.STORED_INFO_TYPE_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, state_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(4, errors_.get(i));
    }
    if (stats_ != null) {
      output.writeMessage(5, getStats());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (config_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getConfig());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (state_
        != com.google.privacy.dlp.v2.StoredInfoTypeState.STORED_INFO_TYPE_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, errors_.get(i));
    }
    if (stats_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getStats());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.StoredInfoTypeVersion)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.StoredInfoTypeVersion other =
        (com.google.privacy.dlp.v2.StoredInfoTypeVersion) obj;

    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (hasStats() != other.hasStats()) return false;
    if (hasStats()) {
      if (!getStats().equals(other.getStats())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    if (hasStats()) {
      hash = (37 * hash) + STATS_FIELD_NUMBER;
      hash = (53 * hash) + getStats().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.StoredInfoTypeVersion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Version of a StoredInfoType, including the configuration used to build it,
   * create timestamp, and current state.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.StoredInfoTypeVersion}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.StoredInfoTypeVersion)
      com.google.privacy.dlp.v2.StoredInfoTypeVersionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StoredInfoTypeVersion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StoredInfoTypeVersion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.StoredInfoTypeVersion.class,
              com.google.privacy.dlp.v2.StoredInfoTypeVersion.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.StoredInfoTypeVersion.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (configBuilder_ == null) {
        config_ = null;
      } else {
        config_ = null;
        configBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      state_ = 0;

      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (statsBuilder_ == null) {
        stats_ = null;
      } else {
        stats_ = null;
        statsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_StoredInfoTypeVersion_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StoredInfoTypeVersion getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.StoredInfoTypeVersion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StoredInfoTypeVersion build() {
      com.google.privacy.dlp.v2.StoredInfoTypeVersion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StoredInfoTypeVersion buildPartial() {
      com.google.privacy.dlp.v2.StoredInfoTypeVersion result =
          new com.google.privacy.dlp.v2.StoredInfoTypeVersion(this);
      int from_bitField0_ = bitField0_;
      if (configBuilder_ == null) {
        result.config_ = config_;
      } else {
        result.config_ = configBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      result.state_ = state_;
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
      if (statsBuilder_ == null) {
        result.stats_ = stats_;
      } else {
        result.stats_ = statsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.StoredInfoTypeVersion) {
        return mergeFrom((com.google.privacy.dlp.v2.StoredInfoTypeVersion) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.StoredInfoTypeVersion other) {
      if (other == com.google.privacy.dlp.v2.StoredInfoTypeVersion.getDefaultInstance())
        return this;
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000001);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      if (other.hasStats()) {
        mergeStats(other.getStats());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 24:
              {
                state_ = input.readEnum();

                break;
              } // case 24
            case 34:
              {
                com.google.privacy.dlp.v2.Error m =
                    input.readMessage(com.google.privacy.dlp.v2.Error.parser(), extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getStatsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.StoredInfoTypeConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.StoredInfoTypeConfig,
            com.google.privacy.dlp.v2.StoredInfoTypeConfig.Builder,
            com.google.privacy.dlp.v2.StoredInfoTypeConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * StoredInfoType configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeConfig config = 1;</code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return configBuilder_ != null || config_ != null;
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeConfig config = 1;</code>
     *
     * @return The config.
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.privacy.dlp.v2.StoredInfoTypeConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeConfig config = 1;</code>
     */
    public Builder setConfig(com.google.privacy.dlp.v2.StoredInfoTypeConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
        onChanged();
      } else {
        configBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeConfig config = 1;</code>
     */
    public Builder setConfig(
        com.google.privacy.dlp.v2.StoredInfoTypeConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
        onChanged();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeConfig config = 1;</code>
     */
    public Builder mergeConfig(com.google.privacy.dlp.v2.StoredInfoTypeConfig value) {
      if (configBuilder_ == null) {
        if (config_ != null) {
          config_ =
              com.google.privacy.dlp.v2.StoredInfoTypeConfig.newBuilder(config_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          config_ = value;
        }
        onChanged();
      } else {
        configBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeConfig config = 1;</code>
     */
    public Builder clearConfig() {
      if (configBuilder_ == null) {
        config_ = null;
        onChanged();
      } else {
        config_ = null;
        configBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeConfig config = 1;</code>
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeConfig.Builder getConfigBuilder() {

      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeConfig config = 1;</code>
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeConfigOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.privacy.dlp.v2.StoredInfoTypeConfig.getDefaultInstance()
            : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * StoredInfoType configuration.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeConfig config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.StoredInfoTypeConfig,
            com.google.privacy.dlp.v2.StoredInfoTypeConfig.Builder,
            com.google.privacy.dlp.v2.StoredInfoTypeConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.StoredInfoTypeConfig,
                com.google.privacy.dlp.v2.StoredInfoTypeConfig.Builder,
                com.google.privacy.dlp.v2.StoredInfoTypeConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Create timestamp of the version. Read-only, determined by the system
     * when the version is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Create timestamp of the version. Read-only, determined by the system
     * when the version is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Create timestamp of the version. Read-only, determined by the system
     * when the version is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Create timestamp of the version. Read-only, determined by the system
     * when the version is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Create timestamp of the version. Read-only, determined by the system
     * when the version is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Create timestamp of the version. Read-only, determined by the system
     * when the version is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Create timestamp of the version. Read-only, determined by the system
     * when the version is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Create timestamp of the version. Read-only, determined by the system
     * when the version is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Create timestamp of the version. Read-only, determined by the system
     * when the version is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Stored info type version state. Read-only, updated by the system
     * during dictionary creation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeState state = 3;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Stored info type version state. Read-only, updated by the system
     * during dictionary creation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeState state = 3;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stored info type version state. Read-only, updated by the system
     * during dictionary creation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeState state = 3;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.StoredInfoTypeState getState() {
      @SuppressWarnings("deprecation")
      com.google.privacy.dlp.v2.StoredInfoTypeState result =
          com.google.privacy.dlp.v2.StoredInfoTypeState.valueOf(state_);
      return result == null ? com.google.privacy.dlp.v2.StoredInfoTypeState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Stored info type version state. Read-only, updated by the system
     * during dictionary creation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeState state = 3;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.privacy.dlp.v2.StoredInfoTypeState value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stored info type version state. Read-only, updated by the system
     * during dictionary creation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeState state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.privacy.dlp.v2.Error> errors_ =
        java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        errors_ = new java.util.ArrayList<com.google.privacy.dlp.v2.Error>(errors_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Error,
            com.google.privacy.dlp.v2.Error.Builder,
            com.google.privacy.dlp.v2.ErrorOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Error> getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public com.google.privacy.dlp.v2.Error getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public Builder setErrors(int index, com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public Builder setErrors(int index, com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public Builder addErrors(com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public Builder addErrors(int index, com.google.privacy.dlp.v2.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public Builder addErrors(com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public Builder addErrors(int index, com.google.privacy.dlp.v2.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public Builder addAllErrors(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.Error> values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public com.google.privacy.dlp.v2.Error.Builder getErrorsBuilder(int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public com.google.privacy.dlp.v2.ErrorOrBuilder getErrorsOrBuilder(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.ErrorOrBuilder>
        getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public com.google.privacy.dlp.v2.Error.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public com.google.privacy.dlp.v2.Error.Builder addErrorsBuilder(int index) {
      return getErrorsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Errors that occurred when creating this storedInfoType version, or
     * anomalies detected in the storedInfoType data that render it unusable. Only
     * the five most recent errors will be displayed, with the most recent error
     * appearing first.
     * For example, some of the data for stored custom dictionaries is put in
     * the user's Cloud Storage bucket, and if this data is modified or
     * deleted by the user or another system, the dictionary becomes invalid.
     * If any errors occur, fix the problem indicated by the error message and
     * use the UpdateStoredInfoType API method to create another version of the
     * storedInfoType to continue using it, reusing the same `config` if it was
     * not the source of the error.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Error errors = 4;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Error.Builder> getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Error,
            com.google.privacy.dlp.v2.Error.Builder,
            com.google.privacy.dlp.v2.ErrorOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.Error,
                com.google.privacy.dlp.v2.Error.Builder,
                com.google.privacy.dlp.v2.ErrorOrBuilder>(
                errors_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    private com.google.privacy.dlp.v2.StoredInfoTypeStats stats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.StoredInfoTypeStats,
            com.google.privacy.dlp.v2.StoredInfoTypeStats.Builder,
            com.google.privacy.dlp.v2.StoredInfoTypeStatsOrBuilder>
        statsBuilder_;
    /**
     *
     *
     * <pre>
     * Statistics about this storedInfoType version.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeStats stats = 5;</code>
     *
     * @return Whether the stats field is set.
     */
    public boolean hasStats() {
      return statsBuilder_ != null || stats_ != null;
    }
    /**
     *
     *
     * <pre>
     * Statistics about this storedInfoType version.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeStats stats = 5;</code>
     *
     * @return The stats.
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeStats getStats() {
      if (statsBuilder_ == null) {
        return stats_ == null
            ? com.google.privacy.dlp.v2.StoredInfoTypeStats.getDefaultInstance()
            : stats_;
      } else {
        return statsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Statistics about this storedInfoType version.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeStats stats = 5;</code>
     */
    public Builder setStats(com.google.privacy.dlp.v2.StoredInfoTypeStats value) {
      if (statsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stats_ = value;
        onChanged();
      } else {
        statsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics about this storedInfoType version.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeStats stats = 5;</code>
     */
    public Builder setStats(com.google.privacy.dlp.v2.StoredInfoTypeStats.Builder builderForValue) {
      if (statsBuilder_ == null) {
        stats_ = builderForValue.build();
        onChanged();
      } else {
        statsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics about this storedInfoType version.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeStats stats = 5;</code>
     */
    public Builder mergeStats(com.google.privacy.dlp.v2.StoredInfoTypeStats value) {
      if (statsBuilder_ == null) {
        if (stats_ != null) {
          stats_ =
              com.google.privacy.dlp.v2.StoredInfoTypeStats.newBuilder(stats_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stats_ = value;
        }
        onChanged();
      } else {
        statsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics about this storedInfoType version.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeStats stats = 5;</code>
     */
    public Builder clearStats() {
      if (statsBuilder_ == null) {
        stats_ = null;
        onChanged();
      } else {
        stats_ = null;
        statsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics about this storedInfoType version.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeStats stats = 5;</code>
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeStats.Builder getStatsBuilder() {

      onChanged();
      return getStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Statistics about this storedInfoType version.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeStats stats = 5;</code>
     */
    public com.google.privacy.dlp.v2.StoredInfoTypeStatsOrBuilder getStatsOrBuilder() {
      if (statsBuilder_ != null) {
        return statsBuilder_.getMessageOrBuilder();
      } else {
        return stats_ == null
            ? com.google.privacy.dlp.v2.StoredInfoTypeStats.getDefaultInstance()
            : stats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Statistics about this storedInfoType version.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StoredInfoTypeStats stats = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.StoredInfoTypeStats,
            com.google.privacy.dlp.v2.StoredInfoTypeStats.Builder,
            com.google.privacy.dlp.v2.StoredInfoTypeStatsOrBuilder>
        getStatsFieldBuilder() {
      if (statsBuilder_ == null) {
        statsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.StoredInfoTypeStats,
                com.google.privacy.dlp.v2.StoredInfoTypeStats.Builder,
                com.google.privacy.dlp.v2.StoredInfoTypeStatsOrBuilder>(
                getStats(), getParentForChildren(), isClean());
        stats_ = null;
      }
      return statsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.StoredInfoTypeVersion)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.StoredInfoTypeVersion)
  private static final com.google.privacy.dlp.v2.StoredInfoTypeVersion DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.StoredInfoTypeVersion();
  }

  public static com.google.privacy.dlp.v2.StoredInfoTypeVersion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StoredInfoTypeVersion> PARSER =
      new com.google.protobuf.AbstractParser<StoredInfoTypeVersion>() {
        @java.lang.Override
        public StoredInfoTypeVersion parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StoredInfoTypeVersion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StoredInfoTypeVersion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.StoredInfoTypeVersion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
