/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/storage.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Shared message indicating Cloud storage type.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.StorageConfig}
 */
public final class StorageConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.StorageConfig)
    StorageConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StorageConfig.newBuilder() to construct.
  private StorageConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StorageConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StorageConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpStorage
        .internal_static_google_privacy_dlp_v2_StorageConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpStorage
        .internal_static_google_privacy_dlp_v2_StorageConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.StorageConfig.class,
            com.google.privacy.dlp.v2.StorageConfig.Builder.class);
  }

  public interface TimespanConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.StorageConfig.TimespanConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Exclude files, tables, or rows older than this value.
     * If not set, no lower time limit is applied.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    boolean hasStartTime();
    /**
     *
     *
     * <pre>
     * Exclude files, tables, or rows older than this value.
     * If not set, no lower time limit is applied.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    com.google.protobuf.Timestamp getStartTime();
    /**
     *
     *
     * <pre>
     * Exclude files, tables, or rows older than this value.
     * If not set, no lower time limit is applied.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Exclude files, tables, or rows newer than this value.
     * If not set, no upper time limit is applied.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    boolean hasEndTime();
    /**
     *
     *
     * <pre>
     * Exclude files, tables, or rows newer than this value.
     * If not set, no upper time limit is applied.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    com.google.protobuf.Timestamp getEndTime();
    /**
     *
     *
     * <pre>
     * Exclude files, tables, or rows newer than this value.
     * If not set, no upper time limit is applied.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Specification of the field containing the timestamp of scanned items.
     * Used for data sources like Datastore and BigQuery.
     * &lt;b&gt;For BigQuery&lt;/b&gt;
     * If this value is not specified and the table was modified between the
     * given start and end times, the entire table will be scanned. If this
     * value is specified, then rows are filtered based on the given start and
     * end times. Rows with a `NULL` value in the provided BigQuery column are
     * skipped.
     * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
     * `TIMESTAMP`, and `DATETIME`.
     * If your BigQuery table is [partitioned at ingestion
     * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
     * you can use any of the following pseudo-columns as your timestamp field.
     * When used with Cloud DLP, these pseudo-column names are case sensitive.
     * &lt;ul&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
     * &lt;/ul&gt;
     * &lt;b&gt;For Datastore&lt;/b&gt;
     * If this value is specified, then entities are filtered based on the given
     * start and end times. If an entity does not contain the provided timestamp
     * property or contains empty or invalid values, then it is included.
     * Valid data types of the provided timestamp property are: `TIMESTAMP`.
     * See the
     * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
     * related to this operation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
     *
     * @return Whether the timestampField field is set.
     */
    boolean hasTimestampField();
    /**
     *
     *
     * <pre>
     * Specification of the field containing the timestamp of scanned items.
     * Used for data sources like Datastore and BigQuery.
     * &lt;b&gt;For BigQuery&lt;/b&gt;
     * If this value is not specified and the table was modified between the
     * given start and end times, the entire table will be scanned. If this
     * value is specified, then rows are filtered based on the given start and
     * end times. Rows with a `NULL` value in the provided BigQuery column are
     * skipped.
     * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
     * `TIMESTAMP`, and `DATETIME`.
     * If your BigQuery table is [partitioned at ingestion
     * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
     * you can use any of the following pseudo-columns as your timestamp field.
     * When used with Cloud DLP, these pseudo-column names are case sensitive.
     * &lt;ul&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
     * &lt;/ul&gt;
     * &lt;b&gt;For Datastore&lt;/b&gt;
     * If this value is specified, then entities are filtered based on the given
     * start and end times. If an entity does not contain the provided timestamp
     * property or contains empty or invalid values, then it is included.
     * Valid data types of the provided timestamp property are: `TIMESTAMP`.
     * See the
     * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
     * related to this operation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
     *
     * @return The timestampField.
     */
    com.google.privacy.dlp.v2.FieldId getTimestampField();
    /**
     *
     *
     * <pre>
     * Specification of the field containing the timestamp of scanned items.
     * Used for data sources like Datastore and BigQuery.
     * &lt;b&gt;For BigQuery&lt;/b&gt;
     * If this value is not specified and the table was modified between the
     * given start and end times, the entire table will be scanned. If this
     * value is specified, then rows are filtered based on the given start and
     * end times. Rows with a `NULL` value in the provided BigQuery column are
     * skipped.
     * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
     * `TIMESTAMP`, and `DATETIME`.
     * If your BigQuery table is [partitioned at ingestion
     * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
     * you can use any of the following pseudo-columns as your timestamp field.
     * When used with Cloud DLP, these pseudo-column names are case sensitive.
     * &lt;ul&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
     * &lt;/ul&gt;
     * &lt;b&gt;For Datastore&lt;/b&gt;
     * If this value is specified, then entities are filtered based on the given
     * start and end times. If an entity does not contain the provided timestamp
     * property or contains empty or invalid values, then it is included.
     * Valid data types of the provided timestamp property are: `TIMESTAMP`.
     * See the
     * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
     * related to this operation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
     */
    com.google.privacy.dlp.v2.FieldIdOrBuilder getTimestampFieldOrBuilder();

    /**
     *
     *
     * <pre>
     * When the job is started by a JobTrigger we will automatically figure out
     * a valid start_time to avoid scanning files that have not been modified
     * since the last time the JobTrigger executed. This will be based on the
     * time of the execution of the last run of the JobTrigger or the timespan
     * end_time used in the last run of the JobTrigger.
     * </pre>
     *
     * <code>bool enable_auto_population_of_timespan_config = 4;</code>
     *
     * @return The enableAutoPopulationOfTimespanConfig.
     */
    boolean getEnableAutoPopulationOfTimespanConfig();
  }
  /**
   *
   *
   * <pre>
   * Configuration of the timespan of the items to include in scanning.
   * Currently only supported when inspecting Cloud Storage and BigQuery.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.StorageConfig.TimespanConfig}
   */
  public static final class TimespanConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.StorageConfig.TimespanConfig)
      TimespanConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TimespanConfig.newBuilder() to construct.
    private TimespanConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TimespanConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TimespanConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_StorageConfig_TimespanConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_StorageConfig_TimespanConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.class,
              com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.Builder.class);
    }

    public static final int START_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp startTime_;
    /**
     *
     *
     * <pre>
     * Exclude files, tables, or rows older than this value.
     * If not set, no lower time limit is applied.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return Whether the startTime field is set.
     */
    @java.lang.Override
    public boolean hasStartTime() {
      return startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Exclude files, tables, or rows older than this value.
     * If not set, no lower time limit is applied.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     *
     * @return The startTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTime() {
      return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
    }
    /**
     *
     *
     * <pre>
     * Exclude files, tables, or rows older than this value.
     * If not set, no lower time limit is applied.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      return getStartTime();
    }

    public static final int END_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp endTime_;
    /**
     *
     *
     * <pre>
     * Exclude files, tables, or rows newer than this value.
     * If not set, no upper time limit is applied.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    @java.lang.Override
    public boolean hasEndTime() {
      return endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Exclude files, tables, or rows newer than this value.
     * If not set, no upper time limit is applied.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEndTime() {
      return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
    }
    /**
     *
     *
     * <pre>
     * Exclude files, tables, or rows newer than this value.
     * If not set, no upper time limit is applied.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      return getEndTime();
    }

    public static final int TIMESTAMP_FIELD_FIELD_NUMBER = 3;
    private com.google.privacy.dlp.v2.FieldId timestampField_;
    /**
     *
     *
     * <pre>
     * Specification of the field containing the timestamp of scanned items.
     * Used for data sources like Datastore and BigQuery.
     * &lt;b&gt;For BigQuery&lt;/b&gt;
     * If this value is not specified and the table was modified between the
     * given start and end times, the entire table will be scanned. If this
     * value is specified, then rows are filtered based on the given start and
     * end times. Rows with a `NULL` value in the provided BigQuery column are
     * skipped.
     * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
     * `TIMESTAMP`, and `DATETIME`.
     * If your BigQuery table is [partitioned at ingestion
     * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
     * you can use any of the following pseudo-columns as your timestamp field.
     * When used with Cloud DLP, these pseudo-column names are case sensitive.
     * &lt;ul&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
     * &lt;/ul&gt;
     * &lt;b&gt;For Datastore&lt;/b&gt;
     * If this value is specified, then entities are filtered based on the given
     * start and end times. If an entity does not contain the provided timestamp
     * property or contains empty or invalid values, then it is included.
     * Valid data types of the provided timestamp property are: `TIMESTAMP`.
     * See the
     * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
     * related to this operation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
     *
     * @return Whether the timestampField field is set.
     */
    @java.lang.Override
    public boolean hasTimestampField() {
      return timestampField_ != null;
    }
    /**
     *
     *
     * <pre>
     * Specification of the field containing the timestamp of scanned items.
     * Used for data sources like Datastore and BigQuery.
     * &lt;b&gt;For BigQuery&lt;/b&gt;
     * If this value is not specified and the table was modified between the
     * given start and end times, the entire table will be scanned. If this
     * value is specified, then rows are filtered based on the given start and
     * end times. Rows with a `NULL` value in the provided BigQuery column are
     * skipped.
     * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
     * `TIMESTAMP`, and `DATETIME`.
     * If your BigQuery table is [partitioned at ingestion
     * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
     * you can use any of the following pseudo-columns as your timestamp field.
     * When used with Cloud DLP, these pseudo-column names are case sensitive.
     * &lt;ul&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
     * &lt;/ul&gt;
     * &lt;b&gt;For Datastore&lt;/b&gt;
     * If this value is specified, then entities are filtered based on the given
     * start and end times. If an entity does not contain the provided timestamp
     * property or contains empty or invalid values, then it is included.
     * Valid data types of the provided timestamp property are: `TIMESTAMP`.
     * See the
     * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
     * related to this operation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
     *
     * @return The timestampField.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.FieldId getTimestampField() {
      return timestampField_ == null
          ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance()
          : timestampField_;
    }
    /**
     *
     *
     * <pre>
     * Specification of the field containing the timestamp of scanned items.
     * Used for data sources like Datastore and BigQuery.
     * &lt;b&gt;For BigQuery&lt;/b&gt;
     * If this value is not specified and the table was modified between the
     * given start and end times, the entire table will be scanned. If this
     * value is specified, then rows are filtered based on the given start and
     * end times. Rows with a `NULL` value in the provided BigQuery column are
     * skipped.
     * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
     * `TIMESTAMP`, and `DATETIME`.
     * If your BigQuery table is [partitioned at ingestion
     * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
     * you can use any of the following pseudo-columns as your timestamp field.
     * When used with Cloud DLP, these pseudo-column names are case sensitive.
     * &lt;ul&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
     * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
     * &lt;/ul&gt;
     * &lt;b&gt;For Datastore&lt;/b&gt;
     * If this value is specified, then entities are filtered based on the given
     * start and end times. If an entity does not contain the provided timestamp
     * property or contains empty or invalid values, then it is included.
     * Valid data types of the provided timestamp property are: `TIMESTAMP`.
     * See the
     * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
     * related to this operation.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getTimestampFieldOrBuilder() {
      return getTimestampField();
    }

    public static final int ENABLE_AUTO_POPULATION_OF_TIMESPAN_CONFIG_FIELD_NUMBER = 4;
    private boolean enableAutoPopulationOfTimespanConfig_;
    /**
     *
     *
     * <pre>
     * When the job is started by a JobTrigger we will automatically figure out
     * a valid start_time to avoid scanning files that have not been modified
     * since the last time the JobTrigger executed. This will be based on the
     * time of the execution of the last run of the JobTrigger or the timespan
     * end_time used in the last run of the JobTrigger.
     * </pre>
     *
     * <code>bool enable_auto_population_of_timespan_config = 4;</code>
     *
     * @return The enableAutoPopulationOfTimespanConfig.
     */
    @java.lang.Override
    public boolean getEnableAutoPopulationOfTimespanConfig() {
      return enableAutoPopulationOfTimespanConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (startTime_ != null) {
        output.writeMessage(1, getStartTime());
      }
      if (endTime_ != null) {
        output.writeMessage(2, getEndTime());
      }
      if (timestampField_ != null) {
        output.writeMessage(3, getTimestampField());
      }
      if (enableAutoPopulationOfTimespanConfig_ != false) {
        output.writeBool(4, enableAutoPopulationOfTimespanConfig_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (startTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
      }
      if (endTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
      }
      if (timestampField_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTimestampField());
      }
      if (enableAutoPopulationOfTimespanConfig_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                4, enableAutoPopulationOfTimespanConfig_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.StorageConfig.TimespanConfig)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.StorageConfig.TimespanConfig other =
          (com.google.privacy.dlp.v2.StorageConfig.TimespanConfig) obj;

      if (hasStartTime() != other.hasStartTime()) return false;
      if (hasStartTime()) {
        if (!getStartTime().equals(other.getStartTime())) return false;
      }
      if (hasEndTime() != other.hasEndTime()) return false;
      if (hasEndTime()) {
        if (!getEndTime().equals(other.getEndTime())) return false;
      }
      if (hasTimestampField() != other.hasTimestampField()) return false;
      if (hasTimestampField()) {
        if (!getTimestampField().equals(other.getTimestampField())) return false;
      }
      if (getEnableAutoPopulationOfTimespanConfig()
          != other.getEnableAutoPopulationOfTimespanConfig()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStartTime()) {
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
      }
      if (hasEndTime()) {
        hash = (37 * hash) + END_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getEndTime().hashCode();
      }
      if (hasTimestampField()) {
        hash = (37 * hash) + TIMESTAMP_FIELD_FIELD_NUMBER;
        hash = (53 * hash) + getTimestampField().hashCode();
      }
      hash = (37 * hash) + ENABLE_AUTO_POPULATION_OF_TIMESPAN_CONFIG_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getEnableAutoPopulationOfTimespanConfig());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.StorageConfig.TimespanConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration of the timespan of the items to include in scanning.
     * Currently only supported when inspecting Cloud Storage and BigQuery.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.StorageConfig.TimespanConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.StorageConfig.TimespanConfig)
        com.google.privacy.dlp.v2.StorageConfig.TimespanConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_StorageConfig_TimespanConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_StorageConfig_TimespanConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.class,
                com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (startTimeBuilder_ == null) {
          startTime_ = null;
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }
        if (endTimeBuilder_ == null) {
          endTime_ = null;
        } else {
          endTime_ = null;
          endTimeBuilder_ = null;
        }
        if (timestampFieldBuilder_ == null) {
          timestampField_ = null;
        } else {
          timestampField_ = null;
          timestampFieldBuilder_ = null;
        }
        enableAutoPopulationOfTimespanConfig_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_StorageConfig_TimespanConfig_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.StorageConfig.TimespanConfig getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.StorageConfig.TimespanConfig build() {
        com.google.privacy.dlp.v2.StorageConfig.TimespanConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.StorageConfig.TimespanConfig buildPartial() {
        com.google.privacy.dlp.v2.StorageConfig.TimespanConfig result =
            new com.google.privacy.dlp.v2.StorageConfig.TimespanConfig(this);
        if (startTimeBuilder_ == null) {
          result.startTime_ = startTime_;
        } else {
          result.startTime_ = startTimeBuilder_.build();
        }
        if (endTimeBuilder_ == null) {
          result.endTime_ = endTime_;
        } else {
          result.endTime_ = endTimeBuilder_.build();
        }
        if (timestampFieldBuilder_ == null) {
          result.timestampField_ = timestampField_;
        } else {
          result.timestampField_ = timestampFieldBuilder_.build();
        }
        result.enableAutoPopulationOfTimespanConfig_ = enableAutoPopulationOfTimespanConfig_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.StorageConfig.TimespanConfig) {
          return mergeFrom((com.google.privacy.dlp.v2.StorageConfig.TimespanConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.StorageConfig.TimespanConfig other) {
        if (other == com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.getDefaultInstance())
          return this;
        if (other.hasStartTime()) {
          mergeStartTime(other.getStartTime());
        }
        if (other.hasEndTime()) {
          mergeEndTime(other.getEndTime());
        }
        if (other.hasTimestampField()) {
          mergeTimestampField(other.getTimestampField());
        }
        if (other.getEnableAutoPopulationOfTimespanConfig() != false) {
          setEnableAutoPopulationOfTimespanConfig(other.getEnableAutoPopulationOfTimespanConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getTimestampFieldFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              case 32:
                {
                  enableAutoPopulationOfTimespanConfig_ = input.readBool();

                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.protobuf.Timestamp startTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          startTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows older than this value.
       * If not set, no lower time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return Whether the startTime field is set.
       */
      public boolean hasStartTime() {
        return startTimeBuilder_ != null || startTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows older than this value.
       * If not set, no lower time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return The startTime.
       */
      public com.google.protobuf.Timestamp getStartTime() {
        if (startTimeBuilder_ == null) {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        } else {
          return startTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows older than this value.
       * If not set, no lower time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTime_ = value;
          onChanged();
        } else {
          startTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows older than this value.
       * If not set, no lower time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (startTimeBuilder_ == null) {
          startTime_ = builderForValue.build();
          onChanged();
        } else {
          startTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows older than this value.
       * If not set, no lower time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
        if (startTimeBuilder_ == null) {
          if (startTime_ != null) {
            startTime_ =
                com.google.protobuf.Timestamp.newBuilder(startTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            startTime_ = value;
          }
          onChanged();
        } else {
          startTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows older than this value.
       * If not set, no lower time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public Builder clearStartTime() {
        if (startTimeBuilder_ == null) {
          startTime_ = null;
          onChanged();
        } else {
          startTime_ = null;
          startTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows older than this value.
       * If not set, no lower time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

        onChanged();
        return getStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows older than this value.
       * If not set, no lower time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        if (startTimeBuilder_ != null) {
          return startTimeBuilder_.getMessageOrBuilder();
        } else {
          return startTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows older than this value.
       * If not set, no lower time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStartTimeFieldBuilder() {
        if (startTimeBuilder_ == null) {
          startTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStartTime(), getParentForChildren(), isClean());
          startTime_ = null;
        }
        return startTimeBuilder_;
      }

      private com.google.protobuf.Timestamp endTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          endTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows newer than this value.
       * If not set, no upper time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       *
       * @return Whether the endTime field is set.
       */
      public boolean hasEndTime() {
        return endTimeBuilder_ != null || endTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows newer than this value.
       * If not set, no upper time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       *
       * @return The endTime.
       */
      public com.google.protobuf.Timestamp getEndTime() {
        if (endTimeBuilder_ == null) {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        } else {
          return endTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows newer than this value.
       * If not set, no upper time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endTime_ = value;
          onChanged();
        } else {
          endTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows newer than this value.
       * If not set, no upper time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (endTimeBuilder_ == null) {
          endTime_ = builderForValue.build();
          onChanged();
        } else {
          endTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows newer than this value.
       * If not set, no upper time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
        if (endTimeBuilder_ == null) {
          if (endTime_ != null) {
            endTime_ =
                com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
          } else {
            endTime_ = value;
          }
          onChanged();
        } else {
          endTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows newer than this value.
       * If not set, no upper time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public Builder clearEndTime() {
        if (endTimeBuilder_ == null) {
          endTime_ = null;
          onChanged();
        } else {
          endTime_ = null;
          endTimeBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows newer than this value.
       * If not set, no upper time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

        onChanged();
        return getEndTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows newer than this value.
       * If not set, no upper time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
        if (endTimeBuilder_ != null) {
          return endTimeBuilder_.getMessageOrBuilder();
        } else {
          return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Exclude files, tables, or rows newer than this value.
       * If not set, no upper time limit is applied.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEndTimeFieldBuilder() {
        if (endTimeBuilder_ == null) {
          endTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEndTime(), getParentForChildren(), isClean());
          endTime_ = null;
        }
        return endTimeBuilder_;
      }

      private com.google.privacy.dlp.v2.FieldId timestampField_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.FieldId,
              com.google.privacy.dlp.v2.FieldId.Builder,
              com.google.privacy.dlp.v2.FieldIdOrBuilder>
          timestampFieldBuilder_;
      /**
       *
       *
       * <pre>
       * Specification of the field containing the timestamp of scanned items.
       * Used for data sources like Datastore and BigQuery.
       * &lt;b&gt;For BigQuery&lt;/b&gt;
       * If this value is not specified and the table was modified between the
       * given start and end times, the entire table will be scanned. If this
       * value is specified, then rows are filtered based on the given start and
       * end times. Rows with a `NULL` value in the provided BigQuery column are
       * skipped.
       * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
       * `TIMESTAMP`, and `DATETIME`.
       * If your BigQuery table is [partitioned at ingestion
       * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
       * you can use any of the following pseudo-columns as your timestamp field.
       * When used with Cloud DLP, these pseudo-column names are case sensitive.
       * &lt;ul&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
       * &lt;/ul&gt;
       * &lt;b&gt;For Datastore&lt;/b&gt;
       * If this value is specified, then entities are filtered based on the given
       * start and end times. If an entity does not contain the provided timestamp
       * property or contains empty or invalid values, then it is included.
       * Valid data types of the provided timestamp property are: `TIMESTAMP`.
       * See the
       * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
       * related to this operation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
       *
       * @return Whether the timestampField field is set.
       */
      public boolean hasTimestampField() {
        return timestampFieldBuilder_ != null || timestampField_ != null;
      }
      /**
       *
       *
       * <pre>
       * Specification of the field containing the timestamp of scanned items.
       * Used for data sources like Datastore and BigQuery.
       * &lt;b&gt;For BigQuery&lt;/b&gt;
       * If this value is not specified and the table was modified between the
       * given start and end times, the entire table will be scanned. If this
       * value is specified, then rows are filtered based on the given start and
       * end times. Rows with a `NULL` value in the provided BigQuery column are
       * skipped.
       * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
       * `TIMESTAMP`, and `DATETIME`.
       * If your BigQuery table is [partitioned at ingestion
       * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
       * you can use any of the following pseudo-columns as your timestamp field.
       * When used with Cloud DLP, these pseudo-column names are case sensitive.
       * &lt;ul&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
       * &lt;/ul&gt;
       * &lt;b&gt;For Datastore&lt;/b&gt;
       * If this value is specified, then entities are filtered based on the given
       * start and end times. If an entity does not contain the provided timestamp
       * property or contains empty or invalid values, then it is included.
       * Valid data types of the provided timestamp property are: `TIMESTAMP`.
       * See the
       * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
       * related to this operation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
       *
       * @return The timestampField.
       */
      public com.google.privacy.dlp.v2.FieldId getTimestampField() {
        if (timestampFieldBuilder_ == null) {
          return timestampField_ == null
              ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance()
              : timestampField_;
        } else {
          return timestampFieldBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Specification of the field containing the timestamp of scanned items.
       * Used for data sources like Datastore and BigQuery.
       * &lt;b&gt;For BigQuery&lt;/b&gt;
       * If this value is not specified and the table was modified between the
       * given start and end times, the entire table will be scanned. If this
       * value is specified, then rows are filtered based on the given start and
       * end times. Rows with a `NULL` value in the provided BigQuery column are
       * skipped.
       * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
       * `TIMESTAMP`, and `DATETIME`.
       * If your BigQuery table is [partitioned at ingestion
       * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
       * you can use any of the following pseudo-columns as your timestamp field.
       * When used with Cloud DLP, these pseudo-column names are case sensitive.
       * &lt;ul&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
       * &lt;/ul&gt;
       * &lt;b&gt;For Datastore&lt;/b&gt;
       * If this value is specified, then entities are filtered based on the given
       * start and end times. If an entity does not contain the provided timestamp
       * property or contains empty or invalid values, then it is included.
       * Valid data types of the provided timestamp property are: `TIMESTAMP`.
       * See the
       * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
       * related to this operation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
       */
      public Builder setTimestampField(com.google.privacy.dlp.v2.FieldId value) {
        if (timestampFieldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestampField_ = value;
          onChanged();
        } else {
          timestampFieldBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the field containing the timestamp of scanned items.
       * Used for data sources like Datastore and BigQuery.
       * &lt;b&gt;For BigQuery&lt;/b&gt;
       * If this value is not specified and the table was modified between the
       * given start and end times, the entire table will be scanned. If this
       * value is specified, then rows are filtered based on the given start and
       * end times. Rows with a `NULL` value in the provided BigQuery column are
       * skipped.
       * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
       * `TIMESTAMP`, and `DATETIME`.
       * If your BigQuery table is [partitioned at ingestion
       * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
       * you can use any of the following pseudo-columns as your timestamp field.
       * When used with Cloud DLP, these pseudo-column names are case sensitive.
       * &lt;ul&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
       * &lt;/ul&gt;
       * &lt;b&gt;For Datastore&lt;/b&gt;
       * If this value is specified, then entities are filtered based on the given
       * start and end times. If an entity does not contain the provided timestamp
       * property or contains empty or invalid values, then it is included.
       * Valid data types of the provided timestamp property are: `TIMESTAMP`.
       * See the
       * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
       * related to this operation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
       */
      public Builder setTimestampField(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
        if (timestampFieldBuilder_ == null) {
          timestampField_ = builderForValue.build();
          onChanged();
        } else {
          timestampFieldBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the field containing the timestamp of scanned items.
       * Used for data sources like Datastore and BigQuery.
       * &lt;b&gt;For BigQuery&lt;/b&gt;
       * If this value is not specified and the table was modified between the
       * given start and end times, the entire table will be scanned. If this
       * value is specified, then rows are filtered based on the given start and
       * end times. Rows with a `NULL` value in the provided BigQuery column are
       * skipped.
       * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
       * `TIMESTAMP`, and `DATETIME`.
       * If your BigQuery table is [partitioned at ingestion
       * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
       * you can use any of the following pseudo-columns as your timestamp field.
       * When used with Cloud DLP, these pseudo-column names are case sensitive.
       * &lt;ul&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
       * &lt;/ul&gt;
       * &lt;b&gt;For Datastore&lt;/b&gt;
       * If this value is specified, then entities are filtered based on the given
       * start and end times. If an entity does not contain the provided timestamp
       * property or contains empty or invalid values, then it is included.
       * Valid data types of the provided timestamp property are: `TIMESTAMP`.
       * See the
       * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
       * related to this operation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
       */
      public Builder mergeTimestampField(com.google.privacy.dlp.v2.FieldId value) {
        if (timestampFieldBuilder_ == null) {
          if (timestampField_ != null) {
            timestampField_ =
                com.google.privacy.dlp.v2.FieldId.newBuilder(timestampField_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            timestampField_ = value;
          }
          onChanged();
        } else {
          timestampFieldBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the field containing the timestamp of scanned items.
       * Used for data sources like Datastore and BigQuery.
       * &lt;b&gt;For BigQuery&lt;/b&gt;
       * If this value is not specified and the table was modified between the
       * given start and end times, the entire table will be scanned. If this
       * value is specified, then rows are filtered based on the given start and
       * end times. Rows with a `NULL` value in the provided BigQuery column are
       * skipped.
       * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
       * `TIMESTAMP`, and `DATETIME`.
       * If your BigQuery table is [partitioned at ingestion
       * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
       * you can use any of the following pseudo-columns as your timestamp field.
       * When used with Cloud DLP, these pseudo-column names are case sensitive.
       * &lt;ul&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
       * &lt;/ul&gt;
       * &lt;b&gt;For Datastore&lt;/b&gt;
       * If this value is specified, then entities are filtered based on the given
       * start and end times. If an entity does not contain the provided timestamp
       * property or contains empty or invalid values, then it is included.
       * Valid data types of the provided timestamp property are: `TIMESTAMP`.
       * See the
       * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
       * related to this operation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
       */
      public Builder clearTimestampField() {
        if (timestampFieldBuilder_ == null) {
          timestampField_ = null;
          onChanged();
        } else {
          timestampField_ = null;
          timestampFieldBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the field containing the timestamp of scanned items.
       * Used for data sources like Datastore and BigQuery.
       * &lt;b&gt;For BigQuery&lt;/b&gt;
       * If this value is not specified and the table was modified between the
       * given start and end times, the entire table will be scanned. If this
       * value is specified, then rows are filtered based on the given start and
       * end times. Rows with a `NULL` value in the provided BigQuery column are
       * skipped.
       * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
       * `TIMESTAMP`, and `DATETIME`.
       * If your BigQuery table is [partitioned at ingestion
       * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
       * you can use any of the following pseudo-columns as your timestamp field.
       * When used with Cloud DLP, these pseudo-column names are case sensitive.
       * &lt;ul&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
       * &lt;/ul&gt;
       * &lt;b&gt;For Datastore&lt;/b&gt;
       * If this value is specified, then entities are filtered based on the given
       * start and end times. If an entity does not contain the provided timestamp
       * property or contains empty or invalid values, then it is included.
       * Valid data types of the provided timestamp property are: `TIMESTAMP`.
       * See the
       * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
       * related to this operation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
       */
      public com.google.privacy.dlp.v2.FieldId.Builder getTimestampFieldBuilder() {

        onChanged();
        return getTimestampFieldFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Specification of the field containing the timestamp of scanned items.
       * Used for data sources like Datastore and BigQuery.
       * &lt;b&gt;For BigQuery&lt;/b&gt;
       * If this value is not specified and the table was modified between the
       * given start and end times, the entire table will be scanned. If this
       * value is specified, then rows are filtered based on the given start and
       * end times. Rows with a `NULL` value in the provided BigQuery column are
       * skipped.
       * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
       * `TIMESTAMP`, and `DATETIME`.
       * If your BigQuery table is [partitioned at ingestion
       * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
       * you can use any of the following pseudo-columns as your timestamp field.
       * When used with Cloud DLP, these pseudo-column names are case sensitive.
       * &lt;ul&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
       * &lt;/ul&gt;
       * &lt;b&gt;For Datastore&lt;/b&gt;
       * If this value is specified, then entities are filtered based on the given
       * start and end times. If an entity does not contain the provided timestamp
       * property or contains empty or invalid values, then it is included.
       * Valid data types of the provided timestamp property are: `TIMESTAMP`.
       * See the
       * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
       * related to this operation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
       */
      public com.google.privacy.dlp.v2.FieldIdOrBuilder getTimestampFieldOrBuilder() {
        if (timestampFieldBuilder_ != null) {
          return timestampFieldBuilder_.getMessageOrBuilder();
        } else {
          return timestampField_ == null
              ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance()
              : timestampField_;
        }
      }
      /**
       *
       *
       * <pre>
       * Specification of the field containing the timestamp of scanned items.
       * Used for data sources like Datastore and BigQuery.
       * &lt;b&gt;For BigQuery&lt;/b&gt;
       * If this value is not specified and the table was modified between the
       * given start and end times, the entire table will be scanned. If this
       * value is specified, then rows are filtered based on the given start and
       * end times. Rows with a `NULL` value in the provided BigQuery column are
       * skipped.
       * Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
       * `TIMESTAMP`, and `DATETIME`.
       * If your BigQuery table is [partitioned at ingestion
       * time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
       * you can use any of the following pseudo-columns as your timestamp field.
       * When used with Cloud DLP, these pseudo-column names are case sensitive.
       * &lt;ul&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONTIME&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITIONDATE&lt;/code&gt;&lt;/li&gt;
       * &lt;li&gt;&lt;code&gt;_PARTITION_LOAD_TIME&lt;/code&gt;&lt;/li&gt;
       * &lt;/ul&gt;
       * &lt;b&gt;For Datastore&lt;/b&gt;
       * If this value is specified, then entities are filtered based on the given
       * start and end times. If an entity does not contain the provided timestamp
       * property or contains empty or invalid values, then it is included.
       * Valid data types of the provided timestamp property are: `TIMESTAMP`.
       * See the
       * [known issue](https://cloud.google.com/dlp/docs/known-issues#bq-timespan)
       * related to this operation.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.FieldId timestamp_field = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.FieldId,
              com.google.privacy.dlp.v2.FieldId.Builder,
              com.google.privacy.dlp.v2.FieldIdOrBuilder>
          getTimestampFieldFieldBuilder() {
        if (timestampFieldBuilder_ == null) {
          timestampFieldBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.FieldId,
                  com.google.privacy.dlp.v2.FieldId.Builder,
                  com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                  getTimestampField(), getParentForChildren(), isClean());
          timestampField_ = null;
        }
        return timestampFieldBuilder_;
      }

      private boolean enableAutoPopulationOfTimespanConfig_;
      /**
       *
       *
       * <pre>
       * When the job is started by a JobTrigger we will automatically figure out
       * a valid start_time to avoid scanning files that have not been modified
       * since the last time the JobTrigger executed. This will be based on the
       * time of the execution of the last run of the JobTrigger or the timespan
       * end_time used in the last run of the JobTrigger.
       * </pre>
       *
       * <code>bool enable_auto_population_of_timespan_config = 4;</code>
       *
       * @return The enableAutoPopulationOfTimespanConfig.
       */
      @java.lang.Override
      public boolean getEnableAutoPopulationOfTimespanConfig() {
        return enableAutoPopulationOfTimespanConfig_;
      }
      /**
       *
       *
       * <pre>
       * When the job is started by a JobTrigger we will automatically figure out
       * a valid start_time to avoid scanning files that have not been modified
       * since the last time the JobTrigger executed. This will be based on the
       * time of the execution of the last run of the JobTrigger or the timespan
       * end_time used in the last run of the JobTrigger.
       * </pre>
       *
       * <code>bool enable_auto_population_of_timespan_config = 4;</code>
       *
       * @param value The enableAutoPopulationOfTimespanConfig to set.
       * @return This builder for chaining.
       */
      public Builder setEnableAutoPopulationOfTimespanConfig(boolean value) {

        enableAutoPopulationOfTimespanConfig_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * When the job is started by a JobTrigger we will automatically figure out
       * a valid start_time to avoid scanning files that have not been modified
       * since the last time the JobTrigger executed. This will be based on the
       * time of the execution of the last run of the JobTrigger or the timespan
       * end_time used in the last run of the JobTrigger.
       * </pre>
       *
       * <code>bool enable_auto_population_of_timespan_config = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableAutoPopulationOfTimespanConfig() {

        enableAutoPopulationOfTimespanConfig_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.StorageConfig.TimespanConfig)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.StorageConfig.TimespanConfig)
    private static final com.google.privacy.dlp.v2.StorageConfig.TimespanConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.StorageConfig.TimespanConfig();
    }

    public static com.google.privacy.dlp.v2.StorageConfig.TimespanConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TimespanConfig> PARSER =
        new com.google.protobuf.AbstractParser<TimespanConfig>() {
          @java.lang.Override
          public TimespanConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TimespanConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TimespanConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StorageConfig.TimespanConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int typeCase_ = 0;
  private java.lang.Object type_;

  public enum TypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DATASTORE_OPTIONS(2),
    CLOUD_STORAGE_OPTIONS(3),
    BIG_QUERY_OPTIONS(4),
    HYBRID_OPTIONS(9),
    TYPE_NOT_SET(0);
    private final int value;

    private TypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return DATASTORE_OPTIONS;
        case 3:
          return CLOUD_STORAGE_OPTIONS;
        case 4:
          return BIG_QUERY_OPTIONS;
        case 9:
          return HYBRID_OPTIONS;
        case 0:
          return TYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeCase getTypeCase() {
    return TypeCase.forNumber(typeCase_);
  }

  public static final int DATASTORE_OPTIONS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Google Cloud Datastore options.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DatastoreOptions datastore_options = 2;</code>
   *
   * @return Whether the datastoreOptions field is set.
   */
  @java.lang.Override
  public boolean hasDatastoreOptions() {
    return typeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Google Cloud Datastore options.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DatastoreOptions datastore_options = 2;</code>
   *
   * @return The datastoreOptions.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DatastoreOptions getDatastoreOptions() {
    if (typeCase_ == 2) {
      return (com.google.privacy.dlp.v2.DatastoreOptions) type_;
    }
    return com.google.privacy.dlp.v2.DatastoreOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Google Cloud Datastore options.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DatastoreOptions datastore_options = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DatastoreOptionsOrBuilder getDatastoreOptionsOrBuilder() {
    if (typeCase_ == 2) {
      return (com.google.privacy.dlp.v2.DatastoreOptions) type_;
    }
    return com.google.privacy.dlp.v2.DatastoreOptions.getDefaultInstance();
  }

  public static final int CLOUD_STORAGE_OPTIONS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Cloud Storage options.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudStorageOptions cloud_storage_options = 3;</code>
   *
   * @return Whether the cloudStorageOptions field is set.
   */
  @java.lang.Override
  public boolean hasCloudStorageOptions() {
    return typeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage options.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudStorageOptions cloud_storage_options = 3;</code>
   *
   * @return The cloudStorageOptions.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudStorageOptions getCloudStorageOptions() {
    if (typeCase_ == 3) {
      return (com.google.privacy.dlp.v2.CloudStorageOptions) type_;
    }
    return com.google.privacy.dlp.v2.CloudStorageOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage options.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudStorageOptions cloud_storage_options = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudStorageOptionsOrBuilder getCloudStorageOptionsOrBuilder() {
    if (typeCase_ == 3) {
      return (com.google.privacy.dlp.v2.CloudStorageOptions) type_;
    }
    return com.google.privacy.dlp.v2.CloudStorageOptions.getDefaultInstance();
  }

  public static final int BIG_QUERY_OPTIONS_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * BigQuery options.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryOptions big_query_options = 4;</code>
   *
   * @return Whether the bigQueryOptions field is set.
   */
  @java.lang.Override
  public boolean hasBigQueryOptions() {
    return typeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * BigQuery options.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryOptions big_query_options = 4;</code>
   *
   * @return The bigQueryOptions.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryOptions getBigQueryOptions() {
    if (typeCase_ == 4) {
      return (com.google.privacy.dlp.v2.BigQueryOptions) type_;
    }
    return com.google.privacy.dlp.v2.BigQueryOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * BigQuery options.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryOptions big_query_options = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryOptionsOrBuilder getBigQueryOptionsOrBuilder() {
    if (typeCase_ == 4) {
      return (com.google.privacy.dlp.v2.BigQueryOptions) type_;
    }
    return com.google.privacy.dlp.v2.BigQueryOptions.getDefaultInstance();
  }

  public static final int HYBRID_OPTIONS_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Hybrid inspection options.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.HybridOptions hybrid_options = 9;</code>
   *
   * @return Whether the hybridOptions field is set.
   */
  @java.lang.Override
  public boolean hasHybridOptions() {
    return typeCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Hybrid inspection options.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.HybridOptions hybrid_options = 9;</code>
   *
   * @return The hybridOptions.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.HybridOptions getHybridOptions() {
    if (typeCase_ == 9) {
      return (com.google.privacy.dlp.v2.HybridOptions) type_;
    }
    return com.google.privacy.dlp.v2.HybridOptions.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Hybrid inspection options.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.HybridOptions hybrid_options = 9;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.HybridOptionsOrBuilder getHybridOptionsOrBuilder() {
    if (typeCase_ == 9) {
      return (com.google.privacy.dlp.v2.HybridOptions) type_;
    }
    return com.google.privacy.dlp.v2.HybridOptions.getDefaultInstance();
  }

  public static final int TIMESPAN_CONFIG_FIELD_NUMBER = 6;
  private com.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespanConfig_;
  /**
   * <code>.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespan_config = 6;</code>
   *
   * @return Whether the timespanConfig field is set.
   */
  @java.lang.Override
  public boolean hasTimespanConfig() {
    return timespanConfig_ != null;
  }
  /**
   * <code>.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespan_config = 6;</code>
   *
   * @return The timespanConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StorageConfig.TimespanConfig getTimespanConfig() {
    return timespanConfig_ == null
        ? com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.getDefaultInstance()
        : timespanConfig_;
  }
  /** <code>.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespan_config = 6;</code> */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StorageConfig.TimespanConfigOrBuilder
      getTimespanConfigOrBuilder() {
    return getTimespanConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (typeCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.DatastoreOptions) type_);
    }
    if (typeCase_ == 3) {
      output.writeMessage(3, (com.google.privacy.dlp.v2.CloudStorageOptions) type_);
    }
    if (typeCase_ == 4) {
      output.writeMessage(4, (com.google.privacy.dlp.v2.BigQueryOptions) type_);
    }
    if (timespanConfig_ != null) {
      output.writeMessage(6, getTimespanConfig());
    }
    if (typeCase_ == 9) {
      output.writeMessage(9, (com.google.privacy.dlp.v2.HybridOptions) type_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (typeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.DatastoreOptions) type_);
    }
    if (typeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.CloudStorageOptions) type_);
    }
    if (typeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.privacy.dlp.v2.BigQueryOptions) type_);
    }
    if (timespanConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getTimespanConfig());
    }
    if (typeCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.privacy.dlp.v2.HybridOptions) type_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.StorageConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.StorageConfig other = (com.google.privacy.dlp.v2.StorageConfig) obj;

    if (hasTimespanConfig() != other.hasTimespanConfig()) return false;
    if (hasTimespanConfig()) {
      if (!getTimespanConfig().equals(other.getTimespanConfig())) return false;
    }
    if (!getTypeCase().equals(other.getTypeCase())) return false;
    switch (typeCase_) {
      case 2:
        if (!getDatastoreOptions().equals(other.getDatastoreOptions())) return false;
        break;
      case 3:
        if (!getCloudStorageOptions().equals(other.getCloudStorageOptions())) return false;
        break;
      case 4:
        if (!getBigQueryOptions().equals(other.getBigQueryOptions())) return false;
        break;
      case 9:
        if (!getHybridOptions().equals(other.getHybridOptions())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTimespanConfig()) {
      hash = (37 * hash) + TIMESPAN_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getTimespanConfig().hashCode();
    }
    switch (typeCase_) {
      case 2:
        hash = (37 * hash) + DATASTORE_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getDatastoreOptions().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CLOUD_STORAGE_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getCloudStorageOptions().hashCode();
        break;
      case 4:
        hash = (37 * hash) + BIG_QUERY_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getBigQueryOptions().hashCode();
        break;
      case 9:
        hash = (37 * hash) + HYBRID_OPTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getHybridOptions().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.StorageConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StorageConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StorageConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StorageConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StorageConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.StorageConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StorageConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StorageConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StorageConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StorageConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.StorageConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.StorageConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.StorageConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Shared message indicating Cloud storage type.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.StorageConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.StorageConfig)
      com.google.privacy.dlp.v2.StorageConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_StorageConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_StorageConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.StorageConfig.class,
              com.google.privacy.dlp.v2.StorageConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.StorageConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (datastoreOptionsBuilder_ != null) {
        datastoreOptionsBuilder_.clear();
      }
      if (cloudStorageOptionsBuilder_ != null) {
        cloudStorageOptionsBuilder_.clear();
      }
      if (bigQueryOptionsBuilder_ != null) {
        bigQueryOptionsBuilder_.clear();
      }
      if (hybridOptionsBuilder_ != null) {
        hybridOptionsBuilder_.clear();
      }
      if (timespanConfigBuilder_ == null) {
        timespanConfig_ = null;
      } else {
        timespanConfig_ = null;
        timespanConfigBuilder_ = null;
      }
      typeCase_ = 0;
      type_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_StorageConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StorageConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.StorageConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StorageConfig build() {
      com.google.privacy.dlp.v2.StorageConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.StorageConfig buildPartial() {
      com.google.privacy.dlp.v2.StorageConfig result =
          new com.google.privacy.dlp.v2.StorageConfig(this);
      if (typeCase_ == 2) {
        if (datastoreOptionsBuilder_ == null) {
          result.type_ = type_;
        } else {
          result.type_ = datastoreOptionsBuilder_.build();
        }
      }
      if (typeCase_ == 3) {
        if (cloudStorageOptionsBuilder_ == null) {
          result.type_ = type_;
        } else {
          result.type_ = cloudStorageOptionsBuilder_.build();
        }
      }
      if (typeCase_ == 4) {
        if (bigQueryOptionsBuilder_ == null) {
          result.type_ = type_;
        } else {
          result.type_ = bigQueryOptionsBuilder_.build();
        }
      }
      if (typeCase_ == 9) {
        if (hybridOptionsBuilder_ == null) {
          result.type_ = type_;
        } else {
          result.type_ = hybridOptionsBuilder_.build();
        }
      }
      if (timespanConfigBuilder_ == null) {
        result.timespanConfig_ = timespanConfig_;
      } else {
        result.timespanConfig_ = timespanConfigBuilder_.build();
      }
      result.typeCase_ = typeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.StorageConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.StorageConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.StorageConfig other) {
      if (other == com.google.privacy.dlp.v2.StorageConfig.getDefaultInstance()) return this;
      if (other.hasTimespanConfig()) {
        mergeTimespanConfig(other.getTimespanConfig());
      }
      switch (other.getTypeCase()) {
        case DATASTORE_OPTIONS:
          {
            mergeDatastoreOptions(other.getDatastoreOptions());
            break;
          }
        case CLOUD_STORAGE_OPTIONS:
          {
            mergeCloudStorageOptions(other.getCloudStorageOptions());
            break;
          }
        case BIG_QUERY_OPTIONS:
          {
            mergeBigQueryOptions(other.getBigQueryOptions());
            break;
          }
        case HYBRID_OPTIONS:
          {
            mergeHybridOptions(other.getHybridOptions());
            break;
          }
        case TYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(
                    getDatastoreOptionsFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getCloudStorageOptionsFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getBigQueryOptionsFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 4;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(getTimespanConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 74:
              {
                input.readMessage(getHybridOptionsFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 9;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public Builder clearType() {
      typeCase_ = 0;
      type_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DatastoreOptions,
            com.google.privacy.dlp.v2.DatastoreOptions.Builder,
            com.google.privacy.dlp.v2.DatastoreOptionsOrBuilder>
        datastoreOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Google Cloud Datastore options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatastoreOptions datastore_options = 2;</code>
     *
     * @return Whether the datastoreOptions field is set.
     */
    @java.lang.Override
    public boolean hasDatastoreOptions() {
      return typeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Datastore options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatastoreOptions datastore_options = 2;</code>
     *
     * @return The datastoreOptions.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DatastoreOptions getDatastoreOptions() {
      if (datastoreOptionsBuilder_ == null) {
        if (typeCase_ == 2) {
          return (com.google.privacy.dlp.v2.DatastoreOptions) type_;
        }
        return com.google.privacy.dlp.v2.DatastoreOptions.getDefaultInstance();
      } else {
        if (typeCase_ == 2) {
          return datastoreOptionsBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.DatastoreOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Datastore options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatastoreOptions datastore_options = 2;</code>
     */
    public Builder setDatastoreOptions(com.google.privacy.dlp.v2.DatastoreOptions value) {
      if (datastoreOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        datastoreOptionsBuilder_.setMessage(value);
      }
      typeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Datastore options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatastoreOptions datastore_options = 2;</code>
     */
    public Builder setDatastoreOptions(
        com.google.privacy.dlp.v2.DatastoreOptions.Builder builderForValue) {
      if (datastoreOptionsBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        datastoreOptionsBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Datastore options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatastoreOptions datastore_options = 2;</code>
     */
    public Builder mergeDatastoreOptions(com.google.privacy.dlp.v2.DatastoreOptions value) {
      if (datastoreOptionsBuilder_ == null) {
        if (typeCase_ == 2
            && type_ != com.google.privacy.dlp.v2.DatastoreOptions.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.DatastoreOptions.newBuilder(
                      (com.google.privacy.dlp.v2.DatastoreOptions) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 2) {
          datastoreOptionsBuilder_.mergeFrom(value);
        } else {
          datastoreOptionsBuilder_.setMessage(value);
        }
      }
      typeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Datastore options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatastoreOptions datastore_options = 2;</code>
     */
    public Builder clearDatastoreOptions() {
      if (datastoreOptionsBuilder_ == null) {
        if (typeCase_ == 2) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 2) {
          typeCase_ = 0;
          type_ = null;
        }
        datastoreOptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Datastore options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatastoreOptions datastore_options = 2;</code>
     */
    public com.google.privacy.dlp.v2.DatastoreOptions.Builder getDatastoreOptionsBuilder() {
      return getDatastoreOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Datastore options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatastoreOptions datastore_options = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DatastoreOptionsOrBuilder getDatastoreOptionsOrBuilder() {
      if ((typeCase_ == 2) && (datastoreOptionsBuilder_ != null)) {
        return datastoreOptionsBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 2) {
          return (com.google.privacy.dlp.v2.DatastoreOptions) type_;
        }
        return com.google.privacy.dlp.v2.DatastoreOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Datastore options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DatastoreOptions datastore_options = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DatastoreOptions,
            com.google.privacy.dlp.v2.DatastoreOptions.Builder,
            com.google.privacy.dlp.v2.DatastoreOptionsOrBuilder>
        getDatastoreOptionsFieldBuilder() {
      if (datastoreOptionsBuilder_ == null) {
        if (!(typeCase_ == 2)) {
          type_ = com.google.privacy.dlp.v2.DatastoreOptions.getDefaultInstance();
        }
        datastoreOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DatastoreOptions,
                com.google.privacy.dlp.v2.DatastoreOptions.Builder,
                com.google.privacy.dlp.v2.DatastoreOptionsOrBuilder>(
                (com.google.privacy.dlp.v2.DatastoreOptions) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 2;
      onChanged();
      ;
      return datastoreOptionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CloudStorageOptions,
            com.google.privacy.dlp.v2.CloudStorageOptions.Builder,
            com.google.privacy.dlp.v2.CloudStorageOptionsOrBuilder>
        cloudStorageOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud Storage options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions cloud_storage_options = 3;</code>
     *
     * @return Whether the cloudStorageOptions field is set.
     */
    @java.lang.Override
    public boolean hasCloudStorageOptions() {
      return typeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions cloud_storage_options = 3;</code>
     *
     * @return The cloudStorageOptions.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageOptions getCloudStorageOptions() {
      if (cloudStorageOptionsBuilder_ == null) {
        if (typeCase_ == 3) {
          return (com.google.privacy.dlp.v2.CloudStorageOptions) type_;
        }
        return com.google.privacy.dlp.v2.CloudStorageOptions.getDefaultInstance();
      } else {
        if (typeCase_ == 3) {
          return cloudStorageOptionsBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CloudStorageOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions cloud_storage_options = 3;</code>
     */
    public Builder setCloudStorageOptions(com.google.privacy.dlp.v2.CloudStorageOptions value) {
      if (cloudStorageOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        cloudStorageOptionsBuilder_.setMessage(value);
      }
      typeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions cloud_storage_options = 3;</code>
     */
    public Builder setCloudStorageOptions(
        com.google.privacy.dlp.v2.CloudStorageOptions.Builder builderForValue) {
      if (cloudStorageOptionsBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        cloudStorageOptionsBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions cloud_storage_options = 3;</code>
     */
    public Builder mergeCloudStorageOptions(com.google.privacy.dlp.v2.CloudStorageOptions value) {
      if (cloudStorageOptionsBuilder_ == null) {
        if (typeCase_ == 3
            && type_ != com.google.privacy.dlp.v2.CloudStorageOptions.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.CloudStorageOptions.newBuilder(
                      (com.google.privacy.dlp.v2.CloudStorageOptions) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 3) {
          cloudStorageOptionsBuilder_.mergeFrom(value);
        } else {
          cloudStorageOptionsBuilder_.setMessage(value);
        }
      }
      typeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions cloud_storage_options = 3;</code>
     */
    public Builder clearCloudStorageOptions() {
      if (cloudStorageOptionsBuilder_ == null) {
        if (typeCase_ == 3) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 3) {
          typeCase_ = 0;
          type_ = null;
        }
        cloudStorageOptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions cloud_storage_options = 3;</code>
     */
    public com.google.privacy.dlp.v2.CloudStorageOptions.Builder getCloudStorageOptionsBuilder() {
      return getCloudStorageOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions cloud_storage_options = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageOptionsOrBuilder
        getCloudStorageOptionsOrBuilder() {
      if ((typeCase_ == 3) && (cloudStorageOptionsBuilder_ != null)) {
        return cloudStorageOptionsBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 3) {
          return (com.google.privacy.dlp.v2.CloudStorageOptions) type_;
        }
        return com.google.privacy.dlp.v2.CloudStorageOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions cloud_storage_options = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CloudStorageOptions,
            com.google.privacy.dlp.v2.CloudStorageOptions.Builder,
            com.google.privacy.dlp.v2.CloudStorageOptionsOrBuilder>
        getCloudStorageOptionsFieldBuilder() {
      if (cloudStorageOptionsBuilder_ == null) {
        if (!(typeCase_ == 3)) {
          type_ = com.google.privacy.dlp.v2.CloudStorageOptions.getDefaultInstance();
        }
        cloudStorageOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CloudStorageOptions,
                com.google.privacy.dlp.v2.CloudStorageOptions.Builder,
                com.google.privacy.dlp.v2.CloudStorageOptionsOrBuilder>(
                (com.google.privacy.dlp.v2.CloudStorageOptions) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 3;
      onChanged();
      ;
      return cloudStorageOptionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryOptions,
            com.google.privacy.dlp.v2.BigQueryOptions.Builder,
            com.google.privacy.dlp.v2.BigQueryOptionsOrBuilder>
        bigQueryOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * BigQuery options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions big_query_options = 4;</code>
     *
     * @return Whether the bigQueryOptions field is set.
     */
    @java.lang.Override
    public boolean hasBigQueryOptions() {
      return typeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * BigQuery options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions big_query_options = 4;</code>
     *
     * @return The bigQueryOptions.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryOptions getBigQueryOptions() {
      if (bigQueryOptionsBuilder_ == null) {
        if (typeCase_ == 4) {
          return (com.google.privacy.dlp.v2.BigQueryOptions) type_;
        }
        return com.google.privacy.dlp.v2.BigQueryOptions.getDefaultInstance();
      } else {
        if (typeCase_ == 4) {
          return bigQueryOptionsBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.BigQueryOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions big_query_options = 4;</code>
     */
    public Builder setBigQueryOptions(com.google.privacy.dlp.v2.BigQueryOptions value) {
      if (bigQueryOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        bigQueryOptionsBuilder_.setMessage(value);
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions big_query_options = 4;</code>
     */
    public Builder setBigQueryOptions(
        com.google.privacy.dlp.v2.BigQueryOptions.Builder builderForValue) {
      if (bigQueryOptionsBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        bigQueryOptionsBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions big_query_options = 4;</code>
     */
    public Builder mergeBigQueryOptions(com.google.privacy.dlp.v2.BigQueryOptions value) {
      if (bigQueryOptionsBuilder_ == null) {
        if (typeCase_ == 4
            && type_ != com.google.privacy.dlp.v2.BigQueryOptions.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.BigQueryOptions.newBuilder(
                      (com.google.privacy.dlp.v2.BigQueryOptions) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 4) {
          bigQueryOptionsBuilder_.mergeFrom(value);
        } else {
          bigQueryOptionsBuilder_.setMessage(value);
        }
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions big_query_options = 4;</code>
     */
    public Builder clearBigQueryOptions() {
      if (bigQueryOptionsBuilder_ == null) {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
        }
        bigQueryOptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * BigQuery options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions big_query_options = 4;</code>
     */
    public com.google.privacy.dlp.v2.BigQueryOptions.Builder getBigQueryOptionsBuilder() {
      return getBigQueryOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * BigQuery options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions big_query_options = 4;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryOptionsOrBuilder getBigQueryOptionsOrBuilder() {
      if ((typeCase_ == 4) && (bigQueryOptionsBuilder_ != null)) {
        return bigQueryOptionsBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 4) {
          return (com.google.privacy.dlp.v2.BigQueryOptions) type_;
        }
        return com.google.privacy.dlp.v2.BigQueryOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * BigQuery options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryOptions big_query_options = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryOptions,
            com.google.privacy.dlp.v2.BigQueryOptions.Builder,
            com.google.privacy.dlp.v2.BigQueryOptionsOrBuilder>
        getBigQueryOptionsFieldBuilder() {
      if (bigQueryOptionsBuilder_ == null) {
        if (!(typeCase_ == 4)) {
          type_ = com.google.privacy.dlp.v2.BigQueryOptions.getDefaultInstance();
        }
        bigQueryOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.BigQueryOptions,
                com.google.privacy.dlp.v2.BigQueryOptions.Builder,
                com.google.privacy.dlp.v2.BigQueryOptionsOrBuilder>(
                (com.google.privacy.dlp.v2.BigQueryOptions) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 4;
      onChanged();
      ;
      return bigQueryOptionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.HybridOptions,
            com.google.privacy.dlp.v2.HybridOptions.Builder,
            com.google.privacy.dlp.v2.HybridOptionsOrBuilder>
        hybridOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Hybrid inspection options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.HybridOptions hybrid_options = 9;</code>
     *
     * @return Whether the hybridOptions field is set.
     */
    @java.lang.Override
    public boolean hasHybridOptions() {
      return typeCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Hybrid inspection options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.HybridOptions hybrid_options = 9;</code>
     *
     * @return The hybridOptions.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.HybridOptions getHybridOptions() {
      if (hybridOptionsBuilder_ == null) {
        if (typeCase_ == 9) {
          return (com.google.privacy.dlp.v2.HybridOptions) type_;
        }
        return com.google.privacy.dlp.v2.HybridOptions.getDefaultInstance();
      } else {
        if (typeCase_ == 9) {
          return hybridOptionsBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.HybridOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Hybrid inspection options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.HybridOptions hybrid_options = 9;</code>
     */
    public Builder setHybridOptions(com.google.privacy.dlp.v2.HybridOptions value) {
      if (hybridOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        hybridOptionsBuilder_.setMessage(value);
      }
      typeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hybrid inspection options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.HybridOptions hybrid_options = 9;</code>
     */
    public Builder setHybridOptions(
        com.google.privacy.dlp.v2.HybridOptions.Builder builderForValue) {
      if (hybridOptionsBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        hybridOptionsBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hybrid inspection options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.HybridOptions hybrid_options = 9;</code>
     */
    public Builder mergeHybridOptions(com.google.privacy.dlp.v2.HybridOptions value) {
      if (hybridOptionsBuilder_ == null) {
        if (typeCase_ == 9
            && type_ != com.google.privacy.dlp.v2.HybridOptions.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.HybridOptions.newBuilder(
                      (com.google.privacy.dlp.v2.HybridOptions) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 9) {
          hybridOptionsBuilder_.mergeFrom(value);
        } else {
          hybridOptionsBuilder_.setMessage(value);
        }
      }
      typeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hybrid inspection options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.HybridOptions hybrid_options = 9;</code>
     */
    public Builder clearHybridOptions() {
      if (hybridOptionsBuilder_ == null) {
        if (typeCase_ == 9) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 9) {
          typeCase_ = 0;
          type_ = null;
        }
        hybridOptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hybrid inspection options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.HybridOptions hybrid_options = 9;</code>
     */
    public com.google.privacy.dlp.v2.HybridOptions.Builder getHybridOptionsBuilder() {
      return getHybridOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Hybrid inspection options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.HybridOptions hybrid_options = 9;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.HybridOptionsOrBuilder getHybridOptionsOrBuilder() {
      if ((typeCase_ == 9) && (hybridOptionsBuilder_ != null)) {
        return hybridOptionsBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 9) {
          return (com.google.privacy.dlp.v2.HybridOptions) type_;
        }
        return com.google.privacy.dlp.v2.HybridOptions.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Hybrid inspection options.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.HybridOptions hybrid_options = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.HybridOptions,
            com.google.privacy.dlp.v2.HybridOptions.Builder,
            com.google.privacy.dlp.v2.HybridOptionsOrBuilder>
        getHybridOptionsFieldBuilder() {
      if (hybridOptionsBuilder_ == null) {
        if (!(typeCase_ == 9)) {
          type_ = com.google.privacy.dlp.v2.HybridOptions.getDefaultInstance();
        }
        hybridOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.HybridOptions,
                com.google.privacy.dlp.v2.HybridOptions.Builder,
                com.google.privacy.dlp.v2.HybridOptionsOrBuilder>(
                (com.google.privacy.dlp.v2.HybridOptions) type_, getParentForChildren(), isClean());
        type_ = null;
      }
      typeCase_ = 9;
      onChanged();
      ;
      return hybridOptionsBuilder_;
    }

    private com.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespanConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.StorageConfig.TimespanConfig,
            com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.Builder,
            com.google.privacy.dlp.v2.StorageConfig.TimespanConfigOrBuilder>
        timespanConfigBuilder_;
    /**
     * <code>.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespan_config = 6;</code>
     *
     * @return Whether the timespanConfig field is set.
     */
    public boolean hasTimespanConfig() {
      return timespanConfigBuilder_ != null || timespanConfig_ != null;
    }
    /**
     * <code>.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespan_config = 6;</code>
     *
     * @return The timespanConfig.
     */
    public com.google.privacy.dlp.v2.StorageConfig.TimespanConfig getTimespanConfig() {
      if (timespanConfigBuilder_ == null) {
        return timespanConfig_ == null
            ? com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.getDefaultInstance()
            : timespanConfig_;
      } else {
        return timespanConfigBuilder_.getMessage();
      }
    }
    /** <code>.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespan_config = 6;</code> */
    public Builder setTimespanConfig(com.google.privacy.dlp.v2.StorageConfig.TimespanConfig value) {
      if (timespanConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timespanConfig_ = value;
        onChanged();
      } else {
        timespanConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /** <code>.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespan_config = 6;</code> */
    public Builder setTimespanConfig(
        com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.Builder builderForValue) {
      if (timespanConfigBuilder_ == null) {
        timespanConfig_ = builderForValue.build();
        onChanged();
      } else {
        timespanConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /** <code>.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespan_config = 6;</code> */
    public Builder mergeTimespanConfig(
        com.google.privacy.dlp.v2.StorageConfig.TimespanConfig value) {
      if (timespanConfigBuilder_ == null) {
        if (timespanConfig_ != null) {
          timespanConfig_ =
              com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.newBuilder(timespanConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          timespanConfig_ = value;
        }
        onChanged();
      } else {
        timespanConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /** <code>.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespan_config = 6;</code> */
    public Builder clearTimespanConfig() {
      if (timespanConfigBuilder_ == null) {
        timespanConfig_ = null;
        onChanged();
      } else {
        timespanConfig_ = null;
        timespanConfigBuilder_ = null;
      }

      return this;
    }
    /** <code>.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespan_config = 6;</code> */
    public com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.Builder
        getTimespanConfigBuilder() {

      onChanged();
      return getTimespanConfigFieldBuilder().getBuilder();
    }
    /** <code>.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespan_config = 6;</code> */
    public com.google.privacy.dlp.v2.StorageConfig.TimespanConfigOrBuilder
        getTimespanConfigOrBuilder() {
      if (timespanConfigBuilder_ != null) {
        return timespanConfigBuilder_.getMessageOrBuilder();
      } else {
        return timespanConfig_ == null
            ? com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.getDefaultInstance()
            : timespanConfig_;
      }
    }
    /** <code>.google.privacy.dlp.v2.StorageConfig.TimespanConfig timespan_config = 6;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.StorageConfig.TimespanConfig,
            com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.Builder,
            com.google.privacy.dlp.v2.StorageConfig.TimespanConfigOrBuilder>
        getTimespanConfigFieldBuilder() {
      if (timespanConfigBuilder_ == null) {
        timespanConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.StorageConfig.TimespanConfig,
                com.google.privacy.dlp.v2.StorageConfig.TimespanConfig.Builder,
                com.google.privacy.dlp.v2.StorageConfig.TimespanConfigOrBuilder>(
                getTimespanConfig(), getParentForChildren(), isClean());
        timespanConfig_ = null;
      }
      return timespanConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.StorageConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.StorageConfig)
  private static final com.google.privacy.dlp.v2.StorageConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.StorageConfig();
  }

  public static com.google.privacy.dlp.v2.StorageConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StorageConfig> PARSER =
      new com.google.protobuf.AbstractParser<StorageConfig>() {
        @java.lang.Override
        public StorageConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StorageConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StorageConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.StorageConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
