/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Configuration for a risk analysis job. See
 * https://cloud.google.com/dlp/docs/concepts-risk-analysis to learn more.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.RiskAnalysisJobConfig}
 */
public final class RiskAnalysisJobConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.RiskAnalysisJobConfig)
    RiskAnalysisJobConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RiskAnalysisJobConfig.newBuilder() to construct.
  private RiskAnalysisJobConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RiskAnalysisJobConfig() {
    actions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RiskAnalysisJobConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_RiskAnalysisJobConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_RiskAnalysisJobConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.RiskAnalysisJobConfig.class,
            com.google.privacy.dlp.v2.RiskAnalysisJobConfig.Builder.class);
  }

  public static final int PRIVACY_METRIC_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.PrivacyMetric privacyMetric_;
  /**
   *
   *
   * <pre>
   * Privacy metric to compute.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.PrivacyMetric privacy_metric = 1;</code>
   *
   * @return Whether the privacyMetric field is set.
   */
  @java.lang.Override
  public boolean hasPrivacyMetric() {
    return privacyMetric_ != null;
  }
  /**
   *
   *
   * <pre>
   * Privacy metric to compute.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.PrivacyMetric privacy_metric = 1;</code>
   *
   * @return The privacyMetric.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.PrivacyMetric getPrivacyMetric() {
    return privacyMetric_ == null
        ? com.google.privacy.dlp.v2.PrivacyMetric.getDefaultInstance()
        : privacyMetric_;
  }
  /**
   *
   *
   * <pre>
   * Privacy metric to compute.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.PrivacyMetric privacy_metric = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.PrivacyMetricOrBuilder getPrivacyMetricOrBuilder() {
    return getPrivacyMetric();
  }

  public static final int SOURCE_TABLE_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.BigQueryTable sourceTable_;
  /**
   *
   *
   * <pre>
   * Input dataset to compute metrics over.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTable source_table = 2;</code>
   *
   * @return Whether the sourceTable field is set.
   */
  @java.lang.Override
  public boolean hasSourceTable() {
    return sourceTable_ != null;
  }
  /**
   *
   *
   * <pre>
   * Input dataset to compute metrics over.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTable source_table = 2;</code>
   *
   * @return The sourceTable.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryTable getSourceTable() {
    return sourceTable_ == null
        ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()
        : sourceTable_;
  }
  /**
   *
   *
   * <pre>
   * Input dataset to compute metrics over.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.BigQueryTable source_table = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.BigQueryTableOrBuilder getSourceTableOrBuilder() {
    return getSourceTable();
  }

  public static final int ACTIONS_FIELD_NUMBER = 3;
  private java.util.List<com.google.privacy.dlp.v2.Action> actions_;
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job. Are executed in the order
   * provided.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.Action> getActionsList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job. Are executed in the order
   * provided.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.ActionOrBuilder>
      getActionsOrBuilderList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job. Are executed in the order
   * provided.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
   */
  @java.lang.Override
  public int getActionsCount() {
    return actions_.size();
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job. Are executed in the order
   * provided.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action getActions(int index) {
    return actions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job. Are executed in the order
   * provided.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ActionOrBuilder getActionsOrBuilder(int index) {
    return actions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (privacyMetric_ != null) {
      output.writeMessage(1, getPrivacyMetric());
    }
    if (sourceTable_ != null) {
      output.writeMessage(2, getSourceTable());
    }
    for (int i = 0; i < actions_.size(); i++) {
      output.writeMessage(3, actions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (privacyMetric_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPrivacyMetric());
    }
    if (sourceTable_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSourceTable());
    }
    for (int i = 0; i < actions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, actions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.RiskAnalysisJobConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.RiskAnalysisJobConfig other =
        (com.google.privacy.dlp.v2.RiskAnalysisJobConfig) obj;

    if (hasPrivacyMetric() != other.hasPrivacyMetric()) return false;
    if (hasPrivacyMetric()) {
      if (!getPrivacyMetric().equals(other.getPrivacyMetric())) return false;
    }
    if (hasSourceTable() != other.hasSourceTable()) return false;
    if (hasSourceTable()) {
      if (!getSourceTable().equals(other.getSourceTable())) return false;
    }
    if (!getActionsList().equals(other.getActionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPrivacyMetric()) {
      hash = (37 * hash) + PRIVACY_METRIC_FIELD_NUMBER;
      hash = (53 * hash) + getPrivacyMetric().hashCode();
    }
    if (hasSourceTable()) {
      hash = (37 * hash) + SOURCE_TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceTable().hashCode();
    }
    if (getActionsCount() > 0) {
      hash = (37 * hash) + ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getActionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.RiskAnalysisJobConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a risk analysis job. See
   * https://cloud.google.com/dlp/docs/concepts-risk-analysis to learn more.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.RiskAnalysisJobConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.RiskAnalysisJobConfig)
      com.google.privacy.dlp.v2.RiskAnalysisJobConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RiskAnalysisJobConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RiskAnalysisJobConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.RiskAnalysisJobConfig.class,
              com.google.privacy.dlp.v2.RiskAnalysisJobConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.RiskAnalysisJobConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (privacyMetricBuilder_ == null) {
        privacyMetric_ = null;
      } else {
        privacyMetric_ = null;
        privacyMetricBuilder_ = null;
      }
      if (sourceTableBuilder_ == null) {
        sourceTable_ = null;
      } else {
        sourceTable_ = null;
        sourceTableBuilder_ = null;
      }
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
      } else {
        actions_ = null;
        actionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RiskAnalysisJobConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RiskAnalysisJobConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.RiskAnalysisJobConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RiskAnalysisJobConfig build() {
      com.google.privacy.dlp.v2.RiskAnalysisJobConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RiskAnalysisJobConfig buildPartial() {
      com.google.privacy.dlp.v2.RiskAnalysisJobConfig result =
          new com.google.privacy.dlp.v2.RiskAnalysisJobConfig(this);
      int from_bitField0_ = bitField0_;
      if (privacyMetricBuilder_ == null) {
        result.privacyMetric_ = privacyMetric_;
      } else {
        result.privacyMetric_ = privacyMetricBuilder_.build();
      }
      if (sourceTableBuilder_ == null) {
        result.sourceTable_ = sourceTable_;
      } else {
        result.sourceTable_ = sourceTableBuilder_.build();
      }
      if (actionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          actions_ = java.util.Collections.unmodifiableList(actions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.actions_ = actions_;
      } else {
        result.actions_ = actionsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.RiskAnalysisJobConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.RiskAnalysisJobConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.RiskAnalysisJobConfig other) {
      if (other == com.google.privacy.dlp.v2.RiskAnalysisJobConfig.getDefaultInstance())
        return this;
      if (other.hasPrivacyMetric()) {
        mergePrivacyMetric(other.getPrivacyMetric());
      }
      if (other.hasSourceTable()) {
        mergeSourceTable(other.getSourceTable());
      }
      if (actionsBuilder_ == null) {
        if (!other.actions_.isEmpty()) {
          if (actions_.isEmpty()) {
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureActionsIsMutable();
            actions_.addAll(other.actions_);
          }
          onChanged();
        }
      } else {
        if (!other.actions_.isEmpty()) {
          if (actionsBuilder_.isEmpty()) {
            actionsBuilder_.dispose();
            actionsBuilder_ = null;
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            actionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getActionsFieldBuilder()
                    : null;
          } else {
            actionsBuilder_.addAllMessages(other.actions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPrivacyMetricFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSourceTableFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                com.google.privacy.dlp.v2.Action m =
                    input.readMessage(com.google.privacy.dlp.v2.Action.parser(), extensionRegistry);
                if (actionsBuilder_ == null) {
                  ensureActionsIsMutable();
                  actions_.add(m);
                } else {
                  actionsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.PrivacyMetric privacyMetric_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.PrivacyMetric,
            com.google.privacy.dlp.v2.PrivacyMetric.Builder,
            com.google.privacy.dlp.v2.PrivacyMetricOrBuilder>
        privacyMetricBuilder_;
    /**
     *
     *
     * <pre>
     * Privacy metric to compute.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrivacyMetric privacy_metric = 1;</code>
     *
     * @return Whether the privacyMetric field is set.
     */
    public boolean hasPrivacyMetric() {
      return privacyMetricBuilder_ != null || privacyMetric_ != null;
    }
    /**
     *
     *
     * <pre>
     * Privacy metric to compute.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrivacyMetric privacy_metric = 1;</code>
     *
     * @return The privacyMetric.
     */
    public com.google.privacy.dlp.v2.PrivacyMetric getPrivacyMetric() {
      if (privacyMetricBuilder_ == null) {
        return privacyMetric_ == null
            ? com.google.privacy.dlp.v2.PrivacyMetric.getDefaultInstance()
            : privacyMetric_;
      } else {
        return privacyMetricBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Privacy metric to compute.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrivacyMetric privacy_metric = 1;</code>
     */
    public Builder setPrivacyMetric(com.google.privacy.dlp.v2.PrivacyMetric value) {
      if (privacyMetricBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        privacyMetric_ = value;
        onChanged();
      } else {
        privacyMetricBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Privacy metric to compute.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrivacyMetric privacy_metric = 1;</code>
     */
    public Builder setPrivacyMetric(
        com.google.privacy.dlp.v2.PrivacyMetric.Builder builderForValue) {
      if (privacyMetricBuilder_ == null) {
        privacyMetric_ = builderForValue.build();
        onChanged();
      } else {
        privacyMetricBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Privacy metric to compute.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrivacyMetric privacy_metric = 1;</code>
     */
    public Builder mergePrivacyMetric(com.google.privacy.dlp.v2.PrivacyMetric value) {
      if (privacyMetricBuilder_ == null) {
        if (privacyMetric_ != null) {
          privacyMetric_ =
              com.google.privacy.dlp.v2.PrivacyMetric.newBuilder(privacyMetric_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          privacyMetric_ = value;
        }
        onChanged();
      } else {
        privacyMetricBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Privacy metric to compute.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrivacyMetric privacy_metric = 1;</code>
     */
    public Builder clearPrivacyMetric() {
      if (privacyMetricBuilder_ == null) {
        privacyMetric_ = null;
        onChanged();
      } else {
        privacyMetric_ = null;
        privacyMetricBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Privacy metric to compute.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrivacyMetric privacy_metric = 1;</code>
     */
    public com.google.privacy.dlp.v2.PrivacyMetric.Builder getPrivacyMetricBuilder() {

      onChanged();
      return getPrivacyMetricFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Privacy metric to compute.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrivacyMetric privacy_metric = 1;</code>
     */
    public com.google.privacy.dlp.v2.PrivacyMetricOrBuilder getPrivacyMetricOrBuilder() {
      if (privacyMetricBuilder_ != null) {
        return privacyMetricBuilder_.getMessageOrBuilder();
      } else {
        return privacyMetric_ == null
            ? com.google.privacy.dlp.v2.PrivacyMetric.getDefaultInstance()
            : privacyMetric_;
      }
    }
    /**
     *
     *
     * <pre>
     * Privacy metric to compute.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.PrivacyMetric privacy_metric = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.PrivacyMetric,
            com.google.privacy.dlp.v2.PrivacyMetric.Builder,
            com.google.privacy.dlp.v2.PrivacyMetricOrBuilder>
        getPrivacyMetricFieldBuilder() {
      if (privacyMetricBuilder_ == null) {
        privacyMetricBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.PrivacyMetric,
                com.google.privacy.dlp.v2.PrivacyMetric.Builder,
                com.google.privacy.dlp.v2.PrivacyMetricOrBuilder>(
                getPrivacyMetric(), getParentForChildren(), isClean());
        privacyMetric_ = null;
      }
      return privacyMetricBuilder_;
    }

    private com.google.privacy.dlp.v2.BigQueryTable sourceTable_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryTable,
            com.google.privacy.dlp.v2.BigQueryTable.Builder,
            com.google.privacy.dlp.v2.BigQueryTableOrBuilder>
        sourceTableBuilder_;
    /**
     *
     *
     * <pre>
     * Input dataset to compute metrics over.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable source_table = 2;</code>
     *
     * @return Whether the sourceTable field is set.
     */
    public boolean hasSourceTable() {
      return sourceTableBuilder_ != null || sourceTable_ != null;
    }
    /**
     *
     *
     * <pre>
     * Input dataset to compute metrics over.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable source_table = 2;</code>
     *
     * @return The sourceTable.
     */
    public com.google.privacy.dlp.v2.BigQueryTable getSourceTable() {
      if (sourceTableBuilder_ == null) {
        return sourceTable_ == null
            ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()
            : sourceTable_;
      } else {
        return sourceTableBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Input dataset to compute metrics over.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable source_table = 2;</code>
     */
    public Builder setSourceTable(com.google.privacy.dlp.v2.BigQueryTable value) {
      if (sourceTableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceTable_ = value;
        onChanged();
      } else {
        sourceTableBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Input dataset to compute metrics over.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable source_table = 2;</code>
     */
    public Builder setSourceTable(com.google.privacy.dlp.v2.BigQueryTable.Builder builderForValue) {
      if (sourceTableBuilder_ == null) {
        sourceTable_ = builderForValue.build();
        onChanged();
      } else {
        sourceTableBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Input dataset to compute metrics over.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable source_table = 2;</code>
     */
    public Builder mergeSourceTable(com.google.privacy.dlp.v2.BigQueryTable value) {
      if (sourceTableBuilder_ == null) {
        if (sourceTable_ != null) {
          sourceTable_ =
              com.google.privacy.dlp.v2.BigQueryTable.newBuilder(sourceTable_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceTable_ = value;
        }
        onChanged();
      } else {
        sourceTableBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Input dataset to compute metrics over.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable source_table = 2;</code>
     */
    public Builder clearSourceTable() {
      if (sourceTableBuilder_ == null) {
        sourceTable_ = null;
        onChanged();
      } else {
        sourceTable_ = null;
        sourceTableBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Input dataset to compute metrics over.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable source_table = 2;</code>
     */
    public com.google.privacy.dlp.v2.BigQueryTable.Builder getSourceTableBuilder() {

      onChanged();
      return getSourceTableFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input dataset to compute metrics over.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable source_table = 2;</code>
     */
    public com.google.privacy.dlp.v2.BigQueryTableOrBuilder getSourceTableOrBuilder() {
      if (sourceTableBuilder_ != null) {
        return sourceTableBuilder_.getMessageOrBuilder();
      } else {
        return sourceTable_ == null
            ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()
            : sourceTable_;
      }
    }
    /**
     *
     *
     * <pre>
     * Input dataset to compute metrics over.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable source_table = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.BigQueryTable,
            com.google.privacy.dlp.v2.BigQueryTable.Builder,
            com.google.privacy.dlp.v2.BigQueryTableOrBuilder>
        getSourceTableFieldBuilder() {
      if (sourceTableBuilder_ == null) {
        sourceTableBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.BigQueryTable,
                com.google.privacy.dlp.v2.BigQueryTable.Builder,
                com.google.privacy.dlp.v2.BigQueryTableOrBuilder>(
                getSourceTable(), getParentForChildren(), isClean());
        sourceTable_ = null;
      }
      return sourceTableBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.Action> actions_ =
        java.util.Collections.emptyList();

    private void ensureActionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        actions_ = new java.util.ArrayList<com.google.privacy.dlp.v2.Action>(actions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Action,
            com.google.privacy.dlp.v2.Action.Builder,
            com.google.privacy.dlp.v2.ActionOrBuilder>
        actionsBuilder_;

    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Action> getActionsList() {
      if (actionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(actions_);
      } else {
        return actionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public int getActionsCount() {
      if (actionsBuilder_ == null) {
        return actions_.size();
      } else {
        return actionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public com.google.privacy.dlp.v2.Action getActions(int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public Builder setActions(int index, com.google.privacy.dlp.v2.Action value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.set(index, value);
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public Builder setActions(int index, com.google.privacy.dlp.v2.Action.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.set(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public Builder addActions(com.google.privacy.dlp.v2.Action value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public Builder addActions(int index, com.google.privacy.dlp.v2.Action value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(index, value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public Builder addActions(com.google.privacy.dlp.v2.Action.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public Builder addActions(int index, com.google.privacy.dlp.v2.Action.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public Builder addAllActions(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.Action> values) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, actions_);
        onChanged();
      } else {
        actionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public Builder clearActions() {
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        actionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public Builder removeActions(int index) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.remove(index);
        onChanged();
      } else {
        actionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public com.google.privacy.dlp.v2.Action.Builder getActionsBuilder(int index) {
      return getActionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public com.google.privacy.dlp.v2.ActionOrBuilder getActionsOrBuilder(int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.ActionOrBuilder>
        getActionsOrBuilderList() {
      if (actionsBuilder_ != null) {
        return actionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(actions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public com.google.privacy.dlp.v2.Action.Builder addActionsBuilder() {
      return getActionsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.Action.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public com.google.privacy.dlp.v2.Action.Builder addActionsBuilder(int index) {
      return getActionsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.Action.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job. Are executed in the order
     * provided.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 3;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Action.Builder> getActionsBuilderList() {
      return getActionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Action,
            com.google.privacy.dlp.v2.Action.Builder,
            com.google.privacy.dlp.v2.ActionOrBuilder>
        getActionsFieldBuilder() {
      if (actionsBuilder_ == null) {
        actionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.Action,
                com.google.privacy.dlp.v2.Action.Builder,
                com.google.privacy.dlp.v2.ActionOrBuilder>(
                actions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        actions_ = null;
      }
      return actionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.RiskAnalysisJobConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.RiskAnalysisJobConfig)
  private static final com.google.privacy.dlp.v2.RiskAnalysisJobConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.RiskAnalysisJobConfig();
  }

  public static com.google.privacy.dlp.v2.RiskAnalysisJobConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RiskAnalysisJobConfig> PARSER =
      new com.google.protobuf.AbstractParser<RiskAnalysisJobConfig>() {
        @java.lang.Override
        public RiskAnalysisJobConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RiskAnalysisJobConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RiskAnalysisJobConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.RiskAnalysisJobConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
