/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Request to search for potentially sensitive info in an image and redact it
 * by covering it with a colored rectangle.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.RedactImageRequest}
 */
public final class RedactImageRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.RedactImageRequest)
    RedactImageRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RedactImageRequest.newBuilder() to construct.
  private RedactImageRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RedactImageRequest() {
    parent_ = "";
    locationId_ = "";
    imageRedactionConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RedactImageRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_RedactImageRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_RedactImageRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.RedactImageRequest.class,
            com.google.privacy.dlp.v2.RedactImageRequest.Builder.class);
  }

  public interface ImageRedactionConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Only one per info_type should be provided per request. If not
     * specified, and redact_all_text is false, the DLP API will redact all
     * text that it matches against all info_types that are found, but not
     * specified in another ImageRedactionConfig.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     *
     * @return Whether the infoType field is set.
     */
    boolean hasInfoType();
    /**
     *
     *
     * <pre>
     * Only one per info_type should be provided per request. If not
     * specified, and redact_all_text is false, the DLP API will redact all
     * text that it matches against all info_types that are found, but not
     * specified in another ImageRedactionConfig.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     *
     * @return The infoType.
     */
    com.google.privacy.dlp.v2.InfoType getInfoType();
    /**
     *
     *
     * <pre>
     * Only one per info_type should be provided per request. If not
     * specified, and redact_all_text is false, the DLP API will redact all
     * text that it matches against all info_types that are found, but not
     * specified in another ImageRedactionConfig.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder();

    /**
     *
     *
     * <pre>
     * If true, all text found in the image, regardless whether it matches an
     * info_type, is redacted. Only one should be provided.
     * </pre>
     *
     * <code>bool redact_all_text = 2;</code>
     *
     * @return Whether the redactAllText field is set.
     */
    boolean hasRedactAllText();
    /**
     *
     *
     * <pre>
     * If true, all text found in the image, regardless whether it matches an
     * info_type, is redacted. Only one should be provided.
     * </pre>
     *
     * <code>bool redact_all_text = 2;</code>
     *
     * @return The redactAllText.
     */
    boolean getRedactAllText();

    /**
     *
     *
     * <pre>
     * The color to use when redacting content from an image. If not specified,
     * the default is black.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
     *
     * @return Whether the redactionColor field is set.
     */
    boolean hasRedactionColor();
    /**
     *
     *
     * <pre>
     * The color to use when redacting content from an image. If not specified,
     * the default is black.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
     *
     * @return The redactionColor.
     */
    com.google.privacy.dlp.v2.Color getRedactionColor();
    /**
     *
     *
     * <pre>
     * The color to use when redacting content from an image. If not specified,
     * the default is black.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
     */
    com.google.privacy.dlp.v2.ColorOrBuilder getRedactionColorOrBuilder();

    public com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.TargetCase
        getTargetCase();
  }
  /**
   *
   *
   * <pre>
   * Configuration for determining how redaction of images should occur.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig}
   */
  public static final class ImageRedactionConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig)
      ImageRedactionConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ImageRedactionConfig.newBuilder() to construct.
    private ImageRedactionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ImageRedactionConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ImageRedactionConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RedactImageRequest_ImageRedactionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RedactImageRequest_ImageRedactionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.class,
              com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.Builder.class);
    }

    private int targetCase_ = 0;
    private java.lang.Object target_;

    public enum TargetCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      INFO_TYPE(1),
      REDACT_ALL_TEXT(2),
      TARGET_NOT_SET(0);
      private final int value;

      private TargetCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TargetCase valueOf(int value) {
        return forNumber(value);
      }

      public static TargetCase forNumber(int value) {
        switch (value) {
          case 1:
            return INFO_TYPE;
          case 2:
            return REDACT_ALL_TEXT;
          case 0:
            return TARGET_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public TargetCase getTargetCase() {
      return TargetCase.forNumber(targetCase_);
    }

    public static final int INFO_TYPE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Only one per info_type should be provided per request. If not
     * specified, and redact_all_text is false, the DLP API will redact all
     * text that it matches against all info_types that are found, but not
     * specified in another ImageRedactionConfig.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     *
     * @return Whether the infoType field is set.
     */
    @java.lang.Override
    public boolean hasInfoType() {
      return targetCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Only one per info_type should be provided per request. If not
     * specified, and redact_all_text is false, the DLP API will redact all
     * text that it matches against all info_types that are found, but not
     * specified in another ImageRedactionConfig.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     *
     * @return The infoType.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoType getInfoType() {
      if (targetCase_ == 1) {
        return (com.google.privacy.dlp.v2.InfoType) target_;
      }
      return com.google.privacy.dlp.v2.InfoType.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Only one per info_type should be provided per request. If not
     * specified, and redact_all_text is false, the DLP API will redact all
     * text that it matches against all info_types that are found, but not
     * specified in another ImageRedactionConfig.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
      if (targetCase_ == 1) {
        return (com.google.privacy.dlp.v2.InfoType) target_;
      }
      return com.google.privacy.dlp.v2.InfoType.getDefaultInstance();
    }

    public static final int REDACT_ALL_TEXT_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * If true, all text found in the image, regardless whether it matches an
     * info_type, is redacted. Only one should be provided.
     * </pre>
     *
     * <code>bool redact_all_text = 2;</code>
     *
     * @return Whether the redactAllText field is set.
     */
    @java.lang.Override
    public boolean hasRedactAllText() {
      return targetCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * If true, all text found in the image, regardless whether it matches an
     * info_type, is redacted. Only one should be provided.
     * </pre>
     *
     * <code>bool redact_all_text = 2;</code>
     *
     * @return The redactAllText.
     */
    @java.lang.Override
    public boolean getRedactAllText() {
      if (targetCase_ == 2) {
        return (java.lang.Boolean) target_;
      }
      return false;
    }

    public static final int REDACTION_COLOR_FIELD_NUMBER = 3;
    private com.google.privacy.dlp.v2.Color redactionColor_;
    /**
     *
     *
     * <pre>
     * The color to use when redacting content from an image. If not specified,
     * the default is black.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
     *
     * @return Whether the redactionColor field is set.
     */
    @java.lang.Override
    public boolean hasRedactionColor() {
      return redactionColor_ != null;
    }
    /**
     *
     *
     * <pre>
     * The color to use when redacting content from an image. If not specified,
     * the default is black.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
     *
     * @return The redactionColor.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Color getRedactionColor() {
      return redactionColor_ == null
          ? com.google.privacy.dlp.v2.Color.getDefaultInstance()
          : redactionColor_;
    }
    /**
     *
     *
     * <pre>
     * The color to use when redacting content from an image. If not specified,
     * the default is black.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ColorOrBuilder getRedactionColorOrBuilder() {
      return getRedactionColor();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (targetCase_ == 1) {
        output.writeMessage(1, (com.google.privacy.dlp.v2.InfoType) target_);
      }
      if (targetCase_ == 2) {
        output.writeBool(2, (boolean) ((java.lang.Boolean) target_));
      }
      if (redactionColor_ != null) {
        output.writeMessage(3, getRedactionColor());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (targetCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.privacy.dlp.v2.InfoType) target_);
      }
      if (targetCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                2, (boolean) ((java.lang.Boolean) target_));
      }
      if (redactionColor_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRedactionColor());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig other =
          (com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig) obj;

      if (hasRedactionColor() != other.hasRedactionColor()) return false;
      if (hasRedactionColor()) {
        if (!getRedactionColor().equals(other.getRedactionColor())) return false;
      }
      if (!getTargetCase().equals(other.getTargetCase())) return false;
      switch (targetCase_) {
        case 1:
          if (!getInfoType().equals(other.getInfoType())) return false;
          break;
        case 2:
          if (getRedactAllText() != other.getRedactAllText()) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRedactionColor()) {
        hash = (37 * hash) + REDACTION_COLOR_FIELD_NUMBER;
        hash = (53 * hash) + getRedactionColor().hashCode();
      }
      switch (targetCase_) {
        case 1:
          hash = (37 * hash) + INFO_TYPE_FIELD_NUMBER;
          hash = (53 * hash) + getInfoType().hashCode();
          break;
        case 2:
          hash = (37 * hash) + REDACT_ALL_TEXT_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRedactAllText());
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for determining how redaction of images should occur.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig)
        com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_RedactImageRequest_ImageRedactionConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_RedactImageRequest_ImageRedactionConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.class,
                com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.Builder.class);
      }

      // Construct using
      // com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (infoTypeBuilder_ != null) {
          infoTypeBuilder_.clear();
        }
        if (redactionColorBuilder_ == null) {
          redactionColor_ = null;
        } else {
          redactionColor_ = null;
          redactionColorBuilder_ = null;
        }
        targetCase_ = 0;
        target_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_RedactImageRequest_ImageRedactionConfig_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig build() {
        com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig buildPartial() {
        com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig result =
            new com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig(this);
        if (targetCase_ == 1) {
          if (infoTypeBuilder_ == null) {
            result.target_ = target_;
          } else {
            result.target_ = infoTypeBuilder_.build();
          }
        }
        if (targetCase_ == 2) {
          result.target_ = target_;
        }
        if (redactionColorBuilder_ == null) {
          result.redactionColor_ = redactionColor_;
        } else {
          result.redactionColor_ = redactionColorBuilder_.build();
        }
        result.targetCase_ = targetCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig) {
          return mergeFrom(
              (com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig other) {
        if (other
            == com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
                .getDefaultInstance()) return this;
        if (other.hasRedactionColor()) {
          mergeRedactionColor(other.getRedactionColor());
        }
        switch (other.getTargetCase()) {
          case INFO_TYPE:
            {
              mergeInfoType(other.getInfoType());
              break;
            }
          case REDACT_ALL_TEXT:
            {
              setRedactAllText(other.getRedactAllText());
              break;
            }
          case TARGET_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getInfoTypeFieldBuilder().getBuilder(), extensionRegistry);
                  targetCase_ = 1;
                  break;
                } // case 10
              case 16:
                {
                  target_ = input.readBool();
                  targetCase_ = 2;
                  break;
                } // case 16
              case 26:
                {
                  input.readMessage(
                      getRedactionColorFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int targetCase_ = 0;
      private java.lang.Object target_;

      public TargetCase getTargetCase() {
        return TargetCase.forNumber(targetCase_);
      }

      public Builder clearTarget() {
        targetCase_ = 0;
        target_ = null;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.InfoType,
              com.google.privacy.dlp.v2.InfoType.Builder,
              com.google.privacy.dlp.v2.InfoTypeOrBuilder>
          infoTypeBuilder_;
      /**
       *
       *
       * <pre>
       * Only one per info_type should be provided per request. If not
       * specified, and redact_all_text is false, the DLP API will redact all
       * text that it matches against all info_types that are found, but not
       * specified in another ImageRedactionConfig.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       *
       * @return Whether the infoType field is set.
       */
      @java.lang.Override
      public boolean hasInfoType() {
        return targetCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Only one per info_type should be provided per request. If not
       * specified, and redact_all_text is false, the DLP API will redact all
       * text that it matches against all info_types that are found, but not
       * specified in another ImageRedactionConfig.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       *
       * @return The infoType.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.InfoType getInfoType() {
        if (infoTypeBuilder_ == null) {
          if (targetCase_ == 1) {
            return (com.google.privacy.dlp.v2.InfoType) target_;
          }
          return com.google.privacy.dlp.v2.InfoType.getDefaultInstance();
        } else {
          if (targetCase_ == 1) {
            return infoTypeBuilder_.getMessage();
          }
          return com.google.privacy.dlp.v2.InfoType.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Only one per info_type should be provided per request. If not
       * specified, and redact_all_text is false, the DLP API will redact all
       * text that it matches against all info_types that are found, but not
       * specified in another ImageRedactionConfig.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       */
      public Builder setInfoType(com.google.privacy.dlp.v2.InfoType value) {
        if (infoTypeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          target_ = value;
          onChanged();
        } else {
          infoTypeBuilder_.setMessage(value);
        }
        targetCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only one per info_type should be provided per request. If not
       * specified, and redact_all_text is false, the DLP API will redact all
       * text that it matches against all info_types that are found, but not
       * specified in another ImageRedactionConfig.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       */
      public Builder setInfoType(com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
        if (infoTypeBuilder_ == null) {
          target_ = builderForValue.build();
          onChanged();
        } else {
          infoTypeBuilder_.setMessage(builderForValue.build());
        }
        targetCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only one per info_type should be provided per request. If not
       * specified, and redact_all_text is false, the DLP API will redact all
       * text that it matches against all info_types that are found, but not
       * specified in another ImageRedactionConfig.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       */
      public Builder mergeInfoType(com.google.privacy.dlp.v2.InfoType value) {
        if (infoTypeBuilder_ == null) {
          if (targetCase_ == 1
              && target_ != com.google.privacy.dlp.v2.InfoType.getDefaultInstance()) {
            target_ =
                com.google.privacy.dlp.v2.InfoType.newBuilder(
                        (com.google.privacy.dlp.v2.InfoType) target_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            target_ = value;
          }
          onChanged();
        } else {
          if (targetCase_ == 1) {
            infoTypeBuilder_.mergeFrom(value);
          } else {
            infoTypeBuilder_.setMessage(value);
          }
        }
        targetCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only one per info_type should be provided per request. If not
       * specified, and redact_all_text is false, the DLP API will redact all
       * text that it matches against all info_types that are found, but not
       * specified in another ImageRedactionConfig.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       */
      public Builder clearInfoType() {
        if (infoTypeBuilder_ == null) {
          if (targetCase_ == 1) {
            targetCase_ = 0;
            target_ = null;
            onChanged();
          }
        } else {
          if (targetCase_ == 1) {
            targetCase_ = 0;
            target_ = null;
          }
          infoTypeBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only one per info_type should be provided per request. If not
       * specified, and redact_all_text is false, the DLP API will redact all
       * text that it matches against all info_types that are found, but not
       * specified in another ImageRedactionConfig.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       */
      public com.google.privacy.dlp.v2.InfoType.Builder getInfoTypeBuilder() {
        return getInfoTypeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Only one per info_type should be provided per request. If not
       * specified, and redact_all_text is false, the DLP API will redact all
       * text that it matches against all info_types that are found, but not
       * specified in another ImageRedactionConfig.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
        if ((targetCase_ == 1) && (infoTypeBuilder_ != null)) {
          return infoTypeBuilder_.getMessageOrBuilder();
        } else {
          if (targetCase_ == 1) {
            return (com.google.privacy.dlp.v2.InfoType) target_;
          }
          return com.google.privacy.dlp.v2.InfoType.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Only one per info_type should be provided per request. If not
       * specified, and redact_all_text is false, the DLP API will redact all
       * text that it matches against all info_types that are found, but not
       * specified in another ImageRedactionConfig.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.InfoType,
              com.google.privacy.dlp.v2.InfoType.Builder,
              com.google.privacy.dlp.v2.InfoTypeOrBuilder>
          getInfoTypeFieldBuilder() {
        if (infoTypeBuilder_ == null) {
          if (!(targetCase_ == 1)) {
            target_ = com.google.privacy.dlp.v2.InfoType.getDefaultInstance();
          }
          infoTypeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.InfoType,
                  com.google.privacy.dlp.v2.InfoType.Builder,
                  com.google.privacy.dlp.v2.InfoTypeOrBuilder>(
                  (com.google.privacy.dlp.v2.InfoType) target_, getParentForChildren(), isClean());
          target_ = null;
        }
        targetCase_ = 1;
        onChanged();
        ;
        return infoTypeBuilder_;
      }

      /**
       *
       *
       * <pre>
       * If true, all text found in the image, regardless whether it matches an
       * info_type, is redacted. Only one should be provided.
       * </pre>
       *
       * <code>bool redact_all_text = 2;</code>
       *
       * @return Whether the redactAllText field is set.
       */
      public boolean hasRedactAllText() {
        return targetCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * If true, all text found in the image, regardless whether it matches an
       * info_type, is redacted. Only one should be provided.
       * </pre>
       *
       * <code>bool redact_all_text = 2;</code>
       *
       * @return The redactAllText.
       */
      public boolean getRedactAllText() {
        if (targetCase_ == 2) {
          return (java.lang.Boolean) target_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * If true, all text found in the image, regardless whether it matches an
       * info_type, is redacted. Only one should be provided.
       * </pre>
       *
       * <code>bool redact_all_text = 2;</code>
       *
       * @param value The redactAllText to set.
       * @return This builder for chaining.
       */
      public Builder setRedactAllText(boolean value) {
        targetCase_ = 2;
        target_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, all text found in the image, regardless whether it matches an
       * info_type, is redacted. Only one should be provided.
       * </pre>
       *
       * <code>bool redact_all_text = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRedactAllText() {
        if (targetCase_ == 2) {
          targetCase_ = 0;
          target_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.privacy.dlp.v2.Color redactionColor_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Color,
              com.google.privacy.dlp.v2.Color.Builder,
              com.google.privacy.dlp.v2.ColorOrBuilder>
          redactionColorBuilder_;
      /**
       *
       *
       * <pre>
       * The color to use when redacting content from an image. If not specified,
       * the default is black.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
       *
       * @return Whether the redactionColor field is set.
       */
      public boolean hasRedactionColor() {
        return redactionColorBuilder_ != null || redactionColor_ != null;
      }
      /**
       *
       *
       * <pre>
       * The color to use when redacting content from an image. If not specified,
       * the default is black.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
       *
       * @return The redactionColor.
       */
      public com.google.privacy.dlp.v2.Color getRedactionColor() {
        if (redactionColorBuilder_ == null) {
          return redactionColor_ == null
              ? com.google.privacy.dlp.v2.Color.getDefaultInstance()
              : redactionColor_;
        } else {
          return redactionColorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The color to use when redacting content from an image. If not specified,
       * the default is black.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
       */
      public Builder setRedactionColor(com.google.privacy.dlp.v2.Color value) {
        if (redactionColorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          redactionColor_ = value;
          onChanged();
        } else {
          redactionColorBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The color to use when redacting content from an image. If not specified,
       * the default is black.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
       */
      public Builder setRedactionColor(com.google.privacy.dlp.v2.Color.Builder builderForValue) {
        if (redactionColorBuilder_ == null) {
          redactionColor_ = builderForValue.build();
          onChanged();
        } else {
          redactionColorBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The color to use when redacting content from an image. If not specified,
       * the default is black.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
       */
      public Builder mergeRedactionColor(com.google.privacy.dlp.v2.Color value) {
        if (redactionColorBuilder_ == null) {
          if (redactionColor_ != null) {
            redactionColor_ =
                com.google.privacy.dlp.v2.Color.newBuilder(redactionColor_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            redactionColor_ = value;
          }
          onChanged();
        } else {
          redactionColorBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The color to use when redacting content from an image. If not specified,
       * the default is black.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
       */
      public Builder clearRedactionColor() {
        if (redactionColorBuilder_ == null) {
          redactionColor_ = null;
          onChanged();
        } else {
          redactionColor_ = null;
          redactionColorBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The color to use when redacting content from an image. If not specified,
       * the default is black.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
       */
      public com.google.privacy.dlp.v2.Color.Builder getRedactionColorBuilder() {

        onChanged();
        return getRedactionColorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The color to use when redacting content from an image. If not specified,
       * the default is black.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
       */
      public com.google.privacy.dlp.v2.ColorOrBuilder getRedactionColorOrBuilder() {
        if (redactionColorBuilder_ != null) {
          return redactionColorBuilder_.getMessageOrBuilder();
        } else {
          return redactionColor_ == null
              ? com.google.privacy.dlp.v2.Color.getDefaultInstance()
              : redactionColor_;
        }
      }
      /**
       *
       *
       * <pre>
       * The color to use when redacting content from an image. If not specified,
       * the default is black.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.Color,
              com.google.privacy.dlp.v2.Color.Builder,
              com.google.privacy.dlp.v2.ColorOrBuilder>
          getRedactionColorFieldBuilder() {
        if (redactionColorBuilder_ == null) {
          redactionColorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.Color,
                  com.google.privacy.dlp.v2.Color.Builder,
                  com.google.privacy.dlp.v2.ColorOrBuilder>(
                  getRedactionColor(), getParentForChildren(), isClean());
          redactionColor_ = null;
        }
        return redactionColorBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig)
    private static final com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig();
    }

    public static com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ImageRedactionConfig> PARSER =
        new com.google.protobuf.AbstractParser<ImageRedactionConfig>() {
          @java.lang.Override
          public ImageRedactionConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ImageRedactionConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ImageRedactionConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Parent resource name.
   * The format of this value varies depending on whether you have [specified a
   * processing
   * location](https://cloud.google.com/dlp/docs/specifying-location):
   * + Projects scope, location specified:&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
   * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
   * The following example `parent` string specifies a parent project with the
   * identifier `example-project`, and specifies the `europe-west3` location
   * for processing data:
   *     parent=projects/example-project/locations/europe-west3
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Parent resource name.
   * The format of this value varies depending on whether you have [specified a
   * processing
   * location](https://cloud.google.com/dlp/docs/specifying-location):
   * + Projects scope, location specified:&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
   * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
   * The following example `parent` string specifies a parent project with the
   * identifier `example-project`, and specifies the `europe-west3` location
   * for processing data:
   *     parent=projects/example-project/locations/europe-west3
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_ID_FIELD_NUMBER = 8;
  private volatile java.lang.Object locationId_;
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>string location_id = 8;</code>
   *
   * @return The locationId.
   */
  @java.lang.Override
  public java.lang.String getLocationId() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>string location_id = 8;</code>
   *
   * @return The bytes for locationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationIdBytes() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSPECT_CONFIG_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.InspectConfig inspectConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the inspector.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
   *
   * @return Whether the inspectConfig field is set.
   */
  @java.lang.Override
  public boolean hasInspectConfig() {
    return inspectConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the inspector.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
   *
   * @return The inspectConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectConfig getInspectConfig() {
    return inspectConfig_ == null
        ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
        : inspectConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the inspector.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectConfigOrBuilder getInspectConfigOrBuilder() {
    return getInspectConfig();
  }

  public static final int IMAGE_REDACTION_CONFIGS_FIELD_NUMBER = 5;
  private java.util.List<com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig>
      imageRedactionConfigs_;
  /**
   *
   *
   * <pre>
   * The configuration for specifying what content to redact from images.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig>
      getImageRedactionConfigsList() {
    return imageRedactionConfigs_;
  }
  /**
   *
   *
   * <pre>
   * The configuration for specifying what content to redact from images.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfigOrBuilder>
      getImageRedactionConfigsOrBuilderList() {
    return imageRedactionConfigs_;
  }
  /**
   *
   *
   * <pre>
   * The configuration for specifying what content to redact from images.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
   * </code>
   */
  @java.lang.Override
  public int getImageRedactionConfigsCount() {
    return imageRedactionConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * The configuration for specifying what content to redact from images.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig getImageRedactionConfigs(
      int index) {
    return imageRedactionConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The configuration for specifying what content to redact from images.
   * </pre>
   *
   * <code>
   * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfigOrBuilder
      getImageRedactionConfigsOrBuilder(int index) {
    return imageRedactionConfigs_.get(index);
  }

  public static final int INCLUDE_FINDINGS_FIELD_NUMBER = 6;
  private boolean includeFindings_;
  /**
   *
   *
   * <pre>
   * Whether the response should include findings along with the redacted
   * image.
   * </pre>
   *
   * <code>bool include_findings = 6;</code>
   *
   * @return The includeFindings.
   */
  @java.lang.Override
  public boolean getIncludeFindings() {
    return includeFindings_;
  }

  public static final int BYTE_ITEM_FIELD_NUMBER = 7;
  private com.google.privacy.dlp.v2.ByteContentItem byteItem_;
  /**
   *
   *
   * <pre>
   * The content must be PNG, JPEG, SVG or BMP.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ByteContentItem byte_item = 7;</code>
   *
   * @return Whether the byteItem field is set.
   */
  @java.lang.Override
  public boolean hasByteItem() {
    return byteItem_ != null;
  }
  /**
   *
   *
   * <pre>
   * The content must be PNG, JPEG, SVG or BMP.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ByteContentItem byte_item = 7;</code>
   *
   * @return The byteItem.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ByteContentItem getByteItem() {
    return byteItem_ == null
        ? com.google.privacy.dlp.v2.ByteContentItem.getDefaultInstance()
        : byteItem_;
  }
  /**
   *
   *
   * <pre>
   * The content must be PNG, JPEG, SVG or BMP.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ByteContentItem byte_item = 7;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ByteContentItemOrBuilder getByteItemOrBuilder() {
    return getByteItem();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (inspectConfig_ != null) {
      output.writeMessage(2, getInspectConfig());
    }
    for (int i = 0; i < imageRedactionConfigs_.size(); i++) {
      output.writeMessage(5, imageRedactionConfigs_.get(i));
    }
    if (includeFindings_ != false) {
      output.writeBool(6, includeFindings_);
    }
    if (byteItem_ != null) {
      output.writeMessage(7, getByteItem());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, locationId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (inspectConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getInspectConfig());
    }
    for (int i = 0; i < imageRedactionConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, imageRedactionConfigs_.get(i));
    }
    if (includeFindings_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, includeFindings_);
    }
    if (byteItem_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getByteItem());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, locationId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.RedactImageRequest)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.RedactImageRequest other =
        (com.google.privacy.dlp.v2.RedactImageRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getLocationId().equals(other.getLocationId())) return false;
    if (hasInspectConfig() != other.hasInspectConfig()) return false;
    if (hasInspectConfig()) {
      if (!getInspectConfig().equals(other.getInspectConfig())) return false;
    }
    if (!getImageRedactionConfigsList().equals(other.getImageRedactionConfigsList())) return false;
    if (getIncludeFindings() != other.getIncludeFindings()) return false;
    if (hasByteItem() != other.hasByteItem()) return false;
    if (hasByteItem()) {
      if (!getByteItem().equals(other.getByteItem())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLocationId().hashCode();
    if (hasInspectConfig()) {
      hash = (37 * hash) + INSPECT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInspectConfig().hashCode();
    }
    if (getImageRedactionConfigsCount() > 0) {
      hash = (37 * hash) + IMAGE_REDACTION_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getImageRedactionConfigsList().hashCode();
    }
    hash = (37 * hash) + INCLUDE_FINDINGS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeFindings());
    if (hasByteItem()) {
      hash = (37 * hash) + BYTE_ITEM_FIELD_NUMBER;
      hash = (53 * hash) + getByteItem().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.RedactImageRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request to search for potentially sensitive info in an image and redact it
   * by covering it with a colored rectangle.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.RedactImageRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.RedactImageRequest)
      com.google.privacy.dlp.v2.RedactImageRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RedactImageRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RedactImageRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.RedactImageRequest.class,
              com.google.privacy.dlp.v2.RedactImageRequest.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.RedactImageRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      locationId_ = "";

      if (inspectConfigBuilder_ == null) {
        inspectConfig_ = null;
      } else {
        inspectConfig_ = null;
        inspectConfigBuilder_ = null;
      }
      if (imageRedactionConfigsBuilder_ == null) {
        imageRedactionConfigs_ = java.util.Collections.emptyList();
      } else {
        imageRedactionConfigs_ = null;
        imageRedactionConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      includeFindings_ = false;

      if (byteItemBuilder_ == null) {
        byteItem_ = null;
      } else {
        byteItem_ = null;
        byteItemBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_RedactImageRequest_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RedactImageRequest getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.RedactImageRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RedactImageRequest build() {
      com.google.privacy.dlp.v2.RedactImageRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.RedactImageRequest buildPartial() {
      com.google.privacy.dlp.v2.RedactImageRequest result =
          new com.google.privacy.dlp.v2.RedactImageRequest(this);
      int from_bitField0_ = bitField0_;
      result.parent_ = parent_;
      result.locationId_ = locationId_;
      if (inspectConfigBuilder_ == null) {
        result.inspectConfig_ = inspectConfig_;
      } else {
        result.inspectConfig_ = inspectConfigBuilder_.build();
      }
      if (imageRedactionConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          imageRedactionConfigs_ = java.util.Collections.unmodifiableList(imageRedactionConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.imageRedactionConfigs_ = imageRedactionConfigs_;
      } else {
        result.imageRedactionConfigs_ = imageRedactionConfigsBuilder_.build();
      }
      result.includeFindings_ = includeFindings_;
      if (byteItemBuilder_ == null) {
        result.byteItem_ = byteItem_;
      } else {
        result.byteItem_ = byteItemBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.RedactImageRequest) {
        return mergeFrom((com.google.privacy.dlp.v2.RedactImageRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.RedactImageRequest other) {
      if (other == com.google.privacy.dlp.v2.RedactImageRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (!other.getLocationId().isEmpty()) {
        locationId_ = other.locationId_;
        onChanged();
      }
      if (other.hasInspectConfig()) {
        mergeInspectConfig(other.getInspectConfig());
      }
      if (imageRedactionConfigsBuilder_ == null) {
        if (!other.imageRedactionConfigs_.isEmpty()) {
          if (imageRedactionConfigs_.isEmpty()) {
            imageRedactionConfigs_ = other.imageRedactionConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureImageRedactionConfigsIsMutable();
            imageRedactionConfigs_.addAll(other.imageRedactionConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.imageRedactionConfigs_.isEmpty()) {
          if (imageRedactionConfigsBuilder_.isEmpty()) {
            imageRedactionConfigsBuilder_.dispose();
            imageRedactionConfigsBuilder_ = null;
            imageRedactionConfigs_ = other.imageRedactionConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            imageRedactionConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getImageRedactionConfigsFieldBuilder()
                    : null;
          } else {
            imageRedactionConfigsBuilder_.addAllMessages(other.imageRedactionConfigs_);
          }
        }
      }
      if (other.getIncludeFindings() != false) {
        setIncludeFindings(other.getIncludeFindings());
      }
      if (other.hasByteItem()) {
        mergeByteItem(other.getByteItem());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInspectConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 42:
              {
                com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.parser(),
                        extensionRegistry);
                if (imageRedactionConfigsBuilder_ == null) {
                  ensureImageRedactionConfigsIsMutable();
                  imageRedactionConfigs_.add(m);
                } else {
                  imageRedactionConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 48:
              {
                includeFindings_ = input.readBool();

                break;
              } // case 48
            case 58:
              {
                input.readMessage(getByteItemFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                locationId_ = input.readStringRequireUtf8();

                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Parent resource name.
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/dlp/docs/specifying-location):
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parent resource name.
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/dlp/docs/specifying-location):
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parent resource name.
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/dlp/docs/specifying-location):
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parent resource name.
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/dlp/docs/specifying-location):
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parent resource name.
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/dlp/docs/specifying-location):
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object locationId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 8;</code>
     *
     * @return The locationId.
     */
    public java.lang.String getLocationId() {
      java.lang.Object ref = locationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 8;</code>
     *
     * @return The bytes for locationId.
     */
    public com.google.protobuf.ByteString getLocationIdBytes() {
      java.lang.Object ref = locationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 8;</code>
     *
     * @param value The locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      locationId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationId() {

      locationId_ = getDefaultInstance().getLocationId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 8;</code>
     *
     * @param value The bytes for locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      locationId_ = value;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.InspectConfig inspectConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectConfig,
            com.google.privacy.dlp.v2.InspectConfig.Builder,
            com.google.privacy.dlp.v2.InspectConfigOrBuilder>
        inspectConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     *
     * @return Whether the inspectConfig field is set.
     */
    public boolean hasInspectConfig() {
      return inspectConfigBuilder_ != null || inspectConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     *
     * @return The inspectConfig.
     */
    public com.google.privacy.dlp.v2.InspectConfig getInspectConfig() {
      if (inspectConfigBuilder_ == null) {
        return inspectConfig_ == null
            ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
            : inspectConfig_;
      } else {
        return inspectConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public Builder setInspectConfig(com.google.privacy.dlp.v2.InspectConfig value) {
      if (inspectConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inspectConfig_ = value;
        onChanged();
      } else {
        inspectConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public Builder setInspectConfig(
        com.google.privacy.dlp.v2.InspectConfig.Builder builderForValue) {
      if (inspectConfigBuilder_ == null) {
        inspectConfig_ = builderForValue.build();
        onChanged();
      } else {
        inspectConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public Builder mergeInspectConfig(com.google.privacy.dlp.v2.InspectConfig value) {
      if (inspectConfigBuilder_ == null) {
        if (inspectConfig_ != null) {
          inspectConfig_ =
              com.google.privacy.dlp.v2.InspectConfig.newBuilder(inspectConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          inspectConfig_ = value;
        }
        onChanged();
      } else {
        inspectConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public Builder clearInspectConfig() {
      if (inspectConfigBuilder_ == null) {
        inspectConfig_ = null;
        onChanged();
      } else {
        inspectConfig_ = null;
        inspectConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public com.google.privacy.dlp.v2.InspectConfig.Builder getInspectConfigBuilder() {

      onChanged();
      return getInspectConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public com.google.privacy.dlp.v2.InspectConfigOrBuilder getInspectConfigOrBuilder() {
      if (inspectConfigBuilder_ != null) {
        return inspectConfigBuilder_.getMessageOrBuilder();
      } else {
        return inspectConfig_ == null
            ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
            : inspectConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectConfig,
            com.google.privacy.dlp.v2.InspectConfig.Builder,
            com.google.privacy.dlp.v2.InspectConfigOrBuilder>
        getInspectConfigFieldBuilder() {
      if (inspectConfigBuilder_ == null) {
        inspectConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InspectConfig,
                com.google.privacy.dlp.v2.InspectConfig.Builder,
                com.google.privacy.dlp.v2.InspectConfigOrBuilder>(
                getInspectConfig(), getParentForChildren(), isClean());
        inspectConfig_ = null;
      }
      return inspectConfigBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig>
        imageRedactionConfigs_ = java.util.Collections.emptyList();

    private void ensureImageRedactionConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        imageRedactionConfigs_ =
            new java.util.ArrayList<
                com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig>(
                imageRedactionConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig,
            com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.Builder,
            com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfigOrBuilder>
        imageRedactionConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig>
        getImageRedactionConfigsList() {
      if (imageRedactionConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(imageRedactionConfigs_);
      } else {
        return imageRedactionConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public int getImageRedactionConfigsCount() {
      if (imageRedactionConfigsBuilder_ == null) {
        return imageRedactionConfigs_.size();
      } else {
        return imageRedactionConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
        getImageRedactionConfigs(int index) {
      if (imageRedactionConfigsBuilder_ == null) {
        return imageRedactionConfigs_.get(index);
      } else {
        return imageRedactionConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public Builder setImageRedactionConfigs(
        int index, com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig value) {
      if (imageRedactionConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImageRedactionConfigsIsMutable();
        imageRedactionConfigs_.set(index, value);
        onChanged();
      } else {
        imageRedactionConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public Builder setImageRedactionConfigs(
        int index,
        com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.Builder builderForValue) {
      if (imageRedactionConfigsBuilder_ == null) {
        ensureImageRedactionConfigsIsMutable();
        imageRedactionConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        imageRedactionConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public Builder addImageRedactionConfigs(
        com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig value) {
      if (imageRedactionConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImageRedactionConfigsIsMutable();
        imageRedactionConfigs_.add(value);
        onChanged();
      } else {
        imageRedactionConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public Builder addImageRedactionConfigs(
        int index, com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig value) {
      if (imageRedactionConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureImageRedactionConfigsIsMutable();
        imageRedactionConfigs_.add(index, value);
        onChanged();
      } else {
        imageRedactionConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public Builder addImageRedactionConfigs(
        com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.Builder builderForValue) {
      if (imageRedactionConfigsBuilder_ == null) {
        ensureImageRedactionConfigsIsMutable();
        imageRedactionConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        imageRedactionConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public Builder addImageRedactionConfigs(
        int index,
        com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.Builder builderForValue) {
      if (imageRedactionConfigsBuilder_ == null) {
        ensureImageRedactionConfigsIsMutable();
        imageRedactionConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        imageRedactionConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public Builder addAllImageRedactionConfigs(
        java.lang.Iterable<
                ? extends com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig>
            values) {
      if (imageRedactionConfigsBuilder_ == null) {
        ensureImageRedactionConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, imageRedactionConfigs_);
        onChanged();
      } else {
        imageRedactionConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public Builder clearImageRedactionConfigs() {
      if (imageRedactionConfigsBuilder_ == null) {
        imageRedactionConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        imageRedactionConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public Builder removeImageRedactionConfigs(int index) {
      if (imageRedactionConfigsBuilder_ == null) {
        ensureImageRedactionConfigsIsMutable();
        imageRedactionConfigs_.remove(index);
        onChanged();
      } else {
        imageRedactionConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.Builder
        getImageRedactionConfigsBuilder(int index) {
      return getImageRedactionConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfigOrBuilder
        getImageRedactionConfigsOrBuilder(int index) {
      if (imageRedactionConfigsBuilder_ == null) {
        return imageRedactionConfigs_.get(index);
      } else {
        return imageRedactionConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public java.util.List<
            ? extends com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfigOrBuilder>
        getImageRedactionConfigsOrBuilderList() {
      if (imageRedactionConfigsBuilder_ != null) {
        return imageRedactionConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(imageRedactionConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.Builder
        addImageRedactionConfigsBuilder() {
      return getImageRedactionConfigsFieldBuilder()
          .addBuilder(
              com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.Builder
        addImageRedactionConfigsBuilder(int index) {
      return getImageRedactionConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The configuration for specifying what content to redact from images.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig image_redaction_configs = 5;
     * </code>
     */
    public java.util.List<com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.Builder>
        getImageRedactionConfigsBuilderList() {
      return getImageRedactionConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig,
            com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.Builder,
            com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfigOrBuilder>
        getImageRedactionConfigsFieldBuilder() {
      if (imageRedactionConfigsBuilder_ == null) {
        imageRedactionConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig,
                com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig.Builder,
                com.google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfigOrBuilder>(
                imageRedactionConfigs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        imageRedactionConfigs_ = null;
      }
      return imageRedactionConfigsBuilder_;
    }

    private boolean includeFindings_;
    /**
     *
     *
     * <pre>
     * Whether the response should include findings along with the redacted
     * image.
     * </pre>
     *
     * <code>bool include_findings = 6;</code>
     *
     * @return The includeFindings.
     */
    @java.lang.Override
    public boolean getIncludeFindings() {
      return includeFindings_;
    }
    /**
     *
     *
     * <pre>
     * Whether the response should include findings along with the redacted
     * image.
     * </pre>
     *
     * <code>bool include_findings = 6;</code>
     *
     * @param value The includeFindings to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeFindings(boolean value) {

      includeFindings_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the response should include findings along with the redacted
     * image.
     * </pre>
     *
     * <code>bool include_findings = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeFindings() {

      includeFindings_ = false;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.ByteContentItem byteItem_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ByteContentItem,
            com.google.privacy.dlp.v2.ByteContentItem.Builder,
            com.google.privacy.dlp.v2.ByteContentItemOrBuilder>
        byteItemBuilder_;
    /**
     *
     *
     * <pre>
     * The content must be PNG, JPEG, SVG or BMP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem byte_item = 7;</code>
     *
     * @return Whether the byteItem field is set.
     */
    public boolean hasByteItem() {
      return byteItemBuilder_ != null || byteItem_ != null;
    }
    /**
     *
     *
     * <pre>
     * The content must be PNG, JPEG, SVG or BMP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem byte_item = 7;</code>
     *
     * @return The byteItem.
     */
    public com.google.privacy.dlp.v2.ByteContentItem getByteItem() {
      if (byteItemBuilder_ == null) {
        return byteItem_ == null
            ? com.google.privacy.dlp.v2.ByteContentItem.getDefaultInstance()
            : byteItem_;
      } else {
        return byteItemBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The content must be PNG, JPEG, SVG or BMP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem byte_item = 7;</code>
     */
    public Builder setByteItem(com.google.privacy.dlp.v2.ByteContentItem value) {
      if (byteItemBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        byteItem_ = value;
        onChanged();
      } else {
        byteItemBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The content must be PNG, JPEG, SVG or BMP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem byte_item = 7;</code>
     */
    public Builder setByteItem(com.google.privacy.dlp.v2.ByteContentItem.Builder builderForValue) {
      if (byteItemBuilder_ == null) {
        byteItem_ = builderForValue.build();
        onChanged();
      } else {
        byteItemBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The content must be PNG, JPEG, SVG or BMP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem byte_item = 7;</code>
     */
    public Builder mergeByteItem(com.google.privacy.dlp.v2.ByteContentItem value) {
      if (byteItemBuilder_ == null) {
        if (byteItem_ != null) {
          byteItem_ =
              com.google.privacy.dlp.v2.ByteContentItem.newBuilder(byteItem_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          byteItem_ = value;
        }
        onChanged();
      } else {
        byteItemBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The content must be PNG, JPEG, SVG or BMP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem byte_item = 7;</code>
     */
    public Builder clearByteItem() {
      if (byteItemBuilder_ == null) {
        byteItem_ = null;
        onChanged();
      } else {
        byteItem_ = null;
        byteItemBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The content must be PNG, JPEG, SVG or BMP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem byte_item = 7;</code>
     */
    public com.google.privacy.dlp.v2.ByteContentItem.Builder getByteItemBuilder() {

      onChanged();
      return getByteItemFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The content must be PNG, JPEG, SVG or BMP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem byte_item = 7;</code>
     */
    public com.google.privacy.dlp.v2.ByteContentItemOrBuilder getByteItemOrBuilder() {
      if (byteItemBuilder_ != null) {
        return byteItemBuilder_.getMessageOrBuilder();
      } else {
        return byteItem_ == null
            ? com.google.privacy.dlp.v2.ByteContentItem.getDefaultInstance()
            : byteItem_;
      }
    }
    /**
     *
     *
     * <pre>
     * The content must be PNG, JPEG, SVG or BMP.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ByteContentItem byte_item = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ByteContentItem,
            com.google.privacy.dlp.v2.ByteContentItem.Builder,
            com.google.privacy.dlp.v2.ByteContentItemOrBuilder>
        getByteItemFieldBuilder() {
      if (byteItemBuilder_ == null) {
        byteItemBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.ByteContentItem,
                com.google.privacy.dlp.v2.ByteContentItem.Builder,
                com.google.privacy.dlp.v2.ByteContentItemOrBuilder>(
                getByteItem(), getParentForChildren(), isClean());
        byteItem_ = null;
      }
      return byteItemBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.RedactImageRequest)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.RedactImageRequest)
  private static final com.google.privacy.dlp.v2.RedactImageRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.RedactImageRequest();
  }

  public static com.google.privacy.dlp.v2.RedactImageRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RedactImageRequest> PARSER =
      new com.google.protobuf.AbstractParser<RedactImageRequest>() {
        @java.lang.Override
        public RedactImageRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RedactImageRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RedactImageRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.RedactImageRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
