/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Specifies the location of the finding.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.Location}
 */
public final class Location extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Location)
    LocationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Location.newBuilder() to construct.
  private Location(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Location() {
    contentLocations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Location();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Location_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Location_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.Location.class,
            com.google.privacy.dlp.v2.Location.Builder.class);
  }

  public static final int BYTE_RANGE_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.Range byteRange_;
  /**
   *
   *
   * <pre>
   * Zero-based byte offsets delimiting the finding.
   * These are relative to the finding's containing element.
   * Note that when the content is not textual, this references
   * the UTF-8 encoded textual representation of the content.
   * Omitted if content is an image.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Range byte_range = 1;</code>
   *
   * @return Whether the byteRange field is set.
   */
  @java.lang.Override
  public boolean hasByteRange() {
    return byteRange_ != null;
  }
  /**
   *
   *
   * <pre>
   * Zero-based byte offsets delimiting the finding.
   * These are relative to the finding's containing element.
   * Note that when the content is not textual, this references
   * the UTF-8 encoded textual representation of the content.
   * Omitted if content is an image.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Range byte_range = 1;</code>
   *
   * @return The byteRange.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Range getByteRange() {
    return byteRange_ == null ? com.google.privacy.dlp.v2.Range.getDefaultInstance() : byteRange_;
  }
  /**
   *
   *
   * <pre>
   * Zero-based byte offsets delimiting the finding.
   * These are relative to the finding's containing element.
   * Note that when the content is not textual, this references
   * the UTF-8 encoded textual representation of the content.
   * Omitted if content is an image.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Range byte_range = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RangeOrBuilder getByteRangeOrBuilder() {
    return getByteRange();
  }

  public static final int CODEPOINT_RANGE_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.Range codepointRange_;
  /**
   *
   *
   * <pre>
   * Unicode character offsets delimiting the finding.
   * These are relative to the finding's containing element.
   * Provided when the content is text.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Range codepoint_range = 2;</code>
   *
   * @return Whether the codepointRange field is set.
   */
  @java.lang.Override
  public boolean hasCodepointRange() {
    return codepointRange_ != null;
  }
  /**
   *
   *
   * <pre>
   * Unicode character offsets delimiting the finding.
   * These are relative to the finding's containing element.
   * Provided when the content is text.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Range codepoint_range = 2;</code>
   *
   * @return The codepointRange.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Range getCodepointRange() {
    return codepointRange_ == null
        ? com.google.privacy.dlp.v2.Range.getDefaultInstance()
        : codepointRange_;
  }
  /**
   *
   *
   * <pre>
   * Unicode character offsets delimiting the finding.
   * These are relative to the finding's containing element.
   * Provided when the content is text.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Range codepoint_range = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RangeOrBuilder getCodepointRangeOrBuilder() {
    return getCodepointRange();
  }

  public static final int CONTENT_LOCATIONS_FIELD_NUMBER = 7;
  private java.util.List<com.google.privacy.dlp.v2.ContentLocation> contentLocations_;
  /**
   *
   *
   * <pre>
   * List of nested objects pointing to the precise location of the finding
   * within the file or record.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.ContentLocation> getContentLocationsList() {
    return contentLocations_;
  }
  /**
   *
   *
   * <pre>
   * List of nested objects pointing to the precise location of the finding
   * within the file or record.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.ContentLocationOrBuilder>
      getContentLocationsOrBuilderList() {
    return contentLocations_;
  }
  /**
   *
   *
   * <pre>
   * List of nested objects pointing to the precise location of the finding
   * within the file or record.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
   */
  @java.lang.Override
  public int getContentLocationsCount() {
    return contentLocations_.size();
  }
  /**
   *
   *
   * <pre>
   * List of nested objects pointing to the precise location of the finding
   * within the file or record.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ContentLocation getContentLocations(int index) {
    return contentLocations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of nested objects pointing to the precise location of the finding
   * within the file or record.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ContentLocationOrBuilder getContentLocationsOrBuilder(
      int index) {
    return contentLocations_.get(index);
  }

  public static final int CONTAINER_FIELD_NUMBER = 8;
  private com.google.privacy.dlp.v2.Container container_;
  /**
   *
   *
   * <pre>
   * Information about the container where this finding occurred, if available.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Container container = 8;</code>
   *
   * @return Whether the container field is set.
   */
  @java.lang.Override
  public boolean hasContainer() {
    return container_ != null;
  }
  /**
   *
   *
   * <pre>
   * Information about the container where this finding occurred, if available.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Container container = 8;</code>
   *
   * @return The container.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Container getContainer() {
    return container_ == null
        ? com.google.privacy.dlp.v2.Container.getDefaultInstance()
        : container_;
  }
  /**
   *
   *
   * <pre>
   * Information about the container where this finding occurred, if available.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Container container = 8;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ContainerOrBuilder getContainerOrBuilder() {
    return getContainer();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (byteRange_ != null) {
      output.writeMessage(1, getByteRange());
    }
    if (codepointRange_ != null) {
      output.writeMessage(2, getCodepointRange());
    }
    for (int i = 0; i < contentLocations_.size(); i++) {
      output.writeMessage(7, contentLocations_.get(i));
    }
    if (container_ != null) {
      output.writeMessage(8, getContainer());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (byteRange_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getByteRange());
    }
    if (codepointRange_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCodepointRange());
    }
    for (int i = 0; i < contentLocations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, contentLocations_.get(i));
    }
    if (container_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getContainer());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.Location)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.Location other = (com.google.privacy.dlp.v2.Location) obj;

    if (hasByteRange() != other.hasByteRange()) return false;
    if (hasByteRange()) {
      if (!getByteRange().equals(other.getByteRange())) return false;
    }
    if (hasCodepointRange() != other.hasCodepointRange()) return false;
    if (hasCodepointRange()) {
      if (!getCodepointRange().equals(other.getCodepointRange())) return false;
    }
    if (!getContentLocationsList().equals(other.getContentLocationsList())) return false;
    if (hasContainer() != other.hasContainer()) return false;
    if (hasContainer()) {
      if (!getContainer().equals(other.getContainer())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasByteRange()) {
      hash = (37 * hash) + BYTE_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getByteRange().hashCode();
    }
    if (hasCodepointRange()) {
      hash = (37 * hash) + CODEPOINT_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getCodepointRange().hashCode();
    }
    if (getContentLocationsCount() > 0) {
      hash = (37 * hash) + CONTENT_LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getContentLocationsList().hashCode();
    }
    if (hasContainer()) {
      hash = (37 * hash) + CONTAINER_FIELD_NUMBER;
      hash = (53 * hash) + getContainer().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.Location parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Location parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Location parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Location parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Location parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Location parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Location parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Location parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Location parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Location parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Location parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Location parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.Location prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies the location of the finding.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Location}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Location)
      com.google.privacy.dlp.v2.LocationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Location_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Location_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Location.class,
              com.google.privacy.dlp.v2.Location.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.Location.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (byteRangeBuilder_ == null) {
        byteRange_ = null;
      } else {
        byteRange_ = null;
        byteRangeBuilder_ = null;
      }
      if (codepointRangeBuilder_ == null) {
        codepointRange_ = null;
      } else {
        codepointRange_ = null;
        codepointRangeBuilder_ = null;
      }
      if (contentLocationsBuilder_ == null) {
        contentLocations_ = java.util.Collections.emptyList();
      } else {
        contentLocations_ = null;
        contentLocationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (containerBuilder_ == null) {
        container_ = null;
      } else {
        container_ = null;
        containerBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Location_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Location getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.Location.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Location build() {
      com.google.privacy.dlp.v2.Location result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Location buildPartial() {
      com.google.privacy.dlp.v2.Location result = new com.google.privacy.dlp.v2.Location(this);
      int from_bitField0_ = bitField0_;
      if (byteRangeBuilder_ == null) {
        result.byteRange_ = byteRange_;
      } else {
        result.byteRange_ = byteRangeBuilder_.build();
      }
      if (codepointRangeBuilder_ == null) {
        result.codepointRange_ = codepointRange_;
      } else {
        result.codepointRange_ = codepointRangeBuilder_.build();
      }
      if (contentLocationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          contentLocations_ = java.util.Collections.unmodifiableList(contentLocations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.contentLocations_ = contentLocations_;
      } else {
        result.contentLocations_ = contentLocationsBuilder_.build();
      }
      if (containerBuilder_ == null) {
        result.container_ = container_;
      } else {
        result.container_ = containerBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.Location) {
        return mergeFrom((com.google.privacy.dlp.v2.Location) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.Location other) {
      if (other == com.google.privacy.dlp.v2.Location.getDefaultInstance()) return this;
      if (other.hasByteRange()) {
        mergeByteRange(other.getByteRange());
      }
      if (other.hasCodepointRange()) {
        mergeCodepointRange(other.getCodepointRange());
      }
      if (contentLocationsBuilder_ == null) {
        if (!other.contentLocations_.isEmpty()) {
          if (contentLocations_.isEmpty()) {
            contentLocations_ = other.contentLocations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureContentLocationsIsMutable();
            contentLocations_.addAll(other.contentLocations_);
          }
          onChanged();
        }
      } else {
        if (!other.contentLocations_.isEmpty()) {
          if (contentLocationsBuilder_.isEmpty()) {
            contentLocationsBuilder_.dispose();
            contentLocationsBuilder_ = null;
            contentLocations_ = other.contentLocations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            contentLocationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getContentLocationsFieldBuilder()
                    : null;
          } else {
            contentLocationsBuilder_.addAllMessages(other.contentLocations_);
          }
        }
      }
      if (other.hasContainer()) {
        mergeContainer(other.getContainer());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getByteRangeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCodepointRangeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 58:
              {
                com.google.privacy.dlp.v2.ContentLocation m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.ContentLocation.parser(), extensionRegistry);
                if (contentLocationsBuilder_ == null) {
                  ensureContentLocationsIsMutable();
                  contentLocations_.add(m);
                } else {
                  contentLocationsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getContainerFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.Range byteRange_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Range,
            com.google.privacy.dlp.v2.Range.Builder,
            com.google.privacy.dlp.v2.RangeOrBuilder>
        byteRangeBuilder_;
    /**
     *
     *
     * <pre>
     * Zero-based byte offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Note that when the content is not textual, this references
     * the UTF-8 encoded textual representation of the content.
     * Omitted if content is an image.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range byte_range = 1;</code>
     *
     * @return Whether the byteRange field is set.
     */
    public boolean hasByteRange() {
      return byteRangeBuilder_ != null || byteRange_ != null;
    }
    /**
     *
     *
     * <pre>
     * Zero-based byte offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Note that when the content is not textual, this references
     * the UTF-8 encoded textual representation of the content.
     * Omitted if content is an image.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range byte_range = 1;</code>
     *
     * @return The byteRange.
     */
    public com.google.privacy.dlp.v2.Range getByteRange() {
      if (byteRangeBuilder_ == null) {
        return byteRange_ == null
            ? com.google.privacy.dlp.v2.Range.getDefaultInstance()
            : byteRange_;
      } else {
        return byteRangeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Zero-based byte offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Note that when the content is not textual, this references
     * the UTF-8 encoded textual representation of the content.
     * Omitted if content is an image.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range byte_range = 1;</code>
     */
    public Builder setByteRange(com.google.privacy.dlp.v2.Range value) {
      if (byteRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        byteRange_ = value;
        onChanged();
      } else {
        byteRangeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Zero-based byte offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Note that when the content is not textual, this references
     * the UTF-8 encoded textual representation of the content.
     * Omitted if content is an image.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range byte_range = 1;</code>
     */
    public Builder setByteRange(com.google.privacy.dlp.v2.Range.Builder builderForValue) {
      if (byteRangeBuilder_ == null) {
        byteRange_ = builderForValue.build();
        onChanged();
      } else {
        byteRangeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Zero-based byte offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Note that when the content is not textual, this references
     * the UTF-8 encoded textual representation of the content.
     * Omitted if content is an image.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range byte_range = 1;</code>
     */
    public Builder mergeByteRange(com.google.privacy.dlp.v2.Range value) {
      if (byteRangeBuilder_ == null) {
        if (byteRange_ != null) {
          byteRange_ =
              com.google.privacy.dlp.v2.Range.newBuilder(byteRange_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          byteRange_ = value;
        }
        onChanged();
      } else {
        byteRangeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Zero-based byte offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Note that when the content is not textual, this references
     * the UTF-8 encoded textual representation of the content.
     * Omitted if content is an image.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range byte_range = 1;</code>
     */
    public Builder clearByteRange() {
      if (byteRangeBuilder_ == null) {
        byteRange_ = null;
        onChanged();
      } else {
        byteRange_ = null;
        byteRangeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Zero-based byte offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Note that when the content is not textual, this references
     * the UTF-8 encoded textual representation of the content.
     * Omitted if content is an image.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range byte_range = 1;</code>
     */
    public com.google.privacy.dlp.v2.Range.Builder getByteRangeBuilder() {

      onChanged();
      return getByteRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Zero-based byte offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Note that when the content is not textual, this references
     * the UTF-8 encoded textual representation of the content.
     * Omitted if content is an image.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range byte_range = 1;</code>
     */
    public com.google.privacy.dlp.v2.RangeOrBuilder getByteRangeOrBuilder() {
      if (byteRangeBuilder_ != null) {
        return byteRangeBuilder_.getMessageOrBuilder();
      } else {
        return byteRange_ == null
            ? com.google.privacy.dlp.v2.Range.getDefaultInstance()
            : byteRange_;
      }
    }
    /**
     *
     *
     * <pre>
     * Zero-based byte offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Note that when the content is not textual, this references
     * the UTF-8 encoded textual representation of the content.
     * Omitted if content is an image.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range byte_range = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Range,
            com.google.privacy.dlp.v2.Range.Builder,
            com.google.privacy.dlp.v2.RangeOrBuilder>
        getByteRangeFieldBuilder() {
      if (byteRangeBuilder_ == null) {
        byteRangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Range,
                com.google.privacy.dlp.v2.Range.Builder,
                com.google.privacy.dlp.v2.RangeOrBuilder>(
                getByteRange(), getParentForChildren(), isClean());
        byteRange_ = null;
      }
      return byteRangeBuilder_;
    }

    private com.google.privacy.dlp.v2.Range codepointRange_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Range,
            com.google.privacy.dlp.v2.Range.Builder,
            com.google.privacy.dlp.v2.RangeOrBuilder>
        codepointRangeBuilder_;
    /**
     *
     *
     * <pre>
     * Unicode character offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Provided when the content is text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range codepoint_range = 2;</code>
     *
     * @return Whether the codepointRange field is set.
     */
    public boolean hasCodepointRange() {
      return codepointRangeBuilder_ != null || codepointRange_ != null;
    }
    /**
     *
     *
     * <pre>
     * Unicode character offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Provided when the content is text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range codepoint_range = 2;</code>
     *
     * @return The codepointRange.
     */
    public com.google.privacy.dlp.v2.Range getCodepointRange() {
      if (codepointRangeBuilder_ == null) {
        return codepointRange_ == null
            ? com.google.privacy.dlp.v2.Range.getDefaultInstance()
            : codepointRange_;
      } else {
        return codepointRangeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Unicode character offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Provided when the content is text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range codepoint_range = 2;</code>
     */
    public Builder setCodepointRange(com.google.privacy.dlp.v2.Range value) {
      if (codepointRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        codepointRange_ = value;
        onChanged();
      } else {
        codepointRangeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Unicode character offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Provided when the content is text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range codepoint_range = 2;</code>
     */
    public Builder setCodepointRange(com.google.privacy.dlp.v2.Range.Builder builderForValue) {
      if (codepointRangeBuilder_ == null) {
        codepointRange_ = builderForValue.build();
        onChanged();
      } else {
        codepointRangeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Unicode character offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Provided when the content is text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range codepoint_range = 2;</code>
     */
    public Builder mergeCodepointRange(com.google.privacy.dlp.v2.Range value) {
      if (codepointRangeBuilder_ == null) {
        if (codepointRange_ != null) {
          codepointRange_ =
              com.google.privacy.dlp.v2.Range.newBuilder(codepointRange_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          codepointRange_ = value;
        }
        onChanged();
      } else {
        codepointRangeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Unicode character offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Provided when the content is text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range codepoint_range = 2;</code>
     */
    public Builder clearCodepointRange() {
      if (codepointRangeBuilder_ == null) {
        codepointRange_ = null;
        onChanged();
      } else {
        codepointRange_ = null;
        codepointRangeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Unicode character offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Provided when the content is text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range codepoint_range = 2;</code>
     */
    public com.google.privacy.dlp.v2.Range.Builder getCodepointRangeBuilder() {

      onChanged();
      return getCodepointRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Unicode character offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Provided when the content is text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range codepoint_range = 2;</code>
     */
    public com.google.privacy.dlp.v2.RangeOrBuilder getCodepointRangeOrBuilder() {
      if (codepointRangeBuilder_ != null) {
        return codepointRangeBuilder_.getMessageOrBuilder();
      } else {
        return codepointRange_ == null
            ? com.google.privacy.dlp.v2.Range.getDefaultInstance()
            : codepointRange_;
      }
    }
    /**
     *
     *
     * <pre>
     * Unicode character offsets delimiting the finding.
     * These are relative to the finding's containing element.
     * Provided when the content is text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Range codepoint_range = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Range,
            com.google.privacy.dlp.v2.Range.Builder,
            com.google.privacy.dlp.v2.RangeOrBuilder>
        getCodepointRangeFieldBuilder() {
      if (codepointRangeBuilder_ == null) {
        codepointRangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Range,
                com.google.privacy.dlp.v2.Range.Builder,
                com.google.privacy.dlp.v2.RangeOrBuilder>(
                getCodepointRange(), getParentForChildren(), isClean());
        codepointRange_ = null;
      }
      return codepointRangeBuilder_;
    }

    private java.util.List<com.google.privacy.dlp.v2.ContentLocation> contentLocations_ =
        java.util.Collections.emptyList();

    private void ensureContentLocationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        contentLocations_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.ContentLocation>(contentLocations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.ContentLocation,
            com.google.privacy.dlp.v2.ContentLocation.Builder,
            com.google.privacy.dlp.v2.ContentLocationOrBuilder>
        contentLocationsBuilder_;

    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.ContentLocation> getContentLocationsList() {
      if (contentLocationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contentLocations_);
      } else {
        return contentLocationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public int getContentLocationsCount() {
      if (contentLocationsBuilder_ == null) {
        return contentLocations_.size();
      } else {
        return contentLocationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public com.google.privacy.dlp.v2.ContentLocation getContentLocations(int index) {
      if (contentLocationsBuilder_ == null) {
        return contentLocations_.get(index);
      } else {
        return contentLocationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public Builder setContentLocations(int index, com.google.privacy.dlp.v2.ContentLocation value) {
      if (contentLocationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentLocationsIsMutable();
        contentLocations_.set(index, value);
        onChanged();
      } else {
        contentLocationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public Builder setContentLocations(
        int index, com.google.privacy.dlp.v2.ContentLocation.Builder builderForValue) {
      if (contentLocationsBuilder_ == null) {
        ensureContentLocationsIsMutable();
        contentLocations_.set(index, builderForValue.build());
        onChanged();
      } else {
        contentLocationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public Builder addContentLocations(com.google.privacy.dlp.v2.ContentLocation value) {
      if (contentLocationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentLocationsIsMutable();
        contentLocations_.add(value);
        onChanged();
      } else {
        contentLocationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public Builder addContentLocations(int index, com.google.privacy.dlp.v2.ContentLocation value) {
      if (contentLocationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContentLocationsIsMutable();
        contentLocations_.add(index, value);
        onChanged();
      } else {
        contentLocationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public Builder addContentLocations(
        com.google.privacy.dlp.v2.ContentLocation.Builder builderForValue) {
      if (contentLocationsBuilder_ == null) {
        ensureContentLocationsIsMutable();
        contentLocations_.add(builderForValue.build());
        onChanged();
      } else {
        contentLocationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public Builder addContentLocations(
        int index, com.google.privacy.dlp.v2.ContentLocation.Builder builderForValue) {
      if (contentLocationsBuilder_ == null) {
        ensureContentLocationsIsMutable();
        contentLocations_.add(index, builderForValue.build());
        onChanged();
      } else {
        contentLocationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public Builder addAllContentLocations(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.ContentLocation> values) {
      if (contentLocationsBuilder_ == null) {
        ensureContentLocationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contentLocations_);
        onChanged();
      } else {
        contentLocationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public Builder clearContentLocations() {
      if (contentLocationsBuilder_ == null) {
        contentLocations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        contentLocationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public Builder removeContentLocations(int index) {
      if (contentLocationsBuilder_ == null) {
        ensureContentLocationsIsMutable();
        contentLocations_.remove(index);
        onChanged();
      } else {
        contentLocationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public com.google.privacy.dlp.v2.ContentLocation.Builder getContentLocationsBuilder(int index) {
      return getContentLocationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public com.google.privacy.dlp.v2.ContentLocationOrBuilder getContentLocationsOrBuilder(
        int index) {
      if (contentLocationsBuilder_ == null) {
        return contentLocations_.get(index);
      } else {
        return contentLocationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.ContentLocationOrBuilder>
        getContentLocationsOrBuilderList() {
      if (contentLocationsBuilder_ != null) {
        return contentLocationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contentLocations_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public com.google.privacy.dlp.v2.ContentLocation.Builder addContentLocationsBuilder() {
      return getContentLocationsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.ContentLocation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public com.google.privacy.dlp.v2.ContentLocation.Builder addContentLocationsBuilder(int index) {
      return getContentLocationsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.ContentLocation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of nested objects pointing to the precise location of the finding
     * within the file or record.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentLocation content_locations = 7;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.ContentLocation.Builder>
        getContentLocationsBuilderList() {
      return getContentLocationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.ContentLocation,
            com.google.privacy.dlp.v2.ContentLocation.Builder,
            com.google.privacy.dlp.v2.ContentLocationOrBuilder>
        getContentLocationsFieldBuilder() {
      if (contentLocationsBuilder_ == null) {
        contentLocationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.ContentLocation,
                com.google.privacy.dlp.v2.ContentLocation.Builder,
                com.google.privacy.dlp.v2.ContentLocationOrBuilder>(
                contentLocations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        contentLocations_ = null;
      }
      return contentLocationsBuilder_;
    }

    private com.google.privacy.dlp.v2.Container container_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Container,
            com.google.privacy.dlp.v2.Container.Builder,
            com.google.privacy.dlp.v2.ContainerOrBuilder>
        containerBuilder_;
    /**
     *
     *
     * <pre>
     * Information about the container where this finding occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container = 8;</code>
     *
     * @return Whether the container field is set.
     */
    public boolean hasContainer() {
      return containerBuilder_ != null || container_ != null;
    }
    /**
     *
     *
     * <pre>
     * Information about the container where this finding occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container = 8;</code>
     *
     * @return The container.
     */
    public com.google.privacy.dlp.v2.Container getContainer() {
      if (containerBuilder_ == null) {
        return container_ == null
            ? com.google.privacy.dlp.v2.Container.getDefaultInstance()
            : container_;
      } else {
        return containerBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the container where this finding occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container = 8;</code>
     */
    public Builder setContainer(com.google.privacy.dlp.v2.Container value) {
      if (containerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        container_ = value;
        onChanged();
      } else {
        containerBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the container where this finding occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container = 8;</code>
     */
    public Builder setContainer(com.google.privacy.dlp.v2.Container.Builder builderForValue) {
      if (containerBuilder_ == null) {
        container_ = builderForValue.build();
        onChanged();
      } else {
        containerBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the container where this finding occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container = 8;</code>
     */
    public Builder mergeContainer(com.google.privacy.dlp.v2.Container value) {
      if (containerBuilder_ == null) {
        if (container_ != null) {
          container_ =
              com.google.privacy.dlp.v2.Container.newBuilder(container_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          container_ = value;
        }
        onChanged();
      } else {
        containerBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the container where this finding occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container = 8;</code>
     */
    public Builder clearContainer() {
      if (containerBuilder_ == null) {
        container_ = null;
        onChanged();
      } else {
        container_ = null;
        containerBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about the container where this finding occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container = 8;</code>
     */
    public com.google.privacy.dlp.v2.Container.Builder getContainerBuilder() {

      onChanged();
      return getContainerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about the container where this finding occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container = 8;</code>
     */
    public com.google.privacy.dlp.v2.ContainerOrBuilder getContainerOrBuilder() {
      if (containerBuilder_ != null) {
        return containerBuilder_.getMessageOrBuilder();
      } else {
        return container_ == null
            ? com.google.privacy.dlp.v2.Container.getDefaultInstance()
            : container_;
      }
    }
    /**
     *
     *
     * <pre>
     * Information about the container where this finding occurred, if available.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Container container = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Container,
            com.google.privacy.dlp.v2.Container.Builder,
            com.google.privacy.dlp.v2.ContainerOrBuilder>
        getContainerFieldBuilder() {
      if (containerBuilder_ == null) {
        containerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Container,
                com.google.privacy.dlp.v2.Container.Builder,
                com.google.privacy.dlp.v2.ContainerOrBuilder>(
                getContainer(), getParentForChildren(), isClean());
        container_ = null;
      }
      return containerBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Location)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Location)
  private static final com.google.privacy.dlp.v2.Location DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Location();
  }

  public static com.google.privacy.dlp.v2.Location getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Location> PARSER =
      new com.google.protobuf.AbstractParser<Location>() {
        @java.lang.Override
        public Location parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Location> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Location> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.Location getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
