/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Controls what and how to inspect for findings.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.InspectJobConfig}
 */
public final class InspectJobConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.InspectJobConfig)
    InspectJobConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InspectJobConfig.newBuilder() to construct.
  private InspectJobConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InspectJobConfig() {
    inspectTemplateName_ = "";
    actions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InspectJobConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_InspectJobConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_InspectJobConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.InspectJobConfig.class,
            com.google.privacy.dlp.v2.InspectJobConfig.Builder.class);
  }

  public static final int STORAGE_CONFIG_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.StorageConfig storageConfig_;
  /**
   *
   *
   * <pre>
   * The data to scan.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StorageConfig storage_config = 1;</code>
   *
   * @return Whether the storageConfig field is set.
   */
  @java.lang.Override
  public boolean hasStorageConfig() {
    return storageConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The data to scan.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StorageConfig storage_config = 1;</code>
   *
   * @return The storageConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StorageConfig getStorageConfig() {
    return storageConfig_ == null
        ? com.google.privacy.dlp.v2.StorageConfig.getDefaultInstance()
        : storageConfig_;
  }
  /**
   *
   *
   * <pre>
   * The data to scan.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StorageConfig storage_config = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.StorageConfigOrBuilder getStorageConfigOrBuilder() {
    return getStorageConfig();
  }

  public static final int INSPECT_CONFIG_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.InspectConfig inspectConfig_;
  /**
   *
   *
   * <pre>
   * How and what to scan for.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
   *
   * @return Whether the inspectConfig field is set.
   */
  @java.lang.Override
  public boolean hasInspectConfig() {
    return inspectConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * How and what to scan for.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
   *
   * @return The inspectConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectConfig getInspectConfig() {
    return inspectConfig_ == null
        ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
        : inspectConfig_;
  }
  /**
   *
   *
   * <pre>
   * How and what to scan for.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectConfigOrBuilder getInspectConfigOrBuilder() {
    return getInspectConfig();
  }

  public static final int INSPECT_TEMPLATE_NAME_FIELD_NUMBER = 3;
  private volatile java.lang.Object inspectTemplateName_;
  /**
   *
   *
   * <pre>
   * If provided, will be used as the default for all values in InspectConfig.
   * `inspect_config` will be merged into the values persisted as part of the
   * template.
   * </pre>
   *
   * <code>string inspect_template_name = 3;</code>
   *
   * @return The inspectTemplateName.
   */
  @java.lang.Override
  public java.lang.String getInspectTemplateName() {
    java.lang.Object ref = inspectTemplateName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inspectTemplateName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If provided, will be used as the default for all values in InspectConfig.
   * `inspect_config` will be merged into the values persisted as part of the
   * template.
   * </pre>
   *
   * <code>string inspect_template_name = 3;</code>
   *
   * @return The bytes for inspectTemplateName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInspectTemplateNameBytes() {
    java.lang.Object ref = inspectTemplateName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inspectTemplateName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACTIONS_FIELD_NUMBER = 4;
  private java.util.List<com.google.privacy.dlp.v2.Action> actions_;
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.Action> getActionsList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.ActionOrBuilder>
      getActionsOrBuilderList() {
    return actions_;
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
   */
  @java.lang.Override
  public int getActionsCount() {
    return actions_.size();
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Action getActions(int index) {
    return actions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ActionOrBuilder getActionsOrBuilder(int index) {
    return actions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (storageConfig_ != null) {
      output.writeMessage(1, getStorageConfig());
    }
    if (inspectConfig_ != null) {
      output.writeMessage(2, getInspectConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inspectTemplateName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, inspectTemplateName_);
    }
    for (int i = 0; i < actions_.size(); i++) {
      output.writeMessage(4, actions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (storageConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStorageConfig());
    }
    if (inspectConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getInspectConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inspectTemplateName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, inspectTemplateName_);
    }
    for (int i = 0; i < actions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, actions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.InspectJobConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.InspectJobConfig other =
        (com.google.privacy.dlp.v2.InspectJobConfig) obj;

    if (hasStorageConfig() != other.hasStorageConfig()) return false;
    if (hasStorageConfig()) {
      if (!getStorageConfig().equals(other.getStorageConfig())) return false;
    }
    if (hasInspectConfig() != other.hasInspectConfig()) return false;
    if (hasInspectConfig()) {
      if (!getInspectConfig().equals(other.getInspectConfig())) return false;
    }
    if (!getInspectTemplateName().equals(other.getInspectTemplateName())) return false;
    if (!getActionsList().equals(other.getActionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStorageConfig()) {
      hash = (37 * hash) + STORAGE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getStorageConfig().hashCode();
    }
    if (hasInspectConfig()) {
      hash = (37 * hash) + INSPECT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInspectConfig().hashCode();
    }
    hash = (37 * hash) + INSPECT_TEMPLATE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getInspectTemplateName().hashCode();
    if (getActionsCount() > 0) {
      hash = (37 * hash) + ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getActionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.InspectJobConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Controls what and how to inspect for findings.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.InspectJobConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.InspectJobConfig)
      com.google.privacy.dlp.v2.InspectJobConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InspectJobConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InspectJobConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.InspectJobConfig.class,
              com.google.privacy.dlp.v2.InspectJobConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.InspectJobConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (storageConfigBuilder_ == null) {
        storageConfig_ = null;
      } else {
        storageConfig_ = null;
        storageConfigBuilder_ = null;
      }
      if (inspectConfigBuilder_ == null) {
        inspectConfig_ = null;
      } else {
        inspectConfig_ = null;
        inspectConfigBuilder_ = null;
      }
      inspectTemplateName_ = "";

      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
      } else {
        actions_ = null;
        actionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InspectJobConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectJobConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectJobConfig build() {
      com.google.privacy.dlp.v2.InspectJobConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectJobConfig buildPartial() {
      com.google.privacy.dlp.v2.InspectJobConfig result =
          new com.google.privacy.dlp.v2.InspectJobConfig(this);
      int from_bitField0_ = bitField0_;
      if (storageConfigBuilder_ == null) {
        result.storageConfig_ = storageConfig_;
      } else {
        result.storageConfig_ = storageConfigBuilder_.build();
      }
      if (inspectConfigBuilder_ == null) {
        result.inspectConfig_ = inspectConfig_;
      } else {
        result.inspectConfig_ = inspectConfigBuilder_.build();
      }
      result.inspectTemplateName_ = inspectTemplateName_;
      if (actionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          actions_ = java.util.Collections.unmodifiableList(actions_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.actions_ = actions_;
      } else {
        result.actions_ = actionsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.InspectJobConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.InspectJobConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.InspectJobConfig other) {
      if (other == com.google.privacy.dlp.v2.InspectJobConfig.getDefaultInstance()) return this;
      if (other.hasStorageConfig()) {
        mergeStorageConfig(other.getStorageConfig());
      }
      if (other.hasInspectConfig()) {
        mergeInspectConfig(other.getInspectConfig());
      }
      if (!other.getInspectTemplateName().isEmpty()) {
        inspectTemplateName_ = other.inspectTemplateName_;
        onChanged();
      }
      if (actionsBuilder_ == null) {
        if (!other.actions_.isEmpty()) {
          if (actions_.isEmpty()) {
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureActionsIsMutable();
            actions_.addAll(other.actions_);
          }
          onChanged();
        }
      } else {
        if (!other.actions_.isEmpty()) {
          if (actionsBuilder_.isEmpty()) {
            actionsBuilder_.dispose();
            actionsBuilder_ = null;
            actions_ = other.actions_;
            bitField0_ = (bitField0_ & ~0x00000001);
            actionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getActionsFieldBuilder()
                    : null;
          } else {
            actionsBuilder_.addAllMessages(other.actions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStorageConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInspectConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                inspectTemplateName_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 34:
              {
                com.google.privacy.dlp.v2.Action m =
                    input.readMessage(com.google.privacy.dlp.v2.Action.parser(), extensionRegistry);
                if (actionsBuilder_ == null) {
                  ensureActionsIsMutable();
                  actions_.add(m);
                } else {
                  actionsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.StorageConfig storageConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.StorageConfig,
            com.google.privacy.dlp.v2.StorageConfig.Builder,
            com.google.privacy.dlp.v2.StorageConfigOrBuilder>
        storageConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StorageConfig storage_config = 1;</code>
     *
     * @return Whether the storageConfig field is set.
     */
    public boolean hasStorageConfig() {
      return storageConfigBuilder_ != null || storageConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StorageConfig storage_config = 1;</code>
     *
     * @return The storageConfig.
     */
    public com.google.privacy.dlp.v2.StorageConfig getStorageConfig() {
      if (storageConfigBuilder_ == null) {
        return storageConfig_ == null
            ? com.google.privacy.dlp.v2.StorageConfig.getDefaultInstance()
            : storageConfig_;
      } else {
        return storageConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StorageConfig storage_config = 1;</code>
     */
    public Builder setStorageConfig(com.google.privacy.dlp.v2.StorageConfig value) {
      if (storageConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        storageConfig_ = value;
        onChanged();
      } else {
        storageConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StorageConfig storage_config = 1;</code>
     */
    public Builder setStorageConfig(
        com.google.privacy.dlp.v2.StorageConfig.Builder builderForValue) {
      if (storageConfigBuilder_ == null) {
        storageConfig_ = builderForValue.build();
        onChanged();
      } else {
        storageConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StorageConfig storage_config = 1;</code>
     */
    public Builder mergeStorageConfig(com.google.privacy.dlp.v2.StorageConfig value) {
      if (storageConfigBuilder_ == null) {
        if (storageConfig_ != null) {
          storageConfig_ =
              com.google.privacy.dlp.v2.StorageConfig.newBuilder(storageConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          storageConfig_ = value;
        }
        onChanged();
      } else {
        storageConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StorageConfig storage_config = 1;</code>
     */
    public Builder clearStorageConfig() {
      if (storageConfigBuilder_ == null) {
        storageConfig_ = null;
        onChanged();
      } else {
        storageConfig_ = null;
        storageConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StorageConfig storage_config = 1;</code>
     */
    public com.google.privacy.dlp.v2.StorageConfig.Builder getStorageConfigBuilder() {

      onChanged();
      return getStorageConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StorageConfig storage_config = 1;</code>
     */
    public com.google.privacy.dlp.v2.StorageConfigOrBuilder getStorageConfigOrBuilder() {
      if (storageConfigBuilder_ != null) {
        return storageConfigBuilder_.getMessageOrBuilder();
      } else {
        return storageConfig_ == null
            ? com.google.privacy.dlp.v2.StorageConfig.getDefaultInstance()
            : storageConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.StorageConfig storage_config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.StorageConfig,
            com.google.privacy.dlp.v2.StorageConfig.Builder,
            com.google.privacy.dlp.v2.StorageConfigOrBuilder>
        getStorageConfigFieldBuilder() {
      if (storageConfigBuilder_ == null) {
        storageConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.StorageConfig,
                com.google.privacy.dlp.v2.StorageConfig.Builder,
                com.google.privacy.dlp.v2.StorageConfigOrBuilder>(
                getStorageConfig(), getParentForChildren(), isClean());
        storageConfig_ = null;
      }
      return storageConfigBuilder_;
    }

    private com.google.privacy.dlp.v2.InspectConfig inspectConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectConfig,
            com.google.privacy.dlp.v2.InspectConfig.Builder,
            com.google.privacy.dlp.v2.InspectConfigOrBuilder>
        inspectConfigBuilder_;
    /**
     *
     *
     * <pre>
     * How and what to scan for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     *
     * @return Whether the inspectConfig field is set.
     */
    public boolean hasInspectConfig() {
      return inspectConfigBuilder_ != null || inspectConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * How and what to scan for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     *
     * @return The inspectConfig.
     */
    public com.google.privacy.dlp.v2.InspectConfig getInspectConfig() {
      if (inspectConfigBuilder_ == null) {
        return inspectConfig_ == null
            ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
            : inspectConfig_;
      } else {
        return inspectConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * How and what to scan for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public Builder setInspectConfig(com.google.privacy.dlp.v2.InspectConfig value) {
      if (inspectConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inspectConfig_ = value;
        onChanged();
      } else {
        inspectConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * How and what to scan for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public Builder setInspectConfig(
        com.google.privacy.dlp.v2.InspectConfig.Builder builderForValue) {
      if (inspectConfigBuilder_ == null) {
        inspectConfig_ = builderForValue.build();
        onChanged();
      } else {
        inspectConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * How and what to scan for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public Builder mergeInspectConfig(com.google.privacy.dlp.v2.InspectConfig value) {
      if (inspectConfigBuilder_ == null) {
        if (inspectConfig_ != null) {
          inspectConfig_ =
              com.google.privacy.dlp.v2.InspectConfig.newBuilder(inspectConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          inspectConfig_ = value;
        }
        onChanged();
      } else {
        inspectConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * How and what to scan for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public Builder clearInspectConfig() {
      if (inspectConfigBuilder_ == null) {
        inspectConfig_ = null;
        onChanged();
      } else {
        inspectConfig_ = null;
        inspectConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * How and what to scan for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public com.google.privacy.dlp.v2.InspectConfig.Builder getInspectConfigBuilder() {

      onChanged();
      return getInspectConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * How and what to scan for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    public com.google.privacy.dlp.v2.InspectConfigOrBuilder getInspectConfigOrBuilder() {
      if (inspectConfigBuilder_ != null) {
        return inspectConfigBuilder_.getMessageOrBuilder();
      } else {
        return inspectConfig_ == null
            ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
            : inspectConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * How and what to scan for.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectConfig,
            com.google.privacy.dlp.v2.InspectConfig.Builder,
            com.google.privacy.dlp.v2.InspectConfigOrBuilder>
        getInspectConfigFieldBuilder() {
      if (inspectConfigBuilder_ == null) {
        inspectConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InspectConfig,
                com.google.privacy.dlp.v2.InspectConfig.Builder,
                com.google.privacy.dlp.v2.InspectConfigOrBuilder>(
                getInspectConfig(), getParentForChildren(), isClean());
        inspectConfig_ = null;
      }
      return inspectConfigBuilder_;
    }

    private java.lang.Object inspectTemplateName_ = "";
    /**
     *
     *
     * <pre>
     * If provided, will be used as the default for all values in InspectConfig.
     * `inspect_config` will be merged into the values persisted as part of the
     * template.
     * </pre>
     *
     * <code>string inspect_template_name = 3;</code>
     *
     * @return The inspectTemplateName.
     */
    public java.lang.String getInspectTemplateName() {
      java.lang.Object ref = inspectTemplateName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inspectTemplateName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If provided, will be used as the default for all values in InspectConfig.
     * `inspect_config` will be merged into the values persisted as part of the
     * template.
     * </pre>
     *
     * <code>string inspect_template_name = 3;</code>
     *
     * @return The bytes for inspectTemplateName.
     */
    public com.google.protobuf.ByteString getInspectTemplateNameBytes() {
      java.lang.Object ref = inspectTemplateName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inspectTemplateName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If provided, will be used as the default for all values in InspectConfig.
     * `inspect_config` will be merged into the values persisted as part of the
     * template.
     * </pre>
     *
     * <code>string inspect_template_name = 3;</code>
     *
     * @param value The inspectTemplateName to set.
     * @return This builder for chaining.
     */
    public Builder setInspectTemplateName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      inspectTemplateName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If provided, will be used as the default for all values in InspectConfig.
     * `inspect_config` will be merged into the values persisted as part of the
     * template.
     * </pre>
     *
     * <code>string inspect_template_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInspectTemplateName() {

      inspectTemplateName_ = getDefaultInstance().getInspectTemplateName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If provided, will be used as the default for all values in InspectConfig.
     * `inspect_config` will be merged into the values persisted as part of the
     * template.
     * </pre>
     *
     * <code>string inspect_template_name = 3;</code>
     *
     * @param value The bytes for inspectTemplateName to set.
     * @return This builder for chaining.
     */
    public Builder setInspectTemplateNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      inspectTemplateName_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.privacy.dlp.v2.Action> actions_ =
        java.util.Collections.emptyList();

    private void ensureActionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        actions_ = new java.util.ArrayList<com.google.privacy.dlp.v2.Action>(actions_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Action,
            com.google.privacy.dlp.v2.Action.Builder,
            com.google.privacy.dlp.v2.ActionOrBuilder>
        actionsBuilder_;

    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Action> getActionsList() {
      if (actionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(actions_);
      } else {
        return actionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public int getActionsCount() {
      if (actionsBuilder_ == null) {
        return actions_.size();
      } else {
        return actionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public com.google.privacy.dlp.v2.Action getActions(int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public Builder setActions(int index, com.google.privacy.dlp.v2.Action value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.set(index, value);
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public Builder setActions(int index, com.google.privacy.dlp.v2.Action.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.set(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public Builder addActions(com.google.privacy.dlp.v2.Action value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public Builder addActions(int index, com.google.privacy.dlp.v2.Action value) {
      if (actionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureActionsIsMutable();
        actions_.add(index, value);
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public Builder addActions(com.google.privacy.dlp.v2.Action.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public Builder addActions(int index, com.google.privacy.dlp.v2.Action.Builder builderForValue) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.add(index, builderForValue.build());
        onChanged();
      } else {
        actionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public Builder addAllActions(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.Action> values) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, actions_);
        onChanged();
      } else {
        actionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public Builder clearActions() {
      if (actionsBuilder_ == null) {
        actions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        actionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public Builder removeActions(int index) {
      if (actionsBuilder_ == null) {
        ensureActionsIsMutable();
        actions_.remove(index);
        onChanged();
      } else {
        actionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public com.google.privacy.dlp.v2.Action.Builder getActionsBuilder(int index) {
      return getActionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public com.google.privacy.dlp.v2.ActionOrBuilder getActionsOrBuilder(int index) {
      if (actionsBuilder_ == null) {
        return actions_.get(index);
      } else {
        return actionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.ActionOrBuilder>
        getActionsOrBuilderList() {
      if (actionsBuilder_ != null) {
        return actionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(actions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public com.google.privacy.dlp.v2.Action.Builder addActionsBuilder() {
      return getActionsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.Action.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public com.google.privacy.dlp.v2.Action.Builder addActionsBuilder(int index) {
      return getActionsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.Action.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.Action actions = 4;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.Action.Builder> getActionsBuilderList() {
      return getActionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.Action,
            com.google.privacy.dlp.v2.Action.Builder,
            com.google.privacy.dlp.v2.ActionOrBuilder>
        getActionsFieldBuilder() {
      if (actionsBuilder_ == null) {
        actionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.Action,
                com.google.privacy.dlp.v2.Action.Builder,
                com.google.privacy.dlp.v2.ActionOrBuilder>(
                actions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        actions_ = null;
      }
      return actionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.InspectJobConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.InspectJobConfig)
  private static final com.google.privacy.dlp.v2.InspectJobConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.InspectJobConfig();
  }

  public static com.google.privacy.dlp.v2.InspectJobConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InspectJobConfig> PARSER =
      new com.google.protobuf.AbstractParser<InspectJobConfig>() {
        @java.lang.Override
        public InspectJobConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InspectJobConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InspectJobConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectJobConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
