/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Configuration description of the scanning process.
 * When used with redactContent only info_types and min_likelihood are currently
 * used.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.InspectConfig}
 */
public final class InspectConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.InspectConfig)
    InspectConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InspectConfig.newBuilder() to construct.
  private InspectConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InspectConfig() {
    infoTypes_ = java.util.Collections.emptyList();
    minLikelihood_ = 0;
    customInfoTypes_ = java.util.Collections.emptyList();
    contentOptions_ = java.util.Collections.emptyList();
    ruleSet_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InspectConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_InspectConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_InspectConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.InspectConfig.class,
            com.google.privacy.dlp.v2.InspectConfig.Builder.class);
  }

  public interface FindingLimitsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.InspectConfig.FindingLimits)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Max number of findings that will be returned for each item scanned.
     * When set within `InspectJobConfig`,
     * the maximum returned is 2000 regardless if this is set higher.
     * When set within `InspectContentRequest`, this field is ignored.
     * </pre>
     *
     * <code>int32 max_findings_per_item = 1;</code>
     *
     * @return The maxFindingsPerItem.
     */
    int getMaxFindingsPerItem();

    /**
     *
     *
     * <pre>
     * Max number of findings that will be returned per request/job.
     * When set within `InspectContentRequest`, the maximum returned is 2000
     * regardless if this is set higher.
     * </pre>
     *
     * <code>int32 max_findings_per_request = 2;</code>
     *
     * @return The maxFindingsPerRequest.
     */
    int getMaxFindingsPerRequest();

    /**
     *
     *
     * <pre>
     * Configuration of findings limit given for specified infoTypes.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
     * </code>
     */
    java.util.List<com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit>
        getMaxFindingsPerInfoTypeList();
    /**
     *
     *
     * <pre>
     * Configuration of findings limit given for specified infoTypes.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
     * </code>
     */
    com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit getMaxFindingsPerInfoType(
        int index);
    /**
     *
     *
     * <pre>
     * Configuration of findings limit given for specified infoTypes.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
     * </code>
     */
    int getMaxFindingsPerInfoTypeCount();
    /**
     *
     *
     * <pre>
     * Configuration of findings limit given for specified infoTypes.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
     * </code>
     */
    java.util.List<
            ? extends com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimitOrBuilder>
        getMaxFindingsPerInfoTypeOrBuilderList();
    /**
     *
     *
     * <pre>
     * Configuration of findings limit given for specified infoTypes.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
     * </code>
     */
    com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimitOrBuilder
        getMaxFindingsPerInfoTypeOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * Configuration to control the number of findings returned for inspection.
   * This is not used for de-identification or data profiling.
   * When redacting sensitive data from images, finding limits don't apply. They
   * can cause unexpected or inconsistent results, where only some data is
   * redacted. Don't include finding limits in
   * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
   * requests. Otherwise, Cloud DLP returns an error.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.InspectConfig.FindingLimits}
   */
  public static final class FindingLimits extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.InspectConfig.FindingLimits)
      FindingLimitsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FindingLimits.newBuilder() to construct.
    private FindingLimits(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FindingLimits() {
      maxFindingsPerInfoType_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FindingLimits();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.InspectConfig.FindingLimits.class,
              com.google.privacy.dlp.v2.InspectConfig.FindingLimits.Builder.class);
    }

    public interface InfoTypeLimitOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Type of information the findings limit applies to. Only one limit per
       * info_type should be provided. If InfoTypeLimit does not have an
       * info_type, the DLP API applies the limit against all info_types that
       * are found but not specified in another InfoTypeLimit.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       *
       * @return Whether the infoType field is set.
       */
      boolean hasInfoType();
      /**
       *
       *
       * <pre>
       * Type of information the findings limit applies to. Only one limit per
       * info_type should be provided. If InfoTypeLimit does not have an
       * info_type, the DLP API applies the limit against all info_types that
       * are found but not specified in another InfoTypeLimit.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       *
       * @return The infoType.
       */
      com.google.privacy.dlp.v2.InfoType getInfoType();
      /**
       *
       *
       * <pre>
       * Type of information the findings limit applies to. Only one limit per
       * info_type should be provided. If InfoTypeLimit does not have an
       * info_type, the DLP API applies the limit against all info_types that
       * are found but not specified in another InfoTypeLimit.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       */
      com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder();

      /**
       *
       *
       * <pre>
       * Max findings limit for the given infoType.
       * </pre>
       *
       * <code>int32 max_findings = 2;</code>
       *
       * @return The maxFindings.
       */
      int getMaxFindings();
    }
    /**
     *
     *
     * <pre>
     * Max findings configuration per infoType, per content item or long
     * running DlpJob.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit}
     */
    public static final class InfoTypeLimit extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit)
        InfoTypeLimitOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use InfoTypeLimit.newBuilder() to construct.
      private InfoTypeLimit(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private InfoTypeLimit() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new InfoTypeLimit();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_InfoTypeLimit_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_InfoTypeLimit_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.class,
                com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.Builder.class);
      }

      public static final int INFO_TYPE_FIELD_NUMBER = 1;
      private com.google.privacy.dlp.v2.InfoType infoType_;
      /**
       *
       *
       * <pre>
       * Type of information the findings limit applies to. Only one limit per
       * info_type should be provided. If InfoTypeLimit does not have an
       * info_type, the DLP API applies the limit against all info_types that
       * are found but not specified in another InfoTypeLimit.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       *
       * @return Whether the infoType field is set.
       */
      @java.lang.Override
      public boolean hasInfoType() {
        return infoType_ != null;
      }
      /**
       *
       *
       * <pre>
       * Type of information the findings limit applies to. Only one limit per
       * info_type should be provided. If InfoTypeLimit does not have an
       * info_type, the DLP API applies the limit against all info_types that
       * are found but not specified in another InfoTypeLimit.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       *
       * @return The infoType.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.InfoType getInfoType() {
        return infoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : infoType_;
      }
      /**
       *
       *
       * <pre>
       * Type of information the findings limit applies to. Only one limit per
       * info_type should be provided. If InfoTypeLimit does not have an
       * info_type, the DLP API applies the limit against all info_types that
       * are found but not specified in another InfoTypeLimit.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
        return getInfoType();
      }

      public static final int MAX_FINDINGS_FIELD_NUMBER = 2;
      private int maxFindings_;
      /**
       *
       *
       * <pre>
       * Max findings limit for the given infoType.
       * </pre>
       *
       * <code>int32 max_findings = 2;</code>
       *
       * @return The maxFindings.
       */
      @java.lang.Override
      public int getMaxFindings() {
        return maxFindings_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (infoType_ != null) {
          output.writeMessage(1, getInfoType());
        }
        if (maxFindings_ != 0) {
          output.writeInt32(2, maxFindings_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (infoType_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInfoType());
        }
        if (maxFindings_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxFindings_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit)) {
          return super.equals(obj);
        }
        com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit other =
            (com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit) obj;

        if (hasInfoType() != other.hasInfoType()) return false;
        if (hasInfoType()) {
          if (!getInfoType().equals(other.getInfoType())) return false;
        }
        if (getMaxFindings() != other.getMaxFindings()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasInfoType()) {
          hash = (37 * hash) + INFO_TYPE_FIELD_NUMBER;
          hash = (53 * hash) + getInfoType().hashCode();
        }
        hash = (37 * hash) + MAX_FINDINGS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxFindings();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Max findings configuration per infoType, per content item or long
       * running DlpJob.
       * </pre>
       *
       * Protobuf type {@code google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit)
          com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimitOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.privacy.dlp.v2.DlpProto
              .internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_InfoTypeLimit_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.privacy.dlp.v2.DlpProto
              .internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_InfoTypeLimit_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.class,
                  com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.Builder
                      .class);
        }

        // Construct using
        // com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (infoTypeBuilder_ == null) {
            infoType_ = null;
          } else {
            infoType_ = null;
            infoTypeBuilder_ = null;
          }
          maxFindings_ = 0;

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.privacy.dlp.v2.DlpProto
              .internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_InfoTypeLimit_descriptor;
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
            getDefaultInstanceForType() {
          return com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit build() {
          com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit buildPartial() {
          com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit result =
              new com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit(this);
          if (infoTypeBuilder_ == null) {
            result.infoType_ = infoType_;
          } else {
            result.infoType_ = infoTypeBuilder_.build();
          }
          result.maxFindings_ = maxFindings_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit) {
            return mergeFrom(
                (com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit other) {
          if (other
              == com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
                  .getDefaultInstance()) return this;
          if (other.hasInfoType()) {
            mergeInfoType(other.getInfoType());
          }
          if (other.getMaxFindings() != 0) {
            setMaxFindings(other.getMaxFindings());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getInfoTypeFieldBuilder().getBuilder(), extensionRegistry);

                    break;
                  } // case 10
                case 16:
                  {
                    maxFindings_ = input.readInt32();

                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private com.google.privacy.dlp.v2.InfoType infoType_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoType,
                com.google.privacy.dlp.v2.InfoType.Builder,
                com.google.privacy.dlp.v2.InfoTypeOrBuilder>
            infoTypeBuilder_;
        /**
         *
         *
         * <pre>
         * Type of information the findings limit applies to. Only one limit per
         * info_type should be provided. If InfoTypeLimit does not have an
         * info_type, the DLP API applies the limit against all info_types that
         * are found but not specified in another InfoTypeLimit.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
         *
         * @return Whether the infoType field is set.
         */
        public boolean hasInfoType() {
          return infoTypeBuilder_ != null || infoType_ != null;
        }
        /**
         *
         *
         * <pre>
         * Type of information the findings limit applies to. Only one limit per
         * info_type should be provided. If InfoTypeLimit does not have an
         * info_type, the DLP API applies the limit against all info_types that
         * are found but not specified in another InfoTypeLimit.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
         *
         * @return The infoType.
         */
        public com.google.privacy.dlp.v2.InfoType getInfoType() {
          if (infoTypeBuilder_ == null) {
            return infoType_ == null
                ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
                : infoType_;
          } else {
            return infoTypeBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Type of information the findings limit applies to. Only one limit per
         * info_type should be provided. If InfoTypeLimit does not have an
         * info_type, the DLP API applies the limit against all info_types that
         * are found but not specified in another InfoTypeLimit.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
         */
        public Builder setInfoType(com.google.privacy.dlp.v2.InfoType value) {
          if (infoTypeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            infoType_ = value;
            onChanged();
          } else {
            infoTypeBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Type of information the findings limit applies to. Only one limit per
         * info_type should be provided. If InfoTypeLimit does not have an
         * info_type, the DLP API applies the limit against all info_types that
         * are found but not specified in another InfoTypeLimit.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
         */
        public Builder setInfoType(com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
          if (infoTypeBuilder_ == null) {
            infoType_ = builderForValue.build();
            onChanged();
          } else {
            infoTypeBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Type of information the findings limit applies to. Only one limit per
         * info_type should be provided. If InfoTypeLimit does not have an
         * info_type, the DLP API applies the limit against all info_types that
         * are found but not specified in another InfoTypeLimit.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
         */
        public Builder mergeInfoType(com.google.privacy.dlp.v2.InfoType value) {
          if (infoTypeBuilder_ == null) {
            if (infoType_ != null) {
              infoType_ =
                  com.google.privacy.dlp.v2.InfoType.newBuilder(infoType_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              infoType_ = value;
            }
            onChanged();
          } else {
            infoTypeBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Type of information the findings limit applies to. Only one limit per
         * info_type should be provided. If InfoTypeLimit does not have an
         * info_type, the DLP API applies the limit against all info_types that
         * are found but not specified in another InfoTypeLimit.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
         */
        public Builder clearInfoType() {
          if (infoTypeBuilder_ == null) {
            infoType_ = null;
            onChanged();
          } else {
            infoType_ = null;
            infoTypeBuilder_ = null;
          }

          return this;
        }
        /**
         *
         *
         * <pre>
         * Type of information the findings limit applies to. Only one limit per
         * info_type should be provided. If InfoTypeLimit does not have an
         * info_type, the DLP API applies the limit against all info_types that
         * are found but not specified in another InfoTypeLimit.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
         */
        public com.google.privacy.dlp.v2.InfoType.Builder getInfoTypeBuilder() {

          onChanged();
          return getInfoTypeFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Type of information the findings limit applies to. Only one limit per
         * info_type should be provided. If InfoTypeLimit does not have an
         * info_type, the DLP API applies the limit against all info_types that
         * are found but not specified in another InfoTypeLimit.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
         */
        public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
          if (infoTypeBuilder_ != null) {
            return infoTypeBuilder_.getMessageOrBuilder();
          } else {
            return infoType_ == null
                ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
                : infoType_;
          }
        }
        /**
         *
         *
         * <pre>
         * Type of information the findings limit applies to. Only one limit per
         * info_type should be provided. If InfoTypeLimit does not have an
         * info_type, the DLP API applies the limit against all info_types that
         * are found but not specified in another InfoTypeLimit.
         * </pre>
         *
         * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoType,
                com.google.privacy.dlp.v2.InfoType.Builder,
                com.google.privacy.dlp.v2.InfoTypeOrBuilder>
            getInfoTypeFieldBuilder() {
          if (infoTypeBuilder_ == null) {
            infoTypeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.privacy.dlp.v2.InfoType,
                    com.google.privacy.dlp.v2.InfoType.Builder,
                    com.google.privacy.dlp.v2.InfoTypeOrBuilder>(
                    getInfoType(), getParentForChildren(), isClean());
            infoType_ = null;
          }
          return infoTypeBuilder_;
        }

        private int maxFindings_;
        /**
         *
         *
         * <pre>
         * Max findings limit for the given infoType.
         * </pre>
         *
         * <code>int32 max_findings = 2;</code>
         *
         * @return The maxFindings.
         */
        @java.lang.Override
        public int getMaxFindings() {
          return maxFindings_;
        }
        /**
         *
         *
         * <pre>
         * Max findings limit for the given infoType.
         * </pre>
         *
         * <code>int32 max_findings = 2;</code>
         *
         * @param value The maxFindings to set.
         * @return This builder for chaining.
         */
        public Builder setMaxFindings(int value) {

          maxFindings_ = value;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Max findings limit for the given infoType.
         * </pre>
         *
         * <code>int32 max_findings = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxFindings() {

          maxFindings_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit)
      }

      // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit)
      private static final com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit();
      }

      public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<InfoTypeLimit> PARSER =
          new com.google.protobuf.AbstractParser<InfoTypeLimit>() {
            @java.lang.Override
            public InfoTypeLimit parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<InfoTypeLimit> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<InfoTypeLimit> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int MAX_FINDINGS_PER_ITEM_FIELD_NUMBER = 1;
    private int maxFindingsPerItem_;
    /**
     *
     *
     * <pre>
     * Max number of findings that will be returned for each item scanned.
     * When set within `InspectJobConfig`,
     * the maximum returned is 2000 regardless if this is set higher.
     * When set within `InspectContentRequest`, this field is ignored.
     * </pre>
     *
     * <code>int32 max_findings_per_item = 1;</code>
     *
     * @return The maxFindingsPerItem.
     */
    @java.lang.Override
    public int getMaxFindingsPerItem() {
      return maxFindingsPerItem_;
    }

    public static final int MAX_FINDINGS_PER_REQUEST_FIELD_NUMBER = 2;
    private int maxFindingsPerRequest_;
    /**
     *
     *
     * <pre>
     * Max number of findings that will be returned per request/job.
     * When set within `InspectContentRequest`, the maximum returned is 2000
     * regardless if this is set higher.
     * </pre>
     *
     * <code>int32 max_findings_per_request = 2;</code>
     *
     * @return The maxFindingsPerRequest.
     */
    @java.lang.Override
    public int getMaxFindingsPerRequest() {
      return maxFindingsPerRequest_;
    }

    public static final int MAX_FINDINGS_PER_INFO_TYPE_FIELD_NUMBER = 3;
    private java.util.List<com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit>
        maxFindingsPerInfoType_;
    /**
     *
     *
     * <pre>
     * Configuration of findings limit given for specified infoTypes.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit>
        getMaxFindingsPerInfoTypeList() {
      return maxFindingsPerInfoType_;
    }
    /**
     *
     *
     * <pre>
     * Configuration of findings limit given for specified infoTypes.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimitOrBuilder>
        getMaxFindingsPerInfoTypeOrBuilderList() {
      return maxFindingsPerInfoType_;
    }
    /**
     *
     *
     * <pre>
     * Configuration of findings limit given for specified infoTypes.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
     * </code>
     */
    @java.lang.Override
    public int getMaxFindingsPerInfoTypeCount() {
      return maxFindingsPerInfoType_.size();
    }
    /**
     *
     *
     * <pre>
     * Configuration of findings limit given for specified infoTypes.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
        getMaxFindingsPerInfoType(int index) {
      return maxFindingsPerInfoType_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Configuration of findings limit given for specified infoTypes.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimitOrBuilder
        getMaxFindingsPerInfoTypeOrBuilder(int index) {
      return maxFindingsPerInfoType_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (maxFindingsPerItem_ != 0) {
        output.writeInt32(1, maxFindingsPerItem_);
      }
      if (maxFindingsPerRequest_ != 0) {
        output.writeInt32(2, maxFindingsPerRequest_);
      }
      for (int i = 0; i < maxFindingsPerInfoType_.size(); i++) {
        output.writeMessage(3, maxFindingsPerInfoType_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (maxFindingsPerItem_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, maxFindingsPerItem_);
      }
      if (maxFindingsPerRequest_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxFindingsPerRequest_);
      }
      for (int i = 0; i < maxFindingsPerInfoType_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, maxFindingsPerInfoType_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.InspectConfig.FindingLimits)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.InspectConfig.FindingLimits other =
          (com.google.privacy.dlp.v2.InspectConfig.FindingLimits) obj;

      if (getMaxFindingsPerItem() != other.getMaxFindingsPerItem()) return false;
      if (getMaxFindingsPerRequest() != other.getMaxFindingsPerRequest()) return false;
      if (!getMaxFindingsPerInfoTypeList().equals(other.getMaxFindingsPerInfoTypeList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MAX_FINDINGS_PER_ITEM_FIELD_NUMBER;
      hash = (53 * hash) + getMaxFindingsPerItem();
      hash = (37 * hash) + MAX_FINDINGS_PER_REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getMaxFindingsPerRequest();
      if (getMaxFindingsPerInfoTypeCount() > 0) {
        hash = (37 * hash) + MAX_FINDINGS_PER_INFO_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getMaxFindingsPerInfoTypeList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.InspectConfig.FindingLimits prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration to control the number of findings returned for inspection.
     * This is not used for de-identification or data profiling.
     * When redacting sensitive data from images, finding limits don't apply. They
     * can cause unexpected or inconsistent results, where only some data is
     * redacted. Don't include finding limits in
     * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
     * requests. Otherwise, Cloud DLP returns an error.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.InspectConfig.FindingLimits}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.InspectConfig.FindingLimits)
        com.google.privacy.dlp.v2.InspectConfig.FindingLimitsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.InspectConfig.FindingLimits.class,
                com.google.privacy.dlp.v2.InspectConfig.FindingLimits.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.InspectConfig.FindingLimits.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        maxFindingsPerItem_ = 0;

        maxFindingsPerRequest_ = 0;

        if (maxFindingsPerInfoTypeBuilder_ == null) {
          maxFindingsPerInfoType_ = java.util.Collections.emptyList();
        } else {
          maxFindingsPerInfoType_ = null;
          maxFindingsPerInfoTypeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_InspectConfig_FindingLimits_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.InspectConfig.FindingLimits getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.InspectConfig.FindingLimits.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.InspectConfig.FindingLimits build() {
        com.google.privacy.dlp.v2.InspectConfig.FindingLimits result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.InspectConfig.FindingLimits buildPartial() {
        com.google.privacy.dlp.v2.InspectConfig.FindingLimits result =
            new com.google.privacy.dlp.v2.InspectConfig.FindingLimits(this);
        int from_bitField0_ = bitField0_;
        result.maxFindingsPerItem_ = maxFindingsPerItem_;
        result.maxFindingsPerRequest_ = maxFindingsPerRequest_;
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            maxFindingsPerInfoType_ =
                java.util.Collections.unmodifiableList(maxFindingsPerInfoType_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.maxFindingsPerInfoType_ = maxFindingsPerInfoType_;
        } else {
          result.maxFindingsPerInfoType_ = maxFindingsPerInfoTypeBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.InspectConfig.FindingLimits) {
          return mergeFrom((com.google.privacy.dlp.v2.InspectConfig.FindingLimits) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.InspectConfig.FindingLimits other) {
        if (other == com.google.privacy.dlp.v2.InspectConfig.FindingLimits.getDefaultInstance())
          return this;
        if (other.getMaxFindingsPerItem() != 0) {
          setMaxFindingsPerItem(other.getMaxFindingsPerItem());
        }
        if (other.getMaxFindingsPerRequest() != 0) {
          setMaxFindingsPerRequest(other.getMaxFindingsPerRequest());
        }
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          if (!other.maxFindingsPerInfoType_.isEmpty()) {
            if (maxFindingsPerInfoType_.isEmpty()) {
              maxFindingsPerInfoType_ = other.maxFindingsPerInfoType_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureMaxFindingsPerInfoTypeIsMutable();
              maxFindingsPerInfoType_.addAll(other.maxFindingsPerInfoType_);
            }
            onChanged();
          }
        } else {
          if (!other.maxFindingsPerInfoType_.isEmpty()) {
            if (maxFindingsPerInfoTypeBuilder_.isEmpty()) {
              maxFindingsPerInfoTypeBuilder_.dispose();
              maxFindingsPerInfoTypeBuilder_ = null;
              maxFindingsPerInfoType_ = other.maxFindingsPerInfoType_;
              bitField0_ = (bitField0_ & ~0x00000001);
              maxFindingsPerInfoTypeBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getMaxFindingsPerInfoTypeFieldBuilder()
                      : null;
            } else {
              maxFindingsPerInfoTypeBuilder_.addAllMessages(other.maxFindingsPerInfoType_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  maxFindingsPerItem_ = input.readInt32();

                  break;
                } // case 8
              case 16:
                {
                  maxFindingsPerRequest_ = input.readInt32();

                  break;
                } // case 16
              case 26:
                {
                  com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit m =
                      input.readMessage(
                          com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
                              .parser(),
                          extensionRegistry);
                  if (maxFindingsPerInfoTypeBuilder_ == null) {
                    ensureMaxFindingsPerInfoTypeIsMutable();
                    maxFindingsPerInfoType_.add(m);
                  } else {
                    maxFindingsPerInfoTypeBuilder_.addMessage(m);
                  }
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int maxFindingsPerItem_;
      /**
       *
       *
       * <pre>
       * Max number of findings that will be returned for each item scanned.
       * When set within `InspectJobConfig`,
       * the maximum returned is 2000 regardless if this is set higher.
       * When set within `InspectContentRequest`, this field is ignored.
       * </pre>
       *
       * <code>int32 max_findings_per_item = 1;</code>
       *
       * @return The maxFindingsPerItem.
       */
      @java.lang.Override
      public int getMaxFindingsPerItem() {
        return maxFindingsPerItem_;
      }
      /**
       *
       *
       * <pre>
       * Max number of findings that will be returned for each item scanned.
       * When set within `InspectJobConfig`,
       * the maximum returned is 2000 regardless if this is set higher.
       * When set within `InspectContentRequest`, this field is ignored.
       * </pre>
       *
       * <code>int32 max_findings_per_item = 1;</code>
       *
       * @param value The maxFindingsPerItem to set.
       * @return This builder for chaining.
       */
      public Builder setMaxFindingsPerItem(int value) {

        maxFindingsPerItem_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Max number of findings that will be returned for each item scanned.
       * When set within `InspectJobConfig`,
       * the maximum returned is 2000 regardless if this is set higher.
       * When set within `InspectContentRequest`, this field is ignored.
       * </pre>
       *
       * <code>int32 max_findings_per_item = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxFindingsPerItem() {

        maxFindingsPerItem_ = 0;
        onChanged();
        return this;
      }

      private int maxFindingsPerRequest_;
      /**
       *
       *
       * <pre>
       * Max number of findings that will be returned per request/job.
       * When set within `InspectContentRequest`, the maximum returned is 2000
       * regardless if this is set higher.
       * </pre>
       *
       * <code>int32 max_findings_per_request = 2;</code>
       *
       * @return The maxFindingsPerRequest.
       */
      @java.lang.Override
      public int getMaxFindingsPerRequest() {
        return maxFindingsPerRequest_;
      }
      /**
       *
       *
       * <pre>
       * Max number of findings that will be returned per request/job.
       * When set within `InspectContentRequest`, the maximum returned is 2000
       * regardless if this is set higher.
       * </pre>
       *
       * <code>int32 max_findings_per_request = 2;</code>
       *
       * @param value The maxFindingsPerRequest to set.
       * @return This builder for chaining.
       */
      public Builder setMaxFindingsPerRequest(int value) {

        maxFindingsPerRequest_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Max number of findings that will be returned per request/job.
       * When set within `InspectContentRequest`, the maximum returned is 2000
       * regardless if this is set higher.
       * </pre>
       *
       * <code>int32 max_findings_per_request = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxFindingsPerRequest() {

        maxFindingsPerRequest_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit>
          maxFindingsPerInfoType_ = java.util.Collections.emptyList();

      private void ensureMaxFindingsPerInfoTypeIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          maxFindingsPerInfoType_ =
              new java.util.ArrayList<
                  com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit>(
                  maxFindingsPerInfoType_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit,
              com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.Builder,
              com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimitOrBuilder>
          maxFindingsPerInfoTypeBuilder_;

      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public java.util.List<com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit>
          getMaxFindingsPerInfoTypeList() {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          return java.util.Collections.unmodifiableList(maxFindingsPerInfoType_);
        } else {
          return maxFindingsPerInfoTypeBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public int getMaxFindingsPerInfoTypeCount() {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          return maxFindingsPerInfoType_.size();
        } else {
          return maxFindingsPerInfoTypeBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
          getMaxFindingsPerInfoType(int index) {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          return maxFindingsPerInfoType_.get(index);
        } else {
          return maxFindingsPerInfoTypeBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public Builder setMaxFindingsPerInfoType(
          int index, com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit value) {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMaxFindingsPerInfoTypeIsMutable();
          maxFindingsPerInfoType_.set(index, value);
          onChanged();
        } else {
          maxFindingsPerInfoTypeBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public Builder setMaxFindingsPerInfoType(
          int index,
          com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.Builder
              builderForValue) {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          ensureMaxFindingsPerInfoTypeIsMutable();
          maxFindingsPerInfoType_.set(index, builderForValue.build());
          onChanged();
        } else {
          maxFindingsPerInfoTypeBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public Builder addMaxFindingsPerInfoType(
          com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit value) {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMaxFindingsPerInfoTypeIsMutable();
          maxFindingsPerInfoType_.add(value);
          onChanged();
        } else {
          maxFindingsPerInfoTypeBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public Builder addMaxFindingsPerInfoType(
          int index, com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit value) {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMaxFindingsPerInfoTypeIsMutable();
          maxFindingsPerInfoType_.add(index, value);
          onChanged();
        } else {
          maxFindingsPerInfoTypeBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public Builder addMaxFindingsPerInfoType(
          com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.Builder
              builderForValue) {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          ensureMaxFindingsPerInfoTypeIsMutable();
          maxFindingsPerInfoType_.add(builderForValue.build());
          onChanged();
        } else {
          maxFindingsPerInfoTypeBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public Builder addMaxFindingsPerInfoType(
          int index,
          com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.Builder
              builderForValue) {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          ensureMaxFindingsPerInfoTypeIsMutable();
          maxFindingsPerInfoType_.add(index, builderForValue.build());
          onChanged();
        } else {
          maxFindingsPerInfoTypeBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public Builder addAllMaxFindingsPerInfoType(
          java.lang.Iterable<
                  ? extends com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit>
              values) {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          ensureMaxFindingsPerInfoTypeIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, maxFindingsPerInfoType_);
          onChanged();
        } else {
          maxFindingsPerInfoTypeBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public Builder clearMaxFindingsPerInfoType() {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          maxFindingsPerInfoType_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          maxFindingsPerInfoTypeBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public Builder removeMaxFindingsPerInfoType(int index) {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          ensureMaxFindingsPerInfoTypeIsMutable();
          maxFindingsPerInfoType_.remove(index);
          onChanged();
        } else {
          maxFindingsPerInfoTypeBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.Builder
          getMaxFindingsPerInfoTypeBuilder(int index) {
        return getMaxFindingsPerInfoTypeFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimitOrBuilder
          getMaxFindingsPerInfoTypeOrBuilder(int index) {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          return maxFindingsPerInfoType_.get(index);
        } else {
          return maxFindingsPerInfoTypeBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimitOrBuilder>
          getMaxFindingsPerInfoTypeOrBuilderList() {
        if (maxFindingsPerInfoTypeBuilder_ != null) {
          return maxFindingsPerInfoTypeBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(maxFindingsPerInfoType_);
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.Builder
          addMaxFindingsPerInfoTypeBuilder() {
        return getMaxFindingsPerInfoTypeFieldBuilder()
            .addBuilder(
                com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.Builder
          addMaxFindingsPerInfoTypeBuilder(int index) {
        return getMaxFindingsPerInfoTypeFieldBuilder()
            .addBuilder(
                index,
                com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Configuration of findings limit given for specified infoTypes.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit max_findings_per_info_type = 3;
       * </code>
       */
      public java.util.List<
              com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.Builder>
          getMaxFindingsPerInfoTypeBuilderList() {
        return getMaxFindingsPerInfoTypeFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit,
              com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.Builder,
              com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimitOrBuilder>
          getMaxFindingsPerInfoTypeFieldBuilder() {
        if (maxFindingsPerInfoTypeBuilder_ == null) {
          maxFindingsPerInfoTypeBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit,
                  com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimit.Builder,
                  com.google.privacy.dlp.v2.InspectConfig.FindingLimits.InfoTypeLimitOrBuilder>(
                  maxFindingsPerInfoType_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          maxFindingsPerInfoType_ = null;
        }
        return maxFindingsPerInfoTypeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.InspectConfig.FindingLimits)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.InspectConfig.FindingLimits)
    private static final com.google.privacy.dlp.v2.InspectConfig.FindingLimits DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.InspectConfig.FindingLimits();
    }

    public static com.google.privacy.dlp.v2.InspectConfig.FindingLimits getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FindingLimits> PARSER =
        new com.google.protobuf.AbstractParser<FindingLimits>() {
          @java.lang.Override
          public FindingLimits parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FindingLimits> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FindingLimits> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectConfig.FindingLimits getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int INFO_TYPES_FIELD_NUMBER = 1;
  private java.util.List<com.google.privacy.dlp.v2.InfoType> infoTypes_;
  /**
   *
   *
   * <pre>
   * Restricts what info_types to look for. The values must correspond to
   * InfoType values returned by ListInfoTypes or listed at
   * https://cloud.google.com/dlp/docs/infotypes-reference.
   * When no InfoTypes or CustomInfoTypes are specified in a request, the
   * system may automatically choose what detectors to run. By default this may
   * be all types, but may change over time as detectors are updated.
   * If you need precise control and predictability as to what detectors are
   * run you should specify specific InfoTypes listed in the reference,
   * otherwise a default list will be used, which may change over time.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.InfoType> getInfoTypesList() {
    return infoTypes_;
  }
  /**
   *
   *
   * <pre>
   * Restricts what info_types to look for. The values must correspond to
   * InfoType values returned by ListInfoTypes or listed at
   * https://cloud.google.com/dlp/docs/infotypes-reference.
   * When no InfoTypes or CustomInfoTypes are specified in a request, the
   * system may automatically choose what detectors to run. By default this may
   * be all types, but may change over time as detectors are updated.
   * If you need precise control and predictability as to what detectors are
   * run you should specify specific InfoTypes listed in the reference,
   * otherwise a default list will be used, which may change over time.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.InfoTypeOrBuilder>
      getInfoTypesOrBuilderList() {
    return infoTypes_;
  }
  /**
   *
   *
   * <pre>
   * Restricts what info_types to look for. The values must correspond to
   * InfoType values returned by ListInfoTypes or listed at
   * https://cloud.google.com/dlp/docs/infotypes-reference.
   * When no InfoTypes or CustomInfoTypes are specified in a request, the
   * system may automatically choose what detectors to run. By default this may
   * be all types, but may change over time as detectors are updated.
   * If you need precise control and predictability as to what detectors are
   * run you should specify specific InfoTypes listed in the reference,
   * otherwise a default list will be used, which may change over time.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
   */
  @java.lang.Override
  public int getInfoTypesCount() {
    return infoTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Restricts what info_types to look for. The values must correspond to
   * InfoType values returned by ListInfoTypes or listed at
   * https://cloud.google.com/dlp/docs/infotypes-reference.
   * When no InfoTypes or CustomInfoTypes are specified in a request, the
   * system may automatically choose what detectors to run. By default this may
   * be all types, but may change over time as detectors are updated.
   * If you need precise control and predictability as to what detectors are
   * run you should specify specific InfoTypes listed in the reference,
   * otherwise a default list will be used, which may change over time.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoType getInfoTypes(int index) {
    return infoTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Restricts what info_types to look for. The values must correspond to
   * InfoType values returned by ListInfoTypes or listed at
   * https://cloud.google.com/dlp/docs/infotypes-reference.
   * When no InfoTypes or CustomInfoTypes are specified in a request, the
   * system may automatically choose what detectors to run. By default this may
   * be all types, but may change over time as detectors are updated.
   * If you need precise control and predictability as to what detectors are
   * run you should specify specific InfoTypes listed in the reference,
   * otherwise a default list will be used, which may change over time.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypesOrBuilder(int index) {
    return infoTypes_.get(index);
  }

  public static final int MIN_LIKELIHOOD_FIELD_NUMBER = 2;
  private int minLikelihood_;
  /**
   *
   *
   * <pre>
   * Only returns findings equal or above this threshold. The default is
   * POSSIBLE.
   * See https://cloud.google.com/dlp/docs/likelihood to learn more.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Likelihood min_likelihood = 2;</code>
   *
   * @return The enum numeric value on the wire for minLikelihood.
   */
  @java.lang.Override
  public int getMinLikelihoodValue() {
    return minLikelihood_;
  }
  /**
   *
   *
   * <pre>
   * Only returns findings equal or above this threshold. The default is
   * POSSIBLE.
   * See https://cloud.google.com/dlp/docs/likelihood to learn more.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Likelihood min_likelihood = 2;</code>
   *
   * @return The minLikelihood.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Likelihood getMinLikelihood() {
    @SuppressWarnings("deprecation")
    com.google.privacy.dlp.v2.Likelihood result =
        com.google.privacy.dlp.v2.Likelihood.valueOf(minLikelihood_);
    return result == null ? com.google.privacy.dlp.v2.Likelihood.UNRECOGNIZED : result;
  }

  public static final int LIMITS_FIELD_NUMBER = 3;
  private com.google.privacy.dlp.v2.InspectConfig.FindingLimits limits_;
  /**
   *
   *
   * <pre>
   * Configuration to control the number of findings returned.
   * This is not used for data profiling.
   * When redacting sensitive data from images, finding limits don't apply. They
   * can cause unexpected or inconsistent results, where only some data is
   * redacted. Don't include finding limits in
   * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
   * requests. Otherwise, Cloud DLP returns an error.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig.FindingLimits limits = 3;</code>
   *
   * @return Whether the limits field is set.
   */
  @java.lang.Override
  public boolean hasLimits() {
    return limits_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration to control the number of findings returned.
   * This is not used for data profiling.
   * When redacting sensitive data from images, finding limits don't apply. They
   * can cause unexpected or inconsistent results, where only some data is
   * redacted. Don't include finding limits in
   * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
   * requests. Otherwise, Cloud DLP returns an error.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig.FindingLimits limits = 3;</code>
   *
   * @return The limits.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectConfig.FindingLimits getLimits() {
    return limits_ == null
        ? com.google.privacy.dlp.v2.InspectConfig.FindingLimits.getDefaultInstance()
        : limits_;
  }
  /**
   *
   *
   * <pre>
   * Configuration to control the number of findings returned.
   * This is not used for data profiling.
   * When redacting sensitive data from images, finding limits don't apply. They
   * can cause unexpected or inconsistent results, where only some data is
   * redacted. Don't include finding limits in
   * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
   * requests. Otherwise, Cloud DLP returns an error.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig.FindingLimits limits = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectConfig.FindingLimitsOrBuilder getLimitsOrBuilder() {
    return getLimits();
  }

  public static final int INCLUDE_QUOTE_FIELD_NUMBER = 4;
  private boolean includeQuote_;
  /**
   *
   *
   * <pre>
   * When true, a contextual quote from the data that triggered a finding is
   * included in the response; see [Finding.quote][google.privacy.dlp.v2.Finding.quote].
   * This is not used for data profiling.
   * </pre>
   *
   * <code>bool include_quote = 4;</code>
   *
   * @return The includeQuote.
   */
  @java.lang.Override
  public boolean getIncludeQuote() {
    return includeQuote_;
  }

  public static final int EXCLUDE_INFO_TYPES_FIELD_NUMBER = 5;
  private boolean excludeInfoTypes_;
  /**
   *
   *
   * <pre>
   * When true, excludes type information of the findings.
   * This is not used for data profiling.
   * </pre>
   *
   * <code>bool exclude_info_types = 5;</code>
   *
   * @return The excludeInfoTypes.
   */
  @java.lang.Override
  public boolean getExcludeInfoTypes() {
    return excludeInfoTypes_;
  }

  public static final int CUSTOM_INFO_TYPES_FIELD_NUMBER = 6;
  private java.util.List<com.google.privacy.dlp.v2.CustomInfoType> customInfoTypes_;
  /**
   *
   *
   * <pre>
   * CustomInfoTypes provided by the user. See
   * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.CustomInfoType> getCustomInfoTypesList() {
    return customInfoTypes_;
  }
  /**
   *
   *
   * <pre>
   * CustomInfoTypes provided by the user. See
   * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.CustomInfoTypeOrBuilder>
      getCustomInfoTypesOrBuilderList() {
    return customInfoTypes_;
  }
  /**
   *
   *
   * <pre>
   * CustomInfoTypes provided by the user. See
   * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
   */
  @java.lang.Override
  public int getCustomInfoTypesCount() {
    return customInfoTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * CustomInfoTypes provided by the user. See
   * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType getCustomInfoTypes(int index) {
    return customInfoTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * CustomInfoTypes provided by the user. See
   * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoTypeOrBuilder getCustomInfoTypesOrBuilder(int index) {
    return customInfoTypes_.get(index);
  }

  public static final int CONTENT_OPTIONS_FIELD_NUMBER = 8;
  private java.util.List<java.lang.Integer> contentOptions_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.privacy.dlp.v2.ContentOption>
      contentOptions_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.privacy.dlp.v2.ContentOption>() {
            public com.google.privacy.dlp.v2.ContentOption convert(java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.privacy.dlp.v2.ContentOption result =
                  com.google.privacy.dlp.v2.ContentOption.valueOf(from);
              return result == null ? com.google.privacy.dlp.v2.ContentOption.UNRECOGNIZED : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Deprecated and unused.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
   *
   * @return A list containing the contentOptions.
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.ContentOption> getContentOptionsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.privacy.dlp.v2.ContentOption>(
        contentOptions_, contentOptions_converter_);
  }
  /**
   *
   *
   * <pre>
   * Deprecated and unused.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
   *
   * @return The count of contentOptions.
   */
  @java.lang.Override
  public int getContentOptionsCount() {
    return contentOptions_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated and unused.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The contentOptions at the given index.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ContentOption getContentOptions(int index) {
    return contentOptions_converter_.convert(contentOptions_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Deprecated and unused.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
   *
   * @return A list containing the enum numeric values on the wire for contentOptions.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getContentOptionsValueList() {
    return contentOptions_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated and unused.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of contentOptions at the given index.
   */
  @java.lang.Override
  public int getContentOptionsValue(int index) {
    return contentOptions_.get(index);
  }

  private int contentOptionsMemoizedSerializedSize;

  public static final int RULE_SET_FIELD_NUMBER = 10;
  private java.util.List<com.google.privacy.dlp.v2.InspectionRuleSet> ruleSet_;
  /**
   *
   *
   * <pre>
   * Set of rules to apply to the findings for this InspectConfig.
   * Exclusion rules, contained in the set are executed in the end, other
   * rules are executed in the order they are specified for each info type.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.InspectionRuleSet> getRuleSetList() {
    return ruleSet_;
  }
  /**
   *
   *
   * <pre>
   * Set of rules to apply to the findings for this InspectConfig.
   * Exclusion rules, contained in the set are executed in the end, other
   * rules are executed in the order they are specified for each info type.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.InspectionRuleSetOrBuilder>
      getRuleSetOrBuilderList() {
    return ruleSet_;
  }
  /**
   *
   *
   * <pre>
   * Set of rules to apply to the findings for this InspectConfig.
   * Exclusion rules, contained in the set are executed in the end, other
   * rules are executed in the order they are specified for each info type.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
   */
  @java.lang.Override
  public int getRuleSetCount() {
    return ruleSet_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of rules to apply to the findings for this InspectConfig.
   * Exclusion rules, contained in the set are executed in the end, other
   * rules are executed in the order they are specified for each info type.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectionRuleSet getRuleSet(int index) {
    return ruleSet_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set of rules to apply to the findings for this InspectConfig.
   * Exclusion rules, contained in the set are executed in the end, other
   * rules are executed in the order they are specified for each info type.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectionRuleSetOrBuilder getRuleSetOrBuilder(int index) {
    return ruleSet_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    for (int i = 0; i < infoTypes_.size(); i++) {
      output.writeMessage(1, infoTypes_.get(i));
    }
    if (minLikelihood_ != com.google.privacy.dlp.v2.Likelihood.LIKELIHOOD_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, minLikelihood_);
    }
    if (limits_ != null) {
      output.writeMessage(3, getLimits());
    }
    if (includeQuote_ != false) {
      output.writeBool(4, includeQuote_);
    }
    if (excludeInfoTypes_ != false) {
      output.writeBool(5, excludeInfoTypes_);
    }
    for (int i = 0; i < customInfoTypes_.size(); i++) {
      output.writeMessage(6, customInfoTypes_.get(i));
    }
    if (getContentOptionsList().size() > 0) {
      output.writeUInt32NoTag(66);
      output.writeUInt32NoTag(contentOptionsMemoizedSerializedSize);
    }
    for (int i = 0; i < contentOptions_.size(); i++) {
      output.writeEnumNoTag(contentOptions_.get(i));
    }
    for (int i = 0; i < ruleSet_.size(); i++) {
      output.writeMessage(10, ruleSet_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < infoTypes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, infoTypes_.get(i));
    }
    if (minLikelihood_ != com.google.privacy.dlp.v2.Likelihood.LIKELIHOOD_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, minLikelihood_);
    }
    if (limits_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getLimits());
    }
    if (includeQuote_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, includeQuote_);
    }
    if (excludeInfoTypes_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, excludeInfoTypes_);
    }
    for (int i = 0; i < customInfoTypes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, customInfoTypes_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < contentOptions_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(contentOptions_.get(i));
      }
      size += dataSize;
      if (!getContentOptionsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      contentOptionsMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < ruleSet_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, ruleSet_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.InspectConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.InspectConfig other = (com.google.privacy.dlp.v2.InspectConfig) obj;

    if (!getInfoTypesList().equals(other.getInfoTypesList())) return false;
    if (minLikelihood_ != other.minLikelihood_) return false;
    if (hasLimits() != other.hasLimits()) return false;
    if (hasLimits()) {
      if (!getLimits().equals(other.getLimits())) return false;
    }
    if (getIncludeQuote() != other.getIncludeQuote()) return false;
    if (getExcludeInfoTypes() != other.getExcludeInfoTypes()) return false;
    if (!getCustomInfoTypesList().equals(other.getCustomInfoTypesList())) return false;
    if (!contentOptions_.equals(other.contentOptions_)) return false;
    if (!getRuleSetList().equals(other.getRuleSetList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getInfoTypesCount() > 0) {
      hash = (37 * hash) + INFO_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getInfoTypesList().hashCode();
    }
    hash = (37 * hash) + MIN_LIKELIHOOD_FIELD_NUMBER;
    hash = (53 * hash) + minLikelihood_;
    if (hasLimits()) {
      hash = (37 * hash) + LIMITS_FIELD_NUMBER;
      hash = (53 * hash) + getLimits().hashCode();
    }
    hash = (37 * hash) + INCLUDE_QUOTE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeQuote());
    hash = (37 * hash) + EXCLUDE_INFO_TYPES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getExcludeInfoTypes());
    if (getCustomInfoTypesCount() > 0) {
      hash = (37 * hash) + CUSTOM_INFO_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getCustomInfoTypesList().hashCode();
    }
    if (getContentOptionsCount() > 0) {
      hash = (37 * hash) + CONTENT_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + contentOptions_.hashCode();
    }
    if (getRuleSetCount() > 0) {
      hash = (37 * hash) + RULE_SET_FIELD_NUMBER;
      hash = (53 * hash) + getRuleSetList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.InspectConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InspectConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InspectConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.InspectConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InspectConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InspectConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.InspectConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.InspectConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.InspectConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration description of the scanning process.
   * When used with redactContent only info_types and min_likelihood are currently
   * used.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.InspectConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.InspectConfig)
      com.google.privacy.dlp.v2.InspectConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InspectConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InspectConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.InspectConfig.class,
              com.google.privacy.dlp.v2.InspectConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.InspectConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (infoTypesBuilder_ == null) {
        infoTypes_ = java.util.Collections.emptyList();
      } else {
        infoTypes_ = null;
        infoTypesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      minLikelihood_ = 0;

      if (limitsBuilder_ == null) {
        limits_ = null;
      } else {
        limits_ = null;
        limitsBuilder_ = null;
      }
      includeQuote_ = false;

      excludeInfoTypes_ = false;

      if (customInfoTypesBuilder_ == null) {
        customInfoTypes_ = java.util.Collections.emptyList();
      } else {
        customInfoTypes_ = null;
        customInfoTypesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      contentOptions_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      if (ruleSetBuilder_ == null) {
        ruleSet_ = java.util.Collections.emptyList();
      } else {
        ruleSet_ = null;
        ruleSetBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_InspectConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectConfig build() {
      com.google.privacy.dlp.v2.InspectConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.InspectConfig buildPartial() {
      com.google.privacy.dlp.v2.InspectConfig result =
          new com.google.privacy.dlp.v2.InspectConfig(this);
      int from_bitField0_ = bitField0_;
      if (infoTypesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          infoTypes_ = java.util.Collections.unmodifiableList(infoTypes_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.infoTypes_ = infoTypes_;
      } else {
        result.infoTypes_ = infoTypesBuilder_.build();
      }
      result.minLikelihood_ = minLikelihood_;
      if (limitsBuilder_ == null) {
        result.limits_ = limits_;
      } else {
        result.limits_ = limitsBuilder_.build();
      }
      result.includeQuote_ = includeQuote_;
      result.excludeInfoTypes_ = excludeInfoTypes_;
      if (customInfoTypesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          customInfoTypes_ = java.util.Collections.unmodifiableList(customInfoTypes_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.customInfoTypes_ = customInfoTypes_;
      } else {
        result.customInfoTypes_ = customInfoTypesBuilder_.build();
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        contentOptions_ = java.util.Collections.unmodifiableList(contentOptions_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.contentOptions_ = contentOptions_;
      if (ruleSetBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          ruleSet_ = java.util.Collections.unmodifiableList(ruleSet_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.ruleSet_ = ruleSet_;
      } else {
        result.ruleSet_ = ruleSetBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.InspectConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.InspectConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.InspectConfig other) {
      if (other == com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()) return this;
      if (infoTypesBuilder_ == null) {
        if (!other.infoTypes_.isEmpty()) {
          if (infoTypes_.isEmpty()) {
            infoTypes_ = other.infoTypes_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureInfoTypesIsMutable();
            infoTypes_.addAll(other.infoTypes_);
          }
          onChanged();
        }
      } else {
        if (!other.infoTypes_.isEmpty()) {
          if (infoTypesBuilder_.isEmpty()) {
            infoTypesBuilder_.dispose();
            infoTypesBuilder_ = null;
            infoTypes_ = other.infoTypes_;
            bitField0_ = (bitField0_ & ~0x00000001);
            infoTypesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInfoTypesFieldBuilder()
                    : null;
          } else {
            infoTypesBuilder_.addAllMessages(other.infoTypes_);
          }
        }
      }
      if (other.minLikelihood_ != 0) {
        setMinLikelihoodValue(other.getMinLikelihoodValue());
      }
      if (other.hasLimits()) {
        mergeLimits(other.getLimits());
      }
      if (other.getIncludeQuote() != false) {
        setIncludeQuote(other.getIncludeQuote());
      }
      if (other.getExcludeInfoTypes() != false) {
        setExcludeInfoTypes(other.getExcludeInfoTypes());
      }
      if (customInfoTypesBuilder_ == null) {
        if (!other.customInfoTypes_.isEmpty()) {
          if (customInfoTypes_.isEmpty()) {
            customInfoTypes_ = other.customInfoTypes_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureCustomInfoTypesIsMutable();
            customInfoTypes_.addAll(other.customInfoTypes_);
          }
          onChanged();
        }
      } else {
        if (!other.customInfoTypes_.isEmpty()) {
          if (customInfoTypesBuilder_.isEmpty()) {
            customInfoTypesBuilder_.dispose();
            customInfoTypesBuilder_ = null;
            customInfoTypes_ = other.customInfoTypes_;
            bitField0_ = (bitField0_ & ~0x00000002);
            customInfoTypesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCustomInfoTypesFieldBuilder()
                    : null;
          } else {
            customInfoTypesBuilder_.addAllMessages(other.customInfoTypes_);
          }
        }
      }
      if (!other.contentOptions_.isEmpty()) {
        if (contentOptions_.isEmpty()) {
          contentOptions_ = other.contentOptions_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureContentOptionsIsMutable();
          contentOptions_.addAll(other.contentOptions_);
        }
        onChanged();
      }
      if (ruleSetBuilder_ == null) {
        if (!other.ruleSet_.isEmpty()) {
          if (ruleSet_.isEmpty()) {
            ruleSet_ = other.ruleSet_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureRuleSetIsMutable();
            ruleSet_.addAll(other.ruleSet_);
          }
          onChanged();
        }
      } else {
        if (!other.ruleSet_.isEmpty()) {
          if (ruleSetBuilder_.isEmpty()) {
            ruleSetBuilder_.dispose();
            ruleSetBuilder_ = null;
            ruleSet_ = other.ruleSet_;
            bitField0_ = (bitField0_ & ~0x00000008);
            ruleSetBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRuleSetFieldBuilder()
                    : null;
          } else {
            ruleSetBuilder_.addAllMessages(other.ruleSet_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.privacy.dlp.v2.InfoType m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.InfoType.parser(), extensionRegistry);
                if (infoTypesBuilder_ == null) {
                  ensureInfoTypesIsMutable();
                  infoTypes_.add(m);
                } else {
                  infoTypesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 16:
              {
                minLikelihood_ = input.readEnum();

                break;
              } // case 16
            case 26:
              {
                input.readMessage(getLimitsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 32:
              {
                includeQuote_ = input.readBool();

                break;
              } // case 32
            case 40:
              {
                excludeInfoTypes_ = input.readBool();

                break;
              } // case 40
            case 50:
              {
                com.google.privacy.dlp.v2.CustomInfoType m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.CustomInfoType.parser(), extensionRegistry);
                if (customInfoTypesBuilder_ == null) {
                  ensureCustomInfoTypesIsMutable();
                  customInfoTypes_.add(m);
                } else {
                  customInfoTypesBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 64:
              {
                int tmpRaw = input.readEnum();
                ensureContentOptionsIsMutable();
                contentOptions_.add(tmpRaw);
                break;
              } // case 64
            case 66:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureContentOptionsIsMutable();
                  contentOptions_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 66
            case 82:
              {
                com.google.privacy.dlp.v2.InspectionRuleSet m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.InspectionRuleSet.parser(), extensionRegistry);
                if (ruleSetBuilder_ == null) {
                  ensureRuleSetIsMutable();
                  ruleSet_.add(m);
                } else {
                  ruleSetBuilder_.addMessage(m);
                }
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.privacy.dlp.v2.InfoType> infoTypes_ =
        java.util.Collections.emptyList();

    private void ensureInfoTypesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        infoTypes_ = new java.util.ArrayList<com.google.privacy.dlp.v2.InfoType>(infoTypes_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        infoTypesBuilder_;

    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.InfoType> getInfoTypesList() {
      if (infoTypesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(infoTypes_);
      } else {
        return infoTypesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public int getInfoTypesCount() {
      if (infoTypesBuilder_ == null) {
        return infoTypes_.size();
      } else {
        return infoTypesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public com.google.privacy.dlp.v2.InfoType getInfoTypes(int index) {
      if (infoTypesBuilder_ == null) {
        return infoTypes_.get(index);
      } else {
        return infoTypesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public Builder setInfoTypes(int index, com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInfoTypesIsMutable();
        infoTypes_.set(index, value);
        onChanged();
      } else {
        infoTypesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public Builder setInfoTypes(
        int index, com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
      if (infoTypesBuilder_ == null) {
        ensureInfoTypesIsMutable();
        infoTypes_.set(index, builderForValue.build());
        onChanged();
      } else {
        infoTypesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public Builder addInfoTypes(com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInfoTypesIsMutable();
        infoTypes_.add(value);
        onChanged();
      } else {
        infoTypesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public Builder addInfoTypes(int index, com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInfoTypesIsMutable();
        infoTypes_.add(index, value);
        onChanged();
      } else {
        infoTypesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public Builder addInfoTypes(com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
      if (infoTypesBuilder_ == null) {
        ensureInfoTypesIsMutable();
        infoTypes_.add(builderForValue.build());
        onChanged();
      } else {
        infoTypesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public Builder addInfoTypes(
        int index, com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
      if (infoTypesBuilder_ == null) {
        ensureInfoTypesIsMutable();
        infoTypes_.add(index, builderForValue.build());
        onChanged();
      } else {
        infoTypesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public Builder addAllInfoTypes(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.InfoType> values) {
      if (infoTypesBuilder_ == null) {
        ensureInfoTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, infoTypes_);
        onChanged();
      } else {
        infoTypesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public Builder clearInfoTypes() {
      if (infoTypesBuilder_ == null) {
        infoTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        infoTypesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public Builder removeInfoTypes(int index) {
      if (infoTypesBuilder_ == null) {
        ensureInfoTypesIsMutable();
        infoTypes_.remove(index);
        onChanged();
      } else {
        infoTypesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public com.google.privacy.dlp.v2.InfoType.Builder getInfoTypesBuilder(int index) {
      return getInfoTypesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypesOrBuilder(int index) {
      if (infoTypesBuilder_ == null) {
        return infoTypes_.get(index);
      } else {
        return infoTypesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        getInfoTypesOrBuilderList() {
      if (infoTypesBuilder_ != null) {
        return infoTypesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(infoTypes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public com.google.privacy.dlp.v2.InfoType.Builder addInfoTypesBuilder() {
      return getInfoTypesFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.InfoType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public com.google.privacy.dlp.v2.InfoType.Builder addInfoTypesBuilder(int index) {
      return getInfoTypesFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.InfoType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Restricts what info_types to look for. The values must correspond to
     * InfoType values returned by ListInfoTypes or listed at
     * https://cloud.google.com/dlp/docs/infotypes-reference.
     * When no InfoTypes or CustomInfoTypes are specified in a request, the
     * system may automatically choose what detectors to run. By default this may
     * be all types, but may change over time as detectors are updated.
     * If you need precise control and predictability as to what detectors are
     * run you should specify specific InfoTypes listed in the reference,
     * otherwise a default list will be used, which may change over time.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InfoType info_types = 1;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.InfoType.Builder> getInfoTypesBuilderList() {
      return getInfoTypesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        getInfoTypesFieldBuilder() {
      if (infoTypesBuilder_ == null) {
        infoTypesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoType,
                com.google.privacy.dlp.v2.InfoType.Builder,
                com.google.privacy.dlp.v2.InfoTypeOrBuilder>(
                infoTypes_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        infoTypes_ = null;
      }
      return infoTypesBuilder_;
    }

    private int minLikelihood_ = 0;
    /**
     *
     *
     * <pre>
     * Only returns findings equal or above this threshold. The default is
     * POSSIBLE.
     * See https://cloud.google.com/dlp/docs/likelihood to learn more.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood min_likelihood = 2;</code>
     *
     * @return The enum numeric value on the wire for minLikelihood.
     */
    @java.lang.Override
    public int getMinLikelihoodValue() {
      return minLikelihood_;
    }
    /**
     *
     *
     * <pre>
     * Only returns findings equal or above this threshold. The default is
     * POSSIBLE.
     * See https://cloud.google.com/dlp/docs/likelihood to learn more.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood min_likelihood = 2;</code>
     *
     * @param value The enum numeric value on the wire for minLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setMinLikelihoodValue(int value) {

      minLikelihood_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only returns findings equal or above this threshold. The default is
     * POSSIBLE.
     * See https://cloud.google.com/dlp/docs/likelihood to learn more.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood min_likelihood = 2;</code>
     *
     * @return The minLikelihood.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Likelihood getMinLikelihood() {
      @SuppressWarnings("deprecation")
      com.google.privacy.dlp.v2.Likelihood result =
          com.google.privacy.dlp.v2.Likelihood.valueOf(minLikelihood_);
      return result == null ? com.google.privacy.dlp.v2.Likelihood.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Only returns findings equal or above this threshold. The default is
     * POSSIBLE.
     * See https://cloud.google.com/dlp/docs/likelihood to learn more.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood min_likelihood = 2;</code>
     *
     * @param value The minLikelihood to set.
     * @return This builder for chaining.
     */
    public Builder setMinLikelihood(com.google.privacy.dlp.v2.Likelihood value) {
      if (value == null) {
        throw new NullPointerException();
      }

      minLikelihood_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only returns findings equal or above this threshold. The default is
     * POSSIBLE.
     * See https://cloud.google.com/dlp/docs/likelihood to learn more.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood min_likelihood = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinLikelihood() {

      minLikelihood_ = 0;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.InspectConfig.FindingLimits limits_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectConfig.FindingLimits,
            com.google.privacy.dlp.v2.InspectConfig.FindingLimits.Builder,
            com.google.privacy.dlp.v2.InspectConfig.FindingLimitsOrBuilder>
        limitsBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration to control the number of findings returned.
     * This is not used for data profiling.
     * When redacting sensitive data from images, finding limits don't apply. They
     * can cause unexpected or inconsistent results, where only some data is
     * redacted. Don't include finding limits in
     * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
     * requests. Otherwise, Cloud DLP returns an error.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig.FindingLimits limits = 3;</code>
     *
     * @return Whether the limits field is set.
     */
    public boolean hasLimits() {
      return limitsBuilder_ != null || limits_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration to control the number of findings returned.
     * This is not used for data profiling.
     * When redacting sensitive data from images, finding limits don't apply. They
     * can cause unexpected or inconsistent results, where only some data is
     * redacted. Don't include finding limits in
     * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
     * requests. Otherwise, Cloud DLP returns an error.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig.FindingLimits limits = 3;</code>
     *
     * @return The limits.
     */
    public com.google.privacy.dlp.v2.InspectConfig.FindingLimits getLimits() {
      if (limitsBuilder_ == null) {
        return limits_ == null
            ? com.google.privacy.dlp.v2.InspectConfig.FindingLimits.getDefaultInstance()
            : limits_;
      } else {
        return limitsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration to control the number of findings returned.
     * This is not used for data profiling.
     * When redacting sensitive data from images, finding limits don't apply. They
     * can cause unexpected or inconsistent results, where only some data is
     * redacted. Don't include finding limits in
     * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
     * requests. Otherwise, Cloud DLP returns an error.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig.FindingLimits limits = 3;</code>
     */
    public Builder setLimits(com.google.privacy.dlp.v2.InspectConfig.FindingLimits value) {
      if (limitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        limits_ = value;
        onChanged();
      } else {
        limitsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to control the number of findings returned.
     * This is not used for data profiling.
     * When redacting sensitive data from images, finding limits don't apply. They
     * can cause unexpected or inconsistent results, where only some data is
     * redacted. Don't include finding limits in
     * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
     * requests. Otherwise, Cloud DLP returns an error.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig.FindingLimits limits = 3;</code>
     */
    public Builder setLimits(
        com.google.privacy.dlp.v2.InspectConfig.FindingLimits.Builder builderForValue) {
      if (limitsBuilder_ == null) {
        limits_ = builderForValue.build();
        onChanged();
      } else {
        limitsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to control the number of findings returned.
     * This is not used for data profiling.
     * When redacting sensitive data from images, finding limits don't apply. They
     * can cause unexpected or inconsistent results, where only some data is
     * redacted. Don't include finding limits in
     * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
     * requests. Otherwise, Cloud DLP returns an error.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig.FindingLimits limits = 3;</code>
     */
    public Builder mergeLimits(com.google.privacy.dlp.v2.InspectConfig.FindingLimits value) {
      if (limitsBuilder_ == null) {
        if (limits_ != null) {
          limits_ =
              com.google.privacy.dlp.v2.InspectConfig.FindingLimits.newBuilder(limits_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          limits_ = value;
        }
        onChanged();
      } else {
        limitsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to control the number of findings returned.
     * This is not used for data profiling.
     * When redacting sensitive data from images, finding limits don't apply. They
     * can cause unexpected or inconsistent results, where only some data is
     * redacted. Don't include finding limits in
     * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
     * requests. Otherwise, Cloud DLP returns an error.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig.FindingLimits limits = 3;</code>
     */
    public Builder clearLimits() {
      if (limitsBuilder_ == null) {
        limits_ = null;
        onChanged();
      } else {
        limits_ = null;
        limitsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration to control the number of findings returned.
     * This is not used for data profiling.
     * When redacting sensitive data from images, finding limits don't apply. They
     * can cause unexpected or inconsistent results, where only some data is
     * redacted. Don't include finding limits in
     * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
     * requests. Otherwise, Cloud DLP returns an error.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig.FindingLimits limits = 3;</code>
     */
    public com.google.privacy.dlp.v2.InspectConfig.FindingLimits.Builder getLimitsBuilder() {

      onChanged();
      return getLimitsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration to control the number of findings returned.
     * This is not used for data profiling.
     * When redacting sensitive data from images, finding limits don't apply. They
     * can cause unexpected or inconsistent results, where only some data is
     * redacted. Don't include finding limits in
     * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
     * requests. Otherwise, Cloud DLP returns an error.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig.FindingLimits limits = 3;</code>
     */
    public com.google.privacy.dlp.v2.InspectConfig.FindingLimitsOrBuilder getLimitsOrBuilder() {
      if (limitsBuilder_ != null) {
        return limitsBuilder_.getMessageOrBuilder();
      } else {
        return limits_ == null
            ? com.google.privacy.dlp.v2.InspectConfig.FindingLimits.getDefaultInstance()
            : limits_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration to control the number of findings returned.
     * This is not used for data profiling.
     * When redacting sensitive data from images, finding limits don't apply. They
     * can cause unexpected or inconsistent results, where only some data is
     * redacted. Don't include finding limits in
     * [RedactImage][google.privacy.dlp.v2.DlpService.RedactImage]
     * requests. Otherwise, Cloud DLP returns an error.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig.FindingLimits limits = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectConfig.FindingLimits,
            com.google.privacy.dlp.v2.InspectConfig.FindingLimits.Builder,
            com.google.privacy.dlp.v2.InspectConfig.FindingLimitsOrBuilder>
        getLimitsFieldBuilder() {
      if (limitsBuilder_ == null) {
        limitsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InspectConfig.FindingLimits,
                com.google.privacy.dlp.v2.InspectConfig.FindingLimits.Builder,
                com.google.privacy.dlp.v2.InspectConfig.FindingLimitsOrBuilder>(
                getLimits(), getParentForChildren(), isClean());
        limits_ = null;
      }
      return limitsBuilder_;
    }

    private boolean includeQuote_;
    /**
     *
     *
     * <pre>
     * When true, a contextual quote from the data that triggered a finding is
     * included in the response; see [Finding.quote][google.privacy.dlp.v2.Finding.quote].
     * This is not used for data profiling.
     * </pre>
     *
     * <code>bool include_quote = 4;</code>
     *
     * @return The includeQuote.
     */
    @java.lang.Override
    public boolean getIncludeQuote() {
      return includeQuote_;
    }
    /**
     *
     *
     * <pre>
     * When true, a contextual quote from the data that triggered a finding is
     * included in the response; see [Finding.quote][google.privacy.dlp.v2.Finding.quote].
     * This is not used for data profiling.
     * </pre>
     *
     * <code>bool include_quote = 4;</code>
     *
     * @param value The includeQuote to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeQuote(boolean value) {

      includeQuote_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When true, a contextual quote from the data that triggered a finding is
     * included in the response; see [Finding.quote][google.privacy.dlp.v2.Finding.quote].
     * This is not used for data profiling.
     * </pre>
     *
     * <code>bool include_quote = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeQuote() {

      includeQuote_ = false;
      onChanged();
      return this;
    }

    private boolean excludeInfoTypes_;
    /**
     *
     *
     * <pre>
     * When true, excludes type information of the findings.
     * This is not used for data profiling.
     * </pre>
     *
     * <code>bool exclude_info_types = 5;</code>
     *
     * @return The excludeInfoTypes.
     */
    @java.lang.Override
    public boolean getExcludeInfoTypes() {
      return excludeInfoTypes_;
    }
    /**
     *
     *
     * <pre>
     * When true, excludes type information of the findings.
     * This is not used for data profiling.
     * </pre>
     *
     * <code>bool exclude_info_types = 5;</code>
     *
     * @param value The excludeInfoTypes to set.
     * @return This builder for chaining.
     */
    public Builder setExcludeInfoTypes(boolean value) {

      excludeInfoTypes_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When true, excludes type information of the findings.
     * This is not used for data profiling.
     * </pre>
     *
     * <code>bool exclude_info_types = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExcludeInfoTypes() {

      excludeInfoTypes_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.privacy.dlp.v2.CustomInfoType> customInfoTypes_ =
        java.util.Collections.emptyList();

    private void ensureCustomInfoTypesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        customInfoTypes_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.CustomInfoType>(customInfoTypes_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType,
            com.google.privacy.dlp.v2.CustomInfoType.Builder,
            com.google.privacy.dlp.v2.CustomInfoTypeOrBuilder>
        customInfoTypesBuilder_;

    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.CustomInfoType> getCustomInfoTypesList() {
      if (customInfoTypesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(customInfoTypes_);
      } else {
        return customInfoTypesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public int getCustomInfoTypesCount() {
      if (customInfoTypesBuilder_ == null) {
        return customInfoTypes_.size();
      } else {
        return customInfoTypesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType getCustomInfoTypes(int index) {
      if (customInfoTypesBuilder_ == null) {
        return customInfoTypes_.get(index);
      } else {
        return customInfoTypesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public Builder setCustomInfoTypes(int index, com.google.privacy.dlp.v2.CustomInfoType value) {
      if (customInfoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomInfoTypesIsMutable();
        customInfoTypes_.set(index, value);
        onChanged();
      } else {
        customInfoTypesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public Builder setCustomInfoTypes(
        int index, com.google.privacy.dlp.v2.CustomInfoType.Builder builderForValue) {
      if (customInfoTypesBuilder_ == null) {
        ensureCustomInfoTypesIsMutable();
        customInfoTypes_.set(index, builderForValue.build());
        onChanged();
      } else {
        customInfoTypesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public Builder addCustomInfoTypes(com.google.privacy.dlp.v2.CustomInfoType value) {
      if (customInfoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomInfoTypesIsMutable();
        customInfoTypes_.add(value);
        onChanged();
      } else {
        customInfoTypesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public Builder addCustomInfoTypes(int index, com.google.privacy.dlp.v2.CustomInfoType value) {
      if (customInfoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomInfoTypesIsMutable();
        customInfoTypes_.add(index, value);
        onChanged();
      } else {
        customInfoTypesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public Builder addCustomInfoTypes(
        com.google.privacy.dlp.v2.CustomInfoType.Builder builderForValue) {
      if (customInfoTypesBuilder_ == null) {
        ensureCustomInfoTypesIsMutable();
        customInfoTypes_.add(builderForValue.build());
        onChanged();
      } else {
        customInfoTypesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public Builder addCustomInfoTypes(
        int index, com.google.privacy.dlp.v2.CustomInfoType.Builder builderForValue) {
      if (customInfoTypesBuilder_ == null) {
        ensureCustomInfoTypesIsMutable();
        customInfoTypes_.add(index, builderForValue.build());
        onChanged();
      } else {
        customInfoTypesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public Builder addAllCustomInfoTypes(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.CustomInfoType> values) {
      if (customInfoTypesBuilder_ == null) {
        ensureCustomInfoTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, customInfoTypes_);
        onChanged();
      } else {
        customInfoTypesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public Builder clearCustomInfoTypes() {
      if (customInfoTypesBuilder_ == null) {
        customInfoTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        customInfoTypesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public Builder removeCustomInfoTypes(int index) {
      if (customInfoTypesBuilder_ == null) {
        ensureCustomInfoTypesIsMutable();
        customInfoTypes_.remove(index);
        onChanged();
      } else {
        customInfoTypesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.Builder getCustomInfoTypesBuilder(int index) {
      return getCustomInfoTypesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public com.google.privacy.dlp.v2.CustomInfoTypeOrBuilder getCustomInfoTypesOrBuilder(
        int index) {
      if (customInfoTypesBuilder_ == null) {
        return customInfoTypes_.get(index);
      } else {
        return customInfoTypesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.CustomInfoTypeOrBuilder>
        getCustomInfoTypesOrBuilderList() {
      if (customInfoTypesBuilder_ != null) {
        return customInfoTypesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(customInfoTypes_);
      }
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.Builder addCustomInfoTypesBuilder() {
      return getCustomInfoTypesFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.CustomInfoType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.Builder addCustomInfoTypesBuilder(int index) {
      return getCustomInfoTypesFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.CustomInfoType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * CustomInfoTypes provided by the user. See
     * https://cloud.google.com/dlp/docs/creating-custom-infotypes to learn more.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CustomInfoType custom_info_types = 6;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.CustomInfoType.Builder>
        getCustomInfoTypesBuilderList() {
      return getCustomInfoTypesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType,
            com.google.privacy.dlp.v2.CustomInfoType.Builder,
            com.google.privacy.dlp.v2.CustomInfoTypeOrBuilder>
        getCustomInfoTypesFieldBuilder() {
      if (customInfoTypesBuilder_ == null) {
        customInfoTypesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType,
                com.google.privacy.dlp.v2.CustomInfoType.Builder,
                com.google.privacy.dlp.v2.CustomInfoTypeOrBuilder>(
                customInfoTypes_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        customInfoTypes_ = null;
      }
      return customInfoTypesBuilder_;
    }

    private java.util.List<java.lang.Integer> contentOptions_ = java.util.Collections.emptyList();

    private void ensureContentOptionsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        contentOptions_ = new java.util.ArrayList<java.lang.Integer>(contentOptions_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated and unused.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
     *
     * @return A list containing the contentOptions.
     */
    public java.util.List<com.google.privacy.dlp.v2.ContentOption> getContentOptionsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.privacy.dlp.v2.ContentOption>(
          contentOptions_, contentOptions_converter_);
    }
    /**
     *
     *
     * <pre>
     * Deprecated and unused.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
     *
     * @return The count of contentOptions.
     */
    public int getContentOptionsCount() {
      return contentOptions_.size();
    }
    /**
     *
     *
     * <pre>
     * Deprecated and unused.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The contentOptions at the given index.
     */
    public com.google.privacy.dlp.v2.ContentOption getContentOptions(int index) {
      return contentOptions_converter_.convert(contentOptions_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Deprecated and unused.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The contentOptions to set.
     * @return This builder for chaining.
     */
    public Builder setContentOptions(int index, com.google.privacy.dlp.v2.ContentOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureContentOptionsIsMutable();
      contentOptions_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated and unused.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
     *
     * @param value The contentOptions to add.
     * @return This builder for chaining.
     */
    public Builder addContentOptions(com.google.privacy.dlp.v2.ContentOption value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureContentOptionsIsMutable();
      contentOptions_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated and unused.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
     *
     * @param values The contentOptions to add.
     * @return This builder for chaining.
     */
    public Builder addAllContentOptions(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.ContentOption> values) {
      ensureContentOptionsIsMutable();
      for (com.google.privacy.dlp.v2.ContentOption value : values) {
        contentOptions_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated and unused.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContentOptions() {
      contentOptions_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated and unused.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
     *
     * @return A list containing the enum numeric values on the wire for contentOptions.
     */
    public java.util.List<java.lang.Integer> getContentOptionsValueList() {
      return java.util.Collections.unmodifiableList(contentOptions_);
    }
    /**
     *
     *
     * <pre>
     * Deprecated and unused.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of contentOptions at the given index.
     */
    public int getContentOptionsValue(int index) {
      return contentOptions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated and unused.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for contentOptions to set.
     * @return This builder for chaining.
     */
    public Builder setContentOptionsValue(int index, int value) {
      ensureContentOptionsIsMutable();
      contentOptions_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated and unused.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
     *
     * @param value The enum numeric value on the wire for contentOptions to add.
     * @return This builder for chaining.
     */
    public Builder addContentOptionsValue(int value) {
      ensureContentOptionsIsMutable();
      contentOptions_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated and unused.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.ContentOption content_options = 8;</code>
     *
     * @param values The enum numeric values on the wire for contentOptions to add.
     * @return This builder for chaining.
     */
    public Builder addAllContentOptionsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureContentOptionsIsMutable();
      for (int value : values) {
        contentOptions_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<com.google.privacy.dlp.v2.InspectionRuleSet> ruleSet_ =
        java.util.Collections.emptyList();

    private void ensureRuleSetIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        ruleSet_ = new java.util.ArrayList<com.google.privacy.dlp.v2.InspectionRuleSet>(ruleSet_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectionRuleSet,
            com.google.privacy.dlp.v2.InspectionRuleSet.Builder,
            com.google.privacy.dlp.v2.InspectionRuleSetOrBuilder>
        ruleSetBuilder_;

    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.InspectionRuleSet> getRuleSetList() {
      if (ruleSetBuilder_ == null) {
        return java.util.Collections.unmodifiableList(ruleSet_);
      } else {
        return ruleSetBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public int getRuleSetCount() {
      if (ruleSetBuilder_ == null) {
        return ruleSet_.size();
      } else {
        return ruleSetBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public com.google.privacy.dlp.v2.InspectionRuleSet getRuleSet(int index) {
      if (ruleSetBuilder_ == null) {
        return ruleSet_.get(index);
      } else {
        return ruleSetBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public Builder setRuleSet(int index, com.google.privacy.dlp.v2.InspectionRuleSet value) {
      if (ruleSetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuleSetIsMutable();
        ruleSet_.set(index, value);
        onChanged();
      } else {
        ruleSetBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public Builder setRuleSet(
        int index, com.google.privacy.dlp.v2.InspectionRuleSet.Builder builderForValue) {
      if (ruleSetBuilder_ == null) {
        ensureRuleSetIsMutable();
        ruleSet_.set(index, builderForValue.build());
        onChanged();
      } else {
        ruleSetBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public Builder addRuleSet(com.google.privacy.dlp.v2.InspectionRuleSet value) {
      if (ruleSetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuleSetIsMutable();
        ruleSet_.add(value);
        onChanged();
      } else {
        ruleSetBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public Builder addRuleSet(int index, com.google.privacy.dlp.v2.InspectionRuleSet value) {
      if (ruleSetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuleSetIsMutable();
        ruleSet_.add(index, value);
        onChanged();
      } else {
        ruleSetBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public Builder addRuleSet(com.google.privacy.dlp.v2.InspectionRuleSet.Builder builderForValue) {
      if (ruleSetBuilder_ == null) {
        ensureRuleSetIsMutable();
        ruleSet_.add(builderForValue.build());
        onChanged();
      } else {
        ruleSetBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public Builder addRuleSet(
        int index, com.google.privacy.dlp.v2.InspectionRuleSet.Builder builderForValue) {
      if (ruleSetBuilder_ == null) {
        ensureRuleSetIsMutable();
        ruleSet_.add(index, builderForValue.build());
        onChanged();
      } else {
        ruleSetBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public Builder addAllRuleSet(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.InspectionRuleSet> values) {
      if (ruleSetBuilder_ == null) {
        ensureRuleSetIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ruleSet_);
        onChanged();
      } else {
        ruleSetBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public Builder clearRuleSet() {
      if (ruleSetBuilder_ == null) {
        ruleSet_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        ruleSetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public Builder removeRuleSet(int index) {
      if (ruleSetBuilder_ == null) {
        ensureRuleSetIsMutable();
        ruleSet_.remove(index);
        onChanged();
      } else {
        ruleSetBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public com.google.privacy.dlp.v2.InspectionRuleSet.Builder getRuleSetBuilder(int index) {
      return getRuleSetFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public com.google.privacy.dlp.v2.InspectionRuleSetOrBuilder getRuleSetOrBuilder(int index) {
      if (ruleSetBuilder_ == null) {
        return ruleSet_.get(index);
      } else {
        return ruleSetBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.InspectionRuleSetOrBuilder>
        getRuleSetOrBuilderList() {
      if (ruleSetBuilder_ != null) {
        return ruleSetBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(ruleSet_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public com.google.privacy.dlp.v2.InspectionRuleSet.Builder addRuleSetBuilder() {
      return getRuleSetFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.InspectionRuleSet.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public com.google.privacy.dlp.v2.InspectionRuleSet.Builder addRuleSetBuilder(int index) {
      return getRuleSetFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.InspectionRuleSet.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of rules to apply to the findings for this InspectConfig.
     * Exclusion rules, contained in the set are executed in the end, other
     * rules are executed in the order they are specified for each info type.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.InspectionRuleSet rule_set = 10;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.InspectionRuleSet.Builder>
        getRuleSetBuilderList() {
      return getRuleSetFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectionRuleSet,
            com.google.privacy.dlp.v2.InspectionRuleSet.Builder,
            com.google.privacy.dlp.v2.InspectionRuleSetOrBuilder>
        getRuleSetFieldBuilder() {
      if (ruleSetBuilder_ == null) {
        ruleSetBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.InspectionRuleSet,
                com.google.privacy.dlp.v2.InspectionRuleSet.Builder,
                com.google.privacy.dlp.v2.InspectionRuleSetOrBuilder>(
                ruleSet_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        ruleSet_ = null;
      }
      return ruleSetBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.InspectConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.InspectConfig)
  private static final com.google.privacy.dlp.v2.InspectConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.InspectConfig();
  }

  public static com.google.privacy.dlp.v2.InspectConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InspectConfig> PARSER =
      new com.google.protobuf.AbstractParser<InspectConfig>() {
        @java.lang.Override
        public InspectConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InspectConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InspectConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
