/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/storage.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Configuration to control jobs where the content being inspected is outside
 * of Google Cloud Platform.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.HybridOptions}
 */
public final class HybridOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.HybridOptions)
    HybridOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HybridOptions.newBuilder() to construct.
  private HybridOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HybridOptions() {
    description_ = "";
    requiredFindingLabelKeys_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HybridOptions();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpStorage
        .internal_static_google_privacy_dlp_v2_HybridOptions_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpStorage
        .internal_static_google_privacy_dlp_v2_HybridOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.HybridOptions.class,
            com.google.privacy.dlp.v2.HybridOptions.Builder.class);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 1;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * A short description of where the data is coming from. Will be stored once
   * in the job. 256 max length.
   * </pre>
   *
   * <code>string description = 1;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A short description of where the data is coming from. Will be stored once
   * in the job. 256 max length.
   * </pre>
   *
   * <code>string description = 1;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUIRED_FINDING_LABEL_KEYS_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList requiredFindingLabelKeys_;
  /**
   *
   *
   * <pre>
   * These are labels that each inspection request must include within their
   * 'finding_labels' map. Request may contain others, but any missing one of
   * these will be rejected.
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * No more than 10 keys can be required.
   * </pre>
   *
   * <code>repeated string required_finding_label_keys = 2;</code>
   *
   * @return A list containing the requiredFindingLabelKeys.
   */
  public com.google.protobuf.ProtocolStringList getRequiredFindingLabelKeysList() {
    return requiredFindingLabelKeys_;
  }
  /**
   *
   *
   * <pre>
   * These are labels that each inspection request must include within their
   * 'finding_labels' map. Request may contain others, but any missing one of
   * these will be rejected.
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * No more than 10 keys can be required.
   * </pre>
   *
   * <code>repeated string required_finding_label_keys = 2;</code>
   *
   * @return The count of requiredFindingLabelKeys.
   */
  public int getRequiredFindingLabelKeysCount() {
    return requiredFindingLabelKeys_.size();
  }
  /**
   *
   *
   * <pre>
   * These are labels that each inspection request must include within their
   * 'finding_labels' map. Request may contain others, but any missing one of
   * these will be rejected.
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * No more than 10 keys can be required.
   * </pre>
   *
   * <code>repeated string required_finding_label_keys = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The requiredFindingLabelKeys at the given index.
   */
  public java.lang.String getRequiredFindingLabelKeys(int index) {
    return requiredFindingLabelKeys_.get(index);
  }
  /**
   *
   *
   * <pre>
   * These are labels that each inspection request must include within their
   * 'finding_labels' map. Request may contain others, but any missing one of
   * these will be rejected.
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * No more than 10 keys can be required.
   * </pre>
   *
   * <code>repeated string required_finding_label_keys = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the requiredFindingLabelKeys at the given index.
   */
  public com.google.protobuf.ByteString getRequiredFindingLabelKeysBytes(int index) {
    return requiredFindingLabelKeys_.getByteString(index);
  }

  public static final int LABELS_FIELD_NUMBER = 3;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.privacy.dlp.v2.DlpStorage
                .internal_static_google_privacy_dlp_v2_HybridOptions_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * To organize findings, these labels will be added to each finding.
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * Label values must be between 0 and 63 characters long and must conform
   * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   * No more than 10 labels can be associated with a given finding.
   * Examples:
   * * `"environment" : "production"`
   * * `"pipeline" : "etl"`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * To organize findings, these labels will be added to each finding.
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * Label values must be between 0 and 63 characters long and must conform
   * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   * No more than 10 labels can be associated with a given finding.
   * Examples:
   * * `"environment" : "production"`
   * * `"pipeline" : "etl"`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * To organize findings, these labels will be added to each finding.
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * Label values must be between 0 and 63 characters long and must conform
   * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   * No more than 10 labels can be associated with a given finding.
   * Examples:
   * * `"environment" : "production"`
   * * `"pipeline" : "etl"`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * To organize findings, these labels will be added to each finding.
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * Label values must be between 0 and 63 characters long and must conform
   * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   * No more than 10 labels can be associated with a given finding.
   * Examples:
   * * `"environment" : "production"`
   * * `"pipeline" : "etl"`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TABLE_OPTIONS_FIELD_NUMBER = 4;
  private com.google.privacy.dlp.v2.TableOptions tableOptions_;
  /**
   *
   *
   * <pre>
   * If the container is a table, additional information to make findings
   * meaningful such as the columns that are primary keys.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
   *
   * @return Whether the tableOptions field is set.
   */
  @java.lang.Override
  public boolean hasTableOptions() {
    return tableOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * If the container is a table, additional information to make findings
   * meaningful such as the columns that are primary keys.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
   *
   * @return The tableOptions.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TableOptions getTableOptions() {
    return tableOptions_ == null
        ? com.google.privacy.dlp.v2.TableOptions.getDefaultInstance()
        : tableOptions_;
  }
  /**
   *
   *
   * <pre>
   * If the container is a table, additional information to make findings
   * meaningful such as the columns that are primary keys.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TableOptionsOrBuilder getTableOptionsOrBuilder() {
    return getTableOptions();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, description_);
    }
    for (int i = 0; i < requiredFindingLabelKeys_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 2, requiredFindingLabelKeys_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 3);
    if (tableOptions_ != null) {
      output.writeMessage(4, getTableOptions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < requiredFindingLabelKeys_.size(); i++) {
        dataSize += computeStringSizeNoTag(requiredFindingLabelKeys_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRequiredFindingLabelKeysList().size();
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, labels__);
    }
    if (tableOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getTableOptions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.HybridOptions)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.HybridOptions other = (com.google.privacy.dlp.v2.HybridOptions) obj;

    if (!getDescription().equals(other.getDescription())) return false;
    if (!getRequiredFindingLabelKeysList().equals(other.getRequiredFindingLabelKeysList()))
      return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasTableOptions() != other.hasTableOptions()) return false;
    if (hasTableOptions()) {
      if (!getTableOptions().equals(other.getTableOptions())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getRequiredFindingLabelKeysCount() > 0) {
      hash = (37 * hash) + REQUIRED_FINDING_LABEL_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + getRequiredFindingLabelKeysList().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasTableOptions()) {
      hash = (37 * hash) + TABLE_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getTableOptions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.HybridOptions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.HybridOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.HybridOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.HybridOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.HybridOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.HybridOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.HybridOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.HybridOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration to control jobs where the content being inspected is outside
   * of Google Cloud Platform.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.HybridOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.HybridOptions)
      com.google.privacy.dlp.v2.HybridOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_HybridOptions_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_HybridOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.HybridOptions.class,
              com.google.privacy.dlp.v2.HybridOptions.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.HybridOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      description_ = "";

      requiredFindingLabelKeys_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableLabels().clear();
      if (tableOptionsBuilder_ == null) {
        tableOptions_ = null;
      } else {
        tableOptions_ = null;
        tableOptionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_HybridOptions_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.HybridOptions getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.HybridOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.HybridOptions build() {
      com.google.privacy.dlp.v2.HybridOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.HybridOptions buildPartial() {
      com.google.privacy.dlp.v2.HybridOptions result =
          new com.google.privacy.dlp.v2.HybridOptions(this);
      int from_bitField0_ = bitField0_;
      result.description_ = description_;
      if (((bitField0_ & 0x00000001) != 0)) {
        requiredFindingLabelKeys_ = requiredFindingLabelKeys_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.requiredFindingLabelKeys_ = requiredFindingLabelKeys_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (tableOptionsBuilder_ == null) {
        result.tableOptions_ = tableOptions_;
      } else {
        result.tableOptions_ = tableOptionsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.HybridOptions) {
        return mergeFrom((com.google.privacy.dlp.v2.HybridOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.HybridOptions other) {
      if (other == com.google.privacy.dlp.v2.HybridOptions.getDefaultInstance()) return this;
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (!other.requiredFindingLabelKeys_.isEmpty()) {
        if (requiredFindingLabelKeys_.isEmpty()) {
          requiredFindingLabelKeys_ = other.requiredFindingLabelKeys_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureRequiredFindingLabelKeysIsMutable();
          requiredFindingLabelKeys_.addAll(other.requiredFindingLabelKeys_);
        }
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.hasTableOptions()) {
        mergeTableOptions(other.getTableOptions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRequiredFindingLabelKeysIsMutable();
                requiredFindingLabelKeys_.add(s);
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getTableOptionsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A short description of where the data is coming from. Will be stored once
     * in the job. 256 max length.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A short description of where the data is coming from. Will be stored once
     * in the job. 256 max length.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A short description of where the data is coming from. Will be stored once
     * in the job. 256 max length.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A short description of where the data is coming from. Will be stored once
     * in the job. 256 max length.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A short description of where the data is coming from. Will be stored once
     * in the job. 256 max length.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList requiredFindingLabelKeys_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureRequiredFindingLabelKeysIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        requiredFindingLabelKeys_ =
            new com.google.protobuf.LazyStringArrayList(requiredFindingLabelKeys_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * These are labels that each inspection request must include within their
     * 'finding_labels' map. Request may contain others, but any missing one of
     * these will be rejected.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * No more than 10 keys can be required.
     * </pre>
     *
     * <code>repeated string required_finding_label_keys = 2;</code>
     *
     * @return A list containing the requiredFindingLabelKeys.
     */
    public com.google.protobuf.ProtocolStringList getRequiredFindingLabelKeysList() {
      return requiredFindingLabelKeys_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * These are labels that each inspection request must include within their
     * 'finding_labels' map. Request may contain others, but any missing one of
     * these will be rejected.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * No more than 10 keys can be required.
     * </pre>
     *
     * <code>repeated string required_finding_label_keys = 2;</code>
     *
     * @return The count of requiredFindingLabelKeys.
     */
    public int getRequiredFindingLabelKeysCount() {
      return requiredFindingLabelKeys_.size();
    }
    /**
     *
     *
     * <pre>
     * These are labels that each inspection request must include within their
     * 'finding_labels' map. Request may contain others, but any missing one of
     * these will be rejected.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * No more than 10 keys can be required.
     * </pre>
     *
     * <code>repeated string required_finding_label_keys = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The requiredFindingLabelKeys at the given index.
     */
    public java.lang.String getRequiredFindingLabelKeys(int index) {
      return requiredFindingLabelKeys_.get(index);
    }
    /**
     *
     *
     * <pre>
     * These are labels that each inspection request must include within their
     * 'finding_labels' map. Request may contain others, but any missing one of
     * these will be rejected.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * No more than 10 keys can be required.
     * </pre>
     *
     * <code>repeated string required_finding_label_keys = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the requiredFindingLabelKeys at the given index.
     */
    public com.google.protobuf.ByteString getRequiredFindingLabelKeysBytes(int index) {
      return requiredFindingLabelKeys_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * These are labels that each inspection request must include within their
     * 'finding_labels' map. Request may contain others, but any missing one of
     * these will be rejected.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * No more than 10 keys can be required.
     * </pre>
     *
     * <code>repeated string required_finding_label_keys = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The requiredFindingLabelKeys to set.
     * @return This builder for chaining.
     */
    public Builder setRequiredFindingLabelKeys(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequiredFindingLabelKeysIsMutable();
      requiredFindingLabelKeys_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * These are labels that each inspection request must include within their
     * 'finding_labels' map. Request may contain others, but any missing one of
     * these will be rejected.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * No more than 10 keys can be required.
     * </pre>
     *
     * <code>repeated string required_finding_label_keys = 2;</code>
     *
     * @param value The requiredFindingLabelKeys to add.
     * @return This builder for chaining.
     */
    public Builder addRequiredFindingLabelKeys(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequiredFindingLabelKeysIsMutable();
      requiredFindingLabelKeys_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * These are labels that each inspection request must include within their
     * 'finding_labels' map. Request may contain others, but any missing one of
     * these will be rejected.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * No more than 10 keys can be required.
     * </pre>
     *
     * <code>repeated string required_finding_label_keys = 2;</code>
     *
     * @param values The requiredFindingLabelKeys to add.
     * @return This builder for chaining.
     */
    public Builder addAllRequiredFindingLabelKeys(java.lang.Iterable<java.lang.String> values) {
      ensureRequiredFindingLabelKeysIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, requiredFindingLabelKeys_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * These are labels that each inspection request must include within their
     * 'finding_labels' map. Request may contain others, but any missing one of
     * these will be rejected.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * No more than 10 keys can be required.
     * </pre>
     *
     * <code>repeated string required_finding_label_keys = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequiredFindingLabelKeys() {
      requiredFindingLabelKeys_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * These are labels that each inspection request must include within their
     * 'finding_labels' map. Request may contain others, but any missing one of
     * these will be rejected.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * No more than 10 keys can be required.
     * </pre>
     *
     * <code>repeated string required_finding_label_keys = 2;</code>
     *
     * @param value The bytes of the requiredFindingLabelKeys to add.
     * @return This builder for chaining.
     */
    public Builder addRequiredFindingLabelKeysBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRequiredFindingLabelKeysIsMutable();
      requiredFindingLabelKeys_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * To organize findings, these labels will be added to each finding.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * To organize findings, these labels will be added to each finding.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * To organize findings, these labels will be added to each finding.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * To organize findings, these labels will be added to each finding.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * To organize findings, these labels will be added to each finding.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * To organize findings, these labels will be added to each finding.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * To organize findings, these labels will be added to each finding.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.privacy.dlp.v2.TableOptions tableOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TableOptions,
            com.google.privacy.dlp.v2.TableOptions.Builder,
            com.google.privacy.dlp.v2.TableOptionsOrBuilder>
        tableOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     *
     * @return Whether the tableOptions field is set.
     */
    public boolean hasTableOptions() {
      return tableOptionsBuilder_ != null || tableOptions_ != null;
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     *
     * @return The tableOptions.
     */
    public com.google.privacy.dlp.v2.TableOptions getTableOptions() {
      if (tableOptionsBuilder_ == null) {
        return tableOptions_ == null
            ? com.google.privacy.dlp.v2.TableOptions.getDefaultInstance()
            : tableOptions_;
      } else {
        return tableOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    public Builder setTableOptions(com.google.privacy.dlp.v2.TableOptions value) {
      if (tableOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tableOptions_ = value;
        onChanged();
      } else {
        tableOptionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    public Builder setTableOptions(com.google.privacy.dlp.v2.TableOptions.Builder builderForValue) {
      if (tableOptionsBuilder_ == null) {
        tableOptions_ = builderForValue.build();
        onChanged();
      } else {
        tableOptionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    public Builder mergeTableOptions(com.google.privacy.dlp.v2.TableOptions value) {
      if (tableOptionsBuilder_ == null) {
        if (tableOptions_ != null) {
          tableOptions_ =
              com.google.privacy.dlp.v2.TableOptions.newBuilder(tableOptions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          tableOptions_ = value;
        }
        onChanged();
      } else {
        tableOptionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    public Builder clearTableOptions() {
      if (tableOptionsBuilder_ == null) {
        tableOptions_ = null;
        onChanged();
      } else {
        tableOptions_ = null;
        tableOptionsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    public com.google.privacy.dlp.v2.TableOptions.Builder getTableOptionsBuilder() {

      onChanged();
      return getTableOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    public com.google.privacy.dlp.v2.TableOptionsOrBuilder getTableOptionsOrBuilder() {
      if (tableOptionsBuilder_ != null) {
        return tableOptionsBuilder_.getMessageOrBuilder();
      } else {
        return tableOptions_ == null
            ? com.google.privacy.dlp.v2.TableOptions.getDefaultInstance()
            : tableOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * If the container is a table, additional information to make findings
     * meaningful such as the columns that are primary keys.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TableOptions table_options = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TableOptions,
            com.google.privacy.dlp.v2.TableOptions.Builder,
            com.google.privacy.dlp.v2.TableOptionsOrBuilder>
        getTableOptionsFieldBuilder() {
      if (tableOptionsBuilder_ == null) {
        tableOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.TableOptions,
                com.google.privacy.dlp.v2.TableOptions.Builder,
                com.google.privacy.dlp.v2.TableOptionsOrBuilder>(
                getTableOptions(), getParentForChildren(), isClean());
        tableOptions_ = null;
      }
      return tableOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.HybridOptions)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.HybridOptions)
  private static final com.google.privacy.dlp.v2.HybridOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.HybridOptions();
  }

  public static com.google.privacy.dlp.v2.HybridOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HybridOptions> PARSER =
      new com.google.protobuf.AbstractParser<HybridOptions>() {
        @java.lang.Override
        public HybridOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HybridOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HybridOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.HybridOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
