/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Statistics related to processing hybrid inspect requests.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.HybridInspectStatistics}
 */
public final class HybridInspectStatistics extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.HybridInspectStatistics)
    HybridInspectStatisticsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HybridInspectStatistics.newBuilder() to construct.
  private HybridInspectStatistics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HybridInspectStatistics() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HybridInspectStatistics();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_HybridInspectStatistics_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_HybridInspectStatistics_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.HybridInspectStatistics.class,
            com.google.privacy.dlp.v2.HybridInspectStatistics.Builder.class);
  }

  public static final int PROCESSED_COUNT_FIELD_NUMBER = 1;
  private long processedCount_;
  /**
   *
   *
   * <pre>
   * The number of hybrid inspection requests processed within this job.
   * </pre>
   *
   * <code>int64 processed_count = 1;</code>
   *
   * @return The processedCount.
   */
  @java.lang.Override
  public long getProcessedCount() {
    return processedCount_;
  }

  public static final int ABORTED_COUNT_FIELD_NUMBER = 2;
  private long abortedCount_;
  /**
   *
   *
   * <pre>
   * The number of hybrid inspection requests aborted because the job ran
   * out of quota or was ended before they could be processed.
   * </pre>
   *
   * <code>int64 aborted_count = 2;</code>
   *
   * @return The abortedCount.
   */
  @java.lang.Override
  public long getAbortedCount() {
    return abortedCount_;
  }

  public static final int PENDING_COUNT_FIELD_NUMBER = 3;
  private long pendingCount_;
  /**
   *
   *
   * <pre>
   * The number of hybrid requests currently being processed. Only populated
   * when called via method `getDlpJob`.
   * A burst of traffic may cause hybrid inspect requests to be enqueued.
   * Processing will take place as quickly as possible, but resource limitations
   * may impact how long a request is enqueued for.
   * </pre>
   *
   * <code>int64 pending_count = 3;</code>
   *
   * @return The pendingCount.
   */
  @java.lang.Override
  public long getPendingCount() {
    return pendingCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (processedCount_ != 0L) {
      output.writeInt64(1, processedCount_);
    }
    if (abortedCount_ != 0L) {
      output.writeInt64(2, abortedCount_);
    }
    if (pendingCount_ != 0L) {
      output.writeInt64(3, pendingCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (processedCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, processedCount_);
    }
    if (abortedCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, abortedCount_);
    }
    if (pendingCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, pendingCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.HybridInspectStatistics)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.HybridInspectStatistics other =
        (com.google.privacy.dlp.v2.HybridInspectStatistics) obj;

    if (getProcessedCount() != other.getProcessedCount()) return false;
    if (getAbortedCount() != other.getAbortedCount()) return false;
    if (getPendingCount() != other.getPendingCount()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROCESSED_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getProcessedCount());
    hash = (37 * hash) + ABORTED_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAbortedCount());
    hash = (37 * hash) + PENDING_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPendingCount());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.HybridInspectStatistics prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Statistics related to processing hybrid inspect requests.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.HybridInspectStatistics}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.HybridInspectStatistics)
      com.google.privacy.dlp.v2.HybridInspectStatisticsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_HybridInspectStatistics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_HybridInspectStatistics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.HybridInspectStatistics.class,
              com.google.privacy.dlp.v2.HybridInspectStatistics.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.HybridInspectStatistics.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      processedCount_ = 0L;

      abortedCount_ = 0L;

      pendingCount_ = 0L;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_HybridInspectStatistics_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.HybridInspectStatistics getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.HybridInspectStatistics.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.HybridInspectStatistics build() {
      com.google.privacy.dlp.v2.HybridInspectStatistics result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.HybridInspectStatistics buildPartial() {
      com.google.privacy.dlp.v2.HybridInspectStatistics result =
          new com.google.privacy.dlp.v2.HybridInspectStatistics(this);
      result.processedCount_ = processedCount_;
      result.abortedCount_ = abortedCount_;
      result.pendingCount_ = pendingCount_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.HybridInspectStatistics) {
        return mergeFrom((com.google.privacy.dlp.v2.HybridInspectStatistics) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.HybridInspectStatistics other) {
      if (other == com.google.privacy.dlp.v2.HybridInspectStatistics.getDefaultInstance())
        return this;
      if (other.getProcessedCount() != 0L) {
        setProcessedCount(other.getProcessedCount());
      }
      if (other.getAbortedCount() != 0L) {
        setAbortedCount(other.getAbortedCount());
      }
      if (other.getPendingCount() != 0L) {
        setPendingCount(other.getPendingCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                processedCount_ = input.readInt64();

                break;
              } // case 8
            case 16:
              {
                abortedCount_ = input.readInt64();

                break;
              } // case 16
            case 24:
              {
                pendingCount_ = input.readInt64();

                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private long processedCount_;
    /**
     *
     *
     * <pre>
     * The number of hybrid inspection requests processed within this job.
     * </pre>
     *
     * <code>int64 processed_count = 1;</code>
     *
     * @return The processedCount.
     */
    @java.lang.Override
    public long getProcessedCount() {
      return processedCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of hybrid inspection requests processed within this job.
     * </pre>
     *
     * <code>int64 processed_count = 1;</code>
     *
     * @param value The processedCount to set.
     * @return This builder for chaining.
     */
    public Builder setProcessedCount(long value) {

      processedCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of hybrid inspection requests processed within this job.
     * </pre>
     *
     * <code>int64 processed_count = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProcessedCount() {

      processedCount_ = 0L;
      onChanged();
      return this;
    }

    private long abortedCount_;
    /**
     *
     *
     * <pre>
     * The number of hybrid inspection requests aborted because the job ran
     * out of quota or was ended before they could be processed.
     * </pre>
     *
     * <code>int64 aborted_count = 2;</code>
     *
     * @return The abortedCount.
     */
    @java.lang.Override
    public long getAbortedCount() {
      return abortedCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of hybrid inspection requests aborted because the job ran
     * out of quota or was ended before they could be processed.
     * </pre>
     *
     * <code>int64 aborted_count = 2;</code>
     *
     * @param value The abortedCount to set.
     * @return This builder for chaining.
     */
    public Builder setAbortedCount(long value) {

      abortedCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of hybrid inspection requests aborted because the job ran
     * out of quota or was ended before they could be processed.
     * </pre>
     *
     * <code>int64 aborted_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAbortedCount() {

      abortedCount_ = 0L;
      onChanged();
      return this;
    }

    private long pendingCount_;
    /**
     *
     *
     * <pre>
     * The number of hybrid requests currently being processed. Only populated
     * when called via method `getDlpJob`.
     * A burst of traffic may cause hybrid inspect requests to be enqueued.
     * Processing will take place as quickly as possible, but resource limitations
     * may impact how long a request is enqueued for.
     * </pre>
     *
     * <code>int64 pending_count = 3;</code>
     *
     * @return The pendingCount.
     */
    @java.lang.Override
    public long getPendingCount() {
      return pendingCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of hybrid requests currently being processed. Only populated
     * when called via method `getDlpJob`.
     * A burst of traffic may cause hybrid inspect requests to be enqueued.
     * Processing will take place as quickly as possible, but resource limitations
     * may impact how long a request is enqueued for.
     * </pre>
     *
     * <code>int64 pending_count = 3;</code>
     *
     * @param value The pendingCount to set.
     * @return This builder for chaining.
     */
    public Builder setPendingCount(long value) {

      pendingCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of hybrid requests currently being processed. Only populated
     * when called via method `getDlpJob`.
     * A burst of traffic may cause hybrid inspect requests to be enqueued.
     * Processing will take place as quickly as possible, but resource limitations
     * may impact how long a request is enqueued for.
     * </pre>
     *
     * <code>int64 pending_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPendingCount() {

      pendingCount_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.HybridInspectStatistics)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.HybridInspectStatistics)
  private static final com.google.privacy.dlp.v2.HybridInspectStatistics DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.HybridInspectStatistics();
  }

  public static com.google.privacy.dlp.v2.HybridInspectStatistics getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HybridInspectStatistics> PARSER =
      new com.google.protobuf.AbstractParser<HybridInspectStatistics>() {
        @java.lang.Override
        public HybridInspectStatistics parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HybridInspectStatistics> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HybridInspectStatistics> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.HybridInspectStatistics getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
