/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Buckets values based on fixed size ranges. The
 * Bucketing transformation can provide all of this functionality,
 * but requires more configuration. This message is provided as a convenience to
 * the user for simple bucketing strategies.
 * The transformed value will be a hyphenated string of
 * {lower_bound}-{upper_bound}. For example, if lower_bound = 10 and upper_bound
 * = 20, all values that are within this bucket will be replaced with "10-20".
 * This can be used on data of type: double, long.
 * If the bound Value type differs from the type of data
 * being transformed, we will first attempt converting the type of the data to
 * be transformed to match the type of the bound before comparing.
 * See https://cloud.google.com/dlp/docs/concepts-bucketing to learn more.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.FixedSizeBucketingConfig}
 */
public final class FixedSizeBucketingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.FixedSizeBucketingConfig)
    FixedSizeBucketingConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FixedSizeBucketingConfig.newBuilder() to construct.
  private FixedSizeBucketingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FixedSizeBucketingConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FixedSizeBucketingConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_FixedSizeBucketingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_FixedSizeBucketingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.FixedSizeBucketingConfig.class,
            com.google.privacy.dlp.v2.FixedSizeBucketingConfig.Builder.class);
  }

  public static final int LOWER_BOUND_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.Value lowerBound_;
  /**
   *
   *
   * <pre>
   * Required. Lower bound value of buckets. All values less than `lower_bound` are
   * grouped together into a single bucket; for example if `lower_bound` = 10,
   * then all values less than 10 are replaced with the value "-10".
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Value lower_bound = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the lowerBound field is set.
   */
  @java.lang.Override
  public boolean hasLowerBound() {
    return lowerBound_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Lower bound value of buckets. All values less than `lower_bound` are
   * grouped together into a single bucket; for example if `lower_bound` = 10,
   * then all values less than 10 are replaced with the value "-10".
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Value lower_bound = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The lowerBound.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Value getLowerBound() {
    return lowerBound_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : lowerBound_;
  }
  /**
   *
   *
   * <pre>
   * Required. Lower bound value of buckets. All values less than `lower_bound` are
   * grouped together into a single bucket; for example if `lower_bound` = 10,
   * then all values less than 10 are replaced with the value "-10".
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Value lower_bound = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ValueOrBuilder getLowerBoundOrBuilder() {
    return getLowerBound();
  }

  public static final int UPPER_BOUND_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.Value upperBound_;
  /**
   *
   *
   * <pre>
   * Required. Upper bound value of buckets. All values greater than upper_bound are
   * grouped together into a single bucket; for example if `upper_bound` = 89,
   * then all values greater than 89 are replaced with the value "89+".
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Value upper_bound = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the upperBound field is set.
   */
  @java.lang.Override
  public boolean hasUpperBound() {
    return upperBound_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Upper bound value of buckets. All values greater than upper_bound are
   * grouped together into a single bucket; for example if `upper_bound` = 89,
   * then all values greater than 89 are replaced with the value "89+".
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Value upper_bound = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The upperBound.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Value getUpperBound() {
    return upperBound_ == null ? com.google.privacy.dlp.v2.Value.getDefaultInstance() : upperBound_;
  }
  /**
   *
   *
   * <pre>
   * Required. Upper bound value of buckets. All values greater than upper_bound are
   * grouped together into a single bucket; for example if `upper_bound` = 89,
   * then all values greater than 89 are replaced with the value "89+".
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Value upper_bound = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ValueOrBuilder getUpperBoundOrBuilder() {
    return getUpperBound();
  }

  public static final int BUCKET_SIZE_FIELD_NUMBER = 3;
  private double bucketSize_;
  /**
   *
   *
   * <pre>
   * Required. Size of each bucket (except for minimum and maximum buckets). So if
   * `lower_bound` = 10, `upper_bound` = 89, and `bucket_size` = 10, then the
   * following buckets would be used: -10, 10-20, 20-30, 30-40, 40-50, 50-60,
   * 60-70, 70-80, 80-89, 89+. Precision up to 2 decimals works.
   * </pre>
   *
   * <code>double bucket_size = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bucketSize.
   */
  @java.lang.Override
  public double getBucketSize() {
    return bucketSize_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (lowerBound_ != null) {
      output.writeMessage(1, getLowerBound());
    }
    if (upperBound_ != null) {
      output.writeMessage(2, getUpperBound());
    }
    if (java.lang.Double.doubleToRawLongBits(bucketSize_) != 0) {
      output.writeDouble(3, bucketSize_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (lowerBound_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLowerBound());
    }
    if (upperBound_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpperBound());
    }
    if (java.lang.Double.doubleToRawLongBits(bucketSize_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, bucketSize_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.FixedSizeBucketingConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.FixedSizeBucketingConfig other =
        (com.google.privacy.dlp.v2.FixedSizeBucketingConfig) obj;

    if (hasLowerBound() != other.hasLowerBound()) return false;
    if (hasLowerBound()) {
      if (!getLowerBound().equals(other.getLowerBound())) return false;
    }
    if (hasUpperBound() != other.hasUpperBound()) return false;
    if (hasUpperBound()) {
      if (!getUpperBound().equals(other.getUpperBound())) return false;
    }
    if (java.lang.Double.doubleToLongBits(getBucketSize())
        != java.lang.Double.doubleToLongBits(other.getBucketSize())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasLowerBound()) {
      hash = (37 * hash) + LOWER_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + getLowerBound().hashCode();
    }
    if (hasUpperBound()) {
      hash = (37 * hash) + UPPER_BOUND_FIELD_NUMBER;
      hash = (53 * hash) + getUpperBound().hashCode();
    }
    hash = (37 * hash) + BUCKET_SIZE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getBucketSize()));
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.FixedSizeBucketingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Buckets values based on fixed size ranges. The
   * Bucketing transformation can provide all of this functionality,
   * but requires more configuration. This message is provided as a convenience to
   * the user for simple bucketing strategies.
   * The transformed value will be a hyphenated string of
   * {lower_bound}-{upper_bound}. For example, if lower_bound = 10 and upper_bound
   * = 20, all values that are within this bucket will be replaced with "10-20".
   * This can be used on data of type: double, long.
   * If the bound Value type differs from the type of data
   * being transformed, we will first attempt converting the type of the data to
   * be transformed to match the type of the bound before comparing.
   * See https://cloud.google.com/dlp/docs/concepts-bucketing to learn more.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.FixedSizeBucketingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.FixedSizeBucketingConfig)
      com.google.privacy.dlp.v2.FixedSizeBucketingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_FixedSizeBucketingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_FixedSizeBucketingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.FixedSizeBucketingConfig.class,
              com.google.privacy.dlp.v2.FixedSizeBucketingConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.FixedSizeBucketingConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (lowerBoundBuilder_ == null) {
        lowerBound_ = null;
      } else {
        lowerBound_ = null;
        lowerBoundBuilder_ = null;
      }
      if (upperBoundBuilder_ == null) {
        upperBound_ = null;
      } else {
        upperBound_ = null;
        upperBoundBuilder_ = null;
      }
      bucketSize_ = 0D;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_FixedSizeBucketingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.FixedSizeBucketingConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.FixedSizeBucketingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.FixedSizeBucketingConfig build() {
      com.google.privacy.dlp.v2.FixedSizeBucketingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.FixedSizeBucketingConfig buildPartial() {
      com.google.privacy.dlp.v2.FixedSizeBucketingConfig result =
          new com.google.privacy.dlp.v2.FixedSizeBucketingConfig(this);
      if (lowerBoundBuilder_ == null) {
        result.lowerBound_ = lowerBound_;
      } else {
        result.lowerBound_ = lowerBoundBuilder_.build();
      }
      if (upperBoundBuilder_ == null) {
        result.upperBound_ = upperBound_;
      } else {
        result.upperBound_ = upperBoundBuilder_.build();
      }
      result.bucketSize_ = bucketSize_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.FixedSizeBucketingConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.FixedSizeBucketingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.FixedSizeBucketingConfig other) {
      if (other == com.google.privacy.dlp.v2.FixedSizeBucketingConfig.getDefaultInstance())
        return this;
      if (other.hasLowerBound()) {
        mergeLowerBound(other.getLowerBound());
      }
      if (other.hasUpperBound()) {
        mergeUpperBound(other.getUpperBound());
      }
      if (other.getBucketSize() != 0D) {
        setBucketSize(other.getBucketSize());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getLowerBoundFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpperBoundFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 25:
              {
                bucketSize_ = input.readDouble();

                break;
              } // case 25
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.privacy.dlp.v2.Value lowerBound_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Value,
            com.google.privacy.dlp.v2.Value.Builder,
            com.google.privacy.dlp.v2.ValueOrBuilder>
        lowerBoundBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Lower bound value of buckets. All values less than `lower_bound` are
     * grouped together into a single bucket; for example if `lower_bound` = 10,
     * then all values less than 10 are replaced with the value "-10".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value lower_bound = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the lowerBound field is set.
     */
    public boolean hasLowerBound() {
      return lowerBoundBuilder_ != null || lowerBound_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Lower bound value of buckets. All values less than `lower_bound` are
     * grouped together into a single bucket; for example if `lower_bound` = 10,
     * then all values less than 10 are replaced with the value "-10".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value lower_bound = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The lowerBound.
     */
    public com.google.privacy.dlp.v2.Value getLowerBound() {
      if (lowerBoundBuilder_ == null) {
        return lowerBound_ == null
            ? com.google.privacy.dlp.v2.Value.getDefaultInstance()
            : lowerBound_;
      } else {
        return lowerBoundBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Lower bound value of buckets. All values less than `lower_bound` are
     * grouped together into a single bucket; for example if `lower_bound` = 10,
     * then all values less than 10 are replaced with the value "-10".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value lower_bound = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setLowerBound(com.google.privacy.dlp.v2.Value value) {
      if (lowerBoundBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lowerBound_ = value;
        onChanged();
      } else {
        lowerBoundBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Lower bound value of buckets. All values less than `lower_bound` are
     * grouped together into a single bucket; for example if `lower_bound` = 10,
     * then all values less than 10 are replaced with the value "-10".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value lower_bound = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setLowerBound(com.google.privacy.dlp.v2.Value.Builder builderForValue) {
      if (lowerBoundBuilder_ == null) {
        lowerBound_ = builderForValue.build();
        onChanged();
      } else {
        lowerBoundBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Lower bound value of buckets. All values less than `lower_bound` are
     * grouped together into a single bucket; for example if `lower_bound` = 10,
     * then all values less than 10 are replaced with the value "-10".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value lower_bound = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeLowerBound(com.google.privacy.dlp.v2.Value value) {
      if (lowerBoundBuilder_ == null) {
        if (lowerBound_ != null) {
          lowerBound_ =
              com.google.privacy.dlp.v2.Value.newBuilder(lowerBound_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          lowerBound_ = value;
        }
        onChanged();
      } else {
        lowerBoundBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Lower bound value of buckets. All values less than `lower_bound` are
     * grouped together into a single bucket; for example if `lower_bound` = 10,
     * then all values less than 10 are replaced with the value "-10".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value lower_bound = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearLowerBound() {
      if (lowerBoundBuilder_ == null) {
        lowerBound_ = null;
        onChanged();
      } else {
        lowerBound_ = null;
        lowerBoundBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Lower bound value of buckets. All values less than `lower_bound` are
     * grouped together into a single bucket; for example if `lower_bound` = 10,
     * then all values less than 10 are replaced with the value "-10".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value lower_bound = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.Value.Builder getLowerBoundBuilder() {

      onChanged();
      return getLowerBoundFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Lower bound value of buckets. All values less than `lower_bound` are
     * grouped together into a single bucket; for example if `lower_bound` = 10,
     * then all values less than 10 are replaced with the value "-10".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value lower_bound = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.ValueOrBuilder getLowerBoundOrBuilder() {
      if (lowerBoundBuilder_ != null) {
        return lowerBoundBuilder_.getMessageOrBuilder();
      } else {
        return lowerBound_ == null
            ? com.google.privacy.dlp.v2.Value.getDefaultInstance()
            : lowerBound_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Lower bound value of buckets. All values less than `lower_bound` are
     * grouped together into a single bucket; for example if `lower_bound` = 10,
     * then all values less than 10 are replaced with the value "-10".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value lower_bound = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Value,
            com.google.privacy.dlp.v2.Value.Builder,
            com.google.privacy.dlp.v2.ValueOrBuilder>
        getLowerBoundFieldBuilder() {
      if (lowerBoundBuilder_ == null) {
        lowerBoundBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Value,
                com.google.privacy.dlp.v2.Value.Builder,
                com.google.privacy.dlp.v2.ValueOrBuilder>(
                getLowerBound(), getParentForChildren(), isClean());
        lowerBound_ = null;
      }
      return lowerBoundBuilder_;
    }

    private com.google.privacy.dlp.v2.Value upperBound_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Value,
            com.google.privacy.dlp.v2.Value.Builder,
            com.google.privacy.dlp.v2.ValueOrBuilder>
        upperBoundBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Upper bound value of buckets. All values greater than upper_bound are
     * grouped together into a single bucket; for example if `upper_bound` = 89,
     * then all values greater than 89 are replaced with the value "89+".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value upper_bound = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the upperBound field is set.
     */
    public boolean hasUpperBound() {
      return upperBoundBuilder_ != null || upperBound_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Upper bound value of buckets. All values greater than upper_bound are
     * grouped together into a single bucket; for example if `upper_bound` = 89,
     * then all values greater than 89 are replaced with the value "89+".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value upper_bound = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The upperBound.
     */
    public com.google.privacy.dlp.v2.Value getUpperBound() {
      if (upperBoundBuilder_ == null) {
        return upperBound_ == null
            ? com.google.privacy.dlp.v2.Value.getDefaultInstance()
            : upperBound_;
      } else {
        return upperBoundBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Upper bound value of buckets. All values greater than upper_bound are
     * grouped together into a single bucket; for example if `upper_bound` = 89,
     * then all values greater than 89 are replaced with the value "89+".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value upper_bound = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpperBound(com.google.privacy.dlp.v2.Value value) {
      if (upperBoundBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        upperBound_ = value;
        onChanged();
      } else {
        upperBoundBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Upper bound value of buckets. All values greater than upper_bound are
     * grouped together into a single bucket; for example if `upper_bound` = 89,
     * then all values greater than 89 are replaced with the value "89+".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value upper_bound = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpperBound(com.google.privacy.dlp.v2.Value.Builder builderForValue) {
      if (upperBoundBuilder_ == null) {
        upperBound_ = builderForValue.build();
        onChanged();
      } else {
        upperBoundBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Upper bound value of buckets. All values greater than upper_bound are
     * grouped together into a single bucket; for example if `upper_bound` = 89,
     * then all values greater than 89 are replaced with the value "89+".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value upper_bound = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUpperBound(com.google.privacy.dlp.v2.Value value) {
      if (upperBoundBuilder_ == null) {
        if (upperBound_ != null) {
          upperBound_ =
              com.google.privacy.dlp.v2.Value.newBuilder(upperBound_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          upperBound_ = value;
        }
        onChanged();
      } else {
        upperBoundBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Upper bound value of buckets. All values greater than upper_bound are
     * grouped together into a single bucket; for example if `upper_bound` = 89,
     * then all values greater than 89 are replaced with the value "89+".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value upper_bound = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUpperBound() {
      if (upperBoundBuilder_ == null) {
        upperBound_ = null;
        onChanged();
      } else {
        upperBound_ = null;
        upperBoundBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Upper bound value of buckets. All values greater than upper_bound are
     * grouped together into a single bucket; for example if `upper_bound` = 89,
     * then all values greater than 89 are replaced with the value "89+".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value upper_bound = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.Value.Builder getUpperBoundBuilder() {

      onChanged();
      return getUpperBoundFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Upper bound value of buckets. All values greater than upper_bound are
     * grouped together into a single bucket; for example if `upper_bound` = 89,
     * then all values greater than 89 are replaced with the value "89+".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value upper_bound = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.privacy.dlp.v2.ValueOrBuilder getUpperBoundOrBuilder() {
      if (upperBoundBuilder_ != null) {
        return upperBoundBuilder_.getMessageOrBuilder();
      } else {
        return upperBound_ == null
            ? com.google.privacy.dlp.v2.Value.getDefaultInstance()
            : upperBound_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Upper bound value of buckets. All values greater than upper_bound are
     * grouped together into a single bucket; for example if `upper_bound` = 89,
     * then all values greater than 89 are replaced with the value "89+".
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Value upper_bound = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Value,
            com.google.privacy.dlp.v2.Value.Builder,
            com.google.privacy.dlp.v2.ValueOrBuilder>
        getUpperBoundFieldBuilder() {
      if (upperBoundBuilder_ == null) {
        upperBoundBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Value,
                com.google.privacy.dlp.v2.Value.Builder,
                com.google.privacy.dlp.v2.ValueOrBuilder>(
                getUpperBound(), getParentForChildren(), isClean());
        upperBound_ = null;
      }
      return upperBoundBuilder_;
    }

    private double bucketSize_;
    /**
     *
     *
     * <pre>
     * Required. Size of each bucket (except for minimum and maximum buckets). So if
     * `lower_bound` = 10, `upper_bound` = 89, and `bucket_size` = 10, then the
     * following buckets would be used: -10, 10-20, 20-30, 30-40, 40-50, 50-60,
     * 60-70, 70-80, 80-89, 89+. Precision up to 2 decimals works.
     * </pre>
     *
     * <code>double bucket_size = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucketSize.
     */
    @java.lang.Override
    public double getBucketSize() {
      return bucketSize_;
    }
    /**
     *
     *
     * <pre>
     * Required. Size of each bucket (except for minimum and maximum buckets). So if
     * `lower_bound` = 10, `upper_bound` = 89, and `bucket_size` = 10, then the
     * following buckets would be used: -10, 10-20, 20-30, 30-40, 40-50, 50-60,
     * 60-70, 70-80, 80-89, 89+. Precision up to 2 decimals works.
     * </pre>
     *
     * <code>double bucket_size = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bucketSize to set.
     * @return This builder for chaining.
     */
    public Builder setBucketSize(double value) {

      bucketSize_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Size of each bucket (except for minimum and maximum buckets). So if
     * `lower_bound` = 10, `upper_bound` = 89, and `bucket_size` = 10, then the
     * following buckets would be used: -10, 10-20, 20-30, 30-40, 40-50, 50-60,
     * 60-70, 70-80, 80-89, 89+. Precision up to 2 decimals works.
     * </pre>
     *
     * <code>double bucket_size = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucketSize() {

      bucketSize_ = 0D;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.FixedSizeBucketingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.FixedSizeBucketingConfig)
  private static final com.google.privacy.dlp.v2.FixedSizeBucketingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.FixedSizeBucketingConfig();
  }

  public static com.google.privacy.dlp.v2.FixedSizeBucketingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FixedSizeBucketingConfig> PARSER =
      new com.google.protobuf.AbstractParser<FixedSizeBucketingConfig>() {
        @java.lang.Override
        public FixedSizeBucketingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FixedSizeBucketingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FixedSizeBucketingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.FixedSizeBucketingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
