/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Represents a piece of potentially sensitive content.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.Finding}
 */
public final class Finding extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.Finding)
    FindingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Finding.newBuilder() to construct.
  private Finding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Finding() {
    name_ = "";
    quote_ = "";
    likelihood_ = 0;
    resourceName_ = "";
    triggerName_ = "";
    jobName_ = "";
    findingId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Finding();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Finding_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 10:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_Finding_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.Finding.class,
            com.google.privacy.dlp.v2.Finding.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 14;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Resource name in format
   * projects/{project}/locations/{location}/findings/{finding} Populated only
   * when viewing persisted findings.
   * </pre>
   *
   * <code>string name = 14;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name in format
   * projects/{project}/locations/{location}/findings/{finding} Populated only
   * when viewing persisted findings.
   * </pre>
   *
   * <code>string name = 14;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUOTE_FIELD_NUMBER = 1;
  private volatile java.lang.Object quote_;
  /**
   *
   *
   * <pre>
   * The content that was found. Even if the content is not textual, it
   * may be converted to a textual representation here.
   * Provided if `include_quote` is true and the finding is
   * less than or equal to 4096 bytes long. If the finding exceeds 4096 bytes
   * in length, the quote may be omitted.
   * </pre>
   *
   * <code>string quote = 1;</code>
   *
   * @return The quote.
   */
  @java.lang.Override
  public java.lang.String getQuote() {
    java.lang.Object ref = quote_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      quote_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The content that was found. Even if the content is not textual, it
   * may be converted to a textual representation here.
   * Provided if `include_quote` is true and the finding is
   * less than or equal to 4096 bytes long. If the finding exceeds 4096 bytes
   * in length, the quote may be omitted.
   * </pre>
   *
   * <code>string quote = 1;</code>
   *
   * @return The bytes for quote.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQuoteBytes() {
    java.lang.Object ref = quote_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      quote_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INFO_TYPE_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.InfoType infoType_;
  /**
   *
   *
   * <pre>
   * The type of content that might have been found.
   * Provided if `excluded_types` is false.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
   *
   * @return Whether the infoType field is set.
   */
  @java.lang.Override
  public boolean hasInfoType() {
    return infoType_ != null;
  }
  /**
   *
   *
   * <pre>
   * The type of content that might have been found.
   * Provided if `excluded_types` is false.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
   *
   * @return The infoType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoType getInfoType() {
    return infoType_ == null ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance() : infoType_;
  }
  /**
   *
   *
   * <pre>
   * The type of content that might have been found.
   * Provided if `excluded_types` is false.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
    return getInfoType();
  }

  public static final int LIKELIHOOD_FIELD_NUMBER = 3;
  private int likelihood_;
  /**
   *
   *
   * <pre>
   * Confidence of how likely it is that the `info_type` is correct.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Likelihood likelihood = 3;</code>
   *
   * @return The enum numeric value on the wire for likelihood.
   */
  @java.lang.Override
  public int getLikelihoodValue() {
    return likelihood_;
  }
  /**
   *
   *
   * <pre>
   * Confidence of how likely it is that the `info_type` is correct.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Likelihood likelihood = 3;</code>
   *
   * @return The likelihood.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Likelihood getLikelihood() {
    @SuppressWarnings("deprecation")
    com.google.privacy.dlp.v2.Likelihood result =
        com.google.privacy.dlp.v2.Likelihood.valueOf(likelihood_);
    return result == null ? com.google.privacy.dlp.v2.Likelihood.UNRECOGNIZED : result;
  }

  public static final int LOCATION_FIELD_NUMBER = 4;
  private com.google.privacy.dlp.v2.Location location_;
  /**
   *
   *
   * <pre>
   * Where the content was found.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Location location = 4;</code>
   *
   * @return Whether the location field is set.
   */
  @java.lang.Override
  public boolean hasLocation() {
    return location_ != null;
  }
  /**
   *
   *
   * <pre>
   * Where the content was found.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Location location = 4;</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.Location getLocation() {
    return location_ == null ? com.google.privacy.dlp.v2.Location.getDefaultInstance() : location_;
  }
  /**
   *
   *
   * <pre>
   * Where the content was found.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Location location = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.LocationOrBuilder getLocationOrBuilder() {
    return getLocation();
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Timestamp when finding was detected.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Timestamp when finding was detected.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Timestamp when finding was detected.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int QUOTE_INFO_FIELD_NUMBER = 7;
  private com.google.privacy.dlp.v2.QuoteInfo quoteInfo_;
  /**
   *
   *
   * <pre>
   * Contains data parsed from quotes. Only populated if include_quote was set
   * to true and a supported infoType was requested. Currently supported
   * infoTypes: DATE, DATE_OF_BIRTH and TIME.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.QuoteInfo quote_info = 7;</code>
   *
   * @return Whether the quoteInfo field is set.
   */
  @java.lang.Override
  public boolean hasQuoteInfo() {
    return quoteInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Contains data parsed from quotes. Only populated if include_quote was set
   * to true and a supported infoType was requested. Currently supported
   * infoTypes: DATE, DATE_OF_BIRTH and TIME.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.QuoteInfo quote_info = 7;</code>
   *
   * @return The quoteInfo.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.QuoteInfo getQuoteInfo() {
    return quoteInfo_ == null
        ? com.google.privacy.dlp.v2.QuoteInfo.getDefaultInstance()
        : quoteInfo_;
  }
  /**
   *
   *
   * <pre>
   * Contains data parsed from quotes. Only populated if include_quote was set
   * to true and a supported infoType was requested. Currently supported
   * infoTypes: DATE, DATE_OF_BIRTH and TIME.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.QuoteInfo quote_info = 7;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.QuoteInfoOrBuilder getQuoteInfoOrBuilder() {
    return getQuoteInfo();
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 8;
  private volatile java.lang.Object resourceName_;
  /**
   *
   *
   * <pre>
   * The job that stored the finding.
   * </pre>
   *
   * <code>string resource_name = 8 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The job that stored the finding.
   * </pre>
   *
   * <code>string resource_name = 8 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRIGGER_NAME_FIELD_NUMBER = 9;
  private volatile java.lang.Object triggerName_;
  /**
   *
   *
   * <pre>
   * Job trigger name, if applicable, for this finding.
   * </pre>
   *
   * <code>string trigger_name = 9 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The triggerName.
   */
  @java.lang.Override
  public java.lang.String getTriggerName() {
    java.lang.Object ref = triggerName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      triggerName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Job trigger name, if applicable, for this finding.
   * </pre>
   *
   * <code>string trigger_name = 9 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for triggerName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTriggerNameBytes() {
    java.lang.Object ref = triggerName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      triggerName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 10;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.privacy.dlp.v2.DlpProto
                .internal_static_google_privacy_dlp_v2_Finding_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * The labels associated with this `Finding`.
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * Label values must be between 0 and 63 characters long and must conform
   * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   * No more than 10 labels can be associated with a given finding.
   * Examples:
   * * `"environment" : "production"`
   * * `"pipeline" : "etl"`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * The labels associated with this `Finding`.
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * Label values must be between 0 and 63 characters long and must conform
   * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   * No more than 10 labels can be associated with a given finding.
   * Examples:
   * * `"environment" : "production"`
   * * `"pipeline" : "etl"`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * The labels associated with this `Finding`.
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * Label values must be between 0 and 63 characters long and must conform
   * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   * No more than 10 labels can be associated with a given finding.
   * Examples:
   * * `"environment" : "production"`
   * * `"pipeline" : "etl"`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * The labels associated with this `Finding`.
   * Label keys must be between 1 and 63 characters long and must conform
   * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * Label values must be between 0 and 63 characters long and must conform
   * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
   * No more than 10 labels can be associated with a given finding.
   * Examples:
   * * `"environment" : "production"`
   * * `"pipeline" : "etl"`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int JOB_CREATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp jobCreateTime_;
  /**
   *
   *
   * <pre>
   * Time the job started that produced this finding.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_create_time = 11;</code>
   *
   * @return Whether the jobCreateTime field is set.
   */
  @java.lang.Override
  public boolean hasJobCreateTime() {
    return jobCreateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time the job started that produced this finding.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_create_time = 11;</code>
   *
   * @return The jobCreateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getJobCreateTime() {
    return jobCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : jobCreateTime_;
  }
  /**
   *
   *
   * <pre>
   * Time the job started that produced this finding.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_create_time = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getJobCreateTimeOrBuilder() {
    return getJobCreateTime();
  }

  public static final int JOB_NAME_FIELD_NUMBER = 13;
  private volatile java.lang.Object jobName_;
  /**
   *
   *
   * <pre>
   * The job that stored the finding.
   * </pre>
   *
   * <code>string job_name = 13 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The jobName.
   */
  @java.lang.Override
  public java.lang.String getJobName() {
    java.lang.Object ref = jobName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      jobName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The job that stored the finding.
   * </pre>
   *
   * <code>string job_name = 13 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for jobName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJobNameBytes() {
    java.lang.Object ref = jobName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      jobName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINDING_ID_FIELD_NUMBER = 15;
  private volatile java.lang.Object findingId_;
  /**
   *
   *
   * <pre>
   * The unique finding id.
   * </pre>
   *
   * <code>string finding_id = 15;</code>
   *
   * @return The findingId.
   */
  @java.lang.Override
  public java.lang.String getFindingId() {
    java.lang.Object ref = findingId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      findingId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique finding id.
   * </pre>
   *
   * <code>string finding_id = 15;</code>
   *
   * @return The bytes for findingId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFindingIdBytes() {
    java.lang.Object ref = findingId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      findingId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(quote_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, quote_);
    }
    if (infoType_ != null) {
      output.writeMessage(2, getInfoType());
    }
    if (likelihood_ != com.google.privacy.dlp.v2.Likelihood.LIKELIHOOD_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, likelihood_);
    }
    if (location_ != null) {
      output.writeMessage(4, getLocation());
    }
    if (createTime_ != null) {
      output.writeMessage(6, getCreateTime());
    }
    if (quoteInfo_ != null) {
      output.writeMessage(7, getQuoteInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, resourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(triggerName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, triggerName_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 10);
    if (jobCreateTime_ != null) {
      output.writeMessage(11, getJobCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, jobName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(findingId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, findingId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(quote_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, quote_);
    }
    if (infoType_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getInfoType());
    }
    if (likelihood_ != com.google.privacy.dlp.v2.Likelihood.LIKELIHOOD_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, likelihood_);
    }
    if (location_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getLocation());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (quoteInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getQuoteInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, resourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(triggerName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, triggerName_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, labels__);
    }
    if (jobCreateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getJobCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, jobName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(findingId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, findingId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.Finding)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.Finding other = (com.google.privacy.dlp.v2.Finding) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getQuote().equals(other.getQuote())) return false;
    if (hasInfoType() != other.hasInfoType()) return false;
    if (hasInfoType()) {
      if (!getInfoType().equals(other.getInfoType())) return false;
    }
    if (likelihood_ != other.likelihood_) return false;
    if (hasLocation() != other.hasLocation()) return false;
    if (hasLocation()) {
      if (!getLocation().equals(other.getLocation())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasQuoteInfo() != other.hasQuoteInfo()) return false;
    if (hasQuoteInfo()) {
      if (!getQuoteInfo().equals(other.getQuoteInfo())) return false;
    }
    if (!getResourceName().equals(other.getResourceName())) return false;
    if (!getTriggerName().equals(other.getTriggerName())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasJobCreateTime() != other.hasJobCreateTime()) return false;
    if (hasJobCreateTime()) {
      if (!getJobCreateTime().equals(other.getJobCreateTime())) return false;
    }
    if (!getJobName().equals(other.getJobName())) return false;
    if (!getFindingId().equals(other.getFindingId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + QUOTE_FIELD_NUMBER;
    hash = (53 * hash) + getQuote().hashCode();
    if (hasInfoType()) {
      hash = (37 * hash) + INFO_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getInfoType().hashCode();
    }
    hash = (37 * hash) + LIKELIHOOD_FIELD_NUMBER;
    hash = (53 * hash) + likelihood_;
    if (hasLocation()) {
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasQuoteInfo()) {
      hash = (37 * hash) + QUOTE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getQuoteInfo().hashCode();
    }
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + TRIGGER_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTriggerName().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasJobCreateTime()) {
      hash = (37 * hash) + JOB_CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getJobCreateTime().hashCode();
    }
    hash = (37 * hash) + JOB_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getJobName().hashCode();
    hash = (37 * hash) + FINDING_ID_FIELD_NUMBER;
    hash = (53 * hash) + getFindingId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.Finding parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Finding parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Finding parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Finding parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Finding parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.Finding parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Finding parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Finding parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Finding parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Finding parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.Finding parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.Finding parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.Finding prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a piece of potentially sensitive content.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.Finding}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.Finding)
      com.google.privacy.dlp.v2.FindingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Finding_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 10:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 10:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Finding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.Finding.class,
              com.google.privacy.dlp.v2.Finding.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.Finding.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      quote_ = "";

      if (infoTypeBuilder_ == null) {
        infoType_ = null;
      } else {
        infoType_ = null;
        infoTypeBuilder_ = null;
      }
      likelihood_ = 0;

      if (locationBuilder_ == null) {
        location_ = null;
      } else {
        location_ = null;
        locationBuilder_ = null;
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (quoteInfoBuilder_ == null) {
        quoteInfo_ = null;
      } else {
        quoteInfo_ = null;
        quoteInfoBuilder_ = null;
      }
      resourceName_ = "";

      triggerName_ = "";

      internalGetMutableLabels().clear();
      if (jobCreateTimeBuilder_ == null) {
        jobCreateTime_ = null;
      } else {
        jobCreateTime_ = null;
        jobCreateTimeBuilder_ = null;
      }
      jobName_ = "";

      findingId_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_Finding_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Finding getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.Finding.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Finding build() {
      com.google.privacy.dlp.v2.Finding result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.Finding buildPartial() {
      com.google.privacy.dlp.v2.Finding result = new com.google.privacy.dlp.v2.Finding(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.quote_ = quote_;
      if (infoTypeBuilder_ == null) {
        result.infoType_ = infoType_;
      } else {
        result.infoType_ = infoTypeBuilder_.build();
      }
      result.likelihood_ = likelihood_;
      if (locationBuilder_ == null) {
        result.location_ = location_;
      } else {
        result.location_ = locationBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (quoteInfoBuilder_ == null) {
        result.quoteInfo_ = quoteInfo_;
      } else {
        result.quoteInfo_ = quoteInfoBuilder_.build();
      }
      result.resourceName_ = resourceName_;
      result.triggerName_ = triggerName_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (jobCreateTimeBuilder_ == null) {
        result.jobCreateTime_ = jobCreateTime_;
      } else {
        result.jobCreateTime_ = jobCreateTimeBuilder_.build();
      }
      result.jobName_ = jobName_;
      result.findingId_ = findingId_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.Finding) {
        return mergeFrom((com.google.privacy.dlp.v2.Finding) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.Finding other) {
      if (other == com.google.privacy.dlp.v2.Finding.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getQuote().isEmpty()) {
        quote_ = other.quote_;
        onChanged();
      }
      if (other.hasInfoType()) {
        mergeInfoType(other.getInfoType());
      }
      if (other.likelihood_ != 0) {
        setLikelihoodValue(other.getLikelihoodValue());
      }
      if (other.hasLocation()) {
        mergeLocation(other.getLocation());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasQuoteInfo()) {
        mergeQuoteInfo(other.getQuoteInfo());
      }
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        onChanged();
      }
      if (!other.getTriggerName().isEmpty()) {
        triggerName_ = other.triggerName_;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      if (other.hasJobCreateTime()) {
        mergeJobCreateTime(other.getJobCreateTime());
      }
      if (!other.getJobName().isEmpty()) {
        jobName_ = other.jobName_;
        onChanged();
      }
      if (!other.getFindingId().isEmpty()) {
        findingId_ = other.findingId_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                quote_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInfoTypeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 24:
              {
                likelihood_ = input.readEnum();

                break;
              } // case 24
            case 34:
              {
                input.readMessage(getLocationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            case 58:
              {
                input.readMessage(getQuoteInfoFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 58
            case 66:
              {
                resourceName_ = input.readStringRequireUtf8();

                break;
              } // case 66
            case 74:
              {
                triggerName_ = input.readStringRequireUtf8();

                break;
              } // case 74
            case 82:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getJobCreateTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 90
            case 106:
              {
                jobName_ = input.readStringRequireUtf8();

                break;
              } // case 106
            case 114:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 114
            case 122:
              {
                findingId_ = input.readStringRequireUtf8();

                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Resource name in format
     * projects/{project}/locations/{location}/findings/{finding} Populated only
     * when viewing persisted findings.
     * </pre>
     *
     * <code>string name = 14;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name in format
     * projects/{project}/locations/{location}/findings/{finding} Populated only
     * when viewing persisted findings.
     * </pre>
     *
     * <code>string name = 14;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name in format
     * projects/{project}/locations/{location}/findings/{finding} Populated only
     * when viewing persisted findings.
     * </pre>
     *
     * <code>string name = 14;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name in format
     * projects/{project}/locations/{location}/findings/{finding} Populated only
     * when viewing persisted findings.
     * </pre>
     *
     * <code>string name = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name in format
     * projects/{project}/locations/{location}/findings/{finding} Populated only
     * when viewing persisted findings.
     * </pre>
     *
     * <code>string name = 14;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object quote_ = "";
    /**
     *
     *
     * <pre>
     * The content that was found. Even if the content is not textual, it
     * may be converted to a textual representation here.
     * Provided if `include_quote` is true and the finding is
     * less than or equal to 4096 bytes long. If the finding exceeds 4096 bytes
     * in length, the quote may be omitted.
     * </pre>
     *
     * <code>string quote = 1;</code>
     *
     * @return The quote.
     */
    public java.lang.String getQuote() {
      java.lang.Object ref = quote_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        quote_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The content that was found. Even if the content is not textual, it
     * may be converted to a textual representation here.
     * Provided if `include_quote` is true and the finding is
     * less than or equal to 4096 bytes long. If the finding exceeds 4096 bytes
     * in length, the quote may be omitted.
     * </pre>
     *
     * <code>string quote = 1;</code>
     *
     * @return The bytes for quote.
     */
    public com.google.protobuf.ByteString getQuoteBytes() {
      java.lang.Object ref = quote_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        quote_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The content that was found. Even if the content is not textual, it
     * may be converted to a textual representation here.
     * Provided if `include_quote` is true and the finding is
     * less than or equal to 4096 bytes long. If the finding exceeds 4096 bytes
     * in length, the quote may be omitted.
     * </pre>
     *
     * <code>string quote = 1;</code>
     *
     * @param value The quote to set.
     * @return This builder for chaining.
     */
    public Builder setQuote(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      quote_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content that was found. Even if the content is not textual, it
     * may be converted to a textual representation here.
     * Provided if `include_quote` is true and the finding is
     * less than or equal to 4096 bytes long. If the finding exceeds 4096 bytes
     * in length, the quote may be omitted.
     * </pre>
     *
     * <code>string quote = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuote() {

      quote_ = getDefaultInstance().getQuote();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The content that was found. Even if the content is not textual, it
     * may be converted to a textual representation here.
     * Provided if `include_quote` is true and the finding is
     * less than or equal to 4096 bytes long. If the finding exceeds 4096 bytes
     * in length, the quote may be omitted.
     * </pre>
     *
     * <code>string quote = 1;</code>
     *
     * @param value The bytes for quote to set.
     * @return This builder for chaining.
     */
    public Builder setQuoteBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      quote_ = value;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.InfoType infoType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        infoTypeBuilder_;
    /**
     *
     *
     * <pre>
     * The type of content that might have been found.
     * Provided if `excluded_types` is false.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     *
     * @return Whether the infoType field is set.
     */
    public boolean hasInfoType() {
      return infoTypeBuilder_ != null || infoType_ != null;
    }
    /**
     *
     *
     * <pre>
     * The type of content that might have been found.
     * Provided if `excluded_types` is false.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     *
     * @return The infoType.
     */
    public com.google.privacy.dlp.v2.InfoType getInfoType() {
      if (infoTypeBuilder_ == null) {
        return infoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : infoType_;
      } else {
        return infoTypeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The type of content that might have been found.
     * Provided if `excluded_types` is false.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    public Builder setInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        infoType_ = value;
        onChanged();
      } else {
        infoTypeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of content that might have been found.
     * Provided if `excluded_types` is false.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    public Builder setInfoType(com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
      if (infoTypeBuilder_ == null) {
        infoType_ = builderForValue.build();
        onChanged();
      } else {
        infoTypeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of content that might have been found.
     * Provided if `excluded_types` is false.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    public Builder mergeInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (infoTypeBuilder_ == null) {
        if (infoType_ != null) {
          infoType_ =
              com.google.privacy.dlp.v2.InfoType.newBuilder(infoType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          infoType_ = value;
        }
        onChanged();
      } else {
        infoTypeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of content that might have been found.
     * Provided if `excluded_types` is false.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    public Builder clearInfoType() {
      if (infoTypeBuilder_ == null) {
        infoType_ = null;
        onChanged();
      } else {
        infoType_ = null;
        infoTypeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of content that might have been found.
     * Provided if `excluded_types` is false.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    public com.google.privacy.dlp.v2.InfoType.Builder getInfoTypeBuilder() {

      onChanged();
      return getInfoTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The type of content that might have been found.
     * Provided if `excluded_types` is false.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder() {
      if (infoTypeBuilder_ != null) {
        return infoTypeBuilder_.getMessageOrBuilder();
      } else {
        return infoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : infoType_;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of content that might have been found.
     * Provided if `excluded_types` is false.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType info_type = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        getInfoTypeFieldBuilder() {
      if (infoTypeBuilder_ == null) {
        infoTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoType,
                com.google.privacy.dlp.v2.InfoType.Builder,
                com.google.privacy.dlp.v2.InfoTypeOrBuilder>(
                getInfoType(), getParentForChildren(), isClean());
        infoType_ = null;
      }
      return infoTypeBuilder_;
    }

    private int likelihood_ = 0;
    /**
     *
     *
     * <pre>
     * Confidence of how likely it is that the `info_type` is correct.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood likelihood = 3;</code>
     *
     * @return The enum numeric value on the wire for likelihood.
     */
    @java.lang.Override
    public int getLikelihoodValue() {
      return likelihood_;
    }
    /**
     *
     *
     * <pre>
     * Confidence of how likely it is that the `info_type` is correct.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood likelihood = 3;</code>
     *
     * @param value The enum numeric value on the wire for likelihood to set.
     * @return This builder for chaining.
     */
    public Builder setLikelihoodValue(int value) {

      likelihood_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidence of how likely it is that the `info_type` is correct.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood likelihood = 3;</code>
     *
     * @return The likelihood.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.Likelihood getLikelihood() {
      @SuppressWarnings("deprecation")
      com.google.privacy.dlp.v2.Likelihood result =
          com.google.privacy.dlp.v2.Likelihood.valueOf(likelihood_);
      return result == null ? com.google.privacy.dlp.v2.Likelihood.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Confidence of how likely it is that the `info_type` is correct.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood likelihood = 3;</code>
     *
     * @param value The likelihood to set.
     * @return This builder for chaining.
     */
    public Builder setLikelihood(com.google.privacy.dlp.v2.Likelihood value) {
      if (value == null) {
        throw new NullPointerException();
      }

      likelihood_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Confidence of how likely it is that the `info_type` is correct.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Likelihood likelihood = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLikelihood() {

      likelihood_ = 0;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.Location location_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Location,
            com.google.privacy.dlp.v2.Location.Builder,
            com.google.privacy.dlp.v2.LocationOrBuilder>
        locationBuilder_;
    /**
     *
     *
     * <pre>
     * Where the content was found.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Location location = 4;</code>
     *
     * @return Whether the location field is set.
     */
    public boolean hasLocation() {
      return locationBuilder_ != null || location_ != null;
    }
    /**
     *
     *
     * <pre>
     * Where the content was found.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Location location = 4;</code>
     *
     * @return The location.
     */
    public com.google.privacy.dlp.v2.Location getLocation() {
      if (locationBuilder_ == null) {
        return location_ == null
            ? com.google.privacy.dlp.v2.Location.getDefaultInstance()
            : location_;
      } else {
        return locationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Where the content was found.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Location location = 4;</code>
     */
    public Builder setLocation(com.google.privacy.dlp.v2.Location value) {
      if (locationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        onChanged();
      } else {
        locationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Where the content was found.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Location location = 4;</code>
     */
    public Builder setLocation(com.google.privacy.dlp.v2.Location.Builder builderForValue) {
      if (locationBuilder_ == null) {
        location_ = builderForValue.build();
        onChanged();
      } else {
        locationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Where the content was found.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Location location = 4;</code>
     */
    public Builder mergeLocation(com.google.privacy.dlp.v2.Location value) {
      if (locationBuilder_ == null) {
        if (location_ != null) {
          location_ =
              com.google.privacy.dlp.v2.Location.newBuilder(location_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          location_ = value;
        }
        onChanged();
      } else {
        locationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Where the content was found.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Location location = 4;</code>
     */
    public Builder clearLocation() {
      if (locationBuilder_ == null) {
        location_ = null;
        onChanged();
      } else {
        location_ = null;
        locationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Where the content was found.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Location location = 4;</code>
     */
    public com.google.privacy.dlp.v2.Location.Builder getLocationBuilder() {

      onChanged();
      return getLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Where the content was found.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Location location = 4;</code>
     */
    public com.google.privacy.dlp.v2.LocationOrBuilder getLocationOrBuilder() {
      if (locationBuilder_ != null) {
        return locationBuilder_.getMessageOrBuilder();
      } else {
        return location_ == null
            ? com.google.privacy.dlp.v2.Location.getDefaultInstance()
            : location_;
      }
    }
    /**
     *
     *
     * <pre>
     * Where the content was found.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.Location location = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.Location,
            com.google.privacy.dlp.v2.Location.Builder,
            com.google.privacy.dlp.v2.LocationOrBuilder>
        getLocationFieldBuilder() {
      if (locationBuilder_ == null) {
        locationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.Location,
                com.google.privacy.dlp.v2.Location.Builder,
                com.google.privacy.dlp.v2.LocationOrBuilder>(
                getLocation(), getParentForChildren(), isClean());
        location_ = null;
      }
      return locationBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Timestamp when finding was detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Timestamp when finding was detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp when finding was detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp when finding was detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp when finding was detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp when finding was detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp when finding was detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Timestamp when finding was detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp when finding was detected.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.privacy.dlp.v2.QuoteInfo quoteInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.QuoteInfo,
            com.google.privacy.dlp.v2.QuoteInfo.Builder,
            com.google.privacy.dlp.v2.QuoteInfoOrBuilder>
        quoteInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Contains data parsed from quotes. Only populated if include_quote was set
     * to true and a supported infoType was requested. Currently supported
     * infoTypes: DATE, DATE_OF_BIRTH and TIME.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.QuoteInfo quote_info = 7;</code>
     *
     * @return Whether the quoteInfo field is set.
     */
    public boolean hasQuoteInfo() {
      return quoteInfoBuilder_ != null || quoteInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Contains data parsed from quotes. Only populated if include_quote was set
     * to true and a supported infoType was requested. Currently supported
     * infoTypes: DATE, DATE_OF_BIRTH and TIME.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.QuoteInfo quote_info = 7;</code>
     *
     * @return The quoteInfo.
     */
    public com.google.privacy.dlp.v2.QuoteInfo getQuoteInfo() {
      if (quoteInfoBuilder_ == null) {
        return quoteInfo_ == null
            ? com.google.privacy.dlp.v2.QuoteInfo.getDefaultInstance()
            : quoteInfo_;
      } else {
        return quoteInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Contains data parsed from quotes. Only populated if include_quote was set
     * to true and a supported infoType was requested. Currently supported
     * infoTypes: DATE, DATE_OF_BIRTH and TIME.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.QuoteInfo quote_info = 7;</code>
     */
    public Builder setQuoteInfo(com.google.privacy.dlp.v2.QuoteInfo value) {
      if (quoteInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        quoteInfo_ = value;
        onChanged();
      } else {
        quoteInfoBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains data parsed from quotes. Only populated if include_quote was set
     * to true and a supported infoType was requested. Currently supported
     * infoTypes: DATE, DATE_OF_BIRTH and TIME.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.QuoteInfo quote_info = 7;</code>
     */
    public Builder setQuoteInfo(com.google.privacy.dlp.v2.QuoteInfo.Builder builderForValue) {
      if (quoteInfoBuilder_ == null) {
        quoteInfo_ = builderForValue.build();
        onChanged();
      } else {
        quoteInfoBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains data parsed from quotes. Only populated if include_quote was set
     * to true and a supported infoType was requested. Currently supported
     * infoTypes: DATE, DATE_OF_BIRTH and TIME.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.QuoteInfo quote_info = 7;</code>
     */
    public Builder mergeQuoteInfo(com.google.privacy.dlp.v2.QuoteInfo value) {
      if (quoteInfoBuilder_ == null) {
        if (quoteInfo_ != null) {
          quoteInfo_ =
              com.google.privacy.dlp.v2.QuoteInfo.newBuilder(quoteInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          quoteInfo_ = value;
        }
        onChanged();
      } else {
        quoteInfoBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains data parsed from quotes. Only populated if include_quote was set
     * to true and a supported infoType was requested. Currently supported
     * infoTypes: DATE, DATE_OF_BIRTH and TIME.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.QuoteInfo quote_info = 7;</code>
     */
    public Builder clearQuoteInfo() {
      if (quoteInfoBuilder_ == null) {
        quoteInfo_ = null;
        onChanged();
      } else {
        quoteInfo_ = null;
        quoteInfoBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Contains data parsed from quotes. Only populated if include_quote was set
     * to true and a supported infoType was requested. Currently supported
     * infoTypes: DATE, DATE_OF_BIRTH and TIME.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.QuoteInfo quote_info = 7;</code>
     */
    public com.google.privacy.dlp.v2.QuoteInfo.Builder getQuoteInfoBuilder() {

      onChanged();
      return getQuoteInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Contains data parsed from quotes. Only populated if include_quote was set
     * to true and a supported infoType was requested. Currently supported
     * infoTypes: DATE, DATE_OF_BIRTH and TIME.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.QuoteInfo quote_info = 7;</code>
     */
    public com.google.privacy.dlp.v2.QuoteInfoOrBuilder getQuoteInfoOrBuilder() {
      if (quoteInfoBuilder_ != null) {
        return quoteInfoBuilder_.getMessageOrBuilder();
      } else {
        return quoteInfo_ == null
            ? com.google.privacy.dlp.v2.QuoteInfo.getDefaultInstance()
            : quoteInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains data parsed from quotes. Only populated if include_quote was set
     * to true and a supported infoType was requested. Currently supported
     * infoTypes: DATE, DATE_OF_BIRTH and TIME.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.QuoteInfo quote_info = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.QuoteInfo,
            com.google.privacy.dlp.v2.QuoteInfo.Builder,
            com.google.privacy.dlp.v2.QuoteInfoOrBuilder>
        getQuoteInfoFieldBuilder() {
      if (quoteInfoBuilder_ == null) {
        quoteInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.QuoteInfo,
                com.google.privacy.dlp.v2.QuoteInfo.Builder,
                com.google.privacy.dlp.v2.QuoteInfoOrBuilder>(
                getQuoteInfo(), getParentForChildren(), isClean());
        quoteInfo_ = null;
      }
      return quoteInfoBuilder_;
    }

    private java.lang.Object resourceName_ = "";
    /**
     *
     *
     * <pre>
     * The job that stored the finding.
     * </pre>
     *
     * <code>string resource_name = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The job that stored the finding.
     * </pre>
     *
     * <code>string resource_name = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The job that stored the finding.
     * </pre>
     *
     * <code>string resource_name = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      resourceName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The job that stored the finding.
     * </pre>
     *
     * <code>string resource_name = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {

      resourceName_ = getDefaultInstance().getResourceName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The job that stored the finding.
     * </pre>
     *
     * <code>string resource_name = 8 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      resourceName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object triggerName_ = "";
    /**
     *
     *
     * <pre>
     * Job trigger name, if applicable, for this finding.
     * </pre>
     *
     * <code>string trigger_name = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The triggerName.
     */
    public java.lang.String getTriggerName() {
      java.lang.Object ref = triggerName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        triggerName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Job trigger name, if applicable, for this finding.
     * </pre>
     *
     * <code>string trigger_name = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for triggerName.
     */
    public com.google.protobuf.ByteString getTriggerNameBytes() {
      java.lang.Object ref = triggerName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        triggerName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Job trigger name, if applicable, for this finding.
     * </pre>
     *
     * <code>string trigger_name = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The triggerName to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      triggerName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Job trigger name, if applicable, for this finding.
     * </pre>
     *
     * <code>string trigger_name = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggerName() {

      triggerName_ = getDefaultInstance().getTriggerName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Job trigger name, if applicable, for this finding.
     * </pre>
     *
     * <code>string trigger_name = 9 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for triggerName to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      triggerName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this `Finding`.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this `Finding`.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this `Finding`.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this `Finding`.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this `Finding`.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this `Finding`.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * The labels associated with this `Finding`.
     * Label keys must be between 1 and 63 characters long and must conform
     * to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
     * Label values must be between 0 and 63 characters long and must conform
     * to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
     * No more than 10 labels can be associated with a given finding.
     * Examples:
     * * `"environment" : "production"`
     * * `"pipeline" : "etl"`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.Timestamp jobCreateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        jobCreateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time the job started that produced this finding.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_create_time = 11;</code>
     *
     * @return Whether the jobCreateTime field is set.
     */
    public boolean hasJobCreateTime() {
      return jobCreateTimeBuilder_ != null || jobCreateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time the job started that produced this finding.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_create_time = 11;</code>
     *
     * @return The jobCreateTime.
     */
    public com.google.protobuf.Timestamp getJobCreateTime() {
      if (jobCreateTimeBuilder_ == null) {
        return jobCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : jobCreateTime_;
      } else {
        return jobCreateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time the job started that produced this finding.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_create_time = 11;</code>
     */
    public Builder setJobCreateTime(com.google.protobuf.Timestamp value) {
      if (jobCreateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobCreateTime_ = value;
        onChanged();
      } else {
        jobCreateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time the job started that produced this finding.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_create_time = 11;</code>
     */
    public Builder setJobCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (jobCreateTimeBuilder_ == null) {
        jobCreateTime_ = builderForValue.build();
        onChanged();
      } else {
        jobCreateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time the job started that produced this finding.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_create_time = 11;</code>
     */
    public Builder mergeJobCreateTime(com.google.protobuf.Timestamp value) {
      if (jobCreateTimeBuilder_ == null) {
        if (jobCreateTime_ != null) {
          jobCreateTime_ =
              com.google.protobuf.Timestamp.newBuilder(jobCreateTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          jobCreateTime_ = value;
        }
        onChanged();
      } else {
        jobCreateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time the job started that produced this finding.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_create_time = 11;</code>
     */
    public Builder clearJobCreateTime() {
      if (jobCreateTimeBuilder_ == null) {
        jobCreateTime_ = null;
        onChanged();
      } else {
        jobCreateTime_ = null;
        jobCreateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time the job started that produced this finding.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_create_time = 11;</code>
     */
    public com.google.protobuf.Timestamp.Builder getJobCreateTimeBuilder() {

      onChanged();
      return getJobCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time the job started that produced this finding.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_create_time = 11;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getJobCreateTimeOrBuilder() {
      if (jobCreateTimeBuilder_ != null) {
        return jobCreateTimeBuilder_.getMessageOrBuilder();
      } else {
        return jobCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : jobCreateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time the job started that produced this finding.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_create_time = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getJobCreateTimeFieldBuilder() {
      if (jobCreateTimeBuilder_ == null) {
        jobCreateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getJobCreateTime(), getParentForChildren(), isClean());
        jobCreateTime_ = null;
      }
      return jobCreateTimeBuilder_;
    }

    private java.lang.Object jobName_ = "";
    /**
     *
     *
     * <pre>
     * The job that stored the finding.
     * </pre>
     *
     * <code>string job_name = 13 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The jobName.
     */
    public java.lang.String getJobName() {
      java.lang.Object ref = jobName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The job that stored the finding.
     * </pre>
     *
     * <code>string job_name = 13 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for jobName.
     */
    public com.google.protobuf.ByteString getJobNameBytes() {
      java.lang.Object ref = jobName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The job that stored the finding.
     * </pre>
     *
     * <code>string job_name = 13 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The jobName to set.
     * @return This builder for chaining.
     */
    public Builder setJobName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      jobName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The job that stored the finding.
     * </pre>
     *
     * <code>string job_name = 13 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobName() {

      jobName_ = getDefaultInstance().getJobName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The job that stored the finding.
     * </pre>
     *
     * <code>string job_name = 13 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for jobName to set.
     * @return This builder for chaining.
     */
    public Builder setJobNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      jobName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object findingId_ = "";
    /**
     *
     *
     * <pre>
     * The unique finding id.
     * </pre>
     *
     * <code>string finding_id = 15;</code>
     *
     * @return The findingId.
     */
    public java.lang.String getFindingId() {
      java.lang.Object ref = findingId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        findingId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique finding id.
     * </pre>
     *
     * <code>string finding_id = 15;</code>
     *
     * @return The bytes for findingId.
     */
    public com.google.protobuf.ByteString getFindingIdBytes() {
      java.lang.Object ref = findingId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        findingId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique finding id.
     * </pre>
     *
     * <code>string finding_id = 15;</code>
     *
     * @param value The findingId to set.
     * @return This builder for chaining.
     */
    public Builder setFindingId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      findingId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique finding id.
     * </pre>
     *
     * <code>string finding_id = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFindingId() {

      findingId_ = getDefaultInstance().getFindingId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique finding id.
     * </pre>
     *
     * <code>string finding_id = 15;</code>
     *
     * @param value The bytes for findingId to set.
     * @return This builder for chaining.
     */
    public Builder setFindingIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      findingId_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.Finding)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.Finding)
  private static final com.google.privacy.dlp.v2.Finding DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.Finding();
  }

  public static com.google.privacy.dlp.v2.Finding getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Finding> PARSER =
      new com.google.protobuf.AbstractParser<Finding>() {
        @java.lang.Override
        public Finding parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Finding> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Finding> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.Finding getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
