/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * The rule that specifies conditions when findings of infoTypes specified in
 * `InspectionRuleSet` are removed from results.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.ExclusionRule}
 */
public final class ExclusionRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.ExclusionRule)
    ExclusionRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExclusionRule.newBuilder() to construct.
  private ExclusionRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExclusionRule() {
    matchingType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExclusionRule();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_ExclusionRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_ExclusionRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.ExclusionRule.class,
            com.google.privacy.dlp.v2.ExclusionRule.Builder.class);
  }

  private int typeCase_ = 0;
  private java.lang.Object type_;

  public enum TypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DICTIONARY(1),
    REGEX(2),
    EXCLUDE_INFO_TYPES(3),
    TYPE_NOT_SET(0);
    private final int value;

    private TypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return DICTIONARY;
        case 2:
          return REGEX;
        case 3:
          return EXCLUDE_INFO_TYPES;
        case 0:
          return TYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeCase getTypeCase() {
    return TypeCase.forNumber(typeCase_);
  }

  public static final int DICTIONARY_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Dictionary which defines the rule.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 1;</code>
   *
   * @return Whether the dictionary field is set.
   */
  @java.lang.Override
  public boolean hasDictionary() {
    return typeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Dictionary which defines the rule.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 1;</code>
   *
   * @return The dictionary.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.Dictionary getDictionary() {
    if (typeCase_ == 1) {
      return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Dictionary which defines the rule.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder getDictionaryOrBuilder() {
    if (typeCase_ == 1) {
      return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
  }

  public static final int REGEX_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Regular expression which defines the rule.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 2;</code>
   *
   * @return Whether the regex field is set.
   */
  @java.lang.Override
  public boolean hasRegex() {
    return typeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Regular expression which defines the rule.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 2;</code>
   *
   * @return The regex.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.Regex getRegex() {
    if (typeCase_ == 2) {
      return (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Regular expression which defines the rule.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder getRegexOrBuilder() {
    if (typeCase_ == 2) {
      return (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_;
    }
    return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
  }

  public static final int EXCLUDE_INFO_TYPES_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Set of infoTypes for which findings would affect this rule.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ExcludeInfoTypes exclude_info_types = 3;</code>
   *
   * @return Whether the excludeInfoTypes field is set.
   */
  @java.lang.Override
  public boolean hasExcludeInfoTypes() {
    return typeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Set of infoTypes for which findings would affect this rule.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ExcludeInfoTypes exclude_info_types = 3;</code>
   *
   * @return The excludeInfoTypes.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ExcludeInfoTypes getExcludeInfoTypes() {
    if (typeCase_ == 3) {
      return (com.google.privacy.dlp.v2.ExcludeInfoTypes) type_;
    }
    return com.google.privacy.dlp.v2.ExcludeInfoTypes.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Set of infoTypes for which findings would affect this rule.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ExcludeInfoTypes exclude_info_types = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ExcludeInfoTypesOrBuilder getExcludeInfoTypesOrBuilder() {
    if (typeCase_ == 3) {
      return (com.google.privacy.dlp.v2.ExcludeInfoTypes) type_;
    }
    return com.google.privacy.dlp.v2.ExcludeInfoTypes.getDefaultInstance();
  }

  public static final int MATCHING_TYPE_FIELD_NUMBER = 4;
  private int matchingType_;
  /**
   *
   *
   * <pre>
   * How the rule is applied, see MatchingType documentation for details.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.MatchingType matching_type = 4;</code>
   *
   * @return The enum numeric value on the wire for matchingType.
   */
  @java.lang.Override
  public int getMatchingTypeValue() {
    return matchingType_;
  }
  /**
   *
   *
   * <pre>
   * How the rule is applied, see MatchingType documentation for details.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.MatchingType matching_type = 4;</code>
   *
   * @return The matchingType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.MatchingType getMatchingType() {
    @SuppressWarnings("deprecation")
    com.google.privacy.dlp.v2.MatchingType result =
        com.google.privacy.dlp.v2.MatchingType.valueOf(matchingType_);
    return result == null ? com.google.privacy.dlp.v2.MatchingType.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (typeCase_ == 1) {
      output.writeMessage(1, (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_);
    }
    if (typeCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_);
    }
    if (typeCase_ == 3) {
      output.writeMessage(3, (com.google.privacy.dlp.v2.ExcludeInfoTypes) type_);
    }
    if (matchingType_
        != com.google.privacy.dlp.v2.MatchingType.MATCHING_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, matchingType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (typeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_);
    }
    if (typeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_);
    }
    if (typeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.privacy.dlp.v2.ExcludeInfoTypes) type_);
    }
    if (matchingType_
        != com.google.privacy.dlp.v2.MatchingType.MATCHING_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, matchingType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.ExclusionRule)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.ExclusionRule other = (com.google.privacy.dlp.v2.ExclusionRule) obj;

    if (matchingType_ != other.matchingType_) return false;
    if (!getTypeCase().equals(other.getTypeCase())) return false;
    switch (typeCase_) {
      case 1:
        if (!getDictionary().equals(other.getDictionary())) return false;
        break;
      case 2:
        if (!getRegex().equals(other.getRegex())) return false;
        break;
      case 3:
        if (!getExcludeInfoTypes().equals(other.getExcludeInfoTypes())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MATCHING_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + matchingType_;
    switch (typeCase_) {
      case 1:
        hash = (37 * hash) + DICTIONARY_FIELD_NUMBER;
        hash = (53 * hash) + getDictionary().hashCode();
        break;
      case 2:
        hash = (37 * hash) + REGEX_FIELD_NUMBER;
        hash = (53 * hash) + getRegex().hashCode();
        break;
      case 3:
        hash = (37 * hash) + EXCLUDE_INFO_TYPES_FIELD_NUMBER;
        hash = (53 * hash) + getExcludeInfoTypes().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.ExclusionRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.ExclusionRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ExclusionRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.ExclusionRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ExclusionRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.ExclusionRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ExclusionRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.ExclusionRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ExclusionRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.ExclusionRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.ExclusionRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.ExclusionRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.ExclusionRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The rule that specifies conditions when findings of infoTypes specified in
   * `InspectionRuleSet` are removed from results.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.ExclusionRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.ExclusionRule)
      com.google.privacy.dlp.v2.ExclusionRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_ExclusionRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_ExclusionRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.ExclusionRule.class,
              com.google.privacy.dlp.v2.ExclusionRule.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.ExclusionRule.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (dictionaryBuilder_ != null) {
        dictionaryBuilder_.clear();
      }
      if (regexBuilder_ != null) {
        regexBuilder_.clear();
      }
      if (excludeInfoTypesBuilder_ != null) {
        excludeInfoTypesBuilder_.clear();
      }
      matchingType_ = 0;

      typeCase_ = 0;
      type_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_ExclusionRule_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.ExclusionRule getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.ExclusionRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.ExclusionRule build() {
      com.google.privacy.dlp.v2.ExclusionRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.ExclusionRule buildPartial() {
      com.google.privacy.dlp.v2.ExclusionRule result =
          new com.google.privacy.dlp.v2.ExclusionRule(this);
      if (typeCase_ == 1) {
        if (dictionaryBuilder_ == null) {
          result.type_ = type_;
        } else {
          result.type_ = dictionaryBuilder_.build();
        }
      }
      if (typeCase_ == 2) {
        if (regexBuilder_ == null) {
          result.type_ = type_;
        } else {
          result.type_ = regexBuilder_.build();
        }
      }
      if (typeCase_ == 3) {
        if (excludeInfoTypesBuilder_ == null) {
          result.type_ = type_;
        } else {
          result.type_ = excludeInfoTypesBuilder_.build();
        }
      }
      result.matchingType_ = matchingType_;
      result.typeCase_ = typeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.ExclusionRule) {
        return mergeFrom((com.google.privacy.dlp.v2.ExclusionRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.ExclusionRule other) {
      if (other == com.google.privacy.dlp.v2.ExclusionRule.getDefaultInstance()) return this;
      if (other.matchingType_ != 0) {
        setMatchingTypeValue(other.getMatchingTypeValue());
      }
      switch (other.getTypeCase()) {
        case DICTIONARY:
          {
            mergeDictionary(other.getDictionary());
            break;
          }
        case REGEX:
          {
            mergeRegex(other.getRegex());
            break;
          }
        case EXCLUDE_INFO_TYPES:
          {
            mergeExcludeInfoTypes(other.getExcludeInfoTypes());
            break;
          }
        case TYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDictionaryFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getRegexFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getExcludeInfoTypesFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 3;
                break;
              } // case 26
            case 32:
              {
                matchingType_ = input.readEnum();

                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public Builder clearType() {
      typeCase_ = 0;
      type_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary,
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder>
        dictionaryBuilder_;
    /**
     *
     *
     * <pre>
     * Dictionary which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 1;</code>
     *
     * @return Whether the dictionary field is set.
     */
    @java.lang.Override
    public boolean hasDictionary() {
      return typeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Dictionary which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 1;</code>
     *
     * @return The dictionary.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.Dictionary getDictionary() {
      if (dictionaryBuilder_ == null) {
        if (typeCase_ == 1) {
          return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
      } else {
        if (typeCase_ == 1) {
          return dictionaryBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Dictionary which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 1;</code>
     */
    public Builder setDictionary(com.google.privacy.dlp.v2.CustomInfoType.Dictionary value) {
      if (dictionaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        dictionaryBuilder_.setMessage(value);
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dictionary which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 1;</code>
     */
    public Builder setDictionary(
        com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder builderForValue) {
      if (dictionaryBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        dictionaryBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dictionary which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 1;</code>
     */
    public Builder mergeDictionary(com.google.privacy.dlp.v2.CustomInfoType.Dictionary value) {
      if (dictionaryBuilder_ == null) {
        if (typeCase_ == 1
            && type_ != com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.CustomInfoType.Dictionary.newBuilder(
                      (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 1) {
          dictionaryBuilder_.mergeFrom(value);
        } else {
          dictionaryBuilder_.setMessage(value);
        }
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dictionary which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 1;</code>
     */
    public Builder clearDictionary() {
      if (dictionaryBuilder_ == null) {
        if (typeCase_ == 1) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 1) {
          typeCase_ = 0;
          type_ = null;
        }
        dictionaryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dictionary which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 1;</code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder getDictionaryBuilder() {
      return getDictionaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Dictionary which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder getDictionaryOrBuilder() {
      if ((typeCase_ == 1) && (dictionaryBuilder_ != null)) {
        return dictionaryBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 1) {
          return (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Dictionary which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary,
            com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder>
        getDictionaryFieldBuilder() {
      if (dictionaryBuilder_ == null) {
        if (!(typeCase_ == 1)) {
          type_ = com.google.privacy.dlp.v2.CustomInfoType.Dictionary.getDefaultInstance();
        }
        dictionaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.Dictionary,
                com.google.privacy.dlp.v2.CustomInfoType.Dictionary.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder>(
                (com.google.privacy.dlp.v2.CustomInfoType.Dictionary) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 1;
      onChanged();
      ;
      return dictionaryBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.Regex,
            com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder>
        regexBuilder_;
    /**
     *
     *
     * <pre>
     * Regular expression which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 2;</code>
     *
     * @return Whether the regex field is set.
     */
    @java.lang.Override
    public boolean hasRegex() {
      return typeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Regular expression which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 2;</code>
     *
     * @return The regex.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.Regex getRegex() {
      if (regexBuilder_ == null) {
        if (typeCase_ == 2) {
          return (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
      } else {
        if (typeCase_ == 2) {
          return regexBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Regular expression which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 2;</code>
     */
    public Builder setRegex(com.google.privacy.dlp.v2.CustomInfoType.Regex value) {
      if (regexBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        regexBuilder_.setMessage(value);
      }
      typeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regular expression which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 2;</code>
     */
    public Builder setRegex(
        com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder builderForValue) {
      if (regexBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        regexBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regular expression which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 2;</code>
     */
    public Builder mergeRegex(com.google.privacy.dlp.v2.CustomInfoType.Regex value) {
      if (regexBuilder_ == null) {
        if (typeCase_ == 2
            && type_ != com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.CustomInfoType.Regex.newBuilder(
                      (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 2) {
          regexBuilder_.mergeFrom(value);
        } else {
          regexBuilder_.setMessage(value);
        }
      }
      typeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regular expression which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 2;</code>
     */
    public Builder clearRegex() {
      if (regexBuilder_ == null) {
        if (typeCase_ == 2) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 2) {
          typeCase_ = 0;
          type_ = null;
        }
        regexBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regular expression which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 2;</code>
     */
    public com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder getRegexBuilder() {
      return getRegexFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Regular expression which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder getRegexOrBuilder() {
      if ((typeCase_ == 2) && (regexBuilder_ != null)) {
        return regexBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 2) {
          return (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_;
        }
        return com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Regular expression which defines the rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CustomInfoType.Regex,
            com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder,
            com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder>
        getRegexFieldBuilder() {
      if (regexBuilder_ == null) {
        if (!(typeCase_ == 2)) {
          type_ = com.google.privacy.dlp.v2.CustomInfoType.Regex.getDefaultInstance();
        }
        regexBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CustomInfoType.Regex,
                com.google.privacy.dlp.v2.CustomInfoType.Regex.Builder,
                com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder>(
                (com.google.privacy.dlp.v2.CustomInfoType.Regex) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 2;
      onChanged();
      ;
      return regexBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ExcludeInfoTypes,
            com.google.privacy.dlp.v2.ExcludeInfoTypes.Builder,
            com.google.privacy.dlp.v2.ExcludeInfoTypesOrBuilder>
        excludeInfoTypesBuilder_;
    /**
     *
     *
     * <pre>
     * Set of infoTypes for which findings would affect this rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ExcludeInfoTypes exclude_info_types = 3;</code>
     *
     * @return Whether the excludeInfoTypes field is set.
     */
    @java.lang.Override
    public boolean hasExcludeInfoTypes() {
      return typeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Set of infoTypes for which findings would affect this rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ExcludeInfoTypes exclude_info_types = 3;</code>
     *
     * @return The excludeInfoTypes.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ExcludeInfoTypes getExcludeInfoTypes() {
      if (excludeInfoTypesBuilder_ == null) {
        if (typeCase_ == 3) {
          return (com.google.privacy.dlp.v2.ExcludeInfoTypes) type_;
        }
        return com.google.privacy.dlp.v2.ExcludeInfoTypes.getDefaultInstance();
      } else {
        if (typeCase_ == 3) {
          return excludeInfoTypesBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.ExcludeInfoTypes.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of infoTypes for which findings would affect this rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ExcludeInfoTypes exclude_info_types = 3;</code>
     */
    public Builder setExcludeInfoTypes(com.google.privacy.dlp.v2.ExcludeInfoTypes value) {
      if (excludeInfoTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        excludeInfoTypesBuilder_.setMessage(value);
      }
      typeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of infoTypes for which findings would affect this rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ExcludeInfoTypes exclude_info_types = 3;</code>
     */
    public Builder setExcludeInfoTypes(
        com.google.privacy.dlp.v2.ExcludeInfoTypes.Builder builderForValue) {
      if (excludeInfoTypesBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        excludeInfoTypesBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of infoTypes for which findings would affect this rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ExcludeInfoTypes exclude_info_types = 3;</code>
     */
    public Builder mergeExcludeInfoTypes(com.google.privacy.dlp.v2.ExcludeInfoTypes value) {
      if (excludeInfoTypesBuilder_ == null) {
        if (typeCase_ == 3
            && type_ != com.google.privacy.dlp.v2.ExcludeInfoTypes.getDefaultInstance()) {
          type_ =
              com.google.privacy.dlp.v2.ExcludeInfoTypes.newBuilder(
                      (com.google.privacy.dlp.v2.ExcludeInfoTypes) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 3) {
          excludeInfoTypesBuilder_.mergeFrom(value);
        } else {
          excludeInfoTypesBuilder_.setMessage(value);
        }
      }
      typeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of infoTypes for which findings would affect this rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ExcludeInfoTypes exclude_info_types = 3;</code>
     */
    public Builder clearExcludeInfoTypes() {
      if (excludeInfoTypesBuilder_ == null) {
        if (typeCase_ == 3) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 3) {
          typeCase_ = 0;
          type_ = null;
        }
        excludeInfoTypesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of infoTypes for which findings would affect this rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ExcludeInfoTypes exclude_info_types = 3;</code>
     */
    public com.google.privacy.dlp.v2.ExcludeInfoTypes.Builder getExcludeInfoTypesBuilder() {
      return getExcludeInfoTypesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Set of infoTypes for which findings would affect this rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ExcludeInfoTypes exclude_info_types = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ExcludeInfoTypesOrBuilder getExcludeInfoTypesOrBuilder() {
      if ((typeCase_ == 3) && (excludeInfoTypesBuilder_ != null)) {
        return excludeInfoTypesBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 3) {
          return (com.google.privacy.dlp.v2.ExcludeInfoTypes) type_;
        }
        return com.google.privacy.dlp.v2.ExcludeInfoTypes.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of infoTypes for which findings would affect this rule.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ExcludeInfoTypes exclude_info_types = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ExcludeInfoTypes,
            com.google.privacy.dlp.v2.ExcludeInfoTypes.Builder,
            com.google.privacy.dlp.v2.ExcludeInfoTypesOrBuilder>
        getExcludeInfoTypesFieldBuilder() {
      if (excludeInfoTypesBuilder_ == null) {
        if (!(typeCase_ == 3)) {
          type_ = com.google.privacy.dlp.v2.ExcludeInfoTypes.getDefaultInstance();
        }
        excludeInfoTypesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.ExcludeInfoTypes,
                com.google.privacy.dlp.v2.ExcludeInfoTypes.Builder,
                com.google.privacy.dlp.v2.ExcludeInfoTypesOrBuilder>(
                (com.google.privacy.dlp.v2.ExcludeInfoTypes) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 3;
      onChanged();
      ;
      return excludeInfoTypesBuilder_;
    }

    private int matchingType_ = 0;
    /**
     *
     *
     * <pre>
     * How the rule is applied, see MatchingType documentation for details.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MatchingType matching_type = 4;</code>
     *
     * @return The enum numeric value on the wire for matchingType.
     */
    @java.lang.Override
    public int getMatchingTypeValue() {
      return matchingType_;
    }
    /**
     *
     *
     * <pre>
     * How the rule is applied, see MatchingType documentation for details.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MatchingType matching_type = 4;</code>
     *
     * @param value The enum numeric value on the wire for matchingType to set.
     * @return This builder for chaining.
     */
    public Builder setMatchingTypeValue(int value) {

      matchingType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How the rule is applied, see MatchingType documentation for details.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MatchingType matching_type = 4;</code>
     *
     * @return The matchingType.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.MatchingType getMatchingType() {
      @SuppressWarnings("deprecation")
      com.google.privacy.dlp.v2.MatchingType result =
          com.google.privacy.dlp.v2.MatchingType.valueOf(matchingType_);
      return result == null ? com.google.privacy.dlp.v2.MatchingType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * How the rule is applied, see MatchingType documentation for details.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MatchingType matching_type = 4;</code>
     *
     * @param value The matchingType to set.
     * @return This builder for chaining.
     */
    public Builder setMatchingType(com.google.privacy.dlp.v2.MatchingType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      matchingType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * How the rule is applied, see MatchingType documentation for details.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.MatchingType matching_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMatchingType() {

      matchingType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.ExclusionRule)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.ExclusionRule)
  private static final com.google.privacy.dlp.v2.ExclusionRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.ExclusionRule();
  }

  public static com.google.privacy.dlp.v2.ExclusionRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExclusionRule> PARSER =
      new com.google.protobuf.AbstractParser<ExclusionRule>() {
        @java.lang.Override
        public ExclusionRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExclusionRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExclusionRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.ExclusionRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
