/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Request to de-identify a ContentItem.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DeidentifyContentRequest}
 */
public final class DeidentifyContentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DeidentifyContentRequest)
    DeidentifyContentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeidentifyContentRequest.newBuilder() to construct.
  private DeidentifyContentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeidentifyContentRequest() {
    parent_ = "";
    inspectTemplateName_ = "";
    deidentifyTemplateName_ = "";
    locationId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeidentifyContentRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DeidentifyContentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DeidentifyContentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DeidentifyContentRequest.class,
            com.google.privacy.dlp.v2.DeidentifyContentRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Parent resource name.
   * The format of this value varies depending on whether you have [specified a
   * processing
   * location](https://cloud.google.com/dlp/docs/specifying-location):
   * + Projects scope, location specified:&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
   * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
   * The following example `parent` string specifies a parent project with the
   * identifier `example-project`, and specifies the `europe-west3` location
   * for processing data:
   *     parent=projects/example-project/locations/europe-west3
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Parent resource name.
   * The format of this value varies depending on whether you have [specified a
   * processing
   * location](https://cloud.google.com/dlp/docs/specifying-location):
   * + Projects scope, location specified:&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
   * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
   *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
   * The following example `parent` string specifies a parent project with the
   * identifier `example-project`, and specifies the `europe-west3` location
   * for processing data:
   *     parent=projects/example-project/locations/europe-west3
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEIDENTIFY_CONFIG_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.DeidentifyConfig deidentifyConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the de-identification of the content item.
   * Items specified here will override the template referenced by the
   * deidentify_template_name argument.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DeidentifyConfig deidentify_config = 2;</code>
   *
   * @return Whether the deidentifyConfig field is set.
   */
  @java.lang.Override
  public boolean hasDeidentifyConfig() {
    return deidentifyConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the de-identification of the content item.
   * Items specified here will override the template referenced by the
   * deidentify_template_name argument.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DeidentifyConfig deidentify_config = 2;</code>
   *
   * @return The deidentifyConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DeidentifyConfig getDeidentifyConfig() {
    return deidentifyConfig_ == null
        ? com.google.privacy.dlp.v2.DeidentifyConfig.getDefaultInstance()
        : deidentifyConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the de-identification of the content item.
   * Items specified here will override the template referenced by the
   * deidentify_template_name argument.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DeidentifyConfig deidentify_config = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DeidentifyConfigOrBuilder getDeidentifyConfigOrBuilder() {
    return getDeidentifyConfig();
  }

  public static final int INSPECT_CONFIG_FIELD_NUMBER = 3;
  private com.google.privacy.dlp.v2.InspectConfig inspectConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the inspector.
   * Items specified here will override the template referenced by the
   * inspect_template_name argument.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 3;</code>
   *
   * @return Whether the inspectConfig field is set.
   */
  @java.lang.Override
  public boolean hasInspectConfig() {
    return inspectConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the inspector.
   * Items specified here will override the template referenced by the
   * inspect_template_name argument.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 3;</code>
   *
   * @return The inspectConfig.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectConfig getInspectConfig() {
    return inspectConfig_ == null
        ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
        : inspectConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the inspector.
   * Items specified here will override the template referenced by the
   * inspect_template_name argument.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InspectConfigOrBuilder getInspectConfigOrBuilder() {
    return getInspectConfig();
  }

  public static final int ITEM_FIELD_NUMBER = 4;
  private com.google.privacy.dlp.v2.ContentItem item_;
  /**
   *
   *
   * <pre>
   * The item to de-identify. Will be treated as text.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ContentItem item = 4;</code>
   *
   * @return Whether the item field is set.
   */
  @java.lang.Override
  public boolean hasItem() {
    return item_ != null;
  }
  /**
   *
   *
   * <pre>
   * The item to de-identify. Will be treated as text.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ContentItem item = 4;</code>
   *
   * @return The item.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ContentItem getItem() {
    return item_ == null ? com.google.privacy.dlp.v2.ContentItem.getDefaultInstance() : item_;
  }
  /**
   *
   *
   * <pre>
   * The item to de-identify. Will be treated as text.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ContentItem item = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ContentItemOrBuilder getItemOrBuilder() {
    return getItem();
  }

  public static final int INSPECT_TEMPLATE_NAME_FIELD_NUMBER = 5;
  private volatile java.lang.Object inspectTemplateName_;
  /**
   *
   *
   * <pre>
   * Template to use. Any configuration directly specified in
   * inspect_config will override those set in the template. Singular fields
   * that are set in this request will replace their corresponding fields in the
   * template. Repeated fields are appended. Singular sub-messages and groups
   * are recursively merged.
   * </pre>
   *
   * <code>string inspect_template_name = 5;</code>
   *
   * @return The inspectTemplateName.
   */
  @java.lang.Override
  public java.lang.String getInspectTemplateName() {
    java.lang.Object ref = inspectTemplateName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inspectTemplateName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Template to use. Any configuration directly specified in
   * inspect_config will override those set in the template. Singular fields
   * that are set in this request will replace their corresponding fields in the
   * template. Repeated fields are appended. Singular sub-messages and groups
   * are recursively merged.
   * </pre>
   *
   * <code>string inspect_template_name = 5;</code>
   *
   * @return The bytes for inspectTemplateName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInspectTemplateNameBytes() {
    java.lang.Object ref = inspectTemplateName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inspectTemplateName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEIDENTIFY_TEMPLATE_NAME_FIELD_NUMBER = 6;
  private volatile java.lang.Object deidentifyTemplateName_;
  /**
   *
   *
   * <pre>
   * Template to use. Any configuration directly specified in
   * deidentify_config will override those set in the template. Singular fields
   * that are set in this request will replace their corresponding fields in the
   * template. Repeated fields are appended. Singular sub-messages and groups
   * are recursively merged.
   * </pre>
   *
   * <code>string deidentify_template_name = 6;</code>
   *
   * @return The deidentifyTemplateName.
   */
  @java.lang.Override
  public java.lang.String getDeidentifyTemplateName() {
    java.lang.Object ref = deidentifyTemplateName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deidentifyTemplateName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Template to use. Any configuration directly specified in
   * deidentify_config will override those set in the template. Singular fields
   * that are set in this request will replace their corresponding fields in the
   * template. Repeated fields are appended. Singular sub-messages and groups
   * are recursively merged.
   * </pre>
   *
   * <code>string deidentify_template_name = 6;</code>
   *
   * @return The bytes for deidentifyTemplateName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeidentifyTemplateNameBytes() {
    java.lang.Object ref = deidentifyTemplateName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deidentifyTemplateName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_ID_FIELD_NUMBER = 7;
  private volatile java.lang.Object locationId_;
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>string location_id = 7;</code>
   *
   * @return The locationId.
   */
  @java.lang.Override
  public java.lang.String getLocationId() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>string location_id = 7;</code>
   *
   * @return The bytes for locationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationIdBytes() {
    java.lang.Object ref = locationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (deidentifyConfig_ != null) {
      output.writeMessage(2, getDeidentifyConfig());
    }
    if (inspectConfig_ != null) {
      output.writeMessage(3, getInspectConfig());
    }
    if (item_ != null) {
      output.writeMessage(4, getItem());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inspectTemplateName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, inspectTemplateName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deidentifyTemplateName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, deidentifyTemplateName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, locationId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (deidentifyConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDeidentifyConfig());
    }
    if (inspectConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getInspectConfig());
    }
    if (item_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getItem());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inspectTemplateName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, inspectTemplateName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deidentifyTemplateName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, deidentifyTemplateName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(locationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, locationId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DeidentifyContentRequest)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DeidentifyContentRequest other =
        (com.google.privacy.dlp.v2.DeidentifyContentRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasDeidentifyConfig() != other.hasDeidentifyConfig()) return false;
    if (hasDeidentifyConfig()) {
      if (!getDeidentifyConfig().equals(other.getDeidentifyConfig())) return false;
    }
    if (hasInspectConfig() != other.hasInspectConfig()) return false;
    if (hasInspectConfig()) {
      if (!getInspectConfig().equals(other.getInspectConfig())) return false;
    }
    if (hasItem() != other.hasItem()) return false;
    if (hasItem()) {
      if (!getItem().equals(other.getItem())) return false;
    }
    if (!getInspectTemplateName().equals(other.getInspectTemplateName())) return false;
    if (!getDeidentifyTemplateName().equals(other.getDeidentifyTemplateName())) return false;
    if (!getLocationId().equals(other.getLocationId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasDeidentifyConfig()) {
      hash = (37 * hash) + DEIDENTIFY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDeidentifyConfig().hashCode();
    }
    if (hasInspectConfig()) {
      hash = (37 * hash) + INSPECT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInspectConfig().hashCode();
    }
    if (hasItem()) {
      hash = (37 * hash) + ITEM_FIELD_NUMBER;
      hash = (53 * hash) + getItem().hashCode();
    }
    hash = (37 * hash) + INSPECT_TEMPLATE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getInspectTemplateName().hashCode();
    hash = (37 * hash) + DEIDENTIFY_TEMPLATE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDeidentifyTemplateName().hashCode();
    hash = (37 * hash) + LOCATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getLocationId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.DeidentifyContentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request to de-identify a ContentItem.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DeidentifyContentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DeidentifyContentRequest)
      com.google.privacy.dlp.v2.DeidentifyContentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DeidentifyContentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DeidentifyContentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DeidentifyContentRequest.class,
              com.google.privacy.dlp.v2.DeidentifyContentRequest.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DeidentifyContentRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      if (deidentifyConfigBuilder_ == null) {
        deidentifyConfig_ = null;
      } else {
        deidentifyConfig_ = null;
        deidentifyConfigBuilder_ = null;
      }
      if (inspectConfigBuilder_ == null) {
        inspectConfig_ = null;
      } else {
        inspectConfig_ = null;
        inspectConfigBuilder_ = null;
      }
      if (itemBuilder_ == null) {
        item_ = null;
      } else {
        item_ = null;
        itemBuilder_ = null;
      }
      inspectTemplateName_ = "";

      deidentifyTemplateName_ = "";

      locationId_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DeidentifyContentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DeidentifyContentRequest getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DeidentifyContentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DeidentifyContentRequest build() {
      com.google.privacy.dlp.v2.DeidentifyContentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DeidentifyContentRequest buildPartial() {
      com.google.privacy.dlp.v2.DeidentifyContentRequest result =
          new com.google.privacy.dlp.v2.DeidentifyContentRequest(this);
      result.parent_ = parent_;
      if (deidentifyConfigBuilder_ == null) {
        result.deidentifyConfig_ = deidentifyConfig_;
      } else {
        result.deidentifyConfig_ = deidentifyConfigBuilder_.build();
      }
      if (inspectConfigBuilder_ == null) {
        result.inspectConfig_ = inspectConfig_;
      } else {
        result.inspectConfig_ = inspectConfigBuilder_.build();
      }
      if (itemBuilder_ == null) {
        result.item_ = item_;
      } else {
        result.item_ = itemBuilder_.build();
      }
      result.inspectTemplateName_ = inspectTemplateName_;
      result.deidentifyTemplateName_ = deidentifyTemplateName_;
      result.locationId_ = locationId_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DeidentifyContentRequest) {
        return mergeFrom((com.google.privacy.dlp.v2.DeidentifyContentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DeidentifyContentRequest other) {
      if (other == com.google.privacy.dlp.v2.DeidentifyContentRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.hasDeidentifyConfig()) {
        mergeDeidentifyConfig(other.getDeidentifyConfig());
      }
      if (other.hasInspectConfig()) {
        mergeInspectConfig(other.getInspectConfig());
      }
      if (other.hasItem()) {
        mergeItem(other.getItem());
      }
      if (!other.getInspectTemplateName().isEmpty()) {
        inspectTemplateName_ = other.inspectTemplateName_;
        onChanged();
      }
      if (!other.getDeidentifyTemplateName().isEmpty()) {
        deidentifyTemplateName_ = other.deidentifyTemplateName_;
        onChanged();
      }
      if (!other.getLocationId().isEmpty()) {
        locationId_ = other.locationId_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getDeidentifyConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getInspectConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(getItemFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 34
            case 42:
              {
                inspectTemplateName_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                deidentifyTemplateName_ = input.readStringRequireUtf8();

                break;
              } // case 50
            case 58:
              {
                locationId_ = input.readStringRequireUtf8();

                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Parent resource name.
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/dlp/docs/specifying-location):
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parent resource name.
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/dlp/docs/specifying-location):
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parent resource name.
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/dlp/docs/specifying-location):
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parent resource name.
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/dlp/docs/specifying-location):
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parent resource name.
     * The format of this value varies depending on whether you have [specified a
     * processing
     * location](https://cloud.google.com/dlp/docs/specifying-location):
     * + Projects scope, location specified:&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;`/locations/`&lt;var&gt;LOCATION_ID&lt;/var&gt;
     * + Projects scope, no location specified (defaults to global):&lt;br/&gt;
     *   `projects/`&lt;var&gt;PROJECT_ID&lt;/var&gt;
     * The following example `parent` string specifies a parent project with the
     * identifier `example-project`, and specifies the `europe-west3` location
     * for processing data:
     *     parent=projects/example-project/locations/europe-west3
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private com.google.privacy.dlp.v2.DeidentifyConfig deidentifyConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DeidentifyConfig,
            com.google.privacy.dlp.v2.DeidentifyConfig.Builder,
            com.google.privacy.dlp.v2.DeidentifyConfigOrBuilder>
        deidentifyConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the de-identification of the content item.
     * Items specified here will override the template referenced by the
     * deidentify_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DeidentifyConfig deidentify_config = 2;</code>
     *
     * @return Whether the deidentifyConfig field is set.
     */
    public boolean hasDeidentifyConfig() {
      return deidentifyConfigBuilder_ != null || deidentifyConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the de-identification of the content item.
     * Items specified here will override the template referenced by the
     * deidentify_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DeidentifyConfig deidentify_config = 2;</code>
     *
     * @return The deidentifyConfig.
     */
    public com.google.privacy.dlp.v2.DeidentifyConfig getDeidentifyConfig() {
      if (deidentifyConfigBuilder_ == null) {
        return deidentifyConfig_ == null
            ? com.google.privacy.dlp.v2.DeidentifyConfig.getDefaultInstance()
            : deidentifyConfig_;
      } else {
        return deidentifyConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the de-identification of the content item.
     * Items specified here will override the template referenced by the
     * deidentify_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DeidentifyConfig deidentify_config = 2;</code>
     */
    public Builder setDeidentifyConfig(com.google.privacy.dlp.v2.DeidentifyConfig value) {
      if (deidentifyConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deidentifyConfig_ = value;
        onChanged();
      } else {
        deidentifyConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the de-identification of the content item.
     * Items specified here will override the template referenced by the
     * deidentify_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DeidentifyConfig deidentify_config = 2;</code>
     */
    public Builder setDeidentifyConfig(
        com.google.privacy.dlp.v2.DeidentifyConfig.Builder builderForValue) {
      if (deidentifyConfigBuilder_ == null) {
        deidentifyConfig_ = builderForValue.build();
        onChanged();
      } else {
        deidentifyConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the de-identification of the content item.
     * Items specified here will override the template referenced by the
     * deidentify_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DeidentifyConfig deidentify_config = 2;</code>
     */
    public Builder mergeDeidentifyConfig(com.google.privacy.dlp.v2.DeidentifyConfig value) {
      if (deidentifyConfigBuilder_ == null) {
        if (deidentifyConfig_ != null) {
          deidentifyConfig_ =
              com.google.privacy.dlp.v2.DeidentifyConfig.newBuilder(deidentifyConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deidentifyConfig_ = value;
        }
        onChanged();
      } else {
        deidentifyConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the de-identification of the content item.
     * Items specified here will override the template referenced by the
     * deidentify_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DeidentifyConfig deidentify_config = 2;</code>
     */
    public Builder clearDeidentifyConfig() {
      if (deidentifyConfigBuilder_ == null) {
        deidentifyConfig_ = null;
        onChanged();
      } else {
        deidentifyConfig_ = null;
        deidentifyConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the de-identification of the content item.
     * Items specified here will override the template referenced by the
     * deidentify_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DeidentifyConfig deidentify_config = 2;</code>
     */
    public com.google.privacy.dlp.v2.DeidentifyConfig.Builder getDeidentifyConfigBuilder() {

      onChanged();
      return getDeidentifyConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the de-identification of the content item.
     * Items specified here will override the template referenced by the
     * deidentify_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DeidentifyConfig deidentify_config = 2;</code>
     */
    public com.google.privacy.dlp.v2.DeidentifyConfigOrBuilder getDeidentifyConfigOrBuilder() {
      if (deidentifyConfigBuilder_ != null) {
        return deidentifyConfigBuilder_.getMessageOrBuilder();
      } else {
        return deidentifyConfig_ == null
            ? com.google.privacy.dlp.v2.DeidentifyConfig.getDefaultInstance()
            : deidentifyConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the de-identification of the content item.
     * Items specified here will override the template referenced by the
     * deidentify_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DeidentifyConfig deidentify_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DeidentifyConfig,
            com.google.privacy.dlp.v2.DeidentifyConfig.Builder,
            com.google.privacy.dlp.v2.DeidentifyConfigOrBuilder>
        getDeidentifyConfigFieldBuilder() {
      if (deidentifyConfigBuilder_ == null) {
        deidentifyConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DeidentifyConfig,
                com.google.privacy.dlp.v2.DeidentifyConfig.Builder,
                com.google.privacy.dlp.v2.DeidentifyConfigOrBuilder>(
                getDeidentifyConfig(), getParentForChildren(), isClean());
        deidentifyConfig_ = null;
      }
      return deidentifyConfigBuilder_;
    }

    private com.google.privacy.dlp.v2.InspectConfig inspectConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectConfig,
            com.google.privacy.dlp.v2.InspectConfig.Builder,
            com.google.privacy.dlp.v2.InspectConfigOrBuilder>
        inspectConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * Items specified here will override the template referenced by the
     * inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 3;</code>
     *
     * @return Whether the inspectConfig field is set.
     */
    public boolean hasInspectConfig() {
      return inspectConfigBuilder_ != null || inspectConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * Items specified here will override the template referenced by the
     * inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 3;</code>
     *
     * @return The inspectConfig.
     */
    public com.google.privacy.dlp.v2.InspectConfig getInspectConfig() {
      if (inspectConfigBuilder_ == null) {
        return inspectConfig_ == null
            ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
            : inspectConfig_;
      } else {
        return inspectConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * Items specified here will override the template referenced by the
     * inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 3;</code>
     */
    public Builder setInspectConfig(com.google.privacy.dlp.v2.InspectConfig value) {
      if (inspectConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inspectConfig_ = value;
        onChanged();
      } else {
        inspectConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * Items specified here will override the template referenced by the
     * inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 3;</code>
     */
    public Builder setInspectConfig(
        com.google.privacy.dlp.v2.InspectConfig.Builder builderForValue) {
      if (inspectConfigBuilder_ == null) {
        inspectConfig_ = builderForValue.build();
        onChanged();
      } else {
        inspectConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * Items specified here will override the template referenced by the
     * inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 3;</code>
     */
    public Builder mergeInspectConfig(com.google.privacy.dlp.v2.InspectConfig value) {
      if (inspectConfigBuilder_ == null) {
        if (inspectConfig_ != null) {
          inspectConfig_ =
              com.google.privacy.dlp.v2.InspectConfig.newBuilder(inspectConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          inspectConfig_ = value;
        }
        onChanged();
      } else {
        inspectConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * Items specified here will override the template referenced by the
     * inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 3;</code>
     */
    public Builder clearInspectConfig() {
      if (inspectConfigBuilder_ == null) {
        inspectConfig_ = null;
        onChanged();
      } else {
        inspectConfig_ = null;
        inspectConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * Items specified here will override the template referenced by the
     * inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 3;</code>
     */
    public com.google.privacy.dlp.v2.InspectConfig.Builder getInspectConfigBuilder() {

      onChanged();
      return getInspectConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * Items specified here will override the template referenced by the
     * inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 3;</code>
     */
    public com.google.privacy.dlp.v2.InspectConfigOrBuilder getInspectConfigOrBuilder() {
      if (inspectConfigBuilder_ != null) {
        return inspectConfigBuilder_.getMessageOrBuilder();
      } else {
        return inspectConfig_ == null
            ? com.google.privacy.dlp.v2.InspectConfig.getDefaultInstance()
            : inspectConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the inspector.
     * Items specified here will override the template referenced by the
     * inspect_template_name argument.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InspectConfig inspect_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InspectConfig,
            com.google.privacy.dlp.v2.InspectConfig.Builder,
            com.google.privacy.dlp.v2.InspectConfigOrBuilder>
        getInspectConfigFieldBuilder() {
      if (inspectConfigBuilder_ == null) {
        inspectConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InspectConfig,
                com.google.privacy.dlp.v2.InspectConfig.Builder,
                com.google.privacy.dlp.v2.InspectConfigOrBuilder>(
                getInspectConfig(), getParentForChildren(), isClean());
        inspectConfig_ = null;
      }
      return inspectConfigBuilder_;
    }

    private com.google.privacy.dlp.v2.ContentItem item_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ContentItem,
            com.google.privacy.dlp.v2.ContentItem.Builder,
            com.google.privacy.dlp.v2.ContentItemOrBuilder>
        itemBuilder_;
    /**
     *
     *
     * <pre>
     * The item to de-identify. Will be treated as text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 4;</code>
     *
     * @return Whether the item field is set.
     */
    public boolean hasItem() {
      return itemBuilder_ != null || item_ != null;
    }
    /**
     *
     *
     * <pre>
     * The item to de-identify. Will be treated as text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 4;</code>
     *
     * @return The item.
     */
    public com.google.privacy.dlp.v2.ContentItem getItem() {
      if (itemBuilder_ == null) {
        return item_ == null ? com.google.privacy.dlp.v2.ContentItem.getDefaultInstance() : item_;
      } else {
        return itemBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The item to de-identify. Will be treated as text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 4;</code>
     */
    public Builder setItem(com.google.privacy.dlp.v2.ContentItem value) {
      if (itemBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        item_ = value;
        onChanged();
      } else {
        itemBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The item to de-identify. Will be treated as text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 4;</code>
     */
    public Builder setItem(com.google.privacy.dlp.v2.ContentItem.Builder builderForValue) {
      if (itemBuilder_ == null) {
        item_ = builderForValue.build();
        onChanged();
      } else {
        itemBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The item to de-identify. Will be treated as text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 4;</code>
     */
    public Builder mergeItem(com.google.privacy.dlp.v2.ContentItem value) {
      if (itemBuilder_ == null) {
        if (item_ != null) {
          item_ =
              com.google.privacy.dlp.v2.ContentItem.newBuilder(item_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          item_ = value;
        }
        onChanged();
      } else {
        itemBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The item to de-identify. Will be treated as text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 4;</code>
     */
    public Builder clearItem() {
      if (itemBuilder_ == null) {
        item_ = null;
        onChanged();
      } else {
        item_ = null;
        itemBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The item to de-identify. Will be treated as text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 4;</code>
     */
    public com.google.privacy.dlp.v2.ContentItem.Builder getItemBuilder() {

      onChanged();
      return getItemFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The item to de-identify. Will be treated as text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 4;</code>
     */
    public com.google.privacy.dlp.v2.ContentItemOrBuilder getItemOrBuilder() {
      if (itemBuilder_ != null) {
        return itemBuilder_.getMessageOrBuilder();
      } else {
        return item_ == null ? com.google.privacy.dlp.v2.ContentItem.getDefaultInstance() : item_;
      }
    }
    /**
     *
     *
     * <pre>
     * The item to de-identify. Will be treated as text.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ContentItem item = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ContentItem,
            com.google.privacy.dlp.v2.ContentItem.Builder,
            com.google.privacy.dlp.v2.ContentItemOrBuilder>
        getItemFieldBuilder() {
      if (itemBuilder_ == null) {
        itemBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.ContentItem,
                com.google.privacy.dlp.v2.ContentItem.Builder,
                com.google.privacy.dlp.v2.ContentItemOrBuilder>(
                getItem(), getParentForChildren(), isClean());
        item_ = null;
      }
      return itemBuilder_;
    }

    private java.lang.Object inspectTemplateName_ = "";
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * inspect_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string inspect_template_name = 5;</code>
     *
     * @return The inspectTemplateName.
     */
    public java.lang.String getInspectTemplateName() {
      java.lang.Object ref = inspectTemplateName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inspectTemplateName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * inspect_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string inspect_template_name = 5;</code>
     *
     * @return The bytes for inspectTemplateName.
     */
    public com.google.protobuf.ByteString getInspectTemplateNameBytes() {
      java.lang.Object ref = inspectTemplateName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inspectTemplateName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * inspect_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string inspect_template_name = 5;</code>
     *
     * @param value The inspectTemplateName to set.
     * @return This builder for chaining.
     */
    public Builder setInspectTemplateName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      inspectTemplateName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * inspect_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string inspect_template_name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInspectTemplateName() {

      inspectTemplateName_ = getDefaultInstance().getInspectTemplateName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * inspect_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string inspect_template_name = 5;</code>
     *
     * @param value The bytes for inspectTemplateName to set.
     * @return This builder for chaining.
     */
    public Builder setInspectTemplateNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      inspectTemplateName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object deidentifyTemplateName_ = "";
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * deidentify_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string deidentify_template_name = 6;</code>
     *
     * @return The deidentifyTemplateName.
     */
    public java.lang.String getDeidentifyTemplateName() {
      java.lang.Object ref = deidentifyTemplateName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deidentifyTemplateName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * deidentify_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string deidentify_template_name = 6;</code>
     *
     * @return The bytes for deidentifyTemplateName.
     */
    public com.google.protobuf.ByteString getDeidentifyTemplateNameBytes() {
      java.lang.Object ref = deidentifyTemplateName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deidentifyTemplateName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * deidentify_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string deidentify_template_name = 6;</code>
     *
     * @param value The deidentifyTemplateName to set.
     * @return This builder for chaining.
     */
    public Builder setDeidentifyTemplateName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      deidentifyTemplateName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * deidentify_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string deidentify_template_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeidentifyTemplateName() {

      deidentifyTemplateName_ = getDefaultInstance().getDeidentifyTemplateName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Template to use. Any configuration directly specified in
     * deidentify_config will override those set in the template. Singular fields
     * that are set in this request will replace their corresponding fields in the
     * template. Repeated fields are appended. Singular sub-messages and groups
     * are recursively merged.
     * </pre>
     *
     * <code>string deidentify_template_name = 6;</code>
     *
     * @param value The bytes for deidentifyTemplateName to set.
     * @return This builder for chaining.
     */
    public Builder setDeidentifyTemplateNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      deidentifyTemplateName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object locationId_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 7;</code>
     *
     * @return The locationId.
     */
    public java.lang.String getLocationId() {
      java.lang.Object ref = locationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 7;</code>
     *
     * @return The bytes for locationId.
     */
    public com.google.protobuf.ByteString getLocationIdBytes() {
      java.lang.Object ref = locationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 7;</code>
     *
     * @param value The locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      locationId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationId() {

      locationId_ = getDefaultInstance().getLocationId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>string location_id = 7;</code>
     *
     * @param value The bytes for locationId to set.
     * @return This builder for chaining.
     */
    public Builder setLocationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      locationId_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DeidentifyContentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DeidentifyContentRequest)
  private static final com.google.privacy.dlp.v2.DeidentifyContentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DeidentifyContentRequest();
  }

  public static com.google.privacy.dlp.v2.DeidentifyContentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeidentifyContentRequest> PARSER =
      new com.google.protobuf.AbstractParser<DeidentifyContentRequest>() {
        @java.lang.Override
        public DeidentifyContentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeidentifyContentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeidentifyContentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DeidentifyContentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
