/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * The configuration that controls how the data will change.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DeidentifyConfig}
 */
public final class DeidentifyConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DeidentifyConfig)
    DeidentifyConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeidentifyConfig.newBuilder() to construct.
  private DeidentifyConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeidentifyConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeidentifyConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DeidentifyConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DeidentifyConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DeidentifyConfig.class,
            com.google.privacy.dlp.v2.DeidentifyConfig.Builder.class);
  }

  private int transformationCase_ = 0;
  private java.lang.Object transformation_;

  public enum TransformationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INFO_TYPE_TRANSFORMATIONS(1),
    RECORD_TRANSFORMATIONS(2),
    IMAGE_TRANSFORMATIONS(4),
    TRANSFORMATION_NOT_SET(0);
    private final int value;

    private TransformationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransformationCase valueOf(int value) {
      return forNumber(value);
    }

    public static TransformationCase forNumber(int value) {
      switch (value) {
        case 1:
          return INFO_TYPE_TRANSFORMATIONS;
        case 2:
          return RECORD_TRANSFORMATIONS;
        case 4:
          return IMAGE_TRANSFORMATIONS;
        case 0:
          return TRANSFORMATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TransformationCase getTransformationCase() {
    return TransformationCase.forNumber(transformationCase_);
  }

  public static final int INFO_TYPE_TRANSFORMATIONS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Treat the dataset as free-form text and apply the same free text
   * transformation everywhere.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 1;</code>
   *
   * @return Whether the infoTypeTransformations field is set.
   */
  @java.lang.Override
  public boolean hasInfoTypeTransformations() {
    return transformationCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Treat the dataset as free-form text and apply the same free text
   * transformation everywhere.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 1;</code>
   *
   * @return The infoTypeTransformations.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeTransformations getInfoTypeTransformations() {
    if (transformationCase_ == 1) {
      return (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_;
    }
    return com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Treat the dataset as free-form text and apply the same free text
   * transformation everywhere.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeTransformationsOrBuilder
      getInfoTypeTransformationsOrBuilder() {
    if (transformationCase_ == 1) {
      return (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_;
    }
    return com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
  }

  public static final int RECORD_TRANSFORMATIONS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Treat the dataset as structured. Transformations can be applied to
   * specific locations within structured datasets, such as transforming
   * a column within a table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordTransformations record_transformations = 2;</code>
   *
   * @return Whether the recordTransformations field is set.
   */
  @java.lang.Override
  public boolean hasRecordTransformations() {
    return transformationCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Treat the dataset as structured. Transformations can be applied to
   * specific locations within structured datasets, such as transforming
   * a column within a table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordTransformations record_transformations = 2;</code>
   *
   * @return The recordTransformations.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordTransformations getRecordTransformations() {
    if (transformationCase_ == 2) {
      return (com.google.privacy.dlp.v2.RecordTransformations) transformation_;
    }
    return com.google.privacy.dlp.v2.RecordTransformations.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Treat the dataset as structured. Transformations can be applied to
   * specific locations within structured datasets, such as transforming
   * a column within a table.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.RecordTransformations record_transformations = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.RecordTransformationsOrBuilder
      getRecordTransformationsOrBuilder() {
    if (transformationCase_ == 2) {
      return (com.google.privacy.dlp.v2.RecordTransformations) transformation_;
    }
    return com.google.privacy.dlp.v2.RecordTransformations.getDefaultInstance();
  }

  public static final int IMAGE_TRANSFORMATIONS_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Treat the dataset as an image and redact.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ImageTransformations image_transformations = 4;</code>
   *
   * @return Whether the imageTransformations field is set.
   */
  @java.lang.Override
  public boolean hasImageTransformations() {
    return transformationCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Treat the dataset as an image and redact.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ImageTransformations image_transformations = 4;</code>
   *
   * @return The imageTransformations.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ImageTransformations getImageTransformations() {
    if (transformationCase_ == 4) {
      return (com.google.privacy.dlp.v2.ImageTransformations) transformation_;
    }
    return com.google.privacy.dlp.v2.ImageTransformations.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Treat the dataset as an image and redact.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.ImageTransformations image_transformations = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.ImageTransformationsOrBuilder
      getImageTransformationsOrBuilder() {
    if (transformationCase_ == 4) {
      return (com.google.privacy.dlp.v2.ImageTransformations) transformation_;
    }
    return com.google.privacy.dlp.v2.ImageTransformations.getDefaultInstance();
  }

  public static final int TRANSFORMATION_ERROR_HANDLING_FIELD_NUMBER = 3;
  private com.google.privacy.dlp.v2.TransformationErrorHandling transformationErrorHandling_;
  /**
   *
   *
   * <pre>
   * Mode for handling transformation errors. If left unspecified, the default
   * mode is `TransformationErrorHandling.ThrowError`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationErrorHandling transformation_error_handling = 3;
   * </code>
   *
   * @return Whether the transformationErrorHandling field is set.
   */
  @java.lang.Override
  public boolean hasTransformationErrorHandling() {
    return transformationErrorHandling_ != null;
  }
  /**
   *
   *
   * <pre>
   * Mode for handling transformation errors. If left unspecified, the default
   * mode is `TransformationErrorHandling.ThrowError`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationErrorHandling transformation_error_handling = 3;
   * </code>
   *
   * @return The transformationErrorHandling.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationErrorHandling getTransformationErrorHandling() {
    return transformationErrorHandling_ == null
        ? com.google.privacy.dlp.v2.TransformationErrorHandling.getDefaultInstance()
        : transformationErrorHandling_;
  }
  /**
   *
   *
   * <pre>
   * Mode for handling transformation errors. If left unspecified, the default
   * mode is `TransformationErrorHandling.ThrowError`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.TransformationErrorHandling transformation_error_handling = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.TransformationErrorHandlingOrBuilder
      getTransformationErrorHandlingOrBuilder() {
    return getTransformationErrorHandling();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (transformationCase_ == 1) {
      output.writeMessage(1, (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_);
    }
    if (transformationCase_ == 2) {
      output.writeMessage(2, (com.google.privacy.dlp.v2.RecordTransformations) transformation_);
    }
    if (transformationErrorHandling_ != null) {
      output.writeMessage(3, getTransformationErrorHandling());
    }
    if (transformationCase_ == 4) {
      output.writeMessage(4, (com.google.privacy.dlp.v2.ImageTransformations) transformation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (transformationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_);
    }
    if (transformationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.RecordTransformations) transformation_);
    }
    if (transformationErrorHandling_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getTransformationErrorHandling());
    }
    if (transformationCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.privacy.dlp.v2.ImageTransformations) transformation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DeidentifyConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DeidentifyConfig other =
        (com.google.privacy.dlp.v2.DeidentifyConfig) obj;

    if (hasTransformationErrorHandling() != other.hasTransformationErrorHandling()) return false;
    if (hasTransformationErrorHandling()) {
      if (!getTransformationErrorHandling().equals(other.getTransformationErrorHandling()))
        return false;
    }
    if (!getTransformationCase().equals(other.getTransformationCase())) return false;
    switch (transformationCase_) {
      case 1:
        if (!getInfoTypeTransformations().equals(other.getInfoTypeTransformations())) return false;
        break;
      case 2:
        if (!getRecordTransformations().equals(other.getRecordTransformations())) return false;
        break;
      case 4:
        if (!getImageTransformations().equals(other.getImageTransformations())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasTransformationErrorHandling()) {
      hash = (37 * hash) + TRANSFORMATION_ERROR_HANDLING_FIELD_NUMBER;
      hash = (53 * hash) + getTransformationErrorHandling().hashCode();
    }
    switch (transformationCase_) {
      case 1:
        hash = (37 * hash) + INFO_TYPE_TRANSFORMATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getInfoTypeTransformations().hashCode();
        break;
      case 2:
        hash = (37 * hash) + RECORD_TRANSFORMATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getRecordTransformations().hashCode();
        break;
      case 4:
        hash = (37 * hash) + IMAGE_TRANSFORMATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getImageTransformations().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.DeidentifyConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration that controls how the data will change.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DeidentifyConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DeidentifyConfig)
      com.google.privacy.dlp.v2.DeidentifyConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DeidentifyConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DeidentifyConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DeidentifyConfig.class,
              com.google.privacy.dlp.v2.DeidentifyConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DeidentifyConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (infoTypeTransformationsBuilder_ != null) {
        infoTypeTransformationsBuilder_.clear();
      }
      if (recordTransformationsBuilder_ != null) {
        recordTransformationsBuilder_.clear();
      }
      if (imageTransformationsBuilder_ != null) {
        imageTransformationsBuilder_.clear();
      }
      if (transformationErrorHandlingBuilder_ == null) {
        transformationErrorHandling_ = null;
      } else {
        transformationErrorHandling_ = null;
        transformationErrorHandlingBuilder_ = null;
      }
      transformationCase_ = 0;
      transformation_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DeidentifyConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DeidentifyConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DeidentifyConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DeidentifyConfig build() {
      com.google.privacy.dlp.v2.DeidentifyConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DeidentifyConfig buildPartial() {
      com.google.privacy.dlp.v2.DeidentifyConfig result =
          new com.google.privacy.dlp.v2.DeidentifyConfig(this);
      if (transformationCase_ == 1) {
        if (infoTypeTransformationsBuilder_ == null) {
          result.transformation_ = transformation_;
        } else {
          result.transformation_ = infoTypeTransformationsBuilder_.build();
        }
      }
      if (transformationCase_ == 2) {
        if (recordTransformationsBuilder_ == null) {
          result.transformation_ = transformation_;
        } else {
          result.transformation_ = recordTransformationsBuilder_.build();
        }
      }
      if (transformationCase_ == 4) {
        if (imageTransformationsBuilder_ == null) {
          result.transformation_ = transformation_;
        } else {
          result.transformation_ = imageTransformationsBuilder_.build();
        }
      }
      if (transformationErrorHandlingBuilder_ == null) {
        result.transformationErrorHandling_ = transformationErrorHandling_;
      } else {
        result.transformationErrorHandling_ = transformationErrorHandlingBuilder_.build();
      }
      result.transformationCase_ = transformationCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DeidentifyConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.DeidentifyConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DeidentifyConfig other) {
      if (other == com.google.privacy.dlp.v2.DeidentifyConfig.getDefaultInstance()) return this;
      if (other.hasTransformationErrorHandling()) {
        mergeTransformationErrorHandling(other.getTransformationErrorHandling());
      }
      switch (other.getTransformationCase()) {
        case INFO_TYPE_TRANSFORMATIONS:
          {
            mergeInfoTypeTransformations(other.getInfoTypeTransformations());
            break;
          }
        case RECORD_TRANSFORMATIONS:
          {
            mergeRecordTransformations(other.getRecordTransformations());
            break;
          }
        case IMAGE_TRANSFORMATIONS:
          {
            mergeImageTransformations(other.getImageTransformations());
            break;
          }
        case TRANSFORMATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getInfoTypeTransformationsFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getRecordTransformationsFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getTransformationErrorHandlingFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getImageTransformationsFieldBuilder().getBuilder(), extensionRegistry);
                transformationCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int transformationCase_ = 0;
    private java.lang.Object transformation_;

    public TransformationCase getTransformationCase() {
      return TransformationCase.forNumber(transformationCase_);
    }

    public Builder clearTransformation() {
      transformationCase_ = 0;
      transformation_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoTypeTransformations,
            com.google.privacy.dlp.v2.InfoTypeTransformations.Builder,
            com.google.privacy.dlp.v2.InfoTypeTransformationsOrBuilder>
        infoTypeTransformationsBuilder_;
    /**
     *
     *
     * <pre>
     * Treat the dataset as free-form text and apply the same free text
     * transformation everywhere.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 1;</code>
     *
     * @return Whether the infoTypeTransformations field is set.
     */
    @java.lang.Override
    public boolean hasInfoTypeTransformations() {
      return transformationCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as free-form text and apply the same free text
     * transformation everywhere.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 1;</code>
     *
     * @return The infoTypeTransformations.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeTransformations getInfoTypeTransformations() {
      if (infoTypeTransformationsBuilder_ == null) {
        if (transformationCase_ == 1) {
          return (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_;
        }
        return com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
      } else {
        if (transformationCase_ == 1) {
          return infoTypeTransformationsBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as free-form text and apply the same free text
     * transformation everywhere.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 1;</code>
     */
    public Builder setInfoTypeTransformations(
        com.google.privacy.dlp.v2.InfoTypeTransformations value) {
      if (infoTypeTransformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        infoTypeTransformationsBuilder_.setMessage(value);
      }
      transformationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as free-form text and apply the same free text
     * transformation everywhere.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 1;</code>
     */
    public Builder setInfoTypeTransformations(
        com.google.privacy.dlp.v2.InfoTypeTransformations.Builder builderForValue) {
      if (infoTypeTransformationsBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        infoTypeTransformationsBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as free-form text and apply the same free text
     * transformation everywhere.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 1;</code>
     */
    public Builder mergeInfoTypeTransformations(
        com.google.privacy.dlp.v2.InfoTypeTransformations value) {
      if (infoTypeTransformationsBuilder_ == null) {
        if (transformationCase_ == 1
            && transformation_
                != com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.InfoTypeTransformations.newBuilder(
                      (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 1) {
          infoTypeTransformationsBuilder_.mergeFrom(value);
        } else {
          infoTypeTransformationsBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as free-form text and apply the same free text
     * transformation everywhere.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 1;</code>
     */
    public Builder clearInfoTypeTransformations() {
      if (infoTypeTransformationsBuilder_ == null) {
        if (transformationCase_ == 1) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 1) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        infoTypeTransformationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as free-form text and apply the same free text
     * transformation everywhere.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 1;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeTransformations.Builder
        getInfoTypeTransformationsBuilder() {
      return getInfoTypeTransformationsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as free-form text and apply the same free text
     * transformation everywhere.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.InfoTypeTransformationsOrBuilder
        getInfoTypeTransformationsOrBuilder() {
      if ((transformationCase_ == 1) && (infoTypeTransformationsBuilder_ != null)) {
        return infoTypeTransformationsBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 1) {
          return (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_;
        }
        return com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as free-form text and apply the same free text
     * transformation everywhere.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoTypeTransformations info_type_transformations = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoTypeTransformations,
            com.google.privacy.dlp.v2.InfoTypeTransformations.Builder,
            com.google.privacy.dlp.v2.InfoTypeTransformationsOrBuilder>
        getInfoTypeTransformationsFieldBuilder() {
      if (infoTypeTransformationsBuilder_ == null) {
        if (!(transformationCase_ == 1)) {
          transformation_ = com.google.privacy.dlp.v2.InfoTypeTransformations.getDefaultInstance();
        }
        infoTypeTransformationsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoTypeTransformations,
                com.google.privacy.dlp.v2.InfoTypeTransformations.Builder,
                com.google.privacy.dlp.v2.InfoTypeTransformationsOrBuilder>(
                (com.google.privacy.dlp.v2.InfoTypeTransformations) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 1;
      onChanged();
      ;
      return infoTypeTransformationsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RecordTransformations,
            com.google.privacy.dlp.v2.RecordTransformations.Builder,
            com.google.privacy.dlp.v2.RecordTransformationsOrBuilder>
        recordTransformationsBuilder_;
    /**
     *
     *
     * <pre>
     * Treat the dataset as structured. Transformations can be applied to
     * specific locations within structured datasets, such as transforming
     * a column within a table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformations record_transformations = 2;</code>
     *
     * @return Whether the recordTransformations field is set.
     */
    @java.lang.Override
    public boolean hasRecordTransformations() {
      return transformationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as structured. Transformations can be applied to
     * specific locations within structured datasets, such as transforming
     * a column within a table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformations record_transformations = 2;</code>
     *
     * @return The recordTransformations.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordTransformations getRecordTransformations() {
      if (recordTransformationsBuilder_ == null) {
        if (transformationCase_ == 2) {
          return (com.google.privacy.dlp.v2.RecordTransformations) transformation_;
        }
        return com.google.privacy.dlp.v2.RecordTransformations.getDefaultInstance();
      } else {
        if (transformationCase_ == 2) {
          return recordTransformationsBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.RecordTransformations.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as structured. Transformations can be applied to
     * specific locations within structured datasets, such as transforming
     * a column within a table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformations record_transformations = 2;</code>
     */
    public Builder setRecordTransformations(com.google.privacy.dlp.v2.RecordTransformations value) {
      if (recordTransformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        recordTransformationsBuilder_.setMessage(value);
      }
      transformationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as structured. Transformations can be applied to
     * specific locations within structured datasets, such as transforming
     * a column within a table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformations record_transformations = 2;</code>
     */
    public Builder setRecordTransformations(
        com.google.privacy.dlp.v2.RecordTransformations.Builder builderForValue) {
      if (recordTransformationsBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        recordTransformationsBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as structured. Transformations can be applied to
     * specific locations within structured datasets, such as transforming
     * a column within a table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformations record_transformations = 2;</code>
     */
    public Builder mergeRecordTransformations(
        com.google.privacy.dlp.v2.RecordTransformations value) {
      if (recordTransformationsBuilder_ == null) {
        if (transformationCase_ == 2
            && transformation_
                != com.google.privacy.dlp.v2.RecordTransformations.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.RecordTransformations.newBuilder(
                      (com.google.privacy.dlp.v2.RecordTransformations) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 2) {
          recordTransformationsBuilder_.mergeFrom(value);
        } else {
          recordTransformationsBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as structured. Transformations can be applied to
     * specific locations within structured datasets, such as transforming
     * a column within a table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformations record_transformations = 2;</code>
     */
    public Builder clearRecordTransformations() {
      if (recordTransformationsBuilder_ == null) {
        if (transformationCase_ == 2) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 2) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        recordTransformationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as structured. Transformations can be applied to
     * specific locations within structured datasets, such as transforming
     * a column within a table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformations record_transformations = 2;</code>
     */
    public com.google.privacy.dlp.v2.RecordTransformations.Builder
        getRecordTransformationsBuilder() {
      return getRecordTransformationsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as structured. Transformations can be applied to
     * specific locations within structured datasets, such as transforming
     * a column within a table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformations record_transformations = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.RecordTransformationsOrBuilder
        getRecordTransformationsOrBuilder() {
      if ((transformationCase_ == 2) && (recordTransformationsBuilder_ != null)) {
        return recordTransformationsBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 2) {
          return (com.google.privacy.dlp.v2.RecordTransformations) transformation_;
        }
        return com.google.privacy.dlp.v2.RecordTransformations.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as structured. Transformations can be applied to
     * specific locations within structured datasets, such as transforming
     * a column within a table.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.RecordTransformations record_transformations = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.RecordTransformations,
            com.google.privacy.dlp.v2.RecordTransformations.Builder,
            com.google.privacy.dlp.v2.RecordTransformationsOrBuilder>
        getRecordTransformationsFieldBuilder() {
      if (recordTransformationsBuilder_ == null) {
        if (!(transformationCase_ == 2)) {
          transformation_ = com.google.privacy.dlp.v2.RecordTransformations.getDefaultInstance();
        }
        recordTransformationsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.RecordTransformations,
                com.google.privacy.dlp.v2.RecordTransformations.Builder,
                com.google.privacy.dlp.v2.RecordTransformationsOrBuilder>(
                (com.google.privacy.dlp.v2.RecordTransformations) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 2;
      onChanged();
      ;
      return recordTransformationsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ImageTransformations,
            com.google.privacy.dlp.v2.ImageTransformations.Builder,
            com.google.privacy.dlp.v2.ImageTransformationsOrBuilder>
        imageTransformationsBuilder_;
    /**
     *
     *
     * <pre>
     * Treat the dataset as an image and redact.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageTransformations image_transformations = 4;</code>
     *
     * @return Whether the imageTransformations field is set.
     */
    @java.lang.Override
    public boolean hasImageTransformations() {
      return transformationCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as an image and redact.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageTransformations image_transformations = 4;</code>
     *
     * @return The imageTransformations.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ImageTransformations getImageTransformations() {
      if (imageTransformationsBuilder_ == null) {
        if (transformationCase_ == 4) {
          return (com.google.privacy.dlp.v2.ImageTransformations) transformation_;
        }
        return com.google.privacy.dlp.v2.ImageTransformations.getDefaultInstance();
      } else {
        if (transformationCase_ == 4) {
          return imageTransformationsBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.ImageTransformations.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as an image and redact.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageTransformations image_transformations = 4;</code>
     */
    public Builder setImageTransformations(com.google.privacy.dlp.v2.ImageTransformations value) {
      if (imageTransformationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformation_ = value;
        onChanged();
      } else {
        imageTransformationsBuilder_.setMessage(value);
      }
      transformationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as an image and redact.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageTransformations image_transformations = 4;</code>
     */
    public Builder setImageTransformations(
        com.google.privacy.dlp.v2.ImageTransformations.Builder builderForValue) {
      if (imageTransformationsBuilder_ == null) {
        transformation_ = builderForValue.build();
        onChanged();
      } else {
        imageTransformationsBuilder_.setMessage(builderForValue.build());
      }
      transformationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as an image and redact.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageTransformations image_transformations = 4;</code>
     */
    public Builder mergeImageTransformations(com.google.privacy.dlp.v2.ImageTransformations value) {
      if (imageTransformationsBuilder_ == null) {
        if (transformationCase_ == 4
            && transformation_
                != com.google.privacy.dlp.v2.ImageTransformations.getDefaultInstance()) {
          transformation_ =
              com.google.privacy.dlp.v2.ImageTransformations.newBuilder(
                      (com.google.privacy.dlp.v2.ImageTransformations) transformation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformation_ = value;
        }
        onChanged();
      } else {
        if (transformationCase_ == 4) {
          imageTransformationsBuilder_.mergeFrom(value);
        } else {
          imageTransformationsBuilder_.setMessage(value);
        }
      }
      transformationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as an image and redact.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageTransformations image_transformations = 4;</code>
     */
    public Builder clearImageTransformations() {
      if (imageTransformationsBuilder_ == null) {
        if (transformationCase_ == 4) {
          transformationCase_ = 0;
          transformation_ = null;
          onChanged();
        }
      } else {
        if (transformationCase_ == 4) {
          transformationCase_ = 0;
          transformation_ = null;
        }
        imageTransformationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as an image and redact.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageTransformations image_transformations = 4;</code>
     */
    public com.google.privacy.dlp.v2.ImageTransformations.Builder getImageTransformationsBuilder() {
      return getImageTransformationsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as an image and redact.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageTransformations image_transformations = 4;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.ImageTransformationsOrBuilder
        getImageTransformationsOrBuilder() {
      if ((transformationCase_ == 4) && (imageTransformationsBuilder_ != null)) {
        return imageTransformationsBuilder_.getMessageOrBuilder();
      } else {
        if (transformationCase_ == 4) {
          return (com.google.privacy.dlp.v2.ImageTransformations) transformation_;
        }
        return com.google.privacy.dlp.v2.ImageTransformations.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Treat the dataset as an image and redact.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.ImageTransformations image_transformations = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.ImageTransformations,
            com.google.privacy.dlp.v2.ImageTransformations.Builder,
            com.google.privacy.dlp.v2.ImageTransformationsOrBuilder>
        getImageTransformationsFieldBuilder() {
      if (imageTransformationsBuilder_ == null) {
        if (!(transformationCase_ == 4)) {
          transformation_ = com.google.privacy.dlp.v2.ImageTransformations.getDefaultInstance();
        }
        imageTransformationsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.ImageTransformations,
                com.google.privacy.dlp.v2.ImageTransformations.Builder,
                com.google.privacy.dlp.v2.ImageTransformationsOrBuilder>(
                (com.google.privacy.dlp.v2.ImageTransformations) transformation_,
                getParentForChildren(),
                isClean());
        transformation_ = null;
      }
      transformationCase_ = 4;
      onChanged();
      ;
      return imageTransformationsBuilder_;
    }

    private com.google.privacy.dlp.v2.TransformationErrorHandling transformationErrorHandling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationErrorHandling,
            com.google.privacy.dlp.v2.TransformationErrorHandling.Builder,
            com.google.privacy.dlp.v2.TransformationErrorHandlingOrBuilder>
        transformationErrorHandlingBuilder_;
    /**
     *
     *
     * <pre>
     * Mode for handling transformation errors. If left unspecified, the default
     * mode is `TransformationErrorHandling.ThrowError`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling transformation_error_handling = 3;
     * </code>
     *
     * @return Whether the transformationErrorHandling field is set.
     */
    public boolean hasTransformationErrorHandling() {
      return transformationErrorHandlingBuilder_ != null || transformationErrorHandling_ != null;
    }
    /**
     *
     *
     * <pre>
     * Mode for handling transformation errors. If left unspecified, the default
     * mode is `TransformationErrorHandling.ThrowError`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling transformation_error_handling = 3;
     * </code>
     *
     * @return The transformationErrorHandling.
     */
    public com.google.privacy.dlp.v2.TransformationErrorHandling getTransformationErrorHandling() {
      if (transformationErrorHandlingBuilder_ == null) {
        return transformationErrorHandling_ == null
            ? com.google.privacy.dlp.v2.TransformationErrorHandling.getDefaultInstance()
            : transformationErrorHandling_;
      } else {
        return transformationErrorHandlingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Mode for handling transformation errors. If left unspecified, the default
     * mode is `TransformationErrorHandling.ThrowError`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling transformation_error_handling = 3;
     * </code>
     */
    public Builder setTransformationErrorHandling(
        com.google.privacy.dlp.v2.TransformationErrorHandling value) {
      if (transformationErrorHandlingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformationErrorHandling_ = value;
        onChanged();
      } else {
        transformationErrorHandlingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Mode for handling transformation errors. If left unspecified, the default
     * mode is `TransformationErrorHandling.ThrowError`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling transformation_error_handling = 3;
     * </code>
     */
    public Builder setTransformationErrorHandling(
        com.google.privacy.dlp.v2.TransformationErrorHandling.Builder builderForValue) {
      if (transformationErrorHandlingBuilder_ == null) {
        transformationErrorHandling_ = builderForValue.build();
        onChanged();
      } else {
        transformationErrorHandlingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Mode for handling transformation errors. If left unspecified, the default
     * mode is `TransformationErrorHandling.ThrowError`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling transformation_error_handling = 3;
     * </code>
     */
    public Builder mergeTransformationErrorHandling(
        com.google.privacy.dlp.v2.TransformationErrorHandling value) {
      if (transformationErrorHandlingBuilder_ == null) {
        if (transformationErrorHandling_ != null) {
          transformationErrorHandling_ =
              com.google.privacy.dlp.v2.TransformationErrorHandling.newBuilder(
                      transformationErrorHandling_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformationErrorHandling_ = value;
        }
        onChanged();
      } else {
        transformationErrorHandlingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Mode for handling transformation errors. If left unspecified, the default
     * mode is `TransformationErrorHandling.ThrowError`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling transformation_error_handling = 3;
     * </code>
     */
    public Builder clearTransformationErrorHandling() {
      if (transformationErrorHandlingBuilder_ == null) {
        transformationErrorHandling_ = null;
        onChanged();
      } else {
        transformationErrorHandling_ = null;
        transformationErrorHandlingBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Mode for handling transformation errors. If left unspecified, the default
     * mode is `TransformationErrorHandling.ThrowError`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling transformation_error_handling = 3;
     * </code>
     */
    public com.google.privacy.dlp.v2.TransformationErrorHandling.Builder
        getTransformationErrorHandlingBuilder() {

      onChanged();
      return getTransformationErrorHandlingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Mode for handling transformation errors. If left unspecified, the default
     * mode is `TransformationErrorHandling.ThrowError`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling transformation_error_handling = 3;
     * </code>
     */
    public com.google.privacy.dlp.v2.TransformationErrorHandlingOrBuilder
        getTransformationErrorHandlingOrBuilder() {
      if (transformationErrorHandlingBuilder_ != null) {
        return transformationErrorHandlingBuilder_.getMessageOrBuilder();
      } else {
        return transformationErrorHandling_ == null
            ? com.google.privacy.dlp.v2.TransformationErrorHandling.getDefaultInstance()
            : transformationErrorHandling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Mode for handling transformation errors. If left unspecified, the default
     * mode is `TransformationErrorHandling.ThrowError`.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.TransformationErrorHandling transformation_error_handling = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.TransformationErrorHandling,
            com.google.privacy.dlp.v2.TransformationErrorHandling.Builder,
            com.google.privacy.dlp.v2.TransformationErrorHandlingOrBuilder>
        getTransformationErrorHandlingFieldBuilder() {
      if (transformationErrorHandlingBuilder_ == null) {
        transformationErrorHandlingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.TransformationErrorHandling,
                com.google.privacy.dlp.v2.TransformationErrorHandling.Builder,
                com.google.privacy.dlp.v2.TransformationErrorHandlingOrBuilder>(
                getTransformationErrorHandling(), getParentForChildren(), isClean());
        transformationErrorHandling_ = null;
      }
      return transformationErrorHandlingBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DeidentifyConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DeidentifyConfig)
  private static final com.google.privacy.dlp.v2.DeidentifyConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DeidentifyConfig();
  }

  public static com.google.privacy.dlp.v2.DeidentifyConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeidentifyConfig> PARSER =
      new com.google.protobuf.AbstractParser<DeidentifyConfig>() {
        @java.lang.Override
        public DeidentifyConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeidentifyConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeidentifyConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DeidentifyConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
