/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * A condition for determining whether a Pub/Sub should be triggered.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DataProfilePubSubCondition}
 */
public final class DataProfilePubSubCondition extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DataProfilePubSubCondition)
    DataProfilePubSubConditionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataProfilePubSubCondition.newBuilder() to construct.
  private DataProfilePubSubCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataProfilePubSubCondition() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataProfilePubSubCondition();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DataProfilePubSubCondition.class,
            com.google.privacy.dlp.v2.DataProfilePubSubCondition.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Various score levels for resources.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket}
   */
  public enum ProfileScoreBucket implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>PROFILE_SCORE_BUCKET_UNSPECIFIED = 0;</code>
     */
    PROFILE_SCORE_BUCKET_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * High risk/sensitivity detected.
     * </pre>
     *
     * <code>HIGH = 1;</code>
     */
    HIGH(1),
    /**
     *
     *
     * <pre>
     * Medium or high risk/sensitivity detected.
     * </pre>
     *
     * <code>MEDIUM_OR_HIGH = 2;</code>
     */
    MEDIUM_OR_HIGH(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>PROFILE_SCORE_BUCKET_UNSPECIFIED = 0;</code>
     */
    public static final int PROFILE_SCORE_BUCKET_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * High risk/sensitivity detected.
     * </pre>
     *
     * <code>HIGH = 1;</code>
     */
    public static final int HIGH_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Medium or high risk/sensitivity detected.
     * </pre>
     *
     * <code>MEDIUM_OR_HIGH = 2;</code>
     */
    public static final int MEDIUM_OR_HIGH_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProfileScoreBucket valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ProfileScoreBucket forNumber(int value) {
      switch (value) {
        case 0:
          return PROFILE_SCORE_BUCKET_UNSPECIFIED;
        case 1:
          return HIGH;
        case 2:
          return MEDIUM_OR_HIGH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ProfileScoreBucket>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ProfileScoreBucket>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ProfileScoreBucket>() {
              public ProfileScoreBucket findValueByNumber(int number) {
                return ProfileScoreBucket.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DataProfilePubSubCondition.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ProfileScoreBucket[] VALUES = values();

    public static ProfileScoreBucket valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ProfileScoreBucket(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket)
  }

  public interface PubSubConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The minimum data risk score that triggers the condition.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_risk_score = 1;
     * </code>
     *
     * @return Whether the minimumRiskScore field is set.
     */
    boolean hasMinimumRiskScore();
    /**
     *
     *
     * <pre>
     * The minimum data risk score that triggers the condition.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_risk_score = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for minimumRiskScore.
     */
    int getMinimumRiskScoreValue();
    /**
     *
     *
     * <pre>
     * The minimum data risk score that triggers the condition.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_risk_score = 1;
     * </code>
     *
     * @return The minimumRiskScore.
     */
    com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket getMinimumRiskScore();

    /**
     *
     *
     * <pre>
     * The minimum sensitivity level that triggers the condition.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_sensitivity_score = 2;
     * </code>
     *
     * @return Whether the minimumSensitivityScore field is set.
     */
    boolean hasMinimumSensitivityScore();
    /**
     *
     *
     * <pre>
     * The minimum sensitivity level that triggers the condition.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_sensitivity_score = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for minimumSensitivityScore.
     */
    int getMinimumSensitivityScoreValue();
    /**
     *
     *
     * <pre>
     * The minimum sensitivity level that triggers the condition.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_sensitivity_score = 2;
     * </code>
     *
     * @return The minimumSensitivityScore.
     */
    com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket
        getMinimumSensitivityScore();

    public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.ValueCase
        getValueCase();
  }
  /**
   *
   *
   * <pre>
   * A condition consisting of a value.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition}
   */
  public static final class PubSubCondition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition)
      PubSubConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PubSubCondition.newBuilder() to construct.
    private PubSubCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PubSubCondition() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PubSubCondition();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_PubSubCondition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_PubSubCondition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.class,
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.Builder.class);
    }

    private int valueCase_ = 0;
    private java.lang.Object value_;

    public enum ValueCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      MINIMUM_RISK_SCORE(1),
      MINIMUM_SENSITIVITY_SCORE(2),
      VALUE_NOT_SET(0);
      private final int value;

      private ValueCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ValueCase valueOf(int value) {
        return forNumber(value);
      }

      public static ValueCase forNumber(int value) {
        switch (value) {
          case 1:
            return MINIMUM_RISK_SCORE;
          case 2:
            return MINIMUM_SENSITIVITY_SCORE;
          case 0:
            return VALUE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ValueCase getValueCase() {
      return ValueCase.forNumber(valueCase_);
    }

    public static final int MINIMUM_RISK_SCORE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * The minimum data risk score that triggers the condition.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_risk_score = 1;
     * </code>
     *
     * @return Whether the minimumRiskScore field is set.
     */
    public boolean hasMinimumRiskScore() {
      return valueCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The minimum data risk score that triggers the condition.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_risk_score = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for minimumRiskScore.
     */
    public int getMinimumRiskScoreValue() {
      if (valueCase_ == 1) {
        return (java.lang.Integer) value_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The minimum data risk score that triggers the condition.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_risk_score = 1;
     * </code>
     *
     * @return The minimumRiskScore.
     */
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket
        getMinimumRiskScore() {
      if (valueCase_ == 1) {
        @SuppressWarnings("deprecation")
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket result =
            com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket.valueOf(
                (java.lang.Integer) value_);
        return result == null
            ? com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket.UNRECOGNIZED
            : result;
      }
      return com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket
          .PROFILE_SCORE_BUCKET_UNSPECIFIED;
    }

    public static final int MINIMUM_SENSITIVITY_SCORE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The minimum sensitivity level that triggers the condition.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_sensitivity_score = 2;
     * </code>
     *
     * @return Whether the minimumSensitivityScore field is set.
     */
    public boolean hasMinimumSensitivityScore() {
      return valueCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The minimum sensitivity level that triggers the condition.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_sensitivity_score = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for minimumSensitivityScore.
     */
    public int getMinimumSensitivityScoreValue() {
      if (valueCase_ == 2) {
        return (java.lang.Integer) value_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The minimum sensitivity level that triggers the condition.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_sensitivity_score = 2;
     * </code>
     *
     * @return The minimumSensitivityScore.
     */
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket
        getMinimumSensitivityScore() {
      if (valueCase_ == 2) {
        @SuppressWarnings("deprecation")
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket result =
            com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket.valueOf(
                (java.lang.Integer) value_);
        return result == null
            ? com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket.UNRECOGNIZED
            : result;
      }
      return com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket
          .PROFILE_SCORE_BUCKET_UNSPECIFIED;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (valueCase_ == 1) {
        output.writeEnum(1, ((java.lang.Integer) value_));
      }
      if (valueCase_ == 2) {
        output.writeEnum(2, ((java.lang.Integer) value_));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (valueCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeEnumSize(1, ((java.lang.Integer) value_));
      }
      if (valueCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeEnumSize(2, ((java.lang.Integer) value_));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition other =
          (com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition) obj;

      if (!getValueCase().equals(other.getValueCase())) return false;
      switch (valueCase_) {
        case 1:
          if (getMinimumRiskScoreValue() != other.getMinimumRiskScoreValue()) return false;
          break;
        case 2:
          if (getMinimumSensitivityScoreValue() != other.getMinimumSensitivityScoreValue())
            return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (valueCase_) {
        case 1:
          hash = (37 * hash) + MINIMUM_RISK_SCORE_FIELD_NUMBER;
          hash = (53 * hash) + getMinimumRiskScoreValue();
          break;
        case 2:
          hash = (37 * hash) + MINIMUM_SENSITIVITY_SCORE_FIELD_NUMBER;
          hash = (53 * hash) + getMinimumSensitivityScoreValue();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A condition consisting of a value.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition)
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_PubSubCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_PubSubCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.class,
                com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.Builder.class);
      }

      // Construct using
      // com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        valueCase_ = 0;
        value_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_PubSubCondition_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition build() {
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition buildPartial() {
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition result =
            new com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition(this);
        if (valueCase_ == 1) {
          result.value_ = value_;
        }
        if (valueCase_ == 2) {
          result.value_ = value_;
        }
        result.valueCase_ = valueCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition) {
          return mergeFrom(
              (com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition other) {
        if (other
            == com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition
                .getDefaultInstance()) return this;
        switch (other.getValueCase()) {
          case MINIMUM_RISK_SCORE:
            {
              setMinimumRiskScoreValue(other.getMinimumRiskScoreValue());
              break;
            }
          case MINIMUM_SENSITIVITY_SCORE:
            {
              setMinimumSensitivityScoreValue(other.getMinimumSensitivityScoreValue());
              break;
            }
          case VALUE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  int rawValue = input.readEnum();
                  valueCase_ = 1;
                  value_ = rawValue;
                  break;
                } // case 8
              case 16:
                {
                  int rawValue = input.readEnum();
                  valueCase_ = 2;
                  value_ = rawValue;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int valueCase_ = 0;
      private java.lang.Object value_;

      public ValueCase getValueCase() {
        return ValueCase.forNumber(valueCase_);
      }

      public Builder clearValue() {
        valueCase_ = 0;
        value_ = null;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The minimum data risk score that triggers the condition.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_risk_score = 1;
       * </code>
       *
       * @return Whether the minimumRiskScore field is set.
       */
      @java.lang.Override
      public boolean hasMinimumRiskScore() {
        return valueCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * The minimum data risk score that triggers the condition.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_risk_score = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for minimumRiskScore.
       */
      @java.lang.Override
      public int getMinimumRiskScoreValue() {
        if (valueCase_ == 1) {
          return ((java.lang.Integer) value_).intValue();
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * The minimum data risk score that triggers the condition.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_risk_score = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for minimumRiskScore to set.
       * @return This builder for chaining.
       */
      public Builder setMinimumRiskScoreValue(int value) {
        valueCase_ = 1;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum data risk score that triggers the condition.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_risk_score = 1;
       * </code>
       *
       * @return The minimumRiskScore.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket
          getMinimumRiskScore() {
        if (valueCase_ == 1) {
          @SuppressWarnings("deprecation")
          com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket result =
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket.valueOf(
                  (java.lang.Integer) value_);
          return result == null
              ? com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket.UNRECOGNIZED
              : result;
        }
        return com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket
            .PROFILE_SCORE_BUCKET_UNSPECIFIED;
      }
      /**
       *
       *
       * <pre>
       * The minimum data risk score that triggers the condition.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_risk_score = 1;
       * </code>
       *
       * @param value The minimumRiskScore to set.
       * @return This builder for chaining.
       */
      public Builder setMinimumRiskScore(
          com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket value) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueCase_ = 1;
        value_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum data risk score that triggers the condition.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_risk_score = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinimumRiskScore() {
        if (valueCase_ == 1) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The minimum sensitivity level that triggers the condition.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_sensitivity_score = 2;
       * </code>
       *
       * @return Whether the minimumSensitivityScore field is set.
       */
      @java.lang.Override
      public boolean hasMinimumSensitivityScore() {
        return valueCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The minimum sensitivity level that triggers the condition.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_sensitivity_score = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for minimumSensitivityScore.
       */
      @java.lang.Override
      public int getMinimumSensitivityScoreValue() {
        if (valueCase_ == 2) {
          return ((java.lang.Integer) value_).intValue();
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * The minimum sensitivity level that triggers the condition.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_sensitivity_score = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for minimumSensitivityScore to set.
       * @return This builder for chaining.
       */
      public Builder setMinimumSensitivityScoreValue(int value) {
        valueCase_ = 2;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum sensitivity level that triggers the condition.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_sensitivity_score = 2;
       * </code>
       *
       * @return The minimumSensitivityScore.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket
          getMinimumSensitivityScore() {
        if (valueCase_ == 2) {
          @SuppressWarnings("deprecation")
          com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket result =
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket.valueOf(
                  (java.lang.Integer) value_);
          return result == null
              ? com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket.UNRECOGNIZED
              : result;
        }
        return com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket
            .PROFILE_SCORE_BUCKET_UNSPECIFIED;
      }
      /**
       *
       *
       * <pre>
       * The minimum sensitivity level that triggers the condition.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_sensitivity_score = 2;
       * </code>
       *
       * @param value The minimumSensitivityScore to set.
       * @return This builder for chaining.
       */
      public Builder setMinimumSensitivityScore(
          com.google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket value) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueCase_ = 2;
        value_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimum sensitivity level that triggers the condition.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.ProfileScoreBucket minimum_sensitivity_score = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinimumSensitivityScore() {
        if (valueCase_ == 2) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition)
    private static final com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition();
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PubSubCondition> PARSER =
        new com.google.protobuf.AbstractParser<PubSubCondition>() {
          @java.lang.Override
          public PubSubCondition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PubSubCondition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PubSubCondition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PubSubExpressionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The operator to apply to the collection of conditions.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator logical_operator = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for logicalOperator.
     */
    int getLogicalOperatorValue();
    /**
     *
     *
     * <pre>
     * The operator to apply to the collection of conditions.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator logical_operator = 1;
     * </code>
     *
     * @return The logicalOperator.
     */
    com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator
        getLogicalOperator();

    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
     * </code>
     */
    java.util.List<com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition>
        getConditionsList();
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
     * </code>
     */
    com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition getConditions(int index);
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
     * </code>
     */
    int getConditionsCount();
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
     * </code>
     */
    java.util.List<
            ? extends com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubConditionOrBuilder>
        getConditionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
     * </code>
     */
    com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubConditionOrBuilder
        getConditionsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * An expression, consisting of an operator and conditions.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions}
   */
  public static final class PubSubExpressions extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions)
      PubSubExpressionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PubSubExpressions.newBuilder() to construct.
    private PubSubExpressions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PubSubExpressions() {
      logicalOperator_ = 0;
      conditions_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PubSubExpressions();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_PubSubExpressions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_PubSubExpressions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.class,
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Logical operators for conditional checks.
     * </pre>
     *
     * Protobuf enum {@code
     * google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator}
     */
    public enum PubSubLogicalOperator implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unused.
       * </pre>
       *
       * <code>LOGICAL_OPERATOR_UNSPECIFIED = 0;</code>
       */
      LOGICAL_OPERATOR_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Conditional OR.
       * </pre>
       *
       * <code>OR = 1;</code>
       */
      OR(1),
      /**
       *
       *
       * <pre>
       * Conditional AND.
       * </pre>
       *
       * <code>AND = 2;</code>
       */
      AND(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unused.
       * </pre>
       *
       * <code>LOGICAL_OPERATOR_UNSPECIFIED = 0;</code>
       */
      public static final int LOGICAL_OPERATOR_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Conditional OR.
       * </pre>
       *
       * <code>OR = 1;</code>
       */
      public static final int OR_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Conditional AND.
       * </pre>
       *
       * <code>AND = 2;</code>
       */
      public static final int AND_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PubSubLogicalOperator valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static PubSubLogicalOperator forNumber(int value) {
        switch (value) {
          case 0:
            return LOGICAL_OPERATOR_UNSPECIFIED;
          case 1:
            return OR;
          case 2:
            return AND;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<PubSubLogicalOperator>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<PubSubLogicalOperator>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<PubSubLogicalOperator>() {
                public PubSubLogicalOperator findValueByNumber(int number) {
                  return PubSubLogicalOperator.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final PubSubLogicalOperator[] VALUES = values();

      public static PubSubLogicalOperator valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private PubSubLogicalOperator(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator)
    }

    public static final int LOGICAL_OPERATOR_FIELD_NUMBER = 1;
    private int logicalOperator_;
    /**
     *
     *
     * <pre>
     * The operator to apply to the collection of conditions.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator logical_operator = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for logicalOperator.
     */
    @java.lang.Override
    public int getLogicalOperatorValue() {
      return logicalOperator_;
    }
    /**
     *
     *
     * <pre>
     * The operator to apply to the collection of conditions.
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator logical_operator = 1;
     * </code>
     *
     * @return The logicalOperator.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
            .PubSubLogicalOperator
        getLogicalOperator() {
      @SuppressWarnings("deprecation")
      com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator
          result =
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
                  .PubSubLogicalOperator.valueOf(logicalOperator_);
      return result == null
          ? com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
              .PubSubLogicalOperator.UNRECOGNIZED
          : result;
    }

    public static final int CONDITIONS_FIELD_NUMBER = 2;
    private java.util.List<com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition>
        conditions_;
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition>
        getConditionsList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubConditionOrBuilder>
        getConditionsOrBuilderList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
     * </code>
     */
    @java.lang.Override
    public int getConditionsCount() {
      return conditions_.size();
    }
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition getConditions(
        int index) {
      return conditions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Conditions to apply to the expression.
     * </pre>
     *
     * <code>
     * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubConditionOrBuilder
        getConditionsOrBuilder(int index) {
      return conditions_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (logicalOperator_
          != com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
              .PubSubLogicalOperator.LOGICAL_OPERATOR_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, logicalOperator_);
      }
      for (int i = 0; i < conditions_.size(); i++) {
        output.writeMessage(2, conditions_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (logicalOperator_
          != com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
              .PubSubLogicalOperator.LOGICAL_OPERATOR_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, logicalOperator_);
      }
      for (int i = 0; i < conditions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, conditions_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions other =
          (com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions) obj;

      if (logicalOperator_ != other.logicalOperator_) return false;
      if (!getConditionsList().equals(other.getConditionsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LOGICAL_OPERATOR_FIELD_NUMBER;
      hash = (53 * hash) + logicalOperator_;
      if (getConditionsCount() > 0) {
        hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getConditionsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An expression, consisting of an operator and conditions.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions)
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_PubSubExpressions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_PubSubExpressions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.class,
                com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.Builder
                    .class);
      }

      // Construct using
      // com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        logicalOperator_ = 0;

        if (conditionsBuilder_ == null) {
          conditions_ = java.util.Collections.emptyList();
        } else {
          conditions_ = null;
          conditionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_PubSubExpressions_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions build() {
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions buildPartial() {
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions result =
            new com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions(this);
        int from_bitField0_ = bitField0_;
        result.logicalOperator_ = logicalOperator_;
        if (conditionsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            conditions_ = java.util.Collections.unmodifiableList(conditions_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.conditions_ = conditions_;
        } else {
          result.conditions_ = conditionsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions) {
          return mergeFrom(
              (com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions other) {
        if (other
            == com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
                .getDefaultInstance()) return this;
        if (other.logicalOperator_ != 0) {
          setLogicalOperatorValue(other.getLogicalOperatorValue());
        }
        if (conditionsBuilder_ == null) {
          if (!other.conditions_.isEmpty()) {
            if (conditions_.isEmpty()) {
              conditions_ = other.conditions_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureConditionsIsMutable();
              conditions_.addAll(other.conditions_);
            }
            onChanged();
          }
        } else {
          if (!other.conditions_.isEmpty()) {
            if (conditionsBuilder_.isEmpty()) {
              conditionsBuilder_.dispose();
              conditionsBuilder_ = null;
              conditions_ = other.conditions_;
              bitField0_ = (bitField0_ & ~0x00000001);
              conditionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConditionsFieldBuilder()
                      : null;
            } else {
              conditionsBuilder_.addAllMessages(other.conditions_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  logicalOperator_ = input.readEnum();

                  break;
                } // case 8
              case 18:
                {
                  com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition m =
                      input.readMessage(
                          com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition
                              .parser(),
                          extensionRegistry);
                  if (conditionsBuilder_ == null) {
                    ensureConditionsIsMutable();
                    conditions_.add(m);
                  } else {
                    conditionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int logicalOperator_ = 0;
      /**
       *
       *
       * <pre>
       * The operator to apply to the collection of conditions.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator logical_operator = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for logicalOperator.
       */
      @java.lang.Override
      public int getLogicalOperatorValue() {
        return logicalOperator_;
      }
      /**
       *
       *
       * <pre>
       * The operator to apply to the collection of conditions.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator logical_operator = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for logicalOperator to set.
       * @return This builder for chaining.
       */
      public Builder setLogicalOperatorValue(int value) {

        logicalOperator_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operator to apply to the collection of conditions.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator logical_operator = 1;
       * </code>
       *
       * @return The logicalOperator.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
              .PubSubLogicalOperator
          getLogicalOperator() {
        @SuppressWarnings("deprecation")
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator
            result =
                com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
                    .PubSubLogicalOperator.valueOf(logicalOperator_);
        return result == null
            ? com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
                .PubSubLogicalOperator.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The operator to apply to the collection of conditions.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator logical_operator = 1;
       * </code>
       *
       * @param value The logicalOperator to set.
       * @return This builder for chaining.
       */
      public Builder setLogicalOperator(
          com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
                  .PubSubLogicalOperator
              value) {
        if (value == null) {
          throw new NullPointerException();
        }

        logicalOperator_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The operator to apply to the collection of conditions.
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.PubSubLogicalOperator logical_operator = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLogicalOperator() {

        logicalOperator_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition>
          conditions_ = java.util.Collections.emptyList();

      private void ensureConditionsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          conditions_ =
              new java.util.ArrayList<
                  com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition>(
                  conditions_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition,
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.Builder,
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubConditionOrBuilder>
          conditionsBuilder_;

      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public java.util.List<com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition>
          getConditionsList() {
        if (conditionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(conditions_);
        } else {
          return conditionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public int getConditionsCount() {
        if (conditionsBuilder_ == null) {
          return conditions_.size();
        } else {
          return conditionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition getConditions(
          int index) {
        if (conditionsBuilder_ == null) {
          return conditions_.get(index);
        } else {
          return conditionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public Builder setConditions(
          int index, com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.set(index, value);
          onChanged();
        } else {
          conditionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public Builder setConditions(
          int index,
          com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.Builder
              builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.set(index, builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public Builder addConditions(
          com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.add(value);
          onChanged();
        } else {
          conditionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public Builder addConditions(
          int index, com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.add(index, value);
          onChanged();
        } else {
          conditionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public Builder addConditions(
          com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.Builder
              builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.add(builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public Builder addConditions(
          int index,
          com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.Builder
              builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.add(index, builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public Builder addAllConditions(
          java.lang.Iterable<
                  ? extends com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition>
              values) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
          onChanged();
        } else {
          conditionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public Builder clearConditions() {
        if (conditionsBuilder_ == null) {
          conditions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          conditionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public Builder removeConditions(int index) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.remove(index);
          onChanged();
        } else {
          conditionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.Builder
          getConditionsBuilder(int index) {
        return getConditionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubConditionOrBuilder
          getConditionsOrBuilder(int index) {
        if (conditionsBuilder_ == null) {
          return conditions_.get(index);
        } else {
          return conditionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubConditionOrBuilder>
          getConditionsOrBuilderList() {
        if (conditionsBuilder_ != null) {
          return conditionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(conditions_);
        }
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.Builder
          addConditionsBuilder() {
        return getConditionsFieldBuilder()
            .addBuilder(
                com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.Builder
          addConditionsBuilder(int index) {
        return getConditionsFieldBuilder()
            .addBuilder(
                index,
                com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Conditions to apply to the expression.
       * </pre>
       *
       * <code>
       * repeated .google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition conditions = 2;
       * </code>
       */
      public java.util.List<
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.Builder>
          getConditionsBuilderList() {
        return getConditionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition,
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.Builder,
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubConditionOrBuilder>
          getConditionsFieldBuilder() {
        if (conditionsBuilder_ == null) {
          conditionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition,
                  com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubCondition.Builder,
                  com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubConditionOrBuilder>(
                  conditions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          conditions_ = null;
        }
        return conditionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions)
    private static final com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions();
    }

    public static com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PubSubExpressions> PARSER =
        new com.google.protobuf.AbstractParser<PubSubExpressions>() {
          @java.lang.Override
          public PubSubExpressions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PubSubExpressions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PubSubExpressions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int EXPRESSIONS_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions_;
  /**
   *
   *
   * <pre>
   * An expression.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions = 1;
   * </code>
   *
   * @return Whether the expressions field is set.
   */
  @java.lang.Override
  public boolean hasExpressions() {
    return expressions_ != null;
  }
  /**
   *
   *
   * <pre>
   * An expression.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions = 1;
   * </code>
   *
   * @return The expressions.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions getExpressions() {
    return expressions_ == null
        ? com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
            .getDefaultInstance()
        : expressions_;
  }
  /**
   *
   *
   * <pre>
   * An expression.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressionsOrBuilder
      getExpressionsOrBuilder() {
    return getExpressions();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (expressions_ != null) {
      output.writeMessage(1, getExpressions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (expressions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getExpressions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DataProfilePubSubCondition)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DataProfilePubSubCondition other =
        (com.google.privacy.dlp.v2.DataProfilePubSubCondition) obj;

    if (hasExpressions() != other.hasExpressions()) return false;
    if (hasExpressions()) {
      if (!getExpressions().equals(other.getExpressions())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasExpressions()) {
      hash = (37 * hash) + EXPRESSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExpressions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.DataProfilePubSubCondition prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A condition for determining whether a Pub/Sub should be triggered.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DataProfilePubSubCondition}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DataProfilePubSubCondition)
      com.google.privacy.dlp.v2.DataProfilePubSubConditionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.class,
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DataProfilePubSubCondition.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (expressionsBuilder_ == null) {
        expressions_ = null;
      } else {
        expressions_ = null;
        expressionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfilePubSubCondition_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DataProfilePubSubCondition.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition build() {
      com.google.privacy.dlp.v2.DataProfilePubSubCondition result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition buildPartial() {
      com.google.privacy.dlp.v2.DataProfilePubSubCondition result =
          new com.google.privacy.dlp.v2.DataProfilePubSubCondition(this);
      if (expressionsBuilder_ == null) {
        result.expressions_ = expressions_;
      } else {
        result.expressions_ = expressionsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DataProfilePubSubCondition) {
        return mergeFrom((com.google.privacy.dlp.v2.DataProfilePubSubCondition) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DataProfilePubSubCondition other) {
      if (other == com.google.privacy.dlp.v2.DataProfilePubSubCondition.getDefaultInstance())
        return this;
      if (other.hasExpressions()) {
        mergeExpressions(other.getExpressions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getExpressionsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions,
            com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.Builder,
            com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressionsOrBuilder>
        expressionsBuilder_;
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions = 1;
     * </code>
     *
     * @return Whether the expressions field is set.
     */
    public boolean hasExpressions() {
      return expressionsBuilder_ != null || expressions_ != null;
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions = 1;
     * </code>
     *
     * @return The expressions.
     */
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions getExpressions() {
      if (expressionsBuilder_ == null) {
        return expressions_ == null
            ? com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
                .getDefaultInstance()
            : expressions_;
      } else {
        return expressionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions = 1;
     * </code>
     */
    public Builder setExpressions(
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions value) {
      if (expressionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expressions_ = value;
        onChanged();
      } else {
        expressionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions = 1;
     * </code>
     */
    public Builder setExpressions(
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.Builder
            builderForValue) {
      if (expressionsBuilder_ == null) {
        expressions_ = builderForValue.build();
        onChanged();
      } else {
        expressionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions = 1;
     * </code>
     */
    public Builder mergeExpressions(
        com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions value) {
      if (expressionsBuilder_ == null) {
        if (expressions_ != null) {
          expressions_ =
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.newBuilder(
                      expressions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expressions_ = value;
        }
        onChanged();
      } else {
        expressionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions = 1;
     * </code>
     */
    public Builder clearExpressions() {
      if (expressionsBuilder_ == null) {
        expressions_ = null;
        onChanged();
      } else {
        expressions_ = null;
        expressionsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions = 1;
     * </code>
     */
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.Builder
        getExpressionsBuilder() {

      onChanged();
      return getExpressionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions = 1;
     * </code>
     */
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressionsOrBuilder
        getExpressionsOrBuilder() {
      if (expressionsBuilder_ != null) {
        return expressionsBuilder_.getMessageOrBuilder();
      } else {
        return expressions_ == null
            ? com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions
                .getDefaultInstance()
            : expressions_;
      }
    }
    /**
     *
     *
     * <pre>
     * An expression.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions expressions = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions,
            com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.Builder,
            com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressionsOrBuilder>
        getExpressionsFieldBuilder() {
      if (expressionsBuilder_ == null) {
        expressionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions,
                com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressions.Builder,
                com.google.privacy.dlp.v2.DataProfilePubSubCondition.PubSubExpressionsOrBuilder>(
                getExpressions(), getParentForChildren(), isClean());
        expressions_ = null;
      }
      return expressionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DataProfilePubSubCondition)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DataProfilePubSubCondition)
  private static final com.google.privacy.dlp.v2.DataProfilePubSubCondition DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DataProfilePubSubCondition();
  }

  public static com.google.privacy.dlp.v2.DataProfilePubSubCondition getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataProfilePubSubCondition> PARSER =
      new com.google.protobuf.AbstractParser<DataProfilePubSubCondition>() {
        @java.lang.Override
        public DataProfilePubSubCondition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataProfilePubSubCondition> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataProfilePubSubCondition> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfilePubSubCondition getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
