/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Configuration for setting up a job to scan resources for profile generation.
 * Only one data profile configuration may exist per organization, folder,
 * or project.
 * The generated data profiles are retained according to the
 * [data retention policy]
 * (https://cloud.google.com/dlp/docs/data-profiles#retention).
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DataProfileJobConfig}
 */
public final class DataProfileJobConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DataProfileJobConfig)
    DataProfileJobConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataProfileJobConfig.newBuilder() to construct.
  private DataProfileJobConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataProfileJobConfig() {
    projectId_ = "";
    inspectTemplates_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    dataProfileActions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataProfileJobConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DataProfileJobConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DataProfileJobConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DataProfileJobConfig.class,
            com.google.privacy.dlp.v2.DataProfileJobConfig.Builder.class);
  }

  public static final int LOCATION_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.DataProfileLocation location_;
  /**
   *
   *
   * <pre>
   * The data to scan.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileLocation location = 1;</code>
   *
   * @return Whether the location field is set.
   */
  @java.lang.Override
  public boolean hasLocation() {
    return location_ != null;
  }
  /**
   *
   *
   * <pre>
   * The data to scan.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileLocation location = 1;</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileLocation getLocation() {
    return location_ == null
        ? com.google.privacy.dlp.v2.DataProfileLocation.getDefaultInstance()
        : location_;
  }
  /**
   *
   *
   * <pre>
   * The data to scan.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileLocation location = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileLocationOrBuilder getLocationOrBuilder() {
    return getLocation();
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 5;
  private volatile java.lang.Object projectId_;
  /**
   *
   *
   * <pre>
   * The project that will run the scan. The DLP service
   * account that exists within this project must have access to all resources
   * that are profiled, and the Cloud DLP API must be enabled.
   * </pre>
   *
   * <code>string project_id = 5;</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The project that will run the scan. The DLP service
   * account that exists within this project must have access to all resources
   * that are profiled, and the Cloud DLP API must be enabled.
   * </pre>
   *
   * <code>string project_id = 5;</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSPECT_TEMPLATES_FIELD_NUMBER = 7;
  private com.google.protobuf.LazyStringList inspectTemplates_;
  /**
   *
   *
   * <pre>
   * Detection logic for profile generation.
   * Not all template features are used by profiles. FindingLimits,
   * include_quote and exclude_info_types have no impact on
   * data profiling.
   * Multiple templates may be provided if there is data in multiple regions.
   * At most one template must be specified per-region (including "global").
   * Each region is scanned using the applicable template. If no region-specific
   * template is specified, but a "global" template is specified, it will be
   * copied to that region and used instead. If no global or region-specific
   * template is provided for a region with data, that region's data will not be
   * scanned.
   * For more information, see
   * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
   * </pre>
   *
   * <code>repeated string inspect_templates = 7;</code>
   *
   * @return A list containing the inspectTemplates.
   */
  public com.google.protobuf.ProtocolStringList getInspectTemplatesList() {
    return inspectTemplates_;
  }
  /**
   *
   *
   * <pre>
   * Detection logic for profile generation.
   * Not all template features are used by profiles. FindingLimits,
   * include_quote and exclude_info_types have no impact on
   * data profiling.
   * Multiple templates may be provided if there is data in multiple regions.
   * At most one template must be specified per-region (including "global").
   * Each region is scanned using the applicable template. If no region-specific
   * template is specified, but a "global" template is specified, it will be
   * copied to that region and used instead. If no global or region-specific
   * template is provided for a region with data, that region's data will not be
   * scanned.
   * For more information, see
   * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
   * </pre>
   *
   * <code>repeated string inspect_templates = 7;</code>
   *
   * @return The count of inspectTemplates.
   */
  public int getInspectTemplatesCount() {
    return inspectTemplates_.size();
  }
  /**
   *
   *
   * <pre>
   * Detection logic for profile generation.
   * Not all template features are used by profiles. FindingLimits,
   * include_quote and exclude_info_types have no impact on
   * data profiling.
   * Multiple templates may be provided if there is data in multiple regions.
   * At most one template must be specified per-region (including "global").
   * Each region is scanned using the applicable template. If no region-specific
   * template is specified, but a "global" template is specified, it will be
   * copied to that region and used instead. If no global or region-specific
   * template is provided for a region with data, that region's data will not be
   * scanned.
   * For more information, see
   * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
   * </pre>
   *
   * <code>repeated string inspect_templates = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The inspectTemplates at the given index.
   */
  public java.lang.String getInspectTemplates(int index) {
    return inspectTemplates_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Detection logic for profile generation.
   * Not all template features are used by profiles. FindingLimits,
   * include_quote and exclude_info_types have no impact on
   * data profiling.
   * Multiple templates may be provided if there is data in multiple regions.
   * At most one template must be specified per-region (including "global").
   * Each region is scanned using the applicable template. If no region-specific
   * template is specified, but a "global" template is specified, it will be
   * copied to that region and used instead. If no global or region-specific
   * template is provided for a region with data, that region's data will not be
   * scanned.
   * For more information, see
   * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
   * </pre>
   *
   * <code>repeated string inspect_templates = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the inspectTemplates at the given index.
   */
  public com.google.protobuf.ByteString getInspectTemplatesBytes(int index) {
    return inspectTemplates_.getByteString(index);
  }

  public static final int DATA_PROFILE_ACTIONS_FIELD_NUMBER = 6;
  private java.util.List<com.google.privacy.dlp.v2.DataProfileAction> dataProfileActions_;
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.DataProfileAction> getDataProfileActionsList() {
    return dataProfileActions_;
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.DataProfileActionOrBuilder>
      getDataProfileActionsOrBuilderList() {
    return dataProfileActions_;
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
   */
  @java.lang.Override
  public int getDataProfileActionsCount() {
    return dataProfileActions_.size();
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileAction getDataProfileActions(int index) {
    return dataProfileActions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Actions to execute at the completion of the job.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileActionOrBuilder getDataProfileActionsOrBuilder(
      int index) {
    return dataProfileActions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (location_ != null) {
      output.writeMessage(1, getLocation());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, projectId_);
    }
    for (int i = 0; i < dataProfileActions_.size(); i++) {
      output.writeMessage(6, dataProfileActions_.get(i));
    }
    for (int i = 0; i < inspectTemplates_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, inspectTemplates_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (location_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLocation());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, projectId_);
    }
    for (int i = 0; i < dataProfileActions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, dataProfileActions_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < inspectTemplates_.size(); i++) {
        dataSize += computeStringSizeNoTag(inspectTemplates_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getInspectTemplatesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DataProfileJobConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DataProfileJobConfig other =
        (com.google.privacy.dlp.v2.DataProfileJobConfig) obj;

    if (hasLocation() != other.hasLocation()) return false;
    if (hasLocation()) {
      if (!getLocation().equals(other.getLocation())) return false;
    }
    if (!getProjectId().equals(other.getProjectId())) return false;
    if (!getInspectTemplatesList().equals(other.getInspectTemplatesList())) return false;
    if (!getDataProfileActionsList().equals(other.getDataProfileActionsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasLocation()) {
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
    }
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    if (getInspectTemplatesCount() > 0) {
      hash = (37 * hash) + INSPECT_TEMPLATES_FIELD_NUMBER;
      hash = (53 * hash) + getInspectTemplatesList().hashCode();
    }
    if (getDataProfileActionsCount() > 0) {
      hash = (37 * hash) + DATA_PROFILE_ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDataProfileActionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.DataProfileJobConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for setting up a job to scan resources for profile generation.
   * Only one data profile configuration may exist per organization, folder,
   * or project.
   * The generated data profiles are retained according to the
   * [data retention policy]
   * (https://cloud.google.com/dlp/docs/data-profiles#retention).
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DataProfileJobConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DataProfileJobConfig)
      com.google.privacy.dlp.v2.DataProfileJobConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfileJobConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfileJobConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DataProfileJobConfig.class,
              com.google.privacy.dlp.v2.DataProfileJobConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DataProfileJobConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (locationBuilder_ == null) {
        location_ = null;
      } else {
        location_ = null;
        locationBuilder_ = null;
      }
      projectId_ = "";

      inspectTemplates_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (dataProfileActionsBuilder_ == null) {
        dataProfileActions_ = java.util.Collections.emptyList();
      } else {
        dataProfileActions_ = null;
        dataProfileActionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfileJobConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileJobConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DataProfileJobConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileJobConfig build() {
      com.google.privacy.dlp.v2.DataProfileJobConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileJobConfig buildPartial() {
      com.google.privacy.dlp.v2.DataProfileJobConfig result =
          new com.google.privacy.dlp.v2.DataProfileJobConfig(this);
      int from_bitField0_ = bitField0_;
      if (locationBuilder_ == null) {
        result.location_ = location_;
      } else {
        result.location_ = locationBuilder_.build();
      }
      result.projectId_ = projectId_;
      if (((bitField0_ & 0x00000001) != 0)) {
        inspectTemplates_ = inspectTemplates_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.inspectTemplates_ = inspectTemplates_;
      if (dataProfileActionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          dataProfileActions_ = java.util.Collections.unmodifiableList(dataProfileActions_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.dataProfileActions_ = dataProfileActions_;
      } else {
        result.dataProfileActions_ = dataProfileActionsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DataProfileJobConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.DataProfileJobConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DataProfileJobConfig other) {
      if (other == com.google.privacy.dlp.v2.DataProfileJobConfig.getDefaultInstance()) return this;
      if (other.hasLocation()) {
        mergeLocation(other.getLocation());
      }
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        onChanged();
      }
      if (!other.inspectTemplates_.isEmpty()) {
        if (inspectTemplates_.isEmpty()) {
          inspectTemplates_ = other.inspectTemplates_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureInspectTemplatesIsMutable();
          inspectTemplates_.addAll(other.inspectTemplates_);
        }
        onChanged();
      }
      if (dataProfileActionsBuilder_ == null) {
        if (!other.dataProfileActions_.isEmpty()) {
          if (dataProfileActions_.isEmpty()) {
            dataProfileActions_ = other.dataProfileActions_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDataProfileActionsIsMutable();
            dataProfileActions_.addAll(other.dataProfileActions_);
          }
          onChanged();
        }
      } else {
        if (!other.dataProfileActions_.isEmpty()) {
          if (dataProfileActionsBuilder_.isEmpty()) {
            dataProfileActionsBuilder_.dispose();
            dataProfileActionsBuilder_ = null;
            dataProfileActions_ = other.dataProfileActions_;
            bitField0_ = (bitField0_ & ~0x00000002);
            dataProfileActionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDataProfileActionsFieldBuilder()
                    : null;
          } else {
            dataProfileActionsBuilder_.addAllMessages(other.dataProfileActions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getLocationFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 42:
              {
                projectId_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                com.google.privacy.dlp.v2.DataProfileAction m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.DataProfileAction.parser(), extensionRegistry);
                if (dataProfileActionsBuilder_ == null) {
                  ensureDataProfileActionsIsMutable();
                  dataProfileActions_.add(m);
                } else {
                  dataProfileActionsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInspectTemplatesIsMutable();
                inspectTemplates_.add(s);
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.DataProfileLocation location_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfileLocation,
            com.google.privacy.dlp.v2.DataProfileLocation.Builder,
            com.google.privacy.dlp.v2.DataProfileLocationOrBuilder>
        locationBuilder_;
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileLocation location = 1;</code>
     *
     * @return Whether the location field is set.
     */
    public boolean hasLocation() {
      return locationBuilder_ != null || location_ != null;
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileLocation location = 1;</code>
     *
     * @return The location.
     */
    public com.google.privacy.dlp.v2.DataProfileLocation getLocation() {
      if (locationBuilder_ == null) {
        return location_ == null
            ? com.google.privacy.dlp.v2.DataProfileLocation.getDefaultInstance()
            : location_;
      } else {
        return locationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileLocation location = 1;</code>
     */
    public Builder setLocation(com.google.privacy.dlp.v2.DataProfileLocation value) {
      if (locationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        location_ = value;
        onChanged();
      } else {
        locationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileLocation location = 1;</code>
     */
    public Builder setLocation(
        com.google.privacy.dlp.v2.DataProfileLocation.Builder builderForValue) {
      if (locationBuilder_ == null) {
        location_ = builderForValue.build();
        onChanged();
      } else {
        locationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileLocation location = 1;</code>
     */
    public Builder mergeLocation(com.google.privacy.dlp.v2.DataProfileLocation value) {
      if (locationBuilder_ == null) {
        if (location_ != null) {
          location_ =
              com.google.privacy.dlp.v2.DataProfileLocation.newBuilder(location_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          location_ = value;
        }
        onChanged();
      } else {
        locationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileLocation location = 1;</code>
     */
    public Builder clearLocation() {
      if (locationBuilder_ == null) {
        location_ = null;
        onChanged();
      } else {
        location_ = null;
        locationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileLocation location = 1;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileLocation.Builder getLocationBuilder() {

      onChanged();
      return getLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileLocation location = 1;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileLocationOrBuilder getLocationOrBuilder() {
      if (locationBuilder_ != null) {
        return locationBuilder_.getMessageOrBuilder();
      } else {
        return location_ == null
            ? com.google.privacy.dlp.v2.DataProfileLocation.getDefaultInstance()
            : location_;
      }
    }
    /**
     *
     *
     * <pre>
     * The data to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileLocation location = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfileLocation,
            com.google.privacy.dlp.v2.DataProfileLocation.Builder,
            com.google.privacy.dlp.v2.DataProfileLocationOrBuilder>
        getLocationFieldBuilder() {
      if (locationBuilder_ == null) {
        locationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DataProfileLocation,
                com.google.privacy.dlp.v2.DataProfileLocation.Builder,
                com.google.privacy.dlp.v2.DataProfileLocationOrBuilder>(
                getLocation(), getParentForChildren(), isClean());
        location_ = null;
      }
      return locationBuilder_;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * The project that will run the scan. The DLP service
     * account that exists within this project must have access to all resources
     * that are profiled, and the Cloud DLP API must be enabled.
     * </pre>
     *
     * <code>string project_id = 5;</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project that will run the scan. The DLP service
     * account that exists within this project must have access to all resources
     * that are profiled, and the Cloud DLP API must be enabled.
     * </pre>
     *
     * <code>string project_id = 5;</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The project that will run the scan. The DLP service
     * account that exists within this project must have access to all resources
     * that are profiled, and the Cloud DLP API must be enabled.
     * </pre>
     *
     * <code>string project_id = 5;</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      projectId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project that will run the scan. The DLP service
     * account that exists within this project must have access to all resources
     * that are profiled, and the Cloud DLP API must be enabled.
     * </pre>
     *
     * <code>string project_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {

      projectId_ = getDefaultInstance().getProjectId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The project that will run the scan. The DLP service
     * account that exists within this project must have access to all resources
     * that are profiled, and the Cloud DLP API must be enabled.
     * </pre>
     *
     * <code>string project_id = 5;</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      projectId_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList inspectTemplates_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureInspectTemplatesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        inspectTemplates_ = new com.google.protobuf.LazyStringArrayList(inspectTemplates_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     * Not all template features are used by profiles. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * data profiling.
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     * For more information, see
     * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 7;</code>
     *
     * @return A list containing the inspectTemplates.
     */
    public com.google.protobuf.ProtocolStringList getInspectTemplatesList() {
      return inspectTemplates_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     * Not all template features are used by profiles. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * data profiling.
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     * For more information, see
     * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 7;</code>
     *
     * @return The count of inspectTemplates.
     */
    public int getInspectTemplatesCount() {
      return inspectTemplates_.size();
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     * Not all template features are used by profiles. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * data profiling.
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     * For more information, see
     * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The inspectTemplates at the given index.
     */
    public java.lang.String getInspectTemplates(int index) {
      return inspectTemplates_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     * Not all template features are used by profiles. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * data profiling.
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     * For more information, see
     * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the inspectTemplates at the given index.
     */
    public com.google.protobuf.ByteString getInspectTemplatesBytes(int index) {
      return inspectTemplates_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     * Not all template features are used by profiles. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * data profiling.
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     * For more information, see
     * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The inspectTemplates to set.
     * @return This builder for chaining.
     */
    public Builder setInspectTemplates(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInspectTemplatesIsMutable();
      inspectTemplates_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     * Not all template features are used by profiles. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * data profiling.
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     * For more information, see
     * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 7;</code>
     *
     * @param value The inspectTemplates to add.
     * @return This builder for chaining.
     */
    public Builder addInspectTemplates(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInspectTemplatesIsMutable();
      inspectTemplates_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     * Not all template features are used by profiles. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * data profiling.
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     * For more information, see
     * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 7;</code>
     *
     * @param values The inspectTemplates to add.
     * @return This builder for chaining.
     */
    public Builder addAllInspectTemplates(java.lang.Iterable<java.lang.String> values) {
      ensureInspectTemplatesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inspectTemplates_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     * Not all template features are used by profiles. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * data profiling.
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     * For more information, see
     * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInspectTemplates() {
      inspectTemplates_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Detection logic for profile generation.
     * Not all template features are used by profiles. FindingLimits,
     * include_quote and exclude_info_types have no impact on
     * data profiling.
     * Multiple templates may be provided if there is data in multiple regions.
     * At most one template must be specified per-region (including "global").
     * Each region is scanned using the applicable template. If no region-specific
     * template is specified, but a "global" template is specified, it will be
     * copied to that region and used instead. If no global or region-specific
     * template is provided for a region with data, that region's data will not be
     * scanned.
     * For more information, see
     * https://cloud.google.com/dlp/docs/data-profiles#data_residency.
     * </pre>
     *
     * <code>repeated string inspect_templates = 7;</code>
     *
     * @param value The bytes of the inspectTemplates to add.
     * @return This builder for chaining.
     */
    public Builder addInspectTemplatesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInspectTemplatesIsMutable();
      inspectTemplates_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.privacy.dlp.v2.DataProfileAction> dataProfileActions_ =
        java.util.Collections.emptyList();

    private void ensureDataProfileActionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        dataProfileActions_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.DataProfileAction>(
                dataProfileActions_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfileAction,
            com.google.privacy.dlp.v2.DataProfileAction.Builder,
            com.google.privacy.dlp.v2.DataProfileActionOrBuilder>
        dataProfileActionsBuilder_;

    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.DataProfileAction> getDataProfileActionsList() {
      if (dataProfileActionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dataProfileActions_);
      } else {
        return dataProfileActionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public int getDataProfileActionsCount() {
      if (dataProfileActionsBuilder_ == null) {
        return dataProfileActions_.size();
      } else {
        return dataProfileActionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileAction getDataProfileActions(int index) {
      if (dataProfileActionsBuilder_ == null) {
        return dataProfileActions_.get(index);
      } else {
        return dataProfileActionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public Builder setDataProfileActions(
        int index, com.google.privacy.dlp.v2.DataProfileAction value) {
      if (dataProfileActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataProfileActionsIsMutable();
        dataProfileActions_.set(index, value);
        onChanged();
      } else {
        dataProfileActionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public Builder setDataProfileActions(
        int index, com.google.privacy.dlp.v2.DataProfileAction.Builder builderForValue) {
      if (dataProfileActionsBuilder_ == null) {
        ensureDataProfileActionsIsMutable();
        dataProfileActions_.set(index, builderForValue.build());
        onChanged();
      } else {
        dataProfileActionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public Builder addDataProfileActions(com.google.privacy.dlp.v2.DataProfileAction value) {
      if (dataProfileActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataProfileActionsIsMutable();
        dataProfileActions_.add(value);
        onChanged();
      } else {
        dataProfileActionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public Builder addDataProfileActions(
        int index, com.google.privacy.dlp.v2.DataProfileAction value) {
      if (dataProfileActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataProfileActionsIsMutable();
        dataProfileActions_.add(index, value);
        onChanged();
      } else {
        dataProfileActionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public Builder addDataProfileActions(
        com.google.privacy.dlp.v2.DataProfileAction.Builder builderForValue) {
      if (dataProfileActionsBuilder_ == null) {
        ensureDataProfileActionsIsMutable();
        dataProfileActions_.add(builderForValue.build());
        onChanged();
      } else {
        dataProfileActionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public Builder addDataProfileActions(
        int index, com.google.privacy.dlp.v2.DataProfileAction.Builder builderForValue) {
      if (dataProfileActionsBuilder_ == null) {
        ensureDataProfileActionsIsMutable();
        dataProfileActions_.add(index, builderForValue.build());
        onChanged();
      } else {
        dataProfileActionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public Builder addAllDataProfileActions(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.DataProfileAction> values) {
      if (dataProfileActionsBuilder_ == null) {
        ensureDataProfileActionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataProfileActions_);
        onChanged();
      } else {
        dataProfileActionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public Builder clearDataProfileActions() {
      if (dataProfileActionsBuilder_ == null) {
        dataProfileActions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        dataProfileActionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public Builder removeDataProfileActions(int index) {
      if (dataProfileActionsBuilder_ == null) {
        ensureDataProfileActionsIsMutable();
        dataProfileActions_.remove(index);
        onChanged();
      } else {
        dataProfileActionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileAction.Builder getDataProfileActionsBuilder(
        int index) {
      return getDataProfileActionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileActionOrBuilder getDataProfileActionsOrBuilder(
        int index) {
      if (dataProfileActionsBuilder_ == null) {
        return dataProfileActions_.get(index);
      } else {
        return dataProfileActionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.DataProfileActionOrBuilder>
        getDataProfileActionsOrBuilderList() {
      if (dataProfileActionsBuilder_ != null) {
        return dataProfileActionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dataProfileActions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileAction.Builder addDataProfileActionsBuilder() {
      return getDataProfileActionsFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.DataProfileAction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileAction.Builder addDataProfileActionsBuilder(
        int index) {
      return getDataProfileActionsFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.DataProfileAction.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Actions to execute at the completion of the job.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.DataProfileAction data_profile_actions = 6;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.DataProfileAction.Builder>
        getDataProfileActionsBuilderList() {
      return getDataProfileActionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfileAction,
            com.google.privacy.dlp.v2.DataProfileAction.Builder,
            com.google.privacy.dlp.v2.DataProfileActionOrBuilder>
        getDataProfileActionsFieldBuilder() {
      if (dataProfileActionsBuilder_ == null) {
        dataProfileActionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.DataProfileAction,
                com.google.privacy.dlp.v2.DataProfileAction.Builder,
                com.google.privacy.dlp.v2.DataProfileActionOrBuilder>(
                dataProfileActions_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        dataProfileActions_ = null;
      }
      return dataProfileActionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DataProfileJobConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DataProfileJobConfig)
  private static final com.google.privacy.dlp.v2.DataProfileJobConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DataProfileJobConfig();
  }

  public static com.google.privacy.dlp.v2.DataProfileJobConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataProfileJobConfig> PARSER =
      new com.google.protobuf.AbstractParser<DataProfileJobConfig>() {
        @java.lang.Override
        public DataProfileJobConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataProfileJobConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataProfileJobConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileJobConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
