/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * A task to execute when a data profile has been generated.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.DataProfileAction}
 */
public final class DataProfileAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DataProfileAction)
    DataProfileActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataProfileAction.newBuilder() to construct.
  private DataProfileAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataProfileAction() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataProfileAction();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DataProfileAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_DataProfileAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.DataProfileAction.class,
            com.google.privacy.dlp.v2.DataProfileAction.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Types of event that can trigger an action.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.DataProfileAction.EventType}
   */
  public enum EventType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>EVENT_TYPE_UNSPECIFIED = 0;</code>
     */
    EVENT_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * New profile (not a re-profile).
     * </pre>
     *
     * <code>NEW_PROFILE = 1;</code>
     */
    NEW_PROFILE(1),
    /**
     *
     *
     * <pre>
     * Changed one of the following profile metrics:
     * * Table data risk score
     * * Table sensitivity score
     * * Table resource visibility
     * * Table encryption type
     * * Table predicted infoTypes
     * * Table other infoTypes
     * </pre>
     *
     * <code>CHANGED_PROFILE = 2;</code>
     */
    CHANGED_PROFILE(2),
    /**
     *
     *
     * <pre>
     * Table data risk score or sensitivity score increased.
     * </pre>
     *
     * <code>SCORE_INCREASED = 3;</code>
     */
    SCORE_INCREASED(3),
    /**
     *
     *
     * <pre>
     * A user (non-internal) error occurred.
     * </pre>
     *
     * <code>ERROR_CHANGED = 4;</code>
     */
    ERROR_CHANGED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>EVENT_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int EVENT_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * New profile (not a re-profile).
     * </pre>
     *
     * <code>NEW_PROFILE = 1;</code>
     */
    public static final int NEW_PROFILE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Changed one of the following profile metrics:
     * * Table data risk score
     * * Table sensitivity score
     * * Table resource visibility
     * * Table encryption type
     * * Table predicted infoTypes
     * * Table other infoTypes
     * </pre>
     *
     * <code>CHANGED_PROFILE = 2;</code>
     */
    public static final int CHANGED_PROFILE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Table data risk score or sensitivity score increased.
     * </pre>
     *
     * <code>SCORE_INCREASED = 3;</code>
     */
    public static final int SCORE_INCREASED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * A user (non-internal) error occurred.
     * </pre>
     *
     * <code>ERROR_CHANGED = 4;</code>
     */
    public static final int ERROR_CHANGED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EventType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EventType forNumber(int value) {
      switch (value) {
        case 0:
          return EVENT_TYPE_UNSPECIFIED;
        case 1:
          return NEW_PROFILE;
        case 2:
          return CHANGED_PROFILE;
        case 3:
          return SCORE_INCREASED;
        case 4:
          return ERROR_CHANGED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EventType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EventType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<EventType>() {
          public EventType findValueByNumber(int number) {
            return EventType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DataProfileAction.getDescriptor().getEnumTypes().get(0);
    }

    private static final EventType[] VALUES = values();

    public static EventType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EventType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.DataProfileAction.EventType)
  }

  public interface ExportOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.DataProfileAction.Export)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Store all table and column profiles in an existing table or a new table
     * in an existing dataset. Each re-generation will result in a new row in
     * BigQuery.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
     *
     * @return Whether the profileTable field is set.
     */
    boolean hasProfileTable();
    /**
     *
     *
     * <pre>
     * Store all table and column profiles in an existing table or a new table
     * in an existing dataset. Each re-generation will result in a new row in
     * BigQuery.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
     *
     * @return The profileTable.
     */
    com.google.privacy.dlp.v2.BigQueryTable getProfileTable();
    /**
     *
     *
     * <pre>
     * Store all table and column profiles in an existing table or a new table
     * in an existing dataset. Each re-generation will result in a new row in
     * BigQuery.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
     */
    com.google.privacy.dlp.v2.BigQueryTableOrBuilder getProfileTableOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * If set, the detailed data profiles will be persisted to the location
   * of your choice whenever updated.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DataProfileAction.Export}
   */
  public static final class Export extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DataProfileAction.Export)
      ExportOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Export.newBuilder() to construct.
    private Export(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Export() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Export();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfileAction_Export_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfileAction_Export_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DataProfileAction.Export.class,
              com.google.privacy.dlp.v2.DataProfileAction.Export.Builder.class);
    }

    public static final int PROFILE_TABLE_FIELD_NUMBER = 1;
    private com.google.privacy.dlp.v2.BigQueryTable profileTable_;
    /**
     *
     *
     * <pre>
     * Store all table and column profiles in an existing table or a new table
     * in an existing dataset. Each re-generation will result in a new row in
     * BigQuery.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
     *
     * @return Whether the profileTable field is set.
     */
    @java.lang.Override
    public boolean hasProfileTable() {
      return profileTable_ != null;
    }
    /**
     *
     *
     * <pre>
     * Store all table and column profiles in an existing table or a new table
     * in an existing dataset. Each re-generation will result in a new row in
     * BigQuery.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
     *
     * @return The profileTable.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryTable getProfileTable() {
      return profileTable_ == null
          ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()
          : profileTable_;
    }
    /**
     *
     *
     * <pre>
     * Store all table and column profiles in an existing table or a new table
     * in an existing dataset. Each re-generation will result in a new row in
     * BigQuery.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.BigQueryTableOrBuilder getProfileTableOrBuilder() {
      return getProfileTable();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (profileTable_ != null) {
        output.writeMessage(1, getProfileTable());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (profileTable_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getProfileTable());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.DataProfileAction.Export)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.DataProfileAction.Export other =
          (com.google.privacy.dlp.v2.DataProfileAction.Export) obj;

      if (hasProfileTable() != other.hasProfileTable()) return false;
      if (hasProfileTable()) {
        if (!getProfileTable().equals(other.getProfileTable())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasProfileTable()) {
        hash = (37 * hash) + PROFILE_TABLE_FIELD_NUMBER;
        hash = (53 * hash) + getProfileTable().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.privacy.dlp.v2.DataProfileAction.Export prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * If set, the detailed data profiles will be persisted to the location
     * of your choice whenever updated.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.DataProfileAction.Export}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DataProfileAction.Export)
        com.google.privacy.dlp.v2.DataProfileAction.ExportOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DataProfileAction_Export_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DataProfileAction_Export_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.DataProfileAction.Export.class,
                com.google.privacy.dlp.v2.DataProfileAction.Export.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.DataProfileAction.Export.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (profileTableBuilder_ == null) {
          profileTable_ = null;
        } else {
          profileTable_ = null;
          profileTableBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DataProfileAction_Export_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfileAction.Export getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.DataProfileAction.Export.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfileAction.Export build() {
        com.google.privacy.dlp.v2.DataProfileAction.Export result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfileAction.Export buildPartial() {
        com.google.privacy.dlp.v2.DataProfileAction.Export result =
            new com.google.privacy.dlp.v2.DataProfileAction.Export(this);
        if (profileTableBuilder_ == null) {
          result.profileTable_ = profileTable_;
        } else {
          result.profileTable_ = profileTableBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.DataProfileAction.Export) {
          return mergeFrom((com.google.privacy.dlp.v2.DataProfileAction.Export) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.DataProfileAction.Export other) {
        if (other == com.google.privacy.dlp.v2.DataProfileAction.Export.getDefaultInstance())
          return this;
        if (other.hasProfileTable()) {
          mergeProfileTable(other.getProfileTable());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getProfileTableFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private com.google.privacy.dlp.v2.BigQueryTable profileTable_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.BigQueryTable,
              com.google.privacy.dlp.v2.BigQueryTable.Builder,
              com.google.privacy.dlp.v2.BigQueryTableOrBuilder>
          profileTableBuilder_;
      /**
       *
       *
       * <pre>
       * Store all table and column profiles in an existing table or a new table
       * in an existing dataset. Each re-generation will result in a new row in
       * BigQuery.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
       *
       * @return Whether the profileTable field is set.
       */
      public boolean hasProfileTable() {
        return profileTableBuilder_ != null || profileTable_ != null;
      }
      /**
       *
       *
       * <pre>
       * Store all table and column profiles in an existing table or a new table
       * in an existing dataset. Each re-generation will result in a new row in
       * BigQuery.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
       *
       * @return The profileTable.
       */
      public com.google.privacy.dlp.v2.BigQueryTable getProfileTable() {
        if (profileTableBuilder_ == null) {
          return profileTable_ == null
              ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()
              : profileTable_;
        } else {
          return profileTableBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Store all table and column profiles in an existing table or a new table
       * in an existing dataset. Each re-generation will result in a new row in
       * BigQuery.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
       */
      public Builder setProfileTable(com.google.privacy.dlp.v2.BigQueryTable value) {
        if (profileTableBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          profileTable_ = value;
          onChanged();
        } else {
          profileTableBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Store all table and column profiles in an existing table or a new table
       * in an existing dataset. Each re-generation will result in a new row in
       * BigQuery.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
       */
      public Builder setProfileTable(
          com.google.privacy.dlp.v2.BigQueryTable.Builder builderForValue) {
        if (profileTableBuilder_ == null) {
          profileTable_ = builderForValue.build();
          onChanged();
        } else {
          profileTableBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Store all table and column profiles in an existing table or a new table
       * in an existing dataset. Each re-generation will result in a new row in
       * BigQuery.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
       */
      public Builder mergeProfileTable(com.google.privacy.dlp.v2.BigQueryTable value) {
        if (profileTableBuilder_ == null) {
          if (profileTable_ != null) {
            profileTable_ =
                com.google.privacy.dlp.v2.BigQueryTable.newBuilder(profileTable_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            profileTable_ = value;
          }
          onChanged();
        } else {
          profileTableBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Store all table and column profiles in an existing table or a new table
       * in an existing dataset. Each re-generation will result in a new row in
       * BigQuery.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
       */
      public Builder clearProfileTable() {
        if (profileTableBuilder_ == null) {
          profileTable_ = null;
          onChanged();
        } else {
          profileTable_ = null;
          profileTableBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Store all table and column profiles in an existing table or a new table
       * in an existing dataset. Each re-generation will result in a new row in
       * BigQuery.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
       */
      public com.google.privacy.dlp.v2.BigQueryTable.Builder getProfileTableBuilder() {

        onChanged();
        return getProfileTableFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Store all table and column profiles in an existing table or a new table
       * in an existing dataset. Each re-generation will result in a new row in
       * BigQuery.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
       */
      public com.google.privacy.dlp.v2.BigQueryTableOrBuilder getProfileTableOrBuilder() {
        if (profileTableBuilder_ != null) {
          return profileTableBuilder_.getMessageOrBuilder();
        } else {
          return profileTable_ == null
              ? com.google.privacy.dlp.v2.BigQueryTable.getDefaultInstance()
              : profileTable_;
        }
      }
      /**
       *
       *
       * <pre>
       * Store all table and column profiles in an existing table or a new table
       * in an existing dataset. Each re-generation will result in a new row in
       * BigQuery.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.BigQueryTable profile_table = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.BigQueryTable,
              com.google.privacy.dlp.v2.BigQueryTable.Builder,
              com.google.privacy.dlp.v2.BigQueryTableOrBuilder>
          getProfileTableFieldBuilder() {
        if (profileTableBuilder_ == null) {
          profileTableBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.BigQueryTable,
                  com.google.privacy.dlp.v2.BigQueryTable.Builder,
                  com.google.privacy.dlp.v2.BigQueryTableOrBuilder>(
                  getProfileTable(), getParentForChildren(), isClean());
          profileTable_ = null;
        }
        return profileTableBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DataProfileAction.Export)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DataProfileAction.Export)
    private static final com.google.privacy.dlp.v2.DataProfileAction.Export DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DataProfileAction.Export();
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.Export getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Export> PARSER =
        new com.google.protobuf.AbstractParser<Export>() {
          @java.lang.Override
          public Export parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Export> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Export> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileAction.Export getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PubSubNotificationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.DataProfileAction.PubSubNotification)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Cloud Pub/Sub topic to send notifications to.
     * Format is projects/{project}/topics/{topic}.
     * </pre>
     *
     * <code>string topic = 1;</code>
     *
     * @return The topic.
     */
    java.lang.String getTopic();
    /**
     *
     *
     * <pre>
     * Cloud Pub/Sub topic to send notifications to.
     * Format is projects/{project}/topics/{topic}.
     * </pre>
     *
     * <code>string topic = 1;</code>
     *
     * @return The bytes for topic.
     */
    com.google.protobuf.ByteString getTopicBytes();

    /**
     *
     *
     * <pre>
     * The type of event that triggers a Pub/Sub. At most one
     * `PubSubNotification` per EventType is permitted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.EventType event = 2;</code>
     *
     * @return The enum numeric value on the wire for event.
     */
    int getEventValue();
    /**
     *
     *
     * <pre>
     * The type of event that triggers a Pub/Sub. At most one
     * `PubSubNotification` per EventType is permitted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.EventType event = 2;</code>
     *
     * @return The event.
     */
    com.google.privacy.dlp.v2.DataProfileAction.EventType getEvent();

    /**
     *
     *
     * <pre>
     * Conditions (e.g., data risk or sensitivity level) for triggering a
     * Pub/Sub.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
     *
     * @return Whether the pubsubCondition field is set.
     */
    boolean hasPubsubCondition();
    /**
     *
     *
     * <pre>
     * Conditions (e.g., data risk or sensitivity level) for triggering a
     * Pub/Sub.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
     *
     * @return The pubsubCondition.
     */
    com.google.privacy.dlp.v2.DataProfilePubSubCondition getPubsubCondition();
    /**
     *
     *
     * <pre>
     * Conditions (e.g., data risk or sensitivity level) for triggering a
     * Pub/Sub.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
     */
    com.google.privacy.dlp.v2.DataProfilePubSubConditionOrBuilder getPubsubConditionOrBuilder();

    /**
     *
     *
     * <pre>
     * How much data to include in the Pub/Sub message. If the user wishes to
     * limit the size of the message, they can use resource_name and fetch the
     * profile fields they wish to. Per table profile (not per column).
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel detail_of_message = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for detailOfMessage.
     */
    int getDetailOfMessageValue();
    /**
     *
     *
     * <pre>
     * How much data to include in the Pub/Sub message. If the user wishes to
     * limit the size of the message, they can use resource_name and fetch the
     * profile fields they wish to. Per table profile (not per column).
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel detail_of_message = 4;
     * </code>
     *
     * @return The detailOfMessage.
     */
    com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel getDetailOfMessage();
  }
  /**
   *
   *
   * <pre>
   * Send a Pub/Sub message into the given Pub/Sub topic to connect other
   * systems to data profile generation. The message payload data will
   * be the byte serialization of `DataProfilePubSubMessage`.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DataProfileAction.PubSubNotification}
   */
  public static final class PubSubNotification extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.DataProfileAction.PubSubNotification)
      PubSubNotificationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PubSubNotification.newBuilder() to construct.
    private PubSubNotification(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PubSubNotification() {
      topic_ = "";
      event_ = 0;
      detailOfMessage_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PubSubNotification();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfileAction_PubSubNotification_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfileAction_PubSubNotification_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.class,
              com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The levels of detail that can be included in the Pub/Sub message.
     * </pre>
     *
     * Protobuf enum {@code google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel}
     */
    public enum DetailLevel implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unused.
       * </pre>
       *
       * <code>DETAIL_LEVEL_UNSPECIFIED = 0;</code>
       */
      DETAIL_LEVEL_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The full table data profile.
       * </pre>
       *
       * <code>TABLE_PROFILE = 1;</code>
       */
      TABLE_PROFILE(1),
      /**
       *
       *
       * <pre>
       * The resource name of the table.
       * </pre>
       *
       * <code>RESOURCE_NAME = 2;</code>
       */
      RESOURCE_NAME(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unused.
       * </pre>
       *
       * <code>DETAIL_LEVEL_UNSPECIFIED = 0;</code>
       */
      public static final int DETAIL_LEVEL_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The full table data profile.
       * </pre>
       *
       * <code>TABLE_PROFILE = 1;</code>
       */
      public static final int TABLE_PROFILE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The resource name of the table.
       * </pre>
       *
       * <code>RESOURCE_NAME = 2;</code>
       */
      public static final int RESOURCE_NAME_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DetailLevel valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static DetailLevel forNumber(int value) {
        switch (value) {
          case 0:
            return DETAIL_LEVEL_UNSPECIFIED;
          case 1:
            return TABLE_PROFILE;
          case 2:
            return RESOURCE_NAME;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<DetailLevel> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<DetailLevel> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DetailLevel>() {
            public DetailLevel findValueByNumber(int number) {
              return DetailLevel.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final DetailLevel[] VALUES = values();

      public static DetailLevel valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private DetailLevel(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel)
    }

    public static final int TOPIC_FIELD_NUMBER = 1;
    private volatile java.lang.Object topic_;
    /**
     *
     *
     * <pre>
     * Cloud Pub/Sub topic to send notifications to.
     * Format is projects/{project}/topics/{topic}.
     * </pre>
     *
     * <code>string topic = 1;</code>
     *
     * @return The topic.
     */
    @java.lang.Override
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Pub/Sub topic to send notifications to.
     * Format is projects/{project}/topics/{topic}.
     * </pre>
     *
     * <code>string topic = 1;</code>
     *
     * @return The bytes for topic.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EVENT_FIELD_NUMBER = 2;
    private int event_;
    /**
     *
     *
     * <pre>
     * The type of event that triggers a Pub/Sub. At most one
     * `PubSubNotification` per EventType is permitted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.EventType event = 2;</code>
     *
     * @return The enum numeric value on the wire for event.
     */
    @java.lang.Override
    public int getEventValue() {
      return event_;
    }
    /**
     *
     *
     * <pre>
     * The type of event that triggers a Pub/Sub. At most one
     * `PubSubNotification` per EventType is permitted.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.EventType event = 2;</code>
     *
     * @return The event.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileAction.EventType getEvent() {
      @SuppressWarnings("deprecation")
      com.google.privacy.dlp.v2.DataProfileAction.EventType result =
          com.google.privacy.dlp.v2.DataProfileAction.EventType.valueOf(event_);
      return result == null
          ? com.google.privacy.dlp.v2.DataProfileAction.EventType.UNRECOGNIZED
          : result;
    }

    public static final int PUBSUB_CONDITION_FIELD_NUMBER = 3;
    private com.google.privacy.dlp.v2.DataProfilePubSubCondition pubsubCondition_;
    /**
     *
     *
     * <pre>
     * Conditions (e.g., data risk or sensitivity level) for triggering a
     * Pub/Sub.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
     *
     * @return Whether the pubsubCondition field is set.
     */
    @java.lang.Override
    public boolean hasPubsubCondition() {
      return pubsubCondition_ != null;
    }
    /**
     *
     *
     * <pre>
     * Conditions (e.g., data risk or sensitivity level) for triggering a
     * Pub/Sub.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
     *
     * @return The pubsubCondition.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfilePubSubCondition getPubsubCondition() {
      return pubsubCondition_ == null
          ? com.google.privacy.dlp.v2.DataProfilePubSubCondition.getDefaultInstance()
          : pubsubCondition_;
    }
    /**
     *
     *
     * <pre>
     * Conditions (e.g., data risk or sensitivity level) for triggering a
     * Pub/Sub.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfilePubSubConditionOrBuilder
        getPubsubConditionOrBuilder() {
      return getPubsubCondition();
    }

    public static final int DETAIL_OF_MESSAGE_FIELD_NUMBER = 4;
    private int detailOfMessage_;
    /**
     *
     *
     * <pre>
     * How much data to include in the Pub/Sub message. If the user wishes to
     * limit the size of the message, they can use resource_name and fetch the
     * profile fields they wish to. Per table profile (not per column).
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel detail_of_message = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for detailOfMessage.
     */
    @java.lang.Override
    public int getDetailOfMessageValue() {
      return detailOfMessage_;
    }
    /**
     *
     *
     * <pre>
     * How much data to include in the Pub/Sub message. If the user wishes to
     * limit the size of the message, they can use resource_name and fetch the
     * profile fields they wish to. Per table profile (not per column).
     * </pre>
     *
     * <code>
     * .google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel detail_of_message = 4;
     * </code>
     *
     * @return The detailOfMessage.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel
        getDetailOfMessage() {
      @SuppressWarnings("deprecation")
      com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel result =
          com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel.valueOf(
              detailOfMessage_);
      return result == null
          ? com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, topic_);
      }
      if (event_
          != com.google.privacy.dlp.v2.DataProfileAction.EventType.EVENT_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, event_);
      }
      if (pubsubCondition_ != null) {
        output.writeMessage(3, getPubsubCondition());
      }
      if (detailOfMessage_
          != com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel
              .DETAIL_LEVEL_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, detailOfMessage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, topic_);
      }
      if (event_
          != com.google.privacy.dlp.v2.DataProfileAction.EventType.EVENT_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, event_);
      }
      if (pubsubCondition_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPubsubCondition());
      }
      if (detailOfMessage_
          != com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel
              .DETAIL_LEVEL_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, detailOfMessage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification other =
          (com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification) obj;

      if (!getTopic().equals(other.getTopic())) return false;
      if (event_ != other.event_) return false;
      if (hasPubsubCondition() != other.hasPubsubCondition()) return false;
      if (hasPubsubCondition()) {
        if (!getPubsubCondition().equals(other.getPubsubCondition())) return false;
      }
      if (detailOfMessage_ != other.detailOfMessage_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TOPIC_FIELD_NUMBER;
      hash = (53 * hash) + getTopic().hashCode();
      hash = (37 * hash) + EVENT_FIELD_NUMBER;
      hash = (53 * hash) + event_;
      if (hasPubsubCondition()) {
        hash = (37 * hash) + PUBSUB_CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getPubsubCondition().hashCode();
      }
      hash = (37 * hash) + DETAIL_OF_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + detailOfMessage_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Send a Pub/Sub message into the given Pub/Sub topic to connect other
     * systems to data profile generation. The message payload data will
     * be the byte serialization of `DataProfilePubSubMessage`.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.DataProfileAction.PubSubNotification}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DataProfileAction.PubSubNotification)
        com.google.privacy.dlp.v2.DataProfileAction.PubSubNotificationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DataProfileAction_PubSubNotification_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DataProfileAction_PubSubNotification_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.class,
                com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        topic_ = "";

        event_ = 0;

        if (pubsubConditionBuilder_ == null) {
          pubsubCondition_ = null;
        } else {
          pubsubCondition_ = null;
          pubsubConditionBuilder_ = null;
        }
        detailOfMessage_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpProto
            .internal_static_google_privacy_dlp_v2_DataProfileAction_PubSubNotification_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification
          getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification build() {
        com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification buildPartial() {
        com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification result =
            new com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification(this);
        result.topic_ = topic_;
        result.event_ = event_;
        if (pubsubConditionBuilder_ == null) {
          result.pubsubCondition_ = pubsubCondition_;
        } else {
          result.pubsubCondition_ = pubsubConditionBuilder_.build();
        }
        result.detailOfMessage_ = detailOfMessage_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification) {
          return mergeFrom((com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification other) {
        if (other
            == com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.getDefaultInstance())
          return this;
        if (!other.getTopic().isEmpty()) {
          topic_ = other.topic_;
          onChanged();
        }
        if (other.event_ != 0) {
          setEventValue(other.getEventValue());
        }
        if (other.hasPubsubCondition()) {
          mergePubsubCondition(other.getPubsubCondition());
        }
        if (other.detailOfMessage_ != 0) {
          setDetailOfMessageValue(other.getDetailOfMessageValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  topic_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 16:
                {
                  event_ = input.readEnum();

                  break;
                } // case 16
              case 26:
                {
                  input.readMessage(
                      getPubsubConditionFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 26
              case 32:
                {
                  detailOfMessage_ = input.readEnum();

                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object topic_ = "";
      /**
       *
       *
       * <pre>
       * Cloud Pub/Sub topic to send notifications to.
       * Format is projects/{project}/topics/{topic}.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @return The topic.
       */
      public java.lang.String getTopic() {
        java.lang.Object ref = topic_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          topic_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Pub/Sub topic to send notifications to.
       * Format is projects/{project}/topics/{topic}.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @return The bytes for topic.
       */
      public com.google.protobuf.ByteString getTopicBytes() {
        java.lang.Object ref = topic_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          topic_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Cloud Pub/Sub topic to send notifications to.
       * Format is projects/{project}/topics/{topic}.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @param value The topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopic(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        topic_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Pub/Sub topic to send notifications to.
       * Format is projects/{project}/topics/{topic}.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopic() {

        topic_ = getDefaultInstance().getTopic();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Cloud Pub/Sub topic to send notifications to.
       * Format is projects/{project}/topics/{topic}.
       * </pre>
       *
       * <code>string topic = 1;</code>
       *
       * @param value The bytes for topic to set.
       * @return This builder for chaining.
       */
      public Builder setTopicBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        topic_ = value;
        onChanged();
        return this;
      }

      private int event_ = 0;
      /**
       *
       *
       * <pre>
       * The type of event that triggers a Pub/Sub. At most one
       * `PubSubNotification` per EventType is permitted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfileAction.EventType event = 2;</code>
       *
       * @return The enum numeric value on the wire for event.
       */
      @java.lang.Override
      public int getEventValue() {
        return event_;
      }
      /**
       *
       *
       * <pre>
       * The type of event that triggers a Pub/Sub. At most one
       * `PubSubNotification` per EventType is permitted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfileAction.EventType event = 2;</code>
       *
       * @param value The enum numeric value on the wire for event to set.
       * @return This builder for chaining.
       */
      public Builder setEventValue(int value) {

        event_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of event that triggers a Pub/Sub. At most one
       * `PubSubNotification` per EventType is permitted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfileAction.EventType event = 2;</code>
       *
       * @return The event.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfileAction.EventType getEvent() {
        @SuppressWarnings("deprecation")
        com.google.privacy.dlp.v2.DataProfileAction.EventType result =
            com.google.privacy.dlp.v2.DataProfileAction.EventType.valueOf(event_);
        return result == null
            ? com.google.privacy.dlp.v2.DataProfileAction.EventType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The type of event that triggers a Pub/Sub. At most one
       * `PubSubNotification` per EventType is permitted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfileAction.EventType event = 2;</code>
       *
       * @param value The event to set.
       * @return This builder for chaining.
       */
      public Builder setEvent(com.google.privacy.dlp.v2.DataProfileAction.EventType value) {
        if (value == null) {
          throw new NullPointerException();
        }

        event_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of event that triggers a Pub/Sub. At most one
       * `PubSubNotification` per EventType is permitted.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfileAction.EventType event = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEvent() {

        event_ = 0;
        onChanged();
        return this;
      }

      private com.google.privacy.dlp.v2.DataProfilePubSubCondition pubsubCondition_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.DataProfilePubSubCondition,
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.Builder,
              com.google.privacy.dlp.v2.DataProfilePubSubConditionOrBuilder>
          pubsubConditionBuilder_;
      /**
       *
       *
       * <pre>
       * Conditions (e.g., data risk or sensitivity level) for triggering a
       * Pub/Sub.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
       *
       * @return Whether the pubsubCondition field is set.
       */
      public boolean hasPubsubCondition() {
        return pubsubConditionBuilder_ != null || pubsubCondition_ != null;
      }
      /**
       *
       *
       * <pre>
       * Conditions (e.g., data risk or sensitivity level) for triggering a
       * Pub/Sub.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
       *
       * @return The pubsubCondition.
       */
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition getPubsubCondition() {
        if (pubsubConditionBuilder_ == null) {
          return pubsubCondition_ == null
              ? com.google.privacy.dlp.v2.DataProfilePubSubCondition.getDefaultInstance()
              : pubsubCondition_;
        } else {
          return pubsubConditionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Conditions (e.g., data risk or sensitivity level) for triggering a
       * Pub/Sub.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
       */
      public Builder setPubsubCondition(
          com.google.privacy.dlp.v2.DataProfilePubSubCondition value) {
        if (pubsubConditionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          pubsubCondition_ = value;
          onChanged();
        } else {
          pubsubConditionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions (e.g., data risk or sensitivity level) for triggering a
       * Pub/Sub.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
       */
      public Builder setPubsubCondition(
          com.google.privacy.dlp.v2.DataProfilePubSubCondition.Builder builderForValue) {
        if (pubsubConditionBuilder_ == null) {
          pubsubCondition_ = builderForValue.build();
          onChanged();
        } else {
          pubsubConditionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions (e.g., data risk or sensitivity level) for triggering a
       * Pub/Sub.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
       */
      public Builder mergePubsubCondition(
          com.google.privacy.dlp.v2.DataProfilePubSubCondition value) {
        if (pubsubConditionBuilder_ == null) {
          if (pubsubCondition_ != null) {
            pubsubCondition_ =
                com.google.privacy.dlp.v2.DataProfilePubSubCondition.newBuilder(pubsubCondition_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            pubsubCondition_ = value;
          }
          onChanged();
        } else {
          pubsubConditionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions (e.g., data risk or sensitivity level) for triggering a
       * Pub/Sub.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
       */
      public Builder clearPubsubCondition() {
        if (pubsubConditionBuilder_ == null) {
          pubsubCondition_ = null;
          onChanged();
        } else {
          pubsubCondition_ = null;
          pubsubConditionBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * Conditions (e.g., data risk or sensitivity level) for triggering a
       * Pub/Sub.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
       */
      public com.google.privacy.dlp.v2.DataProfilePubSubCondition.Builder
          getPubsubConditionBuilder() {

        onChanged();
        return getPubsubConditionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Conditions (e.g., data risk or sensitivity level) for triggering a
       * Pub/Sub.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
       */
      public com.google.privacy.dlp.v2.DataProfilePubSubConditionOrBuilder
          getPubsubConditionOrBuilder() {
        if (pubsubConditionBuilder_ != null) {
          return pubsubConditionBuilder_.getMessageOrBuilder();
        } else {
          return pubsubCondition_ == null
              ? com.google.privacy.dlp.v2.DataProfilePubSubCondition.getDefaultInstance()
              : pubsubCondition_;
        }
      }
      /**
       *
       *
       * <pre>
       * Conditions (e.g., data risk or sensitivity level) for triggering a
       * Pub/Sub.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.DataProfilePubSubCondition pubsub_condition = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.DataProfilePubSubCondition,
              com.google.privacy.dlp.v2.DataProfilePubSubCondition.Builder,
              com.google.privacy.dlp.v2.DataProfilePubSubConditionOrBuilder>
          getPubsubConditionFieldBuilder() {
        if (pubsubConditionBuilder_ == null) {
          pubsubConditionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.DataProfilePubSubCondition,
                  com.google.privacy.dlp.v2.DataProfilePubSubCondition.Builder,
                  com.google.privacy.dlp.v2.DataProfilePubSubConditionOrBuilder>(
                  getPubsubCondition(), getParentForChildren(), isClean());
          pubsubCondition_ = null;
        }
        return pubsubConditionBuilder_;
      }

      private int detailOfMessage_ = 0;
      /**
       *
       *
       * <pre>
       * How much data to include in the Pub/Sub message. If the user wishes to
       * limit the size of the message, they can use resource_name and fetch the
       * profile fields they wish to. Per table profile (not per column).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel detail_of_message = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for detailOfMessage.
       */
      @java.lang.Override
      public int getDetailOfMessageValue() {
        return detailOfMessage_;
      }
      /**
       *
       *
       * <pre>
       * How much data to include in the Pub/Sub message. If the user wishes to
       * limit the size of the message, they can use resource_name and fetch the
       * profile fields they wish to. Per table profile (not per column).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel detail_of_message = 4;
       * </code>
       *
       * @param value The enum numeric value on the wire for detailOfMessage to set.
       * @return This builder for chaining.
       */
      public Builder setDetailOfMessageValue(int value) {

        detailOfMessage_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * How much data to include in the Pub/Sub message. If the user wishes to
       * limit the size of the message, they can use resource_name and fetch the
       * profile fields they wish to. Per table profile (not per column).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel detail_of_message = 4;
       * </code>
       *
       * @return The detailOfMessage.
       */
      @java.lang.Override
      public com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel
          getDetailOfMessage() {
        @SuppressWarnings("deprecation")
        com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel result =
            com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel.valueOf(
                detailOfMessage_);
        return result == null
            ? com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * How much data to include in the Pub/Sub message. If the user wishes to
       * limit the size of the message, they can use resource_name and fetch the
       * profile fields they wish to. Per table profile (not per column).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel detail_of_message = 4;
       * </code>
       *
       * @param value The detailOfMessage to set.
       * @return This builder for chaining.
       */
      public Builder setDetailOfMessage(
          com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel value) {
        if (value == null) {
          throw new NullPointerException();
        }

        detailOfMessage_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * How much data to include in the Pub/Sub message. If the user wishes to
       * limit the size of the message, they can use resource_name and fetch the
       * profile fields they wish to. Per table profile (not per column).
       * </pre>
       *
       * <code>
       * .google.privacy.dlp.v2.DataProfileAction.PubSubNotification.DetailLevel detail_of_message = 4;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDetailOfMessage() {

        detailOfMessage_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DataProfileAction.PubSubNotification)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DataProfileAction.PubSubNotification)
    private static final com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification();
    }

    public static com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PubSubNotification> PARSER =
        new com.google.protobuf.AbstractParser<PubSubNotification>() {
          @java.lang.Override
          public PubSubNotification parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PubSubNotification> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PubSubNotification> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int actionCase_ = 0;
  private java.lang.Object action_;

  public enum ActionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXPORT_DATA(1),
    PUB_SUB_NOTIFICATION(2),
    ACTION_NOT_SET(0);
    private final int value;

    private ActionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ActionCase valueOf(int value) {
      return forNumber(value);
    }

    public static ActionCase forNumber(int value) {
      switch (value) {
        case 1:
          return EXPORT_DATA;
        case 2:
          return PUB_SUB_NOTIFICATION;
        case 0:
          return ACTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ActionCase getActionCase() {
    return ActionCase.forNumber(actionCase_);
  }

  public static final int EXPORT_DATA_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Export data profiles into a provided location.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileAction.Export export_data = 1;</code>
   *
   * @return Whether the exportData field is set.
   */
  @java.lang.Override
  public boolean hasExportData() {
    return actionCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Export data profiles into a provided location.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileAction.Export export_data = 1;</code>
   *
   * @return The exportData.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileAction.Export getExportData() {
    if (actionCase_ == 1) {
      return (com.google.privacy.dlp.v2.DataProfileAction.Export) action_;
    }
    return com.google.privacy.dlp.v2.DataProfileAction.Export.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Export data profiles into a provided location.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileAction.Export export_data = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileAction.ExportOrBuilder getExportDataOrBuilder() {
    if (actionCase_ == 1) {
      return (com.google.privacy.dlp.v2.DataProfileAction.Export) action_;
    }
    return com.google.privacy.dlp.v2.DataProfileAction.Export.getDefaultInstance();
  }

  public static final int PUB_SUB_NOTIFICATION_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Publish a message into the Pub/Sub topic.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileAction.PubSubNotification pub_sub_notification = 2;
   * </code>
   *
   * @return Whether the pubSubNotification field is set.
   */
  @java.lang.Override
  public boolean hasPubSubNotification() {
    return actionCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Publish a message into the Pub/Sub topic.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileAction.PubSubNotification pub_sub_notification = 2;
   * </code>
   *
   * @return The pubSubNotification.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification getPubSubNotification() {
    if (actionCase_ == 2) {
      return (com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification) action_;
    }
    return com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Publish a message into the Pub/Sub topic.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.DataProfileAction.PubSubNotification pub_sub_notification = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileAction.PubSubNotificationOrBuilder
      getPubSubNotificationOrBuilder() {
    if (actionCase_ == 2) {
      return (com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification) action_;
    }
    return com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (actionCase_ == 1) {
      output.writeMessage(1, (com.google.privacy.dlp.v2.DataProfileAction.Export) action_);
    }
    if (actionCase_ == 2) {
      output.writeMessage(
          2, (com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification) action_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (actionCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.privacy.dlp.v2.DataProfileAction.Export) action_);
    }
    if (actionCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification) action_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.DataProfileAction)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.DataProfileAction other =
        (com.google.privacy.dlp.v2.DataProfileAction) obj;

    if (!getActionCase().equals(other.getActionCase())) return false;
    switch (actionCase_) {
      case 1:
        if (!getExportData().equals(other.getExportData())) return false;
        break;
      case 2:
        if (!getPubSubNotification().equals(other.getPubSubNotification())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (actionCase_) {
      case 1:
        hash = (37 * hash) + EXPORT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getExportData().hashCode();
        break;
      case 2:
        hash = (37 * hash) + PUB_SUB_NOTIFICATION_FIELD_NUMBER;
        hash = (53 * hash) + getPubSubNotification().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.DataProfileAction parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DataProfileAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfileAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DataProfileAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfileAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.DataProfileAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfileAction parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DataProfileAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfileAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DataProfileAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.DataProfileAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.DataProfileAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.DataProfileAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A task to execute when a data profile has been generated.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.DataProfileAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.DataProfileAction)
      com.google.privacy.dlp.v2.DataProfileActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfileAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfileAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.DataProfileAction.class,
              com.google.privacy.dlp.v2.DataProfileAction.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.DataProfileAction.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (exportDataBuilder_ != null) {
        exportDataBuilder_.clear();
      }
      if (pubSubNotificationBuilder_ != null) {
        pubSubNotificationBuilder_.clear();
      }
      actionCase_ = 0;
      action_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_DataProfileAction_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileAction getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.DataProfileAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileAction build() {
      com.google.privacy.dlp.v2.DataProfileAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileAction buildPartial() {
      com.google.privacy.dlp.v2.DataProfileAction result =
          new com.google.privacy.dlp.v2.DataProfileAction(this);
      if (actionCase_ == 1) {
        if (exportDataBuilder_ == null) {
          result.action_ = action_;
        } else {
          result.action_ = exportDataBuilder_.build();
        }
      }
      if (actionCase_ == 2) {
        if (pubSubNotificationBuilder_ == null) {
          result.action_ = action_;
        } else {
          result.action_ = pubSubNotificationBuilder_.build();
        }
      }
      result.actionCase_ = actionCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.DataProfileAction) {
        return mergeFrom((com.google.privacy.dlp.v2.DataProfileAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.DataProfileAction other) {
      if (other == com.google.privacy.dlp.v2.DataProfileAction.getDefaultInstance()) return this;
      switch (other.getActionCase()) {
        case EXPORT_DATA:
          {
            mergeExportData(other.getExportData());
            break;
          }
        case PUB_SUB_NOTIFICATION:
          {
            mergePubSubNotification(other.getPubSubNotification());
            break;
          }
        case ACTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getExportDataFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getPubSubNotificationFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int actionCase_ = 0;
    private java.lang.Object action_;

    public ActionCase getActionCase() {
      return ActionCase.forNumber(actionCase_);
    }

    public Builder clearAction() {
      actionCase_ = 0;
      action_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfileAction.Export,
            com.google.privacy.dlp.v2.DataProfileAction.Export.Builder,
            com.google.privacy.dlp.v2.DataProfileAction.ExportOrBuilder>
        exportDataBuilder_;
    /**
     *
     *
     * <pre>
     * Export data profiles into a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.Export export_data = 1;</code>
     *
     * @return Whether the exportData field is set.
     */
    @java.lang.Override
    public boolean hasExportData() {
      return actionCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Export data profiles into a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.Export export_data = 1;</code>
     *
     * @return The exportData.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileAction.Export getExportData() {
      if (exportDataBuilder_ == null) {
        if (actionCase_ == 1) {
          return (com.google.privacy.dlp.v2.DataProfileAction.Export) action_;
        }
        return com.google.privacy.dlp.v2.DataProfileAction.Export.getDefaultInstance();
      } else {
        if (actionCase_ == 1) {
          return exportDataBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.DataProfileAction.Export.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Export data profiles into a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.Export export_data = 1;</code>
     */
    public Builder setExportData(com.google.privacy.dlp.v2.DataProfileAction.Export value) {
      if (exportDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        exportDataBuilder_.setMessage(value);
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Export data profiles into a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.Export export_data = 1;</code>
     */
    public Builder setExportData(
        com.google.privacy.dlp.v2.DataProfileAction.Export.Builder builderForValue) {
      if (exportDataBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        exportDataBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Export data profiles into a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.Export export_data = 1;</code>
     */
    public Builder mergeExportData(com.google.privacy.dlp.v2.DataProfileAction.Export value) {
      if (exportDataBuilder_ == null) {
        if (actionCase_ == 1
            && action_ != com.google.privacy.dlp.v2.DataProfileAction.Export.getDefaultInstance()) {
          action_ =
              com.google.privacy.dlp.v2.DataProfileAction.Export.newBuilder(
                      (com.google.privacy.dlp.v2.DataProfileAction.Export) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 1) {
          exportDataBuilder_.mergeFrom(value);
        } else {
          exportDataBuilder_.setMessage(value);
        }
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Export data profiles into a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.Export export_data = 1;</code>
     */
    public Builder clearExportData() {
      if (exportDataBuilder_ == null) {
        if (actionCase_ == 1) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 1) {
          actionCase_ = 0;
          action_ = null;
        }
        exportDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Export data profiles into a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.Export export_data = 1;</code>
     */
    public com.google.privacy.dlp.v2.DataProfileAction.Export.Builder getExportDataBuilder() {
      return getExportDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Export data profiles into a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.Export export_data = 1;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileAction.ExportOrBuilder getExportDataOrBuilder() {
      if ((actionCase_ == 1) && (exportDataBuilder_ != null)) {
        return exportDataBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 1) {
          return (com.google.privacy.dlp.v2.DataProfileAction.Export) action_;
        }
        return com.google.privacy.dlp.v2.DataProfileAction.Export.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Export data profiles into a provided location.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.Export export_data = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfileAction.Export,
            com.google.privacy.dlp.v2.DataProfileAction.Export.Builder,
            com.google.privacy.dlp.v2.DataProfileAction.ExportOrBuilder>
        getExportDataFieldBuilder() {
      if (exportDataBuilder_ == null) {
        if (!(actionCase_ == 1)) {
          action_ = com.google.privacy.dlp.v2.DataProfileAction.Export.getDefaultInstance();
        }
        exportDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DataProfileAction.Export,
                com.google.privacy.dlp.v2.DataProfileAction.Export.Builder,
                com.google.privacy.dlp.v2.DataProfileAction.ExportOrBuilder>(
                (com.google.privacy.dlp.v2.DataProfileAction.Export) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 1;
      onChanged();
      ;
      return exportDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification,
            com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.Builder,
            com.google.privacy.dlp.v2.DataProfileAction.PubSubNotificationOrBuilder>
        pubSubNotificationBuilder_;
    /**
     *
     *
     * <pre>
     * Publish a message into the Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.PubSubNotification pub_sub_notification = 2;
     * </code>
     *
     * @return Whether the pubSubNotification field is set.
     */
    @java.lang.Override
    public boolean hasPubSubNotification() {
      return actionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Publish a message into the Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.PubSubNotification pub_sub_notification = 2;
     * </code>
     *
     * @return The pubSubNotification.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification getPubSubNotification() {
      if (pubSubNotificationBuilder_ == null) {
        if (actionCase_ == 2) {
          return (com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification) action_;
        }
        return com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.getDefaultInstance();
      } else {
        if (actionCase_ == 2) {
          return pubSubNotificationBuilder_.getMessage();
        }
        return com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Publish a message into the Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.PubSubNotification pub_sub_notification = 2;
     * </code>
     */
    public Builder setPubSubNotification(
        com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification value) {
      if (pubSubNotificationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        pubSubNotificationBuilder_.setMessage(value);
      }
      actionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish a message into the Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.PubSubNotification pub_sub_notification = 2;
     * </code>
     */
    public Builder setPubSubNotification(
        com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.Builder builderForValue) {
      if (pubSubNotificationBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        pubSubNotificationBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish a message into the Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.PubSubNotification pub_sub_notification = 2;
     * </code>
     */
    public Builder mergePubSubNotification(
        com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification value) {
      if (pubSubNotificationBuilder_ == null) {
        if (actionCase_ == 2
            && action_
                != com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification
                    .getDefaultInstance()) {
          action_ =
              com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.newBuilder(
                      (com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 2) {
          pubSubNotificationBuilder_.mergeFrom(value);
        } else {
          pubSubNotificationBuilder_.setMessage(value);
        }
      }
      actionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish a message into the Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.PubSubNotification pub_sub_notification = 2;
     * </code>
     */
    public Builder clearPubSubNotification() {
      if (pubSubNotificationBuilder_ == null) {
        if (actionCase_ == 2) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 2) {
          actionCase_ = 0;
          action_ = null;
        }
        pubSubNotificationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Publish a message into the Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.PubSubNotification pub_sub_notification = 2;
     * </code>
     */
    public com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.Builder
        getPubSubNotificationBuilder() {
      return getPubSubNotificationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Publish a message into the Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.PubSubNotification pub_sub_notification = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.DataProfileAction.PubSubNotificationOrBuilder
        getPubSubNotificationOrBuilder() {
      if ((actionCase_ == 2) && (pubSubNotificationBuilder_ != null)) {
        return pubSubNotificationBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 2) {
          return (com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification) action_;
        }
        return com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Publish a message into the Pub/Sub topic.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.DataProfileAction.PubSubNotification pub_sub_notification = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification,
            com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.Builder,
            com.google.privacy.dlp.v2.DataProfileAction.PubSubNotificationOrBuilder>
        getPubSubNotificationFieldBuilder() {
      if (pubSubNotificationBuilder_ == null) {
        if (!(actionCase_ == 2)) {
          action_ =
              com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.getDefaultInstance();
        }
        pubSubNotificationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification,
                com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification.Builder,
                com.google.privacy.dlp.v2.DataProfileAction.PubSubNotificationOrBuilder>(
                (com.google.privacy.dlp.v2.DataProfileAction.PubSubNotification) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 2;
      onChanged();
      ;
      return pubSubNotificationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.DataProfileAction)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.DataProfileAction)
  private static final com.google.privacy.dlp.v2.DataProfileAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.DataProfileAction();
  }

  public static com.google.privacy.dlp.v2.DataProfileAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataProfileAction> PARSER =
      new com.google.protobuf.AbstractParser<DataProfileAction>() {
        @java.lang.Override
        public DataProfileAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataProfileAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataProfileAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.DataProfileAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
