/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/storage.proto

package com.google.privacy.dlp.v2;

public interface CustomInfoTypeOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.CustomInfoType)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * CustomInfoType can either be a new infoType, or an extension of built-in
   * infoType, when the name matches one of existing infoTypes and that infoType
   * is specified in `InspectContent.info_types` field. Specifying the latter
   * adds findings to the one detected by the system. If built-in info type is
   * not specified in `InspectContent.info_types` list then the name is treated
   * as a custom info type.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
   *
   * @return Whether the infoType field is set.
   */
  boolean hasInfoType();
  /**
   *
   *
   * <pre>
   * CustomInfoType can either be a new infoType, or an extension of built-in
   * infoType, when the name matches one of existing infoTypes and that infoType
   * is specified in `InspectContent.info_types` field. Specifying the latter
   * adds findings to the one detected by the system. If built-in info type is
   * not specified in `InspectContent.info_types` list then the name is treated
   * as a custom info type.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
   *
   * @return The infoType.
   */
  com.google.privacy.dlp.v2.InfoType getInfoType();
  /**
   *
   *
   * <pre>
   * CustomInfoType can either be a new infoType, or an extension of built-in
   * infoType, when the name matches one of existing infoTypes and that infoType
   * is specified in `InspectContent.info_types` field. Specifying the latter
   * adds findings to the one detected by the system. If built-in info type is
   * not specified in `InspectContent.info_types` list then the name is treated
   * as a custom info type.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
   */
  com.google.privacy.dlp.v2.InfoTypeOrBuilder getInfoTypeOrBuilder();

  /**
   *
   *
   * <pre>
   * Likelihood to return for this CustomInfoType. This base value can be
   * altered by a detection rule if the finding meets the criteria specified by
   * the rule. Defaults to `VERY_LIKELY` if not specified.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Likelihood likelihood = 6;</code>
   *
   * @return The enum numeric value on the wire for likelihood.
   */
  int getLikelihoodValue();
  /**
   *
   *
   * <pre>
   * Likelihood to return for this CustomInfoType. This base value can be
   * altered by a detection rule if the finding meets the criteria specified by
   * the rule. Defaults to `VERY_LIKELY` if not specified.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.Likelihood likelihood = 6;</code>
   *
   * @return The likelihood.
   */
  com.google.privacy.dlp.v2.Likelihood getLikelihood();

  /**
   *
   *
   * <pre>
   * A list of phrases to detect as a CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
   *
   * @return Whether the dictionary field is set.
   */
  boolean hasDictionary();
  /**
   *
   *
   * <pre>
   * A list of phrases to detect as a CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
   *
   * @return The dictionary.
   */
  com.google.privacy.dlp.v2.CustomInfoType.Dictionary getDictionary();
  /**
   *
   *
   * <pre>
   * A list of phrases to detect as a CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Dictionary dictionary = 2;</code>
   */
  com.google.privacy.dlp.v2.CustomInfoType.DictionaryOrBuilder getDictionaryOrBuilder();

  /**
   *
   *
   * <pre>
   * Regular expression based CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
   *
   * @return Whether the regex field is set.
   */
  boolean hasRegex();
  /**
   *
   *
   * <pre>
   * Regular expression based CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
   *
   * @return The regex.
   */
  com.google.privacy.dlp.v2.CustomInfoType.Regex getRegex();
  /**
   *
   *
   * <pre>
   * Regular expression based CustomInfoType.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.Regex regex = 3;</code>
   */
  com.google.privacy.dlp.v2.CustomInfoType.RegexOrBuilder getRegexOrBuilder();

  /**
   *
   *
   * <pre>
   * Message for detecting output from deidentification transformations that
   * support reversing.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
   *
   * @return Whether the surrogateType field is set.
   */
  boolean hasSurrogateType();
  /**
   *
   *
   * <pre>
   * Message for detecting output from deidentification transformations that
   * support reversing.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
   *
   * @return The surrogateType.
   */
  com.google.privacy.dlp.v2.CustomInfoType.SurrogateType getSurrogateType();
  /**
   *
   *
   * <pre>
   * Message for detecting output from deidentification transformations that
   * support reversing.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.SurrogateType surrogate_type = 4;</code>
   */
  com.google.privacy.dlp.v2.CustomInfoType.SurrogateTypeOrBuilder getSurrogateTypeOrBuilder();

  /**
   *
   *
   * <pre>
   * Load an existing `StoredInfoType` resource for use in
   * `InspectDataSource`. Not currently supported in `InspectContent`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
   *
   * @return Whether the storedType field is set.
   */
  boolean hasStoredType();
  /**
   *
   *
   * <pre>
   * Load an existing `StoredInfoType` resource for use in
   * `InspectDataSource`. Not currently supported in `InspectContent`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
   *
   * @return The storedType.
   */
  com.google.privacy.dlp.v2.StoredType getStoredType();
  /**
   *
   *
   * <pre>
   * Load an existing `StoredInfoType` resource for use in
   * `InspectDataSource`. Not currently supported in `InspectContent`.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.StoredType stored_type = 5;</code>
   */
  com.google.privacy.dlp.v2.StoredTypeOrBuilder getStoredTypeOrBuilder();

  /**
   *
   *
   * <pre>
   * Set of detection rules to apply to all findings of this CustomInfoType.
   * Rules are applied in order that they are specified. Not supported for the
   * `surrogate_type` CustomInfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;</code>
   */
  java.util.List<com.google.privacy.dlp.v2.CustomInfoType.DetectionRule> getDetectionRulesList();
  /**
   *
   *
   * <pre>
   * Set of detection rules to apply to all findings of this CustomInfoType.
   * Rules are applied in order that they are specified. Not supported for the
   * `surrogate_type` CustomInfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;</code>
   */
  com.google.privacy.dlp.v2.CustomInfoType.DetectionRule getDetectionRules(int index);
  /**
   *
   *
   * <pre>
   * Set of detection rules to apply to all findings of this CustomInfoType.
   * Rules are applied in order that they are specified. Not supported for the
   * `surrogate_type` CustomInfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;</code>
   */
  int getDetectionRulesCount();
  /**
   *
   *
   * <pre>
   * Set of detection rules to apply to all findings of this CustomInfoType.
   * Rules are applied in order that they are specified. Not supported for the
   * `surrogate_type` CustomInfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;</code>
   */
  java.util.List<? extends com.google.privacy.dlp.v2.CustomInfoType.DetectionRuleOrBuilder>
      getDetectionRulesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Set of detection rules to apply to all findings of this CustomInfoType.
   * Rules are applied in order that they are specified. Not supported for the
   * `surrogate_type` CustomInfoType.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CustomInfoType.DetectionRule detection_rules = 7;</code>
   */
  com.google.privacy.dlp.v2.CustomInfoType.DetectionRuleOrBuilder getDetectionRulesOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding
   * to be returned. It still can be used for rules matching.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.ExclusionType exclusion_type = 8;</code>
   *
   * @return The enum numeric value on the wire for exclusionType.
   */
  int getExclusionTypeValue();
  /**
   *
   *
   * <pre>
   * If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding
   * to be returned. It still can be used for rules matching.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CustomInfoType.ExclusionType exclusion_type = 8;</code>
   *
   * @return The exclusionType.
   */
  com.google.privacy.dlp.v2.CustomInfoType.ExclusionType getExclusionType();

  public com.google.privacy.dlp.v2.CustomInfoType.TypeCase getTypeCase();
}
