/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Pseudonymization method that generates deterministic encryption for the given
 * input. Outputs a base64 encoded representation of the encrypted output.
 * Uses AES-SIV based on the RFC https://tools.ietf.org/html/rfc5297.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.CryptoDeterministicConfig}
 */
public final class CryptoDeterministicConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CryptoDeterministicConfig)
    CryptoDeterministicConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CryptoDeterministicConfig.newBuilder() to construct.
  private CryptoDeterministicConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CryptoDeterministicConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CryptoDeterministicConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_CryptoDeterministicConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_CryptoDeterministicConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.CryptoDeterministicConfig.class,
            com.google.privacy.dlp.v2.CryptoDeterministicConfig.Builder.class);
  }

  public static final int CRYPTO_KEY_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.CryptoKey cryptoKey_;
  /**
   *
   *
   * <pre>
   * The key used by the encryption function. For deterministic encryption
   * using AES-SIV, the provided key is internally expanded to 64 bytes prior to
   * use.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CryptoKey crypto_key = 1;</code>
   *
   * @return Whether the cryptoKey field is set.
   */
  @java.lang.Override
  public boolean hasCryptoKey() {
    return cryptoKey_ != null;
  }
  /**
   *
   *
   * <pre>
   * The key used by the encryption function. For deterministic encryption
   * using AES-SIV, the provided key is internally expanded to 64 bytes prior to
   * use.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CryptoKey crypto_key = 1;</code>
   *
   * @return The cryptoKey.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CryptoKey getCryptoKey() {
    return cryptoKey_ == null
        ? com.google.privacy.dlp.v2.CryptoKey.getDefaultInstance()
        : cryptoKey_;
  }
  /**
   *
   *
   * <pre>
   * The key used by the encryption function. For deterministic encryption
   * using AES-SIV, the provided key is internally expanded to 64 bytes prior to
   * use.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CryptoKey crypto_key = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CryptoKeyOrBuilder getCryptoKeyOrBuilder() {
    return getCryptoKey();
  }

  public static final int SURROGATE_INFO_TYPE_FIELD_NUMBER = 2;
  private com.google.privacy.dlp.v2.InfoType surrogateInfoType_;
  /**
   *
   *
   * <pre>
   * The custom info type to annotate the surrogate with.
   * This annotation will be applied to the surrogate by prefixing it with
   * the name of the custom info type followed by the number of
   * characters comprising the surrogate. The following scheme defines the
   * format: {info type name}({surrogate character count}):{surrogate}
   * For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
   * the surrogate is 'abc', the full replacement value
   * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
   * This annotation identifies the surrogate when inspecting content using the
   * custom info type 'Surrogate'. This facilitates reversal of the
   * surrogate when it occurs in free text.
   * Note: For record transformations where the entire cell in a table is being
   * transformed, surrogates are not mandatory. Surrogates are used to denote
   * the location of the token and are necessary for re-identification in free
   * form text.
   * In order for inspection to work properly, the name of this info type must
   * not occur naturally anywhere in your data; otherwise, inspection may either
   * - reverse a surrogate that does not correspond to an actual identifier
   * - be unable to parse the surrogate and result in an error
   * Therefore, choose your custom info type name carefully after considering
   * what your data looks like. One way to select a name that has a high chance
   * of yielding reliable detection is to include one or more unicode characters
   * that are highly improbable to exist in your data.
   * For example, assuming your data is entered from a regular ASCII keyboard,
   * the symbol with the hex code point 29DD might be used like so:
   * ⧝MY_TOKEN_TYPE.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 2;</code>
   *
   * @return Whether the surrogateInfoType field is set.
   */
  @java.lang.Override
  public boolean hasSurrogateInfoType() {
    return surrogateInfoType_ != null;
  }
  /**
   *
   *
   * <pre>
   * The custom info type to annotate the surrogate with.
   * This annotation will be applied to the surrogate by prefixing it with
   * the name of the custom info type followed by the number of
   * characters comprising the surrogate. The following scheme defines the
   * format: {info type name}({surrogate character count}):{surrogate}
   * For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
   * the surrogate is 'abc', the full replacement value
   * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
   * This annotation identifies the surrogate when inspecting content using the
   * custom info type 'Surrogate'. This facilitates reversal of the
   * surrogate when it occurs in free text.
   * Note: For record transformations where the entire cell in a table is being
   * transformed, surrogates are not mandatory. Surrogates are used to denote
   * the location of the token and are necessary for re-identification in free
   * form text.
   * In order for inspection to work properly, the name of this info type must
   * not occur naturally anywhere in your data; otherwise, inspection may either
   * - reverse a surrogate that does not correspond to an actual identifier
   * - be unable to parse the surrogate and result in an error
   * Therefore, choose your custom info type name carefully after considering
   * what your data looks like. One way to select a name that has a high chance
   * of yielding reliable detection is to include one or more unicode characters
   * that are highly improbable to exist in your data.
   * For example, assuming your data is entered from a regular ASCII keyboard,
   * the symbol with the hex code point 29DD might be used like so:
   * ⧝MY_TOKEN_TYPE.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 2;</code>
   *
   * @return The surrogateInfoType.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoType getSurrogateInfoType() {
    return surrogateInfoType_ == null
        ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
        : surrogateInfoType_;
  }
  /**
   *
   *
   * <pre>
   * The custom info type to annotate the surrogate with.
   * This annotation will be applied to the surrogate by prefixing it with
   * the name of the custom info type followed by the number of
   * characters comprising the surrogate. The following scheme defines the
   * format: {info type name}({surrogate character count}):{surrogate}
   * For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
   * the surrogate is 'abc', the full replacement value
   * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
   * This annotation identifies the surrogate when inspecting content using the
   * custom info type 'Surrogate'. This facilitates reversal of the
   * surrogate when it occurs in free text.
   * Note: For record transformations where the entire cell in a table is being
   * transformed, surrogates are not mandatory. Surrogates are used to denote
   * the location of the token and are necessary for re-identification in free
   * form text.
   * In order for inspection to work properly, the name of this info type must
   * not occur naturally anywhere in your data; otherwise, inspection may either
   * - reverse a surrogate that does not correspond to an actual identifier
   * - be unable to parse the surrogate and result in an error
   * Therefore, choose your custom info type name carefully after considering
   * what your data looks like. One way to select a name that has a high chance
   * of yielding reliable detection is to include one or more unicode characters
   * that are highly improbable to exist in your data.
   * For example, assuming your data is entered from a regular ASCII keyboard,
   * the symbol with the hex code point 29DD might be used like so:
   * ⧝MY_TOKEN_TYPE.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 2;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.InfoTypeOrBuilder getSurrogateInfoTypeOrBuilder() {
    return getSurrogateInfoType();
  }

  public static final int CONTEXT_FIELD_NUMBER = 3;
  private com.google.privacy.dlp.v2.FieldId context_;
  /**
   *
   *
   * <pre>
   * A context may be used for higher security and maintaining
   * referential integrity such that the same identifier in two different
   * contexts will be given a distinct surrogate. The context is appended to
   * plaintext value being encrypted. On decryption the provided context is
   * validated against the value used during encryption. If a context was
   * provided during encryption, same context must be provided during decryption
   * as well.
   * If the context is not set, plaintext would be used as is for encryption.
   * If the context is set but:
   * 1. there is no record present when transforming a given value or
   * 2. the field is not present when transforming a given value,
   * plaintext would be used as is for encryption.
   * Note that case (1) is expected when an `InfoTypeTransformation` is
   * applied to both structured and unstructured `ContentItem`s.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FieldId context = 3;</code>
   *
   * @return Whether the context field is set.
   */
  @java.lang.Override
  public boolean hasContext() {
    return context_ != null;
  }
  /**
   *
   *
   * <pre>
   * A context may be used for higher security and maintaining
   * referential integrity such that the same identifier in two different
   * contexts will be given a distinct surrogate. The context is appended to
   * plaintext value being encrypted. On decryption the provided context is
   * validated against the value used during encryption. If a context was
   * provided during encryption, same context must be provided during decryption
   * as well.
   * If the context is not set, plaintext would be used as is for encryption.
   * If the context is set but:
   * 1. there is no record present when transforming a given value or
   * 2. the field is not present when transforming a given value,
   * plaintext would be used as is for encryption.
   * Note that case (1) is expected when an `InfoTypeTransformation` is
   * applied to both structured and unstructured `ContentItem`s.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FieldId context = 3;</code>
   *
   * @return The context.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldId getContext() {
    return context_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : context_;
  }
  /**
   *
   *
   * <pre>
   * A context may be used for higher security and maintaining
   * referential integrity such that the same identifier in two different
   * contexts will be given a distinct surrogate. The context is appended to
   * plaintext value being encrypted. On decryption the provided context is
   * validated against the value used during encryption. If a context was
   * provided during encryption, same context must be provided during decryption
   * as well.
   * If the context is not set, plaintext would be used as is for encryption.
   * If the context is set but:
   * 1. there is no record present when transforming a given value or
   * 2. the field is not present when transforming a given value,
   * plaintext would be used as is for encryption.
   * Note that case (1) is expected when an `InfoTypeTransformation` is
   * applied to both structured and unstructured `ContentItem`s.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.FieldId context = 3;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FieldIdOrBuilder getContextOrBuilder() {
    return getContext();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (cryptoKey_ != null) {
      output.writeMessage(1, getCryptoKey());
    }
    if (surrogateInfoType_ != null) {
      output.writeMessage(2, getSurrogateInfoType());
    }
    if (context_ != null) {
      output.writeMessage(3, getContext());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (cryptoKey_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCryptoKey());
    }
    if (surrogateInfoType_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSurrogateInfoType());
    }
    if (context_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getContext());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.CryptoDeterministicConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.CryptoDeterministicConfig other =
        (com.google.privacy.dlp.v2.CryptoDeterministicConfig) obj;

    if (hasCryptoKey() != other.hasCryptoKey()) return false;
    if (hasCryptoKey()) {
      if (!getCryptoKey().equals(other.getCryptoKey())) return false;
    }
    if (hasSurrogateInfoType() != other.hasSurrogateInfoType()) return false;
    if (hasSurrogateInfoType()) {
      if (!getSurrogateInfoType().equals(other.getSurrogateInfoType())) return false;
    }
    if (hasContext() != other.hasContext()) return false;
    if (hasContext()) {
      if (!getContext().equals(other.getContext())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCryptoKey()) {
      hash = (37 * hash) + CRYPTO_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getCryptoKey().hashCode();
    }
    if (hasSurrogateInfoType()) {
      hash = (37 * hash) + SURROGATE_INFO_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getSurrogateInfoType().hashCode();
    }
    if (hasContext()) {
      hash = (37 * hash) + CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getContext().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.CryptoDeterministicConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Pseudonymization method that generates deterministic encryption for the given
   * input. Outputs a base64 encoded representation of the encrypted output.
   * Uses AES-SIV based on the RFC https://tools.ietf.org/html/rfc5297.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CryptoDeterministicConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CryptoDeterministicConfig)
      com.google.privacy.dlp.v2.CryptoDeterministicConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CryptoDeterministicConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CryptoDeterministicConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CryptoDeterministicConfig.class,
              com.google.privacy.dlp.v2.CryptoDeterministicConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.CryptoDeterministicConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (cryptoKeyBuilder_ == null) {
        cryptoKey_ = null;
      } else {
        cryptoKey_ = null;
        cryptoKeyBuilder_ = null;
      }
      if (surrogateInfoTypeBuilder_ == null) {
        surrogateInfoType_ = null;
      } else {
        surrogateInfoType_ = null;
        surrogateInfoTypeBuilder_ = null;
      }
      if (contextBuilder_ == null) {
        context_ = null;
      } else {
        context_ = null;
        contextBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CryptoDeterministicConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoDeterministicConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.CryptoDeterministicConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoDeterministicConfig build() {
      com.google.privacy.dlp.v2.CryptoDeterministicConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CryptoDeterministicConfig buildPartial() {
      com.google.privacy.dlp.v2.CryptoDeterministicConfig result =
          new com.google.privacy.dlp.v2.CryptoDeterministicConfig(this);
      if (cryptoKeyBuilder_ == null) {
        result.cryptoKey_ = cryptoKey_;
      } else {
        result.cryptoKey_ = cryptoKeyBuilder_.build();
      }
      if (surrogateInfoTypeBuilder_ == null) {
        result.surrogateInfoType_ = surrogateInfoType_;
      } else {
        result.surrogateInfoType_ = surrogateInfoTypeBuilder_.build();
      }
      if (contextBuilder_ == null) {
        result.context_ = context_;
      } else {
        result.context_ = contextBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.CryptoDeterministicConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.CryptoDeterministicConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.CryptoDeterministicConfig other) {
      if (other == com.google.privacy.dlp.v2.CryptoDeterministicConfig.getDefaultInstance())
        return this;
      if (other.hasCryptoKey()) {
        mergeCryptoKey(other.getCryptoKey());
      }
      if (other.hasSurrogateInfoType()) {
        mergeSurrogateInfoType(other.getSurrogateInfoType());
      }
      if (other.hasContext()) {
        mergeContext(other.getContext());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCryptoKeyFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getSurrogateInfoTypeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getContextFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.privacy.dlp.v2.CryptoKey cryptoKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CryptoKey,
            com.google.privacy.dlp.v2.CryptoKey.Builder,
            com.google.privacy.dlp.v2.CryptoKeyOrBuilder>
        cryptoKeyBuilder_;
    /**
     *
     *
     * <pre>
     * The key used by the encryption function. For deterministic encryption
     * using AES-SIV, the provided key is internally expanded to 64 bytes prior to
     * use.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoKey crypto_key = 1;</code>
     *
     * @return Whether the cryptoKey field is set.
     */
    public boolean hasCryptoKey() {
      return cryptoKeyBuilder_ != null || cryptoKey_ != null;
    }
    /**
     *
     *
     * <pre>
     * The key used by the encryption function. For deterministic encryption
     * using AES-SIV, the provided key is internally expanded to 64 bytes prior to
     * use.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoKey crypto_key = 1;</code>
     *
     * @return The cryptoKey.
     */
    public com.google.privacy.dlp.v2.CryptoKey getCryptoKey() {
      if (cryptoKeyBuilder_ == null) {
        return cryptoKey_ == null
            ? com.google.privacy.dlp.v2.CryptoKey.getDefaultInstance()
            : cryptoKey_;
      } else {
        return cryptoKeyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The key used by the encryption function. For deterministic encryption
     * using AES-SIV, the provided key is internally expanded to 64 bytes prior to
     * use.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoKey crypto_key = 1;</code>
     */
    public Builder setCryptoKey(com.google.privacy.dlp.v2.CryptoKey value) {
      if (cryptoKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cryptoKey_ = value;
        onChanged();
      } else {
        cryptoKeyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The key used by the encryption function. For deterministic encryption
     * using AES-SIV, the provided key is internally expanded to 64 bytes prior to
     * use.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoKey crypto_key = 1;</code>
     */
    public Builder setCryptoKey(com.google.privacy.dlp.v2.CryptoKey.Builder builderForValue) {
      if (cryptoKeyBuilder_ == null) {
        cryptoKey_ = builderForValue.build();
        onChanged();
      } else {
        cryptoKeyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The key used by the encryption function. For deterministic encryption
     * using AES-SIV, the provided key is internally expanded to 64 bytes prior to
     * use.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoKey crypto_key = 1;</code>
     */
    public Builder mergeCryptoKey(com.google.privacy.dlp.v2.CryptoKey value) {
      if (cryptoKeyBuilder_ == null) {
        if (cryptoKey_ != null) {
          cryptoKey_ =
              com.google.privacy.dlp.v2.CryptoKey.newBuilder(cryptoKey_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          cryptoKey_ = value;
        }
        onChanged();
      } else {
        cryptoKeyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The key used by the encryption function. For deterministic encryption
     * using AES-SIV, the provided key is internally expanded to 64 bytes prior to
     * use.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoKey crypto_key = 1;</code>
     */
    public Builder clearCryptoKey() {
      if (cryptoKeyBuilder_ == null) {
        cryptoKey_ = null;
        onChanged();
      } else {
        cryptoKey_ = null;
        cryptoKeyBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The key used by the encryption function. For deterministic encryption
     * using AES-SIV, the provided key is internally expanded to 64 bytes prior to
     * use.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoKey crypto_key = 1;</code>
     */
    public com.google.privacy.dlp.v2.CryptoKey.Builder getCryptoKeyBuilder() {

      onChanged();
      return getCryptoKeyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The key used by the encryption function. For deterministic encryption
     * using AES-SIV, the provided key is internally expanded to 64 bytes prior to
     * use.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoKey crypto_key = 1;</code>
     */
    public com.google.privacy.dlp.v2.CryptoKeyOrBuilder getCryptoKeyOrBuilder() {
      if (cryptoKeyBuilder_ != null) {
        return cryptoKeyBuilder_.getMessageOrBuilder();
      } else {
        return cryptoKey_ == null
            ? com.google.privacy.dlp.v2.CryptoKey.getDefaultInstance()
            : cryptoKey_;
      }
    }
    /**
     *
     *
     * <pre>
     * The key used by the encryption function. For deterministic encryption
     * using AES-SIV, the provided key is internally expanded to 64 bytes prior to
     * use.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CryptoKey crypto_key = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CryptoKey,
            com.google.privacy.dlp.v2.CryptoKey.Builder,
            com.google.privacy.dlp.v2.CryptoKeyOrBuilder>
        getCryptoKeyFieldBuilder() {
      if (cryptoKeyBuilder_ == null) {
        cryptoKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CryptoKey,
                com.google.privacy.dlp.v2.CryptoKey.Builder,
                com.google.privacy.dlp.v2.CryptoKeyOrBuilder>(
                getCryptoKey(), getParentForChildren(), isClean());
        cryptoKey_ = null;
      }
      return cryptoKeyBuilder_;
    }

    private com.google.privacy.dlp.v2.InfoType surrogateInfoType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        surrogateInfoTypeBuilder_;
    /**
     *
     *
     * <pre>
     * The custom info type to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom info type followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: {info type name}({surrogate character count}):{surrogate}
     * For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     * This annotation identifies the surrogate when inspecting content using the
     * custom info type 'Surrogate'. This facilitates reversal of the
     * surrogate when it occurs in free text.
     * Note: For record transformations where the entire cell in a table is being
     * transformed, surrogates are not mandatory. Surrogates are used to denote
     * the location of the token and are necessary for re-identification in free
     * form text.
     * In order for inspection to work properly, the name of this info type must
     * not occur naturally anywhere in your data; otherwise, inspection may either
     * - reverse a surrogate that does not correspond to an actual identifier
     * - be unable to parse the surrogate and result in an error
     * Therefore, choose your custom info type name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 2;</code>
     *
     * @return Whether the surrogateInfoType field is set.
     */
    public boolean hasSurrogateInfoType() {
      return surrogateInfoTypeBuilder_ != null || surrogateInfoType_ != null;
    }
    /**
     *
     *
     * <pre>
     * The custom info type to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom info type followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: {info type name}({surrogate character count}):{surrogate}
     * For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     * This annotation identifies the surrogate when inspecting content using the
     * custom info type 'Surrogate'. This facilitates reversal of the
     * surrogate when it occurs in free text.
     * Note: For record transformations where the entire cell in a table is being
     * transformed, surrogates are not mandatory. Surrogates are used to denote
     * the location of the token and are necessary for re-identification in free
     * form text.
     * In order for inspection to work properly, the name of this info type must
     * not occur naturally anywhere in your data; otherwise, inspection may either
     * - reverse a surrogate that does not correspond to an actual identifier
     * - be unable to parse the surrogate and result in an error
     * Therefore, choose your custom info type name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 2;</code>
     *
     * @return The surrogateInfoType.
     */
    public com.google.privacy.dlp.v2.InfoType getSurrogateInfoType() {
      if (surrogateInfoTypeBuilder_ == null) {
        return surrogateInfoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : surrogateInfoType_;
      } else {
        return surrogateInfoTypeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The custom info type to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom info type followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: {info type name}({surrogate character count}):{surrogate}
     * For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     * This annotation identifies the surrogate when inspecting content using the
     * custom info type 'Surrogate'. This facilitates reversal of the
     * surrogate when it occurs in free text.
     * Note: For record transformations where the entire cell in a table is being
     * transformed, surrogates are not mandatory. Surrogates are used to denote
     * the location of the token and are necessary for re-identification in free
     * form text.
     * In order for inspection to work properly, the name of this info type must
     * not occur naturally anywhere in your data; otherwise, inspection may either
     * - reverse a surrogate that does not correspond to an actual identifier
     * - be unable to parse the surrogate and result in an error
     * Therefore, choose your custom info type name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 2;</code>
     */
    public Builder setSurrogateInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (surrogateInfoTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        surrogateInfoType_ = value;
        onChanged();
      } else {
        surrogateInfoTypeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom info type to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom info type followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: {info type name}({surrogate character count}):{surrogate}
     * For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     * This annotation identifies the surrogate when inspecting content using the
     * custom info type 'Surrogate'. This facilitates reversal of the
     * surrogate when it occurs in free text.
     * Note: For record transformations where the entire cell in a table is being
     * transformed, surrogates are not mandatory. Surrogates are used to denote
     * the location of the token and are necessary for re-identification in free
     * form text.
     * In order for inspection to work properly, the name of this info type must
     * not occur naturally anywhere in your data; otherwise, inspection may either
     * - reverse a surrogate that does not correspond to an actual identifier
     * - be unable to parse the surrogate and result in an error
     * Therefore, choose your custom info type name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 2;</code>
     */
    public Builder setSurrogateInfoType(
        com.google.privacy.dlp.v2.InfoType.Builder builderForValue) {
      if (surrogateInfoTypeBuilder_ == null) {
        surrogateInfoType_ = builderForValue.build();
        onChanged();
      } else {
        surrogateInfoTypeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom info type to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom info type followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: {info type name}({surrogate character count}):{surrogate}
     * For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     * This annotation identifies the surrogate when inspecting content using the
     * custom info type 'Surrogate'. This facilitates reversal of the
     * surrogate when it occurs in free text.
     * Note: For record transformations where the entire cell in a table is being
     * transformed, surrogates are not mandatory. Surrogates are used to denote
     * the location of the token and are necessary for re-identification in free
     * form text.
     * In order for inspection to work properly, the name of this info type must
     * not occur naturally anywhere in your data; otherwise, inspection may either
     * - reverse a surrogate that does not correspond to an actual identifier
     * - be unable to parse the surrogate and result in an error
     * Therefore, choose your custom info type name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 2;</code>
     */
    public Builder mergeSurrogateInfoType(com.google.privacy.dlp.v2.InfoType value) {
      if (surrogateInfoTypeBuilder_ == null) {
        if (surrogateInfoType_ != null) {
          surrogateInfoType_ =
              com.google.privacy.dlp.v2.InfoType.newBuilder(surrogateInfoType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          surrogateInfoType_ = value;
        }
        onChanged();
      } else {
        surrogateInfoTypeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom info type to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom info type followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: {info type name}({surrogate character count}):{surrogate}
     * For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     * This annotation identifies the surrogate when inspecting content using the
     * custom info type 'Surrogate'. This facilitates reversal of the
     * surrogate when it occurs in free text.
     * Note: For record transformations where the entire cell in a table is being
     * transformed, surrogates are not mandatory. Surrogates are used to denote
     * the location of the token and are necessary for re-identification in free
     * form text.
     * In order for inspection to work properly, the name of this info type must
     * not occur naturally anywhere in your data; otherwise, inspection may either
     * - reverse a surrogate that does not correspond to an actual identifier
     * - be unable to parse the surrogate and result in an error
     * Therefore, choose your custom info type name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 2;</code>
     */
    public Builder clearSurrogateInfoType() {
      if (surrogateInfoTypeBuilder_ == null) {
        surrogateInfoType_ = null;
        onChanged();
      } else {
        surrogateInfoType_ = null;
        surrogateInfoTypeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The custom info type to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom info type followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: {info type name}({surrogate character count}):{surrogate}
     * For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     * This annotation identifies the surrogate when inspecting content using the
     * custom info type 'Surrogate'. This facilitates reversal of the
     * surrogate when it occurs in free text.
     * Note: For record transformations where the entire cell in a table is being
     * transformed, surrogates are not mandatory. Surrogates are used to denote
     * the location of the token and are necessary for re-identification in free
     * form text.
     * In order for inspection to work properly, the name of this info type must
     * not occur naturally anywhere in your data; otherwise, inspection may either
     * - reverse a surrogate that does not correspond to an actual identifier
     * - be unable to parse the surrogate and result in an error
     * Therefore, choose your custom info type name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 2;</code>
     */
    public com.google.privacy.dlp.v2.InfoType.Builder getSurrogateInfoTypeBuilder() {

      onChanged();
      return getSurrogateInfoTypeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The custom info type to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom info type followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: {info type name}({surrogate character count}):{surrogate}
     * For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     * This annotation identifies the surrogate when inspecting content using the
     * custom info type 'Surrogate'. This facilitates reversal of the
     * surrogate when it occurs in free text.
     * Note: For record transformations where the entire cell in a table is being
     * transformed, surrogates are not mandatory. Surrogates are used to denote
     * the location of the token and are necessary for re-identification in free
     * form text.
     * In order for inspection to work properly, the name of this info type must
     * not occur naturally anywhere in your data; otherwise, inspection may either
     * - reverse a surrogate that does not correspond to an actual identifier
     * - be unable to parse the surrogate and result in an error
     * Therefore, choose your custom info type name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 2;</code>
     */
    public com.google.privacy.dlp.v2.InfoTypeOrBuilder getSurrogateInfoTypeOrBuilder() {
      if (surrogateInfoTypeBuilder_ != null) {
        return surrogateInfoTypeBuilder_.getMessageOrBuilder();
      } else {
        return surrogateInfoType_ == null
            ? com.google.privacy.dlp.v2.InfoType.getDefaultInstance()
            : surrogateInfoType_;
      }
    }
    /**
     *
     *
     * <pre>
     * The custom info type to annotate the surrogate with.
     * This annotation will be applied to the surrogate by prefixing it with
     * the name of the custom info type followed by the number of
     * characters comprising the surrogate. The following scheme defines the
     * format: {info type name}({surrogate character count}):{surrogate}
     * For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
     * the surrogate is 'abc', the full replacement value
     * will be: 'MY_TOKEN_INFO_TYPE(3):abc'
     * This annotation identifies the surrogate when inspecting content using the
     * custom info type 'Surrogate'. This facilitates reversal of the
     * surrogate when it occurs in free text.
     * Note: For record transformations where the entire cell in a table is being
     * transformed, surrogates are not mandatory. Surrogates are used to denote
     * the location of the token and are necessary for re-identification in free
     * form text.
     * In order for inspection to work properly, the name of this info type must
     * not occur naturally anywhere in your data; otherwise, inspection may either
     * - reverse a surrogate that does not correspond to an actual identifier
     * - be unable to parse the surrogate and result in an error
     * Therefore, choose your custom info type name carefully after considering
     * what your data looks like. One way to select a name that has a high chance
     * of yielding reliable detection is to include one or more unicode characters
     * that are highly improbable to exist in your data.
     * For example, assuming your data is entered from a regular ASCII keyboard,
     * the symbol with the hex code point 29DD might be used like so:
     * ⧝MY_TOKEN_TYPE.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.InfoType surrogate_info_type = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.InfoType,
            com.google.privacy.dlp.v2.InfoType.Builder,
            com.google.privacy.dlp.v2.InfoTypeOrBuilder>
        getSurrogateInfoTypeFieldBuilder() {
      if (surrogateInfoTypeBuilder_ == null) {
        surrogateInfoTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.InfoType,
                com.google.privacy.dlp.v2.InfoType.Builder,
                com.google.privacy.dlp.v2.InfoTypeOrBuilder>(
                getSurrogateInfoType(), getParentForChildren(), isClean());
        surrogateInfoType_ = null;
      }
      return surrogateInfoTypeBuilder_;
    }

    private com.google.privacy.dlp.v2.FieldId context_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        contextBuilder_;
    /**
     *
     *
     * <pre>
     * A context may be used for higher security and maintaining
     * referential integrity such that the same identifier in two different
     * contexts will be given a distinct surrogate. The context is appended to
     * plaintext value being encrypted. On decryption the provided context is
     * validated against the value used during encryption. If a context was
     * provided during encryption, same context must be provided during decryption
     * as well.
     * If the context is not set, plaintext would be used as is for encryption.
     * If the context is set but:
     * 1. there is no record present when transforming a given value or
     * 2. the field is not present when transforming a given value,
     * plaintext would be used as is for encryption.
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 3;</code>
     *
     * @return Whether the context field is set.
     */
    public boolean hasContext() {
      return contextBuilder_ != null || context_ != null;
    }
    /**
     *
     *
     * <pre>
     * A context may be used for higher security and maintaining
     * referential integrity such that the same identifier in two different
     * contexts will be given a distinct surrogate. The context is appended to
     * plaintext value being encrypted. On decryption the provided context is
     * validated against the value used during encryption. If a context was
     * provided during encryption, same context must be provided during decryption
     * as well.
     * If the context is not set, plaintext would be used as is for encryption.
     * If the context is set but:
     * 1. there is no record present when transforming a given value or
     * 2. the field is not present when transforming a given value,
     * plaintext would be used as is for encryption.
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 3;</code>
     *
     * @return The context.
     */
    public com.google.privacy.dlp.v2.FieldId getContext() {
      if (contextBuilder_ == null) {
        return context_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : context_;
      } else {
        return contextBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A context may be used for higher security and maintaining
     * referential integrity such that the same identifier in two different
     * contexts will be given a distinct surrogate. The context is appended to
     * plaintext value being encrypted. On decryption the provided context is
     * validated against the value used during encryption. If a context was
     * provided during encryption, same context must be provided during decryption
     * as well.
     * If the context is not set, plaintext would be used as is for encryption.
     * If the context is set but:
     * 1. there is no record present when transforming a given value or
     * 2. the field is not present when transforming a given value,
     * plaintext would be used as is for encryption.
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 3;</code>
     */
    public Builder setContext(com.google.privacy.dlp.v2.FieldId value) {
      if (contextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        context_ = value;
        onChanged();
      } else {
        contextBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A context may be used for higher security and maintaining
     * referential integrity such that the same identifier in two different
     * contexts will be given a distinct surrogate. The context is appended to
     * plaintext value being encrypted. On decryption the provided context is
     * validated against the value used during encryption. If a context was
     * provided during encryption, same context must be provided during decryption
     * as well.
     * If the context is not set, plaintext would be used as is for encryption.
     * If the context is set but:
     * 1. there is no record present when transforming a given value or
     * 2. the field is not present when transforming a given value,
     * plaintext would be used as is for encryption.
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 3;</code>
     */
    public Builder setContext(com.google.privacy.dlp.v2.FieldId.Builder builderForValue) {
      if (contextBuilder_ == null) {
        context_ = builderForValue.build();
        onChanged();
      } else {
        contextBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A context may be used for higher security and maintaining
     * referential integrity such that the same identifier in two different
     * contexts will be given a distinct surrogate. The context is appended to
     * plaintext value being encrypted. On decryption the provided context is
     * validated against the value used during encryption. If a context was
     * provided during encryption, same context must be provided during decryption
     * as well.
     * If the context is not set, plaintext would be used as is for encryption.
     * If the context is set but:
     * 1. there is no record present when transforming a given value or
     * 2. the field is not present when transforming a given value,
     * plaintext would be used as is for encryption.
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 3;</code>
     */
    public Builder mergeContext(com.google.privacy.dlp.v2.FieldId value) {
      if (contextBuilder_ == null) {
        if (context_ != null) {
          context_ =
              com.google.privacy.dlp.v2.FieldId.newBuilder(context_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          context_ = value;
        }
        onChanged();
      } else {
        contextBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A context may be used for higher security and maintaining
     * referential integrity such that the same identifier in two different
     * contexts will be given a distinct surrogate. The context is appended to
     * plaintext value being encrypted. On decryption the provided context is
     * validated against the value used during encryption. If a context was
     * provided during encryption, same context must be provided during decryption
     * as well.
     * If the context is not set, plaintext would be used as is for encryption.
     * If the context is set but:
     * 1. there is no record present when transforming a given value or
     * 2. the field is not present when transforming a given value,
     * plaintext would be used as is for encryption.
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 3;</code>
     */
    public Builder clearContext() {
      if (contextBuilder_ == null) {
        context_ = null;
        onChanged();
      } else {
        context_ = null;
        contextBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A context may be used for higher security and maintaining
     * referential integrity such that the same identifier in two different
     * contexts will be given a distinct surrogate. The context is appended to
     * plaintext value being encrypted. On decryption the provided context is
     * validated against the value used during encryption. If a context was
     * provided during encryption, same context must be provided during decryption
     * as well.
     * If the context is not set, plaintext would be used as is for encryption.
     * If the context is set but:
     * 1. there is no record present when transforming a given value or
     * 2. the field is not present when transforming a given value,
     * plaintext would be used as is for encryption.
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 3;</code>
     */
    public com.google.privacy.dlp.v2.FieldId.Builder getContextBuilder() {

      onChanged();
      return getContextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A context may be used for higher security and maintaining
     * referential integrity such that the same identifier in two different
     * contexts will be given a distinct surrogate. The context is appended to
     * plaintext value being encrypted. On decryption the provided context is
     * validated against the value used during encryption. If a context was
     * provided during encryption, same context must be provided during decryption
     * as well.
     * If the context is not set, plaintext would be used as is for encryption.
     * If the context is set but:
     * 1. there is no record present when transforming a given value or
     * 2. the field is not present when transforming a given value,
     * plaintext would be used as is for encryption.
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 3;</code>
     */
    public com.google.privacy.dlp.v2.FieldIdOrBuilder getContextOrBuilder() {
      if (contextBuilder_ != null) {
        return contextBuilder_.getMessageOrBuilder();
      } else {
        return context_ == null ? com.google.privacy.dlp.v2.FieldId.getDefaultInstance() : context_;
      }
    }
    /**
     *
     *
     * <pre>
     * A context may be used for higher security and maintaining
     * referential integrity such that the same identifier in two different
     * contexts will be given a distinct surrogate. The context is appended to
     * plaintext value being encrypted. On decryption the provided context is
     * validated against the value used during encryption. If a context was
     * provided during encryption, same context must be provided during decryption
     * as well.
     * If the context is not set, plaintext would be used as is for encryption.
     * If the context is set but:
     * 1. there is no record present when transforming a given value or
     * 2. the field is not present when transforming a given value,
     * plaintext would be used as is for encryption.
     * Note that case (1) is expected when an `InfoTypeTransformation` is
     * applied to both structured and unstructured `ContentItem`s.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.FieldId context = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.FieldId,
            com.google.privacy.dlp.v2.FieldId.Builder,
            com.google.privacy.dlp.v2.FieldIdOrBuilder>
        getContextFieldBuilder() {
      if (contextBuilder_ == null) {
        contextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.FieldId,
                com.google.privacy.dlp.v2.FieldId.Builder,
                com.google.privacy.dlp.v2.FieldIdOrBuilder>(
                getContext(), getParentForChildren(), isClean());
        context_ = null;
      }
      return contextBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CryptoDeterministicConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CryptoDeterministicConfig)
  private static final com.google.privacy.dlp.v2.CryptoDeterministicConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CryptoDeterministicConfig();
  }

  public static com.google.privacy.dlp.v2.CryptoDeterministicConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CryptoDeterministicConfig> PARSER =
      new com.google.protobuf.AbstractParser<CryptoDeterministicConfig>() {
        @java.lang.Override
        public CryptoDeterministicConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CryptoDeterministicConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CryptoDeterministicConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.CryptoDeterministicConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
