/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/storage.proto

package com.google.privacy.dlp.v2;

public interface CloudStorageRegexFileSetOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.CloudStorageRegexFileSet)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The name of a Cloud Storage bucket. Required.
   * </pre>
   *
   * <code>string bucket_name = 1;</code>
   *
   * @return The bucketName.
   */
  java.lang.String getBucketName();
  /**
   *
   *
   * <pre>
   * The name of a Cloud Storage bucket. Required.
   * </pre>
   *
   * <code>string bucket_name = 1;</code>
   *
   * @return The bytes for bucketName.
   */
  com.google.protobuf.ByteString getBucketNameBytes();

  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to include. All files in
   * the bucket that match at least one of these regular expressions will be
   * included in the set of files, except for those that also match an item in
   * `exclude_regex`. Leaving this field empty will match all files by default
   * (this is equivalent to including `.*` in the list).
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string include_regex = 2;</code>
   *
   * @return A list containing the includeRegex.
   */
  java.util.List<java.lang.String> getIncludeRegexList();
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to include. All files in
   * the bucket that match at least one of these regular expressions will be
   * included in the set of files, except for those that also match an item in
   * `exclude_regex`. Leaving this field empty will match all files by default
   * (this is equivalent to including `.*` in the list).
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string include_regex = 2;</code>
   *
   * @return The count of includeRegex.
   */
  int getIncludeRegexCount();
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to include. All files in
   * the bucket that match at least one of these regular expressions will be
   * included in the set of files, except for those that also match an item in
   * `exclude_regex`. Leaving this field empty will match all files by default
   * (this is equivalent to including `.*` in the list).
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string include_regex = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The includeRegex at the given index.
   */
  java.lang.String getIncludeRegex(int index);
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to include. All files in
   * the bucket that match at least one of these regular expressions will be
   * included in the set of files, except for those that also match an item in
   * `exclude_regex`. Leaving this field empty will match all files by default
   * (this is equivalent to including `.*` in the list).
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string include_regex = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the includeRegex at the given index.
   */
  com.google.protobuf.ByteString getIncludeRegexBytes(int index);

  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to exclude. All files in
   * the bucket that match at least one of these regular expressions will be
   * excluded from the scan.
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string exclude_regex = 3;</code>
   *
   * @return A list containing the excludeRegex.
   */
  java.util.List<java.lang.String> getExcludeRegexList();
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to exclude. All files in
   * the bucket that match at least one of these regular expressions will be
   * excluded from the scan.
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string exclude_regex = 3;</code>
   *
   * @return The count of excludeRegex.
   */
  int getExcludeRegexCount();
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to exclude. All files in
   * the bucket that match at least one of these regular expressions will be
   * excluded from the scan.
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string exclude_regex = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The excludeRegex at the given index.
   */
  java.lang.String getExcludeRegex(int index);
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to exclude. All files in
   * the bucket that match at least one of these regular expressions will be
   * excluded from the scan.
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string exclude_regex = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the excludeRegex at the given index.
   */
  com.google.protobuf.ByteString getExcludeRegexBytes(int index);
}
