/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/storage.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Message representing a set of files in a Cloud Storage bucket. Regular
 * expressions are used to allow fine-grained control over which files in the
 * bucket to include.
 * Included files are those that match at least one item in `include_regex` and
 * do not match any items in `exclude_regex`. Note that a file that matches
 * items from both lists will _not_ be included. For a match to occur, the
 * entire file path (i.e., everything in the url after the bucket name) must
 * match the regular expression.
 * For example, given the input `{bucket_name: "mybucket", include_regex:
 * ["directory1/.*"], exclude_regex:
 * ["directory1/excluded.*"]}`:
 * * `gs://mybucket/directory1/myfile` will be included
 * * `gs://mybucket/directory1/directory2/myfile` will be included (`.*` matches
 * across `/`)
 * * `gs://mybucket/directory0/directory1/myfile` will _not_ be included (the
 * full path doesn't match any items in `include_regex`)
 * * `gs://mybucket/directory1/excludedfile` will _not_ be included (the path
 * matches an item in `exclude_regex`)
 * If `include_regex` is left empty, it will match all files by default
 * (this is equivalent to setting `include_regex: [".*"]`).
 * Some other common use cases:
 * * `{bucket_name: "mybucket", exclude_regex: [".*&#92;.pdf"]}` will include all
 * files in `mybucket` except for .pdf files
 * * `{bucket_name: "mybucket", include_regex: ["directory/[^/]+"]}` will
 * include all files directly under `gs://mybucket/directory/`, without matching
 * across `/`
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.CloudStorageRegexFileSet}
 */
public final class CloudStorageRegexFileSet extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CloudStorageRegexFileSet)
    CloudStorageRegexFileSetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudStorageRegexFileSet.newBuilder() to construct.
  private CloudStorageRegexFileSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudStorageRegexFileSet() {
    bucketName_ = "";
    includeRegex_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    excludeRegex_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudStorageRegexFileSet();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpStorage
        .internal_static_google_privacy_dlp_v2_CloudStorageRegexFileSet_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpStorage
        .internal_static_google_privacy_dlp_v2_CloudStorageRegexFileSet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.CloudStorageRegexFileSet.class,
            com.google.privacy.dlp.v2.CloudStorageRegexFileSet.Builder.class);
  }

  public static final int BUCKET_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object bucketName_;
  /**
   *
   *
   * <pre>
   * The name of a Cloud Storage bucket. Required.
   * </pre>
   *
   * <code>string bucket_name = 1;</code>
   *
   * @return The bucketName.
   */
  @java.lang.Override
  public java.lang.String getBucketName() {
    java.lang.Object ref = bucketName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bucketName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of a Cloud Storage bucket. Required.
   * </pre>
   *
   * <code>string bucket_name = 1;</code>
   *
   * @return The bytes for bucketName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBucketNameBytes() {
    java.lang.Object ref = bucketName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bucketName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INCLUDE_REGEX_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList includeRegex_;
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to include. All files in
   * the bucket that match at least one of these regular expressions will be
   * included in the set of files, except for those that also match an item in
   * `exclude_regex`. Leaving this field empty will match all files by default
   * (this is equivalent to including `.*` in the list).
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string include_regex = 2;</code>
   *
   * @return A list containing the includeRegex.
   */
  public com.google.protobuf.ProtocolStringList getIncludeRegexList() {
    return includeRegex_;
  }
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to include. All files in
   * the bucket that match at least one of these regular expressions will be
   * included in the set of files, except for those that also match an item in
   * `exclude_regex`. Leaving this field empty will match all files by default
   * (this is equivalent to including `.*` in the list).
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string include_regex = 2;</code>
   *
   * @return The count of includeRegex.
   */
  public int getIncludeRegexCount() {
    return includeRegex_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to include. All files in
   * the bucket that match at least one of these regular expressions will be
   * included in the set of files, except for those that also match an item in
   * `exclude_regex`. Leaving this field empty will match all files by default
   * (this is equivalent to including `.*` in the list).
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string include_regex = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The includeRegex at the given index.
   */
  public java.lang.String getIncludeRegex(int index) {
    return includeRegex_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to include. All files in
   * the bucket that match at least one of these regular expressions will be
   * included in the set of files, except for those that also match an item in
   * `exclude_regex`. Leaving this field empty will match all files by default
   * (this is equivalent to including `.*` in the list).
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string include_regex = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the includeRegex at the given index.
   */
  public com.google.protobuf.ByteString getIncludeRegexBytes(int index) {
    return includeRegex_.getByteString(index);
  }

  public static final int EXCLUDE_REGEX_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList excludeRegex_;
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to exclude. All files in
   * the bucket that match at least one of these regular expressions will be
   * excluded from the scan.
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string exclude_regex = 3;</code>
   *
   * @return A list containing the excludeRegex.
   */
  public com.google.protobuf.ProtocolStringList getExcludeRegexList() {
    return excludeRegex_;
  }
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to exclude. All files in
   * the bucket that match at least one of these regular expressions will be
   * excluded from the scan.
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string exclude_regex = 3;</code>
   *
   * @return The count of excludeRegex.
   */
  public int getExcludeRegexCount() {
    return excludeRegex_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to exclude. All files in
   * the bucket that match at least one of these regular expressions will be
   * excluded from the scan.
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string exclude_regex = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The excludeRegex at the given index.
   */
  public java.lang.String getExcludeRegex(int index) {
    return excludeRegex_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of regular expressions matching file paths to exclude. All files in
   * the bucket that match at least one of these regular expressions will be
   * excluded from the scan.
   * Regular expressions use RE2
   * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
   * under the google/re2 repository on GitHub.
   * </pre>
   *
   * <code>repeated string exclude_regex = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the excludeRegex at the given index.
   */
  public com.google.protobuf.ByteString getExcludeRegexBytes(int index) {
    return excludeRegex_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucketName_);
    }
    for (int i = 0; i < includeRegex_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, includeRegex_.getRaw(i));
    }
    for (int i = 0; i < excludeRegex_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, excludeRegex_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, bucketName_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < includeRegex_.size(); i++) {
        dataSize += computeStringSizeNoTag(includeRegex_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIncludeRegexList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < excludeRegex_.size(); i++) {
        dataSize += computeStringSizeNoTag(excludeRegex_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getExcludeRegexList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.CloudStorageRegexFileSet)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.CloudStorageRegexFileSet other =
        (com.google.privacy.dlp.v2.CloudStorageRegexFileSet) obj;

    if (!getBucketName().equals(other.getBucketName())) return false;
    if (!getIncludeRegexList().equals(other.getIncludeRegexList())) return false;
    if (!getExcludeRegexList().equals(other.getExcludeRegexList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BUCKET_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getBucketName().hashCode();
    if (getIncludeRegexCount() > 0) {
      hash = (37 * hash) + INCLUDE_REGEX_FIELD_NUMBER;
      hash = (53 * hash) + getIncludeRegexList().hashCode();
    }
    if (getExcludeRegexCount() > 0) {
      hash = (37 * hash) + EXCLUDE_REGEX_FIELD_NUMBER;
      hash = (53 * hash) + getExcludeRegexList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.CloudStorageRegexFileSet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message representing a set of files in a Cloud Storage bucket. Regular
   * expressions are used to allow fine-grained control over which files in the
   * bucket to include.
   * Included files are those that match at least one item in `include_regex` and
   * do not match any items in `exclude_regex`. Note that a file that matches
   * items from both lists will _not_ be included. For a match to occur, the
   * entire file path (i.e., everything in the url after the bucket name) must
   * match the regular expression.
   * For example, given the input `{bucket_name: "mybucket", include_regex:
   * ["directory1/.*"], exclude_regex:
   * ["directory1/excluded.*"]}`:
   * * `gs://mybucket/directory1/myfile` will be included
   * * `gs://mybucket/directory1/directory2/myfile` will be included (`.*` matches
   * across `/`)
   * * `gs://mybucket/directory0/directory1/myfile` will _not_ be included (the
   * full path doesn't match any items in `include_regex`)
   * * `gs://mybucket/directory1/excludedfile` will _not_ be included (the path
   * matches an item in `exclude_regex`)
   * If `include_regex` is left empty, it will match all files by default
   * (this is equivalent to setting `include_regex: [".*"]`).
   * Some other common use cases:
   * * `{bucket_name: "mybucket", exclude_regex: [".*&#92;.pdf"]}` will include all
   * files in `mybucket` except for .pdf files
   * * `{bucket_name: "mybucket", include_regex: ["directory/[^/]+"]}` will
   * include all files directly under `gs://mybucket/directory/`, without matching
   * across `/`
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CloudStorageRegexFileSet}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CloudStorageRegexFileSet)
      com.google.privacy.dlp.v2.CloudStorageRegexFileSetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CloudStorageRegexFileSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CloudStorageRegexFileSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CloudStorageRegexFileSet.class,
              com.google.privacy.dlp.v2.CloudStorageRegexFileSet.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.CloudStorageRegexFileSet.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bucketName_ = "";

      includeRegex_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      excludeRegex_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CloudStorageRegexFileSet_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageRegexFileSet getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.CloudStorageRegexFileSet.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageRegexFileSet build() {
      com.google.privacy.dlp.v2.CloudStorageRegexFileSet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageRegexFileSet buildPartial() {
      com.google.privacy.dlp.v2.CloudStorageRegexFileSet result =
          new com.google.privacy.dlp.v2.CloudStorageRegexFileSet(this);
      int from_bitField0_ = bitField0_;
      result.bucketName_ = bucketName_;
      if (((bitField0_ & 0x00000001) != 0)) {
        includeRegex_ = includeRegex_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.includeRegex_ = includeRegex_;
      if (((bitField0_ & 0x00000002) != 0)) {
        excludeRegex_ = excludeRegex_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.excludeRegex_ = excludeRegex_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.CloudStorageRegexFileSet) {
        return mergeFrom((com.google.privacy.dlp.v2.CloudStorageRegexFileSet) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.CloudStorageRegexFileSet other) {
      if (other == com.google.privacy.dlp.v2.CloudStorageRegexFileSet.getDefaultInstance())
        return this;
      if (!other.getBucketName().isEmpty()) {
        bucketName_ = other.bucketName_;
        onChanged();
      }
      if (!other.includeRegex_.isEmpty()) {
        if (includeRegex_.isEmpty()) {
          includeRegex_ = other.includeRegex_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureIncludeRegexIsMutable();
          includeRegex_.addAll(other.includeRegex_);
        }
        onChanged();
      }
      if (!other.excludeRegex_.isEmpty()) {
        if (excludeRegex_.isEmpty()) {
          excludeRegex_ = other.excludeRegex_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureExcludeRegexIsMutable();
          excludeRegex_.addAll(other.excludeRegex_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                bucketName_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIncludeRegexIsMutable();
                includeRegex_.add(s);
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExcludeRegexIsMutable();
                excludeRegex_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object bucketName_ = "";
    /**
     *
     *
     * <pre>
     * The name of a Cloud Storage bucket. Required.
     * </pre>
     *
     * <code>string bucket_name = 1;</code>
     *
     * @return The bucketName.
     */
    public java.lang.String getBucketName() {
      java.lang.Object ref = bucketName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucketName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of a Cloud Storage bucket. Required.
     * </pre>
     *
     * <code>string bucket_name = 1;</code>
     *
     * @return The bytes for bucketName.
     */
    public com.google.protobuf.ByteString getBucketNameBytes() {
      java.lang.Object ref = bucketName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucketName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of a Cloud Storage bucket. Required.
     * </pre>
     *
     * <code>string bucket_name = 1;</code>
     *
     * @param value The bucketName to set.
     * @return This builder for chaining.
     */
    public Builder setBucketName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      bucketName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of a Cloud Storage bucket. Required.
     * </pre>
     *
     * <code>string bucket_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucketName() {

      bucketName_ = getDefaultInstance().getBucketName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of a Cloud Storage bucket. Required.
     * </pre>
     *
     * <code>string bucket_name = 1;</code>
     *
     * @param value The bytes for bucketName to set.
     * @return This builder for chaining.
     */
    public Builder setBucketNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      bucketName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList includeRegex_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureIncludeRegexIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        includeRegex_ = new com.google.protobuf.LazyStringArrayList(includeRegex_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to include. All files in
     * the bucket that match at least one of these regular expressions will be
     * included in the set of files, except for those that also match an item in
     * `exclude_regex`. Leaving this field empty will match all files by default
     * (this is equivalent to including `.*` in the list).
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string include_regex = 2;</code>
     *
     * @return A list containing the includeRegex.
     */
    public com.google.protobuf.ProtocolStringList getIncludeRegexList() {
      return includeRegex_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to include. All files in
     * the bucket that match at least one of these regular expressions will be
     * included in the set of files, except for those that also match an item in
     * `exclude_regex`. Leaving this field empty will match all files by default
     * (this is equivalent to including `.*` in the list).
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string include_regex = 2;</code>
     *
     * @return The count of includeRegex.
     */
    public int getIncludeRegexCount() {
      return includeRegex_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to include. All files in
     * the bucket that match at least one of these regular expressions will be
     * included in the set of files, except for those that also match an item in
     * `exclude_regex`. Leaving this field empty will match all files by default
     * (this is equivalent to including `.*` in the list).
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string include_regex = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The includeRegex at the given index.
     */
    public java.lang.String getIncludeRegex(int index) {
      return includeRegex_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to include. All files in
     * the bucket that match at least one of these regular expressions will be
     * included in the set of files, except for those that also match an item in
     * `exclude_regex`. Leaving this field empty will match all files by default
     * (this is equivalent to including `.*` in the list).
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string include_regex = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includeRegex at the given index.
     */
    public com.google.protobuf.ByteString getIncludeRegexBytes(int index) {
      return includeRegex_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to include. All files in
     * the bucket that match at least one of these regular expressions will be
     * included in the set of files, except for those that also match an item in
     * `exclude_regex`. Leaving this field empty will match all files by default
     * (this is equivalent to including `.*` in the list).
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string include_regex = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The includeRegex to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeRegex(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludeRegexIsMutable();
      includeRegex_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to include. All files in
     * the bucket that match at least one of these regular expressions will be
     * included in the set of files, except for those that also match an item in
     * `exclude_regex`. Leaving this field empty will match all files by default
     * (this is equivalent to including `.*` in the list).
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string include_regex = 2;</code>
     *
     * @param value The includeRegex to add.
     * @return This builder for chaining.
     */
    public Builder addIncludeRegex(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludeRegexIsMutable();
      includeRegex_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to include. All files in
     * the bucket that match at least one of these regular expressions will be
     * included in the set of files, except for those that also match an item in
     * `exclude_regex`. Leaving this field empty will match all files by default
     * (this is equivalent to including `.*` in the list).
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string include_regex = 2;</code>
     *
     * @param values The includeRegex to add.
     * @return This builder for chaining.
     */
    public Builder addAllIncludeRegex(java.lang.Iterable<java.lang.String> values) {
      ensureIncludeRegexIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includeRegex_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to include. All files in
     * the bucket that match at least one of these regular expressions will be
     * included in the set of files, except for those that also match an item in
     * `exclude_regex`. Leaving this field empty will match all files by default
     * (this is equivalent to including `.*` in the list).
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string include_regex = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeRegex() {
      includeRegex_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to include. All files in
     * the bucket that match at least one of these regular expressions will be
     * included in the set of files, except for those that also match an item in
     * `exclude_regex`. Leaving this field empty will match all files by default
     * (this is equivalent to including `.*` in the list).
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string include_regex = 2;</code>
     *
     * @param value The bytes of the includeRegex to add.
     * @return This builder for chaining.
     */
    public Builder addIncludeRegexBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIncludeRegexIsMutable();
      includeRegex_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList excludeRegex_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureExcludeRegexIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        excludeRegex_ = new com.google.protobuf.LazyStringArrayList(excludeRegex_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to exclude. All files in
     * the bucket that match at least one of these regular expressions will be
     * excluded from the scan.
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string exclude_regex = 3;</code>
     *
     * @return A list containing the excludeRegex.
     */
    public com.google.protobuf.ProtocolStringList getExcludeRegexList() {
      return excludeRegex_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to exclude. All files in
     * the bucket that match at least one of these regular expressions will be
     * excluded from the scan.
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string exclude_regex = 3;</code>
     *
     * @return The count of excludeRegex.
     */
    public int getExcludeRegexCount() {
      return excludeRegex_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to exclude. All files in
     * the bucket that match at least one of these regular expressions will be
     * excluded from the scan.
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string exclude_regex = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The excludeRegex at the given index.
     */
    public java.lang.String getExcludeRegex(int index) {
      return excludeRegex_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to exclude. All files in
     * the bucket that match at least one of these regular expressions will be
     * excluded from the scan.
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string exclude_regex = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludeRegex at the given index.
     */
    public com.google.protobuf.ByteString getExcludeRegexBytes(int index) {
      return excludeRegex_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to exclude. All files in
     * the bucket that match at least one of these regular expressions will be
     * excluded from the scan.
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string exclude_regex = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The excludeRegex to set.
     * @return This builder for chaining.
     */
    public Builder setExcludeRegex(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExcludeRegexIsMutable();
      excludeRegex_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to exclude. All files in
     * the bucket that match at least one of these regular expressions will be
     * excluded from the scan.
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string exclude_regex = 3;</code>
     *
     * @param value The excludeRegex to add.
     * @return This builder for chaining.
     */
    public Builder addExcludeRegex(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExcludeRegexIsMutable();
      excludeRegex_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to exclude. All files in
     * the bucket that match at least one of these regular expressions will be
     * excluded from the scan.
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string exclude_regex = 3;</code>
     *
     * @param values The excludeRegex to add.
     * @return This builder for chaining.
     */
    public Builder addAllExcludeRegex(java.lang.Iterable<java.lang.String> values) {
      ensureExcludeRegexIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludeRegex_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to exclude. All files in
     * the bucket that match at least one of these regular expressions will be
     * excluded from the scan.
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string exclude_regex = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExcludeRegex() {
      excludeRegex_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of regular expressions matching file paths to exclude. All files in
     * the bucket that match at least one of these regular expressions will be
     * excluded from the scan.
     * Regular expressions use RE2
     * [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
     * under the google/re2 repository on GitHub.
     * </pre>
     *
     * <code>repeated string exclude_regex = 3;</code>
     *
     * @param value The bytes of the excludeRegex to add.
     * @return This builder for chaining.
     */
    public Builder addExcludeRegexBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExcludeRegexIsMutable();
      excludeRegex_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CloudStorageRegexFileSet)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CloudStorageRegexFileSet)
  private static final com.google.privacy.dlp.v2.CloudStorageRegexFileSet DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CloudStorageRegexFileSet();
  }

  public static com.google.privacy.dlp.v2.CloudStorageRegexFileSet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudStorageRegexFileSet> PARSER =
      new com.google.protobuf.AbstractParser<CloudStorageRegexFileSet>() {
        @java.lang.Override
        public CloudStorageRegexFileSet parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudStorageRegexFileSet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudStorageRegexFileSet> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudStorageRegexFileSet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
