/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/storage.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Options defining a file or a set of files within a Cloud Storage
 * bucket.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.CloudStorageOptions}
 */
public final class CloudStorageOptions extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CloudStorageOptions)
    CloudStorageOptionsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CloudStorageOptions.newBuilder() to construct.
  private CloudStorageOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CloudStorageOptions() {
    fileTypes_ = java.util.Collections.emptyList();
    sampleMethod_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CloudStorageOptions();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpStorage
        .internal_static_google_privacy_dlp_v2_CloudStorageOptions_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpStorage
        .internal_static_google_privacy_dlp_v2_CloudStorageOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.CloudStorageOptions.class,
            com.google.privacy.dlp.v2.CloudStorageOptions.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * How to sample bytes if not all bytes are scanned. Meaningful only when used
   * in conjunction with bytes_limit_per_file. If not specified, scanning would
   * start from the top.
   * </pre>
   *
   * Protobuf enum {@code google.privacy.dlp.v2.CloudStorageOptions.SampleMethod}
   */
  public enum SampleMethod implements com.google.protobuf.ProtocolMessageEnum {
    /** <code>SAMPLE_METHOD_UNSPECIFIED = 0;</code> */
    SAMPLE_METHOD_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Scan from the top (default).
     * </pre>
     *
     * <code>TOP = 1;</code>
     */
    TOP(1),
    /**
     *
     *
     * <pre>
     * For each file larger than bytes_limit_per_file, randomly pick the offset
     * to start scanning. The scanned bytes are contiguous.
     * </pre>
     *
     * <code>RANDOM_START = 2;</code>
     */
    RANDOM_START(2),
    UNRECOGNIZED(-1),
    ;

    /** <code>SAMPLE_METHOD_UNSPECIFIED = 0;</code> */
    public static final int SAMPLE_METHOD_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Scan from the top (default).
     * </pre>
     *
     * <code>TOP = 1;</code>
     */
    public static final int TOP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * For each file larger than bytes_limit_per_file, randomly pick the offset
     * to start scanning. The scanned bytes are contiguous.
     * </pre>
     *
     * <code>RANDOM_START = 2;</code>
     */
    public static final int RANDOM_START_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SampleMethod valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SampleMethod forNumber(int value) {
      switch (value) {
        case 0:
          return SAMPLE_METHOD_UNSPECIFIED;
        case 1:
          return TOP;
        case 2:
          return RANDOM_START;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SampleMethod> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SampleMethod> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SampleMethod>() {
          public SampleMethod findValueByNumber(int number) {
            return SampleMethod.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.privacy.dlp.v2.CloudStorageOptions.getDescriptor().getEnumTypes().get(0);
    }

    private static final SampleMethod[] VALUES = values();

    public static SampleMethod valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SampleMethod(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.privacy.dlp.v2.CloudStorageOptions.SampleMethod)
  }

  public interface FileSetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.privacy.dlp.v2.CloudStorageOptions.FileSet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The Cloud Storage url of the file(s) to scan, in the format
     * `gs://&lt;bucket&gt;/&lt;path&gt;`. Trailing wildcard in the path is allowed.
     * If the url ends in a trailing slash, the bucket or directory represented
     * by the url will be scanned non-recursively (content in sub-directories
     * will not be scanned). This means that `gs://mybucket/` is equivalent to
     * `gs://mybucket/&#42;`, and `gs://mybucket/directory/` is equivalent to
     * `gs://mybucket/directory/&#42;`.
     * Exactly one of `url` or `regex_file_set` must be set.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The url.
     */
    java.lang.String getUrl();
    /**
     *
     *
     * <pre>
     * The Cloud Storage url of the file(s) to scan, in the format
     * `gs://&lt;bucket&gt;/&lt;path&gt;`. Trailing wildcard in the path is allowed.
     * If the url ends in a trailing slash, the bucket or directory represented
     * by the url will be scanned non-recursively (content in sub-directories
     * will not be scanned). This means that `gs://mybucket/` is equivalent to
     * `gs://mybucket/&#42;`, and `gs://mybucket/directory/` is equivalent to
     * `gs://mybucket/directory/&#42;`.
     * Exactly one of `url` or `regex_file_set` must be set.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The bytes for url.
     */
    com.google.protobuf.ByteString getUrlBytes();

    /**
     *
     *
     * <pre>
     * The regex-filtered set of files to scan. Exactly one of `url` or
     * `regex_file_set` must be set.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
     *
     * @return Whether the regexFileSet field is set.
     */
    boolean hasRegexFileSet();
    /**
     *
     *
     * <pre>
     * The regex-filtered set of files to scan. Exactly one of `url` or
     * `regex_file_set` must be set.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
     *
     * @return The regexFileSet.
     */
    com.google.privacy.dlp.v2.CloudStorageRegexFileSet getRegexFileSet();
    /**
     *
     *
     * <pre>
     * The regex-filtered set of files to scan. Exactly one of `url` or
     * `regex_file_set` must be set.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
     */
    com.google.privacy.dlp.v2.CloudStorageRegexFileSetOrBuilder getRegexFileSetOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Set of files to scan.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CloudStorageOptions.FileSet}
   */
  public static final class FileSet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CloudStorageOptions.FileSet)
      FileSetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FileSet.newBuilder() to construct.
    private FileSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FileSet() {
      url_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FileSet();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CloudStorageOptions_FileSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CloudStorageOptions_FileSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.class,
              com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.Builder.class);
    }

    public static final int URL_FIELD_NUMBER = 1;
    private volatile java.lang.Object url_;
    /**
     *
     *
     * <pre>
     * The Cloud Storage url of the file(s) to scan, in the format
     * `gs://&lt;bucket&gt;/&lt;path&gt;`. Trailing wildcard in the path is allowed.
     * If the url ends in a trailing slash, the bucket or directory represented
     * by the url will be scanned non-recursively (content in sub-directories
     * will not be scanned). This means that `gs://mybucket/` is equivalent to
     * `gs://mybucket/&#42;`, and `gs://mybucket/directory/` is equivalent to
     * `gs://mybucket/directory/&#42;`.
     * Exactly one of `url` or `regex_file_set` must be set.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The url.
     */
    @java.lang.Override
    public java.lang.String getUrl() {
      java.lang.Object ref = url_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        url_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Storage url of the file(s) to scan, in the format
     * `gs://&lt;bucket&gt;/&lt;path&gt;`. Trailing wildcard in the path is allowed.
     * If the url ends in a trailing slash, the bucket or directory represented
     * by the url will be scanned non-recursively (content in sub-directories
     * will not be scanned). This means that `gs://mybucket/` is equivalent to
     * `gs://mybucket/&#42;`, and `gs://mybucket/directory/` is equivalent to
     * `gs://mybucket/directory/&#42;`.
     * Exactly one of `url` or `regex_file_set` must be set.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The bytes for url.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUrlBytes() {
      java.lang.Object ref = url_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        url_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REGEX_FILE_SET_FIELD_NUMBER = 2;
    private com.google.privacy.dlp.v2.CloudStorageRegexFileSet regexFileSet_;
    /**
     *
     *
     * <pre>
     * The regex-filtered set of files to scan. Exactly one of `url` or
     * `regex_file_set` must be set.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
     *
     * @return Whether the regexFileSet field is set.
     */
    @java.lang.Override
    public boolean hasRegexFileSet() {
      return regexFileSet_ != null;
    }
    /**
     *
     *
     * <pre>
     * The regex-filtered set of files to scan. Exactly one of `url` or
     * `regex_file_set` must be set.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
     *
     * @return The regexFileSet.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageRegexFileSet getRegexFileSet() {
      return regexFileSet_ == null
          ? com.google.privacy.dlp.v2.CloudStorageRegexFileSet.getDefaultInstance()
          : regexFileSet_;
    }
    /**
     *
     *
     * <pre>
     * The regex-filtered set of files to scan. Exactly one of `url` or
     * `regex_file_set` must be set.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageRegexFileSetOrBuilder getRegexFileSetOrBuilder() {
      return getRegexFileSet();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, url_);
      }
      if (regexFileSet_ != null) {
        output.writeMessage(2, getRegexFileSet());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, url_);
      }
      if (regexFileSet_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRegexFileSet());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.privacy.dlp.v2.CloudStorageOptions.FileSet)) {
        return super.equals(obj);
      }
      com.google.privacy.dlp.v2.CloudStorageOptions.FileSet other =
          (com.google.privacy.dlp.v2.CloudStorageOptions.FileSet) obj;

      if (!getUrl().equals(other.getUrl())) return false;
      if (hasRegexFileSet() != other.hasRegexFileSet()) return false;
      if (hasRegexFileSet()) {
        if (!getRegexFileSet().equals(other.getRegexFileSet())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URL_FIELD_NUMBER;
      hash = (53 * hash) + getUrl().hashCode();
      if (hasRegexFileSet()) {
        hash = (37 * hash) + REGEX_FILE_SET_FIELD_NUMBER;
        hash = (53 * hash) + getRegexFileSet().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.privacy.dlp.v2.CloudStorageOptions.FileSet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Set of files to scan.
     * </pre>
     *
     * Protobuf type {@code google.privacy.dlp.v2.CloudStorageOptions.FileSet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CloudStorageOptions.FileSet)
        com.google.privacy.dlp.v2.CloudStorageOptions.FileSetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CloudStorageOptions_FileSet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CloudStorageOptions_FileSet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.class,
                com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.Builder.class);
      }

      // Construct using com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        url_ = "";

        if (regexFileSetBuilder_ == null) {
          regexFileSet_ = null;
        } else {
          regexFileSet_ = null;
          regexFileSetBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.privacy.dlp.v2.DlpStorage
            .internal_static_google_privacy_dlp_v2_CloudStorageOptions_FileSet_descriptor;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CloudStorageOptions.FileSet getDefaultInstanceForType() {
        return com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CloudStorageOptions.FileSet build() {
        com.google.privacy.dlp.v2.CloudStorageOptions.FileSet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.privacy.dlp.v2.CloudStorageOptions.FileSet buildPartial() {
        com.google.privacy.dlp.v2.CloudStorageOptions.FileSet result =
            new com.google.privacy.dlp.v2.CloudStorageOptions.FileSet(this);
        result.url_ = url_;
        if (regexFileSetBuilder_ == null) {
          result.regexFileSet_ = regexFileSet_;
        } else {
          result.regexFileSet_ = regexFileSetBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.privacy.dlp.v2.CloudStorageOptions.FileSet) {
          return mergeFrom((com.google.privacy.dlp.v2.CloudStorageOptions.FileSet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.privacy.dlp.v2.CloudStorageOptions.FileSet other) {
        if (other == com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.getDefaultInstance())
          return this;
        if (!other.getUrl().isEmpty()) {
          url_ = other.url_;
          onChanged();
        }
        if (other.hasRegexFileSet()) {
          mergeRegexFileSet(other.getRegexFileSet());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  url_ = input.readStringRequireUtf8();

                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getRegexFileSetFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private java.lang.Object url_ = "";
      /**
       *
       *
       * <pre>
       * The Cloud Storage url of the file(s) to scan, in the format
       * `gs://&lt;bucket&gt;/&lt;path&gt;`. Trailing wildcard in the path is allowed.
       * If the url ends in a trailing slash, the bucket or directory represented
       * by the url will be scanned non-recursively (content in sub-directories
       * will not be scanned). This means that `gs://mybucket/` is equivalent to
       * `gs://mybucket/&#42;`, and `gs://mybucket/directory/` is equivalent to
       * `gs://mybucket/directory/&#42;`.
       * Exactly one of `url` or `regex_file_set` must be set.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @return The url.
       */
      public java.lang.String getUrl() {
        java.lang.Object ref = url_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          url_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage url of the file(s) to scan, in the format
       * `gs://&lt;bucket&gt;/&lt;path&gt;`. Trailing wildcard in the path is allowed.
       * If the url ends in a trailing slash, the bucket or directory represented
       * by the url will be scanned non-recursively (content in sub-directories
       * will not be scanned). This means that `gs://mybucket/` is equivalent to
       * `gs://mybucket/&#42;`, and `gs://mybucket/directory/` is equivalent to
       * `gs://mybucket/directory/&#42;`.
       * Exactly one of `url` or `regex_file_set` must be set.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @return The bytes for url.
       */
      public com.google.protobuf.ByteString getUrlBytes() {
        java.lang.Object ref = url_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          url_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage url of the file(s) to scan, in the format
       * `gs://&lt;bucket&gt;/&lt;path&gt;`. Trailing wildcard in the path is allowed.
       * If the url ends in a trailing slash, the bucket or directory represented
       * by the url will be scanned non-recursively (content in sub-directories
       * will not be scanned). This means that `gs://mybucket/` is equivalent to
       * `gs://mybucket/&#42;`, and `gs://mybucket/directory/` is equivalent to
       * `gs://mybucket/directory/&#42;`.
       * Exactly one of `url` or `regex_file_set` must be set.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @param value The url to set.
       * @return This builder for chaining.
       */
      public Builder setUrl(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        url_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage url of the file(s) to scan, in the format
       * `gs://&lt;bucket&gt;/&lt;path&gt;`. Trailing wildcard in the path is allowed.
       * If the url ends in a trailing slash, the bucket or directory represented
       * by the url will be scanned non-recursively (content in sub-directories
       * will not be scanned). This means that `gs://mybucket/` is equivalent to
       * `gs://mybucket/&#42;`, and `gs://mybucket/directory/` is equivalent to
       * `gs://mybucket/directory/&#42;`.
       * Exactly one of `url` or `regex_file_set` must be set.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUrl() {

        url_ = getDefaultInstance().getUrl();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The Cloud Storage url of the file(s) to scan, in the format
       * `gs://&lt;bucket&gt;/&lt;path&gt;`. Trailing wildcard in the path is allowed.
       * If the url ends in a trailing slash, the bucket or directory represented
       * by the url will be scanned non-recursively (content in sub-directories
       * will not be scanned). This means that `gs://mybucket/` is equivalent to
       * `gs://mybucket/&#42;`, and `gs://mybucket/directory/` is equivalent to
       * `gs://mybucket/directory/&#42;`.
       * Exactly one of `url` or `regex_file_set` must be set.
       * </pre>
       *
       * <code>string url = 1;</code>
       *
       * @param value The bytes for url to set.
       * @return This builder for chaining.
       */
      public Builder setUrlBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        url_ = value;
        onChanged();
        return this;
      }

      private com.google.privacy.dlp.v2.CloudStorageRegexFileSet regexFileSet_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.CloudStorageRegexFileSet,
              com.google.privacy.dlp.v2.CloudStorageRegexFileSet.Builder,
              com.google.privacy.dlp.v2.CloudStorageRegexFileSetOrBuilder>
          regexFileSetBuilder_;
      /**
       *
       *
       * <pre>
       * The regex-filtered set of files to scan. Exactly one of `url` or
       * `regex_file_set` must be set.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
       *
       * @return Whether the regexFileSet field is set.
       */
      public boolean hasRegexFileSet() {
        return regexFileSetBuilder_ != null || regexFileSet_ != null;
      }
      /**
       *
       *
       * <pre>
       * The regex-filtered set of files to scan. Exactly one of `url` or
       * `regex_file_set` must be set.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
       *
       * @return The regexFileSet.
       */
      public com.google.privacy.dlp.v2.CloudStorageRegexFileSet getRegexFileSet() {
        if (regexFileSetBuilder_ == null) {
          return regexFileSet_ == null
              ? com.google.privacy.dlp.v2.CloudStorageRegexFileSet.getDefaultInstance()
              : regexFileSet_;
        } else {
          return regexFileSetBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The regex-filtered set of files to scan. Exactly one of `url` or
       * `regex_file_set` must be set.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
       */
      public Builder setRegexFileSet(com.google.privacy.dlp.v2.CloudStorageRegexFileSet value) {
        if (regexFileSetBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          regexFileSet_ = value;
          onChanged();
        } else {
          regexFileSetBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The regex-filtered set of files to scan. Exactly one of `url` or
       * `regex_file_set` must be set.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
       */
      public Builder setRegexFileSet(
          com.google.privacy.dlp.v2.CloudStorageRegexFileSet.Builder builderForValue) {
        if (regexFileSetBuilder_ == null) {
          regexFileSet_ = builderForValue.build();
          onChanged();
        } else {
          regexFileSetBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The regex-filtered set of files to scan. Exactly one of `url` or
       * `regex_file_set` must be set.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
       */
      public Builder mergeRegexFileSet(com.google.privacy.dlp.v2.CloudStorageRegexFileSet value) {
        if (regexFileSetBuilder_ == null) {
          if (regexFileSet_ != null) {
            regexFileSet_ =
                com.google.privacy.dlp.v2.CloudStorageRegexFileSet.newBuilder(regexFileSet_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            regexFileSet_ = value;
          }
          onChanged();
        } else {
          regexFileSetBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The regex-filtered set of files to scan. Exactly one of `url` or
       * `regex_file_set` must be set.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
       */
      public Builder clearRegexFileSet() {
        if (regexFileSetBuilder_ == null) {
          regexFileSet_ = null;
          onChanged();
        } else {
          regexFileSet_ = null;
          regexFileSetBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The regex-filtered set of files to scan. Exactly one of `url` or
       * `regex_file_set` must be set.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
       */
      public com.google.privacy.dlp.v2.CloudStorageRegexFileSet.Builder getRegexFileSetBuilder() {

        onChanged();
        return getRegexFileSetFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The regex-filtered set of files to scan. Exactly one of `url` or
       * `regex_file_set` must be set.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
       */
      public com.google.privacy.dlp.v2.CloudStorageRegexFileSetOrBuilder
          getRegexFileSetOrBuilder() {
        if (regexFileSetBuilder_ != null) {
          return regexFileSetBuilder_.getMessageOrBuilder();
        } else {
          return regexFileSet_ == null
              ? com.google.privacy.dlp.v2.CloudStorageRegexFileSet.getDefaultInstance()
              : regexFileSet_;
        }
      }
      /**
       *
       *
       * <pre>
       * The regex-filtered set of files to scan. Exactly one of `url` or
       * `regex_file_set` must be set.
       * </pre>
       *
       * <code>.google.privacy.dlp.v2.CloudStorageRegexFileSet regex_file_set = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.privacy.dlp.v2.CloudStorageRegexFileSet,
              com.google.privacy.dlp.v2.CloudStorageRegexFileSet.Builder,
              com.google.privacy.dlp.v2.CloudStorageRegexFileSetOrBuilder>
          getRegexFileSetFieldBuilder() {
        if (regexFileSetBuilder_ == null) {
          regexFileSetBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.privacy.dlp.v2.CloudStorageRegexFileSet,
                  com.google.privacy.dlp.v2.CloudStorageRegexFileSet.Builder,
                  com.google.privacy.dlp.v2.CloudStorageRegexFileSetOrBuilder>(
                  getRegexFileSet(), getParentForChildren(), isClean());
          regexFileSet_ = null;
        }
        return regexFileSetBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CloudStorageOptions.FileSet)
    }

    // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CloudStorageOptions.FileSet)
    private static final com.google.privacy.dlp.v2.CloudStorageOptions.FileSet DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CloudStorageOptions.FileSet();
    }

    public static com.google.privacy.dlp.v2.CloudStorageOptions.FileSet getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FileSet> PARSER =
        new com.google.protobuf.AbstractParser<FileSet>() {
          @java.lang.Override
          public FileSet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FileSet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FileSet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageOptions.FileSet getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int FILE_SET_FIELD_NUMBER = 1;
  private com.google.privacy.dlp.v2.CloudStorageOptions.FileSet fileSet_;
  /**
   *
   *
   * <pre>
   * The set of one or more files to scan.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudStorageOptions.FileSet file_set = 1;</code>
   *
   * @return Whether the fileSet field is set.
   */
  @java.lang.Override
  public boolean hasFileSet() {
    return fileSet_ != null;
  }
  /**
   *
   *
   * <pre>
   * The set of one or more files to scan.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudStorageOptions.FileSet file_set = 1;</code>
   *
   * @return The fileSet.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudStorageOptions.FileSet getFileSet() {
    return fileSet_ == null
        ? com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.getDefaultInstance()
        : fileSet_;
  }
  /**
   *
   *
   * <pre>
   * The set of one or more files to scan.
   * </pre>
   *
   * <code>.google.privacy.dlp.v2.CloudStorageOptions.FileSet file_set = 1;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudStorageOptions.FileSetOrBuilder getFileSetOrBuilder() {
    return getFileSet();
  }

  public static final int BYTES_LIMIT_PER_FILE_FIELD_NUMBER = 4;
  private long bytesLimitPerFile_;
  /**
   *
   *
   * <pre>
   * Max number of bytes to scan from a file. If a scanned file's size is bigger
   * than this value then the rest of the bytes are omitted. Only one
   * of bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
   * Cannot be set if de-identification is requested.
   * </pre>
   *
   * <code>int64 bytes_limit_per_file = 4;</code>
   *
   * @return The bytesLimitPerFile.
   */
  @java.lang.Override
  public long getBytesLimitPerFile() {
    return bytesLimitPerFile_;
  }

  public static final int BYTES_LIMIT_PER_FILE_PERCENT_FIELD_NUMBER = 8;
  private int bytesLimitPerFilePercent_;
  /**
   *
   *
   * <pre>
   * Max percentage of bytes to scan from a file. The rest are omitted. The
   * number of bytes scanned is rounded down. Must be between 0 and 100,
   * inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one
   * of bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
   * Cannot be set if de-identification is requested.
   * </pre>
   *
   * <code>int32 bytes_limit_per_file_percent = 8;</code>
   *
   * @return The bytesLimitPerFilePercent.
   */
  @java.lang.Override
  public int getBytesLimitPerFilePercent() {
    return bytesLimitPerFilePercent_;
  }

  public static final int FILE_TYPES_FIELD_NUMBER = 5;
  private java.util.List<java.lang.Integer> fileTypes_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.privacy.dlp.v2.FileType>
      fileTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.privacy.dlp.v2.FileType>() {
            public com.google.privacy.dlp.v2.FileType convert(java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.privacy.dlp.v2.FileType result =
                  com.google.privacy.dlp.v2.FileType.valueOf(from);
              return result == null ? com.google.privacy.dlp.v2.FileType.UNRECOGNIZED : result;
            }
          };
  /**
   *
   *
   * <pre>
   * List of file type groups to include in the scan.
   * If empty, all files are scanned and available data format processors
   * are applied. In addition, the binary content of the selected files
   * is always scanned as well.
   * Images are scanned only as binary if the specified region
   * does not support image inspection and no file_types were specified.
   * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
   *
   * @return A list containing the fileTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.FileType> getFileTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.privacy.dlp.v2.FileType>(fileTypes_, fileTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * List of file type groups to include in the scan.
   * If empty, all files are scanned and available data format processors
   * are applied. In addition, the binary content of the selected files
   * is always scanned as well.
   * Images are scanned only as binary if the specified region
   * does not support image inspection and no file_types were specified.
   * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
   *
   * @return The count of fileTypes.
   */
  @java.lang.Override
  public int getFileTypesCount() {
    return fileTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * List of file type groups to include in the scan.
   * If empty, all files are scanned and available data format processors
   * are applied. In addition, the binary content of the selected files
   * is always scanned as well.
   * Images are scanned only as binary if the specified region
   * does not support image inspection and no file_types were specified.
   * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The fileTypes at the given index.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.FileType getFileTypes(int index) {
    return fileTypes_converter_.convert(fileTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * List of file type groups to include in the scan.
   * If empty, all files are scanned and available data format processors
   * are applied. In addition, the binary content of the selected files
   * is always scanned as well.
   * Images are scanned only as binary if the specified region
   * does not support image inspection and no file_types were specified.
   * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
   *
   * @return A list containing the enum numeric values on the wire for fileTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getFileTypesValueList() {
    return fileTypes_;
  }
  /**
   *
   *
   * <pre>
   * List of file type groups to include in the scan.
   * If empty, all files are scanned and available data format processors
   * are applied. In addition, the binary content of the selected files
   * is always scanned as well.
   * Images are scanned only as binary if the specified region
   * does not support image inspection and no file_types were specified.
   * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of fileTypes at the given index.
   */
  @java.lang.Override
  public int getFileTypesValue(int index) {
    return fileTypes_.get(index);
  }

  private int fileTypesMemoizedSerializedSize;

  public static final int SAMPLE_METHOD_FIELD_NUMBER = 6;
  private int sampleMethod_;
  /**
   * <code>.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod sample_method = 6;</code>
   *
   * @return The enum numeric value on the wire for sampleMethod.
   */
  @java.lang.Override
  public int getSampleMethodValue() {
    return sampleMethod_;
  }
  /**
   * <code>.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod sample_method = 6;</code>
   *
   * @return The sampleMethod.
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod getSampleMethod() {
    @SuppressWarnings("deprecation")
    com.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod result =
        com.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod.valueOf(sampleMethod_);
    return result == null
        ? com.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod.UNRECOGNIZED
        : result;
  }

  public static final int FILES_LIMIT_PERCENT_FIELD_NUMBER = 7;
  private int filesLimitPercent_;
  /**
   *
   *
   * <pre>
   * Limits the number of files to scan to this percentage of the input FileSet.
   * Number of files scanned is rounded down. Must be between 0 and 100,
   * inclusively. Both 0 and 100 means no limit. Defaults to 0.
   * </pre>
   *
   * <code>int32 files_limit_percent = 7;</code>
   *
   * @return The filesLimitPercent.
   */
  @java.lang.Override
  public int getFilesLimitPercent() {
    return filesLimitPercent_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (fileSet_ != null) {
      output.writeMessage(1, getFileSet());
    }
    if (bytesLimitPerFile_ != 0L) {
      output.writeInt64(4, bytesLimitPerFile_);
    }
    if (getFileTypesList().size() > 0) {
      output.writeUInt32NoTag(42);
      output.writeUInt32NoTag(fileTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < fileTypes_.size(); i++) {
      output.writeEnumNoTag(fileTypes_.get(i));
    }
    if (sampleMethod_
        != com.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod.SAMPLE_METHOD_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, sampleMethod_);
    }
    if (filesLimitPercent_ != 0) {
      output.writeInt32(7, filesLimitPercent_);
    }
    if (bytesLimitPerFilePercent_ != 0) {
      output.writeInt32(8, bytesLimitPerFilePercent_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (fileSet_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getFileSet());
    }
    if (bytesLimitPerFile_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, bytesLimitPerFile_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < fileTypes_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(fileTypes_.get(i));
      }
      size += dataSize;
      if (!getFileTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      fileTypesMemoizedSerializedSize = dataSize;
    }
    if (sampleMethod_
        != com.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod.SAMPLE_METHOD_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, sampleMethod_);
    }
    if (filesLimitPercent_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, filesLimitPercent_);
    }
    if (bytesLimitPerFilePercent_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, bytesLimitPerFilePercent_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.CloudStorageOptions)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.CloudStorageOptions other =
        (com.google.privacy.dlp.v2.CloudStorageOptions) obj;

    if (hasFileSet() != other.hasFileSet()) return false;
    if (hasFileSet()) {
      if (!getFileSet().equals(other.getFileSet())) return false;
    }
    if (getBytesLimitPerFile() != other.getBytesLimitPerFile()) return false;
    if (getBytesLimitPerFilePercent() != other.getBytesLimitPerFilePercent()) return false;
    if (!fileTypes_.equals(other.fileTypes_)) return false;
    if (sampleMethod_ != other.sampleMethod_) return false;
    if (getFilesLimitPercent() != other.getFilesLimitPercent()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasFileSet()) {
      hash = (37 * hash) + FILE_SET_FIELD_NUMBER;
      hash = (53 * hash) + getFileSet().hashCode();
    }
    hash = (37 * hash) + BYTES_LIMIT_PER_FILE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getBytesLimitPerFile());
    hash = (37 * hash) + BYTES_LIMIT_PER_FILE_PERCENT_FIELD_NUMBER;
    hash = (53 * hash) + getBytesLimitPerFilePercent();
    if (getFileTypesCount() > 0) {
      hash = (37 * hash) + FILE_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + fileTypes_.hashCode();
    }
    hash = (37 * hash) + SAMPLE_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + sampleMethod_;
    hash = (37 * hash) + FILES_LIMIT_PERCENT_FIELD_NUMBER;
    hash = (53 * hash) + getFilesLimitPercent();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.CloudStorageOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Options defining a file or a set of files within a Cloud Storage
   * bucket.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CloudStorageOptions}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CloudStorageOptions)
      com.google.privacy.dlp.v2.CloudStorageOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CloudStorageOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CloudStorageOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CloudStorageOptions.class,
              com.google.privacy.dlp.v2.CloudStorageOptions.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.CloudStorageOptions.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (fileSetBuilder_ == null) {
        fileSet_ = null;
      } else {
        fileSet_ = null;
        fileSetBuilder_ = null;
      }
      bytesLimitPerFile_ = 0L;

      bytesLimitPerFilePercent_ = 0;

      fileTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      sampleMethod_ = 0;

      filesLimitPercent_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpStorage
          .internal_static_google_privacy_dlp_v2_CloudStorageOptions_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageOptions getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.CloudStorageOptions.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageOptions build() {
      com.google.privacy.dlp.v2.CloudStorageOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageOptions buildPartial() {
      com.google.privacy.dlp.v2.CloudStorageOptions result =
          new com.google.privacy.dlp.v2.CloudStorageOptions(this);
      int from_bitField0_ = bitField0_;
      if (fileSetBuilder_ == null) {
        result.fileSet_ = fileSet_;
      } else {
        result.fileSet_ = fileSetBuilder_.build();
      }
      result.bytesLimitPerFile_ = bytesLimitPerFile_;
      result.bytesLimitPerFilePercent_ = bytesLimitPerFilePercent_;
      if (((bitField0_ & 0x00000001) != 0)) {
        fileTypes_ = java.util.Collections.unmodifiableList(fileTypes_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.fileTypes_ = fileTypes_;
      result.sampleMethod_ = sampleMethod_;
      result.filesLimitPercent_ = filesLimitPercent_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.CloudStorageOptions) {
        return mergeFrom((com.google.privacy.dlp.v2.CloudStorageOptions) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.CloudStorageOptions other) {
      if (other == com.google.privacy.dlp.v2.CloudStorageOptions.getDefaultInstance()) return this;
      if (other.hasFileSet()) {
        mergeFileSet(other.getFileSet());
      }
      if (other.getBytesLimitPerFile() != 0L) {
        setBytesLimitPerFile(other.getBytesLimitPerFile());
      }
      if (other.getBytesLimitPerFilePercent() != 0) {
        setBytesLimitPerFilePercent(other.getBytesLimitPerFilePercent());
      }
      if (!other.fileTypes_.isEmpty()) {
        if (fileTypes_.isEmpty()) {
          fileTypes_ = other.fileTypes_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureFileTypesIsMutable();
          fileTypes_.addAll(other.fileTypes_);
        }
        onChanged();
      }
      if (other.sampleMethod_ != 0) {
        setSampleMethodValue(other.getSampleMethodValue());
      }
      if (other.getFilesLimitPercent() != 0) {
        setFilesLimitPercent(other.getFilesLimitPercent());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getFileSetFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 10
            case 32:
              {
                bytesLimitPerFile_ = input.readInt64();

                break;
              } // case 32
            case 40:
              {
                int tmpRaw = input.readEnum();
                ensureFileTypesIsMutable();
                fileTypes_.add(tmpRaw);
                break;
              } // case 40
            case 42:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureFileTypesIsMutable();
                  fileTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 42
            case 48:
              {
                sampleMethod_ = input.readEnum();

                break;
              } // case 48
            case 56:
              {
                filesLimitPercent_ = input.readInt32();

                break;
              } // case 56
            case 64:
              {
                bytesLimitPerFilePercent_ = input.readInt32();

                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.privacy.dlp.v2.CloudStorageOptions.FileSet fileSet_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CloudStorageOptions.FileSet,
            com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.Builder,
            com.google.privacy.dlp.v2.CloudStorageOptions.FileSetOrBuilder>
        fileSetBuilder_;
    /**
     *
     *
     * <pre>
     * The set of one or more files to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.FileSet file_set = 1;</code>
     *
     * @return Whether the fileSet field is set.
     */
    public boolean hasFileSet() {
      return fileSetBuilder_ != null || fileSet_ != null;
    }
    /**
     *
     *
     * <pre>
     * The set of one or more files to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.FileSet file_set = 1;</code>
     *
     * @return The fileSet.
     */
    public com.google.privacy.dlp.v2.CloudStorageOptions.FileSet getFileSet() {
      if (fileSetBuilder_ == null) {
        return fileSet_ == null
            ? com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.getDefaultInstance()
            : fileSet_;
      } else {
        return fileSetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The set of one or more files to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.FileSet file_set = 1;</code>
     */
    public Builder setFileSet(com.google.privacy.dlp.v2.CloudStorageOptions.FileSet value) {
      if (fileSetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fileSet_ = value;
        onChanged();
      } else {
        fileSetBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of one or more files to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.FileSet file_set = 1;</code>
     */
    public Builder setFileSet(
        com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.Builder builderForValue) {
      if (fileSetBuilder_ == null) {
        fileSet_ = builderForValue.build();
        onChanged();
      } else {
        fileSetBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of one or more files to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.FileSet file_set = 1;</code>
     */
    public Builder mergeFileSet(com.google.privacy.dlp.v2.CloudStorageOptions.FileSet value) {
      if (fileSetBuilder_ == null) {
        if (fileSet_ != null) {
          fileSet_ =
              com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.newBuilder(fileSet_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          fileSet_ = value;
        }
        onChanged();
      } else {
        fileSetBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of one or more files to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.FileSet file_set = 1;</code>
     */
    public Builder clearFileSet() {
      if (fileSetBuilder_ == null) {
        fileSet_ = null;
        onChanged();
      } else {
        fileSet_ = null;
        fileSetBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The set of one or more files to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.FileSet file_set = 1;</code>
     */
    public com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.Builder getFileSetBuilder() {

      onChanged();
      return getFileSetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The set of one or more files to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.FileSet file_set = 1;</code>
     */
    public com.google.privacy.dlp.v2.CloudStorageOptions.FileSetOrBuilder getFileSetOrBuilder() {
      if (fileSetBuilder_ != null) {
        return fileSetBuilder_.getMessageOrBuilder();
      } else {
        return fileSet_ == null
            ? com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.getDefaultInstance()
            : fileSet_;
      }
    }
    /**
     *
     *
     * <pre>
     * The set of one or more files to scan.
     * </pre>
     *
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.FileSet file_set = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.privacy.dlp.v2.CloudStorageOptions.FileSet,
            com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.Builder,
            com.google.privacy.dlp.v2.CloudStorageOptions.FileSetOrBuilder>
        getFileSetFieldBuilder() {
      if (fileSetBuilder_ == null) {
        fileSetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.privacy.dlp.v2.CloudStorageOptions.FileSet,
                com.google.privacy.dlp.v2.CloudStorageOptions.FileSet.Builder,
                com.google.privacy.dlp.v2.CloudStorageOptions.FileSetOrBuilder>(
                getFileSet(), getParentForChildren(), isClean());
        fileSet_ = null;
      }
      return fileSetBuilder_;
    }

    private long bytesLimitPerFile_;
    /**
     *
     *
     * <pre>
     * Max number of bytes to scan from a file. If a scanned file's size is bigger
     * than this value then the rest of the bytes are omitted. Only one
     * of bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
     * Cannot be set if de-identification is requested.
     * </pre>
     *
     * <code>int64 bytes_limit_per_file = 4;</code>
     *
     * @return The bytesLimitPerFile.
     */
    @java.lang.Override
    public long getBytesLimitPerFile() {
      return bytesLimitPerFile_;
    }
    /**
     *
     *
     * <pre>
     * Max number of bytes to scan from a file. If a scanned file's size is bigger
     * than this value then the rest of the bytes are omitted. Only one
     * of bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
     * Cannot be set if de-identification is requested.
     * </pre>
     *
     * <code>int64 bytes_limit_per_file = 4;</code>
     *
     * @param value The bytesLimitPerFile to set.
     * @return This builder for chaining.
     */
    public Builder setBytesLimitPerFile(long value) {

      bytesLimitPerFile_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max number of bytes to scan from a file. If a scanned file's size is bigger
     * than this value then the rest of the bytes are omitted. Only one
     * of bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
     * Cannot be set if de-identification is requested.
     * </pre>
     *
     * <code>int64 bytes_limit_per_file = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBytesLimitPerFile() {

      bytesLimitPerFile_ = 0L;
      onChanged();
      return this;
    }

    private int bytesLimitPerFilePercent_;
    /**
     *
     *
     * <pre>
     * Max percentage of bytes to scan from a file. The rest are omitted. The
     * number of bytes scanned is rounded down. Must be between 0 and 100,
     * inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one
     * of bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
     * Cannot be set if de-identification is requested.
     * </pre>
     *
     * <code>int32 bytes_limit_per_file_percent = 8;</code>
     *
     * @return The bytesLimitPerFilePercent.
     */
    @java.lang.Override
    public int getBytesLimitPerFilePercent() {
      return bytesLimitPerFilePercent_;
    }
    /**
     *
     *
     * <pre>
     * Max percentage of bytes to scan from a file. The rest are omitted. The
     * number of bytes scanned is rounded down. Must be between 0 and 100,
     * inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one
     * of bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
     * Cannot be set if de-identification is requested.
     * </pre>
     *
     * <code>int32 bytes_limit_per_file_percent = 8;</code>
     *
     * @param value The bytesLimitPerFilePercent to set.
     * @return This builder for chaining.
     */
    public Builder setBytesLimitPerFilePercent(int value) {

      bytesLimitPerFilePercent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max percentage of bytes to scan from a file. The rest are omitted. The
     * number of bytes scanned is rounded down. Must be between 0 and 100,
     * inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one
     * of bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
     * Cannot be set if de-identification is requested.
     * </pre>
     *
     * <code>int32 bytes_limit_per_file_percent = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBytesLimitPerFilePercent() {

      bytesLimitPerFilePercent_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> fileTypes_ = java.util.Collections.emptyList();

    private void ensureFileTypesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        fileTypes_ = new java.util.ArrayList<java.lang.Integer>(fileTypes_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * List of file type groups to include in the scan.
     * If empty, all files are scanned and available data format processors
     * are applied. In addition, the binary content of the selected files
     * is always scanned as well.
     * Images are scanned only as binary if the specified region
     * does not support image inspection and no file_types were specified.
     * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
     *
     * @return A list containing the fileTypes.
     */
    public java.util.List<com.google.privacy.dlp.v2.FileType> getFileTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.privacy.dlp.v2.FileType>(fileTypes_, fileTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * List of file type groups to include in the scan.
     * If empty, all files are scanned and available data format processors
     * are applied. In addition, the binary content of the selected files
     * is always scanned as well.
     * Images are scanned only as binary if the specified region
     * does not support image inspection and no file_types were specified.
     * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
     *
     * @return The count of fileTypes.
     */
    public int getFileTypesCount() {
      return fileTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * List of file type groups to include in the scan.
     * If empty, all files are scanned and available data format processors
     * are applied. In addition, the binary content of the selected files
     * is always scanned as well.
     * Images are scanned only as binary if the specified region
     * does not support image inspection and no file_types were specified.
     * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The fileTypes at the given index.
     */
    public com.google.privacy.dlp.v2.FileType getFileTypes(int index) {
      return fileTypes_converter_.convert(fileTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * List of file type groups to include in the scan.
     * If empty, all files are scanned and available data format processors
     * are applied. In addition, the binary content of the selected files
     * is always scanned as well.
     * Images are scanned only as binary if the specified region
     * does not support image inspection and no file_types were specified.
     * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The fileTypes to set.
     * @return This builder for chaining.
     */
    public Builder setFileTypes(int index, com.google.privacy.dlp.v2.FileType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFileTypesIsMutable();
      fileTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file type groups to include in the scan.
     * If empty, all files are scanned and available data format processors
     * are applied. In addition, the binary content of the selected files
     * is always scanned as well.
     * Images are scanned only as binary if the specified region
     * does not support image inspection and no file_types were specified.
     * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
     *
     * @param value The fileTypes to add.
     * @return This builder for chaining.
     */
    public Builder addFileTypes(com.google.privacy.dlp.v2.FileType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFileTypesIsMutable();
      fileTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file type groups to include in the scan.
     * If empty, all files are scanned and available data format processors
     * are applied. In addition, the binary content of the selected files
     * is always scanned as well.
     * Images are scanned only as binary if the specified region
     * does not support image inspection and no file_types were specified.
     * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
     *
     * @param values The fileTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllFileTypes(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.FileType> values) {
      ensureFileTypesIsMutable();
      for (com.google.privacy.dlp.v2.FileType value : values) {
        fileTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file type groups to include in the scan.
     * If empty, all files are scanned and available data format processors
     * are applied. In addition, the binary content of the selected files
     * is always scanned as well.
     * Images are scanned only as binary if the specified region
     * does not support image inspection and no file_types were specified.
     * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFileTypes() {
      fileTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file type groups to include in the scan.
     * If empty, all files are scanned and available data format processors
     * are applied. In addition, the binary content of the selected files
     * is always scanned as well.
     * Images are scanned only as binary if the specified region
     * does not support image inspection and no file_types were specified.
     * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
     *
     * @return A list containing the enum numeric values on the wire for fileTypes.
     */
    public java.util.List<java.lang.Integer> getFileTypesValueList() {
      return java.util.Collections.unmodifiableList(fileTypes_);
    }
    /**
     *
     *
     * <pre>
     * List of file type groups to include in the scan.
     * If empty, all files are scanned and available data format processors
     * are applied. In addition, the binary content of the selected files
     * is always scanned as well.
     * Images are scanned only as binary if the specified region
     * does not support image inspection and no file_types were specified.
     * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of fileTypes at the given index.
     */
    public int getFileTypesValue(int index) {
      return fileTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of file type groups to include in the scan.
     * If empty, all files are scanned and available data format processors
     * are applied. In addition, the binary content of the selected files
     * is always scanned as well.
     * Images are scanned only as binary if the specified region
     * does not support image inspection and no file_types were specified.
     * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for fileTypes to set.
     * @return This builder for chaining.
     */
    public Builder setFileTypesValue(int index, int value) {
      ensureFileTypesIsMutable();
      fileTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file type groups to include in the scan.
     * If empty, all files are scanned and available data format processors
     * are applied. In addition, the binary content of the selected files
     * is always scanned as well.
     * Images are scanned only as binary if the specified region
     * does not support image inspection and no file_types were specified.
     * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
     *
     * @param value The enum numeric value on the wire for fileTypes to add.
     * @return This builder for chaining.
     */
    public Builder addFileTypesValue(int value) {
      ensureFileTypesIsMutable();
      fileTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file type groups to include in the scan.
     * If empty, all files are scanned and available data format processors
     * are applied. In addition, the binary content of the selected files
     * is always scanned as well.
     * Images are scanned only as binary if the specified region
     * does not support image inspection and no file_types were specified.
     * Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.FileType file_types = 5;</code>
     *
     * @param values The enum numeric values on the wire for fileTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllFileTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureFileTypesIsMutable();
      for (int value : values) {
        fileTypes_.add(value);
      }
      onChanged();
      return this;
    }

    private int sampleMethod_ = 0;
    /**
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod sample_method = 6;</code>
     *
     * @return The enum numeric value on the wire for sampleMethod.
     */
    @java.lang.Override
    public int getSampleMethodValue() {
      return sampleMethod_;
    }
    /**
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod sample_method = 6;</code>
     *
     * @param value The enum numeric value on the wire for sampleMethod to set.
     * @return This builder for chaining.
     */
    public Builder setSampleMethodValue(int value) {

      sampleMethod_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod sample_method = 6;</code>
     *
     * @return The sampleMethod.
     */
    @java.lang.Override
    public com.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod getSampleMethod() {
      @SuppressWarnings("deprecation")
      com.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod result =
          com.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod.valueOf(sampleMethod_);
      return result == null
          ? com.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod.UNRECOGNIZED
          : result;
    }
    /**
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod sample_method = 6;</code>
     *
     * @param value The sampleMethod to set.
     * @return This builder for chaining.
     */
    public Builder setSampleMethod(
        com.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }

      sampleMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <code>.google.privacy.dlp.v2.CloudStorageOptions.SampleMethod sample_method = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSampleMethod() {

      sampleMethod_ = 0;
      onChanged();
      return this;
    }

    private int filesLimitPercent_;
    /**
     *
     *
     * <pre>
     * Limits the number of files to scan to this percentage of the input FileSet.
     * Number of files scanned is rounded down. Must be between 0 and 100,
     * inclusively. Both 0 and 100 means no limit. Defaults to 0.
     * </pre>
     *
     * <code>int32 files_limit_percent = 7;</code>
     *
     * @return The filesLimitPercent.
     */
    @java.lang.Override
    public int getFilesLimitPercent() {
      return filesLimitPercent_;
    }
    /**
     *
     *
     * <pre>
     * Limits the number of files to scan to this percentage of the input FileSet.
     * Number of files scanned is rounded down. Must be between 0 and 100,
     * inclusively. Both 0 and 100 means no limit. Defaults to 0.
     * </pre>
     *
     * <code>int32 files_limit_percent = 7;</code>
     *
     * @param value The filesLimitPercent to set.
     * @return This builder for chaining.
     */
    public Builder setFilesLimitPercent(int value) {

      filesLimitPercent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Limits the number of files to scan to this percentage of the input FileSet.
     * Number of files scanned is rounded down. Must be between 0 and 100,
     * inclusively. Both 0 and 100 means no limit. Defaults to 0.
     * </pre>
     *
     * <code>int32 files_limit_percent = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilesLimitPercent() {

      filesLimitPercent_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CloudStorageOptions)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CloudStorageOptions)
  private static final com.google.privacy.dlp.v2.CloudStorageOptions DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CloudStorageOptions();
  }

  public static com.google.privacy.dlp.v2.CloudStorageOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CloudStorageOptions> PARSER =
      new com.google.protobuf.AbstractParser<CloudStorageOptions>() {
        @java.lang.Override
        public CloudStorageOptions parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CloudStorageOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CloudStorageOptions> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.CloudStorageOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
