/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/privacy/dlp/v2/dlp.proto

package com.google.privacy.dlp.v2;

/**
 *
 *
 * <pre>
 * Partially mask a string by replacing a given number of characters with a
 * fixed character. Masking can start from the beginning or end of the string.
 * This can be used on data of any type (numbers, longs, and so on) and when
 * de-identifying structured data we'll attempt to preserve the original data's
 * type. (This allows you to take a long like 123 and modify it to a string like
 * **3.
 * </pre>
 *
 * Protobuf type {@code google.privacy.dlp.v2.CharacterMaskConfig}
 */
public final class CharacterMaskConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.privacy.dlp.v2.CharacterMaskConfig)
    CharacterMaskConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CharacterMaskConfig.newBuilder() to construct.
  private CharacterMaskConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CharacterMaskConfig() {
    maskingCharacter_ = "";
    charactersToIgnore_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CharacterMaskConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_CharacterMaskConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.privacy.dlp.v2.DlpProto
        .internal_static_google_privacy_dlp_v2_CharacterMaskConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.privacy.dlp.v2.CharacterMaskConfig.class,
            com.google.privacy.dlp.v2.CharacterMaskConfig.Builder.class);
  }

  public static final int MASKING_CHARACTER_FIELD_NUMBER = 1;
  private volatile java.lang.Object maskingCharacter_;
  /**
   *
   *
   * <pre>
   * Character to use to mask the sensitive values&amp;mdash;for example, `*` for an
   * alphabetic string such as a name, or `0` for a numeric string such as ZIP
   * code or credit card number. This string must have a length of 1. If not
   * supplied, this value defaults to `*` for strings, and `0` for digits.
   * </pre>
   *
   * <code>string masking_character = 1;</code>
   *
   * @return The maskingCharacter.
   */
  @java.lang.Override
  public java.lang.String getMaskingCharacter() {
    java.lang.Object ref = maskingCharacter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      maskingCharacter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Character to use to mask the sensitive values&amp;mdash;for example, `*` for an
   * alphabetic string such as a name, or `0` for a numeric string such as ZIP
   * code or credit card number. This string must have a length of 1. If not
   * supplied, this value defaults to `*` for strings, and `0` for digits.
   * </pre>
   *
   * <code>string masking_character = 1;</code>
   *
   * @return The bytes for maskingCharacter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMaskingCharacterBytes() {
    java.lang.Object ref = maskingCharacter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      maskingCharacter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NUMBER_TO_MASK_FIELD_NUMBER = 2;
  private int numberToMask_;
  /**
   *
   *
   * <pre>
   * Number of characters to mask. If not set, all matching chars will be
   * masked. Skipped characters do not count towards this tally.
   * If `number_to_mask` is negative, this denotes inverse masking. Cloud DLP
   * masks all but a number of characters.
   * For example, suppose you have the following values:
   * - `masking_character` is `*`
   * - `number_to_mask` is `-4`
   * - `reverse_order` is `false`
   * - `CharsToIgnore` includes `-`
   * - Input string is `1234-5678-9012-3456`
   * The resulting de-identified string is
   * `****-****-****-3456`. Cloud DLP masks all but the last four characters.
   * If `reverse_order` is `true`, all but the first four characters are masked
   * as `1234-****-****-****`.
   * </pre>
   *
   * <code>int32 number_to_mask = 2;</code>
   *
   * @return The numberToMask.
   */
  @java.lang.Override
  public int getNumberToMask() {
    return numberToMask_;
  }

  public static final int REVERSE_ORDER_FIELD_NUMBER = 3;
  private boolean reverseOrder_;
  /**
   *
   *
   * <pre>
   * Mask characters in reverse order. For example, if `masking_character` is
   * `0`, `number_to_mask` is `14`, and `reverse_order` is `false`, then the
   * input string `1234-5678-9012-3456` is masked as `00000000000000-3456`.
   * If `masking_character` is `*`, `number_to_mask` is `3`, and `reverse_order`
   * is `true`, then the string `12345` is masked as `12***`.
   * </pre>
   *
   * <code>bool reverse_order = 3;</code>
   *
   * @return The reverseOrder.
   */
  @java.lang.Override
  public boolean getReverseOrder() {
    return reverseOrder_;
  }

  public static final int CHARACTERS_TO_IGNORE_FIELD_NUMBER = 4;
  private java.util.List<com.google.privacy.dlp.v2.CharsToIgnore> charactersToIgnore_;
  /**
   *
   *
   * <pre>
   * When masking a string, items in this list will be skipped when replacing
   * characters. For example, if the input string is `555-555-5555` and you
   * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
   * returns `***-**5-5555`.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.privacy.dlp.v2.CharsToIgnore> getCharactersToIgnoreList() {
    return charactersToIgnore_;
  }
  /**
   *
   *
   * <pre>
   * When masking a string, items in this list will be skipped when replacing
   * characters. For example, if the input string is `555-555-5555` and you
   * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
   * returns `***-**5-5555`.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.privacy.dlp.v2.CharsToIgnoreOrBuilder>
      getCharactersToIgnoreOrBuilderList() {
    return charactersToIgnore_;
  }
  /**
   *
   *
   * <pre>
   * When masking a string, items in this list will be skipped when replacing
   * characters. For example, if the input string is `555-555-5555` and you
   * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
   * returns `***-**5-5555`.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
   */
  @java.lang.Override
  public int getCharactersToIgnoreCount() {
    return charactersToIgnore_.size();
  }
  /**
   *
   *
   * <pre>
   * When masking a string, items in this list will be skipped when replacing
   * characters. For example, if the input string is `555-555-5555` and you
   * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
   * returns `***-**5-5555`.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CharsToIgnore getCharactersToIgnore(int index) {
    return charactersToIgnore_.get(index);
  }
  /**
   *
   *
   * <pre>
   * When masking a string, items in this list will be skipped when replacing
   * characters. For example, if the input string is `555-555-5555` and you
   * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
   * returns `***-**5-5555`.
   * </pre>
   *
   * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
   */
  @java.lang.Override
  public com.google.privacy.dlp.v2.CharsToIgnoreOrBuilder getCharactersToIgnoreOrBuilder(
      int index) {
    return charactersToIgnore_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(maskingCharacter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, maskingCharacter_);
    }
    if (numberToMask_ != 0) {
      output.writeInt32(2, numberToMask_);
    }
    if (reverseOrder_ != false) {
      output.writeBool(3, reverseOrder_);
    }
    for (int i = 0; i < charactersToIgnore_.size(); i++) {
      output.writeMessage(4, charactersToIgnore_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(maskingCharacter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, maskingCharacter_);
    }
    if (numberToMask_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, numberToMask_);
    }
    if (reverseOrder_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, reverseOrder_);
    }
    for (int i = 0; i < charactersToIgnore_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, charactersToIgnore_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.privacy.dlp.v2.CharacterMaskConfig)) {
      return super.equals(obj);
    }
    com.google.privacy.dlp.v2.CharacterMaskConfig other =
        (com.google.privacy.dlp.v2.CharacterMaskConfig) obj;

    if (!getMaskingCharacter().equals(other.getMaskingCharacter())) return false;
    if (getNumberToMask() != other.getNumberToMask()) return false;
    if (getReverseOrder() != other.getReverseOrder()) return false;
    if (!getCharactersToIgnoreList().equals(other.getCharactersToIgnoreList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MASKING_CHARACTER_FIELD_NUMBER;
    hash = (53 * hash) + getMaskingCharacter().hashCode();
    hash = (37 * hash) + NUMBER_TO_MASK_FIELD_NUMBER;
    hash = (53 * hash) + getNumberToMask();
    hash = (37 * hash) + REVERSE_ORDER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getReverseOrder());
    if (getCharactersToIgnoreCount() > 0) {
      hash = (37 * hash) + CHARACTERS_TO_IGNORE_FIELD_NUMBER;
      hash = (53 * hash) + getCharactersToIgnoreList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.privacy.dlp.v2.CharacterMaskConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Partially mask a string by replacing a given number of characters with a
   * fixed character. Masking can start from the beginning or end of the string.
   * This can be used on data of any type (numbers, longs, and so on) and when
   * de-identifying structured data we'll attempt to preserve the original data's
   * type. (This allows you to take a long like 123 and modify it to a string like
   * **3.
   * </pre>
   *
   * Protobuf type {@code google.privacy.dlp.v2.CharacterMaskConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.privacy.dlp.v2.CharacterMaskConfig)
      com.google.privacy.dlp.v2.CharacterMaskConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CharacterMaskConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CharacterMaskConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.privacy.dlp.v2.CharacterMaskConfig.class,
              com.google.privacy.dlp.v2.CharacterMaskConfig.Builder.class);
    }

    // Construct using com.google.privacy.dlp.v2.CharacterMaskConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      maskingCharacter_ = "";

      numberToMask_ = 0;

      reverseOrder_ = false;

      if (charactersToIgnoreBuilder_ == null) {
        charactersToIgnore_ = java.util.Collections.emptyList();
      } else {
        charactersToIgnore_ = null;
        charactersToIgnoreBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.privacy.dlp.v2.DlpProto
          .internal_static_google_privacy_dlp_v2_CharacterMaskConfig_descriptor;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CharacterMaskConfig getDefaultInstanceForType() {
      return com.google.privacy.dlp.v2.CharacterMaskConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CharacterMaskConfig build() {
      com.google.privacy.dlp.v2.CharacterMaskConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.privacy.dlp.v2.CharacterMaskConfig buildPartial() {
      com.google.privacy.dlp.v2.CharacterMaskConfig result =
          new com.google.privacy.dlp.v2.CharacterMaskConfig(this);
      int from_bitField0_ = bitField0_;
      result.maskingCharacter_ = maskingCharacter_;
      result.numberToMask_ = numberToMask_;
      result.reverseOrder_ = reverseOrder_;
      if (charactersToIgnoreBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          charactersToIgnore_ = java.util.Collections.unmodifiableList(charactersToIgnore_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.charactersToIgnore_ = charactersToIgnore_;
      } else {
        result.charactersToIgnore_ = charactersToIgnoreBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.privacy.dlp.v2.CharacterMaskConfig) {
        return mergeFrom((com.google.privacy.dlp.v2.CharacterMaskConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.privacy.dlp.v2.CharacterMaskConfig other) {
      if (other == com.google.privacy.dlp.v2.CharacterMaskConfig.getDefaultInstance()) return this;
      if (!other.getMaskingCharacter().isEmpty()) {
        maskingCharacter_ = other.maskingCharacter_;
        onChanged();
      }
      if (other.getNumberToMask() != 0) {
        setNumberToMask(other.getNumberToMask());
      }
      if (other.getReverseOrder() != false) {
        setReverseOrder(other.getReverseOrder());
      }
      if (charactersToIgnoreBuilder_ == null) {
        if (!other.charactersToIgnore_.isEmpty()) {
          if (charactersToIgnore_.isEmpty()) {
            charactersToIgnore_ = other.charactersToIgnore_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCharactersToIgnoreIsMutable();
            charactersToIgnore_.addAll(other.charactersToIgnore_);
          }
          onChanged();
        }
      } else {
        if (!other.charactersToIgnore_.isEmpty()) {
          if (charactersToIgnoreBuilder_.isEmpty()) {
            charactersToIgnoreBuilder_.dispose();
            charactersToIgnoreBuilder_ = null;
            charactersToIgnore_ = other.charactersToIgnore_;
            bitField0_ = (bitField0_ & ~0x00000001);
            charactersToIgnoreBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCharactersToIgnoreFieldBuilder()
                    : null;
          } else {
            charactersToIgnoreBuilder_.addAllMessages(other.charactersToIgnore_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                maskingCharacter_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                numberToMask_ = input.readInt32();

                break;
              } // case 16
            case 24:
              {
                reverseOrder_ = input.readBool();

                break;
              } // case 24
            case 34:
              {
                com.google.privacy.dlp.v2.CharsToIgnore m =
                    input.readMessage(
                        com.google.privacy.dlp.v2.CharsToIgnore.parser(), extensionRegistry);
                if (charactersToIgnoreBuilder_ == null) {
                  ensureCharactersToIgnoreIsMutable();
                  charactersToIgnore_.add(m);
                } else {
                  charactersToIgnoreBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object maskingCharacter_ = "";
    /**
     *
     *
     * <pre>
     * Character to use to mask the sensitive values&amp;mdash;for example, `*` for an
     * alphabetic string such as a name, or `0` for a numeric string such as ZIP
     * code or credit card number. This string must have a length of 1. If not
     * supplied, this value defaults to `*` for strings, and `0` for digits.
     * </pre>
     *
     * <code>string masking_character = 1;</code>
     *
     * @return The maskingCharacter.
     */
    public java.lang.String getMaskingCharacter() {
      java.lang.Object ref = maskingCharacter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        maskingCharacter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Character to use to mask the sensitive values&amp;mdash;for example, `*` for an
     * alphabetic string such as a name, or `0` for a numeric string such as ZIP
     * code or credit card number. This string must have a length of 1. If not
     * supplied, this value defaults to `*` for strings, and `0` for digits.
     * </pre>
     *
     * <code>string masking_character = 1;</code>
     *
     * @return The bytes for maskingCharacter.
     */
    public com.google.protobuf.ByteString getMaskingCharacterBytes() {
      java.lang.Object ref = maskingCharacter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        maskingCharacter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Character to use to mask the sensitive values&amp;mdash;for example, `*` for an
     * alphabetic string such as a name, or `0` for a numeric string such as ZIP
     * code or credit card number. This string must have a length of 1. If not
     * supplied, this value defaults to `*` for strings, and `0` for digits.
     * </pre>
     *
     * <code>string masking_character = 1;</code>
     *
     * @param value The maskingCharacter to set.
     * @return This builder for chaining.
     */
    public Builder setMaskingCharacter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      maskingCharacter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Character to use to mask the sensitive values&amp;mdash;for example, `*` for an
     * alphabetic string such as a name, or `0` for a numeric string such as ZIP
     * code or credit card number. This string must have a length of 1. If not
     * supplied, this value defaults to `*` for strings, and `0` for digits.
     * </pre>
     *
     * <code>string masking_character = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaskingCharacter() {

      maskingCharacter_ = getDefaultInstance().getMaskingCharacter();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Character to use to mask the sensitive values&amp;mdash;for example, `*` for an
     * alphabetic string such as a name, or `0` for a numeric string such as ZIP
     * code or credit card number. This string must have a length of 1. If not
     * supplied, this value defaults to `*` for strings, and `0` for digits.
     * </pre>
     *
     * <code>string masking_character = 1;</code>
     *
     * @param value The bytes for maskingCharacter to set.
     * @return This builder for chaining.
     */
    public Builder setMaskingCharacterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      maskingCharacter_ = value;
      onChanged();
      return this;
    }

    private int numberToMask_;
    /**
     *
     *
     * <pre>
     * Number of characters to mask. If not set, all matching chars will be
     * masked. Skipped characters do not count towards this tally.
     * If `number_to_mask` is negative, this denotes inverse masking. Cloud DLP
     * masks all but a number of characters.
     * For example, suppose you have the following values:
     * - `masking_character` is `*`
     * - `number_to_mask` is `-4`
     * - `reverse_order` is `false`
     * - `CharsToIgnore` includes `-`
     * - Input string is `1234-5678-9012-3456`
     * The resulting de-identified string is
     * `****-****-****-3456`. Cloud DLP masks all but the last four characters.
     * If `reverse_order` is `true`, all but the first four characters are masked
     * as `1234-****-****-****`.
     * </pre>
     *
     * <code>int32 number_to_mask = 2;</code>
     *
     * @return The numberToMask.
     */
    @java.lang.Override
    public int getNumberToMask() {
      return numberToMask_;
    }
    /**
     *
     *
     * <pre>
     * Number of characters to mask. If not set, all matching chars will be
     * masked. Skipped characters do not count towards this tally.
     * If `number_to_mask` is negative, this denotes inverse masking. Cloud DLP
     * masks all but a number of characters.
     * For example, suppose you have the following values:
     * - `masking_character` is `*`
     * - `number_to_mask` is `-4`
     * - `reverse_order` is `false`
     * - `CharsToIgnore` includes `-`
     * - Input string is `1234-5678-9012-3456`
     * The resulting de-identified string is
     * `****-****-****-3456`. Cloud DLP masks all but the last four characters.
     * If `reverse_order` is `true`, all but the first four characters are masked
     * as `1234-****-****-****`.
     * </pre>
     *
     * <code>int32 number_to_mask = 2;</code>
     *
     * @param value The numberToMask to set.
     * @return This builder for chaining.
     */
    public Builder setNumberToMask(int value) {

      numberToMask_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of characters to mask. If not set, all matching chars will be
     * masked. Skipped characters do not count towards this tally.
     * If `number_to_mask` is negative, this denotes inverse masking. Cloud DLP
     * masks all but a number of characters.
     * For example, suppose you have the following values:
     * - `masking_character` is `*`
     * - `number_to_mask` is `-4`
     * - `reverse_order` is `false`
     * - `CharsToIgnore` includes `-`
     * - Input string is `1234-5678-9012-3456`
     * The resulting de-identified string is
     * `****-****-****-3456`. Cloud DLP masks all but the last four characters.
     * If `reverse_order` is `true`, all but the first four characters are masked
     * as `1234-****-****-****`.
     * </pre>
     *
     * <code>int32 number_to_mask = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNumberToMask() {

      numberToMask_ = 0;
      onChanged();
      return this;
    }

    private boolean reverseOrder_;
    /**
     *
     *
     * <pre>
     * Mask characters in reverse order. For example, if `masking_character` is
     * `0`, `number_to_mask` is `14`, and `reverse_order` is `false`, then the
     * input string `1234-5678-9012-3456` is masked as `00000000000000-3456`.
     * If `masking_character` is `*`, `number_to_mask` is `3`, and `reverse_order`
     * is `true`, then the string `12345` is masked as `12***`.
     * </pre>
     *
     * <code>bool reverse_order = 3;</code>
     *
     * @return The reverseOrder.
     */
    @java.lang.Override
    public boolean getReverseOrder() {
      return reverseOrder_;
    }
    /**
     *
     *
     * <pre>
     * Mask characters in reverse order. For example, if `masking_character` is
     * `0`, `number_to_mask` is `14`, and `reverse_order` is `false`, then the
     * input string `1234-5678-9012-3456` is masked as `00000000000000-3456`.
     * If `masking_character` is `*`, `number_to_mask` is `3`, and `reverse_order`
     * is `true`, then the string `12345` is masked as `12***`.
     * </pre>
     *
     * <code>bool reverse_order = 3;</code>
     *
     * @param value The reverseOrder to set.
     * @return This builder for chaining.
     */
    public Builder setReverseOrder(boolean value) {

      reverseOrder_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask characters in reverse order. For example, if `masking_character` is
     * `0`, `number_to_mask` is `14`, and `reverse_order` is `false`, then the
     * input string `1234-5678-9012-3456` is masked as `00000000000000-3456`.
     * If `masking_character` is `*`, `number_to_mask` is `3`, and `reverse_order`
     * is `true`, then the string `12345` is masked as `12***`.
     * </pre>
     *
     * <code>bool reverse_order = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReverseOrder() {

      reverseOrder_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.privacy.dlp.v2.CharsToIgnore> charactersToIgnore_ =
        java.util.Collections.emptyList();

    private void ensureCharactersToIgnoreIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        charactersToIgnore_ =
            new java.util.ArrayList<com.google.privacy.dlp.v2.CharsToIgnore>(charactersToIgnore_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.CharsToIgnore,
            com.google.privacy.dlp.v2.CharsToIgnore.Builder,
            com.google.privacy.dlp.v2.CharsToIgnoreOrBuilder>
        charactersToIgnoreBuilder_;

    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.CharsToIgnore> getCharactersToIgnoreList() {
      if (charactersToIgnoreBuilder_ == null) {
        return java.util.Collections.unmodifiableList(charactersToIgnore_);
      } else {
        return charactersToIgnoreBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public int getCharactersToIgnoreCount() {
      if (charactersToIgnoreBuilder_ == null) {
        return charactersToIgnore_.size();
      } else {
        return charactersToIgnoreBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public com.google.privacy.dlp.v2.CharsToIgnore getCharactersToIgnore(int index) {
      if (charactersToIgnoreBuilder_ == null) {
        return charactersToIgnore_.get(index);
      } else {
        return charactersToIgnoreBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public Builder setCharactersToIgnore(int index, com.google.privacy.dlp.v2.CharsToIgnore value) {
      if (charactersToIgnoreBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCharactersToIgnoreIsMutable();
        charactersToIgnore_.set(index, value);
        onChanged();
      } else {
        charactersToIgnoreBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public Builder setCharactersToIgnore(
        int index, com.google.privacy.dlp.v2.CharsToIgnore.Builder builderForValue) {
      if (charactersToIgnoreBuilder_ == null) {
        ensureCharactersToIgnoreIsMutable();
        charactersToIgnore_.set(index, builderForValue.build());
        onChanged();
      } else {
        charactersToIgnoreBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public Builder addCharactersToIgnore(com.google.privacy.dlp.v2.CharsToIgnore value) {
      if (charactersToIgnoreBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCharactersToIgnoreIsMutable();
        charactersToIgnore_.add(value);
        onChanged();
      } else {
        charactersToIgnoreBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public Builder addCharactersToIgnore(int index, com.google.privacy.dlp.v2.CharsToIgnore value) {
      if (charactersToIgnoreBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCharactersToIgnoreIsMutable();
        charactersToIgnore_.add(index, value);
        onChanged();
      } else {
        charactersToIgnoreBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public Builder addCharactersToIgnore(
        com.google.privacy.dlp.v2.CharsToIgnore.Builder builderForValue) {
      if (charactersToIgnoreBuilder_ == null) {
        ensureCharactersToIgnoreIsMutable();
        charactersToIgnore_.add(builderForValue.build());
        onChanged();
      } else {
        charactersToIgnoreBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public Builder addCharactersToIgnore(
        int index, com.google.privacy.dlp.v2.CharsToIgnore.Builder builderForValue) {
      if (charactersToIgnoreBuilder_ == null) {
        ensureCharactersToIgnoreIsMutable();
        charactersToIgnore_.add(index, builderForValue.build());
        onChanged();
      } else {
        charactersToIgnoreBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public Builder addAllCharactersToIgnore(
        java.lang.Iterable<? extends com.google.privacy.dlp.v2.CharsToIgnore> values) {
      if (charactersToIgnoreBuilder_ == null) {
        ensureCharactersToIgnoreIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, charactersToIgnore_);
        onChanged();
      } else {
        charactersToIgnoreBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public Builder clearCharactersToIgnore() {
      if (charactersToIgnoreBuilder_ == null) {
        charactersToIgnore_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        charactersToIgnoreBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public Builder removeCharactersToIgnore(int index) {
      if (charactersToIgnoreBuilder_ == null) {
        ensureCharactersToIgnoreIsMutable();
        charactersToIgnore_.remove(index);
        onChanged();
      } else {
        charactersToIgnoreBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public com.google.privacy.dlp.v2.CharsToIgnore.Builder getCharactersToIgnoreBuilder(int index) {
      return getCharactersToIgnoreFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public com.google.privacy.dlp.v2.CharsToIgnoreOrBuilder getCharactersToIgnoreOrBuilder(
        int index) {
      if (charactersToIgnoreBuilder_ == null) {
        return charactersToIgnore_.get(index);
      } else {
        return charactersToIgnoreBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public java.util.List<? extends com.google.privacy.dlp.v2.CharsToIgnoreOrBuilder>
        getCharactersToIgnoreOrBuilderList() {
      if (charactersToIgnoreBuilder_ != null) {
        return charactersToIgnoreBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(charactersToIgnore_);
      }
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public com.google.privacy.dlp.v2.CharsToIgnore.Builder addCharactersToIgnoreBuilder() {
      return getCharactersToIgnoreFieldBuilder()
          .addBuilder(com.google.privacy.dlp.v2.CharsToIgnore.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public com.google.privacy.dlp.v2.CharsToIgnore.Builder addCharactersToIgnoreBuilder(int index) {
      return getCharactersToIgnoreFieldBuilder()
          .addBuilder(index, com.google.privacy.dlp.v2.CharsToIgnore.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * When masking a string, items in this list will be skipped when replacing
     * characters. For example, if the input string is `555-555-5555` and you
     * instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
     * returns `***-**5-5555`.
     * </pre>
     *
     * <code>repeated .google.privacy.dlp.v2.CharsToIgnore characters_to_ignore = 4;</code>
     */
    public java.util.List<com.google.privacy.dlp.v2.CharsToIgnore.Builder>
        getCharactersToIgnoreBuilderList() {
      return getCharactersToIgnoreFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.privacy.dlp.v2.CharsToIgnore,
            com.google.privacy.dlp.v2.CharsToIgnore.Builder,
            com.google.privacy.dlp.v2.CharsToIgnoreOrBuilder>
        getCharactersToIgnoreFieldBuilder() {
      if (charactersToIgnoreBuilder_ == null) {
        charactersToIgnoreBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.privacy.dlp.v2.CharsToIgnore,
                com.google.privacy.dlp.v2.CharsToIgnore.Builder,
                com.google.privacy.dlp.v2.CharsToIgnoreOrBuilder>(
                charactersToIgnore_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        charactersToIgnore_ = null;
      }
      return charactersToIgnoreBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.privacy.dlp.v2.CharacterMaskConfig)
  }

  // @@protoc_insertion_point(class_scope:google.privacy.dlp.v2.CharacterMaskConfig)
  private static final com.google.privacy.dlp.v2.CharacterMaskConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.privacy.dlp.v2.CharacterMaskConfig();
  }

  public static com.google.privacy.dlp.v2.CharacterMaskConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CharacterMaskConfig> PARSER =
      new com.google.protobuf.AbstractParser<CharacterMaskConfig>() {
        @java.lang.Override
        public CharacterMaskConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CharacterMaskConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CharacterMaskConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.privacy.dlp.v2.CharacterMaskConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
