/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/webhook.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Webhooks host the developer's business logic. During a session, webhooks
 * allow the developer to use the data extracted by Dialogflow's natural
 * language processing to generate dynamic responses, validate collected data,
 * or trigger actions on the backend.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Webhook}
 */
public final class Webhook extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Webhook)
    WebhookOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Webhook.newBuilder() to construct.
  private Webhook(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Webhook() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Webhook();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.class,
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.Builder.class);
  }

  public interface GenericWebServiceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The webhook URI for receiving POST requests. It must use https
     * protocol.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * Required. The webhook URI for receiving POST requests. It must use https
     * protocol.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * The user name for HTTP Basic authentication.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.username is
     *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=147
     * @return The username.
     */
    @java.lang.Deprecated
    java.lang.String getUsername();
    /**
     *
     *
     * <pre>
     * The user name for HTTP Basic authentication.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.username is
     *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=147
     * @return The bytes for username.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getUsernameBytes();

    /**
     *
     *
     * <pre>
     * The password for HTTP Basic authentication.
     * </pre>
     *
     * <code>string password = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.password is
     *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=150
     * @return The password.
     */
    @java.lang.Deprecated
    java.lang.String getPassword();
    /**
     *
     *
     * <pre>
     * The password for HTTP Basic authentication.
     * </pre>
     *
     * <code>string password = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.password is
     *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=150
     * @return The bytes for password.
     */
    @java.lang.Deprecated
    com.google.protobuf.ByteString getPasswordBytes();

    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    int getRequestHeadersCount();
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    boolean containsRequestHeaders(java.lang.String key);
    /** Use {@link #getRequestHeadersMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getRequestHeaders();
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getRequestHeadersMap();
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    /* nullable */
    java.lang.String getRequestHeadersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    java.lang.String getRequestHeadersOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of allowed custom CA certificates (in DER
     * format) for HTTPS verification. This overrides the default SSL trust
     * store. If this is empty or unspecified, Dialogflow will use Google's
     * default trust store to verify certificates. N.B. Make sure the HTTPS
     * server certificates are signed with "subject alt name". For instance a
     * certificate can be self-signed using the following command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr &#92;
     *      -signkey example.com.key &#92;
     *      -out example.com.crt &#92;
     *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
     * ```
     * </pre>
     *
     * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the allowedCaCerts.
     */
    java.util.List<com.google.protobuf.ByteString> getAllowedCaCertsList();
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of allowed custom CA certificates (in DER
     * format) for HTTPS verification. This overrides the default SSL trust
     * store. If this is empty or unspecified, Dialogflow will use Google's
     * default trust store to verify certificates. N.B. Make sure the HTTPS
     * server certificates are signed with "subject alt name". For instance a
     * certificate can be self-signed using the following command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr &#92;
     *      -signkey example.com.key &#92;
     *      -out example.com.crt &#92;
     *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
     * ```
     * </pre>
     *
     * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of allowedCaCerts.
     */
    int getAllowedCaCertsCount();
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of allowed custom CA certificates (in DER
     * format) for HTTPS verification. This overrides the default SSL trust
     * store. If this is empty or unspecified, Dialogflow will use Google's
     * default trust store to verify certificates. N.B. Make sure the HTTPS
     * server certificates are signed with "subject alt name". For instance a
     * certificate can be self-signed using the following command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr &#92;
     *      -signkey example.com.key &#92;
     *      -out example.com.crt &#92;
     *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
     * ```
     * </pre>
     *
     * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The allowedCaCerts at the given index.
     */
    com.google.protobuf.ByteString getAllowedCaCerts(int index);

    /**
     *
     *
     * <pre>
     * Optional. Type of the webhook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType webhook_type = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for webhookType.
     */
    int getWebhookTypeValue();
    /**
     *
     *
     * <pre>
     * Optional. Type of the webhook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType webhook_type = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The webhookType.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType getWebhookType();

    /**
     *
     *
     * <pre>
     * Optional. HTTP method for the flexible webhook calls. Standard webhook
     * always uses POST.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod http_method = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for httpMethod.
     */
    int getHttpMethodValue();
    /**
     *
     *
     * <pre>
     * Optional. HTTP method for the flexible webhook calls. Standard webhook
     * always uses POST.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod http_method = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The httpMethod.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod getHttpMethod();

    /**
     *
     *
     * <pre>
     * Optional. Defines a custom JSON object as request body to send to
     * flexible webhook.
     * </pre>
     *
     * <code>string request_body = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestBody.
     */
    java.lang.String getRequestBody();
    /**
     *
     *
     * <pre>
     * Optional. Defines a custom JSON object as request body to send to
     * flexible webhook.
     * </pre>
     *
     * <code>string request_body = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestBody.
     */
    com.google.protobuf.ByteString getRequestBodyBytes();

    /**
     *
     *
     * <pre>
     * Optional. Maps the values extracted from specific fields of the flexible
     * webhook response into session parameters.
     * - Key: session parameter name
     * - Value: field path in the webhook response
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getParameterMappingCount();
    /**
     *
     *
     * <pre>
     * Optional. Maps the values extracted from specific fields of the flexible
     * webhook response into session parameters.
     * - Key: session parameter name
     * - Value: field path in the webhook response
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    boolean containsParameterMapping(java.lang.String key);
    /** Use {@link #getParameterMappingMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getParameterMapping();
    /**
     *
     *
     * <pre>
     * Optional. Maps the values extracted from specific fields of the flexible
     * webhook response into session parameters.
     * - Key: session parameter name
     * - Value: field path in the webhook response
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.Map<java.lang.String, java.lang.String> getParameterMappingMap();
    /**
     *
     *
     * <pre>
     * Optional. Maps the values extracted from specific fields of the flexible
     * webhook response into session parameters.
     * - Key: session parameter name
     * - Value: field path in the webhook response
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    /* nullable */
    java.lang.String getParameterMappingOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * Optional. Maps the values extracted from specific fields of the flexible
     * webhook response into session parameters.
     * - Key: session parameter name
     * - Value: field path in the webhook response
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.lang.String getParameterMappingOrThrow(java.lang.String key);
  }
  /**
   *
   *
   * <pre>
   * Represents configuration for a generic web service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService}
   */
  public static final class GenericWebService extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService)
      GenericWebServiceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GenericWebService.newBuilder() to construct.
    private GenericWebService(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GenericWebService() {
      uri_ = "";
      username_ = "";
      password_ = "";
      allowedCaCerts_ = java.util.Collections.emptyList();
      webhookType_ = 0;
      httpMethod_ = 0;
      requestBody_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GenericWebService();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_GenericWebService_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetRequestHeaders();
        case 9:
          return internalGetParameterMapping();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_GenericWebService_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.class,
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Represents the type of webhook configuration.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType}
     */
    public enum WebhookType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>WEBHOOK_TYPE_UNSPECIFIED = 0;</code>
       */
      WEBHOOK_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Represents a standard webhook.
       * </pre>
       *
       * <code>STANDARD = 1;</code>
       */
      STANDARD(1),
      /**
       *
       *
       * <pre>
       * Represents a flexible webhook.
       * </pre>
       *
       * <code>FLEXIBLE = 2;</code>
       */
      FLEXIBLE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>WEBHOOK_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int WEBHOOK_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Represents a standard webhook.
       * </pre>
       *
       * <code>STANDARD = 1;</code>
       */
      public static final int STANDARD_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Represents a flexible webhook.
       * </pre>
       *
       * <code>FLEXIBLE = 2;</code>
       */
      public static final int FLEXIBLE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static WebhookType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static WebhookType forNumber(int value) {
        switch (value) {
          case 0:
            return WEBHOOK_TYPE_UNSPECIFIED;
          case 1:
            return STANDARD;
          case 2:
            return FLEXIBLE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<WebhookType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<WebhookType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<WebhookType>() {
            public WebhookType findValueByNumber(int number) {
              return WebhookType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final WebhookType[] VALUES = values();

      public static WebhookType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private WebhookType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType)
    }

    /**
     *
     *
     * <pre>
     * HTTP method to use when calling webhooks.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod}
     */
    public enum HttpMethod implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * HTTP method not specified.
       * </pre>
       *
       * <code>HTTP_METHOD_UNSPECIFIED = 0;</code>
       */
      HTTP_METHOD_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * HTTP POST Method.
       * </pre>
       *
       * <code>POST = 1;</code>
       */
      POST(1),
      /**
       *
       *
       * <pre>
       * HTTP GET Method.
       * </pre>
       *
       * <code>GET = 2;</code>
       */
      GET(2),
      /**
       *
       *
       * <pre>
       * HTTP HEAD Method.
       * </pre>
       *
       * <code>HEAD = 3;</code>
       */
      HEAD(3),
      /**
       *
       *
       * <pre>
       * HTTP PUT Method.
       * </pre>
       *
       * <code>PUT = 4;</code>
       */
      PUT(4),
      /**
       *
       *
       * <pre>
       * HTTP DELETE Method.
       * </pre>
       *
       * <code>DELETE = 5;</code>
       */
      DELETE(5),
      /**
       *
       *
       * <pre>
       * HTTP PATCH Method.
       * </pre>
       *
       * <code>PATCH = 6;</code>
       */
      PATCH(6),
      /**
       *
       *
       * <pre>
       * HTTP OPTIONS Method.
       * </pre>
       *
       * <code>OPTIONS = 7;</code>
       */
      OPTIONS(7),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * HTTP method not specified.
       * </pre>
       *
       * <code>HTTP_METHOD_UNSPECIFIED = 0;</code>
       */
      public static final int HTTP_METHOD_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * HTTP POST Method.
       * </pre>
       *
       * <code>POST = 1;</code>
       */
      public static final int POST_VALUE = 1;
      /**
       *
       *
       * <pre>
       * HTTP GET Method.
       * </pre>
       *
       * <code>GET = 2;</code>
       */
      public static final int GET_VALUE = 2;
      /**
       *
       *
       * <pre>
       * HTTP HEAD Method.
       * </pre>
       *
       * <code>HEAD = 3;</code>
       */
      public static final int HEAD_VALUE = 3;
      /**
       *
       *
       * <pre>
       * HTTP PUT Method.
       * </pre>
       *
       * <code>PUT = 4;</code>
       */
      public static final int PUT_VALUE = 4;
      /**
       *
       *
       * <pre>
       * HTTP DELETE Method.
       * </pre>
       *
       * <code>DELETE = 5;</code>
       */
      public static final int DELETE_VALUE = 5;
      /**
       *
       *
       * <pre>
       * HTTP PATCH Method.
       * </pre>
       *
       * <code>PATCH = 6;</code>
       */
      public static final int PATCH_VALUE = 6;
      /**
       *
       *
       * <pre>
       * HTTP OPTIONS Method.
       * </pre>
       *
       * <code>OPTIONS = 7;</code>
       */
      public static final int OPTIONS_VALUE = 7;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static HttpMethod valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static HttpMethod forNumber(int value) {
        switch (value) {
          case 0:
            return HTTP_METHOD_UNSPECIFIED;
          case 1:
            return POST;
          case 2:
            return GET;
          case 3:
            return HEAD;
          case 4:
            return PUT;
          case 5:
            return DELETE;
          case 6:
            return PATCH;
          case 7:
            return OPTIONS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<HttpMethod> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<HttpMethod> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<HttpMethod>() {
            public HttpMethod findValueByNumber(int number) {
              return HttpMethod.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final HttpMethod[] VALUES = values();

      public static HttpMethod valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private HttpMethod(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod)
    }

    public static final int URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The webhook URI for receiving POST requests. It must use https
     * protocol.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The webhook URI for receiving POST requests. It must use https
     * protocol.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int USERNAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object username_ = "";
    /**
     *
     *
     * <pre>
     * The user name for HTTP Basic authentication.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.username is
     *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=147
     * @return The username.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.lang.String getUsername() {
      java.lang.Object ref = username_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        username_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The user name for HTTP Basic authentication.
     * </pre>
     *
     * <code>string username = 2 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.username is
     *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=147
     * @return The bytes for username.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getUsernameBytes() {
      java.lang.Object ref = username_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        username_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PASSWORD_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object password_ = "";
    /**
     *
     *
     * <pre>
     * The password for HTTP Basic authentication.
     * </pre>
     *
     * <code>string password = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.password is
     *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=150
     * @return The password.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.lang.String getPassword() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        password_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The password for HTTP Basic authentication.
     * </pre>
     *
     * <code>string password = 3 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.password is
     *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=150
     * @return The bytes for password.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getPasswordBytes() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        password_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REQUEST_HEADERS_FIELD_NUMBER = 4;

    private static final class RequestHeadersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
                  .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_GenericWebService_RequestHeadersEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> requestHeaders_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetRequestHeaders() {
      if (requestHeaders_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            RequestHeadersDefaultEntryHolder.defaultEntry);
      }
      return requestHeaders_;
    }

    public int getRequestHeadersCount() {
      return internalGetRequestHeaders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    @java.lang.Override
    public boolean containsRequestHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetRequestHeaders().getMap().containsKey(key);
    }
    /** Use {@link #getRequestHeadersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getRequestHeaders() {
      return getRequestHeadersMap();
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getRequestHeadersMap() {
      return internalGetRequestHeaders().getMap();
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getRequestHeadersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetRequestHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with webhook
     * requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getRequestHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetRequestHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int ALLOWED_CA_CERTS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<com.google.protobuf.ByteString> allowedCaCerts_;
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of allowed custom CA certificates (in DER
     * format) for HTTPS verification. This overrides the default SSL trust
     * store. If this is empty or unspecified, Dialogflow will use Google's
     * default trust store to verify certificates. N.B. Make sure the HTTPS
     * server certificates are signed with "subject alt name". For instance a
     * certificate can be self-signed using the following command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr &#92;
     *      -signkey example.com.key &#92;
     *      -out example.com.crt &#92;
     *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
     * ```
     * </pre>
     *
     * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the allowedCaCerts.
     */
    @java.lang.Override
    public java.util.List<com.google.protobuf.ByteString> getAllowedCaCertsList() {
      return allowedCaCerts_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of allowed custom CA certificates (in DER
     * format) for HTTPS verification. This overrides the default SSL trust
     * store. If this is empty or unspecified, Dialogflow will use Google's
     * default trust store to verify certificates. N.B. Make sure the HTTPS
     * server certificates are signed with "subject alt name". For instance a
     * certificate can be self-signed using the following command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr &#92;
     *      -signkey example.com.key &#92;
     *      -out example.com.crt &#92;
     *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
     * ```
     * </pre>
     *
     * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of allowedCaCerts.
     */
    public int getAllowedCaCertsCount() {
      return allowedCaCerts_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies a list of allowed custom CA certificates (in DER
     * format) for HTTPS verification. This overrides the default SSL trust
     * store. If this is empty or unspecified, Dialogflow will use Google's
     * default trust store to verify certificates. N.B. Make sure the HTTPS
     * server certificates are signed with "subject alt name". For instance a
     * certificate can be self-signed using the following command,
     * ```
     *    openssl x509 -req -days 200 -in example.com.csr &#92;
     *      -signkey example.com.key &#92;
     *      -out example.com.crt &#92;
     *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
     * ```
     * </pre>
     *
     * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The allowedCaCerts at the given index.
     */
    public com.google.protobuf.ByteString getAllowedCaCerts(int index) {
      return allowedCaCerts_.get(index);
    }

    public static final int WEBHOOK_TYPE_FIELD_NUMBER = 6;
    private int webhookType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Type of the webhook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType webhook_type = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for webhookType.
     */
    @java.lang.Override
    public int getWebhookTypeValue() {
      return webhookType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of the webhook.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType webhook_type = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The webhookType.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType
        getWebhookType() {
      com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType result =
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType.forNumber(
              webhookType_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType
              .UNRECOGNIZED
          : result;
    }

    public static final int HTTP_METHOD_FIELD_NUMBER = 7;
    private int httpMethod_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. HTTP method for the flexible webhook calls. Standard webhook
     * always uses POST.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod http_method = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for httpMethod.
     */
    @java.lang.Override
    public int getHttpMethodValue() {
      return httpMethod_;
    }
    /**
     *
     *
     * <pre>
     * Optional. HTTP method for the flexible webhook calls. Standard webhook
     * always uses POST.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod http_method = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The httpMethod.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod
        getHttpMethod() {
      com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod result =
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod.forNumber(
              httpMethod_);
      return result == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod.UNRECOGNIZED
          : result;
    }

    public static final int REQUEST_BODY_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private volatile java.lang.Object requestBody_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Defines a custom JSON object as request body to send to
     * flexible webhook.
     * </pre>
     *
     * <code>string request_body = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestBody.
     */
    @java.lang.Override
    public java.lang.String getRequestBody() {
      java.lang.Object ref = requestBody_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestBody_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines a custom JSON object as request body to send to
     * flexible webhook.
     * </pre>
     *
     * <code>string request_body = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestBody.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRequestBodyBytes() {
      java.lang.Object ref = requestBody_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestBody_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARAMETER_MAPPING_FIELD_NUMBER = 9;

    private static final class ParameterMappingDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
                  .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_GenericWebService_ParameterMappingEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> parameterMapping_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetParameterMapping() {
      if (parameterMapping_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ParameterMappingDefaultEntryHolder.defaultEntry);
      }
      return parameterMapping_;
    }

    public int getParameterMappingCount() {
      return internalGetParameterMapping().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Maps the values extracted from specific fields of the flexible
     * webhook response into session parameters.
     * - Key: session parameter name
     * - Value: field path in the webhook response
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsParameterMapping(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetParameterMapping().getMap().containsKey(key);
    }
    /** Use {@link #getParameterMappingMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getParameterMapping() {
      return getParameterMappingMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Maps the values extracted from specific fields of the flexible
     * webhook response into session parameters.
     * - Key: session parameter name
     * - Value: field path in the webhook response
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getParameterMappingMap() {
      return internalGetParameterMapping().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Maps the values extracted from specific fields of the flexible
     * webhook response into session parameters.
     * - Key: session parameter name
     * - Value: field path in the webhook response
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getParameterMappingOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetParameterMapping().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maps the values extracted from specific fields of the flexible
     * webhook response into session parameters.
     * - Key: session parameter name
     * - Value: field path in the webhook response
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getParameterMappingOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetParameterMapping().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, username_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, password_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetRequestHeaders(), RequestHeadersDefaultEntryHolder.defaultEntry, 4);
      for (int i = 0; i < allowedCaCerts_.size(); i++) {
        output.writeBytes(5, allowedCaCerts_.get(i));
      }
      if (webhookType_
          != com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType
              .WEBHOOK_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(6, webhookType_);
      }
      if (httpMethod_
          != com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod
              .HTTP_METHOD_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(7, httpMethod_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestBody_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, requestBody_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetParameterMapping(),
          ParameterMappingDefaultEntryHolder.defaultEntry,
          9);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, username_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, password_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetRequestHeaders().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> requestHeaders__ =
            RequestHeadersDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, requestHeaders__);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < allowedCaCerts_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeBytesSizeNoTag(allowedCaCerts_.get(i));
        }
        size += dataSize;
        size += 1 * getAllowedCaCertsList().size();
      }
      if (webhookType_
          != com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType
              .WEBHOOK_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, webhookType_);
      }
      if (httpMethod_
          != com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod
              .HTTP_METHOD_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, httpMethod_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestBody_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, requestBody_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetParameterMapping().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> parameterMapping__ =
            ParameterMappingDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, parameterMapping__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService other =
          (com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService) obj;

      if (!getUri().equals(other.getUri())) return false;
      if (!getUsername().equals(other.getUsername())) return false;
      if (!getPassword().equals(other.getPassword())) return false;
      if (!internalGetRequestHeaders().equals(other.internalGetRequestHeaders())) return false;
      if (!getAllowedCaCertsList().equals(other.getAllowedCaCertsList())) return false;
      if (webhookType_ != other.webhookType_) return false;
      if (httpMethod_ != other.httpMethod_) return false;
      if (!getRequestBody().equals(other.getRequestBody())) return false;
      if (!internalGetParameterMapping().equals(other.internalGetParameterMapping())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      hash = (37 * hash) + USERNAME_FIELD_NUMBER;
      hash = (53 * hash) + getUsername().hashCode();
      hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
      hash = (53 * hash) + getPassword().hashCode();
      if (!internalGetRequestHeaders().getMap().isEmpty()) {
        hash = (37 * hash) + REQUEST_HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetRequestHeaders().hashCode();
      }
      if (getAllowedCaCertsCount() > 0) {
        hash = (37 * hash) + ALLOWED_CA_CERTS_FIELD_NUMBER;
        hash = (53 * hash) + getAllowedCaCertsList().hashCode();
      }
      hash = (37 * hash) + WEBHOOK_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + webhookType_;
      hash = (37 * hash) + HTTP_METHOD_FIELD_NUMBER;
      hash = (53 * hash) + httpMethod_;
      hash = (37 * hash) + REQUEST_BODY_FIELD_NUMBER;
      hash = (53 * hash) + getRequestBody().hashCode();
      if (!internalGetParameterMapping().getMap().isEmpty()) {
        hash = (37 * hash) + PARAMETER_MAPPING_FIELD_NUMBER;
        hash = (53 * hash) + internalGetParameterMapping().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents configuration for a generic web service.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService)
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebServiceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_GenericWebService_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 4:
            return internalGetRequestHeaders();
          case 9:
            return internalGetParameterMapping();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 4:
            return internalGetMutableRequestHeaders();
          case 9:
            return internalGetMutableParameterMapping();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_GenericWebService_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.class,
                com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        uri_ = "";
        username_ = "";
        password_ = "";
        internalGetMutableRequestHeaders().clear();
        allowedCaCerts_ = java.util.Collections.emptyList();
        webhookType_ = 0;
        httpMethod_ = 0;
        requestBody_ = "";
        internalGetMutableParameterMapping().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_GenericWebService_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService build() {
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService result =
            new com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService result) {
        if (((bitField0_ & 0x00000010) != 0)) {
          allowedCaCerts_ = java.util.Collections.unmodifiableList(allowedCaCerts_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.allowedCaCerts_ = allowedCaCerts_;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.uri_ = uri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.username_ = username_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.password_ = password_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.requestHeaders_ = internalGetRequestHeaders();
          result.requestHeaders_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.webhookType_ = webhookType_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.httpMethod_ = httpMethod_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.requestBody_ = requestBody_;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.parameterMapping_ = internalGetParameterMapping();
          result.parameterMapping_.makeImmutable();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
                .getDefaultInstance()) return this;
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getUsername().isEmpty()) {
          username_ = other.username_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getPassword().isEmpty()) {
          password_ = other.password_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        internalGetMutableRequestHeaders().mergeFrom(other.internalGetRequestHeaders());
        bitField0_ |= 0x00000008;
        if (!other.allowedCaCerts_.isEmpty()) {
          if (allowedCaCerts_.isEmpty()) {
            allowedCaCerts_ = other.allowedCaCerts_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureAllowedCaCertsIsMutable();
            allowedCaCerts_.addAll(other.allowedCaCerts_);
          }
          onChanged();
        }
        if (other.webhookType_ != 0) {
          setWebhookTypeValue(other.getWebhookTypeValue());
        }
        if (other.httpMethod_ != 0) {
          setHttpMethodValue(other.getHttpMethodValue());
        }
        if (!other.getRequestBody().isEmpty()) {
          requestBody_ = other.requestBody_;
          bitField0_ |= 0x00000080;
          onChanged();
        }
        internalGetMutableParameterMapping().mergeFrom(other.internalGetParameterMapping());
        bitField0_ |= 0x00000100;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  uri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  username_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  password_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                      requestHeaders__ =
                          input.readMessage(
                              RequestHeadersDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableRequestHeaders()
                      .getMutableMap()
                      .put(requestHeaders__.getKey(), requestHeaders__.getValue());
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  com.google.protobuf.ByteString v = input.readBytes();
                  ensureAllowedCaCertsIsMutable();
                  allowedCaCerts_.add(v);
                  break;
                } // case 42
              case 48:
                {
                  webhookType_ = input.readEnum();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 48
              case 56:
                {
                  httpMethod_ = input.readEnum();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 56
              case 66:
                {
                  requestBody_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 66
              case 74:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                      parameterMapping__ =
                          input.readMessage(
                              ParameterMappingDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableParameterMapping()
                      .getMutableMap()
                      .put(parameterMapping__.getKey(), parameterMapping__.getValue());
                  bitField0_ |= 0x00000100;
                  break;
                } // case 74
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * Required. The webhook URI for receiving POST requests. It must use https
       * protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The webhook URI for receiving POST requests. It must use https
       * protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The webhook URI for receiving POST requests. It must use https
       * protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        uri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The webhook URI for receiving POST requests. It must use https
       * protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {
        uri_ = getDefaultInstance().getUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The webhook URI for receiving POST requests. It must use https
       * protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        uri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object username_ = "";
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.username is
       *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=147
       * @return The username.
       */
      @java.lang.Deprecated
      public java.lang.String getUsername() {
        java.lang.Object ref = username_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          username_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.username is
       *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=147
       * @return The bytes for username.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getUsernameBytes() {
        java.lang.Object ref = username_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          username_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.username is
       *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=147
       * @param value The username to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setUsername(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        username_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.username is
       *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=147
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearUsername() {
        username_ = getDefaultInstance().getUsername();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.username is
       *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=147
       * @param value The bytes for username to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        username_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object password_ = "";
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.password is
       *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=150
       * @return The password.
       */
      @java.lang.Deprecated
      public java.lang.String getPassword() {
        java.lang.Object ref = password_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          password_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.password is
       *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=150
       * @return The bytes for password.
       */
      @java.lang.Deprecated
      public com.google.protobuf.ByteString getPasswordBytes() {
        java.lang.Object ref = password_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          password_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.password is
       *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=150
       * @param value The password to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setPassword(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        password_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.password is
       *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=150
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearPassword() {
        password_ = getDefaultInstance().getPassword();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3 [deprecated = true];</code>
       *
       * @deprecated google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.password is
       *     deprecated. See google/cloud/dialogflow/cx/v3beta1/webhook.proto;l=150
       * @param value The bytes for password to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        password_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> requestHeaders_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetRequestHeaders() {
        if (requestHeaders_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              RequestHeadersDefaultEntryHolder.defaultEntry);
        }
        return requestHeaders_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableRequestHeaders() {
        if (requestHeaders_ == null) {
          requestHeaders_ =
              com.google.protobuf.MapField.newMapField(
                  RequestHeadersDefaultEntryHolder.defaultEntry);
        }
        if (!requestHeaders_.isMutable()) {
          requestHeaders_ = requestHeaders_.copy();
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return requestHeaders_;
      }

      public int getRequestHeadersCount() {
        return internalGetRequestHeaders().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      @java.lang.Override
      public boolean containsRequestHeaders(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetRequestHeaders().getMap().containsKey(key);
      }
      /** Use {@link #getRequestHeadersMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getRequestHeaders() {
        return getRequestHeadersMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getRequestHeadersMap() {
        return internalGetRequestHeaders().getMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getRequestHeadersOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetRequestHeaders().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      @java.lang.Override
      public java.lang.String getRequestHeadersOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetRequestHeaders().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearRequestHeaders() {
        bitField0_ = (bitField0_ & ~0x00000008);
        internalGetMutableRequestHeaders().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      public Builder removeRequestHeaders(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableRequestHeaders().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableRequestHeaders() {
        bitField0_ |= 0x00000008;
        return internalGetMutableRequestHeaders().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      public Builder putRequestHeaders(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableRequestHeaders().getMutableMap().put(key, value);
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with webhook
       * requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      public Builder putAllRequestHeaders(
          java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableRequestHeaders().getMutableMap().putAll(values);
        bitField0_ |= 0x00000008;
        return this;
      }

      private java.util.List<com.google.protobuf.ByteString> allowedCaCerts_ =
          java.util.Collections.emptyList();

      private void ensureAllowedCaCertsIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          allowedCaCerts_ =
              new java.util.ArrayList<com.google.protobuf.ByteString>(allowedCaCerts_);
          bitField0_ |= 0x00000010;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER
       * format) for HTTPS verification. This overrides the default SSL trust
       * store. If this is empty or unspecified, Dialogflow will use Google's
       * default trust store to verify certificates. N.B. Make sure the HTTPS
       * server certificates are signed with "subject alt name". For instance a
       * certificate can be self-signed using the following command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the allowedCaCerts.
       */
      public java.util.List<com.google.protobuf.ByteString> getAllowedCaCertsList() {
        return ((bitField0_ & 0x00000010) != 0)
            ? java.util.Collections.unmodifiableList(allowedCaCerts_)
            : allowedCaCerts_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER
       * format) for HTTPS verification. This overrides the default SSL trust
       * store. If this is empty or unspecified, Dialogflow will use Google's
       * default trust store to verify certificates. N.B. Make sure the HTTPS
       * server certificates are signed with "subject alt name". For instance a
       * certificate can be self-signed using the following command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of allowedCaCerts.
       */
      public int getAllowedCaCertsCount() {
        return allowedCaCerts_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER
       * format) for HTTPS verification. This overrides the default SSL trust
       * store. If this is empty or unspecified, Dialogflow will use Google's
       * default trust store to verify certificates. N.B. Make sure the HTTPS
       * server certificates are signed with "subject alt name". For instance a
       * certificate can be self-signed using the following command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The allowedCaCerts at the given index.
       */
      public com.google.protobuf.ByteString getAllowedCaCerts(int index) {
        return allowedCaCerts_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER
       * format) for HTTPS verification. This overrides the default SSL trust
       * store. If this is empty or unspecified, Dialogflow will use Google's
       * default trust store to verify certificates. N.B. Make sure the HTTPS
       * server certificates are signed with "subject alt name". For instance a
       * certificate can be self-signed using the following command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The allowedCaCerts to set.
       * @return This builder for chaining.
       */
      public Builder setAllowedCaCerts(int index, com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedCaCertsIsMutable();
        allowedCaCerts_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER
       * format) for HTTPS verification. This overrides the default SSL trust
       * store. If this is empty or unspecified, Dialogflow will use Google's
       * default trust store to verify certificates. N.B. Make sure the HTTPS
       * server certificates are signed with "subject alt name". For instance a
       * certificate can be self-signed using the following command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The allowedCaCerts to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedCaCerts(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedCaCertsIsMutable();
        allowedCaCerts_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER
       * format) for HTTPS verification. This overrides the default SSL trust
       * store. If this is empty or unspecified, Dialogflow will use Google's
       * default trust store to verify certificates. N.B. Make sure the HTTPS
       * server certificates are signed with "subject alt name". For instance a
       * certificate can be self-signed using the following command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The allowedCaCerts to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowedCaCerts(
          java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
        ensureAllowedCaCertsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedCaCerts_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies a list of allowed custom CA certificates (in DER
       * format) for HTTPS verification. This overrides the default SSL trust
       * store. If this is empty or unspecified, Dialogflow will use Google's
       * default trust store to verify certificates. N.B. Make sure the HTTPS
       * server certificates are signed with "subject alt name". For instance a
       * certificate can be self-signed using the following command,
       * ```
       *    openssl x509 -req -days 200 -in example.com.csr &#92;
       *      -signkey example.com.key &#92;
       *      -out example.com.crt &#92;
       *      -extfile &lt;(printf "&#92;nsubjectAltName='DNS:www.example.com'")
       * ```
       * </pre>
       *
       * <code>repeated bytes allowed_ca_certs = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowedCaCerts() {
        allowedCaCerts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      private int webhookType_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. Type of the webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType webhook_type = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for webhookType.
       */
      @java.lang.Override
      public int getWebhookTypeValue() {
        return webhookType_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Type of the webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType webhook_type = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for webhookType to set.
       * @return This builder for chaining.
       */
      public Builder setWebhookTypeValue(int value) {
        webhookType_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Type of the webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType webhook_type = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The webhookType.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType
          getWebhookType() {
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType result =
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType.forNumber(
                webhookType_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Optional. Type of the webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType webhook_type = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The webhookType to set.
       * @return This builder for chaining.
       */
      public Builder setWebhookType(
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        webhookType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Type of the webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.WebhookType webhook_type = 6 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWebhookType() {
        bitField0_ = (bitField0_ & ~0x00000020);
        webhookType_ = 0;
        onChanged();
        return this;
      }

      private int httpMethod_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. HTTP method for the flexible webhook calls. Standard webhook
       * always uses POST.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod http_method = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for httpMethod.
       */
      @java.lang.Override
      public int getHttpMethodValue() {
        return httpMethod_;
      }
      /**
       *
       *
       * <pre>
       * Optional. HTTP method for the flexible webhook calls. Standard webhook
       * always uses POST.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod http_method = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for httpMethod to set.
       * @return This builder for chaining.
       */
      public Builder setHttpMethodValue(int value) {
        httpMethod_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. HTTP method for the flexible webhook calls. Standard webhook
       * always uses POST.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod http_method = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The httpMethod.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod
          getHttpMethod() {
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod result =
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod.forNumber(
                httpMethod_);
        return result == null
            ? com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Optional. HTTP method for the flexible webhook calls. Standard webhook
       * always uses POST.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod http_method = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The httpMethod to set.
       * @return This builder for chaining.
       */
      public Builder setHttpMethod(
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000040;
        httpMethod_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. HTTP method for the flexible webhook calls. Standard webhook
       * always uses POST.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.HttpMethod http_method = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHttpMethod() {
        bitField0_ = (bitField0_ & ~0x00000040);
        httpMethod_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object requestBody_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Defines a custom JSON object as request body to send to
       * flexible webhook.
       * </pre>
       *
       * <code>string request_body = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The requestBody.
       */
      public java.lang.String getRequestBody() {
        java.lang.Object ref = requestBody_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          requestBody_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Defines a custom JSON object as request body to send to
       * flexible webhook.
       * </pre>
       *
       * <code>string request_body = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for requestBody.
       */
      public com.google.protobuf.ByteString getRequestBodyBytes() {
        java.lang.Object ref = requestBody_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          requestBody_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Defines a custom JSON object as request body to send to
       * flexible webhook.
       * </pre>
       *
       * <code>string request_body = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The requestBody to set.
       * @return This builder for chaining.
       */
      public Builder setRequestBody(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestBody_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Defines a custom JSON object as request body to send to
       * flexible webhook.
       * </pre>
       *
       * <code>string request_body = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequestBody() {
        requestBody_ = getDefaultInstance().getRequestBody();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Defines a custom JSON object as request body to send to
       * flexible webhook.
       * </pre>
       *
       * <code>string request_body = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for requestBody to set.
       * @return This builder for chaining.
       */
      public Builder setRequestBodyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        requestBody_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> parameterMapping_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetParameterMapping() {
        if (parameterMapping_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              ParameterMappingDefaultEntryHolder.defaultEntry);
        }
        return parameterMapping_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableParameterMapping() {
        if (parameterMapping_ == null) {
          parameterMapping_ =
              com.google.protobuf.MapField.newMapField(
                  ParameterMappingDefaultEntryHolder.defaultEntry);
        }
        if (!parameterMapping_.isMutable()) {
          parameterMapping_ = parameterMapping_.copy();
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return parameterMapping_;
      }

      public int getParameterMappingCount() {
        return internalGetParameterMapping().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Maps the values extracted from specific fields of the flexible
       * webhook response into session parameters.
       * - Key: session parameter name
       * - Value: field path in the webhook response
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public boolean containsParameterMapping(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetParameterMapping().getMap().containsKey(key);
      }
      /** Use {@link #getParameterMappingMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getParameterMapping() {
        return getParameterMappingMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Maps the values extracted from specific fields of the flexible
       * webhook response into session parameters.
       * - Key: session parameter name
       * - Value: field path in the webhook response
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getParameterMappingMap() {
        return internalGetParameterMapping().getMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Maps the values extracted from specific fields of the flexible
       * webhook response into session parameters.
       * - Key: session parameter name
       * - Value: field path in the webhook response
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getParameterMappingOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetParameterMapping().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Optional. Maps the values extracted from specific fields of the flexible
       * webhook response into session parameters.
       * - Key: session parameter name
       * - Value: field path in the webhook response
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.lang.String getParameterMappingOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetParameterMapping().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearParameterMapping() {
        bitField0_ = (bitField0_ & ~0x00000100);
        internalGetMutableParameterMapping().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Maps the values extracted from specific fields of the flexible
       * webhook response into session parameters.
       * - Key: session parameter name
       * - Value: field path in the webhook response
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeParameterMapping(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableParameterMapping().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableParameterMapping() {
        bitField0_ |= 0x00000100;
        return internalGetMutableParameterMapping().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Optional. Maps the values extracted from specific fields of the flexible
       * webhook response into session parameters.
       * - Key: session parameter name
       * - Value: field path in the webhook response
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putParameterMapping(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableParameterMapping().getMutableMap().put(key, value);
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Maps the values extracted from specific fields of the flexible
       * webhook response into session parameters.
       * - Key: session parameter name
       * - Value: field path in the webhook response
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; parameter_mapping = 9 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putAllParameterMapping(
          java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableParameterMapping().getMutableMap().putAll(values);
        bitField0_ |= 0x00000100;
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GenericWebService> PARSER =
        new com.google.protobuf.AbstractParser<GenericWebService>() {
          @java.lang.Override
          public GenericWebService parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GenericWebService> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GenericWebService> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ServiceDirectoryConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The name of [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
     * `Location ID` of the service directory must be the same as the location
     * of the agent.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The service.
     */
    java.lang.String getService();
    /**
     *
     *
     * <pre>
     * Required. The name of [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
     * `Location ID` of the service directory must be the same as the location
     * of the agent.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for service.
     */
    com.google.protobuf.ByteString getServiceBytes();

    /**
     *
     *
     * <pre>
     * Generic Service configuration of this webhook.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
     * </code>
     *
     * @return Whether the genericWebService field is set.
     */
    boolean hasGenericWebService();
    /**
     *
     *
     * <pre>
     * Generic Service configuration of this webhook.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
     * </code>
     *
     * @return The genericWebService.
     */
    com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService getGenericWebService();
    /**
     *
     *
     * <pre>
     * Generic Service configuration of this webhook.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebServiceOrBuilder
        getGenericWebServiceOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Represents configuration for a [Service
   * Directory](https://cloud.google.com/service-directory) service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig}
   */
  public static final class ServiceDirectoryConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig)
      ServiceDirectoryConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ServiceDirectoryConfig.newBuilder() to construct.
    private ServiceDirectoryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ServiceDirectoryConfig() {
      service_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ServiceDirectoryConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_ServiceDirectoryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_ServiceDirectoryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig.class,
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig.Builder.class);
    }

    public static final int SERVICE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
     * `Location ID` of the service directory must be the same as the location
     * of the agent.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The service.
     */
    @java.lang.Override
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
     * `Location ID` of the service directory must be the same as the location
     * of the agent.
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for service.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GENERIC_WEB_SERVICE_FIELD_NUMBER = 2;
    private com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService genericWebService_;
    /**
     *
     *
     * <pre>
     * Generic Service configuration of this webhook.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
     * </code>
     *
     * @return Whether the genericWebService field is set.
     */
    @java.lang.Override
    public boolean hasGenericWebService() {
      return genericWebService_ != null;
    }
    /**
     *
     *
     * <pre>
     * Generic Service configuration of this webhook.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
     * </code>
     *
     * @return The genericWebService.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService getGenericWebService() {
      return genericWebService_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.getDefaultInstance()
          : genericWebService_;
    }
    /**
     *
     *
     * <pre>
     * Generic Service configuration of this webhook.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebServiceOrBuilder
        getGenericWebServiceOrBuilder() {
      return genericWebService_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.getDefaultInstance()
          : genericWebService_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
      }
      if (genericWebService_ != null) {
        output.writeMessage(2, getGenericWebService());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
      }
      if (genericWebService_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getGenericWebService());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig other =
          (com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig) obj;

      if (!getService().equals(other.getService())) return false;
      if (hasGenericWebService() != other.hasGenericWebService()) return false;
      if (hasGenericWebService()) {
        if (!getGenericWebService().equals(other.getGenericWebService())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getService().hashCode();
      if (hasGenericWebService()) {
        hash = (37 * hash) + GENERIC_WEB_SERVICE_FIELD_NUMBER;
        hash = (53 * hash) + getGenericWebService().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig)
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_ServiceDirectoryConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_ServiceDirectoryConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig.class,
                com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        service_ = "";
        genericWebService_ = null;
        if (genericWebServiceBuilder_ != null) {
          genericWebServiceBuilder_.dispose();
          genericWebServiceBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_ServiceDirectoryConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig build() {
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig result =
            new com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.service_ = service_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.genericWebService_ =
              genericWebServiceBuilder_ == null
                  ? genericWebService_
                  : genericWebServiceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
                .getDefaultInstance()) return this;
        if (!other.getService().isEmpty()) {
          service_ = other.service_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasGenericWebService()) {
          mergeGenericWebService(other.getGenericWebService());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  service_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getGenericWebServiceFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object service_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
       * `Location ID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The service.
       */
      public java.lang.String getService() {
        java.lang.Object ref = service_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          service_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
       * `Location ID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for service.
       */
      public com.google.protobuf.ByteString getServiceBytes() {
        java.lang.Object ref = service_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          service_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
       * `Location ID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The service to set.
       * @return This builder for chaining.
       */
      public Builder setService(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        service_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
       * `Location ID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearService() {
        service_ = getDefaultInstance().getService();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of [Service
       * Directory](https://cloud.google.com/service-directory) service.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/namespaces/&lt;Namespace ID&gt;/services/&lt;Service ID&gt;`.
       * `Location ID` of the service directory must be the same as the location
       * of the agent.
       * </pre>
       *
       * <code>
       * string service = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for service to set.
       * @return This builder for chaining.
       */
      public Builder setServiceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        service_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService genericWebService_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService,
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebServiceOrBuilder>
          genericWebServiceBuilder_;
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       *
       * @return Whether the genericWebService field is set.
       */
      public boolean hasGenericWebService() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       *
       * @return The genericWebService.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
          getGenericWebService() {
        if (genericWebServiceBuilder_ == null) {
          return genericWebService_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
                  .getDefaultInstance()
              : genericWebService_;
        } else {
          return genericWebServiceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      public Builder setGenericWebService(
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService value) {
        if (genericWebServiceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          genericWebService_ = value;
        } else {
          genericWebServiceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      public Builder setGenericWebService(
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.Builder
              builderForValue) {
        if (genericWebServiceBuilder_ == null) {
          genericWebService_ = builderForValue.build();
        } else {
          genericWebServiceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      public Builder mergeGenericWebService(
          com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService value) {
        if (genericWebServiceBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && genericWebService_ != null
              && genericWebService_
                  != com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
                      .getDefaultInstance()) {
            getGenericWebServiceBuilder().mergeFrom(value);
          } else {
            genericWebService_ = value;
          }
        } else {
          genericWebServiceBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      public Builder clearGenericWebService() {
        bitField0_ = (bitField0_ & ~0x00000002);
        genericWebService_ = null;
        if (genericWebServiceBuilder_ != null) {
          genericWebServiceBuilder_.dispose();
          genericWebServiceBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.Builder
          getGenericWebServiceBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getGenericWebServiceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebServiceOrBuilder
          getGenericWebServiceOrBuilder() {
        if (genericWebServiceBuilder_ != null) {
          return genericWebServiceBuilder_.getMessageOrBuilder();
        } else {
          return genericWebService_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
                  .getDefaultInstance()
              : genericWebService_;
        }
      }
      /**
       *
       *
       * <pre>
       * Generic Service configuration of this webhook.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService,
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebServiceOrBuilder>
          getGenericWebServiceFieldBuilder() {
        if (genericWebServiceBuilder_ == null) {
          genericWebServiceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService,
                  com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebServiceOrBuilder>(
                  getGenericWebService(), getParentForChildren(), isClean());
          genericWebService_ = null;
        }
        return genericWebServiceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig)
    private static final com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ServiceDirectoryConfig> PARSER =
        new com.google.protobuf.AbstractParser<ServiceDirectoryConfig>() {
          @java.lang.Override
          public ServiceDirectoryConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ServiceDirectoryConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ServiceDirectoryConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int webhookCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object webhook_;

  public enum WebhookCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GENERIC_WEB_SERVICE(4),
    SERVICE_DIRECTORY(7),
    WEBHOOK_NOT_SET(0);
    private final int value;

    private WebhookCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static WebhookCase valueOf(int value) {
      return forNumber(value);
    }

    public static WebhookCase forNumber(int value) {
      switch (value) {
        case 4:
          return GENERIC_WEB_SERVICE;
        case 7:
          return SERVICE_DIRECTORY;
        case 0:
          return WEBHOOK_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public WebhookCase getWebhookCase() {
    return WebhookCase.forNumber(webhookCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the webhook.
   * Required for the
   * [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.UpdateWebhook]
   * method.
   * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.CreateWebhook]
   * populates the name automatically. Format: `projects/&lt;Project
   * ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/webhooks/&lt;Webhook ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the webhook.
   * Required for the
   * [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.UpdateWebhook]
   * method.
   * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.CreateWebhook]
   * populates the name automatically. Format: `projects/&lt;Project
   * ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/webhooks/&lt;Webhook ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the webhook, unique within the agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The human-readable name of the webhook, unique within the agent.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GENERIC_WEB_SERVICE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Configuration for a generic web service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 4;
   * </code>
   *
   * @return Whether the genericWebService field is set.
   */
  @java.lang.Override
  public boolean hasGenericWebService() {
    return webhookCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a generic web service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 4;
   * </code>
   *
   * @return The genericWebService.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService getGenericWebService() {
    if (webhookCase_ == 4) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService) webhook_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for a generic web service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebServiceOrBuilder
      getGenericWebServiceOrBuilder() {
    if (webhookCase_ == 4) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService) webhook_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.getDefaultInstance();
  }

  public static final int SERVICE_DIRECTORY_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Configuration for a [Service
   * Directory](https://cloud.google.com/service-directory) service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig service_directory = 7;
   * </code>
   *
   * @return Whether the serviceDirectory field is set.
   */
  @java.lang.Override
  public boolean hasServiceDirectory() {
    return webhookCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a [Service
   * Directory](https://cloud.google.com/service-directory) service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig service_directory = 7;
   * </code>
   *
   * @return The serviceDirectory.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
      getServiceDirectory() {
    if (webhookCase_ == 7) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig) webhook_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for a [Service
   * Directory](https://cloud.google.com/service-directory) service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig service_directory = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfigOrBuilder
      getServiceDirectoryOrBuilder() {
    if (webhookCase_ == 7) {
      return (com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig) webhook_;
    }
    return com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
        .getDefaultInstance();
  }

  public static final int TIMEOUT_FIELD_NUMBER = 6;
  private com.google.protobuf.Duration timeout_;
  /**
   *
   *
   * <pre>
   * Webhook execution timeout. Execution is considered failed if Dialogflow
   * doesn't receive a response from webhook at the end of the timeout period.
   * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   *
   * @return Whether the timeout field is set.
   */
  @java.lang.Override
  public boolean hasTimeout() {
    return timeout_ != null;
  }
  /**
   *
   *
   * <pre>
   * Webhook execution timeout. Execution is considered failed if Dialogflow
   * doesn't receive a response from webhook at the end of the timeout period.
   * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   *
   * @return The timeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTimeout() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }
  /**
   *
   *
   * <pre>
   * Webhook execution timeout. Execution is considered failed if Dialogflow
   * doesn't receive a response from webhook at the end of the timeout period.
   * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration timeout = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
    return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
  }

  public static final int DISABLED_FIELD_NUMBER = 5;
  private boolean disabled_ = false;
  /**
   *
   *
   * <pre>
   * Indicates whether the webhook is disabled.
   * </pre>
   *
   * <code>bool disabled = 5;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (webhookCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService) webhook_);
    }
    if (disabled_ != false) {
      output.writeBool(5, disabled_);
    }
    if (timeout_ != null) {
      output.writeMessage(6, getTimeout());
    }
    if (webhookCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig) webhook_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (webhookCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService) webhook_);
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, disabled_);
    }
    if (timeout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getTimeout());
    }
    if (webhookCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig) webhook_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.Webhook)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.Webhook other =
        (com.google.cloud.dialogflow.cx.v3beta1.Webhook) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasTimeout() != other.hasTimeout()) return false;
    if (hasTimeout()) {
      if (!getTimeout().equals(other.getTimeout())) return false;
    }
    if (getDisabled() != other.getDisabled()) return false;
    if (!getWebhookCase().equals(other.getWebhookCase())) return false;
    switch (webhookCase_) {
      case 4:
        if (!getGenericWebService().equals(other.getGenericWebService())) return false;
        break;
      case 7:
        if (!getServiceDirectory().equals(other.getServiceDirectory())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasTimeout()) {
      hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getTimeout().hashCode();
    }
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    switch (webhookCase_) {
      case 4:
        hash = (37 * hash) + GENERIC_WEB_SERVICE_FIELD_NUMBER;
        hash = (53 * hash) + getGenericWebService().hashCode();
        break;
      case 7:
        hash = (37 * hash) + SERVICE_DIRECTORY_FIELD_NUMBER;
        hash = (53 * hash) + getServiceDirectory().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.cx.v3beta1.Webhook prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Webhooks host the developer's business logic. During a session, webhooks
   * allow the developer to use the data extracted by Dialogflow's natural
   * language processing to generate dynamic responses, validate collected data,
   * or trigger actions on the backend.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.Webhook}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.Webhook)
      com.google.cloud.dialogflow.cx.v3beta1.WebhookOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.class,
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.cx.v3beta1.Webhook.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      if (genericWebServiceBuilder_ != null) {
        genericWebServiceBuilder_.clear();
      }
      if (serviceDirectoryBuilder_ != null) {
        serviceDirectoryBuilder_.clear();
      }
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      disabled_ = false;
      webhookCase_ = 0;
      webhook_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_Webhook_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.Webhook.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook build() {
      com.google.cloud.dialogflow.cx.v3beta1.Webhook result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.Webhook result =
          new com.google.cloud.dialogflow.cx.v3beta1.Webhook(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.cx.v3beta1.Webhook result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.timeout_ = timeoutBuilder_ == null ? timeout_ : timeoutBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.disabled_ = disabled_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.cx.v3beta1.Webhook result) {
      result.webhookCase_ = webhookCase_;
      result.webhook_ = this.webhook_;
      if (webhookCase_ == 4 && genericWebServiceBuilder_ != null) {
        result.webhook_ = genericWebServiceBuilder_.build();
      }
      if (webhookCase_ == 7 && serviceDirectoryBuilder_ != null) {
        result.webhook_ = serviceDirectoryBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.Webhook) {
        return mergeFrom((com.google.cloud.dialogflow.cx.v3beta1.Webhook) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.cx.v3beta1.Webhook other) {
      if (other == com.google.cloud.dialogflow.cx.v3beta1.Webhook.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasTimeout()) {
        mergeTimeout(other.getTimeout());
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      switch (other.getWebhookCase()) {
        case GENERIC_WEB_SERVICE:
          {
            mergeGenericWebService(other.getGenericWebService());
            break;
          }
        case SERVICE_DIRECTORY:
          {
            mergeServiceDirectory(other.getServiceDirectory());
            break;
          }
        case WEBHOOK_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(
                    getGenericWebServiceFieldBuilder().getBuilder(), extensionRegistry);
                webhookCase_ = 4;
                break;
              } // case 34
            case 40:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getServiceDirectoryFieldBuilder().getBuilder(), extensionRegistry);
                webhookCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int webhookCase_ = 0;
    private java.lang.Object webhook_;

    public WebhookCase getWebhookCase() {
      return WebhookCase.forNumber(webhookCase_);
    }

    public Builder clearWebhook() {
      webhookCase_ = 0;
      webhook_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the webhook.
     * Required for the
     * [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.UpdateWebhook]
     * method.
     * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.CreateWebhook]
     * populates the name automatically. Format: `projects/&lt;Project
     * ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the webhook.
     * Required for the
     * [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.UpdateWebhook]
     * method.
     * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.CreateWebhook]
     * populates the name automatically. Format: `projects/&lt;Project
     * ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the webhook.
     * Required for the
     * [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.UpdateWebhook]
     * method.
     * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.CreateWebhook]
     * populates the name automatically. Format: `projects/&lt;Project
     * ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the webhook.
     * Required for the
     * [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.UpdateWebhook]
     * method.
     * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.CreateWebhook]
     * populates the name automatically. Format: `projects/&lt;Project
     * ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the webhook.
     * Required for the
     * [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.UpdateWebhook]
     * method.
     * [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3beta1.Webhooks.CreateWebhook]
     * populates the name automatically. Format: `projects/&lt;Project
     * ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent ID&gt;/webhooks/&lt;Webhook ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the webhook, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the webhook, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the webhook, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the webhook, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The human-readable name of the webhook, unique within the agent.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService,
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebServiceOrBuilder>
        genericWebServiceBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     *
     * @return Whether the genericWebService field is set.
     */
    @java.lang.Override
    public boolean hasGenericWebService() {
      return webhookCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     *
     * @return The genericWebService.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService getGenericWebService() {
      if (genericWebServiceBuilder_ == null) {
        if (webhookCase_ == 4) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService) webhook_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
            .getDefaultInstance();
      } else {
        if (webhookCase_ == 4) {
          return genericWebServiceBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    public Builder setGenericWebService(
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService value) {
      if (genericWebServiceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webhook_ = value;
        onChanged();
      } else {
        genericWebServiceBuilder_.setMessage(value);
      }
      webhookCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    public Builder setGenericWebService(
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.Builder builderForValue) {
      if (genericWebServiceBuilder_ == null) {
        webhook_ = builderForValue.build();
        onChanged();
      } else {
        genericWebServiceBuilder_.setMessage(builderForValue.build());
      }
      webhookCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    public Builder mergeGenericWebService(
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService value) {
      if (genericWebServiceBuilder_ == null) {
        if (webhookCase_ == 4
            && webhook_
                != com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
                    .getDefaultInstance()) {
          webhook_ =
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService) webhook_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          webhook_ = value;
        }
        onChanged();
      } else {
        if (webhookCase_ == 4) {
          genericWebServiceBuilder_.mergeFrom(value);
        } else {
          genericWebServiceBuilder_.setMessage(value);
        }
      }
      webhookCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    public Builder clearGenericWebService() {
      if (genericWebServiceBuilder_ == null) {
        if (webhookCase_ == 4) {
          webhookCase_ = 0;
          webhook_ = null;
          onChanged();
        }
      } else {
        if (webhookCase_ == 4) {
          webhookCase_ = 0;
          webhook_ = null;
        }
        genericWebServiceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.Builder
        getGenericWebServiceBuilder() {
      return getGenericWebServiceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebServiceOrBuilder
        getGenericWebServiceOrBuilder() {
      if ((webhookCase_ == 4) && (genericWebServiceBuilder_ != null)) {
        return genericWebServiceBuilder_.getMessageOrBuilder();
      } else {
        if (webhookCase_ == 4) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService) webhook_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService generic_web_service = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService,
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebServiceOrBuilder>
        getGenericWebServiceFieldBuilder() {
      if (genericWebServiceBuilder_ == null) {
        if (!(webhookCase_ == 4)) {
          webhook_ =
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.getDefaultInstance();
        }
        genericWebServiceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService,
                com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebServiceOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.Webhook.GenericWebService) webhook_,
                getParentForChildren(),
                isClean());
        webhook_ = null;
      }
      webhookCase_ = 4;
      onChanged();
      return genericWebServiceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig,
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfigOrBuilder>
        serviceDirectoryBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     *
     * @return Whether the serviceDirectory field is set.
     */
    @java.lang.Override
    public boolean hasServiceDirectory() {
      return webhookCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     *
     * @return The serviceDirectory.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
        getServiceDirectory() {
      if (serviceDirectoryBuilder_ == null) {
        if (webhookCase_ == 7) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig) webhook_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
            .getDefaultInstance();
      } else {
        if (webhookCase_ == 7) {
          return serviceDirectoryBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    public Builder setServiceDirectory(
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig value) {
      if (serviceDirectoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webhook_ = value;
        onChanged();
      } else {
        serviceDirectoryBuilder_.setMessage(value);
      }
      webhookCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    public Builder setServiceDirectory(
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig.Builder
            builderForValue) {
      if (serviceDirectoryBuilder_ == null) {
        webhook_ = builderForValue.build();
        onChanged();
      } else {
        serviceDirectoryBuilder_.setMessage(builderForValue.build());
      }
      webhookCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    public Builder mergeServiceDirectory(
        com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig value) {
      if (serviceDirectoryBuilder_ == null) {
        if (webhookCase_ == 7
            && webhook_
                != com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
                    .getDefaultInstance()) {
          webhook_ =
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig.newBuilder(
                      (com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig)
                          webhook_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          webhook_ = value;
        }
        onChanged();
      } else {
        if (webhookCase_ == 7) {
          serviceDirectoryBuilder_.mergeFrom(value);
        } else {
          serviceDirectoryBuilder_.setMessage(value);
        }
      }
      webhookCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    public Builder clearServiceDirectory() {
      if (serviceDirectoryBuilder_ == null) {
        if (webhookCase_ == 7) {
          webhookCase_ = 0;
          webhook_ = null;
          onChanged();
        }
      } else {
        if (webhookCase_ == 7) {
          webhookCase_ = 0;
          webhook_ = null;
        }
        serviceDirectoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig.Builder
        getServiceDirectoryBuilder() {
      return getServiceDirectoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfigOrBuilder
        getServiceDirectoryOrBuilder() {
      if ((webhookCase_ == 7) && (serviceDirectoryBuilder_ != null)) {
        return serviceDirectoryBuilder_.getMessageOrBuilder();
      } else {
        if (webhookCase_ == 7) {
          return (com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig) webhook_;
        }
        return com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a [Service
     * Directory](https://cloud.google.com/service-directory) service.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig service_directory = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig,
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfigOrBuilder>
        getServiceDirectoryFieldBuilder() {
      if (serviceDirectoryBuilder_ == null) {
        if (!(webhookCase_ == 7)) {
          webhook_ =
              com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig
                  .getDefaultInstance();
        }
        serviceDirectoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig,
                com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfigOrBuilder>(
                (com.google.cloud.dialogflow.cx.v3beta1.Webhook.ServiceDirectoryConfig) webhook_,
                getParentForChildren(),
                isClean());
        webhook_ = null;
      }
      webhookCase_ = 7;
      onChanged();
      return serviceDirectoryBuilder_;
    }

    private com.google.protobuf.Duration timeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        timeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     *
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     *
     * @return The timeout.
     */
    public com.google.protobuf.Duration getTimeout() {
      if (timeoutBuilder_ == null) {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      } else {
        return timeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timeout_ = value;
      } else {
        timeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder setTimeout(com.google.protobuf.Duration.Builder builderForValue) {
      if (timeoutBuilder_ == null) {
        timeout_ = builderForValue.build();
      } else {
        timeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder mergeTimeout(com.google.protobuf.Duration value) {
      if (timeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && timeout_ != null
            && timeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTimeoutBuilder().mergeFrom(value);
        } else {
          timeout_ = value;
        }
      } else {
        timeoutBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public Builder clearTimeout() {
      bitField0_ = (bitField0_ & ~0x00000010);
      timeout_ = null;
      if (timeoutBuilder_ != null) {
        timeoutBuilder_.dispose();
        timeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public com.google.protobuf.Duration.Builder getTimeoutBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTimeoutOrBuilder() {
      if (timeoutBuilder_ != null) {
        return timeoutBuilder_.getMessageOrBuilder();
      } else {
        return timeout_ == null ? com.google.protobuf.Duration.getDefaultInstance() : timeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Webhook execution timeout. Execution is considered failed if Dialogflow
     * doesn't receive a response from webhook at the end of the timeout period.
     * Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration timeout = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTimeoutFieldBuilder() {
      if (timeoutBuilder_ == null) {
        timeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTimeout(), getParentForChildren(), isClean());
        timeout_ = null;
      }
      return timeoutBuilder_;
    }

    private boolean disabled_;
    /**
     *
     *
     * <pre>
     * Indicates whether the webhook is disabled.
     * </pre>
     *
     * <code>bool disabled = 5;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the webhook is disabled.
     * </pre>
     *
     * <code>bool disabled = 5;</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the webhook is disabled.
     * </pre>
     *
     * <code>bool disabled = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000020);
      disabled_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.Webhook)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.Webhook)
  private static final com.google.cloud.dialogflow.cx.v3beta1.Webhook DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.Webhook();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.Webhook getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Webhook> PARSER =
      new com.google.protobuf.AbstractParser<Webhook>() {
        @java.lang.Override
        public Webhook parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Webhook> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Webhook> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.Webhook getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
