/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/cx/v3beta1/test_case.proto

package com.google.cloud.dialogflow.cx.v3beta1;

/**
 *
 *
 * <pre>
 * Transition route group coverage represents the percentage of all possible
 * transition routes present within any of a parent's test cases. The results
 * are grouped by the transition route group.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage}
 */
public final class TransitionRouteGroupCoverage extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage)
    TransitionRouteGroupCoverageOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TransitionRouteGroupCoverage.newBuilder() to construct.
  private TransitionRouteGroupCoverage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TransitionRouteGroupCoverage() {
    coverages_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TransitionRouteGroupCoverage();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
        .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.class,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Builder.class);
  }

  public interface CoverageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Transition route group metadata. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
     *
     * @return Whether the routeGroup field is set.
     */
    boolean hasRouteGroup();
    /**
     *
     *
     * <pre>
     * Transition route group metadata. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
     *
     * @return The routeGroup.
     */
    com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup getRouteGroup();
    /**
     *
     *
     * <pre>
     * Transition route group metadata. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupOrBuilder getRouteGroupOrBuilder();

    /**
     *
     *
     * <pre>
     * The list of transition routes and coverage in the transition route group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
     * </code>
     */
    java.util.List<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition>
        getTransitionsList();
    /**
     *
     *
     * <pre>
     * The list of transition routes and coverage in the transition route group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
        getTransitions(int index);
    /**
     *
     *
     * <pre>
     * The list of transition routes and coverage in the transition route group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
     * </code>
     */
    int getTransitionsCount();
    /**
     *
     *
     * <pre>
     * The list of transition routes and coverage in the transition route group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                    .TransitionOrBuilder>
        getTransitionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * The list of transition routes and coverage in the transition route group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
     * </code>
     */
    com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.TransitionOrBuilder
        getTransitionsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * The percent of transition routes in the transition route group that are
     * covered.
     * </pre>
     *
     * <code>float coverage_score = 3;</code>
     *
     * @return The coverageScore.
     */
    float getCoverageScore();
  }
  /**
   *
   *
   * <pre>
   * Coverage result message for one transition route group.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage}
   */
  public static final class Coverage extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage)
      CoverageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Coverage.newBuilder() to construct.
    private Coverage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Coverage() {
      transitions_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Coverage();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_Coverage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_Coverage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.class,
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Builder
                  .class);
    }

    public interface TransitionOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
       *
       * @return Whether the transitionRoute field is set.
       */
      boolean hasTransitionRoute();
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
       *
       * @return The transitionRoute.
       */
      com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute getTransitionRoute();
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
       */
      com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder getTransitionRouteOrBuilder();

      /**
       *
       *
       * <pre>
       * Whether the transition route is covered by at least one of the
       * agent's test cases.
       * </pre>
       *
       * <code>bool covered = 2;</code>
       *
       * @return The covered.
       */
      boolean getCovered();
    }
    /**
     *
     *
     * <pre>
     * A transition coverage in a transition route group.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition}
     */
    public static final class Transition extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition)
        TransitionOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Transition.newBuilder() to construct.
      private Transition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Transition() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Transition();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_Coverage_Transition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_Coverage_Transition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                    .Transition.class,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                    .Transition.Builder.class);
      }

      public static final int TRANSITION_ROUTE_FIELD_NUMBER = 1;
      private com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transitionRoute_;
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
       *
       * @return Whether the transitionRoute field is set.
       */
      @java.lang.Override
      public boolean hasTransitionRoute() {
        return transitionRoute_ != null;
      }
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
       *
       * @return The transitionRoute.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute getTransitionRoute() {
        return transitionRoute_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.getDefaultInstance()
            : transitionRoute_;
      }
      /**
       *
       *
       * <pre>
       * Intent route or condition route.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder
          getTransitionRouteOrBuilder() {
        return transitionRoute_ == null
            ? com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.getDefaultInstance()
            : transitionRoute_;
      }

      public static final int COVERED_FIELD_NUMBER = 2;
      private boolean covered_ = false;
      /**
       *
       *
       * <pre>
       * Whether the transition route is covered by at least one of the
       * agent's test cases.
       * </pre>
       *
       * <code>bool covered = 2;</code>
       *
       * @return The covered.
       */
      @java.lang.Override
      public boolean getCovered() {
        return covered_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (transitionRoute_ != null) {
          output.writeMessage(1, getTransitionRoute());
        }
        if (covered_ != false) {
          output.writeBool(2, covered_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (transitionRoute_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTransitionRoute());
        }
        if (covered_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, covered_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                .Transition)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
            other =
                (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                        .Transition)
                    obj;

        if (hasTransitionRoute() != other.hasTransitionRoute()) return false;
        if (hasTransitionRoute()) {
          if (!getTransitionRoute().equals(other.getTransitionRoute())) return false;
        }
        if (getCovered() != other.getCovered()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasTransitionRoute()) {
          hash = (37 * hash) + TRANSITION_ROUTE_FIELD_NUMBER;
          hash = (53 * hash) + getTransitionRoute().hashCode();
        }
        hash = (37 * hash) + COVERED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCovered());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A transition coverage in a transition route group.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition)
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .TransitionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_Coverage_Transition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_Coverage_Transition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                      .Transition.class,
                  com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                      .Transition.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          transitionRoute_ = null;
          if (transitionRouteBuilder_ != null) {
            transitionRouteBuilder_.dispose();
            transitionRouteBuilder_ = null;
          }
          covered_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
              .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_Coverage_Transition_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                .Transition
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                .Transition
            build() {
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                .Transition
            buildPartial() {
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
              result =
                  new com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                      .Transition(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.transitionRoute_ =
                transitionRouteBuilder_ == null
                    ? transitionRoute_
                    : transitionRouteBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.covered_ = covered_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .Transition) {
            return mergeFrom(
                (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                        .Transition)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
                other) {
          if (other
              == com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .Transition.getDefaultInstance()) return this;
          if (other.hasTransitionRoute()) {
            mergeTransitionRoute(other.getTransitionRoute());
          }
          if (other.getCovered() != false) {
            setCovered(other.getCovered());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getTransitionRouteFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    covered_ = input.readBool();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transitionRoute_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder>
            transitionRouteBuilder_;
        /**
         *
         *
         * <pre>
         * Intent route or condition route.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
         *
         * @return Whether the transitionRoute field is set.
         */
        public boolean hasTransitionRoute() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Intent route or condition route.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
         *
         * @return The transitionRoute.
         */
        public com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute getTransitionRoute() {
          if (transitionRouteBuilder_ == null) {
            return transitionRoute_ == null
                ? com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.getDefaultInstance()
                : transitionRoute_;
          } else {
            return transitionRouteBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Intent route or condition route.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
         */
        public Builder setTransitionRoute(
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute value) {
          if (transitionRouteBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            transitionRoute_ = value;
          } else {
            transitionRouteBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Intent route or condition route.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
         */
        public Builder setTransitionRoute(
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder builderForValue) {
          if (transitionRouteBuilder_ == null) {
            transitionRoute_ = builderForValue.build();
          } else {
            transitionRouteBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Intent route or condition route.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
         */
        public Builder mergeTransitionRoute(
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute value) {
          if (transitionRouteBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && transitionRoute_ != null
                && transitionRoute_
                    != com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute
                        .getDefaultInstance()) {
              getTransitionRouteBuilder().mergeFrom(value);
            } else {
              transitionRoute_ = value;
            }
          } else {
            transitionRouteBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Intent route or condition route.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
         */
        public Builder clearTransitionRoute() {
          bitField0_ = (bitField0_ & ~0x00000001);
          transitionRoute_ = null;
          if (transitionRouteBuilder_ != null) {
            transitionRouteBuilder_.dispose();
            transitionRouteBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Intent route or condition route.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
         */
        public com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder
            getTransitionRouteBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getTransitionRouteFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Intent route or condition route.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
         */
        public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder
            getTransitionRouteOrBuilder() {
          if (transitionRouteBuilder_ != null) {
            return transitionRouteBuilder_.getMessageOrBuilder();
          } else {
            return transitionRoute_ == null
                ? com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.getDefaultInstance()
                : transitionRoute_;
          }
        }
        /**
         *
         *
         * <pre>
         * Intent route or condition route.
         * </pre>
         *
         * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRoute transition_route = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder>
            getTransitionRouteFieldBuilder() {
          if (transitionRouteBuilder_ == null) {
            transitionRouteBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute,
                    com.google.cloud.dialogflow.cx.v3beta1.TransitionRoute.Builder,
                    com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteOrBuilder>(
                    getTransitionRoute(), getParentForChildren(), isClean());
            transitionRoute_ = null;
          }
          return transitionRouteBuilder_;
        }

        private boolean covered_;
        /**
         *
         *
         * <pre>
         * Whether the transition route is covered by at least one of the
         * agent's test cases.
         * </pre>
         *
         * <code>bool covered = 2;</code>
         *
         * @return The covered.
         */
        @java.lang.Override
        public boolean getCovered() {
          return covered_;
        }
        /**
         *
         *
         * <pre>
         * Whether the transition route is covered by at least one of the
         * agent's test cases.
         * </pre>
         *
         * <code>bool covered = 2;</code>
         *
         * @param value The covered to set.
         * @return This builder for chaining.
         */
        public Builder setCovered(boolean value) {

          covered_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Whether the transition route is covered by at least one of the
         * agent's test cases.
         * </pre>
         *
         * <code>bool covered = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCovered() {
          bitField0_ = (bitField0_ & ~0x00000002);
          covered_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition)
      private static final com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
              .Coverage.Transition
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                .Transition();
      }

      public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .Transition
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Transition> PARSER =
          new com.google.protobuf.AbstractParser<Transition>() {
            @java.lang.Override
            public Transition parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Transition> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Transition> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int ROUTE_GROUP_FIELD_NUMBER = 1;
    private com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup routeGroup_;
    /**
     *
     *
     * <pre>
     * Transition route group metadata. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
     *
     * @return Whether the routeGroup field is set.
     */
    @java.lang.Override
    public boolean hasRouteGroup() {
      return routeGroup_ != null;
    }
    /**
     *
     *
     * <pre>
     * Transition route group metadata. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
     *
     * @return The routeGroup.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup getRouteGroup() {
      return routeGroup_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup.getDefaultInstance()
          : routeGroup_;
    }
    /**
     *
     *
     * <pre>
     * Transition route group metadata. Only name and displayName will be set.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupOrBuilder
        getRouteGroupOrBuilder() {
      return routeGroup_ == null
          ? com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup.getDefaultInstance()
          : routeGroup_;
    }

    public static final int TRANSITIONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition>
        transitions_;
    /**
     *
     *
     * <pre>
     * The list of transition routes and coverage in the transition route group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition>
        getTransitionsList() {
      return transitions_;
    }
    /**
     *
     *
     * <pre>
     * The list of transition routes and coverage in the transition route group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                    .TransitionOrBuilder>
        getTransitionsOrBuilderList() {
      return transitions_;
    }
    /**
     *
     *
     * <pre>
     * The list of transition routes and coverage in the transition route group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
     * </code>
     */
    @java.lang.Override
    public int getTransitionsCount() {
      return transitions_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of transition routes and coverage in the transition route group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
        getTransitions(int index) {
      return transitions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of transition routes and coverage in the transition route group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
            .TransitionOrBuilder
        getTransitionsOrBuilder(int index) {
      return transitions_.get(index);
    }

    public static final int COVERAGE_SCORE_FIELD_NUMBER = 3;
    private float coverageScore_ = 0F;
    /**
     *
     *
     * <pre>
     * The percent of transition routes in the transition route group that are
     * covered.
     * </pre>
     *
     * <code>float coverage_score = 3;</code>
     *
     * @return The coverageScore.
     */
    @java.lang.Override
    public float getCoverageScore() {
      return coverageScore_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (routeGroup_ != null) {
        output.writeMessage(1, getRouteGroup());
      }
      for (int i = 0; i < transitions_.size(); i++) {
        output.writeMessage(2, transitions_.get(i));
      }
      if (java.lang.Float.floatToRawIntBits(coverageScore_) != 0) {
        output.writeFloat(3, coverageScore_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (routeGroup_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getRouteGroup());
      }
      for (int i = 0; i < transitions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, transitions_.get(i));
      }
      if (java.lang.Float.floatToRawIntBits(coverageScore_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, coverageScore_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage other =
          (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage) obj;

      if (hasRouteGroup() != other.hasRouteGroup()) return false;
      if (hasRouteGroup()) {
        if (!getRouteGroup().equals(other.getRouteGroup())) return false;
      }
      if (!getTransitionsList().equals(other.getTransitionsList())) return false;
      if (java.lang.Float.floatToIntBits(getCoverageScore())
          != java.lang.Float.floatToIntBits(other.getCoverageScore())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRouteGroup()) {
        hash = (37 * hash) + ROUTE_GROUP_FIELD_NUMBER;
        hash = (53 * hash) + getRouteGroup().hashCode();
      }
      if (getTransitionsCount() > 0) {
        hash = (37 * hash) + TRANSITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getTransitionsList().hashCode();
      }
      hash = (37 * hash) + COVERAGE_SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getCoverageScore());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Coverage result message for one transition route group.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage)
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.CoverageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_Coverage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_Coverage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.class,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        routeGroup_ = null;
        if (routeGroupBuilder_ != null) {
          routeGroupBuilder_.dispose();
          routeGroupBuilder_ = null;
        }
        if (transitionsBuilder_ == null) {
          transitions_ = java.util.Collections.emptyList();
        } else {
          transitions_ = null;
          transitionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        coverageScore_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
            .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_Coverage_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage build() {
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
          buildPartial() {
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage result =
            new com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage result) {
        if (transitionsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            transitions_ = java.util.Collections.unmodifiableList(transitions_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.transitions_ = transitions_;
        } else {
          result.transitions_ = transitionsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.routeGroup_ =
              routeGroupBuilder_ == null ? routeGroup_ : routeGroupBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.coverageScore_ = coverageScore_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage) {
          return mergeFrom(
              (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage other) {
        if (other
            == com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                .getDefaultInstance()) return this;
        if (other.hasRouteGroup()) {
          mergeRouteGroup(other.getRouteGroup());
        }
        if (transitionsBuilder_ == null) {
          if (!other.transitions_.isEmpty()) {
            if (transitions_.isEmpty()) {
              transitions_ = other.transitions_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureTransitionsIsMutable();
              transitions_.addAll(other.transitions_);
            }
            onChanged();
          }
        } else {
          if (!other.transitions_.isEmpty()) {
            if (transitionsBuilder_.isEmpty()) {
              transitionsBuilder_.dispose();
              transitionsBuilder_ = null;
              transitions_ = other.transitions_;
              bitField0_ = (bitField0_ & ~0x00000002);
              transitionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getTransitionsFieldBuilder()
                      : null;
            } else {
              transitionsBuilder_.addAllMessages(other.transitions_);
            }
          }
        }
        if (other.getCoverageScore() != 0F) {
          setCoverageScore(other.getCoverageScore());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getRouteGroupFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                          .Transition
                      m =
                          input.readMessage(
                              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
                                  .Coverage.Transition.parser(),
                              extensionRegistry);
                  if (transitionsBuilder_ == null) {
                    ensureTransitionsIsMutable();
                    transitions_.add(m);
                  } else {
                    transitionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 29:
                {
                  coverageScore_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 29
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup routeGroup_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup,
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupOrBuilder>
          routeGroupBuilder_;
      /**
       *
       *
       * <pre>
       * Transition route group metadata. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
       *
       * @return Whether the routeGroup field is set.
       */
      public boolean hasRouteGroup() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Transition route group metadata. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
       *
       * @return The routeGroup.
       */
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup getRouteGroup() {
        if (routeGroupBuilder_ == null) {
          return routeGroup_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup.getDefaultInstance()
              : routeGroup_;
        } else {
          return routeGroupBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Transition route group metadata. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
       */
      public Builder setRouteGroup(
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup value) {
        if (routeGroupBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          routeGroup_ = value;
        } else {
          routeGroupBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Transition route group metadata. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
       */
      public Builder setRouteGroup(
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup.Builder builderForValue) {
        if (routeGroupBuilder_ == null) {
          routeGroup_ = builderForValue.build();
        } else {
          routeGroupBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Transition route group metadata. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
       */
      public Builder mergeRouteGroup(
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup value) {
        if (routeGroupBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && routeGroup_ != null
              && routeGroup_
                  != com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup
                      .getDefaultInstance()) {
            getRouteGroupBuilder().mergeFrom(value);
          } else {
            routeGroup_ = value;
          }
        } else {
          routeGroupBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Transition route group metadata. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
       */
      public Builder clearRouteGroup() {
        bitField0_ = (bitField0_ & ~0x00000001);
        routeGroup_ = null;
        if (routeGroupBuilder_ != null) {
          routeGroupBuilder_.dispose();
          routeGroupBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Transition route group metadata. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup.Builder
          getRouteGroupBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getRouteGroupFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Transition route group metadata. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupOrBuilder
          getRouteGroupOrBuilder() {
        if (routeGroupBuilder_ != null) {
          return routeGroupBuilder_.getMessageOrBuilder();
        } else {
          return routeGroup_ == null
              ? com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup.getDefaultInstance()
              : routeGroup_;
        }
      }
      /**
       *
       *
       * <pre>
       * Transition route group metadata. Only name and displayName will be set.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup route_group = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup,
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupOrBuilder>
          getRouteGroupFieldBuilder() {
        if (routeGroupBuilder_ == null) {
          routeGroupBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup,
                  com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroup.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupOrBuilder>(
                  getRouteGroup(), getParentForChildren(), isClean());
          routeGroup_ = null;
        }
        return routeGroupBuilder_;
      }

      private java.util.List<
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .Transition>
          transitions_ = java.util.Collections.emptyList();

      private void ensureTransitionsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          transitions_ =
              new java.util.ArrayList<
                  com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                      .Transition>(transitions_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .Transition,
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .Transition.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .TransitionOrBuilder>
          transitionsBuilder_;

      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .Transition>
          getTransitionsList() {
        if (transitionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(transitions_);
        } else {
          return transitionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public int getTransitionsCount() {
        if (transitionsBuilder_ == null) {
          return transitions_.size();
        } else {
          return transitionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
          getTransitions(int index) {
        if (transitionsBuilder_ == null) {
          return transitions_.get(index);
        } else {
          return transitionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public Builder setTransitions(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
              value) {
        if (transitionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTransitionsIsMutable();
          transitions_.set(index, value);
          onChanged();
        } else {
          transitionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public Builder setTransitions(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
                  .Builder
              builderForValue) {
        if (transitionsBuilder_ == null) {
          ensureTransitionsIsMutable();
          transitions_.set(index, builderForValue.build());
          onChanged();
        } else {
          transitionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public Builder addTransitions(
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
              value) {
        if (transitionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTransitionsIsMutable();
          transitions_.add(value);
          onChanged();
        } else {
          transitionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public Builder addTransitions(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
              value) {
        if (transitionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTransitionsIsMutable();
          transitions_.add(index, value);
          onChanged();
        } else {
          transitionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public Builder addTransitions(
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
                  .Builder
              builderForValue) {
        if (transitionsBuilder_ == null) {
          ensureTransitionsIsMutable();
          transitions_.add(builderForValue.build());
          onChanged();
        } else {
          transitionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public Builder addTransitions(
          int index,
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
                  .Builder
              builderForValue) {
        if (transitionsBuilder_ == null) {
          ensureTransitionsIsMutable();
          transitions_.add(index, builderForValue.build());
          onChanged();
        } else {
          transitionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public Builder addAllTransitions(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                          .Transition>
              values) {
        if (transitionsBuilder_ == null) {
          ensureTransitionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transitions_);
          onChanged();
        } else {
          transitionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public Builder clearTransitions() {
        if (transitionsBuilder_ == null) {
          transitions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          transitionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public Builder removeTransitions(int index) {
        if (transitionsBuilder_ == null) {
          ensureTransitionsIsMutable();
          transitions_.remove(index);
          onChanged();
        } else {
          transitionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
              .Builder
          getTransitionsBuilder(int index) {
        return getTransitionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
              .TransitionOrBuilder
          getTransitionsOrBuilder(int index) {
        if (transitionsBuilder_ == null) {
          return transitions_.get(index);
        } else {
          return transitionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                      .TransitionOrBuilder>
          getTransitionsOrBuilderList() {
        if (transitionsBuilder_ != null) {
          return transitionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(transitions_);
        }
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
              .Builder
          addTransitionsBuilder() {
        return getTransitionsFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                    .Transition.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition
              .Builder
          addTransitionsBuilder(int index) {
        return getTransitionsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                    .Transition.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The list of transition routes and coverage in the transition route group.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Transition transitions = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .Transition.Builder>
          getTransitionsBuilderList() {
        return getTransitionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .Transition,
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .Transition.Builder,
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .TransitionOrBuilder>
          getTransitionsFieldBuilder() {
        if (transitionsBuilder_ == null) {
          transitionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                      .Transition,
                  com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                      .Transition.Builder,
                  com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                      .TransitionOrBuilder>(
                  transitions_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          transitions_ = null;
        }
        return transitionsBuilder_;
      }

      private float coverageScore_;
      /**
       *
       *
       * <pre>
       * The percent of transition routes in the transition route group that are
       * covered.
       * </pre>
       *
       * <code>float coverage_score = 3;</code>
       *
       * @return The coverageScore.
       */
      @java.lang.Override
      public float getCoverageScore() {
        return coverageScore_;
      }
      /**
       *
       *
       * <pre>
       * The percent of transition routes in the transition route group that are
       * covered.
       * </pre>
       *
       * <code>float coverage_score = 3;</code>
       *
       * @param value The coverageScore to set.
       * @return This builder for chaining.
       */
      public Builder setCoverageScore(float value) {

        coverageScore_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The percent of transition routes in the transition route group that are
       * covered.
       * </pre>
       *
       * <code>float coverage_score = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCoverageScore() {
        bitField0_ = (bitField0_ & ~0x00000004);
        coverageScore_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage)
    private static final com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
            .Coverage
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage();
    }

    public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Coverage> PARSER =
        new com.google.protobuf.AbstractParser<Coverage>() {
          @java.lang.Override
          public Coverage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Coverage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Coverage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int COVERAGES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage>
      coverages_;
  /**
   *
   *
   * <pre>
   * Transition route group coverages.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage>
      getCoveragesList() {
    return coverages_;
  }
  /**
   *
   *
   * <pre>
   * Transition route group coverages.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.CoverageOrBuilder>
      getCoveragesOrBuilderList() {
    return coverages_;
  }
  /**
   *
   *
   * <pre>
   * Transition route group coverages.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
   * </code>
   */
  @java.lang.Override
  public int getCoveragesCount() {
    return coverages_.size();
  }
  /**
   *
   *
   * <pre>
   * Transition route group coverages.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage getCoverages(
      int index) {
    return coverages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Transition route group coverages.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.CoverageOrBuilder
      getCoveragesOrBuilder(int index) {
    return coverages_.get(index);
  }

  public static final int COVERAGE_SCORE_FIELD_NUMBER = 2;
  private float coverageScore_ = 0F;
  /**
   *
   *
   * <pre>
   * The percent of transition routes in all the transition route groups that
   * are covered.
   * </pre>
   *
   * <code>float coverage_score = 2;</code>
   *
   * @return The coverageScore.
   */
  @java.lang.Override
  public float getCoverageScore() {
    return coverageScore_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < coverages_.size(); i++) {
      output.writeMessage(1, coverages_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(coverageScore_) != 0) {
      output.writeFloat(2, coverageScore_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < coverages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, coverages_.get(i));
    }
    if (java.lang.Float.floatToRawIntBits(coverageScore_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, coverageScore_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage other =
        (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage) obj;

    if (!getCoveragesList().equals(other.getCoveragesList())) return false;
    if (java.lang.Float.floatToIntBits(getCoverageScore())
        != java.lang.Float.floatToIntBits(other.getCoverageScore())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getCoveragesCount() > 0) {
      hash = (37 * hash) + COVERAGES_FIELD_NUMBER;
      hash = (53 * hash) + getCoveragesList().hashCode();
    }
    hash = (37 * hash) + COVERAGE_SCORE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getCoverageScore());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Transition route group coverage represents the percentage of all possible
   * transition routes present within any of a parent's test cases. The results
   * are grouped by the transition route group.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage)
      com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverageOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.class,
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Builder.class);
    }

    // Construct using
    // com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (coveragesBuilder_ == null) {
        coverages_ = java.util.Collections.emptyList();
      } else {
        coverages_ = null;
        coveragesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      coverageScore_ = 0F;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.TestCaseProto
          .internal_static_google_cloud_dialogflow_cx_v3beta1_TransitionRouteGroupCoverage_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage build() {
      com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage buildPartial() {
      com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage result =
          new com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage result) {
      if (coveragesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          coverages_ = java.util.Collections.unmodifiableList(coverages_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.coverages_ = coverages_;
      } else {
        result.coverages_ = coveragesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.coverageScore_ = coverageScore_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage) {
        return mergeFrom(
            (com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage other) {
      if (other
          == com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
              .getDefaultInstance()) return this;
      if (coveragesBuilder_ == null) {
        if (!other.coverages_.isEmpty()) {
          if (coverages_.isEmpty()) {
            coverages_ = other.coverages_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCoveragesIsMutable();
            coverages_.addAll(other.coverages_);
          }
          onChanged();
        }
      } else {
        if (!other.coverages_.isEmpty()) {
          if (coveragesBuilder_.isEmpty()) {
            coveragesBuilder_.dispose();
            coveragesBuilder_ = null;
            coverages_ = other.coverages_;
            bitField0_ = (bitField0_ & ~0x00000001);
            coveragesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCoveragesFieldBuilder()
                    : null;
          } else {
            coveragesBuilder_.addAllMessages(other.coverages_);
          }
        }
      }
      if (other.getCoverageScore() != 0F) {
        setCoverageScore(other.getCoverageScore());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage m =
                    input.readMessage(
                        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                            .parser(),
                        extensionRegistry);
                if (coveragesBuilder_ == null) {
                  ensureCoveragesIsMutable();
                  coverages_.add(m);
                } else {
                  coveragesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 21:
              {
                coverageScore_ = input.readFloat();
                bitField0_ |= 0x00000002;
                break;
              } // case 21
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage>
        coverages_ = java.util.Collections.emptyList();

    private void ensureCoveragesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        coverages_ =
            new java.util.ArrayList<
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage>(
                coverages_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.CoverageOrBuilder>
        coveragesBuilder_;

    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage>
        getCoveragesList() {
      if (coveragesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(coverages_);
      } else {
        return coveragesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public int getCoveragesCount() {
      if (coveragesBuilder_ == null) {
        return coverages_.size();
      } else {
        return coveragesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
        getCoverages(int index) {
      if (coveragesBuilder_ == null) {
        return coverages_.get(index);
      } else {
        return coveragesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public Builder setCoverages(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage value) {
      if (coveragesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCoveragesIsMutable();
        coverages_.set(index, value);
        onChanged();
      } else {
        coveragesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public Builder setCoverages(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Builder
            builderForValue) {
      if (coveragesBuilder_ == null) {
        ensureCoveragesIsMutable();
        coverages_.set(index, builderForValue.build());
        onChanged();
      } else {
        coveragesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public Builder addCoverages(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage value) {
      if (coveragesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCoveragesIsMutable();
        coverages_.add(value);
        onChanged();
      } else {
        coveragesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public Builder addCoverages(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage value) {
      if (coveragesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCoveragesIsMutable();
        coverages_.add(index, value);
        onChanged();
      } else {
        coveragesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public Builder addCoverages(
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Builder
            builderForValue) {
      if (coveragesBuilder_ == null) {
        ensureCoveragesIsMutable();
        coverages_.add(builderForValue.build());
        onChanged();
      } else {
        coveragesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public Builder addCoverages(
        int index,
        com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Builder
            builderForValue) {
      if (coveragesBuilder_ == null) {
        ensureCoveragesIsMutable();
        coverages_.add(index, builderForValue.build());
        onChanged();
      } else {
        coveragesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public Builder addAllCoverages(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage>
            values) {
      if (coveragesBuilder_ == null) {
        ensureCoveragesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, coverages_);
        onChanged();
      } else {
        coveragesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public Builder clearCoverages() {
      if (coveragesBuilder_ == null) {
        coverages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        coveragesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public Builder removeCoverages(int index) {
      if (coveragesBuilder_ == null) {
        ensureCoveragesIsMutable();
        coverages_.remove(index);
        onChanged();
      } else {
        coveragesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Builder
        getCoveragesBuilder(int index) {
      return getCoveragesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.CoverageOrBuilder
        getCoveragesOrBuilder(int index) {
      if (coveragesBuilder_ == null) {
        return coverages_.get(index);
      } else {
        return coveragesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
                    .CoverageOrBuilder>
        getCoveragesOrBuilderList() {
      if (coveragesBuilder_ != null) {
        return coveragesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(coverages_);
      }
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Builder
        addCoveragesBuilder() {
      return getCoveragesFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Builder
        addCoveragesBuilder(int index) {
      return getCoveragesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Transition route group coverages.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage coverages = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Builder>
        getCoveragesBuilderList() {
      return getCoveragesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage.Builder,
            com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.CoverageOrBuilder>
        getCoveragesFieldBuilder() {
      if (coveragesBuilder_ == null) {
        coveragesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage.Coverage
                    .Builder,
                com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
                    .CoverageOrBuilder>(
                coverages_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        coverages_ = null;
      }
      return coveragesBuilder_;
    }

    private float coverageScore_;
    /**
     *
     *
     * <pre>
     * The percent of transition routes in all the transition route groups that
     * are covered.
     * </pre>
     *
     * <code>float coverage_score = 2;</code>
     *
     * @return The coverageScore.
     */
    @java.lang.Override
    public float getCoverageScore() {
      return coverageScore_;
    }
    /**
     *
     *
     * <pre>
     * The percent of transition routes in all the transition route groups that
     * are covered.
     * </pre>
     *
     * <code>float coverage_score = 2;</code>
     *
     * @param value The coverageScore to set.
     * @return This builder for chaining.
     */
    public Builder setCoverageScore(float value) {

      coverageScore_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The percent of transition routes in all the transition route groups that
     * are covered.
     * </pre>
     *
     * <code>float coverage_score = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCoverageScore() {
      bitField0_ = (bitField0_ & ~0x00000002);
      coverageScore_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage)
  private static final com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage();
  }

  public static com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TransitionRouteGroupCoverage> PARSER =
      new com.google.protobuf.AbstractParser<TransitionRouteGroupCoverage>() {
        @java.lang.Override
        public TransitionRouteGroupCoverage parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TransitionRouteGroupCoverage> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TransitionRouteGroupCoverage> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.cx.v3beta1.TransitionRouteGroupCoverage
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
